import { custom_resources, aws_iam as iam, CustomResource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface OrganizationOUProviderProps {
    /**
     * The role the custom resource should use for taking actions on OUs if one is not provided one will be created automatically.
     *
     * @stability stable
     */
    readonly role?: iam.IRole;
}
/**
 * @stability stable
 */
export declare class OrganizationOUProvider extends Construct {
    /**
     * @stability stable
     */
    readonly provider: custom_resources.Provider;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: OrganizationOUProviderProps);
}
/**
 * @stability stable
 */
export interface OrganizationOUProps {
    /**
     * The name of the OU.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The parent OU id.
     *
     * @stability stable
     */
    readonly parentId: string;
    /**
     * The provider to use for the custom resource that will create the OU.
     *
     * You can create a provider with the OrganizationOuProvider class
     *
     * @stability stable
     */
    readonly provider: custom_resources.Provider;
    /**
     * Whether or not to import an existing OU if the new OU is a duplicate.
     *
     * If this is false and the OU already exists an error will be thrown.
     *
     * @default false
     * @stability stable
     */
    readonly importOnDuplicate?: boolean;
    /**
     * Whether or not to merge an OU with a duplicate when an OU is moved between parent OUs.
     *
     * If this is false and the OU already exists an error will be thrown.
     * If this is true and the OU already exists the accounts in the OU will be moved to the existing OU
     * and the duplicate, now empty, OU will be deleted.
     *
     * @default false
     * @stability stable
     */
    readonly allowMergeOnMove?: boolean;
    /**
     * Whether or not a missing OU should be recreated during an update.
     *
     * If this is false and the OU does not exist an error will be thrown when you try to update it.
     *
     * @stability stable
     */
    readonly allowRecreateOnUpdate?: boolean;
}
/**
 * @stability stable
 */
export declare class OrganizationOU extends Construct {
    /**
     * @stability stable
     */
    readonly resource: CustomResource;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: OrganizationOUProps);
}
