# Generated by Django 2.0.4 on 2018-05-05 15:12

from django.db import migrations, models


def make_entry_type_codes_unique(apps, schema_editor):
    EntryType = apps.get_model("jacc", "EntryType")
    for e in EntryType.objects.all().distinct("code"):
        dups = list(EntryType.objects.all().filter(code=e.code))
        if len(dups) > 1:
            for ix, e2 in enumerate(dups):
                if ix > 0:
                    e2.code += "({})".format(ix + 1)
                    e2.save(update_fields=["code"])


class Migration(migrations.Migration):

    dependencies = [
        ("jacc", "0014_auto_20180430_1506"),
    ]

    operations = [
        migrations.RunPython(
            make_entry_type_codes_unique,
        ),
        migrations.AlterField(
            model_name="entrytype",
            name="code",
            field=models.CharField(db_index=True, max_length=32, unique=True, verbose_name="code"),
        ),
        migrations.AlterUniqueTogether(
            name="entrytype",
            unique_together=set(),
        ),
    ]
