import { Construct } from 'constructs';
/**
 * @experimental
 */
export declare enum Waf2ScopeOption {
    /**
     * @experimental
     */
    CLOUDFRONT = "CLOUDFRONT",
    /**
     * @experimental
     */
    REGIONAL = "REGIONAL"
}
/**
 * @experimental
 */
export declare enum LogLevel {
    /**
     * @experimental
     */
    DEBUG = "DEBUG",
    /**
     * @experimental
     */
    INFO = "INFO",
    /**
     * @experimental
     */
    WARNING = "WARNING",
    /**
     * @experimental
     */
    ERROR = "ERROR",
    /**
     * @experimental
     */
    CRITICAL = "CRITICAL"
}
/**
 * @experimental
 */
export interface AutomatedWafProps {
    /**
     * (experimental) CLOUDFRONT or REGIONAL.
     *
     * If use REGIONAL, it support ALB、API Gateway
     *
     * @experimental
     */
    readonly waf2Scope: Waf2ScopeOption;
    /**
     * (experimental) Test your WAF rules, see more details: [AWS WAF rule action](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-action.html).
     *
     * Default is false
     *
     * @experimental
     */
    readonly countMode?: boolean;
    /**
     * (experimental) Only support ALB arn or API Gateway arn when waf2Scope is Regional.
     *
     * This property doesn't support CloudFront arn because it is restricted by CloudFormation `AWS::WAFv2::WebACLAssociation` , see more details: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webaclassociation.html#cfn-wafv2-webaclassociation-resourcearndetails:
     *
     * @experimental
     */
    readonly associatedResourceArn?: string;
    /**
     * (experimental) If the construct need to deploy more than one times, specify the property to prevent AWS resource name conflict.
     *
     * (The property only allow alphanumeric and "_" symbol because glue database naming is needed)
     *
     * @experimental
     */
    readonly resourceNamingPrefix?: string;
    /**
     * (experimental) The maximum acceptable bad requests per minute per IP.
     *
     * :warning: The property map WAF `Scanners and Probes` Rule which support only CloudFront and ALB.
     *
     * Default is 200
     *
     * @experimental
     */
    readonly errorThreshold?: number;
    /**
     * (experimental) The maximum acceptable requests per FIVE-minute period per IP address.
     *
     * Default is 1000
     *
     * @experimental
     */
    readonly requestThreshold?: number;
    /**
     * (experimental) The period (in minutes) to block applicable IP addresses.
     *
     * @experimental
     */
    readonly blockPeriod?: number;
    /**
     * (experimental) Enable or disable AWS Shield Advance (:warning: it need [$3000 Monthly Fee](https://aws.amazon.com/shield/pricing/?nc1=h_ls)).
     *
     * Default is false
     *
     * @experimental
     */
    readonly enableShieldAdvancedLambda?: boolean;
    /**
     * (experimental) Valid value is 'INFO', 'DEBUG', 'INFO', 'WARNING', 'ERROR', 'CRITICAL'.
     *
     * @experimental
     */
    readonly logLevel?: LogLevel;
    /**
     * @experimental
     */
    readonly wafLogBucketName?: string;
    /**
     * @experimental
     */
    readonly appAccessLogBucketName?: string;
}
/**
 * @experimental
 */
export declare class AutomatedWaf extends Construct {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AutomatedWafProps);
    /**
     * @experimental
     */
    validateResourceNamingPrefix(resourceNamingPrefix: string): boolean;
}
