from __future__ import print_function

def order(rk,tol=1.e-13): # pragma: no cover
    from numpy import dot,zeros,all,sum,abs
    coneq = zeros((40000))
    A=rk.A
    b=rk.b
    c=rk.c
    coneq[0]=sum(b)-1.
    if any(abs(coneq)>tol):
        return 0
    # order 2 conditions:
    coneq[0]=dot(b,c)-1/2.
    if any(abs(coneq)>tol):
        return 1
    # order 3 conditions:
    coneq[0]=dot(b,dot(A,c))-1/6.
    coneq[1]=dot(b,c*c)-1/3.
    if any(abs(coneq)>tol):
        return 2
    # order 4 conditions:
    coneq[0]=dot(b,dot(A,c**2))-1/12.
    coneq[1]=dot(b,dot(A,dot(A,c)))-1/24.
    coneq[2]=dot(b,dot(A,c)*c)-1/8.
    coneq[3]=dot(b,c**3)-1/4.
    if any(abs(coneq)>tol):
        return 3
    # order 5 conditions:
    coneq[0]=dot(b,dot(A,c**3))-1/20.
    coneq[1]=dot(b,dot(A,dot(A,c**2)))-1/60.
    coneq[2]=dot(b,dot(A,dot(A,dot(A,c))))-1/120.
    coneq[3]=dot(b,dot(A,c*dot(A,c)))-1/40.
    coneq[4]=dot(b,dot(A,c**2)*c)-1/15.
    coneq[5]=dot(b,dot(A,dot(A,c))*c)-1/30.
    coneq[6]=dot(b,dot(A,c)*c*c)-1/10.
    coneq[7]=dot(b,dot(A,c)*dot(A,c))-1/20.
    coneq[8]=dot(b,c**4)-1/5.
    if any(abs(coneq)>tol):
        return 4
    # order 6 conditions:
    coneq[0]=dot(b,dot(A,c**4))-1/30.
    coneq[1]=dot(b,dot(A,dot(A,c**3)))-1/120.
    coneq[2]=dot(b,dot(A,dot(A,dot(A,c**2))))-1/360.
    coneq[3]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))))-1/720.
    coneq[4]=dot(b,dot(A,dot(A,c*dot(A,c))))-1/240.
    coneq[5]=dot(b,dot(A,c*dot(A,c**2)))-1/90.
    coneq[6]=dot(b,dot(A,c*dot(A,dot(A,c))))-1/180.
    coneq[7]=dot(b,dot(A,c**2*dot(A,c)))-1/60.
    coneq[8]=dot(b,dot(A,dot(A,c)*dot(A,c)))-1/120.
    coneq[9]=dot(b,dot(A,c**3)*c)-1/24.
    coneq[10]=dot(b,dot(A,dot(A,c**2))*c)-1/72.
    coneq[11]=dot(b,dot(A,dot(A,dot(A,c)))*c)-1/144.
    coneq[12]=dot(b,dot(A,c*dot(A,c))*c)-1/48.
    coneq[13]=dot(b,dot(A,c**2)*c*c)-1/18.
    coneq[14]=dot(b,dot(A,dot(A,c))*c*c)-1/36.
    coneq[15]=dot(b,dot(A,c)*c**3)-1/12.
    coneq[16]=dot(b,dot(A,c**2)*dot(A,c))-1/36.
    coneq[17]=dot(b,dot(A,dot(A,c))*dot(A,c))-1/72.
    coneq[18]=dot(b,dot(A,c)*dot(A,c)*c)-1/24.
    coneq[19]=dot(b,c**5)-1/6.
    if any(abs(coneq)>tol):
        return 5
    # order 7 conditions:
    coneq[0]=dot(b,dot(A,c**5))-1/42.
    coneq[1]=dot(b,dot(A,dot(A,c**4)))-1/210.
    coneq[2]=dot(b,dot(A,dot(A,dot(A,c**3))))-1/840.
    coneq[3]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))))-1/2520.
    coneq[4]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))-1/5040.
    coneq[5]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))))-1/1680.
    coneq[6]=dot(b,dot(A,dot(A,c*dot(A,c**2))))-1/630.
    coneq[7]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))))-1/1260.
    coneq[8]=dot(b,dot(A,dot(A,c**2*dot(A,c))))-1/420.
    coneq[9]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))))-1/840.
    coneq[10]=dot(b,dot(A,c*dot(A,c**3)))-1/168.
    coneq[11]=dot(b,dot(A,c*dot(A,dot(A,c**2))))-1/504.
    coneq[12]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))))-1/1008.
    coneq[13]=dot(b,dot(A,c*dot(A,c*dot(A,c))))-1/336.
    coneq[14]=dot(b,dot(A,c**2*dot(A,c**2)))-1/126.
    coneq[15]=dot(b,dot(A,c**2*dot(A,dot(A,c))))-1/252.
    coneq[16]=dot(b,dot(A,c**3*dot(A,c)))-1/84.
    coneq[17]=dot(b,dot(A,dot(A,c)*dot(A,c**2)))-1/252.
    coneq[18]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))))-1/504.
    coneq[19]=dot(b,dot(A,c*dot(A,c)*dot(A,c)))-1/168.
    coneq[20]=dot(b,dot(A,c**4)*c)-1/35.
    coneq[21]=dot(b,dot(A,dot(A,c**3))*c)-1/140.
    coneq[22]=dot(b,dot(A,dot(A,dot(A,c**2)))*c)-1/420.
    coneq[23]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*c)-1/840.
    coneq[24]=dot(b,dot(A,dot(A,c*dot(A,c)))*c)-1/280.
    coneq[25]=dot(b,dot(A,c*dot(A,c**2))*c)-1/105.
    coneq[26]=dot(b,dot(A,c*dot(A,dot(A,c)))*c)-1/210.
    coneq[27]=dot(b,dot(A,c**2*dot(A,c))*c)-1/70.
    coneq[28]=dot(b,dot(A,dot(A,c)*dot(A,c))*c)-1/140.
    coneq[29]=dot(b,dot(A,c**3)*c*c)-1/28.
    coneq[30]=dot(b,dot(A,dot(A,c**2))*c*c)-1/84.
    coneq[31]=dot(b,dot(A,dot(A,dot(A,c)))*c*c)-1/168.
    coneq[32]=dot(b,dot(A,c*dot(A,c))*c*c)-1/56.
    coneq[33]=dot(b,dot(A,c**2)*c**3)-1/21.
    coneq[34]=dot(b,dot(A,dot(A,c))*c**3)-1/42.
    coneq[35]=dot(b,dot(A,c)*c**4)-1/14.
    coneq[36]=dot(b,dot(A,c**2)*dot(A,c**2))-1/63.
    coneq[37]=dot(b,dot(A,dot(A,c))*dot(A,c**2))-1/126.
    coneq[38]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c)))-1/252.
    coneq[39]=dot(b,dot(A,c**3)*dot(A,c))-1/56.
    coneq[40]=dot(b,dot(A,dot(A,c**2))*dot(A,c))-1/168.
    coneq[41]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c))-1/336.
    coneq[42]=dot(b,dot(A,c*dot(A,c))*dot(A,c))-1/112.
    coneq[43]=dot(b,dot(A,c**2)*dot(A,c)*c)-1/42.
    coneq[44]=dot(b,dot(A,dot(A,c))*dot(A,c)*c)-1/84.
    coneq[45]=dot(b,dot(A,c)*dot(A,c)*c*c)-1/28.
    coneq[46]=dot(b,dot(A,c)*dot(A,c)*dot(A,c))-1/56.
    coneq[47]=dot(b,c**6)-1/7.
    if any(abs(coneq)>tol):
        return 6
    # order 8 conditions:
    coneq[0]=dot(b,dot(A,c**6))-1/56.
    coneq[1]=dot(b,dot(A,dot(A,c**5)))-1/336.
    coneq[2]=dot(b,dot(A,dot(A,dot(A,c**4))))-1/1680.
    coneq[3]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)))))-1/6720.
    coneq[4]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))-1/20160.
    coneq[5]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/40320.
    coneq[6]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))-1/13440.
    coneq[7]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)))))-1/5040.
    coneq[8]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))-1/10080.
    coneq[9]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)))))-1/3360.
    coneq[10]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/6720.
    coneq[11]=dot(b,dot(A,dot(A,c*dot(A,c**3))))-1/1344.
    coneq[12]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)))))-1/4032.
    coneq[13]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))-1/8064.
    coneq[14]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)))))-1/2688.
    coneq[15]=dot(b,dot(A,dot(A,c**2*dot(A,c**2))))-1/1008.
    coneq[16]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)))))-1/2016.
    coneq[17]=dot(b,dot(A,dot(A,c**3*dot(A,c))))-1/672.
    coneq[18]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2))))-1/2016.
    coneq[19]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/4032.
    coneq[20]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c))))-1/1344.
    coneq[21]=dot(b,dot(A,c*dot(A,c**4)))-1/280.
    coneq[22]=dot(b,dot(A,c*dot(A,dot(A,c**3))))-1/1120.
    coneq[23]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)))))-1/3360.
    coneq[24]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))-1/6720.
    coneq[25]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)))))-1/2240.
    coneq[26]=dot(b,dot(A,c*dot(A,c*dot(A,c**2))))-1/840.
    coneq[27]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)))))-1/1680.
    coneq[28]=dot(b,dot(A,c*dot(A,c**2*dot(A,c))))-1/560.
    coneq[29]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c))))-1/1120.
    coneq[30]=dot(b,dot(A,c**2*dot(A,c**3)))-1/224.
    coneq[31]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))))-1/672.
    coneq[32]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))))-1/1344.
    coneq[33]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))))-1/448.
    coneq[34]=dot(b,dot(A,c**3*dot(A,c**2)))-1/168.
    coneq[35]=dot(b,dot(A,c**3*dot(A,dot(A,c))))-1/336.
    coneq[36]=dot(b,dot(A,c**4*dot(A,c)))-1/112.
    coneq[37]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2)))-1/504.
    coneq[38]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c))))-1/1008.
    coneq[39]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))-1/2016.
    coneq[40]=dot(b,dot(A,dot(A,c)*dot(A,c**3)))-1/448.
    coneq[41]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2))))-1/1344.
    coneq[42]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))-1/2688.
    coneq[43]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c))))-1/896.
    coneq[44]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2)))-1/336.
    coneq[45]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c))))-1/672.
    coneq[46]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)))-1/224.
    coneq[47]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))-1/448.
    coneq[48]=dot(b,dot(A,c**5)*c)-1/48.
    coneq[49]=dot(b,dot(A,dot(A,c**4))*c)-1/240.
    coneq[50]=dot(b,dot(A,dot(A,dot(A,c**3)))*c)-1/960.
    coneq[51]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*c)-1/2880.
    coneq[52]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/5760.
    coneq[53]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*c)-1/1920.
    coneq[54]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*c)-1/720.
    coneq[55]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*c)-1/1440.
    coneq[56]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*c)-1/480.
    coneq[57]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*c)-1/960.
    coneq[58]=dot(b,dot(A,c*dot(A,c**3))*c)-1/192.
    coneq[59]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*c)-1/576.
    coneq[60]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*c)-1/1152.
    coneq[61]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*c)-1/384.
    coneq[62]=dot(b,dot(A,c**2*dot(A,c**2))*c)-1/144.
    coneq[63]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*c)-1/288.
    coneq[64]=dot(b,dot(A,c**3*dot(A,c))*c)-1/96.
    coneq[65]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*c)-1/288.
    coneq[66]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*c)-1/576.
    coneq[67]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*c)-1/192.
    coneq[68]=dot(b,dot(A,c**4)*c*c)-1/40.
    coneq[69]=dot(b,dot(A,dot(A,c**3))*c*c)-1/160.
    coneq[70]=dot(b,dot(A,dot(A,dot(A,c**2)))*c*c)-1/480.
    coneq[71]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*c*c)-1/960.
    coneq[72]=dot(b,dot(A,dot(A,c*dot(A,c)))*c*c)-1/320.
    coneq[73]=dot(b,dot(A,c*dot(A,c**2))*c*c)-1/120.
    coneq[74]=dot(b,dot(A,c*dot(A,dot(A,c)))*c*c)-1/240.
    coneq[75]=dot(b,dot(A,c**2*dot(A,c))*c*c)-1/80.
    coneq[76]=dot(b,dot(A,dot(A,c)*dot(A,c))*c*c)-1/160.
    coneq[77]=dot(b,dot(A,c**3)*c**3)-1/32.
    coneq[78]=dot(b,dot(A,dot(A,c**2))*c**3)-1/96.
    coneq[79]=dot(b,dot(A,dot(A,dot(A,c)))*c**3)-1/192.
    coneq[80]=dot(b,dot(A,c*dot(A,c))*c**3)-1/64.
    coneq[81]=dot(b,dot(A,c**2)*c**4)-1/24.
    coneq[82]=dot(b,dot(A,dot(A,c))*c**4)-1/48.
    coneq[83]=dot(b,dot(A,c)*c**5)-1/16.
    coneq[84]=dot(b,dot(A,c**3)*dot(A,c**2))-1/96.
    coneq[85]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2))-1/288.
    coneq[86]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2))-1/576.
    coneq[87]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2))-1/192.
    coneq[88]=dot(b,dot(A,c**3)*dot(A,dot(A,c)))-1/192.
    coneq[89]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c)))-1/576.
    coneq[90]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/1152.
    coneq[91]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c)))-1/384.
    coneq[92]=dot(b,dot(A,c**4)*dot(A,c))-1/80.
    coneq[93]=dot(b,dot(A,dot(A,c**3))*dot(A,c))-1/320.
    coneq[94]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c))-1/960.
    coneq[95]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c))-1/1920.
    coneq[96]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c))-1/640.
    coneq[97]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c))-1/240.
    coneq[98]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c))-1/480.
    coneq[99]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c))-1/160.
    coneq[100]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c))-1/320.
    coneq[101]=dot(b,dot(A,c**2)*dot(A,c**2)*c)-1/72.
    coneq[102]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*c)-1/144.
    coneq[103]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*c)-1/288.
    coneq[104]=dot(b,dot(A,c**3)*dot(A,c)*c)-1/64.
    coneq[105]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*c)-1/192.
    coneq[106]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*c)-1/384.
    coneq[107]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*c)-1/128.
    coneq[108]=dot(b,dot(A,c**2)*dot(A,c)*c*c)-1/48.
    coneq[109]=dot(b,dot(A,dot(A,c))*dot(A,c)*c*c)-1/96.
    coneq[110]=dot(b,dot(A,c)*dot(A,c)*c**3)-1/32.
    coneq[111]=dot(b,dot(A,c**2)*dot(A,c)*dot(A,c))-1/96.
    coneq[112]=dot(b,dot(A,dot(A,c))*dot(A,c)*dot(A,c))-1/192.
    coneq[113]=dot(b,dot(A,c)*dot(A,c)*dot(A,c)*c)-1/64.
    coneq[114]=dot(b,c**7)-1/8.
    if any(abs(coneq)>tol):
        return 7
    # order 9 conditions:
    coneq[0]=dot(b,dot(A,c**7))-1/72.
    coneq[1]=dot(b,dot(A,dot(A,c**6)))-1/504.
    coneq[2]=dot(b,dot(A,dot(A,dot(A,c**5))))-1/3024.
    coneq[3]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4)))))-1/15120.
    coneq[4]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))-1/60480.
    coneq[5]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/181440.
    coneq[6]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/362880.
    coneq[7]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/120960.
    coneq[8]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/45360.
    coneq[9]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/90720.
    coneq[10]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/30240.
    coneq[11]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/60480.
    coneq[12]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3)))))-1/12096.
    coneq[13]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/36288.
    coneq[14]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/72576.
    coneq[15]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/24192.
    coneq[16]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))-1/9072.
    coneq[17]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/18144.
    coneq[18]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c)))))-1/6048.
    coneq[19]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/18144.
    coneq[20]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/36288.
    coneq[21]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/12096.
    coneq[22]=dot(b,dot(A,dot(A,c*dot(A,c**4))))-1/2520.
    coneq[23]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3)))))-1/10080.
    coneq[24]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/30240.
    coneq[25]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/60480.
    coneq[26]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/20160.
    coneq[27]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))-1/7560.
    coneq[28]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/15120.
    coneq[29]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))-1/5040.
    coneq[30]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/10080.
    coneq[31]=dot(b,dot(A,dot(A,c**2*dot(A,c**3))))-1/2016.
    coneq[32]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))-1/6048.
    coneq[33]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/12096.
    coneq[34]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))-1/4032.
    coneq[35]=dot(b,dot(A,dot(A,c**3*dot(A,c**2))))-1/1512.
    coneq[36]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c)))))-1/3024.
    coneq[37]=dot(b,dot(A,dot(A,c**4*dot(A,c))))-1/1008.
    coneq[38]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))-1/4536.
    coneq[39]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/9072.
    coneq[40]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/18144.
    coneq[41]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3))))-1/4032.
    coneq[42]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/12096.
    coneq[43]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/24192.
    coneq[44]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/8064.
    coneq[45]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))-1/3024.
    coneq[46]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/6048.
    coneq[47]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))-1/2016.
    coneq[48]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/4032.
    coneq[49]=dot(b,dot(A,c*dot(A,c**5)))-1/432.
    coneq[50]=dot(b,dot(A,c*dot(A,dot(A,c**4))))-1/2160.
    coneq[51]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3)))))-1/8640.
    coneq[52]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/25920.
    coneq[53]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/51840.
    coneq[54]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/17280.
    coneq[55]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))-1/6480.
    coneq[56]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/12960.
    coneq[57]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))-1/4320.
    coneq[58]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/8640.
    coneq[59]=dot(b,dot(A,c*dot(A,c*dot(A,c**3))))-1/1728.
    coneq[60]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))-1/5184.
    coneq[61]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/10368.
    coneq[62]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))-1/3456.
    coneq[63]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2))))-1/1296.
    coneq[64]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))-1/2592.
    coneq[65]=dot(b,dot(A,c*dot(A,c**3*dot(A,c))))-1/864.
    coneq[66]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))-1/2592.
    coneq[67]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/5184.
    coneq[68]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))-1/1728.
    coneq[69]=dot(b,dot(A,c**2*dot(A,c**4)))-1/360.
    coneq[70]=dot(b,dot(A,c**2*dot(A,dot(A,c**3))))-1/1440.
    coneq[71]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))-1/4320.
    coneq[72]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))-1/8640.
    coneq[73]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))-1/2880.
    coneq[74]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2))))-1/1080.
    coneq[75]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))-1/2160.
    coneq[76]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c))))-1/720.
    coneq[77]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))-1/1440.
    coneq[78]=dot(b,dot(A,c**3*dot(A,c**3)))-1/288.
    coneq[79]=dot(b,dot(A,c**3*dot(A,dot(A,c**2))))-1/864.
    coneq[80]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)))))-1/1728.
    coneq[81]=dot(b,dot(A,c**3*dot(A,c*dot(A,c))))-1/576.
    coneq[82]=dot(b,dot(A,c**4*dot(A,c**2)))-1/216.
    coneq[83]=dot(b,dot(A,c**4*dot(A,dot(A,c))))-1/432.
    coneq[84]=dot(b,dot(A,c**5*dot(A,c)))-1/144.
    coneq[85]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3)))-1/864.
    coneq[86]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))-1/2592.
    coneq[87]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))-1/5184.
    coneq[88]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))-1/1728.
    coneq[89]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3)))-1/1728.
    coneq[90]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))-1/5184.
    coneq[91]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))-1/10368.
    coneq[92]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))-1/3456.
    coneq[93]=dot(b,dot(A,dot(A,c)*dot(A,c**4)))-1/720.
    coneq[94]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3))))-1/2880.
    coneq[95]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))-1/8640.
    coneq[96]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))-1/17280.
    coneq[97]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))-1/5760.
    coneq[98]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))-1/2160.
    coneq[99]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))-1/4320.
    coneq[100]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))-1/1440.
    coneq[101]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))-1/2880.
    coneq[102]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2)))-1/648.
    coneq[103]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))-1/1296.
    coneq[104]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/2592.
    coneq[105]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3)))-1/576.
    coneq[106]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))-1/1728.
    coneq[107]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))-1/3456.
    coneq[108]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))-1/1152.
    coneq[109]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2)))-1/432.
    coneq[110]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))-1/864.
    coneq[111]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c)))-1/288.
    coneq[112]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))-1/864.
    coneq[113]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))-1/1728.
    coneq[114]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))-1/576.
    coneq[115]=dot(b,dot(A,c**6)*c)-1/63.
    coneq[116]=dot(b,dot(A,dot(A,c**5))*c)-1/378.
    coneq[117]=dot(b,dot(A,dot(A,dot(A,c**4)))*c)-1/1890.
    coneq[118]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*c)-1/7560.
    coneq[119]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*c)-1/22680.
    coneq[120]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/45360.
    coneq[121]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*c)-1/15120.
    coneq[122]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*c)-1/5670.
    coneq[123]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*c)-1/11340.
    coneq[124]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*c)-1/3780.
    coneq[125]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*c)-1/7560.
    coneq[126]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*c)-1/1512.
    coneq[127]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*c)-1/4536.
    coneq[128]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*c)-1/9072.
    coneq[129]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*c)-1/3024.
    coneq[130]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*c)-1/1134.
    coneq[131]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*c)-1/2268.
    coneq[132]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*c)-1/756.
    coneq[133]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*c)-1/2268.
    coneq[134]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*c)-1/4536.
    coneq[135]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*c)-1/1512.
    coneq[136]=dot(b,dot(A,c*dot(A,c**4))*c)-1/315.
    coneq[137]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*c)-1/1260.
    coneq[138]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*c)-1/3780.
    coneq[139]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/7560.
    coneq[140]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*c)-1/2520.
    coneq[141]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*c)-1/945.
    coneq[142]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*c)-1/1890.
    coneq[143]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*c)-1/630.
    coneq[144]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*c)-1/1260.
    coneq[145]=dot(b,dot(A,c**2*dot(A,c**3))*c)-1/252.
    coneq[146]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*c)-1/756.
    coneq[147]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*c)-1/1512.
    coneq[148]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*c)-1/504.
    coneq[149]=dot(b,dot(A,c**3*dot(A,c**2))*c)-1/189.
    coneq[150]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*c)-1/378.
    coneq[151]=dot(b,dot(A,c**4*dot(A,c))*c)-1/126.
    coneq[152]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*c)-1/567.
    coneq[153]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*c)-1/1134.
    coneq[154]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*c)-1/2268.
    coneq[155]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*c)-1/504.
    coneq[156]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*c)-1/1512.
    coneq[157]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*c)-1/3024.
    coneq[158]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*c)-1/1008.
    coneq[159]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*c)-1/378.
    coneq[160]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*c)-1/756.
    coneq[161]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*c)-1/252.
    coneq[162]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*c)-1/504.
    coneq[163]=dot(b,dot(A,c**5)*c*c)-1/54.
    coneq[164]=dot(b,dot(A,dot(A,c**4))*c*c)-1/270.
    coneq[165]=dot(b,dot(A,dot(A,dot(A,c**3)))*c*c)-1/1080.
    coneq[166]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*c*c)-1/3240.
    coneq[167]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*c*c)-1/6480.
    coneq[168]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*c*c)-1/2160.
    coneq[169]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*c*c)-1/810.
    coneq[170]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*c*c)-1/1620.
    coneq[171]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*c*c)-1/540.
    coneq[172]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*c*c)-1/1080.
    coneq[173]=dot(b,dot(A,c*dot(A,c**3))*c*c)-1/216.
    coneq[174]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*c*c)-1/648.
    coneq[175]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*c*c)-1/1296.
    coneq[176]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*c*c)-1/432.
    coneq[177]=dot(b,dot(A,c**2*dot(A,c**2))*c*c)-1/162.
    coneq[178]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*c*c)-1/324.
    coneq[179]=dot(b,dot(A,c**3*dot(A,c))*c*c)-1/108.
    coneq[180]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*c*c)-1/324.
    coneq[181]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*c*c)-1/648.
    coneq[182]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*c*c)-1/216.
    coneq[183]=dot(b,dot(A,c**4)*c**3)-1/45.
    coneq[184]=dot(b,dot(A,dot(A,c**3))*c**3)-1/180.
    coneq[185]=dot(b,dot(A,dot(A,dot(A,c**2)))*c**3)-1/540.
    coneq[186]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*c**3)-1/1080.
    coneq[187]=dot(b,dot(A,dot(A,c*dot(A,c)))*c**3)-1/360.
    coneq[188]=dot(b,dot(A,c*dot(A,c**2))*c**3)-1/135.
    coneq[189]=dot(b,dot(A,c*dot(A,dot(A,c)))*c**3)-1/270.
    coneq[190]=dot(b,dot(A,c**2*dot(A,c))*c**3)-1/90.
    coneq[191]=dot(b,dot(A,dot(A,c)*dot(A,c))*c**3)-1/180.
    coneq[192]=dot(b,dot(A,c**3)*c**4)-1/36.
    coneq[193]=dot(b,dot(A,dot(A,c**2))*c**4)-1/108.
    coneq[194]=dot(b,dot(A,dot(A,dot(A,c)))*c**4)-1/216.
    coneq[195]=dot(b,dot(A,c*dot(A,c))*c**4)-1/72.
    coneq[196]=dot(b,dot(A,c**2)*c**5)-1/27.
    coneq[197]=dot(b,dot(A,dot(A,c))*c**5)-1/54.
    coneq[198]=dot(b,dot(A,c)*c**6)-1/18.
    coneq[199]=dot(b,dot(A,c**3)*dot(A,c**3))-1/144.
    coneq[200]=dot(b,dot(A,dot(A,c**2))*dot(A,c**3))-1/432.
    coneq[201]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**3))-1/864.
    coneq[202]=dot(b,dot(A,c*dot(A,c))*dot(A,c**3))-1/288.
    coneq[203]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))-1/1296.
    coneq[204]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2)))-1/2592.
    coneq[205]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c**2)))-1/864.
    coneq[206]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/5184.
    coneq[207]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c))))-1/1728.
    coneq[208]=dot(b,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))-1/576.
    coneq[209]=dot(b,dot(A,c**4)*dot(A,c**2))-1/135.
    coneq[210]=dot(b,dot(A,dot(A,c**3))*dot(A,c**2))-1/540.
    coneq[211]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2))-1/1620.
    coneq[212]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2))-1/3240.
    coneq[213]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2))-1/1080.
    coneq[214]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**2))-1/405.
    coneq[215]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2))-1/810.
    coneq[216]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**2))-1/270.
    coneq[217]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2))-1/540.
    coneq[218]=dot(b,dot(A,c**4)*dot(A,dot(A,c)))-1/270.
    coneq[219]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c)))-1/1080.
    coneq[220]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c)))-1/3240.
    coneq[221]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/6480.
    coneq[222]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c)))-1/2160.
    coneq[223]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c)))-1/810.
    coneq[224]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/1620.
    coneq[225]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c)))-1/540.
    coneq[226]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c)))-1/1080.
    coneq[227]=dot(b,dot(A,c**5)*dot(A,c))-1/108.
    coneq[228]=dot(b,dot(A,dot(A,c**4))*dot(A,c))-1/540.
    coneq[229]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c))-1/2160.
    coneq[230]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c))-1/6480.
    coneq[231]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/12960.
    coneq[232]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c))-1/4320.
    coneq[233]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c))-1/1620.
    coneq[234]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c))-1/3240.
    coneq[235]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c))-1/1080.
    coneq[236]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c))-1/2160.
    coneq[237]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c))-1/432.
    coneq[238]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c))-1/1296.
    coneq[239]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/2592.
    coneq[240]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c))-1/864.
    coneq[241]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c))-1/324.
    coneq[242]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c))-1/648.
    coneq[243]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c))-1/216.
    coneq[244]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c))-1/648.
    coneq[245]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c))-1/1296.
    coneq[246]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c))-1/432.
    coneq[247]=dot(b,dot(A,c**3)*dot(A,c**2)*c)-1/108.
    coneq[248]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2)*c)-1/324.
    coneq[249]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2)*c)-1/648.
    coneq[250]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2)*c)-1/216.
    coneq[251]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*c)-1/216.
    coneq[252]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*c)-1/648.
    coneq[253]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*c)-1/1296.
    coneq[254]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*c)-1/432.
    coneq[255]=dot(b,dot(A,c**4)*dot(A,c)*c)-1/90.
    coneq[256]=dot(b,dot(A,dot(A,c**3))*dot(A,c)*c)-1/360.
    coneq[257]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c)*c)-1/1080.
    coneq[258]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c)*c)-1/2160.
    coneq[259]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c)*c)-1/720.
    coneq[260]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c)*c)-1/270.
    coneq[261]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c)*c)-1/540.
    coneq[262]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c)*c)-1/180.
    coneq[263]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c)*c)-1/360.
    coneq[264]=dot(b,dot(A,c**2)*dot(A,c**2)*c*c)-1/81.
    coneq[265]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*c*c)-1/162.
    coneq[266]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*c*c)-1/324.
    coneq[267]=dot(b,dot(A,c**3)*dot(A,c)*c*c)-1/72.
    coneq[268]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*c*c)-1/216.
    coneq[269]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*c*c)-1/432.
    coneq[270]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*c*c)-1/144.
    coneq[271]=dot(b,dot(A,c**2)*dot(A,c)*c**3)-1/54.
    coneq[272]=dot(b,dot(A,dot(A,c))*dot(A,c)*c**3)-1/108.
    coneq[273]=dot(b,dot(A,c)*dot(A,c)*c**4)-1/36.
    coneq[274]=dot(b,dot(A,c**3)*dot(A,c)*dot(A,c))-1/144.
    coneq[275]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*dot(A,c))-1/432.
    coneq[276]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*dot(A,c))-1/864.
    coneq[277]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*dot(A,c))-1/288.
    coneq[278]=dot(b,dot(A,c**2)*dot(A,c**2)*dot(A,c))-1/162.
    coneq[279]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*dot(A,c))-1/324.
    coneq[280]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c))-1/648.
    coneq[281]=dot(b,dot(A,c**2)*dot(A,c)*dot(A,c)*c)-1/108.
    coneq[282]=dot(b,dot(A,dot(A,c))*dot(A,c)*dot(A,c)*c)-1/216.
    coneq[283]=dot(b,dot(A,c)*dot(A,c)*dot(A,c)*c*c)-1/72.
    coneq[284]=dot(b,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))-1/144.
    coneq[285]=dot(b,c**8)-1/9.
    if any(abs(coneq)>tol):
        return 8
    # order 10 conditions:
    coneq[0]=dot(b,dot(A,c**8))-1/90.
    coneq[1]=dot(b,dot(A,dot(A,c**7)))-1/720.
    coneq[2]=dot(b,dot(A,dot(A,dot(A,c**6))))-1/5040.
    coneq[3]=dot(b,dot(A,dot(A,dot(A,dot(A,c**5)))))-1/30240.
    coneq[4]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**4))))))-1/151200.
    coneq[5]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/604800.
    coneq[6]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/1814400.
    coneq[7]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/3628800.
    coneq[8]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/1209600.
    coneq[9]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/453600.
    coneq[10]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/907200.
    coneq[11]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/302400.
    coneq[12]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/604800.
    coneq[13]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3))))))-1/120960.
    coneq[14]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/362880.
    coneq[15]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/725760.
    coneq[16]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/241920.
    coneq[17]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))-1/90720.
    coneq[18]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/181440.
    coneq[19]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c))))))-1/60480.
    coneq[20]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/181440.
    coneq[21]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/362880.
    coneq[22]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/120960.
    coneq[23]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**4)))))-1/25200.
    coneq[24]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3))))))-1/100800.
    coneq[25]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/302400.
    coneq[26]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/604800.
    coneq[27]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/201600.
    coneq[28]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))-1/75600.
    coneq[29]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/151200.
    coneq[30]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))-1/50400.
    coneq[31]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/100800.
    coneq[32]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**3)))))-1/20160.
    coneq[33]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))-1/60480.
    coneq[34]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/120960.
    coneq[35]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))-1/40320.
    coneq[36]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**2)))))-1/15120.
    coneq[37]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c))))))-1/30240.
    coneq[38]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c)))))-1/10080.
    coneq[39]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))-1/45360.
    coneq[40]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/90720.
    coneq[41]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/181440.
    coneq[42]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3)))))-1/40320.
    coneq[43]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/120960.
    coneq[44]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/241920.
    coneq[45]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/80640.
    coneq[46]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))-1/30240.
    coneq[47]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/60480.
    coneq[48]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))-1/20160.
    coneq[49]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/40320.
    coneq[50]=dot(b,dot(A,dot(A,c*dot(A,c**5))))-1/4320.
    coneq[51]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**4)))))-1/21600.
    coneq[52]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3))))))-1/86400.
    coneq[53]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/259200.
    coneq[54]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/518400.
    coneq[55]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/172800.
    coneq[56]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))-1/64800.
    coneq[57]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/129600.
    coneq[58]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))-1/43200.
    coneq[59]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/86400.
    coneq[60]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**3)))))-1/17280.
    coneq[61]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))-1/51840.
    coneq[62]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/103680.
    coneq[63]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))-1/34560.
    coneq[64]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2)))))-1/12960.
    coneq[65]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))-1/25920.
    coneq[66]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c)))))-1/8640.
    coneq[67]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))-1/25920.
    coneq[68]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/51840.
    coneq[69]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))-1/17280.
    coneq[70]=dot(b,dot(A,dot(A,c**2*dot(A,c**4))))-1/3600.
    coneq[71]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**3)))))-1/14400.
    coneq[72]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))-1/43200.
    coneq[73]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))-1/86400.
    coneq[74]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))-1/28800.
    coneq[75]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2)))))-1/10800.
    coneq[76]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))-1/21600.
    coneq[77]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c)))))-1/7200.
    coneq[78]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))-1/14400.
    coneq[79]=dot(b,dot(A,dot(A,c**3*dot(A,c**3))))-1/2880.
    coneq[80]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**2)))))-1/8640.
    coneq[81]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c))))))-1/17280.
    coneq[82]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c)))))-1/5760.
    coneq[83]=dot(b,dot(A,dot(A,c**4*dot(A,c**2))))-1/2160.
    coneq[84]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c)))))-1/4320.
    coneq[85]=dot(b,dot(A,dot(A,c**5*dot(A,c))))-1/1440.
    coneq[86]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**3))))-1/8640.
    coneq[87]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))-1/25920.
    coneq[88]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/51840.
    coneq[89]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))-1/17280.
    coneq[90]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3))))-1/17280.
    coneq[91]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/51840.
    coneq[92]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/103680.
    coneq[93]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/34560.
    coneq[94]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**4))))-1/7200.
    coneq[95]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3)))))-1/28800.
    coneq[96]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/86400.
    coneq[97]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/172800.
    coneq[98]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/57600.
    coneq[99]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))-1/21600.
    coneq[100]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/43200.
    coneq[101]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))-1/14400.
    coneq[102]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/28800.
    coneq[103]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2))))-1/6480.
    coneq[104]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))-1/12960.
    coneq[105]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/25920.
    coneq[106]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**3))))-1/5760.
    coneq[107]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))-1/17280.
    coneq[108]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/34560.
    coneq[109]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))-1/11520.
    coneq[110]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2))))-1/4320.
    coneq[111]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))-1/8640.
    coneq[112]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c))))-1/2880.
    coneq[113]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))-1/8640.
    coneq[114]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/17280.
    coneq[115]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))-1/5760.
    coneq[116]=dot(b,dot(A,c*dot(A,c**6)))-1/630.
    coneq[117]=dot(b,dot(A,c*dot(A,dot(A,c**5))))-1/3780.
    coneq[118]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**4)))))-1/18900.
    coneq[119]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/75600.
    coneq[120]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/226800.
    coneq[121]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/453600.
    coneq[122]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/151200.
    coneq[123]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/56700.
    coneq[124]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/113400.
    coneq[125]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/37800.
    coneq[126]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/75600.
    coneq[127]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**3)))))-1/15120.
    coneq[128]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/45360.
    coneq[129]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/90720.
    coneq[130]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/30240.
    coneq[131]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2)))))-1/11340.
    coneq[132]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/22680.
    coneq[133]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c)))))-1/7560.
    coneq[134]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/22680.
    coneq[135]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/45360.
    coneq[136]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/15120.
    coneq[137]=dot(b,dot(A,c*dot(A,c*dot(A,c**4))))-1/3150.
    coneq[138]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**3)))))-1/12600.
    coneq[139]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/37800.
    coneq[140]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/75600.
    coneq[141]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/25200.
    coneq[142]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2)))))-1/9450.
    coneq[143]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/18900.
    coneq[144]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c)))))-1/6300.
    coneq[145]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/12600.
    coneq[146]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**3))))-1/2520.
    coneq[147]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2)))))-1/7560.
    coneq[148]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/15120.
    coneq[149]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c)))))-1/5040.
    coneq[150]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**2))))-1/1890.
    coneq[151]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c)))))-1/3780.
    coneq[152]=dot(b,dot(A,c*dot(A,c**4*dot(A,c))))-1/1260.
    coneq[153]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2))))-1/5670.
    coneq[154]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/11340.
    coneq[155]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/22680.
    coneq[156]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**3))))-1/5040.
    coneq[157]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/15120.
    coneq[158]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/30240.
    coneq[159]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/10080.
    coneq[160]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2))))-1/3780.
    coneq[161]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/7560.
    coneq[162]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c))))-1/2520.
    coneq[163]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/5040.
    coneq[164]=dot(b,dot(A,c**2*dot(A,c**5)))-1/540.
    coneq[165]=dot(b,dot(A,c**2*dot(A,dot(A,c**4))))-1/2700.
    coneq[166]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**3)))))-1/10800.
    coneq[167]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/32400.
    coneq[168]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/64800.
    coneq[169]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/21600.
    coneq[170]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2)))))-1/8100.
    coneq[171]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/16200.
    coneq[172]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c)))))-1/5400.
    coneq[173]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/10800.
    coneq[174]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**3))))-1/2160.
    coneq[175]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2)))))-1/6480.
    coneq[176]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/12960.
    coneq[177]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c)))))-1/4320.
    coneq[178]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**2))))-1/1620.
    coneq[179]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c)))))-1/3240.
    coneq[180]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c))))-1/1080.
    coneq[181]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2))))-1/3240.
    coneq[182]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/6480.
    coneq[183]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c))))-1/2160.
    coneq[184]=dot(b,dot(A,c**3*dot(A,c**4)))-1/450.
    coneq[185]=dot(b,dot(A,c**3*dot(A,dot(A,c**3))))-1/1800.
    coneq[186]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**2)))))-1/5400.
    coneq[187]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c))))))-1/10800.
    coneq[188]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c)))))-1/3600.
    coneq[189]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**2))))-1/1350.
    coneq[190]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c)))))-1/2700.
    coneq[191]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c))))-1/900.
    coneq[192]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c))))-1/1800.
    coneq[193]=dot(b,dot(A,c**4*dot(A,c**3)))-1/360.
    coneq[194]=dot(b,dot(A,c**4*dot(A,dot(A,c**2))))-1/1080.
    coneq[195]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c)))))-1/2160.
    coneq[196]=dot(b,dot(A,c**4*dot(A,c*dot(A,c))))-1/720.
    coneq[197]=dot(b,dot(A,c**5*dot(A,c**2)))-1/270.
    coneq[198]=dot(b,dot(A,c**5*dot(A,dot(A,c))))-1/540.
    coneq[199]=dot(b,dot(A,c**6*dot(A,c)))-1/180.
    coneq[200]=dot(b,dot(A,dot(A,c**3)*dot(A,c**3)))-1/1440.
    coneq[201]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**2))))-1/4320.
    coneq[202]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c)))))-1/8640.
    coneq[203]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c))))-1/2880.
    coneq[204]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))))-1/12960.
    coneq[205]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)))))-1/25920.
    coneq[206]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c))))-1/8640.
    coneq[207]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))))-1/51840.
    coneq[208]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c))))-1/17280.
    coneq[209]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))))-1/5760.
    coneq[210]=dot(b,dot(A,dot(A,c**2)*dot(A,c**4)))-1/1350.
    coneq[211]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**3))))-1/5400.
    coneq[212]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2)))))-1/16200.
    coneq[213]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))))))-1/32400.
    coneq[214]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c)))))-1/10800.
    coneq[215]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2))))-1/4050.
    coneq[216]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c)))))-1/8100.
    coneq[217]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c))))-1/2700.
    coneq[218]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c))))-1/5400.
    coneq[219]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**4)))-1/2700.
    coneq[220]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3))))-1/10800.
    coneq[221]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)))))-1/32400.
    coneq[222]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))-1/64800.
    coneq[223]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)))))-1/21600.
    coneq[224]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2))))-1/8100.
    coneq[225]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)))))-1/16200.
    coneq[226]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c))))-1/5400.
    coneq[227]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/10800.
    coneq[228]=dot(b,dot(A,dot(A,c)*dot(A,c**5)))-1/1080.
    coneq[229]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**4))))-1/5400.
    coneq[230]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3)))))-1/21600.
    coneq[231]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/64800.
    coneq[232]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/129600.
    coneq[233]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/43200.
    coneq[234]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2)))))-1/16200.
    coneq[235]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/32400.
    coneq[236]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c)))))-1/10800.
    coneq[237]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/21600.
    coneq[238]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**3))))-1/4320.
    coneq[239]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2)))))-1/12960.
    coneq[240]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/25920.
    coneq[241]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c)))))-1/8640.
    coneq[242]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2))))-1/3240.
    coneq[243]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c)))))-1/6480.
    coneq[244]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c))))-1/2160.
    coneq[245]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2))))-1/6480.
    coneq[246]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/12960.
    coneq[247]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c))))-1/4320.
    coneq[248]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**3)))-1/1080.
    coneq[249]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2))))-1/3240.
    coneq[250]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))-1/6480.
    coneq[251]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c))))-1/2160.
    coneq[252]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**3)))-1/2160.
    coneq[253]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2))))-1/6480.
    coneq[254]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))-1/12960.
    coneq[255]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c))))-1/4320.
    coneq[256]=dot(b,dot(A,c*dot(A,c)*dot(A,c**4)))-1/900.
    coneq[257]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**3))))-1/3600.
    coneq[258]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))-1/10800.
    coneq[259]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))-1/21600.
    coneq[260]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))-1/7200.
    coneq[261]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2))))-1/2700.
    coneq[262]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))-1/5400.
    coneq[263]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c))))-1/1800.
    coneq[264]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))-1/3600.
    coneq[265]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**2)))-1/810.
    coneq[266]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c))))-1/1620.
    coneq[267]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/3240.
    coneq[268]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**3)))-1/720.
    coneq[269]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2))))-1/2160.
    coneq[270]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c)))))-1/4320.
    coneq[271]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c))))-1/1440.
    coneq[272]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c**2)))-1/540.
    coneq[273]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,c))))-1/1080.
    coneq[274]=dot(b,dot(A,c**4*dot(A,c)*dot(A,c)))-1/360.
    coneq[275]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3)))-1/1440.
    coneq[276]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2))))-1/4320.
    coneq[277]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)))))-1/8640.
    coneq[278]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c))))-1/2880.
    coneq[279]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2)))-1/1620.
    coneq[280]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c))))-1/3240.
    coneq[281]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/6480.
    coneq[282]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2)))-1/1080.
    coneq[283]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))-1/2160.
    coneq[284]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c)))-1/720.
    coneq[285]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)))-1/1440.
    coneq[286]=dot(b,dot(A,c**7)*c)-1/80.
    coneq[287]=dot(b,dot(A,dot(A,c**6))*c)-1/560.
    coneq[288]=dot(b,dot(A,dot(A,dot(A,c**5)))*c)-1/3360.
    coneq[289]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4))))*c)-1/16800.
    coneq[290]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))*c)-1/67200.
    coneq[291]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*c)-1/201600.
    coneq[292]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/403200.
    coneq[293]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*c)-1/134400.
    coneq[294]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))*c)-1/50400.
    coneq[295]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*c)-1/100800.
    coneq[296]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))*c)-1/33600.
    coneq[297]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*c)-1/67200.
    coneq[298]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3))))*c)-1/13440.
    coneq[299]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))*c)-1/40320.
    coneq[300]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*c)-1/80640.
    coneq[301]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))*c)-1/26880.
    coneq[302]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))*c)-1/10080.
    coneq[303]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))*c)-1/20160.
    coneq[304]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c))))*c)-1/6720.
    coneq[305]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))*c)-1/20160.
    coneq[306]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*c)-1/40320.
    coneq[307]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))*c)-1/13440.
    coneq[308]=dot(b,dot(A,dot(A,c*dot(A,c**4)))*c)-1/2800.
    coneq[309]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3))))*c)-1/11200.
    coneq[310]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))*c)-1/33600.
    coneq[311]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/67200.
    coneq[312]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))*c)-1/22400.
    coneq[313]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))*c)-1/8400.
    coneq[314]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))*c)-1/16800.
    coneq[315]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))*c)-1/5600.
    coneq[316]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))*c)-1/11200.
    coneq[317]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)))*c)-1/2240.
    coneq[318]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))*c)-1/6720.
    coneq[319]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))*c)-1/13440.
    coneq[320]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))*c)-1/4480.
    coneq[321]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)))*c)-1/1680.
    coneq[322]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))))*c)-1/3360.
    coneq[323]=dot(b,dot(A,dot(A,c**4*dot(A,c)))*c)-1/1120.
    coneq[324]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))*c)-1/5040.
    coneq[325]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))*c)-1/10080.
    coneq[326]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*c)-1/20160.
    coneq[327]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)))*c)-1/4480.
    coneq[328]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))*c)-1/13440.
    coneq[329]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*c)-1/26880.
    coneq[330]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))*c)-1/8960.
    coneq[331]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))*c)-1/3360.
    coneq[332]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))*c)-1/6720.
    coneq[333]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))*c)-1/2240.
    coneq[334]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*c)-1/4480.
    coneq[335]=dot(b,dot(A,c*dot(A,c**5))*c)-1/480.
    coneq[336]=dot(b,dot(A,c*dot(A,dot(A,c**4)))*c)-1/2400.
    coneq[337]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3))))*c)-1/9600.
    coneq[338]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))*c)-1/28800.
    coneq[339]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/57600.
    coneq[340]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))*c)-1/19200.
    coneq[341]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))*c)-1/7200.
    coneq[342]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))*c)-1/14400.
    coneq[343]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))*c)-1/4800.
    coneq[344]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))*c)-1/9600.
    coneq[345]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)))*c)-1/1920.
    coneq[346]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))*c)-1/5760.
    coneq[347]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))*c)-1/11520.
    coneq[348]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))*c)-1/3840.
    coneq[349]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)))*c)-1/1440.
    coneq[350]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))*c)-1/2880.
    coneq[351]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)))*c)-1/960.
    coneq[352]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))*c)-1/2880.
    coneq[353]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))*c)-1/5760.
    coneq[354]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))*c)-1/1920.
    coneq[355]=dot(b,dot(A,c**2*dot(A,c**4))*c)-1/400.
    coneq[356]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)))*c)-1/1600.
    coneq[357]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))*c)-1/4800.
    coneq[358]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/9600.
    coneq[359]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))*c)-1/3200.
    coneq[360]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)))*c)-1/1200.
    coneq[361]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))*c)-1/2400.
    coneq[362]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)))*c)-1/800.
    coneq[363]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))*c)-1/1600.
    coneq[364]=dot(b,dot(A,c**3*dot(A,c**3))*c)-1/320.
    coneq[365]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)))*c)-1/960.
    coneq[366]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))))*c)-1/1920.
    coneq[367]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)))*c)-1/640.
    coneq[368]=dot(b,dot(A,c**4*dot(A,c**2))*c)-1/240.
    coneq[369]=dot(b,dot(A,c**4*dot(A,dot(A,c)))*c)-1/480.
    coneq[370]=dot(b,dot(A,c**5*dot(A,c))*c)-1/160.
    coneq[371]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3))*c)-1/960.
    coneq[372]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))*c)-1/2880.
    coneq[373]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))*c)-1/5760.
    coneq[374]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))*c)-1/1920.
    coneq[375]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3))*c)-1/1920.
    coneq[376]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))*c)-1/5760.
    coneq[377]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*c)-1/11520.
    coneq[378]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))*c)-1/3840.
    coneq[379]=dot(b,dot(A,dot(A,c)*dot(A,c**4))*c)-1/800.
    coneq[380]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)))*c)-1/3200.
    coneq[381]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))*c)-1/9600.
    coneq[382]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/19200.
    coneq[383]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))*c)-1/6400.
    coneq[384]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))*c)-1/2400.
    coneq[385]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))*c)-1/4800.
    coneq[386]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))*c)-1/1600.
    coneq[387]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*c)-1/3200.
    coneq[388]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2))*c)-1/720.
    coneq[389]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))*c)-1/1440.
    coneq[390]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))*c)-1/2880.
    coneq[391]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3))*c)-1/640.
    coneq[392]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))*c)-1/1920.
    coneq[393]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))*c)-1/3840.
    coneq[394]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))*c)-1/1280.
    coneq[395]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2))*c)-1/480.
    coneq[396]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))*c)-1/960.
    coneq[397]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c))*c)-1/320.
    coneq[398]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))*c)-1/960.
    coneq[399]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*c)-1/1920.
    coneq[400]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))*c)-1/640.
    coneq[401]=dot(b,dot(A,c**6)*c*c)-1/70.
    coneq[402]=dot(b,dot(A,dot(A,c**5))*c*c)-1/420.
    coneq[403]=dot(b,dot(A,dot(A,dot(A,c**4)))*c*c)-1/2100.
    coneq[404]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*c*c)-1/8400.
    coneq[405]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*c*c)-1/25200.
    coneq[406]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c*c)-1/50400.
    coneq[407]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*c*c)-1/16800.
    coneq[408]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*c*c)-1/6300.
    coneq[409]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*c*c)-1/12600.
    coneq[410]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*c*c)-1/4200.
    coneq[411]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*c*c)-1/8400.
    coneq[412]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*c*c)-1/1680.
    coneq[413]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*c*c)-1/5040.
    coneq[414]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*c*c)-1/10080.
    coneq[415]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*c*c)-1/3360.
    coneq[416]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*c*c)-1/1260.
    coneq[417]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*c*c)-1/2520.
    coneq[418]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*c*c)-1/840.
    coneq[419]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*c*c)-1/2520.
    coneq[420]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*c*c)-1/5040.
    coneq[421]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*c*c)-1/1680.
    coneq[422]=dot(b,dot(A,c*dot(A,c**4))*c*c)-1/350.
    coneq[423]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*c*c)-1/1400.
    coneq[424]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*c*c)-1/4200.
    coneq[425]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*c*c)-1/8400.
    coneq[426]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*c*c)-1/2800.
    coneq[427]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*c*c)-1/1050.
    coneq[428]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*c*c)-1/2100.
    coneq[429]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*c*c)-1/700.
    coneq[430]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*c*c)-1/1400.
    coneq[431]=dot(b,dot(A,c**2*dot(A,c**3))*c*c)-1/280.
    coneq[432]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*c*c)-1/840.
    coneq[433]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*c*c)-1/1680.
    coneq[434]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*c*c)-1/560.
    coneq[435]=dot(b,dot(A,c**3*dot(A,c**2))*c*c)-1/210.
    coneq[436]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*c*c)-1/420.
    coneq[437]=dot(b,dot(A,c**4*dot(A,c))*c*c)-1/140.
    coneq[438]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*c*c)-1/630.
    coneq[439]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*c*c)-1/1260.
    coneq[440]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*c*c)-1/2520.
    coneq[441]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*c*c)-1/560.
    coneq[442]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*c*c)-1/1680.
    coneq[443]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*c*c)-1/3360.
    coneq[444]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*c*c)-1/1120.
    coneq[445]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*c*c)-1/420.
    coneq[446]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*c*c)-1/840.
    coneq[447]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*c*c)-1/280.
    coneq[448]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*c*c)-1/560.
    coneq[449]=dot(b,dot(A,c**5)*c**3)-1/60.
    coneq[450]=dot(b,dot(A,dot(A,c**4))*c**3)-1/300.
    coneq[451]=dot(b,dot(A,dot(A,dot(A,c**3)))*c**3)-1/1200.
    coneq[452]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*c**3)-1/3600.
    coneq[453]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*c**3)-1/7200.
    coneq[454]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*c**3)-1/2400.
    coneq[455]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*c**3)-1/900.
    coneq[456]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*c**3)-1/1800.
    coneq[457]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*c**3)-1/600.
    coneq[458]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*c**3)-1/1200.
    coneq[459]=dot(b,dot(A,c*dot(A,c**3))*c**3)-1/240.
    coneq[460]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*c**3)-1/720.
    coneq[461]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*c**3)-1/1440.
    coneq[462]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*c**3)-1/480.
    coneq[463]=dot(b,dot(A,c**2*dot(A,c**2))*c**3)-1/180.
    coneq[464]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*c**3)-1/360.
    coneq[465]=dot(b,dot(A,c**3*dot(A,c))*c**3)-1/120.
    coneq[466]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*c**3)-1/360.
    coneq[467]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*c**3)-1/720.
    coneq[468]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*c**3)-1/240.
    coneq[469]=dot(b,dot(A,c**4)*c**4)-1/50.
    coneq[470]=dot(b,dot(A,dot(A,c**3))*c**4)-1/200.
    coneq[471]=dot(b,dot(A,dot(A,dot(A,c**2)))*c**4)-1/600.
    coneq[472]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*c**4)-1/1200.
    coneq[473]=dot(b,dot(A,dot(A,c*dot(A,c)))*c**4)-1/400.
    coneq[474]=dot(b,dot(A,c*dot(A,c**2))*c**4)-1/150.
    coneq[475]=dot(b,dot(A,c*dot(A,dot(A,c)))*c**4)-1/300.
    coneq[476]=dot(b,dot(A,c**2*dot(A,c))*c**4)-1/100.
    coneq[477]=dot(b,dot(A,dot(A,c)*dot(A,c))*c**4)-1/200.
    coneq[478]=dot(b,dot(A,c**3)*c**5)-1/40.
    coneq[479]=dot(b,dot(A,dot(A,c**2))*c**5)-1/120.
    coneq[480]=dot(b,dot(A,dot(A,dot(A,c)))*c**5)-1/240.
    coneq[481]=dot(b,dot(A,c*dot(A,c))*c**5)-1/80.
    coneq[482]=dot(b,dot(A,c**2)*c**6)-1/30.
    coneq[483]=dot(b,dot(A,dot(A,c))*c**6)-1/60.
    coneq[484]=dot(b,dot(A,c)*c**7)-1/20.
    coneq[485]=dot(b,dot(A,c**4)*dot(A,c**3))-1/200.
    coneq[486]=dot(b,dot(A,dot(A,c**3))*dot(A,c**3))-1/800.
    coneq[487]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**3))-1/2400.
    coneq[488]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**3))-1/4800.
    coneq[489]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**3))-1/1600.
    coneq[490]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**3))-1/600.
    coneq[491]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**3))-1/1200.
    coneq[492]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**3))-1/400.
    coneq[493]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**3))-1/800.
    coneq[494]=dot(b,dot(A,c**4)*dot(A,dot(A,c**2)))-1/600.
    coneq[495]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c**2)))-1/2400.
    coneq[496]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c**2)))-1/7200.
    coneq[497]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**2)))-1/14400.
    coneq[498]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c**2)))-1/4800.
    coneq[499]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c**2)))-1/1800.
    coneq[500]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c**2)))-1/3600.
    coneq[501]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c**2)))-1/1200.
    coneq[502]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c**2)))-1/2400.
    coneq[503]=dot(b,dot(A,c**4)*dot(A,dot(A,dot(A,c))))-1/1200.
    coneq[504]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,c))))-1/4800.
    coneq[505]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c))))-1/14400.
    coneq[506]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/28800.
    coneq[507]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/9600.
    coneq[508]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,c))))-1/3600.
    coneq[509]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/7200.
    coneq[510]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,c))))-1/2400.
    coneq[511]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c))))-1/4800.
    coneq[512]=dot(b,dot(A,c**4)*dot(A,c*dot(A,c)))-1/400.
    coneq[513]=dot(b,dot(A,dot(A,c**3))*dot(A,c*dot(A,c)))-1/1600.
    coneq[514]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,c)))-1/4800.
    coneq[515]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c)))-1/9600.
    coneq[516]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,c)))-1/3200.
    coneq[517]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c)))-1/1200.
    coneq[518]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,c)))-1/2400.
    coneq[519]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,c)))-1/800.
    coneq[520]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,c)))-1/1600.
    coneq[521]=dot(b,dot(A,c**5)*dot(A,c**2))-1/180.
    coneq[522]=dot(b,dot(A,dot(A,c**4))*dot(A,c**2))-1/900.
    coneq[523]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c**2))-1/3600.
    coneq[524]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c**2))-1/10800.
    coneq[525]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**2))-1/21600.
    coneq[526]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c**2))-1/7200.
    coneq[527]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c**2))-1/2700.
    coneq[528]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c**2))-1/5400.
    coneq[529]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c**2))-1/1800.
    coneq[530]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c**2))-1/3600.
    coneq[531]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c**2))-1/720.
    coneq[532]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c**2))-1/2160.
    coneq[533]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c**2))-1/4320.
    coneq[534]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c**2))-1/1440.
    coneq[535]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c**2))-1/540.
    coneq[536]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c**2))-1/1080.
    coneq[537]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c**2))-1/360.
    coneq[538]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c**2))-1/1080.
    coneq[539]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c**2))-1/2160.
    coneq[540]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c**2))-1/720.
    coneq[541]=dot(b,dot(A,c**5)*dot(A,dot(A,c)))-1/360.
    coneq[542]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,c)))-1/1800.
    coneq[543]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,c)))-1/7200.
    coneq[544]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c)))-1/21600.
    coneq[545]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/43200.
    coneq[546]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c)))-1/14400.
    coneq[547]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,c)))-1/5400.
    coneq[548]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/10800.
    coneq[549]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,c)))-1/3600.
    coneq[550]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c)))-1/7200.
    coneq[551]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,c)))-1/1440.
    coneq[552]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,c)))-1/4320.
    coneq[553]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/8640.
    coneq[554]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,c)))-1/2880.
    coneq[555]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,c)))-1/1080.
    coneq[556]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/2160.
    coneq[557]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,c)))-1/720.
    coneq[558]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,c)))-1/2160.
    coneq[559]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/4320.
    coneq[560]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,c)))-1/1440.
    coneq[561]=dot(b,dot(A,c**6)*dot(A,c))-1/140.
    coneq[562]=dot(b,dot(A,dot(A,c**5))*dot(A,c))-1/840.
    coneq[563]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,c))-1/4200.
    coneq[564]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,c))-1/16800.
    coneq[565]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c))-1/50400.
    coneq[566]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/100800.
    coneq[567]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c))-1/33600.
    coneq[568]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,c))-1/12600.
    coneq[569]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c))-1/25200.
    coneq[570]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,c))-1/8400.
    coneq[571]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c))-1/16800.
    coneq[572]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,c))-1/3360.
    coneq[573]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,c))-1/10080.
    coneq[574]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/20160.
    coneq[575]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,c))-1/6720.
    coneq[576]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,c))-1/2520.
    coneq[577]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,c))-1/5040.
    coneq[578]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,c))-1/1680.
    coneq[579]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c))-1/5040.
    coneq[580]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c))-1/10080.
    coneq[581]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c))-1/3360.
    coneq[582]=dot(b,dot(A,c*dot(A,c**4))*dot(A,c))-1/700.
    coneq[583]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,c))-1/2800.
    coneq[584]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,c))-1/8400.
    coneq[585]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/16800.
    coneq[586]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,c))-1/5600.
    coneq[587]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,c))-1/2100.
    coneq[588]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,c))-1/4200.
    coneq[589]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,c))-1/1400.
    coneq[590]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,c))-1/2800.
    coneq[591]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,c))-1/560.
    coneq[592]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,c))-1/1680.
    coneq[593]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/3360.
    coneq[594]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,c))-1/1120.
    coneq[595]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,c))-1/420.
    coneq[596]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,c))-1/840.
    coneq[597]=dot(b,dot(A,c**4*dot(A,c))*dot(A,c))-1/280.
    coneq[598]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,c))-1/1260.
    coneq[599]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c))-1/2520.
    coneq[600]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c))-1/5040.
    coneq[601]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,c))-1/1120.
    coneq[602]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c))-1/3360.
    coneq[603]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/6720.
    coneq[604]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c))-1/2240.
    coneq[605]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,c))-1/840.
    coneq[606]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,c))-1/1680.
    coneq[607]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,c))-1/560.
    coneq[608]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c))-1/1120.
    coneq[609]=dot(b,dot(A,c**3)*dot(A,c**3)*c)-1/160.
    coneq[610]=dot(b,dot(A,dot(A,c**2))*dot(A,c**3)*c)-1/480.
    coneq[611]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**3)*c)-1/960.
    coneq[612]=dot(b,dot(A,c*dot(A,c))*dot(A,c**3)*c)-1/320.
    coneq[613]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))*c)-1/1440.
    coneq[614]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2))*c)-1/2880.
    coneq[615]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c**2))*c)-1/960.
    coneq[616]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*c)-1/5760.
    coneq[617]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)))*c)-1/1920.
    coneq[618]=dot(b,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))*c)-1/640.
    coneq[619]=dot(b,dot(A,c**4)*dot(A,c**2)*c)-1/150.
    coneq[620]=dot(b,dot(A,dot(A,c**3))*dot(A,c**2)*c)-1/600.
    coneq[621]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2)*c)-1/1800.
    coneq[622]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2)*c)-1/3600.
    coneq[623]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2)*c)-1/1200.
    coneq[624]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**2)*c)-1/450.
    coneq[625]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2)*c)-1/900.
    coneq[626]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**2)*c)-1/300.
    coneq[627]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2)*c)-1/600.
    coneq[628]=dot(b,dot(A,c**4)*dot(A,dot(A,c))*c)-1/300.
    coneq[629]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c))*c)-1/1200.
    coneq[630]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c))*c)-1/3600.
    coneq[631]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*c)-1/7200.
    coneq[632]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c))*c)-1/2400.
    coneq[633]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c))*c)-1/900.
    coneq[634]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c))*c)-1/1800.
    coneq[635]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c))*c)-1/600.
    coneq[636]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c))*c)-1/1200.
    coneq[637]=dot(b,dot(A,c**5)*dot(A,c)*c)-1/120.
    coneq[638]=dot(b,dot(A,dot(A,c**4))*dot(A,c)*c)-1/600.
    coneq[639]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c)*c)-1/2400.
    coneq[640]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c)*c)-1/7200.
    coneq[641]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c)*c)-1/14400.
    coneq[642]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c)*c)-1/4800.
    coneq[643]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c)*c)-1/1800.
    coneq[644]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c)*c)-1/3600.
    coneq[645]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c)*c)-1/1200.
    coneq[646]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c)*c)-1/2400.
    coneq[647]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c)*c)-1/480.
    coneq[648]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c)*c)-1/1440.
    coneq[649]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c)*c)-1/2880.
    coneq[650]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c)*c)-1/960.
    coneq[651]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c)*c)-1/360.
    coneq[652]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c)*c)-1/720.
    coneq[653]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c)*c)-1/240.
    coneq[654]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c)*c)-1/720.
    coneq[655]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c)*c)-1/1440.
    coneq[656]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c)*c)-1/480.
    coneq[657]=dot(b,dot(A,c**3)*dot(A,c**2)*c*c)-1/120.
    coneq[658]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2)*c*c)-1/360.
    coneq[659]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2)*c*c)-1/720.
    coneq[660]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2)*c*c)-1/240.
    coneq[661]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*c*c)-1/240.
    coneq[662]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*c*c)-1/720.
    coneq[663]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*c*c)-1/1440.
    coneq[664]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*c*c)-1/480.
    coneq[665]=dot(b,dot(A,c**4)*dot(A,c)*c*c)-1/100.
    coneq[666]=dot(b,dot(A,dot(A,c**3))*dot(A,c)*c*c)-1/400.
    coneq[667]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c)*c*c)-1/1200.
    coneq[668]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c)*c*c)-1/2400.
    coneq[669]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c)*c*c)-1/800.
    coneq[670]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c)*c*c)-1/300.
    coneq[671]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c)*c*c)-1/600.
    coneq[672]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c)*c*c)-1/200.
    coneq[673]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c)*c*c)-1/400.
    coneq[674]=dot(b,dot(A,c**2)*dot(A,c**2)*c**3)-1/90.
    coneq[675]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*c**3)-1/180.
    coneq[676]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*c**3)-1/360.
    coneq[677]=dot(b,dot(A,c**3)*dot(A,c)*c**3)-1/80.
    coneq[678]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*c**3)-1/240.
    coneq[679]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*c**3)-1/480.
    coneq[680]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*c**3)-1/160.
    coneq[681]=dot(b,dot(A,c**2)*dot(A,c)*c**4)-1/60.
    coneq[682]=dot(b,dot(A,dot(A,c))*dot(A,c)*c**4)-1/120.
    coneq[683]=dot(b,dot(A,c)*dot(A,c)*c**5)-1/40.
    coneq[684]=dot(b,dot(A,c**4)*dot(A,c)*dot(A,c))-1/200.
    coneq[685]=dot(b,dot(A,dot(A,c**3))*dot(A,c)*dot(A,c))-1/800.
    coneq[686]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c)*dot(A,c))-1/2400.
    coneq[687]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c)*dot(A,c))-1/4800.
    coneq[688]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c)*dot(A,c))-1/1600.
    coneq[689]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c)*dot(A,c))-1/600.
    coneq[690]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c)*dot(A,c))-1/1200.
    coneq[691]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c)*dot(A,c))-1/400.
    coneq[692]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c)*dot(A,c))-1/800.
    coneq[693]=dot(b,dot(A,c**3)*dot(A,c**2)*dot(A,c))-1/240.
    coneq[694]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2)*dot(A,c))-1/720.
    coneq[695]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c))-1/1440.
    coneq[696]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2)*dot(A,c))-1/480.
    coneq[697]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*dot(A,c))-1/480.
    coneq[698]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*dot(A,c))-1/1440.
    coneq[699]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c))-1/2880.
    coneq[700]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*dot(A,c))-1/960.
    coneq[701]=dot(b,dot(A,c**2)*dot(A,c**2)*dot(A,c**2))-1/270.
    coneq[702]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*dot(A,c**2))-1/540.
    coneq[703]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c**2))-1/1080.
    coneq[704]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/2160.
    coneq[705]=dot(b,dot(A,c**3)*dot(A,c)*dot(A,c)*c)-1/160.
    coneq[706]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*dot(A,c)*c)-1/480.
    coneq[707]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*dot(A,c)*c)-1/960.
    coneq[708]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*dot(A,c)*c)-1/320.
    coneq[709]=dot(b,dot(A,c**2)*dot(A,c**2)*dot(A,c)*c)-1/180.
    coneq[710]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*dot(A,c)*c)-1/360.
    coneq[711]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c)*c)-1/720.
    coneq[712]=dot(b,dot(A,c**2)*dot(A,c)*dot(A,c)*c*c)-1/120.
    coneq[713]=dot(b,dot(A,dot(A,c))*dot(A,c)*dot(A,c)*c*c)-1/240.
    coneq[714]=dot(b,dot(A,c)*dot(A,c)*dot(A,c)*c**3)-1/80.
    coneq[715]=dot(b,dot(A,c**2)*dot(A,c)*dot(A,c)*dot(A,c))-1/240.
    coneq[716]=dot(b,dot(A,dot(A,c))*dot(A,c)*dot(A,c)*dot(A,c))-1/480.
    coneq[717]=dot(b,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)*c)-1/160.
    coneq[718]=dot(b,c**9)-1/10.
    if any(abs(coneq)>tol):
        return 9
    # order 11 conditions:
    coneq[0]=dot(b,dot(A,c**9))-1/110.
    coneq[1]=dot(b,dot(A,dot(A,c**8)))-1/990.
    coneq[2]=dot(b,dot(A,dot(A,dot(A,c**7))))-1/7920.
    coneq[3]=dot(b,dot(A,dot(A,dot(A,dot(A,c**6)))))-1/55440.
    coneq[4]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**5))))))-1/332640.
    coneq[5]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**4)))))))-1/1663200.
    coneq[6]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/6652800.
    coneq[7]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/19958400.
    coneq[8]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/39916800.
    coneq[9]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/13305600.
    coneq[10]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/4989600.
    coneq[11]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/9979200.
    coneq[12]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/3326400.
    coneq[13]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/6652800.
    coneq[14]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3)))))))-1/1330560.
    coneq[15]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/3991680.
    coneq[16]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/7983360.
    coneq[17]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/2661120.
    coneq[18]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))))-1/997920.
    coneq[19]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/1995840.
    coneq[20]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)))))))-1/665280.
    coneq[21]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/1995840.
    coneq[22]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/3991680.
    coneq[23]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/1330560.
    coneq[24]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**4))))))-1/277200.
    coneq[25]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3)))))))-1/1108800.
    coneq[26]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/3326400.
    coneq[27]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/6652800.
    coneq[28]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/2217600.
    coneq[29]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))))-1/831600.
    coneq[30]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/1663200.
    coneq[31]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))))-1/554400.
    coneq[32]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/1108800.
    coneq[33]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**3))))))-1/221760.
    coneq[34]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))))-1/665280.
    coneq[35]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/1330560.
    coneq[36]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))))-1/443520.
    coneq[37]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c**2))))))-1/166320.
    coneq[38]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)))))))-1/332640.
    coneq[39]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,c))))))-1/110880.
    coneq[40]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))))-1/498960.
    coneq[41]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/997920.
    coneq[42]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/1995840.
    coneq[43]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3))))))-1/443520.
    coneq[44]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/1330560.
    coneq[45]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/2661120.
    coneq[46]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/887040.
    coneq[47]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))))-1/332640.
    coneq[48]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/665280.
    coneq[49]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))))-1/221760.
    coneq[50]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/443520.
    coneq[51]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**5)))))-1/47520.
    coneq[52]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**4))))))-1/237600.
    coneq[53]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3)))))))-1/950400.
    coneq[54]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/2851200.
    coneq[55]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/5702400.
    coneq[56]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/1900800.
    coneq[57]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))))-1/712800.
    coneq[58]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1425600.
    coneq[59]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))))-1/475200.
    coneq[60]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/950400.
    coneq[61]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**3))))))-1/190080.
    coneq[62]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))))-1/570240.
    coneq[63]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1140480.
    coneq[64]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))))-1/380160.
    coneq[65]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2))))))-1/142560.
    coneq[66]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))))-1/285120.
    coneq[67]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,c))))))-1/95040.
    coneq[68]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))))-1/285120.
    coneq[69]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/570240.
    coneq[70]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))))-1/190080.
    coneq[71]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**4)))))-1/39600.
    coneq[72]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**3))))))-1/158400.
    coneq[73]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))))-1/475200.
    coneq[74]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))))-1/950400.
    coneq[75]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))))-1/316800.
    coneq[76]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2))))))-1/118800.
    coneq[77]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))))-1/237600.
    coneq[78]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c))))))-1/79200.
    coneq[79]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))))-1/158400.
    coneq[80]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**3)))))-1/31680.
    coneq[81]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c**2))))))-1/95040.
    coneq[82]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)))))))-1/190080.
    coneq[83]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,c))))))-1/63360.
    coneq[84]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c**2)))))-1/23760.
    coneq[85]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,c))))))-1/47520.
    coneq[86]=dot(b,dot(A,dot(A,dot(A,c**5*dot(A,c)))))-1/15840.
    coneq[87]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**3)))))-1/95040.
    coneq[88]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))))-1/285120.
    coneq[89]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/570240.
    coneq[90]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))))-1/190080.
    coneq[91]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3)))))-1/190080.
    coneq[92]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/570240.
    coneq[93]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/1140480.
    coneq[94]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/380160.
    coneq[95]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**4)))))-1/79200.
    coneq[96]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3))))))-1/316800.
    coneq[97]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/950400.
    coneq[98]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1900800.
    coneq[99]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/633600.
    coneq[100]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))))-1/237600.
    coneq[101]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/475200.
    coneq[102]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))))-1/158400.
    coneq[103]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/316800.
    coneq[104]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2)))))-1/71280.
    coneq[105]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))))-1/142560.
    coneq[106]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/285120.
    coneq[107]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**3)))))-1/63360.
    coneq[108]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))))-1/190080.
    coneq[109]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/380160.
    coneq[110]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))))-1/126720.
    coneq[111]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2)))))-1/47520.
    coneq[112]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))))-1/95040.
    coneq[113]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,c)))))-1/31680.
    coneq[114]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/95040.
    coneq[115]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/190080.
    coneq[116]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))))-1/63360.
    coneq[117]=dot(b,dot(A,dot(A,c*dot(A,c**6))))-1/6930.
    coneq[118]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**5)))))-1/41580.
    coneq[119]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**4))))))-1/207900.
    coneq[120]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/831600.
    coneq[121]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/2494800.
    coneq[122]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/4989600.
    coneq[123]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/1663200.
    coneq[124]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/623700.
    coneq[125]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1247400.
    coneq[126]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/415800.
    coneq[127]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/831600.
    coneq[128]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**3))))))-1/166320.
    coneq[129]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/498960.
    coneq[130]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/997920.
    coneq[131]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/332640.
    coneq[132]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2))))))-1/124740.
    coneq[133]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/249480.
    coneq[134]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,c))))))-1/83160.
    coneq[135]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/249480.
    coneq[136]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/498960.
    coneq[137]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/166320.
    coneq[138]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**4)))))-1/34650.
    coneq[139]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**3))))))-1/138600.
    coneq[140]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/415800.
    coneq[141]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/831600.
    coneq[142]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/277200.
    coneq[143]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2))))))-1/103950.
    coneq[144]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/207900.
    coneq[145]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c))))))-1/69300.
    coneq[146]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/138600.
    coneq[147]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**3)))))-1/27720.
    coneq[148]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2))))))-1/83160.
    coneq[149]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/166320.
    coneq[150]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c))))))-1/55440.
    coneq[151]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c**2)))))-1/20790.
    coneq[152]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,c))))))-1/41580.
    coneq[153]=dot(b,dot(A,dot(A,c*dot(A,c**4*dot(A,c)))))-1/13860.
    coneq[154]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/62370.
    coneq[155]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/124740.
    coneq[156]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/249480.
    coneq[157]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**3)))))-1/55440.
    coneq[158]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/166320.
    coneq[159]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/332640.
    coneq[160]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/110880.
    coneq[161]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/41580.
    coneq[162]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/83160.
    coneq[163]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/27720.
    coneq[164]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/55440.
    coneq[165]=dot(b,dot(A,dot(A,c**2*dot(A,c**5))))-1/5940.
    coneq[166]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**4)))))-1/29700.
    coneq[167]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**3))))))-1/118800.
    coneq[168]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/356400.
    coneq[169]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/712800.
    coneq[170]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/237600.
    coneq[171]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2))))))-1/89100.
    coneq[172]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/178200.
    coneq[173]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c))))))-1/59400.
    coneq[174]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/118800.
    coneq[175]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**3)))))-1/23760.
    coneq[176]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2))))))-1/71280.
    coneq[177]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/142560.
    coneq[178]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c))))))-1/47520.
    coneq[179]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c**2)))))-1/17820.
    coneq[180]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c))))))-1/35640.
    coneq[181]=dot(b,dot(A,dot(A,c**2*dot(A,c**3*dot(A,c)))))-1/11880.
    coneq[182]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2)))))-1/35640.
    coneq[183]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/71280.
    coneq[184]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)))))-1/23760.
    coneq[185]=dot(b,dot(A,dot(A,c**3*dot(A,c**4))))-1/4950.
    coneq[186]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**3)))))-1/19800.
    coneq[187]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c**2))))))-1/59400.
    coneq[188]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)))))))-1/118800.
    coneq[189]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,c))))))-1/39600.
    coneq[190]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c**2)))))-1/14850.
    coneq[191]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,c))))))-1/29700.
    coneq[192]=dot(b,dot(A,dot(A,c**3*dot(A,c**2*dot(A,c)))))-1/9900.
    coneq[193]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,c)))))-1/19800.
    coneq[194]=dot(b,dot(A,dot(A,c**4*dot(A,c**3))))-1/3960.
    coneq[195]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c**2)))))-1/11880.
    coneq[196]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,c))))))-1/23760.
    coneq[197]=dot(b,dot(A,dot(A,c**4*dot(A,c*dot(A,c)))))-1/7920.
    coneq[198]=dot(b,dot(A,dot(A,c**5*dot(A,c**2))))-1/2970.
    coneq[199]=dot(b,dot(A,dot(A,c**5*dot(A,dot(A,c)))))-1/5940.
    coneq[200]=dot(b,dot(A,dot(A,c**6*dot(A,c))))-1/1980.
    coneq[201]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c**3))))-1/15840.
    coneq[202]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c**2)))))-1/47520.
    coneq[203]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c))))))-1/95040.
    coneq[204]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,c)))))-1/31680.
    coneq[205]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))))-1/142560.
    coneq[206]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))))-1/285120.
    coneq[207]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))))-1/95040.
    coneq[208]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))))-1/570240.
    coneq[209]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))))-1/190080.
    coneq[210]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))))-1/63360.
    coneq[211]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**4))))-1/14850.
    coneq[212]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**3)))))-1/59400.
    coneq[213]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))))-1/178200.
    coneq[214]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/356400.
    coneq[215]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))))-1/118800.
    coneq[216]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2)))))-1/44550.
    coneq[217]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))))-1/89100.
    coneq[218]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)))))-1/29700.
    coneq[219]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))))-1/59400.
    coneq[220]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**4))))-1/29700.
    coneq[221]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3)))))-1/118800.
    coneq[222]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/356400.
    coneq[223]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/712800.
    coneq[224]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/237600.
    coneq[225]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))))-1/89100.
    coneq[226]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/178200.
    coneq[227]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))))-1/59400.
    coneq[228]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/118800.
    coneq[229]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**5))))-1/11880.
    coneq[230]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**4)))))-1/59400.
    coneq[231]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3))))))-1/237600.
    coneq[232]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/712800.
    coneq[233]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1425600.
    coneq[234]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/475200.
    coneq[235]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))))-1/178200.
    coneq[236]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/356400.
    coneq[237]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))))-1/118800.
    coneq[238]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/237600.
    coneq[239]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**3)))))-1/47520.
    coneq[240]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))))-1/142560.
    coneq[241]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/285120.
    coneq[242]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))))-1/95040.
    coneq[243]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2)))))-1/35640.
    coneq[244]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))))-1/71280.
    coneq[245]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,c)))))-1/23760.
    coneq[246]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))))-1/71280.
    coneq[247]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/142560.
    coneq[248]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))))-1/47520.
    coneq[249]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**3))))-1/11880.
    coneq[250]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/35640.
    coneq[251]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/71280.
    coneq[252]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/23760.
    coneq[253]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**3))))-1/23760.
    coneq[254]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/71280.
    coneq[255]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/142560.
    coneq[256]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/47520.
    coneq[257]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**4))))-1/9900.
    coneq[258]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**3)))))-1/39600.
    coneq[259]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/118800.
    coneq[260]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/237600.
    coneq[261]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/79200.
    coneq[262]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2)))))-1/29700.
    coneq[263]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/59400.
    coneq[264]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)))))-1/19800.
    coneq[265]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/39600.
    coneq[266]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c**2))))-1/8910.
    coneq[267]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)))))-1/17820.
    coneq[268]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/35640.
    coneq[269]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**3))))-1/7920.
    coneq[270]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2)))))-1/23760.
    coneq[271]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/47520.
    coneq[272]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)))))-1/15840.
    coneq[273]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c**2))))-1/5940.
    coneq[274]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,c)))))-1/11880.
    coneq[275]=dot(b,dot(A,dot(A,c**4*dot(A,c)*dot(A,c))))-1/3960.
    coneq[276]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3))))-1/15840.
    coneq[277]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))))-1/47520.
    coneq[278]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/95040.
    coneq[279]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))))-1/31680.
    coneq[280]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2))))-1/17820.
    coneq[281]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))))-1/35640.
    coneq[282]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/71280.
    coneq[283]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2))))-1/11880.
    coneq[284]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/23760.
    coneq[285]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c))))-1/7920.
    coneq[286]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))))-1/15840.
    coneq[287]=dot(b,dot(A,c*dot(A,c**7)))-1/880.
    coneq[288]=dot(b,dot(A,c*dot(A,dot(A,c**6))))-1/6160.
    coneq[289]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**5)))))-1/36960.
    coneq[290]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**4))))))-1/184800.
    coneq[291]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/739200.
    coneq[292]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/2217600.
    coneq[293]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/4435200.
    coneq[294]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/1478400.
    coneq[295]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/554400.
    coneq[296]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1108800.
    coneq[297]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/369600.
    coneq[298]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/739200.
    coneq[299]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**3))))))-1/147840.
    coneq[300]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/443520.
    coneq[301]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/887040.
    coneq[302]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/295680.
    coneq[303]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))-1/110880.
    coneq[304]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/221760.
    coneq[305]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,c))))))-1/73920.
    coneq[306]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/221760.
    coneq[307]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/443520.
    coneq[308]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/147840.
    coneq[309]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**4)))))-1/30800.
    coneq[310]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**3))))))-1/123200.
    coneq[311]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/369600.
    coneq[312]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/739200.
    coneq[313]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/246400.
    coneq[314]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))-1/92400.
    coneq[315]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/184800.
    coneq[316]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))-1/61600.
    coneq[317]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/123200.
    coneq[318]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**3)))))-1/24640.
    coneq[319]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))-1/73920.
    coneq[320]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/147840.
    coneq[321]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))-1/49280.
    coneq[322]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c**2)))))-1/18480.
    coneq[323]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,c))))))-1/36960.
    coneq[324]=dot(b,dot(A,c*dot(A,dot(A,c**4*dot(A,c)))))-1/12320.
    coneq[325]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))-1/55440.
    coneq[326]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/110880.
    coneq[327]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/221760.
    coneq[328]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**3)))))-1/49280.
    coneq[329]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/147840.
    coneq[330]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/295680.
    coneq[331]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/98560.
    coneq[332]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))-1/36960.
    coneq[333]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/73920.
    coneq[334]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))-1/24640.
    coneq[335]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/49280.
    coneq[336]=dot(b,dot(A,c*dot(A,c*dot(A,c**5))))-1/5280.
    coneq[337]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**4)))))-1/26400.
    coneq[338]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**3))))))-1/105600.
    coneq[339]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/316800.
    coneq[340]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/633600.
    coneq[341]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/211200.
    coneq[342]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))-1/79200.
    coneq[343]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/158400.
    coneq[344]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))-1/52800.
    coneq[345]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/105600.
    coneq[346]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**3)))))-1/21120.
    coneq[347]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))-1/63360.
    coneq[348]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/126720.
    coneq[349]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))-1/42240.
    coneq[350]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c**2)))))-1/15840.
    coneq[351]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))-1/31680.
    coneq[352]=dot(b,dot(A,c*dot(A,c*dot(A,c**3*dot(A,c)))))-1/10560.
    coneq[353]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))-1/31680.
    coneq[354]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/63360.
    coneq[355]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))-1/21120.
    coneq[356]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**4))))-1/4400.
    coneq[357]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**3)))))-1/17600.
    coneq[358]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))-1/52800.
    coneq[359]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))-1/105600.
    coneq[360]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))-1/35200.
    coneq[361]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c**2)))))-1/13200.
    coneq[362]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))-1/26400.
    coneq[363]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,c)))))-1/8800.
    coneq[364]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))-1/17600.
    coneq[365]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**3))))-1/3520.
    coneq[366]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c**2)))))-1/10560.
    coneq[367]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,c))))))-1/21120.
    coneq[368]=dot(b,dot(A,c*dot(A,c**3*dot(A,c*dot(A,c)))))-1/7040.
    coneq[369]=dot(b,dot(A,c*dot(A,c**4*dot(A,c**2))))-1/2640.
    coneq[370]=dot(b,dot(A,c*dot(A,c**4*dot(A,dot(A,c)))))-1/5280.
    coneq[371]=dot(b,dot(A,c*dot(A,c**5*dot(A,c))))-1/1760.
    coneq[372]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**3))))-1/10560.
    coneq[373]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))-1/31680.
    coneq[374]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/63360.
    coneq[375]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))-1/21120.
    coneq[376]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**3))))-1/21120.
    coneq[377]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/63360.
    coneq[378]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/126720.
    coneq[379]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/42240.
    coneq[380]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**4))))-1/8800.
    coneq[381]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**3)))))-1/35200.
    coneq[382]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/105600.
    coneq[383]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/211200.
    coneq[384]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/70400.
    coneq[385]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))-1/26400.
    coneq[386]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/52800.
    coneq[387]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))-1/17600.
    coneq[388]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/35200.
    coneq[389]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c**2))))-1/7920.
    coneq[390]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))-1/15840.
    coneq[391]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/31680.
    coneq[392]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**3))))-1/7040.
    coneq[393]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))-1/21120.
    coneq[394]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/42240.
    coneq[395]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))-1/14080.
    coneq[396]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c**2))))-1/5280.
    coneq[397]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))-1/10560.
    coneq[398]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,c))))-1/3520.
    coneq[399]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))-1/10560.
    coneq[400]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/21120.
    coneq[401]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))-1/7040.
    coneq[402]=dot(b,dot(A,c**2*dot(A,c**6)))-1/770.
    coneq[403]=dot(b,dot(A,c**2*dot(A,dot(A,c**5))))-1/4620.
    coneq[404]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**4)))))-1/23100.
    coneq[405]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/92400.
    coneq[406]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/277200.
    coneq[407]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/554400.
    coneq[408]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/184800.
    coneq[409]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/69300.
    coneq[410]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/138600.
    coneq[411]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/46200.
    coneq[412]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/92400.
    coneq[413]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**3)))))-1/18480.
    coneq[414]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/55440.
    coneq[415]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/110880.
    coneq[416]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/36960.
    coneq[417]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c**2)))))-1/13860.
    coneq[418]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/27720.
    coneq[419]=dot(b,dot(A,c**2*dot(A,dot(A,c**3*dot(A,c)))))-1/9240.
    coneq[420]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/27720.
    coneq[421]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/55440.
    coneq[422]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/18480.
    coneq[423]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**4))))-1/3850.
    coneq[424]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**3)))))-1/15400.
    coneq[425]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/46200.
    coneq[426]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/92400.
    coneq[427]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/30800.
    coneq[428]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c**2)))))-1/11550.
    coneq[429]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/23100.
    coneq[430]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,c)))))-1/7700.
    coneq[431]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/15400.
    coneq[432]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**3))))-1/3080.
    coneq[433]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c**2)))))-1/9240.
    coneq[434]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/18480.
    coneq[435]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,c)))))-1/6160.
    coneq[436]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c**2))))-1/2310.
    coneq[437]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,dot(A,c)))))-1/4620.
    coneq[438]=dot(b,dot(A,c**2*dot(A,c**4*dot(A,c))))-1/1540.
    coneq[439]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c**2))))-1/6930.
    coneq[440]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/13860.
    coneq[441]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/27720.
    coneq[442]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**3))))-1/6160.
    coneq[443]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/18480.
    coneq[444]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/36960.
    coneq[445]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/12320.
    coneq[446]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c**2))))-1/4620.
    coneq[447]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/9240.
    coneq[448]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,c))))-1/3080.
    coneq[449]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/6160.
    coneq[450]=dot(b,dot(A,c**3*dot(A,c**5)))-1/660.
    coneq[451]=dot(b,dot(A,c**3*dot(A,dot(A,c**4))))-1/3300.
    coneq[452]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**3)))))-1/13200.
    coneq[453]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/39600.
    coneq[454]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/79200.
    coneq[455]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/26400.
    coneq[456]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c**2)))))-1/9900.
    coneq[457]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/19800.
    coneq[458]=dot(b,dot(A,c**3*dot(A,dot(A,c**2*dot(A,c)))))-1/6600.
    coneq[459]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/13200.
    coneq[460]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**3))))-1/2640.
    coneq[461]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c**2)))))-1/7920.
    coneq[462]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/15840.
    coneq[463]=dot(b,dot(A,c**3*dot(A,c*dot(A,c*dot(A,c)))))-1/5280.
    coneq[464]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c**2))))-1/1980.
    coneq[465]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,dot(A,c)))))-1/3960.
    coneq[466]=dot(b,dot(A,c**3*dot(A,c**3*dot(A,c))))-1/1320.
    coneq[467]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c**2))))-1/3960.
    coneq[468]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/7920.
    coneq[469]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,c))))-1/2640.
    coneq[470]=dot(b,dot(A,c**4*dot(A,c**4)))-1/550.
    coneq[471]=dot(b,dot(A,c**4*dot(A,dot(A,c**3))))-1/2200.
    coneq[472]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c**2)))))-1/6600.
    coneq[473]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,c))))))-1/13200.
    coneq[474]=dot(b,dot(A,c**4*dot(A,dot(A,c*dot(A,c)))))-1/4400.
    coneq[475]=dot(b,dot(A,c**4*dot(A,c*dot(A,c**2))))-1/1650.
    coneq[476]=dot(b,dot(A,c**4*dot(A,c*dot(A,dot(A,c)))))-1/3300.
    coneq[477]=dot(b,dot(A,c**4*dot(A,c**2*dot(A,c))))-1/1100.
    coneq[478]=dot(b,dot(A,c**4*dot(A,dot(A,c)*dot(A,c))))-1/2200.
    coneq[479]=dot(b,dot(A,c**5*dot(A,c**3)))-1/440.
    coneq[480]=dot(b,dot(A,c**5*dot(A,dot(A,c**2))))-1/1320.
    coneq[481]=dot(b,dot(A,c**5*dot(A,dot(A,dot(A,c)))))-1/2640.
    coneq[482]=dot(b,dot(A,c**5*dot(A,c*dot(A,c))))-1/880.
    coneq[483]=dot(b,dot(A,c**6*dot(A,c**2)))-1/330.
    coneq[484]=dot(b,dot(A,c**6*dot(A,dot(A,c))))-1/660.
    coneq[485]=dot(b,dot(A,c**7*dot(A,c)))-1/220.
    coneq[486]=dot(b,dot(A,dot(A,c**3)*dot(A,c**4)))-1/2200.
    coneq[487]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**3))))-1/8800.
    coneq[488]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c**2)))))-1/26400.
    coneq[489]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c))))))-1/52800.
    coneq[490]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,c)))))-1/17600.
    coneq[491]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c**2))))-1/6600.
    coneq[492]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,c)))))-1/13200.
    coneq[493]=dot(b,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,c))))-1/4400.
    coneq[494]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,c))))-1/8800.
    coneq[495]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**4)))-1/6600.
    coneq[496]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**3))))-1/26400.
    coneq[497]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**2)))))-1/79200.
    coneq[498]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c))))))-1/158400.
    coneq[499]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c)))))-1/52800.
    coneq[500]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c**2))))-1/19800.
    coneq[501]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c)))))-1/39600.
    coneq[502]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c))))-1/13200.
    coneq[503]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c))))-1/26400.
    coneq[504]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**4)))-1/13200.
    coneq[505]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**3))))-1/52800.
    coneq[506]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2)))))-1/158400.
    coneq[507]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c))))))-1/316800.
    coneq[508]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c)))))-1/105600.
    coneq[509]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**2))))-1/39600.
    coneq[510]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c)))))-1/79200.
    coneq[511]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c))))-1/26400.
    coneq[512]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c))))-1/52800.
    coneq[513]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**4)))-1/4400.
    coneq[514]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**3))))-1/17600.
    coneq[515]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**2)))))-1/52800.
    coneq[516]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))-1/105600.
    coneq[517]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c)))))-1/35200.
    coneq[518]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c**2))))-1/13200.
    coneq[519]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c)))))-1/26400.
    coneq[520]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c))))-1/8800.
    coneq[521]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/17600.
    coneq[522]=dot(b,dot(A,dot(A,c**2)*dot(A,c**5)))-1/1980.
    coneq[523]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**4))))-1/9900.
    coneq[524]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**3)))))-1/39600.
    coneq[525]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/118800.
    coneq[526]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/237600.
    coneq[527]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/79200.
    coneq[528]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c**2)))))-1/29700.
    coneq[529]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/59400.
    coneq[530]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c)))))-1/19800.
    coneq[531]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/39600.
    coneq[532]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**3))))-1/7920.
    coneq[533]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c**2)))))-1/23760.
    coneq[534]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/47520.
    coneq[535]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c)))))-1/15840.
    coneq[536]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c**2))))-1/5940.
    coneq[537]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c)))))-1/11880.
    coneq[538]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,c))))-1/3960.
    coneq[539]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**2))))-1/11880.
    coneq[540]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/23760.
    coneq[541]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c))))-1/7920.
    coneq[542]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**5)))-1/3960.
    coneq[543]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**4))))-1/19800.
    coneq[544]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**3)))))-1/79200.
    coneq[545]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/237600.
    coneq[546]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/475200.
    coneq[547]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/158400.
    coneq[548]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**2)))))-1/59400.
    coneq[549]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/118800.
    coneq[550]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c)))))-1/39600.
    coneq[551]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/79200.
    coneq[552]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**3))))-1/15840.
    coneq[553]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**2)))))-1/47520.
    coneq[554]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/95040.
    coneq[555]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c)))))-1/31680.
    coneq[556]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c**2))))-1/11880.
    coneq[557]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c)))))-1/23760.
    coneq[558]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,c))))-1/7920.
    coneq[559]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**2))))-1/23760.
    coneq[560]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/47520.
    coneq[561]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c))))-1/15840.
    coneq[562]=dot(b,dot(A,dot(A,c)*dot(A,c**6)))-1/1540.
    coneq[563]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**5))))-1/9240.
    coneq[564]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**4)))))-1/46200.
    coneq[565]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/184800.
    coneq[566]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/554400.
    coneq[567]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1108800.
    coneq[568]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/369600.
    coneq[569]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/138600.
    coneq[570]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/277200.
    coneq[571]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/92400.
    coneq[572]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/184800.
    coneq[573]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**3)))))-1/36960.
    coneq[574]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/110880.
    coneq[575]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/221760.
    coneq[576]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/73920.
    coneq[577]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c**2)))))-1/27720.
    coneq[578]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/55440.
    coneq[579]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,c)))))-1/18480.
    coneq[580]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/55440.
    coneq[581]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/110880.
    coneq[582]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/36960.
    coneq[583]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**4))))-1/7700.
    coneq[584]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**3)))))-1/30800.
    coneq[585]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/92400.
    coneq[586]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/184800.
    coneq[587]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/61600.
    coneq[588]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c**2)))))-1/23100.
    coneq[589]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/46200.
    coneq[590]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c)))))-1/15400.
    coneq[591]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/30800.
    coneq[592]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**3))))-1/6160.
    coneq[593]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c**2)))))-1/18480.
    coneq[594]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/36960.
    coneq[595]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c)))))-1/12320.
    coneq[596]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c**2))))-1/4620.
    coneq[597]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,c)))))-1/9240.
    coneq[598]=dot(b,dot(A,dot(A,c)*dot(A,c**4*dot(A,c))))-1/3080.
    coneq[599]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**2))))-1/13860.
    coneq[600]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/27720.
    coneq[601]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/55440.
    coneq[602]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**3))))-1/12320.
    coneq[603]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/36960.
    coneq[604]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/73920.
    coneq[605]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/24640.
    coneq[606]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**2))))-1/9240.
    coneq[607]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/18480.
    coneq[608]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c))))-1/6160.
    coneq[609]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/12320.
    coneq[610]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c**3)))-1/1760.
    coneq[611]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c**2))))-1/5280.
    coneq[612]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,c)))))-1/10560.
    coneq[613]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,c))))-1/3520.
    coneq[614]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c**2))))-1/15840.
    coneq[615]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)))))-1/31680.
    coneq[616]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,c))))-1/10560.
    coneq[617]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))))-1/63360.
    coneq[618]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c))))-1/21120.
    coneq[619]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,c))))-1/7040.
    coneq[620]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**4)))-1/1650.
    coneq[621]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**3))))-1/6600.
    coneq[622]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c**2)))))-1/19800.
    coneq[623]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))))))-1/39600.
    coneq[624]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,c)))))-1/13200.
    coneq[625]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c**2))))-1/4950.
    coneq[626]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,c)))))-1/9900.
    coneq[627]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,c))))-1/3300.
    coneq[628]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c))))-1/6600.
    coneq[629]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**4)))-1/3300.
    coneq[630]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**3))))-1/13200.
    coneq[631]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)))))-1/39600.
    coneq[632]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))-1/79200.
    coneq[633]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)))))-1/26400.
    coneq[634]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c**2))))-1/9900.
    coneq[635]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)))))-1/19800.
    coneq[636]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,c))))-1/6600.
    coneq[637]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/13200.
    coneq[638]=dot(b,dot(A,c*dot(A,c)*dot(A,c**5)))-1/1320.
    coneq[639]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**4))))-1/6600.
    coneq[640]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**3)))))-1/26400.
    coneq[641]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/79200.
    coneq[642]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/158400.
    coneq[643]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/52800.
    coneq[644]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c**2)))))-1/19800.
    coneq[645]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/39600.
    coneq[646]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,c)))))-1/13200.
    coneq[647]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/26400.
    coneq[648]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**3))))-1/5280.
    coneq[649]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c**2)))))-1/15840.
    coneq[650]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/31680.
    coneq[651]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,c)))))-1/10560.
    coneq[652]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c**2))))-1/3960.
    coneq[653]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,c)))))-1/7920.
    coneq[654]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,c))))-1/2640.
    coneq[655]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c**2))))-1/7920.
    coneq[656]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/15840.
    coneq[657]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c))))-1/5280.
    coneq[658]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**3)))-1/1320.
    coneq[659]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c**2))))-1/3960.
    coneq[660]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))-1/7920.
    coneq[661]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,c))))-1/2640.
    coneq[662]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**3)))-1/2640.
    coneq[663]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c**2))))-1/7920.
    coneq[664]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))-1/15840.
    coneq[665]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,c))))-1/5280.
    coneq[666]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**4)))-1/1100.
    coneq[667]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**3))))-1/4400.
    coneq[668]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))-1/13200.
    coneq[669]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))-1/26400.
    coneq[670]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))-1/8800.
    coneq[671]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c**2))))-1/3300.
    coneq[672]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))-1/6600.
    coneq[673]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,c))))-1/2200.
    coneq[674]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))-1/4400.
    coneq[675]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,c**2)))-1/990.
    coneq[676]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,c))))-1/1980.
    coneq[677]=dot(b,dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/3960.
    coneq[678]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c**3)))-1/880.
    coneq[679]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,c**2))))-1/2640.
    coneq[680]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,dot(A,c)))))-1/5280.
    coneq[681]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c*dot(A,c))))-1/1760.
    coneq[682]=dot(b,dot(A,c**4*dot(A,c)*dot(A,c**2)))-1/660.
    coneq[683]=dot(b,dot(A,c**4*dot(A,c)*dot(A,dot(A,c))))-1/1320.
    coneq[684]=dot(b,dot(A,c**5*dot(A,c)*dot(A,c)))-1/440.
    coneq[685]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**4)))-1/2200.
    coneq[686]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**3))))-1/8800.
    coneq[687]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))-1/26400.
    coneq[688]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))-1/52800.
    coneq[689]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))-1/17600.
    coneq[690]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c**2))))-1/6600.
    coneq[691]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))-1/13200.
    coneq[692]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,c))))-1/4400.
    coneq[693]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))-1/8800.
    coneq[694]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**3)))-1/2640.
    coneq[695]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c**2))))-1/7920.
    coneq[696]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))-1/15840.
    coneq[697]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,c))))-1/5280.
    coneq[698]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c**3)))-1/5280.
    coneq[699]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c**2))))-1/15840.
    coneq[700]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))-1/31680.
    coneq[701]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,c))))-1/10560.
    coneq[702]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,c**2)))-1/2970.
    coneq[703]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,c))))-1/5940.
    coneq[704]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/11880.
    coneq[705]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/23760.
    coneq[706]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**3)))-1/1760.
    coneq[707]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c**2))))-1/5280.
    coneq[708]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)))))-1/10560.
    coneq[709]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c))))-1/3520.
    coneq[710]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,c**2)))-1/1980.
    coneq[711]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c))))-1/3960.
    coneq[712]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/7920.
    coneq[713]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c**2)))-1/1320.
    coneq[714]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))-1/2640.
    coneq[715]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c)*dot(A,c)))-1/880.
    coneq[716]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c**2)))-1/2640.
    coneq[717]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))-1/5280.
    coneq[718]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)))-1/1760.
    coneq[719]=dot(b,dot(A,c**8)*c)-1/99.
    coneq[720]=dot(b,dot(A,dot(A,c**7))*c)-1/792.
    coneq[721]=dot(b,dot(A,dot(A,dot(A,c**6)))*c)-1/5544.
    coneq[722]=dot(b,dot(A,dot(A,dot(A,dot(A,c**5))))*c)-1/33264.
    coneq[723]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**4)))))*c)-1/166320.
    coneq[724]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))*c)-1/665280.
    coneq[725]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))*c)-1/1995840.
    coneq[726]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))*c)-1/3991680.
    coneq[727]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))*c)-1/1330560.
    coneq[728]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))*c)-1/498960.
    coneq[729]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))*c)-1/997920.
    coneq[730]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))*c)-1/332640.
    coneq[731]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))*c)-1/665280.
    coneq[732]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3)))))*c)-1/133056.
    coneq[733]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))*c)-1/399168.
    coneq[734]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))*c)-1/798336.
    coneq[735]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))*c)-1/266112.
    coneq[736]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))*c)-1/99792.
    coneq[737]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))*c)-1/199584.
    coneq[738]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)))))*c)-1/66528.
    coneq[739]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))*c)-1/199584.
    coneq[740]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))*c)-1/399168.
    coneq[741]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))*c)-1/133056.
    coneq[742]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**4))))*c)-1/27720.
    coneq[743]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3)))))*c)-1/110880.
    coneq[744]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))*c)-1/332640.
    coneq[745]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/665280.
    coneq[746]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))*c)-1/221760.
    coneq[747]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))*c)-1/83160.
    coneq[748]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))*c)-1/166320.
    coneq[749]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))*c)-1/55440.
    coneq[750]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))*c)-1/110880.
    coneq[751]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**3))))*c)-1/22176.
    coneq[752]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))*c)-1/66528.
    coneq[753]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))*c)-1/133056.
    coneq[754]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))*c)-1/44352.
    coneq[755]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**2))))*c)-1/16632.
    coneq[756]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)))))*c)-1/33264.
    coneq[757]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c))))*c)-1/11088.
    coneq[758]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))*c)-1/49896.
    coneq[759]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))*c)-1/99792.
    coneq[760]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))*c)-1/199584.
    coneq[761]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3))))*c)-1/44352.
    coneq[762]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))*c)-1/133056.
    coneq[763]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))*c)-1/266112.
    coneq[764]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))*c)-1/88704.
    coneq[765]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))*c)-1/33264.
    coneq[766]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))*c)-1/66528.
    coneq[767]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))*c)-1/22176.
    coneq[768]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))*c)-1/44352.
    coneq[769]=dot(b,dot(A,dot(A,c*dot(A,c**5)))*c)-1/4752.
    coneq[770]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**4))))*c)-1/23760.
    coneq[771]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3)))))*c)-1/95040.
    coneq[772]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))*c)-1/285120.
    coneq[773]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/570240.
    coneq[774]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))*c)-1/190080.
    coneq[775]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))*c)-1/71280.
    coneq[776]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))*c)-1/142560.
    coneq[777]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))*c)-1/47520.
    coneq[778]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))*c)-1/95040.
    coneq[779]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**3))))*c)-1/19008.
    coneq[780]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))*c)-1/57024.
    coneq[781]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))*c)-1/114048.
    coneq[782]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))*c)-1/38016.
    coneq[783]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2))))*c)-1/14256.
    coneq[784]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))*c)-1/28512.
    coneq[785]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c))))*c)-1/9504.
    coneq[786]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))*c)-1/28512.
    coneq[787]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))*c)-1/57024.
    coneq[788]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))*c)-1/19008.
    coneq[789]=dot(b,dot(A,dot(A,c**2*dot(A,c**4)))*c)-1/3960.
    coneq[790]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**3))))*c)-1/15840.
    coneq[791]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))*c)-1/47520.
    coneq[792]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/95040.
    coneq[793]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))*c)-1/31680.
    coneq[794]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2))))*c)-1/11880.
    coneq[795]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))*c)-1/23760.
    coneq[796]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c))))*c)-1/7920.
    coneq[797]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))*c)-1/15840.
    coneq[798]=dot(b,dot(A,dot(A,c**3*dot(A,c**3)))*c)-1/3168.
    coneq[799]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**2))))*c)-1/9504.
    coneq[800]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)))))*c)-1/19008.
    coneq[801]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c))))*c)-1/6336.
    coneq[802]=dot(b,dot(A,dot(A,c**4*dot(A,c**2)))*c)-1/2376.
    coneq[803]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c))))*c)-1/4752.
    coneq[804]=dot(b,dot(A,dot(A,c**5*dot(A,c)))*c)-1/1584.
    coneq[805]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**3)))*c)-1/9504.
    coneq[806]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))*c)-1/28512.
    coneq[807]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))*c)-1/57024.
    coneq[808]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))*c)-1/19008.
    coneq[809]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3)))*c)-1/19008.
    coneq[810]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))*c)-1/57024.
    coneq[811]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))*c)-1/114048.
    coneq[812]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))*c)-1/38016.
    coneq[813]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**4)))*c)-1/7920.
    coneq[814]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3))))*c)-1/31680.
    coneq[815]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))*c)-1/95040.
    coneq[816]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/190080.
    coneq[817]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))*c)-1/63360.
    coneq[818]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))*c)-1/23760.
    coneq[819]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))*c)-1/47520.
    coneq[820]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))*c)-1/15840.
    coneq[821]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))*c)-1/31680.
    coneq[822]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2)))*c)-1/7128.
    coneq[823]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))*c)-1/14256.
    coneq[824]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))*c)-1/28512.
    coneq[825]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**3)))*c)-1/6336.
    coneq[826]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))*c)-1/19008.
    coneq[827]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))*c)-1/38016.
    coneq[828]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))*c)-1/12672.
    coneq[829]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2)))*c)-1/4752.
    coneq[830]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))*c)-1/9504.
    coneq[831]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c)))*c)-1/3168.
    coneq[832]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))*c)-1/9504.
    coneq[833]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))*c)-1/19008.
    coneq[834]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))*c)-1/6336.
    coneq[835]=dot(b,dot(A,c*dot(A,c**6))*c)-1/693.
    coneq[836]=dot(b,dot(A,c*dot(A,dot(A,c**5)))*c)-1/4158.
    coneq[837]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**4))))*c)-1/20790.
    coneq[838]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3)))))*c)-1/83160.
    coneq[839]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*c)-1/249480.
    coneq[840]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/498960.
    coneq[841]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*c)-1/166320.
    coneq[842]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2)))))*c)-1/62370.
    coneq[843]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*c)-1/124740.
    coneq[844]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)))))*c)-1/41580.
    coneq[845]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*c)-1/83160.
    coneq[846]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**3))))*c)-1/16632.
    coneq[847]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2)))))*c)-1/49896.
    coneq[848]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*c)-1/99792.
    coneq[849]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)))))*c)-1/33264.
    coneq[850]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2))))*c)-1/12474.
    coneq[851]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)))))*c)-1/24948.
    coneq[852]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c))))*c)-1/8316.
    coneq[853]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2))))*c)-1/24948.
    coneq[854]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*c)-1/49896.
    coneq[855]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c))))*c)-1/16632.
    coneq[856]=dot(b,dot(A,c*dot(A,c*dot(A,c**4)))*c)-1/3465.
    coneq[857]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**3))))*c)-1/13860.
    coneq[858]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2)))))*c)-1/41580.
    coneq[859]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/83160.
    coneq[860]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)))))*c)-1/27720.
    coneq[861]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2))))*c)-1/10395.
    coneq[862]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)))))*c)-1/20790.
    coneq[863]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c))))*c)-1/6930.
    coneq[864]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c))))*c)-1/13860.
    coneq[865]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**3)))*c)-1/2772.
    coneq[866]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2))))*c)-1/8316.
    coneq[867]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)))))*c)-1/16632.
    coneq[868]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c))))*c)-1/5544.
    coneq[869]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**2)))*c)-1/2079.
    coneq[870]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c))))*c)-1/4158.
    coneq[871]=dot(b,dot(A,c*dot(A,c**4*dot(A,c)))*c)-1/1386.
    coneq[872]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2)))*c)-1/6237.
    coneq[873]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c))))*c)-1/12474.
    coneq[874]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*c)-1/24948.
    coneq[875]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**3)))*c)-1/5544.
    coneq[876]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2))))*c)-1/16632.
    coneq[877]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*c)-1/33264.
    coneq[878]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c))))*c)-1/11088.
    coneq[879]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2)))*c)-1/4158.
    coneq[880]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c))))*c)-1/8316.
    coneq[881]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)))*c)-1/2772.
    coneq[882]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*c)-1/5544.
    coneq[883]=dot(b,dot(A,c**2*dot(A,c**5))*c)-1/594.
    coneq[884]=dot(b,dot(A,c**2*dot(A,dot(A,c**4)))*c)-1/2970.
    coneq[885]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**3))))*c)-1/11880.
    coneq[886]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2)))))*c)-1/35640.
    coneq[887]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/71280.
    coneq[888]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)))))*c)-1/23760.
    coneq[889]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2))))*c)-1/8910.
    coneq[890]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)))))*c)-1/17820.
    coneq[891]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c))))*c)-1/5940.
    coneq[892]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c))))*c)-1/11880.
    coneq[893]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**3)))*c)-1/2376.
    coneq[894]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2))))*c)-1/7128.
    coneq[895]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)))))*c)-1/14256.
    coneq[896]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c))))*c)-1/4752.
    coneq[897]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**2)))*c)-1/1782.
    coneq[898]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c))))*c)-1/3564.
    coneq[899]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c)))*c)-1/1188.
    coneq[900]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2)))*c)-1/3564.
    coneq[901]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c))))*c)-1/7128.
    coneq[902]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)))*c)-1/2376.
    coneq[903]=dot(b,dot(A,c**3*dot(A,c**4))*c)-1/495.
    coneq[904]=dot(b,dot(A,c**3*dot(A,dot(A,c**3)))*c)-1/1980.
    coneq[905]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**2))))*c)-1/5940.
    coneq[906]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/11880.
    coneq[907]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c))))*c)-1/3960.
    coneq[908]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**2)))*c)-1/1485.
    coneq[909]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c))))*c)-1/2970.
    coneq[910]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c)))*c)-1/990.
    coneq[911]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c)))*c)-1/1980.
    coneq[912]=dot(b,dot(A,c**4*dot(A,c**3))*c)-1/396.
    coneq[913]=dot(b,dot(A,c**4*dot(A,dot(A,c**2)))*c)-1/1188.
    coneq[914]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c))))*c)-1/2376.
    coneq[915]=dot(b,dot(A,c**4*dot(A,c*dot(A,c)))*c)-1/792.
    coneq[916]=dot(b,dot(A,c**5*dot(A,c**2))*c)-1/297.
    coneq[917]=dot(b,dot(A,c**5*dot(A,dot(A,c)))*c)-1/594.
    coneq[918]=dot(b,dot(A,c**6*dot(A,c))*c)-1/198.
    coneq[919]=dot(b,dot(A,dot(A,c**3)*dot(A,c**3))*c)-1/1584.
    coneq[920]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**2)))*c)-1/4752.
    coneq[921]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c))))*c)-1/9504.
    coneq[922]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c)))*c)-1/3168.
    coneq[923]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))*c)-1/14256.
    coneq[924]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))*c)-1/28512.
    coneq[925]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))*c)-1/9504.
    coneq[926]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))*c)-1/57024.
    coneq[927]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))*c)-1/19008.
    coneq[928]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))*c)-1/6336.
    coneq[929]=dot(b,dot(A,dot(A,c**2)*dot(A,c**4))*c)-1/1485.
    coneq[930]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**3)))*c)-1/5940.
    coneq[931]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))*c)-1/17820.
    coneq[932]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/35640.
    coneq[933]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))*c)-1/11880.
    coneq[934]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2)))*c)-1/4455.
    coneq[935]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))*c)-1/8910.
    coneq[936]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)))*c)-1/2970.
    coneq[937]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))*c)-1/5940.
    coneq[938]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**4))*c)-1/2970.
    coneq[939]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3)))*c)-1/11880.
    coneq[940]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))*c)-1/35640.
    coneq[941]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/71280.
    coneq[942]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))*c)-1/23760.
    coneq[943]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))*c)-1/8910.
    coneq[944]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))*c)-1/17820.
    coneq[945]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))*c)-1/5940.
    coneq[946]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))*c)-1/11880.
    coneq[947]=dot(b,dot(A,dot(A,c)*dot(A,c**5))*c)-1/1188.
    coneq[948]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**4)))*c)-1/5940.
    coneq[949]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3))))*c)-1/23760.
    coneq[950]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))*c)-1/71280.
    coneq[951]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/142560.
    coneq[952]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))*c)-1/47520.
    coneq[953]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))*c)-1/17820.
    coneq[954]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))*c)-1/35640.
    coneq[955]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))*c)-1/11880.
    coneq[956]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))*c)-1/23760.
    coneq[957]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**3)))*c)-1/4752.
    coneq[958]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))*c)-1/14256.
    coneq[959]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))*c)-1/28512.
    coneq[960]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))*c)-1/9504.
    coneq[961]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2)))*c)-1/3564.
    coneq[962]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))*c)-1/7128.
    coneq[963]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c)))*c)-1/2376.
    coneq[964]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))*c)-1/7128.
    coneq[965]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))*c)-1/14256.
    coneq[966]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))*c)-1/4752.
    coneq[967]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**3))*c)-1/1188.
    coneq[968]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2)))*c)-1/3564.
    coneq[969]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c))))*c)-1/7128.
    coneq[970]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)))*c)-1/2376.
    coneq[971]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**3))*c)-1/2376.
    coneq[972]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2)))*c)-1/7128.
    coneq[973]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*c)-1/14256.
    coneq[974]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)))*c)-1/4752.
    coneq[975]=dot(b,dot(A,c*dot(A,c)*dot(A,c**4))*c)-1/990.
    coneq[976]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**3)))*c)-1/3960.
    coneq[977]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2))))*c)-1/11880.
    coneq[978]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/23760.
    coneq[979]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c))))*c)-1/7920.
    coneq[980]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2)))*c)-1/2970.
    coneq[981]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c))))*c)-1/5940.
    coneq[982]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)))*c)-1/1980.
    coneq[983]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*c)-1/3960.
    coneq[984]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**2))*c)-1/891.
    coneq[985]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)))*c)-1/1782.
    coneq[986]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)))*c)-1/3564.
    coneq[987]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**3))*c)-1/792.
    coneq[988]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2)))*c)-1/2376.
    coneq[989]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c))))*c)-1/4752.
    coneq[990]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)))*c)-1/1584.
    coneq[991]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c**2))*c)-1/594.
    coneq[992]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,c)))*c)-1/1188.
    coneq[993]=dot(b,dot(A,c**4*dot(A,c)*dot(A,c))*c)-1/396.
    coneq[994]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3))*c)-1/1584.
    coneq[995]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))*c)-1/4752.
    coneq[996]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))*c)-1/9504.
    coneq[997]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))*c)-1/3168.
    coneq[998]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2))*c)-1/1782.
    coneq[999]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))*c)-1/3564.
    coneq[1000]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))*c)-1/7128.
    coneq[1001]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2))*c)-1/1188.
    coneq[1002]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*c)-1/2376.
    coneq[1003]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c))*c)-1/792.
    coneq[1004]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))*c)-1/1584.
    coneq[1005]=dot(b,dot(A,c**7)*c*c)-1/88.
    coneq[1006]=dot(b,dot(A,dot(A,c**6))*c*c)-1/616.
    coneq[1007]=dot(b,dot(A,dot(A,dot(A,c**5)))*c*c)-1/3696.
    coneq[1008]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4))))*c*c)-1/18480.
    coneq[1009]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))*c*c)-1/73920.
    coneq[1010]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*c*c)-1/221760.
    coneq[1011]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c*c)-1/443520.
    coneq[1012]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*c*c)-1/147840.
    coneq[1013]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))*c*c)-1/55440.
    coneq[1014]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*c*c)-1/110880.
    coneq[1015]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))*c*c)-1/36960.
    coneq[1016]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*c*c)-1/73920.
    coneq[1017]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3))))*c*c)-1/14784.
    coneq[1018]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))*c*c)-1/44352.
    coneq[1019]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*c*c)-1/88704.
    coneq[1020]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))*c*c)-1/29568.
    coneq[1021]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))*c*c)-1/11088.
    coneq[1022]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))*c*c)-1/22176.
    coneq[1023]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c))))*c*c)-1/7392.
    coneq[1024]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))*c*c)-1/22176.
    coneq[1025]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*c*c)-1/44352.
    coneq[1026]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))*c*c)-1/14784.
    coneq[1027]=dot(b,dot(A,dot(A,c*dot(A,c**4)))*c*c)-1/3080.
    coneq[1028]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3))))*c*c)-1/12320.
    coneq[1029]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))*c*c)-1/36960.
    coneq[1030]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*c*c)-1/73920.
    coneq[1031]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))*c*c)-1/24640.
    coneq[1032]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))*c*c)-1/9240.
    coneq[1033]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))*c*c)-1/18480.
    coneq[1034]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))*c*c)-1/6160.
    coneq[1035]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))*c*c)-1/12320.
    coneq[1036]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)))*c*c)-1/2464.
    coneq[1037]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))*c*c)-1/7392.
    coneq[1038]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))*c*c)-1/14784.
    coneq[1039]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))*c*c)-1/4928.
    coneq[1040]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)))*c*c)-1/1848.
    coneq[1041]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))))*c*c)-1/3696.
    coneq[1042]=dot(b,dot(A,dot(A,c**4*dot(A,c)))*c*c)-1/1232.
    coneq[1043]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))*c*c)-1/5544.
    coneq[1044]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))*c*c)-1/11088.
    coneq[1045]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*c*c)-1/22176.
    coneq[1046]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)))*c*c)-1/4928.
    coneq[1047]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))*c*c)-1/14784.
    coneq[1048]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*c*c)-1/29568.
    coneq[1049]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))*c*c)-1/9856.
    coneq[1050]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))*c*c)-1/3696.
    coneq[1051]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))*c*c)-1/7392.
    coneq[1052]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))*c*c)-1/2464.
    coneq[1053]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*c*c)-1/4928.
    coneq[1054]=dot(b,dot(A,c*dot(A,c**5))*c*c)-1/528.
    coneq[1055]=dot(b,dot(A,c*dot(A,dot(A,c**4)))*c*c)-1/2640.
    coneq[1056]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3))))*c*c)-1/10560.
    coneq[1057]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))*c*c)-1/31680.
    coneq[1058]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c*c)-1/63360.
    coneq[1059]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))*c*c)-1/21120.
    coneq[1060]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))*c*c)-1/7920.
    coneq[1061]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))*c*c)-1/15840.
    coneq[1062]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))*c*c)-1/5280.
    coneq[1063]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))*c*c)-1/10560.
    coneq[1064]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)))*c*c)-1/2112.
    coneq[1065]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))*c*c)-1/6336.
    coneq[1066]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))*c*c)-1/12672.
    coneq[1067]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))*c*c)-1/4224.
    coneq[1068]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)))*c*c)-1/1584.
    coneq[1069]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))*c*c)-1/3168.
    coneq[1070]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)))*c*c)-1/1056.
    coneq[1071]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))*c*c)-1/3168.
    coneq[1072]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))*c*c)-1/6336.
    coneq[1073]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))*c*c)-1/2112.
    coneq[1074]=dot(b,dot(A,c**2*dot(A,c**4))*c*c)-1/440.
    coneq[1075]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)))*c*c)-1/1760.
    coneq[1076]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))*c*c)-1/5280.
    coneq[1077]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))*c*c)-1/10560.
    coneq[1078]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))*c*c)-1/3520.
    coneq[1079]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)))*c*c)-1/1320.
    coneq[1080]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))*c*c)-1/2640.
    coneq[1081]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)))*c*c)-1/880.
    coneq[1082]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))*c*c)-1/1760.
    coneq[1083]=dot(b,dot(A,c**3*dot(A,c**3))*c*c)-1/352.
    coneq[1084]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)))*c*c)-1/1056.
    coneq[1085]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))))*c*c)-1/2112.
    coneq[1086]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)))*c*c)-1/704.
    coneq[1087]=dot(b,dot(A,c**4*dot(A,c**2))*c*c)-1/264.
    coneq[1088]=dot(b,dot(A,c**4*dot(A,dot(A,c)))*c*c)-1/528.
    coneq[1089]=dot(b,dot(A,c**5*dot(A,c))*c*c)-1/176.
    coneq[1090]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3))*c*c)-1/1056.
    coneq[1091]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))*c*c)-1/3168.
    coneq[1092]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))*c*c)-1/6336.
    coneq[1093]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))*c*c)-1/2112.
    coneq[1094]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3))*c*c)-1/2112.
    coneq[1095]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))*c*c)-1/6336.
    coneq[1096]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*c*c)-1/12672.
    coneq[1097]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))*c*c)-1/4224.
    coneq[1098]=dot(b,dot(A,dot(A,c)*dot(A,c**4))*c*c)-1/880.
    coneq[1099]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)))*c*c)-1/3520.
    coneq[1100]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))*c*c)-1/10560.
    coneq[1101]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*c*c)-1/21120.
    coneq[1102]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))*c*c)-1/7040.
    coneq[1103]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))*c*c)-1/2640.
    coneq[1104]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))*c*c)-1/5280.
    coneq[1105]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))*c*c)-1/1760.
    coneq[1106]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*c*c)-1/3520.
    coneq[1107]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2))*c*c)-1/792.
    coneq[1108]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))*c*c)-1/1584.
    coneq[1109]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))*c*c)-1/3168.
    coneq[1110]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3))*c*c)-1/704.
    coneq[1111]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))*c*c)-1/2112.
    coneq[1112]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))*c*c)-1/4224.
    coneq[1113]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))*c*c)-1/1408.
    coneq[1114]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2))*c*c)-1/528.
    coneq[1115]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))*c*c)-1/1056.
    coneq[1116]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c))*c*c)-1/352.
    coneq[1117]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))*c*c)-1/1056.
    coneq[1118]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*c*c)-1/2112.
    coneq[1119]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))*c*c)-1/704.
    coneq[1120]=dot(b,dot(A,c**6)*c**3)-1/77.
    coneq[1121]=dot(b,dot(A,dot(A,c**5))*c**3)-1/462.
    coneq[1122]=dot(b,dot(A,dot(A,dot(A,c**4)))*c**3)-1/2310.
    coneq[1123]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*c**3)-1/9240.
    coneq[1124]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*c**3)-1/27720.
    coneq[1125]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c**3)-1/55440.
    coneq[1126]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*c**3)-1/18480.
    coneq[1127]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*c**3)-1/6930.
    coneq[1128]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*c**3)-1/13860.
    coneq[1129]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*c**3)-1/4620.
    coneq[1130]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*c**3)-1/9240.
    coneq[1131]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*c**3)-1/1848.
    coneq[1132]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*c**3)-1/5544.
    coneq[1133]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*c**3)-1/11088.
    coneq[1134]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*c**3)-1/3696.
    coneq[1135]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*c**3)-1/1386.
    coneq[1136]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*c**3)-1/2772.
    coneq[1137]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*c**3)-1/924.
    coneq[1138]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*c**3)-1/2772.
    coneq[1139]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*c**3)-1/5544.
    coneq[1140]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*c**3)-1/1848.
    coneq[1141]=dot(b,dot(A,c*dot(A,c**4))*c**3)-1/385.
    coneq[1142]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*c**3)-1/1540.
    coneq[1143]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*c**3)-1/4620.
    coneq[1144]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*c**3)-1/9240.
    coneq[1145]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*c**3)-1/3080.
    coneq[1146]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*c**3)-1/1155.
    coneq[1147]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*c**3)-1/2310.
    coneq[1148]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*c**3)-1/770.
    coneq[1149]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*c**3)-1/1540.
    coneq[1150]=dot(b,dot(A,c**2*dot(A,c**3))*c**3)-1/308.
    coneq[1151]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*c**3)-1/924.
    coneq[1152]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*c**3)-1/1848.
    coneq[1153]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*c**3)-1/616.
    coneq[1154]=dot(b,dot(A,c**3*dot(A,c**2))*c**3)-1/231.
    coneq[1155]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*c**3)-1/462.
    coneq[1156]=dot(b,dot(A,c**4*dot(A,c))*c**3)-1/154.
    coneq[1157]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*c**3)-1/693.
    coneq[1158]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*c**3)-1/1386.
    coneq[1159]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*c**3)-1/2772.
    coneq[1160]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*c**3)-1/616.
    coneq[1161]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*c**3)-1/1848.
    coneq[1162]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*c**3)-1/3696.
    coneq[1163]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*c**3)-1/1232.
    coneq[1164]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*c**3)-1/462.
    coneq[1165]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*c**3)-1/924.
    coneq[1166]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*c**3)-1/308.
    coneq[1167]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*c**3)-1/616.
    coneq[1168]=dot(b,dot(A,c**5)*c**4)-1/66.
    coneq[1169]=dot(b,dot(A,dot(A,c**4))*c**4)-1/330.
    coneq[1170]=dot(b,dot(A,dot(A,dot(A,c**3)))*c**4)-1/1320.
    coneq[1171]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*c**4)-1/3960.
    coneq[1172]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*c**4)-1/7920.
    coneq[1173]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*c**4)-1/2640.
    coneq[1174]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*c**4)-1/990.
    coneq[1175]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*c**4)-1/1980.
    coneq[1176]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*c**4)-1/660.
    coneq[1177]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*c**4)-1/1320.
    coneq[1178]=dot(b,dot(A,c*dot(A,c**3))*c**4)-1/264.
    coneq[1179]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*c**4)-1/792.
    coneq[1180]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*c**4)-1/1584.
    coneq[1181]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*c**4)-1/528.
    coneq[1182]=dot(b,dot(A,c**2*dot(A,c**2))*c**4)-1/198.
    coneq[1183]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*c**4)-1/396.
    coneq[1184]=dot(b,dot(A,c**3*dot(A,c))*c**4)-1/132.
    coneq[1185]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*c**4)-1/396.
    coneq[1186]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*c**4)-1/792.
    coneq[1187]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*c**4)-1/264.
    coneq[1188]=dot(b,dot(A,c**4)*c**5)-1/55.
    coneq[1189]=dot(b,dot(A,dot(A,c**3))*c**5)-1/220.
    coneq[1190]=dot(b,dot(A,dot(A,dot(A,c**2)))*c**5)-1/660.
    coneq[1191]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*c**5)-1/1320.
    coneq[1192]=dot(b,dot(A,dot(A,c*dot(A,c)))*c**5)-1/440.
    coneq[1193]=dot(b,dot(A,c*dot(A,c**2))*c**5)-1/165.
    coneq[1194]=dot(b,dot(A,c*dot(A,dot(A,c)))*c**5)-1/330.
    coneq[1195]=dot(b,dot(A,c**2*dot(A,c))*c**5)-1/110.
    coneq[1196]=dot(b,dot(A,dot(A,c)*dot(A,c))*c**5)-1/220.
    coneq[1197]=dot(b,dot(A,c**3)*c**6)-1/44.
    coneq[1198]=dot(b,dot(A,dot(A,c**2))*c**6)-1/132.
    coneq[1199]=dot(b,dot(A,dot(A,dot(A,c)))*c**6)-1/264.
    coneq[1200]=dot(b,dot(A,c*dot(A,c))*c**6)-1/88.
    coneq[1201]=dot(b,dot(A,c**2)*c**7)-1/33.
    coneq[1202]=dot(b,dot(A,dot(A,c))*c**7)-1/66.
    coneq[1203]=dot(b,dot(A,c)*c**8)-1/22.
    coneq[1204]=dot(b,dot(A,c**4)*dot(A,c**4))-1/275.
    coneq[1205]=dot(b,dot(A,dot(A,c**3))*dot(A,c**4))-1/1100.
    coneq[1206]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**4))-1/3300.
    coneq[1207]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**4))-1/6600.
    coneq[1208]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**4))-1/2200.
    coneq[1209]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**4))-1/825.
    coneq[1210]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**4))-1/1650.
    coneq[1211]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**4))-1/550.
    coneq[1212]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**4))-1/1100.
    coneq[1213]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c**3)))-1/4400.
    coneq[1214]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c**3)))-1/13200.
    coneq[1215]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**3)))-1/26400.
    coneq[1216]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c**3)))-1/8800.
    coneq[1217]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c**3)))-1/3300.
    coneq[1218]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c**3)))-1/6600.
    coneq[1219]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c**3)))-1/2200.
    coneq[1220]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c**3)))-1/4400.
    coneq[1221]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c**2))))-1/39600.
    coneq[1222]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c**2))))-1/79200.
    coneq[1223]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c**2))))-1/26400.
    coneq[1224]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,c**2))))-1/9900.
    coneq[1225]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2))))-1/19800.
    coneq[1226]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,c**2))))-1/6600.
    coneq[1227]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c**2))))-1/13200.
    coneq[1228]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,dot(A,c)))))-1/158400.
    coneq[1229]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))-1/52800.
    coneq[1230]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c)))))-1/19800.
    coneq[1231]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))-1/39600.
    coneq[1232]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))-1/13200.
    coneq[1233]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))-1/26400.
    coneq[1234]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c*dot(A,c))))-1/17600.
    coneq[1235]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c*dot(A,c))))-1/6600.
    coneq[1236]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c))))-1/13200.
    coneq[1237]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c*dot(A,c))))-1/4400.
    coneq[1238]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c*dot(A,c))))-1/8800.
    coneq[1239]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c**2)))-1/2475.
    coneq[1240]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,c**2)))-1/4950.
    coneq[1241]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,c**2)))-1/1650.
    coneq[1242]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,c**2)))-1/3300.
    coneq[1243]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c))))-1/9900.
    coneq[1244]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,dot(A,c))))-1/3300.
    coneq[1245]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,dot(A,c))))-1/6600.
    coneq[1246]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**2*dot(A,c)))-1/1100.
    coneq[1247]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2*dot(A,c)))-1/2200.
    coneq[1248]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c)*dot(A,c)))-1/4400.
    coneq[1249]=dot(b,dot(A,c**5)*dot(A,c**3))-1/264.
    coneq[1250]=dot(b,dot(A,dot(A,c**4))*dot(A,c**3))-1/1320.
    coneq[1251]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c**3))-1/5280.
    coneq[1252]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c**3))-1/15840.
    coneq[1253]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**3))-1/31680.
    coneq[1254]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c**3))-1/10560.
    coneq[1255]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c**3))-1/3960.
    coneq[1256]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c**3))-1/7920.
    coneq[1257]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c**3))-1/2640.
    coneq[1258]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c**3))-1/5280.
    coneq[1259]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c**3))-1/1056.
    coneq[1260]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c**3))-1/3168.
    coneq[1261]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c**3))-1/6336.
    coneq[1262]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c**3))-1/2112.
    coneq[1263]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c**3))-1/792.
    coneq[1264]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c**3))-1/1584.
    coneq[1265]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c**3))-1/528.
    coneq[1266]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c**3))-1/1584.
    coneq[1267]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c**3))-1/3168.
    coneq[1268]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c**3))-1/1056.
    coneq[1269]=dot(b,dot(A,c**5)*dot(A,dot(A,c**2)))-1/792.
    coneq[1270]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,c**2)))-1/3960.
    coneq[1271]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,c**2)))-1/15840.
    coneq[1272]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c**2)))-1/47520.
    coneq[1273]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c**2)))-1/95040.
    coneq[1274]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c**2)))-1/31680.
    coneq[1275]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,c**2)))-1/11880.
    coneq[1276]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c**2)))-1/23760.
    coneq[1277]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,c**2)))-1/7920.
    coneq[1278]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c**2)))-1/15840.
    coneq[1279]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,c**2)))-1/3168.
    coneq[1280]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,c**2)))-1/9504.
    coneq[1281]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**2)))-1/19008.
    coneq[1282]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,c**2)))-1/6336.
    coneq[1283]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,c**2)))-1/2376.
    coneq[1284]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,c**2)))-1/4752.
    coneq[1285]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,c**2)))-1/1584.
    coneq[1286]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,c**2)))-1/4752.
    coneq[1287]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c**2)))-1/9504.
    coneq[1288]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,c**2)))-1/3168.
    coneq[1289]=dot(b,dot(A,c**5)*dot(A,dot(A,dot(A,c))))-1/1584.
    coneq[1290]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,dot(A,c))))-1/7920.
    coneq[1291]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,dot(A,c))))-1/31680.
    coneq[1292]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,dot(A,c))))-1/95040.
    coneq[1293]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,dot(A,c))))-1/190080.
    coneq[1294]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/63360.
    coneq[1295]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,dot(A,c))))-1/23760.
    coneq[1296]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/47520.
    coneq[1297]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/15840.
    coneq[1298]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/31680.
    coneq[1299]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,dot(A,c))))-1/6336.
    coneq[1300]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c))))-1/19008.
    coneq[1301]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/38016.
    coneq[1302]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/12672.
    coneq[1303]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,dot(A,c))))-1/4752.
    coneq[1304]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/9504.
    coneq[1305]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,dot(A,c))))-1/3168.
    coneq[1306]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,dot(A,c))))-1/9504.
    coneq[1307]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/19008.
    coneq[1308]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c))))-1/6336.
    coneq[1309]=dot(b,dot(A,c**5)*dot(A,c*dot(A,c)))-1/528.
    coneq[1310]=dot(b,dot(A,dot(A,c**4))*dot(A,c*dot(A,c)))-1/2640.
    coneq[1311]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c*dot(A,c)))-1/10560.
    coneq[1312]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c*dot(A,c)))-1/31680.
    coneq[1313]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c*dot(A,c)))-1/63360.
    coneq[1314]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c*dot(A,c)))-1/21120.
    coneq[1315]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c*dot(A,c)))-1/7920.
    coneq[1316]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c*dot(A,c)))-1/15840.
    coneq[1317]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c*dot(A,c)))-1/5280.
    coneq[1318]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c*dot(A,c)))-1/10560.
    coneq[1319]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c*dot(A,c)))-1/2112.
    coneq[1320]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c*dot(A,c)))-1/6336.
    coneq[1321]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c)))-1/12672.
    coneq[1322]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c*dot(A,c)))-1/4224.
    coneq[1323]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c*dot(A,c)))-1/1584.
    coneq[1324]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c*dot(A,c)))-1/3168.
    coneq[1325]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c*dot(A,c)))-1/1056.
    coneq[1326]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c*dot(A,c)))-1/3168.
    coneq[1327]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c*dot(A,c)))-1/6336.
    coneq[1328]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c*dot(A,c)))-1/2112.
    coneq[1329]=dot(b,dot(A,c**6)*dot(A,c**2))-1/231.
    coneq[1330]=dot(b,dot(A,dot(A,c**5))*dot(A,c**2))-1/1386.
    coneq[1331]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,c**2))-1/6930.
    coneq[1332]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,c**2))-1/27720.
    coneq[1333]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c**2))-1/83160.
    coneq[1334]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c**2))-1/166320.
    coneq[1335]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c**2))-1/55440.
    coneq[1336]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,c**2))-1/20790.
    coneq[1337]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c**2))-1/41580.
    coneq[1338]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,c**2))-1/13860.
    coneq[1339]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c**2))-1/27720.
    coneq[1340]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,c**2))-1/5544.
    coneq[1341]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,c**2))-1/16632.
    coneq[1342]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c**2))-1/33264.
    coneq[1343]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,c**2))-1/11088.
    coneq[1344]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,c**2))-1/4158.
    coneq[1345]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,c**2))-1/8316.
    coneq[1346]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,c**2))-1/2772.
    coneq[1347]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c**2))-1/8316.
    coneq[1348]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c**2))-1/16632.
    coneq[1349]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c**2))-1/5544.
    coneq[1350]=dot(b,dot(A,c*dot(A,c**4))*dot(A,c**2))-1/1155.
    coneq[1351]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,c**2))-1/4620.
    coneq[1352]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,c**2))-1/13860.
    coneq[1353]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**2))-1/27720.
    coneq[1354]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,c**2))-1/9240.
    coneq[1355]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,c**2))-1/3465.
    coneq[1356]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,c**2))-1/6930.
    coneq[1357]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,c**2))-1/2310.
    coneq[1358]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,c**2))-1/4620.
    coneq[1359]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,c**2))-1/924.
    coneq[1360]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,c**2))-1/2772.
    coneq[1361]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,c**2))-1/5544.
    coneq[1362]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,c**2))-1/1848.
    coneq[1363]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,c**2))-1/693.
    coneq[1364]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,c**2))-1/1386.
    coneq[1365]=dot(b,dot(A,c**4*dot(A,c))*dot(A,c**2))-1/462.
    coneq[1366]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,c**2))-1/2079.
    coneq[1367]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c**2))-1/4158.
    coneq[1368]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c**2))-1/8316.
    coneq[1369]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,c**2))-1/1848.
    coneq[1370]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c**2))-1/5544.
    coneq[1371]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c**2))-1/11088.
    coneq[1372]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c**2))-1/3696.
    coneq[1373]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,c**2))-1/1386.
    coneq[1374]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,c**2))-1/2772.
    coneq[1375]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,c**2))-1/924.
    coneq[1376]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c**2))-1/1848.
    coneq[1377]=dot(b,dot(A,c**6)*dot(A,dot(A,c)))-1/462.
    coneq[1378]=dot(b,dot(A,dot(A,c**5))*dot(A,dot(A,c)))-1/2772.
    coneq[1379]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,dot(A,c)))-1/13860.
    coneq[1380]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,dot(A,c)))-1/55440.
    coneq[1381]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,dot(A,c)))-1/166320.
    coneq[1382]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,dot(A,c)))-1/332640.
    coneq[1383]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,dot(A,c)))-1/110880.
    coneq[1384]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,dot(A,c)))-1/41580.
    coneq[1385]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/83160.
    coneq[1386]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,dot(A,c)))-1/27720.
    coneq[1387]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,dot(A,c)))-1/55440.
    coneq[1388]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,dot(A,c)))-1/11088.
    coneq[1389]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,dot(A,c)))-1/33264.
    coneq[1390]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/66528.
    coneq[1391]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,dot(A,c)))-1/22176.
    coneq[1392]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,dot(A,c)))-1/8316.
    coneq[1393]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/16632.
    coneq[1394]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,dot(A,c)))-1/5544.
    coneq[1395]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,dot(A,c)))-1/16632.
    coneq[1396]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/33264.
    coneq[1397]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,dot(A,c)))-1/11088.
    coneq[1398]=dot(b,dot(A,c*dot(A,c**4))*dot(A,dot(A,c)))-1/2310.
    coneq[1399]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,dot(A,c)))-1/9240.
    coneq[1400]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c)))-1/27720.
    coneq[1401]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/55440.
    coneq[1402]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c)))-1/18480.
    coneq[1403]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,dot(A,c)))-1/6930.
    coneq[1404]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/13860.
    coneq[1405]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,dot(A,c)))-1/4620.
    coneq[1406]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c)))-1/9240.
    coneq[1407]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,dot(A,c)))-1/1848.
    coneq[1408]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,dot(A,c)))-1/5544.
    coneq[1409]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/11088.
    coneq[1410]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,dot(A,c)))-1/3696.
    coneq[1411]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,dot(A,c)))-1/1386.
    coneq[1412]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/2772.
    coneq[1413]=dot(b,dot(A,c**4*dot(A,c))*dot(A,dot(A,c)))-1/924.
    coneq[1414]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,dot(A,c)))-1/4158.
    coneq[1415]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/8316.
    coneq[1416]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/16632.
    coneq[1417]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,dot(A,c)))-1/3696.
    coneq[1418]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,dot(A,c)))-1/11088.
    coneq[1419]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/22176.
    coneq[1420]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,dot(A,c)))-1/7392.
    coneq[1421]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,dot(A,c)))-1/2772.
    coneq[1422]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/5544.
    coneq[1423]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,dot(A,c)))-1/1848.
    coneq[1424]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,dot(A,c)))-1/3696.
    coneq[1425]=dot(b,dot(A,c**7)*dot(A,c))-1/176.
    coneq[1426]=dot(b,dot(A,dot(A,c**6))*dot(A,c))-1/1232.
    coneq[1427]=dot(b,dot(A,dot(A,dot(A,c**5)))*dot(A,c))-1/7392.
    coneq[1428]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4))))*dot(A,c))-1/36960.
    coneq[1429]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))*dot(A,c))-1/147840.
    coneq[1430]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*dot(A,c))-1/443520.
    coneq[1431]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*dot(A,c))-1/887040.
    coneq[1432]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*dot(A,c))-1/295680.
    coneq[1433]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))*dot(A,c))-1/110880.
    coneq[1434]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*dot(A,c))-1/221760.
    coneq[1435]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))*dot(A,c))-1/73920.
    coneq[1436]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*dot(A,c))-1/147840.
    coneq[1437]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3))))*dot(A,c))-1/29568.
    coneq[1438]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))*dot(A,c))-1/88704.
    coneq[1439]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/177408.
    coneq[1440]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))*dot(A,c))-1/59136.
    coneq[1441]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))*dot(A,c))-1/22176.
    coneq[1442]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))*dot(A,c))-1/44352.
    coneq[1443]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c))))*dot(A,c))-1/14784.
    coneq[1444]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))*dot(A,c))-1/44352.
    coneq[1445]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*dot(A,c))-1/88704.
    coneq[1446]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))*dot(A,c))-1/29568.
    coneq[1447]=dot(b,dot(A,dot(A,c*dot(A,c**4)))*dot(A,c))-1/6160.
    coneq[1448]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3))))*dot(A,c))-1/24640.
    coneq[1449]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))*dot(A,c))-1/73920.
    coneq[1450]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/147840.
    coneq[1451]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))*dot(A,c))-1/49280.
    coneq[1452]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))*dot(A,c))-1/18480.
    coneq[1453]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))*dot(A,c))-1/36960.
    coneq[1454]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))*dot(A,c))-1/12320.
    coneq[1455]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))*dot(A,c))-1/24640.
    coneq[1456]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)))*dot(A,c))-1/4928.
    coneq[1457]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))*dot(A,c))-1/14784.
    coneq[1458]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/29568.
    coneq[1459]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))*dot(A,c))-1/9856.
    coneq[1460]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)))*dot(A,c))-1/3696.
    coneq[1461]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))))*dot(A,c))-1/7392.
    coneq[1462]=dot(b,dot(A,dot(A,c**4*dot(A,c)))*dot(A,c))-1/2464.
    coneq[1463]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))*dot(A,c))-1/11088.
    coneq[1464]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))*dot(A,c))-1/22176.
    coneq[1465]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*dot(A,c))-1/44352.
    coneq[1466]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)))*dot(A,c))-1/9856.
    coneq[1467]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))*dot(A,c))-1/29568.
    coneq[1468]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/59136.
    coneq[1469]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))*dot(A,c))-1/19712.
    coneq[1470]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))*dot(A,c))-1/7392.
    coneq[1471]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))*dot(A,c))-1/14784.
    coneq[1472]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))*dot(A,c))-1/4928.
    coneq[1473]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*dot(A,c))-1/9856.
    coneq[1474]=dot(b,dot(A,c*dot(A,c**5))*dot(A,c))-1/1056.
    coneq[1475]=dot(b,dot(A,c*dot(A,dot(A,c**4)))*dot(A,c))-1/5280.
    coneq[1476]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3))))*dot(A,c))-1/21120.
    coneq[1477]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c))-1/63360.
    coneq[1478]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/126720.
    coneq[1479]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c))-1/42240.
    coneq[1480]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))*dot(A,c))-1/15840.
    coneq[1481]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c))-1/31680.
    coneq[1482]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))*dot(A,c))-1/10560.
    coneq[1483]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c))-1/21120.
    coneq[1484]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)))*dot(A,c))-1/4224.
    coneq[1485]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))*dot(A,c))-1/12672.
    coneq[1486]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/25344.
    coneq[1487]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))*dot(A,c))-1/8448.
    coneq[1488]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)))*dot(A,c))-1/3168.
    coneq[1489]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))*dot(A,c))-1/6336.
    coneq[1490]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)))*dot(A,c))-1/2112.
    coneq[1491]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c))-1/6336.
    coneq[1492]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c))-1/12672.
    coneq[1493]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c))-1/4224.
    coneq[1494]=dot(b,dot(A,c**2*dot(A,c**4))*dot(A,c))-1/880.
    coneq[1495]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)))*dot(A,c))-1/3520.
    coneq[1496]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))*dot(A,c))-1/10560.
    coneq[1497]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/21120.
    coneq[1498]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))*dot(A,c))-1/7040.
    coneq[1499]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)))*dot(A,c))-1/2640.
    coneq[1500]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))*dot(A,c))-1/5280.
    coneq[1501]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)))*dot(A,c))-1/1760.
    coneq[1502]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))*dot(A,c))-1/3520.
    coneq[1503]=dot(b,dot(A,c**3*dot(A,c**3))*dot(A,c))-1/704.
    coneq[1504]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)))*dot(A,c))-1/2112.
    coneq[1505]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/4224.
    coneq[1506]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)))*dot(A,c))-1/1408.
    coneq[1507]=dot(b,dot(A,c**4*dot(A,c**2))*dot(A,c))-1/528.
    coneq[1508]=dot(b,dot(A,c**4*dot(A,dot(A,c)))*dot(A,c))-1/1056.
    coneq[1509]=dot(b,dot(A,c**5*dot(A,c))*dot(A,c))-1/352.
    coneq[1510]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3))*dot(A,c))-1/2112.
    coneq[1511]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))*dot(A,c))-1/6336.
    coneq[1512]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/12672.
    coneq[1513]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))*dot(A,c))-1/4224.
    coneq[1514]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3))*dot(A,c))-1/4224.
    coneq[1515]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))*dot(A,c))-1/12672.
    coneq[1516]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/25344.
    coneq[1517]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))*dot(A,c))-1/8448.
    coneq[1518]=dot(b,dot(A,dot(A,c)*dot(A,c**4))*dot(A,c))-1/1760.
    coneq[1519]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)))*dot(A,c))-1/7040.
    coneq[1520]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))*dot(A,c))-1/21120.
    coneq[1521]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/42240.
    coneq[1522]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))*dot(A,c))-1/14080.
    coneq[1523]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))*dot(A,c))-1/5280.
    coneq[1524]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))*dot(A,c))-1/10560.
    coneq[1525]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))*dot(A,c))-1/3520.
    coneq[1526]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*dot(A,c))-1/7040.
    coneq[1527]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2))*dot(A,c))-1/1584.
    coneq[1528]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c))-1/3168.
    coneq[1529]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c))-1/6336.
    coneq[1530]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3))*dot(A,c))-1/1408.
    coneq[1531]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c))-1/4224.
    coneq[1532]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/8448.
    coneq[1533]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c))-1/2816.
    coneq[1534]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2))*dot(A,c))-1/1056.
    coneq[1535]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))*dot(A,c))-1/2112.
    coneq[1536]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c))*dot(A,c))-1/704.
    coneq[1537]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))*dot(A,c))-1/2112.
    coneq[1538]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*dot(A,c))-1/4224.
    coneq[1539]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c))-1/1408.
    coneq[1540]=dot(b,dot(A,c**4)*dot(A,c**3)*c)-1/220.
    coneq[1541]=dot(b,dot(A,dot(A,c**3))*dot(A,c**3)*c)-1/880.
    coneq[1542]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**3)*c)-1/2640.
    coneq[1543]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**3)*c)-1/5280.
    coneq[1544]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**3)*c)-1/1760.
    coneq[1545]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**3)*c)-1/660.
    coneq[1546]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**3)*c)-1/1320.
    coneq[1547]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**3)*c)-1/440.
    coneq[1548]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**3)*c)-1/880.
    coneq[1549]=dot(b,dot(A,c**4)*dot(A,dot(A,c**2))*c)-1/660.
    coneq[1550]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c**2))*c)-1/2640.
    coneq[1551]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c**2))*c)-1/7920.
    coneq[1552]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**2))*c)-1/15840.
    coneq[1553]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c**2))*c)-1/5280.
    coneq[1554]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c**2))*c)-1/1980.
    coneq[1555]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c**2))*c)-1/3960.
    coneq[1556]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c**2))*c)-1/1320.
    coneq[1557]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c**2))*c)-1/2640.
    coneq[1558]=dot(b,dot(A,c**4)*dot(A,dot(A,dot(A,c)))*c)-1/1320.
    coneq[1559]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,c)))*c)-1/5280.
    coneq[1560]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c)))*c)-1/15840.
    coneq[1561]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c)))*c)-1/31680.
    coneq[1562]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c)))*c)-1/10560.
    coneq[1563]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,c)))*c)-1/3960.
    coneq[1564]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*c)-1/7920.
    coneq[1565]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,c)))*c)-1/2640.
    coneq[1566]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c)))*c)-1/5280.
    coneq[1567]=dot(b,dot(A,c**4)*dot(A,c*dot(A,c))*c)-1/440.
    coneq[1568]=dot(b,dot(A,dot(A,c**3))*dot(A,c*dot(A,c))*c)-1/1760.
    coneq[1569]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,c))*c)-1/5280.
    coneq[1570]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c))*c)-1/10560.
    coneq[1571]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,c))*c)-1/3520.
    coneq[1572]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c))*c)-1/1320.
    coneq[1573]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,c))*c)-1/2640.
    coneq[1574]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,c))*c)-1/880.
    coneq[1575]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,c))*c)-1/1760.
    coneq[1576]=dot(b,dot(A,c**5)*dot(A,c**2)*c)-1/198.
    coneq[1577]=dot(b,dot(A,dot(A,c**4))*dot(A,c**2)*c)-1/990.
    coneq[1578]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c**2)*c)-1/3960.
    coneq[1579]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c**2)*c)-1/11880.
    coneq[1580]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**2)*c)-1/23760.
    coneq[1581]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c**2)*c)-1/7920.
    coneq[1582]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c**2)*c)-1/2970.
    coneq[1583]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c**2)*c)-1/5940.
    coneq[1584]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c**2)*c)-1/1980.
    coneq[1585]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c**2)*c)-1/3960.
    coneq[1586]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c**2)*c)-1/792.
    coneq[1587]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c**2)*c)-1/2376.
    coneq[1588]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c**2)*c)-1/4752.
    coneq[1589]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c**2)*c)-1/1584.
    coneq[1590]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c**2)*c)-1/594.
    coneq[1591]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c**2)*c)-1/1188.
    coneq[1592]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c**2)*c)-1/396.
    coneq[1593]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c**2)*c)-1/1188.
    coneq[1594]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c**2)*c)-1/2376.
    coneq[1595]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c**2)*c)-1/792.
    coneq[1596]=dot(b,dot(A,c**5)*dot(A,dot(A,c))*c)-1/396.
    coneq[1597]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,c))*c)-1/1980.
    coneq[1598]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,c))*c)-1/7920.
    coneq[1599]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c))*c)-1/23760.
    coneq[1600]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c))*c)-1/47520.
    coneq[1601]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c))*c)-1/15840.
    coneq[1602]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,c))*c)-1/5940.
    coneq[1603]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c))*c)-1/11880.
    coneq[1604]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,c))*c)-1/3960.
    coneq[1605]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c))*c)-1/7920.
    coneq[1606]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,c))*c)-1/1584.
    coneq[1607]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,c))*c)-1/4752.
    coneq[1608]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*c)-1/9504.
    coneq[1609]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,c))*c)-1/3168.
    coneq[1610]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,c))*c)-1/1188.
    coneq[1611]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,c))*c)-1/2376.
    coneq[1612]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,c))*c)-1/792.
    coneq[1613]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,c))*c)-1/2376.
    coneq[1614]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c))*c)-1/4752.
    coneq[1615]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,c))*c)-1/1584.
    coneq[1616]=dot(b,dot(A,c**6)*dot(A,c)*c)-1/154.
    coneq[1617]=dot(b,dot(A,dot(A,c**5))*dot(A,c)*c)-1/924.
    coneq[1618]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,c)*c)-1/4620.
    coneq[1619]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,c)*c)-1/18480.
    coneq[1620]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c)*c)-1/55440.
    coneq[1621]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c)*c)-1/110880.
    coneq[1622]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c)*c)-1/36960.
    coneq[1623]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,c)*c)-1/13860.
    coneq[1624]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c)*c)-1/27720.
    coneq[1625]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,c)*c)-1/9240.
    coneq[1626]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c)*c)-1/18480.
    coneq[1627]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,c)*c)-1/3696.
    coneq[1628]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,c)*c)-1/11088.
    coneq[1629]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c)*c)-1/22176.
    coneq[1630]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,c)*c)-1/7392.
    coneq[1631]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,c)*c)-1/2772.
    coneq[1632]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,c)*c)-1/5544.
    coneq[1633]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,c)*c)-1/1848.
    coneq[1634]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c)*c)-1/5544.
    coneq[1635]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c)*c)-1/11088.
    coneq[1636]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c)*c)-1/3696.
    coneq[1637]=dot(b,dot(A,c*dot(A,c**4))*dot(A,c)*c)-1/770.
    coneq[1638]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,c)*c)-1/3080.
    coneq[1639]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,c)*c)-1/9240.
    coneq[1640]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c)*c)-1/18480.
    coneq[1641]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,c)*c)-1/6160.
    coneq[1642]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,c)*c)-1/2310.
    coneq[1643]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,c)*c)-1/4620.
    coneq[1644]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,c)*c)-1/1540.
    coneq[1645]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,c)*c)-1/3080.
    coneq[1646]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,c)*c)-1/616.
    coneq[1647]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,c)*c)-1/1848.
    coneq[1648]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,c)*c)-1/3696.
    coneq[1649]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,c)*c)-1/1232.
    coneq[1650]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,c)*c)-1/462.
    coneq[1651]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,c)*c)-1/924.
    coneq[1652]=dot(b,dot(A,c**4*dot(A,c))*dot(A,c)*c)-1/308.
    coneq[1653]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,c)*c)-1/1386.
    coneq[1654]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c)*c)-1/2772.
    coneq[1655]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c)*c)-1/5544.
    coneq[1656]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,c)*c)-1/1232.
    coneq[1657]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c)*c)-1/3696.
    coneq[1658]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c)*c)-1/7392.
    coneq[1659]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c)*c)-1/2464.
    coneq[1660]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,c)*c)-1/924.
    coneq[1661]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,c)*c)-1/1848.
    coneq[1662]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,c)*c)-1/616.
    coneq[1663]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c)*c)-1/1232.
    coneq[1664]=dot(b,dot(A,c**3)*dot(A,c**3)*c*c)-1/176.
    coneq[1665]=dot(b,dot(A,dot(A,c**2))*dot(A,c**3)*c*c)-1/528.
    coneq[1666]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**3)*c*c)-1/1056.
    coneq[1667]=dot(b,dot(A,c*dot(A,c))*dot(A,c**3)*c*c)-1/352.
    coneq[1668]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))*c*c)-1/1584.
    coneq[1669]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2))*c*c)-1/3168.
    coneq[1670]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c**2))*c*c)-1/1056.
    coneq[1671]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*c*c)-1/6336.
    coneq[1672]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)))*c*c)-1/2112.
    coneq[1673]=dot(b,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))*c*c)-1/704.
    coneq[1674]=dot(b,dot(A,c**4)*dot(A,c**2)*c*c)-1/165.
    coneq[1675]=dot(b,dot(A,dot(A,c**3))*dot(A,c**2)*c*c)-1/660.
    coneq[1676]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2)*c*c)-1/1980.
    coneq[1677]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2)*c*c)-1/3960.
    coneq[1678]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2)*c*c)-1/1320.
    coneq[1679]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**2)*c*c)-1/495.
    coneq[1680]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2)*c*c)-1/990.
    coneq[1681]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**2)*c*c)-1/330.
    coneq[1682]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2)*c*c)-1/660.
    coneq[1683]=dot(b,dot(A,c**4)*dot(A,dot(A,c))*c*c)-1/330.
    coneq[1684]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c))*c*c)-1/1320.
    coneq[1685]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c))*c*c)-1/3960.
    coneq[1686]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*c*c)-1/7920.
    coneq[1687]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c))*c*c)-1/2640.
    coneq[1688]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c))*c*c)-1/990.
    coneq[1689]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c))*c*c)-1/1980.
    coneq[1690]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c))*c*c)-1/660.
    coneq[1691]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c))*c*c)-1/1320.
    coneq[1692]=dot(b,dot(A,c**5)*dot(A,c)*c*c)-1/132.
    coneq[1693]=dot(b,dot(A,dot(A,c**4))*dot(A,c)*c*c)-1/660.
    coneq[1694]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c)*c*c)-1/2640.
    coneq[1695]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c)*c*c)-1/7920.
    coneq[1696]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c)*c*c)-1/15840.
    coneq[1697]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c)*c*c)-1/5280.
    coneq[1698]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c)*c*c)-1/1980.
    coneq[1699]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c)*c*c)-1/3960.
    coneq[1700]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c)*c*c)-1/1320.
    coneq[1701]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c)*c*c)-1/2640.
    coneq[1702]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c)*c*c)-1/528.
    coneq[1703]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c)*c*c)-1/1584.
    coneq[1704]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c)*c*c)-1/3168.
    coneq[1705]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c)*c*c)-1/1056.
    coneq[1706]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c)*c*c)-1/396.
    coneq[1707]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c)*c*c)-1/792.
    coneq[1708]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c)*c*c)-1/264.
    coneq[1709]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c)*c*c)-1/792.
    coneq[1710]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c)*c*c)-1/1584.
    coneq[1711]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c)*c*c)-1/528.
    coneq[1712]=dot(b,dot(A,c**3)*dot(A,c**2)*c**3)-1/132.
    coneq[1713]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2)*c**3)-1/396.
    coneq[1714]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2)*c**3)-1/792.
    coneq[1715]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2)*c**3)-1/264.
    coneq[1716]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*c**3)-1/264.
    coneq[1717]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*c**3)-1/792.
    coneq[1718]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*c**3)-1/1584.
    coneq[1719]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*c**3)-1/528.
    coneq[1720]=dot(b,dot(A,c**4)*dot(A,c)*c**3)-1/110.
    coneq[1721]=dot(b,dot(A,dot(A,c**3))*dot(A,c)*c**3)-1/440.
    coneq[1722]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c)*c**3)-1/1320.
    coneq[1723]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c)*c**3)-1/2640.
    coneq[1724]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c)*c**3)-1/880.
    coneq[1725]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c)*c**3)-1/330.
    coneq[1726]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c)*c**3)-1/660.
    coneq[1727]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c)*c**3)-1/220.
    coneq[1728]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c)*c**3)-1/440.
    coneq[1729]=dot(b,dot(A,c**2)*dot(A,c**2)*c**4)-1/99.
    coneq[1730]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*c**4)-1/198.
    coneq[1731]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*c**4)-1/396.
    coneq[1732]=dot(b,dot(A,c**3)*dot(A,c)*c**4)-1/88.
    coneq[1733]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*c**4)-1/264.
    coneq[1734]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*c**4)-1/528.
    coneq[1735]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*c**4)-1/176.
    coneq[1736]=dot(b,dot(A,c**2)*dot(A,c)*c**5)-1/66.
    coneq[1737]=dot(b,dot(A,dot(A,c))*dot(A,c)*c**5)-1/132.
    coneq[1738]=dot(b,dot(A,c)*dot(A,c)*c**6)-1/44.
    coneq[1739]=dot(b,dot(A,c**5)*dot(A,c)*dot(A,c))-1/264.
    coneq[1740]=dot(b,dot(A,dot(A,c**4))*dot(A,c)*dot(A,c))-1/1320.
    coneq[1741]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c)*dot(A,c))-1/5280.
    coneq[1742]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c)*dot(A,c))-1/15840.
    coneq[1743]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c)*dot(A,c))-1/31680.
    coneq[1744]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c)*dot(A,c))-1/10560.
    coneq[1745]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c)*dot(A,c))-1/3960.
    coneq[1746]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c)*dot(A,c))-1/7920.
    coneq[1747]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c)*dot(A,c))-1/2640.
    coneq[1748]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c)*dot(A,c))-1/5280.
    coneq[1749]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c)*dot(A,c))-1/1056.
    coneq[1750]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c)*dot(A,c))-1/3168.
    coneq[1751]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c)*dot(A,c))-1/6336.
    coneq[1752]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c)*dot(A,c))-1/2112.
    coneq[1753]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c)*dot(A,c))-1/792.
    coneq[1754]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c)*dot(A,c))-1/1584.
    coneq[1755]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c)*dot(A,c))-1/528.
    coneq[1756]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c)*dot(A,c))-1/1584.
    coneq[1757]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c)*dot(A,c))-1/3168.
    coneq[1758]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c)*dot(A,c))-1/1056.
    coneq[1759]=dot(b,dot(A,c**4)*dot(A,c**2)*dot(A,c))-1/330.
    coneq[1760]=dot(b,dot(A,dot(A,c**3))*dot(A,c**2)*dot(A,c))-1/1320.
    coneq[1761]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2)*dot(A,c))-1/3960.
    coneq[1762]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2)*dot(A,c))-1/7920.
    coneq[1763]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2)*dot(A,c))-1/2640.
    coneq[1764]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**2)*dot(A,c))-1/990.
    coneq[1765]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c))-1/1980.
    coneq[1766]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**2)*dot(A,c))-1/660.
    coneq[1767]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2)*dot(A,c))-1/1320.
    coneq[1768]=dot(b,dot(A,c**4)*dot(A,dot(A,c))*dot(A,c))-1/660.
    coneq[1769]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c))*dot(A,c))-1/2640.
    coneq[1770]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c))*dot(A,c))-1/7920.
    coneq[1771]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*dot(A,c))-1/15840.
    coneq[1772]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c))*dot(A,c))-1/5280.
    coneq[1773]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c))*dot(A,c))-1/1980.
    coneq[1774]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c))-1/3960.
    coneq[1775]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c))*dot(A,c))-1/1320.
    coneq[1776]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c))*dot(A,c))-1/2640.
    coneq[1777]=dot(b,dot(A,c**3)*dot(A,c**2)*dot(A,c**2))-1/396.
    coneq[1778]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2)*dot(A,c**2))-1/1188.
    coneq[1779]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c**2))-1/2376.
    coneq[1780]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2)*dot(A,c**2))-1/792.
    coneq[1781]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*dot(A,c**2))-1/792.
    coneq[1782]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*dot(A,c**2))-1/2376.
    coneq[1783]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c**2))-1/4752.
    coneq[1784]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*dot(A,c**2))-1/1584.
    coneq[1785]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/1584.
    coneq[1786]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/4752.
    coneq[1787]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/9504.
    coneq[1788]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/3168.
    coneq[1789]=dot(b,dot(A,c**3)*dot(A,c**3)*dot(A,c))-1/352.
    coneq[1790]=dot(b,dot(A,dot(A,c**2))*dot(A,c**3)*dot(A,c))-1/1056.
    coneq[1791]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**3)*dot(A,c))-1/2112.
    coneq[1792]=dot(b,dot(A,c*dot(A,c))*dot(A,c**3)*dot(A,c))-1/704.
    coneq[1793]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))*dot(A,c))-1/3168.
    coneq[1794]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2))*dot(A,c))-1/6336.
    coneq[1795]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c**2))*dot(A,c))-1/2112.
    coneq[1796]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/12672.
    coneq[1797]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/4224.
    coneq[1798]=dot(b,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))*dot(A,c))-1/1408.
    coneq[1799]=dot(b,dot(A,c**4)*dot(A,c)*dot(A,c)*c)-1/220.
    coneq[1800]=dot(b,dot(A,dot(A,c**3))*dot(A,c)*dot(A,c)*c)-1/880.
    coneq[1801]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c)*dot(A,c)*c)-1/2640.
    coneq[1802]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c)*dot(A,c)*c)-1/5280.
    coneq[1803]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c)*dot(A,c)*c)-1/1760.
    coneq[1804]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c)*dot(A,c)*c)-1/660.
    coneq[1805]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c)*dot(A,c)*c)-1/1320.
    coneq[1806]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c)*dot(A,c)*c)-1/440.
    coneq[1807]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c)*dot(A,c)*c)-1/880.
    coneq[1808]=dot(b,dot(A,c**3)*dot(A,c**2)*dot(A,c)*c)-1/264.
    coneq[1809]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2)*dot(A,c)*c)-1/792.
    coneq[1810]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c)*c)-1/1584.
    coneq[1811]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2)*dot(A,c)*c)-1/528.
    coneq[1812]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*dot(A,c)*c)-1/528.
    coneq[1813]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*dot(A,c)*c)-1/1584.
    coneq[1814]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c)*c)-1/3168.
    coneq[1815]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*dot(A,c)*c)-1/1056.
    coneq[1816]=dot(b,dot(A,c**2)*dot(A,c**2)*dot(A,c**2)*c)-1/297.
    coneq[1817]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*dot(A,c**2)*c)-1/594.
    coneq[1818]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c**2)*c)-1/1188.
    coneq[1819]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c))*c)-1/2376.
    coneq[1820]=dot(b,dot(A,c**3)*dot(A,c)*dot(A,c)*c*c)-1/176.
    coneq[1821]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*dot(A,c)*c*c)-1/528.
    coneq[1822]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*dot(A,c)*c*c)-1/1056.
    coneq[1823]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*dot(A,c)*c*c)-1/352.
    coneq[1824]=dot(b,dot(A,c**2)*dot(A,c**2)*dot(A,c)*c*c)-1/198.
    coneq[1825]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*dot(A,c)*c*c)-1/396.
    coneq[1826]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c)*c*c)-1/792.
    coneq[1827]=dot(b,dot(A,c**2)*dot(A,c)*dot(A,c)*c**3)-1/132.
    coneq[1828]=dot(b,dot(A,dot(A,c))*dot(A,c)*dot(A,c)*c**3)-1/264.
    coneq[1829]=dot(b,dot(A,c)*dot(A,c)*dot(A,c)*c**4)-1/88.
    coneq[1830]=dot(b,dot(A,c**3)*dot(A,c)*dot(A,c)*dot(A,c))-1/352.
    coneq[1831]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*dot(A,c)*dot(A,c))-1/1056.
    coneq[1832]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*dot(A,c)*dot(A,c))-1/2112.
    coneq[1833]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*dot(A,c)*dot(A,c))-1/704.
    coneq[1834]=dot(b,dot(A,c**2)*dot(A,c**2)*dot(A,c)*dot(A,c))-1/396.
    coneq[1835]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*dot(A,c)*dot(A,c))-1/792.
    coneq[1836]=dot(b,dot(A,c**2)*dot(A,dot(A,c))*dot(A,c)*dot(A,c))-1/792.
    coneq[1837]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c)*dot(A,c))-1/1584.
    coneq[1838]=dot(b,dot(A,c**2)*dot(A,c)*dot(A,c)*dot(A,c)*c)-1/264.
    coneq[1839]=dot(b,dot(A,dot(A,c))*dot(A,c)*dot(A,c)*dot(A,c)*c)-1/528.
    coneq[1840]=dot(b,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)*c*c)-1/176.
    coneq[1841]=dot(b,c**10)-1/11.
    if any(abs(coneq)>tol):
        return 10
    # order 12 conditions:
    coneq[0]=dot(b,dot(A,c**10))-1/132.
    coneq[1]=dot(b,dot(A,dot(A,c**9)))-1/1320.
    coneq[2]=dot(b,dot(A,dot(A,dot(A,c**8))))-1/11880.
    coneq[3]=dot(b,dot(A,dot(A,dot(A,dot(A,c**7)))))-1/95040.
    coneq[4]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**6))))))-1/665280.
    coneq[5]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**5)))))))-1/3991680.
    coneq[6]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**4))))))))-1/19958400.
    coneq[7]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))))-1/79833600.
    coneq[8]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))))-1/239500800.
    coneq[9]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))))-1/479001600.
    coneq[10]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))))-1/159667200.
    coneq[11]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))))-1/59875200.
    coneq[12]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))))-1/119750400.
    coneq[13]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))))-1/39916800.
    coneq[14]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))))-1/79833600.
    coneq[15]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3))))))))-1/15966720.
    coneq[16]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))))-1/47900160.
    coneq[17]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))))-1/95800320.
    coneq[18]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))))-1/31933440.
    coneq[19]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))))-1/11975040.
    coneq[20]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))))-1/23950080.
    coneq[21]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c))))))))-1/7983360.
    coneq[22]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))))-1/23950080.
    coneq[23]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))))-1/47900160.
    coneq[24]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))))-1/15966720.
    coneq[25]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**4)))))))-1/3326400.
    coneq[26]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3))))))))-1/13305600.
    coneq[27]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))))-1/39916800.
    coneq[28]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))))-1/79833600.
    coneq[29]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))))-1/26611200.
    coneq[30]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))))-1/9979200.
    coneq[31]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))))-1/19958400.
    coneq[32]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))))-1/6652800.
    coneq[33]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))))-1/13305600.
    coneq[34]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**3)))))))-1/2661120.
    coneq[35]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))))-1/7983360.
    coneq[36]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))))-1/15966720.
    coneq[37]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))))-1/5322240.
    coneq[38]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c**2)))))))-1/1995840.
    coneq[39]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c))))))))-1/3991680.
    coneq[40]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,c)))))))-1/1330560.
    coneq[41]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))))-1/5987520.
    coneq[42]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))))-1/11975040.
    coneq[43]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))))-1/23950080.
    coneq[44]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3)))))))-1/5322240.
    coneq[45]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))))-1/15966720.
    coneq[46]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))))-1/31933440.
    coneq[47]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))))-1/10644480.
    coneq[48]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))))-1/3991680.
    coneq[49]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))))-1/7983360.
    coneq[50]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))))-1/2661120.
    coneq[51]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))))-1/5322240.
    coneq[52]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**5))))))-1/570240.
    coneq[53]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**4)))))))-1/2851200.
    coneq[54]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3))))))))-1/11404800.
    coneq[55]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/34214400.
    coneq[56]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/68428800.
    coneq[57]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/22809600.
    coneq[58]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))))-1/8553600.
    coneq[59]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/17107200.
    coneq[60]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))))-1/5702400.
    coneq[61]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/11404800.
    coneq[62]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**3)))))))-1/2280960.
    coneq[63]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))))-1/6842880.
    coneq[64]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/13685760.
    coneq[65]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))))-1/4561920.
    coneq[66]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2)))))))-1/1710720.
    coneq[67]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))))-1/3421440.
    coneq[68]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,c)))))))-1/1140480.
    coneq[69]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))))-1/3421440.
    coneq[70]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/6842880.
    coneq[71]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))))-1/2280960.
    coneq[72]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**4))))))-1/475200.
    coneq[73]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**3)))))))-1/1900800.
    coneq[74]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))))-1/5702400.
    coneq[75]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/11404800.
    coneq[76]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))))-1/3801600.
    coneq[77]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2)))))))-1/1425600.
    coneq[78]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))))-1/2851200.
    coneq[79]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c)))))))-1/950400.
    coneq[80]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))))-1/1900800.
    coneq[81]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c**3))))))-1/380160.
    coneq[82]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c**2)))))))-1/1140480.
    coneq[83]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c))))))))-1/2280960.
    coneq[84]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,c)))))))-1/760320.
    coneq[85]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,c**2))))))-1/285120.
    coneq[86]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,c)))))))-1/570240.
    coneq[87]=dot(b,dot(A,dot(A,dot(A,dot(A,c**5*dot(A,c))))))-1/190080.
    coneq[88]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**3))))))-1/1140480.
    coneq[89]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))))-1/3421440.
    coneq[90]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))))-1/6842880.
    coneq[91]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))))-1/2280960.
    coneq[92]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3))))))-1/2280960.
    coneq[93]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))))-1/6842880.
    coneq[94]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))))-1/13685760.
    coneq[95]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))))-1/4561920.
    coneq[96]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**4))))))-1/950400.
    coneq[97]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3)))))))-1/3801600.
    coneq[98]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))))-1/11404800.
    coneq[99]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/22809600.
    coneq[100]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))))-1/7603200.
    coneq[101]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))))-1/2851200.
    coneq[102]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))))-1/5702400.
    coneq[103]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))))-1/1900800.
    coneq[104]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))))-1/3801600.
    coneq[105]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2))))))-1/855360.
    coneq[106]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))))-1/1710720.
    coneq[107]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/3421440.
    coneq[108]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**3))))))-1/760320.
    coneq[109]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))))-1/2280960.
    coneq[110]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/4561920.
    coneq[111]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))))-1/1520640.
    coneq[112]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2))))))-1/570240.
    coneq[113]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))))-1/1140480.
    coneq[114]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,c))))))-1/380160.
    coneq[115]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))))-1/1140480.
    coneq[116]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))))-1/2280960.
    coneq[117]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))))-1/760320.
    coneq[118]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**6)))))-1/83160.
    coneq[119]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**5))))))-1/498960.
    coneq[120]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**4)))))))-1/2494800.
    coneq[121]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/9979200.
    coneq[122]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/29937600.
    coneq[123]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/59875200.
    coneq[124]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/19958400.
    coneq[125]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/7484400.
    coneq[126]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/14968800.
    coneq[127]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/4989600.
    coneq[128]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/9979200.
    coneq[129]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**3)))))))-1/1995840.
    coneq[130]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/5987520.
    coneq[131]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/11975040.
    coneq[132]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/3991680.
    coneq[133]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2)))))))-1/1496880.
    coneq[134]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/2993760.
    coneq[135]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,c)))))))-1/997920.
    coneq[136]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/2993760.
    coneq[137]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/5987520.
    coneq[138]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/1995840.
    coneq[139]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**4))))))-1/415800.
    coneq[140]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**3)))))))-1/1663200.
    coneq[141]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/4989600.
    coneq[142]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/9979200.
    coneq[143]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/3326400.
    coneq[144]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2)))))))-1/1247400.
    coneq[145]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/2494800.
    coneq[146]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c)))))))-1/831600.
    coneq[147]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/1663200.
    coneq[148]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c**3))))))-1/332640.
    coneq[149]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2)))))))-1/997920.
    coneq[150]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/1995840.
    coneq[151]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c)))))))-1/665280.
    coneq[152]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,c**2))))))-1/249480.
    coneq[153]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,c)))))))-1/498960.
    coneq[154]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**4*dot(A,c))))))-1/166320.
    coneq[155]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2))))))-1/748440.
    coneq[156]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/1496880.
    coneq[157]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/2993760.
    coneq[158]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**3))))))-1/665280.
    coneq[159]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/1995840.
    coneq[160]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/3991680.
    coneq[161]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/1330560.
    coneq[162]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2))))))-1/498960.
    coneq[163]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/997920.
    coneq[164]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c))))))-1/332640.
    coneq[165]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/665280.
    coneq[166]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**5)))))-1/71280.
    coneq[167]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**4))))))-1/356400.
    coneq[168]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**3)))))))-1/1425600.
    coneq[169]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/4276800.
    coneq[170]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/8553600.
    coneq[171]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/2851200.
    coneq[172]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2)))))))-1/1069200.
    coneq[173]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/2138400.
    coneq[174]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c)))))))-1/712800.
    coneq[175]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1425600.
    coneq[176]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c**3))))))-1/285120.
    coneq[177]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2)))))))-1/855360.
    coneq[178]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1710720.
    coneq[179]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c)))))))-1/570240.
    coneq[180]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c**2))))))-1/213840.
    coneq[181]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c)))))))-1/427680.
    coneq[182]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**3*dot(A,c))))))-1/142560.
    coneq[183]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2))))))-1/427680.
    coneq[184]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/855360.
    coneq[185]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c))))))-1/285120.
    coneq[186]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**4)))))-1/59400.
    coneq[187]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c**3))))))-1/237600.
    coneq[188]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c**2)))))))-1/712800.
    coneq[189]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1425600.
    coneq[190]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,c)))))))-1/475200.
    coneq[191]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,c**2))))))-1/178200.
    coneq[192]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,c)))))))-1/356400.
    coneq[193]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**2*dot(A,c))))))-1/118800.
    coneq[194]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,c))))))-1/237600.
    coneq[195]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c**3)))))-1/47520.
    coneq[196]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,c**2))))))-1/142560.
    coneq[197]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,c)))))))-1/285120.
    coneq[198]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c*dot(A,c))))))-1/95040.
    coneq[199]=dot(b,dot(A,dot(A,dot(A,c**5*dot(A,c**2)))))-1/35640.
    coneq[200]=dot(b,dot(A,dot(A,dot(A,c**5*dot(A,dot(A,c))))))-1/71280.
    coneq[201]=dot(b,dot(A,dot(A,dot(A,c**6*dot(A,c)))))-1/23760.
    coneq[202]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,c**3)))))-1/190080.
    coneq[203]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c**2))))))-1/570240.
    coneq[204]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c)))))))-1/1140480.
    coneq[205]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,c))))))-1/380160.
    coneq[206]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))))))-1/1710720.
    coneq[207]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)))))))-1/3421440.
    coneq[208]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c))))))-1/1140480.
    coneq[209]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))))))-1/6842880.
    coneq[210]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c))))))-1/2280960.
    coneq[211]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))))))-1/760320.
    coneq[212]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**4)))))-1/178200.
    coneq[213]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**3))))))-1/712800.
    coneq[214]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2)))))))-1/2138400.
    coneq[215]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/4276800.
    coneq[216]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c)))))))-1/1425600.
    coneq[217]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2))))))-1/534600.
    coneq[218]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c)))))))-1/1069200.
    coneq[219]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c))))))-1/356400.
    coneq[220]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c))))))-1/712800.
    coneq[221]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**4)))))-1/356400.
    coneq[222]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3))))))-1/1425600.
    coneq[223]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)))))))-1/4276800.
    coneq[224]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))))-1/8553600.
    coneq[225]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)))))))-1/2851200.
    coneq[226]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2))))))-1/1069200.
    coneq[227]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)))))))-1/2138400.
    coneq[228]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c))))))-1/712800.
    coneq[229]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c))))))-1/1425600.
    coneq[230]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**5)))))-1/142560.
    coneq[231]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**4))))))-1/712800.
    coneq[232]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3)))))))-1/2851200.
    coneq[233]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/8553600.
    coneq[234]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/17107200.
    coneq[235]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/5702400.
    coneq[236]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2)))))))-1/2138400.
    coneq[237]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/4276800.
    coneq[238]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c)))))))-1/1425600.
    coneq[239]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/2851200.
    coneq[240]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**3))))))-1/570240.
    coneq[241]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2)))))))-1/1710720.
    coneq[242]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/3421440.
    coneq[243]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c)))))))-1/1140480.
    coneq[244]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2))))))-1/427680.
    coneq[245]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c)))))))-1/855360.
    coneq[246]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,c))))))-1/285120.
    coneq[247]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2))))))-1/855360.
    coneq[248]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1710720.
    coneq[249]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c))))))-1/570240.
    coneq[250]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**3)))))-1/142560.
    coneq[251]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2))))))-1/427680.
    coneq[252]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/855360.
    coneq[253]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c))))))-1/285120.
    coneq[254]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**3)))))-1/285120.
    coneq[255]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/855360.
    coneq[256]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/1710720.
    coneq[257]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/570240.
    coneq[258]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**4)))))-1/118800.
    coneq[259]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**3))))))-1/475200.
    coneq[260]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/1425600.
    coneq[261]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2851200.
    coneq[262]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/950400.
    coneq[263]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2))))))-1/356400.
    coneq[264]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/712800.
    coneq[265]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c))))))-1/237600.
    coneq[266]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/475200.
    coneq[267]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c**2)))))-1/106920.
    coneq[268]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c))))))-1/213840.
    coneq[269]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/427680.
    coneq[270]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**3)))))-1/95040.
    coneq[271]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2))))))-1/285120.
    coneq[272]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/570240.
    coneq[273]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c))))))-1/190080.
    coneq[274]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,c**2)))))-1/71280.
    coneq[275]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,c))))))-1/142560.
    coneq[276]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c)*dot(A,c)))))-1/47520.
    coneq[277]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3)))))-1/190080.
    coneq[278]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2))))))-1/570240.
    coneq[279]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/1140480.
    coneq[280]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c))))))-1/380160.
    coneq[281]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2)))))-1/213840.
    coneq[282]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c))))))-1/427680.
    coneq[283]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/855360.
    coneq[284]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/142560.
    coneq[285]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/285120.
    coneq[286]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c)))))-1/95040.
    coneq[287]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)))))-1/190080.
    coneq[288]=dot(b,dot(A,dot(A,c*dot(A,c**7))))-1/10560.
    coneq[289]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**6)))))-1/73920.
    coneq[290]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**5))))))-1/443520.
    coneq[291]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**4)))))))-1/2217600.
    coneq[292]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/8870400.
    coneq[293]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/26611200.
    coneq[294]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/53222400.
    coneq[295]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/17740800.
    coneq[296]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/6652800.
    coneq[297]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/13305600.
    coneq[298]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/4435200.
    coneq[299]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/8870400.
    coneq[300]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**3)))))))-1/1774080.
    coneq[301]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/5322240.
    coneq[302]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/10644480.
    coneq[303]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/3548160.
    coneq[304]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))))-1/1330560.
    coneq[305]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/2661120.
    coneq[306]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,c)))))))-1/887040.
    coneq[307]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/2661120.
    coneq[308]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/5322240.
    coneq[309]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/1774080.
    coneq[310]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**4))))))-1/369600.
    coneq[311]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**3)))))))-1/1478400.
    coneq[312]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/4435200.
    coneq[313]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/8870400.
    coneq[314]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/2956800.
    coneq[315]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))))-1/1108800.
    coneq[316]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/2217600.
    coneq[317]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))))-1/739200.
    coneq[318]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/1478400.
    coneq[319]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c**3))))))-1/295680.
    coneq[320]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))))-1/887040.
    coneq[321]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/1774080.
    coneq[322]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))))-1/591360.
    coneq[323]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,c**2))))))-1/221760.
    coneq[324]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,c)))))))-1/443520.
    coneq[325]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**4*dot(A,c))))))-1/147840.
    coneq[326]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))))-1/665280.
    coneq[327]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/1330560.
    coneq[328]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/2661120.
    coneq[329]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**3))))))-1/591360.
    coneq[330]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/1774080.
    coneq[331]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/3548160.
    coneq[332]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/1182720.
    coneq[333]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))))-1/443520.
    coneq[334]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/887040.
    coneq[335]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))))-1/295680.
    coneq[336]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/591360.
    coneq[337]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**5)))))-1/63360.
    coneq[338]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**4))))))-1/316800.
    coneq[339]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**3)))))))-1/1267200.
    coneq[340]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/3801600.
    coneq[341]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/7603200.
    coneq[342]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/2534400.
    coneq[343]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))))-1/950400.
    coneq[344]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1900800.
    coneq[345]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))))-1/633600.
    coneq[346]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1267200.
    coneq[347]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c**3))))))-1/253440.
    coneq[348]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))))-1/760320.
    coneq[349]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1520640.
    coneq[350]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))))-1/506880.
    coneq[351]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c**2))))))-1/190080.
    coneq[352]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))))-1/380160.
    coneq[353]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**3*dot(A,c))))))-1/126720.
    coneq[354]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))))-1/380160.
    coneq[355]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/760320.
    coneq[356]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))))-1/253440.
    coneq[357]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**4)))))-1/52800.
    coneq[358]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c**3))))))-1/211200.
    coneq[359]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))))-1/633600.
    coneq[360]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1267200.
    coneq[361]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))))-1/422400.
    coneq[362]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c**2))))))-1/158400.
    coneq[363]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))))-1/316800.
    coneq[364]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,c))))))-1/105600.
    coneq[365]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))))-1/211200.
    coneq[366]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c**3)))))-1/42240.
    coneq[367]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,c**2))))))-1/126720.
    coneq[368]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,c)))))))-1/253440.
    coneq[369]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c*dot(A,c))))))-1/84480.
    coneq[370]=dot(b,dot(A,dot(A,c*dot(A,c**4*dot(A,c**2)))))-1/31680.
    coneq[371]=dot(b,dot(A,dot(A,c*dot(A,c**4*dot(A,dot(A,c))))))-1/63360.
    coneq[372]=dot(b,dot(A,dot(A,c*dot(A,c**5*dot(A,c)))))-1/21120.
    coneq[373]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**3)))))-1/126720.
    coneq[374]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))))-1/380160.
    coneq[375]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/760320.
    coneq[376]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))))-1/253440.
    coneq[377]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**3)))))-1/253440.
    coneq[378]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/760320.
    coneq[379]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/1520640.
    coneq[380]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/506880.
    coneq[381]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**4)))))-1/105600.
    coneq[382]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**3))))))-1/422400.
    coneq[383]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/1267200.
    coneq[384]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2534400.
    coneq[385]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/844800.
    coneq[386]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))))-1/316800.
    coneq[387]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/633600.
    coneq[388]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))))-1/211200.
    coneq[389]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/422400.
    coneq[390]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c**2)))))-1/95040.
    coneq[391]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))))-1/190080.
    coneq[392]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/380160.
    coneq[393]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**3)))))-1/84480.
    coneq[394]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))))-1/253440.
    coneq[395]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/506880.
    coneq[396]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))))-1/168960.
    coneq[397]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c**2)))))-1/63360.
    coneq[398]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))))-1/126720.
    coneq[399]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,c)))))-1/42240.
    coneq[400]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/126720.
    coneq[401]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/253440.
    coneq[402]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))))-1/84480.
    coneq[403]=dot(b,dot(A,dot(A,c**2*dot(A,c**6))))-1/9240.
    coneq[404]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**5)))))-1/55440.
    coneq[405]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**4))))))-1/277200.
    coneq[406]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/1108800.
    coneq[407]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/3326400.
    coneq[408]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/6652800.
    coneq[409]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/2217600.
    coneq[410]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/831600.
    coneq[411]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1663200.
    coneq[412]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/554400.
    coneq[413]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1108800.
    coneq[414]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c**3))))))-1/221760.
    coneq[415]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/665280.
    coneq[416]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1330560.
    coneq[417]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/443520.
    coneq[418]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c**2))))))-1/166320.
    coneq[419]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/332640.
    coneq[420]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**3*dot(A,c))))))-1/110880.
    coneq[421]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/332640.
    coneq[422]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/665280.
    coneq[423]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/221760.
    coneq[424]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**4)))))-1/46200.
    coneq[425]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c**3))))))-1/184800.
    coneq[426]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/554400.
    coneq[427]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1108800.
    coneq[428]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/369600.
    coneq[429]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c**2))))))-1/138600.
    coneq[430]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/277200.
    coneq[431]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,c))))))-1/92400.
    coneq[432]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/184800.
    coneq[433]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c**3)))))-1/36960.
    coneq[434]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c**2))))))-1/110880.
    coneq[435]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/221760.
    coneq[436]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,c))))))-1/73920.
    coneq[437]=dot(b,dot(A,dot(A,c**2*dot(A,c**3*dot(A,c**2)))))-1/27720.
    coneq[438]=dot(b,dot(A,dot(A,c**2*dot(A,c**3*dot(A,dot(A,c))))))-1/55440.
    coneq[439]=dot(b,dot(A,dot(A,c**2*dot(A,c**4*dot(A,c)))))-1/18480.
    coneq[440]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/83160.
    coneq[441]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/166320.
    coneq[442]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/332640.
    coneq[443]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**3)))))-1/73920.
    coneq[444]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/221760.
    coneq[445]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/443520.
    coneq[446]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/147840.
    coneq[447]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/55440.
    coneq[448]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/110880.
    coneq[449]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/36960.
    coneq[450]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/73920.
    coneq[451]=dot(b,dot(A,dot(A,c**3*dot(A,c**5))))-1/7920.
    coneq[452]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**4)))))-1/39600.
    coneq[453]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c**3))))))-1/158400.
    coneq[454]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/475200.
    coneq[455]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/950400.
    coneq[456]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/316800.
    coneq[457]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,c**2))))))-1/118800.
    coneq[458]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/237600.
    coneq[459]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**2*dot(A,c))))))-1/79200.
    coneq[460]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/158400.
    coneq[461]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c**3)))))-1/31680.
    coneq[462]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,c**2))))))-1/95040.
    coneq[463]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/190080.
    coneq[464]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c*dot(A,c))))))-1/63360.
    coneq[465]=dot(b,dot(A,dot(A,c**3*dot(A,c**2*dot(A,c**2)))))-1/23760.
    coneq[466]=dot(b,dot(A,dot(A,c**3*dot(A,c**2*dot(A,dot(A,c))))))-1/47520.
    coneq[467]=dot(b,dot(A,dot(A,c**3*dot(A,c**3*dot(A,c)))))-1/15840.
    coneq[468]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,c**2)))))-1/47520.
    coneq[469]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/95040.
    coneq[470]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,c)))))-1/31680.
    coneq[471]=dot(b,dot(A,dot(A,c**4*dot(A,c**4))))-1/6600.
    coneq[472]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c**3)))))-1/26400.
    coneq[473]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,c**2))))))-1/79200.
    coneq[474]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,c)))))))-1/158400.
    coneq[475]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c*dot(A,c))))))-1/52800.
    coneq[476]=dot(b,dot(A,dot(A,c**4*dot(A,c*dot(A,c**2)))))-1/19800.
    coneq[477]=dot(b,dot(A,dot(A,c**4*dot(A,c*dot(A,dot(A,c))))))-1/39600.
    coneq[478]=dot(b,dot(A,dot(A,c**4*dot(A,c**2*dot(A,c)))))-1/13200.
    coneq[479]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c)*dot(A,c)))))-1/26400.
    coneq[480]=dot(b,dot(A,dot(A,c**5*dot(A,c**3))))-1/5280.
    coneq[481]=dot(b,dot(A,dot(A,c**5*dot(A,dot(A,c**2)))))-1/15840.
    coneq[482]=dot(b,dot(A,dot(A,c**5*dot(A,dot(A,dot(A,c))))))-1/31680.
    coneq[483]=dot(b,dot(A,dot(A,c**5*dot(A,c*dot(A,c)))))-1/10560.
    coneq[484]=dot(b,dot(A,dot(A,c**6*dot(A,c**2))))-1/3960.
    coneq[485]=dot(b,dot(A,dot(A,c**6*dot(A,dot(A,c)))))-1/7920.
    coneq[486]=dot(b,dot(A,dot(A,c**7*dot(A,c))))-1/2640.
    coneq[487]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c**4))))-1/26400.
    coneq[488]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c**3)))))-1/105600.
    coneq[489]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c**2))))))-1/316800.
    coneq[490]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/633600.
    coneq[491]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,c))))))-1/211200.
    coneq[492]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,c**2)))))-1/79200.
    coneq[493]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,c))))))-1/158400.
    coneq[494]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,c)))))-1/52800.
    coneq[495]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,c)))))-1/105600.
    coneq[496]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c**4))))-1/79200.
    coneq[497]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**3)))))-1/316800.
    coneq[498]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**2))))))-1/950400.
    coneq[499]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1900800.
    coneq[500]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c))))))-1/633600.
    coneq[501]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c**2)))))-1/237600.
    coneq[502]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c))))))-1/475200.
    coneq[503]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c)))))-1/158400.
    coneq[504]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c)))))-1/316800.
    coneq[505]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**4))))-1/158400.
    coneq[506]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**3)))))-1/633600.
    coneq[507]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2))))))-1/1900800.
    coneq[508]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/3801600.
    coneq[509]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c))))))-1/1267200.
    coneq[510]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**2)))))-1/475200.
    coneq[511]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c))))))-1/950400.
    coneq[512]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c)))))-1/316800.
    coneq[513]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))))-1/633600.
    coneq[514]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c**4))))-1/52800.
    coneq[515]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**3)))))-1/211200.
    coneq[516]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/633600.
    coneq[517]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1267200.
    coneq[518]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/422400.
    coneq[519]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c**2)))))-1/158400.
    coneq[520]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/316800.
    coneq[521]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c)))))-1/105600.
    coneq[522]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/211200.
    coneq[523]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**5))))-1/23760.
    coneq[524]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**4)))))-1/118800.
    coneq[525]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**3))))))-1/475200.
    coneq[526]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1425600.
    coneq[527]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/2851200.
    coneq[528]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/950400.
    coneq[529]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c**2))))))-1/356400.
    coneq[530]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/712800.
    coneq[531]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c))))))-1/237600.
    coneq[532]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/475200.
    coneq[533]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**3)))))-1/95040.
    coneq[534]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c**2))))))-1/285120.
    coneq[535]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/570240.
    coneq[536]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c))))))-1/190080.
    coneq[537]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c**2)))))-1/71280.
    coneq[538]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c))))))-1/142560.
    coneq[539]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,c)))))-1/47520.
    coneq[540]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**2)))))-1/142560.
    coneq[541]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/285120.
    coneq[542]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c)))))-1/95040.
    coneq[543]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**5))))-1/47520.
    coneq[544]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**4)))))-1/237600.
    coneq[545]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**3))))))-1/950400.
    coneq[546]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/2851200.
    coneq[547]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/5702400.
    coneq[548]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/1900800.
    coneq[549]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**2))))))-1/712800.
    coneq[550]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/1425600.
    coneq[551]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c))))))-1/475200.
    coneq[552]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/950400.
    coneq[553]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**3)))))-1/190080.
    coneq[554]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**2))))))-1/570240.
    coneq[555]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/1140480.
    coneq[556]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c))))))-1/380160.
    coneq[557]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c**2)))))-1/142560.
    coneq[558]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c))))))-1/285120.
    coneq[559]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,c)))))-1/95040.
    coneq[560]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**2)))))-1/285120.
    coneq[561]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/570240.
    coneq[562]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c)))))-1/190080.
    coneq[563]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**6))))-1/18480.
    coneq[564]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**5)))))-1/110880.
    coneq[565]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**4))))))-1/554400.
    coneq[566]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/2217600.
    coneq[567]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/6652800.
    coneq[568]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/13305600.
    coneq[569]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/4435200.
    coneq[570]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/1663200.
    coneq[571]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/3326400.
    coneq[572]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/1108800.
    coneq[573]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/2217600.
    coneq[574]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**3))))))-1/443520.
    coneq[575]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/1330560.
    coneq[576]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/2661120.
    coneq[577]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/887040.
    coneq[578]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c**2))))))-1/332640.
    coneq[579]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/665280.
    coneq[580]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,c))))))-1/221760.
    coneq[581]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/665280.
    coneq[582]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1330560.
    coneq[583]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/443520.
    coneq[584]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**4)))))-1/92400.
    coneq[585]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**3))))))-1/369600.
    coneq[586]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/1108800.
    coneq[587]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2217600.
    coneq[588]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/739200.
    coneq[589]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c**2))))))-1/277200.
    coneq[590]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/554400.
    coneq[591]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c))))))-1/184800.
    coneq[592]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/369600.
    coneq[593]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**3)))))-1/73920.
    coneq[594]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c**2))))))-1/221760.
    coneq[595]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/443520.
    coneq[596]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c))))))-1/147840.
    coneq[597]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,c**2)))))-1/55440.
    coneq[598]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,c))))))-1/110880.
    coneq[599]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**4*dot(A,c)))))-1/36960.
    coneq[600]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/166320.
    coneq[601]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/332640.
    coneq[602]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/665280.
    coneq[603]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**3)))))-1/147840.
    coneq[604]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/443520.
    coneq[605]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/887040.
    coneq[606]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/295680.
    coneq[607]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/110880.
    coneq[608]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/221760.
    coneq[609]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/73920.
    coneq[610]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/147840.
    coneq[611]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,c**3))))-1/21120.
    coneq[612]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,dot(A,c**2)))))-1/63360.
    coneq[613]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,c))))))-1/126720.
    coneq[614]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,c)))))-1/42240.
    coneq[615]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))))-1/190080.
    coneq[616]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))))-1/380160.
    coneq[617]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))))-1/126720.
    coneq[618]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))))-1/760320.
    coneq[619]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))))-1/253440.
    coneq[620]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))))-1/84480.
    coneq[621]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**4))))-1/19800.
    coneq[622]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**3)))))-1/79200.
    coneq[623]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))))-1/237600.
    coneq[624]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/475200.
    coneq[625]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))))-1/158400.
    coneq[626]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c**2)))))-1/59400.
    coneq[627]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))))-1/118800.
    coneq[628]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,c)))))-1/39600.
    coneq[629]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))))-1/79200.
    coneq[630]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**4))))-1/39600.
    coneq[631]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**3)))))-1/158400.
    coneq[632]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/475200.
    coneq[633]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/950400.
    coneq[634]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/316800.
    coneq[635]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))))-1/118800.
    coneq[636]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/237600.
    coneq[637]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))))-1/79200.
    coneq[638]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/158400.
    coneq[639]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**5))))-1/15840.
    coneq[640]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**4)))))-1/79200.
    coneq[641]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**3))))))-1/316800.
    coneq[642]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/950400.
    coneq[643]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1900800.
    coneq[644]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/633600.
    coneq[645]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))))-1/237600.
    coneq[646]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/475200.
    coneq[647]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))))-1/158400.
    coneq[648]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/316800.
    coneq[649]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**3)))))-1/63360.
    coneq[650]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))))-1/190080.
    coneq[651]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/380160.
    coneq[652]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))))-1/126720.
    coneq[653]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c**2)))))-1/47520.
    coneq[654]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))))-1/95040.
    coneq[655]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,c)))))-1/31680.
    coneq[656]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))))-1/95040.
    coneq[657]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/190080.
    coneq[658]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))))-1/63360.
    coneq[659]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c**3))))-1/15840.
    coneq[660]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/47520.
    coneq[661]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/95040.
    coneq[662]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/31680.
    coneq[663]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**3))))-1/31680.
    coneq[664]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/95040.
    coneq[665]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/190080.
    coneq[666]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/63360.
    coneq[667]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**4))))-1/13200.
    coneq[668]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**3)))))-1/52800.
    coneq[669]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/158400.
    coneq[670]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/316800.
    coneq[671]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/105600.
    coneq[672]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c**2)))))-1/39600.
    coneq[673]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/79200.
    coneq[674]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,c)))))-1/26400.
    coneq[675]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/52800.
    coneq[676]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)*dot(A,c**2))))-1/11880.
    coneq[677]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,c)))))-1/23760.
    coneq[678]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/47520.
    coneq[679]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c**3))))-1/10560.
    coneq[680]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,c**2)))))-1/31680.
    coneq[681]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/63360.
    coneq[682]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c*dot(A,c)))))-1/21120.
    coneq[683]=dot(b,dot(A,dot(A,c**4*dot(A,c)*dot(A,c**2))))-1/7920.
    coneq[684]=dot(b,dot(A,dot(A,c**4*dot(A,c)*dot(A,dot(A,c)))))-1/15840.
    coneq[685]=dot(b,dot(A,dot(A,c**5*dot(A,c)*dot(A,c))))-1/5280.
    coneq[686]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**4))))-1/26400.
    coneq[687]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**3)))))-1/105600.
    coneq[688]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/316800.
    coneq[689]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/633600.
    coneq[690]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/211200.
    coneq[691]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c**2)))))-1/79200.
    coneq[692]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/158400.
    coneq[693]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,c)))))-1/52800.
    coneq[694]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/105600.
    coneq[695]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**3))))-1/31680.
    coneq[696]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/95040.
    coneq[697]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/190080.
    coneq[698]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/63360.
    coneq[699]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c**3))))-1/63360.
    coneq[700]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/190080.
    coneq[701]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/380160.
    coneq[702]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/126720.
    coneq[703]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,c**2))))-1/35640.
    coneq[704]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,c)))))-1/71280.
    coneq[705]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/142560.
    coneq[706]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/285120.
    coneq[707]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**3))))-1/21120.
    coneq[708]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))))-1/63360.
    coneq[709]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/126720.
    coneq[710]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))))-1/42240.
    coneq[711]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,c**2))))-1/23760.
    coneq[712]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))))-1/47520.
    coneq[713]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/95040.
    coneq[714]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c**2))))-1/15840.
    coneq[715]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/31680.
    coneq[716]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c)*dot(A,c))))-1/10560.
    coneq[717]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c**2))))-1/31680.
    coneq[718]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/63360.
    coneq[719]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))))-1/21120.
    coneq[720]=dot(b,dot(A,c*dot(A,c**8)))-1/1188.
    coneq[721]=dot(b,dot(A,c*dot(A,dot(A,c**7))))-1/9504.
    coneq[722]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**6)))))-1/66528.
    coneq[723]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**5))))))-1/399168.
    coneq[724]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**4)))))))-1/1995840.
    coneq[725]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/7983360.
    coneq[726]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/23950080.
    coneq[727]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/47900160.
    coneq[728]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/15966720.
    coneq[729]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/5987520.
    coneq[730]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/11975040.
    coneq[731]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/3991680.
    coneq[732]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/7983360.
    coneq[733]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3)))))))-1/1596672.
    coneq[734]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/4790016.
    coneq[735]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/9580032.
    coneq[736]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/3193344.
    coneq[737]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))))-1/1197504.
    coneq[738]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/2395008.
    coneq[739]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)))))))-1/798336.
    coneq[740]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/2395008.
    coneq[741]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/4790016.
    coneq[742]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/1596672.
    coneq[743]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**4))))))-1/332640.
    coneq[744]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3)))))))-1/1330560.
    coneq[745]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/3991680.
    coneq[746]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/7983360.
    coneq[747]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/2661120.
    coneq[748]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))))-1/997920.
    coneq[749]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/1995840.
    coneq[750]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))))-1/665280.
    coneq[751]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/1330560.
    coneq[752]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c**3))))))-1/266112.
    coneq[753]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))))-1/798336.
    coneq[754]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/1596672.
    coneq[755]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))))-1/532224.
    coneq[756]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,c**2))))))-1/199584.
    coneq[757]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)))))))-1/399168.
    coneq[758]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**4*dot(A,c))))))-1/133056.
    coneq[759]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))))-1/598752.
    coneq[760]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/1197504.
    coneq[761]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/2395008.
    coneq[762]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3))))))-1/532224.
    coneq[763]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/1596672.
    coneq[764]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/3193344.
    coneq[765]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/1064448.
    coneq[766]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))))-1/399168.
    coneq[767]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/798336.
    coneq[768]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))))-1/266112.
    coneq[769]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/532224.
    coneq[770]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**5)))))-1/57024.
    coneq[771]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**4))))))-1/285120.
    coneq[772]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3)))))))-1/1140480.
    coneq[773]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/3421440.
    coneq[774]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/6842880.
    coneq[775]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/2280960.
    coneq[776]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))))-1/855360.
    coneq[777]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1710720.
    coneq[778]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))))-1/570240.
    coneq[779]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1140480.
    coneq[780]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c**3))))))-1/228096.
    coneq[781]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))))-1/684288.
    coneq[782]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1368576.
    coneq[783]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))))-1/456192.
    coneq[784]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,c**2))))))-1/171072.
    coneq[785]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))))-1/342144.
    coneq[786]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**3*dot(A,c))))))-1/114048.
    coneq[787]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))))-1/342144.
    coneq[788]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/684288.
    coneq[789]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))))-1/228096.
    coneq[790]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**4)))))-1/47520.
    coneq[791]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c**3))))))-1/190080.
    coneq[792]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))))-1/570240.
    coneq[793]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1140480.
    coneq[794]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))))-1/380160.
    coneq[795]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,c**2))))))-1/142560.
    coneq[796]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))))-1/285120.
    coneq[797]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2*dot(A,c))))))-1/95040.
    coneq[798]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))))-1/190080.
    coneq[799]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c**3)))))-1/38016.
    coneq[800]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,c**2))))))-1/114048.
    coneq[801]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)))))))-1/228096.
    coneq[802]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c*dot(A,c))))))-1/76032.
    coneq[803]=dot(b,dot(A,c*dot(A,dot(A,c**4*dot(A,c**2)))))-1/28512.
    coneq[804]=dot(b,dot(A,c*dot(A,dot(A,c**4*dot(A,dot(A,c))))))-1/57024.
    coneq[805]=dot(b,dot(A,c*dot(A,dot(A,c**5*dot(A,c)))))-1/19008.
    coneq[806]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c**3)))))-1/114048.
    coneq[807]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))))-1/342144.
    coneq[808]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/684288.
    coneq[809]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))))-1/228096.
    coneq[810]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3)))))-1/228096.
    coneq[811]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/684288.
    coneq[812]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/1368576.
    coneq[813]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/456192.
    coneq[814]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**4)))))-1/95040.
    coneq[815]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3))))))-1/380160.
    coneq[816]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/1140480.
    coneq[817]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2280960.
    coneq[818]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/760320.
    coneq[819]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))))-1/285120.
    coneq[820]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/570240.
    coneq[821]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))))-1/190080.
    coneq[822]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/380160.
    coneq[823]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2)))))-1/85536.
    coneq[824]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))))-1/171072.
    coneq[825]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/342144.
    coneq[826]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c**3)))))-1/76032.
    coneq[827]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))))-1/228096.
    coneq[828]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/456192.
    coneq[829]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))))-1/152064.
    coneq[830]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2)))))-1/57024.
    coneq[831]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))))-1/114048.
    coneq[832]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c)*dot(A,c)))))-1/38016.
    coneq[833]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/114048.
    coneq[834]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/228096.
    coneq[835]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))))-1/76032.
    coneq[836]=dot(b,dot(A,c*dot(A,c*dot(A,c**6))))-1/8316.
    coneq[837]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**5)))))-1/49896.
    coneq[838]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**4))))))-1/249480.
    coneq[839]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/997920.
    coneq[840]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/2993760.
    coneq[841]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/5987520.
    coneq[842]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/1995840.
    coneq[843]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/748440.
    coneq[844]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1496880.
    coneq[845]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/498960.
    coneq[846]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/997920.
    coneq[847]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c**3))))))-1/199584.
    coneq[848]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/598752.
    coneq[849]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1197504.
    coneq[850]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/399168.
    coneq[851]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,c**2))))))-1/149688.
    coneq[852]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/299376.
    coneq[853]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**3*dot(A,c))))))-1/99792.
    coneq[854]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/299376.
    coneq[855]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/598752.
    coneq[856]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/199584.
    coneq[857]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**4)))))-1/41580.
    coneq[858]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c**3))))))-1/166320.
    coneq[859]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/498960.
    coneq[860]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/997920.
    coneq[861]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/332640.
    coneq[862]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,c**2))))))-1/124740.
    coneq[863]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/249480.
    coneq[864]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2*dot(A,c))))))-1/83160.
    coneq[865]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/166320.
    coneq[866]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c**3)))))-1/33264.
    coneq[867]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,c**2))))))-1/99792.
    coneq[868]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/199584.
    coneq[869]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c*dot(A,c))))))-1/66528.
    coneq[870]=dot(b,dot(A,c*dot(A,c*dot(A,c**3*dot(A,c**2)))))-1/24948.
    coneq[871]=dot(b,dot(A,c*dot(A,c*dot(A,c**3*dot(A,dot(A,c))))))-1/49896.
    coneq[872]=dot(b,dot(A,c*dot(A,c*dot(A,c**4*dot(A,c)))))-1/16632.
    coneq[873]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/74844.
    coneq[874]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/149688.
    coneq[875]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/299376.
    coneq[876]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c**3)))))-1/66528.
    coneq[877]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/199584.
    coneq[878]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/399168.
    coneq[879]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/133056.
    coneq[880]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/49896.
    coneq[881]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/99792.
    coneq[882]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/33264.
    coneq[883]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/66528.
    coneq[884]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**5))))-1/7128.
    coneq[885]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**4)))))-1/35640.
    coneq[886]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c**3))))))-1/142560.
    coneq[887]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/427680.
    coneq[888]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/855360.
    coneq[889]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/285120.
    coneq[890]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,c**2))))))-1/106920.
    coneq[891]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/213840.
    coneq[892]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2*dot(A,c))))))-1/71280.
    coneq[893]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/142560.
    coneq[894]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c**3)))))-1/28512.
    coneq[895]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,c**2))))))-1/85536.
    coneq[896]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/171072.
    coneq[897]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c*dot(A,c))))))-1/57024.
    coneq[898]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,c**2)))))-1/21384.
    coneq[899]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,dot(A,c))))))-1/42768.
    coneq[900]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**3*dot(A,c)))))-1/14256.
    coneq[901]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2)))))-1/42768.
    coneq[902]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/85536.
    coneq[903]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)))))-1/28512.
    coneq[904]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**4))))-1/5940.
    coneq[905]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c**3)))))-1/23760.
    coneq[906]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,c**2))))))-1/71280.
    coneq[907]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)))))))-1/142560.
    coneq[908]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c*dot(A,c))))))-1/47520.
    coneq[909]=dot(b,dot(A,c*dot(A,c**3*dot(A,c*dot(A,c**2)))))-1/17820.
    coneq[910]=dot(b,dot(A,c*dot(A,c**3*dot(A,c*dot(A,dot(A,c))))))-1/35640.
    coneq[911]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**2*dot(A,c)))))-1/11880.
    coneq[912]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c)*dot(A,c)))))-1/23760.
    coneq[913]=dot(b,dot(A,c*dot(A,c**4*dot(A,c**3))))-1/4752.
    coneq[914]=dot(b,dot(A,c*dot(A,c**4*dot(A,dot(A,c**2)))))-1/14256.
    coneq[915]=dot(b,dot(A,c*dot(A,c**4*dot(A,dot(A,dot(A,c))))))-1/28512.
    coneq[916]=dot(b,dot(A,c*dot(A,c**4*dot(A,c*dot(A,c)))))-1/9504.
    coneq[917]=dot(b,dot(A,c*dot(A,c**5*dot(A,c**2))))-1/3564.
    coneq[918]=dot(b,dot(A,c*dot(A,c**5*dot(A,dot(A,c)))))-1/7128.
    coneq[919]=dot(b,dot(A,c*dot(A,c**6*dot(A,c))))-1/2376.
    coneq[920]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,c**3))))-1/19008.
    coneq[921]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,dot(A,c**2)))))-1/57024.
    coneq[922]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c))))))-1/114048.
    coneq[923]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,c*dot(A,c)))))-1/38016.
    coneq[924]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))))-1/171072.
    coneq[925]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))))-1/342144.
    coneq[926]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))))-1/114048.
    coneq[927]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))))-1/684288.
    coneq[928]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))))-1/228096.
    coneq[929]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))))-1/76032.
    coneq[930]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**4))))-1/17820.
    coneq[931]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c**3)))))-1/71280.
    coneq[932]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))))-1/213840.
    coneq[933]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/427680.
    coneq[934]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))))-1/142560.
    coneq[935]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2)))))-1/53460.
    coneq[936]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))))-1/106920.
    coneq[937]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)))))-1/35640.
    coneq[938]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))))-1/71280.
    coneq[939]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**4))))-1/35640.
    coneq[940]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3)))))-1/142560.
    coneq[941]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/427680.
    coneq[942]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/855360.
    coneq[943]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/285120.
    coneq[944]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))))-1/106920.
    coneq[945]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/213840.
    coneq[946]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))))-1/71280.
    coneq[947]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/142560.
    coneq[948]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**5))))-1/14256.
    coneq[949]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**4)))))-1/71280.
    coneq[950]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3))))))-1/285120.
    coneq[951]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/855360.
    coneq[952]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1710720.
    coneq[953]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/570240.
    coneq[954]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))))-1/213840.
    coneq[955]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/427680.
    coneq[956]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))))-1/142560.
    coneq[957]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/285120.
    coneq[958]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c**3)))))-1/57024.
    coneq[959]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))))-1/171072.
    coneq[960]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/342144.
    coneq[961]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))))-1/114048.
    coneq[962]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2)))))-1/42768.
    coneq[963]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))))-1/85536.
    coneq[964]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**3*dot(A,c)))))-1/28512.
    coneq[965]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))))-1/85536.
    coneq[966]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/171072.
    coneq[967]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))))-1/57024.
    coneq[968]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c**3))))-1/14256.
    coneq[969]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/42768.
    coneq[970]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/85536.
    coneq[971]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/28512.
    coneq[972]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,c**3))))-1/28512.
    coneq[973]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/85536.
    coneq[974]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/171072.
    coneq[975]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/57024.
    coneq[976]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**4))))-1/11880.
    coneq[977]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c**3)))))-1/47520.
    coneq[978]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/142560.
    coneq[979]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/285120.
    coneq[980]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/95040.
    coneq[981]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2)))))-1/35640.
    coneq[982]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/71280.
    coneq[983]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)))))-1/23760.
    coneq[984]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/47520.
    coneq[985]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)*dot(A,c**2))))-1/10692.
    coneq[986]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)))))-1/21384.
    coneq[987]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/42768.
    coneq[988]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c**3))))-1/9504.
    coneq[989]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2)))))-1/28512.
    coneq[990]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/57024.
    coneq[991]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)))))-1/19008.
    coneq[992]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,c**2))))-1/7128.
    coneq[993]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,dot(A,c)))))-1/14256.
    coneq[994]=dot(b,dot(A,c*dot(A,c**4*dot(A,c)*dot(A,c))))-1/4752.
    coneq[995]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c**3))))-1/19008.
    coneq[996]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))))-1/57024.
    coneq[997]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/114048.
    coneq[998]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))))-1/38016.
    coneq[999]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2))))-1/21384.
    coneq[1000]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))))-1/42768.
    coneq[1001]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/85536.
    coneq[1002]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2))))-1/14256.
    coneq[1003]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/28512.
    coneq[1004]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c))))-1/9504.
    coneq[1005]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))))-1/19008.
    coneq[1006]=dot(b,dot(A,c**2*dot(A,c**7)))-1/1056.
    coneq[1007]=dot(b,dot(A,c**2*dot(A,dot(A,c**6))))-1/7392.
    coneq[1008]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**5)))))-1/44352.
    coneq[1009]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**4))))))-1/221760.
    coneq[1010]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/887040.
    coneq[1011]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/2661120.
    coneq[1012]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/5322240.
    coneq[1013]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/1774080.
    coneq[1014]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/665280.
    coneq[1015]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1330560.
    coneq[1016]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/443520.
    coneq[1017]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/887040.
    coneq[1018]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c**3))))))-1/177408.
    coneq[1019]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/532224.
    coneq[1020]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1064448.
    coneq[1021]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/354816.
    coneq[1022]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))-1/133056.
    coneq[1023]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/266112.
    coneq[1024]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**3*dot(A,c))))))-1/88704.
    coneq[1025]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/266112.
    coneq[1026]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/532224.
    coneq[1027]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/177408.
    coneq[1028]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**4)))))-1/36960.
    coneq[1029]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c**3))))))-1/147840.
    coneq[1030]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/443520.
    coneq[1031]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/887040.
    coneq[1032]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/295680.
    coneq[1033]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))-1/110880.
    coneq[1034]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/221760.
    coneq[1035]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))-1/73920.
    coneq[1036]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/147840.
    coneq[1037]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c**3)))))-1/29568.
    coneq[1038]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))-1/88704.
    coneq[1039]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/177408.
    coneq[1040]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))-1/59136.
    coneq[1041]=dot(b,dot(A,c**2*dot(A,dot(A,c**3*dot(A,c**2)))))-1/22176.
    coneq[1042]=dot(b,dot(A,c**2*dot(A,dot(A,c**3*dot(A,dot(A,c))))))-1/44352.
    coneq[1043]=dot(b,dot(A,c**2*dot(A,dot(A,c**4*dot(A,c)))))-1/14784.
    coneq[1044]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))-1/66528.
    coneq[1045]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/133056.
    coneq[1046]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/266112.
    coneq[1047]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c**3)))))-1/59136.
    coneq[1048]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/177408.
    coneq[1049]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/354816.
    coneq[1050]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/118272.
    coneq[1051]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))-1/44352.
    coneq[1052]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/88704.
    coneq[1053]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))-1/29568.
    coneq[1054]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/59136.
    coneq[1055]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**5))))-1/6336.
    coneq[1056]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**4)))))-1/31680.
    coneq[1057]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c**3))))))-1/126720.
    coneq[1058]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/380160.
    coneq[1059]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/760320.
    coneq[1060]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/253440.
    coneq[1061]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))-1/95040.
    coneq[1062]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/190080.
    coneq[1063]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))-1/63360.
    coneq[1064]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/126720.
    coneq[1065]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c**3)))))-1/25344.
    coneq[1066]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))-1/76032.
    coneq[1067]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/152064.
    coneq[1068]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))-1/50688.
    coneq[1069]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,c**2)))))-1/19008.
    coneq[1070]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))-1/38016.
    coneq[1071]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**3*dot(A,c)))))-1/12672.
    coneq[1072]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))-1/38016.
    coneq[1073]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/76032.
    coneq[1074]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))-1/25344.
    coneq[1075]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**4))))-1/5280.
    coneq[1076]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c**3)))))-1/21120.
    coneq[1077]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))-1/63360.
    coneq[1078]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))-1/126720.
    coneq[1079]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))-1/42240.
    coneq[1080]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,c**2)))))-1/15840.
    coneq[1081]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))-1/31680.
    coneq[1082]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**2*dot(A,c)))))-1/10560.
    coneq[1083]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))-1/21120.
    coneq[1084]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c**3))))-1/4224.
    coneq[1085]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,dot(A,c**2)))))-1/12672.
    coneq[1086]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,dot(A,dot(A,c))))))-1/25344.
    coneq[1087]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c*dot(A,c)))))-1/8448.
    coneq[1088]=dot(b,dot(A,c**2*dot(A,c**4*dot(A,c**2))))-1/3168.
    coneq[1089]=dot(b,dot(A,c**2*dot(A,c**4*dot(A,dot(A,c)))))-1/6336.
    coneq[1090]=dot(b,dot(A,c**2*dot(A,c**5*dot(A,c))))-1/2112.
    coneq[1091]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c**3))))-1/12672.
    coneq[1092]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))-1/38016.
    coneq[1093]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/76032.
    coneq[1094]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))-1/25344.
    coneq[1095]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,c**3))))-1/25344.
    coneq[1096]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/76032.
    coneq[1097]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/152064.
    coneq[1098]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/50688.
    coneq[1099]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**4))))-1/10560.
    coneq[1100]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c**3)))))-1/42240.
    coneq[1101]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/126720.
    coneq[1102]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/253440.
    coneq[1103]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/84480.
    coneq[1104]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))-1/31680.
    coneq[1105]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/63360.
    coneq[1106]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))-1/21120.
    coneq[1107]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/42240.
    coneq[1108]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)*dot(A,c**2))))-1/9504.
    coneq[1109]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))-1/19008.
    coneq[1110]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/38016.
    coneq[1111]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c**3))))-1/8448.
    coneq[1112]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))-1/25344.
    coneq[1113]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/50688.
    coneq[1114]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))-1/16896.
    coneq[1115]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,c**2))))-1/6336.
    coneq[1116]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))-1/12672.
    coneq[1117]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c)*dot(A,c))))-1/4224.
    coneq[1118]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))-1/12672.
    coneq[1119]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/25344.
    coneq[1120]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))-1/8448.
    coneq[1121]=dot(b,dot(A,c**3*dot(A,c**6)))-1/924.
    coneq[1122]=dot(b,dot(A,c**3*dot(A,dot(A,c**5))))-1/5544.
    coneq[1123]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**4)))))-1/27720.
    coneq[1124]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/110880.
    coneq[1125]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/332640.
    coneq[1126]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/665280.
    coneq[1127]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/221760.
    coneq[1128]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/83160.
    coneq[1129]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/166320.
    coneq[1130]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/55440.
    coneq[1131]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/110880.
    coneq[1132]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c**3)))))-1/22176.
    coneq[1133]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/66528.
    coneq[1134]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/133056.
    coneq[1135]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/44352.
    coneq[1136]=dot(b,dot(A,c**3*dot(A,dot(A,c**2*dot(A,c**2)))))-1/16632.
    coneq[1137]=dot(b,dot(A,c**3*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/33264.
    coneq[1138]=dot(b,dot(A,c**3*dot(A,dot(A,c**3*dot(A,c)))))-1/11088.
    coneq[1139]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/33264.
    coneq[1140]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/66528.
    coneq[1141]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/22176.
    coneq[1142]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**4))))-1/4620.
    coneq[1143]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c**3)))))-1/18480.
    coneq[1144]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/55440.
    coneq[1145]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/110880.
    coneq[1146]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/36960.
    coneq[1147]=dot(b,dot(A,c**3*dot(A,c*dot(A,c*dot(A,c**2)))))-1/13860.
    coneq[1148]=dot(b,dot(A,c**3*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/27720.
    coneq[1149]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**2*dot(A,c)))))-1/9240.
    coneq[1150]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/18480.
    coneq[1151]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c**3))))-1/3696.
    coneq[1152]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,dot(A,c**2)))))-1/11088.
    coneq[1153]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/22176.
    coneq[1154]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c*dot(A,c)))))-1/7392.
    coneq[1155]=dot(b,dot(A,c**3*dot(A,c**3*dot(A,c**2))))-1/2772.
    coneq[1156]=dot(b,dot(A,c**3*dot(A,c**3*dot(A,dot(A,c)))))-1/5544.
    coneq[1157]=dot(b,dot(A,c**3*dot(A,c**4*dot(A,c))))-1/1848.
    coneq[1158]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)*dot(A,c**2))))-1/8316.
    coneq[1159]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/16632.
    coneq[1160]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/33264.
    coneq[1161]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c**3))))-1/7392.
    coneq[1162]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/22176.
    coneq[1163]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/44352.
    coneq[1164]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/14784.
    coneq[1165]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,c**2))))-1/5544.
    coneq[1166]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/11088.
    coneq[1167]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c)*dot(A,c))))-1/3696.
    coneq[1168]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/7392.
    coneq[1169]=dot(b,dot(A,c**4*dot(A,c**5)))-1/792.
    coneq[1170]=dot(b,dot(A,c**4*dot(A,dot(A,c**4))))-1/3960.
    coneq[1171]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c**3)))))-1/15840.
    coneq[1172]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/47520.
    coneq[1173]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/95040.
    coneq[1174]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/31680.
    coneq[1175]=dot(b,dot(A,c**4*dot(A,dot(A,c*dot(A,c**2)))))-1/11880.
    coneq[1176]=dot(b,dot(A,c**4*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/23760.
    coneq[1177]=dot(b,dot(A,c**4*dot(A,dot(A,c**2*dot(A,c)))))-1/7920.
    coneq[1178]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/15840.
    coneq[1179]=dot(b,dot(A,c**4*dot(A,c*dot(A,c**3))))-1/3168.
    coneq[1180]=dot(b,dot(A,c**4*dot(A,c*dot(A,dot(A,c**2)))))-1/9504.
    coneq[1181]=dot(b,dot(A,c**4*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/19008.
    coneq[1182]=dot(b,dot(A,c**4*dot(A,c*dot(A,c*dot(A,c)))))-1/6336.
    coneq[1183]=dot(b,dot(A,c**4*dot(A,c**2*dot(A,c**2))))-1/2376.
    coneq[1184]=dot(b,dot(A,c**4*dot(A,c**2*dot(A,dot(A,c)))))-1/4752.
    coneq[1185]=dot(b,dot(A,c**4*dot(A,c**3*dot(A,c))))-1/1584.
    coneq[1186]=dot(b,dot(A,c**4*dot(A,dot(A,c)*dot(A,c**2))))-1/4752.
    coneq[1187]=dot(b,dot(A,c**4*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/9504.
    coneq[1188]=dot(b,dot(A,c**4*dot(A,c*dot(A,c)*dot(A,c))))-1/3168.
    coneq[1189]=dot(b,dot(A,c**5*dot(A,c**4)))-1/660.
    coneq[1190]=dot(b,dot(A,c**5*dot(A,dot(A,c**3))))-1/2640.
    coneq[1191]=dot(b,dot(A,c**5*dot(A,dot(A,dot(A,c**2)))))-1/7920.
    coneq[1192]=dot(b,dot(A,c**5*dot(A,dot(A,dot(A,dot(A,c))))))-1/15840.
    coneq[1193]=dot(b,dot(A,c**5*dot(A,dot(A,c*dot(A,c)))))-1/5280.
    coneq[1194]=dot(b,dot(A,c**5*dot(A,c*dot(A,c**2))))-1/1980.
    coneq[1195]=dot(b,dot(A,c**5*dot(A,c*dot(A,dot(A,c)))))-1/3960.
    coneq[1196]=dot(b,dot(A,c**5*dot(A,c**2*dot(A,c))))-1/1320.
    coneq[1197]=dot(b,dot(A,c**5*dot(A,dot(A,c)*dot(A,c))))-1/2640.
    coneq[1198]=dot(b,dot(A,c**6*dot(A,c**3)))-1/528.
    coneq[1199]=dot(b,dot(A,c**6*dot(A,dot(A,c**2))))-1/1584.
    coneq[1200]=dot(b,dot(A,c**6*dot(A,dot(A,dot(A,c)))))-1/3168.
    coneq[1201]=dot(b,dot(A,c**6*dot(A,c*dot(A,c))))-1/1056.
    coneq[1202]=dot(b,dot(A,c**7*dot(A,c**2)))-1/396.
    coneq[1203]=dot(b,dot(A,c**7*dot(A,dot(A,c))))-1/792.
    coneq[1204]=dot(b,dot(A,c**8*dot(A,c)))-1/264.
    coneq[1205]=dot(b,dot(A,dot(A,c**4)*dot(A,c**4)))-1/3300.
    coneq[1206]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,c**3))))-1/13200.
    coneq[1207]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,dot(A,c**2)))))-1/39600.
    coneq[1208]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,dot(A,dot(A,c))))))-1/79200.
    coneq[1209]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,c*dot(A,c)))))-1/26400.
    coneq[1210]=dot(b,dot(A,dot(A,c**4)*dot(A,c*dot(A,c**2))))-1/9900.
    coneq[1211]=dot(b,dot(A,dot(A,c**4)*dot(A,c*dot(A,dot(A,c)))))-1/19800.
    coneq[1212]=dot(b,dot(A,dot(A,c**4)*dot(A,c**2*dot(A,c))))-1/6600.
    coneq[1213]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,c)*dot(A,c))))-1/13200.
    coneq[1214]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c**3))))-1/52800.
    coneq[1215]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,c**2)))))-1/158400.
    coneq[1216]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,dot(A,c))))))-1/316800.
    coneq[1217]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c*dot(A,c)))))-1/105600.
    coneq[1218]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c*dot(A,c**2))))-1/39600.
    coneq[1219]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c*dot(A,dot(A,c)))))-1/79200.
    coneq[1220]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c**2*dot(A,c))))-1/26400.
    coneq[1221]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c)*dot(A,c))))-1/52800.
    coneq[1222]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c**2)))))-1/475200.
    coneq[1223]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,dot(A,c))))))-1/950400.
    coneq[1224]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c*dot(A,c)))))-1/316800.
    coneq[1225]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,c**2))))-1/118800.
    coneq[1226]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,dot(A,c)))))-1/237600.
    coneq[1227]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2*dot(A,c))))-1/79200.
    coneq[1228]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c)*dot(A,c))))-1/158400.
    coneq[1229]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,dot(A,c))))))-1/1900800.
    coneq[1230]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c*dot(A,c)))))-1/633600.
    coneq[1231]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c**2))))-1/237600.
    coneq[1232]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,dot(A,c)))))-1/475200.
    coneq[1233]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2*dot(A,c))))-1/158400.
    coneq[1234]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)*dot(A,c))))-1/316800.
    coneq[1235]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c*dot(A,c)))))-1/211200.
    coneq[1236]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,c**2))))-1/79200.
    coneq[1237]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,dot(A,c)))))-1/158400.
    coneq[1238]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2*dot(A,c))))-1/52800.
    coneq[1239]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c)*dot(A,c))))-1/105600.
    coneq[1240]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c**2))))-1/29700.
    coneq[1241]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,dot(A,c)))))-1/59400.
    coneq[1242]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c**2*dot(A,c))))-1/19800.
    coneq[1243]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,c)*dot(A,c))))-1/39600.
    coneq[1244]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c)))))-1/118800.
    coneq[1245]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2*dot(A,c))))-1/39600.
    coneq[1246]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c))))-1/79200.
    coneq[1247]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,c**2*dot(A,c))))-1/13200.
    coneq[1248]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/26400.
    coneq[1249]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/52800.
    coneq[1250]=dot(b,dot(A,dot(A,c**3)*dot(A,c**5)))-1/3168.
    coneq[1251]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**4))))-1/15840.
    coneq[1252]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c**3)))))-1/63360.
    coneq[1253]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/190080.
    coneq[1254]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/380160.
    coneq[1255]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/126720.
    coneq[1256]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,c**2)))))-1/47520.
    coneq[1257]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/95040.
    coneq[1258]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**2*dot(A,c)))))-1/31680.
    coneq[1259]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/63360.
    coneq[1260]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c**3))))-1/12672.
    coneq[1261]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,c**2)))))-1/38016.
    coneq[1262]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/76032.
    coneq[1263]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c*dot(A,c)))))-1/25344.
    coneq[1264]=dot(b,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,c**2))))-1/9504.
    coneq[1265]=dot(b,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,dot(A,c)))))-1/19008.
    coneq[1266]=dot(b,dot(A,dot(A,c**3)*dot(A,c**3*dot(A,c))))-1/6336.
    coneq[1267]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,c**2))))-1/19008.
    coneq[1268]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/38016.
    coneq[1269]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c)*dot(A,c))))-1/12672.
    coneq[1270]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**5)))-1/9504.
    coneq[1271]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**4))))-1/47520.
    coneq[1272]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**3)))))-1/190080.
    coneq[1273]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/570240.
    coneq[1274]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/1140480.
    coneq[1275]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/380160.
    coneq[1276]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c**2)))))-1/142560.
    coneq[1277]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/285120.
    coneq[1278]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2*dot(A,c)))))-1/95040.
    coneq[1279]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/190080.
    coneq[1280]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c**3))))-1/38016.
    coneq[1281]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c**2)))))-1/114048.
    coneq[1282]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/228096.
    coneq[1283]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c*dot(A,c)))))-1/76032.
    coneq[1284]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c**2))))-1/28512.
    coneq[1285]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,dot(A,c)))))-1/57024.
    coneq[1286]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**3*dot(A,c))))-1/19008.
    coneq[1287]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c**2))))-1/57024.
    coneq[1288]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/114048.
    coneq[1289]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)*dot(A,c))))-1/38016.
    coneq[1290]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**5)))-1/19008.
    coneq[1291]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**4))))-1/95040.
    coneq[1292]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**3)))))-1/380160.
    coneq[1293]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/1140480.
    coneq[1294]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/2280960.
    coneq[1295]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/760320.
    coneq[1296]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c**2)))))-1/285120.
    coneq[1297]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/570240.
    coneq[1298]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2*dot(A,c)))))-1/190080.
    coneq[1299]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/380160.
    coneq[1300]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**3))))-1/76032.
    coneq[1301]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c**2)))))-1/228096.
    coneq[1302]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/456192.
    coneq[1303]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c*dot(A,c)))))-1/152064.
    coneq[1304]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c**2))))-1/57024.
    coneq[1305]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,dot(A,c)))))-1/114048.
    coneq[1306]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**3*dot(A,c))))-1/38016.
    coneq[1307]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c**2))))-1/114048.
    coneq[1308]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/228096.
    coneq[1309]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)*dot(A,c))))-1/76032.
    coneq[1310]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**5)))-1/6336.
    coneq[1311]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**4))))-1/31680.
    coneq[1312]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**3)))))-1/126720.
    coneq[1313]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/380160.
    coneq[1314]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/760320.
    coneq[1315]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/253440.
    coneq[1316]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c**2)))))-1/95040.
    coneq[1317]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/190080.
    coneq[1318]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**2*dot(A,c)))))-1/63360.
    coneq[1319]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/126720.
    coneq[1320]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c**3))))-1/25344.
    coneq[1321]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c**2)))))-1/76032.
    coneq[1322]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/152064.
    coneq[1323]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c*dot(A,c)))))-1/50688.
    coneq[1324]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c**2))))-1/19008.
    coneq[1325]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,dot(A,c)))))-1/38016.
    coneq[1326]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**3*dot(A,c))))-1/12672.
    coneq[1327]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c**2))))-1/38016.
    coneq[1328]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/76032.
    coneq[1329]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)*dot(A,c))))-1/25344.
    coneq[1330]=dot(b,dot(A,dot(A,c**2)*dot(A,c**6)))-1/2772.
    coneq[1331]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**5))))-1/16632.
    coneq[1332]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**4)))))-1/83160.
    coneq[1333]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/332640.
    coneq[1334]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/997920.
    coneq[1335]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1995840.
    coneq[1336]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/665280.
    coneq[1337]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/249480.
    coneq[1338]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/498960.
    coneq[1339]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/166320.
    coneq[1340]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/332640.
    coneq[1341]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c**3)))))-1/66528.
    coneq[1342]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/199584.
    coneq[1343]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/399168.
    coneq[1344]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/133056.
    coneq[1345]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c**2)))))-1/49896.
    coneq[1346]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/99792.
    coneq[1347]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**3*dot(A,c)))))-1/33264.
    coneq[1348]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/99792.
    coneq[1349]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/199584.
    coneq[1350]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/66528.
    coneq[1351]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**4))))-1/13860.
    coneq[1352]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c**3)))))-1/55440.
    coneq[1353]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/166320.
    coneq[1354]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/332640.
    coneq[1355]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/110880.
    coneq[1356]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c**2)))))-1/41580.
    coneq[1357]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/83160.
    coneq[1358]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2*dot(A,c)))))-1/27720.
    coneq[1359]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/55440.
    coneq[1360]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c**3))))-1/11088.
    coneq[1361]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c**2)))))-1/33264.
    coneq[1362]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/66528.
    coneq[1363]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c*dot(A,c)))))-1/22176.
    coneq[1364]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,c**2))))-1/8316.
    coneq[1365]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,dot(A,c)))))-1/16632.
    coneq[1366]=dot(b,dot(A,dot(A,c**2)*dot(A,c**4*dot(A,c))))-1/5544.
    coneq[1367]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)*dot(A,c**2))))-1/24948.
    coneq[1368]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/49896.
    coneq[1369]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/99792.
    coneq[1370]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**3))))-1/22176.
    coneq[1371]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/66528.
    coneq[1372]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/133056.
    coneq[1373]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/44352.
    coneq[1374]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c**2))))-1/16632.
    coneq[1375]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/33264.
    coneq[1376]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)*dot(A,c))))-1/11088.
    coneq[1377]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/22176.
    coneq[1378]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**6)))-1/5544.
    coneq[1379]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**5))))-1/33264.
    coneq[1380]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**4)))))-1/166320.
    coneq[1381]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/665280.
    coneq[1382]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1995840.
    coneq[1383]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/3991680.
    coneq[1384]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/1330560.
    coneq[1385]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/498960.
    coneq[1386]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/997920.
    coneq[1387]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/332640.
    coneq[1388]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/665280.
    coneq[1389]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**3)))))-1/133056.
    coneq[1390]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/399168.
    coneq[1391]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/798336.
    coneq[1392]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/266112.
    coneq[1393]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c**2)))))-1/99792.
    coneq[1394]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/199584.
    coneq[1395]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3*dot(A,c)))))-1/66528.
    coneq[1396]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/199584.
    coneq[1397]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/399168.
    coneq[1398]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/133056.
    coneq[1399]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**4))))-1/27720.
    coneq[1400]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**3)))))-1/110880.
    coneq[1401]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/332640.
    coneq[1402]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/665280.
    coneq[1403]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/221760.
    coneq[1404]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c**2)))))-1/83160.
    coneq[1405]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/166320.
    coneq[1406]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2*dot(A,c)))))-1/55440.
    coneq[1407]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/110880.
    coneq[1408]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c**3))))-1/22176.
    coneq[1409]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c**2)))))-1/66528.
    coneq[1410]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/133056.
    coneq[1411]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c*dot(A,c)))))-1/44352.
    coneq[1412]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,c**2))))-1/16632.
    coneq[1413]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,dot(A,c)))))-1/33264.
    coneq[1414]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**4*dot(A,c))))-1/11088.
    coneq[1415]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)*dot(A,c**2))))-1/49896.
    coneq[1416]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/99792.
    coneq[1417]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/199584.
    coneq[1418]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**3))))-1/44352.
    coneq[1419]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/133056.
    coneq[1420]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/266112.
    coneq[1421]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/88704.
    coneq[1422]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c**2))))-1/33264.
    coneq[1423]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/66528.
    coneq[1424]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)*dot(A,c))))-1/22176.
    coneq[1425]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/44352.
    coneq[1426]=dot(b,dot(A,dot(A,c)*dot(A,c**7)))-1/2112.
    coneq[1427]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**6))))-1/14784.
    coneq[1428]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**5)))))-1/88704.
    coneq[1429]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**4))))))-1/443520.
    coneq[1430]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/1774080.
    coneq[1431]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/5322240.
    coneq[1432]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/10644480.
    coneq[1433]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/3548160.
    coneq[1434]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/1330560.
    coneq[1435]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/2661120.
    coneq[1436]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/887040.
    coneq[1437]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1774080.
    coneq[1438]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**3))))))-1/354816.
    coneq[1439]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/1064448.
    coneq[1440]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/2128896.
    coneq[1441]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/709632.
    coneq[1442]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))-1/266112.
    coneq[1443]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/532224.
    coneq[1444]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3*dot(A,c))))))-1/177408.
    coneq[1445]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/532224.
    coneq[1446]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1064448.
    coneq[1447]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/354816.
    coneq[1448]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**4)))))-1/73920.
    coneq[1449]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**3))))))-1/295680.
    coneq[1450]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/887040.
    coneq[1451]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1774080.
    coneq[1452]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/591360.
    coneq[1453]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))-1/221760.
    coneq[1454]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/443520.
    coneq[1455]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))-1/147840.
    coneq[1456]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/295680.
    coneq[1457]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c**3)))))-1/59136.
    coneq[1458]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))-1/177408.
    coneq[1459]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/354816.
    coneq[1460]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))-1/118272.
    coneq[1461]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,c**2)))))-1/44352.
    coneq[1462]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,dot(A,c))))))-1/88704.
    coneq[1463]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**4*dot(A,c)))))-1/29568.
    coneq[1464]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))-1/133056.
    coneq[1465]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/266112.
    coneq[1466]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/532224.
    coneq[1467]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**3)))))-1/118272.
    coneq[1468]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/354816.
    coneq[1469]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/709632.
    coneq[1470]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/236544.
    coneq[1471]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))-1/88704.
    coneq[1472]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/177408.
    coneq[1473]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))-1/59136.
    coneq[1474]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/118272.
    coneq[1475]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**5))))-1/12672.
    coneq[1476]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**4)))))-1/63360.
    coneq[1477]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**3))))))-1/253440.
    coneq[1478]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/760320.
    coneq[1479]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1520640.
    coneq[1480]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/506880.
    coneq[1481]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))-1/190080.
    coneq[1482]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/380160.
    coneq[1483]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))-1/126720.
    coneq[1484]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/253440.
    coneq[1485]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c**3)))))-1/50688.
    coneq[1486]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))-1/152064.
    coneq[1487]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/304128.
    coneq[1488]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))-1/101376.
    coneq[1489]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c**2)))))-1/38016.
    coneq[1490]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))-1/76032.
    coneq[1491]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**3*dot(A,c)))))-1/25344.
    coneq[1492]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))-1/76032.
    coneq[1493]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/152064.
    coneq[1494]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))-1/50688.
    coneq[1495]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**4))))-1/10560.
    coneq[1496]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c**3)))))-1/42240.
    coneq[1497]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))-1/126720.
    coneq[1498]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))-1/253440.
    coneq[1499]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))-1/84480.
    coneq[1500]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c**2)))))-1/31680.
    coneq[1501]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))-1/63360.
    coneq[1502]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2*dot(A,c)))))-1/21120.
    coneq[1503]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))-1/42240.
    coneq[1504]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c**3))))-1/8448.
    coneq[1505]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,c**2)))))-1/25344.
    coneq[1506]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,dot(A,c))))))-1/50688.
    coneq[1507]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c*dot(A,c)))))-1/16896.
    coneq[1508]=dot(b,dot(A,dot(A,c)*dot(A,c**4*dot(A,c**2))))-1/6336.
    coneq[1509]=dot(b,dot(A,dot(A,c)*dot(A,c**4*dot(A,dot(A,c)))))-1/12672.
    coneq[1510]=dot(b,dot(A,dot(A,c)*dot(A,c**5*dot(A,c))))-1/4224.
    coneq[1511]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**3))))-1/25344.
    coneq[1512]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))-1/76032.
    coneq[1513]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/152064.
    coneq[1514]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))-1/50688.
    coneq[1515]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,c**3))))-1/50688.
    coneq[1516]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/152064.
    coneq[1517]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/304128.
    coneq[1518]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/101376.
    coneq[1519]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**4))))-1/21120.
    coneq[1520]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**3)))))-1/84480.
    coneq[1521]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/253440.
    coneq[1522]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/506880.
    coneq[1523]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/168960.
    coneq[1524]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))-1/63360.
    coneq[1525]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/126720.
    coneq[1526]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))-1/42240.
    coneq[1527]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/84480.
    coneq[1528]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)*dot(A,c**2))))-1/19008.
    coneq[1529]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))-1/38016.
    coneq[1530]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/76032.
    coneq[1531]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**3))))-1/16896.
    coneq[1532]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))-1/50688.
    coneq[1533]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/101376.
    coneq[1534]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))-1/33792.
    coneq[1535]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c**2))))-1/12672.
    coneq[1536]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))-1/25344.
    coneq[1537]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c)*dot(A,c))))-1/8448.
    coneq[1538]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))-1/25344.
    coneq[1539]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/50688.
    coneq[1540]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))-1/16896.
    coneq[1541]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c**4)))-1/2640.
    coneq[1542]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c**3))))-1/10560.
    coneq[1543]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,c**2)))))-1/31680.
    coneq[1544]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c))))))-1/63360.
    coneq[1545]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c*dot(A,c)))))-1/21120.
    coneq[1546]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,c**2))))-1/7920.
    coneq[1547]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,dot(A,c)))))-1/15840.
    coneq[1548]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c**2*dot(A,c))))-1/5280.
    coneq[1549]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c)*dot(A,c))))-1/10560.
    coneq[1550]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c**4)))-1/7920.
    coneq[1551]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c**3))))-1/31680.
    coneq[1552]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**2)))))-1/95040.
    coneq[1553]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c))))))-1/190080.
    coneq[1554]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c)))))-1/63360.
    coneq[1555]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,c**2))))-1/23760.
    coneq[1556]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c)))))-1/47520.
    coneq[1557]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c))))-1/15840.
    coneq[1558]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c))))-1/31680.
    coneq[1559]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c**4)))-1/15840.
    coneq[1560]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**3))))-1/63360.
    coneq[1561]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2)))))-1/190080.
    coneq[1562]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c))))))-1/380160.
    coneq[1563]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c)))))-1/126720.
    coneq[1564]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**2))))-1/47520.
    coneq[1565]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c)))))-1/95040.
    coneq[1566]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c))))-1/31680.
    coneq[1567]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c))))-1/63360.
    coneq[1568]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c**4)))-1/5280.
    coneq[1569]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c**3))))-1/21120.
    coneq[1570]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**2)))))-1/63360.
    coneq[1571]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))-1/126720.
    coneq[1572]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c)))))-1/42240.
    coneq[1573]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,c**2))))-1/15840.
    coneq[1574]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c)))))-1/31680.
    coneq[1575]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c))))-1/10560.
    coneq[1576]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/21120.
    coneq[1577]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**5)))-1/2376.
    coneq[1578]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**4))))-1/11880.
    coneq[1579]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c**3)))))-1/47520.
    coneq[1580]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/142560.
    coneq[1581]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/285120.
    coneq[1582]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/95040.
    coneq[1583]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,c**2)))))-1/35640.
    coneq[1584]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/71280.
    coneq[1585]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c)))))-1/23760.
    coneq[1586]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/47520.
    coneq[1587]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c**3))))-1/9504.
    coneq[1588]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,c**2)))))-1/28512.
    coneq[1589]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/57024.
    coneq[1590]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c)))))-1/19008.
    coneq[1591]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,c**2))))-1/7128.
    coneq[1592]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c)))))-1/14256.
    coneq[1593]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**3*dot(A,c))))-1/4752.
    coneq[1594]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**2))))-1/14256.
    coneq[1595]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/28512.
    coneq[1596]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c))))-1/9504.
    coneq[1597]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**5)))-1/4752.
    coneq[1598]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**4))))-1/23760.
    coneq[1599]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**3)))))-1/95040.
    coneq[1600]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/285120.
    coneq[1601]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/570240.
    coneq[1602]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/190080.
    coneq[1603]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**2)))))-1/71280.
    coneq[1604]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/142560.
    coneq[1605]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c)))))-1/47520.
    coneq[1606]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/95040.
    coneq[1607]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c**3))))-1/19008.
    coneq[1608]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**2)))))-1/57024.
    coneq[1609]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/114048.
    coneq[1610]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c)))))-1/38016.
    coneq[1611]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,c**2))))-1/14256.
    coneq[1612]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c)))))-1/28512.
    coneq[1613]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**3*dot(A,c))))-1/9504.
    coneq[1614]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**2))))-1/28512.
    coneq[1615]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/57024.
    coneq[1616]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c))))-1/19008.
    coneq[1617]=dot(b,dot(A,c*dot(A,c)*dot(A,c**6)))-1/1848.
    coneq[1618]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**5))))-1/11088.
    coneq[1619]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**4)))))-1/55440.
    coneq[1620]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/221760.
    coneq[1621]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/665280.
    coneq[1622]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1330560.
    coneq[1623]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/443520.
    coneq[1624]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/166320.
    coneq[1625]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/332640.
    coneq[1626]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/110880.
    coneq[1627]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/221760.
    coneq[1628]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c**3)))))-1/44352.
    coneq[1629]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/133056.
    coneq[1630]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/266112.
    coneq[1631]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/88704.
    coneq[1632]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,c**2)))))-1/33264.
    coneq[1633]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/66528.
    coneq[1634]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**3*dot(A,c)))))-1/22176.
    coneq[1635]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/66528.
    coneq[1636]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/133056.
    coneq[1637]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/44352.
    coneq[1638]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**4))))-1/9240.
    coneq[1639]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c**3)))))-1/36960.
    coneq[1640]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/110880.
    coneq[1641]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/221760.
    coneq[1642]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/73920.
    coneq[1643]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,c**2)))))-1/27720.
    coneq[1644]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/55440.
    coneq[1645]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c)))))-1/18480.
    coneq[1646]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/36960.
    coneq[1647]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c**3))))-1/7392.
    coneq[1648]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,c**2)))))-1/22176.
    coneq[1649]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/44352.
    coneq[1650]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c)))))-1/14784.
    coneq[1651]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,c**2))))-1/5544.
    coneq[1652]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,dot(A,c)))))-1/11088.
    coneq[1653]=dot(b,dot(A,c*dot(A,c)*dot(A,c**4*dot(A,c))))-1/3696.
    coneq[1654]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**2))))-1/16632.
    coneq[1655]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/33264.
    coneq[1656]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/66528.
    coneq[1657]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c**3))))-1/14784.
    coneq[1658]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/44352.
    coneq[1659]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/88704.
    coneq[1660]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/29568.
    coneq[1661]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**2))))-1/11088.
    coneq[1662]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/22176.
    coneq[1663]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c))))-1/7392.
    coneq[1664]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/14784.
    coneq[1665]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,c**3)))-1/2112.
    coneq[1666]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,dot(A,c**2))))-1/6336.
    coneq[1667]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,dot(A,dot(A,c)))))-1/12672.
    coneq[1668]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,c*dot(A,c))))-1/4224.
    coneq[1669]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,dot(A,c**2))))-1/19008.
    coneq[1670]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)))))-1/38016.
    coneq[1671]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,c*dot(A,c))))-1/12672.
    coneq[1672]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))))-1/76032.
    coneq[1673]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c))))-1/25344.
    coneq[1674]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,c*dot(A,c))))-1/8448.
    coneq[1675]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**4)))-1/1980.
    coneq[1676]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c**3))))-1/7920.
    coneq[1677]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,c**2)))))-1/23760.
    coneq[1678]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))))))-1/47520.
    coneq[1679]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c*dot(A,c)))))-1/15840.
    coneq[1680]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,c**2))))-1/5940.
    coneq[1681]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,dot(A,c)))))-1/11880.
    coneq[1682]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**2*dot(A,c))))-1/3960.
    coneq[1683]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c))))-1/7920.
    coneq[1684]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**4)))-1/3960.
    coneq[1685]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c**3))))-1/15840.
    coneq[1686]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)))))-1/47520.
    coneq[1687]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))-1/95040.
    coneq[1688]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)))))-1/31680.
    coneq[1689]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,c**2))))-1/11880.
    coneq[1690]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)))))-1/23760.
    coneq[1691]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**2*dot(A,c))))-1/7920.
    coneq[1692]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/15840.
    coneq[1693]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**5)))-1/1584.
    coneq[1694]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**4))))-1/7920.
    coneq[1695]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c**3)))))-1/31680.
    coneq[1696]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/95040.
    coneq[1697]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/190080.
    coneq[1698]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/63360.
    coneq[1699]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,c**2)))))-1/23760.
    coneq[1700]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/47520.
    coneq[1701]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2*dot(A,c)))))-1/15840.
    coneq[1702]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/31680.
    coneq[1703]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c**3))))-1/6336.
    coneq[1704]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,c**2)))))-1/19008.
    coneq[1705]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/38016.
    coneq[1706]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c*dot(A,c)))))-1/12672.
    coneq[1707]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,c**2))))-1/4752.
    coneq[1708]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,dot(A,c)))))-1/9504.
    coneq[1709]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**3*dot(A,c))))-1/3168.
    coneq[1710]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,c**2))))-1/9504.
    coneq[1711]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/19008.
    coneq[1712]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c))))-1/6336.
    coneq[1713]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,c**3)))-1/1584.
    coneq[1714]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,c**2))))-1/4752.
    coneq[1715]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))-1/9504.
    coneq[1716]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,c*dot(A,c))))-1/3168.
    coneq[1717]=dot(b,dot(A,c**3*dot(A,dot(A,c))*dot(A,c**3)))-1/3168.
    coneq[1718]=dot(b,dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,c**2))))-1/9504.
    coneq[1719]=dot(b,dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))-1/19008.
    coneq[1720]=dot(b,dot(A,c**3*dot(A,dot(A,c))*dot(A,c*dot(A,c))))-1/6336.
    coneq[1721]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c**4)))-1/1320.
    coneq[1722]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,c**3))))-1/5280.
    coneq[1723]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))-1/15840.
    coneq[1724]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))-1/31680.
    coneq[1725]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))-1/10560.
    coneq[1726]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c*dot(A,c**2))))-1/3960.
    coneq[1727]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))-1/7920.
    coneq[1728]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c**2*dot(A,c))))-1/2640.
    coneq[1729]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))-1/5280.
    coneq[1730]=dot(b,dot(A,c**4*dot(A,c**2)*dot(A,c**2)))-1/1188.
    coneq[1731]=dot(b,dot(A,c**4*dot(A,c**2)*dot(A,dot(A,c))))-1/2376.
    coneq[1732]=dot(b,dot(A,c**4*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/4752.
    coneq[1733]=dot(b,dot(A,c**4*dot(A,c)*dot(A,c**3)))-1/1056.
    coneq[1734]=dot(b,dot(A,c**4*dot(A,c)*dot(A,dot(A,c**2))))-1/3168.
    coneq[1735]=dot(b,dot(A,c**4*dot(A,c)*dot(A,dot(A,dot(A,c)))))-1/6336.
    coneq[1736]=dot(b,dot(A,c**4*dot(A,c)*dot(A,c*dot(A,c))))-1/2112.
    coneq[1737]=dot(b,dot(A,c**5*dot(A,c)*dot(A,c**2)))-1/792.
    coneq[1738]=dot(b,dot(A,c**5*dot(A,c)*dot(A,dot(A,c))))-1/1584.
    coneq[1739]=dot(b,dot(A,c**6*dot(A,c)*dot(A,c)))-1/528.
    coneq[1740]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**5)))-1/3168.
    coneq[1741]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**4))))-1/15840.
    coneq[1742]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c**3)))))-1/63360.
    coneq[1743]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/190080.
    coneq[1744]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/380160.
    coneq[1745]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/126720.
    coneq[1746]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,c**2)))))-1/47520.
    coneq[1747]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/95040.
    coneq[1748]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2*dot(A,c)))))-1/31680.
    coneq[1749]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/63360.
    coneq[1750]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c**3))))-1/12672.
    coneq[1751]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,c**2)))))-1/38016.
    coneq[1752]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/76032.
    coneq[1753]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c*dot(A,c)))))-1/25344.
    coneq[1754]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,c**2))))-1/9504.
    coneq[1755]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,dot(A,c)))))-1/19008.
    coneq[1756]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3*dot(A,c))))-1/6336.
    coneq[1757]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,c**2))))-1/19008.
    coneq[1758]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/38016.
    coneq[1759]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c))))-1/12672.
    coneq[1760]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**4)))-1/3960.
    coneq[1761]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c**3))))-1/15840.
    coneq[1762]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,c**2)))))-1/47520.
    coneq[1763]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))))))-1/95040.
    coneq[1764]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c*dot(A,c)))))-1/31680.
    coneq[1765]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,c**2))))-1/11880.
    coneq[1766]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,dot(A,c)))))-1/23760.
    coneq[1767]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2*dot(A,c))))-1/7920.
    coneq[1768]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c))))-1/15840.
    coneq[1769]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c**4)))-1/7920.
    coneq[1770]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c**3))))-1/31680.
    coneq[1771]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)))))-1/95040.
    coneq[1772]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))-1/190080.
    coneq[1773]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)))))-1/63360.
    coneq[1774]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,c**2))))-1/23760.
    coneq[1775]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)))))-1/47520.
    coneq[1776]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c**2*dot(A,c))))-1/15840.
    coneq[1777]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/31680.
    coneq[1778]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,c**3)))-1/4752.
    coneq[1779]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,c**2))))-1/14256.
    coneq[1780]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))-1/28512.
    coneq[1781]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,c*dot(A,c))))-1/9504.
    coneq[1782]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,c**3)))-1/9504.
    coneq[1783]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,c**2))))-1/28512.
    coneq[1784]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))-1/57024.
    coneq[1785]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,c*dot(A,c))))-1/19008.
    coneq[1786]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c**3)))-1/19008.
    coneq[1787]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c**2))))-1/57024.
    coneq[1788]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))-1/114048.
    coneq[1789]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c*dot(A,c))))-1/38016.
    coneq[1790]=dot(b,dot(A,dot(A,c)*dot(A,c**3)*dot(A,c**3)))-1/4224.
    coneq[1791]=dot(b,dot(A,dot(A,c)*dot(A,c**3)*dot(A,dot(A,c**2))))-1/12672.
    coneq[1792]=dot(b,dot(A,dot(A,c)*dot(A,c**3)*dot(A,dot(A,dot(A,c)))))-1/25344.
    coneq[1793]=dot(b,dot(A,dot(A,c)*dot(A,c**3)*dot(A,c*dot(A,c))))-1/8448.
    coneq[1794]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2))*dot(A,dot(A,c**2))))-1/38016.
    coneq[1795]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)))))-1/76032.
    coneq[1796]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2))*dot(A,c*dot(A,c))))-1/25344.
    coneq[1797]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))))-1/152064.
    coneq[1798]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c))))-1/50688.
    coneq[1799]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c))*dot(A,c*dot(A,c))))-1/16896.
    coneq[1800]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**4)))-1/2640.
    coneq[1801]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c**3))))-1/10560.
    coneq[1802]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))-1/31680.
    coneq[1803]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))-1/63360.
    coneq[1804]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))-1/21120.
    coneq[1805]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c**2))))-1/7920.
    coneq[1806]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))-1/15840.
    coneq[1807]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,c))))-1/5280.
    coneq[1808]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))-1/10560.
    coneq[1809]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,c**3)))-1/3168.
    coneq[1810]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c**2))))-1/9504.
    coneq[1811]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))-1/19008.
    coneq[1812]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,c))))-1/6336.
    coneq[1813]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,c**3)))-1/6336.
    coneq[1814]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c**2))))-1/19008.
    coneq[1815]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))-1/38016.
    coneq[1816]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,c))))-1/12672.
    coneq[1817]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2)*dot(A,c**2)))-1/3564.
    coneq[1818]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,c))))-1/7128.
    coneq[1819]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/14256.
    coneq[1820]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/28512.
    coneq[1821]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c**3)))-1/2112.
    coneq[1822]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,dot(A,c**2))))-1/6336.
    coneq[1823]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)))))-1/12672.
    coneq[1824]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c))))-1/4224.
    coneq[1825]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2)*dot(A,c**2)))-1/2376.
    coneq[1826]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c))))-1/4752.
    coneq[1827]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/9504.
    coneq[1828]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c)*dot(A,c**2)))-1/1584.
    coneq[1829]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))-1/3168.
    coneq[1830]=dot(b,dot(A,c**4*dot(A,c)*dot(A,c)*dot(A,c)))-1/1056.
    coneq[1831]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c**3)))-1/4224.
    coneq[1832]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,c**2))))-1/12672.
    coneq[1833]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)))))-1/25344.
    coneq[1834]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c))))-1/8448.
    coneq[1835]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)*dot(A,c**2)))-1/4752.
    coneq[1836]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c))))-1/9504.
    coneq[1837]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))*dot(A,c**2)))-1/9504.
    coneq[1838]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c))))-1/19008.
    coneq[1839]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c**2)))-1/3168.
    coneq[1840]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))-1/6336.
    coneq[1841]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)))-1/2112.
    coneq[1842]=dot(b,dot(A,c**9)*c)-1/120.
    coneq[1843]=dot(b,dot(A,dot(A,c**8))*c)-1/1080.
    coneq[1844]=dot(b,dot(A,dot(A,dot(A,c**7)))*c)-1/8640.
    coneq[1845]=dot(b,dot(A,dot(A,dot(A,dot(A,c**6))))*c)-1/60480.
    coneq[1846]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**5)))))*c)-1/362880.
    coneq[1847]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**4))))))*c)-1/1814400.
    coneq[1848]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))*c)-1/7257600.
    coneq[1849]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))*c)-1/21772800.
    coneq[1850]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))*c)-1/43545600.
    coneq[1851]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))*c)-1/14515200.
    coneq[1852]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))*c)-1/5443200.
    coneq[1853]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))*c)-1/10886400.
    coneq[1854]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))*c)-1/3628800.
    coneq[1855]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))*c)-1/7257600.
    coneq[1856]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3))))))*c)-1/1451520.
    coneq[1857]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))*c)-1/4354560.
    coneq[1858]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))*c)-1/8709120.
    coneq[1859]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))*c)-1/2903040.
    coneq[1860]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))*c)-1/1088640.
    coneq[1861]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))*c)-1/2177280.
    coneq[1862]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c))))))*c)-1/725760.
    coneq[1863]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))*c)-1/2177280.
    coneq[1864]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))*c)-1/4354560.
    coneq[1865]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))*c)-1/1451520.
    coneq[1866]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**4)))))*c)-1/302400.
    coneq[1867]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3))))))*c)-1/1209600.
    coneq[1868]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))*c)-1/3628800.
    coneq[1869]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))*c)-1/7257600.
    coneq[1870]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))*c)-1/2419200.
    coneq[1871]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))*c)-1/907200.
    coneq[1872]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))*c)-1/1814400.
    coneq[1873]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))*c)-1/604800.
    coneq[1874]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))*c)-1/1209600.
    coneq[1875]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**3)))))*c)-1/241920.
    coneq[1876]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))*c)-1/725760.
    coneq[1877]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))*c)-1/1451520.
    coneq[1878]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))*c)-1/483840.
    coneq[1879]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c**2)))))*c)-1/181440.
    coneq[1880]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c))))))*c)-1/362880.
    coneq[1881]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,c)))))*c)-1/120960.
    coneq[1882]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))*c)-1/544320.
    coneq[1883]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))*c)-1/1088640.
    coneq[1884]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))*c)-1/2177280.
    coneq[1885]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3)))))*c)-1/483840.
    coneq[1886]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))*c)-1/1451520.
    coneq[1887]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))*c)-1/2903040.
    coneq[1888]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))*c)-1/967680.
    coneq[1889]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))*c)-1/362880.
    coneq[1890]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))*c)-1/725760.
    coneq[1891]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))*c)-1/241920.
    coneq[1892]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))*c)-1/483840.
    coneq[1893]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**5))))*c)-1/51840.
    coneq[1894]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**4)))))*c)-1/259200.
    coneq[1895]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3))))))*c)-1/1036800.
    coneq[1896]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))*c)-1/3110400.
    coneq[1897]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))*c)-1/6220800.
    coneq[1898]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))*c)-1/2073600.
    coneq[1899]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))*c)-1/777600.
    coneq[1900]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))*c)-1/1555200.
    coneq[1901]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))*c)-1/518400.
    coneq[1902]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))*c)-1/1036800.
    coneq[1903]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**3)))))*c)-1/207360.
    coneq[1904]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))*c)-1/622080.
    coneq[1905]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))*c)-1/1244160.
    coneq[1906]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))*c)-1/414720.
    coneq[1907]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2)))))*c)-1/155520.
    coneq[1908]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))*c)-1/311040.
    coneq[1909]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,c)))))*c)-1/103680.
    coneq[1910]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))*c)-1/311040.
    coneq[1911]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))*c)-1/622080.
    coneq[1912]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))*c)-1/207360.
    coneq[1913]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**4))))*c)-1/43200.
    coneq[1914]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**3)))))*c)-1/172800.
    coneq[1915]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))*c)-1/518400.
    coneq[1916]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/1036800.
    coneq[1917]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))*c)-1/345600.
    coneq[1918]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2)))))*c)-1/129600.
    coneq[1919]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))*c)-1/259200.
    coneq[1920]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c)))))*c)-1/86400.
    coneq[1921]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))*c)-1/172800.
    coneq[1922]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**3))))*c)-1/34560.
    coneq[1923]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c**2)))))*c)-1/103680.
    coneq[1924]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c))))))*c)-1/207360.
    coneq[1925]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,c)))))*c)-1/69120.
    coneq[1926]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c**2))))*c)-1/25920.
    coneq[1927]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,c)))))*c)-1/51840.
    coneq[1928]=dot(b,dot(A,dot(A,dot(A,c**5*dot(A,c))))*c)-1/17280.
    coneq[1929]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**3))))*c)-1/103680.
    coneq[1930]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))*c)-1/311040.
    coneq[1931]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))*c)-1/622080.
    coneq[1932]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))*c)-1/207360.
    coneq[1933]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3))))*c)-1/207360.
    coneq[1934]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))*c)-1/622080.
    coneq[1935]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))*c)-1/1244160.
    coneq[1936]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))*c)-1/414720.
    coneq[1937]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**4))))*c)-1/86400.
    coneq[1938]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3)))))*c)-1/345600.
    coneq[1939]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))*c)-1/1036800.
    coneq[1940]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/2073600.
    coneq[1941]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))*c)-1/691200.
    coneq[1942]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))*c)-1/259200.
    coneq[1943]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))*c)-1/518400.
    coneq[1944]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))*c)-1/172800.
    coneq[1945]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))*c)-1/345600.
    coneq[1946]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2))))*c)-1/77760.
    coneq[1947]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))*c)-1/155520.
    coneq[1948]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))*c)-1/311040.
    coneq[1949]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**3))))*c)-1/69120.
    coneq[1950]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))*c)-1/207360.
    coneq[1951]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))*c)-1/414720.
    coneq[1952]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))*c)-1/138240.
    coneq[1953]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2))))*c)-1/51840.
    coneq[1954]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))*c)-1/103680.
    coneq[1955]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,c))))*c)-1/34560.
    coneq[1956]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))*c)-1/103680.
    coneq[1957]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))*c)-1/207360.
    coneq[1958]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))*c)-1/69120.
    coneq[1959]=dot(b,dot(A,dot(A,c*dot(A,c**6)))*c)-1/7560.
    coneq[1960]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**5))))*c)-1/45360.
    coneq[1961]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**4)))))*c)-1/226800.
    coneq[1962]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3))))))*c)-1/907200.
    coneq[1963]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))*c)-1/2721600.
    coneq[1964]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))*c)-1/5443200.
    coneq[1965]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))*c)-1/1814400.
    coneq[1966]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2))))))*c)-1/680400.
    coneq[1967]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))*c)-1/1360800.
    coneq[1968]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c))))))*c)-1/453600.
    coneq[1969]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))*c)-1/907200.
    coneq[1970]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**3)))))*c)-1/181440.
    coneq[1971]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2))))))*c)-1/544320.
    coneq[1972]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))*c)-1/1088640.
    coneq[1973]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c))))))*c)-1/362880.
    coneq[1974]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2)))))*c)-1/136080.
    coneq[1975]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c))))))*c)-1/272160.
    coneq[1976]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,c)))))*c)-1/90720.
    coneq[1977]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))*c)-1/272160.
    coneq[1978]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))*c)-1/544320.
    coneq[1979]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))*c)-1/181440.
    coneq[1980]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**4))))*c)-1/37800.
    coneq[1981]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**3)))))*c)-1/151200.
    coneq[1982]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2))))))*c)-1/453600.
    coneq[1983]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/907200.
    coneq[1984]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c))))))*c)-1/302400.
    coneq[1985]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2)))))*c)-1/113400.
    coneq[1986]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c))))))*c)-1/226800.
    coneq[1987]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c)))))*c)-1/75600.
    coneq[1988]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))*c)-1/151200.
    coneq[1989]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**3))))*c)-1/30240.
    coneq[1990]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2)))))*c)-1/90720.
    coneq[1991]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c))))))*c)-1/181440.
    coneq[1992]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c)))))*c)-1/60480.
    coneq[1993]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c**2))))*c)-1/22680.
    coneq[1994]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,c)))))*c)-1/45360.
    coneq[1995]=dot(b,dot(A,dot(A,c*dot(A,c**4*dot(A,c))))*c)-1/15120.
    coneq[1996]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2))))*c)-1/68040.
    coneq[1997]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))*c)-1/136080.
    coneq[1998]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))*c)-1/272160.
    coneq[1999]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**3))))*c)-1/60480.
    coneq[2000]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))*c)-1/181440.
    coneq[2001]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))*c)-1/362880.
    coneq[2002]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))*c)-1/120960.
    coneq[2003]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2))))*c)-1/45360.
    coneq[2004]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))*c)-1/90720.
    coneq[2005]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c))))*c)-1/30240.
    coneq[2006]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))*c)-1/60480.
    coneq[2007]=dot(b,dot(A,dot(A,c**2*dot(A,c**5)))*c)-1/6480.
    coneq[2008]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**4))))*c)-1/32400.
    coneq[2009]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**3)))))*c)-1/129600.
    coneq[2010]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2))))))*c)-1/388800.
    coneq[2011]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/777600.
    coneq[2012]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c))))))*c)-1/259200.
    coneq[2013]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2)))))*c)-1/97200.
    coneq[2014]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c))))))*c)-1/194400.
    coneq[2015]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c)))))*c)-1/64800.
    coneq[2016]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c)))))*c)-1/129600.
    coneq[2017]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**3))))*c)-1/25920.
    coneq[2018]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2)))))*c)-1/77760.
    coneq[2019]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c))))))*c)-1/155520.
    coneq[2020]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c)))))*c)-1/51840.
    coneq[2021]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c**2))))*c)-1/19440.
    coneq[2022]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c)))))*c)-1/38880.
    coneq[2023]=dot(b,dot(A,dot(A,c**2*dot(A,c**3*dot(A,c))))*c)-1/12960.
    coneq[2024]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2))))*c)-1/38880.
    coneq[2025]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c)))))*c)-1/77760.
    coneq[2026]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c))))*c)-1/25920.
    coneq[2027]=dot(b,dot(A,dot(A,c**3*dot(A,c**4)))*c)-1/5400.
    coneq[2028]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**3))))*c)-1/21600.
    coneq[2029]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c**2)))))*c)-1/64800.
    coneq[2030]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/129600.
    coneq[2031]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,c)))))*c)-1/43200.
    coneq[2032]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c**2))))*c)-1/16200.
    coneq[2033]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,c)))))*c)-1/32400.
    coneq[2034]=dot(b,dot(A,dot(A,c**3*dot(A,c**2*dot(A,c))))*c)-1/10800.
    coneq[2035]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,c))))*c)-1/21600.
    coneq[2036]=dot(b,dot(A,dot(A,c**4*dot(A,c**3)))*c)-1/4320.
    coneq[2037]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c**2))))*c)-1/12960.
    coneq[2038]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,c)))))*c)-1/25920.
    coneq[2039]=dot(b,dot(A,dot(A,c**4*dot(A,c*dot(A,c))))*c)-1/8640.
    coneq[2040]=dot(b,dot(A,dot(A,c**5*dot(A,c**2)))*c)-1/3240.
    coneq[2041]=dot(b,dot(A,dot(A,c**5*dot(A,dot(A,c))))*c)-1/6480.
    coneq[2042]=dot(b,dot(A,dot(A,c**6*dot(A,c)))*c)-1/2160.
    coneq[2043]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c**3)))*c)-1/17280.
    coneq[2044]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c**2))))*c)-1/51840.
    coneq[2045]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c)))))*c)-1/103680.
    coneq[2046]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,c))))*c)-1/34560.
    coneq[2047]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))))*c)-1/155520.
    coneq[2048]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)))))*c)-1/311040.
    coneq[2049]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c))))*c)-1/103680.
    coneq[2050]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))))*c)-1/622080.
    coneq[2051]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c))))*c)-1/207360.
    coneq[2052]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))))*c)-1/69120.
    coneq[2053]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**4)))*c)-1/16200.
    coneq[2054]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**3))))*c)-1/64800.
    coneq[2055]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2)))))*c)-1/194400.
    coneq[2056]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/388800.
    coneq[2057]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c)))))*c)-1/129600.
    coneq[2058]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2))))*c)-1/48600.
    coneq[2059]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c)))))*c)-1/97200.
    coneq[2060]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c))))*c)-1/32400.
    coneq[2061]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c))))*c)-1/64800.
    coneq[2062]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**4)))*c)-1/32400.
    coneq[2063]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3))))*c)-1/129600.
    coneq[2064]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)))))*c)-1/388800.
    coneq[2065]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/777600.
    coneq[2066]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)))))*c)-1/259200.
    coneq[2067]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2))))*c)-1/97200.
    coneq[2068]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)))))*c)-1/194400.
    coneq[2069]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c))))*c)-1/64800.
    coneq[2070]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c))))*c)-1/129600.
    coneq[2071]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**5)))*c)-1/12960.
    coneq[2072]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**4))))*c)-1/64800.
    coneq[2073]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3)))))*c)-1/259200.
    coneq[2074]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2))))))*c)-1/777600.
    coneq[2075]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/1555200.
    coneq[2076]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c))))))*c)-1/518400.
    coneq[2077]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2)))))*c)-1/194400.
    coneq[2078]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c))))))*c)-1/388800.
    coneq[2079]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c)))))*c)-1/129600.
    coneq[2080]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)))))*c)-1/259200.
    coneq[2081]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**3))))*c)-1/51840.
    coneq[2082]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2)))))*c)-1/155520.
    coneq[2083]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c))))))*c)-1/311040.
    coneq[2084]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c)))))*c)-1/103680.
    coneq[2085]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2))))*c)-1/38880.
    coneq[2086]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c)))))*c)-1/77760.
    coneq[2087]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,c))))*c)-1/25920.
    coneq[2088]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2))))*c)-1/77760.
    coneq[2089]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)))))*c)-1/155520.
    coneq[2090]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c))))*c)-1/51840.
    coneq[2091]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**3)))*c)-1/12960.
    coneq[2092]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2))))*c)-1/38880.
    coneq[2093]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))*c)-1/77760.
    coneq[2094]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c))))*c)-1/25920.
    coneq[2095]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**3)))*c)-1/25920.
    coneq[2096]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2))))*c)-1/77760.
    coneq[2097]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))*c)-1/155520.
    coneq[2098]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c))))*c)-1/51840.
    coneq[2099]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**4)))*c)-1/10800.
    coneq[2100]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**3))))*c)-1/43200.
    coneq[2101]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))*c)-1/129600.
    coneq[2102]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/259200.
    coneq[2103]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))*c)-1/86400.
    coneq[2104]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2))))*c)-1/32400.
    coneq[2105]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))*c)-1/64800.
    coneq[2106]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c))))*c)-1/21600.
    coneq[2107]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))*c)-1/43200.
    coneq[2108]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c**2)))*c)-1/9720.
    coneq[2109]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c))))*c)-1/19440.
    coneq[2110]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c))))*c)-1/38880.
    coneq[2111]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**3)))*c)-1/8640.
    coneq[2112]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2))))*c)-1/25920.
    coneq[2113]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c)))))*c)-1/51840.
    coneq[2114]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c))))*c)-1/17280.
    coneq[2115]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c**2)))*c)-1/6480.
    coneq[2116]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,c))))*c)-1/12960.
    coneq[2117]=dot(b,dot(A,dot(A,c**4*dot(A,c)*dot(A,c)))*c)-1/4320.
    coneq[2118]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3)))*c)-1/17280.
    coneq[2119]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2))))*c)-1/51840.
    coneq[2120]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)))))*c)-1/103680.
    coneq[2121]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c))))*c)-1/34560.
    coneq[2122]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2)))*c)-1/19440.
    coneq[2123]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c))))*c)-1/38880.
    coneq[2124]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c))))*c)-1/77760.
    coneq[2125]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2)))*c)-1/12960.
    coneq[2126]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))*c)-1/25920.
    coneq[2127]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c)))*c)-1/8640.
    coneq[2128]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)))*c)-1/17280.
    coneq[2129]=dot(b,dot(A,c*dot(A,c**7))*c)-1/960.
    coneq[2130]=dot(b,dot(A,c*dot(A,dot(A,c**6)))*c)-1/6720.
    coneq[2131]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**5))))*c)-1/40320.
    coneq[2132]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**4)))))*c)-1/201600.
    coneq[2133]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))*c)-1/806400.
    coneq[2134]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))*c)-1/2419200.
    coneq[2135]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))*c)-1/4838400.
    coneq[2136]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))*c)-1/1612800.
    coneq[2137]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))*c)-1/604800.
    coneq[2138]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))*c)-1/1209600.
    coneq[2139]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))*c)-1/403200.
    coneq[2140]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))*c)-1/806400.
    coneq[2141]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**3)))))*c)-1/161280.
    coneq[2142]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))*c)-1/483840.
    coneq[2143]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))*c)-1/967680.
    coneq[2144]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))*c)-1/322560.
    coneq[2145]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))*c)-1/120960.
    coneq[2146]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))*c)-1/241920.
    coneq[2147]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,c)))))*c)-1/80640.
    coneq[2148]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))*c)-1/241920.
    coneq[2149]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))*c)-1/483840.
    coneq[2150]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))*c)-1/161280.
    coneq[2151]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**4))))*c)-1/33600.
    coneq[2152]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**3)))))*c)-1/134400.
    coneq[2153]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))*c)-1/403200.
    coneq[2154]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/806400.
    coneq[2155]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))*c)-1/268800.
    coneq[2156]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))*c)-1/100800.
    coneq[2157]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))*c)-1/201600.
    coneq[2158]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))*c)-1/67200.
    coneq[2159]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))*c)-1/134400.
    coneq[2160]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**3))))*c)-1/26880.
    coneq[2161]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))*c)-1/80640.
    coneq[2162]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))*c)-1/161280.
    coneq[2163]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))*c)-1/53760.
    coneq[2164]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c**2))))*c)-1/20160.
    coneq[2165]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,c)))))*c)-1/40320.
    coneq[2166]=dot(b,dot(A,c*dot(A,dot(A,c**4*dot(A,c))))*c)-1/13440.
    coneq[2167]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))*c)-1/60480.
    coneq[2168]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))*c)-1/120960.
    coneq[2169]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))*c)-1/241920.
    coneq[2170]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**3))))*c)-1/53760.
    coneq[2171]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))*c)-1/161280.
    coneq[2172]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))*c)-1/322560.
    coneq[2173]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))*c)-1/107520.
    coneq[2174]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))*c)-1/40320.
    coneq[2175]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))*c)-1/80640.
    coneq[2176]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))*c)-1/26880.
    coneq[2177]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))*c)-1/53760.
    coneq[2178]=dot(b,dot(A,c*dot(A,c*dot(A,c**5)))*c)-1/5760.
    coneq[2179]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**4))))*c)-1/28800.
    coneq[2180]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**3)))))*c)-1/115200.
    coneq[2181]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))*c)-1/345600.
    coneq[2182]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/691200.
    coneq[2183]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))*c)-1/230400.
    coneq[2184]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))*c)-1/86400.
    coneq[2185]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))*c)-1/172800.
    coneq[2186]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))*c)-1/57600.
    coneq[2187]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))*c)-1/115200.
    coneq[2188]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**3))))*c)-1/23040.
    coneq[2189]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))*c)-1/69120.
    coneq[2190]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))*c)-1/138240.
    coneq[2191]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))*c)-1/46080.
    coneq[2192]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c**2))))*c)-1/17280.
    coneq[2193]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))*c)-1/34560.
    coneq[2194]=dot(b,dot(A,c*dot(A,c*dot(A,c**3*dot(A,c))))*c)-1/11520.
    coneq[2195]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))*c)-1/34560.
    coneq[2196]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))*c)-1/69120.
    coneq[2197]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))*c)-1/23040.
    coneq[2198]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**4)))*c)-1/4800.
    coneq[2199]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**3))))*c)-1/19200.
    coneq[2200]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))*c)-1/57600.
    coneq[2201]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/115200.
    coneq[2202]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))*c)-1/38400.
    coneq[2203]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c**2))))*c)-1/14400.
    coneq[2204]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))*c)-1/28800.
    coneq[2205]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,c))))*c)-1/9600.
    coneq[2206]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))*c)-1/19200.
    coneq[2207]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**3)))*c)-1/3840.
    coneq[2208]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c**2))))*c)-1/11520.
    coneq[2209]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,c)))))*c)-1/23040.
    coneq[2210]=dot(b,dot(A,c*dot(A,c**3*dot(A,c*dot(A,c))))*c)-1/7680.
    coneq[2211]=dot(b,dot(A,c*dot(A,c**4*dot(A,c**2)))*c)-1/2880.
    coneq[2212]=dot(b,dot(A,c*dot(A,c**4*dot(A,dot(A,c))))*c)-1/5760.
    coneq[2213]=dot(b,dot(A,c*dot(A,c**5*dot(A,c)))*c)-1/1920.
    coneq[2214]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**3)))*c)-1/11520.
    coneq[2215]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))*c)-1/34560.
    coneq[2216]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))*c)-1/69120.
    coneq[2217]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))*c)-1/23040.
    coneq[2218]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**3)))*c)-1/23040.
    coneq[2219]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))*c)-1/69120.
    coneq[2220]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))*c)-1/138240.
    coneq[2221]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))*c)-1/46080.
    coneq[2222]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**4)))*c)-1/9600.
    coneq[2223]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**3))))*c)-1/38400.
    coneq[2224]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))*c)-1/115200.
    coneq[2225]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/230400.
    coneq[2226]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))*c)-1/76800.
    coneq[2227]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))*c)-1/28800.
    coneq[2228]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))*c)-1/57600.
    coneq[2229]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))*c)-1/19200.
    coneq[2230]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))*c)-1/38400.
    coneq[2231]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c**2)))*c)-1/8640.
    coneq[2232]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))*c)-1/17280.
    coneq[2233]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))*c)-1/34560.
    coneq[2234]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**3)))*c)-1/7680.
    coneq[2235]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))*c)-1/23040.
    coneq[2236]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))*c)-1/46080.
    coneq[2237]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))*c)-1/15360.
    coneq[2238]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c**2)))*c)-1/5760.
    coneq[2239]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))*c)-1/11520.
    coneq[2240]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,c)))*c)-1/3840.
    coneq[2241]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))*c)-1/11520.
    coneq[2242]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))*c)-1/23040.
    coneq[2243]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))*c)-1/7680.
    coneq[2244]=dot(b,dot(A,c**2*dot(A,c**6))*c)-1/840.
    coneq[2245]=dot(b,dot(A,c**2*dot(A,dot(A,c**5)))*c)-1/5040.
    coneq[2246]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**4))))*c)-1/25200.
    coneq[2247]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**3)))))*c)-1/100800.
    coneq[2248]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*c)-1/302400.
    coneq[2249]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/604800.
    coneq[2250]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*c)-1/201600.
    coneq[2251]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c**2)))))*c)-1/75600.
    coneq[2252]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*c)-1/151200.
    coneq[2253]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,c)))))*c)-1/50400.
    coneq[2254]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*c)-1/100800.
    coneq[2255]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**3))))*c)-1/20160.
    coneq[2256]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c**2)))))*c)-1/60480.
    coneq[2257]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*c)-1/120960.
    coneq[2258]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,c)))))*c)-1/40320.
    coneq[2259]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c**2))))*c)-1/15120.
    coneq[2260]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,c)))))*c)-1/30240.
    coneq[2261]=dot(b,dot(A,c**2*dot(A,dot(A,c**3*dot(A,c))))*c)-1/10080.
    coneq[2262]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c**2))))*c)-1/30240.
    coneq[2263]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*c)-1/60480.
    coneq[2264]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,c))))*c)-1/20160.
    coneq[2265]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**4)))*c)-1/4200.
    coneq[2266]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**3))))*c)-1/16800.
    coneq[2267]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c**2)))))*c)-1/50400.
    coneq[2268]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/100800.
    coneq[2269]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,c)))))*c)-1/33600.
    coneq[2270]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c**2))))*c)-1/12600.
    coneq[2271]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,c)))))*c)-1/25200.
    coneq[2272]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,c))))*c)-1/8400.
    coneq[2273]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,c))))*c)-1/16800.
    coneq[2274]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**3)))*c)-1/3360.
    coneq[2275]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c**2))))*c)-1/10080.
    coneq[2276]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,c)))))*c)-1/20160.
    coneq[2277]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,c))))*c)-1/6720.
    coneq[2278]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c**2)))*c)-1/2520.
    coneq[2279]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,dot(A,c))))*c)-1/5040.
    coneq[2280]=dot(b,dot(A,c**2*dot(A,c**4*dot(A,c)))*c)-1/1680.
    coneq[2281]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c**2)))*c)-1/7560.
    coneq[2282]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,c))))*c)-1/15120.
    coneq[2283]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*c)-1/30240.
    coneq[2284]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**3)))*c)-1/6720.
    coneq[2285]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c**2))))*c)-1/20160.
    coneq[2286]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*c)-1/40320.
    coneq[2287]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,c))))*c)-1/13440.
    coneq[2288]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c**2)))*c)-1/5040.
    coneq[2289]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,c))))*c)-1/10080.
    coneq[2290]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,c)))*c)-1/3360.
    coneq[2291]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*c)-1/6720.
    coneq[2292]=dot(b,dot(A,c**3*dot(A,c**5))*c)-1/720.
    coneq[2293]=dot(b,dot(A,c**3*dot(A,dot(A,c**4)))*c)-1/3600.
    coneq[2294]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**3))))*c)-1/14400.
    coneq[2295]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c**2)))))*c)-1/43200.
    coneq[2296]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/86400.
    coneq[2297]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,c)))))*c)-1/28800.
    coneq[2298]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c**2))))*c)-1/10800.
    coneq[2299]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,c)))))*c)-1/21600.
    coneq[2300]=dot(b,dot(A,c**3*dot(A,dot(A,c**2*dot(A,c))))*c)-1/7200.
    coneq[2301]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,c))))*c)-1/14400.
    coneq[2302]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**3)))*c)-1/2880.
    coneq[2303]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c**2))))*c)-1/8640.
    coneq[2304]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,c)))))*c)-1/17280.
    coneq[2305]=dot(b,dot(A,c**3*dot(A,c*dot(A,c*dot(A,c))))*c)-1/5760.
    coneq[2306]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c**2)))*c)-1/2160.
    coneq[2307]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,dot(A,c))))*c)-1/4320.
    coneq[2308]=dot(b,dot(A,c**3*dot(A,c**3*dot(A,c)))*c)-1/1440.
    coneq[2309]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c**2)))*c)-1/4320.
    coneq[2310]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,c))))*c)-1/8640.
    coneq[2311]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,c)))*c)-1/2880.
    coneq[2312]=dot(b,dot(A,c**4*dot(A,c**4))*c)-1/600.
    coneq[2313]=dot(b,dot(A,c**4*dot(A,dot(A,c**3)))*c)-1/2400.
    coneq[2314]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c**2))))*c)-1/7200.
    coneq[2315]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/14400.
    coneq[2316]=dot(b,dot(A,c**4*dot(A,dot(A,c*dot(A,c))))*c)-1/4800.
    coneq[2317]=dot(b,dot(A,c**4*dot(A,c*dot(A,c**2)))*c)-1/1800.
    coneq[2318]=dot(b,dot(A,c**4*dot(A,c*dot(A,dot(A,c))))*c)-1/3600.
    coneq[2319]=dot(b,dot(A,c**4*dot(A,c**2*dot(A,c)))*c)-1/1200.
    coneq[2320]=dot(b,dot(A,c**4*dot(A,dot(A,c)*dot(A,c)))*c)-1/2400.
    coneq[2321]=dot(b,dot(A,c**5*dot(A,c**3))*c)-1/480.
    coneq[2322]=dot(b,dot(A,c**5*dot(A,dot(A,c**2)))*c)-1/1440.
    coneq[2323]=dot(b,dot(A,c**5*dot(A,dot(A,dot(A,c))))*c)-1/2880.
    coneq[2324]=dot(b,dot(A,c**5*dot(A,c*dot(A,c)))*c)-1/960.
    coneq[2325]=dot(b,dot(A,c**6*dot(A,c**2))*c)-1/360.
    coneq[2326]=dot(b,dot(A,c**6*dot(A,dot(A,c)))*c)-1/720.
    coneq[2327]=dot(b,dot(A,c**7*dot(A,c))*c)-1/240.
    coneq[2328]=dot(b,dot(A,dot(A,c**3)*dot(A,c**4))*c)-1/2400.
    coneq[2329]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**3)))*c)-1/9600.
    coneq[2330]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c**2))))*c)-1/28800.
    coneq[2331]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/57600.
    coneq[2332]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,c))))*c)-1/19200.
    coneq[2333]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c**2)))*c)-1/7200.
    coneq[2334]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,c))))*c)-1/14400.
    coneq[2335]=dot(b,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,c)))*c)-1/4800.
    coneq[2336]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,c)))*c)-1/9600.
    coneq[2337]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**4))*c)-1/7200.
    coneq[2338]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**3)))*c)-1/28800.
    coneq[2339]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**2))))*c)-1/86400.
    coneq[2340]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/172800.
    coneq[2341]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c))))*c)-1/57600.
    coneq[2342]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c**2)))*c)-1/21600.
    coneq[2343]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c))))*c)-1/43200.
    coneq[2344]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c)))*c)-1/14400.
    coneq[2345]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c)))*c)-1/28800.
    coneq[2346]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**4))*c)-1/14400.
    coneq[2347]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**3)))*c)-1/57600.
    coneq[2348]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2))))*c)-1/172800.
    coneq[2349]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/345600.
    coneq[2350]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c))))*c)-1/115200.
    coneq[2351]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**2)))*c)-1/43200.
    coneq[2352]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c))))*c)-1/86400.
    coneq[2353]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c)))*c)-1/28800.
    coneq[2354]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))*c)-1/57600.
    coneq[2355]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**4))*c)-1/4800.
    coneq[2356]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**3)))*c)-1/19200.
    coneq[2357]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**2))))*c)-1/57600.
    coneq[2358]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/115200.
    coneq[2359]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c))))*c)-1/38400.
    coneq[2360]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c**2)))*c)-1/14400.
    coneq[2361]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c))))*c)-1/28800.
    coneq[2362]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c)))*c)-1/9600.
    coneq[2363]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c)))*c)-1/19200.
    coneq[2364]=dot(b,dot(A,dot(A,c**2)*dot(A,c**5))*c)-1/2160.
    coneq[2365]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**4)))*c)-1/10800.
    coneq[2366]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**3))))*c)-1/43200.
    coneq[2367]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**2)))))*c)-1/129600.
    coneq[2368]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/259200.
    coneq[2369]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c)))))*c)-1/86400.
    coneq[2370]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c**2))))*c)-1/32400.
    coneq[2371]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c)))))*c)-1/64800.
    coneq[2372]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c))))*c)-1/21600.
    coneq[2373]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c))))*c)-1/43200.
    coneq[2374]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**3)))*c)-1/8640.
    coneq[2375]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c**2))))*c)-1/25920.
    coneq[2376]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c)))))*c)-1/51840.
    coneq[2377]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c))))*c)-1/17280.
    coneq[2378]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c**2)))*c)-1/6480.
    coneq[2379]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c))))*c)-1/12960.
    coneq[2380]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,c)))*c)-1/4320.
    coneq[2381]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**2)))*c)-1/12960.
    coneq[2382]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c))))*c)-1/25920.
    coneq[2383]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c)))*c)-1/8640.
    coneq[2384]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**5))*c)-1/4320.
    coneq[2385]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**4)))*c)-1/21600.
    coneq[2386]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**3))))*c)-1/86400.
    coneq[2387]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2)))))*c)-1/259200.
    coneq[2388]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/518400.
    coneq[2389]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c)))))*c)-1/172800.
    coneq[2390]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**2))))*c)-1/64800.
    coneq[2391]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c)))))*c)-1/129600.
    coneq[2392]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c))))*c)-1/43200.
    coneq[2393]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c))))*c)-1/86400.
    coneq[2394]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**3)))*c)-1/17280.
    coneq[2395]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**2))))*c)-1/51840.
    coneq[2396]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c)))))*c)-1/103680.
    coneq[2397]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c))))*c)-1/34560.
    coneq[2398]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c**2)))*c)-1/12960.
    coneq[2399]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c))))*c)-1/25920.
    coneq[2400]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,c)))*c)-1/8640.
    coneq[2401]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**2)))*c)-1/25920.
    coneq[2402]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c))))*c)-1/51840.
    coneq[2403]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c)))*c)-1/17280.
    coneq[2404]=dot(b,dot(A,dot(A,c)*dot(A,c**6))*c)-1/1680.
    coneq[2405]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**5)))*c)-1/10080.
    coneq[2406]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**4))))*c)-1/50400.
    coneq[2407]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**3)))))*c)-1/201600.
    coneq[2408]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*c)-1/604800.
    coneq[2409]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c)-1/1209600.
    coneq[2410]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*c)-1/403200.
    coneq[2411]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**2)))))*c)-1/151200.
    coneq[2412]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*c)-1/302400.
    coneq[2413]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c)))))*c)-1/100800.
    coneq[2414]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*c)-1/201600.
    coneq[2415]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**3))))*c)-1/40320.
    coneq[2416]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**2)))))*c)-1/120960.
    coneq[2417]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*c)-1/241920.
    coneq[2418]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c)))))*c)-1/80640.
    coneq[2419]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c**2))))*c)-1/30240.
    coneq[2420]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c)))))*c)-1/60480.
    coneq[2421]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,c))))*c)-1/20160.
    coneq[2422]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**2))))*c)-1/60480.
    coneq[2423]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*c)-1/120960.
    coneq[2424]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c))))*c)-1/40320.
    coneq[2425]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**4)))*c)-1/8400.
    coneq[2426]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**3))))*c)-1/33600.
    coneq[2427]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**2)))))*c)-1/100800.
    coneq[2428]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/201600.
    coneq[2429]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c)))))*c)-1/67200.
    coneq[2430]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c**2))))*c)-1/25200.
    coneq[2431]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c)))))*c)-1/50400.
    coneq[2432]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c))))*c)-1/16800.
    coneq[2433]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c))))*c)-1/33600.
    coneq[2434]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**3)))*c)-1/6720.
    coneq[2435]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c**2))))*c)-1/20160.
    coneq[2436]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c)))))*c)-1/40320.
    coneq[2437]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c))))*c)-1/13440.
    coneq[2438]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c**2)))*c)-1/5040.
    coneq[2439]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,c))))*c)-1/10080.
    coneq[2440]=dot(b,dot(A,dot(A,c)*dot(A,c**4*dot(A,c)))*c)-1/3360.
    coneq[2441]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**2)))*c)-1/15120.
    coneq[2442]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c))))*c)-1/30240.
    coneq[2443]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*c)-1/60480.
    coneq[2444]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**3)))*c)-1/13440.
    coneq[2445]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**2))))*c)-1/40320.
    coneq[2446]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*c)-1/80640.
    coneq[2447]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c))))*c)-1/26880.
    coneq[2448]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**2)))*c)-1/10080.
    coneq[2449]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c))))*c)-1/20160.
    coneq[2450]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c)))*c)-1/6720.
    coneq[2451]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*c)-1/13440.
    coneq[2452]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c**3))*c)-1/1920.
    coneq[2453]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c**2)))*c)-1/5760.
    coneq[2454]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,c))))*c)-1/11520.
    coneq[2455]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,c)))*c)-1/3840.
    coneq[2456]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))*c)-1/17280.
    coneq[2457]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))*c)-1/34560.
    coneq[2458]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))*c)-1/11520.
    coneq[2459]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))*c)-1/69120.
    coneq[2460]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))*c)-1/23040.
    coneq[2461]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))*c)-1/7680.
    coneq[2462]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**4))*c)-1/1800.
    coneq[2463]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**3)))*c)-1/7200.
    coneq[2464]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))*c)-1/21600.
    coneq[2465]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/43200.
    coneq[2466]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))*c)-1/14400.
    coneq[2467]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c**2)))*c)-1/5400.
    coneq[2468]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))*c)-1/10800.
    coneq[2469]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,c)))*c)-1/3600.
    coneq[2470]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))*c)-1/7200.
    coneq[2471]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**4))*c)-1/3600.
    coneq[2472]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**3)))*c)-1/14400.
    coneq[2473]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))*c)-1/43200.
    coneq[2474]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/86400.
    coneq[2475]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))*c)-1/28800.
    coneq[2476]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))*c)-1/10800.
    coneq[2477]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))*c)-1/21600.
    coneq[2478]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))*c)-1/7200.
    coneq[2479]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))*c)-1/14400.
    coneq[2480]=dot(b,dot(A,c*dot(A,c)*dot(A,c**5))*c)-1/1440.
    coneq[2481]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**4)))*c)-1/7200.
    coneq[2482]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**3))))*c)-1/28800.
    coneq[2483]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))*c)-1/86400.
    coneq[2484]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c)-1/172800.
    coneq[2485]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))*c)-1/57600.
    coneq[2486]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))*c)-1/21600.
    coneq[2487]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))*c)-1/43200.
    coneq[2488]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))*c)-1/14400.
    coneq[2489]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))*c)-1/28800.
    coneq[2490]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**3)))*c)-1/5760.
    coneq[2491]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))*c)-1/17280.
    coneq[2492]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))*c)-1/34560.
    coneq[2493]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))*c)-1/11520.
    coneq[2494]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c**2)))*c)-1/4320.
    coneq[2495]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))*c)-1/8640.
    coneq[2496]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,c)))*c)-1/2880.
    coneq[2497]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))*c)-1/8640.
    coneq[2498]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))*c)-1/17280.
    coneq[2499]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))*c)-1/5760.
    coneq[2500]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**3))*c)-1/1440.
    coneq[2501]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c**2)))*c)-1/4320.
    coneq[2502]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,c))))*c)-1/8640.
    coneq[2503]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,c)))*c)-1/2880.
    coneq[2504]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**3))*c)-1/2880.
    coneq[2505]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c**2)))*c)-1/8640.
    coneq[2506]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*c)-1/17280.
    coneq[2507]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,c)))*c)-1/5760.
    coneq[2508]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**4))*c)-1/1200.
    coneq[2509]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**3)))*c)-1/4800.
    coneq[2510]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c**2))))*c)-1/14400.
    coneq[2511]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/28800.
    coneq[2512]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,c))))*c)-1/9600.
    coneq[2513]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c**2)))*c)-1/3600.
    coneq[2514]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,c))))*c)-1/7200.
    coneq[2515]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,c)))*c)-1/2400.
    coneq[2516]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*c)-1/4800.
    coneq[2517]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,c**2))*c)-1/1080.
    coneq[2518]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,c)))*c)-1/2160.
    coneq[2519]=dot(b,dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,c)))*c)-1/4320.
    coneq[2520]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c**3))*c)-1/960.
    coneq[2521]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,c**2)))*c)-1/2880.
    coneq[2522]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,dot(A,c))))*c)-1/5760.
    coneq[2523]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c*dot(A,c)))*c)-1/1920.
    coneq[2524]=dot(b,dot(A,c**4*dot(A,c)*dot(A,c**2))*c)-1/720.
    coneq[2525]=dot(b,dot(A,c**4*dot(A,c)*dot(A,dot(A,c)))*c)-1/1440.
    coneq[2526]=dot(b,dot(A,c**5*dot(A,c)*dot(A,c))*c)-1/480.
    coneq[2527]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**4))*c)-1/2400.
    coneq[2528]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**3)))*c)-1/9600.
    coneq[2529]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c**2))))*c)-1/28800.
    coneq[2530]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*c)-1/57600.
    coneq[2531]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,c))))*c)-1/19200.
    coneq[2532]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c**2)))*c)-1/7200.
    coneq[2533]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,c))))*c)-1/14400.
    coneq[2534]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,c)))*c)-1/4800.
    coneq[2535]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*c)-1/9600.
    coneq[2536]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**3))*c)-1/2880.
    coneq[2537]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c**2)))*c)-1/8640.
    coneq[2538]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,c))))*c)-1/17280.
    coneq[2539]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,c)))*c)-1/5760.
    coneq[2540]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c**3))*c)-1/5760.
    coneq[2541]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c**2)))*c)-1/17280.
    coneq[2542]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*c)-1/34560.
    coneq[2543]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,c)))*c)-1/11520.
    coneq[2544]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,c**2))*c)-1/3240.
    coneq[2545]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,c)))*c)-1/6480.
    coneq[2546]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,c)))*c)-1/12960.
    coneq[2547]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c)))*c)-1/25920.
    coneq[2548]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**3))*c)-1/1920.
    coneq[2549]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))*c)-1/5760.
    coneq[2550]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))*c)-1/11520.
    coneq[2551]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))*c)-1/3840.
    coneq[2552]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,c**2))*c)-1/2160.
    coneq[2553]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))*c)-1/4320.
    coneq[2554]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))*c)-1/8640.
    coneq[2555]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c**2))*c)-1/1440.
    coneq[2556]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*c)-1/2880.
    coneq[2557]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c)*dot(A,c))*c)-1/960.
    coneq[2558]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c**2))*c)-1/2880.
    coneq[2559]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*c)-1/5760.
    coneq[2560]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))*c)-1/1920.
    coneq[2561]=dot(b,dot(A,c**8)*c*c)-1/108.
    coneq[2562]=dot(b,dot(A,dot(A,c**7))*c*c)-1/864.
    coneq[2563]=dot(b,dot(A,dot(A,dot(A,c**6)))*c*c)-1/6048.
    coneq[2564]=dot(b,dot(A,dot(A,dot(A,dot(A,c**5))))*c*c)-1/36288.
    coneq[2565]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**4)))))*c*c)-1/181440.
    coneq[2566]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))*c*c)-1/725760.
    coneq[2567]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))*c*c)-1/2177280.
    coneq[2568]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))*c*c)-1/4354560.
    coneq[2569]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))*c*c)-1/1451520.
    coneq[2570]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))*c*c)-1/544320.
    coneq[2571]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))*c*c)-1/1088640.
    coneq[2572]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))*c*c)-1/362880.
    coneq[2573]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))*c*c)-1/725760.
    coneq[2574]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3)))))*c*c)-1/145152.
    coneq[2575]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))*c*c)-1/435456.
    coneq[2576]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))*c*c)-1/870912.
    coneq[2577]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))*c*c)-1/290304.
    coneq[2578]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))*c*c)-1/108864.
    coneq[2579]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))*c*c)-1/217728.
    coneq[2580]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)))))*c*c)-1/72576.
    coneq[2581]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))*c*c)-1/217728.
    coneq[2582]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))*c*c)-1/435456.
    coneq[2583]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))*c*c)-1/145152.
    coneq[2584]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**4))))*c*c)-1/30240.
    coneq[2585]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3)))))*c*c)-1/120960.
    coneq[2586]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))*c*c)-1/362880.
    coneq[2587]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))*c*c)-1/725760.
    coneq[2588]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))*c*c)-1/241920.
    coneq[2589]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))*c*c)-1/90720.
    coneq[2590]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))*c*c)-1/181440.
    coneq[2591]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))*c*c)-1/60480.
    coneq[2592]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))*c*c)-1/120960.
    coneq[2593]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**3))))*c*c)-1/24192.
    coneq[2594]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))*c*c)-1/72576.
    coneq[2595]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))*c*c)-1/145152.
    coneq[2596]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))*c*c)-1/48384.
    coneq[2597]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**2))))*c*c)-1/18144.
    coneq[2598]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)))))*c*c)-1/36288.
    coneq[2599]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c))))*c*c)-1/12096.
    coneq[2600]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))*c*c)-1/54432.
    coneq[2601]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))*c*c)-1/108864.
    coneq[2602]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))*c*c)-1/217728.
    coneq[2603]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3))))*c*c)-1/48384.
    coneq[2604]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))*c*c)-1/145152.
    coneq[2605]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))*c*c)-1/290304.
    coneq[2606]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))*c*c)-1/96768.
    coneq[2607]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))*c*c)-1/36288.
    coneq[2608]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))*c*c)-1/72576.
    coneq[2609]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))*c*c)-1/24192.
    coneq[2610]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))*c*c)-1/48384.
    coneq[2611]=dot(b,dot(A,dot(A,c*dot(A,c**5)))*c*c)-1/5184.
    coneq[2612]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**4))))*c*c)-1/25920.
    coneq[2613]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3)))))*c*c)-1/103680.
    coneq[2614]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))*c*c)-1/311040.
    coneq[2615]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c*c)-1/622080.
    coneq[2616]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))*c*c)-1/207360.
    coneq[2617]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))*c*c)-1/77760.
    coneq[2618]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))*c*c)-1/155520.
    coneq[2619]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))*c*c)-1/51840.
    coneq[2620]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))*c*c)-1/103680.
    coneq[2621]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**3))))*c*c)-1/20736.
    coneq[2622]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))*c*c)-1/62208.
    coneq[2623]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))*c*c)-1/124416.
    coneq[2624]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))*c*c)-1/41472.
    coneq[2625]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2))))*c*c)-1/15552.
    coneq[2626]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))*c*c)-1/31104.
    coneq[2627]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c))))*c*c)-1/10368.
    coneq[2628]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))*c*c)-1/31104.
    coneq[2629]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))*c*c)-1/62208.
    coneq[2630]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))*c*c)-1/20736.
    coneq[2631]=dot(b,dot(A,dot(A,c**2*dot(A,c**4)))*c*c)-1/4320.
    coneq[2632]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**3))))*c*c)-1/17280.
    coneq[2633]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))*c*c)-1/51840.
    coneq[2634]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))*c*c)-1/103680.
    coneq[2635]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))*c*c)-1/34560.
    coneq[2636]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2))))*c*c)-1/12960.
    coneq[2637]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))*c*c)-1/25920.
    coneq[2638]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c))))*c*c)-1/8640.
    coneq[2639]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))*c*c)-1/17280.
    coneq[2640]=dot(b,dot(A,dot(A,c**3*dot(A,c**3)))*c*c)-1/3456.
    coneq[2641]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**2))))*c*c)-1/10368.
    coneq[2642]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)))))*c*c)-1/20736.
    coneq[2643]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c))))*c*c)-1/6912.
    coneq[2644]=dot(b,dot(A,dot(A,c**4*dot(A,c**2)))*c*c)-1/2592.
    coneq[2645]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c))))*c*c)-1/5184.
    coneq[2646]=dot(b,dot(A,dot(A,c**5*dot(A,c)))*c*c)-1/1728.
    coneq[2647]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**3)))*c*c)-1/10368.
    coneq[2648]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))*c*c)-1/31104.
    coneq[2649]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))*c*c)-1/62208.
    coneq[2650]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))*c*c)-1/20736.
    coneq[2651]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3)))*c*c)-1/20736.
    coneq[2652]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))*c*c)-1/62208.
    coneq[2653]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))*c*c)-1/124416.
    coneq[2654]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))*c*c)-1/41472.
    coneq[2655]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**4)))*c*c)-1/8640.
    coneq[2656]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3))))*c*c)-1/34560.
    coneq[2657]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))*c*c)-1/103680.
    coneq[2658]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))*c*c)-1/207360.
    coneq[2659]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))*c*c)-1/69120.
    coneq[2660]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))*c*c)-1/25920.
    coneq[2661]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))*c*c)-1/51840.
    coneq[2662]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))*c*c)-1/17280.
    coneq[2663]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))*c*c)-1/34560.
    coneq[2664]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2)))*c*c)-1/7776.
    coneq[2665]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))*c*c)-1/15552.
    coneq[2666]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))*c*c)-1/31104.
    coneq[2667]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**3)))*c*c)-1/6912.
    coneq[2668]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))*c*c)-1/20736.
    coneq[2669]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))*c*c)-1/41472.
    coneq[2670]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))*c*c)-1/13824.
    coneq[2671]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2)))*c*c)-1/5184.
    coneq[2672]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))*c*c)-1/10368.
    coneq[2673]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c)))*c*c)-1/3456.
    coneq[2674]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))*c*c)-1/10368.
    coneq[2675]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))*c*c)-1/20736.
    coneq[2676]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))*c*c)-1/6912.
    coneq[2677]=dot(b,dot(A,c*dot(A,c**6))*c*c)-1/756.
    coneq[2678]=dot(b,dot(A,c*dot(A,dot(A,c**5)))*c*c)-1/4536.
    coneq[2679]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**4))))*c*c)-1/22680.
    coneq[2680]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3)))))*c*c)-1/90720.
    coneq[2681]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*c*c)-1/272160.
    coneq[2682]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c*c)-1/544320.
    coneq[2683]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*c*c)-1/181440.
    coneq[2684]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2)))))*c*c)-1/68040.
    coneq[2685]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*c*c)-1/136080.
    coneq[2686]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)))))*c*c)-1/45360.
    coneq[2687]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*c*c)-1/90720.
    coneq[2688]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**3))))*c*c)-1/18144.
    coneq[2689]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2)))))*c*c)-1/54432.
    coneq[2690]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*c*c)-1/108864.
    coneq[2691]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)))))*c*c)-1/36288.
    coneq[2692]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2))))*c*c)-1/13608.
    coneq[2693]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)))))*c*c)-1/27216.
    coneq[2694]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c))))*c*c)-1/9072.
    coneq[2695]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2))))*c*c)-1/27216.
    coneq[2696]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*c*c)-1/54432.
    coneq[2697]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c))))*c*c)-1/18144.
    coneq[2698]=dot(b,dot(A,c*dot(A,c*dot(A,c**4)))*c*c)-1/3780.
    coneq[2699]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**3))))*c*c)-1/15120.
    coneq[2700]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2)))))*c*c)-1/45360.
    coneq[2701]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*c*c)-1/90720.
    coneq[2702]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)))))*c*c)-1/30240.
    coneq[2703]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2))))*c*c)-1/11340.
    coneq[2704]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)))))*c*c)-1/22680.
    coneq[2705]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c))))*c*c)-1/7560.
    coneq[2706]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c))))*c*c)-1/15120.
    coneq[2707]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**3)))*c*c)-1/3024.
    coneq[2708]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2))))*c*c)-1/9072.
    coneq[2709]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)))))*c*c)-1/18144.
    coneq[2710]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c))))*c*c)-1/6048.
    coneq[2711]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**2)))*c*c)-1/2268.
    coneq[2712]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c))))*c*c)-1/4536.
    coneq[2713]=dot(b,dot(A,c*dot(A,c**4*dot(A,c)))*c*c)-1/1512.
    coneq[2714]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2)))*c*c)-1/6804.
    coneq[2715]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c))))*c*c)-1/13608.
    coneq[2716]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*c*c)-1/27216.
    coneq[2717]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**3)))*c*c)-1/6048.
    coneq[2718]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2))))*c*c)-1/18144.
    coneq[2719]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*c*c)-1/36288.
    coneq[2720]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c))))*c*c)-1/12096.
    coneq[2721]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2)))*c*c)-1/4536.
    coneq[2722]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c))))*c*c)-1/9072.
    coneq[2723]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)))*c*c)-1/3024.
    coneq[2724]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*c*c)-1/6048.
    coneq[2725]=dot(b,dot(A,c**2*dot(A,c**5))*c*c)-1/648.
    coneq[2726]=dot(b,dot(A,c**2*dot(A,dot(A,c**4)))*c*c)-1/3240.
    coneq[2727]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**3))))*c*c)-1/12960.
    coneq[2728]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2)))))*c*c)-1/38880.
    coneq[2729]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c*c)-1/77760.
    coneq[2730]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)))))*c*c)-1/25920.
    coneq[2731]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2))))*c*c)-1/9720.
    coneq[2732]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)))))*c*c)-1/19440.
    coneq[2733]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c))))*c*c)-1/6480.
    coneq[2734]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c))))*c*c)-1/12960.
    coneq[2735]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**3)))*c*c)-1/2592.
    coneq[2736]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2))))*c*c)-1/7776.
    coneq[2737]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)))))*c*c)-1/15552.
    coneq[2738]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c))))*c*c)-1/5184.
    coneq[2739]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**2)))*c*c)-1/1944.
    coneq[2740]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c))))*c*c)-1/3888.
    coneq[2741]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c)))*c*c)-1/1296.
    coneq[2742]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2)))*c*c)-1/3888.
    coneq[2743]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c))))*c*c)-1/7776.
    coneq[2744]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)))*c*c)-1/2592.
    coneq[2745]=dot(b,dot(A,c**3*dot(A,c**4))*c*c)-1/540.
    coneq[2746]=dot(b,dot(A,c**3*dot(A,dot(A,c**3)))*c*c)-1/2160.
    coneq[2747]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**2))))*c*c)-1/6480.
    coneq[2748]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)))))*c*c)-1/12960.
    coneq[2749]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c))))*c*c)-1/4320.
    coneq[2750]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**2)))*c*c)-1/1620.
    coneq[2751]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c))))*c*c)-1/3240.
    coneq[2752]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c)))*c*c)-1/1080.
    coneq[2753]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c)))*c*c)-1/2160.
    coneq[2754]=dot(b,dot(A,c**4*dot(A,c**3))*c*c)-1/432.
    coneq[2755]=dot(b,dot(A,c**4*dot(A,dot(A,c**2)))*c*c)-1/1296.
    coneq[2756]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c))))*c*c)-1/2592.
    coneq[2757]=dot(b,dot(A,c**4*dot(A,c*dot(A,c)))*c*c)-1/864.
    coneq[2758]=dot(b,dot(A,c**5*dot(A,c**2))*c*c)-1/324.
    coneq[2759]=dot(b,dot(A,c**5*dot(A,dot(A,c)))*c*c)-1/648.
    coneq[2760]=dot(b,dot(A,c**6*dot(A,c))*c*c)-1/216.
    coneq[2761]=dot(b,dot(A,dot(A,c**3)*dot(A,c**3))*c*c)-1/1728.
    coneq[2762]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**2)))*c*c)-1/5184.
    coneq[2763]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c))))*c*c)-1/10368.
    coneq[2764]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c)))*c*c)-1/3456.
    coneq[2765]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))*c*c)-1/15552.
    coneq[2766]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))*c*c)-1/31104.
    coneq[2767]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))*c*c)-1/10368.
    coneq[2768]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))*c*c)-1/62208.
    coneq[2769]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))*c*c)-1/20736.
    coneq[2770]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))*c*c)-1/6912.
    coneq[2771]=dot(b,dot(A,dot(A,c**2)*dot(A,c**4))*c*c)-1/1620.
    coneq[2772]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**3)))*c*c)-1/6480.
    coneq[2773]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))*c*c)-1/19440.
    coneq[2774]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))*c*c)-1/38880.
    coneq[2775]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))*c*c)-1/12960.
    coneq[2776]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2)))*c*c)-1/4860.
    coneq[2777]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))*c*c)-1/9720.
    coneq[2778]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)))*c*c)-1/3240.
    coneq[2779]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))*c*c)-1/6480.
    coneq[2780]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**4))*c*c)-1/3240.
    coneq[2781]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3)))*c*c)-1/12960.
    coneq[2782]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))*c*c)-1/38880.
    coneq[2783]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))*c*c)-1/77760.
    coneq[2784]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))*c*c)-1/25920.
    coneq[2785]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))*c*c)-1/9720.
    coneq[2786]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))*c*c)-1/19440.
    coneq[2787]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))*c*c)-1/6480.
    coneq[2788]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))*c*c)-1/12960.
    coneq[2789]=dot(b,dot(A,dot(A,c)*dot(A,c**5))*c*c)-1/1296.
    coneq[2790]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**4)))*c*c)-1/6480.
    coneq[2791]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3))))*c*c)-1/25920.
    coneq[2792]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))*c*c)-1/77760.
    coneq[2793]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c*c)-1/155520.
    coneq[2794]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))*c*c)-1/51840.
    coneq[2795]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))*c*c)-1/19440.
    coneq[2796]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))*c*c)-1/38880.
    coneq[2797]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))*c*c)-1/12960.
    coneq[2798]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))*c*c)-1/25920.
    coneq[2799]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**3)))*c*c)-1/5184.
    coneq[2800]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))*c*c)-1/15552.
    coneq[2801]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))*c*c)-1/31104.
    coneq[2802]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))*c*c)-1/10368.
    coneq[2803]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2)))*c*c)-1/3888.
    coneq[2804]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))*c*c)-1/7776.
    coneq[2805]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c)))*c*c)-1/2592.
    coneq[2806]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))*c*c)-1/7776.
    coneq[2807]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))*c*c)-1/15552.
    coneq[2808]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))*c*c)-1/5184.
    coneq[2809]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**3))*c*c)-1/1296.
    coneq[2810]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2)))*c*c)-1/3888.
    coneq[2811]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c))))*c*c)-1/7776.
    coneq[2812]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)))*c*c)-1/2592.
    coneq[2813]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**3))*c*c)-1/2592.
    coneq[2814]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2)))*c*c)-1/7776.
    coneq[2815]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*c*c)-1/15552.
    coneq[2816]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)))*c*c)-1/5184.
    coneq[2817]=dot(b,dot(A,c*dot(A,c)*dot(A,c**4))*c*c)-1/1080.
    coneq[2818]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**3)))*c*c)-1/4320.
    coneq[2819]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2))))*c*c)-1/12960.
    coneq[2820]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*c*c)-1/25920.
    coneq[2821]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c))))*c*c)-1/8640.
    coneq[2822]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2)))*c*c)-1/3240.
    coneq[2823]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c))))*c*c)-1/6480.
    coneq[2824]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)))*c*c)-1/2160.
    coneq[2825]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*c*c)-1/4320.
    coneq[2826]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**2))*c*c)-1/972.
    coneq[2827]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)))*c*c)-1/1944.
    coneq[2828]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)))*c*c)-1/3888.
    coneq[2829]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**3))*c*c)-1/864.
    coneq[2830]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2)))*c*c)-1/2592.
    coneq[2831]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c))))*c*c)-1/5184.
    coneq[2832]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)))*c*c)-1/1728.
    coneq[2833]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c**2))*c*c)-1/648.
    coneq[2834]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,c)))*c*c)-1/1296.
    coneq[2835]=dot(b,dot(A,c**4*dot(A,c)*dot(A,c))*c*c)-1/432.
    coneq[2836]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3))*c*c)-1/1728.
    coneq[2837]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))*c*c)-1/5184.
    coneq[2838]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))*c*c)-1/10368.
    coneq[2839]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))*c*c)-1/3456.
    coneq[2840]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2))*c*c)-1/1944.
    coneq[2841]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))*c*c)-1/3888.
    coneq[2842]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))*c*c)-1/7776.
    coneq[2843]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2))*c*c)-1/1296.
    coneq[2844]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*c*c)-1/2592.
    coneq[2845]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c))*c*c)-1/864.
    coneq[2846]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))*c*c)-1/1728.
    coneq[2847]=dot(b,dot(A,c**7)*c**3)-1/96.
    coneq[2848]=dot(b,dot(A,dot(A,c**6))*c**3)-1/672.
    coneq[2849]=dot(b,dot(A,dot(A,dot(A,c**5)))*c**3)-1/4032.
    coneq[2850]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4))))*c**3)-1/20160.
    coneq[2851]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))*c**3)-1/80640.
    coneq[2852]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*c**3)-1/241920.
    coneq[2853]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*c**3)-1/483840.
    coneq[2854]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*c**3)-1/161280.
    coneq[2855]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))*c**3)-1/60480.
    coneq[2856]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*c**3)-1/120960.
    coneq[2857]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))*c**3)-1/40320.
    coneq[2858]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*c**3)-1/80640.
    coneq[2859]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3))))*c**3)-1/16128.
    coneq[2860]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))*c**3)-1/48384.
    coneq[2861]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*c**3)-1/96768.
    coneq[2862]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))*c**3)-1/32256.
    coneq[2863]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))*c**3)-1/12096.
    coneq[2864]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))*c**3)-1/24192.
    coneq[2865]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c))))*c**3)-1/8064.
    coneq[2866]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))*c**3)-1/24192.
    coneq[2867]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*c**3)-1/48384.
    coneq[2868]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))*c**3)-1/16128.
    coneq[2869]=dot(b,dot(A,dot(A,c*dot(A,c**4)))*c**3)-1/3360.
    coneq[2870]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3))))*c**3)-1/13440.
    coneq[2871]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))*c**3)-1/40320.
    coneq[2872]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*c**3)-1/80640.
    coneq[2873]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))*c**3)-1/26880.
    coneq[2874]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))*c**3)-1/10080.
    coneq[2875]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))*c**3)-1/20160.
    coneq[2876]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))*c**3)-1/6720.
    coneq[2877]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))*c**3)-1/13440.
    coneq[2878]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)))*c**3)-1/2688.
    coneq[2879]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))*c**3)-1/8064.
    coneq[2880]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))*c**3)-1/16128.
    coneq[2881]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))*c**3)-1/5376.
    coneq[2882]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)))*c**3)-1/2016.
    coneq[2883]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))))*c**3)-1/4032.
    coneq[2884]=dot(b,dot(A,dot(A,c**4*dot(A,c)))*c**3)-1/1344.
    coneq[2885]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))*c**3)-1/6048.
    coneq[2886]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))*c**3)-1/12096.
    coneq[2887]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*c**3)-1/24192.
    coneq[2888]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)))*c**3)-1/5376.
    coneq[2889]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))*c**3)-1/16128.
    coneq[2890]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*c**3)-1/32256.
    coneq[2891]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))*c**3)-1/10752.
    coneq[2892]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))*c**3)-1/4032.
    coneq[2893]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))*c**3)-1/8064.
    coneq[2894]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))*c**3)-1/2688.
    coneq[2895]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*c**3)-1/5376.
    coneq[2896]=dot(b,dot(A,c*dot(A,c**5))*c**3)-1/576.
    coneq[2897]=dot(b,dot(A,c*dot(A,dot(A,c**4)))*c**3)-1/2880.
    coneq[2898]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3))))*c**3)-1/11520.
    coneq[2899]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))*c**3)-1/34560.
    coneq[2900]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c**3)-1/69120.
    coneq[2901]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))*c**3)-1/23040.
    coneq[2902]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))*c**3)-1/8640.
    coneq[2903]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))*c**3)-1/17280.
    coneq[2904]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))*c**3)-1/5760.
    coneq[2905]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))*c**3)-1/11520.
    coneq[2906]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)))*c**3)-1/2304.
    coneq[2907]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))*c**3)-1/6912.
    coneq[2908]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))*c**3)-1/13824.
    coneq[2909]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))*c**3)-1/4608.
    coneq[2910]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)))*c**3)-1/1728.
    coneq[2911]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))*c**3)-1/3456.
    coneq[2912]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)))*c**3)-1/1152.
    coneq[2913]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))*c**3)-1/3456.
    coneq[2914]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))*c**3)-1/6912.
    coneq[2915]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))*c**3)-1/2304.
    coneq[2916]=dot(b,dot(A,c**2*dot(A,c**4))*c**3)-1/480.
    coneq[2917]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)))*c**3)-1/1920.
    coneq[2918]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))*c**3)-1/5760.
    coneq[2919]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))*c**3)-1/11520.
    coneq[2920]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))*c**3)-1/3840.
    coneq[2921]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)))*c**3)-1/1440.
    coneq[2922]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))*c**3)-1/2880.
    coneq[2923]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)))*c**3)-1/960.
    coneq[2924]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))*c**3)-1/1920.
    coneq[2925]=dot(b,dot(A,c**3*dot(A,c**3))*c**3)-1/384.
    coneq[2926]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)))*c**3)-1/1152.
    coneq[2927]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))))*c**3)-1/2304.
    coneq[2928]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)))*c**3)-1/768.
    coneq[2929]=dot(b,dot(A,c**4*dot(A,c**2))*c**3)-1/288.
    coneq[2930]=dot(b,dot(A,c**4*dot(A,dot(A,c)))*c**3)-1/576.
    coneq[2931]=dot(b,dot(A,c**5*dot(A,c))*c**3)-1/192.
    coneq[2932]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3))*c**3)-1/1152.
    coneq[2933]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))*c**3)-1/3456.
    coneq[2934]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))*c**3)-1/6912.
    coneq[2935]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))*c**3)-1/2304.
    coneq[2936]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3))*c**3)-1/2304.
    coneq[2937]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))*c**3)-1/6912.
    coneq[2938]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*c**3)-1/13824.
    coneq[2939]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))*c**3)-1/4608.
    coneq[2940]=dot(b,dot(A,dot(A,c)*dot(A,c**4))*c**3)-1/960.
    coneq[2941]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)))*c**3)-1/3840.
    coneq[2942]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))*c**3)-1/11520.
    coneq[2943]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*c**3)-1/23040.
    coneq[2944]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))*c**3)-1/7680.
    coneq[2945]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))*c**3)-1/2880.
    coneq[2946]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))*c**3)-1/5760.
    coneq[2947]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))*c**3)-1/1920.
    coneq[2948]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*c**3)-1/3840.
    coneq[2949]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2))*c**3)-1/864.
    coneq[2950]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))*c**3)-1/1728.
    coneq[2951]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))*c**3)-1/3456.
    coneq[2952]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3))*c**3)-1/768.
    coneq[2953]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))*c**3)-1/2304.
    coneq[2954]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))*c**3)-1/4608.
    coneq[2955]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))*c**3)-1/1536.
    coneq[2956]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2))*c**3)-1/576.
    coneq[2957]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))*c**3)-1/1152.
    coneq[2958]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c))*c**3)-1/384.
    coneq[2959]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))*c**3)-1/1152.
    coneq[2960]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*c**3)-1/2304.
    coneq[2961]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))*c**3)-1/768.
    coneq[2962]=dot(b,dot(A,c**6)*c**4)-1/84.
    coneq[2963]=dot(b,dot(A,dot(A,c**5))*c**4)-1/504.
    coneq[2964]=dot(b,dot(A,dot(A,dot(A,c**4)))*c**4)-1/2520.
    coneq[2965]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*c**4)-1/10080.
    coneq[2966]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*c**4)-1/30240.
    coneq[2967]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*c**4)-1/60480.
    coneq[2968]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*c**4)-1/20160.
    coneq[2969]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*c**4)-1/7560.
    coneq[2970]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*c**4)-1/15120.
    coneq[2971]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*c**4)-1/5040.
    coneq[2972]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*c**4)-1/10080.
    coneq[2973]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*c**4)-1/2016.
    coneq[2974]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*c**4)-1/6048.
    coneq[2975]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*c**4)-1/12096.
    coneq[2976]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*c**4)-1/4032.
    coneq[2977]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*c**4)-1/1512.
    coneq[2978]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*c**4)-1/3024.
    coneq[2979]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*c**4)-1/1008.
    coneq[2980]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*c**4)-1/3024.
    coneq[2981]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*c**4)-1/6048.
    coneq[2982]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*c**4)-1/2016.
    coneq[2983]=dot(b,dot(A,c*dot(A,c**4))*c**4)-1/420.
    coneq[2984]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*c**4)-1/1680.
    coneq[2985]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*c**4)-1/5040.
    coneq[2986]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*c**4)-1/10080.
    coneq[2987]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*c**4)-1/3360.
    coneq[2988]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*c**4)-1/1260.
    coneq[2989]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*c**4)-1/2520.
    coneq[2990]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*c**4)-1/840.
    coneq[2991]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*c**4)-1/1680.
    coneq[2992]=dot(b,dot(A,c**2*dot(A,c**3))*c**4)-1/336.
    coneq[2993]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*c**4)-1/1008.
    coneq[2994]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*c**4)-1/2016.
    coneq[2995]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*c**4)-1/672.
    coneq[2996]=dot(b,dot(A,c**3*dot(A,c**2))*c**4)-1/252.
    coneq[2997]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*c**4)-1/504.
    coneq[2998]=dot(b,dot(A,c**4*dot(A,c))*c**4)-1/168.
    coneq[2999]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*c**4)-1/756.
    coneq[3000]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*c**4)-1/1512.
    coneq[3001]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*c**4)-1/3024.
    coneq[3002]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*c**4)-1/672.
    coneq[3003]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*c**4)-1/2016.
    coneq[3004]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*c**4)-1/4032.
    coneq[3005]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*c**4)-1/1344.
    coneq[3006]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*c**4)-1/504.
    coneq[3007]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*c**4)-1/1008.
    coneq[3008]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*c**4)-1/336.
    coneq[3009]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*c**4)-1/672.
    coneq[3010]=dot(b,dot(A,c**5)*c**5)-1/72.
    coneq[3011]=dot(b,dot(A,dot(A,c**4))*c**5)-1/360.
    coneq[3012]=dot(b,dot(A,dot(A,dot(A,c**3)))*c**5)-1/1440.
    coneq[3013]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*c**5)-1/4320.
    coneq[3014]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*c**5)-1/8640.
    coneq[3015]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*c**5)-1/2880.
    coneq[3016]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*c**5)-1/1080.
    coneq[3017]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*c**5)-1/2160.
    coneq[3018]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*c**5)-1/720.
    coneq[3019]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*c**5)-1/1440.
    coneq[3020]=dot(b,dot(A,c*dot(A,c**3))*c**5)-1/288.
    coneq[3021]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*c**5)-1/864.
    coneq[3022]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*c**5)-1/1728.
    coneq[3023]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*c**5)-1/576.
    coneq[3024]=dot(b,dot(A,c**2*dot(A,c**2))*c**5)-1/216.
    coneq[3025]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*c**5)-1/432.
    coneq[3026]=dot(b,dot(A,c**3*dot(A,c))*c**5)-1/144.
    coneq[3027]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*c**5)-1/432.
    coneq[3028]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*c**5)-1/864.
    coneq[3029]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*c**5)-1/288.
    coneq[3030]=dot(b,dot(A,c**4)*c**6)-1/60.
    coneq[3031]=dot(b,dot(A,dot(A,c**3))*c**6)-1/240.
    coneq[3032]=dot(b,dot(A,dot(A,dot(A,c**2)))*c**6)-1/720.
    coneq[3033]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*c**6)-1/1440.
    coneq[3034]=dot(b,dot(A,dot(A,c*dot(A,c)))*c**6)-1/480.
    coneq[3035]=dot(b,dot(A,c*dot(A,c**2))*c**6)-1/180.
    coneq[3036]=dot(b,dot(A,c*dot(A,dot(A,c)))*c**6)-1/360.
    coneq[3037]=dot(b,dot(A,c**2*dot(A,c))*c**6)-1/120.
    coneq[3038]=dot(b,dot(A,dot(A,c)*dot(A,c))*c**6)-1/240.
    coneq[3039]=dot(b,dot(A,c**3)*c**7)-1/48.
    coneq[3040]=dot(b,dot(A,dot(A,c**2))*c**7)-1/144.
    coneq[3041]=dot(b,dot(A,dot(A,dot(A,c)))*c**7)-1/288.
    coneq[3042]=dot(b,dot(A,c*dot(A,c))*c**7)-1/96.
    coneq[3043]=dot(b,dot(A,c**2)*c**8)-1/36.
    coneq[3044]=dot(b,dot(A,dot(A,c))*c**8)-1/72.
    coneq[3045]=dot(b,dot(A,c)*c**9)-1/24.
    coneq[3046]=dot(b,dot(A,c**5)*dot(A,c**4))-1/360.
    coneq[3047]=dot(b,dot(A,dot(A,c**4))*dot(A,c**4))-1/1800.
    coneq[3048]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c**4))-1/7200.
    coneq[3049]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c**4))-1/21600.
    coneq[3050]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**4))-1/43200.
    coneq[3051]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c**4))-1/14400.
    coneq[3052]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c**4))-1/5400.
    coneq[3053]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c**4))-1/10800.
    coneq[3054]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c**4))-1/3600.
    coneq[3055]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c**4))-1/7200.
    coneq[3056]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c**4))-1/1440.
    coneq[3057]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c**4))-1/4320.
    coneq[3058]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c**4))-1/8640.
    coneq[3059]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c**4))-1/2880.
    coneq[3060]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c**4))-1/1080.
    coneq[3061]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c**4))-1/2160.
    coneq[3062]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c**4))-1/720.
    coneq[3063]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c**4))-1/2160.
    coneq[3064]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c**4))-1/4320.
    coneq[3065]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c**4))-1/1440.
    coneq[3066]=dot(b,dot(A,c**5)*dot(A,dot(A,c**3)))-1/1440.
    coneq[3067]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,c**3)))-1/7200.
    coneq[3068]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,c**3)))-1/28800.
    coneq[3069]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c**3)))-1/86400.
    coneq[3070]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c**3)))-1/172800.
    coneq[3071]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c**3)))-1/57600.
    coneq[3072]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,c**3)))-1/21600.
    coneq[3073]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c**3)))-1/43200.
    coneq[3074]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,c**3)))-1/14400.
    coneq[3075]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c**3)))-1/28800.
    coneq[3076]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,c**3)))-1/5760.
    coneq[3077]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,c**3)))-1/17280.
    coneq[3078]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**3)))-1/34560.
    coneq[3079]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,c**3)))-1/11520.
    coneq[3080]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,c**3)))-1/4320.
    coneq[3081]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,c**3)))-1/8640.
    coneq[3082]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,c**3)))-1/2880.
    coneq[3083]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,c**3)))-1/8640.
    coneq[3084]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c**3)))-1/17280.
    coneq[3085]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,c**3)))-1/5760.
    coneq[3086]=dot(b,dot(A,c**5)*dot(A,dot(A,dot(A,c**2))))-1/4320.
    coneq[3087]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,dot(A,c**2))))-1/21600.
    coneq[3088]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,dot(A,c**2))))-1/86400.
    coneq[3089]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,dot(A,c**2))))-1/259200.
    coneq[3090]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,dot(A,c**2))))-1/518400.
    coneq[3091]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,dot(A,c**2))))-1/172800.
    coneq[3092]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,dot(A,c**2))))-1/64800.
    coneq[3093]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c**2))))-1/129600.
    coneq[3094]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,dot(A,c**2))))-1/43200.
    coneq[3095]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,dot(A,c**2))))-1/86400.
    coneq[3096]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,dot(A,c**2))))-1/17280.
    coneq[3097]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c**2))))-1/51840.
    coneq[3098]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c**2))))-1/103680.
    coneq[3099]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c**2))))-1/34560.
    coneq[3100]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,dot(A,c**2))))-1/12960.
    coneq[3101]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2))))-1/25920.
    coneq[3102]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,dot(A,c**2))))-1/8640.
    coneq[3103]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,dot(A,c**2))))-1/25920.
    coneq[3104]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2))))-1/51840.
    coneq[3105]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c**2))))-1/17280.
    coneq[3106]=dot(b,dot(A,c**5)*dot(A,dot(A,dot(A,dot(A,c)))))-1/8640.
    coneq[3107]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,dot(A,dot(A,c)))))-1/43200.
    coneq[3108]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,dot(A,dot(A,c)))))-1/172800.
    coneq[3109]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,dot(A,dot(A,c)))))-1/518400.
    coneq[3110]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,dot(A,dot(A,c)))))-1/1036800.
    coneq[3111]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,dot(A,dot(A,c)))))-1/345600.
    coneq[3112]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,dot(A,dot(A,c)))))-1/129600.
    coneq[3113]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,dot(A,dot(A,c)))))-1/259200.
    coneq[3114]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))-1/86400.
    coneq[3115]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))-1/172800.
    coneq[3116]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,dot(A,dot(A,c)))))-1/34560.
    coneq[3117]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,dot(A,c)))))-1/103680.
    coneq[3118]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,dot(A,c)))))-1/207360.
    coneq[3119]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))-1/69120.
    coneq[3120]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c)))))-1/25920.
    coneq[3121]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))-1/51840.
    coneq[3122]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))-1/17280.
    coneq[3123]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c)))))-1/51840.
    coneq[3124]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))-1/103680.
    coneq[3125]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))-1/34560.
    coneq[3126]=dot(b,dot(A,c**5)*dot(A,dot(A,c*dot(A,c))))-1/2880.
    coneq[3127]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,c*dot(A,c))))-1/14400.
    coneq[3128]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,c*dot(A,c))))-1/57600.
    coneq[3129]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c*dot(A,c))))-1/172800.
    coneq[3130]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c*dot(A,c))))-1/345600.
    coneq[3131]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c*dot(A,c))))-1/115200.
    coneq[3132]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,c*dot(A,c))))-1/43200.
    coneq[3133]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c*dot(A,c))))-1/86400.
    coneq[3134]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,c*dot(A,c))))-1/28800.
    coneq[3135]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c*dot(A,c))))-1/57600.
    coneq[3136]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,c*dot(A,c))))-1/11520.
    coneq[3137]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,c*dot(A,c))))-1/34560.
    coneq[3138]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c*dot(A,c))))-1/69120.
    coneq[3139]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,c*dot(A,c))))-1/23040.
    coneq[3140]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,c*dot(A,c))))-1/8640.
    coneq[3141]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c))))-1/17280.
    coneq[3142]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,c*dot(A,c))))-1/5760.
    coneq[3143]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,c*dot(A,c))))-1/17280.
    coneq[3144]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c))))-1/34560.
    coneq[3145]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,c*dot(A,c))))-1/11520.
    coneq[3146]=dot(b,dot(A,c**5)*dot(A,c*dot(A,c**2)))-1/1080.
    coneq[3147]=dot(b,dot(A,dot(A,c**4))*dot(A,c*dot(A,c**2)))-1/5400.
    coneq[3148]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c*dot(A,c**2)))-1/21600.
    coneq[3149]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c*dot(A,c**2)))-1/64800.
    coneq[3150]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c*dot(A,c**2)))-1/129600.
    coneq[3151]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c*dot(A,c**2)))-1/43200.
    coneq[3152]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c*dot(A,c**2)))-1/16200.
    coneq[3153]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c*dot(A,c**2)))-1/32400.
    coneq[3154]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c*dot(A,c**2)))-1/10800.
    coneq[3155]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c*dot(A,c**2)))-1/21600.
    coneq[3156]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c*dot(A,c**2)))-1/4320.
    coneq[3157]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c*dot(A,c**2)))-1/12960.
    coneq[3158]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c**2)))-1/25920.
    coneq[3159]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c*dot(A,c**2)))-1/8640.
    coneq[3160]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c*dot(A,c**2)))-1/3240.
    coneq[3161]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c*dot(A,c**2)))-1/6480.
    coneq[3162]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c*dot(A,c**2)))-1/2160.
    coneq[3163]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c*dot(A,c**2)))-1/6480.
    coneq[3164]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c*dot(A,c**2)))-1/12960.
    coneq[3165]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c*dot(A,c**2)))-1/4320.
    coneq[3166]=dot(b,dot(A,c**5)*dot(A,c*dot(A,dot(A,c))))-1/2160.
    coneq[3167]=dot(b,dot(A,dot(A,c**4))*dot(A,c*dot(A,dot(A,c))))-1/10800.
    coneq[3168]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c*dot(A,dot(A,c))))-1/43200.
    coneq[3169]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c*dot(A,dot(A,c))))-1/129600.
    coneq[3170]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c*dot(A,dot(A,c))))-1/259200.
    coneq[3171]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c*dot(A,dot(A,c))))-1/86400.
    coneq[3172]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c*dot(A,dot(A,c))))-1/32400.
    coneq[3173]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c*dot(A,dot(A,c))))-1/64800.
    coneq[3174]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c*dot(A,dot(A,c))))-1/21600.
    coneq[3175]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c*dot(A,dot(A,c))))-1/43200.
    coneq[3176]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c*dot(A,dot(A,c))))-1/8640.
    coneq[3177]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c*dot(A,dot(A,c))))-1/25920.
    coneq[3178]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,dot(A,c))))-1/51840.
    coneq[3179]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c*dot(A,dot(A,c))))-1/17280.
    coneq[3180]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c*dot(A,dot(A,c))))-1/6480.
    coneq[3181]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c))))-1/12960.
    coneq[3182]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c*dot(A,dot(A,c))))-1/4320.
    coneq[3183]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c*dot(A,dot(A,c))))-1/12960.
    coneq[3184]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c))))-1/25920.
    coneq[3185]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c*dot(A,dot(A,c))))-1/8640.
    coneq[3186]=dot(b,dot(A,c**5)*dot(A,c**2*dot(A,c)))-1/720.
    coneq[3187]=dot(b,dot(A,dot(A,c**4))*dot(A,c**2*dot(A,c)))-1/3600.
    coneq[3188]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c**2*dot(A,c)))-1/14400.
    coneq[3189]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c**2*dot(A,c)))-1/43200.
    coneq[3190]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**2*dot(A,c)))-1/86400.
    coneq[3191]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c**2*dot(A,c)))-1/28800.
    coneq[3192]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c**2*dot(A,c)))-1/10800.
    coneq[3193]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c**2*dot(A,c)))-1/21600.
    coneq[3194]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c**2*dot(A,c)))-1/7200.
    coneq[3195]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c**2*dot(A,c)))-1/14400.
    coneq[3196]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c**2*dot(A,c)))-1/2880.
    coneq[3197]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c**2*dot(A,c)))-1/8640.
    coneq[3198]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c**2*dot(A,c)))-1/17280.
    coneq[3199]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c**2*dot(A,c)))-1/5760.
    coneq[3200]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c**2*dot(A,c)))-1/2160.
    coneq[3201]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c**2*dot(A,c)))-1/4320.
    coneq[3202]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c**2*dot(A,c)))-1/1440.
    coneq[3203]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c**2*dot(A,c)))-1/4320.
    coneq[3204]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c**2*dot(A,c)))-1/8640.
    coneq[3205]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c**2*dot(A,c)))-1/2880.
    coneq[3206]=dot(b,dot(A,c**5)*dot(A,dot(A,c)*dot(A,c)))-1/1440.
    coneq[3207]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,c)*dot(A,c)))-1/7200.
    coneq[3208]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,c)*dot(A,c)))-1/28800.
    coneq[3209]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c)*dot(A,c)))-1/86400.
    coneq[3210]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c)*dot(A,c)))-1/172800.
    coneq[3211]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c)*dot(A,c)))-1/57600.
    coneq[3212]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,c)*dot(A,c)))-1/21600.
    coneq[3213]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c)*dot(A,c)))-1/43200.
    coneq[3214]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))-1/14400.
    coneq[3215]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))-1/28800.
    coneq[3216]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,c)*dot(A,c)))-1/5760.
    coneq[3217]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,c)*dot(A,c)))-1/17280.
    coneq[3218]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)*dot(A,c)))-1/34560.
    coneq[3219]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))-1/11520.
    coneq[3220]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,c)*dot(A,c)))-1/4320.
    coneq[3221]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))-1/8640.
    coneq[3222]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,c)*dot(A,c)))-1/2880.
    coneq[3223]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,c)*dot(A,c)))-1/8640.
    coneq[3224]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))-1/17280.
    coneq[3225]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,c)*dot(A,c)))-1/5760.
    coneq[3226]=dot(b,dot(A,c**6)*dot(A,c**3))-1/336.
    coneq[3227]=dot(b,dot(A,dot(A,c**5))*dot(A,c**3))-1/2016.
    coneq[3228]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,c**3))-1/10080.
    coneq[3229]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,c**3))-1/40320.
    coneq[3230]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c**3))-1/120960.
    coneq[3231]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c**3))-1/241920.
    coneq[3232]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c**3))-1/80640.
    coneq[3233]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,c**3))-1/30240.
    coneq[3234]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c**3))-1/60480.
    coneq[3235]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,c**3))-1/20160.
    coneq[3236]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c**3))-1/40320.
    coneq[3237]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,c**3))-1/8064.
    coneq[3238]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,c**3))-1/24192.
    coneq[3239]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c**3))-1/48384.
    coneq[3240]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,c**3))-1/16128.
    coneq[3241]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,c**3))-1/6048.
    coneq[3242]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,c**3))-1/12096.
    coneq[3243]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,c**3))-1/4032.
    coneq[3244]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c**3))-1/12096.
    coneq[3245]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c**3))-1/24192.
    coneq[3246]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c**3))-1/8064.
    coneq[3247]=dot(b,dot(A,c*dot(A,c**4))*dot(A,c**3))-1/1680.
    coneq[3248]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,c**3))-1/6720.
    coneq[3249]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,c**3))-1/20160.
    coneq[3250]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**3))-1/40320.
    coneq[3251]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,c**3))-1/13440.
    coneq[3252]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,c**3))-1/5040.
    coneq[3253]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,c**3))-1/10080.
    coneq[3254]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,c**3))-1/3360.
    coneq[3255]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,c**3))-1/6720.
    coneq[3256]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,c**3))-1/1344.
    coneq[3257]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,c**3))-1/4032.
    coneq[3258]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,c**3))-1/8064.
    coneq[3259]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,c**3))-1/2688.
    coneq[3260]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,c**3))-1/1008.
    coneq[3261]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,c**3))-1/2016.
    coneq[3262]=dot(b,dot(A,c**4*dot(A,c))*dot(A,c**3))-1/672.
    coneq[3263]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,c**3))-1/3024.
    coneq[3264]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c**3))-1/6048.
    coneq[3265]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c**3))-1/12096.
    coneq[3266]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,c**3))-1/2688.
    coneq[3267]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c**3))-1/8064.
    coneq[3268]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c**3))-1/16128.
    coneq[3269]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c**3))-1/5376.
    coneq[3270]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,c**3))-1/2016.
    coneq[3271]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,c**3))-1/4032.
    coneq[3272]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,c**3))-1/1344.
    coneq[3273]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c**3))-1/2688.
    coneq[3274]=dot(b,dot(A,c**6)*dot(A,dot(A,c**2)))-1/1008.
    coneq[3275]=dot(b,dot(A,dot(A,c**5))*dot(A,dot(A,c**2)))-1/6048.
    coneq[3276]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,dot(A,c**2)))-1/30240.
    coneq[3277]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,dot(A,c**2)))-1/120960.
    coneq[3278]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,dot(A,c**2)))-1/362880.
    coneq[3279]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,dot(A,c**2)))-1/725760.
    coneq[3280]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,dot(A,c**2)))-1/241920.
    coneq[3281]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,dot(A,c**2)))-1/90720.
    coneq[3282]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,dot(A,c**2)))-1/181440.
    coneq[3283]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,dot(A,c**2)))-1/60480.
    coneq[3284]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,dot(A,c**2)))-1/120960.
    coneq[3285]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,dot(A,c**2)))-1/24192.
    coneq[3286]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,dot(A,c**2)))-1/72576.
    coneq[3287]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c**2)))-1/145152.
    coneq[3288]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,dot(A,c**2)))-1/48384.
    coneq[3289]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,dot(A,c**2)))-1/18144.
    coneq[3290]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,dot(A,c**2)))-1/36288.
    coneq[3291]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,dot(A,c**2)))-1/12096.
    coneq[3292]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,dot(A,c**2)))-1/36288.
    coneq[3293]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,dot(A,c**2)))-1/72576.
    coneq[3294]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,dot(A,c**2)))-1/24192.
    coneq[3295]=dot(b,dot(A,c*dot(A,c**4))*dot(A,dot(A,c**2)))-1/5040.
    coneq[3296]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,dot(A,c**2)))-1/20160.
    coneq[3297]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c**2)))-1/60480.
    coneq[3298]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c**2)))-1/120960.
    coneq[3299]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c**2)))-1/40320.
    coneq[3300]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,dot(A,c**2)))-1/15120.
    coneq[3301]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c**2)))-1/30240.
    coneq[3302]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,dot(A,c**2)))-1/10080.
    coneq[3303]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c**2)))-1/20160.
    coneq[3304]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,dot(A,c**2)))-1/4032.
    coneq[3305]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,dot(A,c**2)))-1/12096.
    coneq[3306]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**2)))-1/24192.
    coneq[3307]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,dot(A,c**2)))-1/8064.
    coneq[3308]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,dot(A,c**2)))-1/3024.
    coneq[3309]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,dot(A,c**2)))-1/6048.
    coneq[3310]=dot(b,dot(A,c**4*dot(A,c))*dot(A,dot(A,c**2)))-1/2016.
    coneq[3311]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,dot(A,c**2)))-1/9072.
    coneq[3312]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,dot(A,c**2)))-1/18144.
    coneq[3313]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,dot(A,c**2)))-1/36288.
    coneq[3314]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,dot(A,c**2)))-1/8064.
    coneq[3315]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,dot(A,c**2)))-1/24192.
    coneq[3316]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**2)))-1/48384.
    coneq[3317]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,dot(A,c**2)))-1/16128.
    coneq[3318]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,dot(A,c**2)))-1/6048.
    coneq[3319]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c**2)))-1/12096.
    coneq[3320]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,dot(A,c**2)))-1/4032.
    coneq[3321]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,dot(A,c**2)))-1/8064.
    coneq[3322]=dot(b,dot(A,c**6)*dot(A,dot(A,dot(A,c))))-1/2016.
    coneq[3323]=dot(b,dot(A,dot(A,c**5))*dot(A,dot(A,dot(A,c))))-1/12096.
    coneq[3324]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,dot(A,dot(A,c))))-1/60480.
    coneq[3325]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,dot(A,dot(A,c))))-1/241920.
    coneq[3326]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,dot(A,dot(A,c))))-1/725760.
    coneq[3327]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,dot(A,dot(A,c))))-1/1451520.
    coneq[3328]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,dot(A,dot(A,c))))-1/483840.
    coneq[3329]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,dot(A,dot(A,c))))-1/181440.
    coneq[3330]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,dot(A,dot(A,c))))-1/362880.
    coneq[3331]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/120960.
    coneq[3332]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/241920.
    coneq[3333]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,dot(A,dot(A,c))))-1/48384.
    coneq[3334]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,dot(A,dot(A,c))))-1/145152.
    coneq[3335]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,dot(A,c))))-1/290304.
    coneq[3336]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/96768.
    coneq[3337]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,dot(A,dot(A,c))))-1/36288.
    coneq[3338]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/72576.
    coneq[3339]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/24192.
    coneq[3340]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,dot(A,dot(A,c))))-1/72576.
    coneq[3341]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/145152.
    coneq[3342]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/48384.
    coneq[3343]=dot(b,dot(A,c*dot(A,c**4))*dot(A,dot(A,dot(A,c))))-1/10080.
    coneq[3344]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,dot(A,dot(A,c))))-1/40320.
    coneq[3345]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,dot(A,c))))-1/120960.
    coneq[3346]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,dot(A,c))))-1/241920.
    coneq[3347]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/80640.
    coneq[3348]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,dot(A,dot(A,c))))-1/30240.
    coneq[3349]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/60480.
    coneq[3350]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/20160.
    coneq[3351]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/40320.
    coneq[3352]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,dot(A,dot(A,c))))-1/8064.
    coneq[3353]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c))))-1/24192.
    coneq[3354]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/48384.
    coneq[3355]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/16128.
    coneq[3356]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,dot(A,dot(A,c))))-1/6048.
    coneq[3357]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/12096.
    coneq[3358]=dot(b,dot(A,c**4*dot(A,c))*dot(A,dot(A,dot(A,c))))-1/4032.
    coneq[3359]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,dot(A,dot(A,c))))-1/18144.
    coneq[3360]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/36288.
    coneq[3361]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/72576.
    coneq[3362]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,dot(A,dot(A,c))))-1/16128.
    coneq[3363]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c))))-1/48384.
    coneq[3364]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c))))-1/96768.
    coneq[3365]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/32256.
    coneq[3366]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,dot(A,dot(A,c))))-1/12096.
    coneq[3367]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))-1/24192.
    coneq[3368]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c))))-1/8064.
    coneq[3369]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c))))-1/16128.
    coneq[3370]=dot(b,dot(A,c**6)*dot(A,c*dot(A,c)))-1/672.
    coneq[3371]=dot(b,dot(A,dot(A,c**5))*dot(A,c*dot(A,c)))-1/4032.
    coneq[3372]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,c*dot(A,c)))-1/20160.
    coneq[3373]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,c*dot(A,c)))-1/80640.
    coneq[3374]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c*dot(A,c)))-1/241920.
    coneq[3375]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c*dot(A,c)))-1/483840.
    coneq[3376]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c*dot(A,c)))-1/161280.
    coneq[3377]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,c*dot(A,c)))-1/60480.
    coneq[3378]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c*dot(A,c)))-1/120960.
    coneq[3379]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,c*dot(A,c)))-1/40320.
    coneq[3380]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c*dot(A,c)))-1/80640.
    coneq[3381]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,c*dot(A,c)))-1/16128.
    coneq[3382]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,c*dot(A,c)))-1/48384.
    coneq[3383]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c*dot(A,c)))-1/96768.
    coneq[3384]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,c*dot(A,c)))-1/32256.
    coneq[3385]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,c*dot(A,c)))-1/12096.
    coneq[3386]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,c*dot(A,c)))-1/24192.
    coneq[3387]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,c*dot(A,c)))-1/8064.
    coneq[3388]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c*dot(A,c)))-1/24192.
    coneq[3389]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c*dot(A,c)))-1/48384.
    coneq[3390]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c*dot(A,c)))-1/16128.
    coneq[3391]=dot(b,dot(A,c*dot(A,c**4))*dot(A,c*dot(A,c)))-1/3360.
    coneq[3392]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,c*dot(A,c)))-1/13440.
    coneq[3393]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,c*dot(A,c)))-1/40320.
    coneq[3394]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c*dot(A,c)))-1/80640.
    coneq[3395]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,c*dot(A,c)))-1/26880.
    coneq[3396]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,c*dot(A,c)))-1/10080.
    coneq[3397]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,c*dot(A,c)))-1/20160.
    coneq[3398]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,c*dot(A,c)))-1/6720.
    coneq[3399]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,c*dot(A,c)))-1/13440.
    coneq[3400]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,c*dot(A,c)))-1/2688.
    coneq[3401]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,c*dot(A,c)))-1/8064.
    coneq[3402]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c)))-1/16128.
    coneq[3403]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,c*dot(A,c)))-1/5376.
    coneq[3404]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,c*dot(A,c)))-1/2016.
    coneq[3405]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,c*dot(A,c)))-1/4032.
    coneq[3406]=dot(b,dot(A,c**4*dot(A,c))*dot(A,c*dot(A,c)))-1/1344.
    coneq[3407]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,c*dot(A,c)))-1/6048.
    coneq[3408]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c*dot(A,c)))-1/12096.
    coneq[3409]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c*dot(A,c)))-1/24192.
    coneq[3410]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,c*dot(A,c)))-1/5376.
    coneq[3411]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c*dot(A,c)))-1/16128.
    coneq[3412]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c)))-1/32256.
    coneq[3413]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c*dot(A,c)))-1/10752.
    coneq[3414]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,c*dot(A,c)))-1/4032.
    coneq[3415]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,c*dot(A,c)))-1/8064.
    coneq[3416]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,c*dot(A,c)))-1/2688.
    coneq[3417]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c*dot(A,c)))-1/5376.
    coneq[3418]=dot(b,dot(A,c**7)*dot(A,c**2))-1/288.
    coneq[3419]=dot(b,dot(A,dot(A,c**6))*dot(A,c**2))-1/2016.
    coneq[3420]=dot(b,dot(A,dot(A,dot(A,c**5)))*dot(A,c**2))-1/12096.
    coneq[3421]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4))))*dot(A,c**2))-1/60480.
    coneq[3422]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))*dot(A,c**2))-1/241920.
    coneq[3423]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*dot(A,c**2))-1/725760.
    coneq[3424]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*dot(A,c**2))-1/1451520.
    coneq[3425]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*dot(A,c**2))-1/483840.
    coneq[3426]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))*dot(A,c**2))-1/181440.
    coneq[3427]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*dot(A,c**2))-1/362880.
    coneq[3428]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))*dot(A,c**2))-1/120960.
    coneq[3429]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*dot(A,c**2))-1/241920.
    coneq[3430]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3))))*dot(A,c**2))-1/48384.
    coneq[3431]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))*dot(A,c**2))-1/145152.
    coneq[3432]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*dot(A,c**2))-1/290304.
    coneq[3433]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))*dot(A,c**2))-1/96768.
    coneq[3434]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))*dot(A,c**2))-1/36288.
    coneq[3435]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))*dot(A,c**2))-1/72576.
    coneq[3436]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c))))*dot(A,c**2))-1/24192.
    coneq[3437]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))*dot(A,c**2))-1/72576.
    coneq[3438]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*dot(A,c**2))-1/145152.
    coneq[3439]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))*dot(A,c**2))-1/48384.
    coneq[3440]=dot(b,dot(A,dot(A,c*dot(A,c**4)))*dot(A,c**2))-1/10080.
    coneq[3441]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3))))*dot(A,c**2))-1/40320.
    coneq[3442]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))*dot(A,c**2))-1/120960.
    coneq[3443]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c**2))-1/241920.
    coneq[3444]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))*dot(A,c**2))-1/80640.
    coneq[3445]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))*dot(A,c**2))-1/30240.
    coneq[3446]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))*dot(A,c**2))-1/60480.
    coneq[3447]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))*dot(A,c**2))-1/20160.
    coneq[3448]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))*dot(A,c**2))-1/40320.
    coneq[3449]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)))*dot(A,c**2))-1/8064.
    coneq[3450]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))*dot(A,c**2))-1/24192.
    coneq[3451]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))*dot(A,c**2))-1/48384.
    coneq[3452]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))*dot(A,c**2))-1/16128.
    coneq[3453]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)))*dot(A,c**2))-1/6048.
    coneq[3454]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))))*dot(A,c**2))-1/12096.
    coneq[3455]=dot(b,dot(A,dot(A,c**4*dot(A,c)))*dot(A,c**2))-1/4032.
    coneq[3456]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))*dot(A,c**2))-1/18144.
    coneq[3457]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))*dot(A,c**2))-1/36288.
    coneq[3458]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*dot(A,c**2))-1/72576.
    coneq[3459]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)))*dot(A,c**2))-1/16128.
    coneq[3460]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))*dot(A,c**2))-1/48384.
    coneq[3461]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*dot(A,c**2))-1/96768.
    coneq[3462]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))*dot(A,c**2))-1/32256.
    coneq[3463]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))*dot(A,c**2))-1/12096.
    coneq[3464]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))*dot(A,c**2))-1/24192.
    coneq[3465]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))*dot(A,c**2))-1/8064.
    coneq[3466]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*dot(A,c**2))-1/16128.
    coneq[3467]=dot(b,dot(A,c*dot(A,c**5))*dot(A,c**2))-1/1728.
    coneq[3468]=dot(b,dot(A,c*dot(A,dot(A,c**4)))*dot(A,c**2))-1/8640.
    coneq[3469]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3))))*dot(A,c**2))-1/34560.
    coneq[3470]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c**2))-1/103680.
    coneq[3471]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c**2))-1/207360.
    coneq[3472]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c**2))-1/69120.
    coneq[3473]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))*dot(A,c**2))-1/25920.
    coneq[3474]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c**2))-1/51840.
    coneq[3475]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))*dot(A,c**2))-1/17280.
    coneq[3476]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c**2))-1/34560.
    coneq[3477]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)))*dot(A,c**2))-1/6912.
    coneq[3478]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))*dot(A,c**2))-1/20736.
    coneq[3479]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c**2))-1/41472.
    coneq[3480]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))*dot(A,c**2))-1/13824.
    coneq[3481]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)))*dot(A,c**2))-1/5184.
    coneq[3482]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))*dot(A,c**2))-1/10368.
    coneq[3483]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)))*dot(A,c**2))-1/3456.
    coneq[3484]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c**2))-1/10368.
    coneq[3485]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c**2))-1/20736.
    coneq[3486]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c**2))-1/6912.
    coneq[3487]=dot(b,dot(A,c**2*dot(A,c**4))*dot(A,c**2))-1/1440.
    coneq[3488]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)))*dot(A,c**2))-1/5760.
    coneq[3489]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))*dot(A,c**2))-1/17280.
    coneq[3490]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**2))-1/34560.
    coneq[3491]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))*dot(A,c**2))-1/11520.
    coneq[3492]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)))*dot(A,c**2))-1/4320.
    coneq[3493]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))*dot(A,c**2))-1/8640.
    coneq[3494]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)))*dot(A,c**2))-1/2880.
    coneq[3495]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))*dot(A,c**2))-1/5760.
    coneq[3496]=dot(b,dot(A,c**3*dot(A,c**3))*dot(A,c**2))-1/1152.
    coneq[3497]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)))*dot(A,c**2))-1/3456.
    coneq[3498]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))))*dot(A,c**2))-1/6912.
    coneq[3499]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)))*dot(A,c**2))-1/2304.
    coneq[3500]=dot(b,dot(A,c**4*dot(A,c**2))*dot(A,c**2))-1/864.
    coneq[3501]=dot(b,dot(A,c**4*dot(A,dot(A,c)))*dot(A,c**2))-1/1728.
    coneq[3502]=dot(b,dot(A,c**5*dot(A,c))*dot(A,c**2))-1/576.
    coneq[3503]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3))*dot(A,c**2))-1/3456.
    coneq[3504]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))*dot(A,c**2))-1/10368.
    coneq[3505]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))*dot(A,c**2))-1/20736.
    coneq[3506]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))*dot(A,c**2))-1/6912.
    coneq[3507]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3))*dot(A,c**2))-1/6912.
    coneq[3508]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))*dot(A,c**2))-1/20736.
    coneq[3509]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*dot(A,c**2))-1/41472.
    coneq[3510]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))*dot(A,c**2))-1/13824.
    coneq[3511]=dot(b,dot(A,dot(A,c)*dot(A,c**4))*dot(A,c**2))-1/2880.
    coneq[3512]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)))*dot(A,c**2))-1/11520.
    coneq[3513]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))*dot(A,c**2))-1/34560.
    coneq[3514]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**2))-1/69120.
    coneq[3515]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))*dot(A,c**2))-1/23040.
    coneq[3516]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))*dot(A,c**2))-1/8640.
    coneq[3517]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))*dot(A,c**2))-1/17280.
    coneq[3518]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))*dot(A,c**2))-1/5760.
    coneq[3519]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*dot(A,c**2))-1/11520.
    coneq[3520]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2))*dot(A,c**2))-1/2592.
    coneq[3521]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c**2))-1/5184.
    coneq[3522]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c**2))-1/10368.
    coneq[3523]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3))*dot(A,c**2))-1/2304.
    coneq[3524]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c**2))-1/6912.
    coneq[3525]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c**2))-1/13824.
    coneq[3526]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c**2))-1/4608.
    coneq[3527]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2))*dot(A,c**2))-1/1728.
    coneq[3528]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))*dot(A,c**2))-1/3456.
    coneq[3529]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c))*dot(A,c**2))-1/1152.
    coneq[3530]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))*dot(A,c**2))-1/3456.
    coneq[3531]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*dot(A,c**2))-1/6912.
    coneq[3532]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c**2))-1/2304.
    coneq[3533]=dot(b,dot(A,c**7)*dot(A,dot(A,c)))-1/576.
    coneq[3534]=dot(b,dot(A,dot(A,c**6))*dot(A,dot(A,c)))-1/4032.
    coneq[3535]=dot(b,dot(A,dot(A,dot(A,c**5)))*dot(A,dot(A,c)))-1/24192.
    coneq[3536]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4))))*dot(A,dot(A,c)))-1/120960.
    coneq[3537]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))*dot(A,dot(A,c)))-1/483840.
    coneq[3538]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*dot(A,dot(A,c)))-1/1451520.
    coneq[3539]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*dot(A,dot(A,c)))-1/2903040.
    coneq[3540]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*dot(A,dot(A,c)))-1/967680.
    coneq[3541]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))*dot(A,dot(A,c)))-1/362880.
    coneq[3542]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*dot(A,dot(A,c)))-1/725760.
    coneq[3543]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))*dot(A,dot(A,c)))-1/241920.
    coneq[3544]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*dot(A,dot(A,c)))-1/483840.
    coneq[3545]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3))))*dot(A,dot(A,c)))-1/96768.
    coneq[3546]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))*dot(A,dot(A,c)))-1/290304.
    coneq[3547]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*dot(A,dot(A,c)))-1/580608.
    coneq[3548]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))*dot(A,dot(A,c)))-1/193536.
    coneq[3549]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))*dot(A,dot(A,c)))-1/72576.
    coneq[3550]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/145152.
    coneq[3551]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c))))*dot(A,dot(A,c)))-1/48384.
    coneq[3552]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))*dot(A,dot(A,c)))-1/145152.
    coneq[3553]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/290304.
    coneq[3554]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))*dot(A,dot(A,c)))-1/96768.
    coneq[3555]=dot(b,dot(A,dot(A,c*dot(A,c**4)))*dot(A,dot(A,c)))-1/20160.
    coneq[3556]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3))))*dot(A,dot(A,c)))-1/80640.
    coneq[3557]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))*dot(A,dot(A,c)))-1/241920.
    coneq[3558]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,dot(A,c)))-1/483840.
    coneq[3559]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))*dot(A,dot(A,c)))-1/161280.
    coneq[3560]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))*dot(A,dot(A,c)))-1/60480.
    coneq[3561]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/120960.
    coneq[3562]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))*dot(A,dot(A,c)))-1/40320.
    coneq[3563]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))*dot(A,dot(A,c)))-1/80640.
    coneq[3564]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)))*dot(A,dot(A,c)))-1/16128.
    coneq[3565]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))*dot(A,dot(A,c)))-1/48384.
    coneq[3566]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/96768.
    coneq[3567]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))*dot(A,dot(A,c)))-1/32256.
    coneq[3568]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)))*dot(A,dot(A,c)))-1/12096.
    coneq[3569]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/24192.
    coneq[3570]=dot(b,dot(A,dot(A,c**4*dot(A,c)))*dot(A,dot(A,c)))-1/8064.
    coneq[3571]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))*dot(A,dot(A,c)))-1/36288.
    coneq[3572]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/72576.
    coneq[3573]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/145152.
    coneq[3574]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)))*dot(A,dot(A,c)))-1/32256.
    coneq[3575]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))*dot(A,dot(A,c)))-1/96768.
    coneq[3576]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/193536.
    coneq[3577]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))*dot(A,dot(A,c)))-1/64512.
    coneq[3578]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))*dot(A,dot(A,c)))-1/24192.
    coneq[3579]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/48384.
    coneq[3580]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))*dot(A,dot(A,c)))-1/16128.
    coneq[3581]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*dot(A,dot(A,c)))-1/32256.
    coneq[3582]=dot(b,dot(A,c*dot(A,c**5))*dot(A,dot(A,c)))-1/3456.
    coneq[3583]=dot(b,dot(A,c*dot(A,dot(A,c**4)))*dot(A,dot(A,c)))-1/17280.
    coneq[3584]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3))))*dot(A,dot(A,c)))-1/69120.
    coneq[3585]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,dot(A,c)))-1/207360.
    coneq[3586]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,dot(A,c)))-1/414720.
    coneq[3587]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,dot(A,c)))-1/138240.
    coneq[3588]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))*dot(A,dot(A,c)))-1/51840.
    coneq[3589]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/103680.
    coneq[3590]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))*dot(A,dot(A,c)))-1/34560.
    coneq[3591]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,dot(A,c)))-1/69120.
    coneq[3592]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)))*dot(A,dot(A,c)))-1/13824.
    coneq[3593]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))*dot(A,dot(A,c)))-1/41472.
    coneq[3594]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/82944.
    coneq[3595]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))*dot(A,dot(A,c)))-1/27648.
    coneq[3596]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)))*dot(A,dot(A,c)))-1/10368.
    coneq[3597]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/20736.
    coneq[3598]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)))*dot(A,dot(A,c)))-1/6912.
    coneq[3599]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))*dot(A,dot(A,c)))-1/20736.
    coneq[3600]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/41472.
    coneq[3601]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))*dot(A,dot(A,c)))-1/13824.
    coneq[3602]=dot(b,dot(A,c**2*dot(A,c**4))*dot(A,dot(A,c)))-1/2880.
    coneq[3603]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)))*dot(A,dot(A,c)))-1/11520.
    coneq[3604]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c)))-1/34560.
    coneq[3605]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/69120.
    coneq[3606]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c)))-1/23040.
    coneq[3607]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)))*dot(A,dot(A,c)))-1/8640.
    coneq[3608]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/17280.
    coneq[3609]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)))*dot(A,dot(A,c)))-1/5760.
    coneq[3610]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c)))-1/11520.
    coneq[3611]=dot(b,dot(A,c**3*dot(A,c**3))*dot(A,dot(A,c)))-1/2304.
    coneq[3612]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)))*dot(A,dot(A,c)))-1/6912.
    coneq[3613]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/13824.
    coneq[3614]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)))*dot(A,dot(A,c)))-1/4608.
    coneq[3615]=dot(b,dot(A,c**4*dot(A,c**2))*dot(A,dot(A,c)))-1/1728.
    coneq[3616]=dot(b,dot(A,c**4*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/3456.
    coneq[3617]=dot(b,dot(A,c**5*dot(A,c))*dot(A,dot(A,c)))-1/1152.
    coneq[3618]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3))*dot(A,dot(A,c)))-1/6912.
    coneq[3619]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))*dot(A,dot(A,c)))-1/20736.
    coneq[3620]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/41472.
    coneq[3621]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))*dot(A,dot(A,c)))-1/13824.
    coneq[3622]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3))*dot(A,dot(A,c)))-1/13824.
    coneq[3623]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))*dot(A,dot(A,c)))-1/41472.
    coneq[3624]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/82944.
    coneq[3625]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))*dot(A,dot(A,c)))-1/27648.
    coneq[3626]=dot(b,dot(A,dot(A,c)*dot(A,c**4))*dot(A,dot(A,c)))-1/5760.
    coneq[3627]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)))*dot(A,dot(A,c)))-1/23040.
    coneq[3628]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c)))-1/69120.
    coneq[3629]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c)))-1/138240.
    coneq[3630]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c)))-1/46080.
    coneq[3631]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))*dot(A,dot(A,c)))-1/17280.
    coneq[3632]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/34560.
    coneq[3633]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))*dot(A,dot(A,c)))-1/11520.
    coneq[3634]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c)))-1/23040.
    coneq[3635]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2))*dot(A,dot(A,c)))-1/5184.
    coneq[3636]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/10368.
    coneq[3637]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/20736.
    coneq[3638]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3))*dot(A,dot(A,c)))-1/4608.
    coneq[3639]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))*dot(A,dot(A,c)))-1/13824.
    coneq[3640]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)))-1/27648.
    coneq[3641]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))*dot(A,dot(A,c)))-1/9216.
    coneq[3642]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2))*dot(A,dot(A,c)))-1/3456.
    coneq[3643]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/6912.
    coneq[3644]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c))*dot(A,dot(A,c)))-1/2304.
    coneq[3645]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))*dot(A,dot(A,c)))-1/6912.
    coneq[3646]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/13824.
    coneq[3647]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))*dot(A,dot(A,c)))-1/4608.
    coneq[3648]=dot(b,dot(A,c**8)*dot(A,c))-1/216.
    coneq[3649]=dot(b,dot(A,dot(A,c**7))*dot(A,c))-1/1728.
    coneq[3650]=dot(b,dot(A,dot(A,dot(A,c**6)))*dot(A,c))-1/12096.
    coneq[3651]=dot(b,dot(A,dot(A,dot(A,dot(A,c**5))))*dot(A,c))-1/72576.
    coneq[3652]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**4)))))*dot(A,c))-1/362880.
    coneq[3653]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))*dot(A,c))-1/1451520.
    coneq[3654]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))*dot(A,c))-1/4354560.
    coneq[3655]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))*dot(A,c))-1/8709120.
    coneq[3656]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))*dot(A,c))-1/2903040.
    coneq[3657]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))*dot(A,c))-1/1088640.
    coneq[3658]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))*dot(A,c))-1/2177280.
    coneq[3659]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))*dot(A,c))-1/725760.
    coneq[3660]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))*dot(A,c))-1/1451520.
    coneq[3661]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3)))))*dot(A,c))-1/290304.
    coneq[3662]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))*dot(A,c))-1/870912.
    coneq[3663]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))*dot(A,c))-1/1741824.
    coneq[3664]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))*dot(A,c))-1/580608.
    coneq[3665]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))*dot(A,c))-1/217728.
    coneq[3666]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))*dot(A,c))-1/435456.
    coneq[3667]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)))))*dot(A,c))-1/145152.
    coneq[3668]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))*dot(A,c))-1/435456.
    coneq[3669]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))*dot(A,c))-1/870912.
    coneq[3670]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))*dot(A,c))-1/290304.
    coneq[3671]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**4))))*dot(A,c))-1/60480.
    coneq[3672]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3)))))*dot(A,c))-1/241920.
    coneq[3673]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))*dot(A,c))-1/725760.
    coneq[3674]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))*dot(A,c))-1/1451520.
    coneq[3675]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))*dot(A,c))-1/483840.
    coneq[3676]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))*dot(A,c))-1/181440.
    coneq[3677]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))*dot(A,c))-1/362880.
    coneq[3678]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))*dot(A,c))-1/120960.
    coneq[3679]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))*dot(A,c))-1/241920.
    coneq[3680]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**3))))*dot(A,c))-1/48384.
    coneq[3681]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))*dot(A,c))-1/145152.
    coneq[3682]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/290304.
    coneq[3683]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))*dot(A,c))-1/96768.
    coneq[3684]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**2))))*dot(A,c))-1/36288.
    coneq[3685]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)))))*dot(A,c))-1/72576.
    coneq[3686]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c))))*dot(A,c))-1/24192.
    coneq[3687]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))*dot(A,c))-1/108864.
    coneq[3688]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))*dot(A,c))-1/217728.
    coneq[3689]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))*dot(A,c))-1/435456.
    coneq[3690]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3))))*dot(A,c))-1/96768.
    coneq[3691]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))*dot(A,c))-1/290304.
    coneq[3692]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/580608.
    coneq[3693]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))*dot(A,c))-1/193536.
    coneq[3694]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))*dot(A,c))-1/72576.
    coneq[3695]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))*dot(A,c))-1/145152.
    coneq[3696]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))*dot(A,c))-1/48384.
    coneq[3697]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))*dot(A,c))-1/96768.
    coneq[3698]=dot(b,dot(A,dot(A,c*dot(A,c**5)))*dot(A,c))-1/10368.
    coneq[3699]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**4))))*dot(A,c))-1/51840.
    coneq[3700]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3)))))*dot(A,c))-1/207360.
    coneq[3701]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))*dot(A,c))-1/622080.
    coneq[3702]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*dot(A,c))-1/1244160.
    coneq[3703]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))*dot(A,c))-1/414720.
    coneq[3704]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))*dot(A,c))-1/155520.
    coneq[3705]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))*dot(A,c))-1/311040.
    coneq[3706]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))*dot(A,c))-1/103680.
    coneq[3707]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))*dot(A,c))-1/207360.
    coneq[3708]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**3))))*dot(A,c))-1/41472.
    coneq[3709]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))*dot(A,c))-1/124416.
    coneq[3710]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/248832.
    coneq[3711]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))*dot(A,c))-1/82944.
    coneq[3712]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2))))*dot(A,c))-1/31104.
    coneq[3713]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))*dot(A,c))-1/62208.
    coneq[3714]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c))))*dot(A,c))-1/20736.
    coneq[3715]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))*dot(A,c))-1/62208.
    coneq[3716]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))*dot(A,c))-1/124416.
    coneq[3717]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))*dot(A,c))-1/41472.
    coneq[3718]=dot(b,dot(A,dot(A,c**2*dot(A,c**4)))*dot(A,c))-1/8640.
    coneq[3719]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**3))))*dot(A,c))-1/34560.
    coneq[3720]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))*dot(A,c))-1/103680.
    coneq[3721]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/207360.
    coneq[3722]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))*dot(A,c))-1/69120.
    coneq[3723]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2))))*dot(A,c))-1/25920.
    coneq[3724]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))*dot(A,c))-1/51840.
    coneq[3725]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c))))*dot(A,c))-1/17280.
    coneq[3726]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))*dot(A,c))-1/34560.
    coneq[3727]=dot(b,dot(A,dot(A,c**3*dot(A,c**3)))*dot(A,c))-1/6912.
    coneq[3728]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**2))))*dot(A,c))-1/20736.
    coneq[3729]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/41472.
    coneq[3730]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c))))*dot(A,c))-1/13824.
    coneq[3731]=dot(b,dot(A,dot(A,c**4*dot(A,c**2)))*dot(A,c))-1/5184.
    coneq[3732]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c))))*dot(A,c))-1/10368.
    coneq[3733]=dot(b,dot(A,dot(A,c**5*dot(A,c)))*dot(A,c))-1/3456.
    coneq[3734]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**3)))*dot(A,c))-1/20736.
    coneq[3735]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))*dot(A,c))-1/62208.
    coneq[3736]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/124416.
    coneq[3737]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))*dot(A,c))-1/41472.
    coneq[3738]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3)))*dot(A,c))-1/41472.
    coneq[3739]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))*dot(A,c))-1/124416.
    coneq[3740]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/248832.
    coneq[3741]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))*dot(A,c))-1/82944.
    coneq[3742]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**4)))*dot(A,c))-1/17280.
    coneq[3743]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3))))*dot(A,c))-1/69120.
    coneq[3744]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))*dot(A,c))-1/207360.
    coneq[3745]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/414720.
    coneq[3746]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))*dot(A,c))-1/138240.
    coneq[3747]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))*dot(A,c))-1/51840.
    coneq[3748]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))*dot(A,c))-1/103680.
    coneq[3749]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))*dot(A,c))-1/34560.
    coneq[3750]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))*dot(A,c))-1/69120.
    coneq[3751]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2)))*dot(A,c))-1/15552.
    coneq[3752]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))*dot(A,c))-1/31104.
    coneq[3753]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))*dot(A,c))-1/62208.
    coneq[3754]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**3)))*dot(A,c))-1/13824.
    coneq[3755]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))*dot(A,c))-1/41472.
    coneq[3756]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/82944.
    coneq[3757]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))*dot(A,c))-1/27648.
    coneq[3758]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2)))*dot(A,c))-1/10368.
    coneq[3759]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))*dot(A,c))-1/20736.
    coneq[3760]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c)))*dot(A,c))-1/6912.
    coneq[3761]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))*dot(A,c))-1/20736.
    coneq[3762]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))*dot(A,c))-1/41472.
    coneq[3763]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))*dot(A,c))-1/13824.
    coneq[3764]=dot(b,dot(A,c*dot(A,c**6))*dot(A,c))-1/1512.
    coneq[3765]=dot(b,dot(A,c*dot(A,dot(A,c**5)))*dot(A,c))-1/9072.
    coneq[3766]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**4))))*dot(A,c))-1/45360.
    coneq[3767]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3)))))*dot(A,c))-1/181440.
    coneq[3768]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*dot(A,c))-1/544320.
    coneq[3769]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*dot(A,c))-1/1088640.
    coneq[3770]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*dot(A,c))-1/362880.
    coneq[3771]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2)))))*dot(A,c))-1/136080.
    coneq[3772]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*dot(A,c))-1/272160.
    coneq[3773]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)))))*dot(A,c))-1/90720.
    coneq[3774]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*dot(A,c))-1/181440.
    coneq[3775]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**3))))*dot(A,c))-1/36288.
    coneq[3776]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2)))))*dot(A,c))-1/108864.
    coneq[3777]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/217728.
    coneq[3778]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)))))*dot(A,c))-1/72576.
    coneq[3779]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2))))*dot(A,c))-1/27216.
    coneq[3780]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)))))*dot(A,c))-1/54432.
    coneq[3781]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c))))*dot(A,c))-1/18144.
    coneq[3782]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2))))*dot(A,c))-1/54432.
    coneq[3783]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*dot(A,c))-1/108864.
    coneq[3784]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c))))*dot(A,c))-1/36288.
    coneq[3785]=dot(b,dot(A,c*dot(A,c*dot(A,c**4)))*dot(A,c))-1/7560.
    coneq[3786]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**3))))*dot(A,c))-1/30240.
    coneq[3787]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2)))))*dot(A,c))-1/90720.
    coneq[3788]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/181440.
    coneq[3789]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)))))*dot(A,c))-1/60480.
    coneq[3790]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2))))*dot(A,c))-1/22680.
    coneq[3791]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)))))*dot(A,c))-1/45360.
    coneq[3792]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c))))*dot(A,c))-1/15120.
    coneq[3793]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c))))*dot(A,c))-1/30240.
    coneq[3794]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**3)))*dot(A,c))-1/6048.
    coneq[3795]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2))))*dot(A,c))-1/18144.
    coneq[3796]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/36288.
    coneq[3797]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c))))*dot(A,c))-1/12096.
    coneq[3798]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**2)))*dot(A,c))-1/4536.
    coneq[3799]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c))))*dot(A,c))-1/9072.
    coneq[3800]=dot(b,dot(A,c*dot(A,c**4*dot(A,c)))*dot(A,c))-1/3024.
    coneq[3801]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2)))*dot(A,c))-1/13608.
    coneq[3802]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c))))*dot(A,c))-1/27216.
    coneq[3803]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*dot(A,c))-1/54432.
    coneq[3804]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**3)))*dot(A,c))-1/12096.
    coneq[3805]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2))))*dot(A,c))-1/36288.
    coneq[3806]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/72576.
    coneq[3807]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c))))*dot(A,c))-1/24192.
    coneq[3808]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2)))*dot(A,c))-1/9072.
    coneq[3809]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c))))*dot(A,c))-1/18144.
    coneq[3810]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)))*dot(A,c))-1/6048.
    coneq[3811]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*dot(A,c))-1/12096.
    coneq[3812]=dot(b,dot(A,c**2*dot(A,c**5))*dot(A,c))-1/1296.
    coneq[3813]=dot(b,dot(A,c**2*dot(A,dot(A,c**4)))*dot(A,c))-1/6480.
    coneq[3814]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**3))))*dot(A,c))-1/25920.
    coneq[3815]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c))-1/77760.
    coneq[3816]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/155520.
    coneq[3817]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c))-1/51840.
    coneq[3818]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2))))*dot(A,c))-1/19440.
    coneq[3819]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c))-1/38880.
    coneq[3820]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c))))*dot(A,c))-1/12960.
    coneq[3821]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c))-1/25920.
    coneq[3822]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**3)))*dot(A,c))-1/5184.
    coneq[3823]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2))))*dot(A,c))-1/15552.
    coneq[3824]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/31104.
    coneq[3825]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c))))*dot(A,c))-1/10368.
    coneq[3826]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**2)))*dot(A,c))-1/3888.
    coneq[3827]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c))))*dot(A,c))-1/7776.
    coneq[3828]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c)))*dot(A,c))-1/2592.
    coneq[3829]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c))-1/7776.
    coneq[3830]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c))-1/15552.
    coneq[3831]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c))-1/5184.
    coneq[3832]=dot(b,dot(A,c**3*dot(A,c**4))*dot(A,c))-1/1080.
    coneq[3833]=dot(b,dot(A,c**3*dot(A,dot(A,c**3)))*dot(A,c))-1/4320.
    coneq[3834]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**2))))*dot(A,c))-1/12960.
    coneq[3835]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/25920.
    coneq[3836]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c))))*dot(A,c))-1/8640.
    coneq[3837]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**2)))*dot(A,c))-1/3240.
    coneq[3838]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c))))*dot(A,c))-1/6480.
    coneq[3839]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c)))*dot(A,c))-1/2160.
    coneq[3840]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c)))*dot(A,c))-1/4320.
    coneq[3841]=dot(b,dot(A,c**4*dot(A,c**3))*dot(A,c))-1/864.
    coneq[3842]=dot(b,dot(A,c**4*dot(A,dot(A,c**2)))*dot(A,c))-1/2592.
    coneq[3843]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/5184.
    coneq[3844]=dot(b,dot(A,c**4*dot(A,c*dot(A,c)))*dot(A,c))-1/1728.
    coneq[3845]=dot(b,dot(A,c**5*dot(A,c**2))*dot(A,c))-1/648.
    coneq[3846]=dot(b,dot(A,c**5*dot(A,dot(A,c)))*dot(A,c))-1/1296.
    coneq[3847]=dot(b,dot(A,c**6*dot(A,c))*dot(A,c))-1/432.
    coneq[3848]=dot(b,dot(A,dot(A,c**3)*dot(A,c**3))*dot(A,c))-1/3456.
    coneq[3849]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**2)))*dot(A,c))-1/10368.
    coneq[3850]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/20736.
    coneq[3851]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c)))*dot(A,c))-1/6912.
    coneq[3852]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))*dot(A,c))-1/31104.
    coneq[3853]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/62208.
    coneq[3854]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))*dot(A,c))-1/20736.
    coneq[3855]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/124416.
    coneq[3856]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))*dot(A,c))-1/41472.
    coneq[3857]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))*dot(A,c))-1/13824.
    coneq[3858]=dot(b,dot(A,dot(A,c**2)*dot(A,c**4))*dot(A,c))-1/3240.
    coneq[3859]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**3)))*dot(A,c))-1/12960.
    coneq[3860]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))*dot(A,c))-1/38880.
    coneq[3861]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/77760.
    coneq[3862]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))*dot(A,c))-1/25920.
    coneq[3863]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2)))*dot(A,c))-1/9720.
    coneq[3864]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))*dot(A,c))-1/19440.
    coneq[3865]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)))*dot(A,c))-1/6480.
    coneq[3866]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))*dot(A,c))-1/12960.
    coneq[3867]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**4))*dot(A,c))-1/6480.
    coneq[3868]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3)))*dot(A,c))-1/25920.
    coneq[3869]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))*dot(A,c))-1/77760.
    coneq[3870]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/155520.
    coneq[3871]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))*dot(A,c))-1/51840.
    coneq[3872]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))*dot(A,c))-1/19440.
    coneq[3873]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))*dot(A,c))-1/38880.
    coneq[3874]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))*dot(A,c))-1/12960.
    coneq[3875]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))*dot(A,c))-1/25920.
    coneq[3876]=dot(b,dot(A,dot(A,c)*dot(A,c**5))*dot(A,c))-1/2592.
    coneq[3877]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**4)))*dot(A,c))-1/12960.
    coneq[3878]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3))))*dot(A,c))-1/51840.
    coneq[3879]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c))-1/155520.
    coneq[3880]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c))-1/311040.
    coneq[3881]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c))-1/103680.
    coneq[3882]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))*dot(A,c))-1/38880.
    coneq[3883]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c))-1/77760.
    coneq[3884]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))*dot(A,c))-1/25920.
    coneq[3885]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c))-1/51840.
    coneq[3886]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**3)))*dot(A,c))-1/10368.
    coneq[3887]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))*dot(A,c))-1/31104.
    coneq[3888]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/62208.
    coneq[3889]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))*dot(A,c))-1/20736.
    coneq[3890]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2)))*dot(A,c))-1/7776.
    coneq[3891]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))*dot(A,c))-1/15552.
    coneq[3892]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c)))*dot(A,c))-1/5184.
    coneq[3893]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c))-1/15552.
    coneq[3894]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c))-1/31104.
    coneq[3895]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c))-1/10368.
    coneq[3896]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**3))*dot(A,c))-1/2592.
    coneq[3897]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2)))*dot(A,c))-1/7776.
    coneq[3898]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/15552.
    coneq[3899]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)))*dot(A,c))-1/5184.
    coneq[3900]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**3))*dot(A,c))-1/5184.
    coneq[3901]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2)))*dot(A,c))-1/15552.
    coneq[3902]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/31104.
    coneq[3903]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)))*dot(A,c))-1/10368.
    coneq[3904]=dot(b,dot(A,c*dot(A,c)*dot(A,c**4))*dot(A,c))-1/2160.
    coneq[3905]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**3)))*dot(A,c))-1/8640.
    coneq[3906]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2))))*dot(A,c))-1/25920.
    coneq[3907]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c))-1/51840.
    coneq[3908]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c))))*dot(A,c))-1/17280.
    coneq[3909]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2)))*dot(A,c))-1/6480.
    coneq[3910]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c))))*dot(A,c))-1/12960.
    coneq[3911]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)))*dot(A,c))-1/4320.
    coneq[3912]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*dot(A,c))-1/8640.
    coneq[3913]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**2))*dot(A,c))-1/1944.
    coneq[3914]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c))-1/3888.
    coneq[3915]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c))-1/7776.
    coneq[3916]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**3))*dot(A,c))-1/1728.
    coneq[3917]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c))-1/5184.
    coneq[3918]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/10368.
    coneq[3919]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c))-1/3456.
    coneq[3920]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c**2))*dot(A,c))-1/1296.
    coneq[3921]=dot(b,dot(A,c**3*dot(A,c)*dot(A,dot(A,c)))*dot(A,c))-1/2592.
    coneq[3922]=dot(b,dot(A,c**4*dot(A,c)*dot(A,c))*dot(A,c))-1/864.
    coneq[3923]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3))*dot(A,c))-1/3456.
    coneq[3924]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c))-1/10368.
    coneq[3925]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c))-1/20736.
    coneq[3926]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c))-1/6912.
    coneq[3927]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2))*dot(A,c))-1/3888.
    coneq[3928]=dot(b,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c))-1/7776.
    coneq[3929]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c))-1/15552.
    coneq[3930]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2))*dot(A,c))-1/2592.
    coneq[3931]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*dot(A,c))-1/5184.
    coneq[3932]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c))-1/1728.
    coneq[3933]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c))-1/3456.
    coneq[3934]=dot(b,dot(A,c**4)*dot(A,c**4)*c)-1/300.
    coneq[3935]=dot(b,dot(A,dot(A,c**3))*dot(A,c**4)*c)-1/1200.
    coneq[3936]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**4)*c)-1/3600.
    coneq[3937]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**4)*c)-1/7200.
    coneq[3938]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**4)*c)-1/2400.
    coneq[3939]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**4)*c)-1/900.
    coneq[3940]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**4)*c)-1/1800.
    coneq[3941]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**4)*c)-1/600.
    coneq[3942]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**4)*c)-1/1200.
    coneq[3943]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c**3))*c)-1/4800.
    coneq[3944]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c**3))*c)-1/14400.
    coneq[3945]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**3))*c)-1/28800.
    coneq[3946]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c**3))*c)-1/9600.
    coneq[3947]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c**3))*c)-1/3600.
    coneq[3948]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c**3))*c)-1/7200.
    coneq[3949]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c**3))*c)-1/2400.
    coneq[3950]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c**3))*c)-1/4800.
    coneq[3951]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c**2)))*c)-1/43200.
    coneq[3952]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c**2)))*c)-1/86400.
    coneq[3953]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c**2)))*c)-1/28800.
    coneq[3954]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,c**2)))*c)-1/10800.
    coneq[3955]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2)))*c)-1/21600.
    coneq[3956]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,c**2)))*c)-1/7200.
    coneq[3957]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c**2)))*c)-1/14400.
    coneq[3958]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,dot(A,c))))*c)-1/172800.
    coneq[3959]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c))))*c)-1/57600.
    coneq[3960]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c))))*c)-1/21600.
    coneq[3961]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c))))*c)-1/43200.
    coneq[3962]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))*c)-1/14400.
    coneq[3963]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))*c)-1/28800.
    coneq[3964]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c*dot(A,c)))*c)-1/19200.
    coneq[3965]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c*dot(A,c)))*c)-1/7200.
    coneq[3966]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c)))*c)-1/14400.
    coneq[3967]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c*dot(A,c)))*c)-1/4800.
    coneq[3968]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c*dot(A,c)))*c)-1/9600.
    coneq[3969]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c**2))*c)-1/2700.
    coneq[3970]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,c**2))*c)-1/5400.
    coneq[3971]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,c**2))*c)-1/1800.
    coneq[3972]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,c**2))*c)-1/3600.
    coneq[3973]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c)))*c)-1/10800.
    coneq[3974]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,dot(A,c)))*c)-1/3600.
    coneq[3975]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,dot(A,c)))*c)-1/7200.
    coneq[3976]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**2*dot(A,c))*c)-1/1200.
    coneq[3977]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2*dot(A,c))*c)-1/2400.
    coneq[3978]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c)*dot(A,c))*c)-1/4800.
    coneq[3979]=dot(b,dot(A,c**5)*dot(A,c**3)*c)-1/288.
    coneq[3980]=dot(b,dot(A,dot(A,c**4))*dot(A,c**3)*c)-1/1440.
    coneq[3981]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c**3)*c)-1/5760.
    coneq[3982]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c**3)*c)-1/17280.
    coneq[3983]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**3)*c)-1/34560.
    coneq[3984]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c**3)*c)-1/11520.
    coneq[3985]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c**3)*c)-1/4320.
    coneq[3986]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c**3)*c)-1/8640.
    coneq[3987]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c**3)*c)-1/2880.
    coneq[3988]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c**3)*c)-1/5760.
    coneq[3989]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c**3)*c)-1/1152.
    coneq[3990]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c**3)*c)-1/3456.
    coneq[3991]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c**3)*c)-1/6912.
    coneq[3992]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c**3)*c)-1/2304.
    coneq[3993]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c**3)*c)-1/864.
    coneq[3994]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c**3)*c)-1/1728.
    coneq[3995]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c**3)*c)-1/576.
    coneq[3996]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c**3)*c)-1/1728.
    coneq[3997]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c**3)*c)-1/3456.
    coneq[3998]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c**3)*c)-1/1152.
    coneq[3999]=dot(b,dot(A,c**5)*dot(A,dot(A,c**2))*c)-1/864.
    coneq[4000]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,c**2))*c)-1/4320.
    coneq[4001]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,c**2))*c)-1/17280.
    coneq[4002]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c**2))*c)-1/51840.
    coneq[4003]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c**2))*c)-1/103680.
    coneq[4004]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c**2))*c)-1/34560.
    coneq[4005]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,c**2))*c)-1/12960.
    coneq[4006]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c**2))*c)-1/25920.
    coneq[4007]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,c**2))*c)-1/8640.
    coneq[4008]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c**2))*c)-1/17280.
    coneq[4009]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,c**2))*c)-1/3456.
    coneq[4010]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,c**2))*c)-1/10368.
    coneq[4011]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**2))*c)-1/20736.
    coneq[4012]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,c**2))*c)-1/6912.
    coneq[4013]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,c**2))*c)-1/2592.
    coneq[4014]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,c**2))*c)-1/5184.
    coneq[4015]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,c**2))*c)-1/1728.
    coneq[4016]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,c**2))*c)-1/5184.
    coneq[4017]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c**2))*c)-1/10368.
    coneq[4018]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,c**2))*c)-1/3456.
    coneq[4019]=dot(b,dot(A,c**5)*dot(A,dot(A,dot(A,c)))*c)-1/1728.
    coneq[4020]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,dot(A,c)))*c)-1/8640.
    coneq[4021]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,dot(A,c)))*c)-1/34560.
    coneq[4022]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,dot(A,c)))*c)-1/103680.
    coneq[4023]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,dot(A,c)))*c)-1/207360.
    coneq[4024]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,dot(A,c)))*c)-1/69120.
    coneq[4025]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,dot(A,c)))*c)-1/25920.
    coneq[4026]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c)))*c)-1/51840.
    coneq[4027]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,dot(A,c)))*c)-1/17280.
    coneq[4028]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,dot(A,c)))*c)-1/34560.
    coneq[4029]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,dot(A,c)))*c)-1/6912.
    coneq[4030]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c)))*c)-1/20736.
    coneq[4031]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c)))*c)-1/41472.
    coneq[4032]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c)))*c)-1/13824.
    coneq[4033]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,dot(A,c)))*c)-1/5184.
    coneq[4034]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*c)-1/10368.
    coneq[4035]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,dot(A,c)))*c)-1/3456.
    coneq[4036]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,dot(A,c)))*c)-1/10368.
    coneq[4037]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*c)-1/20736.
    coneq[4038]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c)))*c)-1/6912.
    coneq[4039]=dot(b,dot(A,c**5)*dot(A,c*dot(A,c))*c)-1/576.
    coneq[4040]=dot(b,dot(A,dot(A,c**4))*dot(A,c*dot(A,c))*c)-1/2880.
    coneq[4041]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c*dot(A,c))*c)-1/11520.
    coneq[4042]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c*dot(A,c))*c)-1/34560.
    coneq[4043]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c*dot(A,c))*c)-1/69120.
    coneq[4044]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c*dot(A,c))*c)-1/23040.
    coneq[4045]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c*dot(A,c))*c)-1/8640.
    coneq[4046]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c*dot(A,c))*c)-1/17280.
    coneq[4047]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c*dot(A,c))*c)-1/5760.
    coneq[4048]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c*dot(A,c))*c)-1/11520.
    coneq[4049]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c*dot(A,c))*c)-1/2304.
    coneq[4050]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c*dot(A,c))*c)-1/6912.
    coneq[4051]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c))*c)-1/13824.
    coneq[4052]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c*dot(A,c))*c)-1/4608.
    coneq[4053]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c*dot(A,c))*c)-1/1728.
    coneq[4054]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c*dot(A,c))*c)-1/3456.
    coneq[4055]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c*dot(A,c))*c)-1/1152.
    coneq[4056]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c*dot(A,c))*c)-1/3456.
    coneq[4057]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c*dot(A,c))*c)-1/6912.
    coneq[4058]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c*dot(A,c))*c)-1/2304.
    coneq[4059]=dot(b,dot(A,c**6)*dot(A,c**2)*c)-1/252.
    coneq[4060]=dot(b,dot(A,dot(A,c**5))*dot(A,c**2)*c)-1/1512.
    coneq[4061]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,c**2)*c)-1/7560.
    coneq[4062]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,c**2)*c)-1/30240.
    coneq[4063]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c**2)*c)-1/90720.
    coneq[4064]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c**2)*c)-1/181440.
    coneq[4065]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c**2)*c)-1/60480.
    coneq[4066]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,c**2)*c)-1/22680.
    coneq[4067]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c**2)*c)-1/45360.
    coneq[4068]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,c**2)*c)-1/15120.
    coneq[4069]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c**2)*c)-1/30240.
    coneq[4070]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,c**2)*c)-1/6048.
    coneq[4071]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,c**2)*c)-1/18144.
    coneq[4072]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c**2)*c)-1/36288.
    coneq[4073]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,c**2)*c)-1/12096.
    coneq[4074]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,c**2)*c)-1/4536.
    coneq[4075]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,c**2)*c)-1/9072.
    coneq[4076]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,c**2)*c)-1/3024.
    coneq[4077]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c**2)*c)-1/9072.
    coneq[4078]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c**2)*c)-1/18144.
    coneq[4079]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c**2)*c)-1/6048.
    coneq[4080]=dot(b,dot(A,c*dot(A,c**4))*dot(A,c**2)*c)-1/1260.
    coneq[4081]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,c**2)*c)-1/5040.
    coneq[4082]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,c**2)*c)-1/15120.
    coneq[4083]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**2)*c)-1/30240.
    coneq[4084]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,c**2)*c)-1/10080.
    coneq[4085]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,c**2)*c)-1/3780.
    coneq[4086]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,c**2)*c)-1/7560.
    coneq[4087]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,c**2)*c)-1/2520.
    coneq[4088]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,c**2)*c)-1/5040.
    coneq[4089]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,c**2)*c)-1/1008.
    coneq[4090]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,c**2)*c)-1/3024.
    coneq[4091]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,c**2)*c)-1/6048.
    coneq[4092]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,c**2)*c)-1/2016.
    coneq[4093]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,c**2)*c)-1/756.
    coneq[4094]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,c**2)*c)-1/1512.
    coneq[4095]=dot(b,dot(A,c**4*dot(A,c))*dot(A,c**2)*c)-1/504.
    coneq[4096]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,c**2)*c)-1/2268.
    coneq[4097]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c**2)*c)-1/4536.
    coneq[4098]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c**2)*c)-1/9072.
    coneq[4099]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,c**2)*c)-1/2016.
    coneq[4100]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c**2)*c)-1/6048.
    coneq[4101]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c**2)*c)-1/12096.
    coneq[4102]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c**2)*c)-1/4032.
    coneq[4103]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,c**2)*c)-1/1512.
    coneq[4104]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,c**2)*c)-1/3024.
    coneq[4105]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,c**2)*c)-1/1008.
    coneq[4106]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c**2)*c)-1/2016.
    coneq[4107]=dot(b,dot(A,c**6)*dot(A,dot(A,c))*c)-1/504.
    coneq[4108]=dot(b,dot(A,dot(A,c**5))*dot(A,dot(A,c))*c)-1/3024.
    coneq[4109]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,dot(A,c))*c)-1/15120.
    coneq[4110]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,dot(A,c))*c)-1/60480.
    coneq[4111]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,dot(A,c))*c)-1/181440.
    coneq[4112]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,dot(A,c))*c)-1/362880.
    coneq[4113]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,dot(A,c))*c)-1/120960.
    coneq[4114]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,dot(A,c))*c)-1/45360.
    coneq[4115]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,dot(A,c))*c)-1/90720.
    coneq[4116]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,dot(A,c))*c)-1/30240.
    coneq[4117]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,dot(A,c))*c)-1/60480.
    coneq[4118]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,dot(A,c))*c)-1/12096.
    coneq[4119]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,dot(A,c))*c)-1/36288.
    coneq[4120]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c))*c)-1/72576.
    coneq[4121]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,dot(A,c))*c)-1/24192.
    coneq[4122]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,dot(A,c))*c)-1/9072.
    coneq[4123]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,dot(A,c))*c)-1/18144.
    coneq[4124]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,dot(A,c))*c)-1/6048.
    coneq[4125]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,dot(A,c))*c)-1/18144.
    coneq[4126]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,dot(A,c))*c)-1/36288.
    coneq[4127]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,dot(A,c))*c)-1/12096.
    coneq[4128]=dot(b,dot(A,c*dot(A,c**4))*dot(A,dot(A,c))*c)-1/2520.
    coneq[4129]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,dot(A,c))*c)-1/10080.
    coneq[4130]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c))*c)-1/30240.
    coneq[4131]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c))*c)-1/60480.
    coneq[4132]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c))*c)-1/20160.
    coneq[4133]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,dot(A,c))*c)-1/7560.
    coneq[4134]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c))*c)-1/15120.
    coneq[4135]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,dot(A,c))*c)-1/5040.
    coneq[4136]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c))*c)-1/10080.
    coneq[4137]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,dot(A,c))*c)-1/2016.
    coneq[4138]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,dot(A,c))*c)-1/6048.
    coneq[4139]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*c)-1/12096.
    coneq[4140]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,dot(A,c))*c)-1/4032.
    coneq[4141]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,dot(A,c))*c)-1/1512.
    coneq[4142]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,dot(A,c))*c)-1/3024.
    coneq[4143]=dot(b,dot(A,c**4*dot(A,c))*dot(A,dot(A,c))*c)-1/1008.
    coneq[4144]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,dot(A,c))*c)-1/4536.
    coneq[4145]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,dot(A,c))*c)-1/9072.
    coneq[4146]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,dot(A,c))*c)-1/18144.
    coneq[4147]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,dot(A,c))*c)-1/4032.
    coneq[4148]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,dot(A,c))*c)-1/12096.
    coneq[4149]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*c)-1/24192.
    coneq[4150]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,dot(A,c))*c)-1/8064.
    coneq[4151]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,dot(A,c))*c)-1/3024.
    coneq[4152]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c))*c)-1/6048.
    coneq[4153]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,dot(A,c))*c)-1/2016.
    coneq[4154]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,dot(A,c))*c)-1/4032.
    coneq[4155]=dot(b,dot(A,c**7)*dot(A,c)*c)-1/192.
    coneq[4156]=dot(b,dot(A,dot(A,c**6))*dot(A,c)*c)-1/1344.
    coneq[4157]=dot(b,dot(A,dot(A,dot(A,c**5)))*dot(A,c)*c)-1/8064.
    coneq[4158]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4))))*dot(A,c)*c)-1/40320.
    coneq[4159]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))*dot(A,c)*c)-1/161280.
    coneq[4160]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))*dot(A,c)*c)-1/483840.
    coneq[4161]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))*dot(A,c)*c)-1/967680.
    coneq[4162]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))*dot(A,c)*c)-1/322560.
    coneq[4163]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))*dot(A,c)*c)-1/120960.
    coneq[4164]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))*dot(A,c)*c)-1/241920.
    coneq[4165]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))*dot(A,c)*c)-1/80640.
    coneq[4166]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))*dot(A,c)*c)-1/161280.
    coneq[4167]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3))))*dot(A,c)*c)-1/32256.
    coneq[4168]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))*dot(A,c)*c)-1/96768.
    coneq[4169]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))*dot(A,c)*c)-1/193536.
    coneq[4170]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))*dot(A,c)*c)-1/64512.
    coneq[4171]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))*dot(A,c)*c)-1/24192.
    coneq[4172]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))*dot(A,c)*c)-1/48384.
    coneq[4173]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c))))*dot(A,c)*c)-1/16128.
    coneq[4174]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))*dot(A,c)*c)-1/48384.
    coneq[4175]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))*dot(A,c)*c)-1/96768.
    coneq[4176]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))*dot(A,c)*c)-1/32256.
    coneq[4177]=dot(b,dot(A,dot(A,c*dot(A,c**4)))*dot(A,c)*c)-1/6720.
    coneq[4178]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3))))*dot(A,c)*c)-1/26880.
    coneq[4179]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))*dot(A,c)*c)-1/80640.
    coneq[4180]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c)*c)-1/161280.
    coneq[4181]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))*dot(A,c)*c)-1/53760.
    coneq[4182]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))*dot(A,c)*c)-1/20160.
    coneq[4183]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))*dot(A,c)*c)-1/40320.
    coneq[4184]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))*dot(A,c)*c)-1/13440.
    coneq[4185]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))*dot(A,c)*c)-1/26880.
    coneq[4186]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)))*dot(A,c)*c)-1/5376.
    coneq[4187]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))*dot(A,c)*c)-1/16128.
    coneq[4188]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))*dot(A,c)*c)-1/32256.
    coneq[4189]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))*dot(A,c)*c)-1/10752.
    coneq[4190]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)))*dot(A,c)*c)-1/4032.
    coneq[4191]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))))*dot(A,c)*c)-1/8064.
    coneq[4192]=dot(b,dot(A,dot(A,c**4*dot(A,c)))*dot(A,c)*c)-1/2688.
    coneq[4193]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))*dot(A,c)*c)-1/12096.
    coneq[4194]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))*dot(A,c)*c)-1/24192.
    coneq[4195]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))*dot(A,c)*c)-1/48384.
    coneq[4196]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)))*dot(A,c)*c)-1/10752.
    coneq[4197]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))*dot(A,c)*c)-1/32256.
    coneq[4198]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))*dot(A,c)*c)-1/64512.
    coneq[4199]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))*dot(A,c)*c)-1/21504.
    coneq[4200]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))*dot(A,c)*c)-1/8064.
    coneq[4201]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))*dot(A,c)*c)-1/16128.
    coneq[4202]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))*dot(A,c)*c)-1/5376.
    coneq[4203]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))*dot(A,c)*c)-1/10752.
    coneq[4204]=dot(b,dot(A,c*dot(A,c**5))*dot(A,c)*c)-1/1152.
    coneq[4205]=dot(b,dot(A,c*dot(A,dot(A,c**4)))*dot(A,c)*c)-1/5760.
    coneq[4206]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3))))*dot(A,c)*c)-1/23040.
    coneq[4207]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c)*c)-1/69120.
    coneq[4208]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c)*c)-1/138240.
    coneq[4209]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c)*c)-1/46080.
    coneq[4210]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))*dot(A,c)*c)-1/17280.
    coneq[4211]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c)*c)-1/34560.
    coneq[4212]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))*dot(A,c)*c)-1/11520.
    coneq[4213]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c)*c)-1/23040.
    coneq[4214]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)))*dot(A,c)*c)-1/4608.
    coneq[4215]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))*dot(A,c)*c)-1/13824.
    coneq[4216]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c)*c)-1/27648.
    coneq[4217]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))*dot(A,c)*c)-1/9216.
    coneq[4218]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)))*dot(A,c)*c)-1/3456.
    coneq[4219]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))*dot(A,c)*c)-1/6912.
    coneq[4220]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)))*dot(A,c)*c)-1/2304.
    coneq[4221]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c)*c)-1/6912.
    coneq[4222]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c)*c)-1/13824.
    coneq[4223]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c)*c)-1/4608.
    coneq[4224]=dot(b,dot(A,c**2*dot(A,c**4))*dot(A,c)*c)-1/960.
    coneq[4225]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)))*dot(A,c)*c)-1/3840.
    coneq[4226]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))*dot(A,c)*c)-1/11520.
    coneq[4227]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c)*c)-1/23040.
    coneq[4228]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))*dot(A,c)*c)-1/7680.
    coneq[4229]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)))*dot(A,c)*c)-1/2880.
    coneq[4230]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))*dot(A,c)*c)-1/5760.
    coneq[4231]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)))*dot(A,c)*c)-1/1920.
    coneq[4232]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))*dot(A,c)*c)-1/3840.
    coneq[4233]=dot(b,dot(A,c**3*dot(A,c**3))*dot(A,c)*c)-1/768.
    coneq[4234]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)))*dot(A,c)*c)-1/2304.
    coneq[4235]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))))*dot(A,c)*c)-1/4608.
    coneq[4236]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)))*dot(A,c)*c)-1/1536.
    coneq[4237]=dot(b,dot(A,c**4*dot(A,c**2))*dot(A,c)*c)-1/576.
    coneq[4238]=dot(b,dot(A,c**4*dot(A,dot(A,c)))*dot(A,c)*c)-1/1152.
    coneq[4239]=dot(b,dot(A,c**5*dot(A,c))*dot(A,c)*c)-1/384.
    coneq[4240]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3))*dot(A,c)*c)-1/2304.
    coneq[4241]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))*dot(A,c)*c)-1/6912.
    coneq[4242]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))*dot(A,c)*c)-1/13824.
    coneq[4243]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))*dot(A,c)*c)-1/4608.
    coneq[4244]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3))*dot(A,c)*c)-1/4608.
    coneq[4245]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))*dot(A,c)*c)-1/13824.
    coneq[4246]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))*dot(A,c)*c)-1/27648.
    coneq[4247]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))*dot(A,c)*c)-1/9216.
    coneq[4248]=dot(b,dot(A,dot(A,c)*dot(A,c**4))*dot(A,c)*c)-1/1920.
    coneq[4249]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)))*dot(A,c)*c)-1/7680.
    coneq[4250]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))*dot(A,c)*c)-1/23040.
    coneq[4251]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c)*c)-1/46080.
    coneq[4252]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))*dot(A,c)*c)-1/15360.
    coneq[4253]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))*dot(A,c)*c)-1/5760.
    coneq[4254]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))*dot(A,c)*c)-1/11520.
    coneq[4255]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))*dot(A,c)*c)-1/3840.
    coneq[4256]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))*dot(A,c)*c)-1/7680.
    coneq[4257]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2))*dot(A,c)*c)-1/1728.
    coneq[4258]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c)*c)-1/3456.
    coneq[4259]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c)*c)-1/6912.
    coneq[4260]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3))*dot(A,c)*c)-1/1536.
    coneq[4261]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c)*c)-1/4608.
    coneq[4262]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c)*c)-1/9216.
    coneq[4263]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c)*c)-1/3072.
    coneq[4264]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2))*dot(A,c)*c)-1/1152.
    coneq[4265]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))*dot(A,c)*c)-1/2304.
    coneq[4266]=dot(b,dot(A,c**3*dot(A,c)*dot(A,c))*dot(A,c)*c)-1/768.
    coneq[4267]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))*dot(A,c)*c)-1/2304.
    coneq[4268]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))*dot(A,c)*c)-1/4608.
    coneq[4269]=dot(b,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c)*c)-1/1536.
    coneq[4270]=dot(b,dot(A,c**4)*dot(A,c**3)*c*c)-1/240.
    coneq[4271]=dot(b,dot(A,dot(A,c**3))*dot(A,c**3)*c*c)-1/960.
    coneq[4272]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**3)*c*c)-1/2880.
    coneq[4273]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**3)*c*c)-1/5760.
    coneq[4274]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**3)*c*c)-1/1920.
    coneq[4275]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**3)*c*c)-1/720.
    coneq[4276]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**3)*c*c)-1/1440.
    coneq[4277]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**3)*c*c)-1/480.
    coneq[4278]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**3)*c*c)-1/960.
    coneq[4279]=dot(b,dot(A,c**4)*dot(A,dot(A,c**2))*c*c)-1/720.
    coneq[4280]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c**2))*c*c)-1/2880.
    coneq[4281]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c**2))*c*c)-1/8640.
    coneq[4282]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**2))*c*c)-1/17280.
    coneq[4283]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c**2))*c*c)-1/5760.
    coneq[4284]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c**2))*c*c)-1/2160.
    coneq[4285]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c**2))*c*c)-1/4320.
    coneq[4286]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c**2))*c*c)-1/1440.
    coneq[4287]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c**2))*c*c)-1/2880.
    coneq[4288]=dot(b,dot(A,c**4)*dot(A,dot(A,dot(A,c)))*c*c)-1/1440.
    coneq[4289]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,c)))*c*c)-1/5760.
    coneq[4290]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c)))*c*c)-1/17280.
    coneq[4291]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c)))*c*c)-1/34560.
    coneq[4292]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c)))*c*c)-1/11520.
    coneq[4293]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,c)))*c*c)-1/4320.
    coneq[4294]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*c*c)-1/8640.
    coneq[4295]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,c)))*c*c)-1/2880.
    coneq[4296]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c)))*c*c)-1/5760.
    coneq[4297]=dot(b,dot(A,c**4)*dot(A,c*dot(A,c))*c*c)-1/480.
    coneq[4298]=dot(b,dot(A,dot(A,c**3))*dot(A,c*dot(A,c))*c*c)-1/1920.
    coneq[4299]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,c))*c*c)-1/5760.
    coneq[4300]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c))*c*c)-1/11520.
    coneq[4301]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,c))*c*c)-1/3840.
    coneq[4302]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c))*c*c)-1/1440.
    coneq[4303]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,c))*c*c)-1/2880.
    coneq[4304]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,c))*c*c)-1/960.
    coneq[4305]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,c))*c*c)-1/1920.
    coneq[4306]=dot(b,dot(A,c**5)*dot(A,c**2)*c*c)-1/216.
    coneq[4307]=dot(b,dot(A,dot(A,c**4))*dot(A,c**2)*c*c)-1/1080.
    coneq[4308]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c**2)*c*c)-1/4320.
    coneq[4309]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c**2)*c*c)-1/12960.
    coneq[4310]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**2)*c*c)-1/25920.
    coneq[4311]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c**2)*c*c)-1/8640.
    coneq[4312]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c**2)*c*c)-1/3240.
    coneq[4313]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c**2)*c*c)-1/6480.
    coneq[4314]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c**2)*c*c)-1/2160.
    coneq[4315]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c**2)*c*c)-1/4320.
    coneq[4316]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c**2)*c*c)-1/864.
    coneq[4317]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c**2)*c*c)-1/2592.
    coneq[4318]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c**2)*c*c)-1/5184.
    coneq[4319]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c**2)*c*c)-1/1728.
    coneq[4320]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c**2)*c*c)-1/648.
    coneq[4321]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c**2)*c*c)-1/1296.
    coneq[4322]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c**2)*c*c)-1/432.
    coneq[4323]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c**2)*c*c)-1/1296.
    coneq[4324]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c**2)*c*c)-1/2592.
    coneq[4325]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c**2)*c*c)-1/864.
    coneq[4326]=dot(b,dot(A,c**5)*dot(A,dot(A,c))*c*c)-1/432.
    coneq[4327]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,c))*c*c)-1/2160.
    coneq[4328]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,c))*c*c)-1/8640.
    coneq[4329]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c))*c*c)-1/25920.
    coneq[4330]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c))*c*c)-1/51840.
    coneq[4331]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c))*c*c)-1/17280.
    coneq[4332]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,c))*c*c)-1/6480.
    coneq[4333]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c))*c*c)-1/12960.
    coneq[4334]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,c))*c*c)-1/4320.
    coneq[4335]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c))*c*c)-1/8640.
    coneq[4336]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,c))*c*c)-1/1728.
    coneq[4337]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,c))*c*c)-1/5184.
    coneq[4338]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*c*c)-1/10368.
    coneq[4339]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,c))*c*c)-1/3456.
    coneq[4340]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,c))*c*c)-1/1296.
    coneq[4341]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,c))*c*c)-1/2592.
    coneq[4342]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,c))*c*c)-1/864.
    coneq[4343]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,c))*c*c)-1/2592.
    coneq[4344]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c))*c*c)-1/5184.
    coneq[4345]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,c))*c*c)-1/1728.
    coneq[4346]=dot(b,dot(A,c**6)*dot(A,c)*c*c)-1/168.
    coneq[4347]=dot(b,dot(A,dot(A,c**5))*dot(A,c)*c*c)-1/1008.
    coneq[4348]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,c)*c*c)-1/5040.
    coneq[4349]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,c)*c*c)-1/20160.
    coneq[4350]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c)*c*c)-1/60480.
    coneq[4351]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c)*c*c)-1/120960.
    coneq[4352]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c)*c*c)-1/40320.
    coneq[4353]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,c)*c*c)-1/15120.
    coneq[4354]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c)*c*c)-1/30240.
    coneq[4355]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,c)*c*c)-1/10080.
    coneq[4356]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c)*c*c)-1/20160.
    coneq[4357]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,c)*c*c)-1/4032.
    coneq[4358]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,c)*c*c)-1/12096.
    coneq[4359]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c)*c*c)-1/24192.
    coneq[4360]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,c)*c*c)-1/8064.
    coneq[4361]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,c)*c*c)-1/3024.
    coneq[4362]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,c)*c*c)-1/6048.
    coneq[4363]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,c)*c*c)-1/2016.
    coneq[4364]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c)*c*c)-1/6048.
    coneq[4365]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c)*c*c)-1/12096.
    coneq[4366]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c)*c*c)-1/4032.
    coneq[4367]=dot(b,dot(A,c*dot(A,c**4))*dot(A,c)*c*c)-1/840.
    coneq[4368]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,c)*c*c)-1/3360.
    coneq[4369]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,c)*c*c)-1/10080.
    coneq[4370]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c)*c*c)-1/20160.
    coneq[4371]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,c)*c*c)-1/6720.
    coneq[4372]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,c)*c*c)-1/2520.
    coneq[4373]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,c)*c*c)-1/5040.
    coneq[4374]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,c)*c*c)-1/1680.
    coneq[4375]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,c)*c*c)-1/3360.
    coneq[4376]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,c)*c*c)-1/672.
    coneq[4377]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,c)*c*c)-1/2016.
    coneq[4378]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,c)*c*c)-1/4032.
    coneq[4379]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,c)*c*c)-1/1344.
    coneq[4380]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,c)*c*c)-1/504.
    coneq[4381]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,c)*c*c)-1/1008.
    coneq[4382]=dot(b,dot(A,c**4*dot(A,c))*dot(A,c)*c*c)-1/336.
    coneq[4383]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,c)*c*c)-1/1512.
    coneq[4384]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c)*c*c)-1/3024.
    coneq[4385]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c)*c*c)-1/6048.
    coneq[4386]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,c)*c*c)-1/1344.
    coneq[4387]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c)*c*c)-1/4032.
    coneq[4388]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c)*c*c)-1/8064.
    coneq[4389]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c)*c*c)-1/2688.
    coneq[4390]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,c)*c*c)-1/1008.
    coneq[4391]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,c)*c*c)-1/2016.
    coneq[4392]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,c)*c*c)-1/672.
    coneq[4393]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c)*c*c)-1/1344.
    coneq[4394]=dot(b,dot(A,c**3)*dot(A,c**3)*c**3)-1/192.
    coneq[4395]=dot(b,dot(A,dot(A,c**2))*dot(A,c**3)*c**3)-1/576.
    coneq[4396]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**3)*c**3)-1/1152.
    coneq[4397]=dot(b,dot(A,c*dot(A,c))*dot(A,c**3)*c**3)-1/384.
    coneq[4398]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))*c**3)-1/1728.
    coneq[4399]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2))*c**3)-1/3456.
    coneq[4400]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c**2))*c**3)-1/1152.
    coneq[4401]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*c**3)-1/6912.
    coneq[4402]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)))*c**3)-1/2304.
    coneq[4403]=dot(b,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))*c**3)-1/768.
    coneq[4404]=dot(b,dot(A,c**4)*dot(A,c**2)*c**3)-1/180.
    coneq[4405]=dot(b,dot(A,dot(A,c**3))*dot(A,c**2)*c**3)-1/720.
    coneq[4406]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2)*c**3)-1/2160.
    coneq[4407]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2)*c**3)-1/4320.
    coneq[4408]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2)*c**3)-1/1440.
    coneq[4409]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**2)*c**3)-1/540.
    coneq[4410]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2)*c**3)-1/1080.
    coneq[4411]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**2)*c**3)-1/360.
    coneq[4412]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2)*c**3)-1/720.
    coneq[4413]=dot(b,dot(A,c**4)*dot(A,dot(A,c))*c**3)-1/360.
    coneq[4414]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c))*c**3)-1/1440.
    coneq[4415]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c))*c**3)-1/4320.
    coneq[4416]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*c**3)-1/8640.
    coneq[4417]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c))*c**3)-1/2880.
    coneq[4418]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c))*c**3)-1/1080.
    coneq[4419]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c))*c**3)-1/2160.
    coneq[4420]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c))*c**3)-1/720.
    coneq[4421]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c))*c**3)-1/1440.
    coneq[4422]=dot(b,dot(A,c**5)*dot(A,c)*c**3)-1/144.
    coneq[4423]=dot(b,dot(A,dot(A,c**4))*dot(A,c)*c**3)-1/720.
    coneq[4424]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c)*c**3)-1/2880.
    coneq[4425]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c)*c**3)-1/8640.
    coneq[4426]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c)*c**3)-1/17280.
    coneq[4427]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c)*c**3)-1/5760.
    coneq[4428]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c)*c**3)-1/2160.
    coneq[4429]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c)*c**3)-1/4320.
    coneq[4430]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c)*c**3)-1/1440.
    coneq[4431]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c)*c**3)-1/2880.
    coneq[4432]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c)*c**3)-1/576.
    coneq[4433]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c)*c**3)-1/1728.
    coneq[4434]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c)*c**3)-1/3456.
    coneq[4435]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c)*c**3)-1/1152.
    coneq[4436]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c)*c**3)-1/432.
    coneq[4437]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c)*c**3)-1/864.
    coneq[4438]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c)*c**3)-1/288.
    coneq[4439]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c)*c**3)-1/864.
    coneq[4440]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c)*c**3)-1/1728.
    coneq[4441]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c)*c**3)-1/576.
    coneq[4442]=dot(b,dot(A,c**3)*dot(A,c**2)*c**4)-1/144.
    coneq[4443]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2)*c**4)-1/432.
    coneq[4444]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2)*c**4)-1/864.
    coneq[4445]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2)*c**4)-1/288.
    coneq[4446]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*c**4)-1/288.
    coneq[4447]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*c**4)-1/864.
    coneq[4448]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*c**4)-1/1728.
    coneq[4449]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*c**4)-1/576.
    coneq[4450]=dot(b,dot(A,c**4)*dot(A,c)*c**4)-1/120.
    coneq[4451]=dot(b,dot(A,dot(A,c**3))*dot(A,c)*c**4)-1/480.
    coneq[4452]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c)*c**4)-1/1440.
    coneq[4453]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c)*c**4)-1/2880.
    coneq[4454]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c)*c**4)-1/960.
    coneq[4455]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c)*c**4)-1/360.
    coneq[4456]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c)*c**4)-1/720.
    coneq[4457]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c)*c**4)-1/240.
    coneq[4458]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c)*c**4)-1/480.
    coneq[4459]=dot(b,dot(A,c**2)*dot(A,c**2)*c**5)-1/108.
    coneq[4460]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*c**5)-1/216.
    coneq[4461]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*c**5)-1/432.
    coneq[4462]=dot(b,dot(A,c**3)*dot(A,c)*c**5)-1/96.
    coneq[4463]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*c**5)-1/288.
    coneq[4464]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*c**5)-1/576.
    coneq[4465]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*c**5)-1/192.
    coneq[4466]=dot(b,dot(A,c**2)*dot(A,c)*c**6)-1/72.
    coneq[4467]=dot(b,dot(A,dot(A,c))*dot(A,c)*c**6)-1/144.
    coneq[4468]=dot(b,dot(A,c)*dot(A,c)*c**7)-1/48.
    coneq[4469]=dot(b,dot(A,c**6)*dot(A,c)*dot(A,c))-1/336.
    coneq[4470]=dot(b,dot(A,dot(A,c**5))*dot(A,c)*dot(A,c))-1/2016.
    coneq[4471]=dot(b,dot(A,dot(A,dot(A,c**4)))*dot(A,c)*dot(A,c))-1/10080.
    coneq[4472]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))))*dot(A,c)*dot(A,c))-1/40320.
    coneq[4473]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))*dot(A,c)*dot(A,c))-1/120960.
    coneq[4474]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))*dot(A,c)*dot(A,c))-1/241920.
    coneq[4475]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))*dot(A,c)*dot(A,c))-1/80640.
    coneq[4476]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))))*dot(A,c)*dot(A,c))-1/30240.
    coneq[4477]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))*dot(A,c)*dot(A,c))-1/60480.
    coneq[4478]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))))*dot(A,c)*dot(A,c))-1/20160.
    coneq[4479]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))*dot(A,c)*dot(A,c))-1/40320.
    coneq[4480]=dot(b,dot(A,dot(A,c*dot(A,c**3)))*dot(A,c)*dot(A,c))-1/8064.
    coneq[4481]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))))*dot(A,c)*dot(A,c))-1/24192.
    coneq[4482]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))*dot(A,c)*dot(A,c))-1/48384.
    coneq[4483]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))))*dot(A,c)*dot(A,c))-1/16128.
    coneq[4484]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)))*dot(A,c)*dot(A,c))-1/6048.
    coneq[4485]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))))*dot(A,c)*dot(A,c))-1/12096.
    coneq[4486]=dot(b,dot(A,dot(A,c**3*dot(A,c)))*dot(A,c)*dot(A,c))-1/4032.
    coneq[4487]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)))*dot(A,c)*dot(A,c))-1/12096.
    coneq[4488]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))*dot(A,c)*dot(A,c))-1/24192.
    coneq[4489]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)))*dot(A,c)*dot(A,c))-1/8064.
    coneq[4490]=dot(b,dot(A,c*dot(A,c**4))*dot(A,c)*dot(A,c))-1/1680.
    coneq[4491]=dot(b,dot(A,c*dot(A,dot(A,c**3)))*dot(A,c)*dot(A,c))-1/6720.
    coneq[4492]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))))*dot(A,c)*dot(A,c))-1/20160.
    coneq[4493]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c)*dot(A,c))-1/40320.
    coneq[4494]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))))*dot(A,c)*dot(A,c))-1/13440.
    coneq[4495]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)))*dot(A,c)*dot(A,c))-1/5040.
    coneq[4496]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))))*dot(A,c)*dot(A,c))-1/10080.
    coneq[4497]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)))*dot(A,c)*dot(A,c))-1/3360.
    coneq[4498]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)))*dot(A,c)*dot(A,c))-1/6720.
    coneq[4499]=dot(b,dot(A,c**2*dot(A,c**3))*dot(A,c)*dot(A,c))-1/1344.
    coneq[4500]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)))*dot(A,c)*dot(A,c))-1/4032.
    coneq[4501]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))))*dot(A,c)*dot(A,c))-1/8064.
    coneq[4502]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)))*dot(A,c)*dot(A,c))-1/2688.
    coneq[4503]=dot(b,dot(A,c**3*dot(A,c**2))*dot(A,c)*dot(A,c))-1/1008.
    coneq[4504]=dot(b,dot(A,c**3*dot(A,dot(A,c)))*dot(A,c)*dot(A,c))-1/2016.
    coneq[4505]=dot(b,dot(A,c**4*dot(A,c))*dot(A,c)*dot(A,c))-1/672.
    coneq[4506]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2))*dot(A,c)*dot(A,c))-1/3024.
    coneq[4507]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)))*dot(A,c)*dot(A,c))-1/6048.
    coneq[4508]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))*dot(A,c)*dot(A,c))-1/12096.
    coneq[4509]=dot(b,dot(A,dot(A,c)*dot(A,c**3))*dot(A,c)*dot(A,c))-1/2688.
    coneq[4510]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)))*dot(A,c)*dot(A,c))-1/8064.
    coneq[4511]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))*dot(A,c)*dot(A,c))-1/16128.
    coneq[4512]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)))*dot(A,c)*dot(A,c))-1/5376.
    coneq[4513]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2))*dot(A,c)*dot(A,c))-1/2016.
    coneq[4514]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)))*dot(A,c)*dot(A,c))-1/4032.
    coneq[4515]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c))*dot(A,c)*dot(A,c))-1/1344.
    coneq[4516]=dot(b,dot(A,dot(A,c)*dot(A,c)*dot(A,c))*dot(A,c)*dot(A,c))-1/2688.
    coneq[4517]=dot(b,dot(A,c**5)*dot(A,c**2)*dot(A,c))-1/432.
    coneq[4518]=dot(b,dot(A,dot(A,c**4))*dot(A,c**2)*dot(A,c))-1/2160.
    coneq[4519]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c**2)*dot(A,c))-1/8640.
    coneq[4520]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c**2)*dot(A,c))-1/25920.
    coneq[4521]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c**2)*dot(A,c))-1/51840.
    coneq[4522]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c**2)*dot(A,c))-1/17280.
    coneq[4523]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c**2)*dot(A,c))-1/6480.
    coneq[4524]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c**2)*dot(A,c))-1/12960.
    coneq[4525]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c**2)*dot(A,c))-1/4320.
    coneq[4526]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c**2)*dot(A,c))-1/8640.
    coneq[4527]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c**2)*dot(A,c))-1/1728.
    coneq[4528]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c**2)*dot(A,c))-1/5184.
    coneq[4529]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c**2)*dot(A,c))-1/10368.
    coneq[4530]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c**2)*dot(A,c))-1/3456.
    coneq[4531]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c**2)*dot(A,c))-1/1296.
    coneq[4532]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c))-1/2592.
    coneq[4533]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c**2)*dot(A,c))-1/864.
    coneq[4534]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c**2)*dot(A,c))-1/2592.
    coneq[4535]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c))-1/5184.
    coneq[4536]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c**2)*dot(A,c))-1/1728.
    coneq[4537]=dot(b,dot(A,c**5)*dot(A,dot(A,c))*dot(A,c))-1/864.
    coneq[4538]=dot(b,dot(A,dot(A,c**4))*dot(A,dot(A,c))*dot(A,c))-1/4320.
    coneq[4539]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,dot(A,c))*dot(A,c))-1/17280.
    coneq[4540]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,dot(A,c))*dot(A,c))-1/51840.
    coneq[4541]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,dot(A,c))*dot(A,c))-1/103680.
    coneq[4542]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,dot(A,c))*dot(A,c))-1/34560.
    coneq[4543]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,dot(A,c))*dot(A,c))-1/12960.
    coneq[4544]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,dot(A,c))*dot(A,c))-1/25920.
    coneq[4545]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,dot(A,c))*dot(A,c))-1/8640.
    coneq[4546]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,dot(A,c))*dot(A,c))-1/17280.
    coneq[4547]=dot(b,dot(A,c*dot(A,c**3))*dot(A,dot(A,c))*dot(A,c))-1/3456.
    coneq[4548]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,dot(A,c))*dot(A,c))-1/10368.
    coneq[4549]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*dot(A,c))-1/20736.
    coneq[4550]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,dot(A,c))*dot(A,c))-1/6912.
    coneq[4551]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,dot(A,c))*dot(A,c))-1/2592.
    coneq[4552]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c))-1/5184.
    coneq[4553]=dot(b,dot(A,c**3*dot(A,c))*dot(A,dot(A,c))*dot(A,c))-1/1728.
    coneq[4554]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,dot(A,c))*dot(A,c))-1/5184.
    coneq[4555]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c))-1/10368.
    coneq[4556]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,dot(A,c))*dot(A,c))-1/3456.
    coneq[4557]=dot(b,dot(A,c**4)*dot(A,c**2)*dot(A,c**2))-1/540.
    coneq[4558]=dot(b,dot(A,dot(A,c**3))*dot(A,c**2)*dot(A,c**2))-1/2160.
    coneq[4559]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2)*dot(A,c**2))-1/6480.
    coneq[4560]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2)*dot(A,c**2))-1/12960.
    coneq[4561]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2)*dot(A,c**2))-1/4320.
    coneq[4562]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**2)*dot(A,c**2))-1/1620.
    coneq[4563]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c**2))-1/3240.
    coneq[4564]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**2)*dot(A,c**2))-1/1080.
    coneq[4565]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2)*dot(A,c**2))-1/2160.
    coneq[4566]=dot(b,dot(A,c**4)*dot(A,dot(A,c))*dot(A,c**2))-1/1080.
    coneq[4567]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c))*dot(A,c**2))-1/4320.
    coneq[4568]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c))*dot(A,c**2))-1/12960.
    coneq[4569]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*dot(A,c**2))-1/25920.
    coneq[4570]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c))*dot(A,c**2))-1/8640.
    coneq[4571]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c))*dot(A,c**2))-1/3240.
    coneq[4572]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c**2))-1/6480.
    coneq[4573]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c))*dot(A,c**2))-1/2160.
    coneq[4574]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c))*dot(A,c**2))-1/4320.
    coneq[4575]=dot(b,dot(A,c**4)*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/2160.
    coneq[4576]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/8640.
    coneq[4577]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/25920.
    coneq[4578]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/51840.
    coneq[4579]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/17280.
    coneq[4580]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/6480.
    coneq[4581]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/12960.
    coneq[4582]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/4320.
    coneq[4583]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c)))-1/8640.
    coneq[4584]=dot(b,dot(A,c**4)*dot(A,c**3)*dot(A,c))-1/480.
    coneq[4585]=dot(b,dot(A,dot(A,c**3))*dot(A,c**3)*dot(A,c))-1/1920.
    coneq[4586]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**3)*dot(A,c))-1/5760.
    coneq[4587]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**3)*dot(A,c))-1/11520.
    coneq[4588]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**3)*dot(A,c))-1/3840.
    coneq[4589]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**3)*dot(A,c))-1/1440.
    coneq[4590]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**3)*dot(A,c))-1/2880.
    coneq[4591]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**3)*dot(A,c))-1/960.
    coneq[4592]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**3)*dot(A,c))-1/1920.
    coneq[4593]=dot(b,dot(A,c**4)*dot(A,dot(A,c**2))*dot(A,c))-1/1440.
    coneq[4594]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c**2))*dot(A,c))-1/5760.
    coneq[4595]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c**2))*dot(A,c))-1/17280.
    coneq[4596]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**2))*dot(A,c))-1/34560.
    coneq[4597]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c**2))*dot(A,c))-1/11520.
    coneq[4598]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c**2))*dot(A,c))-1/4320.
    coneq[4599]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c**2))*dot(A,c))-1/8640.
    coneq[4600]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c**2))*dot(A,c))-1/2880.
    coneq[4601]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c**2))*dot(A,c))-1/5760.
    coneq[4602]=dot(b,dot(A,c**4)*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/2880.
    coneq[4603]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/11520.
    coneq[4604]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/34560.
    coneq[4605]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/69120.
    coneq[4606]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/23040.
    coneq[4607]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/8640.
    coneq[4608]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/17280.
    coneq[4609]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/5760.
    coneq[4610]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c)))*dot(A,c))-1/11520.
    coneq[4611]=dot(b,dot(A,c**4)*dot(A,c*dot(A,c))*dot(A,c))-1/960.
    coneq[4612]=dot(b,dot(A,dot(A,c**3))*dot(A,c*dot(A,c))*dot(A,c))-1/3840.
    coneq[4613]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,c))*dot(A,c))-1/11520.
    coneq[4614]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c))*dot(A,c))-1/23040.
    coneq[4615]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,c))*dot(A,c))-1/7680.
    coneq[4616]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c))*dot(A,c))-1/2880.
    coneq[4617]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,c))*dot(A,c))-1/5760.
    coneq[4618]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,c))*dot(A,c))-1/1920.
    coneq[4619]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,c))*dot(A,c))-1/3840.
    coneq[4620]=dot(b,dot(A,c**3)*dot(A,c**3)*dot(A,c**2))-1/576.
    coneq[4621]=dot(b,dot(A,dot(A,c**2))*dot(A,c**3)*dot(A,c**2))-1/1728.
    coneq[4622]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**3)*dot(A,c**2))-1/3456.
    coneq[4623]=dot(b,dot(A,c*dot(A,c))*dot(A,c**3)*dot(A,c**2))-1/1152.
    coneq[4624]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))*dot(A,c**2))-1/5184.
    coneq[4625]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2))*dot(A,c**2))-1/10368.
    coneq[4626]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c**2))*dot(A,c**2))-1/3456.
    coneq[4627]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*dot(A,c**2))-1/20736.
    coneq[4628]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)))*dot(A,c**2))-1/6912.
    coneq[4629]=dot(b,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))*dot(A,c**2))-1/2304.
    coneq[4630]=dot(b,dot(A,c**3)*dot(A,c**3)*dot(A,dot(A,c)))-1/1152.
    coneq[4631]=dot(b,dot(A,dot(A,c**2))*dot(A,c**3)*dot(A,dot(A,c)))-1/3456.
    coneq[4632]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**3)*dot(A,dot(A,c)))-1/6912.
    coneq[4633]=dot(b,dot(A,c*dot(A,c))*dot(A,c**3)*dot(A,dot(A,c)))-1/2304.
    coneq[4634]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))*dot(A,dot(A,c)))-1/10368.
    coneq[4635]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2))*dot(A,dot(A,c)))-1/20736.
    coneq[4636]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c**2))*dot(A,dot(A,c)))-1/6912.
    coneq[4637]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/41472.
    coneq[4638]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)))-1/13824.
    coneq[4639]=dot(b,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))*dot(A,dot(A,c)))-1/4608.
    coneq[4640]=dot(b,dot(A,c**5)*dot(A,c)*dot(A,c)*c)-1/288.
    coneq[4641]=dot(b,dot(A,dot(A,c**4))*dot(A,c)*dot(A,c)*c)-1/1440.
    coneq[4642]=dot(b,dot(A,dot(A,dot(A,c**3)))*dot(A,c)*dot(A,c)*c)-1/5760.
    coneq[4643]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))))*dot(A,c)*dot(A,c)*c)-1/17280.
    coneq[4644]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))*dot(A,c)*dot(A,c)*c)-1/34560.
    coneq[4645]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))))*dot(A,c)*dot(A,c)*c)-1/11520.
    coneq[4646]=dot(b,dot(A,dot(A,c*dot(A,c**2)))*dot(A,c)*dot(A,c)*c)-1/4320.
    coneq[4647]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))))*dot(A,c)*dot(A,c)*c)-1/8640.
    coneq[4648]=dot(b,dot(A,dot(A,c**2*dot(A,c)))*dot(A,c)*dot(A,c)*c)-1/2880.
    coneq[4649]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)))*dot(A,c)*dot(A,c)*c)-1/5760.
    coneq[4650]=dot(b,dot(A,c*dot(A,c**3))*dot(A,c)*dot(A,c)*c)-1/1152.
    coneq[4651]=dot(b,dot(A,c*dot(A,dot(A,c**2)))*dot(A,c)*dot(A,c)*c)-1/3456.
    coneq[4652]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))))*dot(A,c)*dot(A,c)*c)-1/6912.
    coneq[4653]=dot(b,dot(A,c*dot(A,c*dot(A,c)))*dot(A,c)*dot(A,c)*c)-1/2304.
    coneq[4654]=dot(b,dot(A,c**2*dot(A,c**2))*dot(A,c)*dot(A,c)*c)-1/864.
    coneq[4655]=dot(b,dot(A,c**2*dot(A,dot(A,c)))*dot(A,c)*dot(A,c)*c)-1/1728.
    coneq[4656]=dot(b,dot(A,c**3*dot(A,c))*dot(A,c)*dot(A,c)*c)-1/576.
    coneq[4657]=dot(b,dot(A,dot(A,c)*dot(A,c**2))*dot(A,c)*dot(A,c)*c)-1/1728.
    coneq[4658]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)))*dot(A,c)*dot(A,c)*c)-1/3456.
    coneq[4659]=dot(b,dot(A,c*dot(A,c)*dot(A,c))*dot(A,c)*dot(A,c)*c)-1/1152.
    coneq[4660]=dot(b,dot(A,c**4)*dot(A,c**2)*dot(A,c)*c)-1/360.
    coneq[4661]=dot(b,dot(A,dot(A,c**3))*dot(A,c**2)*dot(A,c)*c)-1/1440.
    coneq[4662]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2)*dot(A,c)*c)-1/4320.
    coneq[4663]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2)*dot(A,c)*c)-1/8640.
    coneq[4664]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2)*dot(A,c)*c)-1/2880.
    coneq[4665]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c**2)*dot(A,c)*c)-1/1080.
    coneq[4666]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c)*c)-1/2160.
    coneq[4667]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c**2)*dot(A,c)*c)-1/720.
    coneq[4668]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2)*dot(A,c)*c)-1/1440.
    coneq[4669]=dot(b,dot(A,c**4)*dot(A,dot(A,c))*dot(A,c)*c)-1/720.
    coneq[4670]=dot(b,dot(A,dot(A,c**3))*dot(A,dot(A,c))*dot(A,c)*c)-1/2880.
    coneq[4671]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c))*dot(A,c)*c)-1/8640.
    coneq[4672]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c))*dot(A,c)*c)-1/17280.
    coneq[4673]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c))*dot(A,c)*c)-1/5760.
    coneq[4674]=dot(b,dot(A,c*dot(A,c**2))*dot(A,dot(A,c))*dot(A,c)*c)-1/2160.
    coneq[4675]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c)*c)-1/4320.
    coneq[4676]=dot(b,dot(A,c**2*dot(A,c))*dot(A,dot(A,c))*dot(A,c)*c)-1/1440.
    coneq[4677]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c))*dot(A,c)*c)-1/2880.
    coneq[4678]=dot(b,dot(A,c**3)*dot(A,c**2)*dot(A,c**2)*c)-1/432.
    coneq[4679]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2)*dot(A,c**2)*c)-1/1296.
    coneq[4680]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c**2)*c)-1/2592.
    coneq[4681]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2)*dot(A,c**2)*c)-1/864.
    coneq[4682]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*dot(A,c**2)*c)-1/864.
    coneq[4683]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*dot(A,c**2)*c)-1/2592.
    coneq[4684]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c**2)*c)-1/5184.
    coneq[4685]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*dot(A,c**2)*c)-1/1728.
    coneq[4686]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*dot(A,dot(A,c))*c)-1/1728.
    coneq[4687]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*dot(A,dot(A,c))*c)-1/5184.
    coneq[4688]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,dot(A,c))*c)-1/10368.
    coneq[4689]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c))*c)-1/3456.
    coneq[4690]=dot(b,dot(A,c**3)*dot(A,c**3)*dot(A,c)*c)-1/384.
    coneq[4691]=dot(b,dot(A,dot(A,c**2))*dot(A,c**3)*dot(A,c)*c)-1/1152.
    coneq[4692]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**3)*dot(A,c)*c)-1/2304.
    coneq[4693]=dot(b,dot(A,c*dot(A,c))*dot(A,c**3)*dot(A,c)*c)-1/768.
    coneq[4694]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))*dot(A,c)*c)-1/3456.
    coneq[4695]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2))*dot(A,c)*c)-1/6912.
    coneq[4696]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c**2))*dot(A,c)*c)-1/2304.
    coneq[4697]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))*dot(A,c)*c)-1/13824.
    coneq[4698]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)))*dot(A,c)*c)-1/4608.
    coneq[4699]=dot(b,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))*dot(A,c)*c)-1/1536.
    coneq[4700]=dot(b,dot(A,c**4)*dot(A,c)*dot(A,c)*c*c)-1/240.
    coneq[4701]=dot(b,dot(A,dot(A,c**3))*dot(A,c)*dot(A,c)*c*c)-1/960.
    coneq[4702]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c)*dot(A,c)*c*c)-1/2880.
    coneq[4703]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c)*dot(A,c)*c*c)-1/5760.
    coneq[4704]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c)*dot(A,c)*c*c)-1/1920.
    coneq[4705]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c)*dot(A,c)*c*c)-1/720.
    coneq[4706]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c)*dot(A,c)*c*c)-1/1440.
    coneq[4707]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c)*dot(A,c)*c*c)-1/480.
    coneq[4708]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c)*dot(A,c)*c*c)-1/960.
    coneq[4709]=dot(b,dot(A,c**3)*dot(A,c**2)*dot(A,c)*c*c)-1/288.
    coneq[4710]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2)*dot(A,c)*c*c)-1/864.
    coneq[4711]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c)*c*c)-1/1728.
    coneq[4712]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2)*dot(A,c)*c*c)-1/576.
    coneq[4713]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*dot(A,c)*c*c)-1/576.
    coneq[4714]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*dot(A,c)*c*c)-1/1728.
    coneq[4715]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c)*c*c)-1/3456.
    coneq[4716]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*dot(A,c)*c*c)-1/1152.
    coneq[4717]=dot(b,dot(A,c**2)*dot(A,c**2)*dot(A,c**2)*c*c)-1/324.
    coneq[4718]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*dot(A,c**2)*c*c)-1/648.
    coneq[4719]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c**2)*c*c)-1/1296.
    coneq[4720]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c))*c*c)-1/2592.
    coneq[4721]=dot(b,dot(A,c**3)*dot(A,c)*dot(A,c)*c**3)-1/192.
    coneq[4722]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*dot(A,c)*c**3)-1/576.
    coneq[4723]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*dot(A,c)*c**3)-1/1152.
    coneq[4724]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*dot(A,c)*c**3)-1/384.
    coneq[4725]=dot(b,dot(A,c**2)*dot(A,c**2)*dot(A,c)*c**3)-1/216.
    coneq[4726]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*dot(A,c)*c**3)-1/432.
    coneq[4727]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c)*c**3)-1/864.
    coneq[4728]=dot(b,dot(A,c**2)*dot(A,c)*dot(A,c)*c**4)-1/144.
    coneq[4729]=dot(b,dot(A,dot(A,c))*dot(A,c)*dot(A,c)*c**4)-1/288.
    coneq[4730]=dot(b,dot(A,c)*dot(A,c)*dot(A,c)*c**5)-1/96.
    coneq[4731]=dot(b,dot(A,c**4)*dot(A,c)*dot(A,c)*dot(A,c))-1/480.
    coneq[4732]=dot(b,dot(A,dot(A,c**3))*dot(A,c)*dot(A,c)*dot(A,c))-1/1920.
    coneq[4733]=dot(b,dot(A,dot(A,dot(A,c**2)))*dot(A,c)*dot(A,c)*dot(A,c))-1/5760.
    coneq[4734]=dot(b,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c)*dot(A,c)*dot(A,c))-1/11520.
    coneq[4735]=dot(b,dot(A,dot(A,c*dot(A,c)))*dot(A,c)*dot(A,c)*dot(A,c))-1/3840.
    coneq[4736]=dot(b,dot(A,c*dot(A,c**2))*dot(A,c)*dot(A,c)*dot(A,c))-1/1440.
    coneq[4737]=dot(b,dot(A,c*dot(A,dot(A,c)))*dot(A,c)*dot(A,c)*dot(A,c))-1/2880.
    coneq[4738]=dot(b,dot(A,c**2*dot(A,c))*dot(A,c)*dot(A,c)*dot(A,c))-1/960.
    coneq[4739]=dot(b,dot(A,dot(A,c)*dot(A,c))*dot(A,c)*dot(A,c)*dot(A,c))-1/1920.
    coneq[4740]=dot(b,dot(A,c**3)*dot(A,c**2)*dot(A,c)*dot(A,c))-1/576.
    coneq[4741]=dot(b,dot(A,dot(A,c**2))*dot(A,c**2)*dot(A,c)*dot(A,c))-1/1728.
    coneq[4742]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c**2)*dot(A,c)*dot(A,c))-1/3456.
    coneq[4743]=dot(b,dot(A,c*dot(A,c))*dot(A,c**2)*dot(A,c)*dot(A,c))-1/1152.
    coneq[4744]=dot(b,dot(A,c**3)*dot(A,dot(A,c))*dot(A,c)*dot(A,c))-1/1152.
    coneq[4745]=dot(b,dot(A,dot(A,c**2))*dot(A,dot(A,c))*dot(A,c)*dot(A,c))-1/3456.
    coneq[4746]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c))*dot(A,c)*dot(A,c))-1/6912.
    coneq[4747]=dot(b,dot(A,c*dot(A,c))*dot(A,dot(A,c))*dot(A,c)*dot(A,c))-1/2304.
    coneq[4748]=dot(b,dot(A,c**2)*dot(A,c**2)*dot(A,c**2)*dot(A,c))-1/648.
    coneq[4749]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*dot(A,c**2)*dot(A,c))-1/1296.
    coneq[4750]=dot(b,dot(A,c**2)*dot(A,dot(A,c))*dot(A,c**2)*dot(A,c))-1/1296.
    coneq[4751]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c**2)*dot(A,c))-1/2592.
    coneq[4752]=dot(b,dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c))-1/2592.
    coneq[4753]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c))-1/5184.
    coneq[4754]=dot(b,dot(A,c**3)*dot(A,c)*dot(A,c)*dot(A,c)*c)-1/384.
    coneq[4755]=dot(b,dot(A,dot(A,c**2))*dot(A,c)*dot(A,c)*dot(A,c)*c)-1/1152.
    coneq[4756]=dot(b,dot(A,dot(A,dot(A,c)))*dot(A,c)*dot(A,c)*dot(A,c)*c)-1/2304.
    coneq[4757]=dot(b,dot(A,c*dot(A,c))*dot(A,c)*dot(A,c)*dot(A,c)*c)-1/768.
    coneq[4758]=dot(b,dot(A,c**2)*dot(A,c**2)*dot(A,c)*dot(A,c)*c)-1/432.
    coneq[4759]=dot(b,dot(A,dot(A,c))*dot(A,c**2)*dot(A,c)*dot(A,c)*c)-1/864.
    coneq[4760]=dot(b,dot(A,c**2)*dot(A,dot(A,c))*dot(A,c)*dot(A,c)*c)-1/864.
    coneq[4761]=dot(b,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c)*dot(A,c)*c)-1/1728.
    coneq[4762]=dot(b,dot(A,c**2)*dot(A,c)*dot(A,c)*dot(A,c)*c*c)-1/288.
    coneq[4763]=dot(b,dot(A,dot(A,c))*dot(A,c)*dot(A,c)*dot(A,c)*c*c)-1/576.
    coneq[4764]=dot(b,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)*c**3)-1/192.
    coneq[4765]=dot(b,c**11)-1/12.
    if any(abs(coneq)>tol):
        return 11
    # order 13 conditions:
    coneq[0]=dot(b,dot(A,c**11))-1/156.
    coneq[1]=dot(b,dot(A,dot(A,c**10)))-1/1716.
    coneq[2]=dot(b,dot(A,dot(A,dot(A,c**9))))-1/17160.
    coneq[3]=dot(b,dot(A,dot(A,dot(A,dot(A,c**8)))))-1/154440.
    coneq[4]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**7))))))-1/1235520.
    coneq[5]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**6)))))))-1/8648640.
    coneq[6]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**5))))))))-1/51891840.
    coneq[7]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**4)))))))))-1/259459200.
    coneq[8]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))))))-1/1037836800.
    coneq[9]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))))-1/3113510400.
    coneq[10]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))))-1/6227020800.
    coneq[11]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))))-1/2075673600.
    coneq[12]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))))))-1/778377600.
    coneq[13]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))))-1/1556755200.
    coneq[14]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))))))-1/518918400.
    coneq[15]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))))-1/1037836800.
    coneq[16]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3)))))))))-1/207567360.
    coneq[17]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))))))-1/622702080.
    coneq[18]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))))-1/1245404160.
    coneq[19]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))))))-1/415134720.
    coneq[20]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))))))-1/155675520.
    coneq[21]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))))))-1/311351040.
    coneq[22]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)))))))))-1/103783680.
    coneq[23]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))))-1/311351040.
    coneq[24]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))))-1/622702080.
    coneq[25]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))))-1/207567360.
    coneq[26]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**4))))))))-1/43243200.
    coneq[27]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3)))))))))-1/172972800.
    coneq[28]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))))))-1/518918400.
    coneq[29]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))))-1/1037836800.
    coneq[30]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))))))-1/345945600.
    coneq[31]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))))))-1/129729600.
    coneq[32]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))))))-1/259459200.
    coneq[33]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))))))-1/86486400.
    coneq[34]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))))-1/172972800.
    coneq[35]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**3))))))))-1/34594560.
    coneq[36]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))))))-1/103783680.
    coneq[37]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))))))-1/207567360.
    coneq[38]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))))))-1/69189120.
    coneq[39]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c**2))))))))-1/25945920.
    coneq[40]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)))))))))-1/51891840.
    coneq[41]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,c))))))))-1/17297280.
    coneq[42]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))))))-1/77837760.
    coneq[43]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))))-1/155675520.
    coneq[44]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))))-1/311351040.
    coneq[45]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3))))))))-1/69189120.
    coneq[46]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))))-1/207567360.
    coneq[47]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))))-1/415134720.
    coneq[48]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))))-1/138378240.
    coneq[49]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))))))-1/51891840.
    coneq[50]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))))-1/103783680.
    coneq[51]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))))))-1/34594560.
    coneq[52]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))))-1/69189120.
    coneq[53]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**5)))))))-1/7413120.
    coneq[54]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**4))))))))-1/37065600.
    coneq[55]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3)))))))))-1/148262400.
    coneq[56]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))))))-1/444787200.
    coneq[57]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))))-1/889574400.
    coneq[58]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))))))-1/296524800.
    coneq[59]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))))))-1/111196800.
    coneq[60]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))))))-1/222393600.
    coneq[61]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))))))-1/74131200.
    coneq[62]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))))))-1/148262400.
    coneq[63]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**3))))))))-1/29652480.
    coneq[64]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))))))-1/88957440.
    coneq[65]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))))))-1/177914880.
    coneq[66]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))))))-1/59304960.
    coneq[67]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2))))))))-1/22239360.
    coneq[68]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))))))-1/44478720.
    coneq[69]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,c))))))))-1/14826240.
    coneq[70]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))))))-1/44478720.
    coneq[71]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))))))-1/88957440.
    coneq[72]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))))))-1/29652480.
    coneq[73]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**4)))))))-1/6177600.
    coneq[74]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**3))))))))-1/24710400.
    coneq[75]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))))))-1/74131200.
    coneq[76]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))))))-1/148262400.
    coneq[77]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))))))-1/49420800.
    coneq[78]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2))))))))-1/18532800.
    coneq[79]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))))))-1/37065600.
    coneq[80]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c))))))))-1/12355200.
    coneq[81]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))))))-1/24710400.
    coneq[82]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c**3)))))))-1/4942080.
    coneq[83]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c**2))))))))-1/14826240.
    coneq[84]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)))))))))-1/29652480.
    coneq[85]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,c))))))))-1/9884160.
    coneq[86]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,c**2)))))))-1/3706560.
    coneq[87]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,c))))))))-1/7413120.
    coneq[88]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**5*dot(A,c)))))))-1/2471040.
    coneq[89]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**3)))))))-1/14826240.
    coneq[90]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))))))-1/44478720.
    coneq[91]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))))-1/88957440.
    coneq[92]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))))))-1/29652480.
    coneq[93]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3)))))))-1/29652480.
    coneq[94]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))))))-1/88957440.
    coneq[95]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))))-1/177914880.
    coneq[96]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))))))-1/59304960.
    coneq[97]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**4)))))))-1/12355200.
    coneq[98]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3))))))))-1/49420800.
    coneq[99]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))))-1/148262400.
    coneq[100]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))))-1/296524800.
    coneq[101]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))))-1/98841600.
    coneq[102]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))))))-1/37065600.
    coneq[103]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))))-1/74131200.
    coneq[104]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))))))-1/24710400.
    coneq[105]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))))-1/49420800.
    coneq[106]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2)))))))-1/11119680.
    coneq[107]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))))))-1/22239360.
    coneq[108]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))))))-1/44478720.
    coneq[109]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**3)))))))-1/9884160.
    coneq[110]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))))))-1/29652480.
    coneq[111]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))))))-1/59304960.
    coneq[112]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))))))-1/19768320.
    coneq[113]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2)))))))-1/7413120.
    coneq[114]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))))))-1/14826240.
    coneq[115]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,c)))))))-1/4942080.
    coneq[116]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))))))-1/14826240.
    coneq[117]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))))-1/29652480.
    coneq[118]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))))))-1/9884160.
    coneq[119]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**6))))))-1/1081080.
    coneq[120]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**5)))))))-1/6486480.
    coneq[121]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**4))))))))-1/32432400.
    coneq[122]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3)))))))))-1/129729600.
    coneq[123]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))))-1/389188800.
    coneq[124]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))))-1/778377600.
    coneq[125]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))))-1/259459200.
    coneq[126]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))))-1/97297200.
    coneq[127]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))))-1/194594400.
    coneq[128]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))))-1/64864800.
    coneq[129]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))))-1/129729600.
    coneq[130]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**3))))))))-1/25945920.
    coneq[131]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))))-1/77837760.
    coneq[132]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))))-1/155675520.
    coneq[133]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))))-1/51891840.
    coneq[134]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2))))))))-1/19459440.
    coneq[135]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))))-1/38918880.
    coneq[136]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,c))))))))-1/12972960.
    coneq[137]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))))-1/38918880.
    coneq[138]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))))-1/77837760.
    coneq[139]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))))-1/25945920.
    coneq[140]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**4)))))))-1/5405400.
    coneq[141]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**3))))))))-1/21621600.
    coneq[142]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))))-1/64864800.
    coneq[143]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))))-1/129729600.
    coneq[144]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))))-1/43243200.
    coneq[145]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2))))))))-1/16216200.
    coneq[146]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))))-1/32432400.
    coneq[147]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c))))))))-1/10810800.
    coneq[148]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))))-1/21621600.
    coneq[149]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c**3)))))))-1/4324320.
    coneq[150]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2))))))))-1/12972960.
    coneq[151]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))))-1/25945920.
    coneq[152]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c))))))))-1/8648640.
    coneq[153]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,c**2)))))))-1/3243240.
    coneq[154]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,c))))))))-1/6486480.
    coneq[155]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**4*dot(A,c)))))))-1/2162160.
    coneq[156]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2)))))))-1/9729720.
    coneq[157]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))))-1/19459440.
    coneq[158]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))))-1/38918880.
    coneq[159]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**3)))))))-1/8648640.
    coneq[160]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))))-1/25945920.
    coneq[161]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))))-1/51891840.
    coneq[162]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))))-1/17297280.
    coneq[163]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2)))))))-1/6486480.
    coneq[164]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))))-1/12972960.
    coneq[165]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)))))))-1/4324320.
    coneq[166]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))))-1/8648640.
    coneq[167]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**5))))))-1/926640.
    coneq[168]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**4)))))))-1/4633200.
    coneq[169]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**3))))))))-1/18532800.
    coneq[170]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/55598400.
    coneq[171]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/111196800.
    coneq[172]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/37065600.
    coneq[173]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2))))))))-1/13899600.
    coneq[174]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/27799200.
    coneq[175]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c))))))))-1/9266400.
    coneq[176]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/18532800.
    coneq[177]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c**3)))))))-1/3706560.
    coneq[178]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2))))))))-1/11119680.
    coneq[179]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/22239360.
    coneq[180]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c))))))))-1/7413120.
    coneq[181]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c**2)))))))-1/2779920.
    coneq[182]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c))))))))-1/5559840.
    coneq[183]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**3*dot(A,c)))))))-1/1853280.
    coneq[184]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2)))))))-1/5559840.
    coneq[185]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/11119680.
    coneq[186]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)))))))-1/3706560.
    coneq[187]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c**4))))))-1/772200.
    coneq[188]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c**3)))))))-1/3088800.
    coneq[189]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c**2))))))))-1/9266400.
    coneq[190]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/18532800.
    coneq[191]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,c))))))))-1/6177600.
    coneq[192]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,c**2)))))))-1/2316600.
    coneq[193]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,c))))))))-1/4633200.
    coneq[194]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c**2*dot(A,c)))))))-1/1544400.
    coneq[195]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,c)))))))-1/3088800.
    coneq[196]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,c**3))))))-1/617760.
    coneq[197]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,c**2)))))))-1/1853280.
    coneq[198]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,c))))))))-1/3706560.
    coneq[199]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,c*dot(A,c)))))))-1/1235520.
    coneq[200]=dot(b,dot(A,dot(A,dot(A,dot(A,c**5*dot(A,c**2))))))-1/463320.
    coneq[201]=dot(b,dot(A,dot(A,dot(A,dot(A,c**5*dot(A,dot(A,c)))))))-1/926640.
    coneq[202]=dot(b,dot(A,dot(A,dot(A,dot(A,c**6*dot(A,c))))))-1/308880.
    coneq[203]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,c**3))))))-1/2471040.
    coneq[204]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c**2)))))))-1/7413120.
    coneq[205]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c))))))))-1/14826240.
    coneq[206]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,c)))))))-1/4942080.
    coneq[207]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))))))-1/22239360.
    coneq[208]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))))))-1/44478720.
    coneq[209]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))))))-1/14826240.
    coneq[210]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))))))-1/88957440.
    coneq[211]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))))))-1/29652480.
    coneq[212]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))))))-1/9884160.
    coneq[213]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**4))))))-1/2316600.
    coneq[214]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**3)))))))-1/9266400.
    coneq[215]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))))))-1/27799200.
    coneq[216]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/55598400.
    coneq[217]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))))))-1/18532800.
    coneq[218]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2)))))))-1/6949800.
    coneq[219]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))))))-1/13899600.
    coneq[220]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)))))))-1/4633200.
    coneq[221]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))))))-1/9266400.
    coneq[222]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**4))))))-1/4633200.
    coneq[223]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3)))))))-1/18532800.
    coneq[224]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))))))-1/55598400.
    coneq[225]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/111196800.
    coneq[226]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))))))-1/37065600.
    coneq[227]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))))))-1/13899600.
    coneq[228]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))))))-1/27799200.
    coneq[229]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))))))-1/9266400.
    coneq[230]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))))-1/18532800.
    coneq[231]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**5))))))-1/1853280.
    coneq[232]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**4)))))))-1/9266400.
    coneq[233]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3))))))))-1/37065600.
    coneq[234]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/111196800.
    coneq[235]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/222393600.
    coneq[236]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/74131200.
    coneq[237]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))))))-1/27799200.
    coneq[238]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/55598400.
    coneq[239]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))))))-1/18532800.
    coneq[240]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/37065600.
    coneq[241]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**3)))))))-1/7413120.
    coneq[242]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))))))-1/22239360.
    coneq[243]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/44478720.
    coneq[244]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))))))-1/14826240.
    coneq[245]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2)))))))-1/5559840.
    coneq[246]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))))))-1/11119680.
    coneq[247]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,c)))))))-1/3706560.
    coneq[248]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))))))-1/11119680.
    coneq[249]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/22239360.
    coneq[250]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))))))-1/7413120.
    coneq[251]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**3))))))-1/1853280.
    coneq[252]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2)))))))-1/5559840.
    coneq[253]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))))-1/11119680.
    coneq[254]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)))))))-1/3706560.
    coneq[255]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**3))))))-1/3706560.
    coneq[256]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))))-1/11119680.
    coneq[257]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))))-1/22239360.
    coneq[258]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))))-1/7413120.
    coneq[259]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**4))))))-1/1544400.
    coneq[260]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**3)))))))-1/6177600.
    coneq[261]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))))-1/18532800.
    coneq[262]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/37065600.
    coneq[263]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))))-1/12355200.
    coneq[264]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2)))))))-1/4633200.
    coneq[265]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))))-1/9266400.
    coneq[266]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)))))))-1/3088800.
    coneq[267]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))))-1/6177600.
    coneq[268]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c**2))))))-1/1389960.
    coneq[269]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)))))))-1/2779920.
    coneq[270]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/5559840.
    coneq[271]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**3))))))-1/1235520.
    coneq[272]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2)))))))-1/3706560.
    coneq[273]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/7413120.
    coneq[274]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)))))))-1/2471040.
    coneq[275]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,c**2))))))-1/926640.
    coneq[276]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,c)))))))-1/1853280.
    coneq[277]=dot(b,dot(A,dot(A,dot(A,dot(A,c**4*dot(A,c)*dot(A,c))))))-1/617760.
    coneq[278]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3))))))-1/2471040.
    coneq[279]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))))))-1/7413120.
    coneq[280]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/14826240.
    coneq[281]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))))))-1/4942080.
    coneq[282]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2))))))-1/2779920.
    coneq[283]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))))))-1/5559840.
    coneq[284]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/11119680.
    coneq[285]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2))))))-1/1853280.
    coneq[286]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))))-1/3706560.
    coneq[287]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c))))))-1/1235520.
    coneq[288]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))))))-1/2471040.
    coneq[289]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**7)))))-1/137280.
    coneq[290]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**6))))))-1/960960.
    coneq[291]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**5)))))))-1/5765760.
    coneq[292]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**4))))))))-1/28828800.
    coneq[293]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))))-1/115315200.
    coneq[294]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))))-1/345945600.
    coneq[295]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))))-1/691891200.
    coneq[296]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))))-1/230630400.
    coneq[297]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))))-1/86486400.
    coneq[298]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))))-1/172972800.
    coneq[299]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))))-1/57657600.
    coneq[300]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))))-1/115315200.
    coneq[301]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**3))))))))-1/23063040.
    coneq[302]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))))-1/69189120.
    coneq[303]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))))-1/138378240.
    coneq[304]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))))-1/46126080.
    coneq[305]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))))-1/17297280.
    coneq[306]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))))-1/34594560.
    coneq[307]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,c))))))))-1/11531520.
    coneq[308]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))))-1/34594560.
    coneq[309]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))))-1/69189120.
    coneq[310]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))))-1/23063040.
    coneq[311]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**4)))))))-1/4804800.
    coneq[312]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**3))))))))-1/19219200.
    coneq[313]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))))-1/57657600.
    coneq[314]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))))-1/115315200.
    coneq[315]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))))-1/38438400.
    coneq[316]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))))-1/14414400.
    coneq[317]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))))-1/28828800.
    coneq[318]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))))-1/9609600.
    coneq[319]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))))-1/19219200.
    coneq[320]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c**3)))))))-1/3843840.
    coneq[321]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))))-1/11531520.
    coneq[322]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))))-1/23063040.
    coneq[323]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))))-1/7687680.
    coneq[324]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,c**2)))))))-1/2882880.
    coneq[325]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,c))))))))-1/5765760.
    coneq[326]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**4*dot(A,c)))))))-1/1921920.
    coneq[327]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))))-1/8648640.
    coneq[328]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))))-1/17297280.
    coneq[329]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))))-1/34594560.
    coneq[330]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**3)))))))-1/7687680.
    coneq[331]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))))-1/23063040.
    coneq[332]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))))-1/46126080.
    coneq[333]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))))-1/15375360.
    coneq[334]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))))-1/5765760.
    coneq[335]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))))-1/11531520.
    coneq[336]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))))-1/3843840.
    coneq[337]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))))-1/7687680.
    coneq[338]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**5))))))-1/823680.
    coneq[339]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**4)))))))-1/4118400.
    coneq[340]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**3))))))))-1/16473600.
    coneq[341]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/49420800.
    coneq[342]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/98841600.
    coneq[343]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/32947200.
    coneq[344]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))))-1/12355200.
    coneq[345]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/24710400.
    coneq[346]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))))-1/8236800.
    coneq[347]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/16473600.
    coneq[348]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c**3)))))))-1/3294720.
    coneq[349]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))))-1/9884160.
    coneq[350]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/19768320.
    coneq[351]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))))-1/6589440.
    coneq[352]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c**2)))))))-1/2471040.
    coneq[353]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))))-1/4942080.
    coneq[354]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**3*dot(A,c)))))))-1/1647360.
    coneq[355]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))))-1/4942080.
    coneq[356]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/9884160.
    coneq[357]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))))-1/3294720.
    coneq[358]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c**4))))))-1/686400.
    coneq[359]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c**3)))))))-1/2745600.
    coneq[360]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))))-1/8236800.
    coneq[361]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/16473600.
    coneq[362]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))))-1/5491200.
    coneq[363]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c**2)))))))-1/2059200.
    coneq[364]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))))-1/4118400.
    coneq[365]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,c)))))))-1/1372800.
    coneq[366]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))))-1/2745600.
    coneq[367]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,c**3))))))-1/549120.
    coneq[368]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,c**2)))))))-1/1647360.
    coneq[369]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,c))))))))-1/3294720.
    coneq[370]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,c*dot(A,c)))))))-1/1098240.
    coneq[371]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**4*dot(A,c**2))))))-1/411840.
    coneq[372]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**4*dot(A,dot(A,c)))))))-1/823680.
    coneq[373]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**5*dot(A,c))))))-1/274560.
    coneq[374]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**3))))))-1/1647360.
    coneq[375]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))))-1/4942080.
    coneq[376]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))))-1/9884160.
    coneq[377]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))))-1/3294720.
    coneq[378]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**3))))))-1/3294720.
    coneq[379]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))))-1/9884160.
    coneq[380]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))))-1/19768320.
    coneq[381]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))))-1/6589440.
    coneq[382]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**4))))))-1/1372800.
    coneq[383]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**3)))))))-1/5491200.
    coneq[384]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))))-1/16473600.
    coneq[385]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/32947200.
    coneq[386]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))))-1/10982400.
    coneq[387]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))))-1/4118400.
    coneq[388]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))))-1/8236800.
    coneq[389]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))))-1/2745600.
    coneq[390]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))))-1/5491200.
    coneq[391]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c**2))))))-1/1235520.
    coneq[392]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))))-1/2471040.
    coneq[393]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/4942080.
    coneq[394]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**3))))))-1/1098240.
    coneq[395]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))))-1/3294720.
    coneq[396]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/6589440.
    coneq[397]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))))-1/2196480.
    coneq[398]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c**2))))))-1/823680.
    coneq[399]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))))-1/1647360.
    coneq[400]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,c))))))-1/549120.
    coneq[401]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))))-1/1647360.
    coneq[402]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))))-1/3294720.
    coneq[403]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))))-1/1098240.
    coneq[404]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**6)))))-1/120120.
    coneq[405]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**5))))))-1/720720.
    coneq[406]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**4)))))))-1/3603600.
    coneq[407]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/14414400.
    coneq[408]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/43243200.
    coneq[409]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/86486400.
    coneq[410]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/28828800.
    coneq[411]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/10810800.
    coneq[412]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/21621600.
    coneq[413]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/7207200.
    coneq[414]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/14414400.
    coneq[415]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c**3)))))))-1/2882880.
    coneq[416]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/8648640.
    coneq[417]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/17297280.
    coneq[418]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/5765760.
    coneq[419]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c**2)))))))-1/2162160.
    coneq[420]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/4324320.
    coneq[421]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**3*dot(A,c)))))))-1/1441440.
    coneq[422]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/4324320.
    coneq[423]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/8648640.
    coneq[424]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/2882880.
    coneq[425]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c**4))))))-1/600600.
    coneq[426]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c**3)))))))-1/2402400.
    coneq[427]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/7207200.
    coneq[428]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/14414400.
    coneq[429]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/4804800.
    coneq[430]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c**2)))))))-1/1801800.
    coneq[431]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/3603600.
    coneq[432]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,c)))))))-1/1201200.
    coneq[433]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/2402400.
    coneq[434]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c**3))))))-1/480480.
    coneq[435]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c**2)))))))-1/1441440.
    coneq[436]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/2882880.
    coneq[437]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,c)))))))-1/960960.
    coneq[438]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**3*dot(A,c**2))))))-1/360360.
    coneq[439]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**3*dot(A,dot(A,c)))))))-1/720720.
    coneq[440]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**4*dot(A,c))))))-1/240240.
    coneq[441]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c**2))))))-1/1081080.
    coneq[442]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/2162160.
    coneq[443]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/4324320.
    coneq[444]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**3))))))-1/960960.
    coneq[445]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/2882880.
    coneq[446]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/5765760.
    coneq[447]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/1921920.
    coneq[448]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c**2))))))-1/720720.
    coneq[449]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/1441440.
    coneq[450]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,c))))))-1/480480.
    coneq[451]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/960960.
    coneq[452]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**5)))))-1/102960.
    coneq[453]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c**4))))))-1/514800.
    coneq[454]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c**3)))))))-1/2059200.
    coneq[455]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/6177600.
    coneq[456]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/12355200.
    coneq[457]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/4118400.
    coneq[458]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,c**2)))))))-1/1544400.
    coneq[459]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/3088800.
    coneq[460]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c**2*dot(A,c)))))))-1/1029600.
    coneq[461]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/2059200.
    coneq[462]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,c**3))))))-1/411840.
    coneq[463]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,c**2)))))))-1/1235520.
    coneq[464]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/2471040.
    coneq[465]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,c*dot(A,c)))))))-1/823680.
    coneq[466]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**2*dot(A,c**2))))))-1/308880.
    coneq[467]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**2*dot(A,dot(A,c)))))))-1/617760.
    coneq[468]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**3*dot(A,c))))))-1/205920.
    coneq[469]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,c**2))))))-1/617760.
    coneq[470]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1235520.
    coneq[471]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,c))))))-1/411840.
    coneq[472]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c**4)))))-1/85800.
    coneq[473]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,c**3))))))-1/343200.
    coneq[474]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,c**2)))))))-1/1029600.
    coneq[475]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2059200.
    coneq[476]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,c*dot(A,c)))))))-1/686400.
    coneq[477]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c*dot(A,c**2))))))-1/257400.
    coneq[478]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c*dot(A,dot(A,c)))))))-1/514800.
    coneq[479]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c**2*dot(A,c))))))-1/171600.
    coneq[480]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,dot(A,c)*dot(A,c))))))-1/343200.
    coneq[481]=dot(b,dot(A,dot(A,dot(A,c**5*dot(A,c**3)))))-1/68640.
    coneq[482]=dot(b,dot(A,dot(A,dot(A,c**5*dot(A,dot(A,c**2))))))-1/205920.
    coneq[483]=dot(b,dot(A,dot(A,dot(A,c**5*dot(A,dot(A,dot(A,c)))))))-1/411840.
    coneq[484]=dot(b,dot(A,dot(A,dot(A,c**5*dot(A,c*dot(A,c))))))-1/137280.
    coneq[485]=dot(b,dot(A,dot(A,dot(A,c**6*dot(A,c**2)))))-1/51480.
    coneq[486]=dot(b,dot(A,dot(A,dot(A,c**6*dot(A,dot(A,c))))))-1/102960.
    coneq[487]=dot(b,dot(A,dot(A,dot(A,c**7*dot(A,c)))))-1/34320.
    coneq[488]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,c**4)))))-1/343200.
    coneq[489]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c**3))))))-1/1372800.
    coneq[490]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c**2)))))))-1/4118400.
    coneq[491]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/8236800.
    coneq[492]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,c)))))))-1/2745600.
    coneq[493]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,c**2))))))-1/1029600.
    coneq[494]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,c)))))))-1/2059200.
    coneq[495]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,c))))))-1/686400.
    coneq[496]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,c))))))-1/1372800.
    coneq[497]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c**4)))))-1/1029600.
    coneq[498]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**3))))))-1/4118400.
    coneq[499]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**2)))))))-1/12355200.
    coneq[500]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c))))))))-1/24710400.
    coneq[501]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c)))))))-1/8236800.
    coneq[502]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c**2))))))-1/3088800.
    coneq[503]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c)))))))-1/6177600.
    coneq[504]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c))))))-1/2059200.
    coneq[505]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c))))))-1/4118400.
    coneq[506]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**4)))))-1/2059200.
    coneq[507]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**3))))))-1/8236800.
    coneq[508]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2)))))))-1/24710400.
    coneq[509]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c))))))))-1/49420800.
    coneq[510]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c)))))))-1/16473600.
    coneq[511]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**2))))))-1/6177600.
    coneq[512]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c)))))))-1/12355200.
    coneq[513]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c))))))-1/4118400.
    coneq[514]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c))))))-1/8236800.
    coneq[515]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c**4)))))-1/686400.
    coneq[516]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**3))))))-1/2745600.
    coneq[517]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**2)))))))-1/8236800.
    coneq[518]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))))-1/16473600.
    coneq[519]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c)))))))-1/5491200.
    coneq[520]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c**2))))))-1/2059200.
    coneq[521]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c)))))))-1/4118400.
    coneq[522]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c))))))-1/1372800.
    coneq[523]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c))))))-1/2745600.
    coneq[524]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**5)))))-1/308880.
    coneq[525]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**4))))))-1/1544400.
    coneq[526]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**3)))))))-1/6177600.
    coneq[527]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/18532800.
    coneq[528]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/37065600.
    coneq[529]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/12355200.
    coneq[530]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c**2)))))))-1/4633200.
    coneq[531]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/9266400.
    coneq[532]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c)))))))-1/3088800.
    coneq[533]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/6177600.
    coneq[534]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**3))))))-1/1235520.
    coneq[535]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c**2)))))))-1/3706560.
    coneq[536]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/7413120.
    coneq[537]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c)))))))-1/2471040.
    coneq[538]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c**2))))))-1/926640.
    coneq[539]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c)))))))-1/1853280.
    coneq[540]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,c))))))-1/617760.
    coneq[541]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**2))))))-1/1853280.
    coneq[542]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/3706560.
    coneq[543]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c))))))-1/1235520.
    coneq[544]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**5)))))-1/617760.
    coneq[545]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**4))))))-1/3088800.
    coneq[546]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**3)))))))-1/12355200.
    coneq[547]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/37065600.
    coneq[548]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/74131200.
    coneq[549]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/24710400.
    coneq[550]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**2)))))))-1/9266400.
    coneq[551]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/18532800.
    coneq[552]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c)))))))-1/6177600.
    coneq[553]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/12355200.
    coneq[554]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**3))))))-1/2471040.
    coneq[555]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**2)))))))-1/7413120.
    coneq[556]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/14826240.
    coneq[557]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c)))))))-1/4942080.
    coneq[558]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c**2))))))-1/1853280.
    coneq[559]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c)))))))-1/3706560.
    coneq[560]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,c))))))-1/1235520.
    coneq[561]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**2))))))-1/3706560.
    coneq[562]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/7413120.
    coneq[563]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c))))))-1/2471040.
    coneq[564]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**6)))))-1/240240.
    coneq[565]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**5))))))-1/1441440.
    coneq[566]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**4)))))))-1/7207200.
    coneq[567]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/28828800.
    coneq[568]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/86486400.
    coneq[569]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/172972800.
    coneq[570]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/57657600.
    coneq[571]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/21621600.
    coneq[572]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/43243200.
    coneq[573]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/14414400.
    coneq[574]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/28828800.
    coneq[575]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**3)))))))-1/5765760.
    coneq[576]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/17297280.
    coneq[577]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/34594560.
    coneq[578]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/11531520.
    coneq[579]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c**2)))))))-1/4324320.
    coneq[580]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/8648640.
    coneq[581]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,c)))))))-1/2882880.
    coneq[582]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/8648640.
    coneq[583]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/17297280.
    coneq[584]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/5765760.
    coneq[585]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**4))))))-1/1201200.
    coneq[586]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**3)))))))-1/4804800.
    coneq[587]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/14414400.
    coneq[588]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/28828800.
    coneq[589]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/9609600.
    coneq[590]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c**2)))))))-1/3603600.
    coneq[591]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/7207200.
    coneq[592]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c)))))))-1/2402400.
    coneq[593]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/4804800.
    coneq[594]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**3))))))-1/960960.
    coneq[595]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c**2)))))))-1/2882880.
    coneq[596]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/5765760.
    coneq[597]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c)))))))-1/1921920.
    coneq[598]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,c**2))))))-1/720720.
    coneq[599]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,c)))))))-1/1441440.
    coneq[600]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**4*dot(A,c))))))-1/480480.
    coneq[601]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**2))))))-1/2162160.
    coneq[602]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/4324320.
    coneq[603]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/8648640.
    coneq[604]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**3))))))-1/1921920.
    coneq[605]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/5765760.
    coneq[606]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/11531520.
    coneq[607]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/3843840.
    coneq[608]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**2))))))-1/1441440.
    coneq[609]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/2882880.
    coneq[610]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c))))))-1/960960.
    coneq[611]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/1921920.
    coneq[612]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3)*dot(A,c**3)))))-1/274560.
    coneq[613]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3)*dot(A,dot(A,c**2))))))-1/823680.
    coneq[614]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,c)))))))-1/1647360.
    coneq[615]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,c))))))-1/549120.
    coneq[616]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c**2))))))-1/2471040.
    coneq[617]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)))))))-1/4942080.
    coneq[618]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,c))))))-1/1647360.
    coneq[619]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))))))-1/9884160.
    coneq[620]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c))))))-1/3294720.
    coneq[621]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,c))))))-1/1098240.
    coneq[622]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**4)))))-1/257400.
    coneq[623]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**3))))))-1/1029600.
    coneq[624]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c**2)))))))-1/3088800.
    coneq[625]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/6177600.
    coneq[626]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,c)))))))-1/2059200.
    coneq[627]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c**2))))))-1/772200.
    coneq[628]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,c)))))))-1/1544400.
    coneq[629]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,c))))))-1/514800.
    coneq[630]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c))))))-1/1029600.
    coneq[631]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**4)))))-1/514800.
    coneq[632]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**3))))))-1/2059200.
    coneq[633]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)))))))-1/6177600.
    coneq[634]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))))-1/12355200.
    coneq[635]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)))))))-1/4118400.
    coneq[636]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c**2))))))-1/1544400.
    coneq[637]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)))))))-1/3088800.
    coneq[638]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,c))))))-1/1029600.
    coneq[639]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c))))))-1/2059200.
    coneq[640]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**5)))))-1/205920.
    coneq[641]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**4))))))-1/1029600.
    coneq[642]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**3)))))))-1/4118400.
    coneq[643]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/12355200.
    coneq[644]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/24710400.
    coneq[645]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/8236800.
    coneq[646]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c**2)))))))-1/3088800.
    coneq[647]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/6177600.
    coneq[648]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,c)))))))-1/2059200.
    coneq[649]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/4118400.
    coneq[650]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**3))))))-1/823680.
    coneq[651]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c**2)))))))-1/2471040.
    coneq[652]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/4942080.
    coneq[653]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,c)))))))-1/1647360.
    coneq[654]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c**2))))))-1/617760.
    coneq[655]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,c)))))))-1/1235520.
    coneq[656]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,c))))))-1/411840.
    coneq[657]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c**2))))))-1/1235520.
    coneq[658]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/2471040.
    coneq[659]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c))))))-1/823680.
    coneq[660]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c**3)))))-1/205920.
    coneq[661]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c**2))))))-1/617760.
    coneq[662]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/1235520.
    coneq[663]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,c))))))-1/411840.
    coneq[664]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**3)))))-1/411840.
    coneq[665]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/1235520.
    coneq[666]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/2471040.
    coneq[667]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/823680.
    coneq[668]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**4)))))-1/171600.
    coneq[669]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**3))))))-1/686400.
    coneq[670]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/2059200.
    coneq[671]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/4118400.
    coneq[672]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/1372800.
    coneq[673]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c**2))))))-1/514800.
    coneq[674]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/1029600.
    coneq[675]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,c))))))-1/343200.
    coneq[676]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/686400.
    coneq[677]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**2)*dot(A,c**2)))))-1/154440.
    coneq[678]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,c))))))-1/308880.
    coneq[679]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/617760.
    coneq[680]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,c**3)))))-1/137280.
    coneq[681]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,c**2))))))-1/411840.
    coneq[682]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/823680.
    coneq[683]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,c*dot(A,c))))))-1/274560.
    coneq[684]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c)*dot(A,c**2)))))-1/102960.
    coneq[685]=dot(b,dot(A,dot(A,dot(A,c**4*dot(A,c)*dot(A,dot(A,c))))))-1/205920.
    coneq[686]=dot(b,dot(A,dot(A,dot(A,c**5*dot(A,c)*dot(A,c)))))-1/68640.
    coneq[687]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**4)))))-1/343200.
    coneq[688]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**3))))))-1/1372800.
    coneq[689]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/4118400.
    coneq[690]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/8236800.
    coneq[691]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/2745600.
    coneq[692]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c**2))))))-1/1029600.
    coneq[693]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/2059200.
    coneq[694]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,c))))))-1/686400.
    coneq[695]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/1372800.
    coneq[696]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**3)))))-1/411840.
    coneq[697]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c**2))))))-1/1235520.
    coneq[698]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/2471040.
    coneq[699]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,c))))))-1/823680.
    coneq[700]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c**3)))))-1/823680.
    coneq[701]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/2471040.
    coneq[702]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/4942080.
    coneq[703]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/1647360.
    coneq[704]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,c**2)))))-1/463320.
    coneq[705]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,c))))))-1/926640.
    coneq[706]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/1853280.
    coneq[707]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/3706560.
    coneq[708]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**3)))))-1/274560.
    coneq[709]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c**2))))))-1/823680.
    coneq[710]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/1647360.
    coneq[711]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c))))))-1/549120.
    coneq[712]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,c**2)))))-1/308880.
    coneq[713]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c))))))-1/617760.
    coneq[714]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/1235520.
    coneq[715]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/205920.
    coneq[716]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/411840.
    coneq[717]=dot(b,dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,c)*dot(A,c)))))-1/137280.
    coneq[718]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/411840.
    coneq[719]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/823680.
    coneq[720]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)))))-1/274560.
    coneq[721]=dot(b,dot(A,dot(A,c*dot(A,c**8))))-1/15444.
    coneq[722]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**7)))))-1/123552.
    coneq[723]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**6))))))-1/864864.
    coneq[724]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**5)))))))-1/5189184.
    coneq[725]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**4))))))))-1/25945920.
    coneq[726]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))))-1/103783680.
    coneq[727]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))))-1/311351040.
    coneq[728]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))))-1/622702080.
    coneq[729]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))))-1/207567360.
    coneq[730]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))))-1/77837760.
    coneq[731]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))))-1/155675520.
    coneq[732]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))))-1/51891840.
    coneq[733]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))))-1/103783680.
    coneq[734]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3))))))))-1/20756736.
    coneq[735]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))))-1/62270208.
    coneq[736]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))))-1/124540416.
    coneq[737]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))))-1/41513472.
    coneq[738]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))))-1/15567552.
    coneq[739]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))))-1/31135104.
    coneq[740]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c))))))))-1/10378368.
    coneq[741]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))))-1/31135104.
    coneq[742]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))))-1/62270208.
    coneq[743]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))))-1/20756736.
    coneq[744]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**4)))))))-1/4324320.
    coneq[745]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3))))))))-1/17297280.
    coneq[746]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))))-1/51891840.
    coneq[747]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))))-1/103783680.
    coneq[748]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))))-1/34594560.
    coneq[749]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))))-1/12972960.
    coneq[750]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))))-1/25945920.
    coneq[751]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))))-1/8648640.
    coneq[752]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))))-1/17297280.
    coneq[753]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c**3)))))))-1/3459456.
    coneq[754]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))))-1/10378368.
    coneq[755]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))))-1/20756736.
    coneq[756]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))))-1/6918912.
    coneq[757]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,c**2)))))))-1/2594592.
    coneq[758]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c))))))))-1/5189184.
    coneq[759]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**4*dot(A,c)))))))-1/1729728.
    coneq[760]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))))-1/7783776.
    coneq[761]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))))-1/15567552.
    coneq[762]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))))-1/31135104.
    coneq[763]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3)))))))-1/6918912.
    coneq[764]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))))-1/20756736.
    coneq[765]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))))-1/41513472.
    coneq[766]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))))-1/13837824.
    coneq[767]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))))-1/5189184.
    coneq[768]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))))-1/10378368.
    coneq[769]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))))-1/3459456.
    coneq[770]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))))-1/6918912.
    coneq[771]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**5))))))-1/741312.
    coneq[772]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**4)))))))-1/3706560.
    coneq[773]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3))))))))-1/14826240.
    coneq[774]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/44478720.
    coneq[775]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/88957440.
    coneq[776]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/29652480.
    coneq[777]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))))-1/11119680.
    coneq[778]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/22239360.
    coneq[779]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))))-1/7413120.
    coneq[780]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/14826240.
    coneq[781]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c**3)))))))-1/2965248.
    coneq[782]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))))-1/8895744.
    coneq[783]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/17791488.
    coneq[784]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))))-1/5930496.
    coneq[785]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,c**2)))))))-1/2223936.
    coneq[786]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))))-1/4447872.
    coneq[787]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**3*dot(A,c)))))))-1/1482624.
    coneq[788]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))))-1/4447872.
    coneq[789]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/8895744.
    coneq[790]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))))-1/2965248.
    coneq[791]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c**4))))))-1/617760.
    coneq[792]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c**3)))))))-1/2471040.
    coneq[793]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))))-1/7413120.
    coneq[794]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/14826240.
    coneq[795]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))))-1/4942080.
    coneq[796]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,c**2)))))))-1/1853280.
    coneq[797]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))))-1/3706560.
    coneq[798]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2*dot(A,c)))))))-1/1235520.
    coneq[799]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))))-1/2471040.
    coneq[800]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,c**3))))))-1/494208.
    coneq[801]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,c**2)))))))-1/1482624.
    coneq[802]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c))))))))-1/2965248.
    coneq[803]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,c*dot(A,c)))))))-1/988416.
    coneq[804]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**4*dot(A,c**2))))))-1/370656.
    coneq[805]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**4*dot(A,dot(A,c)))))))-1/741312.
    coneq[806]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**5*dot(A,c))))))-1/247104.
    coneq[807]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c**3))))))-1/1482624.
    coneq[808]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))))-1/4447872.
    coneq[809]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))))-1/8895744.
    coneq[810]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))))-1/2965248.
    coneq[811]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3))))))-1/2965248.
    coneq[812]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))))-1/8895744.
    coneq[813]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))))-1/17791488.
    coneq[814]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))))-1/5930496.
    coneq[815]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**4))))))-1/1235520.
    coneq[816]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3)))))))-1/4942080.
    coneq[817]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))))-1/14826240.
    coneq[818]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/29652480.
    coneq[819]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))))-1/9884160.
    coneq[820]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))))-1/3706560.
    coneq[821]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))))-1/7413120.
    coneq[822]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))))-1/2471040.
    coneq[823]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))))-1/4942080.
    coneq[824]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2))))))-1/1111968.
    coneq[825]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))))-1/2223936.
    coneq[826]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/4447872.
    coneq[827]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c**3))))))-1/988416.
    coneq[828]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))))-1/2965248.
    coneq[829]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/5930496.
    coneq[830]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))))-1/1976832.
    coneq[831]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2))))))-1/741312.
    coneq[832]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))))-1/1482624.
    coneq[833]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,c)*dot(A,c))))))-1/494208.
    coneq[834]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))))-1/1482624.
    coneq[835]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))))-1/2965248.
    coneq[836]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))))-1/988416.
    coneq[837]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**6)))))-1/108108.
    coneq[838]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**5))))))-1/648648.
    coneq[839]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**4)))))))-1/3243240.
    coneq[840]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/12972960.
    coneq[841]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/38918880.
    coneq[842]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/77837760.
    coneq[843]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/25945920.
    coneq[844]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/9729720.
    coneq[845]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/19459440.
    coneq[846]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/6486480.
    coneq[847]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/12972960.
    coneq[848]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c**3)))))))-1/2594592.
    coneq[849]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/7783776.
    coneq[850]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/15567552.
    coneq[851]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/5189184.
    coneq[852]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,c**2)))))))-1/1945944.
    coneq[853]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/3891888.
    coneq[854]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**3*dot(A,c)))))))-1/1297296.
    coneq[855]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/3891888.
    coneq[856]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/7783776.
    coneq[857]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/2594592.
    coneq[858]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c**4))))))-1/540540.
    coneq[859]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c**3)))))))-1/2162160.
    coneq[860]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/6486480.
    coneq[861]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/12972960.
    coneq[862]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/4324320.
    coneq[863]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,c**2)))))))-1/1621620.
    coneq[864]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/3243240.
    coneq[865]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2*dot(A,c)))))))-1/1081080.
    coneq[866]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/2162160.
    coneq[867]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c**3))))))-1/432432.
    coneq[868]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,c**2)))))))-1/1297296.
    coneq[869]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/2594592.
    coneq[870]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c*dot(A,c)))))))-1/864864.
    coneq[871]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**3*dot(A,c**2))))))-1/324324.
    coneq[872]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**3*dot(A,dot(A,c)))))))-1/648648.
    coneq[873]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**4*dot(A,c))))))-1/216216.
    coneq[874]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2))))))-1/972972.
    coneq[875]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/1945944.
    coneq[876]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/3891888.
    coneq[877]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c**3))))))-1/864864.
    coneq[878]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/2594592.
    coneq[879]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/5189184.
    coneq[880]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/1729728.
    coneq[881]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2))))))-1/648648.
    coneq[882]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/1297296.
    coneq[883]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c))))))-1/432432.
    coneq[884]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/864864.
    coneq[885]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**5)))))-1/92664.
    coneq[886]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c**4))))))-1/463320.
    coneq[887]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c**3)))))))-1/1853280.
    coneq[888]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/5559840.
    coneq[889]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/11119680.
    coneq[890]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/3706560.
    coneq[891]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,c**2)))))))-1/1389960.
    coneq[892]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/2779920.
    coneq[893]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2*dot(A,c)))))))-1/926640.
    coneq[894]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1853280.
    coneq[895]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c**3))))))-1/370656.
    coneq[896]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,c**2)))))))-1/1111968.
    coneq[897]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/2223936.
    coneq[898]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c*dot(A,c)))))))-1/741312.
    coneq[899]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,c**2))))))-1/277992.
    coneq[900]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,dot(A,c)))))))-1/555984.
    coneq[901]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**3*dot(A,c))))))-1/185328.
    coneq[902]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2))))))-1/555984.
    coneq[903]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1111968.
    coneq[904]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c))))))-1/370656.
    coneq[905]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c**4)))))-1/77220.
    coneq[906]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,c**3))))))-1/308880.
    coneq[907]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,c**2)))))))-1/926640.
    coneq[908]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1853280.
    coneq[909]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,c*dot(A,c)))))))-1/617760.
    coneq[910]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c*dot(A,c**2))))))-1/231660.
    coneq[911]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c*dot(A,dot(A,c)))))))-1/463320.
    coneq[912]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c**2*dot(A,c))))))-1/154440.
    coneq[913]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,c)*dot(A,c))))))-1/308880.
    coneq[914]=dot(b,dot(A,dot(A,c*dot(A,c**4*dot(A,c**3)))))-1/61776.
    coneq[915]=dot(b,dot(A,dot(A,c*dot(A,c**4*dot(A,dot(A,c**2))))))-1/185328.
    coneq[916]=dot(b,dot(A,dot(A,c*dot(A,c**4*dot(A,dot(A,dot(A,c)))))))-1/370656.
    coneq[917]=dot(b,dot(A,dot(A,c*dot(A,c**4*dot(A,c*dot(A,c))))))-1/123552.
    coneq[918]=dot(b,dot(A,dot(A,c*dot(A,c**5*dot(A,c**2)))))-1/46332.
    coneq[919]=dot(b,dot(A,dot(A,c*dot(A,c**5*dot(A,dot(A,c))))))-1/92664.
    coneq[920]=dot(b,dot(A,dot(A,c*dot(A,c**6*dot(A,c)))))-1/30888.
    coneq[921]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3)*dot(A,c**3)))))-1/247104.
    coneq[922]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3)*dot(A,dot(A,c**2))))))-1/741312.
    coneq[923]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c)))))))-1/1482624.
    coneq[924]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**3)*dot(A,c*dot(A,c))))))-1/494208.
    coneq[925]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))))))-1/2223936.
    coneq[926]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)))))))-1/4447872.
    coneq[927]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c))))))-1/1482624.
    coneq[928]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))))))-1/8895744.
    coneq[929]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c))))))-1/2965248.
    coneq[930]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))))))-1/988416.
    coneq[931]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**4)))))-1/231660.
    coneq[932]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c**3))))))-1/926640.
    coneq[933]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2)))))))-1/2779920.
    coneq[934]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/5559840.
    coneq[935]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c)))))))-1/1853280.
    coneq[936]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2))))))-1/694980.
    coneq[937]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c)))))))-1/1389960.
    coneq[938]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c))))))-1/463320.
    coneq[939]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c))))))-1/926640.
    coneq[940]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**4)))))-1/463320.
    coneq[941]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3))))))-1/1853280.
    coneq[942]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)))))))-1/5559840.
    coneq[943]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))))-1/11119680.
    coneq[944]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)))))))-1/3706560.
    coneq[945]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2))))))-1/1389960.
    coneq[946]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)))))))-1/2779920.
    coneq[947]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c))))))-1/926640.
    coneq[948]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c))))))-1/1853280.
    coneq[949]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**5)))))-1/185328.
    coneq[950]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**4))))))-1/926640.
    coneq[951]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3)))))))-1/3706560.
    coneq[952]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/11119680.
    coneq[953]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/22239360.
    coneq[954]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/7413120.
    coneq[955]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2)))))))-1/2779920.
    coneq[956]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/5559840.
    coneq[957]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c)))))))-1/1853280.
    coneq[958]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/3706560.
    coneq[959]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c**3))))))-1/741312.
    coneq[960]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2)))))))-1/2223936.
    coneq[961]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/4447872.
    coneq[962]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c)))))))-1/1482624.
    coneq[963]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2))))))-1/555984.
    coneq[964]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c)))))))-1/1111968.
    coneq[965]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**3*dot(A,c))))))-1/370656.
    coneq[966]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2))))))-1/1111968.
    coneq[967]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/2223936.
    coneq[968]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c))))))-1/741312.
    coneq[969]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c**3)))))-1/185328.
    coneq[970]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2))))))-1/555984.
    coneq[971]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/1111968.
    coneq[972]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c))))))-1/370656.
    coneq[973]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,c**3)))))-1/370656.
    coneq[974]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/1111968.
    coneq[975]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/2223936.
    coneq[976]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/741312.
    coneq[977]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**4)))))-1/154440.
    coneq[978]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c**3))))))-1/617760.
    coneq[979]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/1853280.
    coneq[980]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/3706560.
    coneq[981]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/1235520.
    coneq[982]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2))))))-1/463320.
    coneq[983]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/926640.
    coneq[984]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c))))))-1/308880.
    coneq[985]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/617760.
    coneq[986]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2)*dot(A,c**2)))))-1/138996.
    coneq[987]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c))))))-1/277992.
    coneq[988]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/555984.
    coneq[989]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c**3)))))-1/123552.
    coneq[990]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2))))))-1/370656.
    coneq[991]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/741312.
    coneq[992]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c))))))-1/247104.
    coneq[993]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,c**2)))))-1/92664.
    coneq[994]=dot(b,dot(A,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,dot(A,c))))))-1/185328.
    coneq[995]=dot(b,dot(A,dot(A,c*dot(A,c**4*dot(A,c)*dot(A,c)))))-1/61776.
    coneq[996]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c**3)))))-1/247104.
    coneq[997]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2))))))-1/741312.
    coneq[998]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/1482624.
    coneq[999]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c))))))-1/494208.
    coneq[1000]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2)))))-1/277992.
    coneq[1001]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c))))))-1/555984.
    coneq[1002]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/1111968.
    coneq[1003]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/185328.
    coneq[1004]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/370656.
    coneq[1005]=dot(b,dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c)))))-1/123552.
    coneq[1006]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)))))-1/247104.
    coneq[1007]=dot(b,dot(A,dot(A,c**2*dot(A,c**7))))-1/13728.
    coneq[1008]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**6)))))-1/96096.
    coneq[1009]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**5))))))-1/576576.
    coneq[1010]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**4)))))))-1/2882880.
    coneq[1011]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/11531520.
    coneq[1012]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/34594560.
    coneq[1013]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/69189120.
    coneq[1014]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/23063040.
    coneq[1015]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/8648640.
    coneq[1016]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/17297280.
    coneq[1017]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/5765760.
    coneq[1018]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/11531520.
    coneq[1019]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c**3)))))))-1/2306304.
    coneq[1020]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/6918912.
    coneq[1021]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/13837824.
    coneq[1022]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/4612608.
    coneq[1023]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))))-1/1729728.
    coneq[1024]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/3459456.
    coneq[1025]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**3*dot(A,c)))))))-1/1153152.
    coneq[1026]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/3459456.
    coneq[1027]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/6918912.
    coneq[1028]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/2306304.
    coneq[1029]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c**4))))))-1/480480.
    coneq[1030]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c**3)))))))-1/1921920.
    coneq[1031]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/5765760.
    coneq[1032]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/11531520.
    coneq[1033]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/3843840.
    coneq[1034]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))))-1/1441440.
    coneq[1035]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/2882880.
    coneq[1036]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))))-1/960960.
    coneq[1037]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/1921920.
    coneq[1038]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c**3))))))-1/384384.
    coneq[1039]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))))-1/1153152.
    coneq[1040]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/2306304.
    coneq[1041]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))))-1/768768.
    coneq[1042]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**3*dot(A,c**2))))))-1/288288.
    coneq[1043]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**3*dot(A,dot(A,c)))))))-1/576576.
    coneq[1044]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**4*dot(A,c))))))-1/192192.
    coneq[1045]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))))-1/864864.
    coneq[1046]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/1729728.
    coneq[1047]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/3459456.
    coneq[1048]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c**3))))))-1/768768.
    coneq[1049]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/2306304.
    coneq[1050]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/4612608.
    coneq[1051]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/1537536.
    coneq[1052]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))))-1/576576.
    coneq[1053]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/1153152.
    coneq[1054]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))))-1/384384.
    coneq[1055]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/768768.
    coneq[1056]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**5)))))-1/82368.
    coneq[1057]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c**4))))))-1/411840.
    coneq[1058]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c**3)))))))-1/1647360.
    coneq[1059]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/4942080.
    coneq[1060]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/9884160.
    coneq[1061]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/3294720.
    coneq[1062]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))))-1/1235520.
    coneq[1063]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/2471040.
    coneq[1064]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))))-1/823680.
    coneq[1065]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1647360.
    coneq[1066]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c**3))))))-1/329472.
    coneq[1067]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))))-1/988416.
    coneq[1068]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1976832.
    coneq[1069]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))))-1/658944.
    coneq[1070]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,c**2))))))-1/247104.
    coneq[1071]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))))-1/494208.
    coneq[1072]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**3*dot(A,c))))))-1/164736.
    coneq[1073]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))))-1/494208.
    coneq[1074]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/988416.
    coneq[1075]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))))-1/329472.
    coneq[1076]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c**4)))))-1/68640.
    coneq[1077]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c**3))))))-1/274560.
    coneq[1078]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))))-1/823680.
    coneq[1079]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1647360.
    coneq[1080]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))))-1/549120.
    coneq[1081]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,c**2))))))-1/205920.
    coneq[1082]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))))-1/411840.
    coneq[1083]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c**2*dot(A,c))))))-1/137280.
    coneq[1084]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))))-1/274560.
    coneq[1085]=dot(b,dot(A,dot(A,c**2*dot(A,c**3*dot(A,c**3)))))-1/54912.
    coneq[1086]=dot(b,dot(A,dot(A,c**2*dot(A,c**3*dot(A,dot(A,c**2))))))-1/164736.
    coneq[1087]=dot(b,dot(A,dot(A,c**2*dot(A,c**3*dot(A,dot(A,dot(A,c)))))))-1/329472.
    coneq[1088]=dot(b,dot(A,dot(A,c**2*dot(A,c**3*dot(A,c*dot(A,c))))))-1/109824.
    coneq[1089]=dot(b,dot(A,dot(A,c**2*dot(A,c**4*dot(A,c**2)))))-1/41184.
    coneq[1090]=dot(b,dot(A,dot(A,c**2*dot(A,c**4*dot(A,dot(A,c))))))-1/82368.
    coneq[1091]=dot(b,dot(A,dot(A,c**2*dot(A,c**5*dot(A,c)))))-1/27456.
    coneq[1092]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c**3)))))-1/164736.
    coneq[1093]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))))-1/494208.
    coneq[1094]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/988416.
    coneq[1095]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))))-1/329472.
    coneq[1096]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,c**3)))))-1/329472.
    coneq[1097]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/988416.
    coneq[1098]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/1976832.
    coneq[1099]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/658944.
    coneq[1100]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**4)))))-1/137280.
    coneq[1101]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c**3))))))-1/549120.
    coneq[1102]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/1647360.
    coneq[1103]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/3294720.
    coneq[1104]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/1098240.
    coneq[1105]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))))-1/411840.
    coneq[1106]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/823680.
    coneq[1107]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))))-1/274560.
    coneq[1108]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/549120.
    coneq[1109]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2)*dot(A,c**2)))))-1/123552.
    coneq[1110]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))))-1/247104.
    coneq[1111]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/494208.
    coneq[1112]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c**3)))))-1/109824.
    coneq[1113]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))))-1/329472.
    coneq[1114]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/658944.
    coneq[1115]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))))-1/219648.
    coneq[1116]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,c**2)))))-1/82368.
    coneq[1117]=dot(b,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))))-1/164736.
    coneq[1118]=dot(b,dot(A,dot(A,c**2*dot(A,c**3*dot(A,c)*dot(A,c)))))-1/54912.
    coneq[1119]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/164736.
    coneq[1120]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/329472.
    coneq[1121]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))))-1/109824.
    coneq[1122]=dot(b,dot(A,dot(A,c**3*dot(A,c**6))))-1/12012.
    coneq[1123]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**5)))))-1/72072.
    coneq[1124]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c**4))))))-1/360360.
    coneq[1125]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/1441440.
    coneq[1126]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/4324320.
    coneq[1127]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/8648640.
    coneq[1128]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/2882880.
    coneq[1129]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/1081080.
    coneq[1130]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/2162160.
    coneq[1131]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/720720.
    coneq[1132]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1441440.
    coneq[1133]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,c**3))))))-1/288288.
    coneq[1134]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/864864.
    coneq[1135]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1729728.
    coneq[1136]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/576576.
    coneq[1137]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**2*dot(A,c**2))))))-1/216216.
    coneq[1138]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/432432.
    coneq[1139]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**3*dot(A,c))))))-1/144144.
    coneq[1140]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/432432.
    coneq[1141]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/864864.
    coneq[1142]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/288288.
    coneq[1143]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c**4)))))-1/60060.
    coneq[1144]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,c**3))))))-1/240240.
    coneq[1145]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/720720.
    coneq[1146]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1441440.
    coneq[1147]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/480480.
    coneq[1148]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c*dot(A,c**2))))))-1/180180.
    coneq[1149]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/360360.
    coneq[1150]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c**2*dot(A,c))))))-1/120120.
    coneq[1151]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/240240.
    coneq[1152]=dot(b,dot(A,dot(A,c**3*dot(A,c**2*dot(A,c**3)))))-1/48048.
    coneq[1153]=dot(b,dot(A,dot(A,c**3*dot(A,c**2*dot(A,dot(A,c**2))))))-1/144144.
    coneq[1154]=dot(b,dot(A,dot(A,c**3*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/288288.
    coneq[1155]=dot(b,dot(A,dot(A,c**3*dot(A,c**2*dot(A,c*dot(A,c))))))-1/96096.
    coneq[1156]=dot(b,dot(A,dot(A,c**3*dot(A,c**3*dot(A,c**2)))))-1/36036.
    coneq[1157]=dot(b,dot(A,dot(A,c**3*dot(A,c**3*dot(A,dot(A,c))))))-1/72072.
    coneq[1158]=dot(b,dot(A,dot(A,c**3*dot(A,c**4*dot(A,c)))))-1/24024.
    coneq[1159]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/108108.
    coneq[1160]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/216216.
    coneq[1161]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/432432.
    coneq[1162]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,c**3)))))-1/96096.
    coneq[1163]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/288288.
    coneq[1164]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/576576.
    coneq[1165]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/192192.
    coneq[1166]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/72072.
    coneq[1167]=dot(b,dot(A,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/144144.
    coneq[1168]=dot(b,dot(A,dot(A,c**3*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/48048.
    coneq[1169]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/96096.
    coneq[1170]=dot(b,dot(A,dot(A,c**4*dot(A,c**5))))-1/10296.
    coneq[1171]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c**4)))))-1/51480.
    coneq[1172]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,c**3))))))-1/205920.
    coneq[1173]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/617760.
    coneq[1174]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1235520.
    coneq[1175]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/411840.
    coneq[1176]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c*dot(A,c**2))))))-1/154440.
    coneq[1177]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/308880.
    coneq[1178]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c**2*dot(A,c))))))-1/102960.
    coneq[1179]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/205920.
    coneq[1180]=dot(b,dot(A,dot(A,c**4*dot(A,c*dot(A,c**3)))))-1/41184.
    coneq[1181]=dot(b,dot(A,dot(A,c**4*dot(A,c*dot(A,dot(A,c**2))))))-1/123552.
    coneq[1182]=dot(b,dot(A,dot(A,c**4*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/247104.
    coneq[1183]=dot(b,dot(A,dot(A,c**4*dot(A,c*dot(A,c*dot(A,c))))))-1/82368.
    coneq[1184]=dot(b,dot(A,dot(A,c**4*dot(A,c**2*dot(A,c**2)))))-1/30888.
    coneq[1185]=dot(b,dot(A,dot(A,c**4*dot(A,c**2*dot(A,dot(A,c))))))-1/61776.
    coneq[1186]=dot(b,dot(A,dot(A,c**4*dot(A,c**3*dot(A,c)))))-1/20592.
    coneq[1187]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c)*dot(A,c**2)))))-1/61776.
    coneq[1188]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/123552.
    coneq[1189]=dot(b,dot(A,dot(A,c**4*dot(A,c*dot(A,c)*dot(A,c)))))-1/41184.
    coneq[1190]=dot(b,dot(A,dot(A,c**5*dot(A,c**4))))-1/8580.
    coneq[1191]=dot(b,dot(A,dot(A,c**5*dot(A,dot(A,c**3)))))-1/34320.
    coneq[1192]=dot(b,dot(A,dot(A,c**5*dot(A,dot(A,dot(A,c**2))))))-1/102960.
    coneq[1193]=dot(b,dot(A,dot(A,c**5*dot(A,dot(A,dot(A,dot(A,c)))))))-1/205920.
    coneq[1194]=dot(b,dot(A,dot(A,c**5*dot(A,dot(A,c*dot(A,c))))))-1/68640.
    coneq[1195]=dot(b,dot(A,dot(A,c**5*dot(A,c*dot(A,c**2)))))-1/25740.
    coneq[1196]=dot(b,dot(A,dot(A,c**5*dot(A,c*dot(A,dot(A,c))))))-1/51480.
    coneq[1197]=dot(b,dot(A,dot(A,c**5*dot(A,c**2*dot(A,c)))))-1/17160.
    coneq[1198]=dot(b,dot(A,dot(A,c**5*dot(A,dot(A,c)*dot(A,c)))))-1/34320.
    coneq[1199]=dot(b,dot(A,dot(A,c**6*dot(A,c**3))))-1/6864.
    coneq[1200]=dot(b,dot(A,dot(A,c**6*dot(A,dot(A,c**2)))))-1/20592.
    coneq[1201]=dot(b,dot(A,dot(A,c**6*dot(A,dot(A,dot(A,c))))))-1/41184.
    coneq[1202]=dot(b,dot(A,dot(A,c**6*dot(A,c*dot(A,c)))))-1/13728.
    coneq[1203]=dot(b,dot(A,dot(A,c**7*dot(A,c**2))))-1/5148.
    coneq[1204]=dot(b,dot(A,dot(A,c**7*dot(A,dot(A,c)))))-1/10296.
    coneq[1205]=dot(b,dot(A,dot(A,c**8*dot(A,c))))-1/3432.
    coneq[1206]=dot(b,dot(A,dot(A,dot(A,c**4)*dot(A,c**4))))-1/42900.
    coneq[1207]=dot(b,dot(A,dot(A,dot(A,c**4)*dot(A,dot(A,c**3)))))-1/171600.
    coneq[1208]=dot(b,dot(A,dot(A,dot(A,c**4)*dot(A,dot(A,dot(A,c**2))))))-1/514800.
    coneq[1209]=dot(b,dot(A,dot(A,dot(A,c**4)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1029600.
    coneq[1210]=dot(b,dot(A,dot(A,dot(A,c**4)*dot(A,dot(A,c*dot(A,c))))))-1/343200.
    coneq[1211]=dot(b,dot(A,dot(A,dot(A,c**4)*dot(A,c*dot(A,c**2)))))-1/128700.
    coneq[1212]=dot(b,dot(A,dot(A,dot(A,c**4)*dot(A,c*dot(A,dot(A,c))))))-1/257400.
    coneq[1213]=dot(b,dot(A,dot(A,dot(A,c**4)*dot(A,c**2*dot(A,c)))))-1/85800.
    coneq[1214]=dot(b,dot(A,dot(A,dot(A,c**4)*dot(A,dot(A,c)*dot(A,c)))))-1/171600.
    coneq[1215]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c**3)))))-1/686400.
    coneq[1216]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,c**2))))))-1/2059200.
    coneq[1217]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/4118400.
    coneq[1218]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c*dot(A,c))))))-1/1372800.
    coneq[1219]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))*dot(A,c*dot(A,c**2)))))-1/514800.
    coneq[1220]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))*dot(A,c*dot(A,dot(A,c))))))-1/1029600.
    coneq[1221]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))*dot(A,c**2*dot(A,c)))))-1/343200.
    coneq[1222]=dot(b,dot(A,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c)*dot(A,c)))))-1/686400.
    coneq[1223]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c**2))))))-1/6177600.
    coneq[1224]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/12355200.
    coneq[1225]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c*dot(A,c))))))-1/4118400.
    coneq[1226]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,c**2)))))-1/1544400.
    coneq[1227]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,dot(A,c))))))-1/3088800.
    coneq[1228]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2*dot(A,c)))))-1/1029600.
    coneq[1229]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c)*dot(A,c)))))-1/2059200.
    coneq[1230]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/24710400.
    coneq[1231]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c*dot(A,c))))))-1/8236800.
    coneq[1232]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c**2)))))-1/3088800.
    coneq[1233]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,dot(A,c))))))-1/6177600.
    coneq[1234]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2*dot(A,c)))))-1/2059200.
    coneq[1235]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)*dot(A,c)))))-1/4118400.
    coneq[1236]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c*dot(A,c))))))-1/2745600.
    coneq[1237]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,c**2)))))-1/1029600.
    coneq[1238]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,dot(A,c))))))-1/2059200.
    coneq[1239]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2*dot(A,c)))))-1/686400.
    coneq[1240]=dot(b,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))))-1/1372800.
    coneq[1241]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c**2)))))-1/386100.
    coneq[1242]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,dot(A,c))))))-1/772200.
    coneq[1243]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))*dot(A,c**2*dot(A,c)))))-1/257400.
    coneq[1244]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,c)*dot(A,c)))))-1/514800.
    coneq[1245]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c))))))-1/1544400.
    coneq[1246]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2*dot(A,c)))))-1/514800.
    coneq[1247]=dot(b,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))))-1/1029600.
    coneq[1248]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))*dot(A,c**2*dot(A,c)))))-1/171600.
    coneq[1249]=dot(b,dot(A,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/343200.
    coneq[1250]=dot(b,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/686400.
    coneq[1251]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c**5))))-1/41184.
    coneq[1252]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c**4)))))-1/205920.
    coneq[1253]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c**3))))))-1/823680.
    coneq[1254]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/2471040.
    coneq[1255]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/4942080.
    coneq[1256]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/1647360.
    coneq[1257]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,c**2))))))-1/617760.
    coneq[1258]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/1235520.
    coneq[1259]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c**2*dot(A,c))))))-1/411840.
    coneq[1260]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/823680.
    coneq[1261]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,c**3)))))-1/164736.
    coneq[1262]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,c**2))))))-1/494208.
    coneq[1263]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/988416.
    coneq[1264]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,c*dot(A,c))))))-1/329472.
    coneq[1265]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,c**2)))))-1/123552.
    coneq[1266]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,dot(A,c))))))-1/247104.
    coneq[1267]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c**3*dot(A,c)))))-1/82368.
    coneq[1268]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,c**2)))))-1/247104.
    coneq[1269]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/494208.
    coneq[1270]=dot(b,dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,c)*dot(A,c)))))-1/164736.
    coneq[1271]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c**5))))-1/123552.
    coneq[1272]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**4)))))-1/617760.
    coneq[1273]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**3))))))-1/2471040.
    coneq[1274]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/7413120.
    coneq[1275]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/14826240.
    coneq[1276]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/4942080.
    coneq[1277]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c**2))))))-1/1853280.
    coneq[1278]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/3706560.
    coneq[1279]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2*dot(A,c))))))-1/1235520.
    coneq[1280]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/2471040.
    coneq[1281]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c**3)))))-1/494208.
    coneq[1282]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c**2))))))-1/1482624.
    coneq[1283]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/2965248.
    coneq[1284]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c*dot(A,c))))))-1/988416.
    coneq[1285]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c**2)))))-1/370656.
    coneq[1286]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,dot(A,c))))))-1/741312.
    coneq[1287]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c**3*dot(A,c)))))-1/247104.
    coneq[1288]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c**2)))))-1/741312.
    coneq[1289]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/1482624.
    coneq[1290]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)*dot(A,c)))))-1/494208.
    coneq[1291]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**5))))-1/247104.
    coneq[1292]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**4)))))-1/1235520.
    coneq[1293]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**3))))))-1/4942080.
    coneq[1294]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/14826240.
    coneq[1295]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/29652480.
    coneq[1296]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/9884160.
    coneq[1297]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c**2))))))-1/3706560.
    coneq[1298]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/7413120.
    coneq[1299]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2*dot(A,c))))))-1/2471040.
    coneq[1300]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/4942080.
    coneq[1301]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**3)))))-1/988416.
    coneq[1302]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c**2))))))-1/2965248.
    coneq[1303]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/5930496.
    coneq[1304]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c*dot(A,c))))))-1/1976832.
    coneq[1305]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c**2)))))-1/741312.
    coneq[1306]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,dot(A,c))))))-1/1482624.
    coneq[1307]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**3*dot(A,c)))))-1/494208.
    coneq[1308]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c**2)))))-1/1482624.
    coneq[1309]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/2965248.
    coneq[1310]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)*dot(A,c)))))-1/988416.
    coneq[1311]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c**5))))-1/82368.
    coneq[1312]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**4)))))-1/411840.
    coneq[1313]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**3))))))-1/1647360.
    coneq[1314]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/4942080.
    coneq[1315]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/9884160.
    coneq[1316]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/3294720.
    coneq[1317]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c**2))))))-1/1235520.
    coneq[1318]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/2471040.
    coneq[1319]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**2*dot(A,c))))))-1/823680.
    coneq[1320]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/1647360.
    coneq[1321]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c**3)))))-1/329472.
    coneq[1322]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c**2))))))-1/988416.
    coneq[1323]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/1976832.
    coneq[1324]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c*dot(A,c))))))-1/658944.
    coneq[1325]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c**2)))))-1/247104.
    coneq[1326]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,dot(A,c))))))-1/494208.
    coneq[1327]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c**3*dot(A,c)))))-1/164736.
    coneq[1328]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c**2)))))-1/494208.
    coneq[1329]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/988416.
    coneq[1330]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)*dot(A,c)))))-1/329472.
    coneq[1331]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**6))))-1/36036.
    coneq[1332]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**5)))))-1/216216.
    coneq[1333]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**4))))))-1/1081080.
    coneq[1334]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/4324320.
    coneq[1335]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/12972960.
    coneq[1336]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/25945920.
    coneq[1337]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/8648640.
    coneq[1338]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/3243240.
    coneq[1339]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/6486480.
    coneq[1340]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/2162160.
    coneq[1341]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/4324320.
    coneq[1342]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c**3))))))-1/864864.
    coneq[1343]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/2594592.
    coneq[1344]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/5189184.
    coneq[1345]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/1729728.
    coneq[1346]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c**2))))))-1/648648.
    coneq[1347]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/1297296.
    coneq[1348]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**3*dot(A,c))))))-1/432432.
    coneq[1349]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/1297296.
    coneq[1350]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/2594592.
    coneq[1351]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/864864.
    coneq[1352]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**4)))))-1/180180.
    coneq[1353]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c**3))))))-1/720720.
    coneq[1354]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/2162160.
    coneq[1355]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/4324320.
    coneq[1356]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/1441440.
    coneq[1357]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c**2))))))-1/540540.
    coneq[1358]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/1081080.
    coneq[1359]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2*dot(A,c))))))-1/360360.
    coneq[1360]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/720720.
    coneq[1361]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c**3)))))-1/144144.
    coneq[1362]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c**2))))))-1/432432.
    coneq[1363]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/864864.
    coneq[1364]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c*dot(A,c))))))-1/288288.
    coneq[1365]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,c**2)))))-1/108108.
    coneq[1366]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,dot(A,c))))))-1/216216.
    coneq[1367]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**4*dot(A,c)))))-1/72072.
    coneq[1368]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/324324.
    coneq[1369]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/648648.
    coneq[1370]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/1297296.
    coneq[1371]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**3)))))-1/288288.
    coneq[1372]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/864864.
    coneq[1373]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/1729728.
    coneq[1374]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/576576.
    coneq[1375]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/216216.
    coneq[1376]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/432432.
    coneq[1377]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/144144.
    coneq[1378]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/288288.
    coneq[1379]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**6))))-1/72072.
    coneq[1380]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**5)))))-1/432432.
    coneq[1381]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**4))))))-1/2162160.
    coneq[1382]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/8648640.
    coneq[1383]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/25945920.
    coneq[1384]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/51891840.
    coneq[1385]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/17297280.
    coneq[1386]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/6486480.
    coneq[1387]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/12972960.
    coneq[1388]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/4324320.
    coneq[1389]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/8648640.
    coneq[1390]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**3))))))-1/1729728.
    coneq[1391]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/5189184.
    coneq[1392]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/10378368.
    coneq[1393]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/3459456.
    coneq[1394]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c**2))))))-1/1297296.
    coneq[1395]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/2594592.
    coneq[1396]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3*dot(A,c))))))-1/864864.
    coneq[1397]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/2594592.
    coneq[1398]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/5189184.
    coneq[1399]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/1729728.
    coneq[1400]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**4)))))-1/360360.
    coneq[1401]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**3))))))-1/1441440.
    coneq[1402]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/4324320.
    coneq[1403]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/8648640.
    coneq[1404]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/2882880.
    coneq[1405]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c**2))))))-1/1081080.
    coneq[1406]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/2162160.
    coneq[1407]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2*dot(A,c))))))-1/720720.
    coneq[1408]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/1441440.
    coneq[1409]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c**3)))))-1/288288.
    coneq[1410]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c**2))))))-1/864864.
    coneq[1411]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/1729728.
    coneq[1412]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c*dot(A,c))))))-1/576576.
    coneq[1413]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,c**2)))))-1/216216.
    coneq[1414]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,dot(A,c))))))-1/432432.
    coneq[1415]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**4*dot(A,c)))))-1/144144.
    coneq[1416]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/648648.
    coneq[1417]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/1297296.
    coneq[1418]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/2594592.
    coneq[1419]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**3)))))-1/576576.
    coneq[1420]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/1729728.
    coneq[1421]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/3459456.
    coneq[1422]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/1153152.
    coneq[1423]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/432432.
    coneq[1424]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/864864.
    coneq[1425]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/288288.
    coneq[1426]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/576576.
    coneq[1427]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**7))))-1/27456.
    coneq[1428]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**6)))))-1/192192.
    coneq[1429]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**5))))))-1/1153152.
    coneq[1430]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**4)))))))-1/5765760.
    coneq[1431]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/23063040.
    coneq[1432]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/69189120.
    coneq[1433]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/138378240.
    coneq[1434]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/46126080.
    coneq[1435]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/17297280.
    coneq[1436]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/34594560.
    coneq[1437]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/11531520.
    coneq[1438]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/23063040.
    coneq[1439]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**3)))))))-1/4612608.
    coneq[1440]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/13837824.
    coneq[1441]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/27675648.
    coneq[1442]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/9225216.
    coneq[1443]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))))-1/3459456.
    coneq[1444]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/6918912.
    coneq[1445]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3*dot(A,c)))))))-1/2306304.
    coneq[1446]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/6918912.
    coneq[1447]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/13837824.
    coneq[1448]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/4612608.
    coneq[1449]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**4))))))-1/960960.
    coneq[1450]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**3)))))))-1/3843840.
    coneq[1451]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/11531520.
    coneq[1452]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/23063040.
    coneq[1453]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/7687680.
    coneq[1454]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))))-1/2882880.
    coneq[1455]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/5765760.
    coneq[1456]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))))-1/1921920.
    coneq[1457]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/3843840.
    coneq[1458]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c**3))))))-1/768768.
    coneq[1459]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))))-1/2306304.
    coneq[1460]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/4612608.
    coneq[1461]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))))-1/1537536.
    coneq[1462]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,c**2))))))-1/576576.
    coneq[1463]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,dot(A,c)))))))-1/1153152.
    coneq[1464]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**4*dot(A,c))))))-1/384384.
    coneq[1465]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))))-1/1729728.
    coneq[1466]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/3459456.
    coneq[1467]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/6918912.
    coneq[1468]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**3))))))-1/1537536.
    coneq[1469]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/4612608.
    coneq[1470]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/9225216.
    coneq[1471]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/3075072.
    coneq[1472]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))))-1/1153152.
    coneq[1473]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/2306304.
    coneq[1474]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))))-1/768768.
    coneq[1475]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/1537536.
    coneq[1476]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**5)))))-1/164736.
    coneq[1477]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**4))))))-1/823680.
    coneq[1478]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**3)))))))-1/3294720.
    coneq[1479]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/9884160.
    coneq[1480]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/19768320.
    coneq[1481]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/6589440.
    coneq[1482]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))))-1/2471040.
    coneq[1483]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/4942080.
    coneq[1484]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))))-1/1647360.
    coneq[1485]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/3294720.
    coneq[1486]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c**3))))))-1/658944.
    coneq[1487]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))))-1/1976832.
    coneq[1488]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/3953664.
    coneq[1489]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))))-1/1317888.
    coneq[1490]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c**2))))))-1/494208.
    coneq[1491]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))))-1/988416.
    coneq[1492]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**3*dot(A,c))))))-1/329472.
    coneq[1493]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))))-1/988416.
    coneq[1494]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1976832.
    coneq[1495]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))))-1/658944.
    coneq[1496]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**4)))))-1/137280.
    coneq[1497]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c**3))))))-1/549120.
    coneq[1498]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))))-1/1647360.
    coneq[1499]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))))-1/3294720.
    coneq[1500]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))))-1/1098240.
    coneq[1501]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c**2))))))-1/411840.
    coneq[1502]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))))-1/823680.
    coneq[1503]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2*dot(A,c))))))-1/274560.
    coneq[1504]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))))-1/549120.
    coneq[1505]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,c**3)))))-1/109824.
    coneq[1506]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,c**2))))))-1/329472.
    coneq[1507]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,dot(A,c)))))))-1/658944.
    coneq[1508]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,c*dot(A,c))))))-1/219648.
    coneq[1509]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**4*dot(A,c**2)))))-1/82368.
    coneq[1510]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**4*dot(A,dot(A,c))))))-1/164736.
    coneq[1511]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**5*dot(A,c)))))-1/54912.
    coneq[1512]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**3)))))-1/329472.
    coneq[1513]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))))-1/988416.
    coneq[1514]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/1976832.
    coneq[1515]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))))-1/658944.
    coneq[1516]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,c**3)))))-1/658944.
    coneq[1517]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/1976832.
    coneq[1518]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/3953664.
    coneq[1519]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/1317888.
    coneq[1520]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**4)))))-1/274560.
    coneq[1521]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**3))))))-1/1098240.
    coneq[1522]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/3294720.
    coneq[1523]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/6589440.
    coneq[1524]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/2196480.
    coneq[1525]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))))-1/823680.
    coneq[1526]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/1647360.
    coneq[1527]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))))-1/549120.
    coneq[1528]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/1098240.
    coneq[1529]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)*dot(A,c**2)))))-1/247104.
    coneq[1530]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))))-1/494208.
    coneq[1531]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/988416.
    coneq[1532]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**3)))))-1/219648.
    coneq[1533]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))))-1/658944.
    coneq[1534]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/1317888.
    coneq[1535]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))))-1/439296.
    coneq[1536]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c**2)))))-1/164736.
    coneq[1537]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))))-1/329472.
    coneq[1538]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,c)*dot(A,c)))))-1/109824.
    coneq[1539]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/329472.
    coneq[1540]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/658944.
    coneq[1541]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))))-1/219648.
    coneq[1542]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,c**4))))-1/34320.
    coneq[1543]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,dot(A,c**3)))))-1/137280.
    coneq[1544]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,c**2))))))-1/411840.
    coneq[1545]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/823680.
    coneq[1546]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,dot(A,c*dot(A,c))))))-1/274560.
    coneq[1547]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,c**2)))))-1/102960.
    coneq[1548]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,dot(A,c))))))-1/205920.
    coneq[1549]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,c**2*dot(A,c)))))-1/68640.
    coneq[1550]=dot(b,dot(A,dot(A,c*dot(A,c**3)*dot(A,dot(A,c)*dot(A,c)))))-1/137280.
    coneq[1551]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,c**4))))-1/102960.
    coneq[1552]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c**3)))))-1/411840.
    coneq[1553]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**2))))))-1/1235520.
    coneq[1554]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/2471040.
    coneq[1555]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c))))))-1/823680.
    coneq[1556]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,c**2)))))-1/308880.
    coneq[1557]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c))))))-1/617760.
    coneq[1558]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c)))))-1/205920.
    coneq[1559]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c)))))-1/411840.
    coneq[1560]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c**4))))-1/205920.
    coneq[1561]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**3)))))-1/823680.
    coneq[1562]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2))))))-1/2471040.
    coneq[1563]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/4942080.
    coneq[1564]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c))))))-1/1647360.
    coneq[1565]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**2)))))-1/617760.
    coneq[1566]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c))))))-1/1235520.
    coneq[1567]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c)))))-1/411840.
    coneq[1568]=dot(b,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))))-1/823680.
    coneq[1569]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,c**4))))-1/68640.
    coneq[1570]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c**3)))))-1/274560.
    coneq[1571]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/823680.
    coneq[1572]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1647360.
    coneq[1573]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/549120.
    coneq[1574]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,c**2)))))-1/205920.
    coneq[1575]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/411840.
    coneq[1576]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c)))))-1/137280.
    coneq[1577]=dot(b,dot(A,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/274560.
    coneq[1578]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**5))))-1/30888.
    coneq[1579]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**4)))))-1/154440.
    coneq[1580]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c**3))))))-1/617760.
    coneq[1581]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1853280.
    coneq[1582]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/3706560.
    coneq[1583]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/1235520.
    coneq[1584]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,c**2))))))-1/463320.
    coneq[1585]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/926640.
    coneq[1586]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c))))))-1/308880.
    coneq[1587]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/617760.
    coneq[1588]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c**3)))))-1/123552.
    coneq[1589]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,c**2))))))-1/370656.
    coneq[1590]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/741312.
    coneq[1591]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c))))))-1/247104.
    coneq[1592]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,c**2)))))-1/92664.
    coneq[1593]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c))))))-1/185328.
    coneq[1594]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**3*dot(A,c)))))-1/61776.
    coneq[1595]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**2)))))-1/185328.
    coneq[1596]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/370656.
    coneq[1597]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c)))))-1/123552.
    coneq[1598]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**5))))-1/61776.
    coneq[1599]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**4)))))-1/308880.
    coneq[1600]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**3))))))-1/1235520.
    coneq[1601]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/3706560.
    coneq[1602]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/7413120.
    coneq[1603]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/2471040.
    coneq[1604]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**2))))))-1/926640.
    coneq[1605]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/1853280.
    coneq[1606]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c))))))-1/617760.
    coneq[1607]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/1235520.
    coneq[1608]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c**3)))))-1/247104.
    coneq[1609]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**2))))))-1/741312.
    coneq[1610]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/1482624.
    coneq[1611]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c))))))-1/494208.
    coneq[1612]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,c**2)))))-1/185328.
    coneq[1613]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c))))))-1/370656.
    coneq[1614]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**3*dot(A,c)))))-1/123552.
    coneq[1615]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**2)))))-1/370656.
    coneq[1616]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/741312.
    coneq[1617]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c)))))-1/247104.
    coneq[1618]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**6))))-1/24024.
    coneq[1619]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**5)))))-1/144144.
    coneq[1620]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**4))))))-1/720720.
    coneq[1621]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/2882880.
    coneq[1622]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/8648640.
    coneq[1623]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/17297280.
    coneq[1624]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/5765760.
    coneq[1625]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/2162160.
    coneq[1626]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/4324320.
    coneq[1627]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/1441440.
    coneq[1628]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/2882880.
    coneq[1629]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c**3))))))-1/576576.
    coneq[1630]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/1729728.
    coneq[1631]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/3459456.
    coneq[1632]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/1153152.
    coneq[1633]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,c**2))))))-1/432432.
    coneq[1634]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/864864.
    coneq[1635]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**3*dot(A,c))))))-1/288288.
    coneq[1636]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/864864.
    coneq[1637]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1729728.
    coneq[1638]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/576576.
    coneq[1639]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**4)))))-1/120120.
    coneq[1640]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c**3))))))-1/480480.
    coneq[1641]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/1441440.
    coneq[1642]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2882880.
    coneq[1643]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/960960.
    coneq[1644]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,c**2))))))-1/360360.
    coneq[1645]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/720720.
    coneq[1646]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c))))))-1/240240.
    coneq[1647]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/480480.
    coneq[1648]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c**3)))))-1/96096.
    coneq[1649]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,c**2))))))-1/288288.
    coneq[1650]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/576576.
    coneq[1651]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c))))))-1/192192.
    coneq[1652]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,c**2)))))-1/72072.
    coneq[1653]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,dot(A,c))))))-1/144144.
    coneq[1654]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**4*dot(A,c)))))-1/48048.
    coneq[1655]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/216216.
    coneq[1656]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/432432.
    coneq[1657]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/864864.
    coneq[1658]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c**3)))))-1/192192.
    coneq[1659]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/576576.
    coneq[1660]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/1153152.
    coneq[1661]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/384384.
    coneq[1662]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/144144.
    coneq[1663]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/288288.
    coneq[1664]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/96096.
    coneq[1665]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/192192.
    coneq[1666]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)*dot(A,c**3))))-1/27456.
    coneq[1667]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)*dot(A,dot(A,c**2)))))-1/82368.
    coneq[1668]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)*dot(A,dot(A,dot(A,c))))))-1/164736.
    coneq[1669]=dot(b,dot(A,dot(A,c**2*dot(A,c**3)*dot(A,c*dot(A,c)))))-1/54912.
    coneq[1670]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))))-1/247104.
    coneq[1671]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))))-1/494208.
    coneq[1672]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))))-1/164736.
    coneq[1673]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))))-1/988416.
    coneq[1674]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))))-1/329472.
    coneq[1675]=dot(b,dot(A,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))))-1/109824.
    coneq[1676]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c**4))))-1/25740.
    coneq[1677]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c**3)))))-1/102960.
    coneq[1678]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))))-1/308880.
    coneq[1679]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/617760.
    coneq[1680]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))))-1/205920.
    coneq[1681]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,c**2)))))-1/77220.
    coneq[1682]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))))-1/154440.
    coneq[1683]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c**2*dot(A,c)))))-1/51480.
    coneq[1684]=dot(b,dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))))-1/102960.
    coneq[1685]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**4))))-1/51480.
    coneq[1686]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c**3)))))-1/205920.
    coneq[1687]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/617760.
    coneq[1688]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1235520.
    coneq[1689]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/411840.
    coneq[1690]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))))-1/154440.
    coneq[1691]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/308880.
    coneq[1692]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))))-1/102960.
    coneq[1693]=dot(b,dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/205920.
    coneq[1694]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**5))))-1/20592.
    coneq[1695]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**4)))))-1/102960.
    coneq[1696]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c**3))))))-1/411840.
    coneq[1697]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1235520.
    coneq[1698]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/2471040.
    coneq[1699]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/823680.
    coneq[1700]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))))-1/308880.
    coneq[1701]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/617760.
    coneq[1702]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))))-1/205920.
    coneq[1703]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/411840.
    coneq[1704]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c**3)))))-1/82368.
    coneq[1705]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))))-1/247104.
    coneq[1706]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/494208.
    coneq[1707]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))))-1/164736.
    coneq[1708]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,c**2)))))-1/61776.
    coneq[1709]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))))-1/123552.
    coneq[1710]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**3*dot(A,c)))))-1/41184.
    coneq[1711]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))))-1/123552.
    coneq[1712]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/247104.
    coneq[1713]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))))-1/82368.
    coneq[1714]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)*dot(A,c**3))))-1/20592.
    coneq[1715]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/61776.
    coneq[1716]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/123552.
    coneq[1717]=dot(b,dot(A,dot(A,c**3*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/41184.
    coneq[1718]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))*dot(A,c**3))))-1/41184.
    coneq[1719]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/123552.
    coneq[1720]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/247104.
    coneq[1721]=dot(b,dot(A,dot(A,c**3*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/82368.
    coneq[1722]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c**4))))-1/17160.
    coneq[1723]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,c**3)))))-1/68640.
    coneq[1724]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/205920.
    coneq[1725]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/411840.
    coneq[1726]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/137280.
    coneq[1727]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c*dot(A,c**2)))))-1/51480.
    coneq[1728]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/102960.
    coneq[1729]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c**2*dot(A,c)))))-1/34320.
    coneq[1730]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/68640.
    coneq[1731]=dot(b,dot(A,dot(A,c**4*dot(A,c**2)*dot(A,c**2))))-1/15444.
    coneq[1732]=dot(b,dot(A,dot(A,c**4*dot(A,c**2)*dot(A,dot(A,c)))))-1/30888.
    coneq[1733]=dot(b,dot(A,dot(A,c**4*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/61776.
    coneq[1734]=dot(b,dot(A,dot(A,c**4*dot(A,c)*dot(A,c**3))))-1/13728.
    coneq[1735]=dot(b,dot(A,dot(A,c**4*dot(A,c)*dot(A,dot(A,c**2)))))-1/41184.
    coneq[1736]=dot(b,dot(A,dot(A,c**4*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/82368.
    coneq[1737]=dot(b,dot(A,dot(A,c**4*dot(A,c)*dot(A,c*dot(A,c)))))-1/27456.
    coneq[1738]=dot(b,dot(A,dot(A,c**5*dot(A,c)*dot(A,c**2))))-1/10296.
    coneq[1739]=dot(b,dot(A,dot(A,c**5*dot(A,c)*dot(A,dot(A,c)))))-1/20592.
    coneq[1740]=dot(b,dot(A,dot(A,c**6*dot(A,c)*dot(A,c))))-1/6864.
    coneq[1741]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**5))))-1/41184.
    coneq[1742]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**4)))))-1/205920.
    coneq[1743]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c**3))))))-1/823680.
    coneq[1744]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/2471040.
    coneq[1745]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/4942080.
    coneq[1746]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/1647360.
    coneq[1747]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))))-1/617760.
    coneq[1748]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/1235520.
    coneq[1749]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))))-1/411840.
    coneq[1750]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/823680.
    coneq[1751]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c**3)))))-1/164736.
    coneq[1752]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))))-1/494208.
    coneq[1753]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/988416.
    coneq[1754]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))))-1/329472.
    coneq[1755]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,c**2)))))-1/123552.
    coneq[1756]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))))-1/247104.
    coneq[1757]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3*dot(A,c)))))-1/82368.
    coneq[1758]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))))-1/247104.
    coneq[1759]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/494208.
    coneq[1760]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))))-1/164736.
    coneq[1761]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**4))))-1/51480.
    coneq[1762]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c**3)))))-1/205920.
    coneq[1763]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))))-1/617760.
    coneq[1764]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1235520.
    coneq[1765]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))))-1/411840.
    coneq[1766]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,c**2)))))-1/154440.
    coneq[1767]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))))-1/308880.
    coneq[1768]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2*dot(A,c)))))-1/102960.
    coneq[1769]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))))-1/205920.
    coneq[1770]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c**4))))-1/102960.
    coneq[1771]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c**3)))))-1/411840.
    coneq[1772]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/1235520.
    coneq[1773]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/2471040.
    coneq[1774]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/823680.
    coneq[1775]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))))-1/308880.
    coneq[1776]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/617760.
    coneq[1777]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))))-1/205920.
    coneq[1778]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/411840.
    coneq[1779]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,c**3))))-1/61776.
    coneq[1780]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/185328.
    coneq[1781]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/370656.
    coneq[1782]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/123552.
    coneq[1783]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,c**3))))-1/123552.
    coneq[1784]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/370656.
    coneq[1785]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/741312.
    coneq[1786]=dot(b,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/247104.
    coneq[1787]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c**3))))-1/247104.
    coneq[1788]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/741312.
    coneq[1789]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/1482624.
    coneq[1790]=dot(b,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/494208.
    coneq[1791]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)*dot(A,c**3))))-1/54912.
    coneq[1792]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)*dot(A,dot(A,c**2)))))-1/164736.
    coneq[1793]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)*dot(A,dot(A,dot(A,c))))))-1/329472.
    coneq[1794]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c**3)*dot(A,c*dot(A,c)))))-1/109824.
    coneq[1795]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))))-1/494208.
    coneq[1796]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))))-1/988416.
    coneq[1797]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))))-1/329472.
    coneq[1798]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))))-1/1976832.
    coneq[1799]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))))-1/658944.
    coneq[1800]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))))-1/219648.
    coneq[1801]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**4))))-1/34320.
    coneq[1802]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c**3)))))-1/137280.
    coneq[1803]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/411840.
    coneq[1804]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/823680.
    coneq[1805]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/274560.
    coneq[1806]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c**2)))))-1/102960.
    coneq[1807]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/205920.
    coneq[1808]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,c)))))-1/68640.
    coneq[1809]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/137280.
    coneq[1810]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,c**3))))-1/41184.
    coneq[1811]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/123552.
    coneq[1812]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/247104.
    coneq[1813]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/82368.
    coneq[1814]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,c**3))))-1/82368.
    coneq[1815]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/247104.
    coneq[1816]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/494208.
    coneq[1817]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/164736.
    coneq[1818]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2)*dot(A,c**2))))-1/46332.
    coneq[1819]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,c)))))-1/92664.
    coneq[1820]=dot(b,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/185328.
    coneq[1821]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/370656.
    coneq[1822]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c**3))))-1/27456.
    coneq[1823]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))))-1/82368.
    coneq[1824]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/164736.
    coneq[1825]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))))-1/54912.
    coneq[1826]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2)*dot(A,c**2))))-1/30888.
    coneq[1827]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))))-1/61776.
    coneq[1828]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/123552.
    coneq[1829]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c)*dot(A,c**2))))-1/20592.
    coneq[1830]=dot(b,dot(A,dot(A,c**3*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/41184.
    coneq[1831]=dot(b,dot(A,dot(A,c**4*dot(A,c)*dot(A,c)*dot(A,c))))-1/13728.
    coneq[1832]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c**3))))-1/54912.
    coneq[1833]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))))-1/164736.
    coneq[1834]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/329472.
    coneq[1835]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))))-1/109824.
    coneq[1836]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)*dot(A,c**2))))-1/61776.
    coneq[1837]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))))-1/123552.
    coneq[1838]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))*dot(A,c**2))))-1/123552.
    coneq[1839]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/247104.
    coneq[1840]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c**2))))-1/41184.
    coneq[1841]=dot(b,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/82368.
    coneq[1842]=dot(b,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))))-1/27456.
    coneq[1843]=dot(b,dot(A,c*dot(A,c**9)))-1/1560.
    coneq[1844]=dot(b,dot(A,c*dot(A,dot(A,c**8))))-1/14040.
    coneq[1845]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**7)))))-1/112320.
    coneq[1846]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**6))))))-1/786240.
    coneq[1847]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**5)))))))-1/4717440.
    coneq[1848]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**4))))))))-1/23587200.
    coneq[1849]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))))-1/94348800.
    coneq[1850]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))))-1/283046400.
    coneq[1851]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))))-1/566092800.
    coneq[1852]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))))-1/188697600.
    coneq[1853]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))))-1/70761600.
    coneq[1854]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))))-1/141523200.
    coneq[1855]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))))-1/47174400.
    coneq[1856]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))))-1/94348800.
    coneq[1857]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3))))))))-1/18869760.
    coneq[1858]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))))-1/56609280.
    coneq[1859]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))))-1/113218560.
    coneq[1860]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))))-1/37739520.
    coneq[1861]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))))-1/14152320.
    coneq[1862]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))))-1/28304640.
    coneq[1863]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c))))))))-1/9434880.
    coneq[1864]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))))-1/28304640.
    coneq[1865]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))))-1/56609280.
    coneq[1866]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))))-1/18869760.
    coneq[1867]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**4)))))))-1/3931200.
    coneq[1868]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3))))))))-1/15724800.
    coneq[1869]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))))-1/47174400.
    coneq[1870]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))))-1/94348800.
    coneq[1871]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))))-1/31449600.
    coneq[1872]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))))-1/11793600.
    coneq[1873]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))))-1/23587200.
    coneq[1874]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))))-1/7862400.
    coneq[1875]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))))-1/15724800.
    coneq[1876]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**3)))))))-1/3144960.
    coneq[1877]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))))-1/9434880.
    coneq[1878]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))))-1/18869760.
    coneq[1879]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))))-1/6289920.
    coneq[1880]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c**2)))))))-1/2358720.
    coneq[1881]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c))))))))-1/4717440.
    coneq[1882]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**4*dot(A,c)))))))-1/1572480.
    coneq[1883]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))))-1/7076160.
    coneq[1884]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))))-1/14152320.
    coneq[1885]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))))-1/28304640.
    coneq[1886]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3)))))))-1/6289920.
    coneq[1887]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))))-1/18869760.
    coneq[1888]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))))-1/37739520.
    coneq[1889]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))))-1/12579840.
    coneq[1890]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))))-1/4717440.
    coneq[1891]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))))-1/9434880.
    coneq[1892]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))))-1/3144960.
    coneq[1893]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))))-1/6289920.
    coneq[1894]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**5))))))-1/673920.
    coneq[1895]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**4)))))))-1/3369600.
    coneq[1896]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3))))))))-1/13478400.
    coneq[1897]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/40435200.
    coneq[1898]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/80870400.
    coneq[1899]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/26956800.
    coneq[1900]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))))-1/10108800.
    coneq[1901]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/20217600.
    coneq[1902]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))))-1/6739200.
    coneq[1903]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/13478400.
    coneq[1904]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**3)))))))-1/2695680.
    coneq[1905]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))))-1/8087040.
    coneq[1906]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/16174080.
    coneq[1907]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))))-1/5391360.
    coneq[1908]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c**2)))))))-1/2021760.
    coneq[1909]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))))-1/4043520.
    coneq[1910]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**3*dot(A,c)))))))-1/1347840.
    coneq[1911]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))))-1/4043520.
    coneq[1912]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/8087040.
    coneq[1913]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))))-1/2695680.
    coneq[1914]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c**4))))))-1/561600.
    coneq[1915]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**3)))))))-1/2246400.
    coneq[1916]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))))-1/6739200.
    coneq[1917]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/13478400.
    coneq[1918]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))))-1/4492800.
    coneq[1919]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c**2)))))))-1/1684800.
    coneq[1920]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))))-1/3369600.
    coneq[1921]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c**2*dot(A,c)))))))-1/1123200.
    coneq[1922]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))))-1/2246400.
    coneq[1923]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,c**3))))))-1/449280.
    coneq[1924]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c**2)))))))-1/1347840.
    coneq[1925]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c))))))))-1/2695680.
    coneq[1926]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,c*dot(A,c)))))))-1/898560.
    coneq[1927]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**4*dot(A,c**2))))))-1/336960.
    coneq[1928]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**4*dot(A,dot(A,c)))))))-1/673920.
    coneq[1929]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**5*dot(A,c))))))-1/224640.
    coneq[1930]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**3))))))-1/1347840.
    coneq[1931]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))))-1/4043520.
    coneq[1932]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))))-1/8087040.
    coneq[1933]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))))-1/2695680.
    coneq[1934]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3))))))-1/2695680.
    coneq[1935]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))))-1/8087040.
    coneq[1936]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))))-1/16174080.
    coneq[1937]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))))-1/5391360.
    coneq[1938]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**4))))))-1/1123200.
    coneq[1939]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3)))))))-1/4492800.
    coneq[1940]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))))-1/13478400.
    coneq[1941]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/26956800.
    coneq[1942]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))))-1/8985600.
    coneq[1943]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))))-1/3369600.
    coneq[1944]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))))-1/6739200.
    coneq[1945]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))))-1/2246400.
    coneq[1946]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))))-1/4492800.
    coneq[1947]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2))))))-1/1010880.
    coneq[1948]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))))-1/2021760.
    coneq[1949]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/4043520.
    coneq[1950]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**3))))))-1/898560.
    coneq[1951]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))))-1/2695680.
    coneq[1952]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/5391360.
    coneq[1953]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))))-1/1797120.
    coneq[1954]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2))))))-1/673920.
    coneq[1955]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))))-1/1347840.
    coneq[1956]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,c)*dot(A,c))))))-1/449280.
    coneq[1957]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))))-1/1347840.
    coneq[1958]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))))-1/2695680.
    coneq[1959]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))))-1/898560.
    coneq[1960]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**6)))))-1/98280.
    coneq[1961]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**5))))))-1/589680.
    coneq[1962]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**4)))))))-1/2948400.
    coneq[1963]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/11793600.
    coneq[1964]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/35380800.
    coneq[1965]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/70761600.
    coneq[1966]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/23587200.
    coneq[1967]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/8845200.
    coneq[1968]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/17690400.
    coneq[1969]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/5896800.
    coneq[1970]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/11793600.
    coneq[1971]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**3)))))))-1/2358720.
    coneq[1972]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/7076160.
    coneq[1973]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/14152320.
    coneq[1974]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/4717440.
    coneq[1975]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2)))))))-1/1769040.
    coneq[1976]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/3538080.
    coneq[1977]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**3*dot(A,c)))))))-1/1179360.
    coneq[1978]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/3538080.
    coneq[1979]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/7076160.
    coneq[1980]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/2358720.
    coneq[1981]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c**4))))))-1/491400.
    coneq[1982]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**3)))))))-1/1965600.
    coneq[1983]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/5896800.
    coneq[1984]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/11793600.
    coneq[1985]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/3931200.
    coneq[1986]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2)))))))-1/1474200.
    coneq[1987]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/2948400.
    coneq[1988]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c)))))))-1/982800.
    coneq[1989]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/1965600.
    coneq[1990]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,c**3))))))-1/393120.
    coneq[1991]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2)))))))-1/1179360.
    coneq[1992]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/2358720.
    coneq[1993]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c)))))))-1/786240.
    coneq[1994]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**3*dot(A,c**2))))))-1/294840.
    coneq[1995]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**3*dot(A,dot(A,c)))))))-1/589680.
    coneq[1996]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**4*dot(A,c))))))-1/196560.
    coneq[1997]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2))))))-1/884520.
    coneq[1998]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/1769040.
    coneq[1999]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/3538080.
    coneq[2000]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**3))))))-1/786240.
    coneq[2001]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/2358720.
    coneq[2002]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/4717440.
    coneq[2003]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/1572480.
    coneq[2004]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2))))))-1/589680.
    coneq[2005]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/1179360.
    coneq[2006]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c))))))-1/393120.
    coneq[2007]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/786240.
    coneq[2008]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**5)))))-1/84240.
    coneq[2009]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c**4))))))-1/421200.
    coneq[2010]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**3)))))))-1/1684800.
    coneq[2011]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/5054400.
    coneq[2012]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/10108800.
    coneq[2013]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/3369600.
    coneq[2014]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2)))))))-1/1263600.
    coneq[2015]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/2527200.
    coneq[2016]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c)))))))-1/842400.
    coneq[2017]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1684800.
    coneq[2018]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,c**3))))))-1/336960.
    coneq[2019]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2)))))))-1/1010880.
    coneq[2020]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/2021760.
    coneq[2021]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c)))))))-1/673920.
    coneq[2022]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2*dot(A,c**2))))))-1/252720.
    coneq[2023]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c)))))))-1/505440.
    coneq[2024]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**3*dot(A,c))))))-1/168480.
    coneq[2025]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2))))))-1/505440.
    coneq[2026]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1010880.
    coneq[2027]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c))))))-1/336960.
    coneq[2028]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c**4)))))-1/70200.
    coneq[2029]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,c**3))))))-1/280800.
    coneq[2030]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c**2)))))))-1/842400.
    coneq[2031]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1684800.
    coneq[2032]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,c*dot(A,c)))))))-1/561600.
    coneq[2033]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c*dot(A,c**2))))))-1/210600.
    coneq[2034]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c*dot(A,dot(A,c)))))))-1/421200.
    coneq[2035]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c**2*dot(A,c))))))-1/140400.
    coneq[2036]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,c)*dot(A,c))))))-1/280800.
    coneq[2037]=dot(b,dot(A,c*dot(A,dot(A,c**4*dot(A,c**3)))))-1/56160.
    coneq[2038]=dot(b,dot(A,c*dot(A,dot(A,c**4*dot(A,dot(A,c**2))))))-1/168480.
    coneq[2039]=dot(b,dot(A,c*dot(A,dot(A,c**4*dot(A,dot(A,dot(A,c)))))))-1/336960.
    coneq[2040]=dot(b,dot(A,c*dot(A,dot(A,c**4*dot(A,c*dot(A,c))))))-1/112320.
    coneq[2041]=dot(b,dot(A,c*dot(A,dot(A,c**5*dot(A,c**2)))))-1/42120.
    coneq[2042]=dot(b,dot(A,c*dot(A,dot(A,c**5*dot(A,dot(A,c))))))-1/84240.
    coneq[2043]=dot(b,dot(A,c*dot(A,dot(A,c**6*dot(A,c)))))-1/28080.
    coneq[2044]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3)*dot(A,c**3)))))-1/224640.
    coneq[2045]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,c**2))))))-1/673920.
    coneq[2046]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c)))))))-1/1347840.
    coneq[2047]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**3)*dot(A,c*dot(A,c))))))-1/449280.
    coneq[2048]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2))))))-1/2021760.
    coneq[2049]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)))))))-1/4043520.
    coneq[2050]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c))))))-1/1347840.
    coneq[2051]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))))))-1/8087040.
    coneq[2052]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c))))))-1/2695680.
    coneq[2053]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c))))))-1/898560.
    coneq[2054]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c**4)))))-1/210600.
    coneq[2055]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**3))))))-1/842400.
    coneq[2056]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2)))))))-1/2527200.
    coneq[2057]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/5054400.
    coneq[2058]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c)))))))-1/1684800.
    coneq[2059]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2))))))-1/631800.
    coneq[2060]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c)))))))-1/1263600.
    coneq[2061]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c))))))-1/421200.
    coneq[2062]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c))))))-1/842400.
    coneq[2063]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**4)))))-1/421200.
    coneq[2064]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3))))))-1/1684800.
    coneq[2065]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)))))))-1/5054400.
    coneq[2066]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))))-1/10108800.
    coneq[2067]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)))))))-1/3369600.
    coneq[2068]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2))))))-1/1263600.
    coneq[2069]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)))))))-1/2527200.
    coneq[2070]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c))))))-1/842400.
    coneq[2071]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c))))))-1/1684800.
    coneq[2072]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**5)))))-1/168480.
    coneq[2073]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**4))))))-1/842400.
    coneq[2074]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3)))))))-1/3369600.
    coneq[2075]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/10108800.
    coneq[2076]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/20217600.
    coneq[2077]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/6739200.
    coneq[2078]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2)))))))-1/2527200.
    coneq[2079]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/5054400.
    coneq[2080]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c)))))))-1/1684800.
    coneq[2081]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/3369600.
    coneq[2082]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**3))))))-1/673920.
    coneq[2083]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2)))))))-1/2021760.
    coneq[2084]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/4043520.
    coneq[2085]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c)))))))-1/1347840.
    coneq[2086]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2))))))-1/505440.
    coneq[2087]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c)))))))-1/1010880.
    coneq[2088]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**3*dot(A,c))))))-1/336960.
    coneq[2089]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2))))))-1/1010880.
    coneq[2090]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/2021760.
    coneq[2091]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c))))))-1/673920.
    coneq[2092]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2)*dot(A,c**3)))))-1/168480.
    coneq[2093]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2))))))-1/505440.
    coneq[2094]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/1010880.
    coneq[2095]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c))))))-1/336960.
    coneq[2096]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c**3)))))-1/336960.
    coneq[2097]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/1010880.
    coneq[2098]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/2021760.
    coneq[2099]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/673920.
    coneq[2100]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c**4)))))-1/140400.
    coneq[2101]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**3))))))-1/561600.
    coneq[2102]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/1684800.
    coneq[2103]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/3369600.
    coneq[2104]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/1123200.
    coneq[2105]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2))))))-1/421200.
    coneq[2106]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/842400.
    coneq[2107]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c))))))-1/280800.
    coneq[2108]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/561600.
    coneq[2109]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2)*dot(A,c**2)))))-1/126360.
    coneq[2110]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c))))))-1/252720.
    coneq[2111]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/505440.
    coneq[2112]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,c**3)))))-1/112320.
    coneq[2113]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2))))))-1/336960.
    coneq[2114]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/673920.
    coneq[2115]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c))))))-1/224640.
    coneq[2116]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c)*dot(A,c**2)))))-1/84240.
    coneq[2117]=dot(b,dot(A,c*dot(A,dot(A,c**3*dot(A,c)*dot(A,dot(A,c))))))-1/168480.
    coneq[2118]=dot(b,dot(A,c*dot(A,dot(A,c**4*dot(A,c)*dot(A,c)))))-1/56160.
    coneq[2119]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**3)))))-1/224640.
    coneq[2120]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2))))))-1/673920.
    coneq[2121]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/1347840.
    coneq[2122]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c))))))-1/449280.
    coneq[2123]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2)))))-1/252720.
    coneq[2124]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c))))))-1/505440.
    coneq[2125]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/1010880.
    coneq[2126]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/168480.
    coneq[2127]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/336960.
    coneq[2128]=dot(b,dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c)))))-1/112320.
    coneq[2129]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c)))))-1/224640.
    coneq[2130]=dot(b,dot(A,c*dot(A,c*dot(A,c**7))))-1/12480.
    coneq[2131]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**6)))))-1/87360.
    coneq[2132]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**5))))))-1/524160.
    coneq[2133]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**4)))))))-1/2620800.
    coneq[2134]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/10483200.
    coneq[2135]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/31449600.
    coneq[2136]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/62899200.
    coneq[2137]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/20966400.
    coneq[2138]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/7862400.
    coneq[2139]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/15724800.
    coneq[2140]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/5241600.
    coneq[2141]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/10483200.
    coneq[2142]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**3)))))))-1/2096640.
    coneq[2143]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/6289920.
    coneq[2144]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/12579840.
    coneq[2145]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/4193280.
    coneq[2146]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))))-1/1572480.
    coneq[2147]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/3144960.
    coneq[2148]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**3*dot(A,c)))))))-1/1048320.
    coneq[2149]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/3144960.
    coneq[2150]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/6289920.
    coneq[2151]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/2096640.
    coneq[2152]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c**4))))))-1/436800.
    coneq[2153]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**3)))))))-1/1747200.
    coneq[2154]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/5241600.
    coneq[2155]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/10483200.
    coneq[2156]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/3494400.
    coneq[2157]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))))-1/1310400.
    coneq[2158]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/2620800.
    coneq[2159]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))))-1/873600.
    coneq[2160]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/1747200.
    coneq[2161]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,c**3))))))-1/349440.
    coneq[2162]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))))-1/1048320.
    coneq[2163]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/2096640.
    coneq[2164]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))))-1/698880.
    coneq[2165]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**3*dot(A,c**2))))))-1/262080.
    coneq[2166]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**3*dot(A,dot(A,c)))))))-1/524160.
    coneq[2167]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**4*dot(A,c))))))-1/174720.
    coneq[2168]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))))-1/786240.
    coneq[2169]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/1572480.
    coneq[2170]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/3144960.
    coneq[2171]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**3))))))-1/698880.
    coneq[2172]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/2096640.
    coneq[2173]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/4193280.
    coneq[2174]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/1397760.
    coneq[2175]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))))-1/524160.
    coneq[2176]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/1048320.
    coneq[2177]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))))-1/349440.
    coneq[2178]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/698880.
    coneq[2179]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**5)))))-1/74880.
    coneq[2180]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c**4))))))-1/374400.
    coneq[2181]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**3)))))))-1/1497600.
    coneq[2182]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/4492800.
    coneq[2183]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/8985600.
    coneq[2184]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/2995200.
    coneq[2185]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))))-1/1123200.
    coneq[2186]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/2246400.
    coneq[2187]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))))-1/748800.
    coneq[2188]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1497600.
    coneq[2189]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,c**3))))))-1/299520.
    coneq[2190]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))))-1/898560.
    coneq[2191]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1797120.
    coneq[2192]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))))-1/599040.
    coneq[2193]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2*dot(A,c**2))))))-1/224640.
    coneq[2194]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))))-1/449280.
    coneq[2195]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**3*dot(A,c))))))-1/149760.
    coneq[2196]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))))-1/449280.
    coneq[2197]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/898560.
    coneq[2198]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))))-1/299520.
    coneq[2199]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c**4)))))-1/62400.
    coneq[2200]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,c**3))))))-1/249600.
    coneq[2201]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))))-1/748800.
    coneq[2202]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1497600.
    coneq[2203]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))))-1/499200.
    coneq[2204]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c*dot(A,c**2))))))-1/187200.
    coneq[2205]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))))-1/374400.
    coneq[2206]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,c))))))-1/124800.
    coneq[2207]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))))-1/249600.
    coneq[2208]=dot(b,dot(A,c*dot(A,c*dot(A,c**3*dot(A,c**3)))))-1/49920.
    coneq[2209]=dot(b,dot(A,c*dot(A,c*dot(A,c**3*dot(A,dot(A,c**2))))))-1/149760.
    coneq[2210]=dot(b,dot(A,c*dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,c)))))))-1/299520.
    coneq[2211]=dot(b,dot(A,c*dot(A,c*dot(A,c**3*dot(A,c*dot(A,c))))))-1/99840.
    coneq[2212]=dot(b,dot(A,c*dot(A,c*dot(A,c**4*dot(A,c**2)))))-1/37440.
    coneq[2213]=dot(b,dot(A,c*dot(A,c*dot(A,c**4*dot(A,dot(A,c))))))-1/74880.
    coneq[2214]=dot(b,dot(A,c*dot(A,c*dot(A,c**5*dot(A,c)))))-1/24960.
    coneq[2215]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2)*dot(A,c**3)))))-1/149760.
    coneq[2216]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))))-1/449280.
    coneq[2217]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/898560.
    coneq[2218]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))))-1/299520.
    coneq[2219]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**3)))))-1/299520.
    coneq[2220]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/898560.
    coneq[2221]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/1797120.
    coneq[2222]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/599040.
    coneq[2223]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c**4)))))-1/124800.
    coneq[2224]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**3))))))-1/499200.
    coneq[2225]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/1497600.
    coneq[2226]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2995200.
    coneq[2227]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/998400.
    coneq[2228]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))))-1/374400.
    coneq[2229]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/748800.
    coneq[2230]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))))-1/249600.
    coneq[2231]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/499200.
    coneq[2232]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c**2)))))-1/112320.
    coneq[2233]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))))-1/224640.
    coneq[2234]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/449280.
    coneq[2235]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,c**3)))))-1/99840.
    coneq[2236]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))))-1/299520.
    coneq[2237]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/599040.
    coneq[2238]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))))-1/199680.
    coneq[2239]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c**2)))))-1/74880.
    coneq[2240]=dot(b,dot(A,c*dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))))-1/149760.
    coneq[2241]=dot(b,dot(A,c*dot(A,c*dot(A,c**3*dot(A,c)*dot(A,c)))))-1/49920.
    coneq[2242]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/149760.
    coneq[2243]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/299520.
    coneq[2244]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))))-1/99840.
    coneq[2245]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**6))))-1/10920.
    coneq[2246]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**5)))))-1/65520.
    coneq[2247]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c**4))))))-1/327600.
    coneq[2248]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/1310400.
    coneq[2249]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/3931200.
    coneq[2250]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/7862400.
    coneq[2251]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/2620800.
    coneq[2252]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/982800.
    coneq[2253]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1965600.
    coneq[2254]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/655200.
    coneq[2255]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1310400.
    coneq[2256]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,c**3))))))-1/262080.
    coneq[2257]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/786240.
    coneq[2258]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1572480.
    coneq[2259]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/524160.
    coneq[2260]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2*dot(A,c**2))))))-1/196560.
    coneq[2261]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/393120.
    coneq[2262]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**3*dot(A,c))))))-1/131040.
    coneq[2263]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/393120.
    coneq[2264]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/786240.
    coneq[2265]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/262080.
    coneq[2266]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c**4)))))-1/54600.
    coneq[2267]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,c**3))))))-1/218400.
    coneq[2268]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/655200.
    coneq[2269]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1310400.
    coneq[2270]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/436800.
    coneq[2271]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c*dot(A,c**2))))))-1/163800.
    coneq[2272]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/327600.
    coneq[2273]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,c))))))-1/109200.
    coneq[2274]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/218400.
    coneq[2275]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,c**3)))))-1/43680.
    coneq[2276]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,dot(A,c**2))))))-1/131040.
    coneq[2277]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/262080.
    coneq[2278]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,c))))))-1/87360.
    coneq[2279]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**3*dot(A,c**2)))))-1/32760.
    coneq[2280]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**3*dot(A,dot(A,c))))))-1/65520.
    coneq[2281]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**4*dot(A,c)))))-1/21840.
    coneq[2282]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/98280.
    coneq[2283]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/196560.
    coneq[2284]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/393120.
    coneq[2285]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,c**3)))))-1/87360.
    coneq[2286]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/262080.
    coneq[2287]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/524160.
    coneq[2288]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/174720.
    coneq[2289]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/65520.
    coneq[2290]=dot(b,dot(A,c*dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/131040.
    coneq[2291]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/43680.
    coneq[2292]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/87360.
    coneq[2293]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**5))))-1/9360.
    coneq[2294]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c**4)))))-1/46800.
    coneq[2295]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,c**3))))))-1/187200.
    coneq[2296]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/561600.
    coneq[2297]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1123200.
    coneq[2298]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/374400.
    coneq[2299]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c*dot(A,c**2))))))-1/140400.
    coneq[2300]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/280800.
    coneq[2301]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c**2*dot(A,c))))))-1/93600.
    coneq[2302]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/187200.
    coneq[2303]=dot(b,dot(A,c*dot(A,c**3*dot(A,c*dot(A,c**3)))))-1/37440.
    coneq[2304]=dot(b,dot(A,c*dot(A,c**3*dot(A,c*dot(A,dot(A,c**2))))))-1/112320.
    coneq[2305]=dot(b,dot(A,c*dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/224640.
    coneq[2306]=dot(b,dot(A,c*dot(A,c**3*dot(A,c*dot(A,c*dot(A,c))))))-1/74880.
    coneq[2307]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**2*dot(A,c**2)))))-1/28080.
    coneq[2308]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**2*dot(A,dot(A,c))))))-1/56160.
    coneq[2309]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**3*dot(A,c)))))-1/18720.
    coneq[2310]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c)*dot(A,c**2)))))-1/56160.
    coneq[2311]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/112320.
    coneq[2312]=dot(b,dot(A,c*dot(A,c**3*dot(A,c*dot(A,c)*dot(A,c)))))-1/37440.
    coneq[2313]=dot(b,dot(A,c*dot(A,c**4*dot(A,c**4))))-1/7800.
    coneq[2314]=dot(b,dot(A,c*dot(A,c**4*dot(A,dot(A,c**3)))))-1/31200.
    coneq[2315]=dot(b,dot(A,c*dot(A,c**4*dot(A,dot(A,dot(A,c**2))))))-1/93600.
    coneq[2316]=dot(b,dot(A,c*dot(A,c**4*dot(A,dot(A,dot(A,dot(A,c)))))))-1/187200.
    coneq[2317]=dot(b,dot(A,c*dot(A,c**4*dot(A,dot(A,c*dot(A,c))))))-1/62400.
    coneq[2318]=dot(b,dot(A,c*dot(A,c**4*dot(A,c*dot(A,c**2)))))-1/23400.
    coneq[2319]=dot(b,dot(A,c*dot(A,c**4*dot(A,c*dot(A,dot(A,c))))))-1/46800.
    coneq[2320]=dot(b,dot(A,c*dot(A,c**4*dot(A,c**2*dot(A,c)))))-1/15600.
    coneq[2321]=dot(b,dot(A,c*dot(A,c**4*dot(A,dot(A,c)*dot(A,c)))))-1/31200.
    coneq[2322]=dot(b,dot(A,c*dot(A,c**5*dot(A,c**3))))-1/6240.
    coneq[2323]=dot(b,dot(A,c*dot(A,c**5*dot(A,dot(A,c**2)))))-1/18720.
    coneq[2324]=dot(b,dot(A,c*dot(A,c**5*dot(A,dot(A,dot(A,c))))))-1/37440.
    coneq[2325]=dot(b,dot(A,c*dot(A,c**5*dot(A,c*dot(A,c)))))-1/12480.
    coneq[2326]=dot(b,dot(A,c*dot(A,c**6*dot(A,c**2))))-1/4680.
    coneq[2327]=dot(b,dot(A,c*dot(A,c**6*dot(A,dot(A,c)))))-1/9360.
    coneq[2328]=dot(b,dot(A,c*dot(A,c**7*dot(A,c))))-1/3120.
    coneq[2329]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,c**4))))-1/31200.
    coneq[2330]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,dot(A,c**3)))))-1/124800.
    coneq[2331]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c**2))))))-1/374400.
    coneq[2332]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/748800.
    coneq[2333]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,c))))))-1/249600.
    coneq[2334]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,c*dot(A,c**2)))))-1/93600.
    coneq[2335]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,c))))))-1/187200.
    coneq[2336]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,c**2*dot(A,c)))))-1/62400.
    coneq[2337]=dot(b,dot(A,c*dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,c)))))-1/124800.
    coneq[2338]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,c**4))))-1/93600.
    coneq[2339]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**3)))))-1/374400.
    coneq[2340]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**2))))))-1/1123200.
    coneq[2341]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/2246400.
    coneq[2342]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c))))))-1/748800.
    coneq[2343]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c**2)))))-1/280800.
    coneq[2344]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c))))))-1/561600.
    coneq[2345]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c)))))-1/187200.
    coneq[2346]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c)))))-1/374400.
    coneq[2347]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**4))))-1/187200.
    coneq[2348]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**3)))))-1/748800.
    coneq[2349]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2))))))-1/2246400.
    coneq[2350]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/4492800.
    coneq[2351]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c))))))-1/1497600.
    coneq[2352]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**2)))))-1/561600.
    coneq[2353]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c))))))-1/1123200.
    coneq[2354]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c)))))-1/374400.
    coneq[2355]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c)))))-1/748800.
    coneq[2356]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,c**4))))-1/62400.
    coneq[2357]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**3)))))-1/249600.
    coneq[2358]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/748800.
    coneq[2359]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1497600.
    coneq[2360]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/499200.
    coneq[2361]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c**2)))))-1/187200.
    coneq[2362]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/374400.
    coneq[2363]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c)))))-1/124800.
    coneq[2364]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/249600.
    coneq[2365]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**5))))-1/28080.
    coneq[2366]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c**4)))))-1/140400.
    coneq[2367]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**3))))))-1/561600.
    coneq[2368]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1684800.
    coneq[2369]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/3369600.
    coneq[2370]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/1123200.
    coneq[2371]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c**2))))))-1/421200.
    coneq[2372]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/842400.
    coneq[2373]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c))))))-1/280800.
    coneq[2374]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/561600.
    coneq[2375]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,c**3)))))-1/112320.
    coneq[2376]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c**2))))))-1/336960.
    coneq[2377]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/673920.
    coneq[2378]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c))))))-1/224640.
    coneq[2379]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c**2)))))-1/84240.
    coneq[2380]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c))))))-1/168480.
    coneq[2381]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**3*dot(A,c)))))-1/56160.
    coneq[2382]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**2)))))-1/168480.
    coneq[2383]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/336960.
    coneq[2384]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c)))))-1/112320.
    coneq[2385]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**5))))-1/56160.
    coneq[2386]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**4)))))-1/280800.
    coneq[2387]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**3))))))-1/1123200.
    coneq[2388]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/3369600.
    coneq[2389]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/6739200.
    coneq[2390]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/2246400.
    coneq[2391]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**2))))))-1/842400.
    coneq[2392]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/1684800.
    coneq[2393]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c))))))-1/561600.
    coneq[2394]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/1123200.
    coneq[2395]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**3)))))-1/224640.
    coneq[2396]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**2))))))-1/673920.
    coneq[2397]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/1347840.
    coneq[2398]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c))))))-1/449280.
    coneq[2399]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c**2)))))-1/168480.
    coneq[2400]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c))))))-1/336960.
    coneq[2401]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,c)))))-1/112320.
    coneq[2402]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**2)))))-1/336960.
    coneq[2403]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/673920.
    coneq[2404]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c)))))-1/224640.
    coneq[2405]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**6))))-1/21840.
    coneq[2406]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**5)))))-1/131040.
    coneq[2407]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**4))))))-1/655200.
    coneq[2408]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/2620800.
    coneq[2409]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/7862400.
    coneq[2410]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/15724800.
    coneq[2411]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/5241600.
    coneq[2412]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/1965600.
    coneq[2413]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/3931200.
    coneq[2414]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/1310400.
    coneq[2415]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/2620800.
    coneq[2416]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**3))))))-1/524160.
    coneq[2417]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/1572480.
    coneq[2418]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/3144960.
    coneq[2419]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/1048320.
    coneq[2420]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c**2))))))-1/393120.
    coneq[2421]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/786240.
    coneq[2422]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,c))))))-1/262080.
    coneq[2423]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/786240.
    coneq[2424]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1572480.
    coneq[2425]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/524160.
    coneq[2426]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c**4)))))-1/109200.
    coneq[2427]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**3))))))-1/436800.
    coneq[2428]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/1310400.
    coneq[2429]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2620800.
    coneq[2430]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/873600.
    coneq[2431]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c**2))))))-1/327600.
    coneq[2432]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/655200.
    coneq[2433]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c))))))-1/218400.
    coneq[2434]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/436800.
    coneq[2435]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,c**3)))))-1/87360.
    coneq[2436]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c**2))))))-1/262080.
    coneq[2437]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/524160.
    coneq[2438]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c))))))-1/174720.
    coneq[2439]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**3*dot(A,c**2)))))-1/65520.
    coneq[2440]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,c))))))-1/131040.
    coneq[2441]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**4*dot(A,c)))))-1/43680.
    coneq[2442]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/196560.
    coneq[2443]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/393120.
    coneq[2444]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/786240.
    coneq[2445]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**3)))))-1/174720.
    coneq[2446]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/524160.
    coneq[2447]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/1048320.
    coneq[2448]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/349440.
    coneq[2449]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/131040.
    coneq[2450]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/262080.
    coneq[2451]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/87360.
    coneq[2452]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/174720.
    coneq[2453]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)*dot(A,c**3))))-1/24960.
    coneq[2454]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)*dot(A,dot(A,c**2)))))-1/74880.
    coneq[2455]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,c))))))-1/149760.
    coneq[2456]=dot(b,dot(A,c*dot(A,c*dot(A,c**3)*dot(A,c*dot(A,c)))))-1/49920.
    coneq[2457]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))))-1/224640.
    coneq[2458]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))))-1/449280.
    coneq[2459]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))))-1/149760.
    coneq[2460]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))))-1/898560.
    coneq[2461]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))))-1/299520.
    coneq[2462]=dot(b,dot(A,c*dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))))-1/99840.
    coneq[2463]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c**4))))-1/23400.
    coneq[2464]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,c**3)))))-1/93600.
    coneq[2465]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))))-1/280800.
    coneq[2466]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/561600.
    coneq[2467]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))))-1/187200.
    coneq[2468]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c**2)))))-1/70200.
    coneq[2469]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))))-1/140400.
    coneq[2470]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,c)))))-1/46800.
    coneq[2471]=dot(b,dot(A,c*dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))))-1/93600.
    coneq[2472]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,c**4))))-1/46800.
    coneq[2473]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**3)))))-1/187200.
    coneq[2474]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/561600.
    coneq[2475]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1123200.
    coneq[2476]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/374400.
    coneq[2477]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))))-1/140400.
    coneq[2478]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/280800.
    coneq[2479]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))))-1/93600.
    coneq[2480]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/187200.
    coneq[2481]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**5))))-1/18720.
    coneq[2482]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c**4)))))-1/93600.
    coneq[2483]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**3))))))-1/374400.
    coneq[2484]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1123200.
    coneq[2485]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/2246400.
    coneq[2486]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/748800.
    coneq[2487]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))))-1/280800.
    coneq[2488]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/561600.
    coneq[2489]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))))-1/187200.
    coneq[2490]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/374400.
    coneq[2491]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,c**3)))))-1/74880.
    coneq[2492]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))))-1/224640.
    coneq[2493]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/449280.
    coneq[2494]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))))-1/149760.
    coneq[2495]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c**2)))))-1/56160.
    coneq[2496]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))))-1/112320.
    coneq[2497]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**3*dot(A,c)))))-1/37440.
    coneq[2498]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))))-1/112320.
    coneq[2499]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/224640.
    coneq[2500]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))))-1/74880.
    coneq[2501]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)*dot(A,c**3))))-1/18720.
    coneq[2502]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/56160.
    coneq[2503]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/112320.
    coneq[2504]=dot(b,dot(A,c*dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/37440.
    coneq[2505]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))*dot(A,c**3))))-1/37440.
    coneq[2506]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/112320.
    coneq[2507]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/224640.
    coneq[2508]=dot(b,dot(A,c*dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/74880.
    coneq[2509]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c**4))))-1/15600.
    coneq[2510]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,c**3)))))-1/62400.
    coneq[2511]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/187200.
    coneq[2512]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/374400.
    coneq[2513]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/124800.
    coneq[2514]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c**2)))))-1/46800.
    coneq[2515]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/93600.
    coneq[2516]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,c)))))-1/31200.
    coneq[2517]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/62400.
    coneq[2518]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**2)*dot(A,c**2))))-1/14040.
    coneq[2519]=dot(b,dot(A,c*dot(A,c**3*dot(A,c**2)*dot(A,dot(A,c)))))-1/28080.
    coneq[2520]=dot(b,dot(A,c*dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/56160.
    coneq[2521]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,c**3))))-1/12480.
    coneq[2522]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,dot(A,c**2)))))-1/37440.
    coneq[2523]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/74880.
    coneq[2524]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,c*dot(A,c)))))-1/24960.
    coneq[2525]=dot(b,dot(A,c*dot(A,c**4*dot(A,c)*dot(A,c**2))))-1/9360.
    coneq[2526]=dot(b,dot(A,c*dot(A,c**4*dot(A,c)*dot(A,dot(A,c)))))-1/18720.
    coneq[2527]=dot(b,dot(A,c*dot(A,c**5*dot(A,c)*dot(A,c))))-1/6240.
    coneq[2528]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c**4))))-1/31200.
    coneq[2529]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**3)))))-1/124800.
    coneq[2530]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/374400.
    coneq[2531]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/748800.
    coneq[2532]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/249600.
    coneq[2533]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c**2)))))-1/93600.
    coneq[2534]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/187200.
    coneq[2535]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2*dot(A,c)))))-1/62400.
    coneq[2536]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/124800.
    coneq[2537]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**3))))-1/37440.
    coneq[2538]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/112320.
    coneq[2539]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/224640.
    coneq[2540]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/74880.
    coneq[2541]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c**3))))-1/74880.
    coneq[2542]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/224640.
    coneq[2543]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/449280.
    coneq[2544]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/149760.
    coneq[2545]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,c**2))))-1/42120.
    coneq[2546]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2)*dot(A,dot(A,c)))))-1/84240.
    coneq[2547]=dot(b,dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/168480.
    coneq[2548]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/336960.
    coneq[2549]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**3))))-1/24960.
    coneq[2550]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))))-1/74880.
    coneq[2551]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/149760.
    coneq[2552]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))))-1/49920.
    coneq[2553]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,c**2))))-1/28080.
    coneq[2554]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))))-1/56160.
    coneq[2555]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/112320.
    coneq[2556]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c**2))))-1/18720.
    coneq[2557]=dot(b,dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/37440.
    coneq[2558]=dot(b,dot(A,c*dot(A,c**3*dot(A,c)*dot(A,c)*dot(A,c))))-1/12480.
    coneq[2559]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c**2))))-1/37440.
    coneq[2560]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/74880.
    coneq[2561]=dot(b,dot(A,c*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))))-1/24960.
    coneq[2562]=dot(b,dot(A,c**2*dot(A,c**8)))-1/1404.
    coneq[2563]=dot(b,dot(A,c**2*dot(A,dot(A,c**7))))-1/11232.
    coneq[2564]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**6)))))-1/78624.
    coneq[2565]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**5))))))-1/471744.
    coneq[2566]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c**4)))))))-1/2358720.
    coneq[2567]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/9434880.
    coneq[2568]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/28304640.
    coneq[2569]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/56609280.
    coneq[2570]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/18869760.
    coneq[2571]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/7076160.
    coneq[2572]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/14152320.
    coneq[2573]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/4717440.
    coneq[2574]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/9434880.
    coneq[2575]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3)))))))-1/1886976.
    coneq[2576]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/5660928.
    coneq[2577]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/11321856.
    coneq[2578]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/3773952.
    coneq[2579]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))))-1/1415232.
    coneq[2580]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/2830464.
    coneq[2581]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)))))))-1/943488.
    coneq[2582]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/2830464.
    coneq[2583]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/5660928.
    coneq[2584]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/1886976.
    coneq[2585]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c**4))))))-1/393120.
    coneq[2586]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3)))))))-1/1572480.
    coneq[2587]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/4717440.
    coneq[2588]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/9434880.
    coneq[2589]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/3144960.
    coneq[2590]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))))-1/1179360.
    coneq[2591]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/2358720.
    coneq[2592]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))))-1/786240.
    coneq[2593]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/1572480.
    coneq[2594]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,c**3))))))-1/314496.
    coneq[2595]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))))-1/943488.
    coneq[2596]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/1886976.
    coneq[2597]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))))-1/628992.
    coneq[2598]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**3*dot(A,c**2))))))-1/235872.
    coneq[2599]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)))))))-1/471744.
    coneq[2600]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**4*dot(A,c))))))-1/157248.
    coneq[2601]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))))-1/707616.
    coneq[2602]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/1415232.
    coneq[2603]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/2830464.
    coneq[2604]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3))))))-1/628992.
    coneq[2605]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/1886976.
    coneq[2606]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/3773952.
    coneq[2607]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/1257984.
    coneq[2608]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))))-1/471744.
    coneq[2609]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/943488.
    coneq[2610]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))))-1/314496.
    coneq[2611]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/628992.
    coneq[2612]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**5)))))-1/67392.
    coneq[2613]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c**4))))))-1/336960.
    coneq[2614]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3)))))))-1/1347840.
    coneq[2615]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/4043520.
    coneq[2616]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/8087040.
    coneq[2617]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/2695680.
    coneq[2618]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))))-1/1010880.
    coneq[2619]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/2021760.
    coneq[2620]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))))-1/673920.
    coneq[2621]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1347840.
    coneq[2622]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,c**3))))))-1/269568.
    coneq[2623]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))))-1/808704.
    coneq[2624]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1617408.
    coneq[2625]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))))-1/539136.
    coneq[2626]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2*dot(A,c**2))))))-1/202176.
    coneq[2627]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))))-1/404352.
    coneq[2628]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**3*dot(A,c))))))-1/134784.
    coneq[2629]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))))-1/404352.
    coneq[2630]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/808704.
    coneq[2631]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))))-1/269568.
    coneq[2632]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c**4)))))-1/56160.
    coneq[2633]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,c**3))))))-1/224640.
    coneq[2634]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))))-1/673920.
    coneq[2635]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1347840.
    coneq[2636]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))))-1/449280.
    coneq[2637]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c*dot(A,c**2))))))-1/168480.
    coneq[2638]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))))-1/336960.
    coneq[2639]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c**2*dot(A,c))))))-1/112320.
    coneq[2640]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))))-1/224640.
    coneq[2641]=dot(b,dot(A,c**2*dot(A,dot(A,c**3*dot(A,c**3)))))-1/44928.
    coneq[2642]=dot(b,dot(A,c**2*dot(A,dot(A,c**3*dot(A,dot(A,c**2))))))-1/134784.
    coneq[2643]=dot(b,dot(A,c**2*dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)))))))-1/269568.
    coneq[2644]=dot(b,dot(A,c**2*dot(A,dot(A,c**3*dot(A,c*dot(A,c))))))-1/89856.
    coneq[2645]=dot(b,dot(A,c**2*dot(A,dot(A,c**4*dot(A,c**2)))))-1/33696.
    coneq[2646]=dot(b,dot(A,c**2*dot(A,dot(A,c**4*dot(A,dot(A,c))))))-1/67392.
    coneq[2647]=dot(b,dot(A,c**2*dot(A,dot(A,c**5*dot(A,c)))))-1/22464.
    coneq[2648]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2)*dot(A,c**3)))))-1/134784.
    coneq[2649]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))))-1/404352.
    coneq[2650]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/808704.
    coneq[2651]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))))-1/269568.
    coneq[2652]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3)))))-1/269568.
    coneq[2653]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/808704.
    coneq[2654]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/1617408.
    coneq[2655]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/539136.
    coneq[2656]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c**4)))))-1/112320.
    coneq[2657]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3))))))-1/449280.
    coneq[2658]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/1347840.
    coneq[2659]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2695680.
    coneq[2660]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/898560.
    coneq[2661]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))))-1/336960.
    coneq[2662]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/673920.
    coneq[2663]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))))-1/224640.
    coneq[2664]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/449280.
    coneq[2665]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2)))))-1/101088.
    coneq[2666]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))))-1/202176.
    coneq[2667]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/404352.
    coneq[2668]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,c**3)))))-1/89856.
    coneq[2669]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))))-1/269568.
    coneq[2670]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/539136.
    coneq[2671]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))))-1/179712.
    coneq[2672]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2)))))-1/67392.
    coneq[2673]=dot(b,dot(A,c**2*dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))))-1/134784.
    coneq[2674]=dot(b,dot(A,c**2*dot(A,dot(A,c**3*dot(A,c)*dot(A,c)))))-1/44928.
    coneq[2675]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/134784.
    coneq[2676]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/269568.
    coneq[2677]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))))-1/89856.
    coneq[2678]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**6))))-1/9828.
    coneq[2679]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**5)))))-1/58968.
    coneq[2680]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c**4))))))-1/294840.
    coneq[2681]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/1179360.
    coneq[2682]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/3538080.
    coneq[2683]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/7076160.
    coneq[2684]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/2358720.
    coneq[2685]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/884520.
    coneq[2686]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1769040.
    coneq[2687]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/589680.
    coneq[2688]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1179360.
    coneq[2689]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,c**3))))))-1/235872.
    coneq[2690]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/707616.
    coneq[2691]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1415232.
    coneq[2692]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/471744.
    coneq[2693]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2*dot(A,c**2))))))-1/176904.
    coneq[2694]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/353808.
    coneq[2695]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**3*dot(A,c))))))-1/117936.
    coneq[2696]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/353808.
    coneq[2697]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/707616.
    coneq[2698]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/235872.
    coneq[2699]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c**4)))))-1/49140.
    coneq[2700]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,c**3))))))-1/196560.
    coneq[2701]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/589680.
    coneq[2702]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1179360.
    coneq[2703]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/393120.
    coneq[2704]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c*dot(A,c**2))))))-1/147420.
    coneq[2705]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/294840.
    coneq[2706]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c**2*dot(A,c))))))-1/98280.
    coneq[2707]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/196560.
    coneq[2708]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,c**3)))))-1/39312.
    coneq[2709]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,dot(A,c**2))))))-1/117936.
    coneq[2710]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/235872.
    coneq[2711]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,c*dot(A,c))))))-1/78624.
    coneq[2712]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**3*dot(A,c**2)))))-1/29484.
    coneq[2713]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**3*dot(A,dot(A,c))))))-1/58968.
    coneq[2714]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**4*dot(A,c)))))-1/19656.
    coneq[2715]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/88452.
    coneq[2716]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/176904.
    coneq[2717]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/353808.
    coneq[2718]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,c**3)))))-1/78624.
    coneq[2719]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/235872.
    coneq[2720]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/471744.
    coneq[2721]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/157248.
    coneq[2722]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/58968.
    coneq[2723]=dot(b,dot(A,c**2*dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/117936.
    coneq[2724]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/39312.
    coneq[2725]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/78624.
    coneq[2726]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**5))))-1/8424.
    coneq[2727]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c**4)))))-1/42120.
    coneq[2728]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,c**3))))))-1/168480.
    coneq[2729]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/505440.
    coneq[2730]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1010880.
    coneq[2731]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/336960.
    coneq[2732]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c*dot(A,c**2))))))-1/126360.
    coneq[2733]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/252720.
    coneq[2734]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c**2*dot(A,c))))))-1/84240.
    coneq[2735]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/168480.
    coneq[2736]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,c**3)))))-1/33696.
    coneq[2737]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,dot(A,c**2))))))-1/101088.
    coneq[2738]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/202176.
    coneq[2739]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,c*dot(A,c))))))-1/67392.
    coneq[2740]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**2*dot(A,c**2)))))-1/25272.
    coneq[2741]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**2*dot(A,dot(A,c))))))-1/50544.
    coneq[2742]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**3*dot(A,c)))))-1/16848.
    coneq[2743]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2)))))-1/50544.
    coneq[2744]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/101088.
    coneq[2745]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)))))-1/33696.
    coneq[2746]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c**4))))-1/7020.
    coneq[2747]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,dot(A,c**3)))))-1/28080.
    coneq[2748]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,dot(A,dot(A,c**2))))))-1/84240.
    coneq[2749]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)))))))-1/168480.
    coneq[2750]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,dot(A,c*dot(A,c))))))-1/56160.
    coneq[2751]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c*dot(A,c**2)))))-1/21060.
    coneq[2752]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c*dot(A,dot(A,c))))))-1/42120.
    coneq[2753]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c**2*dot(A,c)))))-1/14040.
    coneq[2754]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,dot(A,c)*dot(A,c)))))-1/28080.
    coneq[2755]=dot(b,dot(A,c**2*dot(A,c**4*dot(A,c**3))))-1/5616.
    coneq[2756]=dot(b,dot(A,c**2*dot(A,c**4*dot(A,dot(A,c**2)))))-1/16848.
    coneq[2757]=dot(b,dot(A,c**2*dot(A,c**4*dot(A,dot(A,dot(A,c))))))-1/33696.
    coneq[2758]=dot(b,dot(A,c**2*dot(A,c**4*dot(A,c*dot(A,c)))))-1/11232.
    coneq[2759]=dot(b,dot(A,c**2*dot(A,c**5*dot(A,c**2))))-1/4212.
    coneq[2760]=dot(b,dot(A,c**2*dot(A,c**5*dot(A,dot(A,c)))))-1/8424.
    coneq[2761]=dot(b,dot(A,c**2*dot(A,c**6*dot(A,c))))-1/2808.
    coneq[2762]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)*dot(A,c**3))))-1/22464.
    coneq[2763]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)*dot(A,dot(A,c**2)))))-1/67392.
    coneq[2764]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c))))))-1/134784.
    coneq[2765]=dot(b,dot(A,c**2*dot(A,dot(A,c**3)*dot(A,c*dot(A,c)))))-1/44928.
    coneq[2766]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))))-1/202176.
    coneq[2767]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))))-1/404352.
    coneq[2768]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))))-1/134784.
    coneq[2769]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))))-1/808704.
    coneq[2770]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))))-1/269568.
    coneq[2771]=dot(b,dot(A,c**2*dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))))-1/89856.
    coneq[2772]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c**4))))-1/21060.
    coneq[2773]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,c**3)))))-1/84240.
    coneq[2774]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))))-1/252720.
    coneq[2775]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/505440.
    coneq[2776]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))))-1/168480.
    coneq[2777]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2)))))-1/63180.
    coneq[2778]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))))-1/126360.
    coneq[2779]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)))))-1/42120.
    coneq[2780]=dot(b,dot(A,c**2*dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))))-1/84240.
    coneq[2781]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,c**4))))-1/42120.
    coneq[2782]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3)))))-1/168480.
    coneq[2783]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/505440.
    coneq[2784]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1010880.
    coneq[2785]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/336960.
    coneq[2786]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))))-1/126360.
    coneq[2787]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/252720.
    coneq[2788]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))))-1/84240.
    coneq[2789]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/168480.
    coneq[2790]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**5))))-1/16848.
    coneq[2791]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c**4)))))-1/84240.
    coneq[2792]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3))))))-1/336960.
    coneq[2793]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1010880.
    coneq[2794]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/2021760.
    coneq[2795]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/673920.
    coneq[2796]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))))-1/252720.
    coneq[2797]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/505440.
    coneq[2798]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))))-1/168480.
    coneq[2799]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/336960.
    coneq[2800]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,c**3)))))-1/67392.
    coneq[2801]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))))-1/202176.
    coneq[2802]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/404352.
    coneq[2803]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))))-1/134784.
    coneq[2804]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2)))))-1/50544.
    coneq[2805]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))))-1/101088.
    coneq[2806]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**3*dot(A,c)))))-1/33696.
    coneq[2807]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))))-1/101088.
    coneq[2808]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/202176.
    coneq[2809]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))))-1/67392.
    coneq[2810]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)*dot(A,c**3))))-1/16848.
    coneq[2811]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/50544.
    coneq[2812]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/101088.
    coneq[2813]=dot(b,dot(A,c**2*dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/33696.
    coneq[2814]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))*dot(A,c**3))))-1/33696.
    coneq[2815]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/101088.
    coneq[2816]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/202176.
    coneq[2817]=dot(b,dot(A,c**2*dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/67392.
    coneq[2818]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c**4))))-1/14040.
    coneq[2819]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,c**3)))))-1/56160.
    coneq[2820]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/168480.
    coneq[2821]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/336960.
    coneq[2822]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/112320.
    coneq[2823]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2)))))-1/42120.
    coneq[2824]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/84240.
    coneq[2825]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)))))-1/28080.
    coneq[2826]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/56160.
    coneq[2827]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**2)*dot(A,c**2))))-1/12636.
    coneq[2828]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)))))-1/25272.
    coneq[2829]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/50544.
    coneq[2830]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,c**3))))-1/11232.
    coneq[2831]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2)))))-1/33696.
    coneq[2832]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/67392.
    coneq[2833]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)))))-1/22464.
    coneq[2834]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c)*dot(A,c**2))))-1/8424.
    coneq[2835]=dot(b,dot(A,c**2*dot(A,c**3*dot(A,c)*dot(A,dot(A,c)))))-1/16848.
    coneq[2836]=dot(b,dot(A,c**2*dot(A,c**4*dot(A,c)*dot(A,c))))-1/5616.
    coneq[2837]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,c**3))))-1/22464.
    coneq[2838]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))))-1/67392.
    coneq[2839]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/134784.
    coneq[2840]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))))-1/44928.
    coneq[2841]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2))))-1/25272.
    coneq[2842]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))))-1/50544.
    coneq[2843]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/101088.
    coneq[2844]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2))))-1/16848.
    coneq[2845]=dot(b,dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/33696.
    coneq[2846]=dot(b,dot(A,c**2*dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c))))-1/11232.
    coneq[2847]=dot(b,dot(A,c**2*dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))))-1/22464.
    coneq[2848]=dot(b,dot(A,c**3*dot(A,c**7)))-1/1248.
    coneq[2849]=dot(b,dot(A,c**3*dot(A,dot(A,c**6))))-1/8736.
    coneq[2850]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**5)))))-1/52416.
    coneq[2851]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c**4))))))-1/262080.
    coneq[2852]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/1048320.
    coneq[2853]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/3144960.
    coneq[2854]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/6289920.
    coneq[2855]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/2096640.
    coneq[2856]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/786240.
    coneq[2857]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/1572480.
    coneq[2858]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/524160.
    coneq[2859]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/1048320.
    coneq[2860]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,c**3))))))-1/209664.
    coneq[2861]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/628992.
    coneq[2862]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/1257984.
    coneq[2863]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/419328.
    coneq[2864]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))-1/157248.
    coneq[2865]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/314496.
    coneq[2866]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**3*dot(A,c))))))-1/104832.
    coneq[2867]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/314496.
    coneq[2868]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/628992.
    coneq[2869]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/209664.
    coneq[2870]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c**4)))))-1/43680.
    coneq[2871]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,c**3))))))-1/174720.
    coneq[2872]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/524160.
    coneq[2873]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/1048320.
    coneq[2874]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/349440.
    coneq[2875]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))-1/131040.
    coneq[2876]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/262080.
    coneq[2877]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))-1/87360.
    coneq[2878]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/174720.
    coneq[2879]=dot(b,dot(A,c**3*dot(A,dot(A,c**2*dot(A,c**3)))))-1/34944.
    coneq[2880]=dot(b,dot(A,c**3*dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))-1/104832.
    coneq[2881]=dot(b,dot(A,c**3*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/209664.
    coneq[2882]=dot(b,dot(A,c**3*dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))-1/69888.
    coneq[2883]=dot(b,dot(A,c**3*dot(A,dot(A,c**3*dot(A,c**2)))))-1/26208.
    coneq[2884]=dot(b,dot(A,c**3*dot(A,dot(A,c**3*dot(A,dot(A,c))))))-1/52416.
    coneq[2885]=dot(b,dot(A,c**3*dot(A,dot(A,c**4*dot(A,c)))))-1/17472.
    coneq[2886]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))-1/78624.
    coneq[2887]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/157248.
    coneq[2888]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/314496.
    coneq[2889]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,c**3)))))-1/69888.
    coneq[2890]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/209664.
    coneq[2891]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/419328.
    coneq[2892]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/139776.
    coneq[2893]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))-1/52416.
    coneq[2894]=dot(b,dot(A,c**3*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/104832.
    coneq[2895]=dot(b,dot(A,c**3*dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))-1/34944.
    coneq[2896]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/69888.
    coneq[2897]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**5))))-1/7488.
    coneq[2898]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c**4)))))-1/37440.
    coneq[2899]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,c**3))))))-1/149760.
    coneq[2900]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/449280.
    coneq[2901]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/898560.
    coneq[2902]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/299520.
    coneq[2903]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))-1/112320.
    coneq[2904]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/224640.
    coneq[2905]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))-1/74880.
    coneq[2906]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/149760.
    coneq[2907]=dot(b,dot(A,c**3*dot(A,c*dot(A,c*dot(A,c**3)))))-1/29952.
    coneq[2908]=dot(b,dot(A,c**3*dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))-1/89856.
    coneq[2909]=dot(b,dot(A,c**3*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/179712.
    coneq[2910]=dot(b,dot(A,c**3*dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))-1/59904.
    coneq[2911]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**2*dot(A,c**2)))))-1/22464.
    coneq[2912]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))-1/44928.
    coneq[2913]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**3*dot(A,c)))))-1/14976.
    coneq[2914]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))-1/44928.
    coneq[2915]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/89856.
    coneq[2916]=dot(b,dot(A,c**3*dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))-1/29952.
    coneq[2917]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c**4))))-1/6240.
    coneq[2918]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,dot(A,c**3)))))-1/24960.
    coneq[2919]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))-1/74880.
    coneq[2920]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))-1/149760.
    coneq[2921]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))-1/49920.
    coneq[2922]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c*dot(A,c**2)))))-1/18720.
    coneq[2923]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))-1/37440.
    coneq[2924]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c**2*dot(A,c)))))-1/12480.
    coneq[2925]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))-1/24960.
    coneq[2926]=dot(b,dot(A,c**3*dot(A,c**3*dot(A,c**3))))-1/4992.
    coneq[2927]=dot(b,dot(A,c**3*dot(A,c**3*dot(A,dot(A,c**2)))))-1/14976.
    coneq[2928]=dot(b,dot(A,c**3*dot(A,c**3*dot(A,dot(A,dot(A,c))))))-1/29952.
    coneq[2929]=dot(b,dot(A,c**3*dot(A,c**3*dot(A,c*dot(A,c)))))-1/9984.
    coneq[2930]=dot(b,dot(A,c**3*dot(A,c**4*dot(A,c**2))))-1/3744.
    coneq[2931]=dot(b,dot(A,c**3*dot(A,c**4*dot(A,dot(A,c)))))-1/7488.
    coneq[2932]=dot(b,dot(A,c**3*dot(A,c**5*dot(A,c))))-1/2496.
    coneq[2933]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)*dot(A,c**3))))-1/14976.
    coneq[2934]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))-1/44928.
    coneq[2935]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/89856.
    coneq[2936]=dot(b,dot(A,c**3*dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))-1/29952.
    coneq[2937]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))*dot(A,c**3))))-1/29952.
    coneq[2938]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/89856.
    coneq[2939]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/179712.
    coneq[2940]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/59904.
    coneq[2941]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c**4))))-1/12480.
    coneq[2942]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,c**3)))))-1/49920.
    coneq[2943]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/149760.
    coneq[2944]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/299520.
    coneq[2945]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/99840.
    coneq[2946]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))-1/37440.
    coneq[2947]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/74880.
    coneq[2948]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))-1/24960.
    coneq[2949]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/49920.
    coneq[2950]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**2)*dot(A,c**2))))-1/11232.
    coneq[2951]=dot(b,dot(A,c**3*dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))-1/22464.
    coneq[2952]=dot(b,dot(A,c**3*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/44928.
    coneq[2953]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,c**3))))-1/9984.
    coneq[2954]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))-1/29952.
    coneq[2955]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/59904.
    coneq[2956]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))-1/19968.
    coneq[2957]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c)*dot(A,c**2))))-1/7488.
    coneq[2958]=dot(b,dot(A,c**3*dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))-1/14976.
    coneq[2959]=dot(b,dot(A,c**3*dot(A,c**3*dot(A,c)*dot(A,c))))-1/4992.
    coneq[2960]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))-1/14976.
    coneq[2961]=dot(b,dot(A,c**3*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/29952.
    coneq[2962]=dot(b,dot(A,c**3*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))-1/9984.
    coneq[2963]=dot(b,dot(A,c**4*dot(A,c**6)))-1/1092.
    coneq[2964]=dot(b,dot(A,c**4*dot(A,dot(A,c**5))))-1/6552.
    coneq[2965]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c**4)))))-1/32760.
    coneq[2966]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/131040.
    coneq[2967]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/393120.
    coneq[2968]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/786240.
    coneq[2969]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/262080.
    coneq[2970]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/98280.
    coneq[2971]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/196560.
    coneq[2972]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/65520.
    coneq[2973]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/131040.
    coneq[2974]=dot(b,dot(A,c**4*dot(A,dot(A,c*dot(A,c**3)))))-1/26208.
    coneq[2975]=dot(b,dot(A,c**4*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/78624.
    coneq[2976]=dot(b,dot(A,c**4*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/157248.
    coneq[2977]=dot(b,dot(A,c**4*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/52416.
    coneq[2978]=dot(b,dot(A,c**4*dot(A,dot(A,c**2*dot(A,c**2)))))-1/19656.
    coneq[2979]=dot(b,dot(A,c**4*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/39312.
    coneq[2980]=dot(b,dot(A,c**4*dot(A,dot(A,c**3*dot(A,c)))))-1/13104.
    coneq[2981]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/39312.
    coneq[2982]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/78624.
    coneq[2983]=dot(b,dot(A,c**4*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/26208.
    coneq[2984]=dot(b,dot(A,c**4*dot(A,c*dot(A,c**4))))-1/5460.
    coneq[2985]=dot(b,dot(A,c**4*dot(A,c*dot(A,dot(A,c**3)))))-1/21840.
    coneq[2986]=dot(b,dot(A,c**4*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/65520.
    coneq[2987]=dot(b,dot(A,c**4*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/131040.
    coneq[2988]=dot(b,dot(A,c**4*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/43680.
    coneq[2989]=dot(b,dot(A,c**4*dot(A,c*dot(A,c*dot(A,c**2)))))-1/16380.
    coneq[2990]=dot(b,dot(A,c**4*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/32760.
    coneq[2991]=dot(b,dot(A,c**4*dot(A,c*dot(A,c**2*dot(A,c)))))-1/10920.
    coneq[2992]=dot(b,dot(A,c**4*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/21840.
    coneq[2993]=dot(b,dot(A,c**4*dot(A,c**2*dot(A,c**3))))-1/4368.
    coneq[2994]=dot(b,dot(A,c**4*dot(A,c**2*dot(A,dot(A,c**2)))))-1/13104.
    coneq[2995]=dot(b,dot(A,c**4*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/26208.
    coneq[2996]=dot(b,dot(A,c**4*dot(A,c**2*dot(A,c*dot(A,c)))))-1/8736.
    coneq[2997]=dot(b,dot(A,c**4*dot(A,c**3*dot(A,c**2))))-1/3276.
    coneq[2998]=dot(b,dot(A,c**4*dot(A,c**3*dot(A,dot(A,c)))))-1/6552.
    coneq[2999]=dot(b,dot(A,c**4*dot(A,c**4*dot(A,c))))-1/2184.
    coneq[3000]=dot(b,dot(A,c**4*dot(A,dot(A,c**2)*dot(A,c**2))))-1/9828.
    coneq[3001]=dot(b,dot(A,c**4*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/19656.
    coneq[3002]=dot(b,dot(A,c**4*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/39312.
    coneq[3003]=dot(b,dot(A,c**4*dot(A,dot(A,c)*dot(A,c**3))))-1/8736.
    coneq[3004]=dot(b,dot(A,c**4*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/26208.
    coneq[3005]=dot(b,dot(A,c**4*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/52416.
    coneq[3006]=dot(b,dot(A,c**4*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/17472.
    coneq[3007]=dot(b,dot(A,c**4*dot(A,c*dot(A,c)*dot(A,c**2))))-1/6552.
    coneq[3008]=dot(b,dot(A,c**4*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/13104.
    coneq[3009]=dot(b,dot(A,c**4*dot(A,c**2*dot(A,c)*dot(A,c))))-1/4368.
    coneq[3010]=dot(b,dot(A,c**4*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/8736.
    coneq[3011]=dot(b,dot(A,c**5*dot(A,c**5)))-1/936.
    coneq[3012]=dot(b,dot(A,c**5*dot(A,dot(A,c**4))))-1/4680.
    coneq[3013]=dot(b,dot(A,c**5*dot(A,dot(A,dot(A,c**3)))))-1/18720.
    coneq[3014]=dot(b,dot(A,c**5*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/56160.
    coneq[3015]=dot(b,dot(A,c**5*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/112320.
    coneq[3016]=dot(b,dot(A,c**5*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/37440.
    coneq[3017]=dot(b,dot(A,c**5*dot(A,dot(A,c*dot(A,c**2)))))-1/14040.
    coneq[3018]=dot(b,dot(A,c**5*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/28080.
    coneq[3019]=dot(b,dot(A,c**5*dot(A,dot(A,c**2*dot(A,c)))))-1/9360.
    coneq[3020]=dot(b,dot(A,c**5*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/18720.
    coneq[3021]=dot(b,dot(A,c**5*dot(A,c*dot(A,c**3))))-1/3744.
    coneq[3022]=dot(b,dot(A,c**5*dot(A,c*dot(A,dot(A,c**2)))))-1/11232.
    coneq[3023]=dot(b,dot(A,c**5*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/22464.
    coneq[3024]=dot(b,dot(A,c**5*dot(A,c*dot(A,c*dot(A,c)))))-1/7488.
    coneq[3025]=dot(b,dot(A,c**5*dot(A,c**2*dot(A,c**2))))-1/2808.
    coneq[3026]=dot(b,dot(A,c**5*dot(A,c**2*dot(A,dot(A,c)))))-1/5616.
    coneq[3027]=dot(b,dot(A,c**5*dot(A,c**3*dot(A,c))))-1/1872.
    coneq[3028]=dot(b,dot(A,c**5*dot(A,dot(A,c)*dot(A,c**2))))-1/5616.
    coneq[3029]=dot(b,dot(A,c**5*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/11232.
    coneq[3030]=dot(b,dot(A,c**5*dot(A,c*dot(A,c)*dot(A,c))))-1/3744.
    coneq[3031]=dot(b,dot(A,c**6*dot(A,c**4)))-1/780.
    coneq[3032]=dot(b,dot(A,c**6*dot(A,dot(A,c**3))))-1/3120.
    coneq[3033]=dot(b,dot(A,c**6*dot(A,dot(A,dot(A,c**2)))))-1/9360.
    coneq[3034]=dot(b,dot(A,c**6*dot(A,dot(A,dot(A,dot(A,c))))))-1/18720.
    coneq[3035]=dot(b,dot(A,c**6*dot(A,dot(A,c*dot(A,c)))))-1/6240.
    coneq[3036]=dot(b,dot(A,c**6*dot(A,c*dot(A,c**2))))-1/2340.
    coneq[3037]=dot(b,dot(A,c**6*dot(A,c*dot(A,dot(A,c)))))-1/4680.
    coneq[3038]=dot(b,dot(A,c**6*dot(A,c**2*dot(A,c))))-1/1560.
    coneq[3039]=dot(b,dot(A,c**6*dot(A,dot(A,c)*dot(A,c))))-1/3120.
    coneq[3040]=dot(b,dot(A,c**7*dot(A,c**3)))-1/624.
    coneq[3041]=dot(b,dot(A,c**7*dot(A,dot(A,c**2))))-1/1872.
    coneq[3042]=dot(b,dot(A,c**7*dot(A,dot(A,dot(A,c)))))-1/3744.
    coneq[3043]=dot(b,dot(A,c**7*dot(A,c*dot(A,c))))-1/1248.
    coneq[3044]=dot(b,dot(A,c**8*dot(A,c**2)))-1/468.
    coneq[3045]=dot(b,dot(A,c**8*dot(A,dot(A,c))))-1/936.
    coneq[3046]=dot(b,dot(A,c**9*dot(A,c)))-1/312.
    coneq[3047]=dot(b,dot(A,dot(A,c**4)*dot(A,c**5)))-1/4680.
    coneq[3048]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,c**4))))-1/23400.
    coneq[3049]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,dot(A,c**3)))))-1/93600.
    coneq[3050]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/280800.
    coneq[3051]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/561600.
    coneq[3052]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/187200.
    coneq[3053]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,c*dot(A,c**2)))))-1/70200.
    coneq[3054]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/140400.
    coneq[3055]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,c**2*dot(A,c)))))-1/46800.
    coneq[3056]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/93600.
    coneq[3057]=dot(b,dot(A,dot(A,c**4)*dot(A,c*dot(A,c**3))))-1/18720.
    coneq[3058]=dot(b,dot(A,dot(A,c**4)*dot(A,c*dot(A,dot(A,c**2)))))-1/56160.
    coneq[3059]=dot(b,dot(A,dot(A,c**4)*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/112320.
    coneq[3060]=dot(b,dot(A,dot(A,c**4)*dot(A,c*dot(A,c*dot(A,c)))))-1/37440.
    coneq[3061]=dot(b,dot(A,dot(A,c**4)*dot(A,c**2*dot(A,c**2))))-1/14040.
    coneq[3062]=dot(b,dot(A,dot(A,c**4)*dot(A,c**2*dot(A,dot(A,c)))))-1/28080.
    coneq[3063]=dot(b,dot(A,dot(A,c**4)*dot(A,c**3*dot(A,c))))-1/9360.
    coneq[3064]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,c)*dot(A,c**2))))-1/28080.
    coneq[3065]=dot(b,dot(A,dot(A,c**4)*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/56160.
    coneq[3066]=dot(b,dot(A,dot(A,c**4)*dot(A,c*dot(A,c)*dot(A,c))))-1/18720.
    coneq[3067]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c**5)))-1/18720.
    coneq[3068]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c**4))))-1/93600.
    coneq[3069]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,c**3)))))-1/374400.
    coneq[3070]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/1123200.
    coneq[3071]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/2246400.
    coneq[3072]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/748800.
    coneq[3073]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c*dot(A,c**2)))))-1/280800.
    coneq[3074]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/561600.
    coneq[3075]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c**2*dot(A,c)))))-1/187200.
    coneq[3076]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/374400.
    coneq[3077]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c*dot(A,c**3))))-1/74880.
    coneq[3078]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c*dot(A,dot(A,c**2)))))-1/224640.
    coneq[3079]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/449280.
    coneq[3080]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c*dot(A,c*dot(A,c)))))-1/149760.
    coneq[3081]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c**2*dot(A,c**2))))-1/56160.
    coneq[3082]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c**2*dot(A,dot(A,c)))))-1/112320.
    coneq[3083]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c**3*dot(A,c))))-1/37440.
    coneq[3084]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c)*dot(A,c**2))))-1/112320.
    coneq[3085]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/224640.
    coneq[3086]=dot(b,dot(A,dot(A,dot(A,c**3))*dot(A,c*dot(A,c)*dot(A,c))))-1/74880.
    coneq[3087]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c**5)))-1/56160.
    coneq[3088]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c**4))))-1/280800.
    coneq[3089]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c**3)))))-1/1123200.
    coneq[3090]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/3369600.
    coneq[3091]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/6739200.
    coneq[3092]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/2246400.
    coneq[3093]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c*dot(A,c**2)))))-1/842400.
    coneq[3094]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/1684800.
    coneq[3095]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c**2*dot(A,c)))))-1/561600.
    coneq[3096]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/1123200.
    coneq[3097]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,c**3))))-1/224640.
    coneq[3098]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,dot(A,c**2)))))-1/673920.
    coneq[3099]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/1347840.
    coneq[3100]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,c*dot(A,c)))))-1/449280.
    coneq[3101]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2*dot(A,c**2))))-1/168480.
    coneq[3102]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c**2*dot(A,dot(A,c)))))-1/336960.
    coneq[3103]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c**3*dot(A,c))))-1/112320.
    coneq[3104]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c)*dot(A,c**2))))-1/336960.
    coneq[3105]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/673920.
    coneq[3106]=dot(b,dot(A,dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,c)*dot(A,c))))-1/224640.
    coneq[3107]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**5)))-1/112320.
    coneq[3108]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**4))))-1/561600.
    coneq[3109]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c**3)))))-1/2246400.
    coneq[3110]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/6739200.
    coneq[3111]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/13478400.
    coneq[3112]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/4492800.
    coneq[3113]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c*dot(A,c**2)))))-1/1684800.
    coneq[3114]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/3369600.
    coneq[3115]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c**2*dot(A,c)))))-1/1123200.
    coneq[3116]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/2246400.
    coneq[3117]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c**3))))-1/449280.
    coneq[3118]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,dot(A,c**2)))))-1/1347840.
    coneq[3119]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/2695680.
    coneq[3120]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c*dot(A,c)))))-1/898560.
    coneq[3121]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2*dot(A,c**2))))-1/336960.
    coneq[3122]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2*dot(A,dot(A,c)))))-1/673920.
    coneq[3123]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**3*dot(A,c))))-1/224640.
    coneq[3124]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)*dot(A,c**2))))-1/673920.
    coneq[3125]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/1347840.
    coneq[3126]=dot(b,dot(A,dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c)*dot(A,c))))-1/449280.
    coneq[3127]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c**5)))-1/37440.
    coneq[3128]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c**4))))-1/187200.
    coneq[3129]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c**3)))))-1/748800.
    coneq[3130]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/2246400.
    coneq[3131]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/4492800.
    coneq[3132]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/1497600.
    coneq[3133]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c*dot(A,c**2)))))-1/561600.
    coneq[3134]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/1123200.
    coneq[3135]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c**2*dot(A,c)))))-1/374400.
    coneq[3136]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/748800.
    coneq[3137]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,c**3))))-1/149760.
    coneq[3138]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,dot(A,c**2)))))-1/449280.
    coneq[3139]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/898560.
    coneq[3140]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,c*dot(A,c)))))-1/299520.
    coneq[3141]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2*dot(A,c**2))))-1/112320.
    coneq[3142]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c**2*dot(A,dot(A,c)))))-1/224640.
    coneq[3143]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c**3*dot(A,c))))-1/74880.
    coneq[3144]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c)*dot(A,c**2))))-1/224640.
    coneq[3145]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/449280.
    coneq[3146]=dot(b,dot(A,dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,c)*dot(A,c))))-1/149760.
    coneq[3147]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c**5)))-1/14040.
    coneq[3148]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,c**4))))-1/70200.
    coneq[3149]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,c**3)))))-1/280800.
    coneq[3150]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/842400.
    coneq[3151]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/1684800.
    coneq[3152]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/561600.
    coneq[3153]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,c*dot(A,c**2)))))-1/210600.
    coneq[3154]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/421200.
    coneq[3155]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,c**2*dot(A,c)))))-1/140400.
    coneq[3156]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/280800.
    coneq[3157]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c**3))))-1/56160.
    coneq[3158]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,dot(A,c**2)))))-1/168480.
    coneq[3159]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/336960.
    coneq[3160]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c*dot(A,c)))))-1/112320.
    coneq[3161]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c**2*dot(A,c**2))))-1/42120.
    coneq[3162]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c**2*dot(A,dot(A,c)))))-1/84240.
    coneq[3163]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c**3*dot(A,c))))-1/28080.
    coneq[3164]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,c)*dot(A,c**2))))-1/84240.
    coneq[3165]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/168480.
    coneq[3166]=dot(b,dot(A,dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c)*dot(A,c))))-1/56160.
    coneq[3167]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c**5)))-1/28080.
    coneq[3168]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c**4))))-1/140400.
    coneq[3169]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**3)))))-1/561600.
    coneq[3170]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/1684800.
    coneq[3171]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/3369600.
    coneq[3172]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/1123200.
    coneq[3173]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c**2)))))-1/421200.
    coneq[3174]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/842400.
    coneq[3175]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c**2*dot(A,c)))))-1/280800.
    coneq[3176]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/561600.
    coneq[3177]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,c**3))))-1/112320.
    coneq[3178]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c**2)))))-1/336960.
    coneq[3179]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/673920.
    coneq[3180]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,c*dot(A,c)))))-1/224640.
    coneq[3181]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2*dot(A,c**2))))-1/84240.
    coneq[3182]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c**2*dot(A,dot(A,c)))))-1/168480.
    coneq[3183]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c**3*dot(A,c))))-1/56160.
    coneq[3184]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c**2))))-1/168480.
    coneq[3185]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/336960.
    coneq[3186]=dot(b,dot(A,dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,c)*dot(A,c))))-1/112320.
    coneq[3187]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,c**5)))-1/9360.
    coneq[3188]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,c**4))))-1/46800.
    coneq[3189]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,c**3)))))-1/187200.
    coneq[3190]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/561600.
    coneq[3191]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/1123200.
    coneq[3192]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/374400.
    coneq[3193]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,c*dot(A,c**2)))))-1/140400.
    coneq[3194]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/280800.
    coneq[3195]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,c**2*dot(A,c)))))-1/93600.
    coneq[3196]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/187200.
    coneq[3197]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,c**3))))-1/37440.
    coneq[3198]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,dot(A,c**2)))))-1/112320.
    coneq[3199]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/224640.
    coneq[3200]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,c*dot(A,c)))))-1/74880.
    coneq[3201]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,c**2*dot(A,c**2))))-1/28080.
    coneq[3202]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,c**2*dot(A,dot(A,c)))))-1/56160.
    coneq[3203]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,c**3*dot(A,c))))-1/18720.
    coneq[3204]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,c)*dot(A,c**2))))-1/56160.
    coneq[3205]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/112320.
    coneq[3206]=dot(b,dot(A,dot(A,c**2*dot(A,c))*dot(A,c*dot(A,c)*dot(A,c))))-1/37440.
    coneq[3207]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,c**5)))-1/18720.
    coneq[3208]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c**4))))-1/93600.
    coneq[3209]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c**3)))))-1/374400.
    coneq[3210]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/1123200.
    coneq[3211]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/2246400.
    coneq[3212]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/748800.
    coneq[3213]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c*dot(A,c**2)))))-1/280800.
    coneq[3214]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/561600.
    coneq[3215]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c**2*dot(A,c)))))-1/187200.
    coneq[3216]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/374400.
    coneq[3217]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,c**3))))-1/74880.
    coneq[3218]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,dot(A,c**2)))))-1/224640.
    coneq[3219]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/449280.
    coneq[3220]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,c*dot(A,c)))))-1/149760.
    coneq[3221]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2*dot(A,c**2))))-1/56160.
    coneq[3222]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,c**2*dot(A,dot(A,c)))))-1/112320.
    coneq[3223]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,c**3*dot(A,c))))-1/37440.
    coneq[3224]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c)*dot(A,c**2))))-1/112320.
    coneq[3225]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/224640.
    coneq[3226]=dot(b,dot(A,dot(A,dot(A,c)*dot(A,c))*dot(A,c*dot(A,c)*dot(A,c))))-1/74880.
    coneq[3227]=dot(b,dot(A,dot(A,c**3)*dot(A,c**6)))-1/4368.
    coneq[3228]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**5))))-1/26208.
    coneq[3229]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c**4)))))-1/131040.
    coneq[3230]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/524160.
    coneq[3231]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1572480.
    coneq[3232]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/3144960.
    coneq[3233]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/1048320.
    coneq[3234]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/393120.
    coneq[3235]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/786240.
    coneq[3236]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/262080.
    coneq[3237]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/524160.
    coneq[3238]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,c**3)))))-1/104832.
    coneq[3239]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/314496.
    coneq[3240]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/628992.
    coneq[3241]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/209664.
    coneq[3242]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**2*dot(A,c**2)))))-1/78624.
    coneq[3243]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/157248.
    coneq[3244]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**3*dot(A,c)))))-1/52416.
    coneq[3245]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/157248.
    coneq[3246]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/314496.
    coneq[3247]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/104832.
    coneq[3248]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c**4))))-1/21840.
    coneq[3249]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,c**3)))))-1/87360.
    coneq[3250]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/262080.
    coneq[3251]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/524160.
    coneq[3252]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/174720.
    coneq[3253]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c*dot(A,c**2)))))-1/65520.
    coneq[3254]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/131040.
    coneq[3255]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c**2*dot(A,c)))))-1/43680.
    coneq[3256]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/87360.
    coneq[3257]=dot(b,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,c**3))))-1/17472.
    coneq[3258]=dot(b,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,dot(A,c**2)))))-1/52416.
    coneq[3259]=dot(b,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/104832.
    coneq[3260]=dot(b,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,c*dot(A,c)))))-1/34944.
    coneq[3261]=dot(b,dot(A,dot(A,c**3)*dot(A,c**3*dot(A,c**2))))-1/13104.
    coneq[3262]=dot(b,dot(A,dot(A,c**3)*dot(A,c**3*dot(A,dot(A,c)))))-1/26208.
    coneq[3263]=dot(b,dot(A,dot(A,c**3)*dot(A,c**4*dot(A,c))))-1/8736.
    coneq[3264]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**2)*dot(A,c**2))))-1/39312.
    coneq[3265]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/78624.
    coneq[3266]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/157248.
    coneq[3267]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,c**3))))-1/34944.
    coneq[3268]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/104832.
    coneq[3269]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/209664.
    coneq[3270]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/69888.
    coneq[3271]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c)*dot(A,c**2))))-1/26208.
    coneq[3272]=dot(b,dot(A,dot(A,c**3)*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/52416.
    coneq[3273]=dot(b,dot(A,dot(A,c**3)*dot(A,c**2*dot(A,c)*dot(A,c))))-1/17472.
    coneq[3274]=dot(b,dot(A,dot(A,c**3)*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/34944.
    coneq[3275]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**6)))-1/13104.
    coneq[3276]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**5))))-1/78624.
    coneq[3277]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**4)))))-1/393120.
    coneq[3278]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/1572480.
    coneq[3279]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/4717440.
    coneq[3280]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/9434880.
    coneq[3281]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/3144960.
    coneq[3282]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/1179360.
    coneq[3283]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/2358720.
    coneq[3284]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/786240.
    coneq[3285]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/1572480.
    coneq[3286]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c**3)))))-1/314496.
    coneq[3287]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/943488.
    coneq[3288]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/1886976.
    coneq[3289]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/628992.
    coneq[3290]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2*dot(A,c**2)))))-1/235872.
    coneq[3291]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/471744.
    coneq[3292]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**3*dot(A,c)))))-1/157248.
    coneq[3293]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/471744.
    coneq[3294]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/943488.
    coneq[3295]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/314496.
    coneq[3296]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c**4))))-1/65520.
    coneq[3297]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c**3)))))-1/262080.
    coneq[3298]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/786240.
    coneq[3299]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1572480.
    coneq[3300]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/524160.
    coneq[3301]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c*dot(A,c**2)))))-1/196560.
    coneq[3302]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/393120.
    coneq[3303]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c**2*dot(A,c)))))-1/131040.
    coneq[3304]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/262080.
    coneq[3305]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c**3))))-1/52416.
    coneq[3306]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,dot(A,c**2)))))-1/157248.
    coneq[3307]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/314496.
    coneq[3308]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c*dot(A,c)))))-1/104832.
    coneq[3309]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**3*dot(A,c**2))))-1/39312.
    coneq[3310]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**3*dot(A,dot(A,c)))))-1/78624.
    coneq[3311]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**4*dot(A,c))))-1/26208.
    coneq[3312]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)*dot(A,c**2))))-1/117936.
    coneq[3313]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/235872.
    coneq[3314]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/471744.
    coneq[3315]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c**3))))-1/104832.
    coneq[3316]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/314496.
    coneq[3317]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/628992.
    coneq[3318]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/209664.
    coneq[3319]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)*dot(A,c**2))))-1/78624.
    coneq[3320]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/157248.
    coneq[3321]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c)*dot(A,c))))-1/52416.
    coneq[3322]=dot(b,dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/104832.
    coneq[3323]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**6)))-1/26208.
    coneq[3324]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**5))))-1/157248.
    coneq[3325]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**4)))))-1/786240.
    coneq[3326]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/3144960.
    coneq[3327]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/9434880.
    coneq[3328]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/18869760.
    coneq[3329]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/6289920.
    coneq[3330]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/2358720.
    coneq[3331]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/4717440.
    coneq[3332]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/1572480.
    coneq[3333]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/3144960.
    coneq[3334]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c**3)))))-1/628992.
    coneq[3335]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/1886976.
    coneq[3336]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/3773952.
    coneq[3337]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/1257984.
    coneq[3338]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2*dot(A,c**2)))))-1/471744.
    coneq[3339]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/943488.
    coneq[3340]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**3*dot(A,c)))))-1/314496.
    coneq[3341]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/943488.
    coneq[3342]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/1886976.
    coneq[3343]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/628992.
    coneq[3344]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**4))))-1/131040.
    coneq[3345]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c**3)))))-1/524160.
    coneq[3346]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/1572480.
    coneq[3347]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/3144960.
    coneq[3348]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/1048320.
    coneq[3349]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c*dot(A,c**2)))))-1/393120.
    coneq[3350]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/786240.
    coneq[3351]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**2*dot(A,c)))))-1/262080.
    coneq[3352]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/524160.
    coneq[3353]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c**3))))-1/104832.
    coneq[3354]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,dot(A,c**2)))))-1/314496.
    coneq[3355]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/628992.
    coneq[3356]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c*dot(A,c)))))-1/209664.
    coneq[3357]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**3*dot(A,c**2))))-1/78624.
    coneq[3358]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**3*dot(A,dot(A,c)))))-1/157248.
    coneq[3359]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**4*dot(A,c))))-1/52416.
    coneq[3360]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2)*dot(A,c**2))))-1/235872.
    coneq[3361]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/471744.
    coneq[3362]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/943488.
    coneq[3363]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c**3))))-1/209664.
    coneq[3364]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/628992.
    coneq[3365]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/1257984.
    coneq[3366]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/419328.
    coneq[3367]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)*dot(A,c**2))))-1/157248.
    coneq[3368]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/314496.
    coneq[3369]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c)*dot(A,c))))-1/104832.
    coneq[3370]=dot(b,dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/209664.
    coneq[3371]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**6)))-1/8736.
    coneq[3372]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**5))))-1/52416.
    coneq[3373]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**4)))))-1/262080.
    coneq[3374]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/1048320.
    coneq[3375]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/3144960.
    coneq[3376]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/6289920.
    coneq[3377]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/2096640.
    coneq[3378]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/786240.
    coneq[3379]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/1572480.
    coneq[3380]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/524160.
    coneq[3381]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/1048320.
    coneq[3382]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c**3)))))-1/209664.
    coneq[3383]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/628992.
    coneq[3384]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/1257984.
    coneq[3385]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/419328.
    coneq[3386]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**2*dot(A,c**2)))))-1/157248.
    coneq[3387]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/314496.
    coneq[3388]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**3*dot(A,c)))))-1/104832.
    coneq[3389]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/314496.
    coneq[3390]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/628992.
    coneq[3391]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/209664.
    coneq[3392]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c**4))))-1/43680.
    coneq[3393]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c**3)))))-1/174720.
    coneq[3394]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/524160.
    coneq[3395]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1048320.
    coneq[3396]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/349440.
    coneq[3397]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c*dot(A,c**2)))))-1/131040.
    coneq[3398]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/262080.
    coneq[3399]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c**2*dot(A,c)))))-1/87360.
    coneq[3400]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/174720.
    coneq[3401]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c**3))))-1/34944.
    coneq[3402]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,dot(A,c**2)))))-1/104832.
    coneq[3403]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/209664.
    coneq[3404]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c*dot(A,c)))))-1/69888.
    coneq[3405]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**3*dot(A,c**2))))-1/26208.
    coneq[3406]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**3*dot(A,dot(A,c)))))-1/52416.
    coneq[3407]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**4*dot(A,c))))-1/17472.
    coneq[3408]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**2)*dot(A,c**2))))-1/78624.
    coneq[3409]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/157248.
    coneq[3410]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/314496.
    coneq[3411]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c**3))))-1/69888.
    coneq[3412]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/209664.
    coneq[3413]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/419328.
    coneq[3414]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/139776.
    coneq[3415]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)*dot(A,c**2))))-1/52416.
    coneq[3416]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/104832.
    coneq[3417]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c)*dot(A,c))))-1/34944.
    coneq[3418]=dot(b,dot(A,dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/69888.
    coneq[3419]=dot(b,dot(A,dot(A,c**2)*dot(A,c**7)))-1/3744.
    coneq[3420]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**6))))-1/26208.
    coneq[3421]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**5)))))-1/157248.
    coneq[3422]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**4))))))-1/786240.
    coneq[3423]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/3144960.
    coneq[3424]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/9434880.
    coneq[3425]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/18869760.
    coneq[3426]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/6289920.
    coneq[3427]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/2358720.
    coneq[3428]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/4717440.
    coneq[3429]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/1572480.
    coneq[3430]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/3144960.
    coneq[3431]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c**3))))))-1/628992.
    coneq[3432]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/1886976.
    coneq[3433]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/3773952.
    coneq[3434]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/1257984.
    coneq[3435]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))-1/471744.
    coneq[3436]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/943488.
    coneq[3437]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**3*dot(A,c))))))-1/314496.
    coneq[3438]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/943488.
    coneq[3439]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1886976.
    coneq[3440]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/628992.
    coneq[3441]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c**4)))))-1/131040.
    coneq[3442]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c**3))))))-1/524160.
    coneq[3443]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/1572480.
    coneq[3444]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/3144960.
    coneq[3445]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/1048320.
    coneq[3446]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))-1/393120.
    coneq[3447]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/786240.
    coneq[3448]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))-1/262080.
    coneq[3449]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/524160.
    coneq[3450]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c**3)))))-1/104832.
    coneq[3451]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))-1/314496.
    coneq[3452]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/628992.
    coneq[3453]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))-1/209664.
    coneq[3454]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**3*dot(A,c**2)))))-1/78624.
    coneq[3455]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**3*dot(A,dot(A,c))))))-1/157248.
    coneq[3456]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**4*dot(A,c)))))-1/52416.
    coneq[3457]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))-1/235872.
    coneq[3458]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/471744.
    coneq[3459]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/943488.
    coneq[3460]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c**3)))))-1/209664.
    coneq[3461]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/628992.
    coneq[3462]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/1257984.
    coneq[3463]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/419328.
    coneq[3464]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))-1/157248.
    coneq[3465]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/314496.
    coneq[3466]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))-1/104832.
    coneq[3467]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/209664.
    coneq[3468]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**5))))-1/22464.
    coneq[3469]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c**4)))))-1/112320.
    coneq[3470]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c**3))))))-1/449280.
    coneq[3471]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1347840.
    coneq[3472]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/2695680.
    coneq[3473]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/898560.
    coneq[3474]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))-1/336960.
    coneq[3475]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/673920.
    coneq[3476]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))-1/224640.
    coneq[3477]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/449280.
    coneq[3478]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c**3)))))-1/89856.
    coneq[3479]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))-1/269568.
    coneq[3480]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/539136.
    coneq[3481]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))-1/179712.
    coneq[3482]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2*dot(A,c**2)))))-1/67392.
    coneq[3483]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))-1/134784.
    coneq[3484]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**3*dot(A,c)))))-1/44928.
    coneq[3485]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))-1/134784.
    coneq[3486]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/269568.
    coneq[3487]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))-1/89856.
    coneq[3488]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c**4))))-1/18720.
    coneq[3489]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c**3)))))-1/74880.
    coneq[3490]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))-1/224640.
    coneq[3491]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))-1/449280.
    coneq[3492]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))-1/149760.
    coneq[3493]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c*dot(A,c**2)))))-1/56160.
    coneq[3494]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))-1/112320.
    coneq[3495]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c**2*dot(A,c)))))-1/37440.
    coneq[3496]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))-1/74880.
    coneq[3497]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,c**3))))-1/14976.
    coneq[3498]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,dot(A,c**2)))))-1/44928.
    coneq[3499]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,dot(A,dot(A,c))))))-1/89856.
    coneq[3500]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,c*dot(A,c)))))-1/29952.
    coneq[3501]=dot(b,dot(A,dot(A,c**2)*dot(A,c**4*dot(A,c**2))))-1/11232.
    coneq[3502]=dot(b,dot(A,dot(A,c**2)*dot(A,c**4*dot(A,dot(A,c)))))-1/22464.
    coneq[3503]=dot(b,dot(A,dot(A,c**2)*dot(A,c**5*dot(A,c))))-1/7488.
    coneq[3504]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)*dot(A,c**3))))-1/44928.
    coneq[3505]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))-1/134784.
    coneq[3506]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/269568.
    coneq[3507]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))-1/89856.
    coneq[3508]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))*dot(A,c**3))))-1/89856.
    coneq[3509]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/269568.
    coneq[3510]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/539136.
    coneq[3511]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/179712.
    coneq[3512]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**4))))-1/37440.
    coneq[3513]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c**3)))))-1/149760.
    coneq[3514]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/449280.
    coneq[3515]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/898560.
    coneq[3516]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/299520.
    coneq[3517]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))-1/112320.
    coneq[3518]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/224640.
    coneq[3519]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))-1/74880.
    coneq[3520]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/149760.
    coneq[3521]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2)*dot(A,c**2))))-1/33696.
    coneq[3522]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))-1/67392.
    coneq[3523]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/134784.
    coneq[3524]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c**3))))-1/29952.
    coneq[3525]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))-1/89856.
    coneq[3526]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/179712.
    coneq[3527]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))-1/59904.
    coneq[3528]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)*dot(A,c**2))))-1/22464.
    coneq[3529]=dot(b,dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))-1/44928.
    coneq[3530]=dot(b,dot(A,dot(A,c**2)*dot(A,c**3*dot(A,c)*dot(A,c))))-1/14976.
    coneq[3531]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))-1/44928.
    coneq[3532]=dot(b,dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/89856.
    coneq[3533]=dot(b,dot(A,dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))-1/29952.
    coneq[3534]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**7)))-1/7488.
    coneq[3535]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**6))))-1/52416.
    coneq[3536]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**5)))))-1/314496.
    coneq[3537]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**4))))))-1/1572480.
    coneq[3538]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/6289920.
    coneq[3539]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/18869760.
    coneq[3540]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/37739520.
    coneq[3541]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/12579840.
    coneq[3542]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/4717440.
    coneq[3543]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/9434880.
    coneq[3544]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/3144960.
    coneq[3545]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/6289920.
    coneq[3546]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c**3))))))-1/1257984.
    coneq[3547]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/3773952.
    coneq[3548]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/7547904.
    coneq[3549]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/2515968.
    coneq[3550]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))-1/943488.
    coneq[3551]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/1886976.
    coneq[3552]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**3*dot(A,c))))))-1/628992.
    coneq[3553]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/1886976.
    coneq[3554]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/3773952.
    coneq[3555]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/1257984.
    coneq[3556]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**4)))))-1/262080.
    coneq[3557]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c**3))))))-1/1048320.
    coneq[3558]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/3144960.
    coneq[3559]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/6289920.
    coneq[3560]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/2096640.
    coneq[3561]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))-1/786240.
    coneq[3562]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/1572480.
    coneq[3563]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))-1/524160.
    coneq[3564]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/1048320.
    coneq[3565]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c**3)))))-1/209664.
    coneq[3566]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))-1/628992.
    coneq[3567]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/1257984.
    coneq[3568]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))-1/419328.
    coneq[3569]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3*dot(A,c**2)))))-1/157248.
    coneq[3570]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3*dot(A,dot(A,c))))))-1/314496.
    coneq[3571]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**4*dot(A,c)))))-1/104832.
    coneq[3572]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))-1/471744.
    coneq[3573]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/943488.
    coneq[3574]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/1886976.
    coneq[3575]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c**3)))))-1/419328.
    coneq[3576]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/1257984.
    coneq[3577]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/2515968.
    coneq[3578]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/838656.
    coneq[3579]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))-1/314496.
    coneq[3580]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/628992.
    coneq[3581]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))-1/209664.
    coneq[3582]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/419328.
    coneq[3583]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**5))))-1/44928.
    coneq[3584]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**4)))))-1/224640.
    coneq[3585]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c**3))))))-1/898560.
    coneq[3586]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/2695680.
    coneq[3587]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/5391360.
    coneq[3588]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/1797120.
    coneq[3589]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))-1/673920.
    coneq[3590]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/1347840.
    coneq[3591]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))-1/449280.
    coneq[3592]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/898560.
    coneq[3593]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c**3)))))-1/179712.
    coneq[3594]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))-1/539136.
    coneq[3595]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/1078272.
    coneq[3596]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))-1/359424.
    coneq[3597]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2*dot(A,c**2)))))-1/134784.
    coneq[3598]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))-1/269568.
    coneq[3599]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**3*dot(A,c)))))-1/89856.
    coneq[3600]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))-1/269568.
    coneq[3601]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/539136.
    coneq[3602]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))-1/179712.
    coneq[3603]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c**4))))-1/37440.
    coneq[3604]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c**3)))))-1/149760.
    coneq[3605]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))-1/449280.
    coneq[3606]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))-1/898560.
    coneq[3607]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))-1/299520.
    coneq[3608]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c*dot(A,c**2)))))-1/112320.
    coneq[3609]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))-1/224640.
    coneq[3610]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c**2*dot(A,c)))))-1/74880.
    coneq[3611]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))-1/149760.
    coneq[3612]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,c**3))))-1/29952.
    coneq[3613]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,dot(A,c**2)))))-1/89856.
    coneq[3614]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,dot(A,dot(A,c))))))-1/179712.
    coneq[3615]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,c*dot(A,c)))))-1/59904.
    coneq[3616]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**4*dot(A,c**2))))-1/22464.
    coneq[3617]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**4*dot(A,dot(A,c)))))-1/44928.
    coneq[3618]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**5*dot(A,c))))-1/14976.
    coneq[3619]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)*dot(A,c**3))))-1/89856.
    coneq[3620]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))-1/269568.
    coneq[3621]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/539136.
    coneq[3622]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))-1/179712.
    coneq[3623]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))*dot(A,c**3))))-1/179712.
    coneq[3624]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/539136.
    coneq[3625]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/1078272.
    coneq[3626]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/359424.
    coneq[3627]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**4))))-1/74880.
    coneq[3628]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c**3)))))-1/299520.
    coneq[3629]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/898560.
    coneq[3630]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1797120.
    coneq[3631]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/599040.
    coneq[3632]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))-1/224640.
    coneq[3633]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/449280.
    coneq[3634]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))-1/149760.
    coneq[3635]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/299520.
    coneq[3636]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2)*dot(A,c**2))))-1/67392.
    coneq[3637]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))-1/134784.
    coneq[3638]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/269568.
    coneq[3639]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c**3))))-1/59904.
    coneq[3640]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))-1/179712.
    coneq[3641]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/359424.
    coneq[3642]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))-1/119808.
    coneq[3643]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)*dot(A,c**2))))-1/44928.
    coneq[3644]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))-1/89856.
    coneq[3645]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c**3*dot(A,c)*dot(A,c))))-1/29952.
    coneq[3646]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))-1/89856.
    coneq[3647]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/179712.
    coneq[3648]=dot(b,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))-1/59904.
    coneq[3649]=dot(b,dot(A,dot(A,c)*dot(A,c**8)))-1/2808.
    coneq[3650]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**7))))-1/22464.
    coneq[3651]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**6)))))-1/157248.
    coneq[3652]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**5))))))-1/943488.
    coneq[3653]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**4)))))))-1/4717440.
    coneq[3654]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**3))))))))-1/18869760.
    coneq[3655]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))))-1/56609280.
    coneq[3656]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))))-1/113218560.
    coneq[3657]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))))-1/37739520.
    coneq[3658]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2))))))))-1/14152320.
    coneq[3659]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))))-1/28304640.
    coneq[3660]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c))))))))-1/9434880.
    coneq[3661]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))))-1/18869760.
    coneq[3662]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**3)))))))-1/3773952.
    coneq[3663]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2))))))))-1/11321856.
    coneq[3664]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))))-1/22643712.
    coneq[3665]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c))))))))-1/7547904.
    coneq[3666]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c**2)))))))-1/2830464.
    coneq[3667]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c))))))))-1/5660928.
    coneq[3668]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**3*dot(A,c)))))))-1/1886976.
    coneq[3669]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2)))))))-1/5660928.
    coneq[3670]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))))-1/11321856.
    coneq[3671]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c)))))))-1/3773952.
    coneq[3672]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**4))))))-1/786240.
    coneq[3673]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**3)))))))-1/3144960.
    coneq[3674]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2))))))))-1/9434880.
    coneq[3675]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))))-1/18869760.
    coneq[3676]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c))))))))-1/6289920.
    coneq[3677]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c**2)))))))-1/2358720.
    coneq[3678]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c))))))))-1/4717440.
    coneq[3679]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**2*dot(A,c)))))))-1/1572480.
    coneq[3680]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c)))))))-1/3144960.
    coneq[3681]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c**3))))))-1/628992.
    coneq[3682]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c**2)))))))-1/1886976.
    coneq[3683]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c))))))))-1/3773952.
    coneq[3684]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c*dot(A,c)))))))-1/1257984.
    coneq[3685]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3*dot(A,c**2))))))-1/471744.
    coneq[3686]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3*dot(A,dot(A,c)))))))-1/943488.
    coneq[3687]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**4*dot(A,c))))))-1/314496.
    coneq[3688]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,c**2))))))-1/1415232.
    coneq[3689]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c)))))))-1/2830464.
    coneq[3690]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))))-1/5660928.
    coneq[3691]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**3))))))-1/1257984.
    coneq[3692]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2)))))))-1/3773952.
    coneq[3693]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))))-1/7547904.
    coneq[3694]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c)))))))-1/2515968.
    coneq[3695]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c**2))))))-1/943488.
    coneq[3696]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c)))))))-1/1886976.
    coneq[3697]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c)*dot(A,c))))))-1/628992.
    coneq[3698]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c))))))-1/1257984.
    coneq[3699]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**5)))))-1/134784.
    coneq[3700]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**4))))))-1/673920.
    coneq[3701]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**3)))))))-1/2695680.
    coneq[3702]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/8087040.
    coneq[3703]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/16174080.
    coneq[3704]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/5391360.
    coneq[3705]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c**2)))))))-1/2021760.
    coneq[3706]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/4043520.
    coneq[3707]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**2*dot(A,c)))))))-1/1347840.
    coneq[3708]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/2695680.
    coneq[3709]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c**3))))))-1/539136.
    coneq[3710]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c**2)))))))-1/1617408.
    coneq[3711]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/3234816.
    coneq[3712]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c*dot(A,c)))))))-1/1078272.
    coneq[3713]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2*dot(A,c**2))))))-1/404352.
    coneq[3714]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2*dot(A,dot(A,c)))))))-1/808704.
    coneq[3715]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**3*dot(A,c))))))-1/269568.
    coneq[3716]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c**2))))))-1/808704.
    coneq[3717]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1617408.
    coneq[3718]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c)*dot(A,c))))))-1/539136.
    coneq[3719]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c**4)))))-1/112320.
    coneq[3720]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c**3))))))-1/449280.
    coneq[3721]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c**2)))))))-1/1347840.
    coneq[3722]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2695680.
    coneq[3723]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c*dot(A,c)))))))-1/898560.
    coneq[3724]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c*dot(A,c**2))))))-1/336960.
    coneq[3725]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c*dot(A,dot(A,c)))))))-1/673920.
    coneq[3726]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c**2*dot(A,c))))))-1/224640.
    coneq[3727]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c)*dot(A,c))))))-1/449280.
    coneq[3728]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,c**3)))))-1/89856.
    coneq[3729]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,dot(A,c**2))))))-1/269568.
    coneq[3730]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,dot(A,dot(A,c)))))))-1/539136.
    coneq[3731]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,c*dot(A,c))))))-1/179712.
    coneq[3732]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**4*dot(A,c**2)))))-1/67392.
    coneq[3733]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**4*dot(A,dot(A,c))))))-1/134784.
    coneq[3734]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**5*dot(A,c)))))-1/44928.
    coneq[3735]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)*dot(A,c**3)))))-1/269568.
    coneq[3736]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c**2))))))-1/808704.
    coneq[3737]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c)))))))-1/1617408.
    coneq[3738]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)*dot(A,c*dot(A,c))))))-1/539136.
    coneq[3739]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c**3)))))-1/539136.
    coneq[3740]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2))))))-1/1617408.
    coneq[3741]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)))))))-1/3234816.
    coneq[3742]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c))))))-1/1078272.
    coneq[3743]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**4)))))-1/224640.
    coneq[3744]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**3))))))-1/898560.
    coneq[3745]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2)))))))-1/2695680.
    coneq[3746]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))))))))-1/5391360.
    coneq[3747]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)))))))-1/1797120.
    coneq[3748]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c**2))))))-1/673920.
    coneq[3749]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)))))))-1/1347840.
    coneq[3750]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**2*dot(A,c))))))-1/449280.
    coneq[3751]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c))))))-1/898560.
    coneq[3752]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2)*dot(A,c**2)))))-1/202176.
    coneq[3753]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2)*dot(A,dot(A,c))))))-1/404352.
    coneq[3754]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/808704.
    coneq[3755]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c**3)))))-1/179712.
    coneq[3756]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c**2))))))-1/539136.
    coneq[3757]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/1078272.
    coneq[3758]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c*dot(A,c))))))-1/359424.
    coneq[3759]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c)*dot(A,c**2)))))-1/134784.
    coneq[3760]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c)*dot(A,dot(A,c))))))-1/269568.
    coneq[3761]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3*dot(A,c)*dot(A,c)))))-1/89856.
    coneq[3762]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c**2)))))-1/269568.
    coneq[3763]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c))))))-1/539136.
    coneq[3764]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c)*dot(A,c)))))-1/179712.
    coneq[3765]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**6))))-1/19656.
    coneq[3766]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**5)))))-1/117936.
    coneq[3767]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**4))))))-1/589680.
    coneq[3768]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/2358720.
    coneq[3769]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/7076160.
    coneq[3770]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/14152320.
    coneq[3771]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/4717440.
    coneq[3772]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/1769040.
    coneq[3773]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/3538080.
    coneq[3774]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/1179360.
    coneq[3775]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/2358720.
    coneq[3776]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c**3))))))-1/471744.
    coneq[3777]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/1415232.
    coneq[3778]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/2830464.
    coneq[3779]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/943488.
    coneq[3780]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2*dot(A,c**2))))))-1/353808.
    coneq[3781]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/707616.
    coneq[3782]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**3*dot(A,c))))))-1/235872.
    coneq[3783]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/707616.
    coneq[3784]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1415232.
    coneq[3785]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/471744.
    coneq[3786]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c**4)))))-1/98280.
    coneq[3787]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c**3))))))-1/393120.
    coneq[3788]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/1179360.
    coneq[3789]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2358720.
    coneq[3790]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/786240.
    coneq[3791]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c*dot(A,c**2))))))-1/294840.
    coneq[3792]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/589680.
    coneq[3793]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c**2*dot(A,c))))))-1/196560.
    coneq[3794]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/393120.
    coneq[3795]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c**3)))))-1/78624.
    coneq[3796]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,dot(A,c**2))))))-1/235872.
    coneq[3797]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/471744.
    coneq[3798]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c*dot(A,c))))))-1/157248.
    coneq[3799]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**3*dot(A,c**2)))))-1/58968.
    coneq[3800]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**3*dot(A,dot(A,c))))))-1/117936.
    coneq[3801]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**4*dot(A,c)))))-1/39312.
    coneq[3802]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2)*dot(A,c**2)))))-1/176904.
    coneq[3803]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/353808.
    coneq[3804]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/707616.
    coneq[3805]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c**3)))))-1/157248.
    coneq[3806]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/471744.
    coneq[3807]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/943488.
    coneq[3808]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/314496.
    coneq[3809]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c)*dot(A,c**2)))))-1/117936.
    coneq[3810]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/235872.
    coneq[3811]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c)*dot(A,c)))))-1/78624.
    coneq[3812]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/157248.
    coneq[3813]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**5))))-1/16848.
    coneq[3814]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c**4)))))-1/84240.
    coneq[3815]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c**3))))))-1/336960.
    coneq[3816]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1010880.
    coneq[3817]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/2021760.
    coneq[3818]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/673920.
    coneq[3819]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c*dot(A,c**2))))))-1/252720.
    coneq[3820]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/505440.
    coneq[3821]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c**2*dot(A,c))))))-1/168480.
    coneq[3822]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/336960.
    coneq[3823]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c**3)))))-1/67392.
    coneq[3824]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,dot(A,c**2))))))-1/202176.
    coneq[3825]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/404352.
    coneq[3826]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c*dot(A,c))))))-1/134784.
    coneq[3827]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2*dot(A,c**2)))))-1/50544.
    coneq[3828]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2*dot(A,dot(A,c))))))-1/101088.
    coneq[3829]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**3*dot(A,c)))))-1/33696.
    coneq[3830]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c)*dot(A,c**2)))))-1/101088.
    coneq[3831]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/202176.
    coneq[3832]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c)*dot(A,c)))))-1/67392.
    coneq[3833]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c**4))))-1/14040.
    coneq[3834]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,c**3)))))-1/56160.
    coneq[3835]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,dot(A,c**2))))))-1/168480.
    coneq[3836]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,dot(A,dot(A,c)))))))-1/336960.
    coneq[3837]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,c*dot(A,c))))))-1/112320.
    coneq[3838]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c*dot(A,c**2)))))-1/42120.
    coneq[3839]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c*dot(A,dot(A,c))))))-1/84240.
    coneq[3840]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c**2*dot(A,c)))))-1/28080.
    coneq[3841]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,dot(A,c)*dot(A,c)))))-1/56160.
    coneq[3842]=dot(b,dot(A,dot(A,c)*dot(A,c**4*dot(A,c**3))))-1/11232.
    coneq[3843]=dot(b,dot(A,dot(A,c)*dot(A,c**4*dot(A,dot(A,c**2)))))-1/33696.
    coneq[3844]=dot(b,dot(A,dot(A,c)*dot(A,c**4*dot(A,dot(A,dot(A,c))))))-1/67392.
    coneq[3845]=dot(b,dot(A,dot(A,c)*dot(A,c**4*dot(A,c*dot(A,c)))))-1/22464.
    coneq[3846]=dot(b,dot(A,dot(A,c)*dot(A,c**5*dot(A,c**2))))-1/8424.
    coneq[3847]=dot(b,dot(A,dot(A,c)*dot(A,c**5*dot(A,dot(A,c)))))-1/16848.
    coneq[3848]=dot(b,dot(A,dot(A,c)*dot(A,c**6*dot(A,c))))-1/5616.
    coneq[3849]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)*dot(A,c**3))))-1/44928.
    coneq[3850]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)*dot(A,dot(A,c**2)))))-1/134784.
    coneq[3851]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)*dot(A,dot(A,dot(A,c))))))-1/269568.
    coneq[3852]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**3)*dot(A,c*dot(A,c)))))-1/89856.
    coneq[3853]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,c**2)))))-1/404352.
    coneq[3854]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c))))))-1/808704.
    coneq[3855]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))*dot(A,c*dot(A,c)))))-1/269568.
    coneq[3856]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c))))))-1/1617408.
    coneq[3857]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)))))-1/539136.
    coneq[3858]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))*dot(A,c*dot(A,c)))))-1/179712.
    coneq[3859]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**4))))-1/42120.
    coneq[3860]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c**3)))))-1/168480.
    coneq[3861]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c**2))))))-1/505440.
    coneq[3862]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/1010880.
    coneq[3863]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c*dot(A,c))))))-1/336960.
    coneq[3864]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c*dot(A,c**2)))))-1/126360.
    coneq[3865]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c*dot(A,dot(A,c))))))-1/252720.
    coneq[3866]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**2*dot(A,c)))))-1/84240.
    coneq[3867]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)))))-1/168480.
    coneq[3868]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,c**4))))-1/84240.
    coneq[3869]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**3)))))-1/336960.
    coneq[3870]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2))))))-1/1010880.
    coneq[3871]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)))))))-1/2021760.
    coneq[3872]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c))))))-1/673920.
    coneq[3873]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c**2)))))-1/252720.
    coneq[3874]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c))))))-1/505440.
    coneq[3875]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,c**2*dot(A,c)))))-1/168480.
    coneq[3876]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)))))-1/336960.
    coneq[3877]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**5))))-1/33696.
    coneq[3878]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**4)))))-1/168480.
    coneq[3879]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**3))))))-1/673920.
    coneq[3880]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/2021760.
    coneq[3881]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/4043520.
    coneq[3882]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/1347840.
    coneq[3883]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c**2))))))-1/505440.
    coneq[3884]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/1010880.
    coneq[3885]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**2*dot(A,c))))))-1/336960.
    coneq[3886]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/673920.
    coneq[3887]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c**3)))))-1/134784.
    coneq[3888]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c**2))))))-1/404352.
    coneq[3889]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/808704.
    coneq[3890]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c*dot(A,c))))))-1/269568.
    coneq[3891]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2)))))-1/101088.
    coneq[3892]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c))))))-1/202176.
    coneq[3893]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**3*dot(A,c)))))-1/67392.
    coneq[3894]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)))))-1/202176.
    coneq[3895]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/404352.
    coneq[3896]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)))))-1/134784.
    coneq[3897]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)*dot(A,c**3))))-1/33696.
    coneq[3898]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2)))))-1/101088.
    coneq[3899]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/202176.
    coneq[3900]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)))))-1/67392.
    coneq[3901]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))*dot(A,c**3))))-1/67392.
    coneq[3902]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/202176.
    coneq[3903]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/404352.
    coneq[3904]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/134784.
    coneq[3905]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**4))))-1/28080.
    coneq[3906]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c**3)))))-1/112320.
    coneq[3907]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/336960.
    coneq[3908]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/673920.
    coneq[3909]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/224640.
    coneq[3910]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2)))))-1/84240.
    coneq[3911]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/168480.
    coneq[3912]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)))))-1/56160.
    coneq[3913]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/112320.
    coneq[3914]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2)*dot(A,c**2))))-1/25272.
    coneq[3915]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)))))-1/50544.
    coneq[3916]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/101088.
    coneq[3917]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c**3))))-1/22464.
    coneq[3918]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2)))))-1/67392.
    coneq[3919]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/134784.
    coneq[3920]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)))))-1/44928.
    coneq[3921]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c)*dot(A,c**2))))-1/16848.
    coneq[3922]=dot(b,dot(A,dot(A,c)*dot(A,c**3*dot(A,c)*dot(A,dot(A,c)))))-1/33696.
    coneq[3923]=dot(b,dot(A,dot(A,c)*dot(A,c**4*dot(A,c)*dot(A,c))))-1/11232.
    coneq[3924]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c**3))))-1/44928.
    coneq[3925]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c**2)))))-1/134784.
    coneq[3926]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/269568.
    coneq[3927]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c*dot(A,c)))))-1/89856.
    coneq[3928]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)*dot(A,c**2))))-1/50544.
    coneq[3929]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c**2)*dot(A,dot(A,c)))))-1/101088.
    coneq[3930]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/202176.
    coneq[3931]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c**2))))-1/33696.
    coneq[3932]=dot(b,dot(A,dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/67392.
    coneq[3933]=dot(b,dot(A,dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c)*dot(A,c))))-1/22464.
    coneq[3934]=dot(b,dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c)*dot(A,c))))-1/44928.
    coneq[3935]=dot(b,dot(A,c*dot(A,c**4)*dot(A,c**4)))-1/3900.
    coneq[3936]=dot(b,dot(A,c*dot(A,c**4)*dot(A,dot(A,c**3))))-1/15600.
    coneq[3937]=dot(b,dot(A,c*dot(A,c**4)*dot(A,dot(A,dot(A,c**2)))))-1/46800.
    coneq[3938]=dot(b,dot(A,c*dot(A,c**4)*dot(A,dot(A,dot(A,dot(A,c))))))-1/93600.
    coneq[3939]=dot(b,dot(A,c*dot(A,c**4)*dot(A,dot(A,c*dot(A,c)))))-1/31200.
    coneq[3940]=dot(b,dot(A,c*dot(A,c**4)*dot(A,c*dot(A,c**2))))-1/11700.
    coneq[3941]=dot(b,dot(A,c*dot(A,c**4)*dot(A,c*dot(A,dot(A,c)))))-1/23400.
    coneq[3942]=dot(b,dot(A,c*dot(A,c**4)*dot(A,c**2*dot(A,c))))-1/7800.
    coneq[3943]=dot(b,dot(A,c*dot(A,c**4)*dot(A,dot(A,c)*dot(A,c))))-1/15600.
    coneq[3944]=dot(b,dot(A,c*dot(A,dot(A,c**3))*dot(A,dot(A,c**3))))-1/62400.
    coneq[3945]=dot(b,dot(A,c*dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,c**2)))))-1/187200.
    coneq[3946]=dot(b,dot(A,c*dot(A,dot(A,c**3))*dot(A,dot(A,dot(A,dot(A,c))))))-1/374400.
    coneq[3947]=dot(b,dot(A,c*dot(A,dot(A,c**3))*dot(A,dot(A,c*dot(A,c)))))-1/124800.
    coneq[3948]=dot(b,dot(A,c*dot(A,dot(A,c**3))*dot(A,c*dot(A,c**2))))-1/46800.
    coneq[3949]=dot(b,dot(A,c*dot(A,dot(A,c**3))*dot(A,c*dot(A,dot(A,c)))))-1/93600.
    coneq[3950]=dot(b,dot(A,c*dot(A,dot(A,c**3))*dot(A,c**2*dot(A,c))))-1/31200.
    coneq[3951]=dot(b,dot(A,c*dot(A,dot(A,c**3))*dot(A,dot(A,c)*dot(A,c))))-1/62400.
    coneq[3952]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,c**2)))))-1/561600.
    coneq[3953]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,dot(A,dot(A,c))))))-1/1123200.
    coneq[3954]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c*dot(A,c)))))-1/374400.
    coneq[3955]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,c**2))))-1/140400.
    coneq[3956]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)))*dot(A,c*dot(A,dot(A,c)))))-1/280800.
    coneq[3957]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)))*dot(A,c**2*dot(A,c))))-1/93600.
    coneq[3958]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c**2)))*dot(A,dot(A,c)*dot(A,c))))-1/187200.
    coneq[3959]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,dot(A,dot(A,c))))))-1/2246400.
    coneq[3960]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c*dot(A,c)))))-1/748800.
    coneq[3961]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,c**2))))-1/280800.
    coneq[3962]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c*dot(A,dot(A,c)))))-1/561600.
    coneq[3963]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))*dot(A,c**2*dot(A,c))))-1/187200.
    coneq[3964]=dot(b,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))*dot(A,dot(A,c)*dot(A,c))))-1/374400.
    coneq[3965]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c*dot(A,c)))))-1/249600.
    coneq[3966]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,c**2))))-1/93600.
    coneq[3967]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)))*dot(A,c*dot(A,dot(A,c)))))-1/187200.
    coneq[3968]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)))*dot(A,c**2*dot(A,c))))-1/62400.
    coneq[3969]=dot(b,dot(A,c*dot(A,dot(A,c*dot(A,c)))*dot(A,dot(A,c)*dot(A,c))))-1/124800.
    coneq[3970]=dot(b,dot(A,c*dot(A,c*dot(A,c**2))*dot(A,c*dot(A,c**2))))-1/35100.
    coneq[3971]=dot(b,dot(A,c*dot(A,c*dot(A,c**2))*dot(A,c*dot(A,dot(A,c)))))-1/70200.
    coneq[3972]=dot(b,dot(A,c*dot(A,c*dot(A,c**2))*dot(A,c**2*dot(A,c))))-1/23400.
    coneq[3973]=dot(b,dot(A,c*dot(A,c*dot(A,c**2))*dot(A,dot(A,c)*dot(A,c))))-1/46800.
    coneq[3974]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c)))))-1/140400.
    coneq[3975]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)))*dot(A,c**2*dot(A,c))))-1/46800.
    coneq[3976]=dot(b,dot(A,c*dot(A,c*dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c))))-1/93600.
    coneq[3977]=dot(b,dot(A,c*dot(A,c**2*dot(A,c))*dot(A,c**2*dot(A,c))))-1/15600.
    coneq[3978]=dot(b,dot(A,c*dot(A,c**2*dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/31200.
    coneq[3979]=dot(b,dot(A,c*dot(A,dot(A,c)*dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/62400.
    coneq[3980]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c**5)))-1/3744.
    coneq[3981]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c**4))))-1/18720.
    coneq[3982]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,c**3)))))-1/74880.
    coneq[3983]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/224640.
    coneq[3984]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/449280.
    coneq[3985]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/149760.
    coneq[3986]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c*dot(A,c**2)))))-1/56160.
    coneq[3987]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/112320.
    coneq[3988]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c**2*dot(A,c)))))-1/37440.
    coneq[3989]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/74880.
    coneq[3990]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,c**3))))-1/14976.
    coneq[3991]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,dot(A,c**2)))))-1/44928.
    coneq[3992]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/89856.
    coneq[3993]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,c*dot(A,c)))))-1/29952.
    coneq[3994]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c**2*dot(A,c**2))))-1/11232.
    coneq[3995]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c**2*dot(A,dot(A,c)))))-1/22464.
    coneq[3996]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c**3*dot(A,c))))-1/7488.
    coneq[3997]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c)*dot(A,c**2))))-1/22464.
    coneq[3998]=dot(b,dot(A,c*dot(A,c**3)*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/44928.
    coneq[3999]=dot(b,dot(A,c*dot(A,c**3)*dot(A,c*dot(A,c)*dot(A,c))))-1/14976.
    coneq[4000]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c**5)))-1/11232.
    coneq[4001]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c**4))))-1/56160.
    coneq[4002]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**3)))))-1/224640.
    coneq[4003]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/673920.
    coneq[4004]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/1347840.
    coneq[4005]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/449280.
    coneq[4006]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c**2)))))-1/168480.
    coneq[4007]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/336960.
    coneq[4008]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c**2*dot(A,c)))))-1/112320.
    coneq[4009]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/224640.
    coneq[4010]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,c**3))))-1/44928.
    coneq[4011]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c**2)))))-1/134784.
    coneq[4012]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/269568.
    coneq[4013]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,c*dot(A,c)))))-1/89856.
    coneq[4014]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c**2))))-1/33696.
    coneq[4015]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c**2*dot(A,dot(A,c)))))-1/67392.
    coneq[4016]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c**3*dot(A,c))))-1/22464.
    coneq[4017]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c**2))))-1/67392.
    coneq[4018]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/134784.
    coneq[4019]=dot(b,dot(A,c*dot(A,dot(A,c**2))*dot(A,c*dot(A,c)*dot(A,c))))-1/44928.
    coneq[4020]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c**5)))-1/22464.
    coneq[4021]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**4))))-1/112320.
    coneq[4022]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**3)))))-1/449280.
    coneq[4023]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/1347840.
    coneq[4024]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/2695680.
    coneq[4025]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/898560.
    coneq[4026]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c**2)))))-1/336960.
    coneq[4027]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/673920.
    coneq[4028]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**2*dot(A,c)))))-1/224640.
    coneq[4029]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/449280.
    coneq[4030]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**3))))-1/89856.
    coneq[4031]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c**2)))))-1/269568.
    coneq[4032]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/539136.
    coneq[4033]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c*dot(A,c)))))-1/179712.
    coneq[4034]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c**2))))-1/67392.
    coneq[4035]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,dot(A,c)))))-1/134784.
    coneq[4036]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c**3*dot(A,c))))-1/44928.
    coneq[4037]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c**2))))-1/134784.
    coneq[4038]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/269568.
    coneq[4039]=dot(b,dot(A,c*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c)*dot(A,c))))-1/89856.
    coneq[4040]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c**5)))-1/7488.
    coneq[4041]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c**4))))-1/37440.
    coneq[4042]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**3)))))-1/149760.
    coneq[4043]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/449280.
    coneq[4044]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/898560.
    coneq[4045]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/299520.
    coneq[4046]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c**2)))))-1/112320.
    coneq[4047]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/224640.
    coneq[4048]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c**2*dot(A,c)))))-1/74880.
    coneq[4049]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/149760.
    coneq[4050]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,c**3))))-1/29952.
    coneq[4051]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c**2)))))-1/89856.
    coneq[4052]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/179712.
    coneq[4053]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,c*dot(A,c)))))-1/59904.
    coneq[4054]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c**2))))-1/22464.
    coneq[4055]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c**2*dot(A,dot(A,c)))))-1/44928.
    coneq[4056]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c**3*dot(A,c))))-1/14976.
    coneq[4057]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c**2))))-1/44928.
    coneq[4058]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/89856.
    coneq[4059]=dot(b,dot(A,c*dot(A,c*dot(A,c))*dot(A,c*dot(A,c)*dot(A,c))))-1/29952.
    coneq[4060]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**6)))-1/3276.
    coneq[4061]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**5))))-1/19656.
    coneq[4062]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c**4)))))-1/98280.
    coneq[4063]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/393120.
    coneq[4064]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/1179360.
    coneq[4065]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/2358720.
    coneq[4066]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/786240.
    coneq[4067]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/294840.
    coneq[4068]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/589680.
    coneq[4069]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/196560.
    coneq[4070]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/393120.
    coneq[4071]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,c**3)))))-1/78624.
    coneq[4072]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/235872.
    coneq[4073]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/471744.
    coneq[4074]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/157248.
    coneq[4075]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c**2)))))-1/58968.
    coneq[4076]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/117936.
    coneq[4077]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**3*dot(A,c)))))-1/39312.
    coneq[4078]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/117936.
    coneq[4079]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/235872.
    coneq[4080]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/78624.
    coneq[4081]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c**4))))-1/16380.
    coneq[4082]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,c**3)))))-1/65520.
    coneq[4083]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/196560.
    coneq[4084]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/393120.
    coneq[4085]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/131040.
    coneq[4086]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c**2)))))-1/49140.
    coneq[4087]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/98280.
    coneq[4088]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c**2*dot(A,c)))))-1/32760.
    coneq[4089]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/65520.
    coneq[4090]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,c**3))))-1/13104.
    coneq[4091]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c**2)))))-1/39312.
    coneq[4092]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/78624.
    coneq[4093]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,c*dot(A,c)))))-1/26208.
    coneq[4094]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**3*dot(A,c**2))))-1/9828.
    coneq[4095]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**3*dot(A,dot(A,c)))))-1/19656.
    coneq[4096]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**4*dot(A,c))))-1/6552.
    coneq[4097]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2)*dot(A,c**2))))-1/29484.
    coneq[4098]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/58968.
    coneq[4099]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/117936.
    coneq[4100]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**3))))-1/26208.
    coneq[4101]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/78624.
    coneq[4102]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/157248.
    coneq[4103]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/52416.
    coneq[4104]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c**2))))-1/19656.
    coneq[4105]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/39312.
    coneq[4106]=dot(b,dot(A,c*dot(A,c**2)*dot(A,c**2*dot(A,c)*dot(A,c))))-1/13104.
    coneq[4107]=dot(b,dot(A,c*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/26208.
    coneq[4108]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**6)))-1/6552.
    coneq[4109]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**5))))-1/39312.
    coneq[4110]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**4)))))-1/196560.
    coneq[4111]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/786240.
    coneq[4112]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/2358720.
    coneq[4113]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/4717440.
    coneq[4114]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/1572480.
    coneq[4115]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/589680.
    coneq[4116]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/1179360.
    coneq[4117]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/393120.
    coneq[4118]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/786240.
    coneq[4119]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**3)))))-1/157248.
    coneq[4120]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/471744.
    coneq[4121]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/943488.
    coneq[4122]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/314496.
    coneq[4123]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c**2)))))-1/117936.
    coneq[4124]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/235872.
    coneq[4125]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**3*dot(A,c)))))-1/78624.
    coneq[4126]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/235872.
    coneq[4127]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/471744.
    coneq[4128]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/157248.
    coneq[4129]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c**4))))-1/32760.
    coneq[4130]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**3)))))-1/131040.
    coneq[4131]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/393120.
    coneq[4132]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/786240.
    coneq[4133]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/262080.
    coneq[4134]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c**2)))))-1/98280.
    coneq[4135]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/196560.
    coneq[4136]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c**2*dot(A,c)))))-1/65520.
    coneq[4137]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/131040.
    coneq[4138]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,c**3))))-1/26208.
    coneq[4139]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c**2)))))-1/78624.
    coneq[4140]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/157248.
    coneq[4141]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,c*dot(A,c)))))-1/52416.
    coneq[4142]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**3*dot(A,c**2))))-1/19656.
    coneq[4143]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**3*dot(A,dot(A,c)))))-1/39312.
    coneq[4144]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**4*dot(A,c))))-1/13104.
    coneq[4145]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2)*dot(A,c**2))))-1/58968.
    coneq[4146]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/117936.
    coneq[4147]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/235872.
    coneq[4148]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**3))))-1/52416.
    coneq[4149]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/157248.
    coneq[4150]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/314496.
    coneq[4151]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/104832.
    coneq[4152]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c**2))))-1/39312.
    coneq[4153]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/78624.
    coneq[4154]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,c**2*dot(A,c)*dot(A,c))))-1/26208.
    coneq[4155]=dot(b,dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/52416.
    coneq[4156]=dot(b,dot(A,c*dot(A,c)*dot(A,c**7)))-1/2496.
    coneq[4157]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**6))))-1/17472.
    coneq[4158]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**5)))))-1/104832.
    coneq[4159]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**4))))))-1/524160.
    coneq[4160]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**3)))))))-1/2096640.
    coneq[4161]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c**2))))))))-1/6289920.
    coneq[4162]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))))-1/12579840.
    coneq[4163]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c*dot(A,c))))))))-1/4193280.
    coneq[4164]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c**2)))))))-1/1572480.
    coneq[4165]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,dot(A,c))))))))-1/3144960.
    coneq[4166]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**2*dot(A,c)))))))-1/1048320.
    coneq[4167]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c)*dot(A,c)))))))-1/2096640.
    coneq[4168]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**3))))))-1/419328.
    coneq[4169]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c**2)))))))-1/1257984.
    coneq[4170]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,dot(A,c))))))))-1/2515968.
    coneq[4171]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c*dot(A,c)))))))-1/838656.
    coneq[4172]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c**2))))))-1/314496.
    coneq[4173]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,dot(A,c)))))))-1/628992.
    coneq[4174]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**3*dot(A,c))))))-1/209664.
    coneq[4175]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c**2))))))-1/628992.
    coneq[4176]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,dot(A,c)))))))-1/1257984.
    coneq[4177]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c)*dot(A,c))))))-1/419328.
    coneq[4178]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c**4)))))-1/87360.
    coneq[4179]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**3))))))-1/349440.
    coneq[4180]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c**2)))))))-1/1048320.
    coneq[4181]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,dot(A,c))))))))-1/2096640.
    coneq[4182]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c*dot(A,c)))))))-1/698880.
    coneq[4183]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c**2))))))-1/262080.
    coneq[4184]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,dot(A,c)))))))-1/524160.
    coneq[4185]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c**2*dot(A,c))))))-1/174720.
    coneq[4186]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c)*dot(A,c))))))-1/349440.
    coneq[4187]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,c**3)))))-1/69888.
    coneq[4188]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c**2))))))-1/209664.
    coneq[4189]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,dot(A,c)))))))-1/419328.
    coneq[4190]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,c*dot(A,c))))))-1/139776.
    coneq[4191]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**3*dot(A,c**2)))))-1/52416.
    coneq[4192]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**3*dot(A,dot(A,c))))))-1/104832.
    coneq[4193]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**4*dot(A,c)))))-1/34944.
    coneq[4194]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2)*dot(A,c**2)))))-1/157248.
    coneq[4195]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c**2)*dot(A,dot(A,c))))))-1/314496.
    coneq[4196]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c))*dot(A,dot(A,c))))))-1/628992.
    coneq[4197]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**3)))))-1/139776.
    coneq[4198]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c**2))))))-1/419328.
    coneq[4199]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,dot(A,c)))))))-1/838656.
    coneq[4200]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c*dot(A,c))))))-1/279552.
    coneq[4201]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c**2)))))-1/104832.
    coneq[4202]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,dot(A,c))))))-1/209664.
    coneq[4203]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2*dot(A,c)*dot(A,c)))))-1/69888.
    coneq[4204]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c)*dot(A,c)))))-1/139776.
    coneq[4205]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**5))))-1/14976.
    coneq[4206]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c**4)))))-1/74880.
    coneq[4207]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**3))))))-1/299520.
    coneq[4208]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/898560.
    coneq[4209]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1797120.
    coneq[4210]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/599040.
    coneq[4211]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c**2))))))-1/224640.
    coneq[4212]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/449280.
    coneq[4213]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c**2*dot(A,c))))))-1/149760.
    coneq[4214]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/299520.
    coneq[4215]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,c**3)))))-1/59904.
    coneq[4216]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c**2))))))-1/179712.
    coneq[4217]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/359424.
    coneq[4218]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,c*dot(A,c))))))-1/119808.
    coneq[4219]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c**2)))))-1/44928.
    coneq[4220]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2*dot(A,dot(A,c))))))-1/89856.
    coneq[4221]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**3*dot(A,c)))))-1/29952.
    coneq[4222]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c**2)))))-1/89856.
    coneq[4223]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/179712.
    coneq[4224]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c*dot(A,c)*dot(A,c)))))-1/59904.
    coneq[4225]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c**4))))-1/12480.
    coneq[4226]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,c**3)))))-1/49920.
    coneq[4227]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c**2))))))-1/149760.
    coneq[4228]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,dot(A,c)))))))-1/299520.
    coneq[4229]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,c*dot(A,c))))))-1/99840.
    coneq[4230]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c**2)))))-1/37440.
    coneq[4231]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c*dot(A,dot(A,c))))))-1/74880.
    coneq[4232]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c**2*dot(A,c)))))-1/24960.
    coneq[4233]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,dot(A,c)*dot(A,c)))))-1/49920.
    coneq[4234]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,c**3))))-1/9984.
    coneq[4235]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,dot(A,c**2)))))-1/29952.
    coneq[4236]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,dot(A,dot(A,c))))))-1/59904.
    coneq[4237]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,c*dot(A,c)))))-1/19968.
    coneq[4238]=dot(b,dot(A,c*dot(A,c)*dot(A,c**4*dot(A,c**2))))-1/7488.
    coneq[4239]=dot(b,dot(A,c*dot(A,c)*dot(A,c**4*dot(A,dot(A,c)))))-1/14976.
    coneq[4240]=dot(b,dot(A,c*dot(A,c)*dot(A,c**5*dot(A,c))))-1/4992.
    coneq[4241]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**3))))-1/29952.
    coneq[4242]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c**2)))))-1/89856.
    coneq[4243]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,dot(A,c))))))-1/179712.
    coneq[4244]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c**2)*dot(A,c*dot(A,c)))))-1/59904.
    coneq[4245]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,c**3))))-1/59904.
    coneq[4246]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c**2)))))-1/179712.
    coneq[4247]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,dot(A,c))))))-1/359424.
    coneq[4248]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,c*dot(A,c)))))-1/119808.
    coneq[4249]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c**4))))-1/24960.
    coneq[4250]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**3)))))-1/99840.
    coneq[4251]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c**2))))))-1/299520.
    coneq[4252]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)))))))-1/599040.
    coneq[4253]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c*dot(A,c))))))-1/199680.
    coneq[4254]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c**2)))))-1/74880.
    coneq[4255]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,dot(A,c))))))-1/149760.
    coneq[4256]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c**2*dot(A,c)))))-1/49920.
    coneq[4257]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c)*dot(A,c)))))-1/99840.
    coneq[4258]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2)*dot(A,c**2))))-1/22464.
    coneq[4259]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c**2)*dot(A,dot(A,c)))))-1/44928.
    coneq[4260]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/89856.
    coneq[4261]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**3))))-1/19968.
    coneq[4262]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c**2)))))-1/59904.
    coneq[4263]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/119808.
    coneq[4264]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c*dot(A,c)))))-1/39936.
    coneq[4265]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c**2))))-1/14976.
    coneq[4266]=dot(b,dot(A,c*dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,dot(A,c)))))-1/29952.
    coneq[4267]=dot(b,dot(A,c*dot(A,c)*dot(A,c**3*dot(A,c)*dot(A,c))))-1/9984.
    coneq[4268]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c**2))))-1/29952.
    coneq[4269]=dot(b,dot(A,c*dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,dot(A,c)))))-1/59904.
    coneq[4270]=dot(b,dot(A,c*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c)*dot(A,c))))-1/19968.
    coneq[4271]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,c**4)))-1/3120.
    coneq[4272]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,dot(A,c**3))))-1/12480.
    coneq[4273]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,dot(A,dot(A,c**2)))))-1/37440.
    coneq[4274]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,dot(A,dot(A,dot(A,c))))))-1/74880.
    coneq[4275]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,dot(A,c*dot(A,c)))))-1/24960.
    coneq[4276]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,c*dot(A,c**2))))-1/9360.
    coneq[4277]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,c*dot(A,dot(A,c)))))-1/18720.
    coneq[4278]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,c**2*dot(A,c))))-1/6240.
    coneq[4279]=dot(b,dot(A,c**2*dot(A,c**3)*dot(A,dot(A,c)*dot(A,c))))-1/12480.
    coneq[4280]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,c**4)))-1/9360.
    coneq[4281]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,dot(A,c**3))))-1/37440.
    coneq[4282]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c**2)))))-1/112320.
    coneq[4283]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,dot(A,c))))))-1/224640.
    coneq[4284]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,dot(A,c*dot(A,c)))))-1/74880.
    coneq[4285]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,c*dot(A,c**2))))-1/28080.
    coneq[4286]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,c*dot(A,dot(A,c)))))-1/56160.
    coneq[4287]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,c**2*dot(A,c))))-1/18720.
    coneq[4288]=dot(b,dot(A,c**2*dot(A,dot(A,c**2))*dot(A,dot(A,c)*dot(A,c))))-1/37440.
    coneq[4289]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,c**4)))-1/18720.
    coneq[4290]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c**3))))-1/74880.
    coneq[4291]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c**2)))))-1/224640.
    coneq[4292]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,dot(A,c))))))-1/449280.
    coneq[4293]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c*dot(A,c)))))-1/149760.
    coneq[4294]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c**2))))-1/56160.
    coneq[4295]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,dot(A,c)))))-1/112320.
    coneq[4296]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,c**2*dot(A,c))))-1/37440.
    coneq[4297]=dot(b,dot(A,c**2*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,c)*dot(A,c))))-1/74880.
    coneq[4298]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,c**4)))-1/6240.
    coneq[4299]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,dot(A,c**3))))-1/24960.
    coneq[4300]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,c**2)))))-1/74880.
    coneq[4301]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,dot(A,dot(A,dot(A,c))))))-1/149760.
    coneq[4302]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,dot(A,c*dot(A,c)))))-1/49920.
    coneq[4303]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,c*dot(A,c**2))))-1/18720.
    coneq[4304]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,c*dot(A,dot(A,c)))))-1/37440.
    coneq[4305]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,c**2*dot(A,c))))-1/12480.
    coneq[4306]=dot(b,dot(A,c**2*dot(A,c*dot(A,c))*dot(A,dot(A,c)*dot(A,c))))-1/24960.
    coneq[4307]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**5)))-1/2808.
    coneq[4308]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c**4))))-1/14040.
    coneq[4309]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,c**3)))))-1/56160.
    coneq[4310]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/168480.
    coneq[4311]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/336960.
    coneq[4312]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/112320.
    coneq[4313]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c*dot(A,c**2)))))-1/42120.
    coneq[4314]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/84240.
    coneq[4315]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c**2*dot(A,c)))))-1/28080.
    coneq[4316]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/56160.
    coneq[4317]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,c**3))))-1/11232.
    coneq[4318]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,dot(A,c**2)))))-1/33696.
    coneq[4319]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/67392.
    coneq[4320]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,c*dot(A,c)))))-1/22464.
    coneq[4321]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**2*dot(A,c**2))))-1/8424.
    coneq[4322]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**2*dot(A,dot(A,c)))))-1/16848.
    coneq[4323]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c**3*dot(A,c))))-1/5616.
    coneq[4324]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c**2))))-1/16848.
    coneq[4325]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/33696.
    coneq[4326]=dot(b,dot(A,c**2*dot(A,c**2)*dot(A,c*dot(A,c)*dot(A,c))))-1/11232.
    coneq[4327]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**5)))-1/5616.
    coneq[4328]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c**4))))-1/28080.
    coneq[4329]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**3)))))-1/112320.
    coneq[4330]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,c**2))))))-1/336960.
    coneq[4331]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,dot(A,dot(A,c)))))))-1/673920.
    coneq[4332]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c*dot(A,c))))))-1/224640.
    coneq[4333]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,c**2)))))-1/84240.
    coneq[4334]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c*dot(A,dot(A,c))))))-1/168480.
    coneq[4335]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c**2*dot(A,c)))))-1/56160.
    coneq[4336]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c)*dot(A,c)))))-1/112320.
    coneq[4337]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,c**3))))-1/22464.
    coneq[4338]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,c**2)))))-1/67392.
    coneq[4339]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,dot(A,dot(A,c))))))-1/134784.
    coneq[4340]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,c*dot(A,c)))))-1/44928.
    coneq[4341]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**2*dot(A,c**2))))-1/16848.
    coneq[4342]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**2*dot(A,dot(A,c)))))-1/33696.
    coneq[4343]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c**3*dot(A,c))))-1/11232.
    coneq[4344]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,c**2))))-1/33696.
    coneq[4345]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,dot(A,c)*dot(A,dot(A,c)))))-1/67392.
    coneq[4346]=dot(b,dot(A,c**2*dot(A,dot(A,c))*dot(A,c*dot(A,c)*dot(A,c))))-1/22464.
    coneq[4347]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**6)))-1/2184.
    coneq[4348]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**5))))-1/13104.
    coneq[4349]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c**4)))))-1/65520.
    coneq[4350]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c**3))))))-1/262080.
    coneq[4351]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,c**2)))))))-1/786240.
    coneq[4352]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,dot(A,dot(A,c))))))))-1/1572480.
    coneq[4353]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c*dot(A,c)))))))-1/524160.
    coneq[4354]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,c**2))))))-1/196560.
    coneq[4355]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c*dot(A,dot(A,c)))))))-1/393120.
    coneq[4356]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c**2*dot(A,c))))))-1/131040.
    coneq[4357]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,dot(A,c)*dot(A,c))))))-1/262080.
    coneq[4358]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,c**3)))))-1/52416.
    coneq[4359]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,c**2))))))-1/157248.
    coneq[4360]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,dot(A,dot(A,c)))))))-1/314496.
    coneq[4361]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,c*dot(A,c))))))-1/104832.
    coneq[4362]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2*dot(A,c**2)))))-1/39312.
    coneq[4363]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2*dot(A,dot(A,c))))))-1/78624.
    coneq[4364]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**3*dot(A,c)))))-1/26208.
    coneq[4365]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,c**2)))))-1/78624.
    coneq[4366]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c)*dot(A,dot(A,c))))))-1/157248.
    coneq[4367]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c*dot(A,c)*dot(A,c)))))-1/52416.
    coneq[4368]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c**4))))-1/10920.
    coneq[4369]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,c**3)))))-1/43680.
    coneq[4370]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,c**2))))))-1/131040.
    coneq[4371]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,dot(A,dot(A,c)))))))-1/262080.
    coneq[4372]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,c*dot(A,c))))))-1/87360.
    coneq[4373]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c*dot(A,c**2)))))-1/32760.
    coneq[4374]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c*dot(A,dot(A,c))))))-1/65520.
    coneq[4375]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c**2*dot(A,c)))))-1/21840.
    coneq[4376]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,dot(A,c)*dot(A,c)))))-1/43680.
    coneq[4377]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,c**3))))-1/8736.
    coneq[4378]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,dot(A,c**2)))))-1/26208.
    coneq[4379]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,dot(A,dot(A,c))))))-1/52416.
    coneq[4380]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,c*dot(A,c)))))-1/17472.
    coneq[4381]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**3*dot(A,c**2))))-1/6552.
    coneq[4382]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**3*dot(A,dot(A,c)))))-1/13104.
    coneq[4383]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**4*dot(A,c))))-1/4368.
    coneq[4384]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2)*dot(A,c**2))))-1/19656.
    coneq[4385]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c**2)*dot(A,dot(A,c)))))-1/39312.
    coneq[4386]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,dot(A,c))*dot(A,dot(A,c)))))-1/78624.
    coneq[4387]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,c**3))))-1/17472.
    coneq[4388]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,c**2)))))-1/52416.
    coneq[4389]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,dot(A,dot(A,c))))))-1/104832.
    coneq[4390]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,c*dot(A,c)))))-1/34944.
    coneq[4391]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)*dot(A,c**2))))-1/13104.
    coneq[4392]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c*dot(A,c)*dot(A,dot(A,c)))))-1/26208.
    coneq[4393]=dot(b,dot(A,c**2*dot(A,c)*dot(A,c**2*dot(A,c)*dot(A,c))))-1/8736.
    coneq[4394]=dot(b,dot(A,c**2*dot(A,c)*dot(A,dot(A,c)*dot(A,c)*dot(A,c))))-1/17472.
    coneq[4395]=dot(b,dot(A,c**3*dot(A,c**3)*dot(A,c**3)))-1/2496.
    coneq[4396]=dot(b,dot(A,c**3*dot(A,c**3)*dot(A,dot(A,c**2))))-1/7488.
    coneq[4397]=dot(b,dot(A,c**3*dot(A,c**3)*dot(A,dot(A,dot(A,c)))))-1/14976.
    coneq[4398]=dot(b,dot(A,c**3*dot(A,c**3)*dot(A,c*dot(A,c))))-1/4992.
    coneq[4399]=dot(b,dot(A,c**3*dot(A,dot(A,c**2))*dot(A,dot(A,c**2))))-1/22464.
    coneq[4400]=dot(b,dot(A,c**3*dot(A,dot(A,c**2))*dot(A,dot(A,dot(A,c)))))-1/44928.
    coneq[4401]=dot(b,dot(A,c**3*dot(A,dot(A,c**2))*dot(A,c*dot(A,c))))-1/14976.
    coneq[4402]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)))*dot(A,dot(A,dot(A,c)))))-1/89856.
    coneq[4403]=dot(b,dot(A,c**3*dot(A,dot(A,dot(A,c)))*dot(A,c*dot(A,c))))-1/29952.
    coneq[4404]=dot(b,dot(A,c**3*dot(A,c*dot(A,c))*dot(A,c*dot(A,c))))-1/9984.
    coneq[4405]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,c**4)))-1/2340.
    coneq[4406]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,c**3))))-1/9360.
    coneq[4407]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,dot(A,c**2)))))-1/28080.
    coneq[4408]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,dot(A,dot(A,c))))))-1/56160.
    coneq[4409]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,c*dot(A,c)))))-1/18720.
    coneq[4410]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,c*dot(A,c**2))))-1/7020.
    coneq[4411]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,c*dot(A,dot(A,c)))))-1/14040.
    coneq[4412]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,c**2*dot(A,c))))-1/4680.
    coneq[4413]=dot(b,dot(A,c**3*dot(A,c**2)*dot(A,dot(A,c)*dot(A,c))))-1/9360.
    coneq[4414]=dot(b,dot(A,c**3*dot(A,dot(A,c))*dot(A,c**4)))-1/4680.
    coneq[4415]=dot(b,dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,c**3))))-1/18720.
    coneq[4416]=dot(b,dot(A,c**3*dot(A,dot(A,c))*dot(A,dot(A,dot(A,c**2)))))-1/56160.
    coneq[4417]=dot(b,dot(A,c**3*dot(A,dot