"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.Encryption = exports.Machine = exports.Technology = exports.Size = exports.TechnicalAssetType = exports.TechnicalAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const communication_1 = require("./communication");
const model_1 = require("./model");
const resource_1 = require("./resource");
const scope_1 = require("./scope");
class TechnicalAsset extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.type = props.type;
        this.usage = props.usage;
        this.humanUse = props.humanUse;
        this.internet = props.internet;
        this.scope = props.scope ?? new scope_1.InScope();
        this.size = props.size;
        this.technology = props.technology;
        this.tags = props.tags;
        this.machine = props.machine;
        this.encryption = props.encryption;
        this.owner = props.owner;
        this.ciaTriad = props.ciaTriad;
        this.multiTenant = props.multiTenant;
        this.redundant = props.redundant;
        this.dataAssetsProcessed = new Set();
        this.dataAssetsStored = new Set();
        this.communications = new Array();
        if (this.tags && this.tags.length > 0) {
            const model = model_1.Model.of(this);
            model.addTags(...this.tags);
        }
        if (props.trustBoundary) {
            props.trustBoundary.addTechnicalAssets(this);
        }
    }
    process(...assets) {
        assets.forEach((a) => {
            this.dataAssetsProcessed.add(a.uuid);
        });
    }
    store(...assets) {
        assets.forEach((a) => {
            this.dataAssetsStored.add(a.uuid);
        });
    }
    communicateWith(id, target, options) {
        const communication = new communication_1.Communication(id, {
            caller: this,
            target: target,
            ...options,
        });
        this.communications.push(communication);
        return communication;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.type,
                usage: this.usage,
                used_as_client_by_human: this.humanUse,
                ...this.scope?._toThreagile(),
                size: this.size,
                technology: this.technology,
                tags: Array.from(new Set(this.tags)),
                internet: this.internet,
                machine: this.machine,
                encryption: this.encryption,
                owner: this.owner,
                ...this.ciaTriad._toThreagile(),
                multitenant: this.multiTenant,
                redundant: this.redundant,
                data_assets_processed: Array.from(this.dataAssetsProcessed),
                data_assets_stored: Array.from(this.dataAssetsStored),
            },
        };
        threagile.communication_links = this.communications.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        return threagile;
    }
}
exports.TechnicalAsset = TechnicalAsset;
_a = JSII_RTTI_SYMBOL_1;
TechnicalAsset[_a] = { fqn: "cdktg.TechnicalAsset", version: "0.0.16" };
var TechnicalAssetType;
(function (TechnicalAssetType) {
    TechnicalAssetType["EXTERNAL_ENTITY"] = "external-entity";
    TechnicalAssetType["PROCESS"] = "process";
    TechnicalAssetType["DATASTORE"] = "datastore";
})(TechnicalAssetType = exports.TechnicalAssetType || (exports.TechnicalAssetType = {}));
var Size;
(function (Size) {
    Size["SYSTEM"] = "system";
    Size["SERVICE"] = "service";
    Size["APPLICATION"] = "application";
    Size["COMPONENT"] = "component";
})(Size = exports.Size || (exports.Size = {}));
var Technology;
(function (Technology) {
    Technology["UNKNOWN"] = "unknown-technology";
    Technology["CLIENT_SYSTEM"] = "client-system";
    Technology["BROWSER"] = "browser";
    Technology["DESKTOP"] = "desktop";
    Technology["MOBILE_APP"] = "mobile-app";
    Technology["DEVOPS_CLIENT"] = "devops-client";
    Technology["WEB_SERVER"] = "web-server";
    Technology["WEB_APPLICATION"] = "web-application";
    Technology["APPLICATION_SERVER"] = "application-server";
    Technology["DATABASE"] = "database";
    Technology["FILE_SERVER"] = "file-server";
    Technology["LOCAL_FILE_SERVER"] = "local-file-system";
    Technology["ERP"] = "erp";
    Technology["CMS"] = "cms";
    Technology["WEB_SERVICE_REST"] = "web-service-rest";
    Technology["WEB_SERVICE_SOAP"] = "web-service-soap";
    Technology["EJB"] = "ejb";
    Technology["SEARCH_INDEX"] = "search-index";
    Technology["SEARCH_ENGINE"] = "search-engine";
    Technology["SERVICE_REGISTRY"] = "service-registry";
    Technology["REVERSE_PROXY"] = "reverse-proxy";
    Technology["LOAD_BALANCER"] = "load-balancer";
    Technology["BUILD_PIPELINE"] = "build-pipeline";
    Technology["SOURCECODE_REPOSITORY"] = "sourcecode-repository";
    Technology["ARTIFACT_REGISTRY"] = "artifact-registry";
    Technology["CODE_INSPECTION_PLATFORM"] = "code-inspection-platform";
    Technology["MONITORING"] = "monitoring";
    Technology["LDAP_SERVER"] = "ldap-server";
    Technology["CONTAINER_PLATFORM"] = "container-platform";
    Technology["BATCH_PROCESSING"] = "batch-processing";
    Technology["EVENT_LISTENER"] = "event-listener";
    Technology["IDENTITIY_PROVIDER"] = "identity-provider";
    Technology["IDENTITY_STORE_LDAP"] = "identity-store-ldap";
    Technology["IDENTITY_STORE_DATABASE"] = "identity-store-database";
    Technology["TOOL"] = "tool";
    Technology["CLI"] = "cli";
    Technology["TASK"] = "task";
    Technology["FUNCTION"] = "function";
    Technology["GATEWAY"] = "gateway";
    Technology["IOT_DEVICE"] = "iot-device";
    Technology["MESSAGE_QUEUE"] = "message-queue";
    Technology["STREAM_PROCESSING"] = "stream-processing";
    Technology["SERVICE_MESH"] = "service-mesh";
    Technology["DATA_LAKE"] = "data-lake";
    Technology["REPORT_ENGINE"] = "report-engine";
    Technology["AI"] = "ai";
    Technology["MAIL_SERVER"] = "mail-server";
    Technology["VAULT"] = "vault";
    Technology["HASM"] = "hsm";
    Technology["WAF"] = "waf";
    Technology["IDS"] = "ids";
    Technology["IPS"] = "ips";
    Technology["SCHEDULER"] = "scheduler";
    Technology["MAINFRAME"] = "mainframe";
    Technology["BLOCK_STORAGE"] = "block-storage";
    Technology["LIBRARY"] = "library";
})(Technology = exports.Technology || (exports.Technology = {}));
var Machine;
(function (Machine) {
    Machine["PHYSICAL"] = "physical";
    Machine["VIRTUAL"] = "virtual";
    Machine["CONTAINER"] = "container";
    Machine["SERVERLESS"] = "serverless";
})(Machine = exports.Machine || (exports.Machine = {}));
var Encryption;
(function (Encryption) {
    Encryption["NONE"] = "none";
    Encryption["TRANSPARENT"] = "transparent";
    Encryption["SYMMETRIC_SHARED_KEY"] = "data-with-symmetric-shared-key";
    Encryption["ASYMMETRIC_SHARED_KEY"] = "data-with-asymmetric-shared-key";
    Encryption["ENDUSER_INDIVIDUAL_KEY"] = "data-with-enduser-individual-key";
})(Encryption = exports.Encryption || (exports.Encryption = {}));
var DataFormat;
(function (DataFormat) {
    DataFormat["JSON"] = "json";
    DataFormat["XML"] = "xml";
    DataFormat["SERIALIZATION"] = "serialization";
    DataFormat["FILE"] = "file";
    DataFormat["CSV"] = "csv";
})(DataFormat = exports.DataFormat || (exports.DataFormat = {}));
//# sourceMappingURL=data:application/json;base64,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