import { IConstruct } from "constructs";
import { Manifest } from "./manifest";
import { Model } from "./model";
export interface ISynthesisSession {
    /**
     * The output directory for this synthesis session.
     */
    readonly outdir: string;
    readonly skipValidation?: boolean;
    readonly manifest: Manifest;
}
export interface IModelSynthesizer {
    /**
     * Synthesize the associated model to the session
     */
    synthesize(session: ISynthesisSession): void;
}
export declare class ModelSynthesizer implements IModelSynthesizer {
    protected model: Model;
    private continueOnErrorAnnotations;
    constructor(model: Model, continueOnErrorAnnotations?: boolean);
    synthesize(session: ISynthesisSession): void;
}
/**
 * Invoke aspects on the given construct tree.
 *
 * originally from https://github.com/aws/aws-cdk/blob/dcae3eead0dbf9acb1ed80ba95bb104c64cb1bd7/packages/@aws-cdk/core/lib/private/synthesis.ts#L99-L137
 */
export declare function invokeAspects(root: IConstruct): void;
