"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataBreachProbability = exports.ExploitationImpact = exports.ExploitationLikelihood = exports.Severity = exports.Stride = exports.RiskFunction = exports.RiskCategory = exports.Risk = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const resource_1 = require("./resource");
class Risk {
    constructor(id, props) {
        this.id = id;
        this.severity = props.severity;
        this.exploitationLikelihood = props.exploitationLikelihood;
        this.exploitationImpact = props.exploitationImpact;
        this.dataBreachProbability = props.dataBreachProbability;
        this.dataBreachTechnicalAssets = props.dataBreachTechnicalAssets;
        this.mostRelevantTechnicalAsset = props.mostRelevantTechnicalAsset;
        this.mostRelevantDataAsset = props.mostRelevantDataAsset;
        this.mostRelevantCommunicationLink = props.mostRelevantCommunicationLink;
        this.mostRelevantTrustBoundary = props.mostRelevantTrustBoundary;
        this.mostRelevantSharedRuntime = props.mostRelevantSharedRuntime;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.id]: {
                severity: this.severity,
                exploitation_likelihood: this.exploitationLikelihood,
                exploitation_impact: this.exploitationImpact,
                data_breach_probability: this.dataBreachProbability,
                data_breach_technical_assets: this.dataBreachTechnicalAssets.map((a) => a.uuid),
                most_relevant_data_asset: this.mostRelevantDataAsset?.uuid,
                most_relevant_technical_asset: this.mostRelevantTechnicalAsset?.uuid,
                most_relevant_communication_link: this.mostRelevantCommunicationLink?.id,
                most_relevant_trust_boundary: this.mostRelevantTrustBoundary?.uuid,
                most_relevant_shared_runtime: this.mostRelevantSharedRuntime?.uuid,
            },
        };
    }
}
exports.Risk = Risk;
_a = JSII_RTTI_SYMBOL_1;
Risk[_a] = { fqn: "cdktg.Risk", version: "0.0.16" };
class RiskCategory extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.impact = props.impact;
        this.asvs = props.asvs;
        this.cheatSheat = props.cheatSheat;
        this.action = props.action;
        this.mitigation = props.mitigation;
        this.check = props.check;
        this.function = props.function;
        this.stride = props.stride;
        this.detectionLogic = props.detectionLogic;
        this.riskAssessment = props.riskAssessment;
        this.falsePositives = props.falsePositives;
        this.modelFailurePossibleReason = props.modelFailurePossibleReason;
        this.cwe = props.cwe;
        this.risks = new Array();
    }
    identifiedAtDataAsset(target, options) {
        this.risks.push(new Risk(`<b>${this.node.id}</b> risk at <b>${target.node.id}</b>`, {
            ...options,
            mostRelevantDataAsset: target,
        }));
    }
    identifiedAtTechnicalAsset(target, options) {
        this.risks.push(new Risk(`<b>${this.node.id}</b> risk at <b>${target.node.id}</b>`, {
            ...options,
            mostRelevantTechnicalAsset: target,
        }));
    }
    identifiedAtTrustBoundary(target, options) {
        this.risks.push(new Risk(`<b>${this.node.id}</b> risk at <b>${target.node.id}</b>`, {
            ...options,
            mostRelevantSharedRuntime: target,
        }));
    }
    identifiedAtSharedRuntime(target, options) {
        this.risks.push(new Risk(`<b>${this.node.id}</b> risk at <b>${target.node.id}</b>`, {
            ...options,
            mostRelevantSharedRuntime: target,
        }));
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                impact: this.impact,
                asvs: this.asvs,
                cheat_sheet: this.cheatSheat,
                action: this.action,
                mitigation: this.mitigation,
                check: this.check,
                function: this.function,
                stride: this.stride,
                detection_logic: this.detectionLogic,
                risk_assessment: this.riskAssessment,
                false_positives: this.falsePositives,
                model_failure_possible_reason: this.modelFailurePossibleReason ?? false,
                cwe: this.cwe,
            },
        };
        threagile.risks_identified = this.risks.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        return threagile;
    }
}
exports.RiskCategory = RiskCategory;
_b = JSII_RTTI_SYMBOL_1;
RiskCategory[_b] = { fqn: "cdktg.RiskCategory", version: "0.0.16" };
var RiskFunction;
(function (RiskFunction) {
    RiskFunction["BUSINESS_SIDE"] = "business-side";
    RiskFunction["ARCHITECTURE"] = "architecture";
    RiskFunction["DEVELOPMENT"] = "development";
    RiskFunction["OPERATIONS"] = "operations";
})(RiskFunction = exports.RiskFunction || (exports.RiskFunction = {}));
var Stride;
(function (Stride) {
    Stride["SPOOFING"] = "spoofing";
    Stride["TAMPERING"] = "tampering";
    Stride["REPUDIATION"] = "repudiation";
    Stride["INFORMATION_DISCLOSURE"] = "information-disclosure";
    Stride["DENIAL_OF_SERVICE"] = "denial-of-service";
    Stride["ELEVATION_OF_PRIVILEGE"] = "elevation-of-privilege";
})(Stride = exports.Stride || (exports.Stride = {}));
var Severity;
(function (Severity) {
    Severity["LOW"] = "low";
    Severity["MEDIUM"] = "medium";
    Severity["ELEVATED"] = "elevated";
    Severity["HIGH"] = "high";
    Severity["CRITICAL"] = "critical";
})(Severity = exports.Severity || (exports.Severity = {}));
var ExploitationLikelihood;
(function (ExploitationLikelihood) {
    ExploitationLikelihood["UNLIKELY"] = "unlikely";
    ExploitationLikelihood["LIKELY"] = "likely";
    ExploitationLikelihood["VERY_LIKELY"] = "very-likely";
    ExploitationLikelihood["FREQUENT"] = "frequent";
})(ExploitationLikelihood = exports.ExploitationLikelihood || (exports.ExploitationLikelihood = {}));
var ExploitationImpact;
(function (ExploitationImpact) {
    ExploitationImpact["LOW"] = "low";
    ExploitationImpact["MEDIUM"] = "medium";
    ExploitationImpact["HIGH"] = "high";
    ExploitationImpact["VERY_HIGH"] = "very-high";
})(ExploitationImpact = exports.ExploitationImpact || (exports.ExploitationImpact = {}));
var DataBreachProbability;
(function (DataBreachProbability) {
    DataBreachProbability["IMPROBABLE"] = "improbable";
    DataBreachProbability["POSSIBLE"] = "possible";
    DataBreachProbability["PROBABLE"] = "probable";
})(DataBreachProbability = exports.DataBreachProbability || (exports.DataBreachProbability = {}));
//# sourceMappingURL=data:application/json;base64,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