import { Construct } from "constructs";
import { Communication } from "./communication";
import { DataAsset } from "./data-asset";
import { Resource, ResourceProps } from "./resource";
import { SharedRuntime } from "./shared-runtime";
import * as spec from "./spec/threatgile.generated";
import { TechnicalAsset } from "./technical-asset";
import { TrustBoundary } from "./trust-boundary";
export interface RiskOptions {
    readonly severity: Severity;
    readonly exploitationLikelihood: ExploitationLikelihood;
    readonly exploitationImpact: ExploitationImpact;
    readonly dataBreachProbability: DataBreachProbability;
    readonly dataBreachTechnicalAssets: TechnicalAsset[];
}
export interface RiskProps extends RiskOptions {
    readonly mostRelevantTechnicalAsset?: TechnicalAsset;
    readonly mostRelevantDataAsset?: DataAsset;
    readonly mostRelevantCommunicationLink?: Communication;
    readonly mostRelevantTrustBoundary?: TrustBoundary;
    readonly mostRelevantSharedRuntime?: SharedRuntime;
}
export declare class Risk {
    readonly id: string;
    readonly severity: Severity;
    readonly exploitationLikelihood: ExploitationLikelihood;
    readonly exploitationImpact: ExploitationImpact;
    readonly dataBreachProbability: DataBreachProbability;
    readonly dataBreachTechnicalAssets: TechnicalAsset[];
    readonly mostRelevantTechnicalAsset?: TechnicalAsset;
    readonly mostRelevantDataAsset?: DataAsset;
    readonly mostRelevantCommunicationLink?: Communication;
    readonly mostRelevantTrustBoundary?: TrustBoundary;
    readonly mostRelevantSharedRuntime?: SharedRuntime;
    constructor(id: string, props: RiskProps);
    /**
     * @internal
     */
    _toThreagile(): {
        [x: string]: {
            severity: Severity;
            exploitation_likelihood: ExploitationLikelihood;
            exploitation_impact: ExploitationImpact;
            data_breach_probability: DataBreachProbability;
            data_breach_technical_assets: string[];
            most_relevant_data_asset: string | undefined;
            most_relevant_technical_asset: string | undefined;
            most_relevant_communication_link: string | undefined;
            most_relevant_trust_boundary: string | undefined;
            most_relevant_shared_runtime: string | undefined;
        };
    };
}
export interface RiskCategoryProps extends ResourceProps {
    readonly impact: string;
    readonly asvs: string;
    readonly cheatSheat: string;
    readonly action: string;
    readonly mitigation: string;
    readonly check: string;
    readonly function: RiskFunction;
    readonly stride: Stride;
    readonly detectionLogic: string;
    readonly riskAssessment: string;
    readonly falsePositives: string;
    readonly modelFailurePossibleReason?: boolean;
    readonly cwe: number;
}
export declare class RiskCategory extends Resource {
    readonly impact: string;
    readonly asvs: string;
    readonly cheatSheat: string;
    readonly action: string;
    readonly mitigation: string;
    readonly check: string;
    readonly function: RiskFunction;
    readonly stride: Stride;
    readonly detectionLogic: string;
    readonly riskAssessment: string;
    readonly falsePositives: string;
    readonly modelFailurePossibleReason?: boolean;
    readonly cwe: number;
    private risks;
    constructor(scope: Construct, id: string, props: RiskCategoryProps);
    identifiedAtDataAsset(target: DataAsset, options: RiskOptions): void;
    identifiedAtTechnicalAsset(target: TechnicalAsset, options: RiskOptions): void;
    identifiedAtTrustBoundary(target: SharedRuntime, options: RiskOptions): void;
    identifiedAtSharedRuntime(target: SharedRuntime, options: RiskOptions): void;
    /**
     * @internal
     */
    _toThreagile(): spec.Threagile["individual_risk_categories"];
}
export declare enum RiskFunction {
    BUSINESS_SIDE = "business-side",
    ARCHITECTURE = "architecture",
    DEVELOPMENT = "development",
    OPERATIONS = "operations"
}
export declare enum Stride {
    SPOOFING = "spoofing",
    TAMPERING = "tampering",
    REPUDIATION = "repudiation",
    INFORMATION_DISCLOSURE = "information-disclosure",
    DENIAL_OF_SERVICE = "denial-of-service",
    ELEVATION_OF_PRIVILEGE = "elevation-of-privilege"
}
export declare enum Severity {
    LOW = "low",
    MEDIUM = "medium",
    ELEVATED = "elevated",
    HIGH = "high",
    CRITICAL = "critical"
}
export declare enum ExploitationLikelihood {
    UNLIKELY = "unlikely",
    LIKELY = "likely",
    VERY_LIKELY = "very-likely",
    FREQUENT = "frequent"
}
export declare enum ExploitationImpact {
    LOW = "low",
    MEDIUM = "medium",
    HIGH = "high",
    VERY_HIGH = "very-high"
}
export declare enum DataBreachProbability {
    IMPROBABLE = "improbable",
    POSSIBLE = "possible",
    PROBABLE = "probable"
}
