"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessCriticality = exports.Model = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const data_asset_1 = require("./data-asset");
const risk_category_1 = require("./risk-category");
const shared_runtime_1 = require("./shared-runtime");
const synthesizer_1 = require("./synthesizer");
const technical_asset_1 = require("./technical-asset");
const trust_boundary_1 = require("./trust-boundary");
const MODEL_SYMBOL = Symbol.for("cdktg/Model");
class Model extends constructs_1.Construct {
    constructor(project, id, props) {
        super(project, id);
        this.version = props.version;
        this.title = props.title ?? id;
        this.date = props.date
            ? new Date(props.date).toISOString().split("T")[0]
            : undefined;
        this.author = props.author;
        this.managementSummary = props.managementSummary;
        this.businessCriticality = props.businessCriticality;
        this.questions = new Map();
        props.questions?.forEach((q) => {
            this.addQuestion(q.text, q.answer);
        });
        this.abuseCases = new Map();
        if (props.abuseCases && props.abuseCases.length > 0) {
            this.addAbuseCases(...props.abuseCases);
        }
        this.securityRequirements = new Map();
        if (props.securityRequirements && props.securityRequirements.length > 0) {
            this.addSecurityRequirements(...props.securityRequirements);
        }
        this.tags = new Set();
        this.rawOverrides = {};
        this.synthesizer = new synthesizer_1.ModelSynthesizer(this, false);
        Object.defineProperty(this, MODEL_SYMBOL, { value: true });
    }
    static isModel(x) {
        return x !== null && typeof x === "object" && MODEL_SYMBOL in x;
    }
    static of(construct) {
        return _lookup(construct);
        function _lookup(c) {
            if (Model.isModel(c)) {
                return c;
            }
            const node = c.node;
            if (!node.scope) {
                throw new Error(`No model could be identified for the construct at path '${construct.node.path}'`);
            }
            return _lookup(node.scope);
        }
    }
    addTag(tag) {
        this.addTags(tag);
    }
    addTags(...tags) {
        tags.forEach((tag) => {
            this.tags.add(tag);
        });
    }
    addQuestion(text, answer = "") {
        // "" as answer signals "unanswered"
        if (this.questions.has(text)) {
            throw new Error(`Duplicated question "${text}"`);
        }
        this.questions.set(text, answer);
    }
    addAbuseCases(...cases) {
        cases.forEach((c) => {
            if (this.abuseCases.has(c.name)) {
                throw new Error(`Duplicated abuse case "${c.name}"`);
            }
            this.abuseCases.set(c.name, c.description);
        });
    }
    addSecurityRequirements(...requirements) {
        requirements.forEach((r) => {
            if (this.abuseCases.has(r.name)) {
                throw new Error(`Duplicated security requirement "${r.name}"`);
            }
            this.securityRequirements.set(r.name, r.description);
        });
    }
    addOverride(path, value) {
        const parts = path.split(".");
        let curr = this.rawOverrides;
        while (parts.length > 1) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const key = parts.shift();
            // if we can't recurse further or the previous value is not an
            // object overwrite it with an object.
            const isObject = curr[key] != null &&
                typeof curr[key] === "object" &&
                !Array.isArray(curr[key]);
            if (!isObject) {
                curr[key] = {};
            }
            curr = curr[key];
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const lastKey = parts.shift();
        curr[lastKey] = value;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const dataAssets = new Array();
        const technicalAssets = new Array();
        const trustBoundaries = new Array();
        const sharedRuntimes = new Array();
        const individualRiskCategories = new Array();
        this.node.findAll().map((n) => {
            if (n instanceof data_asset_1.DataAsset) {
                dataAssets.push(n);
            }
            else if (n instanceof technical_asset_1.TechnicalAsset) {
                technicalAssets.push(n);
            }
            else if (n instanceof trust_boundary_1.TrustBoundary) {
                trustBoundaries.push(n);
            }
            else if (n instanceof shared_runtime_1.SharedRuntime) {
                sharedRuntimes.push(n);
            }
            else if (n instanceof risk_category_1.RiskCategory) {
                individualRiskCategories.push(n);
            }
        });
        const threagile = {
            threagile_version: this.version,
            title: this.title,
            data: this.date,
            author: this.author._toThreagile(),
            management_summary_comment: this.managementSummary,
            business_criticality: this.businessCriticality,
            questions: Object.fromEntries(this.questions),
            abuse_cases: Object.fromEntries(this.abuseCases),
            security_requirements: Object.fromEntries(this.securityRequirements),
            tags_available: Array.from(this.tags),
        };
        threagile.data_assets = dataAssets.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.technical_assets = technicalAssets.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.trust_boundaries = trustBoundaries.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.shared_runtimes = sharedRuntimes.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.individual_risk_categories = individualRiskCategories.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        return {
            ...threagile,
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { stack: Object.keys(this.rawOverrides) } }
                : {}),
        };
    }
}
exports.Model = Model;
_a = JSII_RTTI_SYMBOL_1;
Model[_a] = { fqn: "cdktg.Model", version: "0.0.16" };
var BusinessCriticality;
(function (BusinessCriticality) {
    BusinessCriticality["ARCHIVE"] = "archive";
    BusinessCriticality["OPERATIONAL"] = "operational";
    BusinessCriticality["IMPORTANT"] = "important";
    BusinessCriticality["CRITICAL"] = "critical";
    BusinessCriticality["MISSION_CRITICAL"] = "mission-critical";
})(BusinessCriticality = exports.BusinessCriticality || (exports.BusinessCriticality = {}));
//# sourceMappingURL=data:application/json;base64,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