"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynthCommand = void 0;
const path = require("path");
const execa = require("execa");
const fs = require("fs-extra");
const which = require("which");
class SynthCommand {
    constructor() {
        this.command = "synth <filename>";
        this.describe = "synthesize the models";
        this.builder = (args) => {
            args.positional("filename", { demandOption: true, type: "string" });
            args.option("watch", {
                boolean: true,
                alias: "w",
                describe: "get watch with it!",
            });
            return args;
        };
        this.handler = async (args) => {
            const { filename } = args;
            if (!fs.existsSync(filename)) {
                throw new Error(`File ${filename} not exist!`);
            }
            const command = (() => {
                switch (path.extname(filename)) {
                    case ".ts":
                        return require.resolve("ts-node/dist/bin");
                    case ".py":
                        return which.sync("python3", { all: false });
                    default:
                        throw new Error("Unknown file extension");
                }
            })();
            execa(command, [filename], {
                stdio: ["ignore", "inherit", "inherit"],
            });
        };
    }
}
exports.SynthCommand = SynthCommand;
//# sourceMappingURL=data:application/json;base64,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