"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnalyseCommand = void 0;
const path = require("path");
const AdmZip = require("adm-zip");
const fs = require("fs-extra");
const threagile_1 = require("../api/threagile");
const manifest_1 = require("../manifest");
class AnalyseCommand {
    constructor() {
        this.command = "analyse";
        this.describe = "analyze the models";
        this.builder = (args) => {
            args.option("url", { type: "string", alias: "u", describe: "" });
            args.option("out", {
                type: "string",
                alias: "o",
                describe: "",
                default: "dist",
            });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            fs.mkdirSync(args.out, { recursive: true });
            const api = new threagile_1.Threagile(url);
            const manifest = manifest_1.Manifest.fromPath(".cdktg.out");
            Object.keys(manifest.models).forEach(async (k) => {
                const modelManifest = manifest.models[k];
                const resp = await api.analyse(path.join(".cdktg.out", modelManifest.synthesizedModelPath));
                if (resp.status === 400) {
                    console.log(`Errors for model "${k}":`);
                    console.log(resp.data.error);
                    return;
                }
                const zip = new AdmZip(resp.data);
                zip.extractAllTo(path.join(args.out, modelManifest.sanitizedName));
            });
        };
    }
}
exports.AnalyseCommand = AnalyseCommand;
//# sourceMappingURL=data:application/json;base64,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