"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbuseCase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class AbuseCase {
    constructor(props) {
        this.name = props.name;
        this.description = props.description;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.name]: this.description,
        };
    }
}
exports.AbuseCase = AbuseCase;
_a = JSII_RTTI_SYMBOL_1;
AbuseCase[_a] = { fqn: "cdktg.AbuseCase", version: "0.0.16" };
AbuseCase.DENIAL_OF_SERVICE = new AbuseCase({
    name: "Denial-of-Service",
    description: "As a hacker I want to disturb the functionality of the backend system in order to cause indirect financial damage via unusable features.",
});
AbuseCase.CPU_CYCLE_THEFT = new AbuseCase({
    name: "CPU-Cycle Theft",
    description: "As a hacker I want to steal CPU cycles in order to transform them into money via installed crypto currency miners.",
});
AbuseCase.RANSOMWARE = new AbuseCase({
    name: "Ransomware",
    description: "As a hacker I want to encrypt the storage and file systems in order to demand ransom.",
});
AbuseCase.IDENTITY_THEFT = new AbuseCase({
    name: "Identity Theft",
    description: "As a hacker I want to steal identity data in order to reuse credentials and/or keys on other targets of the same company or outside.",
});
AbuseCase.PII_THEFT = new AbuseCase({
    name: "PII Theft",
    description: "As a hacker I want to steal PII (Personally Identifiable Information) data in order to blackmail the company and/or damage their repudiation by publishing them.",
});
//# sourceMappingURL=data:application/json;base64,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