// Copyright (c) 2020 Marcus Valtonen Örnhag
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include "solver_valtonenornhag_arxiv_2020b_fHf.hpp"
#include <Eigen/Dense>
#include "roots.hpp"

namespace HomLib::ValtonenOrnhagArxiv2020B {
    inline Eigen::VectorXd compute_coeffs_fHf(const Eigen::VectorXd& data);

    Eigen::VectorXcd solver_fHf(const Eigen::VectorXd& data) {
        Eigen::VectorXd coeffs = HomLib::ValtonenOrnhagArxiv2020B::compute_coeffs_fHf(data);
        Eigen::VectorXcd putative_sols = HomLib::roots(coeffs);
        return putative_sols;
    }

    inline Eigen::VectorXd compute_coeffs_fHf(const Eigen::VectorXd& data) {
        const double* d = data.data();
        Eigen::VectorXd coeffs(7);
        double in_x2 = d[0];
        double in_x3 = d[1];
        double in_x4 = d[2];
        double in_x5 = d[3];
        double in_x6 = d[4];
        double in_x7 = d[5];
        double in_x8 = d[6];
        double in_x9 = d[7];
        double in_x10 = d[8];
        double in_x11 = d[9];
        double in_x12 = d[10];
        double in_x13 = d[11];
        double in_x14 = d[12];
        double in_x15 = d[13];
        double in_x16 = d[14];
        double in_x17 = d[15];
        double in_x18 = d[16];
        double in_x19 = d[17];
        double in_x20 = d[18];
        double in_x21 = d[19];
        double in_x22 = d[20];
        double in_x23 = d[21];
        double in_x24 = d[22];
        double in_x25 = d[23];
        double in_x26 = d[24];
        double in_x27 = d[25];

        double t2 = in_x17*in_x17;
        double t3 = in_x26*in_x26;
        double t4 = in_x2*in_x2;
        double t5 = in_x6*in_x6;
        double t6 = in_x11*in_x11;
        double t7 = in_x3*in_x3;
        double t8 = in_x4*in_x4;
        double t9 = in_x14*in_x14;
        double t10 = in_x7*in_x7;
        double t11 = in_x8*in_x8;
        double t12 = in_x20*in_x20;
        double t13 = in_x5*in_x5;
        double t14 = in_x23*in_x23;
        double t15 = in_x9*in_x9;
        coeffs[0] = t2*t3*(in_x2*in_x4*in_x10*in_x17*in_x20*in_x27-in_x2*in_x4*in_x10*in_x17*in_x21*in_x26-in_x2*in_x4*in_x11*in_x16*in_x20*in_x27+in_x2*in_x4*in_x11*in_x16*in_x21*in_x26-in_x2*in_x4*in_x11*in_x18*in_x19*in_x26+in_x2*in_x4*in_x11*in_x18*in_x20*in_x25+in_x2*in_x4*in_x12*in_x17*in_x19*in_x26-in_x2*in_x4*in_x12*in_x17*in_x20*in_x25+in_x2*in_x5*in_x10*in_x17*in_x23*in_x27-in_x2*in_x5*in_x10*in_x17*in_x24*in_x26-in_x2*in_x5*in_x11*in_x16*in_x23*in_x27+in_x2*in_x5*in_x11*in_x16*in_x24*in_x26-in_x2*in_x5*in_x11*in_x18*in_x22*in_x26+in_x2*in_x5*in_x11*in_x18*in_x23*in_x25+in_x2*in_x5*in_x12*in_x17*in_x22*in_x26-in_x2*in_x5*in_x12*in_x17*in_x23*in_x25-in_x2*in_x8*in_x10*in_x17*in_x20*in_x27+in_x2*in_x8*in_x10*in_x17*in_x21*in_x26+in_x2*in_x8*in_x11*in_x16*in_x20*in_x27-in_x2*in_x8*in_x11*in_x16*in_x21*in_x26+in_x2*in_x8*in_x11*in_x18*in_x19*in_x26-in_x2*in_x8*in_x11*in_x18*in_x20*in_x25-in_x2*in_x8*in_x12*in_x17*in_x19*in_x26+in_x2*in_x8*in_x12*in_x17*in_x20*in_x25+in_x3*in_x4*in_x13*in_x17*in_x20*in_x27-in_x3*in_x4*in_x13*in_x17*in_x21*in_x26-in_x3*in_x4*in_x14*in_x16*in_x20*in_x27+in_x3*in_x4*in_x14*in_x16*in_x21*in_x26-in_x3*in_x4*in_x14*in_x18*in_x19*in_x26+in_x3*in_x4*in_x14*in_x18*in_x20*in_x25+in_x3*in_x4*in_x15*in_x17*in_x19*in_x26-in_x3*in_x4*in_x15*in_x17*in_x20*in_x25-in_x4*in_x6*in_x10*in_x17*in_x20*in_x27+in_x4*in_x6*in_x10*in_x17*in_x21*in_x26+in_x4*in_x6*in_x11*in_x16*in_x20*in_x27-in_x4*in_x6*in_x11*in_x16*in_x21*in_x26+in_x4*in_x6*in_x11*in_x18*in_x19*in_x26-in_x4*in_x6*in_x11*in_x18*in_x20*in_x25-in_x4*in_x6*in_x12*in_x17*in_x19*in_x26+in_x4*in_x6*in_x12*in_x17*in_x20*in_x25-in_x2*in_x9*in_x10*in_x17*in_x23*in_x27+in_x2*in_x9*in_x10*in_x17*in_x24*in_x26+in_x2*in_x9*in_x11*in_x16*in_x23*in_x27-in_x2*in_x9*in_x11*in_x16*in_x24*in_x26+in_x2*in_x9*in_x11*in_x18*in_x22*in_x26-in_x2*in_x9*in_x11*in_x18*in_x23*in_x25-in_x2*in_x9*in_x12*in_x17*in_x22*in_x26+in_x2*in_x9*in_x12*in_x17*in_x23*in_x25+in_x3*in_x5*in_x13*in_x17*in_x23*in_x27-in_x3*in_x5*in_x13*in_x17*in_x24*in_x26-in_x3*in_x5*in_x14*in_x16*in_x23*in_x27+in_x3*in_x5*in_x14*in_x16*in_x24*in_x26-in_x3*in_x5*in_x14*in_x18*in_x22*in_x26+in_x3*in_x5*in_x14*in_x18*in_x23*in_x25+in_x3*in_x5*in_x15*in_x17*in_x22*in_x26-in_x3*in_x5*in_x15*in_x17*in_x23*in_x25-in_x3*in_x8*in_x13*in_x17*in_x20*in_x27+in_x3*in_x8*in_x13*in_x17*in_x21*in_x26+in_x3*in_x8*in_x14*in_x16*in_x20*in_x27-in_x3*in_x8*in_x14*in_x16*in_x21*in_x26+in_x3*in_x8*in_x14*in_x18*in_x19*in_x26-in_x3*in_x8*in_x14*in_x18*in_x20*in_x25-in_x3*in_x8*in_x15*in_x17*in_x19*in_x26+in_x3*in_x8*in_x15*in_x17*in_x20*in_x25-in_x4*in_x7*in_x13*in_x17*in_x20*in_x27+in_x4*in_x7*in_x13*in_x17*in_x21*in_x26+in_x4*in_x7*in_x14*in_x16*in_x20*in_x27-in_x4*in_x7*in_x14*in_x16*in_x21*in_x26+in_x4*in_x7*in_x14*in_x18*in_x19*in_x26-in_x4*in_x7*in_x14*in_x18*in_x20*in_x25-in_x4*in_x7*in_x15*in_x17*in_x19*in_x26+in_x4*in_x7*in_x15*in_x17*in_x20*in_x25-in_x5*in_x6*in_x10*in_x17*in_x23*in_x27+in_x5*in_x6*in_x10*in_x17*in_x24*in_x26+in_x5*in_x6*in_x11*in_x16*in_x23*in_x27-in_x5*in_x6*in_x11*in_x16*in_x24*in_x26+in_x5*in_x6*in_x11*in_x18*in_x22*in_x26-in_x5*in_x6*in_x11*in_x18*in_x23*in_x25-in_x5*in_x6*in_x12*in_x17*in_x22*in_x26+in_x5*in_x6*in_x12*in_x17*in_x23*in_x25+in_x6*in_x8*in_x10*in_x17*in_x20*in_x27-in_x6*in_x8*in_x10*in_x17*in_x21*in_x26-in_x6*in_x8*in_x11*in_x16*in_x20*in_x27+in_x6*in_x8*in_x11*in_x16*in_x21*in_x26-in_x6*in_x8*in_x11*in_x18*in_x19*in_x26+in_x6*in_x8*in_x11*in_x18*in_x20*in_x25+in_x6*in_x8*in_x12*in_x17*in_x19*in_x26-in_x6*in_x8*in_x12*in_x17*in_x20*in_x25-in_x3*in_x9*in_x13*in_x17*in_x23*in_x27+in_x3*in_x9*in_x13*in_x17*in_x24*in_x26+in_x3*in_x9*in_x14*in_x16*in_x23*in_x27-in_x3*in_x9*in_x14*in_x16*in_x24*in_x26+in_x3*in_x9*in_x14*in_x18*in_x22*in_x26-in_x3*in_x9*in_x14*in_x18*in_x23*in_x25-in_x3*in_x9*in_x15*in_x17*in_x22*in_x26+in_x3*in_x9*in_x15*in_x17*in_x23*in_x25-in_x5*in_x7*in_x13*in_x17*in_x23*in_x27+in_x5*in_x7*in_x13*in_x17*in_x24*in_x26+in_x5*in_x7*in_x14*in_x16*in_x23*in_x27-in_x5*in_x7*in_x14*in_x16*in_x24*in_x26+in_x5*in_x7*in_x14*in_x18*in_x22*in_x26-in_x5*in_x7*in_x14*in_x18*in_x23*in_x25-in_x5*in_x7*in_x15*in_x17*in_x22*in_x26+in_x5*in_x7*in_x15*in_x17*in_x23*in_x25+in_x6*in_x9*in_x10*in_x17*in_x23*in_x27-in_x6*in_x9*in_x10*in_x17*in_x24*in_x26-in_x6*in_x9*in_x11*in_x16*in_x23*in_x27+in_x6*in_x9*in_x11*in_x16*in_x24*in_x26-in_x6*in_x9*in_x11*in_x18*in_x22*in_x26+in_x6*in_x9*in_x11*in_x18*in_x23*in_x25+in_x6*in_x9*in_x12*in_x17*in_x22*in_x26-in_x6*in_x9*in_x12*in_x17*in_x23*in_x25+in_x7*in_x8*in_x13*in_x17*in_x20*in_x27-in_x7*in_x8*in_x13*in_x17*in_x21*in_x26-in_x7*in_x8*in_x14*in_x16*in_x20*in_x27+in_x7*in_x8*in_x14*in_x16*in_x21*in_x26-in_x7*in_x8*in_x14*in_x18*in_x19*in_x26+in_x7*in_x8*in_x14*in_x18*in_x20*in_x25+in_x7*in_x8*in_x15*in_x17*in_x19*in_x26-in_x7*in_x8*in_x15*in_x17*in_x20*in_x25+in_x7*in_x9*in_x13*in_x17*in_x23*in_x27-in_x7*in_x9*in_x13*in_x17*in_x24*in_x26-in_x7*in_x9*in_x14*in_x16*in_x23*in_x27+in_x7*in_x9*in_x14*in_x16*in_x24*in_x26-in_x7*in_x9*in_x14*in_x18*in_x22*in_x26+in_x7*in_x9*in_x14*in_x18*in_x23*in_x25+in_x7*in_x9*in_x15*in_x17*in_x22*in_x26-in_x7*in_x9*in_x15*in_x17*in_x23*in_x25);  // NOLINT
        coeffs[1] = t2*t3*t4*in_x4*in_x10*in_x11*in_x20*in_x27-t2*t3*t4*in_x4*in_x10*in_x11*in_x21*in_x26+t2*t3*t4*in_x4*in_x11*in_x12*in_x19*in_x26-t2*t3*t4*in_x4*in_x11*in_x12*in_x20*in_x25-t2*t3*t5*in_x4*in_x10*in_x11*in_x20*in_x27+t2*t3*t5*in_x4*in_x10*in_x11*in_x21*in_x26-t2*t3*t5*in_x4*in_x11*in_x12*in_x19*in_x26+t2*t3*t5*in_x4*in_x11*in_x12*in_x20*in_x25-t2*t3*t8*in_x2*in_x10*in_x17*in_x20*in_x21+t2*t3*t8*in_x2*in_x11*in_x16*in_x20*in_x21-t2*t3*t8*in_x2*in_x11*in_x18*in_x19*in_x20+t2*t3*t8*in_x2*in_x12*in_x17*in_x19*in_x20+t2*t3*t4*in_x5*in_x10*in_x11*in_x23*in_x27-t2*t3*t4*in_x5*in_x10*in_x11*in_x24*in_x26+t2*t3*t4*in_x5*in_x11*in_x12*in_x22*in_x26-t2*t3*t4*in_x5*in_x11*in_x12*in_x23*in_x25-t2*t3*t4*in_x8*in_x10*in_x11*in_x20*in_x27+t2*t3*t4*in_x8*in_x10*in_x11*in_x21*in_x26-t2*t3*t4*in_x8*in_x11*in_x12*in_x19*in_x26+t2*t3*t4*in_x8*in_x11*in_x12*in_x20*in_x25-t2*t3*t5*in_x5*in_x10*in_x11*in_x23*in_x27+t2*t3*t5*in_x5*in_x10*in_x11*in_x24*in_x26-t2*t3*t5*in_x5*in_x11*in_x12*in_x22*in_x26+t2*t3*t5*in_x5*in_x11*in_x12*in_x23*in_x25+t2*t3*t5*in_x8*in_x10*in_x11*in_x20*in_x27-t2*t3*t5*in_x8*in_x10*in_x11*in_x21*in_x26+t2*t3*t5*in_x8*in_x11*in_x12*in_x19*in_x26-t2*t3*t5*in_x8*in_x11*in_x12*in_x20*in_x25+t2*t3*t11*in_x2*in_x10*in_x17*in_x20*in_x21-t2*t3*t11*in_x2*in_x11*in_x16*in_x20*in_x21+t2*t3*t11*in_x2*in_x11*in_x18*in_x19*in_x20-t2*t3*t11*in_x2*in_x12*in_x17*in_x19*in_x20-t2*t3*t8*in_x3*in_x13*in_x17*in_x20*in_x21+t2*t3*t8*in_x3*in_x14*in_x16*in_x20*in_x21-t2*t3*t8*in_x3*in_x14*in_x18*in_x19*in_x20+t2*t3*t8*in_x3*in_x15*in_x17*in_x19*in_x20+t2*t3*t8*in_x6*in_x10*in_x17*in_x20*in_x21-t2*t3*t8*in_x6*in_x11*in_x16*in_x20*in_x21+t2*t3*t8*in_x6*in_x11*in_x18*in_x19*in_x20-t2*t3*t8*in_x6*in_x12*in_x17*in_x19*in_x20-t2*t3*t4*in_x9*in_x10*in_x11*in_x23*in_x27+t2*t3*t4*in_x9*in_x10*in_x11*in_x24*in_x26-t2*t3*t4*in_x9*in_x11*in_x12*in_x22*in_x26+t2*t3*t4*in_x9*in_x11*in_x12*in_x23*in_x25+t2*t3*t5*in_x9*in_x10*in_x11*in_x23*in_x27-t2*t3*t5*in_x9*in_x10*in_x11*in_x24*in_x26+t2*t3*t5*in_x9*in_x11*in_x12*in_x22*in_x26-t2*t3*t5*in_x9*in_x11*in_x12*in_x23*in_x25+t2*t3*t7*in_x4*in_x13*in_x14*in_x20*in_x27-t2*t3*t7*in_x4*in_x13*in_x14*in_x21*in_x26+t2*t3*t7*in_x4*in_x14*in_x15*in_x19*in_x26-t2*t3*t7*in_x4*in_x14*in_x15*in_x20*in_x25+t2*t3*t11*in_x3*in_x13*in_x17*in_x20*in_x21-t2*t3*t11*in_x3*in_x14*in_x16*in_x20*in_x21+t2*t3*t11*in_x3*in_x14*in_x18*in_x19*in_x20-t2*t3*t11*in_x3*in_x15*in_x17*in_x19*in_x20-t2*t3*t11*in_x6*in_x10*in_x17*in_x20*in_x21+t2*t3*t11*in_x6*in_x11*in_x16*in_x20*in_x21-t2*t3*t11*in_x6*in_x11*in_x18*in_x19*in_x20+t2*t3*t11*in_x6*in_x12*in_x17*in_x19*in_x20+t2*t3*t8*in_x7*in_x13*in_x17*in_x20*in_x21-t2*t3*t8*in_x7*in_x14*in_x16*in_x20*in_x21+t2*t3*t8*in_x7*in_x14*in_x18*in_x19*in_x20-t2*t3*t8*in_x7*in_x15*in_x17*in_x19*in_x20-t2*t3*t10*in_x4*in_x13*in_x14*in_x20*in_x27+t2*t3*t10*in_x4*in_x13*in_x14*in_x21*in_x26-t2*t3*t10*in_x4*in_x14*in_x15*in_x19*in_x26+t2*t3*t10*in_x4*in_x14*in_x15*in_x20*in_x25+t2*t3*t7*in_x5*in_x13*in_x14*in_x23*in_x27-t2*t3*t7*in_x5*in_x13*in_x14*in_x24*in_x26+t2*t3*t7*in_x5*in_x14*in_x15*in_x22*in_x26-t2*t3*t7*in_x5*in_x14*in_x15*in_x23*in_x25-t2*t3*t7*in_x8*in_x13*in_x14*in_x20*in_x27+t2*t3*t7*in_x8*in_x13*in_x14*in_x21*in_x26-t2*t3*t7*in_x8*in_x14*in_x15*in_x19*in_x26+t2*t3*t7*in_x8*in_x14*in_x15*in_x20*in_x25-t2*t3*t11*in_x7*in_x13*in_x17*in_x20*in_x21+t2*t3*t11*in_x7*in_x14*in_x16*in_x20*in_x21-t2*t3*t11*in_x7*in_x14*in_x18*in_x19*in_x20+t2*t3*t11*in_x7*in_x15*in_x17*in_x19*in_x20-t2*t3*t13*in_x2*in_x10*in_x17*in_x23*in_x24+t2*t3*t13*in_x2*in_x11*in_x16*in_x23*in_x24-t2*t3*t13*in_x2*in_x11*in_x18*in_x22*in_x23+t2*t3*t13*in_x2*in_x12*in_x17*in_x22*in_x23+t2*t3*t15*in_x2*in_x10*in_x17*in_x23*in_x24-t2*t3*t15*in_x2*in_x11*in_x16*in_x23*in_x24+t2*t3*t15*in_x2*in_x11*in_x18*in_x22*in_x23-t2*t3*t15*in_x2*in_x12*in_x17*in_x22*in_x23-t2*t3*t10*in_x5*in_x13*in_x14*in_x23*in_x27+t2*t3*t10*in_x5*in_x13*in_x14*in_x24*in_x26-t2*t3*t10*in_x5*in_x14*in_x15*in_x22*in_x26+t2*t3*t10*in_x5*in_x14*in_x15*in_x23*in_x25+t2*t3*t10*in_x8*in_x13*in_x14*in_x20*in_x27-t2*t3*t10*in_x8*in_x13*in_x14*in_x21*in_x26+t2*t3*t10*in_x8*in_x14*in_x15*in_x19*in_x26-t2*t3*t10*in_x8*in_x14*in_x15*in_x20*in_x25-t3*t4*t6*in_x4*in_x16*in_x17*in_x20*in_x27+t3*t4*t6*in_x4*in_x16*in_x17*in_x21*in_x26-t3*t4*t6*in_x4*in_x17*in_x18*in_x19*in_x26+t3*t4*t6*in_x4*in_x17*in_x18*in_x20*in_x25-t2*t3*t7*in_x9*in_x13*in_x14*in_x23*in_x27+t2*t3*t7*in_x9*in_x13*in_x14*in_x24*in_x26-t2*t3*t7*in_x9*in_x14*in_x15*in_x22*in_x26+t2*t3*t7*in_x9*in_x14*in_x15*in_x23*in_x25-t2*t3*t13*in_x3*in_x13*in_x17*in_x23*in_x24+t2*t3*t13*in_x3*in_x14*in_x16*in_x23*in_x24-t2*t3*t13*in_x3*in_x14*in_x18*in_x22*in_x23+t2*t3*t13*in_x3*in_x15*in_x17*in_x22*in_x23+t2*t3*t13*in_x6*in_x10*in_x17*in_x23*in_x24-t2*t3*t13*in_x6*in_x11*in_x16*in_x23*in_x24+t2*t3*t13*in_x6*in_x11*in_x18*in_x22*in_x23-t2*t3*t13*in_x6*in_x12*in_x17*in_x22*in_x23+t3*t5*t6*in_x4*in_x16*in_x17*in_x20*in_x27-t3*t5*t6*in_x4*in_x16*in_x17*in_x21*in_x26+t3*t5*t6*in_x4*in_x17*in_x18*in_x19*in_x26-t3*t5*t6*in_x4*in_x17*in_x18*in_x20*in_x25+t2*t3*t15*in_x3*in_x13*in_x17*in_x23*in_x24-t2*t3*t15*in_x3*in_x14*in_x16*in_x23*in_x24+t2*t3*t15*in_x3*in_x14*in_x18*in_x22*in_x23-t2*t3*t15*in_x3*in_x15*in_x17*in_x22*in_x23-t2*t3*t15*in_x6*in_x10*in_x17*in_x23*in_x24+t2*t3*t15*in_x6*in_x11*in_x16*in_x23*in_x24-t2*t3*t15*in_x6*in_x11*in_x18*in_x22*in_x23+t2*t3*t15*in_x6*in_x12*in_x17*in_x22*in_x23+t2*t3*t10*in_x9*in_x13*in_x14*in_x23*in_x27-t2*t3*t10*in_x9*in_x13*in_x14*in_x24*in_x26+t2*t3*t10*in_x9*in_x14*in_x15*in_x22*in_x26-t2*t3*t10*in_x9*in_x14*in_x15*in_x23*in_x25-t3*t4*t6*in_x5*in_x16*in_x17*in_x23*in_x27+t3*t4*t6*in_x5*in_x16*in_x17*in_x24*in_x26-t3*t4*t6*in_x5*in_x17*in_x18*in_x22*in_x26+t3*t4*t6*in_x5*in_x17*in_x18*in_x23*in_x25+t3*t4*t6*in_x8*in_x16*in_x17*in_x20*in_x27-t3*t4*t6*in_x8*in_x16*in_x17*in_x21*in_x26+t3*t4*t6*in_x8*in_x17*in_x18*in_x19*in_x26-t3*t4*t6*in_x8*in_x17*in_x18*in_x20*in_x25+t2*t3*t13*in_x7*in_x13*in_x17*in_x23*in_x24-t2*t3*t13*in_x7*in_x14*in_x16*in_x23*in_x24+t2*t3*t13*in_x7*in_x14*in_x18*in_x22*in_x23-t2*t3*t13*in_x7*in_x15*in_x17*in_x22*in_x23+t3*t5*t6*in_x5*in_x16*in_x17*in_x23*in_x27-t3*t5*t6*in_x5*in_x16*in_x17*in_x24*in_x26+t3*t5*t6*in_x5*in_x17*in_x18*in_x22*in_x26-t3*t5*t6*in_x5*in_x17*in_x18*in_x23*in_x25-t3*t5*t6*in_x8*in_x16*in_x17*in_x20*in_x27+t3*t5*t6*in_x8*in_x16*in_x17*in_x21*in_x26-t3*t5*t6*in_x8*in_x17*in_x18*in_x19*in_x26+t3*t5*t6*in_x8*in_x17*in_x18*in_x20*in_x25-t3*t7*t9*in_x4*in_x16*in_x17*in_x20*in_x27+t3*t7*t9*in_x4*in_x16*in_x17*in_x21*in_x26-t3*t7*t9*in_x4*in_x17*in_x18*in_x19*in_x26+t3*t7*t9*in_x4*in_x17*in_x18*in_x20*in_x25-t2*t3*t15*in_x7*in_x13*in_x17*in_x23*in_x24+t2*t3*t15*in_x7*in_x14*in_x16*in_x23*in_x24-t2*t3*t15*in_x7*in_x14*in_x18*in_x22*in_x23+t2*t3*t15*in_x7*in_x15*in_x17*in_x22*in_x23+t2*t8*t12*in_x2*in_x10*in_x17*in_x26*in_x27-t2*t8*t12*in_x2*in_x11*in_x16*in_x26*in_x27+t2*t8*t12*in_x2*in_x11*in_x18*in_x25*in_x26-t2*t8*t12*in_x2*in_x12*in_x17*in_x25*in_x26+t3*t4*t6*in_x9*in_x16*in_x17*in_x23*in_x27-t3*t4*t6*in_x9*in_x16*in_x17*in_x24*in_x26+t3*t4*t6*in_x9*in_x17*in_x18*in_x22*in_x26-t3*t4*t6*in_x9*in_x17*in_x18*in_x23*in_x25-t3*t5*t6*in_x9*in_x16*in_x17*in_x23*in_x27+t3*t5*t6*in_x9*in_x16*in_x17*in_x24*in_x26-t3*t5*t6*in_x9*in_x17*in_x18*in_x22*in_x26+t3*t5*t6*in_x9*in_x17*in_x18*in_x23*in_x25+t3*t9*t10*in_x4*in_x16*in_x17*in_x20*in_x27-t3*t9*t10*in_x4*in_x16*in_x17*in_x21*in_x26+t3*t9*t10*in_x4*in_x17*in_x18*in_x19*in_x26-t3*t9*t10*in_x4*in_x17*in_x18*in_x20*in_x25-t2*t11*t12*in_x2*in_x10*in_x17*in_x26*in_x27+t2*t11*t12*in_x2*in_x11*in_x16*in_x26*in_x27-t2*t11*t12*in_x2*in_x11*in_x18*in_x25*in_x26+t2*t11*t12*in_x2*in_x12*in_x17*in_x25*in_x26-t3*t7*t9*in_x5*in_x16*in_x17*in_x23*in_x27+t3*t7*t9*in_x5*in_x16*in_x17*in_x24*in_x26-t3*t7*t9*in_x5*in_x17*in_x18*in_x22*in_x26+t3*t7*t9*in_x5*in_x17*in_x18*in_x23*in_x25+t3*t7*t9*in_x8*in_x16*in_x17*in_x20*in_x27-t3*t7*t9*in_x8*in_x16*in_x17*in_x21*in_x26+t3*t7*t9*in_x8*in_x17*in_x18*in_x19*in_x26-t3*t7*t9*in_x8*in_x17*in_x18*in_x20*in_x25+t2*t8*t12*in_x3*in_x13*in_x17*in_x26*in_x27-t2*t8*t12*in_x3*in_x14*in_x16*in_x26*in_x27+t2*t8*t12*in_x3*in_x14*in_x18*in_x25*in_x26-t2*t8*t12*in_x3*in_x15*in_x17*in_x25*in_x26-t2*t8*t12*in_x6*in_x10*in_x17*in_x26*in_x27+t2*t8*t12*in_x6*in_x11*in_x16*in_x26*in_x27-t2*t8*t12*in_x6*in_x11*in_x18*in_x25*in_x26+t2*t8*t12*in_x6*in_x12*in_x17*in_x25*in_x26+t3*t9*t10*in_x5*in_x16*in_x17*in_x23*in_x27-t3*t9*t10*in_x5*in_x16*in_x17*in_x24*in_x26+t3*t9*t10*in_x5*in_x17*in_x18*in_x22*in_x26-t3*t9*t10*in_x5*in_x17*in_x18*in_x23*in_x25-t3*t9*t10*in_x8*in_x16*in_x17*in_x20*in_x27+t3*t9*t10*in_x8*in_x16*in_x17*in_x21*in_x26-t3*t9*t10*in_x8*in_x17*in_x18*in_x19*in_x26+t3*t9*t10*in_x8*in_x17*in_x18*in_x20*in_x25-t2*t11*t12*in_x3*in_x13*in_x17*in_x26*in_x27+t2*t11*t12*in_x3*in_x14*in_x16*in_x26*in_x27-t2*t11*t12*in_x3*in_x14*in_x18*in_x25*in_x26+t2*t11*t12*in_x3*in_x15*in_x17*in_x25*in_x26+t2*t11*t12*in_x6*in_x10*in_x17*in_x26*in_x27-t2*t11*t12*in_x6*in_x11*in_x16*in_x26*in_x27+t2*t11*t12*in_x6*in_x11*in_x18*in_x25*in_x26-t2*t11*t12*in_x6*in_x12*in_x17*in_x25*in_x26+t2*t13*t14*in_x2*in_x10*in_x17*in_x26*in_x27-t2*t13*t14*in_x2*in_x11*in_x16*in_x26*in_x27+t2*t13*t14*in_x2*in_x11*in_x18*in_x25*in_x26-t2*t13*t14*in_x2*in_x12*in_x17*in_x25*in_x26+t3*t7*t9*in_x9*in_x16*in_x17*in_x23*in_x27-t3*t7*t9*in_x9*in_x16*in_x17*in_x24*in_x26+t3*t7*t9*in_x9*in_x17*in_x18*in_x22*in_x26-t3*t7*t9*in_x9*in_x17*in_x18*in_x23*in_x25-t2*t8*t12*in_x7*in_x13*in_x17*in_x26*in_x27+t2*t8*t12*in_x7*in_x14*in_x16*in_x26*in_x27-t2*t8*t12*in_x7*in_x14*in_x18*in_x25*in_x26+t2*t8*t12*in_x7*in_x15*in_x17*in_x25*in_x26-t2*t14*t15*in_x2*in_x10*in_x17*in_x26*in_x27+t2*t14*t15*in_x2*in_x11*in_x16*in_x26*in_x27-t2*t14*t15*in_x2*in_x11*in_x18*in_x25*in_x26+t2*t14*t15*in_x2*in_x12*in_x17*in_x25*in_x26-t3*t9*t10*in_x9*in_x16*in_x17*in_x23*in_x27+t3*t9*t10*in_x9*in_x16*in_x17*in_x24*in_x26-t3*t9*t10*in_x9*in_x17*in_x18*in_x22*in_x26+t3*t9*t10*in_x9*in_x17*in_x18*in_x23*in_x25+t2*t11*t12*in_x7*in_x13*in_x17*in_x26*in_x27-t2*t11*t12*in_x7*in_x14*in_x16*in_x26*in_x27+t2*t11*t12*in_x7*in_x14*in_x18*in_x25*in_x26-t2*t11*t12*in_x7*in_x15*in_x17*in_x25*in_x26+t2*t13*t14*in_x3*in_x13*in_x17*in_x26*in_x27-t2*t13*t14*in_x3*in_x14*in_x16*in_x26*in_x27+t2*t13*t14*in_x3*in_x14*in_x18*in_x25*in_x26-t2*t13*t14*in_x3*in_x15*in_x17*in_x25*in_x26-t2*t13*t14*in_x6*in_x10*in_x17*in_x26*in_x27+t2*t13*t14*in_x6*in_x11*in_x16*in_x26*in_x27-t2*t13*t14*in_x6*in_x11*in_x18*in_x25*in_x26+t2*t13*t14*in_x6*in_x12*in_x17*in_x25*in_x26-t2*t14*t15*in_x3*in_x13*in_x17*in_x26*in_x27+t2*t14*t15*in_x3*in_x14*in_x16*in_x26*in_x27-t2*t14*t15*in_x3*in_x14*in_x18*in_x25*in_x26+t2*t14*t15*in_x3*in_x15*in_x17*in_x25*in_x26+t2*t14*t15*in_x6*in_x10*in_x17*in_x26*in_x27-t2*t14*t15*in_x6*in_x11*in_x16*in_x26*in_x27+t2*t14*t15*in_x6*in_x11*in_x18*in_x25*in_x26-t2*t14*t15*in_x6*in_x12*in_x17*in_x25*in_x26-t2*t13*t14*in_x7*in_x13*in_x17*in_x26*in_x27+t2*t13*t14*in_x7*in_x14*in_x16*in_x26*in_x27-t2*t13*t14*in_x7*in_x14*in_x18*in_x25*in_x26+t2*t13*t14*in_x7*in_x15*in_x17*in_x25*in_x26+t2*t14*t15*in_x7*in_x13*in_x17*in_x26*in_x27-t2*t14*t15*in_x7*in_x14*in_x16*in_x26*in_x27+t2*t14*t15*in_x7*in_x14*in_x18*in_x25*in_x26-t2*t14*t15*in_x7*in_x15*in_x17*in_x25*in_x26+t2*t3*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x27-t2*t3*in_x2*in_x3*in_x4*in_x10*in_x14*in_x21*in_x26+t2*t3*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x27-t2*t3*in_x2*in_x3*in_x4*in_x11*in_x13*in_x21*in_x26+t2*t3*in_x2*in_x3*in_x4*in_x11*in_x15*in_x19*in_x26-t2*t3*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x25+t2*t3*in_x2*in_x3*in_x4*in_x12*in_x14*in_x19*in_x26-t2*t3*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x25-t2*t3*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x24-t2*t3*in_x2*in_x4*in_x5*in_x10*in_x17*in_x21*in_x23+t2*t3*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x24+t2*t3*in_x2*in_x4*in_x5*in_x11*in_x16*in_x21*in_x23-t2*t3*in_x2*in_x4*in_x5*in_x11*in_x18*in_x19*in_x23-t2*t3*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x22+t2*t3*in_x2*in_x4*in_x5*in_x12*in_x17*in_x19*in_x23+t2*t3*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x22+t2*t3*in_x2*in_x3*in_x5*in_x10*in_x14*in_x23*in_x27-t2*t3*in_x2*in_x3*in_x5*in_x10*in_x14*in_x24*in_x26+t2*t3*in_x2*in_x3*in_x5*in_x11*in_x13*in_x23*in_x27-t2*t3*in_x2*in_x3*in_x5*in_x11*in_x13*in_x24*in_x26+t2*t3*in_x2*in_x3*in_x5*in_x11*in_x15*in_x22*in_x26-t2*t3*in_x2*in_x3*in_x5*in_x11*in_x15*in_x23*in_x25+t2*t3*in_x2*in_x3*in_x5*in_x12*in_x14*in_x22*in_x26-t2*t3*in_x2*in_x3*in_x5*in_x12*in_x14*in_x23*in_x25-t2*t3*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x27+t2*t3*in_x2*in_x3*in_x8*in_x10*in_x14*in_x21*in_x26-t2*t3*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x27+t2*t3*in_x2*in_x3*in_x8*in_x11*in_x13*in_x21*in_x26-t2*t3*in_x2*in_x3*in_x8*in_x11*in_x15*in_x19*in_x26+t2*t3*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x25-t2*t3*in_x2*in_x3*in_x8*in_x12*in_x14*in_x19*in_x26+t2*t3*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x25+t2*t3*in_x2*in_x4*in_x7*in_x10*in_x14*in_x20*in_x27*2.0-t2*t3*in_x2*in_x4*in_x7*in_x10*in_x14*in_x21*in_x26*2.0-t2*t3*in_x2*in_x4*in_x7*in_x11*in_x13*in_x20*in_x27*2.0+t2*t3*in_x2*in_x4*in_x7*in_x11*in_x13*in_x21*in_x26*2.0-t2*t3*in_x2*in_x4*in_x7*in_x11*in_x15*in_x19*in_x26*2.0+t2*t3*in_x2*in_x4*in_x7*in_x11*in_x15*in_x20*in_x25*2.0+t2*t3*in_x2*in_x4*in_x7*in_x12*in_x14*in_x19*in_x26*2.0-t2*t3*in_x2*in_x4*in_x7*in_x12*in_x14*in_x20*in_x25*2.0-t2*t3*in_x3*in_x4*in_x6*in_x10*in_x14*in_x20*in_x27*2.0+t2*t3*in_x3*in_x4*in_x6*in_x10*in_x14*in_x21*in_x26*2.0+t2*t3*in_x3*in_x4*in_x6*in_x11*in_x13*in_x20*in_x27*2.0-t2*t3*in_x3*in_x4*in_x6*in_x11*in_x13*in_x21*in_x26*2.0+t2*t3*in_x3*in_x4*in_x6*in_x11*in_x15*in_x19*in_x26*2.0-t2*t3*in_x3*in_x4*in_x6*in_x11*in_x15*in_x20*in_x25*2.0-t2*t3*in_x3*in_x4*in_x6*in_x12*in_x14*in_x19*in_x26*2.0+t2*t3*in_x3*in_x4*in_x6*in_x12*in_x14*in_x20*in_x25*2.0+t2*t3*in_x2*in_x4*in_x9*in_x10*in_x17*in_x20*in_x24*2.0-t2*t3*in_x2*in_x4*in_x9*in_x10*in_x17*in_x21*in_x23*2.0-t2*t3*in_x2*in_x4*in_x9*in_x11*in_x16*in_x20*in_x24*2.0+t2*t3*in_x2*in_x4*in_x9*in_x11*in_x16*in_x21*in_x23*2.0-t2*t3*in_x2*in_x4*in_x9*in_x11*in_x18*in_x19*in_x23*2.0+t2*t3*in_x2*in_x4*in_x9*in_x11*in_x18*in_x20*in_x22*2.0+t2*t3*in_x2*in_x4*in_x9*in_x12*in_x17*in_x19*in_x23*2.0-t2*t3*in_x2*in_x4*in_x9*in_x12*in_x17*in_x20*in_x22*2.0-t2*t3*in_x2*in_x5*in_x8*in_x10*in_x17*in_x20*in_x24*2.0+t2*t3*in_x2*in_x5*in_x8*in_x10*in_x17*in_x21*in_x23*2.0+t2*t3*in_x2*in_x5*in_x8*in_x11*in_x16*in_x20*in_x24*2.0-t2*t3*in_x2*in_x5*in_x8*in_x11*in_x16*in_x21*in_x23*2.0+t2*t3*in_x2*in_x5*in_x8*in_x11*in_x18*in_x19*in_x23*2.0-t2*t3*in_x2*in_x5*in_x8*in_x11*in_x18*in_x20*in_x22*2.0-t2*t3*in_x2*in_x5*in_x8*in_x12*in_x17*in_x19*in_x23*2.0+t2*t3*in_x2*in_x5*in_x8*in_x12*in_x17*in_x20*in_x22*2.0-t2*t3*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x24-t2*t3*in_x3*in_x4*in_x5*in_x13*in_x17*in_x21*in_x23+t2*t3*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x24+t2*t3*in_x3*in_x4*in_x5*in_x14*in_x16*in_x21*in_x23-t2*t3*in_x3*in_x4*in_x5*in_x14*in_x18*in_x19*in_x23-t2*t3*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x22+t2*t3*in_x3*in_x4*in_x5*in_x15*in_x17*in_x19*in_x23+t2*t3*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x22+t2*t3*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x24+t2*t3*in_x4*in_x5*in_x6*in_x10*in_x17*in_x21*in_x23-t2*t3*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x24-t2*t3*in_x4*in_x5*in_x6*in_x11*in_x16*in_x21*in_x23+t2*t3*in_x4*in_x5*in_x6*in_x11*in_x18*in_x19*in_x23+t2*t3*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x22-t2*t3*in_x4*in_x5*in_x6*in_x12*in_x17*in_x19*in_x23-t2*t3*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x22-t2*t3*in_x2*in_x3*in_x9*in_x10*in_x14*in_x23*in_x27+t2*t3*in_x2*in_x3*in_x9*in_x10*in_x14*in_x24*in_x26-t2*t3*in_x2*in_x3*in_x9*in_x11*in_x13*in_x23*in_x27+t2*t3*in_x2*in_x3*in_x9*in_x11*in_x13*in_x24*in_x26-t2*t3*in_x2*in_x3*in_x9*in_x11*in_x15*in_x22*in_x26+t2*t3*in_x2*in_x3*in_x9*in_x11*in_x15*in_x23*in_x25-t2*t3*in_x2*in_x3*in_x9*in_x12*in_x14*in_x22*in_x26+t2*t3*in_x2*in_x3*in_x9*in_x12*in_x14*in_x23*in_x25+t2*t3*in_x2*in_x5*in_x7*in_x10*in_x14*in_x23*in_x27*2.0-t2*t3*in_x2*in_x5*in_x7*in_x10*in_x14*in_x24*in_x26*2.0-t2*t3*in_x2*in_x5*in_x7*in_x11*in_x13*in_x23*in_x27*2.0+t2*t3*in_x2*in_x5*in_x7*in_x11*in_x13*in_x24*in_x26*2.0-t2*t3*in_x2*in_x5*in_x7*in_x11*in_x15*in_x22*in_x26*2.0+t2*t3*in_x2*in_x5*in_x7*in_x11*in_x15*in_x23*in_x25*2.0+t2*t3*in_x2*in_x5*in_x7*in_x12*in_x14*in_x22*in_x26*2.0-t2*t3*in_x2*in_x5*in_x7*in_x12*in_x14*in_x23*in_x25*2.0-t2*t3*in_x2*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27*2.0+t2*t3*in_x2*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26*2.0+t2*t3*in_x2*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27*2.0-t2*t3*in_x2*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26*2.0+t2*t3*in_x2*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26*2.0-t2*t3*in_x2*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25*2.0-t2*t3*in_x2*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26*2.0+t2*t3*in_x2*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25*2.0-t2*t3*in_x3*in_x5*in_x6*in_x10*in_x14*in_x23*in_x27*2.0+t2*t3*in_x3*in_x5*in_x6*in_x10*in_x14*in_x24*in_x26*2.0+t2*t3*in_x3*in_x5*in_x6*in_x11*in_x13*in_x23*in_x27*2.0-t2*t3*in_x3*in_x5*in_x6*in_x11*in_x13*in_x24*in_x26*2.0+t2*t3*in_x3*in_x5*in_x6*in_x11*in_x15*in_x22*in_x26*2.0-t2*t3*in_x3*in_x5*in_x6*in_x11*in_x15*in_x23*in_x25*2.0-t2*t3*in_x3*in_x5*in_x6*in_x12*in_x14*in_x22*in_x26*2.0+t2*t3*in_x3*in_x5*in_x6*in_x12*in_x14*in_x23*in_x25*2.0+t2*t3*in_x3*in_x6*in_x8*in_x10*in_x14*in_x20*in_x27*2.0-t2*t3*in_x3*in_x6*in_x8*in_x10*in_x14*in_x21*in_x26*2.0-t2*t3*in_x3*in_x6*in_x8*in_x11*in_x13*in_x20*in_x27*2.0+t2*t3*in_x3*in_x6*in_x8*in_x11*in_x13*in_x21*in_x26*2.0-t2*t3*in_x3*in_x6*in_x8*in_x11*in_x15*in_x19*in_x26*2.0+t2*t3*in_x3*in_x6*in_x8*in_x11*in_x15*in_x20*in_x25*2.0+t2*t3*in_x3*in_x6*in_x8*in_x12*in_x14*in_x19*in_x26*2.0-t2*t3*in_x3*in_x6*in_x8*in_x12*in_x14*in_x20*in_x25*2.0-t2*t3*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x27+t2*t3*in_x4*in_x6*in_x7*in_x10*in_x14*in_x21*in_x26-t2*t3*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x27+t2*t3*in_x4*in_x6*in_x7*in_x11*in_x13*in_x21*in_x26-t2*t3*in_x4*in_x6*in_x7*in_x11*in_x15*in_x19*in_x26+t2*t3*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x25-t2*t3*in_x4*in_x6*in_x7*in_x12*in_x14*in_x19*in_x26+t2*t3*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x25+t2*t3*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24+t2*t3*in_x2*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23-t2*t3*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24-t2*t3*in_x2*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23+t2*t3*in_x2*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23+t2*t3*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22-t2*t3*in_x2*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23-t2*t3*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t2*t3*in_x3*in_x4*in_x9*in_x13*in_x17*in_x20*in_x24*2.0-t2*t3*in_x3*in_x4*in_x9*in_x13*in_x17*in_x21*in_x23*2.0-t2*t3*in_x3*in_x4*in_x9*in_x14*in_x16*in_x20*in_x24*2.0+t2*t3*in_x3*in_x4*in_x9*in_x14*in_x16*in_x21*in_x23*2.0-t2*t3*in_x3*in_x4*in_x9*in_x14*in_x18*in_x19*in_x23*2.0+t2*t3*in_x3*in_x4*in_x9*in_x14*in_x18*in_x20*in_x22*2.0+t2*t3*in_x3*in_x4*in_x9*in_x15*in_x17*in_x19*in_x23*2.0-t2*t3*in_x3*in_x4*in_x9*in_x15*in_x17*in_x20*in_x22*2.0-t2*t3*in_x3*in_x5*in_x8*in_x13*in_x17*in_x20*in_x24*2.0+t2*t3*in_x3*in_x5*in_x8*in_x13*in_x17*in_x21*in_x23*2.0+t2*t3*in_x3*in_x5*in_x8*in_x14*in_x16*in_x20*in_x24*2.0-t2*t3*in_x3*in_x5*in_x8*in_x14*in_x16*in_x21*in_x23*2.0+t2*t3*in_x3*in_x5*in_x8*in_x14*in_x18*in_x19*in_x23*2.0-t2*t3*in_x3*in_x5*in_x8*in_x14*in_x18*in_x20*in_x22*2.0-t2*t3*in_x3*in_x5*in_x8*in_x15*in_x17*in_x19*in_x23*2.0+t2*t3*in_x3*in_x5*in_x8*in_x15*in_x17*in_x20*in_x22*2.0+t2*t3*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x24+t2*t3*in_x4*in_x5*in_x7*in_x13*in_x17*in_x21*in_x23-t2*t3*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x24-t2*t3*in_x4*in_x5*in_x7*in_x14*in_x16*in_x21*in_x23+t2*t3*in_x4*in_x5*in_x7*in_x14*in_x18*in_x19*in_x23+t2*t3*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x22-t2*t3*in_x4*in_x5*in_x7*in_x15*in_x17*in_x19*in_x23-t2*t3*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x22-t2*t3*in_x4*in_x6*in_x9*in_x10*in_x17*in_x20*in_x24*2.0+t2*t3*in_x4*in_x6*in_x9*in_x10*in_x17*in_x21*in_x23*2.0+t2*t3*in_x4*in_x6*in_x9*in_x11*in_x16*in_x20*in_x24*2.0-t2*t3*in_x4*in_x6*in_x9*in_x11*in_x16*in_x21*in_x23*2.0+t2*t3*in_x4*in_x6*in_x9*in_x11*in_x18*in_x19*in_x23*2.0-t2*t3*in_x4*in_x6*in_x9*in_x11*in_x18*in_x20*in_x22*2.0-t2*t3*in_x4*in_x6*in_x9*in_x12*in_x17*in_x19*in_x23*2.0+t2*t3*in_x4*in_x6*in_x9*in_x12*in_x17*in_x20*in_x22*2.0+t2*t3*in_x5*in_x6*in_x8*in_x10*in_x17*in_x20*in_x24*2.0-t2*t3*in_x5*in_x6*in_x8*in_x10*in_x17*in_x21*in_x23*2.0-t2*t3*in_x5*in_x6*in_x8*in_x11*in_x16*in_x20*in_x24*2.0+t2*t3*in_x5*in_x6*in_x8*in_x11*in_x16*in_x21*in_x23*2.0-t2*t3*in_x5*in_x6*in_x8*in_x11*in_x18*in_x19*in_x23*2.0+t2*t3*in_x5*in_x6*in_x8*in_x11*in_x18*in_x20*in_x22*2.0+t2*t3*in_x5*in_x6*in_x8*in_x12*in_x17*in_x19*in_x23*2.0-t2*t3*in_x5*in_x6*in_x8*in_x12*in_x17*in_x20*in_x22*2.0-t2*t3*in_x2*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27*2.0+t2*t3*in_x2*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26*2.0+t2*t3*in_x2*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27*2.0-t2*t3*in_x2*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26*2.0+t2*t3*in_x2*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26*2.0-t2*t3*in_x2*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25*2.0-t2*t3*in_x2*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26*2.0+t2*t3*in_x2*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25*2.0+t2*t3*in_x3*in_x6*in_x9*in_x10*in_x14*in_x23*in_x27*2.0-t2*t3*in_x3*in_x6*in_x9*in_x10*in_x14*in_x24*in_x26*2.0-t2*t3*in_x3*in_x6*in_x9*in_x11*in_x13*in_x23*in_x27*2.0+t2*t3*in_x3*in_x6*in_x9*in_x11*in_x13*in_x24*in_x26*2.0-t2*t3*in_x3*in_x6*in_x9*in_x11*in_x15*in_x22*in_x26*2.0+t2*t3*in_x3*in_x6*in_x9*in_x11*in_x15*in_x23*in_x25*2.0+t2*t3*in_x3*in_x6*in_x9*in_x12*in_x14*in_x22*in_x26*2.0-t2*t3*in_x3*in_x6*in_x9*in_x12*in_x14*in_x23*in_x25*2.0-t2*t3*in_x5*in_x6*in_x7*in_x10*in_x14*in_x23*in_x27+t2*t3*in_x5*in_x6*in_x7*in_x10*in_x14*in_x24*in_x26-t2*t3*in_x5*in_x6*in_x7*in_x11*in_x13*in_x23*in_x27+t2*t3*in_x5*in_x6*in_x7*in_x11*in_x13*in_x24*in_x26-t2*t3*in_x5*in_x6*in_x7*in_x11*in_x15*in_x22*in_x26+t2*t3*in_x5*in_x6*in_x7*in_x11*in_x15*in_x23*in_x25-t2*t3*in_x5*in_x6*in_x7*in_x12*in_x14*in_x22*in_x26+t2*t3*in_x5*in_x6*in_x7*in_x12*in_x14*in_x23*in_x25+t2*t3*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27-t2*t3*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26+t2*t3*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27-t2*t3*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26+t2*t3*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26-t2*t3*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25+t2*t3*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26-t2*t3*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25+t2*t3*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24+t2*t3*in_x3*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23-t2*t3*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24-t2*t3*in_x3*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23+t2*t3*in_x3*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23+t2*t3*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22-t2*t3*in_x3*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23-t2*t3*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t2*t3*in_x4*in_x7*in_x9*in_x13*in_x17*in_x20*in_x24*2.0+t2*t3*in_x4*in_x7*in_x9*in_x13*in_x17*in_x21*in_x23*2.0+t2*t3*in_x4*in_x7*in_x9*in_x14*in_x16*in_x20*in_x24*2.0-t2*t3*in_x4*in_x7*in_x9*in_x14*in_x16*in_x21*in_x23*2.0+t2*t3*in_x4*in_x7*in_x9*in_x14*in_x18*in_x19*in_x23*2.0-t2*t3*in_x4*in_x7*in_x9*in_x14*in_x18*in_x20*in_x22*2.0-t2*t3*in_x4*in_x7*in_x9*in_x15*in_x17*in_x19*in_x23*2.0+t2*t3*in_x4*in_x7*in_x9*in_x15*in_x17*in_x20*in_x22*2.0+t2*t3*in_x5*in_x7*in_x8*in_x13*in_x17*in_x20*in_x24*2.0-t2*t3*in_x5*in_x7*in_x8*in_x13*in_x17*in_x21*in_x23*2.0-t2*t3*in_x5*in_x7*in_x8*in_x14*in_x16*in_x20*in_x24*2.0+t2*t3*in_x5*in_x7*in_x8*in_x14*in_x16*in_x21*in_x23*2.0-t2*t3*in_x5*in_x7*in_x8*in_x14*in_x18*in_x19*in_x23*2.0+t2*t3*in_x5*in_x7*in_x8*in_x14*in_x18*in_x20*in_x22*2.0+t2*t3*in_x5*in_x7*in_x8*in_x15*in_x17*in_x19*in_x23*2.0-t2*t3*in_x5*in_x7*in_x8*in_x15*in_x17*in_x20*in_x22*2.0-t2*t3*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24-t2*t3*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23+t2*t3*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24+t2*t3*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23-t2*t3*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23-t2*t3*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22+t2*t3*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23+t2*t3*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t2*t3*in_x6*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27-t2*t3*in_x6*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26+t2*t3*in_x6*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27-t2*t3*in_x6*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26+t2*t3*in_x6*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26-t2*t3*in_x6*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25+t2*t3*in_x6*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26-t2*t3*in_x6*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25-t2*t3*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24-t2*t3*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23+t2*t3*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24+t2*t3*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23-t2*t3*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23-t2*t3*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22+t2*t3*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23+t2*t3*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t3*in_x2*in_x3*in_x4*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0+t3*in_x2*in_x3*in_x4*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0-t3*in_x2*in_x3*in_x4*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0+t3*in_x2*in_x3*in_x4*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0-t3*in_x2*in_x3*in_x5*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0+t3*in_x2*in_x3*in_x5*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0-t3*in_x2*in_x3*in_x5*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0+t3*in_x2*in_x3*in_x5*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0+t3*in_x2*in_x3*in_x8*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0-t3*in_x2*in_x3*in_x8*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0+t3*in_x2*in_x3*in_x8*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0-t3*in_x2*in_x3*in_x8*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0+t3*in_x2*in_x3*in_x9*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0-t3*in_x2*in_x3*in_x9*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0+t3*in_x2*in_x3*in_x9*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0-t3*in_x2*in_x3*in_x9*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0+t3*in_x4*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0-t3*in_x4*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0+t3*in_x4*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0-t3*in_x4*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0+t3*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0-t3*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0+t3*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0-t3*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0-t3*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0+t3*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0-t3*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0+t3*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0-t3*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0+t3*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0-t3*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0+t3*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0+t2*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0+t2*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t2*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t2*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t2*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t2*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0+t2*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0+t2*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0;  // NOLINT
        coeffs[2] = -t2*t3*t4*t8*in_x10*in_x11*in_x20*in_x21+t2*t3*t4*t8*in_x11*in_x12*in_x19*in_x20+t2*t3*t5*t8*in_x10*in_x11*in_x20*in_x21-t2*t3*t5*t8*in_x11*in_x12*in_x19*in_x20+t2*t3*t4*t11*in_x10*in_x11*in_x20*in_x21-t2*t3*t4*t11*in_x11*in_x12*in_x19*in_x20-t2*t3*t5*t11*in_x10*in_x11*in_x20*in_x21+t2*t3*t5*t11*in_x11*in_x12*in_x19*in_x20-t2*t3*t7*t8*in_x13*in_x14*in_x20*in_x21+t2*t3*t7*t8*in_x14*in_x15*in_x19*in_x20-t2*t3*t4*t13*in_x10*in_x11*in_x23*in_x24+t2*t3*t4*t13*in_x11*in_x12*in_x22*in_x23+t2*t3*t5*t13*in_x10*in_x11*in_x23*in_x24-t2*t3*t5*t13*in_x11*in_x12*in_x22*in_x23+t2*t3*t7*t11*in_x13*in_x14*in_x20*in_x21-t2*t3*t7*t11*in_x14*in_x15*in_x19*in_x20+t2*t3*t8*t10*in_x13*in_x14*in_x20*in_x21-t2*t3*t8*t10*in_x14*in_x15*in_x19*in_x20+t2*t3*t4*t15*in_x10*in_x11*in_x23*in_x24-t2*t3*t4*t15*in_x11*in_x12*in_x22*in_x23-t2*t3*t5*t15*in_x10*in_x11*in_x23*in_x24+t2*t3*t5*t15*in_x11*in_x12*in_x22*in_x23-t2*t3*t10*t11*in_x13*in_x14*in_x20*in_x21+t2*t3*t10*t11*in_x14*in_x15*in_x19*in_x20+t3*t4*t6*t8*in_x16*in_x17*in_x20*in_x21-t3*t4*t6*t8*in_x17*in_x18*in_x19*in_x20-t3*t5*t6*t8*in_x16*in_x17*in_x20*in_x21+t3*t5*t6*t8*in_x17*in_x18*in_x19*in_x20-t3*t4*t6*t11*in_x16*in_x17*in_x20*in_x21+t3*t4*t6*t11*in_x17*in_x18*in_x19*in_x20-t2*t3*t7*t13*in_x13*in_x14*in_x23*in_x24+t2*t3*t7*t13*in_x14*in_x15*in_x22*in_x23+t3*t5*t6*t11*in_x16*in_x17*in_x20*in_x21-t3*t5*t6*t11*in_x17*in_x18*in_x19*in_x20+t2*t4*t8*t12*in_x10*in_x11*in_x26*in_x27-t2*t4*t8*t12*in_x11*in_x12*in_x25*in_x26+t2*t3*t7*t15*in_x13*in_x14*in_x23*in_x24-t2*t3*t7*t15*in_x14*in_x15*in_x22*in_x23-t2*t5*t8*t12*in_x10*in_x11*in_x26*in_x27+t2*t5*t8*t12*in_x11*in_x12*in_x25*in_x26+t3*t7*t8*t9*in_x16*in_x17*in_x20*in_x21-t3*t7*t8*t9*in_x17*in_x18*in_x19*in_x20+t2*t3*t10*t13*in_x13*in_x14*in_x23*in_x24-t2*t3*t10*t13*in_x14*in_x15*in_x22*in_x23-t2*t4*t11*t12*in_x10*in_x11*in_x26*in_x27+t2*t4*t11*t12*in_x11*in_x12*in_x25*in_x26-t2*t3*t10*t15*in_x13*in_x14*in_x23*in_x24+t2*t3*t10*t15*in_x14*in_x15*in_x22*in_x23+t2*t5*t11*t12*in_x10*in_x11*in_x26*in_x27-t2*t5*t11*t12*in_x11*in_x12*in_x25*in_x26-t3*t7*t9*t11*in_x16*in_x17*in_x20*in_x21+t3*t7*t9*t11*in_x17*in_x18*in_x19*in_x20-t3*t8*t9*t10*in_x16*in_x17*in_x20*in_x21+t3*t8*t9*t10*in_x17*in_x18*in_x19*in_x20+t3*t4*t6*t13*in_x16*in_x17*in_x23*in_x24-t3*t4*t6*t13*in_x17*in_x18*in_x22*in_x23+t2*t4*t13*t14*in_x10*in_x11*in_x26*in_x27-t2*t4*t13*t14*in_x11*in_x12*in_x25*in_x26-t3*t5*t6*t13*in_x16*in_x17*in_x23*in_x24+t3*t5*t6*t13*in_x17*in_x18*in_x22*in_x23+t3*t9*t10*t11*in_x16*in_x17*in_x20*in_x21-t3*t9*t10*t11*in_x17*in_x18*in_x19*in_x20-t2*t5*t13*t14*in_x10*in_x11*in_x26*in_x27+t2*t5*t13*t14*in_x11*in_x12*in_x25*in_x26-t3*t4*t6*t15*in_x16*in_x17*in_x23*in_x24+t3*t4*t6*t15*in_x17*in_x18*in_x22*in_x23-t2*t4*t14*t15*in_x10*in_x11*in_x26*in_x27+t2*t4*t14*t15*in_x11*in_x12*in_x25*in_x26+t2*t7*t8*t12*in_x13*in_x14*in_x26*in_x27-t2*t7*t8*t12*in_x14*in_x15*in_x25*in_x26+t3*t5*t6*t15*in_x16*in_x17*in_x23*in_x24-t3*t5*t6*t15*in_x17*in_x18*in_x22*in_x23+t2*t5*t14*t15*in_x10*in_x11*in_x26*in_x27-t2*t5*t14*t15*in_x11*in_x12*in_x25*in_x26-t2*t7*t11*t12*in_x13*in_x14*in_x26*in_x27+t2*t7*t11*t12*in_x14*in_x15*in_x25*in_x26-t2*t8*t10*t12*in_x13*in_x14*in_x26*in_x27+t2*t8*t10*t12*in_x14*in_x15*in_x25*in_x26+t3*t7*t9*t13*in_x16*in_x17*in_x23*in_x24-t3*t7*t9*t13*in_x17*in_x18*in_x22*in_x23-t3*t7*t9*t15*in_x16*in_x17*in_x23*in_x24+t3*t7*t9*t15*in_x17*in_x18*in_x22*in_x23+t2*t10*t11*t12*in_x13*in_x14*in_x26*in_x27-t2*t10*t11*t12*in_x14*in_x15*in_x25*in_x26-t3*t9*t10*t13*in_x16*in_x17*in_x23*in_x24+t3*t9*t10*t13*in_x17*in_x18*in_x22*in_x23+t2*t7*t13*t14*in_x13*in_x14*in_x26*in_x27-t2*t7*t13*t14*in_x14*in_x15*in_x25*in_x26-t4*t6*t8*t12*in_x16*in_x17*in_x26*in_x27+t4*t6*t8*t12*in_x17*in_x18*in_x25*in_x26+t3*t9*t10*t15*in_x16*in_x17*in_x23*in_x24-t3*t9*t10*t15*in_x17*in_x18*in_x22*in_x23+t5*t6*t8*t12*in_x16*in_x17*in_x26*in_x27-t5*t6*t8*t12*in_x17*in_x18*in_x25*in_x26-t2*t7*t14*t15*in_x13*in_x14*in_x26*in_x27+t2*t7*t14*t15*in_x14*in_x15*in_x25*in_x26-t2*t10*t13*t14*in_x13*in_x14*in_x26*in_x27+t2*t10*t13*t14*in_x14*in_x15*in_x25*in_x26+t4*t6*t11*t12*in_x16*in_x17*in_x26*in_x27-t4*t6*t11*t12*in_x17*in_x18*in_x25*in_x26-t5*t6*t11*t12*in_x16*in_x17*in_x26*in_x27+t5*t6*t11*t12*in_x17*in_x18*in_x25*in_x26+t2*t10*t14*t15*in_x13*in_x14*in_x26*in_x27-t2*t10*t14*t15*in_x14*in_x15*in_x25*in_x26-t7*t8*t9*t12*in_x16*in_x17*in_x26*in_x27+t7*t8*t9*t12*in_x17*in_x18*in_x25*in_x26-t4*t6*t13*t14*in_x16*in_x17*in_x26*in_x27+t4*t6*t13*t14*in_x17*in_x18*in_x25*in_x26+t5*t6*t13*t14*in_x16*in_x17*in_x26*in_x27-t5*t6*t13*t14*in_x17*in_x18*in_x25*in_x26+t4*t6*t14*t15*in_x16*in_x17*in_x26*in_x27-t4*t6*t14*t15*in_x17*in_x18*in_x25*in_x26+t7*t9*t11*t12*in_x16*in_x17*in_x26*in_x27-t7*t9*t11*t12*in_x17*in_x18*in_x25*in_x26+t8*t9*t10*t12*in_x16*in_x17*in_x26*in_x27-t8*t9*t10*t12*in_x17*in_x18*in_x25*in_x26-t5*t6*t14*t15*in_x16*in_x17*in_x26*in_x27+t5*t6*t14*t15*in_x17*in_x18*in_x25*in_x26-t9*t10*t11*t12*in_x16*in_x17*in_x26*in_x27+t9*t10*t11*t12*in_x17*in_x18*in_x25*in_x26-t7*t9*t13*t14*in_x16*in_x17*in_x26*in_x27+t7*t9*t13*t14*in_x17*in_x18*in_x25*in_x26+t7*t9*t14*t15*in_x16*in_x17*in_x26*in_x27-t7*t9*t14*t15*in_x17*in_x18*in_x25*in_x26+t9*t10*t13*t14*in_x16*in_x17*in_x26*in_x27-t9*t10*t13*t14*in_x17*in_x18*in_x25*in_x26-t9*t10*t14*t15*in_x16*in_x17*in_x26*in_x27+t9*t10*t14*t15*in_x17*in_x18*in_x25*in_x26-t2*t3*t4*in_x4*in_x5*in_x10*in_x11*in_x20*in_x24-t2*t3*t4*in_x4*in_x5*in_x10*in_x11*in_x21*in_x23+t2*t3*t4*in_x4*in_x5*in_x11*in_x12*in_x19*in_x23+t2*t3*t4*in_x4*in_x5*in_x11*in_x12*in_x20*in_x22-t2*t3*t8*in_x2*in_x3*in_x10*in_x14*in_x20*in_x21-t2*t3*t8*in_x2*in_x3*in_x11*in_x13*in_x20*in_x21+t2*t3*t8*in_x2*in_x3*in_x11*in_x15*in_x19*in_x20+t2*t3*t8*in_x2*in_x3*in_x12*in_x14*in_x19*in_x20+t2*t3*t5*in_x4*in_x5*in_x10*in_x11*in_x20*in_x24+t2*t3*t5*in_x4*in_x5*in_x10*in_x11*in_x21*in_x23-t2*t3*t5*in_x4*in_x5*in_x11*in_x12*in_x19*in_x23-t2*t3*t5*in_x4*in_x5*in_x11*in_x12*in_x20*in_x22+t2*t3*t11*in_x2*in_x3*in_x10*in_x14*in_x20*in_x21+t2*t3*t11*in_x2*in_x3*in_x11*in_x13*in_x20*in_x21-t2*t3*t11*in_x2*in_x3*in_x11*in_x15*in_x19*in_x20-t2*t3*t11*in_x2*in_x3*in_x12*in_x14*in_x19*in_x20+t2*t3*t4*in_x4*in_x9*in_x10*in_x11*in_x20*in_x24*2.0-t2*t3*t4*in_x4*in_x9*in_x10*in_x11*in_x21*in_x23*2.0+t2*t3*t4*in_x4*in_x9*in_x11*in_x12*in_x19*in_x23*2.0-t2*t3*t4*in_x4*in_x9*in_x11*in_x12*in_x20*in_x22*2.0-t2*t3*t4*in_x5*in_x8*in_x10*in_x11*in_x20*in_x24*2.0+t2*t3*t4*in_x5*in_x8*in_x10*in_x11*in_x21*in_x23*2.0-t2*t3*t4*in_x5*in_x8*in_x11*in_x12*in_x19*in_x23*2.0+t2*t3*t4*in_x5*in_x8*in_x11*in_x12*in_x20*in_x22*2.0-t2*t3*t8*in_x2*in_x7*in_x10*in_x14*in_x20*in_x21*2.0+t2*t3*t8*in_x2*in_x7*in_x11*in_x13*in_x20*in_x21*2.0-t2*t3*t8*in_x2*in_x7*in_x11*in_x15*in_x19*in_x20*2.0+t2*t3*t8*in_x2*in_x7*in_x12*in_x14*in_x19*in_x20*2.0+t2*t3*t8*in_x3*in_x6*in_x10*in_x14*in_x20*in_x21*2.0-t2*t3*t8*in_x3*in_x6*in_x11*in_x13*in_x20*in_x21*2.0+t2*t3*t8*in_x3*in_x6*in_x11*in_x15*in_x19*in_x20*2.0-t2*t3*t8*in_x3*in_x6*in_x12*in_x14*in_x19*in_x20*2.0-t2*t3*t5*in_x4*in_x9*in_x10*in_x11*in_x20*in_x24*2.0+t2*t3*t5*in_x4*in_x9*in_x10*in_x11*in_x21*in_x23*2.0-t2*t3*t5*in_x4*in_x9*in_x11*in_x12*in_x19*in_x23*2.0+t2*t3*t5*in_x4*in_x9*in_x11*in_x12*in_x20*in_x22*2.0+t2*t3*t5*in_x5*in_x8*in_x10*in_x11*in_x20*in_x24*2.0-t2*t3*t5*in_x5*in_x8*in_x10*in_x11*in_x21*in_x23*2.0+t2*t3*t5*in_x5*in_x8*in_x11*in_x12*in_x19*in_x23*2.0-t2*t3*t5*in_x5*in_x8*in_x11*in_x12*in_x20*in_x22*2.0+t2*t3*t11*in_x2*in_x7*in_x10*in_x14*in_x20*in_x21*2.0-t2*t3*t11*in_x2*in_x7*in_x11*in_x13*in_x20*in_x21*2.0+t2*t3*t11*in_x2*in_x7*in_x11*in_x15*in_x19*in_x20*2.0-t2*t3*t11*in_x2*in_x7*in_x12*in_x14*in_x19*in_x20*2.0-t2*t3*t11*in_x3*in_x6*in_x10*in_x14*in_x20*in_x21*2.0+t2*t3*t11*in_x3*in_x6*in_x11*in_x13*in_x20*in_x21*2.0-t2*t3*t11*in_x3*in_x6*in_x11*in_x15*in_x19*in_x20*2.0+t2*t3*t11*in_x3*in_x6*in_x12*in_x14*in_x19*in_x20*2.0+t2*t3*t4*in_x8*in_x9*in_x10*in_x11*in_x20*in_x24+t2*t3*t4*in_x8*in_x9*in_x10*in_x11*in_x21*in_x23-t2*t3*t4*in_x8*in_x9*in_x11*in_x12*in_x19*in_x23-t2*t3*t4*in_x8*in_x9*in_x11*in_x12*in_x20*in_x22+t2*t3*t8*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21+t2*t3*t8*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21-t2*t3*t8*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20-t2*t3*t8*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20-t2*t3*t5*in_x8*in_x9*in_x10*in_x11*in_x20*in_x24-t2*t3*t5*in_x8*in_x9*in_x10*in_x11*in_x21*in_x23+t2*t3*t5*in_x8*in_x9*in_x11*in_x12*in_x19*in_x23+t2*t3*t5*in_x8*in_x9*in_x11*in_x12*in_x20*in_x22-t2*t3*t7*in_x4*in_x5*in_x13*in_x14*in_x20*in_x24-t2*t3*t7*in_x4*in_x5*in_x13*in_x14*in_x21*in_x23+t2*t3*t7*in_x4*in_x5*in_x14*in_x15*in_x19*in_x23+t2*t3*t7*in_x4*in_x5*in_x14*in_x15*in_x20*in_x22-t2*t3*t11*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21-t2*t3*t11*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21+t2*t3*t11*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20+t2*t3*t11*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20-t2*t3*t13*in_x2*in_x3*in_x10*in_x14*in_x23*in_x24-t2*t3*t13*in_x2*in_x3*in_x11*in_x13*in_x23*in_x24+t2*t3*t13*in_x2*in_x3*in_x11*in_x15*in_x22*in_x23+t2*t3*t13*in_x2*in_x3*in_x12*in_x14*in_x22*in_x23-t3*t5*t6*in_x2*in_x4*in_x10*in_x17*in_x20*in_x27+t3*t5*t6*in_x2*in_x4*in_x10*in_x17*in_x21*in_x26+t3*t5*t6*in_x2*in_x4*in_x11*in_x16*in_x20*in_x27-t3*t5*t6*in_x2*in_x4*in_x11*in_x16*in_x21*in_x26+t3*t5*t6*in_x2*in_x4*in_x11*in_x18*in_x19*in_x26-t3*t5*t6*in_x2*in_x4*in_x11*in_x18*in_x20*in_x25-t3*t5*t6*in_x2*in_x4*in_x12*in_x17*in_x19*in_x26+t3*t5*t6*in_x2*in_x4*in_x12*in_x17*in_x20*in_x25+t2*t3*t10*in_x4*in_x5*in_x13*in_x14*in_x20*in_x24+t2*t3*t10*in_x4*in_x5*in_x13*in_x14*in_x21*in_x23-t2*t3*t10*in_x4*in_x5*in_x14*in_x15*in_x19*in_x23-t2*t3*t10*in_x4*in_x5*in_x14*in_x15*in_x20*in_x22+t2*t3*t7*in_x4*in_x9*in_x13*in_x14*in_x20*in_x24*2.0-t2*t3*t7*in_x4*in_x9*in_x13*in_x14*in_x21*in_x23*2.0+t2*t3*t7*in_x4*in_x9*in_x14*in_x15*in_x19*in_x23*2.0-t2*t3*t7*in_x4*in_x9*in_x14*in_x15*in_x20*in_x22*2.0-t2*t3*t7*in_x5*in_x8*in_x13*in_x14*in_x20*in_x24*2.0+t2*t3*t7*in_x5*in_x8*in_x13*in_x14*in_x21*in_x23*2.0-t2*t3*t7*in_x5*in_x8*in_x14*in_x15*in_x19*in_x23*2.0+t2*t3*t7*in_x5*in_x8*in_x14*in_x15*in_x20*in_x22*2.0+t2*t3*t15*in_x2*in_x3*in_x10*in_x14*in_x23*in_x24+t2*t3*t15*in_x2*in_x3*in_x11*in_x13*in_x23*in_x24-t2*t3*t15*in_x2*in_x3*in_x11*in_x15*in_x22*in_x23-t2*t3*t15*in_x2*in_x3*in_x12*in_x14*in_x22*in_x23+t3*t4*t6*in_x4*in_x6*in_x10*in_x17*in_x20*in_x27-t3*t4*t6*in_x4*in_x6*in_x10*in_x17*in_x21*in_x26-t3*t4*t6*in_x4*in_x6*in_x11*in_x16*in_x20*in_x27+t3*t4*t6*in_x4*in_x6*in_x11*in_x16*in_x21*in_x26-t3*t4*t6*in_x4*in_x6*in_x11*in_x18*in_x19*in_x26+t3*t4*t6*in_x4*in_x6*in_x11*in_x18*in_x20*in_x25+t3*t4*t6*in_x4*in_x6*in_x12*in_x17*in_x19*in_x26-t3*t4*t6*in_x4*in_x6*in_x12*in_x17*in_x20*in_x25-t2*t3*t13*in_x2*in_x7*in_x10*in_x14*in_x23*in_x24*2.0+t2*t3*t13*in_x2*in_x7*in_x11*in_x13*in_x23*in_x24*2.0-t2*t3*t13*in_x2*in_x7*in_x11*in_x15*in_x22*in_x23*2.0+t2*t3*t13*in_x2*in_x7*in_x12*in_x14*in_x22*in_x23*2.0+t2*t3*t13*in_x3*in_x6*in_x10*in_x14*in_x23*in_x24*2.0-t2*t3*t13*in_x3*in_x6*in_x11*in_x13*in_x23*in_x24*2.0+t2*t3*t13*in_x3*in_x6*in_x11*in_x15*in_x22*in_x23*2.0-t2*t3*t13*in_x3*in_x6*in_x12*in_x14*in_x22*in_x23*2.0-t3*t5*t6*in_x2*in_x5*in_x10*in_x17*in_x23*in_x27+t3*t5*t6*in_x2*in_x5*in_x10*in_x17*in_x24*in_x26+t3*t5*t6*in_x2*in_x5*in_x11*in_x16*in_x23*in_x27-t3*t5*t6*in_x2*in_x5*in_x11*in_x16*in_x24*in_x26+t3*t5*t6*in_x2*in_x5*in_x11*in_x18*in_x22*in_x26-t3*t5*t6*in_x2*in_x5*in_x11*in_x18*in_x23*in_x25-t3*t5*t6*in_x2*in_x5*in_x12*in_x17*in_x22*in_x26+t3*t5*t6*in_x2*in_x5*in_x12*in_x17*in_x23*in_x25+t3*t5*t6*in_x2*in_x8*in_x10*in_x17*in_x20*in_x27-t3*t5*t6*in_x2*in_x8*in_x10*in_x17*in_x21*in_x26-t3*t5*t6*in_x2*in_x8*in_x11*in_x16*in_x20*in_x27+t3*t5*t6*in_x2*in_x8*in_x11*in_x16*in_x21*in_x26-t3*t5*t6*in_x2*in_x8*in_x11*in_x18*in_x19*in_x26+t3*t5*t6*in_x2*in_x8*in_x11*in_x18*in_x20*in_x25+t3*t5*t6*in_x2*in_x8*in_x12*in_x17*in_x19*in_x26-t3*t5*t6*in_x2*in_x8*in_x12*in_x17*in_x20*in_x25+t3*t5*t6*in_x3*in_x4*in_x13*in_x17*in_x20*in_x27-t3*t5*t6*in_x3*in_x4*in_x13*in_x17*in_x21*in_x26+t3*t5*t6*in_x3*in_x4*in_x14*in_x16*in_x20*in_x27-t3*t5*t6*in_x3*in_x4*in_x14*in_x16*in_x21*in_x26+t3*t5*t6*in_x3*in_x4*in_x14*in_x18*in_x19*in_x26-t3*t5*t6*in_x3*in_x4*in_x14*in_x18*in_x20*in_x25+t3*t5*t6*in_x3*in_x4*in_x15*in_x17*in_x19*in_x26-t3*t5*t6*in_x3*in_x4*in_x15*in_x17*in_x20*in_x25-t2*t3*t10*in_x4*in_x9*in_x13*in_x14*in_x20*in_x24*2.0+t2*t3*t10*in_x4*in_x9*in_x13*in_x14*in_x21*in_x23*2.0-t2*t3*t10*in_x4*in_x9*in_x14*in_x15*in_x19*in_x23*2.0+t2*t3*t10*in_x4*in_x9*in_x14*in_x15*in_x20*in_x22*2.0+t2*t3*t10*in_x5*in_x8*in_x13*in_x14*in_x20*in_x24*2.0-t2*t3*t10*in_x5*in_x8*in_x13*in_x14*in_x21*in_x23*2.0+t2*t3*t10*in_x5*in_x8*in_x14*in_x15*in_x19*in_x23*2.0-t2*t3*t10*in_x5*in_x8*in_x14*in_x15*in_x20*in_x22*2.0+t3*t4*t6*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24+t3*t4*t6*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23-t3*t4*t6*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23-t3*t4*t6*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22+t2*t3*t7*in_x8*in_x9*in_x13*in_x14*in_x20*in_x24+t2*t3*t7*in_x8*in_x9*in_x13*in_x14*in_x21*in_x23-t2*t3*t7*in_x8*in_x9*in_x14*in_x15*in_x19*in_x23-t2*t3*t7*in_x8*in_x9*in_x14*in_x15*in_x20*in_x22+t2*t3*t15*in_x2*in_x7*in_x10*in_x14*in_x23*in_x24*2.0-t2*t3*t15*in_x2*in_x7*in_x11*in_x13*in_x23*in_x24*2.0+t2*t3*t15*in_x2*in_x7*in_x11*in_x15*in_x22*in_x23*2.0-t2*t3*t15*in_x2*in_x7*in_x12*in_x14*in_x22*in_x23*2.0-t2*t3*t15*in_x3*in_x6*in_x10*in_x14*in_x23*in_x24*2.0+t2*t3*t15*in_x3*in_x6*in_x11*in_x13*in_x23*in_x24*2.0-t2*t3*t15*in_x3*in_x6*in_x11*in_x15*in_x22*in_x23*2.0+t2*t3*t15*in_x3*in_x6*in_x12*in_x14*in_x22*in_x23*2.0-t3*t5*t6*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24-t3*t5*t6*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23+t3*t5*t6*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23+t3*t5*t6*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22-t3*t4*t6*in_x4*in_x7*in_x13*in_x17*in_x20*in_x27+t3*t4*t6*in_x4*in_x7*in_x13*in_x17*in_x21*in_x26-t3*t4*t6*in_x4*in_x7*in_x14*in_x16*in_x20*in_x27+t3*t4*t6*in_x4*in_x7*in_x14*in_x16*in_x21*in_x26-t3*t4*t6*in_x4*in_x7*in_x14*in_x18*in_x19*in_x26+t3*t4*t6*in_x4*in_x7*in_x14*in_x18*in_x20*in_x25-t3*t4*t6*in_x4*in_x7*in_x15*in_x17*in_x19*in_x26+t3*t4*t6*in_x4*in_x7*in_x15*in_x17*in_x20*in_x25+t3*t4*t6*in_x5*in_x6*in_x10*in_x17*in_x23*in_x27-t3*t4*t6*in_x5*in_x6*in_x10*in_x17*in_x24*in_x26-t3*t4*t6*in_x5*in_x6*in_x11*in_x16*in_x23*in_x27+t3*t4*t6*in_x5*in_x6*in_x11*in_x16*in_x24*in_x26-t3*t4*t6*in_x5*in_x6*in_x11*in_x18*in_x22*in_x26+t3*t4*t6*in_x5*in_x6*in_x11*in_x18*in_x23*in_x25+t3*t4*t6*in_x5*in_x6*in_x12*in_x17*in_x22*in_x26-t3*t4*t6*in_x5*in_x6*in_x12*in_x17*in_x23*in_x25-t3*t4*t6*in_x6*in_x8*in_x10*in_x17*in_x20*in_x27+t3*t4*t6*in_x6*in_x8*in_x10*in_x17*in_x21*in_x26+t3*t4*t6*in_x6*in_x8*in_x11*in_x16*in_x20*in_x27-t3*t4*t6*in_x6*in_x8*in_x11*in_x16*in_x21*in_x26+t3*t4*t6*in_x6*in_x8*in_x11*in_x18*in_x19*in_x26-t3*t4*t6*in_x6*in_x8*in_x11*in_x18*in_x20*in_x25-t3*t4*t6*in_x6*in_x8*in_x12*in_x17*in_x19*in_x26+t3*t4*t6*in_x6*in_x8*in_x12*in_x17*in_x20*in_x25+t2*t3*t13*in_x6*in_x7*in_x10*in_x14*in_x23*in_x24+t2*t3*t13*in_x6*in_x7*in_x11*in_x13*in_x23*in_x24-t2*t3*t13*in_x6*in_x7*in_x11*in_x15*in_x22*in_x23-t2*t3*t13*in_x6*in_x7*in_x12*in_x14*in_x22*in_x23+t3*t5*t6*in_x2*in_x9*in_x10*in_x17*in_x23*in_x27-t3*t5*t6*in_x2*in_x9*in_x10*in_x17*in_x24*in_x26-t3*t5*t6*in_x2*in_x9*in_x11*in_x16*in_x23*in_x27+t3*t5*t6*in_x2*in_x9*in_x11*in_x16*in_x24*in_x26-t3*t5*t6*in_x2*in_x9*in_x11*in_x18*in_x22*in_x26+t3*t5*t6*in_x2*in_x9*in_x11*in_x18*in_x23*in_x25+t3*t5*t6*in_x2*in_x9*in_x12*in_x17*in_x22*in_x26-t3*t5*t6*in_x2*in_x9*in_x12*in_x17*in_x23*in_x25+t3*t5*t6*in_x3*in_x5*in_x13*in_x17*in_x23*in_x27-t3*t5*t6*in_x3*in_x5*in_x13*in_x17*in_x24*in_x26+t3*t5*t6*in_x3*in_x5*in_x14*in_x16*in_x23*in_x27-t3*t5*t6*in_x3*in_x5*in_x14*in_x16*in_x24*in_x26+t3*t5*t6*in_x3*in_x5*in_x14*in_x18*in_x22*in_x26-t3*t5*t6*in_x3*in_x5*in_x14*in_x18*in_x23*in_x25+t3*t5*t6*in_x3*in_x5*in_x15*in_x17*in_x22*in_x26-t3*t5*t6*in_x3*in_x5*in_x15*in_x17*in_x23*in_x25-t3*t5*t6*in_x3*in_x8*in_x13*in_x17*in_x20*in_x27+t3*t5*t6*in_x3*in_x8*in_x13*in_x17*in_x21*in_x26-t3*t5*t6*in_x3*in_x8*in_x14*in_x16*in_x20*in_x27+t3*t5*t6*in_x3*in_x8*in_x14*in_x16*in_x21*in_x26-t3*t5*t6*in_x3*in_x8*in_x14*in_x18*in_x19*in_x26+t3*t5*t6*in_x3*in_x8*in_x14*in_x18*in_x20*in_x25-t3*t5*t6*in_x3*in_x8*in_x15*in_x17*in_x19*in_x26+t3*t5*t6*in_x3*in_x8*in_x15*in_x17*in_x20*in_x25+t3*t9*t10*in_x2*in_x4*in_x10*in_x17*in_x20*in_x27-t3*t9*t10*in_x2*in_x4*in_x10*in_x17*in_x21*in_x26+t3*t9*t10*in_x2*in_x4*in_x11*in_x16*in_x20*in_x27-t3*t9*t10*in_x2*in_x4*in_x11*in_x16*in_x21*in_x26+t3*t9*t10*in_x2*in_x4*in_x11*in_x18*in_x19*in_x26-t3*t9*t10*in_x2*in_x4*in_x11*in_x18*in_x20*in_x25+t3*t9*t10*in_x2*in_x4*in_x12*in_x17*in_x19*in_x26-t3*t9*t10*in_x2*in_x4*in_x12*in_x17*in_x20*in_x25-t2*t3*t10*in_x8*in_x9*in_x13*in_x14*in_x20*in_x24-t2*t3*t10*in_x8*in_x9*in_x13*in_x14*in_x21*in_x23+t2*t3*t10*in_x8*in_x9*in_x14*in_x15*in_x19*in_x23+t2*t3*t10*in_x8*in_x9*in_x14*in_x15*in_x20*in_x22-t3*t4*t6*in_x4*in_x9*in_x16*in_x17*in_x20*in_x24*2.0+t3*t4*t6*in_x4*in_x9*in_x16*in_x17*in_x21*in_x23*2.0-t3*t4*t6*in_x4*in_x9*in_x17*in_x18*in_x19*in_x23*2.0+t3*t4*t6*in_x4*in_x9*in_x17*in_x18*in_x20*in_x22*2.0+t3*t4*t6*in_x5*in_x8*in_x16*in_x17*in_x20*in_x24*2.0-t3*t4*t6*in_x5*in_x8*in_x16*in_x17*in_x21*in_x23*2.0+t3*t4*t6*in_x5*in_x8*in_x17*in_x18*in_x19*in_x23*2.0-t3*t4*t6*in_x5*in_x8*in_x17*in_x18*in_x20*in_x22*2.0-t3*t7*t9*in_x4*in_x6*in_x10*in_x17*in_x20*in_x27+t3*t7*t9*in_x4*in_x6*in_x10*in_x17*in_x21*in_x26-t3*t7*t9*in_x4*in_x6*in_x11*in_x16*in_x20*in_x27+t3*t7*t9*in_x4*in_x6*in_x11*in_x16*in_x21*in_x26-t3*t7*t9*in_x4*in_x6*in_x11*in_x18*in_x19*in_x26+t3*t7*t9*in_x4*in_x6*in_x11*in_x18*in_x20*in_x25-t3*t7*t9*in_x4*in_x6*in_x12*in_x17*in_x19*in_x26+t3*t7*t9*in_x4*in_x6*in_x12*in_x17*in_x20*in_x25-t2*t3*t15*in_x6*in_x7*in_x10*in_x14*in_x23*in_x24-t2*t3*t15*in_x6*in_x7*in_x11*in_x13*in_x23*in_x24+t2*t3*t15*in_x6*in_x7*in_x11*in_x15*in_x22*in_x23+t2*t3*t15*in_x6*in_x7*in_x12*in_x14*in_x22*in_x23+t2*t8*t12*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27+t2*t8*t12*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27-t2*t8*t12*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26-t2*t8*t12*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26+t3*t5*t6*in_x4*in_x9*in_x16*in_x17*in_x20*in_x24*2.0-t3*t5*t6*in_x4*in_x9*in_x16*in_x17*in_x21*in_x23*2.0+t3*t5*t6*in_x4*in_x9*in_x17*in_x18*in_x19*in_x23*2.0-t3*t5*t6*in_x4*in_x9*in_x17*in_x18*in_x20*in_x22*2.0-t3*t5*t6*in_x5*in_x8*in_x16*in_x17*in_x20*in_x24*2.0+t3*t5*t6*in_x5*in_x8*in_x16*in_x17*in_x21*in_x23*2.0-t3*t5*t6*in_x5*in_x8*in_x17*in_x18*in_x19*in_x23*2.0+t3*t5*t6*in_x5*in_x8*in_x17*in_x18*in_x20*in_x22*2.0-t2*t11*t12*in_x2*in_x4*in_x10*in_x17*in_x20*in_x27+t2*t11*t12*in_x2*in_x4*in_x10*in_x17*in_x21*in_x26+t2*t11*t12*in_x2*in_x4*in_x11*in_x16*in_x20*in_x27-t2*t11*t12*in_x2*in_x4*in_x11*in_x16*in_x21*in_x26+t2*t11*t12*in_x2*in_x4*in_x11*in_x18*in_x19*in_x26-t2*t11*t12*in_x2*in_x4*in_x11*in_x18*in_x20*in_x25-t2*t11*t12*in_x2*in_x4*in_x12*in_x17*in_x19*in_x26+t2*t11*t12*in_x2*in_x4*in_x12*in_x17*in_x20*in_x25-t3*t4*t6*in_x5*in_x7*in_x13*in_x17*in_x23*in_x27+t3*t4*t6*in_x5*in_x7*in_x13*in_x17*in_x24*in_x26-t3*t4*t6*in_x5*in_x7*in_x14*in_x16*in_x23*in_x27+t3*t4*t6*in_x5*in_x7*in_x14*in_x16*in_x24*in_x26-t3*t4*t6*in_x5*in_x7*in_x14*in_x18*in_x22*in_x26+t3*t4*t6*in_x5*in_x7*in_x14*in_x18*in_x23*in_x25-t3*t4*t6*in_x5*in_x7*in_x15*in_x17*in_x22*in_x26+t3*t4*t6*in_x5*in_x7*in_x15*in_x17*in_x23*in_x25-t3*t4*t6*in_x6*in_x9*in_x10*in_x17*in_x23*in_x27+t3*t4*t6*in_x6*in_x9*in_x10*in_x17*in_x24*in_x26+t3*t4*t6*in_x6*in_x9*in_x11*in_x16*in_x23*in_x27-t3*t4*t6*in_x6*in_x9*in_x11*in_x16*in_x24*in_x26+t3*t4*t6*in_x6*in_x9*in_x11*in_x18*in_x22*in_x26-t3*t4*t6*in_x6*in_x9*in_x11*in_x18*in_x23*in_x25-t3*t4*t6*in_x6*in_x9*in_x12*in_x17*in_x22*in_x26+t3*t4*t6*in_x6*in_x9*in_x12*in_x17*in_x23*in_x25+t3*t4*t6*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27-t3*t4*t6*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26+t3*t4*t6*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27-t3*t4*t6*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26+t3*t4*t6*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26-t3*t4*t6*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25+t3*t4*t6*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26-t3*t4*t6*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25+t3*t7*t9*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24+t3*t7*t9*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23-t3*t7*t9*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23-t3*t7*t9*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22+t2*t8*t12*in_x2*in_x8*in_x10*in_x17*in_x20*in_x27-t2*t8*t12*in_x2*in_x8*in_x10*in_x17*in_x21*in_x26-t2*t8*t12*in_x2*in_x8*in_x11*in_x16*in_x20*in_x27+t2*t8*t12*in_x2*in_x8*in_x11*in_x16*in_x21*in_x26-t2*t8*t12*in_x2*in_x8*in_x11*in_x18*in_x19*in_x26+t2*t8*t12*in_x2*in_x8*in_x11*in_x18*in_x20*in_x25+t2*t8*t12*in_x2*in_x8*in_x12*in_x17*in_x19*in_x26-t2*t8*t12*in_x2*in_x8*in_x12*in_x17*in_x20*in_x25-t3*t5*t6*in_x3*in_x9*in_x13*in_x17*in_x23*in_x27+t3*t5*t6*in_x3*in_x9*in_x13*in_x17*in_x24*in_x26-t3*t5*t6*in_x3*in_x9*in_x14*in_x16*in_x23*in_x27+t3*t5*t6*in_x3*in_x9*in_x14*in_x16*in_x24*in_x26-t3*t5*t6*in_x3*in_x9*in_x14*in_x18*in_x22*in_x26+t3*t5*t6*in_x3*in_x9*in_x14*in_x18*in_x23*in_x25-t3*t5*t6*in_x3*in_x9*in_x15*in_x17*in_x22*in_x26+t3*t5*t6*in_x3*in_x9*in_x15*in_x17*in_x23*in_x25+t3*t9*t10*in_x2*in_x5*in_x10*in_x17*in_x23*in_x27-t3*t9*t10*in_x2*in_x5*in_x10*in_x17*in_x24*in_x26+t3*t9*t10*in_x2*in_x5*in_x11*in_x16*in_x23*in_x27-t3*t9*t10*in_x2*in_x5*in_x11*in_x16*in_x24*in_x26+t3*t9*t10*in_x2*in_x5*in_x11*in_x18*in_x22*in_x26-t3*t9*t10*in_x2*in_x5*in_x11*in_x18*in_x23*in_x25+t3*t9*t10*in_x2*in_x5*in_x12*in_x17*in_x22*in_x26-t3*t9*t10*in_x2*in_x5*in_x12*in_x17*in_x23*in_x25-t3*t9*t10*in_x2*in_x8*in_x10*in_x17*in_x20*in_x27+t3*t9*t10*in_x2*in_x8*in_x10*in_x17*in_x21*in_x26-t3*t9*t10*in_x2*in_x8*in_x11*in_x16*in_x20*in_x27+t3*t9*t10*in_x2*in_x8*in_x11*in_x16*in_x21*in_x26-t3*t9*t10*in_x2*in_x8*in_x11*in_x18*in_x19*in_x26+t3*t9*t10*in_x2*in_x8*in_x11*in_x18*in_x20*in_x25-t3*t9*t10*in_x2*in_x8*in_x12*in_x17*in_x19*in_x26+t3*t9*t10*in_x2*in_x8*in_x12*in_x17*in_x20*in_x25-t3*t9*t10*in_x3*in_x4*in_x13*in_x17*in_x20*in_x27+t3*t9*t10*in_x3*in_x4*in_x13*in_x17*in_x21*in_x26+t3*t9*t10*in_x3*in_x4*in_x14*in_x16*in_x20*in_x27-t3*t9*t10*in_x3*in_x4*in_x14*in_x16*in_x21*in_x26+t3*t9*t10*in_x3*in_x4*in_x14*in_x18*in_x19*in_x26-t3*t9*t10*in_x3*in_x4*in_x14*in_x18*in_x20*in_x25-t3*t9*t10*in_x3*in_x4*in_x15*in_x17*in_x19*in_x26+t3*t9*t10*in_x3*in_x4*in_x15*in_x17*in_x20*in_x25-t2*t11*t12*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27-t2*t11*t12*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27+t2*t11*t12*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26+t2*t11*t12*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26-t3*t4*t6*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24-t3*t4*t6*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23+t3*t4*t6*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23+t3*t4*t6*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22+t3*t7*t9*in_x4*in_x7*in_x13*in_x17*in_x20*in_x27-t3*t7*t9*in_x4*in_x7*in_x13*in_x17*in_x21*in_x26-t3*t7*t9*in_x4*in_x7*in_x14*in_x16*in_x20*in_x27+t3*t7*t9*in_x4*in_x7*in_x14*in_x16*in_x21*in_x26-t3*t7*t9*in_x4*in_x7*in_x14*in_x18*in_x19*in_x26+t3*t7*t9*in_x4*in_x7*in_x14*in_x18*in_x20*in_x25+t3*t7*t9*in_x4*in_x7*in_x15*in_x17*in_x19*in_x26-t3*t7*t9*in_x4*in_x7*in_x15*in_x17*in_x20*in_x25-t3*t7*t9*in_x5*in_x6*in_x10*in_x17*in_x23*in_x27+t3*t7*t9*in_x5*in_x6*in_x10*in_x17*in_x24*in_x26-t3*t7*t9*in_x5*in_x6*in_x11*in_x16*in_x23*in_x27+t3*t7*t9*in_x5*in_x6*in_x11*in_x16*in_x24*in_x26-t3*t7*t9*in_x5*in_x6*in_x11*in_x18*in_x22*in_x26+t3*t7*t9*in_x5*in_x6*in_x11*in_x18*in_x23*in_x25-t3*t7*t9*in_x5*in_x6*in_x12*in_x17*in_x22*in_x26+t3*t7*t9*in_x5*in_x6*in_x12*in_x17*in_x23*in_x25+t3*t7*t9*in_x6*in_x8*in_x10*in_x17*in_x20*in_x27-t3*t7*t9*in_x6*in_x8*in_x10*in_x17*in_x21*in_x26+t3*t7*t9*in_x6*in_x8*in_x11*in_x16*in_x20*in_x27-t3*t7*t9*in_x6*in_x8*in_x11*in_x16*in_x21*in_x26+t3*t7*t9*in_x6*in_x8*in_x11*in_x18*in_x19*in_x26-t3*t7*t9*in_x6*in_x8*in_x11*in_x18*in_x20*in_x25+t3*t7*t9*in_x6*in_x8*in_x12*in_x17*in_x19*in_x26-t3*t7*t9*in_x6*in_x8*in_x12*in_x17*in_x20*in_x25+t2*t8*t12*in_x2*in_x7*in_x10*in_x14*in_x26*in_x27*2.0-t2*t8*t12*in_x2*in_x7*in_x11*in_x13*in_x26*in_x27*2.0+t2*t8*t12*in_x2*in_x7*in_x11*in_x15*in_x25*in_x26*2.0-t2*t8*t12*in_x2*in_x7*in_x12*in_x14*in_x25*in_x26*2.0-t2*t8*t12*in_x3*in_x6*in_x10*in_x14*in_x26*in_x27*2.0+t2*t8*t12*in_x3*in_x6*in_x11*in_x13*in_x26*in_x27*2.0-t2*t8*t12*in_x3*in_x6*in_x11*in_x15*in_x25*in_x26*2.0+t2*t8*t12*in_x3*in_x6*in_x12*in_x14*in_x25*in_x26*2.0+t3*t5*t6*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24+t3*t5*t6*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23-t3*t5*t6*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23-t3*t5*t6*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22-t3*t9*t10*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24-t3*t9*t10*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23+t3*t9*t10*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23+t3*t9*t10*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22-t2*t11*t12*in_x2*in_x5*in_x10*in_x17*in_x23*in_x27-t2*t11*t12*in_x2*in_x5*in_x10*in_x17*in_x24*in_x26+t2*t11*t12*in_x2*in_x5*in_x11*in_x16*in_x23*in_x27+t2*t11*t12*in_x2*in_x5*in_x11*in_x16*in_x24*in_x26-t2*t11*t12*in_x2*in_x5*in_x11*in_x18*in_x22*in_x26-t2*t11*t12*in_x2*in_x5*in_x11*in_x18*in_x23*in_x25+t2*t11*t12*in_x2*in_x5*in_x12*in_x17*in_x22*in_x26+t2*t11*t12*in_x2*in_x5*in_x12*in_x17*in_x23*in_x25-t2*t11*t12*in_x3*in_x4*in_x13*in_x17*in_x20*in_x27+t2*t11*t12*in_x3*in_x4*in_x13*in_x17*in_x21*in_x26+t2*t11*t12*in_x3*in_x4*in_x14*in_x16*in_x20*in_x27-t2*t11*t12*in_x3*in_x4*in_x14*in_x16*in_x21*in_x26+t2*t11*t12*in_x3*in_x4*in_x14*in_x18*in_x19*in_x26-t2*t11*t12*in_x3*in_x4*in_x14*in_x18*in_x20*in_x25-t2*t11*t12*in_x3*in_x4*in_x15*in_x17*in_x19*in_x26+t2*t11*t12*in_x3*in_x4*in_x15*in_x17*in_x20*in_x25+t2*t11*t12*in_x4*in_x6*in_x10*in_x17*in_x20*in_x27-t2*t11*t12*in_x4*in_x6*in_x10*in_x17*in_x21*in_x26-t2*t11*t12*in_x4*in_x6*in_x11*in_x16*in_x20*in_x27+t2*t11*t12*in_x4*in_x6*in_x11*in_x16*in_x21*in_x26-t2*t11*t12*in_x4*in_x6*in_x11*in_x18*in_x19*in_x26+t2*t11*t12*in_x4*in_x6*in_x11*in_x18*in_x20*in_x25+t2*t11*t12*in_x4*in_x6*in_x12*in_x17*in_x19*in_x26-t2*t11*t12*in_x4*in_x6*in_x12*in_x17*in_x20*in_x25+t3*t4*t6*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27-t3*t4*t6*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26+t3*t4*t6*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27-t3*t4*t6*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26+t3*t4*t6*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26-t3*t4*t6*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25+t3*t4*t6*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26-t3*t4*t6*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25-t3*t7*t9*in_x4*in_x9*in_x16*in_x17*in_x20*in_x24*2.0+t3*t7*t9*in_x4*in_x9*in_x16*in_x17*in_x21*in_x23*2.0-t3*t7*t9*in_x4*in_x9*in_x17*in_x18*in_x19*in_x23*2.0+t3*t7*t9*in_x4*in_x9*in_x17*in_x18*in_x20*in_x22*2.0+t3*t7*t9*in_x5*in_x8*in_x16*in_x17*in_x20*in_x24*2.0-t3*t7*t9*in_x5*in_x8*in_x16*in_x17*in_x21*in_x23*2.0+t3*t7*t9*in_x5*in_x8*in_x17*in_x18*in_x19*in_x23*2.0-t3*t7*t9*in_x5*in_x8*in_x17*in_x18*in_x20*in_x22*2.0+t2*t8*t12*in_x2*in_x9*in_x10*in_x17*in_x23*in_x27+t2*t8*t12*in_x2*in_x9*in_x10*in_x17*in_x24*in_x26-t2*t8*t12*in_x2*in_x9*in_x11*in_x16*in_x23*in_x27-t2*t8*t12*in_x2*in_x9*in_x11*in_x16*in_x24*in_x26+t2*t8*t12*in_x2*in_x9*in_x11*in_x18*in_x22*in_x26+t2*t8*t12*in_x2*in_x9*in_x11*in_x18*in_x23*in_x25-t2*t8*t12*in_x2*in_x9*in_x12*in_x17*in_x22*in_x26-t2*t8*t12*in_x2*in_x9*in_x12*in_x17*in_x23*in_x25+t2*t8*t12*in_x3*in_x8*in_x13*in_x17*in_x20*in_x27-t2*t8*t12*in_x3*in_x8*in_x13*in_x17*in_x21*in_x26-t2*t8*t12*in_x3*in_x8*in_x14*in_x16*in_x20*in_x27+t2*t8*t12*in_x3*in_x8*in_x14*in_x16*in_x21*in_x26-t2*t8*t12*in_x3*in_x8*in_x14*in_x18*in_x19*in_x26+t2*t8*t12*in_x3*in_x8*in_x14*in_x18*in_x20*in_x25+t2*t8*t12*in_x3*in_x8*in_x15*in_x17*in_x19*in_x26-t2*t8*t12*in_x3*in_x8*in_x15*in_x17*in_x20*in_x25-t2*t8*t12*in_x6*in_x8*in_x10*in_x17*in_x20*in_x27+t2*t8*t12*in_x6*in_x8*in_x10*in_x17*in_x21*in_x26+t2*t8*t12*in_x6*in_x8*in_x11*in_x16*in_x20*in_x27-t2*t8*t12*in_x6*in_x8*in_x11*in_x16*in_x21*in_x26+t2*t8*t12*in_x6*in_x8*in_x11*in_x18*in_x19*in_x26-t2*t8*t12*in_x6*in_x8*in_x11*in_x18*in_x20*in_x25-t2*t8*t12*in_x6*in_x8*in_x12*in_x17*in_x19*in_x26+t2*t8*t12*in_x6*in_x8*in_x12*in_x17*in_x20*in_x25-t3*t9*t10*in_x2*in_x9*in_x10*in_x17*in_x23*in_x27+t3*t9*t10*in_x2*in_x9*in_x10*in_x17*in_x24*in_x26-t3*t9*t10*in_x2*in_x9*in_x11*in_x16*in_x23*in_x27+t3*t9*t10*in_x2*in_x9*in_x11*in_x16*in_x24*in_x26-t3*t9*t10*in_x2*in_x9*in_x11*in_x18*in_x22*in_x26+t3*t9*t10*in_x2*in_x9*in_x11*in_x18*in_x23*in_x25-t3*t9*t10*in_x2*in_x9*in_x12*in_x17*in_x22*in_x26+t3*t9*t10*in_x2*in_x9*in_x12*in_x17*in_x23*in_x25-t3*t9*t10*in_x3*in_x5*in_x13*in_x17*in_x23*in_x27+t3*t9*t10*in_x3*in_x5*in_x13*in_x17*in_x24*in_x26+t3*t9*t10*in_x3*in_x5*in_x14*in_x16*in_x23*in_x27-t3*t9*t10*in_x3*in_x5*in_x14*in_x16*in_x24*in_x26+t3*t9*t10*in_x3*in_x5*in_x14*in_x18*in_x22*in_x26-t3*t9*t10*in_x3*in_x5*in_x14*in_x18*in_x23*in_x25-t3*t9*t10*in_x3*in_x5*in_x15*in_x17*in_x22*in_x26+t3*t9*t10*in_x3*in_x5*in_x15*in_x17*in_x23*in_x25+t3*t9*t10*in_x3*in_x8*in_x13*in_x17*in_x20*in_x27-t3*t9*t10*in_x3*in_x8*in_x13*in_x17*in_x21*in_x26-t3*t9*t10*in_x3*in_x8*in_x14*in_x16*in_x20*in_x27+t3*t9*t10*in_x3*in_x8*in_x14*in_x16*in_x21*in_x26-t3*t9*t10*in_x3*in_x8*in_x14*in_x18*in_x19*in_x26+t3*t9*t10*in_x3*in_x8*in_x14*in_x18*in_x20*in_x25+t3*t9*t10*in_x3*in_x8*in_x15*in_x17*in_x19*in_x26-t3*t9*t10*in_x3*in_x8*in_x15*in_x17*in_x20*in_x25-t2*t11*t12*in_x2*in_x7*in_x10*in_x14*in_x26*in_x27*2.0+t2*t11*t12*in_x2*in_x7*in_x11*in_x13*in_x26*in_x27*2.0-t2*t11*t12*in_x2*in_x7*in_x11*in_x15*in_x25*in_x26*2.0+t2*t11*t12*in_x2*in_x7*in_x12*in_x14*in_x25*in_x26*2.0+t2*t11*t12*in_x3*in_x6*in_x10*in_x14*in_x26*in_x27*2.0-t2*t11*t12*in_x3*in_x6*in_x11*in_x13*in_x26*in_x27*2.0+t2*t11*t12*in_x3*in_x6*in_x11*in_x15*in_x25*in_x26*2.0-t2*t11*t12*in_x3*in_x6*in_x12*in_x14*in_x25*in_x26*2.0+t2*t13*t14*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27+t2*t13*t14*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27-t2*t13*t14*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26-t2*t13*t14*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26-t2*t14*t15*in_x2*in_x4*in_x10*in_x17*in_x20*in_x27-t2*t14*t15*in_x2*in_x4*in_x10*in_x17*in_x21*in_x26+t2*t14*t15*in_x2*in_x4*in_x11*in_x16*in_x20*in_x27+t2*t14*t15*in_x2*in_x4*in_x11*in_x16*in_x21*in_x26-t2*t14*t15*in_x2*in_x4*in_x11*in_x18*in_x19*in_x26-t2*t14*t15*in_x2*in_x4*in_x11*in_x18*in_x20*in_x25+t2*t14*t15*in_x2*in_x4*in_x12*in_x17*in_x19*in_x26+t2*t14*t15*in_x2*in_x4*in_x12*in_x17*in_x20*in_x25+t3*t7*t9*in_x5*in_x7*in_x13*in_x17*in_x23*in_x27-t3*t7*t9*in_x5*in_x7*in_x13*in_x17*in_x24*in_x26-t3*t7*t9*in_x5*in_x7*in_x14*in_x16*in_x23*in_x27+t3*t7*t9*in_x5*in_x7*in_x14*in_x16*in_x24*in_x26-t3*t7*t9*in_x5*in_x7*in_x14*in_x18*in_x22*in_x26+t3*t7*t9*in_x5*in_x7*in_x14*in_x18*in_x23*in_x25+t3*t7*t9*in_x5*in_x7*in_x15*in_x17*in_x22*in_x26-t3*t7*t9*in_x5*in_x7*in_x15*in_x17*in_x23*in_x25+t3*t7*t9*in_x6*in_x9*in_x10*in_x17*in_x23*in_x27-t3*t7*t9*in_x6*in_x9*in_x10*in_x17*in_x24*in_x26+t3*t7*t9*in_x6*in_x9*in_x11*in_x16*in_x23*in_x27-t3*t7*t9*in_x6*in_x9*in_x11*in_x16*in_x24*in_x26+t3*t7*t9*in_x6*in_x9*in_x11*in_x18*in_x22*in_x26-t3*t7*t9*in_x6*in_x9*in_x11*in_x18*in_x23*in_x25+t3*t7*t9*in_x6*in_x9*in_x12*in_x17*in_x22*in_x26-t3*t7*t9*in_x6*in_x9*in_x12*in_x17*in_x23*in_x25-t3*t7*t9*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27+t3*t7*t9*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26+t3*t7*t9*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27-t3*t7*t9*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26+t3*t7*t9*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26-t3*t7*t9*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25-t3*t7*t9*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26+t3*t7*t9*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25-t2*t8*t12*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27-t2*t8*t12*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27+t2*t8*t12*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26+t2*t8*t12*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26+t3*t9*t10*in_x4*in_x9*in_x16*in_x17*in_x20*in_x24*2.0-t3*t9*t10*in_x4*in_x9*in_x16*in_x17*in_x21*in_x23*2.0+t3*t9*t10*in_x4*in_x9*in_x17*in_x18*in_x19*in_x23*2.0-t3*t9*t10*in_x4*in_x9*in_x17*in_x18*in_x20*in_x22*2.0-t3*t9*t10*in_x5*in_x8*in_x16*in_x17*in_x20*in_x24*2.0+t3*t9*t10*in_x5*in_x8*in_x16*in_x17*in_x21*in_x23*2.0-t3*t9*t10*in_x5*in_x8*in_x17*in_x18*in_x19*in_x23*2.0+t3*t9*t10*in_x5*in_x8*in_x17*in_x18*in_x20*in_x22*2.0-t2*t11*t12*in_x3*in_x5*in_x13*in_x17*in_x23*in_x27-t2*t11*t12*in_x3*in_x5*in_x13*in_x17*in_x24*in_x26+t2*t11*t12*in_x3*in_x5*in_x14*in_x16*in_x23*in_x27+t2*t11*t12*in_x3*in_x5*in_x14*in_x16*in_x24*in_x26-t2*t11*t12*in_x3*in_x5*in_x14*in_x18*in_x22*in_x26-t2*t11*t12*in_x3*in_x5*in_x14*in_x18*in_x23*in_x25+t2*t11*t12*in_x3*in_x5*in_x15*in_x17*in_x22*in_x26+t2*t11*t12*in_x3*in_x5*in_x15*in_x17*in_x23*in_x25+t2*t11*t12*in_x4*in_x7*in_x13*in_x17*in_x20*in_x27-t2*t11*t12*in_x4*in_x7*in_x13*in_x17*in_x21*in_x26-t2*t11*t12*in_x4*in_x7*in_x14*in_x16*in_x20*in_x27+t2*t11*t12*in_x4*in_x7*in_x14*in_x16*in_x21*in_x26-t2*t11*t12*in_x4*in_x7*in_x14*in_x18*in_x19*in_x26+t2*t11*t12*in_x4*in_x7*in_x14*in_x18*in_x20*in_x25+t2*t11*t12*in_x4*in_x7*in_x15*in_x17*in_x19*in_x26-t2*t11*t12*in_x4*in_x7*in_x15*in_x17*in_x20*in_x25+t2*t11*t12*in_x5*in_x6*in_x10*in_x17*in_x23*in_x27+t2*t11*t12*in_x5*in_x6*in_x10*in_x17*in_x24*in_x26-t2*t11*t12*in_x5*in_x6*in_x11*in_x16*in_x23*in_x27-t2*t11*t12*in_x5*in_x6*in_x11*in_x16*in_x24*in_x26+t2*t11*t12*in_x5*in_x6*in_x11*in_x18*in_x22*in_x26+t2*t11*t12*in_x5*in_x6*in_x11*in_x18*in_x23*in_x25-t2*t11*t12*in_x5*in_x6*in_x12*in_x17*in_x22*in_x26-t2*t11*t12*in_x5*in_x6*in_x12*in_x17*in_x23*in_x25+t2*t13*t14*in_x2*in_x8*in_x10*in_x17*in_x20*in_x27+t2*t13*t14*in_x2*in_x8*in_x10*in_x17*in_x21*in_x26-t2*t13*t14*in_x2*in_x8*in_x11*in_x16*in_x20*in_x27-t2*t13*t14*in_x2*in_x8*in_x11*in_x16*in_x21*in_x26+t2*t13*t14*in_x2*in_x8*in_x11*in_x18*in_x19*in_x26+t2*t13*t14*in_x2*in_x8*in_x11*in_x18*in_x20*in_x25-t2*t13*t14*in_x2*in_x8*in_x12*in_x17*in_x19*in_x26-t2*t13*t14*in_x2*in_x8*in_x12*in_x17*in_x20*in_x25-t2*t14*t15*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27-t2*t14*t15*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27+t2*t14*t15*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26+t2*t14*t15*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26-t3*t7*t9*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24-t3*t7*t9*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23+t3*t7*t9*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23+t3*t7*t9*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22+t2*t8*t12*in_x3*in_x9*in_x13*in_x17*in_x23*in_x27+t2*t8*t12*in_x3*in_x9*in_x13*in_x17*in_x24*in_x26-t2*t8*t12*in_x3*in_x9*in_x14*in_x16*in_x23*in_x27-t2*t8*t12*in_x3*in_x9*in_x14*in_x16*in_x24*in_x26+t2*t8*t12*in_x3*in_x9*in_x14*in_x18*in_x22*in_x26+t2*t8*t12*in_x3*in_x9*in_x14*in_x18*in_x23*in_x25-t2*t8*t12*in_x3*in_x9*in_x15*in_x17*in_x22*in_x26-t2*t8*t12*in_x3*in_x9*in_x15*in_x17*in_x23*in_x25-t2*t8*t12*in_x6*in_x9*in_x10*in_x17*in_x23*in_x27-t2*t8*t12*in_x6*in_x9*in_x10*in_x17*in_x24*in_x26+t2*t8*t12*in_x6*in_x9*in_x11*in_x16*in_x23*in_x27+t2*t8*t12*in_x6*in_x9*in_x11*in_x16*in_x24*in_x26-t2*t8*t12*in_x6*in_x9*in_x11*in_x18*in_x22*in_x26-t2*t8*t12*in_x6*in_x9*in_x11*in_x18*in_x23*in_x25+t2*t8*t12*in_x6*in_x9*in_x12*in_x17*in_x22*in_x26+t2*t8*t12*in_x6*in_x9*in_x12*in_x17*in_x23*in_x25-t2*t8*t12*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27+t2*t8*t12*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26+t2*t8*t12*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27-t2*t8*t12*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26+t2*t8*t12*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26-t2*t8*t12*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25-t2*t8*t12*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26+t2*t8*t12*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25+t3*t9*t10*in_x3*in_x9*in_x13*in_x17*in_x23*in_x27-t3*t9*t10*in_x3*in_x9*in_x13*in_x17*in_x24*in_x26-t3*t9*t10*in_x3*in_x9*in_x14*in_x16*in_x23*in_x27+t3*t9*t10*in_x3*in_x9*in_x14*in_x16*in_x24*in_x26-t3*t9*t10*in_x3*in_x9*in_x14*in_x18*in_x22*in_x26+t3*t9*t10*in_x3*in_x9*in_x14*in_x18*in_x23*in_x25+t3*t9*t10*in_x3*in_x9*in_x15*in_x17*in_x22*in_x26-t3*t9*t10*in_x3*in_x9*in_x15*in_x17*in_x23*in_x25+t2*t11*t12*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27+t2*t11*t12*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27-t2*t11*t12*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26-t2*t11*t12*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26+t2*t13*t14*in_x2*in_x7*in_x10*in_x14*in_x26*in_x27*2.0-t2*t13*t14*in_x2*in_x7*in_x11*in_x13*in_x26*in_x27*2.0+t2*t13*t14*in_x2*in_x7*in_x11*in_x15*in_x25*in_x26*2.0-t2*t13*t14*in_x2*in_x7*in_x12*in_x14*in_x25*in_x26*2.0-t2*t13*t14*in_x3*in_x6*in_x10*in_x14*in_x26*in_x27*2.0+t2*t13*t14*in_x3*in_x6*in_x11*in_x13*in_x26*in_x27*2.0-t2*t13*t14*in_x3*in_x6*in_x11*in_x15*in_x25*in_x26*2.0+t2*t13*t14*in_x3*in_x6*in_x12*in_x14*in_x25*in_x26*2.0-t2*t14*t15*in_x2*in_x5*in_x10*in_x17*in_x23*in_x27+t2*t14*t15*in_x2*in_x5*in_x10*in_x17*in_x24*in_x26+t2*t14*t15*in_x2*in_x5*in_x11*in_x16*in_x23*in_x27-t2*t14*t15*in_x2*in_x5*in_x11*in_x16*in_x24*in_x26+t2*t14*t15*in_x2*in_x5*in_x11*in_x18*in_x22*in_x26-t2*t14*t15*in_x2*in_x5*in_x11*in_x18*in_x23*in_x25-t2*t14*t15*in_x2*in_x5*in_x12*in_x17*in_x22*in_x26+t2*t14*t15*in_x2*in_x5*in_x12*in_x17*in_x23*in_x25-t2*t14*t15*in_x3*in_x4*in_x13*in_x17*in_x20*in_x27-t2*t14*t15*in_x3*in_x4*in_x13*in_x17*in_x21*in_x26+t2*t14*t15*in_x3*in_x4*in_x14*in_x16*in_x20*in_x27+t2*t14*t15*in_x3*in_x4*in_x14*in_x16*in_x21*in_x26-t2*t14*t15*in_x3*in_x4*in_x14*in_x18*in_x19*in_x26-t2*t14*t15*in_x3*in_x4*in_x14*in_x18*in_x20*in_x25+t2*t14*t15*in_x3*in_x4*in_x15*in_x17*in_x19*in_x26+t2*t14*t15*in_x3*in_x4*in_x15*in_x17*in_x20*in_x25+t2*t14*t15*in_x4*in_x6*in_x10*in_x17*in_x20*in_x27+t2*t14*t15*in_x4*in_x6*in_x10*in_x17*in_x21*in_x26-t2*t14*t15*in_x4*in_x6*in_x11*in_x16*in_x20*in_x27-t2*t14*t15*in_x4*in_x6*in_x11*in_x16*in_x21*in_x26+t2*t14*t15*in_x4*in_x6*in_x11*in_x18*in_x19*in_x26+t2*t14*t15*in_x4*in_x6*in_x11*in_x18*in_x20*in_x25-t2*t14*t15*in_x4*in_x6*in_x12*in_x17*in_x19*in_x26-t2*t14*t15*in_x4*in_x6*in_x12*in_x17*in_x20*in_x25-t3*t7*t9*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27+t3*t7*t9*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26+t3*t7*t9*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27-t3*t7*t9*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26+t3*t7*t9*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26-t3*t7*t9*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25-t3*t7*t9*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26+t3*t7*t9*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25+t3*t9*t10*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24+t3*t9*t10*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23-t3*t9*t10*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23-t3*t9*t10*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22+t2*t11*t12*in_x5*in_x7*in_x13*in_x17*in_x23*in_x27+t2*t11*t12*in_x5*in_x7*in_x13*in_x17*in_x24*in_x26-t2*t11*t12*in_x5*in_x7*in_x14*in_x16*in_x23*in_x27-t2*t11*t12*in_x5*in_x7*in_x14*in_x16*in_x24*in_x26+t2*t11*t12*in_x5*in_x7*in_x14*in_x18*in_x22*in_x26+t2*t11*t12*in_x5*in_x7*in_x14*in_x18*in_x23*in_x25-t2*t11*t12*in_x5*in_x7*in_x15*in_x17*in_x22*in_x26-t2*t11*t12*in_x5*in_x7*in_x15*in_x17*in_x23*in_x25+t2*t13*t14*in_x2*in_x9*in_x10*in_x17*in_x23*in_x27-t2*t13*t14*in_x2*in_x9*in_x10*in_x17*in_x24*in_x26-t2*t13*t14*in_x2*in_x9*in_x11*in_x16*in_x23*in_x27+t2*t13*t14*in_x2*in_x9*in_x11*in_x16*in_x24*in_x26-t2*t13*t14*in_x2*in_x9*in_x11*in_x18*in_x22*in_x26+t2*t13*t14*in_x2*in_x9*in_x11*in_x18*in_x23*in_x25+t2*t13*t14*in_x2*in_x9*in_x12*in_x17*in_x22*in_x26-t2*t13*t14*in_x2*in_x9*in_x12*in_x17*in_x23*in_x25+t2*t13*t14*in_x3*in_x8*in_x13*in_x17*in_x20*in_x27+t2*t13*t14*in_x3*in_x8*in_x13*in_x17*in_x21*in_x26-t2*t13*t14*in_x3*in_x8*in_x14*in_x16*in_x20*in_x27-t2*t13*t14*in_x3*in_x8*in_x14*in_x16*in_x21*in_x26+t2*t13*t14*in_x3*in_x8*in_x14*in_x18*in_x19*in_x26+t2*t13*t14*in_x3*in_x8*in_x14*in_x18*in_x20*in_x25-t2*t13*t14*in_x3*in_x8*in_x15*in_x17*in_x19*in_x26-t2*t13*t14*in_x3*in_x8*in_x15*in_x17*in_x20*in_x25-t2*t13*t14*in_x6*in_x8*in_x10*in_x17*in_x20*in_x27-t2*t13*t14*in_x6*in_x8*in_x10*in_x17*in_x21*in_x26+t2*t13*t14*in_x6*in_x8*in_x11*in_x16*in_x20*in_x27+t2*t13*t14*in_x6*in_x8*in_x11*in_x16*in_x21*in_x26-t2*t13*t14*in_x6*in_x8*in_x11*in_x18*in_x19*in_x26-t2*t13*t14*in_x6*in_x8*in_x11*in_x18*in_x20*in_x25+t2*t13*t14*in_x6*in_x8*in_x12*in_x17*in_x19*in_x26+t2*t13*t14*in_x6*in_x8*in_x12*in_x17*in_x20*in_x25-t2*t14*t15*in_x2*in_x7*in_x10*in_x14*in_x26*in_x27*2.0+t2*t14*t15*in_x2*in_x7*in_x11*in_x13*in_x26*in_x27*2.0-t2*t14*t15*in_x2*in_x7*in_x11*in_x15*in_x25*in_x26*2.0+t2*t14*t15*in_x2*in_x7*in_x12*in_x14*in_x25*in_x26*2.0+t2*t14*t15*in_x3*in_x6*in_x10*in_x14*in_x26*in_x27*2.0-t2*t14*t15*in_x3*in_x6*in_x11*in_x13*in_x26*in_x27*2.0+t2*t14*t15*in_x3*in_x6*in_x11*in_x15*in_x25*in_x26*2.0-t2*t14*t15*in_x3*in_x6*in_x12*in_x14*in_x25*in_x26*2.0-t2*t8*t12*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27-t2*t8*t12*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26+t2*t8*t12*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27+t2*t8*t12*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26-t2*t8*t12*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26-t2*t8*t12*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25+t2*t8*t12*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26+t2*t8*t12*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25-t2*t13*t14*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27-t2*t13*t14*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27+t2*t13*t14*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26+t2*t13*t14*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26-t2*t14*t15*in_x3*in_x5*in_x13*in_x17*in_x23*in_x27+t2*t14*t15*in_x3*in_x5*in_x13*in_x17*in_x24*in_x26+t2*t14*t15*in_x3*in_x5*in_x14*in_x16*in_x23*in_x27-t2*t14*t15*in_x3*in_x5*in_x14*in_x16*in_x24*in_x26+t2*t14*t15*in_x3*in_x5*in_x14*in_x18*in_x22*in_x26-t2*t14*t15*in_x3*in_x5*in_x14*in_x18*in_x23*in_x25-t2*t14*t15*in_x3*in_x5*in_x15*in_x17*in_x22*in_x26+t2*t14*t15*in_x3*in_x5*in_x15*in_x17*in_x23*in_x25+t2*t14*t15*in_x4*in_x7*in_x13*in_x17*in_x20*in_x27+t2*t14*t15*in_x4*in_x7*in_x13*in_x17*in_x21*in_x26-t2*t14*t15*in_x4*in_x7*in_x14*in_x16*in_x20*in_x27-t2*t14*t15*in_x4*in_x7*in_x14*in_x16*in_x21*in_x26+t2*t14*t15*in_x4*in_x7*in_x14*in_x18*in_x19*in_x26+t2*t14*t15*in_x4*in_x7*in_x14*in_x18*in_x20*in_x25-t2*t14*t15*in_x4*in_x7*in_x15*in_x17*in_x19*in_x26-t2*t14*t15*in_x4*in_x7*in_x15*in_x17*in_x20*in_x25+t2*t14*t15*in_x5*in_x6*in_x10*in_x17*in_x23*in_x27-t2*t14*t15*in_x5*in_x6*in_x10*in_x17*in_x24*in_x26-t2*t14*t15*in_x5*in_x6*in_x11*in_x16*in_x23*in_x27+t2*t14*t15*in_x5*in_x6*in_x11*in_x16*in_x24*in_x26-t2*t14*t15*in_x5*in_x6*in_x11*in_x18*in_x22*in_x26+t2*t14*t15*in_x5*in_x6*in_x11*in_x18*in_x23*in_x25+t2*t14*t15*in_x5*in_x6*in_x12*in_x17*in_x22*in_x26-t2*t14*t15*in_x5*in_x6*in_x12*in_x17*in_x23*in_x25+t2*t13*t14*in_x3*in_x9*in_x13*in_x17*in_x23*in_x27-t2*t13*t14*in_x3*in_x9*in_x13*in_x17*in_x24*in_x26-t2*t13*t14*in_x3*in_x9*in_x14*in_x16*in_x23*in_x27+t2*t13*t14*in_x3*in_x9*in_x14*in_x16*in_x24*in_x26-t2*t13*t14*in_x3*in_x9*in_x14*in_x18*in_x22*in_x26+t2*t13*t14*in_x3*in_x9*in_x14*in_x18*in_x23*in_x25+t2*t13*t14*in_x3*in_x9*in_x15*in_x17*in_x22*in_x26-t2*t13*t14*in_x3*in_x9*in_x15*in_x17*in_x23*in_x25-t2*t13*t14*in_x6*in_x9*in_x10*in_x17*in_x23*in_x27+t2*t13*t14*in_x6*in_x9*in_x10*in_x17*in_x24*in_x26+t2*t13*t14*in_x6*in_x9*in_x11*in_x16*in_x23*in_x27-t2*t13*t14*in_x6*in_x9*in_x11*in_x16*in_x24*in_x26+t2*t13*t14*in_x6*in_x9*in_x11*in_x18*in_x22*in_x26-t2*t13*t14*in_x6*in_x9*in_x11*in_x18*in_x23*in_x25-t2*t13*t14*in_x6*in_x9*in_x12*in_x17*in_x22*in_x26+t2*t13*t14*in_x6*in_x9*in_x12*in_x17*in_x23*in_x25-t2*t13*t14*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27-t2*t13*t14*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26+t2*t13*t14*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27+t2*t13*t14*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26-t2*t13*t14*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26-t2*t13*t14*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25+t2*t13*t14*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26+t2*t13*t14*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25+t2*t14*t15*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27+t2*t14*t15*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27-t2*t14*t15*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26-t2*t14*t15*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26+t2*t14*t15*in_x5*in_x7*in_x13*in_x17*in_x23*in_x27-t2*t14*t15*in_x5*in_x7*in_x13*in_x17*in_x24*in_x26-t2*t14*t15*in_x5*in_x7*in_x14*in_x16*in_x23*in_x27+t2*t14*t15*in_x5*in_x7*in_x14*in_x16*in_x24*in_x26-t2*t14*t15*in_x5*in_x7*in_x14*in_x18*in_x22*in_x26+t2*t14*t15*in_x5*in_x7*in_x14*in_x18*in_x23*in_x25+t2*t14*t15*in_x5*in_x7*in_x15*in_x17*in_x22*in_x26-t2*t14*t15*in_x5*in_x7*in_x15*in_x17*in_x23*in_x25-t2*t13*t14*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27+t2*t13*t14*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26+t2*t13*t14*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27-t2*t13*t14*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26+t2*t13*t14*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26-t2*t13*t14*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25-t2*t13*t14*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26+t2*t13*t14*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25-t2*t3*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x20*in_x24-t2*t3*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x21*in_x23-t2*t3*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x20*in_x24-t2*t3*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x21*in_x23+t2*t3*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x19*in_x23+t2*t3*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x20*in_x22+t2*t3*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x19*in_x23+t2*t3*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x20*in_x22+t2*t3*in_x2*in_x3*in_x4*in_x9*in_x10*in_x14*in_x20*in_x24*2.0-t2*t3*in_x2*in_x3*in_x4*in_x9*in_x10*in_x14*in_x21*in_x23*2.0+t2*t3*in_x2*in_x3*in_x4*in_x9*in_x11*in_x13*in_x20*in_x24*2.0-t2*t3*in_x2*in_x3*in_x4*in_x9*in_x11*in_x13*in_x21*in_x23*2.0+t2*t3*in_x2*in_x3*in_x4*in_x9*in_x11*in_x15*in_x19*in_x23*2.0-t2*t3*in_x2*in_x3*in_x4*in_x9*in_x11*in_x15*in_x20*in_x22*2.0+t2*t3*in_x2*in_x3*in_x4*in_x9*in_x12*in_x14*in_x19*in_x23*2.0-t2*t3*in_x2*in_x3*in_x4*in_x9*in_x12*in_x14*in_x20*in_x22*2.0-t2*t3*in_x2*in_x3*in_x5*in_x8*in_x10*in_x14*in_x20*in_x24*2.0+t2*t3*in_x2*in_x3*in_x5*in_x8*in_x10*in_x14*in_x21*in_x23*2.0-t2*t3*in_x2*in_x3*in_x5*in_x8*in_x11*in_x13*in_x20*in_x24*2.0+t2*t3*in_x2*in_x3*in_x5*in_x8*in_x11*in_x13*in_x21*in_x23*2.0-t2*t3*in_x2*in_x3*in_x5*in_x8*in_x11*in_x15*in_x19*in_x23*2.0+t2*t3*in_x2*in_x3*in_x5*in_x8*in_x11*in_x15*in_x20*in_x22*2.0-t2*t3*in_x2*in_x3*in_x5*in_x8*in_x12*in_x14*in_x19*in_x23*2.0+t2*t3*in_x2*in_x3*in_x5*in_x8*in_x12*in_x14*in_x20*in_x22*2.0-t2*t3*in_x2*in_x4*in_x5*in_x7*in_x10*in_x14*in_x20*in_x24*2.0-t2*t3*in_x2*in_x4*in_x5*in_x7*in_x10*in_x14*in_x21*in_x23*2.0+t2*t3*in_x2*in_x4*in_x5*in_x7*in_x11*in_x13*in_x20*in_x24*2.0+t2*t3*in_x2*in_x4*in_x5*in_x7*in_x11*in_x13*in_x21*in_x23*2.0-t2*t3*in_x2*in_x4*in_x5*in_x7*in_x11*in_x15*in_x19*in_x23*2.0-t2*t3*in_x2*in_x4*in_x5*in_x7*in_x11*in_x15*in_x20*in_x22*2.0+t2*t3*in_x2*in_x4*in_x5*in_x7*in_x12*in_x14*in_x19*in_x23*2.0+t2*t3*in_x2*in_x4*in_x5*in_x7*in_x12*in_x14*in_x20*in_x22*2.0+t2*t3*in_x3*in_x4*in_x5*in_x6*in_x10*in_x14*in_x20*in_x24*2.0+t2*t3*in_x3*in_x4*in_x5*in_x6*in_x10*in_x14*in_x21*in_x23*2.0-t2*t3*in_x3*in_x4*in_x5*in_x6*in_x11*in_x13*in_x20*in_x24*2.0-t2*t3*in_x3*in_x4*in_x5*in_x6*in_x11*in_x13*in_x21*in_x23*2.0+t2*t3*in_x3*in_x4*in_x5*in_x6*in_x11*in_x15*in_x19*in_x23*2.0+t2*t3*in_x3*in_x4*in_x5*in_x6*in_x11*in_x15*in_x20*in_x22*2.0-t2*t3*in_x3*in_x4*in_x5*in_x6*in_x12*in_x14*in_x19*in_x23*2.0-t2*t3*in_x3*in_x4*in_x5*in_x6*in_x12*in_x14*in_x20*in_x22*2.0+t2*t3*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24+t2*t3*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23+t2*t3*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24+t2*t3*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23-t2*t3*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23-t2*t3*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22-t2*t3*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23-t2*t3*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22+t2*t3*in_x2*in_x4*in_x7*in_x9*in_x10*in_x14*in_x20*in_x24*4.0-t2*t3*in_x2*in_x4*in_x7*in_x9*in_x10*in_x14*in_x21*in_x23*4.0-t2*t3*in_x2*in_x4*in_x7*in_x9*in_x11*in_x13*in_x20*in_x24*4.0+t2*t3*in_x2*in_x4*in_x7*in_x9*in_x11*in_x13*in_x21*in_x23*4.0-t2*t3*in_x2*in_x4*in_x7*in_x9*in_x11*in_x15*in_x19*in_x23*4.0+t2*t3*in_x2*in_x4*in_x7*in_x9*in_x11*in_x15*in_x20*in_x22*4.0+t2*t3*in_x2*in_x4*in_x7*in_x9*in_x12*in_x14*in_x19*in_x23*4.0-t2*t3*in_x2*in_x4*in_x7*in_x9*in_x12*in_x14*in_x20*in_x22*4.0-t2*t3*in_x2*in_x5*in_x7*in_x8*in_x10*in_x14*in_x20*in_x24*4.0+t2*t3*in_x2*in_x5*in_x7*in_x8*in_x10*in_x14*in_x21*in_x23*4.0+t2*t3*in_x2*in_x5*in_x7*in_x8*in_x11*in_x13*in_x20*in_x24*4.0-t2*t3*in_x2*in_x5*in_x7*in_x8*in_x11*in_x13*in_x21*in_x23*4.0+t2*t3*in_x2*in_x5*in_x7*in_x8*in_x11*in_x15*in_x19*in_x23*4.0-t2*t3*in_x2*in_x5*in_x7*in_x8*in_x11*in_x15*in_x20*in_x22*4.0-t2*t3*in_x2*in_x5*in_x7*in_x8*in_x12*in_x14*in_x19*in_x23*4.0+t2*t3*in_x2*in_x5*in_x7*in_x8*in_x12*in_x14*in_x20*in_x22*4.0-t2*t3*in_x3*in_x4*in_x6*in_x9*in_x10*in_x14*in_x20*in_x24*4.0+t2*t3*in_x3*in_x4*in_x6*in_x9*in_x10*in_x14*in_x21*in_x23*4.0+t2*t3*in_x3*in_x4*in_x6*in_x9*in_x11*in_x13*in_x20*in_x24*4.0-t2*t3*in_x3*in_x4*in_x6*in_x9*in_x11*in_x13*in_x21*in_x23*4.0+t2*t3*in_x3*in_x4*in_x6*in_x9*in_x11*in_x15*in_x19*in_x23*4.0-t2*t3*in_x3*in_x4*in_x6*in_x9*in_x11*in_x15*in_x20*in_x22*4.0-t2*t3*in_x3*in_x4*in_x6*in_x9*in_x12*in_x14*in_x19*in_x23*4.0+t2*t3*in_x3*in_x4*in_x6*in_x9*in_x12*in_x14*in_x20*in_x22*4.0+t2*t3*in_x3*in_x5*in_x6*in_x8*in_x10*in_x14*in_x20*in_x24*4.0-t2*t3*in_x3*in_x5*in_x6*in_x8*in_x10*in_x14*in_x21*in_x23*4.0-t2*t3*in_x3*in_x5*in_x6*in_x8*in_x11*in_x13*in_x20*in_x24*4.0+t2*t3*in_x3*in_x5*in_x6*in_x8*in_x11*in_x13*in_x21*in_x23*4.0-t2*t3*in_x3*in_x5*in_x6*in_x8*in_x11*in_x15*in_x19*in_x23*4.0+t2*t3*in_x3*in_x5*in_x6*in_x8*in_x11*in_x15*in_x20*in_x22*4.0+t2*t3*in_x3*in_x5*in_x6*in_x8*in_x12*in_x14*in_x19*in_x23*4.0-t2*t3*in_x3*in_x5*in_x6*in_x8*in_x12*in_x14*in_x20*in_x22*4.0+t2*t3*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x24+t2*t3*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x21*in_x23+t2*t3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x24+t2*t3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x21*in_x23-t2*t3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x19*in_x23-t2*t3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x20*in_x22-t2*t3*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x19*in_x23-t2*t3*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x20*in_x22+t2*t3*in_x2*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24*2.0+t2*t3*in_x2*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23*2.0-t2*t3*in_x2*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24*2.0-t2*t3*in_x2*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23*2.0+t2*t3*in_x2*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23*2.0+t2*t3*in_x2*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22*2.0-t2*t3*in_x2*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23*2.0-t2*t3*in_x2*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22*2.0-t2*t3*in_x3*in_x6*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24*2.0-t2*t3*in_x3*in_x6*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23*2.0+t2*t3*in_x3*in_x6*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24*2.0+t2*t3*in_x3*in_x6*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23*2.0-t2*t3*in_x3*in_x6*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23*2.0-t2*t3*in_x3*in_x6*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22*2.0+t2*t3*in_x3*in_x6*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23*2.0+t2*t3*in_x3*in_x6*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22*2.0-t2*t3*in_x4*in_x6*in_x7*in_x9*in_x10*in_x14*in_x20*in_x24*2.0+t2*t3*in_x4*in_x6*in_x7*in_x9*in_x10*in_x14*in_x21*in_x23*2.0-t2*t3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x13*in_x20*in_x24*2.0+t2*t3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x13*in_x21*in_x23*2.0-t2*t3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x15*in_x19*in_x23*2.0+t2*t3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x15*in_x20*in_x22*2.0-t2*t3*in_x4*in_x6*in_x7*in_x9*in_x12*in_x14*in_x19*in_x23*2.0+t2*t3*in_x4*in_x6*in_x7*in_x9*in_x12*in_x14*in_x20*in_x22*2.0+t2*t3*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x24*2.0-t2*t3*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x23*2.0+t2*t3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x24*2.0-t2*t3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x23*2.0+t2*t3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x23*2.0-t2*t3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x22*2.0+t2*t3*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x23*2.0-t2*t3*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x22*2.0+t3*t6*in_x2*in_x3*in_x4*in_x6*in_x13*in_x17*in_x20*in_x27*2.0-t3*t6*in_x2*in_x3*in_x4*in_x6*in_x13*in_x17*in_x21*in_x26*2.0-t3*t6*in_x2*in_x3*in_x4*in_x6*in_x14*in_x16*in_x20*in_x27*2.0+t3*t6*in_x2*in_x3*in_x4*in_x6*in_x14*in_x16*in_x21*in_x26*2.0-t3*t6*in_x2*in_x3*in_x4*in_x6*in_x14*in_x18*in_x19*in_x26*2.0+t3*t6*in_x2*in_x3*in_x4*in_x6*in_x14*in_x18*in_x20*in_x25*2.0+t3*t6*in_x2*in_x3*in_x4*in_x6*in_x15*in_x17*in_x19*in_x26*2.0-t3*t6*in_x2*in_x3*in_x4*in_x6*in_x15*in_x17*in_x20*in_x25*2.0+t3*t9*in_x2*in_x3*in_x4*in_x7*in_x10*in_x17*in_x20*in_x27*2.0-t3*t9*in_x2*in_x3*in_x4*in_x7*in_x10*in_x17*in_x21*in_x26*2.0-t3*t9*in_x2*in_x3*in_x4*in_x7*in_x11*in_x16*in_x20*in_x27*2.0+t3*t9*in_x2*in_x3*in_x4*in_x7*in_x11*in_x16*in_x21*in_x26*2.0-t3*t9*in_x2*in_x3*in_x4*in_x7*in_x11*in_x18*in_x19*in_x26*2.0+t3*t9*in_x2*in_x3*in_x4*in_x7*in_x11*in_x18*in_x20*in_x25*2.0+t3*t9*in_x2*in_x3*in_x4*in_x7*in_x12*in_x17*in_x19*in_x26*2.0-t3*t9*in_x2*in_x3*in_x4*in_x7*in_x12*in_x17*in_x20*in_x25*2.0-t2*t3*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24-t2*t3*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23-t2*t3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24-t2*t3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23+t2*t3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23+t2*t3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22+t2*t3*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23+t2*t3*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22+t3*t6*in_x2*in_x3*in_x5*in_x6*in_x13*in_x17*in_x23*in_x27*2.0-t3*t6*in_x2*in_x3*in_x5*in_x6*in_x13*in_x17*in_x24*in_x26*2.0-t3*t6*in_x2*in_x3*in_x5*in_x6*in_x14*in_x16*in_x23*in_x27*2.0+t3*t6*in_x2*in_x3*in_x5*in_x6*in_x14*in_x16*in_x24*in_x26*2.0-t3*t6*in_x2*in_x3*in_x5*in_x6*in_x14*in_x18*in_x22*in_x26*2.0+t3*t6*in_x2*in_x3*in_x5*in_x6*in_x14*in_x18*in_x23*in_x25*2.0+t3*t6*in_x2*in_x3*in_x5*in_x6*in_x15*in_x17*in_x22*in_x26*2.0-t3*t6*in_x2*in_x3*in_x5*in_x6*in_x15*in_x17*in_x23*in_x25*2.0-t3*t6*in_x2*in_x3*in_x6*in_x8*in_x13*in_x17*in_x20*in_x27*2.0+t3*t6*in_x2*in_x3*in_x6*in_x8*in_x13*in_x17*in_x21*in_x26*2.0+t3*t6*in_x2*in_x3*in_x6*in_x8*in_x14*in_x16*in_x20*in_x27*2.0-t3*t6*in_x2*in_x3*in_x6*in_x8*in_x14*in_x16*in_x21*in_x26*2.0+t3*t6*in_x2*in_x3*in_x6*in_x8*in_x14*in_x18*in_x19*in_x26*2.0-t3*t6*in_x2*in_x3*in_x6*in_x8*in_x14*in_x18*in_x20*in_x25*2.0-t3*t6*in_x2*in_x3*in_x6*in_x8*in_x15*in_x17*in_x19*in_x26*2.0+t3*t6*in_x2*in_x3*in_x6*in_x8*in_x15*in_x17*in_x20*in_x25*2.0-t3*t6*in_x2*in_x4*in_x6*in_x7*in_x13*in_x17*in_x20*in_x27*2.0+t3*t6*in_x2*in_x4*in_x6*in_x7*in_x13*in_x17*in_x21*in_x26*2.0+t3*t6*in_x2*in_x4*in_x6*in_x7*in_x14*in_x16*in_x20*in_x27*2.0-t3*t6*in_x2*in_x4*in_x6*in_x7*in_x14*in_x16*in_x21*in_x26*2.0+t3*t6*in_x2*in_x4*in_x6*in_x7*in_x14*in_x18*in_x19*in_x26*2.0-t3*t6*in_x2*in_x4*in_x6*in_x7*in_x14*in_x18*in_x20*in_x25*2.0-t3*t6*in_x2*in_x4*in_x6*in_x7*in_x15*in_x17*in_x19*in_x26*2.0+t3*t6*in_x2*in_x4*in_x6*in_x7*in_x15*in_x17*in_x20*in_x25*2.0+t3*t9*in_x2*in_x3*in_x5*in_x7*in_x10*in_x17*in_x23*in_x27*2.0-t3*t9*in_x2*in_x3*in_x5*in_x7*in_x10*in_x17*in_x24*in_x26*2.0-t3*t9*in_x2*in_x3*in_x5*in_x7*in_x11*in_x16*in_x23*in_x27*2.0+t3*t9*in_x2*in_x3*in_x5*in_x7*in_x11*in_x16*in_x24*in_x26*2.0-t3*t9*in_x2*in_x3*in_x5*in_x7*in_x11*in_x18*in_x22*in_x26*2.0+t3*t9*in_x2*in_x3*in_x5*in_x7*in_x11*in_x18*in_x23*in_x25*2.0+t3*t9*in_x2*in_x3*in_x5*in_x7*in_x12*in_x17*in_x22*in_x26*2.0-t3*t9*in_x2*in_x3*in_x5*in_x7*in_x12*in_x17*in_x23*in_x25*2.0-t3*t9*in_x2*in_x3*in_x7*in_x8*in_x10*in_x17*in_x20*in_x27*2.0+t3*t9*in_x2*in_x3*in_x7*in_x8*in_x10*in_x17*in_x21*in_x26*2.0+t3*t9*in_x2*in_x3*in_x7*in_x8*in_x11*in_x16*in_x20*in_x27*2.0-t3*t9*in_x2*in_x3*in_x7*in_x8*in_x11*in_x16*in_x21*in_x26*2.0+t3*t9*in_x2*in_x3*in_x7*in_x8*in_x11*in_x18*in_x19*in_x26*2.0-t3*t9*in_x2*in_x3*in_x7*in_x8*in_x11*in_x18*in_x20*in_x25*2.0-t3*t9*in_x2*in_x3*in_x7*in_x8*in_x12*in_x17*in_x19*in_x26*2.0+t3*t9*in_x2*in_x3*in_x7*in_x8*in_x12*in_x17*in_x20*in_x25*2.0-t3*t9*in_x3*in_x4*in_x6*in_x7*in_x10*in_x17*in_x20*in_x27*2.0+t3*t9*in_x3*in_x4*in_x6*in_x7*in_x10*in_x17*in_x21*in_x26*2.0+t3*t9*in_x3*in_x4*in_x6*in_x7*in_x11*in_x16*in_x20*in_x27*2.0-t3*t9*in_x3*in_x4*in_x6*in_x7*in_x11*in_x16*in_x21*in_x26*2.0+t3*t9*in_x3*in_x4*in_x6*in_x7*in_x11*in_x18*in_x19*in_x26*2.0-t3*t9*in_x3*in_x4*in_x6*in_x7*in_x11*in_x18*in_x20*in_x25*2.0-t3*t9*in_x3*in_x4*in_x6*in_x7*in_x12*in_x17*in_x19*in_x26*2.0+t3*t9*in_x3*in_x4*in_x6*in_x7*in_x12*in_x17*in_x20*in_x25*2.0-t3*t6*in_x2*in_x3*in_x6*in_x9*in_x13*in_x17*in_x23*in_x27*2.0+t3*t6*in_x2*in_x3*in_x6*in_x9*in_x13*in_x17*in_x24*in_x26*2.0+t3*t6*in_x2*in_x3*in_x6*in_x9*in_x14*in_x16*in_x23*in_x27*2.0-t3*t6*in_x2*in_x3*in_x6*in_x9*in_x14*in_x16*in_x24*in_x26*2.0+t3*t6*in_x2*in_x3*in_x6*in_x9*in_x14*in_x18*in_x22*in_x26*2.0-t3*t6*in_x2*in_x3*in_x6*in_x9*in_x14*in_x18*in_x23*in_x25*2.0-t3*t6*in_x2*in_x3*in_x6*in_x9*in_x15*in_x17*in_x22*in_x26*2.0+t3*t6*in_x2*in_x3*in_x6*in_x9*in_x15*in_x17*in_x23*in_x25*2.0-t3*t6*in_x2*in_x5*in_x6*in_x7*in_x13*in_x17*in_x23*in_x27*2.0+t3*t6*in_x2*in_x5*in_x6*in_x7*in_x13*in_x17*in_x24*in_x26*2.0+t3*t6*in_x2*in_x5*in_x6*in_x7*in_x14*in_x16*in_x23*in_x27*2.0-t3*t6*in_x2*in_x5*in_x6*in_x7*in_x14*in_x16*in_x24*in_x26*2.0+t3*t6*in_x2*in_x5*in_x6*in_x7*in_x14*in_x18*in_x22*in_x26*2.0-t3*t6*in_x2*in_x5*in_x6*in_x7*in_x14*in_x18*in_x23*in_x25*2.0-t3*t6*in_x2*in_x5*in_x6*in_x7*in_x15*in_x17*in_x22*in_x26*2.0+t3*t6*in_x2*in_x5*in_x6*in_x7*in_x15*in_x17*in_x23*in_x25*2.0+t3*t6*in_x2*in_x6*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27*2.0-t3*t6*in_x2*in_x6*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26*2.0-t3*t6*in_x2*in_x6*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27*2.0+t3*t6*in_x2*in_x6*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26*2.0-t3*t6*in_x2*in_x6*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26*2.0+t3*t6*in_x2*in_x6*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25*2.0+t3*t6*in_x2*in_x6*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26*2.0-t3*t6*in_x2*in_x6*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25*2.0+t2*t12*in_x2*in_x4*in_x5*in_x8*in_x10*in_x17*in_x23*in_x27*2.0-t2*t12*in_x2*in_x4*in_x5*in_x8*in_x10*in_x17*in_x24*in_x26*2.0-t2*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x16*in_x23*in_x27*2.0+t2*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x16*in_x24*in_x26*2.0-t2*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x18*in_x22*in_x26*2.0+t2*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x18*in_x23*in_x25*2.0+t2*t12*in_x2*in_x4*in_x5*in_x8*in_x12*in_x17*in_x22*in_x26*2.0-t2*t12*in_x2*in_x4*in_x5*in_x8*in_x12*in_x17*in_x23*in_x25*2.0+t2*t14*in_x2*in_x4*in_x5*in_x9*in_x10*in_x17*in_x20*in_x27*2.0-t2*t14*in_x2*in_x4*in_x5*in_x9*in_x10*in_x17*in_x21*in_x26*2.0-t2*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x16*in_x20*in_x27*2.0+t2*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x16*in_x21*in_x26*2.0-t2*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x18*in_x19*in_x26*2.0+t2*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x18*in_x20*in_x25*2.0+t2*t14*in_x2*in_x4*in_x5*in_x9*in_x12*in_x17*in_x19*in_x26*2.0-t2*t14*in_x2*in_x4*in_x5*in_x9*in_x12*in_x17*in_x20*in_x25*2.0-t3*t9*in_x2*in_x3*in_x7*in_x9*in_x10*in_x17*in_x23*in_x27*2.0+t3*t9*in_x2*in_x3*in_x7*in_x9*in_x10*in_x17*in_x24*in_x26*2.0+t3*t9*in_x2*in_x3*in_x7*in_x9*in_x11*in_x16*in_x23*in_x27*2.0-t3*t9*in_x2*in_x3*in_x7*in_x9*in_x11*in_x16*in_x24*in_x26*2.0+t3*t9*in_x2*in_x3*in_x7*in_x9*in_x11*in_x18*in_x22*in_x26*2.0-t3*t9*in_x2*in_x3*in_x7*in_x9*in_x11*in_x18*in_x23*in_x25*2.0-t3*t9*in_x2*in_x3*in_x7*in_x9*in_x12*in_x17*in_x22*in_x26*2.0+t3*t9*in_x2*in_x3*in_x7*in_x9*in_x12*in_x17*in_x23*in_x25*2.0-t3*t9*in_x3*in_x5*in_x6*in_x7*in_x10*in_x17*in_x23*in_x27*2.0+t3*t9*in_x3*in_x5*in_x6*in_x7*in_x10*in_x17*in_x24*in_x26*2.0+t3*t9*in_x3*in_x5*in_x6*in_x7*in_x11*in_x16*in_x23*in_x27*2.0-t3*t9*in_x3*in_x5*in_x6*in_x7*in_x11*in_x16*in_x24*in_x26*2.0+t3*t9*in_x3*in_x5*in_x6*in_x7*in_x11*in_x18*in_x22*in_x26*2.0-t3*t9*in_x3*in_x5*in_x6*in_x7*in_x11*in_x18*in_x23*in_x25*2.0-t3*t9*in_x3*in_x5*in_x6*in_x7*in_x12*in_x17*in_x22*in_x26*2.0+t3*t9*in_x3*in_x5*in_x6*in_x7*in_x12*in_x17*in_x23*in_x25*2.0+t3*t9*in_x3*in_x6*in_x7*in_x8*in_x10*in_x17*in_x20*in_x27*2.0-t3*t9*in_x3*in_x6*in_x7*in_x8*in_x10*in_x17*in_x21*in_x26*2.0-t3*t9*in_x3*in_x6*in_x7*in_x8*in_x11*in_x16*in_x20*in_x27*2.0+t3*t9*in_x3*in_x6*in_x7*in_x8*in_x11*in_x16*in_x21*in_x26*2.0-t3*t9*in_x3*in_x6*in_x7*in_x8*in_x11*in_x18*in_x19*in_x26*2.0+t3*t9*in_x3*in_x6*in_x7*in_x8*in_x11*in_x18*in_x20*in_x25*2.0+t3*t9*in_x3*in_x6*in_x7*in_x8*in_x12*in_x17*in_x19*in_x26*2.0-t3*t9*in_x3*in_x6*in_x7*in_x8*in_x12*in_x17*in_x20*in_x25*2.0+t3*t6*in_x2*in_x6*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27*2.0-t3*t6*in_x2*in_x6*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26*2.0-t3*t6*in_x2*in_x6*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27*2.0+t3*t6*in_x2*in_x6*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26*2.0-t3*t6*in_x2*in_x6*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26*2.0+t3*t6*in_x2*in_x6*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25*2.0+t3*t6*in_x2*in_x6*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26*2.0-t3*t6*in_x2*in_x6*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25*2.0-t2*t12*in_x2*in_x4*in_x8*in_x9*in_x10*in_x17*in_x23*in_x27*2.0+t2*t12*in_x2*in_x4*in_x8*in_x9*in_x10*in_x17*in_x24*in_x26*2.0+t2*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x16*in_x23*in_x27*2.0-t2*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x16*in_x24*in_x26*2.0+t2*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x18*in_x22*in_x26*2.0-t2*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x18*in_x23*in_x25*2.0-t2*t12*in_x2*in_x4*in_x8*in_x9*in_x12*in_x17*in_x22*in_x26*2.0+t2*t12*in_x2*in_x4*in_x8*in_x9*in_x12*in_x17*in_x23*in_x25*2.0+t2*t12*in_x3*in_x4*in_x5*in_x8*in_x13*in_x17*in_x23*in_x27*2.0-t2*t12*in_x3*in_x4*in_x5*in_x8*in_x13*in_x17*in_x24*in_x26*2.0-t2*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x16*in_x23*in_x27*2.0+t2*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x16*in_x24*in_x26*2.0-t2*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x18*in_x22*in_x26*2.0+t2*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x18*in_x23*in_x25*2.0+t2*t12*in_x3*in_x4*in_x5*in_x8*in_x15*in_x17*in_x22*in_x26*2.0-t2*t12*in_x3*in_x4*in_x5*in_x8*in_x15*in_x17*in_x23*in_x25*2.0-t2*t12*in_x4*in_x5*in_x6*in_x8*in_x10*in_x17*in_x23*in_x27*2.0+t2*t12*in_x4*in_x5*in_x6*in_x8*in_x10*in_x17*in_x24*in_x26*2.0+t2*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x16*in_x23*in_x27*2.0-t2*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x16*in_x24*in_x26*2.0+t2*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x18*in_x22*in_x26*2.0-t2*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x18*in_x23*in_x25*2.0-t2*t12*in_x4*in_x5*in_x6*in_x8*in_x12*in_x17*in_x22*in_x26*2.0+t2*t12*in_x4*in_x5*in_x6*in_x8*in_x12*in_x17*in_x23*in_x25*2.0-t2*t14*in_x2*in_x5*in_x8*in_x9*in_x10*in_x17*in_x20*in_x27*2.0+t2*t14*in_x2*in_x5*in_x8*in_x9*in_x10*in_x17*in_x21*in_x26*2.0+t2*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x16*in_x20*in_x27*2.0-t2*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x16*in_x21*in_x26*2.0+t2*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x18*in_x19*in_x26*2.0-t2*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x18*in_x20*in_x25*2.0-t2*t14*in_x2*in_x5*in_x8*in_x9*in_x12*in_x17*in_x19*in_x26*2.0+t2*t14*in_x2*in_x5*in_x8*in_x9*in_x12*in_x17*in_x20*in_x25*2.0+t2*t14*in_x3*in_x4*in_x5*in_x9*in_x13*in_x17*in_x20*in_x27*2.0-t2*t14*in_x3*in_x4*in_x5*in_x9*in_x13*in_x17*in_x21*in_x26*2.0-t2*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x16*in_x20*in_x27*2.0+t2*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x16*in_x21*in_x26*2.0-t2*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x18*in_x19*in_x26*2.0+t2*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x18*in_x20*in_x25*2.0+t2*t14*in_x3*in_x4*in_x5*in_x9*in_x15*in_x17*in_x19*in_x26*2.0-t2*t14*in_x3*in_x4*in_x5*in_x9*in_x15*in_x17*in_x20*in_x25*2.0-t2*t14*in_x4*in_x5*in_x6*in_x9*in_x10*in_x17*in_x20*in_x27*2.0+t2*t14*in_x4*in_x5*in_x6*in_x9*in_x10*in_x17*in_x21*in_x26*2.0+t2*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x16*in_x20*in_x27*2.0-t2*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x16*in_x21*in_x26*2.0+t2*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x18*in_x19*in_x26*2.0-t2*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x18*in_x20*in_x25*2.0-t2*t14*in_x4*in_x5*in_x6*in_x9*in_x12*in_x17*in_x19*in_x26*2.0+t2*t14*in_x4*in_x5*in_x6*in_x9*in_x12*in_x17*in_x20*in_x25*2.0-t3*t5*in_x3*in_x4*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0+t3*t5*in_x3*in_x4*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0-t3*t5*in_x3*in_x4*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0+t3*t5*in_x3*in_x4*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0+t3*t9*in_x3*in_x6*in_x7*in_x9*in_x10*in_x17*in_x23*in_x27*2.0-t3*t9*in_x3*in_x6*in_x7*in_x9*in_x10*in_x17*in_x24*in_x26*2.0-t3*t9*in_x3*in_x6*in_x7*in_x9*in_x11*in_x16*in_x23*in_x27*2.0+t3*t9*in_x3*in_x6*in_x7*in_x9*in_x11*in_x16*in_x24*in_x26*2.0-t3*t9*in_x3*in_x6*in_x7*in_x9*in_x11*in_x18*in_x22*in_x26*2.0+t3*t9*in_x3*in_x6*in_x7*in_x9*in_x11*in_x18*in_x23*in_x25*2.0+t3*t9*in_x3*in_x6*in_x7*in_x9*in_x12*in_x17*in_x22*in_x26*2.0-t3*t9*in_x3*in_x6*in_x7*in_x9*in_x12*in_x17*in_x23*in_x25*2.0+t3*t8*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*2.0-t3*t8*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*2.0+t3*t4*in_x4*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0-t3*t4*in_x4*in_x7*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0+t3*t4*in_x4*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0-t3*t4*in_x4*in_x7*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0-t2*t12*in_x3*in_x4*in_x8*in_x9*in_x13*in_x17*in_x23*in_x27*2.0+t2*t12*in_x3*in_x4*in_x8*in_x9*in_x13*in_x17*in_x24*in_x26*2.0+t2*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x16*in_x23*in_x27*2.0-t2*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x16*in_x24*in_x26*2.0+t2*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x18*in_x22*in_x26*2.0-t2*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x18*in_x23*in_x25*2.0-t2*t12*in_x3*in_x4*in_x8*in_x9*in_x15*in_x17*in_x22*in_x26*2.0+t2*t12*in_x3*in_x4*in_x8*in_x9*in_x15*in_x17*in_x23*in_x25*2.0-t2*t12*in_x4*in_x5*in_x7*in_x8*in_x13*in_x17*in_x23*in_x27*2.0+t2*t12*in_x4*in_x5*in_x7*in_x8*in_x13*in_x17*in_x24*in_x26*2.0+t2*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x16*in_x23*in_x27*2.0-t2*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x16*in_x24*in_x26*2.0+t2*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x18*in_x22*in_x26*2.0-t2*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x18*in_x23*in_x25*2.0-t2*t12*in_x4*in_x5*in_x7*in_x8*in_x15*in_x17*in_x22*in_x26*2.0+t2*t12*in_x4*in_x5*in_x7*in_x8*in_x15*in_x17*in_x23*in_x25*2.0+t2*t12*in_x4*in_x6*in_x8*in_x9*in_x10*in_x17*in_x23*in_x27*2.0-t2*t12*in_x4*in_x6*in_x8*in_x9*in_x10*in_x17*in_x24*in_x26*2.0-t2*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x16*in_x23*in_x27*2.0+t2*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x16*in_x24*in_x26*2.0-t2*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x18*in_x22*in_x26*2.0+t2*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x18*in_x23*in_x25*2.0+t2*t12*in_x4*in_x6*in_x8*in_x9*in_x12*in_x17*in_x22*in_x26*2.0-t2*t12*in_x4*in_x6*in_x8*in_x9*in_x12*in_x17*in_x23*in_x25*2.0-t2*t14*in_x3*in_x5*in_x8*in_x9*in_x13*in_x17*in_x20*in_x27*2.0+t2*t14*in_x3*in_x5*in_x8*in_x9*in_x13*in_x17*in_x21*in_x26*2.0+t2*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x16*in_x20*in_x27*2.0-t2*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x16*in_x21*in_x26*2.0+t2*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x18*in_x19*in_x26*2.0-t2*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x18*in_x20*in_x25*2.0-t2*t14*in_x3*in_x5*in_x8*in_x9*in_x15*in_x17*in_x19*in_x26*2.0+t2*t14*in_x3*in_x5*in_x8*in_x9*in_x15*in_x17*in_x20*in_x25*2.0-t2*t14*in_x4*in_x5*in_x7*in_x9*in_x13*in_x17*in_x20*in_x27*2.0+t2*t14*in_x4*in_x5*in_x7*in_x9*in_x13*in_x17*in_x21*in_x26*2.0+t2*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x16*in_x20*in_x27*2.0-t2*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x16*in_x21*in_x26*2.0+t2*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x18*in_x19*in_x26*2.0-t2*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x18*in_x20*in_x25*2.0-t2*t14*in_x4*in_x5*in_x7*in_x9*in_x15*in_x17*in_x19*in_x26*2.0+t2*t14*in_x4*in_x5*in_x7*in_x9*in_x15*in_x17*in_x20*in_x25*2.0+t2*t14*in_x5*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x27*2.0-t2*t14*in_x5*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x26*2.0-t2*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x27*2.0+t2*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x26*2.0-t2*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x26*2.0+t2*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x25*2.0+t2*t14*in_x5*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x26*2.0-t2*t14*in_x5*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x25*2.0-t3*t5*in_x3*in_x5*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0+t3*t5*in_x3*in_x5*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0-t3*t5*in_x3*in_x5*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0+t3*t5*in_x3*in_x5*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0+t3*t5*in_x3*in_x8*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0-t3*t5*in_x3*in_x8*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0+t3*t5*in_x3*in_x8*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0-t3*t5*in_x3*in_x8*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0-t3*t11*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*2.0+t3*t11*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*2.0+t3*t4*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0-t3*t4*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0+t3*t4*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0-t3*t4*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0-t3*t4*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0+t3*t4*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0-t3*t4*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0+t3*t4*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0-t3*t10*in_x2*in_x4*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0+t3*t10*in_x2*in_x4*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0-t3*t10*in_x2*in_x4*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0+t3*t10*in_x2*in_x4*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0+t2*t12*in_x4*in_x7*in_x8*in_x9*in_x13*in_x17*in_x23*in_x27*2.0-t2*t12*in_x4*in_x7*in_x8*in_x9*in_x13*in_x17*in_x24*in_x26*2.0-t2*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x16*in_x23*in_x27*2.0+t2*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x16*in_x24*in_x26*2.0-t2*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x18*in_x22*in_x26*2.0+t2*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x18*in_x23*in_x25*2.0+t2*t12*in_x4*in_x7*in_x8*in_x9*in_x15*in_x17*in_x22*in_x26*2.0-t2*t12*in_x4*in_x7*in_x8*in_x9*in_x15*in_x17*in_x23*in_x25*2.0+t2*t14*in_x5*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x27*2.0-t2*t14*in_x5*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x26*2.0-t2*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x27*2.0+t2*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x26*2.0-t2*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x26*2.0+t2*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x25*2.0+t2*t14*in_x5*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x26*2.0-t2*t14*in_x5*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x25*2.0+t3*t5*in_x3*in_x9*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0-t3*t5*in_x3*in_x9*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0+t3*t5*in_x3*in_x9*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0-t3*t5*in_x3*in_x9*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0+t3*t7*in_x4*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0-t3*t7*in_x4*in_x6*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0+t3*t7*in_x4*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0-t3*t7*in_x4*in_x6*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0-t3*t8*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*2.0+t3*t8*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*2.0-t3*t4*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0+t3*t4*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0-t3*t4*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0+t3*t4*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0-t3*t10*in_x2*in_x5*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0+t3*t10*in_x2*in_x5*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0-t3*t10*in_x2*in_x5*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0+t3*t10*in_x2*in_x5*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0+t3*t10*in_x2*in_x8*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0-t3*t10*in_x2*in_x8*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0+t3*t10*in_x2*in_x8*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0-t3*t10*in_x2*in_x8*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0+t3*t7*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0-t3*t7*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0+t3*t7*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0-t3*t7*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0-t3*t7*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0+t3*t7*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0-t3*t7*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0+t3*t7*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0+t3*t11*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*2.0-t3*t11*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*2.0+t3*t13*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x23*in_x24*2.0-t3*t13*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x22*in_x23*2.0-t3*t15*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x23*in_x24*2.0+t3*t15*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x22*in_x23*2.0+t3*t10*in_x2*in_x9*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0-t3*t10*in_x2*in_x9*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0+t3*t10*in_x2*in_x9*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0-t3*t10*in_x2*in_x9*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0-t3*t7*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0+t3*t7*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0-t3*t7*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0+t3*t7*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0+t2*t4*in_x4*in_x5*in_x10*in_x11*in_x20*in_x23*in_x26*in_x27*2.0-t2*t4*in_x4*in_x5*in_x11*in_x12*in_x20*in_x23*in_x25*in_x26*2.0-t2*t5*in_x4*in_x5*in_x10*in_x11*in_x20*in_x23*in_x26*in_x27*2.0+t2*t5*in_x4*in_x5*in_x11*in_x12*in_x20*in_x23*in_x25*in_x26*2.0-t3*t13*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x23*in_x24*2.0+t3*t13*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x22*in_x23*2.0+t3*t15*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x23*in_x24*2.0-t3*t15*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x22*in_x23*2.0-t8*t12*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x26*in_x27*2.0+t8*t12*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x25*in_x26*2.0+t2*t11*in_x2*in_x5*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t2*t11*in_x2*in_x5*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t2*t11*in_x2*in_x5*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t2*t11*in_x2*in_x5*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0-t2*t8*in_x2*in_x9*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t2*t8*in_x2*in_x9*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t2*t8*in_x2*in_x9*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t2*t8*in_x2*in_x9*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t11*t12*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x26*in_x27*2.0-t11*t12*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x25*in_x26*2.0-t2*t4*in_x8*in_x9*in_x10*in_x11*in_x20*in_x23*in_x26*in_x27*2.0+t2*t4*in_x8*in_x9*in_x11*in_x12*in_x20*in_x23*in_x25*in_x26*2.0+t2*t5*in_x8*in_x9*in_x10*in_x11*in_x20*in_x23*in_x26*in_x27*2.0-t2*t5*in_x8*in_x9*in_x11*in_x12*in_x20*in_x23*in_x25*in_x26*2.0+t2*t7*in_x4*in_x5*in_x13*in_x14*in_x20*in_x23*in_x26*in_x27*2.0-t2*t7*in_x4*in_x5*in_x14*in_x15*in_x20*in_x23*in_x25*in_x26*2.0+t2*t11*in_x3*in_x5*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t2*t11*in_x3*in_x5*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t2*t11*in_x3*in_x5*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t2*t11*in_x3*in_x5*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0-t2*t11*in_x5*in_x6*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t2*t11*in_x5*in_x6*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t2*t11*in_x5*in_x6*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t2*t11*in_x5*in_x6*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0-t2*t8*in_x3*in_x9*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t2*t8*in_x3*in_x9*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t2*t8*in_x3*in_x9*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t2*t8*in_x3*in_x9*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t2*t8*in_x6*in_x9*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t2*t8*in_x6*in_x9*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t2*t8*in_x6*in_x9*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t2*t8*in_x6*in_x9*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t2*t15*in_x2*in_x4*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t2*t15*in_x2*in_x4*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t2*t15*in_x2*in_x4*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t2*t15*in_x2*in_x4*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t13*t14*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x26*in_x27*2.0+t13*t14*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x25*in_x26*2.0-t2*t10*in_x4*in_x5*in_x13*in_x14*in_x20*in_x23*in_x26*in_x27*2.0+t2*t10*in_x4*in_x5*in_x14*in_x15*in_x20*in_x23*in_x25*in_x26*2.0+t8*t12*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x26*in_x27*2.0-t8*t12*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x25*in_x26*2.0-t2*t11*in_x5*in_x7*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t2*t11*in_x5*in_x7*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t2*t11*in_x5*in_x7*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t2*t11*in_x5*in_x7*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0-t2*t13*in_x2*in_x8*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t2*t13*in_x2*in_x8*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t2*t13*in_x2*in_x8*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t2*t13*in_x2*in_x8*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t14*t15*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x26*in_x27*2.0-t14*t15*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x25*in_x26*2.0+t2*t8*in_x7*in_x9*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t2*t8*in_x7*in_x9*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t2*t8*in_x7*in_x9*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t2*t8*in_x7*in_x9*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t2*t15*in_x3*in_x4*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t2*t15*in_x3*in_x4*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t2*t15*in_x3*in_x4*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t2*t15*in_x3*in_x4*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t2*t15*in_x4*in_x6*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t2*t15*in_x4*in_x6*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t2*t15*in_x4*in_x6*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t2*t15*in_x4*in_x6*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t11*t12*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x26*in_x27*2.0+t11*t12*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x25*in_x26*2.0-t4*t6*in_x4*in_x5*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t4*t6*in_x4*in_x5*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t2*t7*in_x8*in_x9*in_x13*in_x14*in_x20*in_x23*in_x26*in_x27*2.0+t2*t7*in_x8*in_x9*in_x14*in_x15*in_x20*in_x23*in_x25*in_x26*2.0-t2*t13*in_x3*in_x8*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t2*t13*in_x3*in_x8*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t2*t13*in_x3*in_x8*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t2*t13*in_x3*in_x8*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t2*t13*in_x6*in_x8*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t2*t13*in_x6*in_x8*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t2*t13*in_x6*in_x8*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t2*t13*in_x6*in_x8*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t5*t6*in_x4*in_x5*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t5*t6*in_x4*in_x5*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t2*t15*in_x4*in_x7*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t2*t15*in_x4*in_x7*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t2*t15*in_x4*in_x7*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t2*t15*in_x4*in_x7*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t13*t14*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x26*in_x27*2.0-t13*t14*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x25*in_x26*2.0+t2*t10*in_x8*in_x9*in_x13*in_x14*in_x20*in_x23*in_x26*in_x27*2.0-t2*t10*in_x8*in_x9*in_x14*in_x15*in_x20*in_x23*in_x25*in_x26*2.0+t2*t13*in_x7*in_x8*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t2*t13*in_x7*in_x8*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t2*t13*in_x7*in_x8*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t2*t13*in_x7*in_x8*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t14*t15*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x26*in_x27*2.0+t14*t15*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x25*in_x26*2.0-t7*t9*in_x4*in_x5*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t7*t9*in_x4*in_x5*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t4*t6*in_x8*in_x9*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t4*t6*in_x8*in_x9*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t5*t6*in_x8*in_x9*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t5*t6*in_x8*in_x9*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t9*t10*in_x4*in_x5*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t9*t10*in_x4*in_x5*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t7*t9*in_x8*in_x9*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t7*t9*in_x8*in_x9*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t9*t10*in_x8*in_x9*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t9*t10*in_x8*in_x9*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t3*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0+t3*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0-t3*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0-t3*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0-t3*in_x2*in_x3*in_x4*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*4.0+t3*in_x2*in_x3*in_x4*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*4.0-t3*in_x2*in_x3*in_x4*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*4.0+t3*in_x2*in_x3*in_x4*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*4.0+t3*in_x2*in_x3*in_x5*in_x8*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*4.0-t3*in_x2*in_x3*in_x5*in_x8*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*4.0+t3*in_x2*in_x3*in_x5*in_x8*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*4.0-t3*in_x2*in_x3*in_x5*in_x8*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*4.0-t3*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0-t3*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0+t3*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0+t3*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0-t3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0-t3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0+t3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0+t3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0+t3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*4.0-t3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*4.0+t3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*4.0-t3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*4.0-t3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*4.0+t3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*4.0-t3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*4.0+t3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*4.0+t3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0+t3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0-t3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0-t3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0+t2*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0+t2*in_x2*in_x4*in_x5*in_x7*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*4.0-t2*in_x2*in_x4*in_x5*in_x7*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*4.0+t2*in_x2*in_x4*in_x5*in_x7*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*4.0-t2*in_x2*in_x4*in_x5*in_x7*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*4.0-t2*in_x3*in_x4*in_x5*in_x6*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*4.0+t2*in_x3*in_x4*in_x5*in_x6*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*4.0-t2*in_x3*in_x4*in_x5*in_x6*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*4.0+t2*in_x3*in_x4*in_x5*in_x6*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*4.0-t2*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0+t2*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0+t2*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x2*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*4.0+t2*in_x2*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*4.0-t2*in_x2*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*4.0+t2*in_x2*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*4.0+t2*in_x3*in_x6*in_x8*in_x9*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*4.0-t2*in_x3*in_x6*in_x8*in_x9*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*4.0+t2*in_x3*in_x6*in_x8*in_x9*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*4.0-t2*in_x3*in_x6*in_x8*in_x9*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*4.0+t2*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0+t2*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0-t2*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0-t2*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0-in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*4.0+in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*4.0+in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*4.0-in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*4.0+in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*4.0-in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*4.0-in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x23*in_x26*in_x27*4.0+in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x23*in_x25*in_x26*4.0;  // NOLINT
        coeffs[3] = t3*t5*t6*t8*in_x2*in_x10*in_x17*in_x20*in_x21-t3*t5*t6*t8*in_x2*in_x11*in_x16*in_x20*in_x21+t3*t5*t6*t8*in_x2*in_x11*in_x18*in_x19*in_x20-t3*t5*t6*t8*in_x2*in_x12*in_x17*in_x19*in_x20-t3*t4*t6*t8*in_x6*in_x10*in_x17*in_x20*in_x21+t3*t4*t6*t8*in_x6*in_x11*in_x16*in_x20*in_x21-t3*t4*t6*t8*in_x6*in_x11*in_x18*in_x19*in_x20+t3*t4*t6*t8*in_x6*in_x12*in_x17*in_x19*in_x20-t3*t5*t6*t11*in_x2*in_x10*in_x17*in_x20*in_x21+t3*t5*t6*t11*in_x2*in_x11*in_x16*in_x20*in_x21-t3*t5*t6*t11*in_x2*in_x11*in_x18*in_x19*in_x20+t3*t5*t6*t11*in_x2*in_x12*in_x17*in_x19*in_x20-t3*t5*t6*t8*in_x3*in_x13*in_x17*in_x20*in_x21-t3*t5*t6*t8*in_x3*in_x14*in_x16*in_x20*in_x21+t3*t5*t6*t8*in_x3*in_x14*in_x18*in_x19*in_x20+t3*t5*t6*t8*in_x3*in_x15*in_x17*in_x19*in_x20-t3*t5*t7*t9*in_x4*in_x10*in_x11*in_x20*in_x27+t3*t5*t7*t9*in_x4*in_x10*in_x11*in_x21*in_x26-t3*t5*t7*t9*in_x4*in_x11*in_x12*in_x19*in_x26+t3*t5*t7*t9*in_x4*in_x11*in_x12*in_x20*in_x25+t3*t4*t6*t11*in_x6*in_x10*in_x17*in_x20*in_x21-t3*t4*t6*t11*in_x6*in_x11*in_x16*in_x20*in_x21+t3*t4*t6*t11*in_x6*in_x11*in_x18*in_x19*in_x20-t3*t4*t6*t11*in_x6*in_x12*in_x17*in_x19*in_x20+t3*t4*t9*t10*in_x4*in_x10*in_x11*in_x20*in_x27-t3*t4*t9*t10*in_x4*in_x10*in_x11*in_x21*in_x26+t3*t4*t9*t10*in_x4*in_x11*in_x12*in_x19*in_x26-t3*t4*t9*t10*in_x4*in_x11*in_x12*in_x20*in_x25+t3*t4*t6*t8*in_x7*in_x13*in_x17*in_x20*in_x21+t3*t4*t6*t8*in_x7*in_x14*in_x16*in_x20*in_x21-t3*t4*t6*t8*in_x7*in_x14*in_x18*in_x19*in_x20-t3*t4*t6*t8*in_x7*in_x15*in_x17*in_x19*in_x20+t3*t5*t6*t7*in_x4*in_x13*in_x14*in_x20*in_x27-t3*t5*t6*t7*in_x4*in_x13*in_x14*in_x21*in_x26+t3*t5*t6*t7*in_x4*in_x14*in_x15*in_x19*in_x26-t3*t5*t6*t7*in_x4*in_x14*in_x15*in_x20*in_x25+t3*t5*t6*t11*in_x3*in_x13*in_x17*in_x20*in_x21+t3*t5*t6*t11*in_x3*in_x14*in_x16*in_x20*in_x21-t3*t5*t6*t11*in_x3*in_x14*in_x18*in_x19*in_x20-t3*t5*t6*t11*in_x3*in_x15*in_x17*in_x19*in_x20-t3*t5*t7*t9*in_x5*in_x10*in_x11*in_x23*in_x27+t3*t5*t7*t9*in_x5*in_x10*in_x11*in_x24*in_x26-t3*t5*t7*t9*in_x5*in_x11*in_x12*in_x22*in_x26+t3*t5*t7*t9*in_x5*in_x11*in_x12*in_x23*in_x25+t3*t5*t7*t9*in_x8*in_x10*in_x11*in_x20*in_x27-t3*t5*t7*t9*in_x8*in_x10*in_x11*in_x21*in_x26+t3*t5*t7*t9*in_x8*in_x11*in_x12*in_x19*in_x26-t3*t5*t7*t9*in_x8*in_x11*in_x12*in_x20*in_x25-t3*t8*t9*t10*in_x2*in_x10*in_x17*in_x20*in_x21-t3*t8*t9*t10*in_x2*in_x11*in_x16*in_x20*in_x21+t3*t8*t9*t10*in_x2*in_x11*in_x18*in_x19*in_x20+t3*t8*t9*t10*in_x2*in_x12*in_x17*in_x19*in_x20-t2*t4*t11*t12*in_x4*in_x10*in_x11*in_x20*in_x27+t2*t4*t11*t12*in_x4*in_x10*in_x11*in_x21*in_x26-t2*t4*t11*t12*in_x4*in_x11*in_x12*in_x19*in_x26+t2*t4*t11*t12*in_x4*in_x11*in_x12*in_x20*in_x25-t3*t4*t6*t10*in_x4*in_x13*in_x14*in_x20*in_x27+t3*t4*t6*t10*in_x4*in_x13*in_x14*in_x21*in_x26-t3*t4*t6*t10*in_x4*in_x14*in_x15*in_x19*in_x26+t3*t4*t6*t10*in_x4*in_x14*in_x15*in_x20*in_x25+t3*t7*t8*t9*in_x6*in_x10*in_x17*in_x20*in_x21+t3*t7*t8*t9*in_x6*in_x11*in_x16*in_x20*in_x21-t3*t7*t8*t9*in_x6*in_x11*in_x18*in_x19*in_x20-t3*t7*t8*t9*in_x6*in_x12*in_x17*in_x19*in_x20+t2*t4*t8*t12*in_x8*in_x10*in_x11*in_x20*in_x27-t2*t4*t8*t12*in_x8*in_x10*in_x11*in_x21*in_x26+t2*t4*t8*t12*in_x8*in_x11*in_x12*in_x19*in_x26-t2*t4*t8*t12*in_x8*in_x11*in_x12*in_x20*in_x25+t2*t5*t11*t12*in_x4*in_x10*in_x11*in_x20*in_x27-t2*t5*t11*t12*in_x4*in_x10*in_x11*in_x21*in_x26+t2*t5*t11*t12*in_x4*in_x11*in_x12*in_x19*in_x26-t2*t5*t11*t12*in_x4*in_x11*in_x12*in_x20*in_x25-t3*t4*t6*t11*in_x7*in_x13*in_x17*in_x20*in_x21-t3*t4*t6*t11*in_x7*in_x14*in_x16*in_x20*in_x21+t3*t4*t6*t11*in_x7*in_x14*in_x18*in_x19*in_x20+t3*t4*t6*t11*in_x7*in_x15*in_x17*in_x19*in_x20+t3*t4*t9*t10*in_x5*in_x10*in_x11*in_x23*in_x27-t3*t4*t9*t10*in_x5*in_x10*in_x11*in_x24*in_x26+t3*t4*t9*t10*in_x5*in_x11*in_x12*in_x22*in_x26-t3*t4*t9*t10*in_x5*in_x11*in_x12*in_x23*in_x25-t3*t4*t9*t10*in_x8*in_x10*in_x11*in_x20*in_x27+t3*t4*t9*t10*in_x8*in_x10*in_x11*in_x21*in_x26-t3*t4*t9*t10*in_x8*in_x11*in_x12*in_x19*in_x26+t3*t4*t9*t10*in_x8*in_x11*in_x12*in_x20*in_x25-t2*t5*t8*t12*in_x8*in_x10*in_x11*in_x20*in_x27+t2*t5*t8*t12*in_x8*in_x10*in_x11*in_x21*in_x26-t2*t5*t8*t12*in_x8*in_x11*in_x12*in_x19*in_x26+t2*t5*t8*t12*in_x8*in_x11*in_x12*in_x20*in_x25+t3*t5*t6*t7*in_x5*in_x13*in_x14*in_x23*in_x27-t3*t5*t6*t7*in_x5*in_x13*in_x14*in_x24*in_x26+t3*t5*t6*t7*in_x5*in_x14*in_x15*in_x22*in_x26-t3*t5*t6*t7*in_x5*in_x14*in_x15*in_x23*in_x25-t3*t5*t6*t7*in_x8*in_x13*in_x14*in_x20*in_x27+t3*t5*t6*t7*in_x8*in_x13*in_x14*in_x21*in_x26-t3*t5*t6*t7*in_x8*in_x14*in_x15*in_x19*in_x26+t3*t5*t6*t7*in_x8*in_x14*in_x15*in_x20*in_x25+t3*t5*t6*t13*in_x2*in_x10*in_x17*in_x23*in_x24-t3*t5*t6*t13*in_x2*in_x11*in_x16*in_x23*in_x24+t3*t5*t6*t13*in_x2*in_x11*in_x18*in_x22*in_x23-t3*t5*t6*t13*in_x2*in_x12*in_x17*in_x22*in_x23+t3*t9*t10*t11*in_x2*in_x10*in_x17*in_x20*in_x21+t3*t9*t10*t11*in_x2*in_x11*in_x16*in_x20*in_x21-t3*t9*t10*t11*in_x2*in_x11*in_x18*in_x19*in_x20-t3*t9*t10*t11*in_x2*in_x12*in_x17*in_x19*in_x20+t3*t5*t7*t9*in_x9*in_x10*in_x11*in_x23*in_x27-t3*t5*t7*t9*in_x9*in_x10*in_x11*in_x24*in_x26+t3*t5*t7*t9*in_x9*in_x11*in_x12*in_x22*in_x26-t3*t5*t7*t9*in_x9*in_x11*in_x12*in_x23*in_x25-t3*t7*t9*t11*in_x6*in_x10*in_x17*in_x20*in_x21-t3*t7*t9*t11*in_x6*in_x11*in_x16*in_x20*in_x21+t3*t7*t9*t11*in_x6*in_x11*in_x18*in_x19*in_x20+t3*t7*t9*t11*in_x6*in_x12*in_x17*in_x19*in_x20+t3*t8*t9*t10*in_x3*in_x13*in_x17*in_x20*in_x21-t3*t8*t9*t10*in_x3*in_x14*in_x16*in_x20*in_x21+t3*t8*t9*t10*in_x3*in_x14*in_x18*in_x19*in_x20-t3*t8*t9*t10*in_x3*in_x15*in_x17*in_x19*in_x20-t2*t4*t11*t12*in_x5*in_x10*in_x11*in_x23*in_x27-t2*t4*t11*t12*in_x5*in_x10*in_x11*in_x24*in_x26+t2*t4*t11*t12*in_x5*in_x11*in_x12*in_x22*in_x26+t2*t4*t11*t12*in_x5*in_x11*in_x12*in_x23*in_x25-t3*t4*t6*t10*in_x5*in_x13*in_x14*in_x23*in_x27+t3*t4*t6*t10*in_x5*in_x13*in_x14*in_x24*in_x26-t3*t4*t6*t10*in_x5*in_x14*in_x15*in_x22*in_x26+t3*t4*t6*t10*in_x5*in_x14*in_x15*in_x23*in_x25+t3*t4*t6*t10*in_x8*in_x13*in_x14*in_x20*in_x27-t3*t4*t6*t10*in_x8*in_x13*in_x14*in_x21*in_x26+t3*t4*t6*t10*in_x8*in_x14*in_x15*in_x19*in_x26-t3*t4*t6*t10*in_x8*in_x14*in_x15*in_x20*in_x25-t3*t5*t6*t15*in_x2*in_x10*in_x17*in_x23*in_x24+t3*t5*t6*t15*in_x2*in_x11*in_x16*in_x23*in_x24-t3*t5*t6*t15*in_x2*in_x11*in_x18*in_x22*in_x23+t3*t5*t6*t15*in_x2*in_x12*in_x17*in_x22*in_x23-t3*t7*t8*t9*in_x7*in_x13*in_x17*in_x20*in_x21+t3*t7*t8*t9*in_x7*in_x14*in_x16*in_x20*in_x21-t3*t7*t8*t9*in_x7*in_x14*in_x18*in_x19*in_x20+t3*t7*t8*t9*in_x7*in_x15*in_x17*in_x19*in_x20+t2*t4*t8*t12*in_x9*in_x10*in_x11*in_x23*in_x27+t2*t4*t8*t12*in_x9*in_x10*in_x11*in_x24*in_x26-t2*t4*t8*t12*in_x9*in_x11*in_x12*in_x22*in_x26-t2*t4*t8*t12*in_x9*in_x11*in_x12*in_x23*in_x25+t2*t5*t11*t12*in_x5*in_x10*in_x11*in_x23*in_x27+t2*t5*t11*t12*in_x5*in_x10*in_x11*in_x24*in_x26-t2*t5*t11*t12*in_x5*in_x11*in_x12*in_x22*in_x26-t2*t5*t11*t12*in_x5*in_x11*in_x12*in_x23*in_x25-t3*t4*t6*t13*in_x6*in_x10*in_x17*in_x23*in_x24+t3*t4*t6*t13*in_x6*in_x11*in_x16*in_x23*in_x24-t3*t4*t6*t13*in_x6*in_x11*in_x18*in_x22*in_x23+t3*t4*t6*t13*in_x6*in_x12*in_x17*in_x22*in_x23-t3*t4*t9*t10*in_x9*in_x10*in_x11*in_x23*in_x27+t3*t4*t9*t10*in_x9*in_x10*in_x11*in_x24*in_x26-t3*t4*t9*t10*in_x9*in_x11*in_x12*in_x22*in_x26+t3*t4*t9*t10*in_x9*in_x11*in_x12*in_x23*in_x25-t2*t4*t14*t15*in_x4*in_x10*in_x11*in_x20*in_x27-t2*t4*t14*t15*in_x4*in_x10*in_x11*in_x21*in_x26+t2*t4*t14*t15*in_x4*in_x11*in_x12*in_x19*in_x26+t2*t4*t14*t15*in_x4*in_x11*in_x12*in_x20*in_x25-t2*t5*t8*t12*in_x9*in_x10*in_x11*in_x23*in_x27-t2*t5*t8*t12*in_x9*in_x10*in_x11*in_x24*in_x26+t2*t5*t8*t12*in_x9*in_x11*in_x12*in_x22*in_x26+t2*t5*t8*t12*in_x9*in_x11*in_x12*in_x23*in_x25-t3*t5*t6*t7*in_x9*in_x13*in_x14*in_x23*in_x27+t3*t5*t6*t7*in_x9*in_x13*in_x14*in_x24*in_x26-t3*t5*t6*t7*in_x9*in_x14*in_x15*in_x22*in_x26+t3*t5*t6*t7*in_x9*in_x14*in_x15*in_x23*in_x25-t3*t5*t6*t13*in_x3*in_x13*in_x17*in_x23*in_x24-t3*t5*t6*t13*in_x3*in_x14*in_x16*in_x23*in_x24+t3*t5*t6*t13*in_x3*in_x14*in_x18*in_x22*in_x23+t3*t5*t6*t13*in_x3*in_x15*in_x17*in_x22*in_x23-t3*t9*t10*t11*in_x3*in_x13*in_x17*in_x20*in_x21+t3*t9*t10*t11*in_x3*in_x14*in_x16*in_x20*in_x21-t3*t9*t10*t11*in_x3*in_x14*in_x18*in_x19*in_x20+t3*t9*t10*t11*in_x3*in_x15*in_x17*in_x19*in_x20+t2*t5*t14*t15*in_x4*in_x10*in_x11*in_x20*in_x27+t2*t5*t14*t15*in_x4*in_x10*in_x11*in_x21*in_x26-t2*t5*t14*t15*in_x4*in_x11*in_x12*in_x19*in_x26-t2*t5*t14*t15*in_x4*in_x11*in_x12*in_x20*in_x25+t3*t4*t6*t15*in_x6*in_x10*in_x17*in_x23*in_x24-t3*t4*t6*t15*in_x6*in_x11*in_x16*in_x23*in_x24+t3*t4*t6*t15*in_x6*in_x11*in_x18*in_x22*in_x23-t3*t4*t6*t15*in_x6*in_x12*in_x17*in_x22*in_x23+t3*t7*t9*t11*in_x7*in_x13*in_x17*in_x20*in_x21-t3*t7*t9*t11*in_x7*in_x14*in_x16*in_x20*in_x21+t3*t7*t9*t11*in_x7*in_x14*in_x18*in_x19*in_x20-t3*t7*t9*t11*in_x7*in_x15*in_x17*in_x19*in_x20+t2*t4*t13*t14*in_x8*in_x10*in_x11*in_x20*in_x27+t2*t4*t13*t14*in_x8*in_x10*in_x11*in_x21*in_x26-t2*t4*t13*t14*in_x8*in_x11*in_x12*in_x19*in_x26-t2*t4*t13*t14*in_x8*in_x11*in_x12*in_x20*in_x25-t2*t8*t14*t15*in_x2*in_x10*in_x17*in_x20*in_x21+t2*t8*t14*t15*in_x2*in_x11*in_x16*in_x20*in_x21-t2*t8*t14*t15*in_x2*in_x11*in_x18*in_x19*in_x20+t2*t8*t14*t15*in_x2*in_x12*in_x17*in_x19*in_x20+t3*t4*t6*t10*in_x9*in_x13*in_x14*in_x23*in_x27-t3*t4*t6*t10*in_x9*in_x13*in_x14*in_x24*in_x26+t3*t4*t6*t10*in_x9*in_x14*in_x15*in_x22*in_x26-t3*t4*t6*t10*in_x9*in_x14*in_x15*in_x23*in_x25+t3*t5*t6*t15*in_x3*in_x13*in_x17*in_x23*in_x24+t3*t5*t6*t15*in_x3*in_x14*in_x16*in_x23*in_x24-t3*t5*t6*t15*in_x3*in_x14*in_x18*in_x22*in_x23-t3*t5*t6*t15*in_x3*in_x15*in_x17*in_x22*in_x23-t2*t5*t13*t14*in_x8*in_x10*in_x11*in_x20*in_x27-t2*t5*t13*t14*in_x8*in_x10*in_x11*in_x21*in_x26+t2*t5*t13*t14*in_x8*in_x11*in_x12*in_x19*in_x26+t2*t5*t13*t14*in_x8*in_x11*in_x12*in_x20*in_x25-t2*t7*t11*t12*in_x4*in_x13*in_x14*in_x20*in_x27+t2*t7*t11*t12*in_x4*in_x13*in_x14*in_x21*in_x26-t2*t7*t11*t12*in_x4*in_x14*in_x15*in_x19*in_x26+t2*t7*t11*t12*in_x4*in_x14*in_x15*in_x20*in_x25+t2*t11*t13*t14*in_x2*in_x10*in_x17*in_x20*in_x21-t2*t11*t13*t14*in_x2*in_x11*in_x16*in_x20*in_x21+t2*t11*t13*t14*in_x2*in_x11*in_x18*in_x19*in_x20-t2*t11*t13*t14*in_x2*in_x12*in_x17*in_x19*in_x20+t3*t4*t6*t13*in_x7*in_x13*in_x17*in_x23*in_x24+t3*t4*t6*t13*in_x7*in_x14*in_x16*in_x23*in_x24-t3*t4*t6*t13*in_x7*in_x14*in_x18*in_x22*in_x23-t3*t4*t6*t13*in_x7*in_x15*in_x17*in_x22*in_x23-t2*t4*t14*t15*in_x5*in_x10*in_x11*in_x23*in_x27+t2*t4*t14*t15*in_x5*in_x10*in_x11*in_x24*in_x26-t2*t4*t14*t15*in_x5*in_x11*in_x12*in_x22*in_x26+t2*t4*t14*t15*in_x5*in_x11*in_x12*in_x23*in_x25+t2*t7*t8*t12*in_x8*in_x13*in_x14*in_x20*in_x27-t2*t7*t8*t12*in_x8*in_x13*in_x14*in_x21*in_x26+t2*t7*t8*t12*in_x8*in_x14*in_x15*in_x19*in_x26-t2*t7*t8*t12*in_x8*in_x14*in_x15*in_x20*in_x25-t3*t9*t10*t13*in_x2*in_x10*in_x17*in_x23*in_x24-t3*t9*t10*t13*in_x2*in_x11*in_x16*in_x23*in_x24+t3*t9*t10*t13*in_x2*in_x11*in_x18*in_x22*in_x23+t3*t9*t10*t13*in_x2*in_x12*in_x17*in_x22*in_x23+t2*t5*t14*t15*in_x5*in_x10*in_x11*in_x23*in_x27-t2*t5*t14*t15*in_x5*in_x10*in_x11*in_x24*in_x26+t2*t5*t14*t15*in_x5*in_x11*in_x12*in_x22*in_x26-t2*t5*t14*t15*in_x5*in_x11*in_x12*in_x23*in_x25-t3*t4*t6*t15*in_x7*in_x13*in_x17*in_x23*in_x24-t3*t4*t6*t15*in_x7*in_x14*in_x16*in_x23*in_x24+t3*t4*t6*t15*in_x7*in_x14*in_x18*in_x22*in_x23+t3*t4*t6*t15*in_x7*in_x15*in_x17*in_x22*in_x23+t3*t7*t9*t13*in_x6*in_x10*in_x17*in_x23*in_x24+t3*t7*t9*t13*in_x6*in_x11*in_x16*in_x23*in_x24-t3*t7*t9*t13*in_x6*in_x11*in_x18*in_x22*in_x23-t3*t7*t9*t13*in_x6*in_x12*in_x17*in_x22*in_x23+t2*t4*t13*t14*in_x9*in_x10*in_x11*in_x23*in_x27-t2*t4*t13*t14*in_x9*in_x10*in_x11*in_x24*in_x26+t2*t4*t13*t14*in_x9*in_x11*in_x12*in_x22*in_x26-t2*t4*t13*t14*in_x9*in_x11*in_x12*in_x23*in_x25+t2*t8*t12*t15*in_x2*in_x10*in_x17*in_x23*in_x24-t2*t8*t12*t15*in_x2*in_x11*in_x16*in_x23*in_x24+t2*t8*t12*t15*in_x2*in_x11*in_x18*in_x22*in_x23-t2*t8*t12*t15*in_x2*in_x12*in_x17*in_x22*in_x23-t2*t8*t14*t15*in_x3*in_x13*in_x17*in_x20*in_x21+t2*t8*t14*t15*in_x3*in_x14*in_x16*in_x20*in_x21-t2*t8*t14*t15*in_x3*in_x14*in_x18*in_x19*in_x20+t2*t8*t14*t15*in_x3*in_x15*in_x17*in_x19*in_x20+t2*t8*t14*t15*in_x6*in_x10*in_x17*in_x20*in_x21-t2*t8*t14*t15*in_x6*in_x11*in_x16*in_x20*in_x21+t2*t8*t14*t15*in_x6*in_x11*in_x18*in_x19*in_x20-t2*t8*t14*t15*in_x6*in_x12*in_x17*in_x19*in_x20+t2*t10*t11*t12*in_x4*in_x13*in_x14*in_x20*in_x27-t2*t10*t11*t12*in_x4*in_x13*in_x14*in_x21*in_x26+t2*t10*t11*t12*in_x4*in_x14*in_x15*in_x19*in_x26-t2*t10*t11*t12*in_x4*in_x14*in_x15*in_x20*in_x25+t3*t9*t10*t15*in_x2*in_x10*in_x17*in_x23*in_x24+t3*t9*t10*t15*in_x2*in_x11*in_x16*in_x23*in_x24-t3*t9*t10*t15*in_x2*in_x11*in_x18*in_x22*in_x23-t3*t9*t10*t15*in_x2*in_x12*in_x17*in_x22*in_x23-t5*t6*t8*t12*in_x2*in_x10*in_x17*in_x26*in_x27+t5*t6*t8*t12*in_x2*in_x11*in_x16*in_x26*in_x27-t5*t6*t8*t12*in_x2*in_x11*in_x18*in_x25*in_x26+t5*t6*t8*t12*in_x2*in_x12*in_x17*in_x25*in_x26-t2*t5*t13*t14*in_x9*in_x10*in_x11*in_x23*in_x27+t2*t5*t13*t14*in_x9*in_x10*in_x11*in_x24*in_x26-t2*t5*t13*t14*in_x9*in_x11*in_x12*in_x22*in_x26+t2*t5*t13*t14*in_x9*in_x11*in_x12*in_x23*in_x25-t2*t7*t11*t12*in_x5*in_x13*in_x14*in_x23*in_x27-t2*t7*t11*t12*in_x5*in_x13*in_x14*in_x24*in_x26+t2*t7*t11*t12*in_x5*in_x14*in_x15*in_x22*in_x26+t2*t7*t11*t12*in_x5*in_x14*in_x15*in_x23*in_x25-t2*t8*t10*t12*in_x8*in_x13*in_x14*in_x20*in_x27+t2*t8*t10*t12*in_x8*in_x13*in_x14*in_x21*in_x26-t2*t8*t10*t12*in_x8*in_x14*in_x15*in_x19*in_x26+t2*t8*t10*t12*in_x8*in_x14*in_x15*in_x20*in_x25-t2*t11*t12*t13*in_x2*in_x10*in_x17*in_x23*in_x24+t2*t11*t12*t13*in_x2*in_x11*in_x16*in_x23*in_x24-t2*t11*t12*t13*in_x2*in_x11*in_x18*in_x22*in_x23+t2*t11*t12*t13*in_x2*in_x12*in_x17*in_x22*in_x23+t2*t11*t13*t14*in_x3*in_x13*in_x17*in_x20*in_x21-t2*t11*t13*t14*in_x3*in_x14*in_x16*in_x20*in_x21+t2*t11*t13*t14*in_x3*in_x14*in_x18*in_x19*in_x20-t2*t11*t13*t14*in_x3*in_x15*in_x17*in_x19*in_x20-t2*t11*t13*t14*in_x6*in_x10*in_x17*in_x20*in_x21+t2*t11*t13*t14*in_x6*in_x11*in_x16*in_x20*in_x21-t2*t11*t13*t14*in_x6*in_x11*in_x18*in_x19*in_x20+t2*t11*t13*t14*in_x6*in_x12*in_x17*in_x19*in_x20-t3*t7*t9*t15*in_x6*in_x10*in_x17*in_x23*in_x24-t3*t7*t9*t15*in_x6*in_x11*in_x16*in_x23*in_x24+t3*t7*t9*t15*in_x6*in_x11*in_x18*in_x22*in_x23+t3*t7*t9*t15*in_x6*in_x12*in_x17*in_x22*in_x23+t2*t7*t8*t12*in_x9*in_x13*in_x14*in_x23*in_x27+t2*t7*t8*t12*in_x9*in_x13*in_x14*in_x24*in_x26-t2*t7*t8*t12*in_x9*in_x14*in_x15*in_x22*in_x26-t2*t7*t8*t12*in_x9*in_x14*in_x15*in_x23*in_x25+t3*t9*t10*t13*in_x3*in_x13*in_x17*in_x23*in_x24-t3*t9*t10*t13*in_x3*in_x14*in_x16*in_x23*in_x24+t3*t9*t10*t13*in_x3*in_x14*in_x18*in_x22*in_x23-t3*t9*t10*t13*in_x3*in_x15*in_x17*in_x22*in_x23-t2*t7*t14*t15*in_x4*in_x13*in_x14*in_x20*in_x27-t2*t7*t14*t15*in_x4*in_x13*in_x14*in_x21*in_x26+t2*t7*t14*t15*in_x4*in_x14*in_x15*in_x19*in_x26+t2*t7*t14*t15*in_x4*in_x14*in_x15*in_x20*in_x25-t3*t7*t9*t13*in_x7*in_x13*in_x17*in_x23*in_x24+t3*t7*t9*t13*in_x7*in_x14*in_x16*in_x23*in_x24-t3*t7*t9*t13*in_x7*in_x14*in_x18*in_x22*in_x23+t3*t7*t9*t13*in_x7*in_x15*in_x17*in_x22*in_x23+t4*t6*t8*t12*in_x6*in_x10*in_x17*in_x26*in_x27-t4*t6*t8*t12*in_x6*in_x11*in_x16*in_x26*in_x27+t4*t6*t8*t12*in_x6*in_x11*in_x18*in_x25*in_x26-t4*t6*t8*t12*in_x6*in_x12*in_x17*in_x25*in_x26+t5*t6*t11*t12*in_x2*in_x10*in_x17*in_x26*in_x27-t5*t6*t11*t12*in_x2*in_x11*in_x16*in_x26*in_x27+t5*t6*t11*t12*in_x2*in_x11*in_x18*in_x25*in_x26-t5*t6*t11*t12*in_x2*in_x12*in_x17*in_x25*in_x26+t2*t8*t12*t15*in_x3*in_x13*in_x17*in_x23*in_x24-t2*t8*t12*t15*in_x3*in_x14*in_x16*in_x23*in_x24+t2*t8*t12*t15*in_x3*in_x14*in_x18*in_x22*in_x23-t2*t8*t12*t15*in_x3*in_x15*in_x17*in_x22*in_x23-t2*t8*t12*t15*in_x6*in_x10*in_x17*in_x23*in_x24+t2*t8*t12*t15*in_x6*in_x11*in_x16*in_x23*in_x24-t2*t8*t12*t15*in_x6*in_x11*in_x18*in_x22*in_x23+t2*t8*t12*t15*in_x6*in_x12*in_x17*in_x22*in_x23+t2*t8*t14*t15*in_x7*in_x13*in_x17*in_x20*in_x21-t2*t8*t14*t15*in_x7*in_x14*in_x16*in_x20*in_x21+t2*t8*t14*t15*in_x7*in_x14*in_x18*in_x19*in_x20-t2*t8*t14*t15*in_x7*in_x15*in_x17*in_x19*in_x20+t2*t10*t11*t12*in_x5*in_x13*in_x14*in_x23*in_x27+t2*t10*t11*t12*in_x5*in_x13*in_x14*in_x24*in_x26-t2*t10*t11*t12*in_x5*in_x14*in_x15*in_x22*in_x26-t2*t10*t11*t12*in_x5*in_x14*in_x15*in_x23*in_x25-t3*t9*t10*t15*in_x3*in_x13*in_x17*in_x23*in_x24+t3*t9*t10*t15*in_x3*in_x14*in_x16*in_x23*in_x24-t3*t9*t10*t15*in_x3*in_x14*in_x18*in_x22*in_x23+t3*t9*t10*t15*in_x3*in_x15*in_x17*in_x22*in_x23+t4*t6*t11*t12*in_x4*in_x16*in_x17*in_x20*in_x27-t4*t6*t11*t12*in_x4*in_x16*in_x17*in_x21*in_x26+t4*t6*t11*t12*in_x4*in_x17*in_x18*in_x19*in_x26-t4*t6*t11*t12*in_x4*in_x17*in_x18*in_x20*in_x25+t5*t6*t8*t12*in_x3*in_x13*in_x17*in_x26*in_x27+t5*t6*t8*t12*in_x3*in_x14*in_x16*in_x26*in_x27-t5*t6*t8*t12*in_x3*in_x14*in_x18*in_x25*in_x26-t5*t6*t8*t12*in_x3*in_x15*in_x17*in_x25*in_x26+t2*t7*t13*t14*in_x8*in_x13*in_x14*in_x20*in_x27+t2*t7*t13*t14*in_x8*in_x13*in_x14*in_x21*in_x26-t2*t7*t13*t14*in_x8*in_x14*in_x15*in_x19*in_x26-t2*t7*t13*t14*in_x8*in_x14*in_x15*in_x20*in_x25-t2*t8*t10*t12*in_x9*in_x13*in_x14*in_x23*in_x27-t2*t8*t10*t12*in_x9*in_x13*in_x14*in_x24*in_x26+t2*t8*t10*t12*in_x9*in_x14*in_x15*in_x22*in_x26+t2*t8*t10*t12*in_x9*in_x14*in_x15*in_x23*in_x25-t2*t11*t12*t13*in_x3*in_x13*in_x17*in_x23*in_x24+t2*t11*t12*t13*in_x3*in_x14*in_x16*in_x23*in_x24-t2*t11*t12*t13*in_x3*in_x14*in_x18*in_x22*in_x23+t2*t11*t12*t13*in_x3*in_x15*in_x17*in_x22*in_x23+t2*t11*t12*t13*in_x6*in_x10*in_x17*in_x23*in_x24-t2*t11*t12*t13*in_x6*in_x11*in_x16*in_x23*in_x24+t2*t11*t12*t13*in_x6*in_x11*in_x18*in_x22*in_x23-t2*t11*t12*t13*in_x6*in_x12*in_x17*in_x22*in_x23-t2*t11*t13*t14*in_x7*in_x13*in_x17*in_x20*in_x21+t2*t11*t13*t14*in_x7*in_x14*in_x16*in_x20*in_x21-t2*t11*t13*t14*in_x7*in_x14*in_x18*in_x19*in_x20+t2*t11*t13*t14*in_x7*in_x15*in_x17*in_x19*in_x20+t3*t7*t9*t15*in_x7*in_x13*in_x17*in_x23*in_x24-t3*t7*t9*t15*in_x7*in_x14*in_x16*in_x23*in_x24+t3*t7*t9*t15*in_x7*in_x14*in_x18*in_x22*in_x23-t3*t7*t9*t15*in_x7*in_x15*in_x17*in_x22*in_x23-t4*t6*t8*t12*in_x8*in_x16*in_x17*in_x20*in_x27+t4*t6*t8*t12*in_x8*in_x16*in_x17*in_x21*in_x26-t4*t6*t8*t12*in_x8*in_x17*in_x18*in_x19*in_x26+t4*t6*t8*t12*in_x8*in_x17*in_x18*in_x20*in_x25-t5*t6*t11*t12*in_x4*in_x16*in_x17*in_x20*in_x27+t5*t6*t11*t12*in_x4*in_x16*in_x17*in_x21*in_x26-t5*t6*t11*t12*in_x4*in_x17*in_x18*in_x19*in_x26+t5*t6*t11*t12*in_x4*in_x17*in_x18*in_x20*in_x25+t2*t10*t14*t15*in_x4*in_x13*in_x14*in_x20*in_x27+t2*t10*t14*t15*in_x4*in_x13*in_x14*in_x21*in_x26-t2*t10*t14*t15*in_x4*in_x14*in_x15*in_x19*in_x26-t2*t10*t14*t15*in_x4*in_x14*in_x15*in_x20*in_x25-t4*t6*t11*t12*in_x6*in_x10*in_x17*in_x26*in_x27+t4*t6*t11*t12*in_x6*in_x11*in_x16*in_x26*in_x27-t4*t6*t11*t12*in_x6*in_x11*in_x18*in_x25*in_x26+t4*t6*t11*t12*in_x6*in_x12*in_x17*in_x25*in_x26+t5*t6*t8*t12*in_x8*in_x16*in_x17*in_x20*in_x27-t5*t6*t8*t12*in_x8*in_x16*in_x17*in_x21*in_x26+t5*t6*t8*t12*in_x8*in_x17*in_x18*in_x19*in_x26-t5*t6*t8*t12*in_x8*in_x17*in_x18*in_x20*in_x25-t2*t7*t14*t15*in_x5*in_x13*in_x14*in_x23*in_x27+t2*t7*t14*t15*in_x5*in_x13*in_x14*in_x24*in_x26-t2*t7*t14*t15*in_x5*in_x14*in_x15*in_x22*in_x26+t2*t7*t14*t15*in_x5*in_x14*in_x15*in_x23*in_x25-t4*t6*t8*t12*in_x7*in_x13*in_x17*in_x26*in_x27-t4*t6*t8*t12*in_x7*in_x14*in_x16*in_x26*in_x27+t4*t6*t8*t12*in_x7*in_x14*in_x18*in_x25*in_x26+t4*t6*t8*t12*in_x7*in_x15*in_x17*in_x25*in_x26-t5*t6*t11*t12*in_x3*in_x13*in_x17*in_x26*in_x27-t5*t6*t11*t12*in_x3*in_x14*in_x16*in_x26*in_x27+t5*t6*t11*t12*in_x3*in_x14*in_x18*in_x25*in_x26+t5*t6*t11*t12*in_x3*in_x15*in_x17*in_x25*in_x26-t5*t6*t13*t14*in_x2*in_x10*in_x17*in_x26*in_x27+t5*t6*t13*t14*in_x2*in_x11*in_x16*in_x26*in_x27-t5*t6*t13*t14*in_x2*in_x11*in_x18*in_x25*in_x26+t5*t6*t13*t14*in_x2*in_x12*in_x17*in_x25*in_x26-t2*t8*t12*t15*in_x7*in_x13*in_x17*in_x23*in_x24+t2*t8*t12*t15*in_x7*in_x14*in_x16*in_x23*in_x24-t2*t8*t12*t15*in_x7*in_x14*in_x18*in_x22*in_x23+t2*t8*t12*t15*in_x7*in_x15*in_x17*in_x22*in_x23-t2*t10*t13*t14*in_x8*in_x13*in_x14*in_x20*in_x27-t2*t10*t13*t14*in_x8*in_x13*in_x14*in_x21*in_x26+t2*t10*t13*t14*in_x8*in_x14*in_x15*in_x19*in_x26+t2*t10*t13*t14*in_x8*in_x14*in_x15*in_x20*in_x25+t4*t6*t11*t12*in_x5*in_x16*in_x17*in_x23*in_x27+t4*t6*t11*t12*in_x5*in_x16*in_x17*in_x24*in_x26-t4*t6*t11*t12*in_x5*in_x17*in_x18*in_x22*in_x26-t4*t6*t11*t12*in_x5*in_x17*in_x18*in_x23*in_x25+t8*t9*t10*t12*in_x2*in_x10*in_x17*in_x26*in_x27+t8*t9*t10*t12*in_x2*in_x11*in_x16*in_x26*in_x27-t8*t9*t10*t12*in_x2*in_x11*in_x18*in_x25*in_x26-t8*t9*t10*t12*in_x2*in_x12*in_x17*in_x25*in_x26+t2*t7*t13*t14*in_x9*in_x13*in_x14*in_x23*in_x27-t2*t7*t13*t14*in_x9*in_x13*in_x14*in_x24*in_x26+t2*t7*t13*t14*in_x9*in_x14*in_x15*in_x22*in_x26-t2*t7*t13*t14*in_x9*in_x14*in_x15*in_x23*in_x25+t2*t11*t12*t13*in_x7*in_x13*in_x17*in_x23*in_x24-t2*t11*t12*t13*in_x7*in_x14*in_x16*in_x23*in_x24+t2*t11*t12*t13*in_x7*in_x14*in_x18*in_x22*in_x23-t2*t11*t12*t13*in_x7*in_x15*in_x17*in_x22*in_x23-t4*t6*t8*t12*in_x9*in_x16*in_x17*in_x23*in_x27-t4*t6*t8*t12*in_x9*in_x16*in_x17*in_x24*in_x26+t4*t6*t8*t12*in_x9*in_x17*in_x18*in_x22*in_x26+t4*t6*t8*t12*in_x9*in_x17*in_x18*in_x23*in_x25-t5*t6*t11*t12*in_x5*in_x16*in_x17*in_x23*in_x27-t5*t6*t11*t12*in_x5*in_x16*in_x17*in_x24*in_x26+t5*t6*t11*t12*in_x5*in_x17*in_x18*in_x22*in_x26+t5*t6*t11*t12*in_x5*in_x17*in_x18*in_x23*in_x25+t5*t6*t14*t15*in_x2*in_x10*in_x17*in_x26*in_x27-t5*t6*t14*t15*in_x2*in_x11*in_x16*in_x26*in_x27+t5*t6*t14*t15*in_x2*in_x11*in_x18*in_x25*in_x26-t5*t6*t14*t15*in_x2*in_x12*in_x17*in_x25*in_x26-t7*t8*t9*t12*in_x6*in_x10*in_x17*in_x26*in_x27-t7*t8*t9*t12*in_x6*in_x11*in_x16*in_x26*in_x27+t7*t8*t9*t12*in_x6*in_x11*in_x18*in_x25*in_x26+t7*t8*t9*t12*in_x6*in_x12*in_x17*in_x25*in_x26+t2*t10*t14*t15*in_x5*in_x13*in_x14*in_x23*in_x27-t2*t10*t14*t15*in_x5*in_x13*in_x14*in_x24*in_x26+t2*t10*t14*t15*in_x5*in_x14*in_x15*in_x22*in_x26-t2*t10*t14*t15*in_x5*in_x14*in_x15*in_x23*in_x25+t4*t6*t11*t12*in_x7*in_x13*in_x17*in_x26*in_x27+t4*t6*t11*t12*in_x7*in_x14*in_x16*in_x26*in_x27-t4*t6*t11*t12*in_x7*in_x14*in_x18*in_x25*in_x26-t4*t6*t11*t12*in_x7*in_x15*in_x17*in_x25*in_x26+t4*t6*t13*t14*in_x6*in_x10*in_x17*in_x26*in_x27-t4*t6*t13*t14*in_x6*in_x11*in_x16*in_x26*in_x27+t4*t6*t13*t14*in_x6*in_x11*in_x18*in_x25*in_x26-t4*t6*t13*t14*in_x6*in_x12*in_x17*in_x25*in_x26+t4*t6*t14*t15*in_x4*in_x16*in_x17*in_x20*in_x27+t4*t6*t14*t15*in_x4*in_x16*in_x17*in_x21*in_x26-t4*t6*t14*t15*in_x4*in_x17*in_x18*in_x19*in_x26-t4*t6*t14*t15*in_x4*in_x17*in_x18*in_x20*in_x25+t5*t6*t8*t12*in_x9*in_x16*in_x17*in_x23*in_x27+t5*t6*t8*t12*in_x9*in_x16*in_x17*in_x24*in_x26-t5*t6*t8*t12*in_x9*in_x17*in_x18*in_x22*in_x26-t5*t6*t8*t12*in_x9*in_x17*in_x18*in_x23*in_x25+t7*t9*t11*t12*in_x4*in_x16*in_x17*in_x20*in_x27-t7*t9*t11*t12*in_x4*in_x16*in_x17*in_x21*in_x26+t7*t9*t11*t12*in_x4*in_x17*in_x18*in_x19*in_x26-t7*t9*t11*t12*in_x4*in_x17*in_x18*in_x20*in_x25+t5*t6*t13*t14*in_x3*in_x13*in_x17*in_x26*in_x27+t5*t6*t13*t14*in_x3*in_x14*in_x16*in_x26*in_x27-t5*t6*t13*t14*in_x3*in_x14*in_x18*in_x25*in_x26-t5*t6*t13*t14*in_x3*in_x15*in_x17*in_x25*in_x26-t5*t6*t14*t15*in_x4*in_x16*in_x17*in_x20*in_x27-t5*t6*t14*t15*in_x4*in_x16*in_x17*in_x21*in_x26+t5*t6*t14*t15*in_x4*in_x17*in_x18*in_x19*in_x26+t5*t6*t14*t15*in_x4*in_x17*in_x18*in_x20*in_x25-t7*t8*t9*t12*in_x8*in_x16*in_x17*in_x20*in_x27+t7*t8*t9*t12*in_x8*in_x16*in_x17*in_x21*in_x26-t7*t8*t9*t12*in_x8*in_x17*in_x18*in_x19*in_x26+t7*t8*t9*t12*in_x8*in_x17*in_x18*in_x20*in_x25-t9*t10*t11*t12*in_x2*in_x10*in_x17*in_x26*in_x27-t9*t10*t11*t12*in_x2*in_x11*in_x16*in_x26*in_x27+t9*t10*t11*t12*in_x2*in_x11*in_x18*in_x25*in_x26+t9*t10*t11*t12*in_x2*in_x12*in_x17*in_x25*in_x26-t2*t10*t13*t14*in_x9*in_x13*in_x14*in_x23*in_x27+t2*t10*t13*t14*in_x9*in_x13*in_x14*in_x24*in_x26-t2*t10*t13*t14*in_x9*in_x14*in_x15*in_x22*in_x26+t2*t10*t13*t14*in_x9*in_x14*in_x15*in_x23*in_x25-t4*t6*t13*t14*in_x8*in_x16*in_x17*in_x20*in_x27-t4*t6*t13*t14*in_x8*in_x16*in_x17*in_x21*in_x26+t4*t6*t13*t14*in_x8*in_x17*in_x18*in_x19*in_x26+t4*t6*t13*t14*in_x8*in_x17*in_x18*in_x20*in_x25-t4*t6*t14*t15*in_x6*in_x10*in_x17*in_x26*in_x27+t4*t6*t14*t15*in_x6*in_x11*in_x16*in_x26*in_x27-t4*t6*t14*t15*in_x6*in_x11*in_x18*in_x25*in_x26+t4*t6*t14*t15*in_x6*in_x12*in_x17*in_x25*in_x26+t7*t9*t11*t12*in_x6*in_x10*in_x17*in_x26*in_x27+t7*t9*t11*t12*in_x6*in_x11*in_x16*in_x26*in_x27-t7*t9*t11*t12*in_x6*in_x11*in_x18*in_x25*in_x26-t7*t9*t11*t12*in_x6*in_x12*in_x17*in_x25*in_x26-t8*t9*t10*t12*in_x3*in_x13*in_x17*in_x26*in_x27+t8*t9*t10*t12*in_x3*in_x14*in_x16*in_x26*in_x27-t8*t9*t10*t12*in_x3*in_x14*in_x18*in_x25*in_x26+t8*t9*t10*t12*in_x3*in_x15*in_x17*in_x25*in_x26+t5*t6*t13*t14*in_x8*in_x16*in_x17*in_x20*in_x27+t5*t6*t13*t14*in_x8*in_x16*in_x17*in_x21*in_x26-t5*t6*t13*t14*in_x8*in_x17*in_x18*in_x19*in_x26-t5*t6*t13*t14*in_x8*in_x17*in_x18*in_x20*in_x25-t5*t6*t14*t15*in_x3*in_x13*in_x17*in_x26*in_x27-t5*t6*t14*t15*in_x3*in_x14*in_x16*in_x26*in_x27+t5*t6*t14*t15*in_x3*in_x14*in_x18*in_x25*in_x26+t5*t6*t14*t15*in_x3*in_x15*in_x17*in_x25*in_x26+t7*t8*t9*t12*in_x7*in_x13*in_x17*in_x26*in_x27-t7*t8*t9*t12*in_x7*in_x14*in_x16*in_x26*in_x27+t7*t8*t9*t12*in_x7*in_x14*in_x18*in_x25*in_x26-t7*t8*t9*t12*in_x7*in_x15*in_x17*in_x25*in_x26-t9*t10*t11*t12*in_x4*in_x16*in_x17*in_x20*in_x27+t9*t10*t11*t12*in_x4*in_x16*in_x17*in_x21*in_x26-t9*t10*t11*t12*in_x4*in_x17*in_x18*in_x19*in_x26+t9*t10*t11*t12*in_x4*in_x17*in_x18*in_x20*in_x25-t4*t6*t13*t14*in_x7*in_x13*in_x17*in_x26*in_x27-t4*t6*t13*t14*in_x7*in_x14*in_x16*in_x26*in_x27+t4*t6*t13*t14*in_x7*in_x14*in_x18*in_x25*in_x26+t4*t6*t13*t14*in_x7*in_x15*in_x17*in_x25*in_x26+t4*t6*t14*t15*in_x5*in_x16*in_x17*in_x23*in_x27-t4*t6*t14*t15*in_x5*in_x16*in_x17*in_x24*in_x26+t4*t6*t14*t15*in_x5*in_x17*in_x18*in_x22*in_x26-t4*t6*t14*t15*in_x5*in_x17*in_x18*in_x23*in_x25+t7*t9*t11*t12*in_x5*in_x16*in_x17*in_x23*in_x27+t7*t9*t11*t12*in_x5*in_x16*in_x17*in_x24*in_x26-t7*t9*t11*t12*in_x5*in_x17*in_x18*in_x22*in_x26-t7*t9*t11*t12*in_x5*in_x17*in_x18*in_x23*in_x25+t8*t9*t10*t12*in_x8*in_x16*in_x17*in_x20*in_x27-t8*t9*t10*t12*in_x8*in_x16*in_x17*in_x21*in_x26+t8*t9*t10*t12*in_x8*in_x17*in_x18*in_x19*in_x26-t8*t9*t10*t12*in_x8*in_x17*in_x18*in_x20*in_x25-t5*t6*t14*t15*in_x5*in_x16*in_x17*in_x23*in_x27+t5*t6*t14*t15*in_x5*in_x16*in_x17*in_x24*in_x26-t5*t6*t14*t15*in_x5*in_x17*in_x18*in_x22*in_x26+t5*t6*t14*t15*in_x5*in_x17*in_x18*in_x23*in_x25-t7*t8*t9*t12*in_x9*in_x16*in_x17*in_x23*in_x27-t7*t8*t9*t12*in_x9*in_x16*in_x17*in_x24*in_x26+t7*t8*t9*t12*in_x9*in_x17*in_x18*in_x22*in_x26+t7*t8*t9*t12*in_x9*in_x17*in_x18*in_x23*in_x25+t9*t10*t11*t12*in_x3*in_x13*in_x17*in_x26*in_x27-t9*t10*t11*t12*in_x3*in_x14*in_x16*in_x26*in_x27+t9*t10*t11*t12*in_x3*in_x14*in_x18*in_x25*in_x26-t9*t10*t11*t12*in_x3*in_x15*in_x17*in_x25*in_x26+t9*t10*t13*t14*in_x2*in_x10*in_x17*in_x26*in_x27+t9*t10*t13*t14*in_x2*in_x11*in_x16*in_x26*in_x27-t9*t10*t13*t14*in_x2*in_x11*in_x18*in_x25*in_x26-t9*t10*t13*t14*in_x2*in_x12*in_x17*in_x25*in_x26-t4*t6*t13*t14*in_x9*in_x16*in_x17*in_x23*in_x27+t4*t6*t13*t14*in_x9*in_x16*in_x17*in_x24*in_x26-t4*t6*t13*t14*in_x9*in_x17*in_x18*in_x22*in_x26+t4*t6*t13*t14*in_x9*in_x17*in_x18*in_x23*in_x25+t4*t6*t14*t15*in_x7*in_x13*in_x17*in_x26*in_x27+t4*t6*t14*t15*in_x7*in_x14*in_x16*in_x26*in_x27-t4*t6*t14*t15*in_x7*in_x14*in_x18*in_x25*in_x26-t4*t6*t14*t15*in_x7*in_x15*in_x17*in_x25*in_x26-t7*t9*t11*t12*in_x7*in_x13*in_x17*in_x26*in_x27+t7*t9*t11*t12*in_x7*in_x14*in_x16*in_x26*in_x27-t7*t9*t11*t12*in_x7*in_x14*in_x18*in_x25*in_x26+t7*t9*t11*t12*in_x7*in_x15*in_x17*in_x25*in_x26-t7*t9*t13*t14*in_x6*in_x10*in_x17*in_x26*in_x27-t7*t9*t13*t14*in_x6*in_x11*in_x16*in_x26*in_x27+t7*t9*t13*t14*in_x6*in_x11*in_x18*in_x25*in_x26+t7*t9*t13*t14*in_x6*in_x12*in_x17*in_x25*in_x26+t7*t9*t14*t15*in_x4*in_x16*in_x17*in_x20*in_x27+t7*t9*t14*t15*in_x4*in_x16*in_x17*in_x21*in_x26-t7*t9*t14*t15*in_x4*in_x17*in_x18*in_x19*in_x26-t7*t9*t14*t15*in_x4*in_x17*in_x18*in_x20*in_x25+t5*t6*t13*t14*in_x9*in_x16*in_x17*in_x23*in_x27-t5*t6*t13*t14*in_x9*in_x16*in_x17*in_x24*in_x26+t5*t6*t13*t14*in_x9*in_x17*in_x18*in_x22*in_x26-t5*t6*t13*t14*in_x9*in_x17*in_x18*in_x23*in_x25-t9*t10*t11*t12*in_x5*in_x16*in_x17*in_x23*in_x27-t9*t10*t11*t12*in_x5*in_x16*in_x17*in_x24*in_x26+t9*t10*t11*t12*in_x5*in_x17*in_x18*in_x22*in_x26+t9*t10*t11*t12*in_x5*in_x17*in_x18*in_x23*in_x25-t9*t10*t14*t15*in_x2*in_x10*in_x17*in_x26*in_x27-t9*t10*t14*t15*in_x2*in_x11*in_x16*in_x26*in_x27+t9*t10*t14*t15*in_x2*in_x11*in_x18*in_x25*in_x26+t9*t10*t14*t15*in_x2*in_x12*in_x17*in_x25*in_x26-t7*t9*t13*t14*in_x8*in_x16*in_x17*in_x20*in_x27-t7*t9*t13*t14*in_x8*in_x16*in_x17*in_x21*in_x26+t7*t9*t13*t14*in_x8*in_x17*in_x18*in_x19*in_x26+t7*t9*t13*t14*in_x8*in_x17*in_x18*in_x20*in_x25+t7*t9*t14*t15*in_x6*in_x10*in_x17*in_x26*in_x27+t7*t9*t14*t15*in_x6*in_x11*in_x16*in_x26*in_x27-t7*t9*t14*t15*in_x6*in_x11*in_x18*in_x25*in_x26-t7*t9*t14*t15*in_x6*in_x12*in_x17*in_x25*in_x26+t8*t9*t10*t12*in_x9*in_x16*in_x17*in_x23*in_x27+t8*t9*t10*t12*in_x9*in_x16*in_x17*in_x24*in_x26-t8*t9*t10*t12*in_x9*in_x17*in_x18*in_x22*in_x26-t8*t9*t10*t12*in_x9*in_x17*in_x18*in_x23*in_x25-t9*t10*t13*t14*in_x3*in_x13*in_x17*in_x26*in_x27+t9*t10*t13*t14*in_x3*in_x14*in_x16*in_x26*in_x27-t9*t10*t13*t14*in_x3*in_x14*in_x18*in_x25*in_x26+t9*t10*t13*t14*in_x3*in_x15*in_x17*in_x25*in_x26-t9*t10*t14*t15*in_x4*in_x16*in_x17*in_x20*in_x27-t9*t10*t14*t15*in_x4*in_x16*in_x17*in_x21*in_x26+t9*t10*t14*t15*in_x4*in_x17*in_x18*in_x19*in_x26+t9*t10*t14*t15*in_x4*in_x17*in_x18*in_x20*in_x25+t7*t9*t13*t14*in_x7*in_x13*in_x17*in_x26*in_x27-t7*t9*t13*t14*in_x7*in_x14*in_x16*in_x26*in_x27+t7*t9*t13*t14*in_x7*in_x14*in_x18*in_x25*in_x26-t7*t9*t13*t14*in_x7*in_x15*in_x17*in_x25*in_x26+t7*t9*t14*t15*in_x5*in_x16*in_x17*in_x23*in_x27-t7*t9*t14*t15*in_x5*in_x16*in_x17*in_x24*in_x26+t7*t9*t14*t15*in_x5*in_x17*in_x18*in_x22*in_x26-t7*t9*t14*t15*in_x5*in_x17*in_x18*in_x23*in_x25+t9*t10*t13*t14*in_x8*in_x16*in_x17*in_x20*in_x27+t9*t10*t13*t14*in_x8*in_x16*in_x17*in_x21*in_x26-t9*t10*t13*t14*in_x8*in_x17*in_x18*in_x19*in_x26-t9*t10*t13*t14*in_x8*in_x17*in_x18*in_x20*in_x25+t9*t10*t14*t15*in_x3*in_x13*in_x17*in_x26*in_x27-t9*t10*t14*t15*in_x3*in_x14*in_x16*in_x26*in_x27+t9*t10*t14*t15*in_x3*in_x14*in_x18*in_x25*in_x26-t9*t10*t14*t15*in_x3*in_x15*in_x17*in_x25*in_x26-t7*t9*t13*t14*in_x9*in_x16*in_x17*in_x23*in_x27+t7*t9*t13*t14*in_x9*in_x16*in_x17*in_x24*in_x26-t7*t9*t13*t14*in_x9*in_x17*in_x18*in_x22*in_x26+t7*t9*t13*t14*in_x9*in_x17*in_x18*in_x23*in_x25-t7*t9*t14*t15*in_x7*in_x13*in_x17*in_x26*in_x27+t7*t9*t14*t15*in_x7*in_x14*in_x16*in_x26*in_x27-t7*t9*t14*t15*in_x7*in_x14*in_x18*in_x25*in_x26+t7*t9*t14*t15*in_x7*in_x15*in_x17*in_x25*in_x26-t9*t10*t14*t15*in_x5*in_x16*in_x17*in_x23*in_x27+t9*t10*t14*t15*in_x5*in_x16*in_x17*in_x24*in_x26-t9*t10*t14*t15*in_x5*in_x17*in_x18*in_x22*in_x26+t9*t10*t14*t15*in_x5*in_x17*in_x18*in_x23*in_x25+t9*t10*t13*t14*in_x9*in_x16*in_x17*in_x23*in_x27-t9*t10*t13*t14*in_x9*in_x16*in_x17*in_x24*in_x26+t9*t10*t13*t14*in_x9*in_x17*in_x18*in_x22*in_x26-t9*t10*t13*t14*in_x9*in_x17*in_x18*in_x23*in_x25-t3*t5*t6*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x27+t3*t5*t6*in_x2*in_x3*in_x4*in_x10*in_x14*in_x21*in_x26+t3*t5*t6*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x27-t3*t5*t6*in_x2*in_x3*in_x4*in_x11*in_x13*in_x21*in_x26+t3*t5*t6*in_x2*in_x3*in_x4*in_x11*in_x15*in_x19*in_x26-t3*t5*t6*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x25-t3*t5*t6*in_x2*in_x3*in_x4*in_x12*in_x14*in_x19*in_x26+t3*t5*t6*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x25+t3*t5*t6*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x24+t3*t5*t6*in_x2*in_x4*in_x5*in_x10*in_x17*in_x21*in_x23-t3*t5*t6*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x24-t3*t5*t6*in_x2*in_x4*in_x5*in_x11*in_x16*in_x21*in_x23+t3*t5*t6*in_x2*in_x4*in_x5*in_x11*in_x18*in_x19*in_x23+t3*t5*t6*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x22-t3*t5*t6*in_x2*in_x4*in_x5*in_x12*in_x17*in_x19*in_x23-t3*t5*t6*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x22-t3*t5*t6*in_x2*in_x3*in_x5*in_x10*in_x14*in_x23*in_x27+t3*t5*t6*in_x2*in_x3*in_x5*in_x10*in_x14*in_x24*in_x26+t3*t5*t6*in_x2*in_x3*in_x5*in_x11*in_x13*in_x23*in_x27-t3*t5*t6*in_x2*in_x3*in_x5*in_x11*in_x13*in_x24*in_x26+t3*t5*t6*in_x2*in_x3*in_x5*in_x11*in_x15*in_x22*in_x26-t3*t5*t6*in_x2*in_x3*in_x5*in_x11*in_x15*in_x23*in_x25-t3*t5*t6*in_x2*in_x3*in_x5*in_x12*in_x14*in_x22*in_x26+t3*t5*t6*in_x2*in_x3*in_x5*in_x12*in_x14*in_x23*in_x25+t3*t5*t6*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x27-t3*t5*t6*in_x2*in_x3*in_x8*in_x10*in_x14*in_x21*in_x26-t3*t5*t6*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x27+t3*t5*t6*in_x2*in_x3*in_x8*in_x11*in_x13*in_x21*in_x26-t3*t5*t6*in_x2*in_x3*in_x8*in_x11*in_x15*in_x19*in_x26+t3*t5*t6*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x25+t3*t5*t6*in_x2*in_x3*in_x8*in_x12*in_x14*in_x19*in_x26-t3*t5*t6*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x25-t3*t4*t6*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x24-t3*t4*t6*in_x4*in_x5*in_x6*in_x10*in_x17*in_x21*in_x23+t3*t4*t6*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x24+t3*t4*t6*in_x4*in_x5*in_x6*in_x11*in_x16*in_x21*in_x23-t3*t4*t6*in_x4*in_x5*in_x6*in_x11*in_x18*in_x19*in_x23-t3*t4*t6*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x22+t3*t4*t6*in_x4*in_x5*in_x6*in_x12*in_x17*in_x19*in_x23+t3*t4*t6*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x22-t3*t6*t8*in_x2*in_x3*in_x6*in_x13*in_x17*in_x20*in_x21*2.0+t3*t6*t8*in_x2*in_x3*in_x6*in_x14*in_x16*in_x20*in_x21*2.0-t3*t6*t8*in_x2*in_x3*in_x6*in_x14*in_x18*in_x19*in_x20*2.0+t3*t6*t8*in_x2*in_x3*in_x6*in_x15*in_x17*in_x19*in_x20*2.0-t3*t5*t6*in_x2*in_x4*in_x9*in_x10*in_x17*in_x20*in_x24*2.0+t3*t5*t6*in_x2*in_x4*in_x9*in_x10*in_x17*in_x21*in_x23*2.0+t3*t5*t6*in_x2*in_x4*in_x9*in_x11*in_x16*in_x20*in_x24*2.0-t3*t5*t6*in_x2*in_x4*in_x9*in_x11*in_x16*in_x21*in_x23*2.0+t3*t5*t6*in_x2*in_x4*in_x9*in_x11*in_x18*in_x19*in_x23*2.0-t3*t5*t6*in_x2*in_x4*in_x9*in_x11*in_x18*in_x20*in_x22*2.0-t3*t5*t6*in_x2*in_x4*in_x9*in_x12*in_x17*in_x19*in_x23*2.0+t3*t5*t6*in_x2*in_x4*in_x9*in_x12*in_x17*in_x20*in_x22*2.0+t3*t5*t6*in_x2*in_x5*in_x8*in_x10*in_x17*in_x20*in_x24*2.0-t3*t5*t6*in_x2*in_x5*in_x8*in_x10*in_x17*in_x21*in_x23*2.0-t3*t5*t6*in_x2*in_x5*in_x8*in_x11*in_x16*in_x20*in_x24*2.0+t3*t5*t6*in_x2*in_x5*in_x8*in_x11*in_x16*in_x21*in_x23*2.0-t3*t5*t6*in_x2*in_x5*in_x8*in_x11*in_x18*in_x19*in_x23*2.0+t3*t5*t6*in_x2*in_x5*in_x8*in_x11*in_x18*in_x20*in_x22*2.0+t3*t5*t6*in_x2*in_x5*in_x8*in_x12*in_x17*in_x19*in_x23*2.0-t3*t5*t6*in_x2*in_x5*in_x8*in_x12*in_x17*in_x20*in_x22*2.0-t3*t5*t6*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x24-t3*t5*t6*in_x3*in_x4*in_x5*in_x13*in_x17*in_x21*in_x23-t3*t5*t6*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x24-t3*t5*t6*in_x3*in_x4*in_x5*in_x14*in_x16*in_x21*in_x23+t3*t5*t6*in_x3*in_x4*in_x5*in_x14*in_x18*in_x19*in_x23+t3*t5*t6*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x22+t3*t5*t6*in_x3*in_x4*in_x5*in_x15*in_x17*in_x19*in_x23+t3*t5*t6*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x22-t3*t8*t9*in_x2*in_x3*in_x7*in_x10*in_x17*in_x20*in_x21*2.0+t3*t8*t9*in_x2*in_x3*in_x7*in_x11*in_x16*in_x20*in_x21*2.0-t3*t8*t9*in_x2*in_x3*in_x7*in_x11*in_x18*in_x19*in_x20*2.0+t3*t8*t9*in_x2*in_x3*in_x7*in_x12*in_x17*in_x19*in_x20*2.0+t3*t4*t6*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x27-t3*t4*t6*in_x4*in_x6*in_x7*in_x10*in_x14*in_x21*in_x26-t3*t4*t6*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x27+t3*t4*t6*in_x4*in_x6*in_x7*in_x11*in_x13*in_x21*in_x26-t3*t4*t6*in_x4*in_x6*in_x7*in_x11*in_x15*in_x19*in_x26+t3*t4*t6*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x25+t3*t4*t6*in_x4*in_x6*in_x7*in_x12*in_x14*in_x19*in_x26-t3*t4*t6*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x25+t3*t5*t6*in_x2*in_x3*in_x9*in_x10*in_x14*in_x23*in_x27-t3*t5*t6*in_x2*in_x3*in_x9*in_x10*in_x14*in_x24*in_x26-t3*t5*t6*in_x2*in_x3*in_x9*in_x11*in_x13*in_x23*in_x27+t3*t5*t6*in_x2*in_x3*in_x9*in_x11*in_x13*in_x24*in_x26-t3*t5*t6*in_x2*in_x3*in_x9*in_x11*in_x15*in_x22*in_x26+t3*t5*t6*in_x2*in_x3*in_x9*in_x11*in_x15*in_x23*in_x25+t3*t5*t6*in_x2*in_x3*in_x9*in_x12*in_x14*in_x22*in_x26-t3*t5*t6*in_x2*in_x3*in_x9*in_x12*in_x14*in_x23*in_x25+t3*t6*t11*in_x2*in_x3*in_x6*in_x13*in_x17*in_x20*in_x21*2.0-t3*t6*t11*in_x2*in_x3*in_x6*in_x14*in_x16*in_x20*in_x21*2.0+t3*t6*t11*in_x2*in_x3*in_x6*in_x14*in_x18*in_x19*in_x20*2.0-t3*t6*t11*in_x2*in_x3*in_x6*in_x15*in_x17*in_x19*in_x20*2.0+t3*t9*t10*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x27-t3*t9*t10*in_x2*in_x3*in_x4*in_x10*in_x14*in_x21*in_x26-t3*t9*t10*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x27+t3*t9*t10*in_x2*in_x3*in_x4*in_x11*in_x13*in_x21*in_x26-t3*t9*t10*in_x2*in_x3*in_x4*in_x11*in_x15*in_x19*in_x26+t3*t9*t10*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x25+t3*t9*t10*in_x2*in_x3*in_x4*in_x12*in_x14*in_x19*in_x26-t3*t9*t10*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x25+t3*t4*t6*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x24+t3*t4*t6*in_x4*in_x5*in_x7*in_x13*in_x17*in_x21*in_x23+t3*t4*t6*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x24+t3*t4*t6*in_x4*in_x5*in_x7*in_x14*in_x16*in_x21*in_x23-t3*t4*t6*in_x4*in_x5*in_x7*in_x14*in_x18*in_x19*in_x23-t3*t4*t6*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x22-t3*t4*t6*in_x4*in_x5*in_x7*in_x15*in_x17*in_x19*in_x23-t3*t4*t6*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x22+t3*t4*t6*in_x4*in_x6*in_x9*in_x10*in_x17*in_x20*in_x24*2.0-t3*t4*t6*in_x4*in_x6*in_x9*in_x10*in_x17*in_x21*in_x23*2.0-t3*t4*t6*in_x4*in_x6*in_x9*in_x11*in_x16*in_x20*in_x24*2.0+t3*t4*t6*in_x4*in_x6*in_x9*in_x11*in_x16*in_x21*in_x23*2.0-t3*t4*t6*in_x4*in_x6*in_x9*in_x11*in_x18*in_x19*in_x23*2.0+t3*t4*t6*in_x4*in_x6*in_x9*in_x11*in_x18*in_x20*in_x22*2.0+t3*t4*t6*in_x4*in_x6*in_x9*in_x12*in_x17*in_x19*in_x23*2.0-t3*t4*t6*in_x4*in_x6*in_x9*in_x12*in_x17*in_x20*in_x22*2.0-t3*t4*t6*in_x5*in_x6*in_x8*in_x10*in_x17*in_x20*in_x24*2.0+t3*t4*t6*in_x5*in_x6*in_x8*in_x10*in_x17*in_x21*in_x23*2.0+t3*t4*t6*in_x5*in_x6*in_x8*in_x11*in_x16*in_x20*in_x24*2.0-t3*t4*t6*in_x5*in_x6*in_x8*in_x11*in_x16*in_x21*in_x23*2.0+t3*t4*t6*in_x5*in_x6*in_x8*in_x11*in_x18*in_x19*in_x23*2.0-t3*t4*t6*in_x5*in_x6*in_x8*in_x11*in_x18*in_x20*in_x22*2.0-t3*t4*t6*in_x5*in_x6*in_x8*in_x12*in_x17*in_x19*in_x23*2.0+t3*t4*t6*in_x5*in_x6*in_x8*in_x12*in_x17*in_x20*in_x22*2.0+t3*t6*t8*in_x2*in_x6*in_x7*in_x13*in_x17*in_x20*in_x21*2.0-t3*t6*t8*in_x2*in_x6*in_x7*in_x14*in_x16*in_x20*in_x21*2.0+t3*t6*t8*in_x2*in_x6*in_x7*in_x14*in_x18*in_x19*in_x20*2.0-t3*t6*t8*in_x2*in_x6*in_x7*in_x15*in_x17*in_x19*in_x20*2.0+t3*t9*t11*in_x2*in_x3*in_x7*in_x10*in_x17*in_x20*in_x21*2.0-t3*t9*t11*in_x2*in_x3*in_x7*in_x11*in_x16*in_x20*in_x21*2.0+t3*t9*t11*in_x2*in_x3*in_x7*in_x11*in_x18*in_x19*in_x20*2.0-t3*t9*t11*in_x2*in_x3*in_x7*in_x12*in_x17*in_x19*in_x20*2.0-t3*t5*t6*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24-t3*t5*t6*in_x2*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23+t3*t5*t6*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24+t3*t5*t6*in_x2*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23-t3*t5*t6*in_x2*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23-t3*t5*t6*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22+t3*t5*t6*in_x2*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23+t3*t5*t6*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t3*t5*t6*in_x3*in_x4*in_x9*in_x13*in_x17*in_x20*in_x24*2.0-t3*t5*t6*in_x3*in_x4*in_x9*in_x13*in_x17*in_x21*in_x23*2.0+t3*t5*t6*in_x3*in_x4*in_x9*in_x14*in_x16*in_x20*in_x24*2.0-t3*t5*t6*in_x3*in_x4*in_x9*in_x14*in_x16*in_x21*in_x23*2.0+t3*t5*t6*in_x3*in_x4*in_x9*in_x14*in_x18*in_x19*in_x23*2.0-t3*t5*t6*in_x3*in_x4*in_x9*in_x14*in_x18*in_x20*in_x22*2.0+t3*t5*t6*in_x3*in_x4*in_x9*in_x15*in_x17*in_x19*in_x23*2.0-t3*t5*t6*in_x3*in_x4*in_x9*in_x15*in_x17*in_x20*in_x22*2.0-t3*t5*t6*in_x3*in_x5*in_x8*in_x13*in_x17*in_x20*in_x24*2.0+t3*t5*t6*in_x3*in_x5*in_x8*in_x13*in_x17*in_x21*in_x23*2.0-t3*t5*t6*in_x3*in_x5*in_x8*in_x14*in_x16*in_x20*in_x24*2.0+t3*t5*t6*in_x3*in_x5*in_x8*in_x14*in_x16*in_x21*in_x23*2.0-t3*t5*t6*in_x3*in_x5*in_x8*in_x14*in_x18*in_x19*in_x23*2.0+t3*t5*t6*in_x3*in_x5*in_x8*in_x14*in_x18*in_x20*in_x22*2.0-t3*t5*t6*in_x3*in_x5*in_x8*in_x15*in_x17*in_x19*in_x23*2.0+t3*t5*t6*in_x3*in_x5*in_x8*in_x15*in_x17*in_x20*in_x22*2.0+t3*t8*t9*in_x3*in_x6*in_x7*in_x10*in_x17*in_x20*in_x21*2.0-t3*t8*t9*in_x3*in_x6*in_x7*in_x11*in_x16*in_x20*in_x21*2.0+t3*t8*t9*in_x3*in_x6*in_x7*in_x11*in_x18*in_x19*in_x20*2.0-t3*t8*t9*in_x3*in_x6*in_x7*in_x12*in_x17*in_x19*in_x20*2.0-t3*t9*t10*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x24-t3*t9*t10*in_x2*in_x4*in_x5*in_x10*in_x17*in_x21*in_x23-t3*t9*t10*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x24-t3*t9*t10*in_x2*in_x4*in_x5*in_x11*in_x16*in_x21*in_x23+t3*t9*t10*in_x2*in_x4*in_x5*in_x11*in_x18*in_x19*in_x23+t3*t9*t10*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x22+t3*t9*t10*in_x2*in_x4*in_x5*in_x12*in_x17*in_x19*in_x23+t3*t9*t10*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x22-t2*t11*t12*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x27+t2*t11*t12*in_x2*in_x3*in_x4*in_x10*in_x14*in_x21*in_x26-t2*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x27+t2*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x13*in_x21*in_x26-t2*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x15*in_x19*in_x26+t2*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x25-t2*t11*t12*in_x2*in_x3*in_x4*in_x12*in_x14*in_x19*in_x26+t2*t11*t12*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x25+t3*t4*t6*in_x5*in_x6*in_x7*in_x10*in_x14*in_x23*in_x27-t3*t4*t6*in_x5*in_x6*in_x7*in_x10*in_x14*in_x24*in_x26-t3*t4*t6*in_x5*in_x6*in_x7*in_x11*in_x13*in_x23*in_x27+t3*t4*t6*in_x5*in_x6*in_x7*in_x11*in_x13*in_x24*in_x26-t3*t4*t6*in_x5*in_x6*in_x7*in_x11*in_x15*in_x22*in_x26+t3*t4*t6*in_x5*in_x6*in_x7*in_x11*in_x15*in_x23*in_x25+t3*t4*t6*in_x5*in_x6*in_x7*in_x12*in_x14*in_x22*in_x26-t3*t4*t6*in_x5*in_x6*in_x7*in_x12*in_x14*in_x23*in_x25-t3*t4*t6*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27+t3*t4*t6*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26+t3*t4*t6*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27-t3*t4*t6*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26+t3*t4*t6*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26-t3*t4*t6*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25-t3*t4*t6*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26+t3*t4*t6*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25+t3*t7*t9*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x24+t3*t7*t9*in_x4*in_x5*in_x6*in_x10*in_x17*in_x21*in_x23+t3*t7*t9*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x24+t3*t7*t9*in_x4*in_x5*in_x6*in_x11*in_x16*in_x21*in_x23-t3*t7*t9*in_x4*in_x5*in_x6*in_x11*in_x18*in_x19*in_x23-t3*t7*t9*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x22-t3*t7*t9*in_x4*in_x5*in_x6*in_x12*in_x17*in_x19*in_x23-t3*t7*t9*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x22+t2*t4*t12*in_x4*in_x5*in_x8*in_x10*in_x11*in_x23*in_x27*2.0-t2*t4*t12*in_x4*in_x5*in_x8*in_x10*in_x11*in_x24*in_x26*2.0+t2*t4*t12*in_x4*in_x5*in_x8*in_x11*in_x12*in_x22*in_x26*2.0-t2*t4*t12*in_x4*in_x5*in_x8*in_x11*in_x12*in_x23*in_x25*2.0+t2*t4*t14*in_x4*in_x5*in_x9*in_x10*in_x11*in_x20*in_x27*2.0-t2*t4*t14*in_x4*in_x5*in_x9*in_x10*in_x11*in_x21*in_x26*2.0+t2*t4*t14*in_x4*in_x5*in_x9*in_x11*in_x12*in_x19*in_x26*2.0-t2*t4*t14*in_x4*in_x5*in_x9*in_x11*in_x12*in_x20*in_x25*2.0+t2*t8*t12*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x27-t2*t8*t12*in_x2*in_x3*in_x8*in_x10*in_x14*in_x21*in_x26+t2*t8*t12*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x27-t2*t8*t12*in_x2*in_x3*in_x8*in_x11*in_x13*in_x21*in_x26+t2*t8*t12*in_x2*in_x3*in_x8*in_x11*in_x15*in_x19*in_x26-t2*t8*t12*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x25+t2*t8*t12*in_x2*in_x3*in_x8*in_x12*in_x14*in_x19*in_x26-t2*t8*t12*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x25-t3*t6*t11*in_x2*in_x6*in_x7*in_x13*in_x17*in_x20*in_x21*2.0+t3*t6*t11*in_x2*in_x6*in_x7*in_x14*in_x16*in_x20*in_x21*2.0-t3*t6*t11*in_x2*in_x6*in_x7*in_x14*in_x18*in_x19*in_x20*2.0+t3*t6*t11*in_x2*in_x6*in_x7*in_x15*in_x17*in_x19*in_x20*2.0+t3*t9*t10*in_x2*in_x3*in_x5*in_x10*in_x14*in_x23*in_x27-t3*t9*t10*in_x2*in_x3*in_x5*in_x10*in_x14*in_x24*in_x26-t3*t9*t10*in_x2*in_x3*in_x5*in_x11*in_x13*in_x23*in_x27+t3*t9*t10*in_x2*in_x3*in_x5*in_x11*in_x13*in_x24*in_x26-t3*t9*t10*in_x2*in_x3*in_x5*in_x11*in_x15*in_x22*in_x26+t3*t9*t10*in_x2*in_x3*in_x5*in_x11*in_x15*in_x23*in_x25+t3*t9*t10*in_x2*in_x3*in_x5*in_x12*in_x14*in_x22*in_x26-t3*t9*t10*in_x2*in_x3*in_x5*in_x12*in_x14*in_x23*in_x25-t3*t9*t10*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x27+t3*t9*t10*in_x2*in_x3*in_x8*in_x10*in_x14*in_x21*in_x26+t3*t9*t10*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x27-t3*t9*t10*in_x2*in_x3*in_x8*in_x11*in_x13*in_x21*in_x26+t3*t9*t10*in_x2*in_x3*in_x8*in_x11*in_x15*in_x19*in_x26-t3*t9*t10*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x25-t3*t9*t10*in_x2*in_x3*in_x8*in_x12*in_x14*in_x19*in_x26+t3*t9*t10*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x25-t2*t5*t12*in_x4*in_x5*in_x8*in_x10*in_x11*in_x23*in_x27*2.0+t2*t5*t12*in_x4*in_x5*in_x8*in_x10*in_x11*in_x24*in_x26*2.0-t2*t5*t12*in_x4*in_x5*in_x8*in_x11*in_x12*in_x22*in_x26*2.0+t2*t5*t12*in_x4*in_x5*in_x8*in_x11*in_x12*in_x23*in_x25*2.0-t2*t5*t14*in_x4*in_x5*in_x9*in_x10*in_x11*in_x20*in_x27*2.0+t2*t5*t14*in_x4*in_x5*in_x9*in_x10*in_x11*in_x21*in_x26*2.0-t2*t5*t14*in_x4*in_x5*in_x9*in_x11*in_x12*in_x19*in_x26*2.0+t2*t5*t14*in_x4*in_x5*in_x9*in_x11*in_x12*in_x20*in_x25*2.0-t2*t11*t12*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x24+t2*t11*t12*in_x2*in_x4*in_x5*in_x10*in_x17*in_x21*in_x23+t2*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x24-t2*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x16*in_x21*in_x23+t2*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x18*in_x19*in_x23-t2*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x22-t2*t11*t12*in_x2*in_x4*in_x5*in_x12*in_x17*in_x19*in_x23+t2*t11*t12*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x22-t3*t4*t6*in_x4*in_x7*in_x9*in_x13*in_x17*in_x20*in_x24*2.0+t3*t4*t6*in_x4*in_x7*in_x9*in_x13*in_x17*in_x21*in_x23*2.0-t3*t4*t6*in_x4*in_x7*in_x9*in_x14*in_x16*in_x20*in_x24*2.0+t3*t4*t6*in_x4*in_x7*in_x9*in_x14*in_x16*in_x21*in_x23*2.0-t3*t4*t6*in_x4*in_x7*in_x9*in_x14*in_x18*in_x19*in_x23*2.0+t3*t4*t6*in_x4*in_x7*in_x9*in_x14*in_x18*in_x20*in_x22*2.0-t3*t4*t6*in_x4*in_x7*in_x9*in_x15*in_x17*in_x19*in_x23*2.0+t3*t4*t6*in_x4*in_x7*in_x9*in_x15*in_x17*in_x20*in_x22*2.0+t3*t4*t6*in_x5*in_x7*in_x8*in_x13*in_x17*in_x20*in_x24*2.0-t3*t4*t6*in_x5*in_x7*in_x8*in_x13*in_x17*in_x21*in_x23*2.0+t3*t4*t6*in_x5*in_x7*in_x8*in_x14*in_x16*in_x20*in_x24*2.0-t3*t4*t6*in_x5*in_x7*in_x8*in_x14*in_x16*in_x21*in_x23*2.0+t3*t4*t6*in_x5*in_x7*in_x8*in_x14*in_x18*in_x19*in_x23*2.0-t3*t4*t6*in_x5*in_x7*in_x8*in_x14*in_x18*in_x20*in_x22*2.0+t3*t4*t6*in_x5*in_x7*in_x8*in_x15*in_x17*in_x19*in_x23*2.0-t3*t4*t6*in_x5*in_x7*in_x8*in_x15*in_x17*in_x20*in_x22*2.0+t3*t4*t6*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24+t3*t4*t6*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23-t3*t4*t6*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24-t3*t4*t6*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23+t3*t4*t6*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23+t3*t4*t6*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22-t3*t4*t6*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23-t3*t4*t6*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22-t3*t7*t9*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x27+t3*t7*t9*in_x4*in_x6*in_x7*in_x10*in_x14*in_x21*in_x26+t3*t7*t9*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x27-t3*t7*t9*in_x4*in_x6*in_x7*in_x11*in_x13*in_x21*in_x26+t3*t7*t9*in_x4*in_x6*in_x7*in_x11*in_x15*in_x19*in_x26-t3*t7*t9*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x25-t3*t7*t9*in_x4*in_x6*in_x7*in_x12*in_x14*in_x19*in_x26+t3*t7*t9*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x25-t3*t9*t11*in_x3*in_x6*in_x7*in_x10*in_x17*in_x20*in_x21*2.0+t3*t9*t11*in_x3*in_x6*in_x7*in_x11*in_x16*in_x20*in_x21*2.0-t3*t9*t11*in_x3*in_x6*in_x7*in_x11*in_x18*in_x19*in_x20*2.0+t3*t9*t11*in_x3*in_x6*in_x7*in_x12*in_x17*in_x19*in_x20*2.0+t3*t5*t6*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24+t3*t5*t6*in_x3*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23+t3*t5*t6*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24+t3*t5*t6*in_x3*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23-t3*t5*t6*in_x3*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23-t3*t5*t6*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22-t3*t5*t6*in_x3*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23-t3*t5*t6*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22+t3*t9*t10*in_x2*in_x4*in_x9*in_x10*in_x17*in_x20*in_x24*2.0-t3*t9*t10*in_x2*in_x4*in_x9*in_x10*in_x17*in_x21*in_x23*2.0+t3*t9*t10*in_x2*in_x4*in_x9*in_x11*in_x16*in_x20*in_x24*2.0-t3*t9*t10*in_x2*in_x4*in_x9*in_x11*in_x16*in_x21*in_x23*2.0+t3*t9*t10*in_x2*in_x4*in_x9*in_x11*in_x18*in_x19*in_x23*2.0-t3*t9*t10*in_x2*in_x4*in_x9*in_x11*in_x18*in_x20*in_x22*2.0+t3*t9*t10*in_x2*in_x4*in_x9*in_x12*in_x17*in_x19*in_x23*2.0-t3*t9*t10*in_x2*in_x4*in_x9*in_x12*in_x17*in_x20*in_x22*2.0-t3*t9*t10*in_x2*in_x5*in_x8*in_x10*in_x17*in_x20*in_x24*2.0+t3*t9*t10*in_x2*in_x5*in_x8*in_x10*in_x17*in_x21*in_x23*2.0-t3*t9*t10*in_x2*in_x5*in_x8*in_x11*in_x16*in_x20*in_x24*2.0+t3*t9*t10*in_x2*in_x5*in_x8*in_x11*in_x16*in_x21*in_x23*2.0-t3*t9*t10*in_x2*in_x5*in_x8*in_x11*in_x18*in_x19*in_x23*2.0+t3*t9*t10*in_x2*in_x5*in_x8*in_x11*in_x18*in_x20*in_x22*2.0-t3*t9*t10*in_x2*in_x5*in_x8*in_x12*in_x17*in_x19*in_x23*2.0+t3*t9*t10*in_x2*in_x5*in_x8*in_x12*in_x17*in_x20*in_x22*2.0+t3*t9*t10*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x24+t3*t9*t10*in_x3*in_x4*in_x5*in_x13*in_x17*in_x21*in_x23-t3*t9*t10*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x24-t3*t9*t10*in_x3*in_x4*in_x5*in_x14*in_x16*in_x21*in_x23+t3*t9*t10*in_x3*in_x4*in_x5*in_x14*in_x18*in_x19*in_x23+t3*t9*t10*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x22-t3*t9*t10*in_x3*in_x4*in_x5*in_x15*in_x17*in_x19*in_x23-t3*t9*t10*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x22-t2*t11*t12*in_x2*in_x3*in_x5*in_x10*in_x14*in_x23*in_x27-t2*t11*t12*in_x2*in_x3*in_x5*in_x10*in_x14*in_x24*in_x26-t2*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x13*in_x23*in_x27-t2*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x13*in_x24*in_x26+t2*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x15*in_x22*in_x26+t2*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x15*in_x23*in_x25+t2*t11*t12*in_x2*in_x3*in_x5*in_x12*in_x14*in_x22*in_x26+t2*t11*t12*in_x2*in_x3*in_x5*in_x12*in_x14*in_x23*in_x25-t2*t11*t12*in_x2*in_x4*in_x7*in_x10*in_x14*in_x20*in_x27*2.0+t2*t11*t12*in_x2*in_x4*in_x7*in_x10*in_x14*in_x21*in_x26*2.0+t2*t11*t12*in_x2*in_x4*in_x7*in_x11*in_x13*in_x20*in_x27*2.0-t2*t11*t12*in_x2*in_x4*in_x7*in_x11*in_x13*in_x21*in_x26*2.0+t2*t11*t12*in_x2*in_x4*in_x7*in_x11*in_x15*in_x19*in_x26*2.0-t2*t11*t12*in_x2*in_x4*in_x7*in_x11*in_x15*in_x20*in_x25*2.0-t2*t11*t12*in_x2*in_x4*in_x7*in_x12*in_x14*in_x19*in_x26*2.0+t2*t11*t12*in_x2*in_x4*in_x7*in_x12*in_x14*in_x20*in_x25*2.0+t2*t11*t12*in_x3*in_x4*in_x6*in_x10*in_x14*in_x20*in_x27*2.0-t2*t11*t12*in_x3*in_x4*in_x6*in_x10*in_x14*in_x21*in_x26*2.0-t2*t11*t12*in_x3*in_x4*in_x6*in_x11*in_x13*in_x20*in_x27*2.0+t2*t11*t12*in_x3*in_x4*in_x6*in_x11*in_x13*in_x21*in_x26*2.0-t2*t11*t12*in_x3*in_x4*in_x6*in_x11*in_x15*in_x19*in_x26*2.0+t2*t11*t12*in_x3*in_x4*in_x6*in_x11*in_x15*in_x20*in_x25*2.0+t2*t11*t12*in_x3*in_x4*in_x6*in_x12*in_x14*in_x19*in_x26*2.0-t2*t11*t12*in_x3*in_x4*in_x6*in_x12*in_x14*in_x20*in_x25*2.0-t3*t4*t6*in_x6*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27+t3*t4*t6*in_x6*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26+t3*t4*t6*in_x6*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27-t3*t4*t6*in_x6*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26+t3*t4*t6*in_x6*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26-t3*t4*t6*in_x6*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25-t3*t4*t6*in_x6*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26+t3*t4*t6*in_x6*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25-t3*t7*t9*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x24-t3*t7*t9*in_x4*in_x5*in_x7*in_x13*in_x17*in_x21*in_x23+t3*t7*t9*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x24+t3*t7*t9*in_x4*in_x5*in_x7*in_x14*in_x16*in_x21*in_x23-t3*t7*t9*in_x4*in_x5*in_x7*in_x14*in_x18*in_x19*in_x23-t3*t7*t9*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x22+t3*t7*t9*in_x4*in_x5*in_x7*in_x15*in_x17*in_x19*in_x23+t3*t7*t9*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x22-t3*t7*t9*in_x4*in_x6*in_x9*in_x10*in_x17*in_x20*in_x24*2.0+t3*t7*t9*in_x4*in_x6*in_x9*in_x10*in_x17*in_x21*in_x23*2.0-t3*t7*t9*in_x4*in_x6*in_x9*in_x11*in_x16*in_x20*in_x24*2.0+t3*t7*t9*in_x4*in_x6*in_x9*in_x11*in_x16*in_x21*in_x23*2.0-t3*t7*t9*in_x4*in_x6*in_x9*in_x11*in_x18*in_x19*in_x23*2.0+t3*t7*t9*in_x4*in_x6*in_x9*in_x11*in_x18*in_x20*in_x22*2.0-t3*t7*t9*in_x4*in_x6*in_x9*in_x12*in_x17*in_x19*in_x23*2.0+t3*t7*t9*in_x4*in_x6*in_x9*in_x12*in_x17*in_x20*in_x22*2.0+t3*t7*t9*in_x5*in_x6*in_x8*in_x10*in_x17*in_x20*in_x24*2.0-t3*t7*t9*in_x5*in_x6*in_x8*in_x10*in_x17*in_x21*in_x23*2.0+t3*t7*t9*in_x5*in_x6*in_x8*in_x11*in_x16*in_x20*in_x24*2.0-t3*t7*t9*in_x5*in_x6*in_x8*in_x11*in_x16*in_x21*in_x23*2.0+t3*t7*t9*in_x5*in_x6*in_x8*in_x11*in_x18*in_x19*in_x23*2.0-t3*t7*t9*in_x5*in_x6*in_x8*in_x11*in_x18*in_x20*in_x22*2.0+t3*t7*t9*in_x5*in_x6*in_x8*in_x12*in_x17*in_x19*in_x23*2.0-t3*t7*t9*in_x5*in_x6*in_x8*in_x12*in_x17*in_x20*in_x22*2.0-t2*t4*t12*in_x4*in_x8*in_x9*in_x10*in_x11*in_x23*in_x27*2.0+t2*t4*t12*in_x4*in_x8*in_x9*in_x10*in_x11*in_x24*in_x26*2.0-t2*t4*t12*in_x4*in_x8*in_x9*in_x11*in_x12*in_x22*in_x26*2.0+t2*t4*t12*in_x4*in_x8*in_x9*in_x11*in_x12*in_x23*in_x25*2.0-t2*t4*t14*in_x5*in_x8*in_x9*in_x10*in_x11*in_x20*in_x27*2.0+t2*t4*t14*in_x5*in_x8*in_x9*in_x10*in_x11*in_x21*in_x26*2.0-t2*t4*t14*in_x5*in_x8*in_x9*in_x11*in_x12*in_x19*in_x26*2.0+t2*t4*t14*in_x5*in_x8*in_x9*in_x11*in_x12*in_x20*in_x25*2.0+t2*t8*t12*in_x2*in_x3*in_x9*in_x10*in_x14*in_x23*in_x27+t2*t8*t12*in_x2*in_x3*in_x9*in_x10*in_x14*in_x24*in_x26+t2*t8*t12*in_x2*in_x3*in_x9*in_x11*in_x13*in_x23*in_x27+t2*t8*t12*in_x2*in_x3*in_x9*in_x11*in_x13*in_x24*in_x26-t2*t8*t12*in_x2*in_x3*in_x9*in_x11*in_x15*in_x22*in_x26-t2*t8*t12*in_x2*in_x3*in_x9*in_x11*in_x15*in_x23*in_x25-t2*t8*t12*in_x2*in_x3*in_x9*in_x12*in_x14*in_x22*in_x26-t2*t8*t12*in_x2*in_x3*in_x9*in_x12*in_x14*in_x23*in_x25+t2*t8*t12*in_x2*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27*2.0-t2*t8*t12*in_x2*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26*2.0-t2*t8*t12*in_x2*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27*2.0+t2*t8*t12*in_x2*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26*2.0-t2*t8*t12*in_x2*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26*2.0+t2*t8*t12*in_x2*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25*2.0+t2*t8*t12*in_x2*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26*2.0-t2*t8*t12*in_x2*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25*2.0-t2*t8*t12*in_x3*in_x6*in_x8*in_x10*in_x14*in_x20*in_x27*2.0+t2*t8*t12*in_x3*in_x6*in_x8*in_x10*in_x14*in_x21*in_x26*2.0+t2*t8*t12*in_x3*in_x6*in_x8*in_x11*in_x13*in_x20*in_x27*2.0-t2*t8*t12*in_x3*in_x6*in_x8*in_x11*in_x13*in_x21*in_x26*2.0+t2*t8*t12*in_x3*in_x6*in_x8*in_x11*in_x15*in_x19*in_x26*2.0-t2*t8*t12*in_x3*in_x6*in_x8*in_x11*in_x15*in_x20*in_x25*2.0-t2*t8*t12*in_x3*in_x6*in_x8*in_x12*in_x14*in_x19*in_x26*2.0+t2*t8*t12*in_x3*in_x6*in_x8*in_x12*in_x14*in_x20*in_x25*2.0-t3*t6*t13*in_x2*in_x3*in_x6*in_x13*in_x17*in_x23*in_x24*2.0+t3*t6*t13*in_x2*in_x3*in_x6*in_x14*in_x16*in_x23*in_x24*2.0-t3*t6*t13*in_x2*in_x3*in_x6*in_x14*in_x18*in_x22*in_x23*2.0+t3*t6*t13*in_x2*in_x3*in_x6*in_x15*in_x17*in_x22*in_x23*2.0-t3*t9*t10*in_x2*in_x3*in_x9*in_x10*in_x14*in_x23*in_x27+t3*t9*t10*in_x2*in_x3*in_x9*in_x10*in_x14*in_x24*in_x26+t3*t9*t10*in_x2*in_x3*in_x9*in_x11*in_x13*in_x23*in_x27-t3*t9*t10*in_x2*in_x3*in_x9*in_x11*in_x13*in_x24*in_x26+t3*t9*t10*in_x2*in_x3*in_x9*in_x11*in_x15*in_x22*in_x26-t3*t9*t10*in_x2*in_x3*in_x9*in_x11*in_x15*in_x23*in_x25-t3*t9*t10*in_x2*in_x3*in_x9*in_x12*in_x14*in_x22*in_x26+t3*t9*t10*in_x2*in_x3*in_x9*in_x12*in_x14*in_x23*in_x25+t2*t5*t12*in_x4*in_x8*in_x9*in_x10*in_x11*in_x23*in_x27*2.0-t2*t5*t12*in_x4*in_x8*in_x9*in_x10*in_x11*in_x24*in_x26*2.0+t2*t5*t12*in_x4*in_x8*in_x9*in_x11*in_x12*in_x22*in_x26*2.0-t2*t5*t12*in_x4*in_x8*in_x9*in_x11*in_x12*in_x23*in_x25*2.0+t2*t5*t14*in_x5*in_x8*in_x9*in_x10*in_x11*in_x20*in_x27*2.0-t2*t5*t14*in_x5*in_x8*in_x9*in_x10*in_x11*in_x21*in_x26*2.0+t2*t5*t14*in_x5*in_x8*in_x9*in_x11*in_x12*in_x19*in_x26*2.0-t2*t5*t14*in_x5*in_x8*in_x9*in_x11*in_x12*in_x20*in_x25*2.0-t2*t11*t12*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x24+t2*t11*t12*in_x3*in_x4*in_x5*in_x13*in_x17*in_x21*in_x23+t2*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x24-t2*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x16*in_x21*in_x23+t2*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x18*in_x19*in_x23-t2*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x22-t2*t11*t12*in_x3*in_x4*in_x5*in_x15*in_x17*in_x19*in_x23+t2*t11*t12*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x22+t2*t11*t12*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x24-t2*t11*t12*in_x4*in_x5*in_x6*in_x10*in_x17*in_x21*in_x23-t2*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x24+t2*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x16*in_x21*in_x23-t2*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x18*in_x19*in_x23+t2*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x22+t2*t11*t12*in_x4*in_x5*in_x6*in_x12*in_x17*in_x19*in_x23-t2*t11*t12*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x22-t2*t14*t15*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x27-t2*t14*t15*in_x2*in_x3*in_x4*in_x10*in_x14*in_x21*in_x26-t2*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x27-t2*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x13*in_x21*in_x26+t2*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x15*in_x19*in_x26+t2*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x25+t2*t14*t15*in_x2*in_x3*in_x4*in_x12*in_x14*in_x19*in_x26+t2*t14*t15*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x25-t3*t4*t6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24-t3*t4*t6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23-t3*t4*t6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24-t3*t4*t6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23+t3*t4*t6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23+t3*t4*t6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22+t3*t4*t6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23+t3*t4*t6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t3*t7*t9*in_x5*in_x6*in_x7*in_x10*in_x14*in_x23*in_x27+t3*t7*t9*in_x5*in_x6*in_x7*in_x10*in_x14*in_x24*in_x26+t3*t7*t9*in_x5*in_x6*in_x7*in_x11*in_x13*in_x23*in_x27-t3*t7*t9*in_x5*in_x6*in_x7*in_x11*in_x13*in_x24*in_x26+t3*t7*t9*in_x5*in_x6*in_x7*in_x11*in_x15*in_x22*in_x26-t3*t7*t9*in_x5*in_x6*in_x7*in_x11*in_x15*in_x23*in_x25-t3*t7*t9*in_x5*in_x6*in_x7*in_x12*in_x14*in_x22*in_x26+t3*t7*t9*in_x5*in_x6*in_x7*in_x12*in_x14*in_x23*in_x25+t3*t7*t9*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27-t3*t7*t9*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26-t3*t7*t9*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27+t3*t7*t9*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26-t3*t7*t9*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26+t3*t7*t9*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25+t3*t7*t9*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26-t3*t7*t9*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25-t3*t9*t13*in_x2*in_x3*in_x7*in_x10*in_x17*in_x23*in_x24*2.0+t3*t9*t13*in_x2*in_x3*in_x7*in_x11*in_x16*in_x23*in_x24*2.0-t3*t9*t13*in_x2*in_x3*in_x7*in_x11*in_x18*in_x22*in_x23*2.0+t3*t9*t13*in_x2*in_x3*in_x7*in_x12*in_x17*in_x22*in_x23*2.0+t2*t8*t12*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24-t2*t8*t12*in_x2*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23-t2*t8*t12*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24+t2*t8*t12*in_x2*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23-t2*t8*t12*in_x2*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23+t2*t8*t12*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22+t2*t8*t12*in_x2*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23-t2*t8*t12*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t3*t5*t8*in_x3*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*2.0-t3*t5*t8*in_x3*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*2.0+t3*t6*t15*in_x2*in_x3*in_x6*in_x13*in_x17*in_x23*in_x24*2.0-t3*t6*t15*in_x2*in_x3*in_x6*in_x14*in_x16*in_x23*in_x24*2.0+t3*t6*t15*in_x2*in_x3*in_x6*in_x14*in_x18*in_x22*in_x23*2.0-t3*t6*t15*in_x2*in_x3*in_x6*in_x15*in_x17*in_x22*in_x23*2.0+t3*t9*t10*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24+t3*t9*t10*in_x2*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23+t3*t9*t10*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24+t3*t9*t10*in_x2*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23-t3*t9*t10*in_x2*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23-t3*t9*t10*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22-t3*t9*t10*in_x2*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23-t3*t9*t10*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22-t3*t9*t10*in_x3*in_x4*in_x9*in_x13*in_x17*in_x20*in_x24*2.0+t3*t9*t10*in_x3*in_x4*in_x9*in_x13*in_x17*in_x21*in_x23*2.0+t3*t9*t10*in_x3*in_x4*in_x9*in_x14*in_x16*in_x20*in_x24*2.0-t3*t9*t10*in_x3*in_x4*in_x9*in_x14*in_x16*in_x21*in_x23*2.0+t3*t9*t10*in_x3*in_x4*in_x9*in_x14*in_x18*in_x19*in_x23*2.0-t3*t9*t10*in_x3*in_x4*in_x9*in_x14*in_x18*in_x20*in_x22*2.0-t3*t9*t10*in_x3*in_x4*in_x9*in_x15*in_x17*in_x19*in_x23*2.0+t3*t9*t10*in_x3*in_x4*in_x9*in_x15*in_x17*in_x20*in_x22*2.0+t3*t9*t10*in_x3*in_x5*in_x8*in_x13*in_x17*in_x20*in_x24*2.0-t3*t9*t10*in_x3*in_x5*in_x8*in_x13*in_x17*in_x21*in_x23*2.0-t3*t9*t10*in_x3*in_x5*in_x8*in_x14*in_x16*in_x20*in_x24*2.0+t3*t9*t10*in_x3*in_x5*in_x8*in_x14*in_x16*in_x21*in_x23*2.0-t3*t9*t10*in_x3*in_x5*in_x8*in_x14*in_x18*in_x19*in_x23*2.0+t3*t9*t10*in_x3*in_x5*in_x8*in_x14*in_x18*in_x20*in_x22*2.0+t3*t9*t10*in_x3*in_x5*in_x8*in_x15*in_x17*in_x19*in_x23*2.0-t3*t9*t10*in_x3*in_x5*in_x8*in_x15*in_x17*in_x20*in_x22*2.0-t2*t11*t12*in_x2*in_x5*in_x7*in_x10*in_x14*in_x23*in_x27*2.0-t2*t11*t12*in_x2*in_x5*in_x7*in_x10*in_x14*in_x24*in_x26*2.0+t2*t11*t12*in_x2*in_x5*in_x7*in_x11*in_x13*in_x23*in_x27*2.0+t2*t11*t12*in_x2*in_x5*in_x7*in_x11*in_x13*in_x24*in_x26*2.0-t2*t11*t12*in_x2*in_x5*in_x7*in_x11*in_x15*in_x22*in_x26*2.0-t2*t11*t12*in_x2*in_x5*in_x7*in_x11*in_x15*in_x23*in_x25*2.0+t2*t11*t12*in_x2*in_x5*in_x7*in_x12*in_x14*in_x22*in_x26*2.0+t2*t11*t12*in_x2*in_x5*in_x7*in_x12*in_x14*in_x23*in_x25*2.0+t2*t11*t12*in_x3*in_x5*in_x6*in_x10*in_x14*in_x23*in_x27*2.0+t2*t11*t12*in_x3*in_x5*in_x6*in_x10*in_x14*in_x24*in_x26*2.0-t2*t11*t12*in_x3*in_x5*in_x6*in_x11*in_x13*in_x23*in_x27*2.0-t2*t11*t12*in_x3*in_x5*in_x6*in_x11*in_x13*in_x24*in_x26*2.0+t2*t11*t12*in_x3*in_x5*in_x6*in_x11*in_x15*in_x22*in_x26*2.0+t2*t11*t12*in_x3*in_x5*in_x6*in_x11*in_x15*in_x23*in_x25*2.0-t2*t11*t12*in_x3*in_x5*in_x6*in_x12*in_x14*in_x22*in_x26*2.0-t2*t11*t12*in_x3*in_x5*in_x6*in_x12*in_x14*in_x23*in_x25*2.0+t2*t11*t12*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x27-t2*t11*t12*in_x4*in_x6*in_x7*in_x10*in_x14*in_x21*in_x26+t2*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x27-t2*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x13*in_x21*in_x26+t2*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x15*in_x19*in_x26-t2*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x25+t2*t11*t12*in_x4*in_x6*in_x7*in_x12*in_x14*in_x19*in_x26-t2*t11*t12*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x25+t2*t13*t14*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x27+t2*t13*t14*in_x2*in_x3*in_x8*in_x10*in_x14*in_x21*in_x26+t2*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x27+t2*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x13*in_x21*in_x26-t2*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x15*in_x19*in_x26-t2*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x25-t2*t13*t14*in_x2*in_x3*in_x8*in_x12*in_x14*in_x19*in_x26-t2*t13*t14*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x25+t2*t14*t15*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x24-t2*t14*t15*in_x2*in_x4*in_x5*in_x10*in_x17*in_x21*in_x23-t2*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x24+t2*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x16*in_x21*in_x23-t2*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x18*in_x19*in_x23+t2*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x22+t2*t14*t15*in_x2*in_x4*in_x5*in_x12*in_x17*in_x19*in_x23-t2*t14*t15*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x22+t3*t7*t9*in_x4*in_x7*in_x9*in_x13*in_x17*in_x20*in_x24*2.0-t3*t7*t9*in_x4*in_x7*in_x9*in_x13*in_x17*in_x21*in_x23*2.0-t3*t7*t9*in_x4*in_x7*in_x9*in_x14*in_x16*in_x20*in_x24*2.0+t3*t7*t9*in_x4*in_x7*in_x9*in_x14*in_x16*in_x21*in_x23*2.0-t3*t7*t9*in_x4*in_x7*in_x9*in_x14*in_x18*in_x19*in_x23*2.0+t3*t7*t9*in_x4*in_x7*in_x9*in_x14*in_x18*in_x20*in_x22*2.0+t3*t7*t9*in_x4*in_x7*in_x9*in_x15*in_x17*in_x19*in_x23*2.0-t3*t7*t9*in_x4*in_x7*in_x9*in_x15*in_x17*in_x20*in_x22*2.0-t3*t7*t9*in_x5*in_x7*in_x8*in_x13*in_x17*in_x20*in_x24*2.0+t3*t7*t9*in_x5*in_x7*in_x8*in_x13*in_x17*in_x21*in_x23*2.0+t3*t7*t9*in_x5*in_x7*in_x8*in_x14*in_x16*in_x20*in_x24*2.0-t3*t7*t9*in_x5*in_x7*in_x8*in_x14*in_x16*in_x21*in_x23*2.0+t3*t7*t9*in_x5*in_x7*in_x8*in_x14*in_x18*in_x19*in_x23*2.0-t3*t7*t9*in_x5*in_x7*in_x8*in_x14*in_x18*in_x20*in_x22*2.0-t3*t7*t9*in_x5*in_x7*in_x8*in_x15*in_x17*in_x19*in_x23*2.0+t3*t7*t9*in_x5*in_x7*in_x8*in_x15*in_x17*in_x20*in_x22*2.0-t3*t7*t9*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24-t3*t7*t9*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23-t3*t7*t9*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24-t3*t7*t9*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23+t3*t7*t9*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23+t3*t7*t9*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22+t3*t7*t9*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23+t3*t7*t9*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t3*t9*t15*in_x2*in_x3*in_x7*in_x10*in_x17*in_x23*in_x24*2.0-t3*t9*t15*in_x2*in_x3*in_x7*in_x11*in_x16*in_x23*in_x24*2.0+t3*t9*t15*in_x2*in_x3*in_x7*in_x11*in_x18*in_x22*in_x23*2.0-t3*t9*t15*in_x2*in_x3*in_x7*in_x12*in_x17*in_x22*in_x23*2.0+t2*t8*t12*in_x2*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27*2.0+t2*t8*t12*in_x2*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26*2.0-t2*t8*t12*in_x2*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27*2.0-t2*t8*t12*in_x2*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26*2.0+t2*t8*t12*in_x2*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26*2.0+t2*t8*t12*in_x2*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25*2.0-t2*t8*t12*in_x2*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26*2.0-t2*t8*t12*in_x2*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25*2.0-t2*t8*t12*in_x3*in_x6*in_x9*in_x10*in_x14*in_x23*in_x27*2.0-t2*t8*t12*in_x3*in_x6*in_x9*in_x10*in_x14*in_x24*in_x26*2.0+t2*t8*t12*in_x3*in_x6*in_x9*in_x11*in_x13*in_x23*in_x27*2.0+t2*t8*t12*in_x3*in_x6*in_x9*in_x11*in_x13*in_x24*in_x26*2.0-t2*t8*t12*in_x3*in_x6*in_x9*in_x11*in_x15*in_x22*in_x26*2.0-t2*t8*t12*in_x3*in_x6*in_x9*in_x11*in_x15*in_x23*in_x25*2.0+t2*t8*t12*in_x3*in_x6*in_x9*in_x12*in_x14*in_x22*in_x26*2.0+t2*t8*t12*in_x3*in_x6*in_x9*in_x12*in_x14*in_x23*in_x25*2.0-t2*t8*t12*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27+t2*t8*t12*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26-t2*t8*t12*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27+t2*t8*t12*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26-t2*t8*t12*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26+t2*t8*t12*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25-t2*t8*t12*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26+t2*t8*t12*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25+t3*t6*t13*in_x2*in_x6*in_x7*in_x13*in_x17*in_x23*in_x24*2.0-t3*t6*t13*in_x2*in_x6*in_x7*in_x14*in_x16*in_x23*in_x24*2.0+t3*t6*t13*in_x2*in_x6*in_x7*in_x14*in_x18*in_x22*in_x23*2.0-t3*t6*t13*in_x2*in_x6*in_x7*in_x15*in_x17*in_x22*in_x23*2.0+t2*t7*t12*in_x4*in_x5*in_x8*in_x13*in_x14*in_x23*in_x27*2.0-t2*t7*t12*in_x4*in_x5*in_x8*in_x13*in_x14*in_x24*in_x26*2.0+t2*t7*t12*in_x4*in_x5*in_x8*in_x14*in_x15*in_x22*in_x26*2.0-t2*t7*t12*in_x4*in_x5*in_x8*in_x14*in_x15*in_x23*in_x25*2.0+t2*t7*t14*in_x4*in_x5*in_x9*in_x13*in_x14*in_x20*in_x27*2.0-t2*t7*t14*in_x4*in_x5*in_x9*in_x13*in_x14*in_x21*in_x26*2.0+t2*t7*t14*in_x4*in_x5*in_x9*in_x14*in_x15*in_x19*in_x26*2.0-t2*t7*t14*in_x4*in_x5*in_x9*in_x14*in_x15*in_x20*in_x25*2.0+t2*t11*t12*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x24-t2*t11*t12*in_x4*in_x5*in_x7*in_x13*in_x17*in_x21*in_x23-t2*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x24+t2*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x16*in_x21*in_x23-t2*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x18*in_x19*in_x23+t2*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x22+t2*t11*t12*in_x4*in_x5*in_x7*in_x15*in_x17*in_x19*in_x23-t2*t11*t12*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x22-t2*t14*t15*in_x2*in_x3*in_x5*in_x10*in_x14*in_x23*in_x27+t2*t14*t15*in_x2*in_x3*in_x5*in_x10*in_x14*in_x24*in_x26-t2*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x13*in_x23*in_x27+t2*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x13*in_x24*in_x26-t2*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x15*in_x22*in_x26+t2*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x15*in_x23*in_x25-t2*t14*t15*in_x2*in_x3*in_x5*in_x12*in_x14*in_x22*in_x26+t2*t14*t15*in_x2*in_x3*in_x5*in_x12*in_x14*in_x23*in_x25-t2*t14*t15*in_x2*in_x4*in_x7*in_x10*in_x14*in_x20*in_x27*2.0-t2*t14*t15*in_x2*in_x4*in_x7*in_x10*in_x14*in_x21*in_x26*2.0+t2*t14*t15*in_x2*in_x4*in_x7*in_x11*in_x13*in_x20*in_x27*2.0+t2*t14*t15*in_x2*in_x4*in_x7*in_x11*in_x13*in_x21*in_x26*2.0-t2*t14*t15*in_x2*in_x4*in_x7*in_x11*in_x15*in_x19*in_x26*2.0-t2*t14*t15*in_x2*in_x4*in_x7*in_x11*in_x15*in_x20*in_x25*2.0+t2*t14*t15*in_x2*in_x4*in_x7*in_x12*in_x14*in_x19*in_x26*2.0+t2*t14*t15*in_x2*in_x4*in_x7*in_x12*in_x14*in_x20*in_x25*2.0+t2*t14*t15*in_x3*in_x4*in_x6*in_x10*in_x14*in_x20*in_x27*2.0+t2*t14*t15*in_x3*in_x4*in_x6*in_x10*in_x14*in_x21*in_x26*2.0-t2*t14*t15*in_x3*in_x4*in_x6*in_x11*in_x13*in_x20*in_x27*2.0-t2*t14*t15*in_x3*in_x4*in_x6*in_x11*in_x13*in_x21*in_x26*2.0+t2*t14*t15*in_x3*in_x4*in_x6*in_x11*in_x15*in_x19*in_x26*2.0+t2*t14*t15*in_x3*in_x4*in_x6*in_x11*in_x15*in_x20*in_x25*2.0-t2*t14*t15*in_x3*in_x4*in_x6*in_x12*in_x14*in_x19*in_x26*2.0-t2*t14*t15*in_x3*in_x4*in_x6*in_x12*in_x14*in_x20*in_x25*2.0-t3*t4*t8*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*2.0+t3*t4*t8*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*2.0-t3*t5*t11*in_x3*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*2.0+t3*t5*t11*in_x3*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*2.0+t3*t7*t9*in_x6*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27-t3*t7*t9*in_x6*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26-t3*t7*t9*in_x6*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27+t3*t7*t9*in_x6*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26-t3*t7*t9*in_x6*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26+t3*t7*t9*in_x6*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25+t3*t7*t9*in_x6*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26-t3*t7*t9*in_x6*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25+t3*t9*t13*in_x3*in_x6*in_x7*in_x10*in_x17*in_x23*in_x24*2.0-t3*t9*t13*in_x3*in_x6*in_x7*in_x11*in_x16*in_x23*in_x24*2.0+t3*t9*t13*in_x3*in_x6*in_x7*in_x11*in_x18*in_x22*in_x23*2.0-t3*t9*t13*in_x3*in_x6*in_x7*in_x12*in_x17*in_x22*in_x23*2.0+t2*t8*t12*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24-t2*t8*t12*in_x3*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23-t2*t8*t12*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24+t2*t8*t12*in_x3*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23-t2*t8*t12*in_x3*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23+t2*t8*t12*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22+t2*t8*t12*in_x3*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23-t2*t8*t12*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t2*t8*t12*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24+t2*t8*t12*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23+t2*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24-t2*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23+t2*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23-t2*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22-t2*t8*t12*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23+t2*t8*t12*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22-t3*t6*t15*in_x2*in_x6*in_x7*in_x13*in_x17*in_x23*in_x24*2.0+t3*t6*t15*in_x2*in_x6*in_x7*in_x14*in_x16*in_x23*in_x24*2.0-t3*t6*t15*in_x2*in_x6*in_x7*in_x14*in_x18*in_x22*in_x23*2.0+t3*t6*t15*in_x2*in_x6*in_x7*in_x15*in_x17*in_x22*in_x23*2.0-t3*t9*t10*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24-t3*t9*t10*in_x3*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23+t3*t9*t10*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24+t3*t9*t10*in_x3*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23-t3*t9*t10*in_x3*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23-t3*t9*t10*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22+t3*t9*t10*in_x3*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23+t3*t9*t10*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22+t2*t11*t12*in_x5*in_x6*in_x7*in_x10*in_x14*in_x23*in_x27+t2*t11*t12*in_x5*in_x6*in_x7*in_x10*in_x14*in_x24*in_x26+t2*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x13*in_x23*in_x27+t2*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x13*in_x24*in_x26-t2*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x15*in_x22*in_x26-t2*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x15*in_x23*in_x25-t2*t11*t12*in_x5*in_x6*in_x7*in_x12*in_x14*in_x22*in_x26-t2*t11*t12*in_x5*in_x6*in_x7*in_x12*in_x14*in_x23*in_x25+t2*t13*t14*in_x2*in_x3*in_x9*in_x10*in_x14*in_x23*in_x27-t2*t13*t14*in_x2*in_x3*in_x9*in_x10*in_x14*in_x24*in_x26+t2*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x13*in_x23*in_x27-t2*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x13*in_x24*in_x26+t2*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x15*in_x22*in_x26-t2*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x15*in_x23*in_x25+t2*t13*t14*in_x2*in_x3*in_x9*in_x12*in_x14*in_x22*in_x26-t2*t13*t14*in_x2*in_x3*in_x9*in_x12*in_x14*in_x23*in_x25+t2*t13*t14*in_x2*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27*2.0+t2*t13*t14*in_x2*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26*2.0-t2*t13*t14*in_x2*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27*2.0-t2*t13*t14*in_x2*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26*2.0+t2*t13*t14*in_x2*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26*2.0+t2*t13*t14*in_x2*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25*2.0-t2*t13*t14*in_x2*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26*2.0-t2*t13*t14*in_x2*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25*2.0-t2*t13*t14*in_x3*in_x6*in_x8*in_x10*in_x14*in_x20*in_x27*2.0-t2*t13*t14*in_x3*in_x6*in_x8*in_x10*in_x14*in_x21*in_x26*2.0+t2*t13*t14*in_x3*in_x6*in_x8*in_x11*in_x13*in_x20*in_x27*2.0+t2*t13*t14*in_x3*in_x6*in_x8*in_x11*in_x13*in_x21*in_x26*2.0-t2*t13*t14*in_x3*in_x6*in_x8*in_x11*in_x15*in_x19*in_x26*2.0-t2*t13*t14*in_x3*in_x6*in_x8*in_x11*in_x15*in_x20*in_x25*2.0+t2*t13*t14*in_x3*in_x6*in_x8*in_x12*in_x14*in_x19*in_x26*2.0+t2*t13*t14*in_x3*in_x6*in_x8*in_x12*in_x14*in_x20*in_x25*2.0+t2*t14*t15*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x24-t2*t14*t15*in_x3*in_x4*in_x5*in_x13*in_x17*in_x21*in_x23-t2*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x24+t2*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x16*in_x21*in_x23-t2*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x18*in_x19*in_x23+t2*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x22+t2*t14*t15*in_x3*in_x4*in_x5*in_x15*in_x17*in_x19*in_x23-t2*t14*t15*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x22-t2*t14*t15*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x24+t2*t14*t15*in_x4*in_x5*in_x6*in_x10*in_x17*in_x21*in_x23+t2*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x24-t2*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x16*in_x21*in_x23+t2*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x18*in_x19*in_x23-t2*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x22-t2*t14*t15*in_x4*in_x5*in_x6*in_x12*in_x17*in_x19*in_x23+t2*t14*t15*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x22+t3*t7*t9*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24+t3*t7*t9*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23-t3*t7*t9*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24-t3*t7*t9*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23+t3*t7*t9*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23+t3*t7*t9*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22-t3*t7*t9*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23-t3*t7*t9*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t3*t9*t15*in_x3*in_x6*in_x7*in_x10*in_x17*in_x23*in_x24*2.0+t3*t9*t15*in_x3*in_x6*in_x7*in_x11*in_x16*in_x23*in_x24*2.0-t3*t9*t15*in_x3*in_x6*in_x7*in_x11*in_x18*in_x22*in_x23*2.0+t3*t9*t15*in_x3*in_x6*in_x7*in_x12*in_x17*in_x22*in_x23*2.0-t2*t8*t12*in_x6*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27-t2*t8*t12*in_x6*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26-t2*t8*t12*in_x6*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27-t2*t8*t12*in_x6*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26+t2*t8*t12*in_x6*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26+t2*t8*t12*in_x6*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25+t2*t8*t12*in_x6*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26+t2*t8*t12*in_x6*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25-t2*t10*t12*in_x4*in_x5*in_x8*in_x13*in_x14*in_x23*in_x27*2.0+t2*t10*t12*in_x4*in_x5*in_x8*in_x13*in_x14*in_x24*in_x26*2.0-t2*t10*t12*in_x4*in_x5*in_x8*in_x14*in_x15*in_x22*in_x26*2.0+t2*t10*t12*in_x4*in_x5*in_x8*in_x14*in_x15*in_x23*in_x25*2.0-t2*t10*t14*in_x4*in_x5*in_x9*in_x13*in_x14*in_x20*in_x27*2.0+t2*t10*t14*in_x4*in_x5*in_x9*in_x13*in_x14*in_x21*in_x26*2.0-t2*t10*t14*in_x4*in_x5*in_x9*in_x14*in_x15*in_x19*in_x26*2.0+t2*t10*t14*in_x4*in_x5*in_x9*in_x14*in_x15*in_x20*in_x25*2.0+t3*t4*t11*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*2.0-t3*t4*t11*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*2.0-t2*t7*t12*in_x4*in_x8*in_x9*in_x13*in_x14*in_x23*in_x27*2.0+t2*t7*t12*in_x4*in_x8*in_x9*in_x13*in_x14*in_x24*in_x26*2.0-t2*t7*t12*in_x4*in_x8*in_x9*in_x14*in_x15*in_x22*in_x26*2.0+t2*t7*t12*in_x4*in_x8*in_x9*in_x14*in_x15*in_x23*in_x25*2.0-t2*t7*t14*in_x5*in_x8*in_x9*in_x13*in_x14*in_x20*in_x27*2.0+t2*t7*t14*in_x5*in_x8*in_x9*in_x13*in_x14*in_x21*in_x26*2.0-t2*t7*t14*in_x5*in_x8*in_x9*in_x14*in_x15*in_x19*in_x26*2.0+t2*t7*t14*in_x5*in_x8*in_x9*in_x14*in_x15*in_x20*in_x25*2.0-t2*t13*t14*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24+t2*t13*t14*in_x2*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23+t2*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24-t2*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23+t2*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23-t2*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22-t2*t13*t14*in_x2*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23+t2*t13*t14*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22-t2*t14*t15*in_x2*in_x5*in_x7*in_x10*in_x14*in_x23*in_x27*2.0+t2*t14*t15*in_x2*in_x5*in_x7*in_x10*in_x14*in_x24*in_x26*2.0+t2*t14*t15*in_x2*in_x5*in_x7*in_x11*in_x13*in_x23*in_x27*2.0-t2*t14*t15*in_x2*in_x5*in_x7*in_x11*in_x13*in_x24*in_x26*2.0+t2*t14*t15*in_x2*in_x5*in_x7*in_x11*in_x15*in_x22*in_x26*2.0-t2*t14*t15*in_x2*in_x5*in_x7*in_x11*in_x15*in_x23*in_x25*2.0-t2*t14*t15*in_x2*in_x5*in_x7*in_x12*in_x14*in_x22*in_x26*2.0+t2*t14*t15*in_x2*in_x5*in_x7*in_x12*in_x14*in_x23*in_x25*2.0+t2*t14*t15*in_x3*in_x5*in_x6*in_x10*in_x14*in_x23*in_x27*2.0-t2*t14*t15*in_x3*in_x5*in_x6*in_x10*in_x14*in_x24*in_x26*2.0-t2*t14*t15*in_x3*in_x5*in_x6*in_x11*in_x13*in_x23*in_x27*2.0+t2*t14*t15*in_x3*in_x5*in_x6*in_x11*in_x13*in_x24*in_x26*2.0-t2*t14*t15*in_x3*in_x5*in_x6*in_x11*in_x15*in_x22*in_x26*2.0+t2*t14*t15*in_x3*in_x5*in_x6*in_x11*in_x15*in_x23*in_x25*2.0+t2*t14*t15*in_x3*in_x5*in_x6*in_x12*in_x14*in_x22*in_x26*2.0-t2*t14*t15*in_x3*in_x5*in_x6*in_x12*in_x14*in_x23*in_x25*2.0+t2*t14*t15*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x27+t2*t14*t15*in_x4*in_x6*in_x7*in_x10*in_x14*in_x21*in_x26+t2*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x27+t2*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x13*in_x21*in_x26-t2*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x15*in_x19*in_x26-t2*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x25-t2*t14*t15*in_x4*in_x6*in_x7*in_x12*in_x14*in_x19*in_x26-t2*t14*t15*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x25+t3*t8*t10*in_x2*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*2.0-t3*t8*t10*in_x2*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*2.0-t2*t8*t12*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24+t2*t8*t12*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23+t2*t8*t12*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24-t2*t8*t12*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23+t2*t8*t12*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23-t2*t8*t12*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22-t2*t8*t12*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23+t2*t8*t12*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t3*t7*t8*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*2.0+t3*t7*t8*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x13*in_x17*in_x26*in_x27*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x14*in_x16*in_x26*in_x27*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x14*in_x18*in_x25*in_x26*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x15*in_x17*in_x25*in_x26*2.0+t2*t13*t14*in_x2*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27*2.0-t2*t13*t14*in_x2*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26*2.0-t2*t13*t14*in_x2*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27*2.0+t2*t13*t14*in_x2*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26*2.0-t2*t13*t14*in_x2*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26*2.0+t2*t13*t14*in_x2*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25*2.0+t2*t13*t14*in_x2*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26*2.0-t2*t13*t14*in_x2*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25*2.0-t2*t13*t14*in_x3*in_x6*in_x9*in_x10*in_x14*in_x23*in_x27*2.0+t2*t13*t14*in_x3*in_x6*in_x9*in_x10*in_x14*in_x24*in_x26*2.0+t2*t13*t14*in_x3*in_x6*in_x9*in_x11*in_x13*in_x23*in_x27*2.0-t2*t13*t14*in_x3*in_x6*in_x9*in_x11*in_x13*in_x24*in_x26*2.0+t2*t13*t14*in_x3*in_x6*in_x9*in_x11*in_x15*in_x22*in_x26*2.0-t2*t13*t14*in_x3*in_x6*in_x9*in_x11*in_x15*in_x23*in_x25*2.0-t2*t13*t14*in_x3*in_x6*in_x9*in_x12*in_x14*in_x22*in_x26*2.0+t2*t13*t14*in_x3*in_x6*in_x9*in_x12*in_x14*in_x23*in_x25*2.0-t2*t13*t14*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27-t2*t13*t14*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26-t2*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27-t2*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26+t2*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26+t2*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25+t2*t13*t14*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26+t2*t13*t14*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25-t2*t14*t15*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x24+t2*t14*t15*in_x4*in_x5*in_x7*in_x13*in_x17*in_x21*in_x23+t2*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x24-t2*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x16*in_x21*in_x23+t2*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x18*in_x19*in_x23-t2*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x22-t2*t14*t15*in_x4*in_x5*in_x7*in_x15*in_x17*in_x19*in_x23+t2*t14*t15*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x22+t8*t9*t12*in_x2*in_x3*in_x7*in_x10*in_x17*in_x26*in_x27*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x11*in_x16*in_x26*in_x27*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x11*in_x18*in_x25*in_x26*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x12*in_x17*in_x25*in_x26*2.0+t2*t10*t12*in_x4*in_x8*in_x9*in_x13*in_x14*in_x23*in_x27*2.0-t2*t10*t12*in_x4*in_x8*in_x9*in_x13*in_x14*in_x24*in_x26*2.0+t2*t10*t12*in_x4*in_x8*in_x9*in_x14*in_x15*in_x22*in_x26*2.0-t2*t10*t12*in_x4*in_x8*in_x9*in_x14*in_x15*in_x23*in_x25*2.0+t2*t10*t14*in_x5*in_x8*in_x9*in_x13*in_x14*in_x20*in_x27*2.0-t2*t10*t14*in_x5*in_x8*in_x9*in_x13*in_x14*in_x21*in_x26*2.0+t2*t10*t14*in_x5*in_x8*in_x9*in_x14*in_x15*in_x19*in_x26*2.0-t2*t10*t14*in_x5*in_x8*in_x9*in_x14*in_x15*in_x20*in_x25*2.0-t3*t10*t11*in_x2*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*2.0+t3*t10*t11*in_x2*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*2.0-t4*t6*t12*in_x4*in_x5*in_x8*in_x16*in_x17*in_x23*in_x27*2.0+t4*t6*t12*in_x4*in_x5*in_x8*in_x16*in_x17*in_x24*in_x26*2.0-t4*t6*t12*in_x4*in_x5*in_x8*in_x17*in_x18*in_x22*in_x26*2.0+t4*t6*t12*in_x4*in_x5*in_x8*in_x17*in_x18*in_x23*in_x25*2.0-t4*t6*t14*in_x4*in_x5*in_x9*in_x16*in_x17*in_x20*in_x27*2.0+t4*t6*t14*in_x4*in_x5*in_x9*in_x16*in_x17*in_x21*in_x26*2.0-t4*t6*t14*in_x4*in_x5*in_x9*in_x17*in_x18*in_x19*in_x26*2.0+t4*t6*t14*in_x4*in_x5*in_x9*in_x17*in_x18*in_x20*in_x25*2.0-t2*t13*t14*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24+t2*t13*t14*in_x3*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23+t2*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24-t2*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23+t2*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23-t2*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22-t2*t13*t14*in_x3*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23+t2*t13*t14*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22+t2*t13*t14*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24-t2*t13*t14*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23-t2*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24+t2*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23-t2*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23+t2*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22+t2*t13*t14*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23-t2*t13*t14*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t2*t14*t15*in_x5*in_x6*in_x7*in_x10*in_x14*in_x23*in_x27-t2*t14*t15*in_x5*in_x6*in_x7*in_x10*in_x14*in_x24*in_x26+t2*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x13*in_x23*in_x27-t2*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x13*in_x24*in_x26+t2*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x15*in_x22*in_x26-t2*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x15*in_x23*in_x25+t2*t14*t15*in_x5*in_x6*in_x7*in_x12*in_x14*in_x22*in_x26-t2*t14*t15*in_x5*in_x6*in_x7*in_x12*in_x14*in_x23*in_x25+t3*t5*t13*in_x3*in_x10*in_x11*in_x14*in_x17*in_x23*in_x24*2.0-t3*t5*t13*in_x3*in_x11*in_x12*in_x14*in_x17*in_x22*in_x23*2.0+t3*t7*t11*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*2.0-t3*t7*t11*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*2.0+t5*t6*t12*in_x4*in_x5*in_x8*in_x16*in_x17*in_x23*in_x27*2.0-t5*t6*t12*in_x4*in_x5*in_x8*in_x16*in_x17*in_x24*in_x26*2.0+t5*t6*t12*in_x4*in_x5*in_x8*in_x17*in_x18*in_x22*in_x26*2.0-t5*t6*t12*in_x4*in_x5*in_x8*in_x17*in_x18*in_x23*in_x25*2.0+t5*t6*t14*in_x4*in_x5*in_x9*in_x16*in_x17*in_x20*in_x27*2.0-t5*t6*t14*in_x4*in_x5*in_x9*in_x16*in_x17*in_x21*in_x26*2.0+t5*t6*t14*in_x4*in_x5*in_x9*in_x17*in_x18*in_x19*in_x26*2.0-t5*t6*t14*in_x4*in_x5*in_x9*in_x17*in_x18*in_x20*in_x25*2.0-t6*t11*t12*in_x2*in_x3*in_x6*in_x13*in_x17*in_x26*in_x27*2.0+t6*t11*t12*in_x2*in_x3*in_x6*in_x14*in_x16*in_x26*in_x27*2.0-t6*t11*t12*in_x2*in_x3*in_x6*in_x14*in_x18*in_x25*in_x26*2.0+t6*t11*t12*in_x2*in_x3*in_x6*in_x15*in_x17*in_x25*in_x26*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x13*in_x17*in_x26*in_x27*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x14*in_x16*in_x26*in_x27*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x14*in_x18*in_x25*in_x26*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x15*in_x17*in_x25*in_x26*2.0-t9*t11*t12*in_x2*in_x3*in_x7*in_x10*in_x17*in_x26*in_x27*2.0+t9*t11*t12*in_x2*in_x3*in_x7*in_x11*in_x16*in_x26*in_x27*2.0-t9*t11*t12*in_x2*in_x3*in_x7*in_x11*in_x18*in_x25*in_x26*2.0+t9*t11*t12*in_x2*in_x3*in_x7*in_x12*in_x17*in_x25*in_x26*2.0-t2*t13*t14*in_x6*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27+t2*t13*t14*in_x6*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26-t2*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27+t2*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26-t2*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26+t2*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25-t2*t13*t14*in_x6*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26+t2*t13*t14*in_x6*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25-t3*t5*t15*in_x3*in_x10*in_x11*in_x14*in_x17*in_x23*in_x24*2.0+t3*t5*t15*in_x3*in_x11*in_x12*in_x14*in_x17*in_x22*in_x23*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x10*in_x17*in_x26*in_x27*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x11*in_x16*in_x26*in_x27*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x11*in_x18*in_x25*in_x26*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x12*in_x17*in_x25*in_x26*2.0-t3*t4*t13*in_x7*in_x10*in_x11*in_x14*in_x17*in_x23*in_x24*2.0+t3*t4*t13*in_x7*in_x11*in_x12*in_x14*in_x17*in_x22*in_x23*2.0+t4*t6*t12*in_x4*in_x8*in_x9*in_x16*in_x17*in_x23*in_x27*2.0-t4*t6*t12*in_x4*in_x8*in_x9*in_x16*in_x17*in_x24*in_x26*2.0+t4*t6*t12*in_x4*in_x8*in_x9*in_x17*in_x18*in_x22*in_x26*2.0-t4*t6*t12*in_x4*in_x8*in_x9*in_x17*in_x18*in_x23*in_x25*2.0+t4*t6*t14*in_x5*in_x8*in_x9*in_x16*in_x17*in_x20*in_x27*2.0-t4*t6*t14*in_x5*in_x8*in_x9*in_x16*in_x17*in_x21*in_x26*2.0+t4*t6*t14*in_x5*in_x8*in_x9*in_x17*in_x18*in_x19*in_x26*2.0-t4*t6*t14*in_x5*in_x8*in_x9*in_x17*in_x18*in_x20*in_x25*2.0+t2*t13*t14*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24-t2*t13*t14*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23-t2*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24+t2*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23-t2*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23+t2*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22+t2*t13*t14*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23-t2*t13*t14*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t5*t6*t12*in_x4*in_x8*in_x9*in_x16*in_x17*in_x23*in_x27*2.0+t5*t6*t12*in_x4*in_x8*in_x9*in_x16*in_x17*in_x24*in_x26*2.0-t5*t6*t12*in_x4*in_x8*in_x9*in_x17*in_x18*in_x22*in_x26*2.0+t5*t6*t12*in_x4*in_x8*in_x9*in_x17*in_x18*in_x23*in_x25*2.0-t5*t6*t14*in_x5*in_x8*in_x9*in_x16*in_x17*in_x20*in_x27*2.0+t5*t6*t14*in_x5*in_x8*in_x9*in_x16*in_x17*in_x21*in_x26*2.0-t5*t6*t14*in_x5*in_x8*in_x9*in_x17*in_x18*in_x19*in_x26*2.0+t5*t6*t14*in_x5*in_x8*in_x9*in_x17*in_x18*in_x20*in_x25*2.0+t6*t11*t12*in_x2*in_x6*in_x7*in_x13*in_x17*in_x26*in_x27*2.0-t6*t11*t12*in_x2*in_x6*in_x7*in_x14*in_x16*in_x26*in_x27*2.0+t6*t11*t12*in_x2*in_x6*in_x7*in_x14*in_x18*in_x25*in_x26*2.0-t6*t11*t12*in_x2*in_x6*in_x7*in_x15*in_x17*in_x25*in_x26*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x13*in_x17*in_x26*in_x27*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x14*in_x16*in_x26*in_x27*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x14*in_x18*in_x25*in_x26*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x15*in_x17*in_x25*in_x26*2.0+t3*t4*t15*in_x7*in_x10*in_x11*in_x14*in_x17*in_x23*in_x24*2.0-t3*t4*t15*in_x7*in_x11*in_x12*in_x14*in_x17*in_x22*in_x23*2.0-t7*t9*t12*in_x4*in_x5*in_x8*in_x16*in_x17*in_x23*in_x27*2.0+t7*t9*t12*in_x4*in_x5*in_x8*in_x16*in_x17*in_x24*in_x26*2.0-t7*t9*t12*in_x4*in_x5*in_x8*in_x17*in_x18*in_x22*in_x26*2.0+t7*t9*t12*in_x4*in_x5*in_x8*in_x17*in_x18*in_x23*in_x25*2.0-t7*t9*t14*in_x4*in_x5*in_x9*in_x16*in_x17*in_x20*in_x27*2.0+t7*t9*t14*in_x4*in_x5*in_x9*in_x16*in_x17*in_x21*in_x26*2.0-t7*t9*t14*in_x4*in_x5*in_x9*in_x17*in_x18*in_x19*in_x26*2.0+t7*t9*t14*in_x4*in_x5*in_x9*in_x17*in_x18*in_x20*in_x25*2.0+t9*t11*t12*in_x3*in_x6*in_x7*in_x10*in_x17*in_x26*in_x27*2.0-t9*t11*t12*in_x3*in_x6*in_x7*in_x11*in_x16*in_x26*in_x27*2.0+t9*t11*t12*in_x3*in_x6*in_x7*in_x11*in_x18*in_x25*in_x26*2.0-t9*t11*t12*in_x3*in_x6*in_x7*in_x12*in_x17*in_x25*in_x26*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x10*in_x17*in_x26*in_x27*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x11*in_x16*in_x26*in_x27*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x11*in_x18*in_x25*in_x26*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x12*in_x17*in_x25*in_x26*2.0-t6*t14*t15*in_x2*in_x3*in_x6*in_x13*in_x17*in_x26*in_x27*2.0+t6*t14*t15*in_x2*in_x3*in_x6*in_x14*in_x16*in_x26*in_x27*2.0-t6*t14*t15*in_x2*in_x3*in_x6*in_x14*in_x18*in_x25*in_x26*2.0+t6*t14*t15*in_x2*in_x3*in_x6*in_x15*in_x17*in_x25*in_x26*2.0+t3*t10*t13*in_x2*in_x11*in_x13*in_x14*in_x17*in_x23*in_x24*2.0-t3*t10*t13*in_x2*in_x11*in_x14*in_x15*in_x17*in_x22*in_x23*2.0-t9*t14*t15*in_x2*in_x3*in_x7*in_x10*in_x17*in_x26*in_x27*2.0+t9*t14*t15*in_x2*in_x3*in_x7*in_x11*in_x16*in_x26*in_x27*2.0-t9*t14*t15*in_x2*in_x3*in_x7*in_x11*in_x18*in_x25*in_x26*2.0+t9*t14*t15*in_x2*in_x3*in_x7*in_x12*in_x17*in_x25*in_x26*2.0-t3*t7*t13*in_x6*in_x11*in_x13*in_x14*in_x17*in_x23*in_x24*2.0+t3*t7*t13*in_x6*in_x11*in_x14*in_x15*in_x17*in_x22*in_x23*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x13*in_x17*in_x26*in_x27*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x14*in_x16*in_x26*in_x27*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x14*in_x18*in_x25*in_x26*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x15*in_x17*in_x25*in_x26*2.0+t9*t10*t12*in_x4*in_x5*in_x8*in_x16*in_x17*in_x23*in_x27*2.0-t9*t10*t12*in_x4*in_x5*in_x8*in_x16*in_x17*in_x24*in_x26*2.0+t9*t10*t12*in_x4*in_x5*in_x8*in_x17*in_x18*in_x22*in_x26*2.0-t9*t10*t12*in_x4*in_x5*in_x8*in_x17*in_x18*in_x23*in_x25*2.0+t9*t10*t14*in_x4*in_x5*in_x9*in_x16*in_x17*in_x20*in_x27*2.0-t9*t10*t14*in_x4*in_x5*in_x9*in_x16*in_x17*in_x21*in_x26*2.0+t9*t10*t14*in_x4*in_x5*in_x9*in_x17*in_x18*in_x19*in_x26*2.0-t9*t10*t14*in_x4*in_x5*in_x9*in_x17*in_x18*in_x20*in_x25*2.0-t3*t10*t15*in_x2*in_x11*in_x13*in_x14*in_x17*in_x23*in_x24*2.0+t3*t10*t15*in_x2*in_x11*in_x14*in_x15*in_x17*in_x22*in_x23*2.0+t7*t9*t12*in_x4*in_x8*in_x9*in_x16*in_x17*in_x23*in_x27*2.0-t7*t9*t12*in_x4*in_x8*in_x9*in_x16*in_x17*in_x24*in_x26*2.0+t7*t9*t12*in_x4*in_x8*in_x9*in_x17*in_x18*in_x22*in_x26*2.0-t7*t9*t12*in_x4*in_x8*in_x9*in_x17*in_x18*in_x23*in_x25*2.0+t7*t9*t14*in_x5*in_x8*in_x9*in_x16*in_x17*in_x20*in_x27*2.0-t7*t9*t14*in_x5*in_x8*in_x9*in_x16*in_x17*in_x21*in_x26*2.0+t7*t9*t14*in_x5*in_x8*in_x9*in_x17*in_x18*in_x19*in_x26*2.0-t7*t9*t14*in_x5*in_x8*in_x9*in_x17*in_x18*in_x20*in_x25*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x10*in_x17*in_x26*in_x27*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x11*in_x16*in_x26*in_x27*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x11*in_x18*in_x25*in_x26*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x12*in_x17*in_x25*in_x26*2.0+t2*t4*t11*in_x5*in_x10*in_x11*in_x20*in_x21*in_x23*in_x26*2.0-t2*t4*t11*in_x5*in_x11*in_x12*in_x19*in_x20*in_x23*in_x26*2.0+t3*t7*t15*in_x6*in_x11*in_x13*in_x14*in_x17*in_x23*in_x24*2.0-t3*t7*t15*in_x6*in_x11*in_x14*in_x15*in_x17*in_x22*in_x23*2.0-t5*t8*t12*in_x3*in_x10*in_x11*in_x14*in_x17*in_x26*in_x27*2.0+t5*t8*t12*in_x3*in_x11*in_x12*in_x14*in_x17*in_x25*in_x26*2.0+t6*t14*t15*in_x2*in_x6*in_x7*in_x13*in_x17*in_x26*in_x27*2.0-t6*t14*t15*in_x2*in_x6*in_x7*in_x14*in_x16*in_x26*in_x27*2.0+t6*t14*t15*in_x2*in_x6*in_x7*in_x14*in_x18*in_x25*in_x26*2.0-t6*t14*t15*in_x2*in_x6*in_x7*in_x15*in_x17*in_x25*in_x26*2.0-t2*t4*t8*in_x9*in_x10*in_x11*in_x20*in_x21*in_x23*in_x26*2.0+t2*t4*t8*in_x9*in_x11*in_x12*in_x19*in_x20*in_x23*in_x26*2.0-t2*t5*t11*in_x5*in_x10*in_x11*in_x20*in_x21*in_x23*in_x26*2.0+t2*t5*t11*in_x5*in_x11*in_x12*in_x19*in_x20*in_x23*in_x26*2.0+t9*t14*t15*in_x3*in_x6*in_x7*in_x10*in_x17*in_x26*in_x27*2.0-t9*t14*t15*in_x3*in_x6*in_x7*in_x11*in_x16*in_x26*in_x27*2.0+t9*t14*t15*in_x3*in_x6*in_x7*in_x11*in_x18*in_x25*in_x26*2.0-t9*t14*t15*in_x3*in_x6*in_x7*in_x12*in_x17*in_x25*in_x26*2.0+t2*t5*t8*in_x9*in_x10*in_x11*in_x20*in_x21*in_x23*in_x26*2.0-t2*t5*t8*in_x9*in_x11*in_x12*in_x19*in_x20*in_x23*in_x26*2.0-t9*t10*t12*in_x4*in_x8*in_x9*in_x16*in_x17*in_x23*in_x27*2.0+t9*t10*t12*in_x4*in_x8*in_x9*in_x16*in_x17*in_x24*in_x26*2.0-t9*t10*t12*in_x4*in_x8*in_x9*in_x17*in_x18*in_x22*in_x26*2.0+t9*t10*t12*in_x4*in_x8*in_x9*in_x17*in_x18*in_x23*in_x25*2.0-t9*t10*t14*in_x5*in_x8*in_x9*in_x16*in_x17*in_x20*in_x27*2.0+t9*t10*t14*in_x5*in_x8*in_x9*in_x16*in_x17*in_x21*in_x26*2.0-t9*t10*t14*in_x5*in_x8*in_x9*in_x17*in_x18*in_x19*in_x26*2.0+t9*t10*t14*in_x5*in_x8*in_x9*in_x17*in_x18*in_x20*in_x25*2.0+t4*t8*t12*in_x7*in_x10*in_x11*in_x14*in_x17*in_x26*in_x27*2.0-t4*t8*t12*in_x7*in_x11*in_x12*in_x14*in_x17*in_x25*in_x26*2.0+t5*t11*t12*in_x3*in_x10*in_x11*in_x14*in_x17*in_x26*in_x27*2.0-t5*t11*t12*in_x3*in_x11*in_x12*in_x14*in_x17*in_x25*in_x26*2.0+t2*t4*t15*in_x4*in_x10*in_x11*in_x20*in_x23*in_x24*in_x26*2.0-t2*t4*t15*in_x4*in_x11*in_x12*in_x20*in_x22*in_x23*in_x26*2.0-t4*t11*t12*in_x7*in_x10*in_x11*in_x14*in_x17*in_x26*in_x27*2.0+t4*t11*t12*in_x7*in_x11*in_x12*in_x14*in_x17*in_x25*in_x26*2.0-t2*t5*t15*in_x4*in_x10*in_x11*in_x20*in_x23*in_x24*in_x26*2.0+t2*t5*t15*in_x4*in_x11*in_x12*in_x20*in_x22*in_x23*in_x26*2.0-t5*t13*t14*in_x3*in_x10*in_x11*in_x14*in_x17*in_x26*in_x27*2.0+t5*t13*t14*in_x3*in_x11*in_x12*in_x14*in_x17*in_x25*in_x26*2.0-t8*t10*t12*in_x2*in_x11*in_x13*in_x14*in_x17*in_x26*in_x27*2.0+t8*t10*t12*in_x2*in_x11*in_x14*in_x15*in_x17*in_x25*in_x26*2.0-t2*t4*t13*in_x8*in_x10*in_x11*in_x20*in_x23*in_x24*in_x26*2.0+t2*t4*t13*in_x8*in_x11*in_x12*in_x20*in_x22*in_x23*in_x26*2.0+t7*t8*t12*in_x6*in_x11*in_x13*in_x14*in_x17*in_x26*in_x27*2.0-t7*t8*t12*in_x6*in_x11*in_x14*in_x15*in_x17*in_x25*in_x26*2.0+t2*t5*t13*in_x8*in_x10*in_x11*in_x20*in_x23*in_x24*in_x26*2.0-t2*t5*t13*in_x8*in_x11*in_x12*in_x20*in_x22*in_x23*in_x26*2.0+t2*t7*t11*in_x5*in_x13*in_x14*in_x20*in_x21*in_x23*in_x26*2.0-t2*t7*t11*in_x5*in_x14*in_x15*in_x19*in_x20*in_x23*in_x26*2.0+t5*t14*t15*in_x3*in_x10*in_x11*in_x14*in_x17*in_x26*in_x27*2.0-t5*t14*t15*in_x3*in_x11*in_x12*in_x14*in_x17*in_x25*in_x26*2.0-t2*t7*t8*in_x9*in_x13*in_x14*in_x20*in_x21*in_x23*in_x26*2.0+t2*t7*t8*in_x9*in_x14*in_x15*in_x19*in_x20*in_x23*in_x26*2.0+t4*t13*t14*in_x7*in_x10*in_x11*in_x14*in_x17*in_x26*in_x27*2.0-t4*t13*t14*in_x7*in_x11*in_x12*in_x14*in_x17*in_x25*in_x26*2.0+t10*t11*t12*in_x2*in_x11*in_x13*in_x14*in_x17*in_x26*in_x27*2.0-t10*t11*t12*in_x2*in_x11*in_x14*in_x15*in_x17*in_x25*in_x26*2.0-t7*t11*t12*in_x6*in_x11*in_x13*in_x14*in_x17*in_x26*in_x27*2.0+t7*t11*t12*in_x6*in_x11*in_x14*in_x15*in_x17*in_x25*in_x26*2.0-t2*t10*t11*in_x5*in_x13*in_x14*in_x20*in_x21*in_x23*in_x26*2.0+t2*t10*t11*in_x5*in_x14*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t4*t14*t15*in_x7*in_x10*in_x11*in_x14*in_x17*in_x26*in_x27*2.0+t4*t14*t15*in_x7*in_x11*in_x12*in_x14*in_x17*in_x25*in_x26*2.0+t2*t8*t10*in_x9*in_x13*in_x14*in_x20*in_x21*in_x23*in_x26*2.0-t2*t8*t10*in_x9*in_x14*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t10*t13*t14*in_x2*in_x11*in_x13*in_x14*in_x17*in_x26*in_x27*2.0+t10*t13*t14*in_x2*in_x11*in_x14*in_x15*in_x17*in_x25*in_x26*2.0+t2*t7*t15*in_x4*in_x13*in_x14*in_x20*in_x23*in_x24*in_x26*2.0-t2*t7*t15*in_x4*in_x14*in_x15*in_x20*in_x22*in_x23*in_x26*2.0+t7*t13*t14*in_x6*in_x11*in_x13*in_x14*in_x17*in_x26*in_x27*2.0-t7*t13*t14*in_x6*in_x11*in_x14*in_x15*in_x17*in_x25*in_x26*2.0-t4*t6*t11*in_x5*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t4*t6*t11*in_x5*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t10*t14*t15*in_x2*in_x11*in_x13*in_x14*in_x17*in_x26*in_x27*2.0-t10*t14*t15*in_x2*in_x11*in_x14*in_x15*in_x17*in_x25*in_x26*2.0-t2*t7*t13*in_x8*in_x13*in_x14*in_x20*in_x23*in_x24*in_x26*2.0+t2*t7*t13*in_x8*in_x14*in_x15*in_x20*in_x22*in_x23*in_x26*2.0+t4*t6*t8*in_x9*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t4*t6*t8*in_x9*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t11*in_x5*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t5*t6*t11*in_x5*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t7*t14*t15*in_x6*in_x11*in_x13*in_x14*in_x17*in_x26*in_x27*2.0+t7*t14*t15*in_x6*in_x11*in_x14*in_x15*in_x17*in_x25*in_x26*2.0-t2*t10*t15*in_x4*in_x13*in_x14*in_x20*in_x23*in_x24*in_x26*2.0+t2*t10*t15*in_x4*in_x14*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t5*t6*t8*in_x9*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t5*t6*t8*in_x9*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t2*t10*t13*in_x8*in_x13*in_x14*in_x20*in_x23*in_x24*in_x26*2.0-t2*t10*t13*in_x8*in_x14*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t4*t6*t15*in_x4*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t4*t6*t15*in_x4*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t7*t9*t11*in_x5*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t7*t9*t11*in_x5*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t15*in_x4*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t5*t6*t15*in_x4*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t7*t8*t9*in_x9*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t7*t8*t9*in_x9*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t4*t6*t13*in_x8*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t4*t6*t13*in_x8*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t5*t6*t13*in_x8*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t5*t6*t13*in_x8*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t9*t10*t11*in_x5*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t9*t10*t11*in_x5*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t8*t9*t10*in_x9*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t8*t9*t10*in_x9*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t7*t9*t15*in_x4*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t7*t9*t15*in_x4*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t7*t9*t13*in_x8*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t7*t9*t13*in_x8*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t9*t10*t15*in_x4*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t9*t10*t15*in_x4*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t9*t10*t13*in_x8*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t9*t10*t13*in_x8*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t3*t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x13*in_x17*in_x20*in_x24*2.0-t3*t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x13*in_x17*in_x21*in_x23*2.0+t3*t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x16*in_x20*in_x24*2.0+t3*t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x16*in_x21*in_x23*2.0-t3*t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x18*in_x19*in_x23*2.0-t3*t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x18*in_x20*in_x22*2.0+t3*t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x15*in_x17*in_x19*in_x23*2.0+t3*t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x15*in_x17*in_x20*in_x22*2.0-t3*t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x10*in_x17*in_x20*in_x24*2.0-t3*t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x10*in_x17*in_x21*in_x23*2.0+t3*t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x16*in_x20*in_x24*2.0+t3*t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x16*in_x21*in_x23*2.0-t3*t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x18*in_x19*in_x23*2.0-t3*t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x18*in_x20*in_x22*2.0+t3*t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x12*in_x17*in_x19*in_x23*2.0+t3*t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x12*in_x17*in_x20*in_x22*2.0+t3*t6*in_x2*in_x3*in_x4*in_x6*in_x9*in_x13*in_x17*in_x20*in_x24*4.0-t3*t6*in_x2*in_x3*in_x4*in_x6*in_x9*in_x13*in_x17*in_x21*in_x23*4.0-t3*t6*in_x2*in_x3*in_x4*in_x6*in_x9*in_x14*in_x16*in_x20*in_x24*4.0+t3*t6*in_x2*in_x3*in_x4*in_x6*in_x9*in_x14*in_x16*in_x21*in_x23*4.0-t3*t6*in_x2*in_x3*in_x4*in_x6*in_x9*in_x14*in_x18*in_x19*in_x23*4.0+t3*t6*in_x2*in_x3*in_x4*in_x6*in_x9*in_x14*in_x18*in_x20*in_x22*4.0+t3*t6*in_x2*in_x3*in_x4*in_x6*in_x9*in_x15*in_x17*in_x19*in_x23*4.0-t3*t6*in_x2*in_x3*in_x4*in_x6*in_x9*in_x15*in_x17*in_x20*in_x22*4.0-t3*t6*in_x2*in_x3*in_x5*in_x6*in_x8*in_x13*in_x17*in_x20*in_x24*4.0+t3*t6*in_x2*in_x3*in_x5*in_x6*in_x8*in_x13*in_x17*in_x21*in_x23*4.0+t3*t6*in_x2*in_x3*in_x5*in_x6*in_x8*in_x14*in_x16*in_x20*in_x24*4.0-t3*t6*in_x2*in_x3*in_x5*in_x6*in_x8*in_x14*in_x16*in_x21*in_x23*4.0+t3*t6*in_x2*in_x3*in_x5*in_x6*in_x8*in_x14*in_x18*in_x19*in_x23*4.0-t3*t6*in_x2*in_x3*in_x5*in_x6*in_x8*in_x14*in_x18*in_x20*in_x22*4.0-t3*t6*in_x2*in_x3*in_x5*in_x6*in_x8*in_x15*in_x17*in_x19*in_x23*4.0+t3*t6*in_x2*in_x3*in_x5*in_x6*in_x8*in_x15*in_x17*in_x20*in_x22*4.0+t3*t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x13*in_x17*in_x20*in_x24*2.0+t3*t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x13*in_x17*in_x21*in_x23*2.0-t3*t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x16*in_x20*in_x24*2.0-t3*t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x16*in_x21*in_x23*2.0+t3*t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x18*in_x19*in_x23*2.0+t3*t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x18*in_x20*in_x22*2.0-t3*t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x15*in_x17*in_x19*in_x23*2.0-t3*t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x15*in_x17*in_x20*in_x22*2.0+t3*t9*in_x2*in_x3*in_x4*in_x7*in_x9*in_x10*in_x17*in_x20*in_x24*4.0-t3*t9*in_x2*in_x3*in_x4*in_x7*in_x9*in_x10*in_x17*in_x21*in_x23*4.0-t3*t9*in_x2*in_x3*in_x4*in_x7*in_x9*in_x11*in_x16*in_x20*in_x24*4.0+t3*t9*in_x2*in_x3*in_x4*in_x7*in_x9*in_x11*in_x16*in_x21*in_x23*4.0-t3*t9*in_x2*in_x3*in_x4*in_x7*in_x9*in_x11*in_x18*in_x19*in_x23*4.0+t3*t9*in_x2*in_x3*in_x4*in_x7*in_x9*in_x11*in_x18*in_x20*in_x22*4.0+t3*t9*in_x2*in_x3*in_x4*in_x7*in_x9*in_x12*in_x17*in_x19*in_x23*4.0-t3*t9*in_x2*in_x3*in_x4*in_x7*in_x9*in_x12*in_x17*in_x20*in_x22*4.0-t3*t9*in_x2*in_x3*in_x5*in_x7*in_x8*in_x10*in_x17*in_x20*in_x24*4.0+t3*t9*in_x2*in_x3*in_x5*in_x7*in_x8*in_x10*in_x17*in_x21*in_x23*4.0+t3*t9*in_x2*in_x3*in_x5*in_x7*in_x8*in_x11*in_x16*in_x20*in_x24*4.0-t3*t9*in_x2*in_x3*in_x5*in_x7*in_x8*in_x11*in_x16*in_x21*in_x23*4.0+t3*t9*in_x2*in_x3*in_x5*in_x7*in_x8*in_x11*in_x18*in_x19*in_x23*4.0-t3*t9*in_x2*in_x3*in_x5*in_x7*in_x8*in_x11*in_x18*in_x20*in_x22*4.0-t3*t9*in_x2*in_x3*in_x5*in_x7*in_x8*in_x12*in_x17*in_x19*in_x23*4.0+t3*t9*in_x2*in_x3*in_x5*in_x7*in_x8*in_x12*in_x17*in_x20*in_x22*4.0+t3*t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x10*in_x17*in_x20*in_x24*2.0+t3*t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x10*in_x17*in_x21*in_x23*2.0-t3*t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x16*in_x20*in_x24*2.0-t3*t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x16*in_x21*in_x23*2.0+t3*t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x18*in_x19*in_x23*2.0+t3*t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x18*in_x20*in_x22*2.0-t3*t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x12*in_x17*in_x19*in_x23*2.0-t3*t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x12*in_x17*in_x20*in_x22*2.0+t2*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x10*in_x14*in_x23*in_x27*2.0-t2*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x10*in_x14*in_x24*in_x26*2.0+t2*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x13*in_x23*in_x27*2.0-t2*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x13*in_x24*in_x26*2.0+t2*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x15*in_x22*in_x26*2.0-t2*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x15*in_x23*in_x25*2.0+t2*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x12*in_x14*in_x22*in_x26*2.0-t2*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x12*in_x14*in_x23*in_x25*2.0+t2*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x10*in_x14*in_x20*in_x27*2.0-t2*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x10*in_x14*in_x21*in_x26*2.0+t2*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x13*in_x20*in_x27*2.0-t2*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x13*in_x21*in_x26*2.0+t2*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x15*in_x19*in_x26*2.0-t2*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x15*in_x20*in_x25*2.0+t2*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x12*in_x14*in_x19*in_x26*2.0-t2*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x12*in_x14*in_x20*in_x25*2.0+t3*t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24*2.0+t3*t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23*2.0-t3*t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24*2.0-t3*t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23*2.0+t3*t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23*2.0+t3*t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22*2.0-t3*t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23*2.0-t3*t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22*2.0-t3*t6*in_x2*in_x4*in_x6*in_x7*in_x9*in_x13*in_x17*in_x20*in_x24*4.0+t3*t6*in_x2*in_x4*in_x6*in_x7*in_x9*in_x13*in_x17*in_x21*in_x23*4.0+t3*t6*in_x2*in_x4*in_x6*in_x7*in_x9*in_x14*in_x16*in_x20*in_x24*4.0-t3*t6*in_x2*in_x4*in_x6*in_x7*in_x9*in_x14*in_x16*in_x21*in_x23*4.0+t3*t6*in_x2*in_x4*in_x6*in_x7*in_x9*in_x14*in_x18*in_x19*in_x23*4.0-t3*t6*in_x2*in_x4*in_x6*in_x7*in_x9*in_x14*in_x18*in_x20*in_x22*4.0-t3*t6*in_x2*in_x4*in_x6*in_x7*in_x9*in_x15*in_x17*in_x19*in_x23*4.0+t3*t6*in_x2*in_x4*in_x6*in_x7*in_x9*in_x15*in_x17*in_x20*in_x22*4.0+t3*t6*in_x2*in_x5*in_x6*in_x7*in_x8*in_x13*in_x17*in_x20*in_x24*4.0-t3*t6*in_x2*in_x5*in_x6*in_x7*in_x8*in_x13*in_x17*in_x21*in_x23*4.0-t3*t6*in_x2*in_x5*in_x6*in_x7*in_x8*in_x14*in_x16*in_x20*in_x24*4.0+t3*t6*in_x2*in_x5*in_x6*in_x7*in_x8*in_x14*in_x16*in_x21*in_x23*4.0-t3*t6*in_x2*in_x5*in_x6*in_x7*in_x8*in_x14*in_x18*in_x19*in_x23*4.0+t3*t6*in_x2*in_x5*in_x6*in_x7*in_x8*in_x14*in_x18*in_x20*in_x22*4.0+t3*t6*in_x2*in_x5*in_x6*in_x7*in_x8*in_x15*in_x17*in_x19*in_x23*4.0-t3*t6*in_x2*in_x5*in_x6*in_x7*in_x8*in_x15*in_x17*in_x20*in_x22*4.0+t3*t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24*2.0+t3*t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23*2.0-t3*t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24*2.0-t3*t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23*2.0+t3*t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23*2.0+t3*t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22*2.0-t3*t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23*2.0-t3*t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22*2.0-t3*t9*in_x3*in_x4*in_x6*in_x7*in_x9*in_x10*in_x17*in_x20*in_x24*4.0+t3*t9*in_x3*in_x4*in_x6*in_x7*in_x9*in_x10*in_x17*in_x21*in_x23*4.0+t3*t9*in_x3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x16*in_x20*in_x24*4.0-t3*t9*in_x3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x16*in_x21*in_x23*4.0+t3*t9*in_x3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x18*in_x19*in_x23*4.0-t3*t9*in_x3*in_x4*in_x6*in_x7*in_x9*in_x11*in_x18*in_x20*in_x22*4.0-t3*t9*in_x3*in_x4*in_x6*in_x7*in_x9*in_x12*in_x17*in_x19*in_x23*4.0+t3*t9*in_x3*in_x4*in_x6*in_x7*in_x9*in_x12*in_x17*in_x20*in_x22*4.0+t3*t9*in_x3*in_x5*in_x6*in_x7*in_x8*in_x10*in_x17*in_x20*in_x24*4.0-t3*t9*in_x3*in_x5*in_x6*in_x7*in_x8*in_x10*in_x17*in_x21*in_x23*4.0-t3*t9*in_x3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x16*in_x20*in_x24*4.0+t3*t9*in_x3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x16*in_x21*in_x23*4.0-t3*t9*in_x3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x18*in_x19*in_x23*4.0+t3*t9*in_x3*in_x5*in_x6*in_x7*in_x8*in_x11*in_x18*in_x20*in_x22*4.0+t3*t9*in_x3*in_x5*in_x6*in_x7*in_x8*in_x12*in_x17*in_x19*in_x23*4.0-t3*t9*in_x3*in_x5*in_x6*in_x7*in_x8*in_x12*in_x17*in_x20*in_x22*4.0-t2*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x10*in_x14*in_x23*in_x27*2.0+t2*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x10*in_x14*in_x24*in_x26*2.0-t2*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x13*in_x23*in_x27*2.0+t2*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x13*in_x24*in_x26*2.0-t2*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x15*in_x22*in_x26*2.0+t2*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x15*in_x23*in_x25*2.0-t2*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x12*in_x14*in_x22*in_x26*2.0+t2*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x12*in_x14*in_x23*in_x25*2.0+t2*t12*in_x2*in_x4*in_x5*in_x7*in_x8*in_x10*in_x14*in_x23*in_x27*4.0-t2*t12*in_x2*in_x4*in_x5*in_x7*in_x8*in_x10*in_x14*in_x24*in_x26*4.0-t2*t12*in_x2*in_x4*in_x5*in_x7*in_x8*in_x11*in_x13*in_x23*in_x27*4.0+t2*t12*in_x2*in_x4*in_x5*in_x7*in_x8*in_x11*in_x13*in_x24*in_x26*4.0-t2*t12*in_x2*in_x4*in_x5*in_x7*in_x8*in_x11*in_x15*in_x22*in_x26*4.0+t2*t12*in_x2*in_x4*in_x5*in_x7*in_x8*in_x11*in_x15*in_x23*in_x25*4.0+t2*t12*in_x2*in_x4*in_x5*in_x7*in_x8*in_x12*in_x14*in_x22*in_x26*4.0-t2*t12*in_x2*in_x4*in_x5*in_x7*in_x8*in_x12*in_x14*in_x23*in_x25*4.0-t2*t12*in_x3*in_x4*in_x5*in_x6*in_x8*in_x10*in_x14*in_x23*in_x27*4.0+t2*t12*in_x3*in_x4*in_x5*in_x6*in_x8*in_x10*in_x14*in_x24*in_x26*4.0+t2*t12*in_x3*in_x4*in_x5*in_x6*in_x8*in_x11*in_x13*in_x23*in_x27*4.0-t2*t12*in_x3*in_x4*in_x5*in_x6*in_x8*in_x11*in_x13*in_x24*in_x26*4.0+t2*t12*in_x3*in_x4*in_x5*in_x6*in_x8*in_x11*in_x15*in_x22*in_x26*4.0-t2*t12*in_x3*in_x4*in_x5*in_x6*in_x8*in_x11*in_x15*in_x23*in_x25*4.0-t2*t12*in_x3*in_x4*in_x5*in_x6*in_x8*in_x12*in_x14*in_x22*in_x26*4.0+t2*t12*in_x3*in_x4*in_x5*in_x6*in_x8*in_x12*in_x14*in_x23*in_x25*4.0-t2*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x10*in_x14*in_x20*in_x27*2.0+t2*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x10*in_x14*in_x21*in_x26*2.0-t2*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x13*in_x20*in_x27*2.0+t2*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x13*in_x21*in_x26*2.0-t2*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x15*in_x19*in_x26*2.0+t2*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x15*in_x20*in_x25*2.0-t2*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x12*in_x14*in_x19*in_x26*2.0+t2*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x12*in_x14*in_x20*in_x25*2.0+t2*t14*in_x2*in_x4*in_x5*in_x7*in_x9*in_x10*in_x14*in_x20*in_x27*4.0-t2*t14*in_x2*in_x4*in_x5*in_x7*in_x9*in_x10*in_x14*in_x21*in_x26*4.0-t2*t14*in_x2*in_x4*in_x5*in_x7*in_x9*in_x11*in_x13*in_x20*in_x27*4.0+t2*t14*in_x2*in_x4*in_x5*in_x7*in_x9*in_x11*in_x13*in_x21*in_x26*4.0-t2*t14*in_x2*in_x4*in_x5*in_x7*in_x9*in_x11*in_x15*in_x19*in_x26*4.0+t2*t14*in_x2*in_x4*in_x5*in_x7*in_x9*in_x11*in_x15*in_x20*in_x25*4.0+t2*t14*in_x2*in_x4*in_x5*in_x7*in_x9*in_x12*in_x14*in_x19*in_x26*4.0-t2*t14*in_x2*in_x4*in_x5*in_x7*in_x9*in_x12*in_x14*in_x20*in_x25*4.0-t2*t14*in_x3*in_x4*in_x5*in_x6*in_x9*in_x10*in_x14*in_x20*in_x27*4.0+t2*t14*in_x3*in_x4*in_x5*in_x6*in_x9*in_x10*in_x14*in_x21*in_x26*4.0+t2*t14*in_x3*in_x4*in_x5*in_x6*in_x9*in_x11*in_x13*in_x20*in_x27*4.0-t2*t14*in_x3*in_x4*in_x5*in_x6*in_x9*in_x11*in_x13*in_x21*in_x26*4.0+t2*t14*in_x3*in_x4*in_x5*in_x6*in_x9*in_x11*in_x15*in_x19*in_x26*4.0-t2*t14*in_x3*in_x4*in_x5*in_x6*in_x9*in_x11*in_x15*in_x20*in_x25*4.0-t2*t14*in_x3*in_x4*in_x5*in_x6*in_x9*in_x12*in_x14*in_x19*in_x26*4.0+t2*t14*in_x3*in_x4*in_x5*in_x6*in_x9*in_x12*in_x14*in_x20*in_x25*4.0-t3*t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24*2.0-t3*t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23*2.0+t3*t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24*2.0+t3*t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23*2.0-t3*t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23*2.0-t3*t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22*2.0+t3*t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23*2.0+t3*t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22*2.0+t3*t5*in_x3*in_x4*in_x5*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0+t3*t5*in_x3*in_x4*in_x5*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0-t3*t5*in_x3*in_x4*in_x5*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0-t3*t5*in_x3*in_x4*in_x5*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0-t3*t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24*2.0-t3*t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23*2.0+t3*t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24*2.0+t3*t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23*2.0-t3*t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23*2.0-t3*t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22*2.0+t3*t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23*2.0+t3*t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22*2.0-t2*t12*in_x2*in_x4*in_x7*in_x8*in_x9*in_x10*in_x14*in_x23*in_x27*4.0+t2*t12*in_x2*in_x4*in_x7*in_x8*in_x9*in_x10*in_x14*in_x24*in_x26*4.0+t2*t12*in_x2*in_x4*in_x7*in_x8*in_x9*in_x11*in_x13*in_x23*in_x27*4.0-t2*t12*in_x2*in_x4*in_x7*in_x8*in_x9*in_x11*in_x13*in_x24*in_x26*4.0+t2*t12*in_x2*in_x4*in_x7*in_x8*in_x9*in_x11*in_x15*in_x22*in_x26*4.0-t2*t12*in_x2*in_x4*in_x7*in_x8*in_x9*in_x11*in_x15*in_x23*in_x25*4.0-t2*t12*in_x2*in_x4*in_x7*in_x8*in_x9*in_x12*in_x14*in_x22*in_x26*4.0+t2*t12*in_x2*in_x4*in_x7*in_x8*in_x9*in_x12*in_x14*in_x23*in_x25*4.0+t2*t12*in_x3*in_x4*in_x6*in_x8*in_x9*in_x10*in_x14*in_x23*in_x27*4.0-t2*t12*in_x3*in_x4*in_x6*in_x8*in_x9*in_x10*in_x14*in_x24*in_x26*4.0-t2*t12*in_x3*in_x4*in_x6*in_x8*in_x9*in_x11*in_x13*in_x23*in_x27*4.0+t2*t12*in_x3*in_x4*in_x6*in_x8*in_x9*in_x11*in_x13*in_x24*in_x26*4.0-t2*t12*in_x3*in_x4*in_x6*in_x8*in_x9*in_x11*in_x15*in_x22*in_x26*4.0+t2*t12*in_x3*in_x4*in_x6*in_x8*in_x9*in_x11*in_x15*in_x23*in_x25*4.0+t2*t12*in_x3*in_x4*in_x6*in_x8*in_x9*in_x12*in_x14*in_x22*in_x26*4.0-t2*t12*in_x3*in_x4*in_x6*in_x8*in_x9*in_x12*in_x14*in_x23*in_x25*4.0-t2*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x23*in_x27*2.0+t2*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x24*in_x26*2.0-t2*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x23*in_x27*2.0+t2*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x24*in_x26*2.0-t2*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x22*in_x26*2.0+t2*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x23*in_x25*2.0-t2*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x22*in_x26*2.0+t2*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x23*in_x25*2.0-t2*t14*in_x2*in_x5*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x27*4.0+t2*t14*in_x2*in_x5*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x26*4.0+t2*t14*in_x2*in_x5*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x27*4.0-t2*t14*in_x2*in_x5*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x26*4.0+t2*t14*in_x2*in_x5*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x26*4.0-t2*t14*in_x2*in_x5*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x25*4.0-t2*t14*in_x2*in_x5*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x26*4.0+t2*t14*in_x2*in_x5*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x25*4.0+t2*t14*in_x3*in_x5*in_x6*in_x8*in_x9*in_x10*in_x14*in_x20*in_x27*4.0-t2*t14*in_x3*in_x5*in_x6*in_x8*in_x9*in_x10*in_x14*in_x21*in_x26*4.0-t2*t14*in_x3*in_x5*in_x6*in_x8*in_x9*in_x11*in_x13*in_x20*in_x27*4.0+t2*t14*in_x3*in_x5*in_x6*in_x8*in_x9*in_x11*in_x13*in_x21*in_x26*4.0-t2*t14*in_x3*in_x5*in_x6*in_x8*in_x9*in_x11*in_x15*in_x19*in_x26*4.0+t2*t14*in_x3*in_x5*in_x6*in_x8*in_x9*in_x11*in_x15*in_x20*in_x25*4.0+t2*t14*in_x3*in_x5*in_x6*in_x8*in_x9*in_x12*in_x14*in_x19*in_x26*4.0-t2*t14*in_x3*in_x5*in_x6*in_x8*in_x9*in_x12*in_x14*in_x20*in_x25*4.0-t2*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x10*in_x14*in_x20*in_x27*2.0+t2*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x10*in_x14*in_x21*in_x26*2.0-t2*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x13*in_x20*in_x27*2.0+t2*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x13*in_x21*in_x26*2.0-t2*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x15*in_x19*in_x26*2.0+t2*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x15*in_x20*in_x25*2.0-t2*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x12*in_x14*in_x19*in_x26*2.0+t2*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x12*in_x14*in_x20*in_x25*2.0-t3*t4*in_x4*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0-t3*t4*in_x4*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0+t3*t4*in_x4*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0+t3*t4*in_x4*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0-t3*t5*in_x3*in_x4*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*4.0+t3*t5*in_x3*in_x4*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*4.0-t3*t5*in_x3*in_x4*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*4.0+t3*t5*in_x3*in_x4*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*4.0+t3*t5*in_x3*in_x5*in_x8*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*4.0-t3*t5*in_x3*in_x5*in_x8*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*4.0+t3*t5*in_x3*in_x5*in_x8*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*4.0-t3*t5*in_x3*in_x5*in_x8*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*4.0+t2*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x23*in_x27*2.0-t2*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x24*in_x26*2.0+t2*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x23*in_x27*2.0-t2*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x24*in_x26*2.0+t2*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x22*in_x26*2.0-t2*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x23*in_x25*2.0+t2*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x22*in_x26*2.0-t2*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x23*in_x25*2.0+t2*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x27*2.0-t2*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x26*2.0+t2*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x27*2.0-t2*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x26*2.0+t2*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x26*2.0-t2*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x25*2.0+t2*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x26*2.0-t2*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x25*2.0+t3*t4*in_x4*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*4.0-t3*t4*in_x4*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*4.0+t3*t4*in_x4*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*4.0-t3*t4*in_x4*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*4.0-t3*t4*in_x5*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*4.0+t3*t4*in_x5*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*4.0-t3*t4*in_x5*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*4.0+t3*t4*in_x5*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*4.0+t3*t10*in_x2*in_x4*in_x5*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0+t3*t10*in_x2*in_x4*in_x5*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0-t3*t10*in_x2*in_x4*in_x5*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0-t3*t10*in_x2*in_x4*in_x5*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0-t3*t5*in_x3*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0-t3*t5*in_x3*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0+t3*t5*in_x3*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0+t3*t5*in_x3*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0-t3*t7*in_x4*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0-t3*t7*in_x4*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0+t3*t7*in_x4*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0+t3*t7*in_x4*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0+t3*t4*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0+t3*t4*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0-t3*t4*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0-t3*t4*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0-t3*t10*in_x2*in_x4*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*4.0+t3*t10*in_x2*in_x4*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*4.0-t3*t10*in_x2*in_x4*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*4.0+t3*t10*in_x2*in_x4*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*4.0+t3*t10*in_x2*in_x5*in_x8*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*4.0-t3*t10*in_x2*in_x5*in_x8*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*4.0+t3*t10*in_x2*in_x5*in_x8*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*4.0-t3*t10*in_x2*in_x5*in_x8*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*4.0+t3*t7*in_x4*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*4.0-t3*t7*in_x4*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*4.0+t3*t7*in_x4*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*4.0-t3*t7*in_x4*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*4.0-t3*t7*in_x5*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*4.0+t3*t7*in_x5*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*4.0-t3*t7*in_x5*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*4.0+t3*t7*in_x5*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*4.0-t3*t10*in_x2*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0-t3*t10*in_x2*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0+t3*t10*in_x2*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0+t3*t10*in_x2*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0+t3*t7*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0+t3*t7*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0-t3*t7*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0-t3*t7*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0+t2*t11*in_x2*in_x3*in_x5*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0+t2*t11*in_x2*in_x3*in_x5*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0-t2*t11*in_x2*in_x3*in_x5*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t2*t11*in_x2*in_x3*in_x5*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0+t11*t12*in_x2*in_x3*in_x4*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0-t11*t12*in_x2*in_x3*in_x4*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0+t11*t12*in_x2*in_x3*in_x4*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0-t11*t12*in_x2*in_x3*in_x4*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0-t2*t8*in_x2*in_x3*in_x9*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0-t2*t8*in_x2*in_x3*in_x9*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0+t2*t8*in_x2*in_x3*in_x9*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0+t2*t8*in_x2*in_x3*in_x9*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0-t8*t12*in_x2*in_x3*in_x8*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0+t8*t12*in_x2*in_x3*in_x8*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0-t8*t12*in_x2*in_x3*in_x8*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0+t8*t12*in_x2*in_x3*in_x8*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0+t2*t11*in_x2*in_x5*in_x7*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*4.0-t2*t11*in_x2*in_x5*in_x7*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*4.0+t2*t11*in_x2*in_x5*in_x7*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*4.0-t2*t11*in_x2*in_x5*in_x7*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*4.0-t2*t11*in_x3*in_x5*in_x6*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*4.0+t2*t11*in_x3*in_x5*in_x6*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*4.0-t2*t11*in_x3*in_x5*in_x6*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*4.0+t2*t11*in_x3*in_x5*in_x6*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*4.0+t11*t12*in_x2*in_x3*in_x5*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0+t11*t12*in_x2*in_x3*in_x5*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0-t11*t12*in_x2*in_x3*in_x5*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0-t11*t12*in_x2*in_x3*in_x5*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0-t2*t8*in_x2*in_x7*in_x9*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*4.0+t2*t8*in_x2*in_x7*in_x9*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*4.0-t2*t8*in_x2*in_x7*in_x9*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*4.0+t2*t8*in_x2*in_x7*in_x9*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*4.0+t2*t8*in_x3*in_x6*in_x9*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*4.0-t2*t8*in_x3*in_x6*in_x9*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*4.0+t2*t8*in_x3*in_x6*in_x9*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*4.0-t2*t8*in_x3*in_x6*in_x9*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*4.0-t8*t12*in_x2*in_x3*in_x9*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0-t8*t12*in_x2*in_x3*in_x9*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0+t8*t12*in_x2*in_x3*in_x9*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0+t8*t12*in_x2*in_x3*in_x9*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0+t2*t15*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0+t2*t15*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0-t2*t15*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t2*t15*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0+t14*t15*in_x2*in_x3*in_x4*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0+t14*t15*in_x2*in_x3*in_x4*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0-t14*t15*in_x2*in_x3*in_x4*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0-t14*t15*in_x2*in_x3*in_x4*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0-t2*t11*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0-t2*t11*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0+t2*t11*in_x5*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0+t2*t11*in_x5*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0-t2*t13*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0-t2*t13*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0+t2*t13*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0+t2*t13*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0-t5*t6*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t5*t6*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t5*t6*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t5*t6*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t11*t12*in_x4*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0+t11*t12*in_x4*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0-t11*t12*in_x4*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0+t11*t12*in_x4*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0-t13*t14*in_x2*in_x3*in_x8*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0-t13*t14*in_x2*in_x3*in_x8*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0+t13*t14*in_x2*in_x3*in_x8*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0+t13*t14*in_x2*in_x3*in_x8*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0+t2*t8*in_x6*in_x7*in_x9*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0+t2*t8*in_x6*in_x7*in_x9*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0-t2*t8*in_x6*in_x7*in_x9*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t2*t8*in_x6*in_x7*in_x9*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0+t8*t12*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0-t8*t12*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0+t8*t12*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0-t8*t12*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0+t2*t15*in_x2*in_x4*in_x7*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*4.0-t2*t15*in_x2*in_x4*in_x7*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*4.0+t2*t15*in_x2*in_x4*in_x7*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*4.0-t2*t15*in_x2*in_x4*in_x7*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*4.0-t2*t15*in_x3*in_x4*in_x6*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*4.0+t2*t15*in_x3*in_x4*in_x6*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*4.0-t2*t15*in_x3*in_x4*in_x6*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*4.0+t2*t15*in_x3*in_x4*in_x6*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*4.0+t14*t15*in_x2*in_x3*in_x5*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0-t14*t15*in_x2*in_x3*in_x5*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0+t14*t15*in_x2*in_x3*in_x5*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0-t14*t15*in_x2*in_x3*in_x5*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0+t4*t6*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t4*t6*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t4*t6*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t4*t6*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t2*t13*in_x2*in_x7*in_x8*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*4.0+t2*t13*in_x2*in_x7*in_x8*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*4.0-t2*t13*in_x2*in_x7*in_x8*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*4.0+t2*t13*in_x2*in_x7*in_x8*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*4.0+t2*t13*in_x3*in_x6*in_x8*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*4.0-t2*t13*in_x3*in_x6*in_x8*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*4.0+t2*t13*in_x3*in_x6*in_x8*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*4.0-t2*t13*in_x3*in_x6*in_x8*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*4.0+t5*t6*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t5*t6*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t5*t6*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t5*t6*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t11*t12*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0-t11*t12*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0+t11*t12*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0+t11*t12*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0-t13*t14*in_x2*in_x3*in_x9*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0+t13*t14*in_x2*in_x3*in_x9*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0-t13*t14*in_x2*in_x3*in_x9*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0+t13*t14*in_x2*in_x3*in_x9*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0+t8*t12*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0+t8*t12*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0-t8*t12*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0-t8*t12*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0-t2*t15*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0-t2*t15*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0+t2*t15*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0+t2*t15*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0-t14*t15*in_x4*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0-t14*t15*in_x4*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0+t14*t15*in_x4*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0+t14*t15*in_x4*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0-t4*t6*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t4*t6*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t4*t6*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t4*t6*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0+t2*t13*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0+t2*t13*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0-t2*t13*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t2*t13*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0+t5*t6*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t5*t6*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t5*t6*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t5*t6*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0+t9*t10*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t9*t10*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t9*t10*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t9*t10*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0+t13*t14*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*2.0+t13*t14*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*2.0-t13*t14*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*2.0-t13*t14*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*2.0-t7*t9*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t7*t9*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t7*t9*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t7*t9*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t14*t15*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0+t14*t15*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0-t14*t15*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0+t14*t15*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0-t4*t6*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t4*t6*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t4*t6*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t4*t6*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t5*t6*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t5*t6*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t5*t6*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t5*t6*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t9*t10*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t9*t10*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t9*t10*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t9*t10*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0+t13*t14*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*2.0-t13*t14*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*2.0+t13*t14*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*2.0-t13*t14*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*2.0+t7*t9*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t7*t9*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t7*t9*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t7*t9*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0+t4*t6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t4*t6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t4*t6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t4*t6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t9*t10*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t9*t10*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t9*t10*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t9*t10*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0+t7*t9*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t7*t9*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t7*t9*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t7*t9*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*2.0+t9*t10*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0-t9*t10*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0+t9*t10*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0-t9*t10*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t7*t9*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*2.0+t7*t9*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*2.0-t7*t9*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*2.0+t7*t9*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*2.0-t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*4.0+t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*4.0-t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*4.0+t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*4.0-t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*4.0+t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*4.0-t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*4.0+t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*4.0+t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*4.0-t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*4.0+t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*4.0-t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*4.0+t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*4.0-t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*4.0+t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*4.0-t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*4.0+t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*4.0-t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*4.0+t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*4.0-t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*4.0+t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*4.0-t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*4.0+t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*4.0-t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*4.0+t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*4.0-t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*4.0+t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*4.0-t6*in_x2*in_x3*in_x4*in_x5*in_x6*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*4.0+t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*4.0-t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*4.0+t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*4.0-t9*in_x2*in_x3*in_x4*in_x5*in_x7*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*4.0-t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x23*in_x27*4.0+t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x24*in_x26*4.0-t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x22*in_x26*4.0+t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x23*in_x25*4.0-t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x27*4.0+t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x26*4.0-t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x26*4.0+t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x25*4.0-t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*4.0+t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*4.0-t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*4.0+t6*in_x2*in_x4*in_x5*in_x6*in_x7*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*4.0-t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*4.0+t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*4.0-t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*4.0+t9*in_x3*in_x4*in_x5*in_x6*in_x7*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*4.0-t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*4.0+t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*4.0-t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*4.0+t6*in_x2*in_x3*in_x6*in_x8*in_x9*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*4.0-t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*4.0+t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*4.0-t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*4.0+t9*in_x2*in_x3*in_x7*in_x8*in_x9*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*4.0+t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x23*in_x26*in_x27*4.0-t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x23*in_x26*in_x27*4.0+t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x23*in_x25*in_x26*4.0-t6*in_x2*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*4.0-t5*in_x3*in_x4*in_x5*in_x10*in_x11*in_x14*in_x17*in_x20*in_x23*in_x26*in_x27*4.0+t5*in_x3*in_x4*in_x5*in_x11*in_x12*in_x14*in_x17*in_x20*in_x23*in_x25*in_x26*4.0+t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x20*in_x23*in_x26*in_x27*4.0-t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x20*in_x23*in_x26*in_x27*4.0+t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x20*in_x23*in_x25*in_x26*4.0-t9*in_x3*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x20*in_x23*in_x25*in_x26*4.0+t4*in_x4*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x23*in_x26*in_x27*4.0-t4*in_x4*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x20*in_x23*in_x25*in_x26*4.0-t11*in_x2*in_x3*in_x5*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*4.0+t11*in_x2*in_x3*in_x5*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*4.0+t8*in_x2*in_x3*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*4.0-t8*in_x2*in_x3*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*4.0-t10*in_x2*in_x4*in_x5*in_x11*in_x13*in_x14*in_x17*in_x20*in_x23*in_x26*in_x27*4.0+t10*in_x2*in_x4*in_x5*in_x11*in_x14*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*4.0+t5*in_x3*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x23*in_x26*in_x27*4.0-t5*in_x3*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x23*in_x25*in_x26*4.0+t7*in_x4*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x23*in_x26*in_x27*4.0-t7*in_x4*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*4.0-t15*in_x2*in_x3*in_x4*in_x11*in_x14*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*4.0+t15*in_x2*in_x3*in_x4*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*4.0-t4*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x23*in_x26*in_x27*4.0+t4*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x23*in_x25*in_x26*4.0+t11*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*4.0-t11*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*4.0+t13*in_x2*in_x3*in_x8*in_x11*in_x14*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*4.0-t13*in_x2*in_x3*in_x8*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*4.0-t8*in_x6*in_x7*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*in_x23*in_x26*4.0+t8*in_x6*in_x7*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*in_x23*in_x26*4.0+t10*in_x2*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x23*in_x26*in_x27*4.0-t10*in_x2*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*4.0-t7*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x23*in_x26*in_x27*4.0+t7*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x23*in_x25*in_x26*4.0+t15*in_x4*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*4.0-t15*in_x4*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*4.0-t13*in_x6*in_x7*in_x8*in_x11*in_x14*in_x16*in_x17*in_x20*in_x23*in_x24*in_x26*4.0+t13*in_x6*in_x7*in_x8*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*in_x23*in_x26*4.0;  // NOLINT
        coeffs[4] = t3*t5*t7*t8*t9*in_x10*in_x11*in_x20*in_x21-t3*t5*t7*t8*t9*in_x11*in_x12*in_x19*in_x20-t3*t4*t8*t9*t10*in_x10*in_x11*in_x20*in_x21+t3*t4*t8*t9*t10*in_x11*in_x12*in_x19*in_x20-t3*t5*t6*t7*t8*in_x13*in_x14*in_x20*in_x21+t3*t5*t6*t7*t8*in_x14*in_x15*in_x19*in_x20-t3*t5*t7*t9*t11*in_x10*in_x11*in_x20*in_x21+t3*t5*t7*t9*t11*in_x11*in_x12*in_x19*in_x20+t3*t4*t6*t8*t10*in_x13*in_x14*in_x20*in_x21-t3*t4*t6*t8*t10*in_x14*in_x15*in_x19*in_x20+t3*t4*t9*t10*t11*in_x10*in_x11*in_x20*in_x21-t3*t4*t9*t10*t11*in_x11*in_x12*in_x19*in_x20+t3*t5*t6*t7*t11*in_x13*in_x14*in_x20*in_x21-t3*t5*t6*t7*t11*in_x14*in_x15*in_x19*in_x20-t3*t4*t6*t10*t11*in_x13*in_x14*in_x20*in_x21+t3*t4*t6*t10*t11*in_x14*in_x15*in_x19*in_x20-t2*t4*t8*t14*t15*in_x10*in_x11*in_x20*in_x21+t2*t4*t8*t14*t15*in_x11*in_x12*in_x19*in_x20+t3*t5*t7*t9*t13*in_x10*in_x11*in_x23*in_x24-t3*t5*t7*t9*t13*in_x11*in_x12*in_x22*in_x23+t2*t4*t11*t13*t14*in_x10*in_x11*in_x20*in_x21-t2*t4*t11*t13*t14*in_x11*in_x12*in_x19*in_x20+t2*t5*t8*t14*t15*in_x10*in_x11*in_x20*in_x21-t2*t5*t8*t14*t15*in_x11*in_x12*in_x19*in_x20-t2*t5*t11*t13*t14*in_x10*in_x11*in_x20*in_x21+t2*t5*t11*t13*t14*in_x11*in_x12*in_x19*in_x20-t3*t4*t9*t10*t13*in_x10*in_x11*in_x23*in_x24+t3*t4*t9*t10*t13*in_x11*in_x12*in_x22*in_x23-t3*t5*t7*t9*t15*in_x10*in_x11*in_x23*in_x24+t3*t5*t7*t9*t15*in_x11*in_x12*in_x22*in_x23-t3*t5*t6*t7*t13*in_x13*in_x14*in_x23*in_x24+t3*t5*t6*t7*t13*in_x14*in_x15*in_x22*in_x23+t2*t4*t8*t12*t15*in_x10*in_x11*in_x23*in_x24-t2*t4*t8*t12*t15*in_x11*in_x12*in_x22*in_x23+t3*t4*t9*t10*t15*in_x10*in_x11*in_x23*in_x24-t3*t4*t9*t10*t15*in_x11*in_x12*in_x22*in_x23-t2*t4*t11*t12*t13*in_x10*in_x11*in_x23*in_x24+t2*t4*t11*t12*t13*in_x11*in_x12*in_x22*in_x23-t2*t5*t8*t12*t15*in_x10*in_x11*in_x23*in_x24+t2*t5*t8*t12*t15*in_x11*in_x12*in_x22*in_x23+t3*t4*t6*t10*t13*in_x13*in_x14*in_x23*in_x24-t3*t4*t6*t10*t13*in_x14*in_x15*in_x22*in_x23+t3*t5*t6*t7*t15*in_x13*in_x14*in_x23*in_x24-t3*t5*t6*t7*t15*in_x14*in_x15*in_x22*in_x23+t2*t5*t11*t12*t13*in_x10*in_x11*in_x23*in_x24-t2*t5*t11*t12*t13*in_x11*in_x12*in_x22*in_x23-t3*t4*t6*t10*t15*in_x13*in_x14*in_x23*in_x24+t3*t4*t6*t10*t15*in_x14*in_x15*in_x22*in_x23-t2*t7*t8*t14*t15*in_x13*in_x14*in_x20*in_x21+t2*t7*t8*t14*t15*in_x14*in_x15*in_x19*in_x20+t2*t7*t11*t13*t14*in_x13*in_x14*in_x20*in_x21-t2*t7*t11*t13*t14*in_x14*in_x15*in_x19*in_x20-t5*t7*t8*t9*t12*in_x10*in_x11*in_x26*in_x27+t5*t7*t8*t9*t12*in_x11*in_x12*in_x25*in_x26+t2*t8*t10*t14*t15*in_x13*in_x14*in_x20*in_x21-t2*t8*t10*t14*t15*in_x14*in_x15*in_x19*in_x20+t4*t8*t9*t10*t12*in_x10*in_x11*in_x26*in_x27-t4*t8*t9*t10*t12*in_x11*in_x12*in_x25*in_x26+t2*t7*t8*t12*t15*in_x13*in_x14*in_x23*in_x24-t2*t7*t8*t12*t15*in_x14*in_x15*in_x22*in_x23-t2*t10*t11*t13*t14*in_x13*in_x14*in_x20*in_x21+t2*t10*t11*t13*t14*in_x14*in_x15*in_x19*in_x20+t5*t6*t7*t8*t12*in_x13*in_x14*in_x26*in_x27-t5*t6*t7*t8*t12*in_x14*in_x15*in_x25*in_x26+t5*t7*t9*t11*t12*in_x10*in_x11*in_x26*in_x27-t5*t7*t9*t11*t12*in_x11*in_x12*in_x25*in_x26-t2*t7*t11*t12*t13*in_x13*in_x14*in_x23*in_x24+t2*t7*t11*t12*t13*in_x14*in_x15*in_x22*in_x23-t4*t6*t8*t10*t12*in_x13*in_x14*in_x26*in_x27+t4*t6*t8*t10*t12*in_x14*in_x15*in_x25*in_x26-t4*t9*t10*t11*t12*in_x10*in_x11*in_x26*in_x27+t4*t9*t10*t11*t12*in_x11*in_x12*in_x25*in_x26-t2*t8*t10*t12*t15*in_x13*in_x14*in_x23*in_x24+t2*t8*t10*t12*t15*in_x14*in_x15*in_x22*in_x23+t4*t6*t8*t14*t15*in_x16*in_x17*in_x20*in_x21-t4*t6*t8*t14*t15*in_x17*in_x18*in_x19*in_x20-t5*t6*t7*t11*t12*in_x13*in_x14*in_x26*in_x27+t5*t6*t7*t11*t12*in_x14*in_x15*in_x25*in_x26+t2*t10*t11*t12*t13*in_x13*in_x14*in_x23*in_x24-t2*t10*t11*t12*t13*in_x14*in_x15*in_x22*in_x23-t4*t6*t11*t13*t14*in_x16*in_x17*in_x20*in_x21+t4*t6*t11*t13*t14*in_x17*in_x18*in_x19*in_x20-t5*t6*t8*t14*t15*in_x16*in_x17*in_x20*in_x21+t5*t6*t8*t14*t15*in_x17*in_x18*in_x19*in_x20-t5*t7*t9*t13*t14*in_x10*in_x11*in_x26*in_x27+t5*t7*t9*t13*t14*in_x11*in_x12*in_x25*in_x26+t4*t6*t10*t11*t12*in_x13*in_x14*in_x26*in_x27-t4*t6*t10*t11*t12*in_x14*in_x15*in_x25*in_x26+t5*t6*t11*t13*t14*in_x16*in_x17*in_x20*in_x21-t5*t6*t11*t13*t14*in_x17*in_x18*in_x19*in_x20+t4*t9*t10*t13*t14*in_x10*in_x11*in_x26*in_x27-t4*t9*t10*t13*t14*in_x11*in_x12*in_x25*in_x26+t5*t7*t9*t14*t15*in_x10*in_x11*in_x26*in_x27-t5*t7*t9*t14*t15*in_x11*in_x12*in_x25*in_x26-t4*t6*t8*t12*t15*in_x16*in_x17*in_x23*in_x24+t4*t6*t8*t12*t15*in_x17*in_x18*in_x22*in_x23+t5*t6*t7*t13*t14*in_x13*in_x14*in_x26*in_x27-t5*t6*t7*t13*t14*in_x14*in_x15*in_x25*in_x26+t4*t6*t11*t12*t13*in_x16*in_x17*in_x23*in_x24-t4*t6*t11*t12*t13*in_x17*in_x18*in_x22*in_x23-t4*t9*t10*t14*t15*in_x10*in_x11*in_x26*in_x27+t4*t9*t10*t14*t15*in_x11*in_x12*in_x25*in_x26+t5*t6*t8*t12*t15*in_x16*in_x17*in_x23*in_x24-t5*t6*t8*t12*t15*in_x17*in_x18*in_x22*in_x23-t4*t6*t10*t13*t14*in_x13*in_x14*in_x26*in_x27+t4*t6*t10*t13*t14*in_x14*in_x15*in_x25*in_x26-t5*t6*t7*t14*t15*in_x13*in_x14*in_x26*in_x27+t5*t6*t7*t14*t15*in_x14*in_x15*in_x25*in_x26-t5*t6*t11*t12*t13*in_x16*in_x17*in_x23*in_x24+t5*t6*t11*t12*t13*in_x17*in_x18*in_x22*in_x23+t7*t8*t9*t14*t15*in_x16*in_x17*in_x20*in_x21-t7*t8*t9*t14*t15*in_x17*in_x18*in_x19*in_x20-t7*t9*t11*t13*t14*in_x16*in_x17*in_x20*in_x21+t7*t9*t11*t13*t14*in_x17*in_x18*in_x19*in_x20+t4*t6*t10*t14*t15*in_x13*in_x14*in_x26*in_x27-t4*t6*t10*t14*t15*in_x14*in_x15*in_x25*in_x26-t8*t9*t10*t14*t15*in_x16*in_x17*in_x20*in_x21+t8*t9*t10*t14*t15*in_x17*in_x18*in_x19*in_x20-t7*t8*t9*t12*t15*in_x16*in_x17*in_x23*in_x24+t7*t8*t9*t12*t15*in_x17*in_x18*in_x22*in_x23+t9*t10*t11*t13*t14*in_x16*in_x17*in_x20*in_x21-t9*t10*t11*t13*t14*in_x17*in_x18*in_x19*in_x20+t7*t9*t11*t12*t13*in_x16*in_x17*in_x23*in_x24-t7*t9*t11*t12*t13*in_x17*in_x18*in_x22*in_x23+t8*t9*t10*t12*t15*in_x16*in_x17*in_x23*in_x24-t8*t9*t10*t12*t15*in_x17*in_x18*in_x22*in_x23-t9*t10*t11*t12*t13*in_x16*in_x17*in_x23*in_x24+t9*t10*t11*t12*t13*in_x17*in_x18*in_x22*in_x23+t3*t5*t6*t8*in_x2*in_x3*in_x10*in_x14*in_x20*in_x21-t3*t5*t6*t8*in_x2*in_x3*in_x11*in_x13*in_x20*in_x21+t3*t5*t6*t8*in_x2*in_x3*in_x11*in_x15*in_x19*in_x20-t3*t5*t6*t8*in_x2*in_x3*in_x12*in_x14*in_x19*in_x20-t3*t5*t6*t11*in_x2*in_x3*in_x10*in_x14*in_x20*in_x21+t3*t5*t6*t11*in_x2*in_x3*in_x11*in_x13*in_x20*in_x21-t3*t5*t6*t11*in_x2*in_x3*in_x11*in_x15*in_x19*in_x20+t3*t5*t6*t11*in_x2*in_x3*in_x12*in_x14*in_x19*in_x20+t3*t5*t7*t9*in_x4*in_x5*in_x10*in_x11*in_x20*in_x24+t3*t5*t7*t9*in_x4*in_x5*in_x10*in_x11*in_x21*in_x23-t3*t5*t7*t9*in_x4*in_x5*in_x11*in_x12*in_x19*in_x23-t3*t5*t7*t9*in_x4*in_x5*in_x11*in_x12*in_x20*in_x22-t3*t4*t6*t8*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21+t3*t4*t6*t8*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21-t3*t4*t6*t8*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20+t3*t4*t6*t8*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20-t3*t4*t9*t10*in_x4*in_x5*in_x10*in_x11*in_x20*in_x24-t3*t4*t9*t10*in_x4*in_x5*in_x10*in_x11*in_x21*in_x23+t3*t4*t9*t10*in_x4*in_x5*in_x11*in_x12*in_x19*in_x23+t3*t4*t9*t10*in_x4*in_x5*in_x11*in_x12*in_x20*in_x22-t3*t8*t9*t10*in_x2*in_x3*in_x10*in_x14*in_x20*in_x21+t3*t8*t9*t10*in_x2*in_x3*in_x11*in_x13*in_x20*in_x21-t3*t8*t9*t10*in_x2*in_x3*in_x11*in_x15*in_x19*in_x20+t3*t8*t9*t10*in_x2*in_x3*in_x12*in_x14*in_x19*in_x20-t3*t5*t6*t7*in_x4*in_x5*in_x13*in_x14*in_x20*in_x24-t3*t5*t6*t7*in_x4*in_x5*in_x13*in_x14*in_x21*in_x23+t3*t5*t6*t7*in_x4*in_x5*in_x14*in_x15*in_x19*in_x23+t3*t5*t6*t7*in_x4*in_x5*in_x14*in_x15*in_x20*in_x22+t3*t4*t6*t11*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21-t3*t4*t6*t11*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21+t3*t4*t6*t11*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20-t3*t4*t6*t11*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20-t3*t5*t7*t9*in_x4*in_x9*in_x10*in_x11*in_x20*in_x24*2.0+t3*t5*t7*t9*in_x4*in_x9*in_x10*in_x11*in_x21*in_x23*2.0-t3*t5*t7*t9*in_x4*in_x9*in_x11*in_x12*in_x19*in_x23*2.0+t3*t5*t7*t9*in_x4*in_x9*in_x11*in_x12*in_x20*in_x22*2.0+t3*t5*t7*t9*in_x5*in_x8*in_x10*in_x11*in_x20*in_x24*2.0-t3*t5*t7*t9*in_x5*in_x8*in_x10*in_x11*in_x21*in_x23*2.0+t3*t5*t7*t9*in_x5*in_x8*in_x11*in_x12*in_x19*in_x23*2.0-t3*t5*t7*t9*in_x5*in_x8*in_x11*in_x12*in_x20*in_x22*2.0-t2*t4*t11*t12*in_x4*in_x5*in_x10*in_x11*in_x20*in_x24+t2*t4*t11*t12*in_x4*in_x5*in_x10*in_x11*in_x21*in_x23-t2*t4*t11*t12*in_x4*in_x5*in_x11*in_x12*in_x19*in_x23+t2*t4*t11*t12*in_x4*in_x5*in_x11*in_x12*in_x20*in_x22+t3*t4*t6*t10*in_x4*in_x5*in_x13*in_x14*in_x20*in_x24+t3*t4*t6*t10*in_x4*in_x5*in_x13*in_x14*in_x21*in_x23-t3*t4*t6*t10*in_x4*in_x5*in_x14*in_x15*in_x19*in_x23-t3*t4*t6*t10*in_x4*in_x5*in_x14*in_x15*in_x20*in_x22+t3*t5*t6*t13*in_x2*in_x3*in_x10*in_x14*in_x23*in_x24-t3*t5*t6*t13*in_x2*in_x3*in_x11*in_x13*in_x23*in_x24+t3*t5*t6*t13*in_x2*in_x3*in_x11*in_x15*in_x22*in_x23-t3*t5*t6*t13*in_x2*in_x3*in_x12*in_x14*in_x22*in_x23+t3*t9*t10*t11*in_x2*in_x3*in_x10*in_x14*in_x20*in_x21-t3*t9*t10*t11*in_x2*in_x3*in_x11*in_x13*in_x20*in_x21+t3*t9*t10*t11*in_x2*in_x3*in_x11*in_x15*in_x19*in_x20-t3*t9*t10*t11*in_x2*in_x3*in_x12*in_x14*in_x19*in_x20+t2*t5*t11*t12*in_x4*in_x5*in_x10*in_x11*in_x20*in_x24-t2*t5*t11*t12*in_x4*in_x5*in_x10*in_x11*in_x21*in_x23+t2*t5*t11*t12*in_x4*in_x5*in_x11*in_x12*in_x19*in_x23-t2*t5*t11*t12*in_x4*in_x5*in_x11*in_x12*in_x20*in_x22+t3*t4*t9*t10*in_x4*in_x9*in_x10*in_x11*in_x20*in_x24*2.0-t3*t4*t9*t10*in_x4*in_x9*in_x10*in_x11*in_x21*in_x23*2.0+t3*t4*t9*t10*in_x4*in_x9*in_x11*in_x12*in_x19*in_x23*2.0-t3*t4*t9*t10*in_x4*in_x9*in_x11*in_x12*in_x20*in_x22*2.0-t3*t4*t9*t10*in_x5*in_x8*in_x10*in_x11*in_x20*in_x24*2.0+t3*t4*t9*t10*in_x5*in_x8*in_x10*in_x11*in_x21*in_x23*2.0-t3*t4*t9*t10*in_x5*in_x8*in_x11*in_x12*in_x19*in_x23*2.0+t3*t4*t9*t10*in_x5*in_x8*in_x11*in_x12*in_x20*in_x22*2.0+t3*t5*t6*t7*in_x4*in_x9*in_x13*in_x14*in_x20*in_x24*2.0-t3*t5*t6*t7*in_x4*in_x9*in_x13*in_x14*in_x21*in_x23*2.0+t3*t5*t6*t7*in_x4*in_x9*in_x14*in_x15*in_x19*in_x23*2.0-t3*t5*t6*t7*in_x4*in_x9*in_x14*in_x15*in_x20*in_x22*2.0-t3*t5*t6*t7*in_x5*in_x8*in_x13*in_x14*in_x20*in_x24*2.0+t3*t5*t6*t7*in_x5*in_x8*in_x13*in_x14*in_x21*in_x23*2.0-t3*t5*t6*t7*in_x5*in_x8*in_x14*in_x15*in_x19*in_x23*2.0+t3*t5*t6*t7*in_x5*in_x8*in_x14*in_x15*in_x20*in_x22*2.0-t3*t5*t6*t15*in_x2*in_x3*in_x10*in_x14*in_x23*in_x24+t3*t5*t6*t15*in_x2*in_x3*in_x11*in_x13*in_x23*in_x24-t3*t5*t6*t15*in_x2*in_x3*in_x11*in_x15*in_x22*in_x23+t3*t5*t6*t15*in_x2*in_x3*in_x12*in_x14*in_x22*in_x23+t3*t7*t8*t9*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21-t3*t7*t8*t9*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21+t3*t7*t8*t9*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20-t3*t7*t8*t9*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20-t3*t5*t7*t9*in_x8*in_x9*in_x10*in_x11*in_x20*in_x24-t3*t5*t7*t9*in_x8*in_x9*in_x10*in_x11*in_x21*in_x23+t3*t5*t7*t9*in_x8*in_x9*in_x11*in_x12*in_x19*in_x23+t3*t5*t7*t9*in_x8*in_x9*in_x11*in_x12*in_x20*in_x22-t3*t4*t6*t10*in_x4*in_x9*in_x13*in_x14*in_x20*in_x24*2.0+t3*t4*t6*t10*in_x4*in_x9*in_x13*in_x14*in_x21*in_x23*2.0-t3*t4*t6*t10*in_x4*in_x9*in_x14*in_x15*in_x19*in_x23*2.0+t3*t4*t6*t10*in_x4*in_x9*in_x14*in_x15*in_x20*in_x22*2.0+t3*t4*t6*t10*in_x5*in_x8*in_x13*in_x14*in_x20*in_x24*2.0-t3*t4*t6*t10*in_x5*in_x8*in_x13*in_x14*in_x21*in_x23*2.0+t3*t4*t6*t10*in_x5*in_x8*in_x14*in_x15*in_x19*in_x23*2.0-t3*t4*t6*t10*in_x5*in_x8*in_x14*in_x15*in_x20*in_x22*2.0+t2*t4*t8*t12*in_x8*in_x9*in_x10*in_x11*in_x20*in_x24-t2*t4*t8*t12*in_x8*in_x9*in_x10*in_x11*in_x21*in_x23+t2*t4*t8*t12*in_x8*in_x9*in_x11*in_x12*in_x19*in_x23-t2*t4*t8*t12*in_x8*in_x9*in_x11*in_x12*in_x20*in_x22+t3*t4*t9*t10*in_x8*in_x9*in_x10*in_x11*in_x20*in_x24+t3*t4*t9*t10*in_x8*in_x9*in_x10*in_x11*in_x21*in_x23-t3*t4*t9*t10*in_x8*in_x9*in_x11*in_x12*in_x19*in_x23-t3*t4*t9*t10*in_x8*in_x9*in_x11*in_x12*in_x20*in_x22-t3*t7*t9*t11*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21+t3*t7*t9*t11*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21-t3*t7*t9*t11*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20+t3*t7*t9*t11*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20+t2*t4*t14*t15*in_x4*in_x5*in_x10*in_x11*in_x20*in_x24-t2*t4*t14*t15*in_x4*in_x5*in_x10*in_x11*in_x21*in_x23+t2*t4*t14*t15*in_x4*in_x5*in_x11*in_x12*in_x19*in_x23-t2*t4*t14*t15*in_x4*in_x5*in_x11*in_x12*in_x20*in_x22-t2*t5*t8*t12*in_x8*in_x9*in_x10*in_x11*in_x20*in_x24+t2*t5*t8*t12*in_x8*in_x9*in_x10*in_x11*in_x21*in_x23-t2*t5*t8*t12*in_x8*in_x9*in_x11*in_x12*in_x19*in_x23+t2*t5*t8*t12*in_x8*in_x9*in_x11*in_x12*in_x20*in_x22-t2*t8*t14*t15*in_x2*in_x3*in_x10*in_x14*in_x20*in_x21-t2*t8*t14*t15*in_x2*in_x3*in_x11*in_x13*in_x20*in_x21+t2*t8*t14*t15*in_x2*in_x3*in_x11*in_x15*in_x19*in_x20+t2*t8*t14*t15*in_x2*in_x3*in_x12*in_x14*in_x19*in_x20+t3*t5*t6*t7*in_x8*in_x9*in_x13*in_x14*in_x20*in_x24+t3*t5*t6*t7*in_x8*in_x9*in_x13*in_x14*in_x21*in_x23-t3*t5*t6*t7*in_x8*in_x9*in_x14*in_x15*in_x19*in_x23-t3*t5*t6*t7*in_x8*in_x9*in_x14*in_x15*in_x20*in_x22-t2*t5*t14*t15*in_x4*in_x5*in_x10*in_x11*in_x20*in_x24+t2*t5*t14*t15*in_x4*in_x5*in_x10*in_x11*in_x21*in_x23-t2*t5*t14*t15*in_x4*in_x5*in_x11*in_x12*in_x19*in_x23+t2*t5*t14*t15*in_x4*in_x5*in_x11*in_x12*in_x20*in_x22+t2*t11*t13*t14*in_x2*in_x3*in_x10*in_x14*in_x20*in_x21+t2*t11*t13*t14*in_x2*in_x3*in_x11*in_x13*in_x20*in_x21-t2*t11*t13*t14*in_x2*in_x3*in_x11*in_x15*in_x19*in_x20-t2*t11*t13*t14*in_x2*in_x3*in_x12*in_x14*in_x19*in_x20-t3*t4*t6*t13*in_x6*in_x7*in_x10*in_x14*in_x23*in_x24+t3*t4*t6*t13*in_x6*in_x7*in_x11*in_x13*in_x23*in_x24-t3*t4*t6*t13*in_x6*in_x7*in_x11*in_x15*in_x22*in_x23+t3*t4*t6*t13*in_x6*in_x7*in_x12*in_x14*in_x22*in_x23-t3*t4*t6*t10*in_x8*in_x9*in_x13*in_x14*in_x20*in_x24-t3*t4*t6*t10*in_x8*in_x9*in_x13*in_x14*in_x21*in_x23+t3*t4*t6*t10*in_x8*in_x9*in_x14*in_x15*in_x19*in_x23+t3*t4*t6*t10*in_x8*in_x9*in_x14*in_x15*in_x20*in_x22-t3*t9*t10*t13*in_x2*in_x3*in_x10*in_x14*in_x23*in_x24+t3*t9*t10*t13*in_x2*in_x3*in_x11*in_x13*in_x23*in_x24-t3*t9*t10*t13*in_x2*in_x3*in_x11*in_x15*in_x22*in_x23+t3*t9*t10*t13*in_x2*in_x3*in_x12*in_x14*in_x22*in_x23-t2*t7*t11*t12*in_x4*in_x5*in_x13*in_x14*in_x20*in_x24+t2*t7*t11*t12*in_x4*in_x5*in_x13*in_x14*in_x21*in_x23-t2*t7*t11*t12*in_x4*in_x5*in_x14*in_x15*in_x19*in_x23+t2*t7*t11*t12*in_x4*in_x5*in_x14*in_x15*in_x20*in_x22+t3*t4*t6*t15*in_x6*in_x7*in_x10*in_x14*in_x23*in_x24-t3*t4*t6*t15*in_x6*in_x7*in_x11*in_x13*in_x23*in_x24+t3*t4*t6*t15*in_x6*in_x7*in_x11*in_x15*in_x22*in_x23-t3*t4*t6*t15*in_x6*in_x7*in_x12*in_x14*in_x22*in_x23+t2*t8*t12*t15*in_x2*in_x3*in_x10*in_x14*in_x23*in_x24+t2*t8*t12*t15*in_x2*in_x3*in_x11*in_x13*in_x23*in_x24-t2*t8*t12*t15*in_x2*in_x3*in_x11*in_x15*in_x22*in_x23-t2*t8*t12*t15*in_x2*in_x3*in_x12*in_x14*in_x22*in_x23-t2*t8*t14*t15*in_x2*in_x7*in_x10*in_x14*in_x20*in_x21*2.0+t2*t8*t14*t15*in_x2*in_x7*in_x11*in_x13*in_x20*in_x21*2.0-t2*t8*t14*t15*in_x2*in_x7*in_x11*in_x15*in_x19*in_x20*2.0+t2*t8*t14*t15*in_x2*in_x7*in_x12*in_x14*in_x19*in_x20*2.0+t2*t8*t14*t15*in_x3*in_x6*in_x10*in_x14*in_x20*in_x21*2.0-t2*t8*t14*t15*in_x3*in_x6*in_x11*in_x13*in_x20*in_x21*2.0+t2*t8*t14*t15*in_x3*in_x6*in_x11*in_x15*in_x19*in_x20*2.0-t2*t8*t14*t15*in_x3*in_x6*in_x12*in_x14*in_x19*in_x20*2.0+t3*t9*t10*t15*in_x2*in_x3*in_x10*in_x14*in_x23*in_x24-t3*t9*t10*t15*in_x2*in_x3*in_x11*in_x13*in_x23*in_x24+t3*t9*t10*t15*in_x2*in_x3*in_x11*in_x15*in_x22*in_x23-t3*t9*t10*t15*in_x2*in_x3*in_x12*in_x14*in_x22*in_x23-t5*t6*t8*t12*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27+t5*t6*t8*t12*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27-t5*t6*t8*t12*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26+t5*t6*t8*t12*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26-t2*t11*t12*t13*in_x2*in_x3*in_x10*in_x14*in_x23*in_x24-t2*t11*t12*t13*in_x2*in_x3*in_x11*in_x13*in_x23*in_x24+t2*t11*t12*t13*in_x2*in_x3*in_x11*in_x15*in_x22*in_x23+t2*t11*t12*t13*in_x2*in_x3*in_x12*in_x14*in_x22*in_x23+t2*t11*t13*t14*in_x2*in_x7*in_x10*in_x14*in_x20*in_x21*2.0-t2*t11*t13*t14*in_x2*in_x7*in_x11*in_x13*in_x20*in_x21*2.0+t2*t11*t13*t14*in_x2*in_x7*in_x11*in_x15*in_x19*in_x20*2.0-t2*t11*t13*t14*in_x2*in_x7*in_x12*in_x14*in_x19*in_x20*2.0-t2*t11*t13*t14*in_x3*in_x6*in_x10*in_x14*in_x20*in_x21*2.0+t2*t11*t13*t14*in_x3*in_x6*in_x11*in_x13*in_x20*in_x21*2.0-t2*t11*t13*t14*in_x3*in_x6*in_x11*in_x15*in_x19*in_x20*2.0+t2*t11*t13*t14*in_x3*in_x6*in_x12*in_x14*in_x19*in_x20*2.0+t5*t6*t11*t12*in_x2*in_x4*in_x10*in_x17*in_x20*in_x27-t5*t6*t11*t12*in_x2*in_x4*in_x10*in_x17*in_x21*in_x26-t5*t6*t11*t12*in_x2*in_x4*in_x11*in_x16*in_x20*in_x27+t5*t6*t11*t12*in_x2*in_x4*in_x11*in_x16*in_x21*in_x26-t5*t6*t11*t12*in_x2*in_x4*in_x11*in_x18*in_x19*in_x26+t5*t6*t11*t12*in_x2*in_x4*in_x11*in_x18*in_x20*in_x25+t5*t6*t11*t12*in_x2*in_x4*in_x12*in_x17*in_x19*in_x26-t5*t6*t11*t12*in_x2*in_x4*in_x12*in_x17*in_x20*in_x25-t2*t4*t13*t14*in_x8*in_x9*in_x10*in_x11*in_x20*in_x24+t2*t4*t13*t14*in_x8*in_x9*in_x10*in_x11*in_x21*in_x23-t2*t4*t13*t14*in_x8*in_x9*in_x11*in_x12*in_x19*in_x23+t2*t4*t13*t14*in_x8*in_x9*in_x11*in_x12*in_x20*in_x22+t2*t10*t11*t12*in_x4*in_x5*in_x13*in_x14*in_x20*in_x24-t2*t10*t11*t12*in_x4*in_x5*in_x13*in_x14*in_x21*in_x23+t2*t10*t11*t12*in_x4*in_x5*in_x14*in_x15*in_x19*in_x23-t2*t10*t11*t12*in_x4*in_x5*in_x14*in_x15*in_x20*in_x22-t5*t6*t8*t12*in_x2*in_x8*in_x10*in_x17*in_x20*in_x27+t5*t6*t8*t12*in_x2*in_x8*in_x10*in_x17*in_x21*in_x26+t5*t6*t8*t12*in_x2*in_x8*in_x11*in_x16*in_x20*in_x27-t5*t6*t8*t12*in_x2*in_x8*in_x11*in_x16*in_x21*in_x26+t5*t6*t8*t12*in_x2*in_x8*in_x11*in_x18*in_x19*in_x26-t5*t6*t8*t12*in_x2*in_x8*in_x11*in_x18*in_x20*in_x25-t5*t6*t8*t12*in_x2*in_x8*in_x12*in_x17*in_x19*in_x26+t5*t6*t8*t12*in_x2*in_x8*in_x12*in_x17*in_x20*in_x25+t2*t5*t13*t14*in_x8*in_x9*in_x10*in_x11*in_x20*in_x24-t2*t5*t13*t14*in_x8*in_x9*in_x10*in_x11*in_x21*in_x23+t2*t5*t13*t14*in_x8*in_x9*in_x11*in_x12*in_x19*in_x23-t2*t5*t13*t14*in_x8*in_x9*in_x11*in_x12*in_x20*in_x22+t3*t7*t9*t13*in_x6*in_x7*in_x10*in_x14*in_x23*in_x24-t3*t7*t9*t13*in_x6*in_x7*in_x11*in_x13*in_x23*in_x24+t3*t7*t9*t13*in_x6*in_x7*in_x11*in_x15*in_x22*in_x23-t3*t7*t9*t13*in_x6*in_x7*in_x12*in_x14*in_x22*in_x23+t5*t6*t11*t12*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27-t5*t6*t11*t12*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27+t5*t6*t11*t12*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26-t5*t6*t11*t12*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26+t2*t7*t8*t12*in_x8*in_x9*in_x13*in_x14*in_x20*in_x24-t2*t7*t8*t12*in_x8*in_x9*in_x13*in_x14*in_x21*in_x23+t2*t7*t8*t12*in_x8*in_x9*in_x14*in_x15*in_x19*in_x23-t2*t7*t8*t12*in_x8*in_x9*in_x14*in_x15*in_x20*in_x22+t2*t8*t12*t15*in_x2*in_x7*in_x10*in_x14*in_x23*in_x24*2.0-t2*t8*t12*t15*in_x2*in_x7*in_x11*in_x13*in_x23*in_x24*2.0+t2*t8*t12*t15*in_x2*in_x7*in_x11*in_x15*in_x22*in_x23*2.0-t2*t8*t12*t15*in_x2*in_x7*in_x12*in_x14*in_x22*in_x23*2.0-t2*t8*t12*t15*in_x3*in_x6*in_x10*in_x14*in_x23*in_x24*2.0+t2*t8*t12*t15*in_x3*in_x6*in_x11*in_x13*in_x23*in_x24*2.0-t2*t8*t12*t15*in_x3*in_x6*in_x11*in_x15*in_x22*in_x23*2.0+t2*t8*t12*t15*in_x3*in_x6*in_x12*in_x14*in_x22*in_x23*2.0+t2*t8*t14*t15*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21+t2*t8*t14*t15*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21-t2*t8*t14*t15*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20-t2*t8*t14*t15*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20-t4*t6*t11*t12*in_x4*in_x6*in_x10*in_x17*in_x20*in_x27+t4*t6*t11*t12*in_x4*in_x6*in_x10*in_x17*in_x21*in_x26+t4*t6*t11*t12*in_x4*in_x6*in_x11*in_x16*in_x20*in_x27-t4*t6*t11*t12*in_x4*in_x6*in_x11*in_x16*in_x21*in_x26+t4*t6*t11*t12*in_x4*in_x6*in_x11*in_x18*in_x19*in_x26-t4*t6*t11*t12*in_x4*in_x6*in_x11*in_x18*in_x20*in_x25-t4*t6*t11*t12*in_x4*in_x6*in_x12*in_x17*in_x19*in_x26+t4*t6*t11*t12*in_x4*in_x6*in_x12*in_x17*in_x20*in_x25+t2*t7*t14*t15*in_x4*in_x5*in_x13*in_x14*in_x20*in_x24-t2*t7*t14*t15*in_x4*in_x5*in_x13*in_x14*in_x21*in_x23+t2*t7*t14*t15*in_x4*in_x5*in_x14*in_x15*in_x19*in_x23-t2*t7*t14*t15*in_x4*in_x5*in_x14*in_x15*in_x20*in_x22-t2*t11*t12*t13*in_x2*in_x7*in_x10*in_x14*in_x23*in_x24*2.0+t2*t11*t12*t13*in_x2*in_x7*in_x11*in_x13*in_x23*in_x24*2.0-t2*t11*t12*t13*in_x2*in_x7*in_x11*in_x15*in_x22*in_x23*2.0+t2*t11*t12*t13*in_x2*in_x7*in_x12*in_x14*in_x22*in_x23*2.0+t2*t11*t12*t13*in_x3*in_x6*in_x10*in_x14*in_x23*in_x24*2.0-t2*t11*t12*t13*in_x3*in_x6*in_x11*in_x13*in_x23*in_x24*2.0+t2*t11*t12*t13*in_x3*in_x6*in_x11*in_x15*in_x22*in_x23*2.0-t2*t11*t12*t13*in_x3*in_x6*in_x12*in_x14*in_x22*in_x23*2.0-t2*t11*t13*t14*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21-t2*t11*t13*t14*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21+t2*t11*t13*t14*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20+t2*t11*t13*t14*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20-t3*t7*t9*t15*in_x6*in_x7*in_x10*in_x14*in_x23*in_x24+t3*t7*t9*t15*in_x6*in_x7*in_x11*in_x13*in_x23*in_x24-t3*t7*t9*t15*in_x6*in_x7*in_x11*in_x15*in_x22*in_x23+t3*t7*t9*t15*in_x6*in_x7*in_x12*in_x14*in_x22*in_x23+t4*t6*t8*t12*in_x6*in_x8*in_x10*in_x17*in_x20*in_x27-t4*t6*t8*t12*in_x6*in_x8*in_x10*in_x17*in_x21*in_x26-t4*t6*t8*t12*in_x6*in_x8*in_x11*in_x16*in_x20*in_x27+t4*t6*t8*t12*in_x6*in_x8*in_x11*in_x16*in_x21*in_x26-t4*t6*t8*t12*in_x6*in_x8*in_x11*in_x18*in_x19*in_x26+t4*t6*t8*t12*in_x6*in_x8*in_x11*in_x18*in_x20*in_x25+t4*t6*t8*t12*in_x6*in_x8*in_x12*in_x17*in_x19*in_x26-t4*t6*t8*t12*in_x6*in_x8*in_x12*in_x17*in_x20*in_x25+t5*t6*t11*t12*in_x2*in_x5*in_x10*in_x17*in_x23*in_x27+t5*t6*t11*t12*in_x2*in_x5*in_x10*in_x17*in_x24*in_x26-t5*t6*t11*t12*in_x2*in_x5*in_x11*in_x16*in_x23*in_x27-t5*t6*t11*t12*in_x2*in_x5*in_x11*in_x16*in_x24*in_x26+t5*t6*t11*t12*in_x2*in_x5*in_x11*in_x18*in_x22*in_x26+t5*t6*t11*t12*in_x2*in_x5*in_x11*in_x18*in_x23*in_x25-t5*t6*t11*t12*in_x2*in_x5*in_x12*in_x17*in_x22*in_x26-t5*t6*t11*t12*in_x2*in_x5*in_x12*in_x17*in_x23*in_x25-t5*t6*t11*t12*in_x3*in_x4*in_x13*in_x17*in_x20*in_x27+t5*t6*t11*t12*in_x3*in_x4*in_x13*in_x17*in_x21*in_x26-t5*t6*t11*t12*in_x3*in_x4*in_x14*in_x16*in_x20*in_x27+t5*t6*t11*t12*in_x3*in_x4*in_x14*in_x16*in_x21*in_x26-t5*t6*t11*t12*in_x3*in_x4*in_x14*in_x18*in_x19*in_x26+t5*t6*t11*t12*in_x3*in_x4*in_x14*in_x18*in_x20*in_x25-t5*t6*t11*t12*in_x3*in_x4*in_x15*in_x17*in_x19*in_x26+t5*t6*t11*t12*in_x3*in_x4*in_x15*in_x17*in_x20*in_x25+t4*t6*t11*t12*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24-t4*t6*t11*t12*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23+t4*t6*t11*t12*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23-t4*t6*t11*t12*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22-t5*t6*t8*t12*in_x2*in_x9*in_x10*in_x17*in_x23*in_x27-t5*t6*t8*t12*in_x2*in_x9*in_x10*in_x17*in_x24*in_x26+t5*t6*t8*t12*in_x2*in_x9*in_x11*in_x16*in_x23*in_x27+t5*t6*t8*t12*in_x2*in_x9*in_x11*in_x16*in_x24*in_x26-t5*t6*t8*t12*in_x2*in_x9*in_x11*in_x18*in_x22*in_x26-t5*t6*t8*t12*in_x2*in_x9*in_x11*in_x18*in_x23*in_x25+t5*t6*t8*t12*in_x2*in_x9*in_x12*in_x17*in_x22*in_x26+t5*t6*t8*t12*in_x2*in_x9*in_x12*in_x17*in_x23*in_x25+t5*t6*t8*t12*in_x3*in_x8*in_x13*in_x17*in_x20*in_x27-t5*t6*t8*t12*in_x3*in_x8*in_x13*in_x17*in_x21*in_x26+t5*t6*t8*t12*in_x3*in_x8*in_x14*in_x16*in_x20*in_x27-t5*t6*t8*t12*in_x3*in_x8*in_x14*in_x16*in_x21*in_x26+t5*t6*t8*t12*in_x3*in_x8*in_x14*in_x18*in_x19*in_x26-t5*t6*t8*t12*in_x3*in_x8*in_x14*in_x18*in_x20*in_x25+t5*t6*t8*t12*in_x3*in_x8*in_x15*in_x17*in_x19*in_x26-t5*t6*t8*t12*in_x3*in_x8*in_x15*in_x17*in_x20*in_x25-t2*t8*t10*t12*in_x8*in_x9*in_x13*in_x14*in_x20*in_x24+t2*t8*t10*t12*in_x8*in_x9*in_x13*in_x14*in_x21*in_x23-t2*t8*t10*t12*in_x8*in_x9*in_x14*in_x15*in_x19*in_x23+t2*t8*t10*t12*in_x8*in_x9*in_x14*in_x15*in_x20*in_x22+t4*t6*t8*t12*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27-t4*t6*t8*t12*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27+t4*t6*t8*t12*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26-t4*t6*t8*t12*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26-t5*t6*t11*t12*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24+t5*t6*t11*t12*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23-t5*t6*t11*t12*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23+t5*t6*t11*t12*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22-t5*t6*t13*t14*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27+t5*t6*t13*t14*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27-t5*t6*t13*t14*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26+t5*t6*t13*t14*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26+t5*t6*t14*t15*in_x2*in_x4*in_x10*in_x17*in_x20*in_x27+t5*t6*t14*t15*in_x2*in_x4*in_x10*in_x17*in_x21*in_x26-t5*t6*t14*t15*in_x2*in_x4*in_x11*in_x16*in_x20*in_x27-t5*t6*t14*t15*in_x2*in_x4*in_x11*in_x16*in_x21*in_x26+t5*t6*t14*t15*in_x2*in_x4*in_x11*in_x18*in_x19*in_x26+t5*t6*t14*t15*in_x2*in_x4*in_x11*in_x18*in_x20*in_x25-t5*t6*t14*t15*in_x2*in_x4*in_x12*in_x17*in_x19*in_x26-t5*t6*t14*t15*in_x2*in_x4*in_x12*in_x17*in_x20*in_x25-t2*t8*t12*t15*in_x6*in_x7*in_x10*in_x14*in_x23*in_x24-t2*t8*t12*t15*in_x6*in_x7*in_x11*in_x13*in_x23*in_x24+t2*t8*t12*t15*in_x6*in_x7*in_x11*in_x15*in_x22*in_x23+t2*t8*t12*t15*in_x6*in_x7*in_x12*in_x14*in_x22*in_x23-t2*t10*t14*t15*in_x4*in_x5*in_x13*in_x14*in_x20*in_x24+t2*t10*t14*t15*in_x4*in_x5*in_x13*in_x14*in_x21*in_x23-t2*t10*t14*t15*in_x4*in_x5*in_x14*in_x15*in_x19*in_x23+t2*t10*t14*t15*in_x4*in_x5*in_x14*in_x15*in_x20*in_x22+t4*t6*t11*t12*in_x4*in_x7*in_x13*in_x17*in_x20*in_x27-t4*t6*t11*t12*in_x4*in_x7*in_x13*in_x17*in_x21*in_x26+t4*t6*t11*t12*in_x4*in_x7*in_x14*in_x16*in_x20*in_x27-t4*t6*t11*t12*in_x4*in_x7*in_x14*in_x16*in_x21*in_x26+t4*t6*t11*t12*in_x4*in_x7*in_x14*in_x18*in_x19*in_x26-t4*t6*t11*t12*in_x4*in_x7*in_x14*in_x18*in_x20*in_x25+t4*t6*t11*t12*in_x4*in_x7*in_x15*in_x17*in_x19*in_x26-t4*t6*t11*t12*in_x4*in_x7*in_x15*in_x17*in_x20*in_x25-t4*t6*t11*t12*in_x5*in_x6*in_x10*in_x17*in_x23*in_x27-t4*t6*t11*t12*in_x5*in_x6*in_x10*in_x17*in_x24*in_x26+t4*t6*t11*t12*in_x5*in_x6*in_x11*in_x16*in_x23*in_x27+t4*t6*t11*t12*in_x5*in_x6*in_x11*in_x16*in_x24*in_x26-t4*t6*t11*t12*in_x5*in_x6*in_x11*in_x18*in_x22*in_x26-t4*t6*t11*t12*in_x5*in_x6*in_x11*in_x18*in_x23*in_x25+t4*t6*t11*t12*in_x5*in_x6*in_x12*in_x17*in_x22*in_x26+t4*t6*t11*t12*in_x5*in_x6*in_x12*in_x17*in_x23*in_x25+t8*t9*t10*t12*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27-t8*t9*t10*t12*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27+t8*t9*t10*t12*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26-t8*t9*t10*t12*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26+t2*t11*t12*t13*in_x6*in_x7*in_x10*in_x14*in_x23*in_x24+t2*t11*t12*t13*in_x6*in_x7*in_x11*in_x13*in_x23*in_x24-t2*t11*t12*t13*in_x6*in_x7*in_x11*in_x15*in_x22*in_x23-t2*t11*t12*t13*in_x6*in_x7*in_x12*in_x14*in_x22*in_x23+t4*t6*t8*t12*in_x6*in_x9*in_x10*in_x17*in_x23*in_x27+t4*t6*t8*t12*in_x6*in_x9*in_x10*in_x17*in_x24*in_x26-t4*t6*t8*t12*in_x6*in_x9*in_x11*in_x16*in_x23*in_x27-t4*t6*t8*t12*in_x6*in_x9*in_x11*in_x16*in_x24*in_x26+t4*t6*t8*t12*in_x6*in_x9*in_x11*in_x18*in_x22*in_x26+t4*t6*t8*t12*in_x6*in_x9*in_x11*in_x18*in_x23*in_x25-t4*t6*t8*t12*in_x6*in_x9*in_x12*in_x17*in_x22*in_x26-t4*t6*t8*t12*in_x6*in_x9*in_x12*in_x17*in_x23*in_x25-t4*t6*t8*t12*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27+t4*t6*t8*t12*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26-t4*t6*t8*t12*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27+t4*t6*t8*t12*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26-t4*t6*t8*t12*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26+t4*t6*t8*t12*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25-t4*t6*t8*t12*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26+t4*t6*t8*t12*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25-t5*t6*t11*t12*in_x3*in_x5*in_x13*in_x17*in_x23*in_x27-t5*t6*t11*t12*in_x3*in_x5*in_x13*in_x17*in_x24*in_x26-t5*t6*t11*t12*in_x3*in_x5*in_x14*in_x16*in_x23*in_x27-t5*t6*t11*t12*in_x3*in_x5*in_x14*in_x16*in_x24*in_x26+t5*t6*t11*t12*in_x3*in_x5*in_x14*in_x18*in_x22*in_x26+t5*t6*t11*t12*in_x3*in_x5*in_x14*in_x18*in_x23*in_x25+t5*t6*t11*t12*in_x3*in_x5*in_x15*in_x17*in_x22*in_x26+t5*t6*t11*t12*in_x3*in_x5*in_x15*in_x17*in_x23*in_x25-t5*t6*t13*t14*in_x2*in_x8*in_x10*in_x17*in_x20*in_x27-t5*t6*t13*t14*in_x2*in_x8*in_x10*in_x17*in_x21*in_x26+t5*t6*t13*t14*in_x2*in_x8*in_x11*in_x16*in_x20*in_x27+t5*t6*t13*t14*in_x2*in_x8*in_x11*in_x16*in_x21*in_x26-t5*t6*t13*t14*in_x2*in_x8*in_x11*in_x18*in_x19*in_x26-t5*t6*t13*t14*in_x2*in_x8*in_x11*in_x18*in_x20*in_x25+t5*t6*t13*t14*in_x2*in_x8*in_x12*in_x17*in_x19*in_x26+t5*t6*t13*t14*in_x2*in_x8*in_x12*in_x17*in_x20*in_x25+t5*t6*t14*t15*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27-t5*t6*t14*t15*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27+t5*t6*t14*t15*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26-t5*t6*t14*t15*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26-t9*t10*t11*t12*in_x2*in_x4*in_x10*in_x17*in_x20*in_x27+t9*t10*t11*t12*in_x2*in_x4*in_x10*in_x17*in_x21*in_x26-t9*t10*t11*t12*in_x2*in_x4*in_x11*in_x16*in_x20*in_x27+t9*t10*t11*t12*in_x2*in_x4*in_x11*in_x16*in_x21*in_x26-t9*t10*t11*t12*in_x2*in_x4*in_x11*in_x18*in_x19*in_x26+t9*t10*t11*t12*in_x2*in_x4*in_x11*in_x18*in_x20*in_x25-t9*t10*t11*t12*in_x2*in_x4*in_x12*in_x17*in_x19*in_x26+t9*t10*t11*t12*in_x2*in_x4*in_x12*in_x17*in_x20*in_x25-t4*t6*t11*t12*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27+t4*t6*t11*t12*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27-t4*t6*t11*t12*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26+t4*t6*t11*t12*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26-t4*t6*t14*t15*in_x4*in_x6*in_x10*in_x17*in_x20*in_x27-t4*t6*t14*t15*in_x4*in_x6*in_x10*in_x17*in_x21*in_x26+t4*t6*t14*t15*in_x4*in_x6*in_x11*in_x16*in_x20*in_x27+t4*t6*t14*t15*in_x4*in_x6*in_x11*in_x16*in_x21*in_x26-t4*t6*t14*t15*in_x4*in_x6*in_x11*in_x18*in_x19*in_x26-t4*t6*t14*t15*in_x4*in_x6*in_x11*in_x18*in_x20*in_x25+t4*t6*t14*t15*in_x4*in_x6*in_x12*in_x17*in_x19*in_x26+t4*t6*t14*t15*in_x4*in_x6*in_x12*in_x17*in_x20*in_x25+t5*t6*t8*t12*in_x3*in_x9*in_x13*in_x17*in_x23*in_x27+t5*t6*t8*t12*in_x3*in_x9*in_x13*in_x17*in_x24*in_x26+t5*t6*t8*t12*in_x3*in_x9*in_x14*in_x16*in_x23*in_x27+t5*t6*t8*t12*in_x3*in_x9*in_x14*in_x16*in_x24*in_x26-t5*t6*t8*t12*in_x3*in_x9*in_x14*in_x18*in_x22*in_x26-t5*t6*t8*t12*in_x3*in_x9*in_x14*in_x18*in_x23*in_x25-t5*t6*t8*t12*in_x3*in_x9*in_x15*in_x17*in_x22*in_x26-t5*t6*t8*t12*in_x3*in_x9*in_x15*in_x17*in_x23*in_x25+t7*t9*t11*t12*in_x4*in_x6*in_x10*in_x17*in_x20*in_x27-t7*t9*t11*t12*in_x4*in_x6*in_x10*in_x17*in_x21*in_x26+t7*t9*t11*t12*in_x4*in_x6*in_x11*in_x16*in_x20*in_x27-t7*t9*t11*t12*in_x4*in_x6*in_x11*in_x16*in_x21*in_x26+t7*t9*t11*t12*in_x4*in_x6*in_x11*in_x18*in_x19*in_x26-t7*t9*t11*t12*in_x4*in_x6*in_x11*in_x18*in_x20*in_x25+t7*t9*t11*t12*in_x4*in_x6*in_x12*in_x17*in_x19*in_x26-t7*t9*t11*t12*in_x4*in_x6*in_x12*in_x17*in_x20*in_x25+t8*t9*t10*t12*in_x2*in_x8*in_x10*in_x17*in_x20*in_x27-t8*t9*t10*t12*in_x2*in_x8*in_x10*in_x17*in_x21*in_x26+t8*t9*t10*t12*in_x2*in_x8*in_x11*in_x16*in_x20*in_x27-t8*t9*t10*t12*in_x2*in_x8*in_x11*in_x16*in_x21*in_x26+t8*t9*t10*t12*in_x2*in_x8*in_x11*in_x18*in_x19*in_x26-t8*t9*t10*t12*in_x2*in_x8*in_x11*in_x18*in_x20*in_x25+t8*t9*t10*t12*in_x2*in_x8*in_x12*in_x17*in_x19*in_x26-t8*t9*t10*t12*in_x2*in_x8*in_x12*in_x17*in_x20*in_x25-t2*t7*t13*t14*in_x8*in_x9*in_x13*in_x14*in_x20*in_x24+t2*t7*t13*t14*in_x8*in_x9*in_x13*in_x14*in_x21*in_x23-t2*t7*t13*t14*in_x8*in_x9*in_x14*in_x15*in_x19*in_x23+t2*t7*t13*t14*in_x8*in_x9*in_x14*in_x15*in_x20*in_x22-t4*t6*t8*t12*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24+t4*t6*t8*t12*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23-t4*t6*t8*t12*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23+t4*t6*t8*t12*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22+t5*t6*t14*t15*in_x2*in_x5*in_x10*in_x17*in_x23*in_x27-t5*t6*t14*t15*in_x2*in_x5*in_x10*in_x17*in_x24*in_x26-t5*t6*t14*t15*in_x2*in_x5*in_x11*in_x16*in_x23*in_x27+t5*t6*t14*t15*in_x2*in_x5*in_x11*in_x16*in_x24*in_x26-t5*t6*t14*t15*in_x2*in_x5*in_x11*in_x18*in_x22*in_x26+t5*t6*t14*t15*in_x2*in_x5*in_x11*in_x18*in_x23*in_x25+t5*t6*t14*t15*in_x2*in_x5*in_x12*in_x17*in_x22*in_x26-t5*t6*t14*t15*in_x2*in_x5*in_x12*in_x17*in_x23*in_x25-t5*t6*t14*t15*in_x3*in_x4*in_x13*in_x17*in_x20*in_x27-t5*t6*t14*t15*in_x3*in_x4*in_x13*in_x17*in_x21*in_x26-t5*t6*t14*t15*in_x3*in_x4*in_x14*in_x16*in_x20*in_x27-t5*t6*t14*t15*in_x3*in_x4*in_x14*in_x16*in_x21*in_x26+t5*t6*t14*t15*in_x3*in_x4*in_x14*in_x18*in_x19*in_x26+t5*t6*t14*t15*in_x3*in_x4*in_x14*in_x18*in_x20*in_x25+t5*t6*t14*t15*in_x3*in_x4*in_x15*in_x17*in_x19*in_x26+t5*t6*t14*t15*in_x3*in_x4*in_x15*in_x17*in_x20*in_x25-t7*t8*t9*t12*in_x6*in_x8*in_x10*in_x17*in_x20*in_x27+t7*t8*t9*t12*in_x6*in_x8*in_x10*in_x17*in_x21*in_x26-t7*t8*t9*t12*in_x6*in_x8*in_x11*in_x16*in_x20*in_x27+t7*t8*t9*t12*in_x6*in_x8*in_x11*in_x16*in_x21*in_x26-t7*t8*t9*t12*in_x6*in_x8*in_x11*in_x18*in_x19*in_x26+t7*t8*t9*t12*in_x6*in_x8*in_x11*in_x18*in_x20*in_x25-t7*t8*t9*t12*in_x6*in_x8*in_x12*in_x17*in_x19*in_x26+t7*t8*t9*t12*in_x6*in_x8*in_x12*in_x17*in_x20*in_x25-t9*t10*t11*t12*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27+t9*t10*t11*t12*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27-t9*t10*t11*t12*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26+t9*t10*t11*t12*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26+t4*t6*t11*t12*in_x5*in_x7*in_x13*in_x17*in_x23*in_x27+t4*t6*t11*t12*in_x5*in_x7*in_x13*in_x17*in_x24*in_x26+t4*t6*t11*t12*in_x5*in_x7*in_x14*in_x16*in_x23*in_x27+t4*t6*t11*t12*in_x5*in_x7*in_x14*in_x16*in_x24*in_x26-t4*t6*t11*t12*in_x5*in_x7*in_x14*in_x18*in_x22*in_x26-t4*t6*t11*t12*in_x5*in_x7*in_x14*in_x18*in_x23*in_x25-t4*t6*t11*t12*in_x5*in_x7*in_x15*in_x17*in_x22*in_x26-t4*t6*t11*t12*in_x5*in_x7*in_x15*in_x17*in_x23*in_x25+t4*t6*t13*t14*in_x6*in_x8*in_x10*in_x17*in_x20*in_x27+t4*t6*t13*t14*in_x6*in_x8*in_x10*in_x17*in_x21*in_x26-t4*t6*t13*t14*in_x6*in_x8*in_x11*in_x16*in_x20*in_x27-t4*t6*t13*t14*in_x6*in_x8*in_x11*in_x16*in_x21*in_x26+t4*t6*t13*t14*in_x6*in_x8*in_x11*in_x18*in_x19*in_x26+t4*t6*t13*t14*in_x6*in_x8*in_x11*in_x18*in_x20*in_x25-t4*t6*t13*t14*in_x6*in_x8*in_x12*in_x17*in_x19*in_x26-t4*t6*t13*t14*in_x6*in_x8*in_x12*in_x17*in_x20*in_x25-t4*t6*t14*t15*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24+t4*t6*t14*t15*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23-t4*t6*t14*t15*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23+t4*t6*t14*t15*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22+t5*t6*t8*t12*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24-t5*t6*t8*t12*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23+t5*t6*t8*t12*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23-t5*t6*t8*t12*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22+t7*t9*t11*t12*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24-t7*t9*t11*t12*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23+t7*t9*t11*t12*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23-t7*t9*t11*t12*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22-t4*t6*t8*t12*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27-t4*t6*t8*t12*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26-t4*t6*t8*t12*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27-t4*t6*t8*t12*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26+t4*t6*t8*t12*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26+t4*t6*t8*t12*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25+t4*t6*t8*t12*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26+t4*t6*t8*t12*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25-t5*t6*t13*t14*in_x2*in_x9*in_x10*in_x17*in_x23*in_x27+t5*t6*t13*t14*in_x2*in_x9*in_x10*in_x17*in_x24*in_x26+t5*t6*t13*t14*in_x2*in_x9*in_x11*in_x16*in_x23*in_x27-t5*t6*t13*t14*in_x2*in_x9*in_x11*in_x16*in_x24*in_x26+t5*t6*t13*t14*in_x2*in_x9*in_x11*in_x18*in_x22*in_x26-t5*t6*t13*t14*in_x2*in_x9*in_x11*in_x18*in_x23*in_x25-t5*t6*t13*t14*in_x2*in_x9*in_x12*in_x17*in_x22*in_x26+t5*t6*t13*t14*in_x2*in_x9*in_x12*in_x17*in_x23*in_x25+t5*t6*t13*t14*in_x3*in_x8*in_x13*in_x17*in_x20*in_x27+t5*t6*t13*t14*in_x3*in_x8*in_x13*in_x17*in_x21*in_x26+t5*t6*t13*t14*in_x3*in_x8*in_x14*in_x16*in_x20*in_x27+t5*t6*t13*t14*in_x3*in_x8*in_x14*in_x16*in_x21*in_x26-t5*t6*t13*t14*in_x3*in_x8*in_x14*in_x18*in_x19*in_x26-t5*t6*t13*t14*in_x3*in_x8*in_x14*in_x18*in_x20*in_x25-t5*t6*t13*t14*in_x3*in_x8*in_x15*in_x17*in_x19*in_x26-t5*t6*t13*t14*in_x3*in_x8*in_x15*in_x17*in_x20*in_x25+t5*t6*t14*t15*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24-t5*t6*t14*t15*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23+t5*t6*t14*t15*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23-t5*t6*t14*t15*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22-t7*t8*t9*t12*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27+t7*t8*t9*t12*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27-t7*t8*t9*t12*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26+t7*t8*t9*t12*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26-t9*t10*t11*t12*in_x2*in_x5*in_x10*in_x17*in_x23*in_x27-t9*t10*t11*t12*in_x2*in_x5*in_x10*in_x17*in_x24*in_x26-t9*t10*t11*t12*in_x2*in_x5*in_x11*in_x16*in_x23*in_x27-t9*t10*t11*t12*in_x2*in_x5*in_x11*in_x16*in_x24*in_x26+t9*t10*t11*t12*in_x2*in_x5*in_x11*in_x18*in_x22*in_x26+t9*t10*t11*t12*in_x2*in_x5*in_x11*in_x18*in_x23*in_x25+t9*t10*t11*t12*in_x2*in_x5*in_x12*in_x17*in_x22*in_x26+t9*t10*t11*t12*in_x2*in_x5*in_x12*in_x17*in_x23*in_x25+t9*t10*t11*t12*in_x3*in_x4*in_x13*in_x17*in_x20*in_x27-t9*t10*t11*t12*in_x3*in_x4*in_x13*in_x17*in_x21*in_x26-t9*t10*t11*t12*in_x3*in_x4*in_x14*in_x16*in_x20*in_x27+t9*t10*t11*t12*in_x3*in_x4*in_x14*in_x16*in_x21*in_x26-t9*t10*t11*t12*in_x3*in_x4*in_x14*in_x18*in_x19*in_x26+t9*t10*t11*t12*in_x3*in_x4*in_x14*in_x18*in_x20*in_x25+t9*t10*t11*t12*in_x3*in_x4*in_x15*in_x17*in_x19*in_x26-t9*t10*t11*t12*in_x3*in_x4*in_x15*in_x17*in_x20*in_x25+t2*t10*t13*t14*in_x8*in_x9*in_x13*in_x14*in_x20*in_x24-t2*t10*t13*t14*in_x8*in_x9*in_x13*in_x14*in_x21*in_x23+t2*t10*t13*t14*in_x8*in_x9*in_x14*in_x15*in_x19*in_x23-t2*t10*t13*t14*in_x8*in_x9*in_x14*in_x15*in_x20*in_x22+t4*t6*t13*t14*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27-t4*t6*t13*t14*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27+t4*t6*t13*t14*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26-t4*t6*t13*t14*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26+t4*t6*t14*t15*in_x4*in_x7*in_x13*in_x17*in_x20*in_x27+t4*t6*t14*t15*in_x4*in_x7*in_x13*in_x17*in_x21*in_x26+t4*t6*t14*t15*in_x4*in_x7*in_x14*in_x16*in_x20*in_x27+t4*t6*t14*t15*in_x4*in_x7*in_x14*in_x16*in_x21*in_x26-t4*t6*t14*t15*in_x4*in_x7*in_x14*in_x18*in_x19*in_x26-t4*t6*t14*t15*in_x4*in_x7*in_x14*in_x18*in_x20*in_x25-t4*t6*t14*t15*in_x4*in_x7*in_x15*in_x17*in_x19*in_x26-t4*t6*t14*t15*in_x4*in_x7*in_x15*in_x17*in_x20*in_x25-t4*t6*t14*t15*in_x5*in_x6*in_x10*in_x17*in_x23*in_x27+t4*t6*t14*t15*in_x5*in_x6*in_x10*in_x17*in_x24*in_x26+t4*t6*t14*t15*in_x5*in_x6*in_x11*in_x16*in_x23*in_x27-t4*t6*t14*t15*in_x5*in_x6*in_x11*in_x16*in_x24*in_x26+t4*t6*t14*t15*in_x5*in_x6*in_x11*in_x18*in_x22*in_x26-t4*t6*t14*t15*in_x5*in_x6*in_x11*in_x18*in_x23*in_x25-t4*t6*t14*t15*in_x5*in_x6*in_x12*in_x17*in_x22*in_x26+t4*t6*t14*t15*in_x5*in_x6*in_x12*in_x17*in_x23*in_x25-t7*t9*t11*t12*in_x4*in_x7*in_x13*in_x17*in_x20*in_x27+t7*t9*t11*t12*in_x4*in_x7*in_x13*in_x17*in_x21*in_x26+t7*t9*t11*t12*in_x4*in_x7*in_x14*in_x16*in_x20*in_x27-t7*t9*t11*t12*in_x4*in_x7*in_x14*in_x16*in_x21*in_x26+t7*t9*t11*t12*in_x4*in_x7*in_x14*in_x18*in_x19*in_x26-t7*t9*t11*t12*in_x4*in_x7*in_x14*in_x18*in_x20*in_x25-t7*t9*t11*t12*in_x4*in_x7*in_x15*in_x17*in_x19*in_x26+t7*t9*t11*t12*in_x4*in_x7*in_x15*in_x17*in_x20*in_x25+t7*t9*t11*t12*in_x5*in_x6*in_x10*in_x17*in_x23*in_x27+t7*t9*t11*t12*in_x5*in_x6*in_x10*in_x17*in_x24*in_x26+t7*t9*t11*t12*in_x5*in_x6*in_x11*in_x16*in_x23*in_x27+t7*t9*t11*t12*in_x5*in_x6*in_x11*in_x16*in_x24*in_x26-t7*t9*t11*t12*in_x5*in_x6*in_x11*in_x18*in_x22*in_x26-t7*t9*t11*t12*in_x5*in_x6*in_x11*in_x18*in_x23*in_x25-t7*t9*t11*t12*in_x5*in_x6*in_x12*in_x17*in_x22*in_x26-t7*t9*t11*t12*in_x5*in_x6*in_x12*in_x17*in_x23*in_x25+t8*t9*t10*t12*in_x2*in_x9*in_x10*in_x17*in_x23*in_x27+t8*t9*t10*t12*in_x2*in_x9*in_x10*in_x17*in_x24*in_x26+t8*t9*t10*t12*in_x2*in_x9*in_x11*in_x16*in_x23*in_x27+t8*t9*t10*t12*in_x2*in_x9*in_x11*in_x16*in_x24*in_x26-t8*t9*t10*t12*in_x2*in_x9*in_x11*in_x18*in_x22*in_x26-t8*t9*t10*t12*in_x2*in_x9*in_x11*in_x18*in_x23*in_x25-t8*t9*t10*t12*in_x2*in_x9*in_x12*in_x17*in_x22*in_x26-t8*t9*t10*t12*in_x2*in_x9*in_x12*in_x17*in_x23*in_x25-t8*t9*t10*t12*in_x3*in_x8*in_x13*in_x17*in_x20*in_x27+t8*t9*t10*t12*in_x3*in_x8*in_x13*in_x17*in_x21*in_x26+t8*t9*t10*t12*in_x3*in_x8*in_x14*in_x16*in_x20*in_x27-t8*t9*t10*t12*in_x3*in_x8*in_x14*in_x16*in_x21*in_x26+t8*t9*t10*t12*in_x3*in_x8*in_x14*in_x18*in_x19*in_x26-t8*t9*t10*t12*in_x3*in_x8*in_x14*in_x18*in_x20*in_x25-t8*t9*t10*t12*in_x3*in_x8*in_x15*in_x17*in_x19*in_x26+t8*t9*t10*t12*in_x3*in_x8*in_x15*in_x17*in_x20*in_x25-t5*t6*t14*t15*in_x3*in_x5*in_x13*in_x17*in_x23*in_x27+t5*t6*t14*t15*in_x3*in_x5*in_x13*in_x17*in_x24*in_x26-t5*t6*t14*t15*in_x3*in_x5*in_x14*in_x16*in_x23*in_x27+t5*t6*t14*t15*in_x3*in_x5*in_x14*in_x16*in_x24*in_x26-t5*t6*t14*t15*in_x3*in_x5*in_x14*in_x18*in_x22*in_x26+t5*t6*t14*t15*in_x3*in_x5*in_x14*in_x18*in_x23*in_x25-t5*t6*t14*t15*in_x3*in_x5*in_x15*in_x17*in_x22*in_x26+t5*t6*t14*t15*in_x3*in_x5*in_x15*in_x17*in_x23*in_x25-t7*t8*t9*t12*in_x6*in_x9*in_x10*in_x17*in_x23*in_x27-t7*t8*t9*t12*in_x6*in_x9*in_x10*in_x17*in_x24*in_x26-t7*t8*t9*t12*in_x6*in_x9*in_x11*in_x16*in_x23*in_x27-t7*t8*t9*t12*in_x6*in_x9*in_x11*in_x16*in_x24*in_x26+t7*t8*t9*t12*in_x6*in_x9*in_x11*in_x18*in_x22*in_x26+t7*t8*t9*t12*in_x6*in_x9*in_x11*in_x18*in_x23*in_x25+t7*t8*t9*t12*in_x6*in_x9*in_x12*in_x17*in_x22*in_x26+t7*t8*t9*t12*in_x6*in_x9*in_x12*in_x17*in_x23*in_x25+t7*t8*t9*t12*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27-t7*t8*t9*t12*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26-t7*t8*t9*t12*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27+t7*t8*t9*t12*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26-t7*t8*t9*t12*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26+t7*t8*t9*t12*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25+t7*t8*t9*t12*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26-t7*t8*t9*t12*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25-t9*t10*t11*t12*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24+t9*t10*t11*t12*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23-t9*t10*t11*t12*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23+t9*t10*t11*t12*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22+t9*t10*t13*t14*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27-t9*t10*t13*t14*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27+t9*t10*t13*t14*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26-t9*t10*t13*t14*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26-t9*t10*t14*t15*in_x2*in_x4*in_x10*in_x17*in_x20*in_x27-t9*t10*t14*t15*in_x2*in_x4*in_x10*in_x17*in_x21*in_x26-t9*t10*t14*t15*in_x2*in_x4*in_x11*in_x16*in_x20*in_x27-t9*t10*t14*t15*in_x2*in_x4*in_x11*in_x16*in_x21*in_x26+t9*t10*t14*t15*in_x2*in_x4*in_x11*in_x18*in_x19*in_x26+t9*t10*t14*t15*in_x2*in_x4*in_x11*in_x18*in_x20*in_x25+t9*t10*t14*t15*in_x2*in_x4*in_x12*in_x17*in_x19*in_x26+t9*t10*t14*t15*in_x2*in_x4*in_x12*in_x17*in_x20*in_x25+t4*t6*t13*t14*in_x6*in_x9*in_x10*in_x17*in_x23*in_x27-t4*t6*t13*t14*in_x6*in_x9*in_x10*in_x17*in_x24*in_x26-t4*t6*t13*t14*in_x6*in_x9*in_x11*in_x16*in_x23*in_x27+t4*t6*t13*t14*in_x6*in_x9*in_x11*in_x16*in_x24*in_x26-t4*t6*t13*t14*in_x6*in_x9*in_x11*in_x18*in_x22*in_x26+t4*t6*t13*t14*in_x6*in_x9*in_x11*in_x18*in_x23*in_x25+t4*t6*t13*t14*in_x6*in_x9*in_x12*in_x17*in_x22*in_x26-t4*t6*t13*t14*in_x6*in_x9*in_x12*in_x17*in_x23*in_x25-t4*t6*t13*t14*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27-t4*t6*t13*t14*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26-t4*t6*t13*t14*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27-t4*t6*t13*t14*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26+t4*t6*t13*t14*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26+t4*t6*t13*t14*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25+t4*t6*t13*t14*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26+t4*t6*t13*t14*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25-t4*t6*t14*t15*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27+t4*t6*t14*t15*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27-t4*t6*t14*t15*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26+t4*t6*t14*t15*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26+t7*t9*t11*t12*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27-t7*t9*t11*t12*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27+t7*t9*t11*t12*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26-t7*t9*t11*t12*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26+t7*t9*t14*t15*in_x4*in_x6*in_x10*in_x17*in_x20*in_x27+t7*t9*t14*t15*in_x4*in_x6*in_x10*in_x17*in_x21*in_x26+t7*t9*t14*t15*in_x4*in_x6*in_x11*in_x16*in_x20*in_x27+t7*t9*t14*t15*in_x4*in_x6*in_x11*in_x16*in_x21*in_x26-t7*t9*t14*t15*in_x4*in_x6*in_x11*in_x18*in_x19*in_x26-t7*t9*t14*t15*in_x4*in_x6*in_x11*in_x18*in_x20*in_x25-t7*t9*t14*t15*in_x4*in_x6*in_x12*in_x17*in_x19*in_x26-t7*t9*t14*t15*in_x4*in_x6*in_x12*in_x17*in_x20*in_x25+t5*t6*t13*t14*in_x3*in_x9*in_x13*in_x17*in_x23*in_x27-t5*t6*t13*t14*in_x3*in_x9*in_x13*in_x17*in_x24*in_x26+t5*t6*t13*t14*in_x3*in_x9*in_x14*in_x16*in_x23*in_x27-t5*t6*t13*t14*in_x3*in_x9*in_x14*in_x16*in_x24*in_x26+t5*t6*t13*t14*in_x3*in_x9*in_x14*in_x18*in_x22*in_x26-t5*t6*t13*t14*in_x3*in_x9*in_x14*in_x18*in_x23*in_x25+t5*t6*t13*t14*in_x3*in_x9*in_x15*in_x17*in_x22*in_x26-t5*t6*t13*t14*in_x3*in_x9*in_x15*in_x17*in_x23*in_x25-t7*t8*t9*t12*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24+t7*t8*t9*t12*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23-t7*t8*t9*t12*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23+t7*t8*t9*t12*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22+t9*t10*t11*t12*in_x3*in_x5*in_x13*in_x17*in_x23*in_x27+t9*t10*t11*t12*in_x3*in_x5*in_x13*in_x17*in_x24*in_x26-t9*t10*t11*t12*in_x3*in_x5*in_x14*in_x16*in_x23*in_x27-t9*t10*t11*t12*in_x3*in_x5*in_x14*in_x16*in_x24*in_x26+t9*t10*t11*t12*in_x3*in_x5*in_x14*in_x18*in_x22*in_x26+t9*t10*t11*t12*in_x3*in_x5*in_x14*in_x18*in_x23*in_x25-t9*t10*t11*t12*in_x3*in_x5*in_x15*in_x17*in_x22*in_x26-t9*t10*t11*t12*in_x3*in_x5*in_x15*in_x17*in_x23*in_x25+t9*t10*t13*t14*in_x2*in_x8*in_x10*in_x17*in_x20*in_x27+t9*t10*t13*t14*in_x2*in_x8*in_x10*in_x17*in_x21*in_x26+t9*t10*t13*t14*in_x2*in_x8*in_x11*in_x16*in_x20*in_x27+t9*t10*t13*t14*in_x2*in_x8*in_x11*in_x16*in_x21*in_x26-t9*t10*t13*t14*in_x2*in_x8*in_x11*in_x18*in_x19*in_x26-t9*t10*t13*t14*in_x2*in_x8*in_x11*in_x18*in_x20*in_x25-t9*t10*t13*t14*in_x2*in_x8*in_x12*in_x17*in_x19*in_x26-t9*t10*t13*t14*in_x2*in_x8*in_x12*in_x17*in_x20*in_x25-t9*t10*t14*t15*in_x2*in_x3*in_x10*in_x14*in_x26*in_x27+t9*t10*t14*t15*in_x2*in_x3*in_x11*in_x13*in_x26*in_x27-t9*t10*t14*t15*in_x2*in_x3*in_x11*in_x15*in_x25*in_x26+t9*t10*t14*t15*in_x2*in_x3*in_x12*in_x14*in_x25*in_x26+t4*t6*t13*t14*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24-t4*t6*t13*t14*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23+t4*t6*t13*t14*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23-t4*t6*t13*t14*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22+t4*t6*t14*t15*in_x5*in_x7*in_x13*in_x17*in_x23*in_x27-t4*t6*t14*t15*in_x5*in_x7*in_x13*in_x17*in_x24*in_x26+t4*t6*t14*t15*in_x5*in_x7*in_x14*in_x16*in_x23*in_x27-t4*t6*t14*t15*in_x5*in_x7*in_x14*in_x16*in_x24*in_x26+t4*t6*t14*t15*in_x5*in_x7*in_x14*in_x18*in_x22*in_x26-t4*t6*t14*t15*in_x5*in_x7*in_x14*in_x18*in_x23*in_x25+t4*t6*t14*t15*in_x5*in_x7*in_x15*in_x17*in_x22*in_x26-t4*t6*t14*t15*in_x5*in_x7*in_x15*in_x17*in_x23*in_x25-t7*t9*t11*t12*in_x5*in_x7*in_x13*in_x17*in_x23*in_x27-t7*t9*t11*t12*in_x5*in_x7*in_x13*in_x17*in_x24*in_x26+t7*t9*t11*t12*in_x5*in_x7*in_x14*in_x16*in_x23*in_x27+t7*t9*t11*t12*in_x5*in_x7*in_x14*in_x16*in_x24*in_x26-t7*t9*t11*t12*in_x5*in_x7*in_x14*in_x18*in_x22*in_x26-t7*t9*t11*t12*in_x5*in_x7*in_x14*in_x18*in_x23*in_x25+t7*t9*t11*t12*in_x5*in_x7*in_x15*in_x17*in_x22*in_x26+t7*t9*t11*t12*in_x5*in_x7*in_x15*in_x17*in_x23*in_x25-t7*t9*t13*t14*in_x6*in_x8*in_x10*in_x17*in_x20*in_x27-t7*t9*t13*t14*in_x6*in_x8*in_x10*in_x17*in_x21*in_x26-t7*t9*t13*t14*in_x6*in_x8*in_x11*in_x16*in_x20*in_x27-t7*t9*t13*t14*in_x6*in_x8*in_x11*in_x16*in_x21*in_x26+t7*t9*t13*t14*in_x6*in_x8*in_x11*in_x18*in_x19*in_x26+t7*t9*t13*t14*in_x6*in_x8*in_x11*in_x18*in_x20*in_x25+t7*t9*t13*t14*in_x6*in_x8*in_x12*in_x17*in_x19*in_x26+t7*t9*t13*t14*in_x6*in_x8*in_x12*in_x17*in_x20*in_x25-t7*t9*t14*t15*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24+t7*t9*t14*t15*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23-t7*t9*t14*t15*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23+t7*t9*t14*t15*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22-t8*t9*t10*t12*in_x3*in_x9*in_x13*in_x17*in_x23*in_x27-t8*t9*t10*t12*in_x3*in_x9*in_x13*in_x17*in_x24*in_x26+t8*t9*t10*t12*in_x3*in_x9*in_x14*in_x16*in_x23*in_x27+t8*t9*t10*t12*in_x3*in_x9*in_x14*in_x16*in_x24*in_x26-t8*t9*t10*t12*in_x3*in_x9*in_x14*in_x18*in_x22*in_x26-t8*t9*t10*t12*in_x3*in_x9*in_x14*in_x18*in_x23*in_x25+t8*t9*t10*t12*in_x3*in_x9*in_x15*in_x17*in_x22*in_x26+t8*t9*t10*t12*in_x3*in_x9*in_x15*in_x17*in_x23*in_x25-t5*t6*t13*t14*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24+t5*t6*t13*t14*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23-t5*t6*t13*t14*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23+t5*t6*t13*t14*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22+t7*t8*t9*t12*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27+t7*t8*t9*t12*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26-t7*t8*t9*t12*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27-t7*t8*t9*t12*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26+t7*t8*t9*t12*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26+t7*t8*t9*t12*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25-t7*t8*t9*t12*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26-t7*t8*t9*t12*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25-t9*t10*t14*t15*in_x2*in_x5*in_x10*in_x17*in_x23*in_x27+t9*t10*t14*t15*in_x2*in_x5*in_x10*in_x17*in_x24*in_x26-t9*t10*t14*t15*in_x2*in_x5*in_x11*in_x16*in_x23*in_x27+t9*t10*t14*t15*in_x2*in_x5*in_x11*in_x16*in_x24*in_x26-t9*t10*t14*t15*in_x2*in_x5*in_x11*in_x18*in_x22*in_x26+t9*t10*t14*t15*in_x2*in_x5*in_x11*in_x18*in_x23*in_x25-t9*t10*t14*t15*in_x2*in_x5*in_x12*in_x17*in_x22*in_x26+t9*t10*t14*t15*in_x2*in_x5*in_x12*in_x17*in_x23*in_x25+t9*t10*t14*t15*in_x3*in_x4*in_x13*in_x17*in_x20*in_x27+t9*t10*t14*t15*in_x3*in_x4*in_x13*in_x17*in_x21*in_x26-t9*t10*t14*t15*in_x3*in_x4*in_x14*in_x16*in_x20*in_x27-t9*t10*t14*t15*in_x3*in_x4*in_x14*in_x16*in_x21*in_x26+t9*t10*t14*t15*in_x3*in_x4*in_x14*in_x18*in_x19*in_x26+t9*t10*t14*t15*in_x3*in_x4*in_x14*in_x18*in_x20*in_x25-t9*t10*t14*t15*in_x3*in_x4*in_x15*in_x17*in_x19*in_x26-t9*t10*t14*t15*in_x3*in_x4*in_x15*in_x17*in_x20*in_x25-t4*t6*t13*t14*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27+t4*t6*t13*t14*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26-t4*t6*t13*t14*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27+t4*t6*t13*t14*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26-t4*t6*t13*t14*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26+t4*t6*t13*t14*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25-t4*t6*t13*t14*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26+t4*t6*t13*t14*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25-t7*t9*t13*t14*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27+t7*t9*t13*t14*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27-t7*t9*t13*t14*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26+t7*t9*t13*t14*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26-t7*t9*t14*t15*in_x4*in_x7*in_x13*in_x17*in_x20*in_x27-t7*t9*t14*t15*in_x4*in_x7*in_x13*in_x17*in_x21*in_x26+t7*t9*t14*t15*in_x4*in_x7*in_x14*in_x16*in_x20*in_x27+t7*t9*t14*t15*in_x4*in_x7*in_x14*in_x16*in_x21*in_x26-t7*t9*t14*t15*in_x4*in_x7*in_x14*in_x18*in_x19*in_x26-t7*t9*t14*t15*in_x4*in_x7*in_x14*in_x18*in_x20*in_x25+t7*t9*t14*t15*in_x4*in_x7*in_x15*in_x17*in_x19*in_x26+t7*t9*t14*t15*in_x4*in_x7*in_x15*in_x17*in_x20*in_x25+t7*t9*t14*t15*in_x5*in_x6*in_x10*in_x17*in_x23*in_x27-t7*t9*t14*t15*in_x5*in_x6*in_x10*in_x17*in_x24*in_x26+t7*t9*t14*t15*in_x5*in_x6*in_x11*in_x16*in_x23*in_x27-t7*t9*t14*t15*in_x5*in_x6*in_x11*in_x16*in_x24*in_x26+t7*t9*t14*t15*in_x5*in_x6*in_x11*in_x18*in_x22*in_x26-t7*t9*t14*t15*in_x5*in_x6*in_x11*in_x18*in_x23*in_x25+t7*t9*t14*t15*in_x5*in_x6*in_x12*in_x17*in_x22*in_x26-t7*t9*t14*t15*in_x5*in_x6*in_x12*in_x17*in_x23*in_x25+t8*t9*t10*t12*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24-t8*t9*t10*t12*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23+t8*t9*t10*t12*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23-t8*t9*t10*t12*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22+t9*t10*t13*t14*in_x2*in_x9*in_x10*in_x17*in_x23*in_x27-t9*t10*t13*t14*in_x2*in_x9*in_x10*in_x17*in_x24*in_x26+t9*t10*t13*t14*in_x2*in_x9*in_x11*in_x16*in_x23*in_x27-t9*t10*t13*t14*in_x2*in_x9*in_x11*in_x16*in_x24*in_x26+t9*t10*t13*t14*in_x2*in_x9*in_x11*in_x18*in_x22*in_x26-t9*t10*t13*t14*in_x2*in_x9*in_x11*in_x18*in_x23*in_x25+t9*t10*t13*t14*in_x2*in_x9*in_x12*in_x17*in_x22*in_x26-t9*t10*t13*t14*in_x2*in_x9*in_x12*in_x17*in_x23*in_x25-t9*t10*t13*t14*in_x3*in_x8*in_x13*in_x17*in_x20*in_x27-t9*t10*t13*t14*in_x3*in_x8*in_x13*in_x17*in_x21*in_x26+t9*t10*t13*t14*in_x3*in_x8*in_x14*in_x16*in_x20*in_x27+t9*t10*t13*t14*in_x3*in_x8*in_x14*in_x16*in_x21*in_x26-t9*t10*t13*t14*in_x3*in_x8*in_x14*in_x18*in_x19*in_x26-t9*t10*t13*t14*in_x3*in_x8*in_x14*in_x18*in_x20*in_x25+t9*t10*t13*t14*in_x3*in_x8*in_x15*in_x17*in_x19*in_x26+t9*t10*t13*t14*in_x3*in_x8*in_x15*in_x17*in_x20*in_x25+t9*t10*t14*t15*in_x4*in_x5*in_x16*in_x17*in_x20*in_x24-t9*t10*t14*t15*in_x4*in_x5*in_x16*in_x17*in_x21*in_x23+t9*t10*t14*t15*in_x4*in_x5*in_x17*in_x18*in_x19*in_x23-t9*t10*t14*t15*in_x4*in_x5*in_x17*in_x18*in_x20*in_x22-t7*t9*t13*t14*in_x6*in_x9*in_x10*in_x17*in_x23*in_x27+t7*t9*t13*t14*in_x6*in_x9*in_x10*in_x17*in_x24*in_x26-t7*t9*t13*t14*in_x6*in_x9*in_x11*in_x16*in_x23*in_x27+t7*t9*t13*t14*in_x6*in_x9*in_x11*in_x16*in_x24*in_x26-t7*t9*t13*t14*in_x6*in_x9*in_x11*in_x18*in_x22*in_x26+t7*t9*t13*t14*in_x6*in_x9*in_x11*in_x18*in_x23*in_x25-t7*t9*t13*t14*in_x6*in_x9*in_x12*in_x17*in_x22*in_x26+t7*t9*t13*t14*in_x6*in_x9*in_x12*in_x17*in_x23*in_x25+t7*t9*t13*t14*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27+t7*t9*t13*t14*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26-t7*t9*t13*t14*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27-t7*t9*t13*t14*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26+t7*t9*t13*t14*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26+t7*t9*t13*t14*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25-t7*t9*t13*t14*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26-t7*t9*t13*t14*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25+t7*t9*t14*t15*in_x6*in_x7*in_x10*in_x14*in_x26*in_x27-t7*t9*t14*t15*in_x6*in_x7*in_x11*in_x13*in_x26*in_x27+t7*t9*t14*t15*in_x6*in_x7*in_x11*in_x15*in_x25*in_x26-t7*t9*t14*t15*in_x6*in_x7*in_x12*in_x14*in_x25*in_x26+t9*t10*t14*t15*in_x3*in_x5*in_x13*in_x17*in_x23*in_x27-t9*t10*t14*t15*in_x3*in_x5*in_x13*in_x17*in_x24*in_x26-t9*t10*t14*t15*in_x3*in_x5*in_x14*in_x16*in_x23*in_x27+t9*t10*t14*t15*in_x3*in_x5*in_x14*in_x16*in_x24*in_x26-t9*t10*t14*t15*in_x3*in_x5*in_x14*in_x18*in_x22*in_x26+t9*t10*t14*t15*in_x3*in_x5*in_x14*in_x18*in_x23*in_x25+t9*t10*t14*t15*in_x3*in_x5*in_x15*in_x17*in_x22*in_x26-t9*t10*t14*t15*in_x3*in_x5*in_x15*in_x17*in_x23*in_x25+t7*t9*t13*t14*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24-t7*t9*t13*t14*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23+t7*t9*t13*t14*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23-t7*t9*t13*t14*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22-t7*t9*t14*t15*in_x5*in_x7*in_x13*in_x17*in_x23*in_x27+t7*t9*t14*t15*in_x5*in_x7*in_x13*in_x17*in_x24*in_x26+t7*t9*t14*t15*in_x5*in_x7*in_x14*in_x16*in_x23*in_x27-t7*t9*t14*t15*in_x5*in_x7*in_x14*in_x16*in_x24*in_x26+t7*t9*t14*t15*in_x5*in_x7*in_x14*in_x18*in_x22*in_x26-t7*t9*t14*t15*in_x5*in_x7*in_x14*in_x18*in_x23*in_x25-t7*t9*t14*t15*in_x5*in_x7*in_x15*in_x17*in_x22*in_x26+t7*t9*t14*t15*in_x5*in_x7*in_x15*in_x17*in_x23*in_x25-t9*t10*t13*t14*in_x3*in_x9*in_x13*in_x17*in_x23*in_x27+t9*t10*t13*t14*in_x3*in_x9*in_x13*in_x17*in_x24*in_x26+t9*t10*t13*t14*in_x3*in_x9*in_x14*in_x16*in_x23*in_x27-t9*t10*t13*t14*in_x3*in_x9*in_x14*in_x16*in_x24*in_x26+t9*t10*t13*t14*in_x3*in_x9*in_x14*in_x18*in_x22*in_x26-t9*t10*t13*t14*in_x3*in_x9*in_x14*in_x18*in_x23*in_x25-t9*t10*t13*t14*in_x3*in_x9*in_x15*in_x17*in_x22*in_x26+t9*t10*t13*t14*in_x3*in_x9*in_x15*in_x17*in_x23*in_x25+t7*t9*t13*t14*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27-t7*t9*t13*t14*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26-t7*t9*t13*t14*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27+t7*t9*t13*t14*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26-t7*t9*t13*t14*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26+t7*t9*t13*t14*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25+t7*t9*t13*t14*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26-t7*t9*t13*t14*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25-t9*t10*t13*t14*in_x8*in_x9*in_x16*in_x17*in_x20*in_x24+t9*t10*t13*t14*in_x8*in_x9*in_x16*in_x17*in_x21*in_x23-t9*t10*t13*t14*in_x8*in_x9*in_x17*in_x18*in_x19*in_x23+t9*t10*t13*t14*in_x8*in_x9*in_x17*in_x18*in_x20*in_x22+t3*t5*t6*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x20*in_x24+t3*t5*t6*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x21*in_x23-t3*t5*t6*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x20*in_x24-t3*t5*t6*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x21*in_x23+t3*t5*t6*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x19*in_x23+t3*t5*t6*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x20*in_x22-t3*t5*t6*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x19*in_x23-t3*t5*t6*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x20*in_x22-t3*t5*t6*in_x2*in_x3*in_x4*in_x9*in_x10*in_x14*in_x20*in_x24*2.0+t3*t5*t6*in_x2*in_x3*in_x4*in_x9*in_x10*in_x14*in_x21*in_x23*2.0+t3*t5*t6*in_x2*in_x3*in_x4*in_x9*in_x11*in_x13*in_x20*in_x24*2.0-t3*t5*t6*in_x2*in_x3*in_x4*in_x9*in_x11*in_x13*in_x21*in_x23*2.0+t3*t5*t6*in_x2*in_x3*in_x4*in_x9*in_x11*in_x15*in_x19*in_x23*2.0-t3*t5*t6*in_x2*in_x3*in_x4*in_x9*in_x11*in_x15*in_x20*in_x22*2.0-t3*t5*t6*in_x2*in_x3*in_x4*in_x9*in_x12*in_x14*in_x19*in_x23*2.0+t3*t5*t6*in_x2*in_x3*in_x4*in_x9*in_x12*in_x14*in_x20*in_x22*2.0+t3*t5*t6*in_x2*in_x3*in_x5*in_x8*in_x10*in_x14*in_x20*in_x24*2.0-t3*t5*t6*in_x2*in_x3*in_x5*in_x8*in_x10*in_x14*in_x21*in_x23*2.0-t3*t5*t6*in_x2*in_x3*in_x5*in_x8*in_x11*in_x13*in_x20*in_x24*2.0+t3*t5*t6*in_x2*in_x3*in_x5*in_x8*in_x11*in_x13*in_x21*in_x23*2.0-t3*t5*t6*in_x2*in_x3*in_x5*in_x8*in_x11*in_x15*in_x19*in_x23*2.0+t3*t5*t6*in_x2*in_x3*in_x5*in_x8*in_x11*in_x15*in_x20*in_x22*2.0+t3*t5*t6*in_x2*in_x3*in_x5*in_x8*in_x12*in_x14*in_x19*in_x23*2.0-t3*t5*t6*in_x2*in_x3*in_x5*in_x8*in_x12*in_x14*in_x20*in_x22*2.0-t3*t4*t6*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x24-t3*t4*t6*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x21*in_x23+t3*t4*t6*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x24+t3*t4*t6*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x21*in_x23-t3*t4*t6*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x19*in_x23-t3*t4*t6*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x20*in_x22+t3*t4*t6*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x19*in_x23+t3*t4*t6*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x20*in_x22-t3*t5*t6*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24-t3*t5*t6*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23+t3*t5*t6*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24+t3*t5*t6*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23-t3*t5*t6*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23-t3*t5*t6*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22+t3*t5*t6*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23+t3*t5*t6*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22-t3*t9*t10*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x20*in_x24-t3*t9*t10*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x21*in_x23+t3*t9*t10*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x20*in_x24+t3*t9*t10*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x21*in_x23-t3*t9*t10*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x19*in_x23-t3*t9*t10*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x20*in_x22+t3*t9*t10*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x19*in_x23+t3*t9*t10*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x20*in_x22-t2*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x20*in_x24+t2*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x21*in_x23-t2*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x20*in_x24+t2*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x21*in_x23-t2*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x19*in_x23+t2*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x20*in_x22-t2*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x19*in_x23+t2*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x20*in_x22+t3*t4*t6*in_x4*in_x6*in_x7*in_x9*in_x10*in_x14*in_x20*in_x24*2.0-t3*t4*t6*in_x4*in_x6*in_x7*in_x9*in_x10*in_x14*in_x21*in_x23*2.0-t3*t4*t6*in_x4*in_x6*in_x7*in_x9*in_x11*in_x13*in_x20*in_x24*2.0+t3*t4*t6*in_x4*in_x6*in_x7*in_x9*in_x11*in_x13*in_x21*in_x23*2.0-t3*t4*t6*in_x4*in_x6*in_x7*in_x9*in_x11*in_x15*in_x19*in_x23*2.0+t3*t4*t6*in_x4*in_x6*in_x7*in_x9*in_x11*in_x15*in_x20*in_x22*2.0+t3*t4*t6*in_x4*in_x6*in_x7*in_x9*in_x12*in_x14*in_x19*in_x23*2.0-t3*t4*t6*in_x4*in_x6*in_x7*in_x9*in_x12*in_x14*in_x20*in_x22*2.0-t3*t4*t6*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x24*2.0+t3*t4*t6*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x23*2.0+t3*t4*t6*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x24*2.0-t3*t4*t6*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x23*2.0+t3*t4*t6*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x23*2.0-t3*t4*t6*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x22*2.0-t3*t4*t6*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x23*2.0+t3*t4*t6*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x22*2.0+t3*t9*t10*in_x2*in_x3*in_x4*in_x9*in_x10*in_x14*in_x20*in_x24*2.0-t3*t9*t10*in_x2*in_x3*in_x4*in_x9*in_x10*in_x14*in_x21*in_x23*2.0-t3*t9*t10*in_x2*in_x3*in_x4*in_x9*in_x11*in_x13*in_x20*in_x24*2.0+t3*t9*t10*in_x2*in_x3*in_x4*in_x9*in_x11*in_x13*in_x21*in_x23*2.0-t3*t9*t10*in_x2*in_x3*in_x4*in_x9*in_x11*in_x15*in_x19*in_x23*2.0+t3*t9*t10*in_x2*in_x3*in_x4*in_x9*in_x11*in_x15*in_x20*in_x22*2.0+t3*t9*t10*in_x2*in_x3*in_x4*in_x9*in_x12*in_x14*in_x19*in_x23*2.0-t3*t9*t10*in_x2*in_x3*in_x4*in_x9*in_x12*in_x14*in_x20*in_x22*2.0-t3*t9*t10*in_x2*in_x3*in_x5*in_x8*in_x10*in_x14*in_x20*in_x24*2.0+t3*t9*t10*in_x2*in_x3*in_x5*in_x8*in_x10*in_x14*in_x21*in_x23*2.0+t3*t9*t10*in_x2*in_x3*in_x5*in_x8*in_x11*in_x13*in_x20*in_x24*2.0-t3*t9*t10*in_x2*in_x3*in_x5*in_x8*in_x11*in_x13*in_x21*in_x23*2.0+t3*t9*t10*in_x2*in_x3*in_x5*in_x8*in_x11*in_x15*in_x19*in_x23*2.0-t3*t9*t10*in_x2*in_x3*in_x5*in_x8*in_x11*in_x15*in_x20*in_x22*2.0-t3*t9*t10*in_x2*in_x3*in_x5*in_x8*in_x12*in_x14*in_x19*in_x23*2.0+t3*t9*t10*in_x2*in_x3*in_x5*in_x8*in_x12*in_x14*in_x20*in_x22*2.0+t3*t7*t9*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x24+t3*t7*t9*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x21*in_x23-t3*t7*t9*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x24-t3*t7*t9*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x21*in_x23+t3*t7*t9*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x19*in_x23+t3*t7*t9*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x20*in_x22-t3*t7*t9*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x19*in_x23-t3*t7*t9*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x20*in_x22-t2*t11*t12*in_x2*in_x4*in_x5*in_x7*in_x10*in_x14*in_x20*in_x24*2.0+t2*t11*t12*in_x2*in_x4*in_x5*in_x7*in_x10*in_x14*in_x21*in_x23*2.0+t2*t11*t12*in_x2*in_x4*in_x5*in_x7*in_x11*in_x13*in_x20*in_x24*2.0-t2*t11*t12*in_x2*in_x4*in_x5*in_x7*in_x11*in_x13*in_x21*in_x23*2.0+t2*t11*t12*in_x2*in_x4*in_x5*in_x7*in_x11*in_x15*in_x19*in_x23*2.0-t2*t11*t12*in_x2*in_x4*in_x5*in_x7*in_x11*in_x15*in_x20*in_x22*2.0-t2*t11*t12*in_x2*in_x4*in_x5*in_x7*in_x12*in_x14*in_x19*in_x23*2.0+t2*t11*t12*in_x2*in_x4*in_x5*in_x7*in_x12*in_x14*in_x20*in_x22*2.0+t2*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x10*in_x14*in_x20*in_x24*2.0-t2*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x10*in_x14*in_x21*in_x23*2.0-t2*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x11*in_x13*in_x20*in_x24*2.0+t2*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x11*in_x13*in_x21*in_x23*2.0-t2*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x11*in_x15*in_x19*in_x23*2.0+t2*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x11*in_x15*in_x20*in_x22*2.0+t2*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x12*in_x14*in_x19*in_x23*2.0-t2*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x12*in_x14*in_x20*in_x22*2.0+t3*t4*t6*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24+t3*t4*t6*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23-t3*t4*t6*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24-t3*t4*t6*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23+t3*t4*t6*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23+t3*t4*t6*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22-t3*t4*t6*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23-t3*t4*t6*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22+t2*t8*t12*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24-t2*t8*t12*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23+t2*t8*t12*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24-t2*t8*t12*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23+t2*t8*t12*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23-t2*t8*t12*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22+t2*t8*t12*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23-t2*t8*t12*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22+t3*t9*t10*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24+t3*t9*t10*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23-t3*t9*t10*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24-t3*t9*t10*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23+t3*t9*t10*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23+t3*t9*t10*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22-t3*t9*t10*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23-t3*t9*t10*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22+t2*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x20*in_x24-t2*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x21*in_x23+t2*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x20*in_x24-t2*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x21*in_x23+t2*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x19*in_x23-t2*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x20*in_x22+t2*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x19*in_x23-t2*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x20*in_x22-t3*t7*t9*in_x4*in_x6*in_x7*in_x9*in_x10*in_x14*in_x20*in_x24*2.0+t3*t7*t9*in_x4*in_x6*in_x7*in_x9*in_x10*in_x14*in_x21*in_x23*2.0+t3*t7*t9*in_x4*in_x6*in_x7*in_x9*in_x11*in_x13*in_x20*in_x24*2.0-t3*t7*t9*in_x4*in_x6*in_x7*in_x9*in_x11*in_x13*in_x21*in_x23*2.0+t3*t7*t9*in_x4*in_x6*in_x7*in_x9*in_x11*in_x15*in_x19*in_x23*2.0-t3*t7*t9*in_x4*in_x6*in_x7*in_x9*in_x11*in_x15*in_x20*in_x22*2.0-t3*t7*t9*in_x4*in_x6*in_x7*in_x9*in_x12*in_x14*in_x19*in_x23*2.0+t3*t7*t9*in_x4*in_x6*in_x7*in_x9*in_x12*in_x14*in_x20*in_x22*2.0+t3*t7*t9*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x24*2.0-t3*t7*t9*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x23*2.0-t3*t7*t9*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x24*2.0+t3*t7*t9*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x23*2.0-t3*t7*t9*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x23*2.0+t3*t7*t9*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x22*2.0+t3*t7*t9*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x23*2.0-t3*t7*t9*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x22*2.0+t2*t11*t12*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x24-t2*t11*t12*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x21*in_x23+t2*t11*t12*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x24-t2*t11*t12*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x21*in_x23+t2*t11*t12*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x19*in_x23-t2*t11*t12*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x20*in_x22+t2*t11*t12*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x19*in_x23-t2*t11*t12*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x20*in_x22+t2*t8*t12*in_x2*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24*2.0-t2*t8*t12*in_x2*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23*2.0-t2*t8*t12*in_x2*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24*2.0+t2*t8*t12*in_x2*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23*2.0-t2*t8*t12*in_x2*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23*2.0+t2*t8*t12*in_x2*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22*2.0+t2*t8*t12*in_x2*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23*2.0-t2*t8*t12*in_x2*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22*2.0-t2*t8*t12*in_x3*in_x6*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24*2.0+t2*t8*t12*in_x3*in_x6*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23*2.0+t2*t8*t12*in_x3*in_x6*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24*2.0-t2*t8*t12*in_x3*in_x6*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23*2.0+t2*t8*t12*in_x3*in_x6*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23*2.0-t2*t8*t12*in_x3*in_x6*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22*2.0-t2*t8*t12*in_x3*in_x6*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23*2.0+t2*t8*t12*in_x3*in_x6*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22*2.0+t2*t14*t15*in_x2*in_x4*in_x5*in_x7*in_x10*in_x14*in_x20*in_x24*2.0-t2*t14*t15*in_x2*in_x4*in_x5*in_x7*in_x10*in_x14*in_x21*in_x23*2.0-t2*t14*t15*in_x2*in_x4*in_x5*in_x7*in_x11*in_x13*in_x20*in_x24*2.0+t2*t14*t15*in_x2*in_x4*in_x5*in_x7*in_x11*in_x13*in_x21*in_x23*2.0-t2*t14*t15*in_x2*in_x4*in_x5*in_x7*in_x11*in_x15*in_x19*in_x23*2.0+t2*t14*t15*in_x2*in_x4*in_x5*in_x7*in_x11*in_x15*in_x20*in_x22*2.0+t2*t14*t15*in_x2*in_x4*in_x5*in_x7*in_x12*in_x14*in_x19*in_x23*2.0-t2*t14*t15*in_x2*in_x4*in_x5*in_x7*in_x12*in_x14*in_x20*in_x22*2.0-t2*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x10*in_x14*in_x20*in_x24*2.0+t2*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x10*in_x14*in_x21*in_x23*2.0+t2*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x11*in_x13*in_x20*in_x24*2.0-t2*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x11*in_x13*in_x21*in_x23*2.0+t2*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x11*in_x15*in_x19*in_x23*2.0-t2*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x11*in_x15*in_x20*in_x22*2.0-t2*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x12*in_x14*in_x19*in_x23*2.0+t2*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x12*in_x14*in_x20*in_x22*2.0-t3*t7*t9*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24-t3*t7*t9*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23+t3*t7*t9*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24+t3*t7*t9*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23-t3*t7*t9*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23-t3*t7*t9*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22+t3*t7*t9*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23+t3*t7*t9*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22-t2*t13*t14*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24+t2*t13*t14*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23-t2*t13*t14*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24+t2*t13*t14*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23-t2*t13*t14*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23+t2*t13*t14*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22-t2*t13*t14*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23+t2*t13*t14*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22-t5*t6*t12*in_x2*in_x4*in_x5*in_x8*in_x10*in_x17*in_x23*in_x27*2.0+t5*t6*t12*in_x2*in_x4*in_x5*in_x8*in_x10*in_x17*in_x24*in_x26*2.0+t5*t6*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x16*in_x23*in_x27*2.0-t5*t6*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x16*in_x24*in_x26*2.0+t5*t6*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x18*in_x22*in_x26*2.0-t5*t6*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x18*in_x23*in_x25*2.0-t5*t6*t12*in_x2*in_x4*in_x5*in_x8*in_x12*in_x17*in_x22*in_x26*2.0+t5*t6*t12*in_x2*in_x4*in_x5*in_x8*in_x12*in_x17*in_x23*in_x25*2.0-t5*t6*t14*in_x2*in_x4*in_x5*in_x9*in_x10*in_x17*in_x20*in_x27*2.0+t5*t6*t14*in_x2*in_x4*in_x5*in_x9*in_x10*in_x17*in_x21*in_x26*2.0+t5*t6*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x16*in_x20*in_x27*2.0-t5*t6*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x16*in_x21*in_x26*2.0+t5*t6*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x18*in_x19*in_x26*2.0-t5*t6*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x18*in_x20*in_x25*2.0-t5*t6*t14*in_x2*in_x4*in_x5*in_x9*in_x12*in_x17*in_x19*in_x26*2.0+t5*t6*t14*in_x2*in_x4*in_x5*in_x9*in_x12*in_x17*in_x20*in_x25*2.0-t2*t8*t12*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24+t2*t8*t12*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23-t2*t8*t12*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24+t2*t8*t12*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23-t2*t8*t12*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23+t2*t8*t12*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22-t2*t8*t12*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23+t2*t8*t12*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22-t2*t14*t15*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x24+t2*t14*t15*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x21*in_x23-t2*t14*t15*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x24+t2*t14*t15*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x21*in_x23-t2*t14*t15*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x19*in_x23+t2*t14*t15*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x20*in_x22-t2*t14*t15*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x19*in_x23+t2*t14*t15*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x20*in_x22-t6*t11*t12*in_x2*in_x3*in_x4*in_x6*in_x13*in_x17*in_x20*in_x27*2.0+t6*t11*t12*in_x2*in_x3*in_x4*in_x6*in_x13*in_x17*in_x21*in_x26*2.0+t6*t11*t12*in_x2*in_x3*in_x4*in_x6*in_x14*in_x16*in_x20*in_x27*2.0-t6*t11*t12*in_x2*in_x3*in_x4*in_x6*in_x14*in_x16*in_x21*in_x26*2.0+t6*t11*t12*in_x2*in_x3*in_x4*in_x6*in_x14*in_x18*in_x19*in_x26*2.0-t6*t11*t12*in_x2*in_x3*in_x4*in_x6*in_x14*in_x18*in_x20*in_x25*2.0-t6*t11*t12*in_x2*in_x3*in_x4*in_x6*in_x15*in_x17*in_x19*in_x26*2.0+t6*t11*t12*in_x2*in_x3*in_x4*in_x6*in_x15*in_x17*in_x20*in_x25*2.0+t4*t6*t12*in_x4*in_x5*in_x6*in_x8*in_x10*in_x17*in_x23*in_x27*2.0-t4*t6*t12*in_x4*in_x5*in_x6*in_x8*in_x10*in_x17*in_x24*in_x26*2.0-t4*t6*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x16*in_x23*in_x27*2.0+t4*t6*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x16*in_x24*in_x26*2.0-t4*t6*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x18*in_x22*in_x26*2.0+t4*t6*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x18*in_x23*in_x25*2.0+t4*t6*t12*in_x4*in_x5*in_x6*in_x8*in_x12*in_x17*in_x22*in_x26*2.0-t4*t6*t12*in_x4*in_x5*in_x6*in_x8*in_x12*in_x17*in_x23*in_x25*2.0+t4*t6*t14*in_x4*in_x5*in_x6*in_x9*in_x10*in_x17*in_x20*in_x27*2.0-t4*t6*t14*in_x4*in_x5*in_x6*in_x9*in_x10*in_x17*in_x21*in_x26*2.0-t4*t6*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x16*in_x20*in_x27*2.0+t4*t6*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x16*in_x21*in_x26*2.0-t4*t6*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x18*in_x19*in_x26*2.0+t4*t6*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x18*in_x20*in_x25*2.0+t4*t6*t14*in_x4*in_x5*in_x6*in_x9*in_x12*in_x17*in_x19*in_x26*2.0-t4*t6*t14*in_x4*in_x5*in_x6*in_x9*in_x12*in_x17*in_x20*in_x25*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x13*in_x17*in_x20*in_x27*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x13*in_x17*in_x21*in_x26*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x14*in_x16*in_x20*in_x27*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x14*in_x16*in_x21*in_x26*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x14*in_x18*in_x19*in_x26*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x14*in_x18*in_x20*in_x25*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x15*in_x17*in_x19*in_x26*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x15*in_x17*in_x20*in_x25*2.0-t9*t11*t12*in_x2*in_x3*in_x4*in_x7*in_x10*in_x17*in_x20*in_x27*2.0+t9*t11*t12*in_x2*in_x3*in_x4*in_x7*in_x10*in_x17*in_x21*in_x26*2.0+t9*t11*t12*in_x2*in_x3*in_x4*in_x7*in_x11*in_x16*in_x20*in_x27*2.0-t9*t11*t12*in_x2*in_x3*in_x4*in_x7*in_x11*in_x16*in_x21*in_x26*2.0+t9*t11*t12*in_x2*in_x3*in_x4*in_x7*in_x11*in_x18*in_x19*in_x26*2.0-t9*t11*t12*in_x2*in_x3*in_x4*in_x7*in_x11*in_x18*in_x20*in_x25*2.0-t9*t11*t12*in_x2*in_x3*in_x4*in_x7*in_x12*in_x17*in_x19*in_x26*2.0+t9*t11*t12*in_x2*in_x3*in_x4*in_x7*in_x12*in_x17*in_x20*in_x25*2.0-t2*t13*t14*in_x2*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24*2.0+t2*t13*t14*in_x2*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23*2.0+t2*t13*t14*in_x2*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24*2.0-t2*t13*t14*in_x2*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23*2.0+t2*t13*t14*in_x2*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23*2.0-t2*t13*t14*in_x2*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22*2.0-t2*t13*t14*in_x2*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23*2.0+t2*t13*t14*in_x2*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22*2.0+t2*t13*t14*in_x3*in_x6*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24*2.0-t2*t13*t14*in_x3*in_x6*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23*2.0-t2*t13*t14*in_x3*in_x6*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24*2.0+t2*t13*t14*in_x3*in_x6*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23*2.0-t2*t13*t14*in_x3*in_x6*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23*2.0+t2*t13*t14*in_x3*in_x6*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22*2.0+t2*t13*t14*in_x3*in_x6*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23*2.0-t2*t13*t14*in_x3*in_x6*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22*2.0+t5*t6*t12*in_x2*in_x4*in_x8*in_x9*in_x10*in_x17*in_x23*in_x27*2.0-t5*t6*t12*in_x2*in_x4*in_x8*in_x9*in_x10*in_x17*in_x24*in_x26*2.0-t5*t6*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x16*in_x23*in_x27*2.0+t5*t6*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x16*in_x24*in_x26*2.0-t5*t6*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x18*in_x22*in_x26*2.0+t5*t6*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x18*in_x23*in_x25*2.0+t5*t6*t12*in_x2*in_x4*in_x8*in_x9*in_x12*in_x17*in_x22*in_x26*2.0-t5*t6*t12*in_x2*in_x4*in_x8*in_x9*in_x12*in_x17*in_x23*in_x25*2.0+t5*t6*t12*in_x3*in_x4*in_x5*in_x8*in_x13*in_x17*in_x23*in_x27*2.0-t5*t6*t12*in_x3*in_x4*in_x5*in_x8*in_x13*in_x17*in_x24*in_x26*2.0+t5*t6*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x16*in_x23*in_x27*2.0-t5*t6*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x16*in_x24*in_x26*2.0+t5*t6*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x18*in_x22*in_x26*2.0-t5*t6*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x18*in_x23*in_x25*2.0+t5*t6*t12*in_x3*in_x4*in_x5*in_x8*in_x15*in_x17*in_x22*in_x26*2.0-t5*t6*t12*in_x3*in_x4*in_x5*in_x8*in_x15*in_x17*in_x23*in_x25*2.0+t5*t6*t14*in_x2*in_x5*in_x8*in_x9*in_x10*in_x17*in_x20*in_x27*2.0-t5*t6*t14*in_x2*in_x5*in_x8*in_x9*in_x10*in_x17*in_x21*in_x26*2.0-t5*t6*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x16*in_x20*in_x27*2.0+t5*t6*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x16*in_x21*in_x26*2.0-t5*t6*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x18*in_x19*in_x26*2.0+t5*t6*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x18*in_x20*in_x25*2.0+t5*t6*t14*in_x2*in_x5*in_x8*in_x9*in_x12*in_x17*in_x19*in_x26*2.0-t5*t6*t14*in_x2*in_x5*in_x8*in_x9*in_x12*in_x17*in_x20*in_x25*2.0+t5*t6*t14*in_x3*in_x4*in_x5*in_x9*in_x13*in_x17*in_x20*in_x27*2.0-t5*t6*t14*in_x3*in_x4*in_x5*in_x9*in_x13*in_x17*in_x21*in_x26*2.0+t5*t6*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x16*in_x20*in_x27*2.0-t5*t6*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x16*in_x21*in_x26*2.0+t5*t6*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x18*in_x19*in_x26*2.0-t5*t6*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x18*in_x20*in_x25*2.0+t5*t6*t14*in_x3*in_x4*in_x5*in_x9*in_x15*in_x17*in_x19*in_x26*2.0-t5*t6*t14*in_x3*in_x4*in_x5*in_x9*in_x15*in_x17*in_x20*in_x25*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x10*in_x17*in_x20*in_x27*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x10*in_x17*in_x21*in_x26*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x11*in_x16*in_x20*in_x27*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x11*in_x16*in_x21*in_x26*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x11*in_x18*in_x19*in_x26*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x11*in_x18*in_x20*in_x25*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x12*in_x17*in_x19*in_x26*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x12*in_x17*in_x20*in_x25*2.0-t6*t11*t12*in_x2*in_x3*in_x5*in_x6*in_x13*in_x17*in_x23*in_x27*2.0-t6*t11*t12*in_x2*in_x3*in_x5*in_x6*in_x13*in_x17*in_x24*in_x26*2.0+t6*t11*t12*in_x2*in_x3*in_x5*in_x6*in_x14*in_x16*in_x23*in_x27*2.0+t6*t11*t12*in_x2*in_x3*in_x5*in_x6*in_x14*in_x16*in_x24*in_x26*2.0-t6*t11*t12*in_x2*in_x3*in_x5*in_x6*in_x14*in_x18*in_x22*in_x26*2.0-t6*t11*t12*in_x2*in_x3*in_x5*in_x6*in_x14*in_x18*in_x23*in_x25*2.0+t6*t11*t12*in_x2*in_x3*in_x5*in_x6*in_x15*in_x17*in_x22*in_x26*2.0+t6*t11*t12*in_x2*in_x3*in_x5*in_x6*in_x15*in_x17*in_x23*in_x25*2.0+t6*t11*t12*in_x2*in_x4*in_x6*in_x7*in_x13*in_x17*in_x20*in_x27*2.0-t6*t11*t12*in_x2*in_x4*in_x6*in_x7*in_x13*in_x17*in_x21*in_x26*2.0-t6*t11*t12*in_x2*in_x4*in_x6*in_x7*in_x14*in_x16*in_x20*in_x27*2.0+t6*t11*t12*in_x2*in_x4*in_x6*in_x7*in_x14*in_x16*in_x21*in_x26*2.0-t6*t11*t12*in_x2*in_x4*in_x6*in_x7*in_x14*in_x18*in_x19*in_x26*2.0+t6*t11*t12*in_x2*in_x4*in_x6*in_x7*in_x14*in_x18*in_x20*in_x25*2.0+t6*t11*t12*in_x2*in_x4*in_x6*in_x7*in_x15*in_x17*in_x19*in_x26*2.0-t6*t11*t12*in_x2*in_x4*in_x6*in_x7*in_x15*in_x17*in_x20*in_x25*2.0-t4*t6*t12*in_x4*in_x5*in_x7*in_x8*in_x13*in_x17*in_x23*in_x27*2.0+t4*t6*t12*in_x4*in_x5*in_x7*in_x8*in_x13*in_x17*in_x24*in_x26*2.0-t4*t6*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x16*in_x23*in_x27*2.0+t4*t6*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x16*in_x24*in_x26*2.0-t4*t6*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x18*in_x22*in_x26*2.0+t4*t6*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x18*in_x23*in_x25*2.0-t4*t6*t12*in_x4*in_x5*in_x7*in_x8*in_x15*in_x17*in_x22*in_x26*2.0+t4*t6*t12*in_x4*in_x5*in_x7*in_x8*in_x15*in_x17*in_x23*in_x25*2.0-t4*t6*t12*in_x4*in_x6*in_x8*in_x9*in_x10*in_x17*in_x23*in_x27*2.0+t4*t6*t12*in_x4*in_x6*in_x8*in_x9*in_x10*in_x17*in_x24*in_x26*2.0+t4*t6*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x16*in_x23*in_x27*2.0-t4*t6*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x16*in_x24*in_x26*2.0+t4*t6*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x18*in_x22*in_x26*2.0-t4*t6*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x18*in_x23*in_x25*2.0-t4*t6*t12*in_x4*in_x6*in_x8*in_x9*in_x12*in_x17*in_x22*in_x26*2.0+t4*t6*t12*in_x4*in_x6*in_x8*in_x9*in_x12*in_x17*in_x23*in_x25*2.0-t4*t6*t14*in_x4*in_x5*in_x7*in_x9*in_x13*in_x17*in_x20*in_x27*2.0+t4*t6*t14*in_x4*in_x5*in_x7*in_x9*in_x13*in_x17*in_x21*in_x26*2.0-t4*t6*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x16*in_x20*in_x27*2.0+t4*t6*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x16*in_x21*in_x26*2.0-t4*t6*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x18*in_x19*in_x26*2.0+t4*t6*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x18*in_x20*in_x25*2.0-t4*t6*t14*in_x4*in_x5*in_x7*in_x9*in_x15*in_x17*in_x19*in_x26*2.0+t4*t6*t14*in_x4*in_x5*in_x7*in_x9*in_x15*in_x17*in_x20*in_x25*2.0-t4*t6*t14*in_x5*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x27*2.0+t4*t6*t14*in_x5*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x26*2.0+t4*t6*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x27*2.0-t4*t6*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x26*2.0+t4*t6*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x26*2.0-t4*t6*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x25*2.0-t4*t6*t14*in_x5*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x26*2.0+t4*t6*t14*in_x5*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x25*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x9*in_x13*in_x17*in_x23*in_x27*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x9*in_x13*in_x17*in_x24*in_x26*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x9*in_x14*in_x16*in_x23*in_x27*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x9*in_x14*in_x16*in_x24*in_x26*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x9*in_x14*in_x18*in_x22*in_x26*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x9*in_x14*in_x18*in_x23*in_x25*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x9*in_x15*in_x17*in_x22*in_x26*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x9*in_x15*in_x17*in_x23*in_x25*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25*2.0-t9*t11*t12*in_x2*in_x3*in_x5*in_x7*in_x10*in_x17*in_x23*in_x27*2.0-t9*t11*t12*in_x2*in_x3*in_x5*in_x7*in_x10*in_x17*in_x24*in_x26*2.0+t9*t11*t12*in_x2*in_x3*in_x5*in_x7*in_x11*in_x16*in_x23*in_x27*2.0+t9*t11*t12*in_x2*in_x3*in_x5*in_x7*in_x11*in_x16*in_x24*in_x26*2.0-t9*t11*t12*in_x2*in_x3*in_x5*in_x7*in_x11*in_x18*in_x22*in_x26*2.0-t9*t11*t12*in_x2*in_x3*in_x5*in_x7*in_x11*in_x18*in_x23*in_x25*2.0+t9*t11*t12*in_x2*in_x3*in_x5*in_x7*in_x12*in_x17*in_x22*in_x26*2.0+t9*t11*t12*in_x2*in_x3*in_x5*in_x7*in_x12*in_x17*in_x23*in_x25*2.0+t9*t11*t12*in_x3*in_x4*in_x6*in_x7*in_x10*in_x17*in_x20*in_x27*2.0-t9*t11*t12*in_x3*in_x4*in_x6*in_x7*in_x10*in_x17*in_x21*in_x26*2.0-t9*t11*t12*in_x3*in_x4*in_x6*in_x7*in_x11*in_x16*in_x20*in_x27*2.0+t9*t11*t12*in_x3*in_x4*in_x6*in_x7*in_x11*in_x16*in_x21*in_x26*2.0-t9*t11*t12*in_x3*in_x4*in_x6*in_x7*in_x11*in_x18*in_x19*in_x26*2.0+t9*t11*t12*in_x3*in_x4*in_x6*in_x7*in_x11*in_x18*in_x20*in_x25*2.0+t9*t11*t12*in_x3*in_x4*in_x6*in_x7*in_x12*in_x17*in_x19*in_x26*2.0-t9*t11*t12*in_x3*in_x4*in_x6*in_x7*in_x12*in_x17*in_x20*in_x25*2.0+t2*t13*t14*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x24-t2*t13*t14*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x23+t2*t13*t14*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x24-t2*t13*t14*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x23+t2*t13*t14*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x23-t2*t13*t14*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x22+t2*t13*t14*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x23-t2*t13*t14*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x22-t5*t6*t12*in_x3*in_x4*in_x8*in_x9*in_x13*in_x17*in_x23*in_x27*2.0+t5*t6*t12*in_x3*in_x4*in_x8*in_x9*in_x13*in_x17*in_x24*in_x26*2.0-t5*t6*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x16*in_x23*in_x27*2.0+t5*t6*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x16*in_x24*in_x26*2.0-t5*t6*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x18*in_x22*in_x26*2.0+t5*t6*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x18*in_x23*in_x25*2.0-t5*t6*t12*in_x3*in_x4*in_x8*in_x9*in_x15*in_x17*in_x22*in_x26*2.0+t5*t6*t12*in_x3*in_x4*in_x8*in_x9*in_x15*in_x17*in_x23*in_x25*2.0-t5*t6*t14*in_x3*in_x5*in_x8*in_x9*in_x13*in_x17*in_x20*in_x27*2.0+t5*t6*t14*in_x3*in_x5*in_x8*in_x9*in_x13*in_x17*in_x21*in_x26*2.0-t5*t6*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x16*in_x20*in_x27*2.0+t5*t6*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x16*in_x21*in_x26*2.0-t5*t6*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x18*in_x19*in_x26*2.0+t5*t6*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x18*in_x20*in_x25*2.0-t5*t6*t14*in_x3*in_x5*in_x8*in_x9*in_x15*in_x17*in_x19*in_x26*2.0+t5*t6*t14*in_x3*in_x5*in_x8*in_x9*in_x15*in_x17*in_x20*in_x25*2.0-t6*t14*t15*in_x2*in_x3*in_x4*in_x6*in_x13*in_x17*in_x20*in_x27*2.0-t6*t14*t15*in_x2*in_x3*in_x4*in_x6*in_x13*in_x17*in_x21*in_x26*2.0+t6*t14*t15*in_x2*in_x3*in_x4*in_x6*in_x14*in_x16*in_x20*in_x27*2.0+t6*t14*t15*in_x2*in_x3*in_x4*in_x6*in_x14*in_x16*in_x21*in_x26*2.0-t6*t14*t15*in_x2*in_x3*in_x4*in_x6*in_x14*in_x18*in_x19*in_x26*2.0-t6*t14*t15*in_x2*in_x3*in_x4*in_x6*in_x14*in_x18*in_x20*in_x25*2.0+t6*t14*t15*in_x2*in_x3*in_x4*in_x6*in_x15*in_x17*in_x19*in_x26*2.0+t6*t14*t15*in_x2*in_x3*in_x4*in_x6*in_x15*in_x17*in_x20*in_x25*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x9*in_x10*in_x17*in_x23*in_x27*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x9*in_x10*in_x17*in_x24*in_x26*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x9*in_x11*in_x16*in_x23*in_x27*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x9*in_x11*in_x16*in_x24*in_x26*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x9*in_x11*in_x18*in_x22*in_x26*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x9*in_x11*in_x18*in_x23*in_x25*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x9*in_x12*in_x17*in_x22*in_x26*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x9*in_x12*in_x17*in_x23*in_x25*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x10*in_x17*in_x20*in_x27*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x10*in_x17*in_x21*in_x26*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x11*in_x16*in_x20*in_x27*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x11*in_x16*in_x21*in_x26*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x11*in_x18*in_x19*in_x26*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x11*in_x18*in_x20*in_x25*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x12*in_x17*in_x19*in_x26*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x12*in_x17*in_x20*in_x25*2.0+t9*t10*t12*in_x2*in_x4*in_x5*in_x8*in_x10*in_x17*in_x23*in_x27*2.0-t9*t10*t12*in_x2*in_x4*in_x5*in_x8*in_x10*in_x17*in_x24*in_x26*2.0+t9*t10*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x16*in_x23*in_x27*2.0-t9*t10*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x16*in_x24*in_x26*2.0+t9*t10*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x18*in_x22*in_x26*2.0-t9*t10*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x18*in_x23*in_x25*2.0+t9*t10*t12*in_x2*in_x4*in_x5*in_x8*in_x12*in_x17*in_x22*in_x26*2.0-t9*t10*t12*in_x2*in_x4*in_x5*in_x8*in_x12*in_x17*in_x23*in_x25*2.0+t9*t10*t14*in_x2*in_x4*in_x5*in_x9*in_x10*in_x17*in_x20*in_x27*2.0-t9*t10*t14*in_x2*in_x4*in_x5*in_x9*in_x10*in_x17*in_x21*in_x26*2.0+t9*t10*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x16*in_x20*in_x27*2.0-t9*t10*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x16*in_x21*in_x26*2.0+t9*t10*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x18*in_x19*in_x26*2.0-t9*t10*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x18*in_x20*in_x25*2.0+t9*t10*t14*in_x2*in_x4*in_x5*in_x9*in_x12*in_x17*in_x19*in_x26*2.0-t9*t10*t14*in_x2*in_x4*in_x5*in_x9*in_x12*in_x17*in_x20*in_x25*2.0-t7*t9*t12*in_x4*in_x5*in_x6*in_x8*in_x10*in_x17*in_x23*in_x27*2.0+t7*t9*t12*in_x4*in_x5*in_x6*in_x8*in_x10*in_x17*in_x24*in_x26*2.0-t7*t9*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x16*in_x23*in_x27*2.0+t7*t9*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x16*in_x24*in_x26*2.0-t7*t9*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x18*in_x22*in_x26*2.0+t7*t9*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x18*in_x23*in_x25*2.0-t7*t9*t12*in_x4*in_x5*in_x6*in_x8*in_x12*in_x17*in_x22*in_x26*2.0+t7*t9*t12*in_x4*in_x5*in_x6*in_x8*in_x12*in_x17*in_x23*in_x25*2.0-t7*t9*t14*in_x4*in_x5*in_x6*in_x9*in_x10*in_x17*in_x20*in_x27*2.0+t7*t9*t14*in_x4*in_x5*in_x6*in_x9*in_x10*in_x17*in_x21*in_x26*2.0-t7*t9*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x16*in_x20*in_x27*2.0+t7*t9*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x16*in_x21*in_x26*2.0-t7*t9*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x18*in_x19*in_x26*2.0+t7*t9*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x18*in_x20*in_x25*2.0-t7*t9*t14*in_x4*in_x5*in_x6*in_x9*in_x12*in_x17*in_x19*in_x26*2.0+t7*t9*t14*in_x4*in_x5*in_x6*in_x9*in_x12*in_x17*in_x20*in_x25*2.0-t9*t14*t15*in_x2*in_x3*in_x4*in_x7*in_x10*in_x17*in_x20*in_x27*2.0-t9*t14*t15*in_x2*in_x3*in_x4*in_x7*in_x10*in_x17*in_x21*in_x26*2.0+t9*t14*t15*in_x2*in_x3*in_x4*in_x7*in_x11*in_x16*in_x20*in_x27*2.0+t9*t14*t15*in_x2*in_x3*in_x4*in_x7*in_x11*in_x16*in_x21*in_x26*2.0-t9*t14*t15*in_x2*in_x3*in_x4*in_x7*in_x11*in_x18*in_x19*in_x26*2.0-t9*t14*t15*in_x2*in_x3*in_x4*in_x7*in_x11*in_x18*in_x20*in_x25*2.0+t9*t14*t15*in_x2*in_x3*in_x4*in_x7*in_x12*in_x17*in_x19*in_x26*2.0+t9*t14*t15*in_x2*in_x3*in_x4*in_x7*in_x12*in_x17*in_x20*in_x25*2.0+t6*t11*t12*in_x2*in_x5*in_x6*in_x7*in_x13*in_x17*in_x23*in_x27*2.0+t6*t11*t12*in_x2*in_x5*in_x6*in_x7*in_x13*in_x17*in_x24*in_x26*2.0-t6*t11*t12*in_x2*in_x5*in_x6*in_x7*in_x14*in_x16*in_x23*in_x27*2.0-t6*t11*t12*in_x2*in_x5*in_x6*in_x7*in_x14*in_x16*in_x24*in_x26*2.0+t6*t11*t12*in_x2*in_x5*in_x6*in_x7*in_x14*in_x18*in_x22*in_x26*2.0+t6*t11*t12*in_x2*in_x5*in_x6*in_x7*in_x14*in_x18*in_x23*in_x25*2.0-t6*t11*t12*in_x2*in_x5*in_x6*in_x7*in_x15*in_x17*in_x22*in_x26*2.0-t6*t11*t12*in_x2*in_x5*in_x6*in_x7*in_x15*in_x17*in_x23*in_x25*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x13*in_x17*in_x20*in_x27*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x13*in_x17*in_x21*in_x26*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x14*in_x16*in_x20*in_x27*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x14*in_x16*in_x21*in_x26*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x14*in_x18*in_x19*in_x26*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x14*in_x18*in_x20*in_x25*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x15*in_x17*in_x19*in_x26*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x15*in_x17*in_x20*in_x25*2.0+t4*t6*t12*in_x4*in_x7*in_x8*in_x9*in_x13*in_x17*in_x23*in_x27*2.0-t4*t6*t12*in_x4*in_x7*in_x8*in_x9*in_x13*in_x17*in_x24*in_x26*2.0+t4*t6*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x16*in_x23*in_x27*2.0-t4*t6*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x16*in_x24*in_x26*2.0+t4*t6*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x18*in_x22*in_x26*2.0-t4*t6*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x18*in_x23*in_x25*2.0+t4*t6*t12*in_x4*in_x7*in_x8*in_x9*in_x15*in_x17*in_x22*in_x26*2.0-t4*t6*t12*in_x4*in_x7*in_x8*in_x9*in_x15*in_x17*in_x23*in_x25*2.0+t4*t6*t14*in_x5*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x27*2.0-t4*t6*t14*in_x5*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x26*2.0+t4*t6*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x27*2.0-t4*t6*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x26*2.0+t4*t6*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x26*2.0-t4*t6*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x25*2.0+t4*t6*t14*in_x5*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x26*2.0-t4*t6*t14*in_x5*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x25*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25*2.0+t9*t11*t12*in_x3*in_x5*in_x6*in_x7*in_x10*in_x17*in_x23*in_x27*2.0+t9*t11*t12*in_x3*in_x5*in_x6*in_x7*in_x10*in_x17*in_x24*in_x26*2.0-t9*t11*t12*in_x3*in_x5*in_x6*in_x7*in_x11*in_x16*in_x23*in_x27*2.0-t9*t11*t12*in_x3*in_x5*in_x6*in_x7*in_x11*in_x16*in_x24*in_x26*2.0+t9*t11*t12*in_x3*in_x5*in_x6*in_x7*in_x11*in_x18*in_x22*in_x26*2.0+t9*t11*t12*in_x3*in_x5*in_x6*in_x7*in_x11*in_x18*in_x23*in_x25*2.0-t9*t11*t12*in_x3*in_x5*in_x6*in_x7*in_x12*in_x17*in_x22*in_x26*2.0-t9*t11*t12*in_x3*in_x5*in_x6*in_x7*in_x12*in_x17*in_x23*in_x25*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x10*in_x17*in_x20*in_x27*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x10*in_x17*in_x21*in_x26*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x11*in_x16*in_x20*in_x27*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x11*in_x16*in_x21*in_x26*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x11*in_x18*in_x19*in_x26*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x11*in_x18*in_x20*in_x25*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x12*in_x17*in_x19*in_x26*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x12*in_x17*in_x20*in_x25*2.0-t6*t14*t15*in_x2*in_x3*in_x5*in_x6*in_x13*in_x17*in_x23*in_x27*2.0+t6*t14*t15*in_x2*in_x3*in_x5*in_x6*in_x13*in_x17*in_x24*in_x26*2.0+t6*t14*t15*in_x2*in_x3*in_x5*in_x6*in_x14*in_x16*in_x23*in_x27*2.0-t6*t14*t15*in_x2*in_x3*in_x5*in_x6*in_x14*in_x16*in_x24*in_x26*2.0+t6*t14*t15*in_x2*in_x3*in_x5*in_x6*in_x14*in_x18*in_x22*in_x26*2.0-t6*t14*t15*in_x2*in_x3*in_x5*in_x6*in_x14*in_x18*in_x23*in_x25*2.0-t6*t14*t15*in_x2*in_x3*in_x5*in_x6*in_x15*in_x17*in_x22*in_x26*2.0+t6*t14*t15*in_x2*in_x3*in_x5*in_x6*in_x15*in_x17*in_x23*in_x25*2.0+t6*t14*t15*in_x2*in_x4*in_x6*in_x7*in_x13*in_x17*in_x20*in_x27*2.0+t6*t14*t15*in_x2*in_x4*in_x6*in_x7*in_x13*in_x17*in_x21*in_x26*2.0-t6*t14*t15*in_x2*in_x4*in_x6*in_x7*in_x14*in_x16*in_x20*in_x27*2.0-t6*t14*t15*in_x2*in_x4*in_x6*in_x7*in_x14*in_x16*in_x21*in_x26*2.0+t6*t14*t15*in_x2*in_x4*in_x6*in_x7*in_x14*in_x18*in_x19*in_x26*2.0+t6*t14*t15*in_x2*in_x4*in_x6*in_x7*in_x14*in_x18*in_x20*in_x25*2.0-t6*t14*t15*in_x2*in_x4*in_x6*in_x7*in_x15*in_x17*in_x19*in_x26*2.0-t6*t14*t15*in_x2*in_x4*in_x6*in_x7*in_x15*in_x17*in_x20*in_x25*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x9*in_x10*in_x17*in_x23*in_x27*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x9*in_x10*in_x17*in_x24*in_x26*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x9*in_x11*in_x16*in_x23*in_x27*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x9*in_x11*in_x16*in_x24*in_x26*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x9*in_x11*in_x18*in_x22*in_x26*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x9*in_x11*in_x18*in_x23*in_x25*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x9*in_x12*in_x17*in_x22*in_x26*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x9*in_x12*in_x17*in_x23*in_x25*2.0-t9*t10*t12*in_x2*in_x4*in_x8*in_x9*in_x10*in_x17*in_x23*in_x27*2.0+t9*t10*t12*in_x2*in_x4*in_x8*in_x9*in_x10*in_x17*in_x24*in_x26*2.0-t9*t10*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x16*in_x23*in_x27*2.0+t9*t10*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x16*in_x24*in_x26*2.0-t9*t10*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x18*in_x22*in_x26*2.0+t9*t10*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x18*in_x23*in_x25*2.0-t9*t10*t12*in_x2*in_x4*in_x8*in_x9*in_x12*in_x17*in_x22*in_x26*2.0+t9*t10*t12*in_x2*in_x4*in_x8*in_x9*in_x12*in_x17*in_x23*in_x25*2.0-t9*t10*t12*in_x3*in_x4*in_x5*in_x8*in_x13*in_x17*in_x23*in_x27*2.0+t9*t10*t12*in_x3*in_x4*in_x5*in_x8*in_x13*in_x17*in_x24*in_x26*2.0+t9*t10*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x16*in_x23*in_x27*2.0-t9*t10*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x16*in_x24*in_x26*2.0+t9*t10*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x18*in_x22*in_x26*2.0-t9*t10*t12*in_x3*in_x4*in_x5*in_x8*in_x14*in_x18*in_x23*in_x25*2.0-t9*t10*t12*in_x3*in_x4*in_x5*in_x8*in_x15*in_x17*in_x22*in_x26*2.0+t9*t10*t12*in_x3*in_x4*in_x5*in_x8*in_x15*in_x17*in_x23*in_x25*2.0-t9*t10*t14*in_x2*in_x5*in_x8*in_x9*in_x10*in_x17*in_x20*in_x27*2.0+t9*t10*t14*in_x2*in_x5*in_x8*in_x9*in_x10*in_x17*in_x21*in_x26*2.0-t9*t10*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x16*in_x20*in_x27*2.0+t9*t10*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x16*in_x21*in_x26*2.0-t9*t10*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x18*in_x19*in_x26*2.0+t9*t10*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x18*in_x20*in_x25*2.0-t9*t10*t14*in_x2*in_x5*in_x8*in_x9*in_x12*in_x17*in_x19*in_x26*2.0+t9*t10*t14*in_x2*in_x5*in_x8*in_x9*in_x12*in_x17*in_x20*in_x25*2.0-t9*t10*t14*in_x3*in_x4*in_x5*in_x9*in_x13*in_x17*in_x20*in_x27*2.0+t9*t10*t14*in_x3*in_x4*in_x5*in_x9*in_x13*in_x17*in_x21*in_x26*2.0+t9*t10*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x16*in_x20*in_x27*2.0-t9*t10*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x16*in_x21*in_x26*2.0+t9*t10*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x18*in_x19*in_x26*2.0-t9*t10*t14*in_x3*in_x4*in_x5*in_x9*in_x14*in_x18*in_x20*in_x25*2.0-t9*t10*t14*in_x3*in_x4*in_x5*in_x9*in_x15*in_x17*in_x19*in_x26*2.0+t9*t10*t14*in_x3*in_x4*in_x5*in_x9*in_x15*in_x17*in_x20*in_x25*2.0+t7*t9*t12*in_x4*in_x5*in_x7*in_x8*in_x13*in_x17*in_x23*in_x27*2.0-t7*t9*t12*in_x4*in_x5*in_x7*in_x8*in_x13*in_x17*in_x24*in_x26*2.0-t7*t9*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x16*in_x23*in_x27*2.0+t7*t9*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x16*in_x24*in_x26*2.0-t7*t9*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x18*in_x22*in_x26*2.0+t7*t9*t12*in_x4*in_x5*in_x7*in_x8*in_x14*in_x18*in_x23*in_x25*2.0+t7*t9*t12*in_x4*in_x5*in_x7*in_x8*in_x15*in_x17*in_x22*in_x26*2.0-t7*t9*t12*in_x4*in_x5*in_x7*in_x8*in_x15*in_x17*in_x23*in_x25*2.0+t7*t9*t12*in_x4*in_x6*in_x8*in_x9*in_x10*in_x17*in_x23*in_x27*2.0-t7*t9*t12*in_x4*in_x6*in_x8*in_x9*in_x10*in_x17*in_x24*in_x26*2.0+t7*t9*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x16*in_x23*in_x27*2.0-t7*t9*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x16*in_x24*in_x26*2.0+t7*t9*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x18*in_x22*in_x26*2.0-t7*t9*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x18*in_x23*in_x25*2.0+t7*t9*t12*in_x4*in_x6*in_x8*in_x9*in_x12*in_x17*in_x22*in_x26*2.0-t7*t9*t12*in_x4*in_x6*in_x8*in_x9*in_x12*in_x17*in_x23*in_x25*2.0+t7*t9*t14*in_x4*in_x5*in_x7*in_x9*in_x13*in_x17*in_x20*in_x27*2.0-t7*t9*t14*in_x4*in_x5*in_x7*in_x9*in_x13*in_x17*in_x21*in_x26*2.0-t7*t9*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x16*in_x20*in_x27*2.0+t7*t9*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x16*in_x21*in_x26*2.0-t7*t9*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x18*in_x19*in_x26*2.0+t7*t9*t14*in_x4*in_x5*in_x7*in_x9*in_x14*in_x18*in_x20*in_x25*2.0+t7*t9*t14*in_x4*in_x5*in_x7*in_x9*in_x15*in_x17*in_x19*in_x26*2.0-t7*t9*t14*in_x4*in_x5*in_x7*in_x9*in_x15*in_x17*in_x20*in_x25*2.0+t7*t9*t14*in_x5*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x27*2.0-t7*t9*t14*in_x5*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x26*2.0+t7*t9*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x27*2.0-t7*t9*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x26*2.0+t7*t9*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x26*2.0-t7*t9*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x25*2.0+t7*t9*t14*in_x5*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x26*2.0-t7*t9*t14*in_x5*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x25*2.0-t9*t14*t15*in_x2*in_x3*in_x5*in_x7*in_x10*in_x17*in_x23*in_x27*2.0+t9*t14*t15*in_x2*in_x3*in_x5*in_x7*in_x10*in_x17*in_x24*in_x26*2.0+t9*t14*t15*in_x2*in_x3*in_x5*in_x7*in_x11*in_x16*in_x23*in_x27*2.0-t9*t14*t15*in_x2*in_x3*in_x5*in_x7*in_x11*in_x16*in_x24*in_x26*2.0+t9*t14*t15*in_x2*in_x3*in_x5*in_x7*in_x11*in_x18*in_x22*in_x26*2.0-t9*t14*t15*in_x2*in_x3*in_x5*in_x7*in_x11*in_x18*in_x23*in_x25*2.0-t9*t14*t15*in_x2*in_x3*in_x5*in_x7*in_x12*in_x17*in_x22*in_x26*2.0+t9*t14*t15*in_x2*in_x3*in_x5*in_x7*in_x12*in_x17*in_x23*in_x25*2.0+t9*t14*t15*in_x3*in_x4*in_x6*in_x7*in_x10*in_x17*in_x20*in_x27*2.0+t9*t14*t15*in_x3*in_x4*in_x6*in_x7*in_x10*in_x17*in_x21*in_x26*2.0-t9*t14*t15*in_x3*in_x4*in_x6*in_x7*in_x11*in_x16*in_x20*in_x27*2.0-t9*t14*t15*in_x3*in_x4*in_x6*in_x7*in_x11*in_x16*in_x21*in_x26*2.0+t9*t14*t15*in_x3*in_x4*in_x6*in_x7*in_x11*in_x18*in_x19*in_x26*2.0+t9*t14*t15*in_x3*in_x4*in_x6*in_x7*in_x11*in_x18*in_x20*in_x25*2.0-t9*t14*t15*in_x3*in_x4*in_x6*in_x7*in_x12*in_x17*in_x19*in_x26*2.0-t9*t14*t15*in_x3*in_x4*in_x6*in_x7*in_x12*in_x17*in_x20*in_x25*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x9*in_x13*in_x17*in_x23*in_x27*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x9*in_x13*in_x17*in_x24*in_x26*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x9*in_x14*in_x16*in_x23*in_x27*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x9*in_x14*in_x16*in_x24*in_x26*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x9*in_x14*in_x18*in_x22*in_x26*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x9*in_x14*in_x18*in_x23*in_x25*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x9*in_x15*in_x17*in_x22*in_x26*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x9*in_x15*in_x17*in_x23*in_x25*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x13*in_x17*in_x20*in_x27*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x13*in_x17*in_x21*in_x26*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x14*in_x16*in_x20*in_x27*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x14*in_x16*in_x21*in_x26*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x14*in_x18*in_x19*in_x26*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x14*in_x18*in_x20*in_x25*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x15*in_x17*in_x19*in_x26*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x15*in_x17*in_x20*in_x25*2.0+t5*t11*t12*in_x3*in_x4*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0-t5*t11*t12*in_x3*in_x4*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0+t5*t11*t12*in_x3*in_x4*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0-t5*t11*t12*in_x3*in_x4*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x9*in_x10*in_x17*in_x23*in_x27*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x9*in_x10*in_x17*in_x24*in_x26*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x9*in_x11*in_x16*in_x23*in_x27*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x9*in_x11*in_x16*in_x24*in_x26*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x9*in_x11*in_x18*in_x22*in_x26*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x9*in_x11*in_x18*in_x23*in_x25*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x9*in_x12*in_x17*in_x22*in_x26*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x9*in_x12*in_x17*in_x23*in_x25*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x10*in_x17*in_x20*in_x27*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x10*in_x17*in_x21*in_x26*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x11*in_x16*in_x20*in_x27*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x11*in_x16*in_x21*in_x26*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x11*in_x18*in_x19*in_x26*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x11*in_x18*in_x20*in_x25*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x12*in_x17*in_x19*in_x26*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x12*in_x17*in_x20*in_x25*2.0-t5*t8*t12*in_x3*in_x8*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0+t5*t8*t12*in_x3*in_x8*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0-t5*t8*t12*in_x3*in_x8*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0+t5*t8*t12*in_x3*in_x8*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0+t6*t14*t15*in_x2*in_x5*in_x6*in_x7*in_x13*in_x17*in_x23*in_x27*2.0-t6*t14*t15*in_x2*in_x5*in_x6*in_x7*in_x13*in_x17*in_x24*in_x26*2.0-t6*t14*t15*in_x2*in_x5*in_x6*in_x7*in_x14*in_x16*in_x23*in_x27*2.0+t6*t14*t15*in_x2*in_x5*in_x6*in_x7*in_x14*in_x16*in_x24*in_x26*2.0-t6*t14*t15*in_x2*in_x5*in_x6*in_x7*in_x14*in_x18*in_x22*in_x26*2.0+t6*t14*t15*in_x2*in_x5*in_x6*in_x7*in_x14*in_x18*in_x23*in_x25*2.0+t6*t14*t15*in_x2*in_x5*in_x6*in_x7*in_x15*in_x17*in_x22*in_x26*2.0-t6*t14*t15*in_x2*in_x5*in_x6*in_x7*in_x15*in_x17*in_x23*in_x25*2.0+t9*t10*t12*in_x3*in_x4*in_x8*in_x9*in_x13*in_x17*in_x23*in_x27*2.0-t9*t10*t12*in_x3*in_x4*in_x8*in_x9*in_x13*in_x17*in_x24*in_x26*2.0-t9*t10*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x16*in_x23*in_x27*2.0+t9*t10*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x16*in_x24*in_x26*2.0-t9*t10*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x18*in_x22*in_x26*2.0+t9*t10*t12*in_x3*in_x4*in_x8*in_x9*in_x14*in_x18*in_x23*in_x25*2.0+t9*t10*t12*in_x3*in_x4*in_x8*in_x9*in_x15*in_x17*in_x22*in_x26*2.0-t9*t10*t12*in_x3*in_x4*in_x8*in_x9*in_x15*in_x17*in_x23*in_x25*2.0+t9*t10*t14*in_x3*in_x5*in_x8*in_x9*in_x13*in_x17*in_x20*in_x27*2.0-t9*t10*t14*in_x3*in_x5*in_x8*in_x9*in_x13*in_x17*in_x21*in_x26*2.0-t9*t10*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x16*in_x20*in_x27*2.0+t9*t10*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x16*in_x21*in_x26*2.0-t9*t10*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x18*in_x19*in_x26*2.0+t9*t10*t14*in_x3*in_x5*in_x8*in_x9*in_x14*in_x18*in_x20*in_x25*2.0+t9*t10*t14*in_x3*in_x5*in_x8*in_x9*in_x15*in_x17*in_x19*in_x26*2.0-t9*t10*t14*in_x3*in_x5*in_x8*in_x9*in_x15*in_x17*in_x20*in_x25*2.0-t7*t9*t12*in_x4*in_x7*in_x8*in_x9*in_x13*in_x17*in_x23*in_x27*2.0+t7*t9*t12*in_x4*in_x7*in_x8*in_x9*in_x13*in_x17*in_x24*in_x26*2.0+t7*t9*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x16*in_x23*in_x27*2.0-t7*t9*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x16*in_x24*in_x26*2.0+t7*t9*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x18*in_x22*in_x26*2.0-t7*t9*t12*in_x4*in_x7*in_x8*in_x9*in_x14*in_x18*in_x23*in_x25*2.0-t7*t9*t12*in_x4*in_x7*in_x8*in_x9*in_x15*in_x17*in_x22*in_x26*2.0+t7*t9*t12*in_x4*in_x7*in_x8*in_x9*in_x15*in_x17*in_x23*in_x25*2.0-t7*t9*t14*in_x5*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x27*2.0+t7*t9*t14*in_x5*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x26*2.0+t7*t9*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x27*2.0-t7*t9*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x26*2.0+t7*t9*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x26*2.0-t7*t9*t14*in_x5*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x25*2.0-t7*t9*t14*in_x5*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x26*2.0+t7*t9*t14*in_x5*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x25*2.0+t9*t14*t15*in_x3*in_x5*in_x6*in_x7*in_x10*in_x17*in_x23*in_x27*2.0-t9*t14*t15*in_x3*in_x5*in_x6*in_x7*in_x10*in_x17*in_x24*in_x26*2.0-t9*t14*t15*in_x3*in_x5*in_x6*in_x7*in_x11*in_x16*in_x23*in_x27*2.0+t9*t14*t15*in_x3*in_x5*in_x6*in_x7*in_x11*in_x16*in_x24*in_x26*2.0-t9*t14*t15*in_x3*in_x5*in_x6*in_x7*in_x11*in_x18*in_x22*in_x26*2.0+t9*t14*t15*in_x3*in_x5*in_x6*in_x7*in_x11*in_x18*in_x23*in_x25*2.0+t9*t14*t15*in_x3*in_x5*in_x6*in_x7*in_x12*in_x17*in_x22*in_x26*2.0-t9*t14*t15*in_x3*in_x5*in_x6*in_x7*in_x12*in_x17*in_x23*in_x25*2.0-t4*t11*t12*in_x4*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0+t4*t11*t12*in_x4*in_x7*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0-t4*t11*t12*in_x4*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0+t4*t11*t12*in_x4*in_x7*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x9*in_x13*in_x17*in_x23*in_x27*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x9*in_x13*in_x17*in_x24*in_x26*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x9*in_x14*in_x16*in_x23*in_x27*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x9*in_x14*in_x16*in_x24*in_x26*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x9*in_x14*in_x18*in_x22*in_x26*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x9*in_x14*in_x18*in_x23*in_x25*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x9*in_x15*in_x17*in_x22*in_x26*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x9*in_x15*in_x17*in_x23*in_x25*2.0+t4*t8*t12*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0-t4*t8*t12*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0+t4*t8*t12*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0-t4*t8*t12*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0+t5*t11*t12*in_x3*in_x5*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0+t5*t11*t12*in_x3*in_x5*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0-t5*t11*t12*in_x3*in_x5*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0-t5*t11*t12*in_x3*in_x5*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x9*in_x10*in_x17*in_x23*in_x27*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x9*in_x10*in_x17*in_x24*in_x26*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x9*in_x11*in_x16*in_x23*in_x27*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x9*in_x11*in_x16*in_x24*in_x26*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x9*in_x11*in_x18*in_x22*in_x26*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x9*in_x11*in_x18*in_x23*in_x25*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x9*in_x12*in_x17*in_x22*in_x26*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x9*in_x12*in_x17*in_x23*in_x25*2.0-t5*t8*t12*in_x3*in_x9*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0-t5*t8*t12*in_x3*in_x9*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0+t5*t8*t12*in_x3*in_x9*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0+t5*t8*t12*in_x3*in_x9*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0+t5*t14*t15*in_x3*in_x4*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0+t5*t14*t15*in_x3*in_x4*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0-t5*t14*t15*in_x3*in_x4*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0-t5*t14*t15*in_x3*in_x4*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0-t4*t11*t12*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0-t4*t11*t12*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0+t4*t11*t12*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0+t4*t11*t12*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0+t8*t14*t15*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*2.0-t8*t14*t15*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*2.0+t10*t11*t12*in_x2*in_x4*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0-t10*t11*t12*in_x2*in_x4*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0+t10*t11*t12*in_x2*in_x4*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0-t10*t11*t12*in_x2*in_x4*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0+t4*t8*t12*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0+t4*t8*t12*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0-t4*t8*t12*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0-t4*t8*t12*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0-t5*t13*t14*in_x3*in_x8*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0-t5*t13*t14*in_x3*in_x8*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0+t5*t13*t14*in_x3*in_x8*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0+t5*t13*t14*in_x3*in_x8*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0-t7*t11*t12*in_x4*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0+t7*t11*t12*in_x4*in_x6*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0-t7*t11*t12*in_x4*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0+t7*t11*t12*in_x4*in_x6*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0-t8*t10*t12*in_x2*in_x8*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0+t8*t10*t12*in_x2*in_x8*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0-t8*t10*t12*in_x2*in_x8*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0+t8*t10*t12*in_x2*in_x8*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0-t11*t13*t14*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*2.0+t11*t13*t14*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*2.0-t4*t14*t15*in_x4*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0-t4*t14*t15*in_x4*in_x7*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0+t4*t14*t15*in_x4*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0+t4*t14*t15*in_x4*in_x7*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0+t7*t8*t12*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0-t7*t8*t12*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0+t7*t8*t12*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0-t7*t8*t12*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0+t5*t14*t15*in_x3*in_x5*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0-t5*t14*t15*in_x3*in_x5*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0+t5*t14*t15*in_x3*in_x5*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0-t5*t14*t15*in_x3*in_x5*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0+t4*t13*t14*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*2.0+t4*t13*t14*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*2.0-t4*t13*t14*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*2.0-t4*t13*t14*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*2.0-t8*t12*t15*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x23*in_x24*2.0+t8*t12*t15*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x22*in_x23*2.0+t10*t11*t12*in_x2*in_x5*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0+t10*t11*t12*in_x2*in_x5*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0-t10*t11*t12*in_x2*in_x5*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0-t10*t11*t12*in_x2*in_x5*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0-t5*t6*t11*in_x2*in_x5*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t5*t6*t11*in_x2*in_x5*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t5*t6*t11*in_x2*in_x5*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t11*in_x2*in_x5*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0-t5*t13*t14*in_x3*in_x9*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0+t5*t13*t14*in_x3*in_x9*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0-t5*t13*t14*in_x3*in_x9*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0+t5*t13*t14*in_x3*in_x9*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0-t7*t11*t12*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0-t7*t11*t12*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0+t7*t11*t12*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0+t7*t11*t12*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0-t8*t10*t12*in_x2*in_x9*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0-t8*t10*t12*in_x2*in_x9*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0+t8*t10*t12*in_x2*in_x9*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0+t8*t10*t12*in_x2*in_x9*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0+t11*t12*t13*in_x2*in_x3*in_x11*in_x14*in_x16*in_x17*in_x23*in_x24*2.0-t11*t12*t13*in_x2*in_x3*in_x11*in_x14*in_x17*in_x18*in_x22*in_x23*2.0-t4*t14*t15*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0+t4*t14*t15*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0-t4*t14*t15*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0+t4*t14*t15*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0+t5*t6*t8*in_x2*in_x9*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t5*t6*t8*in_x2*in_x9*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t5*t6*t8*in_x2*in_x9*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t5*t6*t8*in_x2*in_x9*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0-t5*t7*t9*in_x4*in_x5*in_x10*in_x11*in_x20*in_x23*in_x26*in_x27*2.0+t5*t7*t9*in_x4*in_x5*in_x11*in_x12*in_x20*in_x23*in_x25*in_x26*2.0+t7*t8*t12*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0+t7*t8*t12*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0-t7*t8*t12*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0-t7*t8*t12*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0+t10*t14*t15*in_x2*in_x4*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0+t10*t14*t15*in_x2*in_x4*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0-t10*t14*t15*in_x2*in_x4*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0-t10*t14*t15*in_x2*in_x4*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0-t7*t14*t15*in_x4*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0-t7*t14*t15*in_x4*in_x6*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0+t7*t14*t15*in_x4*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0+t7*t14*t15*in_x4*in_x6*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0+t4*t6*t11*in_x5*in_x6*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t4*t6*t11*in_x5*in_x6*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t4*t6*t11*in_x5*in_x6*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t4*t6*t11*in_x5*in_x6*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t4*t9*t10*in_x4*in_x5*in_x10*in_x11*in_x20*in_x23*in_x26*in_x27*2.0-t4*t9*t10*in_x4*in_x5*in_x11*in_x12*in_x20*in_x23*in_x25*in_x26*2.0+t4*t13*t14*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*2.0-t4*t13*t14*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*2.0+t4*t13*t14*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*2.0-t4*t13*t14*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*2.0-t8*t14*t15*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*2.0+t8*t14*t15*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*2.0-t10*t13*t14*in_x2*in_x8*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0-t10*t13*t14*in_x2*in_x8*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0+t10*t13*t14*in_x2*in_x8*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0+t10*t13*t14*in_x2*in_x8*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0-t4*t6*t8*in_x6*in_x9*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t4*t6*t8*in_x6*in_x9*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t4*t6*t8*in_x6*in_x9*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t4*t6*t8*in_x6*in_x9*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t7*in_x4*in_x5*in_x13*in_x14*in_x20*in_x23*in_x26*in_x27*2.0-t5*t6*t7*in_x4*in_x5*in_x14*in_x15*in_x20*in_x23*in_x25*in_x26*2.0+t5*t6*t11*in_x3*in_x5*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t5*t6*t11*in_x3*in_x5*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t5*t6*t11*in_x3*in_x5*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t5*t6*t11*in_x3*in_x5*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t7*t13*t14*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*2.0+t7*t13*t14*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*2.0-t7*t13*t14*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*2.0-t7*t13*t14*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*2.0+t11*t13*t14*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x21*2.0-t11*t13*t14*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x20*2.0-t5*t6*t8*in_x3*in_x9*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t5*t6*t8*in_x3*in_x9*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t5*t6*t8*in_x3*in_x9*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t8*in_x3*in_x9*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t10*t14*t15*in_x2*in_x5*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0-t10*t14*t15*in_x2*in_x5*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0+t10*t14*t15*in_x2*in_x5*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0-t10*t14*t15*in_x2*in_x5*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0-t4*t6*t10*in_x4*in_x5*in_x13*in_x14*in_x20*in_x23*in_x26*in_x27*2.0+t4*t6*t10*in_x4*in_x5*in_x14*in_x15*in_x20*in_x23*in_x25*in_x26*2.0-t5*t6*t15*in_x2*in_x4*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t5*t6*t15*in_x2*in_x4*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t5*t6*t15*in_x2*in_x4*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t5*t6*t15*in_x2*in_x4*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t7*t14*t15*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0+t7*t14*t15*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0-t7*t14*t15*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0+t7*t14*t15*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0-t4*t6*t11*in_x5*in_x7*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t4*t6*t11*in_x5*in_x7*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t4*t6*t11*in_x5*in_x7*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t4*t6*t11*in_x5*in_x7*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t8*t12*t15*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x23*in_x24*2.0-t8*t12*t15*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x22*in_x23*2.0-t10*t13*t14*in_x2*in_x9*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0+t10*t13*t14*in_x2*in_x9*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0-t10*t13*t14*in_x2*in_x9*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0+t10*t13*t14*in_x2*in_x9*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0+t4*t6*t8*in_x7*in_x9*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t4*t6*t8*in_x7*in_x9*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t4*t6*t8*in_x7*in_x9*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t4*t6*t8*in_x7*in_x9*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t13*in_x2*in_x8*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t5*t6*t13*in_x2*in_x8*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t5*t6*t13*in_x2*in_x8*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t5*t6*t13*in_x2*in_x8*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t7*t13*t14*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*2.0-t7*t13*t14*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*2.0+t7*t13*t14*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*2.0-t7*t13*t14*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*2.0+t9*t10*t11*in_x2*in_x5*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t9*t10*t11*in_x2*in_x5*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t9*t10*t11*in_x2*in_x5*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t9*t10*t11*in_x2*in_x5*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0-t11*t12*t13*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x23*in_x24*2.0+t11*t12*t13*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x22*in_x23*2.0+t4*t6*t15*in_x4*in_x6*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t4*t6*t15*in_x4*in_x6*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t4*t6*t15*in_x4*in_x6*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t4*t6*t15*in_x4*in_x6*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t5*t7*t9*in_x8*in_x9*in_x10*in_x11*in_x20*in_x23*in_x26*in_x27*2.0-t5*t7*t9*in_x8*in_x9*in_x11*in_x12*in_x20*in_x23*in_x25*in_x26*2.0-t7*t9*t11*in_x5*in_x6*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t7*t9*t11*in_x5*in_x6*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t7*t9*t11*in_x5*in_x6*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t7*t9*t11*in_x5*in_x6*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0-t8*t9*t10*in_x2*in_x9*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t8*t9*t10*in_x2*in_x9*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t8*t9*t10*in_x2*in_x9*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t8*t9*t10*in_x2*in_x9*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t15*in_x3*in_x4*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t5*t6*t15*in_x3*in_x4*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t5*t6*t15*in_x3*in_x4*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t5*t6*t15*in_x3*in_x4*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t7*t8*t9*in_x6*in_x9*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t7*t8*t9*in_x6*in_x9*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t7*t8*t9*in_x6*in_x9*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t7*t8*t9*in_x6*in_x9*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*2.0-t4*t6*t13*in_x6*in_x8*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t4*t6*t13*in_x6*in_x8*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t4*t6*t13*in_x6*in_x8*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t4*t6*t13*in_x6*in_x8*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t4*t9*t10*in_x8*in_x9*in_x10*in_x11*in_x20*in_x23*in_x26*in_x27*2.0+t4*t9*t10*in_x8*in_x9*in_x11*in_x12*in_x20*in_x23*in_x25*in_x26*2.0-t5*t6*t7*in_x8*in_x9*in_x13*in_x14*in_x20*in_x23*in_x26*in_x27*2.0+t5*t6*t7*in_x8*in_x9*in_x14*in_x15*in_x20*in_x23*in_x25*in_x26*2.0-t5*t6*t13*in_x3*in_x8*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t5*t6*t13*in_x3*in_x8*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t5*t6*t13*in_x3*in_x8*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t5*t6*t13*in_x3*in_x8*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t9*t10*t11*in_x3*in_x5*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t9*t10*t11*in_x3*in_x5*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t9*t10*t11*in_x3*in_x5*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t9*t10*t11*in_x3*in_x5*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0-t4*t6*t15*in_x4*in_x7*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t4*t6*t15*in_x4*in_x7*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t4*t6*t15*in_x4*in_x7*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t4*t6*t15*in_x4*in_x7*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t7*t9*t11*in_x5*in_x7*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t7*t9*t11*in_x5*in_x7*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t7*t9*t11*in_x5*in_x7*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t7*t9*t11*in_x5*in_x7*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t8*t9*t10*in_x3*in_x9*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0-t8*t9*t10*in_x3*in_x9*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0+t8*t9*t10*in_x3*in_x9*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0-t8*t9*t10*in_x3*in_x9*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t4*t6*t10*in_x8*in_x9*in_x13*in_x14*in_x20*in_x23*in_x26*in_x27*2.0-t4*t6*t10*in_x8*in_x9*in_x14*in_x15*in_x20*in_x23*in_x25*in_x26*2.0-t7*t8*t9*in_x7*in_x9*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*2.0+t7*t8*t9*in_x7*in_x9*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*2.0-t7*t8*t9*in_x7*in_x9*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*2.0+t7*t8*t9*in_x7*in_x9*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*2.0+t9*t10*t15*in_x2*in_x4*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t9*t10*t15*in_x2*in_x4*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t9*t10*t15*in_x2*in_x4*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t9*t10*t15*in_x2*in_x4*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t4*t6*t13*in_x7*in_x8*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t4*t6*t13*in_x7*in_x8*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t4*t6*t13*in_x7*in_x8*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t4*t6*t13*in_x7*in_x8*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t7*t9*t15*in_x4*in_x6*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t7*t9*t15*in_x4*in_x6*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t7*t9*t15*in_x4*in_x6*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t7*t9*t15*in_x4*in_x6*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t9*t10*t13*in_x2*in_x8*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t9*t10*t13*in_x2*in_x8*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t9*t10*t13*in_x2*in_x8*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t9*t10*t13*in_x2*in_x8*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t7*t9*t13*in_x6*in_x8*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t7*t9*t13*in_x6*in_x8*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t7*t9*t13*in_x6*in_x8*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t7*t9*t13*in_x6*in_x8*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t9*t10*t15*in_x3*in_x4*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t9*t10*t15*in_x3*in_x4*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t9*t10*t15*in_x3*in_x4*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t9*t10*t15*in_x3*in_x4*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t7*t9*t15*in_x4*in_x7*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t7*t9*t15*in_x4*in_x7*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t7*t9*t15*in_x4*in_x7*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t7*t9*t15*in_x4*in_x7*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t9*t10*t13*in_x3*in_x8*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0-t9*t10*t13*in_x3*in_x8*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0+t9*t10*t13*in_x3*in_x8*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0-t9*t10*t13*in_x3*in_x8*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0-t7*t9*t13*in_x7*in_x8*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*2.0+t7*t9*t13*in_x7*in_x8*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*2.0-t7*t9*t13*in_x7*in_x8*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*2.0+t7*t9*t13*in_x7*in_x8*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*2.0+t6*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x8*in_x13*in_x17*in_x23*in_x27*4.0-t6*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x8*in_x13*in_x17*in_x24*in_x26*4.0-t6*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x8*in_x14*in_x16*in_x23*in_x27*4.0+t6*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x8*in_x14*in_x16*in_x24*in_x26*4.0-t6*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x8*in_x14*in_x18*in_x22*in_x26*4.0+t6*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x8*in_x14*in_x18*in_x23*in_x25*4.0+t6*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x8*in_x15*in_x17*in_x22*in_x26*4.0-t6*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x8*in_x15*in_x17*in_x23*in_x25*4.0+t6*t14*in_x2*in_x3*in_x4*in_x5*in_x6*in_x9*in_x13*in_x17*in_x20*in_x27*4.0-t6*t14*in_x2*in_x3*in_x4*in_x5*in_x6*in_x9*in_x13*in_x17*in_x21*in_x26*4.0-t6*t14*in_x2*in_x3*in_x4*in_x5*in_x6*in_x9*in_x14*in_x16*in_x20*in_x27*4.0+t6*t14*in_x2*in_x3*in_x4*in_x5*in_x6*in_x9*in_x14*in_x16*in_x21*in_x26*4.0-t6*t14*in_x2*in_x3*in_x4*in_x5*in_x6*in_x9*in_x14*in_x18*in_x19*in_x26*4.0+t6*t14*in_x2*in_x3*in_x4*in_x5*in_x6*in_x9*in_x14*in_x18*in_x20*in_x25*4.0+t6*t14*in_x2*in_x3*in_x4*in_x5*in_x6*in_x9*in_x15*in_x17*in_x19*in_x26*4.0-t6*t14*in_x2*in_x3*in_x4*in_x5*in_x6*in_x9*in_x15*in_x17*in_x20*in_x25*4.0+t9*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x8*in_x10*in_x17*in_x23*in_x27*4.0-t9*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x8*in_x10*in_x17*in_x24*in_x26*4.0-t9*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x8*in_x11*in_x16*in_x23*in_x27*4.0+t9*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x8*in_x11*in_x16*in_x24*in_x26*4.0-t9*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x8*in_x11*in_x18*in_x22*in_x26*4.0+t9*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x8*in_x11*in_x18*in_x23*in_x25*4.0+t9*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x8*in_x12*in_x17*in_x22*in_x26*4.0-t9*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x8*in_x12*in_x17*in_x23*in_x25*4.0+t9*t14*in_x2*in_x3*in_x4*in_x5*in_x7*in_x9*in_x10*in_x17*in_x20*in_x27*4.0-t9*t14*in_x2*in_x3*in_x4*in_x5*in_x7*in_x9*in_x10*in_x17*in_x21*in_x26*4.0-t9*t14*in_x2*in_x3*in_x4*in_x5*in_x7*in_x9*in_x11*in_x16*in_x20*in_x27*4.0+t9*t14*in_x2*in_x3*in_x4*in_x5*in_x7*in_x9*in_x11*in_x16*in_x21*in_x26*4.0-t9*t14*in_x2*in_x3*in_x4*in_x5*in_x7*in_x9*in_x11*in_x18*in_x19*in_x26*4.0+t9*t14*in_x2*in_x3*in_x4*in_x5*in_x7*in_x9*in_x11*in_x18*in_x20*in_x25*4.0+t9*t14*in_x2*in_x3*in_x4*in_x5*in_x7*in_x9*in_x12*in_x17*in_x19*in_x26*4.0-t9*t14*in_x2*in_x3*in_x4*in_x5*in_x7*in_x9*in_x12*in_x17*in_x20*in_x25*4.0-t6*t12*in_x2*in_x3*in_x4*in_x6*in_x8*in_x9*in_x13*in_x17*in_x23*in_x27*4.0+t6*t12*in_x2*in_x3*in_x4*in_x6*in_x8*in_x9*in_x13*in_x17*in_x24*in_x26*4.0+t6*t12*in_x2*in_x3*in_x4*in_x6*in_x8*in_x9*in_x14*in_x16*in_x23*in_x27*4.0-t6*t12*in_x2*in_x3*in_x4*in_x6*in_x8*in_x9*in_x14*in_x16*in_x24*in_x26*4.0+t6*t12*in_x2*in_x3*in_x4*in_x6*in_x8*in_x9*in_x14*in_x18*in_x22*in_x26*4.0-t6*t12*in_x2*in_x3*in_x4*in_x6*in_x8*in_x9*in_x14*in_x18*in_x23*in_x25*4.0-t6*t12*in_x2*in_x3*in_x4*in_x6*in_x8*in_x9*in_x15*in_x17*in_x22*in_x26*4.0+t6*t12*in_x2*in_x3*in_x4*in_x6*in_x8*in_x9*in_x15*in_x17*in_x23*in_x25*4.0-t6*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x8*in_x13*in_x17*in_x23*in_x27*4.0+t6*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x8*in_x13*in_x17*in_x24*in_x26*4.0+t6*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x8*in_x14*in_x16*in_x23*in_x27*4.0-t6*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x8*in_x14*in_x16*in_x24*in_x26*4.0+t6*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x8*in_x14*in_x18*in_x22*in_x26*4.0-t6*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x8*in_x14*in_x18*in_x23*in_x25*4.0-t6*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x8*in_x15*in_x17*in_x22*in_x26*4.0+t6*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x8*in_x15*in_x17*in_x23*in_x25*4.0-t6*t14*in_x2*in_x3*in_x5*in_x6*in_x8*in_x9*in_x13*in_x17*in_x20*in_x27*4.0+t6*t14*in_x2*in_x3*in_x5*in_x6*in_x8*in_x9*in_x13*in_x17*in_x21*in_x26*4.0+t6*t14*in_x2*in_x3*in_x5*in_x6*in_x8*in_x9*in_x14*in_x16*in_x20*in_x27*4.0-t6*t14*in_x2*in_x3*in_x5*in_x6*in_x8*in_x9*in_x14*in_x16*in_x21*in_x26*4.0+t6*t14*in_x2*in_x3*in_x5*in_x6*in_x8*in_x9*in_x14*in_x18*in_x19*in_x26*4.0-t6*t14*in_x2*in_x3*in_x5*in_x6*in_x8*in_x9*in_x14*in_x18*in_x20*in_x25*4.0-t6*t14*in_x2*in_x3*in_x5*in_x6*in_x8*in_x9*in_x15*in_x17*in_x19*in_x26*4.0+t6*t14*in_x2*in_x3*in_x5*in_x6*in_x8*in_x9*in_x15*in_x17*in_x20*in_x25*4.0-t6*t14*in_x2*in_x4*in_x5*in_x6*in_x7*in_x9*in_x13*in_x17*in_x20*in_x27*4.0+t6*t14*in_x2*in_x4*in_x5*in_x6*in_x7*in_x9*in_x13*in_x17*in_x21*in_x26*4.0+t6*t14*in_x2*in_x4*in_x5*in_x6*in_x7*in_x9*in_x14*in_x16*in_x20*in_x27*4.0-t6*t14*in_x2*in_x4*in_x5*in_x6*in_x7*in_x9*in_x14*in_x16*in_x21*in_x26*4.0+t6*t14*in_x2*in_x4*in_x5*in_x6*in_x7*in_x9*in_x14*in_x18*in_x19*in_x26*4.0-t6*t14*in_x2*in_x4*in_x5*in_x6*in_x7*in_x9*in_x14*in_x18*in_x20*in_x25*4.0-t6*t14*in_x2*in_x4*in_x5*in_x6*in_x7*in_x9*in_x15*in_x17*in_x19*in_x26*4.0+t6*t14*in_x2*in_x4*in_x5*in_x6*in_x7*in_x9*in_x15*in_x17*in_x20*in_x25*4.0-t9*t12*in_x2*in_x3*in_x4*in_x7*in_x8*in_x9*in_x10*in_x17*in_x23*in_x27*4.0+t9*t12*in_x2*in_x3*in_x4*in_x7*in_x8*in_x9*in_x10*in_x17*in_x24*in_x26*4.0+t9*t12*in_x2*in_x3*in_x4*in_x7*in_x8*in_x9*in_x11*in_x16*in_x23*in_x27*4.0-t9*t12*in_x2*in_x3*in_x4*in_x7*in_x8*in_x9*in_x11*in_x16*in_x24*in_x26*4.0+t9*t12*in_x2*in_x3*in_x4*in_x7*in_x8*in_x9*in_x11*in_x18*in_x22*in_x26*4.0-t9*t12*in_x2*in_x3*in_x4*in_x7*in_x8*in_x9*in_x11*in_x18*in_x23*in_x25*4.0-t9*t12*in_x2*in_x3*in_x4*in_x7*in_x8*in_x9*in_x12*in_x17*in_x22*in_x26*4.0+t9*t12*in_x2*in_x3*in_x4*in_x7*in_x8*in_x9*in_x12*in_x17*in_x23*in_x25*4.0-t9*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x8*in_x10*in_x17*in_x23*in_x27*4.0+t9*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x8*in_x10*in_x17*in_x24*in_x26*4.0+t9*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x16*in_x23*in_x27*4.0-t9*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x16*in_x24*in_x26*4.0+t9*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x18*in_x22*in_x26*4.0-t9*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x18*in_x23*in_x25*4.0-t9*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x8*in_x12*in_x17*in_x22*in_x26*4.0+t9*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x8*in_x12*in_x17*in_x23*in_x25*4.0-t9*t14*in_x2*in_x3*in_x5*in_x7*in_x8*in_x9*in_x10*in_x17*in_x20*in_x27*4.0+t9*t14*in_x2*in_x3*in_x5*in_x7*in_x8*in_x9*in_x10*in_x17*in_x21*in_x26*4.0+t9*t14*in_x2*in_x3*in_x5*in_x7*in_x8*in_x9*in_x11*in_x16*in_x20*in_x27*4.0-t9*t14*in_x2*in_x3*in_x5*in_x7*in_x8*in_x9*in_x11*in_x16*in_x21*in_x26*4.0+t9*t14*in_x2*in_x3*in_x5*in_x7*in_x8*in_x9*in_x11*in_x18*in_x19*in_x26*4.0-t9*t14*in_x2*in_x3*in_x5*in_x7*in_x8*in_x9*in_x11*in_x18*in_x20*in_x25*4.0-t9*t14*in_x2*in_x3*in_x5*in_x7*in_x8*in_x9*in_x12*in_x17*in_x19*in_x26*4.0+t9*t14*in_x2*in_x3*in_x5*in_x7*in_x8*in_x9*in_x12*in_x17*in_x20*in_x25*4.0-t9*t14*in_x3*in_x4*in_x5*in_x6*in_x7*in_x9*in_x10*in_x17*in_x20*in_x27*4.0+t9*t14*in_x3*in_x4*in_x5*in_x6*in_x7*in_x9*in_x10*in_x17*in_x21*in_x26*4.0+t9*t14*in_x3*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x16*in_x20*in_x27*4.0-t9*t14*in_x3*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x16*in_x21*in_x26*4.0+t9*t14*in_x3*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x18*in_x19*in_x26*4.0-t9*t14*in_x3*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x18*in_x20*in_x25*4.0-t9*t14*in_x3*in_x4*in_x5*in_x6*in_x7*in_x9*in_x12*in_x17*in_x19*in_x26*4.0+t9*t14*in_x3*in_x4*in_x5*in_x6*in_x7*in_x9*in_x12*in_x17*in_x20*in_x25*4.0+t6*t12*in_x2*in_x4*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x23*in_x27*4.0-t6*t12*in_x2*in_x4*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x24*in_x26*4.0-t6*t12*in_x2*in_x4*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x23*in_x27*4.0+t6*t12*in_x2*in_x4*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x24*in_x26*4.0-t6*t12*in_x2*in_x4*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x22*in_x26*4.0+t6*t12*in_x2*in_x4*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x23*in_x25*4.0+t6*t12*in_x2*in_x4*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x22*in_x26*4.0-t6*t12*in_x2*in_x4*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x23*in_x25*4.0+t6*t14*in_x2*in_x5*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x27*4.0-t6*t14*in_x2*in_x5*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x26*4.0-t6*t14*in_x2*in_x5*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x27*4.0+t6*t14*in_x2*in_x5*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x26*4.0-t6*t14*in_x2*in_x5*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x26*4.0+t6*t14*in_x2*in_x5*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x25*4.0+t6*t14*in_x2*in_x5*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x26*4.0-t6*t14*in_x2*in_x5*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x25*4.0+t9*t12*in_x3*in_x4*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x23*in_x27*4.0-t9*t12*in_x3*in_x4*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x24*in_x26*4.0-t9*t12*in_x3*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x23*in_x27*4.0+t9*t12*in_x3*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x24*in_x26*4.0-t9*t12*in_x3*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x22*in_x26*4.0+t9*t12*in_x3*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x23*in_x25*4.0+t9*t12*in_x3*in_x4*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x22*in_x26*4.0-t9*t12*in_x3*in_x4*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x23*in_x25*4.0+t9*t14*in_x3*in_x5*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x20*in_x27*4.0-t9*t14*in_x3*in_x5*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x21*in_x26*4.0-t9*t14*in_x3*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x20*in_x27*4.0+t9*t14*in_x3*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x21*in_x26*4.0-t9*t14*in_x3*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x19*in_x26*4.0+t9*t14*in_x3*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x20*in_x25*4.0+t9*t14*in_x3*in_x5*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x19*in_x26*4.0-t9*t14*in_x3*in_x5*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x20*in_x25*4.0-t5*t12*in_x3*in_x4*in_x5*in_x8*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*4.0+t5*t12*in_x3*in_x4*in_x5*in_x8*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*4.0-t5*t12*in_x3*in_x4*in_x5*in_x8*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*4.0+t5*t12*in_x3*in_x4*in_x5*in_x8*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*4.0-t5*t14*in_x3*in_x4*in_x5*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*4.0+t5*t14*in_x3*in_x4*in_x5*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*4.0-t5*t14*in_x3*in_x4*in_x5*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*4.0+t5*t14*in_x3*in_x4*in_x5*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*4.0+t11*t12*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0-t11*t12*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0+t11*t12*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0-t11*t12*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0+t4*t12*in_x4*in_x5*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*4.0-t4*t12*in_x4*in_x5*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*4.0+t4*t12*in_x4*in_x5*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*4.0-t4*t12*in_x4*in_x5*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*4.0+t4*t14*in_x4*in_x5*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*4.0-t4*t14*in_x4*in_x5*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*4.0+t4*t14*in_x4*in_x5*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*4.0-t4*t14*in_x4*in_x5*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*4.0+t5*t12*in_x3*in_x4*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*4.0-t5*t12*in_x3*in_x4*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*4.0+t5*t12*in_x3*in_x4*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*4.0-t5*t12*in_x3*in_x4*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*4.0+t5*t14*in_x3*in_x5*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*4.0-t5*t14*in_x3*in_x5*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*4.0+t5*t14*in_x3*in_x5*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*4.0-t5*t14*in_x3*in_x5*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*4.0-t8*t12*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0+t8*t12*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0-t8*t12*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0+t8*t12*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0-t5*t6*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0+t5*t6*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0-t5*t6*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0+t5*t6*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0-t14*t15*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0+t14*t15*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0-t14*t15*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0+t14*t15*in_x2*in_x3*in_x4*in_x5*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0-t4*t12*in_x4*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x23*in_x27*4.0+t4*t12*in_x4*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x24*in_x26*4.0-t4*t12*in_x4*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x22*in_x26*4.0+t4*t12*in_x4*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x23*in_x25*4.0-t4*t14*in_x5*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x27*4.0+t4*t14*in_x5*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x26*4.0-t4*t14*in_x5*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x26*4.0+t4*t14*in_x5*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x25*4.0-t10*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*4.0+t10*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*4.0-t10*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*4.0+t10*t12*in_x2*in_x4*in_x5*in_x8*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*4.0-t10*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*4.0+t10*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*4.0-t10*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*4.0+t10*t14*in_x2*in_x4*in_x5*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*4.0+t7*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*4.0-t7*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*4.0+t7*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*4.0-t7*t12*in_x4*in_x5*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*4.0+t7*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*4.0-t7*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*4.0+t7*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*4.0-t7*t14*in_x4*in_x5*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*4.0-t11*t12*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0+t11*t12*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0-t11*t12*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0+t11*t12*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0+t10*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*4.0-t10*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*4.0+t10*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*4.0-t10*t12*in_x2*in_x4*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*4.0+t10*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*4.0-t10*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*4.0+t10*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*4.0-t10*t14*in_x2*in_x5*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*4.0-t7*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x23*in_x27*4.0+t7*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x24*in_x26*4.0-t7*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x22*in_x26*4.0+t7*t12*in_x4*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x23*in_x25*4.0-t7*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x27*4.0+t7*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x26*4.0-t7*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x26*4.0+t7*t14*in_x5*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x25*4.0+t13*t14*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0-t13*t14*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0+t13*t14*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0-t13*t14*in_x2*in_x3*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0+t4*t6*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0-t4*t6*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0+t4*t6*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0-t4*t6*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0+t8*t12*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0-t8*t12*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0+t8*t12*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0-t8*t12*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0+t5*t6*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0-t5*t6*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0+t5*t6*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0-t5*t6*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0+t6*t11*in_x2*in_x3*in_x5*in_x6*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*4.0-t6*t11*in_x2*in_x3*in_x5*in_x6*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*4.0+t6*t11*in_x2*in_x3*in_x5*in_x6*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*4.0-t6*t11*in_x2*in_x3*in_x5*in_x6*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*4.0+t9*t10*in_x2*in_x3*in_x4*in_x5*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0-t9*t10*in_x2*in_x3*in_x4*in_x5*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0+t9*t10*in_x2*in_x3*in_x4*in_x5*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0-t9*t10*in_x2*in_x3*in_x4*in_x5*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0+t14*t15*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0-t14*t15*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0+t14*t15*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0-t14*t15*in_x4*in_x5*in_x6*in_x7*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0-t6*t8*in_x2*in_x3*in_x6*in_x9*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*4.0+t6*t8*in_x2*in_x3*in_x6*in_x9*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*4.0-t6*t8*in_x2*in_x3*in_x6*in_x9*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*4.0+t6*t8*in_x2*in_x3*in_x6*in_x9*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*4.0+t9*t11*in_x2*in_x3*in_x5*in_x7*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*4.0-t9*t11*in_x2*in_x3*in_x5*in_x7*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*4.0+t9*t11*in_x2*in_x3*in_x5*in_x7*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*4.0-t9*t11*in_x2*in_x3*in_x5*in_x7*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*4.0-t8*t9*in_x2*in_x3*in_x7*in_x9*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*4.0+t8*t9*in_x2*in_x3*in_x7*in_x9*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*4.0-t8*t9*in_x2*in_x3*in_x7*in_x9*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*4.0+t8*t9*in_x2*in_x3*in_x7*in_x9*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*4.0-t6*t11*in_x2*in_x5*in_x6*in_x7*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*4.0+t6*t11*in_x2*in_x5*in_x6*in_x7*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*4.0-t6*t11*in_x2*in_x5*in_x6*in_x7*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*4.0+t6*t11*in_x2*in_x5*in_x6*in_x7*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*4.0+t6*t8*in_x2*in_x6*in_x7*in_x9*in_x13*in_x17*in_x20*in_x21*in_x23*in_x26*4.0-t6*t8*in_x2*in_x6*in_x7*in_x9*in_x14*in_x16*in_x20*in_x21*in_x23*in_x26*4.0+t6*t8*in_x2*in_x6*in_x7*in_x9*in_x14*in_x18*in_x19*in_x20*in_x23*in_x26*4.0-t6*t8*in_x2*in_x6*in_x7*in_x9*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*4.0-t7*t9*in_x4*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0+t7*t9*in_x4*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0-t7*t9*in_x4*in_x5*in_x6*in_x7*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0+t7*t9*in_x4*in_x5*in_x6*in_x7*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0-t9*t11*in_x3*in_x5*in_x6*in_x7*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*4.0+t9*t11*in_x3*in_x5*in_x6*in_x7*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*4.0-t9*t11*in_x3*in_x5*in_x6*in_x7*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*4.0+t9*t11*in_x3*in_x5*in_x6*in_x7*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*4.0+t6*t15*in_x2*in_x3*in_x4*in_x6*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*4.0-t6*t15*in_x2*in_x3*in_x4*in_x6*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*4.0+t6*t15*in_x2*in_x3*in_x4*in_x6*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*4.0-t6*t15*in_x2*in_x3*in_x4*in_x6*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*4.0+t8*t9*in_x3*in_x6*in_x7*in_x9*in_x10*in_x17*in_x20*in_x21*in_x23*in_x26*4.0-t8*t9*in_x3*in_x6*in_x7*in_x9*in_x11*in_x16*in_x20*in_x21*in_x23*in_x26*4.0+t8*t9*in_x3*in_x6*in_x7*in_x9*in_x11*in_x18*in_x19*in_x20*in_x23*in_x26*4.0-t8*t9*in_x3*in_x6*in_x7*in_x9*in_x12*in_x17*in_x19*in_x20*in_x23*in_x26*4.0-t13*t14*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x20*in_x24*2.0+t13*t14*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x16*in_x17*in_x21*in_x23*2.0-t13*t14*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x19*in_x23*2.0+t13*t14*in_x6*in_x7*in_x8*in_x9*in_x11*in_x14*in_x17*in_x18*in_x20*in_x22*2.0-t4*t6*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0+t4*t6*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0-t4*t6*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0+t4*t6*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0+t9*t15*in_x2*in_x3*in_x4*in_x7*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*4.0-t9*t15*in_x2*in_x3*in_x4*in_x7*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*4.0+t9*t15*in_x2*in_x3*in_x4*in_x7*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*4.0-t9*t15*in_x2*in_x3*in_x4*in_x7*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*4.0-t6*t13*in_x2*in_x3*in_x6*in_x8*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*4.0+t6*t13*in_x2*in_x3*in_x6*in_x8*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*4.0-t6*t13*in_x2*in_x3*in_x6*in_x8*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*4.0+t6*t13*in_x2*in_x3*in_x6*in_x8*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*4.0-t9*t10*in_x2*in_x3*in_x8*in_x9*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0+t9*t10*in_x2*in_x3*in_x8*in_x9*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0-t9*t10*in_x2*in_x3*in_x8*in_x9*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0+t9*t10*in_x2*in_x3*in_x8*in_x9*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0-t9*t13*in_x2*in_x3*in_x7*in_x8*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*4.0+t9*t13*in_x2*in_x3*in_x7*in_x8*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*4.0-t9*t13*in_x2*in_x3*in_x7*in_x8*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*4.0+t9*t13*in_x2*in_x3*in_x7*in_x8*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*4.0-t6*t15*in_x2*in_x4*in_x6*in_x7*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*4.0+t6*t15*in_x2*in_x4*in_x6*in_x7*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*4.0-t6*t15*in_x2*in_x4*in_x6*in_x7*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*4.0+t6*t15*in_x2*in_x4*in_x6*in_x7*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*4.0-t9*t15*in_x3*in_x4*in_x6*in_x7*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*4.0+t9*t15*in_x3*in_x4*in_x6*in_x7*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*4.0-t9*t15*in_x3*in_x4*in_x6*in_x7*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*4.0+t9*t15*in_x3*in_x4*in_x6*in_x7*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*4.0+t6*t13*in_x2*in_x6*in_x7*in_x8*in_x13*in_x17*in_x20*in_x23*in_x24*in_x26*4.0-t6*t13*in_x2*in_x6*in_x7*in_x8*in_x14*in_x16*in_x20*in_x23*in_x24*in_x26*4.0+t6*t13*in_x2*in_x6*in_x7*in_x8*in_x14*in_x18*in_x20*in_x22*in_x23*in_x26*4.0-t6*t13*in_x2*in_x6*in_x7*in_x8*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*4.0-t5*t11*in_x3*in_x5*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*in_x23*in_x26*4.0+t5*t11*in_x3*in_x5*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*in_x23*in_x26*4.0+t7*t9*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x23*in_x26*in_x27*2.0-t7*t9*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x23*in_x26*in_x27*2.0+t7*t9*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x23*in_x25*in_x26*2.0-t7*t9*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x23*in_x25*in_x26*2.0+t9*t13*in_x3*in_x6*in_x7*in_x8*in_x10*in_x17*in_x20*in_x23*in_x24*in_x26*4.0-t9*t13*in_x3*in_x6*in_x7*in_x8*in_x11*in_x16*in_x20*in_x23*in_x24*in_x26*4.0+t9*t13*in_x3*in_x6*in_x7*in_x8*in_x11*in_x18*in_x20*in_x22*in_x23*in_x26*4.0-t9*t13*in_x3*in_x6*in_x7*in_x8*in_x12*in_x17*in_x20*in_x22*in_x23*in_x26*4.0+t5*t8*in_x3*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*in_x23*in_x26*4.0-t5*t8*in_x3*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*in_x23*in_x26*4.0+t4*t11*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*in_x23*in_x26*4.0-t4*t11*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*in_x23*in_x26*4.0-t4*t8*in_x7*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*in_x23*in_x26*4.0+t4*t8*in_x7*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*in_x23*in_x26*4.0-t5*t15*in_x3*in_x4*in_x10*in_x11*in_x14*in_x17*in_x20*in_x23*in_x24*in_x26*4.0+t5*t15*in_x3*in_x4*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*in_x23*in_x26*4.0-t10*t11*in_x2*in_x5*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*in_x23*in_x26*4.0+t10*t11*in_x2*in_x5*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*4.0+t5*t13*in_x3*in_x8*in_x10*in_x11*in_x14*in_x17*in_x20*in_x23*in_x24*in_x26*4.0-t5*t13*in_x3*in_x8*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*in_x23*in_x26*4.0+t7*t11*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*in_x23*in_x26*4.0-t7*t11*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*4.0+t8*t10*in_x2*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*in_x23*in_x26*4.0-t8*t10*in_x2*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*4.0+t4*t15*in_x4*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x23*in_x24*in_x26*4.0-t4*t15*in_x4*in_x7*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*in_x23*in_x26*4.0-t7*t8*in_x6*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*in_x23*in_x26*4.0+t7*t8*in_x6*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*in_x23*in_x26*4.0-t4*t13*in_x7*in_x8*in_x10*in_x11*in_x14*in_x17*in_x20*in_x23*in_x24*in_x26*4.0+t4*t13*in_x7*in_x8*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*in_x23*in_x26*4.0-t10*t15*in_x2*in_x4*in_x11*in_x13*in_x14*in_x17*in_x20*in_x23*in_x24*in_x26*4.0+t10*t15*in_x2*in_x4*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*4.0+t7*t15*in_x4*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x23*in_x24*in_x26*4.0-t7*t15*in_x4*in_x6*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*4.0+t10*t13*in_x2*in_x8*in_x11*in_x13*in_x14*in_x17*in_x20*in_x23*in_x24*in_x26*4.0-t10*t13*in_x2*in_x8*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*4.0-t7*t13*in_x6*in_x8*in_x11*in_x13*in_x14*in_x17*in_x20*in_x23*in_x24*in_x26*4.0+t7*t13*in_x6*in_x8*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*in_x23*in_x26*4.0;  // NOLINT
        coeffs[5] = t5*t7*t9*t11*t12*in_x4*in_x10*in_x11*in_x20*in_x27-t5*t7*t9*t11*t12*in_x4*in_x10*in_x11*in_x21*in_x26+t5*t7*t9*t11*t12*in_x4*in_x11*in_x12*in_x19*in_x26-t5*t7*t9*t11*t12*in_x4*in_x11*in_x12*in_x20*in_x25-t5*t7*t8*t9*t12*in_x8*in_x10*in_x11*in_x20*in_x27+t5*t7*t8*t9*t12*in_x8*in_x10*in_x11*in_x21*in_x26-t5*t7*t8*t9*t12*in_x8*in_x11*in_x12*in_x19*in_x26+t5*t7*t8*t9*t12*in_x8*in_x11*in_x12*in_x20*in_x25-t4*t9*t10*t11*t12*in_x4*in_x10*in_x11*in_x20*in_x27+t4*t9*t10*t11*t12*in_x4*in_x10*in_x11*in_x21*in_x26-t4*t9*t10*t11*t12*in_x4*in_x11*in_x12*in_x19*in_x26+t4*t9*t10*t11*t12*in_x4*in_x11*in_x12*in_x20*in_x25+t5*t6*t8*t14*t15*in_x2*in_x10*in_x17*in_x20*in_x21-t5*t6*t8*t14*t15*in_x2*in_x11*in_x16*in_x20*in_x21+t5*t6*t8*t14*t15*in_x2*in_x11*in_x18*in_x19*in_x20-t5*t6*t8*t14*t15*in_x2*in_x12*in_x17*in_x19*in_x20+t4*t8*t9*t10*t12*in_x8*in_x10*in_x11*in_x20*in_x27-t4*t8*t9*t10*t12*in_x8*in_x10*in_x11*in_x21*in_x26+t4*t8*t9*t10*t12*in_x8*in_x11*in_x12*in_x19*in_x26-t4*t8*t9*t10*t12*in_x8*in_x11*in_x12*in_x20*in_x25-t5*t6*t7*t11*t12*in_x4*in_x13*in_x14*in_x20*in_x27+t5*t6*t7*t11*t12*in_x4*in_x13*in_x14*in_x21*in_x26-t5*t6*t7*t11*t12*in_x4*in_x14*in_x15*in_x19*in_x26+t5*t6*t7*t11*t12*in_x4*in_x14*in_x15*in_x20*in_x25-t5*t6*t11*t13*t14*in_x2*in_x10*in_x17*in_x20*in_x21+t5*t6*t11*t13*t14*in_x2*in_x11*in_x16*in_x20*in_x21-t5*t6*t11*t13*t14*in_x2*in_x11*in_x18*in_x19*in_x20+t5*t6*t11*t13*t14*in_x2*in_x12*in_x17*in_x19*in_x20+t5*t6*t7*t8*t12*in_x8*in_x13*in_x14*in_x20*in_x27-t5*t6*t7*t8*t12*in_x8*in_x13*in_x14*in_x21*in_x26+t5*t6*t7*t8*t12*in_x8*in_x14*in_x15*in_x19*in_x26-t5*t6*t7*t8*t12*in_x8*in_x14*in_x15*in_x20*in_x25+t5*t7*t9*t11*t12*in_x5*in_x10*in_x11*in_x23*in_x27+t5*t7*t9*t11*t12*in_x5*in_x10*in_x11*in_x24*in_x26-t5*t7*t9*t11*t12*in_x5*in_x11*in_x12*in_x22*in_x26-t5*t7*t9*t11*t12*in_x5*in_x11*in_x12*in_x23*in_x25-t4*t6*t8*t14*t15*in_x6*in_x10*in_x17*in_x20*in_x21+t4*t6*t8*t14*t15*in_x6*in_x11*in_x16*in_x20*in_x21-t4*t6*t8*t14*t15*in_x6*in_x11*in_x18*in_x19*in_x20+t4*t6*t8*t14*t15*in_x6*in_x12*in_x17*in_x19*in_x20+t4*t6*t10*t11*t12*in_x4*in_x13*in_x14*in_x20*in_x27-t4*t6*t10*t11*t12*in_x4*in_x13*in_x14*in_x21*in_x26+t4*t6*t10*t11*t12*in_x4*in_x14*in_x15*in_x19*in_x26-t4*t6*t10*t11*t12*in_x4*in_x14*in_x15*in_x20*in_x25-t5*t7*t8*t9*t12*in_x9*in_x10*in_x11*in_x23*in_x27-t5*t7*t8*t9*t12*in_x9*in_x10*in_x11*in_x24*in_x26+t5*t7*t8*t9*t12*in_x9*in_x11*in_x12*in_x22*in_x26+t5*t7*t8*t9*t12*in_x9*in_x11*in_x12*in_x23*in_x25-t4*t6*t8*t10*t12*in_x8*in_x13*in_x14*in_x20*in_x27+t4*t6*t8*t10*t12*in_x8*in_x13*in_x14*in_x21*in_x26-t4*t6*t8*t10*t12*in_x8*in_x14*in_x15*in_x19*in_x26+t4*t6*t8*t10*t12*in_x8*in_x14*in_x15*in_x20*in_x25+t4*t6*t11*t13*t14*in_x6*in_x10*in_x17*in_x20*in_x21-t4*t6*t11*t13*t14*in_x6*in_x11*in_x16*in_x20*in_x21+t4*t6*t11*t13*t14*in_x6*in_x11*in_x18*in_x19*in_x20-t4*t6*t11*t13*t14*in_x6*in_x12*in_x17*in_x19*in_x20-t4*t9*t10*t11*t12*in_x5*in_x10*in_x11*in_x23*in_x27-t4*t9*t10*t11*t12*in_x5*in_x10*in_x11*in_x24*in_x26+t4*t9*t10*t11*t12*in_x5*in_x11*in_x12*in_x22*in_x26+t4*t9*t10*t11*t12*in_x5*in_x11*in_x12*in_x23*in_x25-t5*t6*t8*t12*t15*in_x2*in_x10*in_x17*in_x23*in_x24+t5*t6*t8*t12*t15*in_x2*in_x11*in_x16*in_x23*in_x24-t5*t6*t8*t12*t15*in_x2*in_x11*in_x18*in_x22*in_x23+t5*t6*t8*t12*t15*in_x2*in_x12*in_x17*in_x22*in_x23-t5*t6*t8*t14*t15*in_x3*in_x13*in_x17*in_x20*in_x21-t5*t6*t8*t14*t15*in_x3*in_x14*in_x16*in_x20*in_x21+t5*t6*t8*t14*t15*in_x3*in_x14*in_x18*in_x19*in_x20+t5*t6*t8*t14*t15*in_x3*in_x15*in_x17*in_x19*in_x20+t5*t7*t9*t14*t15*in_x4*in_x10*in_x11*in_x20*in_x27+t5*t7*t9*t14*t15*in_x4*in_x10*in_x11*in_x21*in_x26-t5*t7*t9*t14*t15*in_x4*in_x11*in_x12*in_x19*in_x26-t5*t7*t9*t14*t15*in_x4*in_x11*in_x12*in_x20*in_x25+t4*t8*t9*t10*t12*in_x9*in_x10*in_x11*in_x23*in_x27+t4*t8*t9*t10*t12*in_x9*in_x10*in_x11*in_x24*in_x26-t4*t8*t9*t10*t12*in_x9*in_x11*in_x12*in_x22*in_x26-t4*t8*t9*t10*t12*in_x9*in_x11*in_x12*in_x23*in_x25-t5*t6*t7*t11*t12*in_x5*in_x13*in_x14*in_x23*in_x27-t5*t6*t7*t11*t12*in_x5*in_x13*in_x14*in_x24*in_x26+t5*t6*t7*t11*t12*in_x5*in_x14*in_x15*in_x22*in_x26+t5*t6*t7*t11*t12*in_x5*in_x14*in_x15*in_x23*in_x25+t5*t6*t11*t12*t13*in_x2*in_x10*in_x17*in_x23*in_x24-t5*t6*t11*t12*t13*in_x2*in_x11*in_x16*in_x23*in_x24+t5*t6*t11*t12*t13*in_x2*in_x11*in_x18*in_x22*in_x23-t5*t6*t11*t12*t13*in_x2*in_x12*in_x17*in_x22*in_x23+t5*t6*t11*t13*t14*in_x3*in_x13*in_x17*in_x20*in_x21+t5*t6*t11*t13*t14*in_x3*in_x14*in_x16*in_x20*in_x21-t5*t6*t11*t13*t14*in_x3*in_x14*in_x18*in_x19*in_x20-t5*t6*t11*t13*t14*in_x3*in_x15*in_x17*in_x19*in_x20-t4*t9*t10*t14*t15*in_x4*in_x10*in_x11*in_x20*in_x27-t4*t9*t10*t14*t15*in_x4*in_x10*in_x11*in_x21*in_x26+t4*t9*t10*t14*t15*in_x4*in_x11*in_x12*in_x19*in_x26+t4*t9*t10*t14*t15*in_x4*in_x11*in_x12*in_x20*in_x25+t5*t6*t7*t8*t12*in_x9*in_x13*in_x14*in_x23*in_x27+t5*t6*t7*t8*t12*in_x9*in_x13*in_x14*in_x24*in_x26-t5*t6*t7*t8*t12*in_x9*in_x14*in_x15*in_x22*in_x26-t5*t6*t7*t8*t12*in_x9*in_x14*in_x15*in_x23*in_x25-t5*t7*t9*t13*t14*in_x8*in_x10*in_x11*in_x20*in_x27-t5*t7*t9*t13*t14*in_x8*in_x10*in_x11*in_x21*in_x26+t5*t7*t9*t13*t14*in_x8*in_x11*in_x12*in_x19*in_x26+t5*t7*t9*t13*t14*in_x8*in_x11*in_x12*in_x20*in_x25+t4*t6*t8*t12*t15*in_x6*in_x10*in_x17*in_x23*in_x24-t4*t6*t8*t12*t15*in_x6*in_x11*in_x16*in_x23*in_x24+t4*t6*t8*t12*t15*in_x6*in_x11*in_x18*in_x22*in_x23-t4*t6*t8*t12*t15*in_x6*in_x12*in_x17*in_x22*in_x23+t4*t6*t8*t14*t15*in_x7*in_x13*in_x17*in_x20*in_x21+t4*t6*t8*t14*t15*in_x7*in_x14*in_x16*in_x20*in_x21-t4*t6*t8*t14*t15*in_x7*in_x14*in_x18*in_x19*in_x20-t4*t6*t8*t14*t15*in_x7*in_x15*in_x17*in_x19*in_x20+t4*t6*t10*t11*t12*in_x5*in_x13*in_x14*in_x23*in_x27+t4*t6*t10*t11*t12*in_x5*in_x13*in_x14*in_x24*in_x26-t4*t6*t10*t11*t12*in_x5*in_x14*in_x15*in_x22*in_x26-t4*t6*t10*t11*t12*in_x5*in_x14*in_x15*in_x23*in_x25-t5*t6*t7*t14*t15*in_x4*in_x13*in_x14*in_x20*in_x27-t5*t6*t7*t14*t15*in_x4*in_x13*in_x14*in_x21*in_x26+t5*t6*t7*t14*t15*in_x4*in_x14*in_x15*in_x19*in_x26+t5*t6*t7*t14*t15*in_x4*in_x14*in_x15*in_x20*in_x25-t4*t6*t8*t10*t12*in_x9*in_x13*in_x14*in_x23*in_x27-t4*t6*t8*t10*t12*in_x9*in_x13*in_x14*in_x24*in_x26+t4*t6*t8*t10*t12*in_x9*in_x14*in_x15*in_x22*in_x26+t4*t6*t8*t10*t12*in_x9*in_x14*in_x15*in_x23*in_x25-t4*t6*t11*t12*t13*in_x6*in_x10*in_x17*in_x23*in_x24+t4*t6*t11*t12*t13*in_x6*in_x11*in_x16*in_x23*in_x24-t4*t6*t11*t12*t13*in_x6*in_x11*in_x18*in_x22*in_x23+t4*t6*t11*t12*t13*in_x6*in_x12*in_x17*in_x22*in_x23-t4*t6*t11*t13*t14*in_x7*in_x13*in_x17*in_x20*in_x21-t4*t6*t11*t13*t14*in_x7*in_x14*in_x16*in_x20*in_x21+t4*t6*t11*t13*t14*in_x7*in_x14*in_x18*in_x19*in_x20+t4*t6*t11*t13*t14*in_x7*in_x15*in_x17*in_x19*in_x20+t4*t9*t10*t13*t14*in_x8*in_x10*in_x11*in_x20*in_x27+t4*t9*t10*t13*t14*in_x8*in_x10*in_x11*in_x21*in_x26-t4*t9*t10*t13*t14*in_x8*in_x11*in_x12*in_x19*in_x26-t4*t9*t10*t13*t14*in_x8*in_x11*in_x12*in_x20*in_x25+t5*t6*t8*t12*t15*in_x3*in_x13*in_x17*in_x23*in_x24+t5*t6*t8*t12*t15*in_x3*in_x14*in_x16*in_x23*in_x24-t5*t6*t8*t12*t15*in_x3*in_x14*in_x18*in_x22*in_x23-t5*t6*t8*t12*t15*in_x3*in_x15*in_x17*in_x22*in_x23+t5*t7*t9*t14*t15*in_x5*in_x10*in_x11*in_x23*in_x27-t5*t7*t9*t14*t15*in_x5*in_x10*in_x11*in_x24*in_x26+t5*t7*t9*t14*t15*in_x5*in_x11*in_x12*in_x22*in_x26-t5*t7*t9*t14*t15*in_x5*in_x11*in_x12*in_x23*in_x25-t8*t9*t10*t14*t15*in_x2*in_x10*in_x17*in_x20*in_x21-t8*t9*t10*t14*t15*in_x2*in_x11*in_x16*in_x20*in_x21+t8*t9*t10*t14*t15*in_x2*in_x11*in_x18*in_x19*in_x20+t8*t9*t10*t14*t15*in_x2*in_x12*in_x17*in_x19*in_x20+t4*t6*t10*t14*t15*in_x4*in_x13*in_x14*in_x20*in_x27+t4*t6*t10*t14*t15*in_x4*in_x13*in_x14*in_x21*in_x26-t4*t6*t10*t14*t15*in_x4*in_x14*in_x15*in_x19*in_x26-t4*t6*t10*t14*t15*in_x4*in_x14*in_x15*in_x20*in_x25+t5*t6*t7*t13*t14*in_x8*in_x13*in_x14*in_x20*in_x27+t5*t6*t7*t13*t14*in_x8*in_x13*in_x14*in_x21*in_x26-t5*t6*t7*t13*t14*in_x8*in_x14*in_x15*in_x19*in_x26-t5*t6*t7*t13*t14*in_x8*in_x14*in_x15*in_x20*in_x25-t5*t6*t11*t12*t13*in_x3*in_x13*in_x17*in_x23*in_x24-t5*t6*t11*t12*t13*in_x3*in_x14*in_x16*in_x23*in_x24+t5*t6*t11*t12*t13*in_x3*in_x14*in_x18*in_x22*in_x23+t5*t6*t11*t12*t13*in_x3*in_x15*in_x17*in_x22*in_x23+t7*t8*t9*t14*t15*in_x6*in_x10*in_x17*in_x20*in_x21+t7*t8*t9*t14*t15*in_x6*in_x11*in_x16*in_x20*in_x21-t7*t8*t9*t14*t15*in_x6*in_x11*in_x18*in_x19*in_x20-t7*t8*t9*t14*t15*in_x6*in_x12*in_x17*in_x19*in_x20+t9*t10*t11*t13*t14*in_x2*in_x10*in_x17*in_x20*in_x21+t9*t10*t11*t13*t14*in_x2*in_x11*in_x16*in_x20*in_x21-t9*t10*t11*t13*t14*in_x2*in_x11*in_x18*in_x19*in_x20-t9*t10*t11*t13*t14*in_x2*in_x12*in_x17*in_x19*in_x20-t4*t9*t10*t14*t15*in_x5*in_x10*in_x11*in_x23*in_x27+t4*t9*t10*t14*t15*in_x5*in_x10*in_x11*in_x24*in_x26-t4*t9*t10*t14*t15*in_x5*in_x11*in_x12*in_x22*in_x26+t4*t9*t10*t14*t15*in_x5*in_x11*in_x12*in_x23*in_x25-t5*t7*t9*t13*t14*in_x9*in_x10*in_x11*in_x23*in_x27+t5*t7*t9*t13*t14*in_x9*in_x10*in_x11*in_x24*in_x26-t5*t7*t9*t13*t14*in_x9*in_x11*in_x12*in_x22*in_x26+t5*t7*t9*t13*t14*in_x9*in_x11*in_x12*in_x23*in_x25-t7*t9*t11*t13*t14*in_x6*in_x10*in_x17*in_x20*in_x21-t7*t9*t11*t13*t14*in_x6*in_x11*in_x16*in_x20*in_x21+t7*t9*t11*t13*t14*in_x6*in_x11*in_x18*in_x19*in_x20+t7*t9*t11*t13*t14*in_x6*in_x12*in_x17*in_x19*in_x20-t4*t6*t8*t12*t15*in_x7*in_x13*in_x17*in_x23*in_x24-t4*t6*t8*t12*t15*in_x7*in_x14*in_x16*in_x23*in_x24+t4*t6*t8*t12*t15*in_x7*in_x14*in_x18*in_x22*in_x23+t4*t6*t8*t12*t15*in_x7*in_x15*in_x17*in_x22*in_x23-t4*t6*t10*t13*t14*in_x8*in_x13*in_x14*in_x20*in_x27-t4*t6*t10*t13*t14*in_x8*in_x13*in_x14*in_x21*in_x26+t4*t6*t10*t13*t14*in_x8*in_x14*in_x15*in_x19*in_x26+t4*t6*t10*t13*t14*in_x8*in_x14*in_x15*in_x20*in_x25-t5*t6*t7*t14*t15*in_x5*in_x13*in_x14*in_x23*in_x27+t5*t6*t7*t14*t15*in_x5*in_x13*in_x14*in_x24*in_x26-t5*t6*t7*t14*t15*in_x5*in_x14*in_x15*in_x22*in_x26+t5*t6*t7*t14*t15*in_x5*in_x14*in_x15*in_x23*in_x25+t4*t6*t11*t12*t13*in_x7*in_x13*in_x17*in_x23*in_x24+t4*t6*t11*t12*t13*in_x7*in_x14*in_x16*in_x23*in_x24-t4*t6*t11*t12*t13*in_x7*in_x14*in_x18*in_x22*in_x23-t4*t6*t11*t12*t13*in_x7*in_x15*in_x17*in_x22*in_x23+t4*t9*t10*t13*t14*in_x9*in_x10*in_x11*in_x23*in_x27-t4*t9*t10*t13*t14*in_x9*in_x10*in_x11*in_x24*in_x26+t4*t9*t10*t13*t14*in_x9*in_x11*in_x12*in_x22*in_x26-t4*t9*t10*t13*t14*in_x9*in_x11*in_x12*in_x23*in_x25+t8*t9*t10*t12*t15*in_x2*in_x10*in_x17*in_x23*in_x24+t8*t9*t10*t12*t15*in_x2*in_x11*in_x16*in_x23*in_x24-t8*t9*t10*t12*t15*in_x2*in_x11*in_x18*in_x22*in_x23-t8*t9*t10*t12*t15*in_x2*in_x12*in_x17*in_x22*in_x23+t8*t9*t10*t14*t15*in_x3*in_x13*in_x17*in_x20*in_x21-t8*t9*t10*t14*t15*in_x3*in_x14*in_x16*in_x20*in_x21+t8*t9*t10*t14*t15*in_x3*in_x14*in_x18*in_x19*in_x20-t8*t9*t10*t14*t15*in_x3*in_x15*in_x17*in_x19*in_x20+t4*t6*t10*t14*t15*in_x5*in_x13*in_x14*in_x23*in_x27-t4*t6*t10*t14*t15*in_x5*in_x13*in_x14*in_x24*in_x26+t4*t6*t10*t14*t15*in_x5*in_x14*in_x15*in_x22*in_x26-t4*t6*t10*t14*t15*in_x5*in_x14*in_x15*in_x23*in_x25+t5*t6*t7*t13*t14*in_x9*in_x13*in_x14*in_x23*in_x27-t5*t6*t7*t13*t14*in_x9*in_x13*in_x14*in_x24*in_x26+t5*t6*t7*t13*t14*in_x9*in_x14*in_x15*in_x22*in_x26-t5*t6*t7*t13*t14*in_x9*in_x14*in_x15*in_x23*in_x25-t7*t8*t9*t12*t15*in_x6*in_x10*in_x17*in_x23*in_x24-t7*t8*t9*t12*t15*in_x6*in_x11*in_x16*in_x23*in_x24+t7*t8*t9*t12*t15*in_x6*in_x11*in_x18*in_x22*in_x23+t7*t8*t9*t12*t15*in_x6*in_x12*in_x17*in_x22*in_x23-t7*t8*t9*t14*t15*in_x7*in_x13*in_x17*in_x20*in_x21+t7*t8*t9*t14*t15*in_x7*in_x14*in_x16*in_x20*in_x21-t7*t8*t9*t14*t15*in_x7*in_x14*in_x18*in_x19*in_x20+t7*t8*t9*t14*t15*in_x7*in_x15*in_x17*in_x19*in_x20-t9*t10*t11*t12*t13*in_x2*in_x10*in_x17*in_x23*in_x24-t9*t10*t11*t12*t13*in_x2*in_x11*in_x16*in_x23*in_x24+t9*t10*t11*t12*t13*in_x2*in_x11*in_x18*in_x22*in_x23+t9*t10*t11*t12*t13*in_x2*in_x12*in_x17*in_x22*in_x23-t9*t10*t11*t13*t14*in_x3*in_x13*in_x17*in_x20*in_x21+t9*t10*t11*t13*t14*in_x3*in_x14*in_x16*in_x20*in_x21-t9*t10*t11*t13*t14*in_x3*in_x14*in_x18*in_x19*in_x20+t9*t10*t11*t13*t14*in_x3*in_x15*in_x17*in_x19*in_x20+t7*t9*t11*t12*t13*in_x6*in_x10*in_x17*in_x23*in_x24+t7*t9*t11*t12*t13*in_x6*in_x11*in_x16*in_x23*in_x24-t7*t9*t11*t12*t13*in_x6*in_x11*in_x18*in_x22*in_x23-t7*t9*t11*t12*t13*in_x6*in_x12*in_x17*in_x22*in_x23+t7*t9*t11*t13*t14*in_x7*in_x13*in_x17*in_x20*in_x21-t7*t9*t11*t13*t14*in_x7*in_x14*in_x16*in_x20*in_x21+t7*t9*t11*t13*t14*in_x7*in_x14*in_x18*in_x19*in_x20-t7*t9*t11*t13*t14*in_x7*in_x15*in_x17*in_x19*in_x20-t4*t6*t10*t13*t14*in_x9*in_x13*in_x14*in_x23*in_x27+t4*t6*t10*t13*t14*in_x9*in_x13*in_x14*in_x24*in_x26-t4*t6*t10*t13*t14*in_x9*in_x14*in_x15*in_x22*in_x26+t4*t6*t10*t13*t14*in_x9*in_x14*in_x15*in_x23*in_x25-t8*t9*t10*t12*t15*in_x3*in_x13*in_x17*in_x23*in_x24+t8*t9*t10*t12*t15*in_x3*in_x14*in_x16*in_x23*in_x24-t8*t9*t10*t12*t15*in_x3*in_x14*in_x18*in_x22*in_x23+t8*t9*t10*t12*t15*in_x3*in_x15*in_x17*in_x22*in_x23+t7*t8*t9*t12*t15*in_x7*in_x13*in_x17*in_x23*in_x24-t7*t8*t9*t12*t15*in_x7*in_x14*in_x16*in_x23*in_x24+t7*t8*t9*t12*t15*in_x7*in_x14*in_x18*in_x22*in_x23-t7*t8*t9*t12*t15*in_x7*in_x15*in_x17*in_x22*in_x23+t9*t10*t11*t12*t13*in_x3*in_x13*in_x17*in_x23*in_x24-t9*t10*t11*t12*t13*in_x3*in_x14*in_x16*in_x23*in_x24+t9*t10*t11*t12*t13*in_x3*in_x14*in_x18*in_x22*in_x23-t9*t10*t11*t12*t13*in_x3*in_x15*in_x17*in_x22*in_x23-t7*t9*t11*t12*t13*in_x7*in_x13*in_x17*in_x23*in_x24+t7*t9*t11*t12*t13*in_x7*in_x14*in_x16*in_x23*in_x24-t7*t9*t11*t12*t13*in_x7*in_x14*in_x18*in_x22*in_x23+t7*t9*t11*t12*t13*in_x7*in_x15*in_x17*in_x22*in_x23+t5*t6*t11*t12*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x27-t5*t6*t11*t12*in_x2*in_x3*in_x4*in_x10*in_x14*in_x21*in_x26-t5*t6*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x27+t5*t6*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x13*in_x21*in_x26-t5*t6*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x15*in_x19*in_x26+t5*t6*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x25+t5*t6*t11*t12*in_x2*in_x3*in_x4*in_x12*in_x14*in_x19*in_x26-t5*t6*t11*t12*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x25-t5*t6*t8*t12*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x27+t5*t6*t8*t12*in_x2*in_x3*in_x8*in_x10*in_x14*in_x21*in_x26+t5*t6*t8*t12*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x27-t5*t6*t8*t12*in_x2*in_x3*in_x8*in_x11*in_x13*in_x21*in_x26+t5*t6*t8*t12*in_x2*in_x3*in_x8*in_x11*in_x15*in_x19*in_x26-t5*t6*t8*t12*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x25-t5*t6*t8*t12*in_x2*in_x3*in_x8*in_x12*in_x14*in_x19*in_x26+t5*t6*t8*t12*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x25+t5*t6*t11*t12*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x24-t5*t6*t11*t12*in_x2*in_x4*in_x5*in_x10*in_x17*in_x21*in_x23-t5*t6*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x24+t5*t6*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x16*in_x21*in_x23-t5*t6*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x18*in_x19*in_x23+t5*t6*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x22+t5*t6*t11*t12*in_x2*in_x4*in_x5*in_x12*in_x17*in_x19*in_x23-t5*t6*t11*t12*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x22+t5*t6*t11*t12*in_x2*in_x3*in_x5*in_x10*in_x14*in_x23*in_x27+t5*t6*t11*t12*in_x2*in_x3*in_x5*in_x10*in_x14*in_x24*in_x26-t5*t6*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x13*in_x23*in_x27-t5*t6*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x13*in_x24*in_x26+t5*t6*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x15*in_x22*in_x26+t5*t6*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x15*in_x23*in_x25-t5*t6*t11*t12*in_x2*in_x3*in_x5*in_x12*in_x14*in_x22*in_x26-t5*t6*t11*t12*in_x2*in_x3*in_x5*in_x12*in_x14*in_x23*in_x25-t4*t6*t11*t12*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x24+t4*t6*t11*t12*in_x4*in_x5*in_x6*in_x10*in_x17*in_x21*in_x23+t4*t6*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x24-t4*t6*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x16*in_x21*in_x23+t4*t6*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x18*in_x19*in_x23-t4*t6*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x22-t4*t6*t11*t12*in_x4*in_x5*in_x6*in_x12*in_x17*in_x19*in_x23+t4*t6*t11*t12*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x22-t5*t6*t8*t12*in_x2*in_x3*in_x9*in_x10*in_x14*in_x23*in_x27-t5*t6*t8*t12*in_x2*in_x3*in_x9*in_x10*in_x14*in_x24*in_x26+t5*t6*t8*t12*in_x2*in_x3*in_x9*in_x11*in_x13*in_x23*in_x27+t5*t6*t8*t12*in_x2*in_x3*in_x9*in_x11*in_x13*in_x24*in_x26-t5*t6*t8*t12*in_x2*in_x3*in_x9*in_x11*in_x15*in_x22*in_x26-t5*t6*t8*t12*in_x2*in_x3*in_x9*in_x11*in_x15*in_x23*in_x25+t5*t6*t8*t12*in_x2*in_x3*in_x9*in_x12*in_x14*in_x22*in_x26+t5*t6*t8*t12*in_x2*in_x3*in_x9*in_x12*in_x14*in_x23*in_x25-t5*t6*t11*t12*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x24+t5*t6*t11*t12*in_x3*in_x4*in_x5*in_x13*in_x17*in_x21*in_x23-t5*t6*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x24+t5*t6*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x16*in_x21*in_x23-t5*t6*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x18*in_x19*in_x23+t5*t6*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x22-t5*t6*t11*t12*in_x3*in_x4*in_x5*in_x15*in_x17*in_x19*in_x23+t5*t6*t11*t12*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x22+t5*t6*t14*t15*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x27+t5*t6*t14*t15*in_x2*in_x3*in_x4*in_x10*in_x14*in_x21*in_x26-t5*t6*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x27-t5*t6*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x13*in_x21*in_x26+t5*t6*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x15*in_x19*in_x26+t5*t6*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x25-t5*t6*t14*t15*in_x2*in_x3*in_x4*in_x12*in_x14*in_x19*in_x26-t5*t6*t14*t15*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x25-t4*t6*t11*t12*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x27+t4*t6*t11*t12*in_x4*in_x6*in_x7*in_x10*in_x14*in_x21*in_x26+t4*t6*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x27-t4*t6*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x13*in_x21*in_x26+t4*t6*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x15*in_x19*in_x26-t4*t6*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x25-t4*t6*t11*t12*in_x4*in_x6*in_x7*in_x12*in_x14*in_x19*in_x26+t4*t6*t11*t12*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x25-t5*t6*t8*t12*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24+t5*t6*t8*t12*in_x2*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23+t5*t6*t8*t12*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24-t5*t6*t8*t12*in_x2*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23+t5*t6*t8*t12*in_x2*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23-t5*t6*t8*t12*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22-t5*t6*t8*t12*in_x2*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23+t5*t6*t8*t12*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22-t5*t7*t9*t12*in_x4*in_x5*in_x8*in_x10*in_x11*in_x23*in_x27*2.0+t5*t7*t9*t12*in_x4*in_x5*in_x8*in_x10*in_x11*in_x24*in_x26*2.0-t5*t7*t9*t12*in_x4*in_x5*in_x8*in_x11*in_x12*in_x22*in_x26*2.0+t5*t7*t9*t12*in_x4*in_x5*in_x8*in_x11*in_x12*in_x23*in_x25*2.0-t5*t7*t9*t14*in_x4*in_x5*in_x9*in_x10*in_x11*in_x20*in_x27*2.0+t5*t7*t9*t14*in_x4*in_x5*in_x9*in_x10*in_x11*in_x21*in_x26*2.0-t5*t7*t9*t14*in_x4*in_x5*in_x9*in_x11*in_x12*in_x19*in_x26*2.0+t5*t7*t9*t14*in_x4*in_x5*in_x9*in_x11*in_x12*in_x20*in_x25*2.0+t4*t6*t8*t12*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27-t4*t6*t8*t12*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26-t4*t6*t8*t12*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27+t4*t6*t8*t12*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26-t4*t6*t8*t12*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26+t4*t6*t8*t12*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25+t4*t6*t8*t12*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26-t4*t6*t8*t12*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25-t5*t6*t13*t14*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x27-t5*t6*t13*t14*in_x2*in_x3*in_x8*in_x10*in_x14*in_x21*in_x26+t5*t6*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x27+t5*t6*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x13*in_x21*in_x26-t5*t6*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x15*in_x19*in_x26-t5*t6*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x25+t5*t6*t13*t14*in_x2*in_x3*in_x8*in_x12*in_x14*in_x19*in_x26+t5*t6*t13*t14*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x25-t5*t6*t14*t15*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x24+t5*t6*t14*t15*in_x2*in_x4*in_x5*in_x10*in_x17*in_x21*in_x23+t5*t6*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x24-t5*t6*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x16*in_x21*in_x23+t5*t6*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x18*in_x19*in_x23-t5*t6*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x22-t5*t6*t14*t15*in_x2*in_x4*in_x5*in_x12*in_x17*in_x19*in_x23+t5*t6*t14*t15*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x22-t9*t10*t11*t12*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x27+t9*t10*t11*t12*in_x2*in_x3*in_x4*in_x10*in_x14*in_x21*in_x26+t9*t10*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x27-t9*t10*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x13*in_x21*in_x26+t9*t10*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x15*in_x19*in_x26-t9*t10*t11*t12*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x25-t9*t10*t11*t12*in_x2*in_x3*in_x4*in_x12*in_x14*in_x19*in_x26+t9*t10*t11*t12*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x25+t4*t6*t11*t12*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x24-t4*t6*t11*t12*in_x4*in_x5*in_x7*in_x13*in_x17*in_x21*in_x23+t4*t6*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x24-t4*t6*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x16*in_x21*in_x23+t4*t6*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x18*in_x19*in_x23-t4*t6*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x22+t4*t6*t11*t12*in_x4*in_x5*in_x7*in_x15*in_x17*in_x19*in_x23-t4*t6*t11*t12*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x22+t4*t9*t10*t12*in_x4*in_x5*in_x8*in_x10*in_x11*in_x23*in_x27*2.0-t4*t9*t10*t12*in_x4*in_x5*in_x8*in_x10*in_x11*in_x24*in_x26*2.0+t4*t9*t10*t12*in_x4*in_x5*in_x8*in_x11*in_x12*in_x22*in_x26*2.0-t4*t9*t10*t12*in_x4*in_x5*in_x8*in_x11*in_x12*in_x23*in_x25*2.0+t4*t9*t10*t14*in_x4*in_x5*in_x9*in_x10*in_x11*in_x20*in_x27*2.0-t4*t9*t10*t14*in_x4*in_x5*in_x9*in_x10*in_x11*in_x21*in_x26*2.0+t4*t9*t10*t14*in_x4*in_x5*in_x9*in_x11*in_x12*in_x19*in_x26*2.0-t4*t9*t10*t14*in_x4*in_x5*in_x9*in_x11*in_x12*in_x20*in_x25*2.0+t8*t9*t10*t12*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x27-t8*t9*t10*t12*in_x2*in_x3*in_x8*in_x10*in_x14*in_x21*in_x26-t8*t9*t10*t12*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x27+t8*t9*t10*t12*in_x2*in_x3*in_x8*in_x11*in_x13*in_x21*in_x26-t8*t9*t10*t12*in_x2*in_x3*in_x8*in_x11*in_x15*in_x19*in_x26+t8*t9*t10*t12*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x25+t8*t9*t10*t12*in_x2*in_x3*in_x8*in_x12*in_x14*in_x19*in_x26-t8*t9*t10*t12*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x25+t4*t6*t8*t12*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24-t4*t6*t8*t12*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23-t4*t6*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24+t4*t6*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23-t4*t6*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23+t4*t6*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22+t4*t6*t8*t12*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23-t4*t6*t8*t12*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t5*t6*t7*t12*in_x4*in_x5*in_x8*in_x13*in_x14*in_x23*in_x27*2.0-t5*t6*t7*t12*in_x4*in_x5*in_x8*in_x13*in_x14*in_x24*in_x26*2.0+t5*t6*t7*t12*in_x4*in_x5*in_x8*in_x14*in_x15*in_x22*in_x26*2.0-t5*t6*t7*t12*in_x4*in_x5*in_x8*in_x14*in_x15*in_x23*in_x25*2.0+t5*t6*t7*t14*in_x4*in_x5*in_x9*in_x13*in_x14*in_x20*in_x27*2.0-t5*t6*t7*t14*in_x4*in_x5*in_x9*in_x13*in_x14*in_x21*in_x26*2.0+t5*t6*t7*t14*in_x4*in_x5*in_x9*in_x14*in_x15*in_x19*in_x26*2.0-t5*t6*t7*t14*in_x4*in_x5*in_x9*in_x14*in_x15*in_x20*in_x25*2.0+t5*t6*t14*t15*in_x2*in_x3*in_x5*in_x10*in_x14*in_x23*in_x27-t5*t6*t14*t15*in_x2*in_x3*in_x5*in_x10*in_x14*in_x24*in_x26-t5*t6*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x13*in_x23*in_x27+t5*t6*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x13*in_x24*in_x26-t5*t6*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x15*in_x22*in_x26+t5*t6*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x15*in_x23*in_x25+t5*t6*t14*t15*in_x2*in_x3*in_x5*in_x12*in_x14*in_x22*in_x26-t5*t6*t14*t15*in_x2*in_x3*in_x5*in_x12*in_x14*in_x23*in_x25-t9*t10*t11*t12*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x24+t9*t10*t11*t12*in_x2*in_x4*in_x5*in_x10*in_x17*in_x21*in_x23-t9*t10*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x24+t9*t10*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x16*in_x21*in_x23-t9*t10*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x18*in_x19*in_x23+t9*t10*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x22-t9*t10*t11*t12*in_x2*in_x4*in_x5*in_x12*in_x17*in_x19*in_x23+t9*t10*t11*t12*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x22-t4*t6*t11*t12*in_x5*in_x6*in_x7*in_x10*in_x14*in_x23*in_x27-t4*t6*t11*t12*in_x5*in_x6*in_x7*in_x10*in_x14*in_x24*in_x26+t4*t6*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x13*in_x23*in_x27+t4*t6*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x13*in_x24*in_x26-t4*t6*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x15*in_x22*in_x26-t4*t6*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x15*in_x23*in_x25+t4*t6*t11*t12*in_x5*in_x6*in_x7*in_x12*in_x14*in_x22*in_x26+t4*t6*t11*t12*in_x5*in_x6*in_x7*in_x12*in_x14*in_x23*in_x25+t4*t6*t14*t15*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x24-t4*t6*t14*t15*in_x4*in_x5*in_x6*in_x10*in_x17*in_x21*in_x23-t4*t6*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x24+t4*t6*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x16*in_x21*in_x23-t4*t6*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x18*in_x19*in_x23+t4*t6*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x22+t4*t6*t14*t15*in_x4*in_x5*in_x6*in_x12*in_x17*in_x19*in_x23-t4*t6*t14*t15*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x22+t5*t6*t8*t12*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24-t5*t6*t8*t12*in_x3*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23+t5*t6*t8*t12*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24-t5*t6*t8*t12*in_x3*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23+t5*t6*t8*t12*in_x3*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23-t5*t6*t8*t12*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22+t5*t6*t8*t12*in_x3*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23-t5*t6*t8*t12*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22+t5*t7*t9*t12*in_x4*in_x8*in_x9*in_x10*in_x11*in_x23*in_x27*2.0-t5*t7*t9*t12*in_x4*in_x8*in_x9*in_x10*in_x11*in_x24*in_x26*2.0+t5*t7*t9*t12*in_x4*in_x8*in_x9*in_x11*in_x12*in_x22*in_x26*2.0-t5*t7*t9*t12*in_x4*in_x8*in_x9*in_x11*in_x12*in_x23*in_x25*2.0+t5*t7*t9*t14*in_x5*in_x8*in_x9*in_x10*in_x11*in_x20*in_x27*2.0-t5*t7*t9*t14*in_x5*in_x8*in_x9*in_x10*in_x11*in_x21*in_x26*2.0+t5*t7*t9*t14*in_x5*in_x8*in_x9*in_x11*in_x12*in_x19*in_x26*2.0-t5*t7*t9*t14*in_x5*in_x8*in_x9*in_x11*in_x12*in_x20*in_x25*2.0-t6*t8*t14*t15*in_x2*in_x3*in_x6*in_x13*in_x17*in_x20*in_x21*2.0+t6*t8*t14*t15*in_x2*in_x3*in_x6*in_x14*in_x16*in_x20*in_x21*2.0-t6*t8*t14*t15*in_x2*in_x3*in_x6*in_x14*in_x18*in_x19*in_x20*2.0+t6*t8*t14*t15*in_x2*in_x3*in_x6*in_x15*in_x17*in_x19*in_x20*2.0+t7*t9*t11*t12*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x24-t7*t9*t11*t12*in_x4*in_x5*in_x6*in_x10*in_x17*in_x21*in_x23+t7*t9*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x24-t7*t9*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x16*in_x21*in_x23+t7*t9*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x18*in_x19*in_x23-t7*t9*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x22+t7*t9*t11*t12*in_x4*in_x5*in_x6*in_x12*in_x17*in_x19*in_x23-t7*t9*t11*t12*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x22+t4*t6*t8*t12*in_x6*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27+t4*t6*t8*t12*in_x6*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26-t4*t6*t8*t12*in_x6*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27-t4*t6*t8*t12*in_x6*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26+t4*t6*t8*t12*in_x6*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26+t4*t6*t8*t12*in_x6*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25-t4*t6*t8*t12*in_x6*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26-t4*t6*t8*t12*in_x6*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25-t4*t6*t10*t12*in_x4*in_x5*in_x8*in_x13*in_x14*in_x23*in_x27*2.0+t4*t6*t10*t12*in_x4*in_x5*in_x8*in_x13*in_x14*in_x24*in_x26*2.0-t4*t6*t10*t12*in_x4*in_x5*in_x8*in_x14*in_x15*in_x22*in_x26*2.0+t4*t6*t10*t12*in_x4*in_x5*in_x8*in_x14*in_x15*in_x23*in_x25*2.0-t4*t6*t10*t14*in_x4*in_x5*in_x9*in_x13*in_x14*in_x20*in_x27*2.0+t4*t6*t10*t14*in_x4*in_x5*in_x9*in_x13*in_x14*in_x21*in_x26*2.0-t4*t6*t10*t14*in_x4*in_x5*in_x9*in_x14*in_x15*in_x19*in_x26*2.0+t4*t6*t10*t14*in_x4*in_x5*in_x9*in_x14*in_x15*in_x20*in_x25*2.0-t5*t6*t13*t14*in_x2*in_x3*in_x9*in_x10*in_x14*in_x23*in_x27+t5*t6*t13*t14*in_x2*in_x3*in_x9*in_x10*in_x14*in_x24*in_x26+t5*t6*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x13*in_x23*in_x27-t5*t6*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x13*in_x24*in_x26+t5*t6*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x15*in_x22*in_x26-t5*t6*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x15*in_x23*in_x25-t5*t6*t13*t14*in_x2*in_x3*in_x9*in_x12*in_x14*in_x22*in_x26+t5*t6*t13*t14*in_x2*in_x3*in_x9*in_x12*in_x14*in_x23*in_x25+t5*t6*t14*t15*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x24-t5*t6*t14*t15*in_x3*in_x4*in_x5*in_x13*in_x17*in_x21*in_x23+t5*t6*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x24-t5*t6*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x16*in_x21*in_x23+t5*t6*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x18*in_x19*in_x23-t5*t6*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x22+t5*t6*t14*t15*in_x3*in_x4*in_x5*in_x15*in_x17*in_x19*in_x23-t5*t6*t14*t15*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x22+t6*t11*t13*t14*in_x2*in_x3*in_x6*in_x13*in_x17*in_x20*in_x21*2.0-t6*t11*t13*t14*in_x2*in_x3*in_x6*in_x14*in_x16*in_x20*in_x21*2.0+t6*t11*t13*t14*in_x2*in_x3*in_x6*in_x14*in_x18*in_x19*in_x20*2.0-t6*t11*t13*t14*in_x2*in_x3*in_x6*in_x15*in_x17*in_x19*in_x20*2.0-t8*t9*t14*t15*in_x2*in_x3*in_x7*in_x10*in_x17*in_x20*in_x21*2.0+t8*t9*t14*t15*in_x2*in_x3*in_x7*in_x11*in_x16*in_x20*in_x21*2.0-t8*t9*t14*t15*in_x2*in_x3*in_x7*in_x11*in_x18*in_x19*in_x20*2.0+t8*t9*t14*t15*in_x2*in_x3*in_x7*in_x12*in_x17*in_x19*in_x20*2.0-t9*t10*t11*t12*in_x2*in_x3*in_x5*in_x10*in_x14*in_x23*in_x27-t9*t10*t11*t12*in_x2*in_x3*in_x5*in_x10*in_x14*in_x24*in_x26+t9*t10*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x13*in_x23*in_x27+t9*t10*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x13*in_x24*in_x26-t9*t10*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x15*in_x22*in_x26-t9*t10*t11*t12*in_x2*in_x3*in_x5*in_x11*in_x15*in_x23*in_x25+t9*t10*t11*t12*in_x2*in_x3*in_x5*in_x12*in_x14*in_x22*in_x26+t9*t10*t11*t12*in_x2*in_x3*in_x5*in_x12*in_x14*in_x23*in_x25-t4*t6*t14*t15*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x27-t4*t6*t14*t15*in_x4*in_x6*in_x7*in_x10*in_x14*in_x21*in_x26+t4*t6*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x27+t4*t6*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x13*in_x21*in_x26-t4*t6*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x15*in_x19*in_x26-t4*t6*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x25+t4*t6*t14*t15*in_x4*in_x6*in_x7*in_x12*in_x14*in_x19*in_x26+t4*t6*t14*t15*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x25-t4*t9*t10*t12*in_x4*in_x8*in_x9*in_x10*in_x11*in_x23*in_x27*2.0+t4*t9*t10*t12*in_x4*in_x8*in_x9*in_x10*in_x11*in_x24*in_x26*2.0-t4*t9*t10*t12*in_x4*in_x8*in_x9*in_x11*in_x12*in_x22*in_x26*2.0+t4*t9*t10*t12*in_x4*in_x8*in_x9*in_x11*in_x12*in_x23*in_x25*2.0-t4*t9*t10*t14*in_x5*in_x8*in_x9*in_x10*in_x11*in_x20*in_x27*2.0+t4*t9*t10*t14*in_x5*in_x8*in_x9*in_x10*in_x11*in_x21*in_x26*2.0-t4*t9*t10*t14*in_x5*in_x8*in_x9*in_x11*in_x12*in_x19*in_x26*2.0+t4*t9*t10*t14*in_x5*in_x8*in_x9*in_x11*in_x12*in_x20*in_x25*2.0+t7*t9*t11*t12*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x27-t7*t9*t11*t12*in_x4*in_x6*in_x7*in_x10*in_x14*in_x21*in_x26-t7*t9*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x27+t7*t9*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x13*in_x21*in_x26-t7*t9*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x15*in_x19*in_x26+t7*t9*t11*t12*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x25+t7*t9*t11*t12*in_x4*in_x6*in_x7*in_x12*in_x14*in_x19*in_x26-t7*t9*t11*t12*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x25+t8*t9*t10*t12*in_x2*in_x3*in_x9*in_x10*in_x14*in_x23*in_x27+t8*t9*t10*t12*in_x2*in_x3*in_x9*in_x10*in_x14*in_x24*in_x26-t8*t9*t10*t12*in_x2*in_x3*in_x9*in_x11*in_x13*in_x23*in_x27-t8*t9*t10*t12*in_x2*in_x3*in_x9*in_x11*in_x13*in_x24*in_x26+t8*t9*t10*t12*in_x2*in_x3*in_x9*in_x11*in_x15*in_x22*in_x26+t8*t9*t10*t12*in_x2*in_x3*in_x9*in_x11*in_x15*in_x23*in_x25-t8*t9*t10*t12*in_x2*in_x3*in_x9*in_x12*in_x14*in_x22*in_x26-t8*t9*t10*t12*in_x2*in_x3*in_x9*in_x12*in_x14*in_x23*in_x25+t9*t11*t13*t14*in_x2*in_x3*in_x7*in_x10*in_x17*in_x20*in_x21*2.0-t9*t11*t13*t14*in_x2*in_x3*in_x7*in_x11*in_x16*in_x20*in_x21*2.0+t9*t11*t13*t14*in_x2*in_x3*in_x7*in_x11*in_x18*in_x19*in_x20*2.0-t9*t11*t13*t14*in_x2*in_x3*in_x7*in_x12*in_x17*in_x19*in_x20*2.0-t4*t6*t8*t12*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24+t4*t6*t8*t12*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23-t4*t6*t8*t12*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24+t4*t6*t8*t12*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23-t4*t6*t8*t12*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23+t4*t6*t8*t12*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22-t4*t6*t8*t12*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23+t4*t6*t8*t12*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t5*t6*t7*t12*in_x4*in_x8*in_x9*in_x13*in_x14*in_x23*in_x27*2.0+t5*t6*t7*t12*in_x4*in_x8*in_x9*in_x13*in_x14*in_x24*in_x26*2.0-t5*t6*t7*t12*in_x4*in_x8*in_x9*in_x14*in_x15*in_x22*in_x26*2.0+t5*t6*t7*t12*in_x4*in_x8*in_x9*in_x14*in_x15*in_x23*in_x25*2.0-t5*t6*t7*t14*in_x5*in_x8*in_x9*in_x13*in_x14*in_x20*in_x27*2.0+t5*t6*t7*t14*in_x5*in_x8*in_x9*in_x13*in_x14*in_x21*in_x26*2.0-t5*t6*t7*t14*in_x5*in_x8*in_x9*in_x14*in_x15*in_x19*in_x26*2.0+t5*t6*t7*t14*in_x5*in_x8*in_x9*in_x14*in_x15*in_x20*in_x25*2.0+t5*t6*t13*t14*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24-t5*t6*t13*t14*in_x2*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23-t5*t6*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24+t5*t6*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23-t5*t6*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23+t5*t6*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22+t5*t6*t13*t14*in_x2*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23-t5*t6*t13*t14*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22-t7*t8*t9*t12*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27+t7*t8*t9*t12*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26+t7*t8*t9*t12*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27-t7*t8*t9*t12*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26+t7*t8*t9*t12*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26-t7*t8*t9*t12*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25-t7*t8*t9*t12*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26+t7*t8*t9*t12*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25+t9*t10*t11*t12*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x24-t9*t10*t11*t12*in_x3*in_x4*in_x5*in_x13*in_x17*in_x21*in_x23-t9*t10*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x24+t9*t10*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x16*in_x21*in_x23-t9*t10*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x18*in_x19*in_x23+t9*t10*t11*t12*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x22+t9*t10*t11*t12*in_x3*in_x4*in_x5*in_x15*in_x17*in_x19*in_x23-t9*t10*t11*t12*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x22-t9*t10*t14*t15*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x27-t9*t10*t14*t15*in_x2*in_x3*in_x4*in_x10*in_x14*in_x21*in_x26+t9*t10*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x27+t9*t10*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x13*in_x21*in_x26-t9*t10*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x15*in_x19*in_x26-t9*t10*t14*t15*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x25+t9*t10*t14*t15*in_x2*in_x3*in_x4*in_x12*in_x14*in_x19*in_x26+t9*t10*t14*t15*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x25+t4*t6*t13*t14*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27+t4*t6*t13*t14*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26-t4*t6*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27-t4*t6*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26+t4*t6*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26+t4*t6*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25-t4*t6*t13*t14*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26-t4*t6*t13*t14*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25-t4*t6*t14*t15*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x24+t4*t6*t14*t15*in_x4*in_x5*in_x7*in_x13*in_x17*in_x21*in_x23-t4*t6*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x24+t4*t6*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x16*in_x21*in_x23-t4*t6*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x18*in_x19*in_x23+t4*t6*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x22-t4*t6*t14*t15*in_x4*in_x5*in_x7*in_x15*in_x17*in_x19*in_x23+t4*t6*t14*t15*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x22+t6*t8*t12*t15*in_x2*in_x3*in_x6*in_x13*in_x17*in_x23*in_x24*2.0-t6*t8*t12*t15*in_x2*in_x3*in_x6*in_x14*in_x16*in_x23*in_x24*2.0+t6*t8*t12*t15*in_x2*in_x3*in_x6*in_x14*in_x18*in_x22*in_x23*2.0-t6*t8*t12*t15*in_x2*in_x3*in_x6*in_x15*in_x17*in_x22*in_x23*2.0+t6*t8*t14*t15*in_x2*in_x6*in_x7*in_x13*in_x17*in_x20*in_x21*2.0-t6*t8*t14*t15*in_x2*in_x6*in_x7*in_x14*in_x16*in_x20*in_x21*2.0+t6*t8*t14*t15*in_x2*in_x6*in_x7*in_x14*in_x18*in_x19*in_x20*2.0-t6*t8*t14*t15*in_x2*in_x6*in_x7*in_x15*in_x17*in_x19*in_x20*2.0-t7*t9*t11*t12*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x24+t7*t9*t11*t12*in_x4*in_x5*in_x7*in_x13*in_x17*in_x21*in_x23+t7*t9*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x24-t7*t9*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x16*in_x21*in_x23+t7*t9*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x18*in_x19*in_x23-t7*t9*t11*t12*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x22-t7*t9*t11*t12*in_x4*in_x5*in_x7*in_x15*in_x17*in_x19*in_x23+t7*t9*t11*t12*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x22+t8*t9*t10*t12*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24-t8*t9*t10*t12*in_x2*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23+t8*t9*t10*t12*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24-t8*t9*t10*t12*in_x2*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23+t8*t9*t10*t12*in_x2*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23-t8*t9*t10*t12*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22+t8*t9*t10*t12*in_x2*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23-t8*t9*t10*t12*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t4*t6*t10*t12*in_x4*in_x8*in_x9*in_x13*in_x14*in_x23*in_x27*2.0-t4*t6*t10*t12*in_x4*in_x8*in_x9*in_x13*in_x14*in_x24*in_x26*2.0+t4*t6*t10*t12*in_x4*in_x8*in_x9*in_x14*in_x15*in_x22*in_x26*2.0-t4*t6*t10*t12*in_x4*in_x8*in_x9*in_x14*in_x15*in_x23*in_x25*2.0+t4*t6*t10*t14*in_x5*in_x8*in_x9*in_x13*in_x14*in_x20*in_x27*2.0-t4*t6*t10*t14*in_x5*in_x8*in_x9*in_x13*in_x14*in_x21*in_x26*2.0+t4*t6*t10*t14*in_x5*in_x8*in_x9*in_x14*in_x15*in_x19*in_x26*2.0-t4*t6*t10*t14*in_x5*in_x8*in_x9*in_x14*in_x15*in_x20*in_x25*2.0-t6*t11*t12*t13*in_x2*in_x3*in_x6*in_x13*in_x17*in_x23*in_x24*2.0+t6*t11*t12*t13*in_x2*in_x3*in_x6*in_x14*in_x16*in_x23*in_x24*2.0-t6*t11*t12*t13*in_x2*in_x3*in_x6*in_x14*in_x18*in_x22*in_x23*2.0+t6*t11*t12*t13*in_x2*in_x3*in_x6*in_x15*in_x17*in_x22*in_x23*2.0-t6*t11*t13*t14*in_x2*in_x6*in_x7*in_x13*in_x17*in_x20*in_x21*2.0+t6*t11*t13*t14*in_x2*in_x6*in_x7*in_x14*in_x16*in_x20*in_x21*2.0-t6*t11*t13*t14*in_x2*in_x6*in_x7*in_x14*in_x18*in_x19*in_x20*2.0+t6*t11*t13*t14*in_x2*in_x6*in_x7*in_x15*in_x17*in_x19*in_x20*2.0-t7*t8*t9*t12*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24+t7*t8*t9*t12*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23-t7*t8*t9*t12*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24+t7*t8*t9*t12*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23-t7*t8*t9*t12*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23+t7*t8*t9*t12*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22-t7*t8*t9*t12*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23+t7*t8*t9*t12*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t8*t9*t12*t15*in_x2*in_x3*in_x7*in_x10*in_x17*in_x23*in_x24*2.0-t8*t9*t12*t15*in_x2*in_x3*in_x7*in_x11*in_x16*in_x23*in_x24*2.0+t8*t9*t12*t15*in_x2*in_x3*in_x7*in_x11*in_x18*in_x22*in_x23*2.0-t8*t9*t12*t15*in_x2*in_x3*in_x7*in_x12*in_x17*in_x22*in_x23*2.0+t8*t9*t14*t15*in_x3*in_x6*in_x7*in_x10*in_x17*in_x20*in_x21*2.0-t8*t9*t14*t15*in_x3*in_x6*in_x7*in_x11*in_x16*in_x20*in_x21*2.0+t8*t9*t14*t15*in_x3*in_x6*in_x7*in_x11*in_x18*in_x19*in_x20*2.0-t8*t9*t14*t15*in_x3*in_x6*in_x7*in_x12*in_x17*in_x19*in_x20*2.0+t9*t10*t13*t14*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x27+t9*t10*t13*t14*in_x2*in_x3*in_x8*in_x10*in_x14*in_x21*in_x26-t9*t10*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x27-t9*t10*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x13*in_x21*in_x26+t9*t10*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x15*in_x19*in_x26+t9*t10*t13*t14*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x25-t9*t10*t13*t14*in_x2*in_x3*in_x8*in_x12*in_x14*in_x19*in_x26-t9*t10*t13*t14*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x25+t9*t10*t14*t15*in_x2*in_x4*in_x5*in_x10*in_x17*in_x20*in_x24-t9*t10*t14*t15*in_x2*in_x4*in_x5*in_x10*in_x17*in_x21*in_x23+t9*t10*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x16*in_x20*in_x24-t9*t10*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x16*in_x21*in_x23+t9*t10*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x18*in_x19*in_x23-t9*t10*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x18*in_x20*in_x22+t9*t10*t14*t15*in_x2*in_x4*in_x5*in_x12*in_x17*in_x19*in_x23-t9*t10*t14*t15*in_x2*in_x4*in_x5*in_x12*in_x17*in_x20*in_x22-t4*t6*t13*t14*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24+t4*t6*t13*t14*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23+t4*t6*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24-t4*t6*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23+t4*t6*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23-t4*t6*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22-t4*t6*t13*t14*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23+t4*t6*t13*t14*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22-t4*t6*t14*t15*in_x5*in_x6*in_x7*in_x10*in_x14*in_x23*in_x27+t4*t6*t14*t15*in_x5*in_x6*in_x7*in_x10*in_x14*in_x24*in_x26+t4*t6*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x13*in_x23*in_x27-t4*t6*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x13*in_x24*in_x26+t4*t6*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x15*in_x22*in_x26-t4*t6*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x15*in_x23*in_x25-t4*t6*t14*t15*in_x5*in_x6*in_x7*in_x12*in_x14*in_x22*in_x26+t4*t6*t14*t15*in_x5*in_x6*in_x7*in_x12*in_x14*in_x23*in_x25+t7*t9*t11*t12*in_x5*in_x6*in_x7*in_x10*in_x14*in_x23*in_x27+t7*t9*t11*t12*in_x5*in_x6*in_x7*in_x10*in_x14*in_x24*in_x26-t7*t9*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x13*in_x23*in_x27-t7*t9*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x13*in_x24*in_x26+t7*t9*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x15*in_x22*in_x26+t7*t9*t11*t12*in_x5*in_x6*in_x7*in_x11*in_x15*in_x23*in_x25-t7*t9*t11*t12*in_x5*in_x6*in_x7*in_x12*in_x14*in_x22*in_x26-t7*t9*t11*t12*in_x5*in_x6*in_x7*in_x12*in_x14*in_x23*in_x25-t7*t9*t14*t15*in_x4*in_x5*in_x6*in_x10*in_x17*in_x20*in_x24+t7*t9*t14*t15*in_x4*in_x5*in_x6*in_x10*in_x17*in_x21*in_x23-t7*t9*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x16*in_x20*in_x24+t7*t9*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x16*in_x21*in_x23-t7*t9*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x18*in_x19*in_x23+t7*t9*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x18*in_x20*in_x22-t7*t9*t14*t15*in_x4*in_x5*in_x6*in_x12*in_x17*in_x19*in_x23+t7*t9*t14*t15*in_x4*in_x5*in_x6*in_x12*in_x17*in_x20*in_x22-t9*t11*t12*t13*in_x2*in_x3*in_x7*in_x10*in_x17*in_x23*in_x24*2.0+t9*t11*t12*t13*in_x2*in_x3*in_x7*in_x11*in_x16*in_x23*in_x24*2.0-t9*t11*t12*t13*in_x2*in_x3*in_x7*in_x11*in_x18*in_x22*in_x23*2.0+t9*t11*t12*t13*in_x2*in_x3*in_x7*in_x12*in_x17*in_x22*in_x23*2.0-t9*t11*t13*t14*in_x3*in_x6*in_x7*in_x10*in_x17*in_x20*in_x21*2.0+t9*t11*t13*t14*in_x3*in_x6*in_x7*in_x11*in_x16*in_x20*in_x21*2.0-t9*t11*t13*t14*in_x3*in_x6*in_x7*in_x11*in_x18*in_x19*in_x20*2.0+t9*t11*t13*t14*in_x3*in_x6*in_x7*in_x12*in_x17*in_x19*in_x20*2.0-t5*t6*t13*t14*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24+t5*t6*t13*t14*in_x3*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23-t5*t6*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24+t5*t6*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23-t5*t6*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23+t5*t6*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22-t5*t6*t13*t14*in_x3*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23+t5*t6*t13*t14*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t7*t8*t9*t12*in_x6*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27-t7*t8*t9*t12*in_x6*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26+t7*t8*t9*t12*in_x6*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27+t7*t8*t9*t12*in_x6*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26-t7*t8*t9*t12*in_x6*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26-t7*t8*t9*t12*in_x6*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25+t7*t8*t9*t12*in_x6*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26+t7*t8*t9*t12*in_x6*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25-t9*t10*t14*t15*in_x2*in_x3*in_x5*in_x10*in_x14*in_x23*in_x27+t9*t10*t14*t15*in_x2*in_x3*in_x5*in_x10*in_x14*in_x24*in_x26+t9*t10*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x13*in_x23*in_x27-t9*t10*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x13*in_x24*in_x26+t9*t10*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x15*in_x22*in_x26-t9*t10*t14*t15*in_x2*in_x3*in_x5*in_x11*in_x15*in_x23*in_x25-t9*t10*t14*t15*in_x2*in_x3*in_x5*in_x12*in_x14*in_x22*in_x26+t9*t10*t14*t15*in_x2*in_x3*in_x5*in_x12*in_x14*in_x23*in_x25+t4*t6*t13*t14*in_x6*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27-t4*t6*t13*t14*in_x6*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26-t4*t6*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27+t4*t6*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26-t4*t6*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26+t4*t6*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25+t4*t6*t13*t14*in_x6*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26-t4*t6*t13*t14*in_x6*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25-t6*t8*t12*t15*in_x2*in_x6*in_x7*in_x13*in_x17*in_x23*in_x24*2.0+t6*t8*t12*t15*in_x2*in_x6*in_x7*in_x14*in_x16*in_x23*in_x24*2.0-t6*t8*t12*t15*in_x2*in_x6*in_x7*in_x14*in_x18*in_x22*in_x23*2.0+t6*t8*t12*t15*in_x2*in_x6*in_x7*in_x15*in_x17*in_x22*in_x23*2.0+t7*t9*t14*t15*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x27+t7*t9*t14*t15*in_x4*in_x6*in_x7*in_x10*in_x14*in_x21*in_x26-t7*t9*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x27-t7*t9*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x13*in_x21*in_x26+t7*t9*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x15*in_x19*in_x26+t7*t9*t14*t15*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x25-t7*t9*t14*t15*in_x4*in_x6*in_x7*in_x12*in_x14*in_x19*in_x26-t7*t9*t14*t15*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x25-t8*t9*t10*t12*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24+t8*t9*t10*t12*in_x3*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23+t8*t9*t10*t12*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24-t8*t9*t10*t12*in_x3*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23+t8*t9*t10*t12*in_x3*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23-t8*t9*t10*t12*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22-t8*t9*t10*t12*in_x3*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23+t8*t9*t10*t12*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22+t6*t11*t12*t13*in_x2*in_x6*in_x7*in_x13*in_x17*in_x23*in_x24*2.0-t6*t11*t12*t13*in_x2*in_x6*in_x7*in_x14*in_x16*in_x23*in_x24*2.0+t6*t11*t12*t13*in_x2*in_x6*in_x7*in_x14*in_x18*in_x22*in_x23*2.0-t6*t11*t12*t13*in_x2*in_x6*in_x7*in_x15*in_x17*in_x22*in_x23*2.0+t7*t8*t9*t12*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24-t7*t8*t9*t12*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23-t7*t8*t9*t12*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24+t7*t8*t9*t12*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23-t7*t8*t9*t12*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23+t7*t8*t9*t12*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22+t7*t8*t9*t12*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23-t7*t8*t9*t12*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t8*t9*t12*t15*in_x3*in_x6*in_x7*in_x10*in_x17*in_x23*in_x24*2.0+t8*t9*t12*t15*in_x3*in_x6*in_x7*in_x11*in_x16*in_x23*in_x24*2.0-t8*t9*t12*t15*in_x3*in_x6*in_x7*in_x11*in_x18*in_x22*in_x23*2.0+t8*t9*t12*t15*in_x3*in_x6*in_x7*in_x12*in_x17*in_x22*in_x23*2.0+t9*t10*t13*t14*in_x2*in_x3*in_x9*in_x10*in_x14*in_x23*in_x27-t9*t10*t13*t14*in_x2*in_x3*in_x9*in_x10*in_x14*in_x24*in_x26-t9*t10*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x13*in_x23*in_x27+t9*t10*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x13*in_x24*in_x26-t9*t10*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x15*in_x22*in_x26+t9*t10*t13*t14*in_x2*in_x3*in_x9*in_x11*in_x15*in_x23*in_x25+t9*t10*t13*t14*in_x2*in_x3*in_x9*in_x12*in_x14*in_x22*in_x26-t9*t10*t13*t14*in_x2*in_x3*in_x9*in_x12*in_x14*in_x23*in_x25-t9*t10*t14*t15*in_x3*in_x4*in_x5*in_x13*in_x17*in_x20*in_x24+t9*t10*t14*t15*in_x3*in_x4*in_x5*in_x13*in_x17*in_x21*in_x23+t9*t10*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x16*in_x20*in_x24-t9*t10*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x16*in_x21*in_x23+t9*t10*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x18*in_x19*in_x23-t9*t10*t14*t15*in_x3*in_x4*in_x5*in_x14*in_x18*in_x20*in_x22-t9*t10*t14*t15*in_x3*in_x4*in_x5*in_x15*in_x17*in_x19*in_x23+t9*t10*t14*t15*in_x3*in_x4*in_x5*in_x15*in_x17*in_x20*in_x22+t4*t6*t13*t14*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24-t4*t6*t13*t14*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23+t4*t6*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24-t4*t6*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23+t4*t6*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23-t4*t6*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22+t4*t6*t13*t14*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23-t4*t6*t13*t14*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t7*t9*t13*t14*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x27-t7*t9*t13*t14*in_x6*in_x7*in_x8*in_x10*in_x14*in_x21*in_x26+t7*t9*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x27+t7*t9*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x13*in_x21*in_x26-t7*t9*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x15*in_x19*in_x26-t7*t9*t13*t14*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x25+t7*t9*t13*t14*in_x6*in_x7*in_x8*in_x12*in_x14*in_x19*in_x26+t7*t9*t13*t14*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x25+t7*t9*t14*t15*in_x4*in_x5*in_x7*in_x13*in_x17*in_x20*in_x24-t7*t9*t14*t15*in_x4*in_x5*in_x7*in_x13*in_x17*in_x21*in_x23-t7*t9*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x16*in_x20*in_x24+t7*t9*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x16*in_x21*in_x23-t7*t9*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x18*in_x19*in_x23+t7*t9*t14*t15*in_x4*in_x5*in_x7*in_x14*in_x18*in_x20*in_x22+t7*t9*t14*t15*in_x4*in_x5*in_x7*in_x15*in_x17*in_x19*in_x23-t7*t9*t14*t15*in_x4*in_x5*in_x7*in_x15*in_x17*in_x20*in_x22+t9*t11*t12*t13*in_x3*in_x6*in_x7*in_x10*in_x17*in_x23*in_x24*2.0-t9*t11*t12*t13*in_x3*in_x6*in_x7*in_x11*in_x16*in_x23*in_x24*2.0+t9*t11*t12*t13*in_x3*in_x6*in_x7*in_x11*in_x18*in_x22*in_x23*2.0-t9*t11*t12*t13*in_x3*in_x6*in_x7*in_x12*in_x17*in_x22*in_x23*2.0-t9*t10*t13*t14*in_x2*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24+t9*t10*t13*t14*in_x2*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23-t9*t10*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24+t9*t10*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23-t9*t10*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23+t9*t10*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22-t9*t10*t13*t14*in_x2*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23+t9*t10*t13*t14*in_x2*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t7*t9*t13*t14*in_x6*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24-t7*t9*t13*t14*in_x6*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23+t7*t9*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24-t7*t9*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23+t7*t9*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23-t7*t9*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22+t7*t9*t13*t14*in_x6*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23-t7*t9*t13*t14*in_x6*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22+t7*t9*t14*t15*in_x5*in_x6*in_x7*in_x10*in_x14*in_x23*in_x27-t7*t9*t14*t15*in_x5*in_x6*in_x7*in_x10*in_x14*in_x24*in_x26-t7*t9*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x13*in_x23*in_x27+t7*t9*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x13*in_x24*in_x26-t7*t9*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x15*in_x22*in_x26+t7*t9*t14*t15*in_x5*in_x6*in_x7*in_x11*in_x15*in_x23*in_x25+t7*t9*t14*t15*in_x5*in_x6*in_x7*in_x12*in_x14*in_x22*in_x26-t7*t9*t14*t15*in_x5*in_x6*in_x7*in_x12*in_x14*in_x23*in_x25+t5*t8*t14*t15*in_x3*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*2.0-t5*t8*t14*t15*in_x3*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*2.0-t5*t11*t13*t14*in_x3*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*2.0+t5*t11*t13*t14*in_x3*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*2.0-t7*t9*t13*t14*in_x6*in_x7*in_x9*in_x10*in_x14*in_x23*in_x27+t7*t9*t13*t14*in_x6*in_x7*in_x9*in_x10*in_x14*in_x24*in_x26+t7*t9*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x13*in_x23*in_x27-t7*t9*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x13*in_x24*in_x26+t7*t9*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x15*in_x22*in_x26-t7*t9*t13*t14*in_x6*in_x7*in_x9*in_x11*in_x15*in_x23*in_x25-t7*t9*t13*t14*in_x6*in_x7*in_x9*in_x12*in_x14*in_x22*in_x26+t7*t9*t13*t14*in_x6*in_x7*in_x9*in_x12*in_x14*in_x23*in_x25+t9*t10*t13*t14*in_x3*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24-t9*t10*t13*t14*in_x3*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23-t9*t10*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24+t9*t10*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23-t9*t10*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23+t9*t10*t13*t14*in_x3*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22+t9*t10*t13*t14*in_x3*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23-t9*t10*t13*t14*in_x3*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22-t4*t8*t14*t15*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*2.0+t4*t8*t14*t15*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*2.0-t7*t9*t13*t14*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24+t7*t9*t13*t14*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23+t7*t9*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24-t7*t9*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23+t7*t9*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23-t7*t9*t13*t14*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22-t7*t9*t13*t14*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23+t7*t9*t13*t14*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22+t4*t11*t13*t14*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x21*2.0-t4*t11*t13*t14*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x20*2.0-t5*t8*t12*t15*in_x3*in_x10*in_x11*in_x14*in_x17*in_x23*in_x24*2.0+t5*t8*t12*t15*in_x3*in_x11*in_x12*in_x14*in_x17*in_x22*in_x23*2.0+t5*t11*t12*t13*in_x3*in_x10*in_x11*in_x14*in_x17*in_x23*in_x24*2.0-t5*t11*t12*t13*in_x3*in_x11*in_x12*in_x14*in_x17*in_x22*in_x23*2.0+t4*t8*t12*t15*in_x7*in_x10*in_x11*in_x14*in_x17*in_x23*in_x24*2.0-t4*t8*t12*t15*in_x7*in_x11*in_x12*in_x14*in_x17*in_x22*in_x23*2.0+t8*t10*t14*t15*in_x2*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*2.0-t8*t10*t14*t15*in_x2*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*2.0-t4*t11*t12*t13*in_x7*in_x10*in_x11*in_x14*in_x17*in_x23*in_x24*2.0+t4*t11*t12*t13*in_x7*in_x11*in_x12*in_x14*in_x17*in_x22*in_x23*2.0-t7*t8*t14*t15*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*2.0+t7*t8*t14*t15*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*2.0-t10*t11*t13*t14*in_x2*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*2.0+t10*t11*t13*t14*in_x2*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*2.0+t7*t11*t13*t14*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x21*2.0-t7*t11*t13*t14*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x20*2.0-t5*t7*t9*t11*in_x5*in_x10*in_x11*in_x20*in_x21*in_x23*in_x26*2.0+t5*t7*t9*t11*in_x5*in_x11*in_x12*in_x19*in_x20*in_x23*in_x26*2.0+t5*t7*t8*t9*in_x9*in_x10*in_x11*in_x20*in_x21*in_x23*in_x26*2.0-t5*t7*t8*t9*in_x9*in_x11*in_x12*in_x19*in_x20*in_x23*in_x26*2.0-t8*t10*t12*t15*in_x2*in_x11*in_x13*in_x14*in_x17*in_x23*in_x24*2.0+t8*t10*t12*t15*in_x2*in_x11*in_x14*in_x15*in_x17*in_x22*in_x23*2.0+t4*t9*t10*t11*in_x5*in_x10*in_x11*in_x20*in_x21*in_x23*in_x26*2.0-t4*t9*t10*t11*in_x5*in_x11*in_x12*in_x19*in_x20*in_x23*in_x26*2.0+t7*t8*t12*t15*in_x6*in_x11*in_x13*in_x14*in_x17*in_x23*in_x24*2.0-t7*t8*t12*t15*in_x6*in_x11*in_x14*in_x15*in_x17*in_x22*in_x23*2.0+t10*t11*t12*t13*in_x2*in_x11*in_x13*in_x14*in_x17*in_x23*in_x24*2.0-t10*t11*t12*t13*in_x2*in_x11*in_x14*in_x15*in_x17*in_x22*in_x23*2.0-t4*t8*t9*t10*in_x9*in_x10*in_x11*in_x20*in_x21*in_x23*in_x26*2.0+t4*t8*t9*t10*in_x9*in_x11*in_x12*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t7*t11*in_x5*in_x13*in_x14*in_x20*in_x21*in_x23*in_x26*2.0-t5*t6*t7*t11*in_x5*in_x14*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t7*t11*t12*t13*in_x6*in_x11*in_x13*in_x14*in_x17*in_x23*in_x24*2.0+t7*t11*t12*t13*in_x6*in_x11*in_x14*in_x15*in_x17*in_x22*in_x23*2.0-t5*t6*t7*t8*in_x9*in_x13*in_x14*in_x20*in_x21*in_x23*in_x26*2.0+t5*t6*t7*t8*in_x9*in_x14*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t4*t6*t10*t11*in_x5*in_x13*in_x14*in_x20*in_x21*in_x23*in_x26*2.0+t4*t6*t10*t11*in_x5*in_x14*in_x15*in_x19*in_x20*in_x23*in_x26*2.0+t4*t6*t8*t10*in_x9*in_x13*in_x14*in_x20*in_x21*in_x23*in_x26*2.0-t4*t6*t8*t10*in_x9*in_x14*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t5*t7*t9*t15*in_x4*in_x10*in_x11*in_x20*in_x23*in_x24*in_x26*2.0+t5*t7*t9*t15*in_x4*in_x11*in_x12*in_x20*in_x22*in_x23*in_x26*2.0+t4*t9*t10*t15*in_x4*in_x10*in_x11*in_x20*in_x23*in_x24*in_x26*2.0-t4*t9*t10*t15*in_x4*in_x11*in_x12*in_x20*in_x22*in_x23*in_x26*2.0+t5*t7*t9*t13*in_x8*in_x10*in_x11*in_x20*in_x23*in_x24*in_x26*2.0-t5*t7*t9*t13*in_x8*in_x11*in_x12*in_x20*in_x22*in_x23*in_x26*2.0+t5*t6*t7*t15*in_x4*in_x13*in_x14*in_x20*in_x23*in_x24*in_x26*2.0-t5*t6*t7*t15*in_x4*in_x14*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t4*t9*t10*t13*in_x8*in_x10*in_x11*in_x20*in_x23*in_x24*in_x26*2.0+t4*t9*t10*t13*in_x8*in_x11*in_x12*in_x20*in_x22*in_x23*in_x26*2.0-t4*t6*t10*t15*in_x4*in_x13*in_x14*in_x20*in_x23*in_x24*in_x26*2.0+t4*t6*t10*t15*in_x4*in_x14*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t5*t6*t7*t13*in_x8*in_x13*in_x14*in_x20*in_x23*in_x24*in_x26*2.0+t5*t6*t7*t13*in_x8*in_x14*in_x15*in_x20*in_x22*in_x23*in_x26*2.0+t4*t6*t10*t13*in_x8*in_x13*in_x14*in_x20*in_x23*in_x24*in_x26*2.0-t4*t6*t10*t13*in_x8*in_x14*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t5*t6*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x10*in_x14*in_x23*in_x27*2.0+t5*t6*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x10*in_x14*in_x24*in_x26*2.0+t5*t6*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x13*in_x23*in_x27*2.0-t5*t6*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x13*in_x24*in_x26*2.0+t5*t6*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x15*in_x22*in_x26*2.0-t5*t6*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x15*in_x23*in_x25*2.0-t5*t6*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x12*in_x14*in_x22*in_x26*2.0+t5*t6*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x12*in_x14*in_x23*in_x25*2.0-t5*t6*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x10*in_x14*in_x20*in_x27*2.0+t5*t6*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x10*in_x14*in_x21*in_x26*2.0+t5*t6*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x13*in_x20*in_x27*2.0-t5*t6*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x13*in_x21*in_x26*2.0+t5*t6*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x15*in_x19*in_x26*2.0-t5*t6*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x15*in_x20*in_x25*2.0-t5*t6*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x12*in_x14*in_x19*in_x26*2.0+t5*t6*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x12*in_x14*in_x20*in_x25*2.0+t5*t6*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x10*in_x14*in_x23*in_x27*2.0-t5*t6*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x10*in_x14*in_x24*in_x26*2.0-t5*t6*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x13*in_x23*in_x27*2.0+t5*t6*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x13*in_x24*in_x26*2.0-t5*t6*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x15*in_x22*in_x26*2.0+t5*t6*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x15*in_x23*in_x25*2.0+t5*t6*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x12*in_x14*in_x22*in_x26*2.0-t5*t6*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x12*in_x14*in_x23*in_x25*2.0+t5*t6*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x10*in_x14*in_x20*in_x27*2.0-t5*t6*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x10*in_x14*in_x21*in_x26*2.0-t5*t6*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x13*in_x20*in_x27*2.0+t5*t6*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x13*in_x21*in_x26*2.0-t5*t6*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x15*in_x19*in_x26*2.0+t5*t6*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x15*in_x20*in_x25*2.0+t5*t6*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x12*in_x14*in_x19*in_x26*2.0-t5*t6*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x12*in_x14*in_x20*in_x25*2.0-t6*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x13*in_x17*in_x20*in_x24*2.0+t6*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x13*in_x17*in_x21*in_x23*2.0+t6*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x16*in_x20*in_x24*2.0-t6*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x16*in_x21*in_x23*2.0+t6*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x18*in_x19*in_x23*2.0-t6*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x18*in_x20*in_x22*2.0-t6*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x15*in_x17*in_x19*in_x23*2.0+t6*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x6*in_x15*in_x17*in_x20*in_x22*2.0-t9*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x10*in_x17*in_x20*in_x24*2.0+t9*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x10*in_x17*in_x21*in_x23*2.0+t9*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x16*in_x20*in_x24*2.0-t9*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x16*in_x21*in_x23*2.0+t9*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x18*in_x19*in_x23*2.0-t9*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x18*in_x20*in_x22*2.0-t9*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x12*in_x17*in_x19*in_x23*2.0+t9*t11*t12*in_x2*in_x3*in_x4*in_x5*in_x7*in_x12*in_x17*in_x20*in_x22*2.0+t4*t6*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x23*in_x27*2.0-t4*t6*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x24*in_x26*2.0-t4*t6*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x23*in_x27*2.0+t4*t6*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x24*in_x26*2.0-t4*t6*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x22*in_x26*2.0+t4*t6*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x23*in_x25*2.0+t4*t6*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x22*in_x26*2.0-t4*t6*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x23*in_x25*2.0+t4*t6*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x10*in_x14*in_x20*in_x27*2.0-t4*t6*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x10*in_x14*in_x21*in_x26*2.0-t4*t6*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x13*in_x20*in_x27*2.0+t4*t6*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x13*in_x21*in_x26*2.0-t4*t6*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x15*in_x19*in_x26*2.0+t4*t6*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x15*in_x20*in_x25*2.0+t4*t6*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x12*in_x14*in_x19*in_x26*2.0-t4*t6*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x12*in_x14*in_x20*in_x25*2.0+t6*t11*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x13*in_x17*in_x20*in_x24*2.0-t6*t11*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x13*in_x17*in_x21*in_x23*2.0-t6*t11*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x16*in_x20*in_x24*2.0+t6*t11*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x16*in_x21*in_x23*2.0-t6*t11*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x18*in_x19*in_x23*2.0+t6*t11*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x18*in_x20*in_x22*2.0+t6*t11*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x15*in_x17*in_x19*in_x23*2.0-t6*t11*t12*in_x2*in_x4*in_x5*in_x6*in_x7*in_x15*in_x17*in_x20*in_x22*2.0+t9*t10*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x10*in_x14*in_x23*in_x27*2.0-t9*t10*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x10*in_x14*in_x24*in_x26*2.0-t9*t10*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x13*in_x23*in_x27*2.0+t9*t10*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x13*in_x24*in_x26*2.0-t9*t10*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x15*in_x22*in_x26*2.0+t9*t10*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x11*in_x15*in_x23*in_x25*2.0+t9*t10*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x12*in_x14*in_x22*in_x26*2.0-t9*t10*t12*in_x2*in_x3*in_x4*in_x5*in_x8*in_x12*in_x14*in_x23*in_x25*2.0+t9*t10*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x10*in_x14*in_x20*in_x27*2.0-t9*t10*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x10*in_x14*in_x21*in_x26*2.0-t9*t10*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x13*in_x20*in_x27*2.0+t9*t10*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x13*in_x21*in_x26*2.0-t9*t10*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x15*in_x19*in_x26*2.0+t9*t10*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x11*in_x15*in_x20*in_x25*2.0+t9*t10*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x12*in_x14*in_x19*in_x26*2.0-t9*t10*t14*in_x2*in_x3*in_x4*in_x5*in_x9*in_x12*in_x14*in_x20*in_x25*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22*2.0+t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23*2.0-t6*t8*t12*in_x2*in_x3*in_x6*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22*2.0+t9*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x10*in_x17*in_x20*in_x24*2.0-t9*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x10*in_x17*in_x21*in_x23*2.0-t9*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x16*in_x20*in_x24*2.0+t9*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x16*in_x21*in_x23*2.0-t9*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x18*in_x19*in_x23*2.0+t9*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x18*in_x20*in_x22*2.0+t9*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x12*in_x17*in_x19*in_x23*2.0-t9*t11*t12*in_x3*in_x4*in_x5*in_x6*in_x7*in_x12*in_x17*in_x20*in_x22*2.0+t6*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x6*in_x13*in_x17*in_x20*in_x24*2.0-t6*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x6*in_x13*in_x17*in_x21*in_x23*2.0-t6*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x16*in_x20*in_x24*2.0+t6*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x16*in_x21*in_x23*2.0-t6*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x18*in_x19*in_x23*2.0+t6*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x6*in_x14*in_x18*in_x20*in_x22*2.0+t6*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x6*in_x15*in_x17*in_x19*in_x23*2.0-t6*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x6*in_x15*in_x17*in_x20*in_x22*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22*2.0+t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23*2.0-t8*t9*t12*in_x2*in_x3*in_x7*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22*2.0-t4*t6*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x23*in_x27*2.0+t4*t6*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x24*in_x26*2.0+t4*t6*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x23*in_x27*2.0-t4*t6*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x24*in_x26*2.0+t4*t6*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x22*in_x26*2.0-t4*t6*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x23*in_x25*2.0-t4*t6*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x22*in_x26*2.0+t4*t6*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x23*in_x25*2.0-t4*t6*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x27*2.0+t4*t6*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x26*2.0+t4*t6*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x27*2.0-t4*t6*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x26*2.0+t4*t6*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x26*2.0-t4*t6*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x25*2.0-t4*t6*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x26*2.0+t4*t6*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x25*2.0+t9*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x7*in_x10*in_x17*in_x20*in_x24*2.0-t9*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x7*in_x10*in_x17*in_x21*in_x23*2.0-t9*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x16*in_x20*in_x24*2.0+t9*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x16*in_x21*in_x23*2.0-t9*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x18*in_x19*in_x23*2.0+t9*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x7*in_x11*in_x18*in_x20*in_x22*2.0+t9*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x7*in_x12*in_x17*in_x19*in_x23*2.0-t9*t14*t15*in_x2*in_x3*in_x4*in_x5*in_x7*in_x12*in_x17*in_x20*in_x22*2.0-t9*t10*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x10*in_x14*in_x23*in_x27*2.0+t9*t10*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x10*in_x14*in_x24*in_x26*2.0+t9*t10*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x13*in_x23*in_x27*2.0-t9*t10*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x13*in_x24*in_x26*2.0+t9*t10*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x15*in_x22*in_x26*2.0-t9*t10*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x11*in_x15*in_x23*in_x25*2.0-t9*t10*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x12*in_x14*in_x22*in_x26*2.0+t9*t10*t12*in_x2*in_x3*in_x4*in_x8*in_x9*in_x12*in_x14*in_x23*in_x25*2.0-t9*t10*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x10*in_x14*in_x20*in_x27*2.0+t9*t10*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x10*in_x14*in_x21*in_x26*2.0+t9*t10*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x13*in_x20*in_x27*2.0-t9*t10*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x13*in_x21*in_x26*2.0+t9*t10*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x15*in_x19*in_x26*2.0-t9*t10*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x11*in_x15*in_x20*in_x25*2.0-t9*t10*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x12*in_x14*in_x19*in_x26*2.0+t9*t10*t14*in_x2*in_x3*in_x5*in_x8*in_x9*in_x12*in_x14*in_x20*in_x25*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22*2.0-t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23*2.0+t6*t8*t12*in_x2*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22*2.0-t7*t9*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x23*in_x27*2.0+t7*t9*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x10*in_x14*in_x24*in_x26*2.0+t7*t9*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x23*in_x27*2.0-t7*t9*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x13*in_x24*in_x26*2.0+t7*t9*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x22*in_x26*2.0-t7*t9*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x11*in_x15*in_x23*in_x25*2.0-t7*t9*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x22*in_x26*2.0+t7*t9*t12*in_x4*in_x5*in_x6*in_x7*in_x8*in_x12*in_x14*in_x23*in_x25*2.0-t7*t9*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x10*in_x14*in_x20*in_x27*2.0+t7*t9*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x10*in_x14*in_x21*in_x26*2.0+t7*t9*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x13*in_x20*in_x27*2.0-t7*t9*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x13*in_x21*in_x26*2.0+t7*t9*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x15*in_x19*in_x26*2.0-t7*t9*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x11*in_x15*in_x20*in_x25*2.0-t7*t9*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x12*in_x14*in_x19*in_x26*2.0+t7*t9*t14*in_x4*in_x5*in_x6*in_x7*in_x9*in_x12*in_x14*in_x20*in_x25*2.0-t6*t14*t15*in_x2*in_x4*in_x5*in_x6*in_x7*in_x13*in_x17*in_x20*in_x24*2.0+t6*t14*t15*in_x2*in_x4*in_x5*in_x6*in_x7*in_x13*in_x17*in_x21*in_x23*2.0+t6*t14*t15*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x16*in_x20*in_x24*2.0-t6*t14*t15*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x16*in_x21*in_x23*2.0+t6*t14*t15*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x18*in_x19*in_x23*2.0-t6*t14*t15*in_x2*in_x4*in_x5*in_x6*in_x7*in_x14*in_x18*in_x20*in_x22*2.0-t6*t14*t15*in_x2*in_x4*in_x5*in_x6*in_x7*in_x15*in_x17*in_x19*in_x23*2.0+t6*t14*t15*in_x2*in_x4*in_x5*in_x6*in_x7*in_x15*in_x17*in_x20*in_x22*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22*2.0-t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23*2.0+t8*t9*t12*in_x3*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22*2.0-t9*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x7*in_x10*in_x17*in_x20*in_x24*2.0+t9*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x7*in_x10*in_x17*in_x21*in_x23*2.0+t9*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x16*in_x20*in_x24*2.0-t9*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x16*in_x21*in_x23*2.0+t9*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x18*in_x19*in_x23*2.0-t9*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x7*in_x11*in_x18*in_x20*in_x22*2.0-t9*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x7*in_x12*in_x17*in_x19*in_x23*2.0+t9*t14*t15*in_x3*in_x4*in_x5*in_x6*in_x7*in_x12*in_x17*in_x20*in_x22*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22*2.0-t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23*2.0+t6*t13*t14*in_x2*in_x3*in_x6*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22*2.0+t5*t11*t12*in_x3*in_x4*in_x5*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0-t5*t11*t12*in_x3*in_x4*in_x5*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0+t5*t11*t12*in_x3*in_x4*in_x5*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0-t5*t11*t12*in_x3*in_x4*in_x5*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0+t7*t9*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x23*in_x27*2.0-t7*t9*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x24*in_x26*2.0-t7*t9*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x23*in_x27*2.0+t7*t9*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x24*in_x26*2.0-t7*t9*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x22*in_x26*2.0+t7*t9*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x23*in_x25*2.0+t7*t9*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x22*in_x26*2.0-t7*t9*t12*in_x4*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x23*in_x25*2.0+t7*t9*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x20*in_x27*2.0-t7*t9*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x10*in_x14*in_x21*in_x26*2.0-t7*t9*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x20*in_x27*2.0+t7*t9*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x13*in_x21*in_x26*2.0-t7*t9*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x19*in_x26*2.0+t7*t9*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x11*in_x15*in_x20*in_x25*2.0+t7*t9*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x19*in_x26*2.0-t7*t9*t14*in_x5*in_x6*in_x7*in_x8*in_x9*in_x12*in_x14*in_x20*in_x25*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22*2.0-t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23*2.0+t9*t13*t14*in_x2*in_x3*in_x7*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22*2.0-t4*t11*t12*in_x4*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0+t4*t11*t12*in_x4*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0-t4*t11*t12*in_x4*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0+t4*t11*t12*in_x4*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x20*in_x24*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x9*in_x13*in_x17*in_x21*in_x23*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x20*in_x24*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x16*in_x21*in_x23*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x19*in_x23*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x9*in_x14*in_x18*in_x20*in_x22*2.0+t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x19*in_x23*2.0-t6*t13*t14*in_x2*in_x6*in_x7*in_x8*in_x9*in_x15*in_x17*in_x20*in_x22*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x20*in_x24*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x9*in_x10*in_x17*in_x21*in_x23*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x20*in_x24*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x16*in_x21*in_x23*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x19*in_x23*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x9*in_x11*in_x18*in_x20*in_x22*2.0+t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x19*in_x23*2.0-t9*t13*t14*in_x3*in_x6*in_x7*in_x8*in_x9*in_x12*in_x17*in_x20*in_x22*2.0-t5*t8*t12*in_x3*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0+t5*t8*t12*in_x3*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0-t5*t8*t12*in_x3*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0+t5*t8*t12*in_x3*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0-t5*t14*t15*in_x3*in_x4*in_x5*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0+t5*t14*t15*in_x3*in_x4*in_x5*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0-t5*t14*t15*in_x3*in_x4*in_x5*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0+t5*t14*t15*in_x3*in_x4*in_x5*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0+t10*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0-t10*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0+t10*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0-t10*t11*t12*in_x2*in_x4*in_x5*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0+t4*t8*t12*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0-t4*t8*t12*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0+t4*t8*t12*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0-t4*t8*t12*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0-t7*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0+t7*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0-t7*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0+t7*t11*t12*in_x4*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0+t4*t14*t15*in_x4*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0-t4*t14*t15*in_x4*in_x5*in_x7*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0+t4*t14*t15*in_x4*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0-t4*t14*t15*in_x4*in_x5*in_x7*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0-t5*t6*t11*in_x2*in_x3*in_x5*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0+t5*t6*t11*in_x2*in_x3*in_x5*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0-t5*t6*t11*in_x2*in_x3*in_x5*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t11*in_x2*in_x3*in_x5*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t8*in_x2*in_x3*in_x9*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0-t5*t6*t8*in_x2*in_x3*in_x9*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0+t5*t6*t8*in_x2*in_x3*in_x9*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t5*t6*t8*in_x2*in_x3*in_x9*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0+t5*t13*t14*in_x3*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0-t5*t13*t14*in_x3*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0+t5*t13*t14*in_x3*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0-t5*t13*t14*in_x3*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0-t8*t10*t12*in_x2*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0+t8*t10*t12*in_x2*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0-t8*t10*t12*in_x2*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0+t8*t10*t12*in_x2*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0+t7*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0-t7*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0+t7*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0-t7*t8*t12*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0-t10*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0+t10*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0-t10*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0+t10*t14*t15*in_x2*in_x4*in_x5*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0+t7*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0-t7*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0+t7*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0-t7*t14*t15*in_x4*in_x5*in_x6*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0-t4*t13*t14*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x20*in_x24*2.0+t4*t13*t14*in_x7*in_x8*in_x9*in_x10*in_x11*in_x14*in_x17*in_x21*in_x23*2.0-t4*t13*t14*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x19*in_x23*2.0+t4*t13*t14*in_x7*in_x8*in_x9*in_x11*in_x12*in_x14*in_x17*in_x20*in_x22*2.0-t5*t6*t15*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0+t5*t6*t15*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0-t5*t6*t15*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0+t5*t6*t15*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0+t4*t6*t11*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0-t4*t6*t11*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0+t4*t6*t11*in_x5*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t4*t6*t11*in_x5*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0-t4*t6*t8*in_x6*in_x7*in_x9*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0+t4*t6*t8*in_x6*in_x7*in_x9*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0-t4*t6*t8*in_x6*in_x7*in_x9*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0+t4*t6*t8*in_x6*in_x7*in_x9*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0+t5*t6*t13*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0-t5*t6*t13*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0+t5*t6*t13*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t5*t6*t13*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0+t9*t10*t11*in_x2*in_x3*in_x5*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0-t9*t10*t11*in_x2*in_x3*in_x5*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0+t9*t10*t11*in_x2*in_x3*in_x5*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t9*t10*t11*in_x2*in_x3*in_x5*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0-t8*t9*t10*in_x2*in_x3*in_x9*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0+t8*t9*t10*in_x2*in_x3*in_x9*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0-t8*t9*t10*in_x2*in_x3*in_x9*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0+t8*t9*t10*in_x2*in_x3*in_x9*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0+t10*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0-t10*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0+t10*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0-t10*t13*t14*in_x2*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0-t7*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x20*in_x24*2.0+t7*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x13*in_x14*in_x17*in_x21*in_x23*2.0-t7*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x19*in_x23*2.0+t7*t13*t14*in_x6*in_x8*in_x9*in_x11*in_x14*in_x15*in_x17*in_x20*in_x22*2.0+t4*t6*t15*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0-t4*t6*t15*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0+t4*t6*t15*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t4*t6*t15*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0-t7*t9*t11*in_x5*in_x6*in_x7*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0+t7*t9*t11*in_x5*in_x6*in_x7*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0-t7*t9*t11*in_x5*in_x6*in_x7*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0+t7*t9*t11*in_x5*in_x6*in_x7*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0+t7*t8*t9*in_x6*in_x7*in_x9*in_x10*in_x14*in_x20*in_x21*in_x23*in_x26*2.0-t7*t8*t9*in_x6*in_x7*in_x9*in_x11*in_x13*in_x20*in_x21*in_x23*in_x26*2.0+t7*t8*t9*in_x6*in_x7*in_x9*in_x11*in_x15*in_x19*in_x20*in_x23*in_x26*2.0-t7*t8*t9*in_x6*in_x7*in_x9*in_x12*in_x14*in_x19*in_x20*in_x23*in_x26*2.0+t9*t10*t15*in_x2*in_x3*in_x4*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0-t9*t10*t15*in_x2*in_x3*in_x4*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0+t9*t10*t15*in_x2*in_x3*in_x4*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t9*t10*t15*in_x2*in_x3*in_x4*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0-t4*t6*t13*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0+t4*t6*t13*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0-t4*t6*t13*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0+t4*t6*t13*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0-t9*t10*t13*in_x2*in_x3*in_x8*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0+t9*t10*t13*in_x2*in_x3*in_x8*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0-t9*t10*t13*in_x2*in_x3*in_x8*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0+t9*t10*t13*in_x2*in_x3*in_x8*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0-t7*t9*t15*in_x4*in_x6*in_x7*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0+t7*t9*t15*in_x4*in_x6*in_x7*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0-t7*t9*t15*in_x4*in_x6*in_x7*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0+t7*t9*t15*in_x4*in_x6*in_x7*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0+t7*t9*t13*in_x6*in_x7*in_x8*in_x10*in_x14*in_x20*in_x23*in_x24*in_x26*2.0-t7*t9*t13*in_x6*in_x7*in_x8*in_x11*in_x13*in_x20*in_x23*in_x24*in_x26*2.0+t7*t9*t13*in_x6*in_x7*in_x8*in_x11*in_x15*in_x20*in_x22*in_x23*in_x26*2.0-t7*t9*t13*in_x6*in_x7*in_x8*in_x12*in_x14*in_x20*in_x22*in_x23*in_x26*2.0;  // NOLINT
        coeffs[6] = (in_x2*in_x7-in_x3*in_x6)*(in_x4*in_x9-in_x5*in_x8)*(in_x2*in_x11+in_x3*in_x14)*(in_x6*in_x11+in_x7*in_x14)*(in_x4*in_x20+in_x5*in_x23)*(in_x8*in_x20+in_x9*in_x23)*(in_x10*in_x14*in_x20*in_x24-in_x10*in_x14*in_x21*in_x23-in_x11*in_x13*in_x20*in_x24+in_x11*in_x13*in_x21*in_x23-in_x11*in_x15*in_x19*in_x23+in_x11*in_x15*in_x20*in_x22+in_x12*in_x14*in_x19*in_x23-in_x12*in_x14*in_x20*in_x22); // NOLINT

        return coeffs;
    }
}  // namespace HomLib::ValtonenOrnhagArxiv2020B
