% Script to compile and link C++ source file to MATLAB compatible MEX binary.
solver_types = {%'get_fitzgibbon_cvpr_2001', ...
                %'get_kukelova_cvpr_2015', ...
                %'get_valtonenornhag_arxiv_2020a_fHf', ...
                %'get_valtonenornhag_arxiv_2020b_fHf', ...
                'get_valtonenornhag_arxiv_2020b_frHfr'};

path_to_eigen = '/usr/include/eigen3';
cpp_flags = '-O';
outputdir = 'solvers';

if ~exist(outputdir, 'dir')
	mkdir(outputdir)
end

for j = 1:length(solver_types)
    solver_type = solver_types{j};

    switch solver_type
	    case 'get_fitzgibbon_cvpr_2001'
            mex(['-I', path_to_eigen], ...
                '-I../includes/HomLib', ...
                '-I../src/helpers', ...
                '-I../src/solvers/fitzgibbon_cvpr_2001', ...
                'src/get_fitzgibbon_cvpr_2001_mex.cpp', ...
                '../src/solvers/fitzgibbon_cvpr_2001/get_fitzgibbon_cvpr_2001.cpp', ...
                '../src/helpers/radial.cpp', ...
                cpp_flags, '-outdir', outputdir)
        case 'get_kukelova_cvpr_2015'
            mex(['-I', path_to_eigen], ...
                '-I../includes/HomLib', ...
                '-I../src/helpers', ...
                '-I../src/solvers/kukelova_cvpr_2015', ...
                'src/get_kukelova_cvpr_2015_mex.cpp', ...
                '../src/solvers/kukelova_cvpr_2015/get_kukelova_cvpr_2015.cpp', ...
                '../src/solvers/kukelova_cvpr_2015/solver_kukelova_cvpr_2015.cpp', ...
                '../src/helpers/normalize2dpts.cpp', ...
                '../src/helpers/gj.cpp', ...
                cpp_flags, '-outdir', outputdir)
        case 'get_valtonenornhag_arxiv_2020a_fHf'
            mex(['-I', path_to_eigen], ...
                '-I../includes/HomLib', ...
                '-I../src/helpers', ...
                '-I../src/solvers/valtonenornhag_arxiv_2020a', ...
                'src/get_valtonenornhag_arxiv_2020a_fHf_mex.cpp', ...
                '../src/solvers/valtonenornhag_arxiv_2020a/get_valtonenornhag_arxiv_2020a_fHf.cpp', ...
                '../src/solvers/valtonenornhag_arxiv_2020a/solver_valtonenornhag_arxiv_2020a_fHf.cpp', ...
                '../src/helpers/normalize2dpts.cpp', ...
                '../src/helpers/roots.cpp', ...
                cpp_flags, '-outdir', outputdir)
        case 'get_valtonenornhag_arxiv_2020b_fHf'
            mex(['-I', path_to_eigen], ...
                '-I../includes/HomLib', ...
                '-I../src/helpers', ...
                '-I../src/solvers/valtonenornhag_arxiv_2020b', ...
                'src/get_valtonenornhag_arxiv_2020b_fHf_mex.cpp', ...
                '../src/solvers/valtonenornhag_arxiv_2020b/get_valtonenornhag_arxiv_2020b_fHf.cpp', ...
                '../src/solvers/valtonenornhag_arxiv_2020b/solver_valtonenornhag_arxiv_2020b_fHf.cpp', ...
                '../src/helpers/normalize2dpts.cpp', ...
                '../src/helpers/roots.cpp', ...
                cpp_flags, '-outdir', outputdir)
        case 'get_valtonenornhag_arxiv_2020b_frHfr'
            mex(['-I', path_to_eigen], ...
                '-I../includes/HomLib', ...
                '-I../src/helpers', ...
                '-I../src/solvers/valtonenornhag_arxiv_2020b', ...
                'src/get_valtonenornhag_arxiv_2020b_frHfr_mex.cpp', ...
                '../src/solvers/valtonenornhag_arxiv_2020b/get_valtonenornhag_arxiv_2020b_frHfr.cpp', ...
                '../src/solvers/valtonenornhag_arxiv_2020b/solver_valtonenornhag_arxiv_2020b_frHfr.cpp', ...
                '../src/helpers/normalize2dpts.cpp', ...
                '../src/helpers/gj.cpp', ...
                cpp_flags, '-outdir', outputdir)
        otherwise
            error('Not a valid method.')
    end
end
