"""compas_convert."""
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import functools
import os

from .universal_converter import convert  # noqa: F401,F403

try:
    from collections.abc import Sequence
except ImportError:
    from collections import Sequence

try:
    from typing import Any
    from typing import Callable
    from typing import Sequence as SequenceType
except ImportError:
    pass


def _get_version():  # type: () -> str
    # from https://smarie.github.io/python-getversion/#package-versioning-best-practices
    # and setuptools_scm docs
    try:
        # import from _version.py generated by setuptools_scm during release
        from ._version import version

        return version
    except ImportError:
        try:
            from importlib.metadata import version  # type: ignore [no-redef]

            return version("rapid-clay-formations-fab")  # type: ignore [operator]
        except ImportError:
            try:
                from importlib_metadata import version  # type: ignore [no-redef]

                return version("rapid-clay-formations-fab")  # type: ignore [operator]
            except ImportError:
                pass

    return "src"


__author__ = "Anton Tetov Johansson"
__license__ = "MIT License"
__email__ = "anton@tetov.xyz"
__version__ = _get_version()
__all_plugins__ = ["compas_convert.install.rhino"]

PKG_DIR = os.path.dirname(__file__)  # type: str
"""Path to the location of the package."""


def register_converter(
    input_types, output_type
):  # type: (SequenceType[Any], Any) -> Callable
    def wrapped(fn):
        @functools.wraps(fn)
        def func(*args, **kwargs):
            return fn(*args, **kwargs)

        func.is_converter = True
        func.input_types = (
            input_types if isinstance(input_types, Sequence) else [input_types]
        )
        func.output_type = output_type

        return func

    return wrapped
