"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallRuleGroupAssociation = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * A Firewall Rule Group Association
 */
class FirewallRuleGroupAssociation extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRuleGroupAssociationProps(props);
        if (!core_1.Token.isUnresolved(props.priority) && (props.priority <= 100 || props.priority >= 9000)) {
            throw new Error(`Priority must be greater than 100 and less than 9000, got ${props.priority}`);
        }
        const association = new route53resolver_generated_1.CfnFirewallRuleGroupAssociation(this, 'Resource', {
            firewallRuleGroupId: props.firewallRuleGroup.firewallRuleGroupId,
            priority: props.priority,
            vpcId: props.vpc.vpcId,
        });
        this.firewallRuleGroupAssociationArn = association.attrArn;
        this.firewallRuleGroupAssociationCreationTime = association.attrCreationTime;
        this.firewallRuleGroupAssociationCreatorRequestId = association.attrCreatorRequestId;
        this.firewallRuleGroupAssociationId = association.attrId;
        this.firewallRuleGroupAssociationManagedOwnerName = association.attrManagedOwnerName;
        this.firewallRuleGroupAssociationModificationTime = association.attrModificationTime;
        this.firewallRuleGroupAssociationStatus = association.attrStatus;
        this.firewallRuleGroupAssociationStatusMessage = association.attrStatusMessage;
    }
}
exports.FirewallRuleGroupAssociation = FirewallRuleGroupAssociation;
_a = JSII_RTTI_SYMBOL_1;
FirewallRuleGroupAssociation[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleGroupAssociation", version: "1.148.0" };
//# sourceMappingURL=data:application/json;base64,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