# -*- coding: utf-8 -*-
#
# This file is part of the parce Python package.
#
# Copyright © 2019-2020 by Wilbert Berendsen <info@wilbertberendsen.nl>
#
# This module is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This module is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

"""
Scheme keywords list.
Currently taken from ly.lex.scheme, but should be generated somehow.
"""

keywords = [
    '*',
    '+',
    '-',
    '->char-set',
    '/',
    '1+',
    '1-',
    '<',
    '<=',
    '=',
    '==',
    '>',
    '>=',
    'abs',
    'access?',
    'acons',
    'acos',
    'acosh',
    'activate-readline',
    'add-duration',
    'add-duration!',
    'add-hook!',
    'alist->hash-table',
    'alist-cons',
    'alist-copy',
    'alist-delete',
    'alist-delete!',
    'and',
    'and-let*',
    'angle',
    'any',
    'any->c32vector',
    'any->c64vector',
    'any->f32vector',
    'any->f64vector',
    'any->s16vector',
    'any->s32vector',
    'any->s64vector',
    'any->s8vector',
    'any->u16vector',
    'any->u32vector',
    'any->u64vector',
    'any->u8vector',
    'any-bits-set?',
    'append',
    'append!',
    'append-map',
    'append-map!',
    'append-reverse',
    'append-reverse!',
    'apply',
    'apply:nconc2last',
    'apropos-completion-function',
    'arithmetic-shift',
    'array->list',
    'array-contents',
    'array-copy!',
    'array-copy-in-order!',
    'array-dimensions',
    'array-equal?',
    'array-fill!',
    'array-for-each',
    'array-in-bounds?',
    'array-index-map!',
    'array-map!',
    'array-map-in-order!',
    'array-rank',
    'array-ref',
    'array-set!',
    'array-shape',
    'array-type',
    'array?',
    'ash',
    'asin',
    'asinh',
    'assoc',
    'assoc-ref',
    'assoc-remove!',
    'assoc-set!',
    'assq',
    'assq-ref',
    'assq-remove!',
    'assq-set!',
    'assv',
    'assv-ref',
    'assv-remove!',
    'assv-set!',
    'atan',
    'atanh',
    'basename',
    'begin',
    'bit-count',
    'bit-count*',
    'bit-extract',
    'bit-field',
    'bit-invert!',
    'bit-position',
    'bit-set*!',
    'bit-set?',
    'bitvector',
    'bitvector->list',
    'bitvector-fill!',
    'bitvector-length',
    'bitvector-ref',
    'bitvector-set!',
    'bitvector?',
    'bitwise-and',
    'bitwise-if',
    'bitwise-ior',
    'bitwise-merge',
    'bitwise-not',
    'bitwise-xor',
    'boolean?',
    'booleans->integer',
    'break',
    'break!',
    'broadcast-condition-variable',
    'c32vector',
    'c32vector->list',
    'c32vector-length',
    'c32vector-ref',
    'c32vector-set!',
    'c32vector?',
    'c64vector',
    'c64vector->list',
    'c64vector-length',
    'c64vector-ref',
    'c64vector-set!',
    'c64vector?',
    'caaaar',
    'caaadr',
    'caaar',
    'caadar',
    'caaddr',
    'caadr',
    'caar',
    'cadaar',
    'cadadr',
    'cadar',
    'caddar',
    'cadddr',
    'caddr',
    'cadr',
    'call-with-input-file',
    'call-with-input-string',
    'call-with-output-file',
    'call-with-output-string',
    'call-with-values',
    'car',
    'car+cdr',
    'case',
    'case-lambda',
    'catch',
    'cd',
    'cdaaar',
    'cdaadr',
    'cdaar',
    'cdadar',
    'cdaddr',
    'cdadr',
    'cdar',
    'cddaar',
    'cddadr',
    'cddar',
    'cdddar',
    'cddddr',
    'cdddr',
    'cddr',
    'cdr',
    'ceiling',
    'char->integer',
    'char-alphabetic?',
    'char-ci<=?',
    'char-ci<?',
    'char-ci=?',
    'char-ci>=?',
    'char-ci>?',
    'char-downcase',
    'char-is-both?',
    'char-lower-case?',
    'char-numeric?',
    'char-ready?',
    'char-set',
    'char-set->list',
    'char-set->string',
    'char-set-adjoin',
    'char-set-adjoin!',
    'char-set-any',
    'char-set-complement',
    'char-set-complement!',
    'char-set-contains?',
    'char-set-copy',
    'char-set-count',
    'char-set-cursor',
    'char-set-cursor-next',
    'char-set-delete',
    'char-set-delete!',
    'char-set-diff+intersection',
    'char-set-diff+intersection!',
    'char-set-difference',
    'char-set-difference!',
    'char-set-every',
    'char-set-filter',
    'char-set-filter!',
    'char-set-fold',
    'char-set-for-each',
    'char-set-hash',
    'char-set-intersection',
    'char-set-intersection!',
    'char-set-map',
    'char-set-ref',
    'char-set-size',
    'char-set-unfold',
    'char-set-unfold!',
    'char-set-union',
    'char-set-union!',
    'char-set-xor',
    'char-set-xor!',
    'char-set<=',
    'char-set=',
    'char-set?',
    'char-upcase',
    'char-upper-case?',
    'char-whitespace?',
    'char<=?',
    'char<?',
    'char=?',
    'char>=?',
    'char>?',
    'char?',
    'chdir',
    'chmod',
    'chown',
    'chroot',
    'circular-list',
    'circular-list?',
    'close',
    'close-fdes',
    'close-input-port',
    'close-output-port',
    'close-pipe',
    'close-port',
    'closedir',
    'closure?',
    'command-line',
    'complex?',
    'concatenate',
    'concatenate!',
    'cond',
    'cond-expand',
    'condition',
    'condition-has-type?',
    'condition-message',
    'condition-ref',
    'condition-type?',
    'cons',
    'cons*',
    'cons-source',
    'continue',
    'copy-bit',
    'copy-bit-field',
    'copy-file',
    'copy-random-state',
    'copy-time',
    'copy-tree',
    'cos',
    'cosh',
    'count',
    'ctermid',
    'current-date',
    'current-dynamic-state',
    'current-error-port',
    'current-input-port',
    'current-julian-day',
    'current-load-port',
    'current-modified-julian-day',
    'current-module',
    'current-output-port',
    'current-time',
    'cut',
    'cute',
    'date->julian-day',
    'date->modified-julian-day',
    'date->string',
    'date->time-monotonic',
    'date->time-tai',
    'date->time-utc',
    'date-day',
    'date-hour',
    'date-minute',
    'date-month',
    'date-nanosecond',
    'date-second',
    'date-week-day',
    'date-week-number',
    'date-year',
    'date-year-day',
    'date-zone-offset',
    'date?',
    'debug-object?',
    'debug-options-interface',
    'debug-trap',
    'default-duplicate-binding-handler',
    'define',
    'define*',
    'define*-public',
    'define-condition-type',
    'define-macro',
    'define-module',
    'define-public',
    'define-reader-ctor',
    'define-record-type',
    'defined?',
    'defmacro',
    'defmacro*',
    'defmacro*-public',
    'delay',
    'delete',
    'delete!',
    'delete-duplicates',
    'delete-duplicates!',
    'delete-file',
    'delete1!',
    'delq',
    'delq!',
    'delq1!',
    'delv',
    'delv!',
    'delv1!',
    'denominator',
    'deq!',
    'directory-stream?',
    'dirname',
    'display',
    'display-application',
    'display-backtrace',
    'display-error',
    'do',
    'dotted-list?',
    'doubly-weak-hash-table?',
    'down',
    'drain-input',
    'drop',
    'drop-right',
    'drop-right!',
    'drop-while',
    'dup',
    'dup->fdes',
    'dup->inport',
    'dup->outport',
    'dup->port',
    'dup2',
    'duplicate-port',
    'dynamic-args-call',
    'dynamic-call',
    'dynamic-func',
    'dynamic-link',
    'dynamic-object?',
    'dynamic-state?',
    'dynamic-unlink',
    'dynamic-wind',
    'effective-version',
    'eighth',
    'else',
    'enclose-array',
    'end-of-char-set?',
    'enq!',
    'entity?',
    'environ',
    'eof-object?',
    'eq?',
    'equal?',
    'eqv?',
    'error',
    'error?',
    'eval',
    'eval-disable',
    'eval-enable',
    'eval-options',
    'eval-options-interface',
    'eval-set!',
    'eval-string',
    'evaluate',
    'evaluator-traps-interface',
    'even?',
    'every',
    'exact->inexact',
    'exact?',
    'execl',
    'execle',
    'execlp',
    'exp',
    'expect',
    'expect-strings',
    'export',
    'expt',
    'extract-condition',
    'f32vector',
    'f32vector->list',
    'f32vector-length',
    'f32vector-ref',
    'f32vector-set!',
    'f32vector?',
    'f64vector',
    'f64vector->list',
    'f64vector-length',
    'f64vector-ref',
    'f64vector-set!',
    'f64vector?',
    'false-if-exception',
    'fchmod',
    'fchown',
    'fcntl',
    'fdes->inport',
    'fdes->outport',
    'fdes->ports',
    'fdopen',
    'feature?',
    'fflush',
    'fifth',
    'file-exists?',
    'file-port?',
    'filename-completion-function',
    'fileno',
    'filter',
    'filter!',
    'filter-map',
    'find',
    'find-tail',
    'first',
    'first-set-bit',
    'flock',
    'floor',
    'fluid-ref',
    'fluid-set!',
    'fluid?',
    'flush-all-ports',
    'fn',
    'fold',
    'fold-matches',
    'fold-right',
    'for-each',
    'force',
    'force-output',
    'format',
    'fourth',
    'frame',
    'frame-arguments',
    'frame-evaluating-args?',
    'frame-next',
    'frame-number',
    'frame-overflow?',
    'frame-previous',
    'frame-procedure',
    'frame-procedure?',
    'frame-real?',
    'frame-source',
    'frame?',
    'fstat',
    'fsync',
    'ftell',
    'ftruncate',
    'ftw',
    'gcd',
    'generalized-vector->list',
    'generalized-vector-length',
    'generalized-vector-ref',
    'generalized-vector-set!',
    'generalized-vector?',
    'gensym',
    'get-internal-real-time',
    'get-internal-run-time',
    'get-output-string',
    'get-print-state',
    'getcwd',
    'getegid',
    'getenv',
    'geteuid',
    'getgid',
    'getgroups',
    'getpgrp',
    'getpid',
    'getppid',
    'getpriority',
    'getter-with-setter',
    'gettimeofday',
    'getuid',
    'gmtime',
    'hash',
    'hash-by-identity',
    'hash-clear!',
    'hash-create-handle!',
    'hash-fold',
    'hash-for-each',
    'hash-for-each-handle',
    'hash-get-handle',
    'hash-map->list',
    'hash-ref',
    'hash-remove!',
    'hash-set!',
    'hash-table->alist',
    'hash-table-delete!',
    'hash-table-equivalence-function',
    'hash-table-exists?',
    'hash-table-fold',
    'hash-table-hash-function',
    'hash-table-keys',
    'hash-table-ref',
    'hash-table-ref/default',
    'hash-table-set!',
    'hash-table-size',
    'hash-table-update!',
    'hash-table-update!/default',
    'hash-table-values',
    'hash-table-walk',
    'hash-table?',
    'hashq',
    'hashq-create-handle!',
    'hashq-get-handle',
    'hashq-ref',
    'hashq-remove!',
    'hashq-set!',
    'hashv',
    'hashv-create-handle!',
    'hashv-get-handle',
    'hashv-ref',
    'hashv-remove!',
    'hashv-set!',
    'hashx-create-handle!',
    'hashx-get-handle',
    'hashx-ref',
    'hashx-remove!',
    'hashx-set!',
    'hook->list',
    'hook-empty?',
    'hook?',
    'if',
    'imag-part',
    'inet-aton',
    'inet-lnaof',
    'inet-makeaddr',
    'inet-netof',
    'inet-ntoa',
    'inet-ntop',
    'inet-pton',
    'inexact->exact',
    'inexact?',
    'inf',
    'inf?',
    'input-port?',
    'install-trap',
    'integer->char',
    'integer->list',
    'integer-expt',
    'integer-length',
    'integer?',
    'interaction-environment',
    'iota',
    'isatty?',
    'julian-day->date',
    'julian-day->time-monotonic',
    'julian-day->time-tai',
    'julian-day->time-utc',
    'key',
    'keyword->string',
    'keyword->symbol',
    'keyword?',
    'lambda',
    'lambda*',
    'last',
    'last-pair',
    'last-stack-frame',
    'lazy-catch',
    'lchown',
    'lcm',
    'length',
    'length+',
    'let',
    'let*',
    'let*-values',
    'let-keywords',
    'let-keywords*',
    'let-optional',
    'let-optional*',
    'let-values',
    'letpar',
    'letrec',
    'link',
    'list',
    'list->array',
    'list->bitvector',
    'list->c32vector',
    'list->c64vector',
    'list->char-set',
    'list->char-set!',
    'list->f32vector',
    'list->f64vector',
    'list->integer',
    'list->s16vector',
    'list->s32vector',
    'list->s64vector',
    'list->s8vector',
    'list->stream',
    'list->string',
    'list->typed-array',
    'list->u16vector',
    'list->u32vector',
    'list->u64vector',
    'list->u8vector',
    'list->vector',
    'list->weak-vector',
    'list-cdr-ref',
    'list-cdr-set!',
    'list-copy',
    'list-head',
    'list-index',
    'list-matches',
    'list-ref',
    'list-set!',
    'list-tabulate',
    'list-tail',
    'list=',
    'list?',
    'load',
    'load-extension',
    'load-from-path',
    'local-eval',
    'localtime',
    'lock-mutex',
    'log',
    'log10',
    'log2-binary-factors',
    'logand',
    'logbit?',
    'logcount',
    'logior',
    'lognot',
    'logtest',
    'logxor',
    'lset-adjoin',
    'lset-diff+intersection',
    'lset-diff+intersection!',
    'lset-difference',
    'lset-difference!',
    'lset-intersection',
    'lset-intersection!',
    'lset-union',
    'lset-union!',
    'lset-xor',
    'lset-xor!',
    'lset<=',
    'lset=',
    'lstat',
    'macro-name',
    'macro-transformer',
    'macro-type',
    'macro?',
    'magnitude',
    'major-version',
    'make-arbiter',
    'make-array',
    'make-bitvector',
    'make-buffered-input-port',
    'make-c32vector',
    'make-c64vector',
    'make-class-object',
    'make-completion-function',
    'make-compound-condition',
    'make-condition',
    'make-condition-type',
    'make-condition-variable',
    'make-date',
    'make-doubly-weak-hash-table',
    'make-dynamic-state',
    'make-f32vector',
    'make-f64vector',
    'make-fluid',
    'make-guardian',
    'make-hash-table',
    'make-hook',
    'make-line-buffered-input-port',
    'make-list',
    'make-mutex',
    'make-object-property',
    'make-parameter',
    'make-polar',
    'make-procedure-with-setter',
    'make-q',
    'make-record-type',
    'make-rectangular',
    'make-recursive-mutex',
    'make-regexp',
    'make-s16vector',
    'make-s32vector',
    'make-s64vector',
    'make-s8vector',
    'make-shared-array',
    'make-soft-port',
    'make-stack',
    'make-stream',
    'make-string',
    'make-struct',
    'make-struct-layout',
    'make-subclass-object',
    'make-symbol',
    'make-time',
    'make-typed-array',
    'make-u16vector',
    'make-u32vector',
    'make-u64vector',
    'make-u8vector',
    'make-undefined-variable',
    'make-variable',
    'make-vector',
    'make-vtable',
    'make-vtable-vtable',
    'make-weak-key-hash-table',
    'make-weak-value-hash-table',
    'make-weak-vector',
    'malloc-stats',
    'map',
    'map!',
    'map-in-order',
    'match:count',
    'match:end',
    'match:prefix',
    'match:start',
    'match:string',
    'match:substring',
    'match:suffix',
    'max',
    'member',
    'memoized-environment',
    'memoized?',
    'memq',
    'memv',
    'merge',
    'merge!',
    'message-condition?',
    'micro-version',
    'min',
    'minor-version',
    'mkdir',
    'mknod',
    'mkstemp!',
    'mktime',
    'modified-julian-day->date',
    'modified-julian-day->time-monotonic',
    'modified-julian-day->time-tai',
    'modified-julian-day->time-utc',
    'module-use!',
    'modulo',
    'modulo-expt',
    'monitor',
    'move->fdes',
    'n-for-each-par-map',
    'n-par-for-each',
    'n-par-map',
    'nan',
    'nan?',
    'negative?',
    'newline',
    'nftw',
    'nice',
    'nil-car',
    'nil-cdr',
    'nil-cons',
    'nil-eq',
    'ninth',
    'not',
    'not-pair?',
    'null',
    'null-environment',
    'null-list?',
    'null?',
    'number->string',
    'number?',
    'numerator',
    'object->string',
    'object-properties',
    'object-property',
    'odd?',
    'open',
    'open-fdes',
    'open-file',
    'open-input-file',
    'open-input-output-pipe',
    'open-input-pipe',
    'open-input-string',
    'open-output-file',
    'open-output-pipe',
    'open-output-string',
    'open-pipe',
    'open-pipe*',
    'opendir',
    'operator?',
    'option-ref',
    'or',
    'output-port?',
    'pair-fold',
    'pair-fold-right',
    'pair-for-each',
    'pair?',
    'par-for-each',
    'par-map',
    'parallel',
    'parameterize',
    'parse-path',
    'partition',
    'partition!',
    'pclose',
    'peek-char',
    'pipe',
    'popen',
    'port->fdes',
    'port->stream',
    'port-closed?',
    'port-column',
    'port-filename',
    'port-for-each',
    'port-line',
    'port-mode',
    'port-revealed',
    'port-with-print-state',
    'port?',
    'position',
    'positive?',
    'pretty-print',
    'primitive-eval',
    'primitive-exit',
    'primitive-fork',
    'primitive-load',
    'primitive-load-path',
    'primitive-make-property',
    'primitive-move->fdes',
    'primitive-property-del!',
    'primitive-property-ref',
    'primitive-property-set!',
    'print-options-interface',
    'procedure',
    'procedure->macro',
    'procedure->memoizing-macro',
    'procedure->syntax',
    'procedure-documentation',
    'procedure-environment',
    'procedure-name',
    'procedure-properties',
    'procedure-property',
    'procedure-source',
    'procedure-with-setter?',
    'procedure?',
    'program-arguments',
    'promise?',
    'proper-list?',
    'provide',
    'provided?',
    'putenv',
    'pwd',
    'q-empty-check',
    'q-empty?',
    'q-front',
    'q-length',
    'q-pop!',
    'q-push!',
    'q-rear',
    'q-remove!',
    'q?',
    'quasiquote',
    'quit',
    'quote',
    'quotient',
    'random',
    'random:exp',
    'random:hollow-sphere!',
    'random:normal',
    'random:normal-vector!',
    'random:solid-sphere!',
    'random:uniform',
    'rational?',
    'rationalize',
    're-export',
    'read',
    'read-char',
    'read-delimited',
    'read-delimited!',
    'read-disable',
    'read-enable',
    'read-hash-extend',
    'read-line',
    'read-line!',
    'read-options',
    'read-options-interface',
    'read-set!',
    'read-string!/partial',
    'readdir',
    'readline',
    'readline-disable',
    'readline-enable',
    'readline-options',
    'readline-port',
    'readline-set!',
    'readlink',
    'real-part',
    'real?',
    'rec',
    'receive',
    'record-accessor',
    'record-constructor',
    'record-modifier',
    'record-predicate',
    'record-type-descriptor',
    'record-type-fields',
    'record-type-name',
    'record?',
    'redirect-port',
    'reduce',
    'reduce-right',
    'regexp-exec',
    'regexp-match?',
    'regexp-quote',
    'regexp-substitute',
    'regexp-substitute/global',
    'regexp?',
    'release-arbiter',
    'release-port-handle',
    'remainder',
    'remove',
    'remove!',
    'remove-hook!',
    'rename',
    'rename-file',
    'require',
    'require-extension',
    'reset-hook!',
    'resolve-interface',
    'resolve-module',
    'restricted-vector-sort!',
    'reverse',
    'reverse!',
    'reverse-bit-field',
    'reverse-list->string',
    'rewinddir',
    'rmdir',
    'rotate-bit-field',
    'round',
    'run-hook',
    's16vector',
    's16vector->list',
    's16vector-length',
    's16vector-ref',
    's16vector-set!',
    's16vector?',
    's32vector',
    's32vector->list',
    's32vector-length',
    's32vector-ref',
    's32vector-set!',
    's32vector?',
    's64vector',
    's64vector->list',
    's64vector-length',
    's64vector-ref',
    's64vector-set!',
    's64vector?',
    's8vector',
    's8vector->list',
    's8vector-length',
    's8vector-ref',
    's8vector-set!',
    's8vector?',
    'save-module-excursion',
    'scheme-report-environment',
    'scm-error',
    'search-path',
    'second',
    'seed->random-state',
    'seek',
    'select',
    'serious-condition?',
    'set!',
    'set-buffered-input-continuation?!',
    'set-car!',
    'set-cdr!',
    'set-current-dynamic-state',
    'set-current-error-port',
    'set-current-input-port',
    'set-current-module',
    'set-current-output-port',
    'set-object-procedure!',
    'set-object-properties!',
    'set-object-property!',
    'set-port-column!',
    'set-port-filename!',
    'set-port-line!',
    'set-port-revealed!',
    'set-procedure-properties!',
    'set-procedure-property!',
    'set-program-arguments',
    'set-readline-input-port!',
    'set-readline-output-port!',
    'set-readline-prompt!',
    'set-source-properties!',
    'set-source-property!',
    'set-struct-vtable-name!',
    'set-symbol-property!',
    'set-time-nanosecond!',
    'set-time-second!',
    'set-time-type!',
    'set-tm:gmtoff',
    'set-tm:hour',
    'set-tm:isdst',
    'set-tm:mday',
    'set-tm:min',
    'set-tm:mon',
    'set-tm:sec',
    'set-tm:wday',
    'set-tm:yday',
    'set-tm:year',
    'set-tm:zone',
    'set-trace-layout',
    'setegid',
    'setenv',
    'seteuid',
    'setgid',
    'setgroups',
    'setlocale',
    'setpgid',
    'setpriority',
    'setsid',
    'setter',
    'setuid',
    'setvbuf',
    'seventh',
    'shared-array-increments',
    'shared-array-offset',
    'shared-array-root',
    'signal-condition-variable',
    'simple-format',
    'sin',
    'sinh',
    'sixth',
    'sloppy-assoc',
    'sloppy-assq',
    'sloppy-assv',
    'sort',
    'sort!',
    'sort-list',
    'sort-list!',
    'sorted?',
    'source-properties',
    'source-property',
    'span',
    'span!',
    'split-at',
    'split-at!',
    'sqrt',
    'stable-sort',
    'stable-sort!',
    'stack-id',
    'stack-length',
    'stack-ref',
    'stack?',
    'start-stack',
    'stat',
    'stat:atime',
    'stat:blksize',
    'stat:blocks',
    'stat:ctime',
    'stat:dev',
    'stat:gid',
    'stat:ino',
    'stat:mode',
    'stat:mtime',
    'stat:nlink',
    'stat:perms',
    'stat:rdev',
    'stat:size',
    'stat:type',
    'stat:uid',
    'status:exit-val',
    'status:stop-sig',
    'status:term-sig',
    'stream->list',
    'stream->list&amp;length',
    'stream->reversed-list',
    'stream->reversed-list&amp;length',
    'stream->vector',
    'stream-car',
    'stream-cdr',
    'stream-fold',
    'stream-for-each',
    'stream-map',
    'stream-null?',
    'strerror',
    'strftime',
    'string',
    'string->char-set',
    'string->char-set!',
    'string->date',
    'string->keyword',
    'string->list',
    'string->number',
    'string->symbol',
    'string-any',
    'string-append',
    'string-append/shared',
    'string-capitalize',
    'string-capitalize!',
    'string-ci->symbol',
    'string-ci-hash',
    'string-ci<',
    'string-ci<=',
    'string-ci<=?',
    'string-ci<>',
    'string-ci<?',
    'string-ci=',
    'string-ci=?',
    'string-ci>',
    'string-ci>=',
    'string-ci>=?',
    'string-ci>?',
    'string-compare',
    'string-compare-ci',
    'string-concatenate',
    'string-concatenate-reverse',
    'string-concatenate-reverse/shared',
    'string-concatenate/shared',
    'string-contains',
    'string-contains-ci',
    'string-copy',
    'string-copy!',
    'string-count',
    'string-delete',
    'string-downcase',
    'string-downcase!',
    'string-drop',
    'string-drop-right',
    'string-every',
    'string-fill!',
    'string-filter',
    'string-fold',
    'string-fold-right',
    'string-for-each',
    'string-for-each-index',
    'string-hash',
    'string-hash-ci',
    'string-index',
    'string-index-right',
    'string-join',
    'string-length',
    'string-map',
    'string-map!',
    'string-match',
    'string-null?',
    'string-pad',
    'string-pad-right',
    'string-prefix-ci?',
    'string-prefix-length',
    'string-prefix-length-ci',
    'string-prefix?',
    'string-ref',
    'string-replace',
    'string-reverse',
    'string-reverse!',
    'string-rindex',
    'string-set!',
    'string-skip',
    'string-skip-right',
    'string-split',
    'string-suffix-ci?',
    'string-suffix-length',
    'string-suffix-length-ci',
    'string-suffix?',
    'string-tabulate',
    'string-take',
    'string-take-right',
    'string-titlecase',
    'string-titlecase!',
    'string-tokenize',
    'string-trim',
    'string-trim-both',
    'string-trim-right',
    'string-unfold',
    'string-unfold-right',
    'string-upcase',
    'string-upcase!',
    'string-xcopy!',
    'string<',
    'string<=',
    'string<=?',
    'string<>',
    'string<?',
    'string=',
    'string=?',
    'string>',
    'string>=',
    'string>=?',
    'string>?',
    'string?',
    'strptime',
    'struct-ref',
    'struct-set!',
    'struct-vtable',
    'struct-vtable-name',
    'struct-vtable-tag',
    'struct-vtable?',
    'struct?',
    'substring',
    'substring-fill!',
    'substring-move!',
    'substring/copy',
    'substring/read-only',
    'substring/shared',
    'subtract-duration',
    'subtract-duration!',
    'symbol->keyword',
    'symbol->string',
    'symbol-fref',
    'symbol-fset!',
    'symbol-hash',
    'symbol-interned?',
    'symbol-pref',
    'symbol-prefix-proc',
    'symbol-property',
    'symbol-property-remove!',
    'symbol-pset!',
    'symbol?',
    'symlink',
    'sync',
    'sync-q!',
    'system',
    'system*',
    'system-error-errno',
    'take',
    'take!',
    'take-right',
    'take-while',
    'take-while!',
    'tan',
    'tanh',
    'tc:depth',
    'tc:frame',
    'tc:real-depth',
    'tc:return-value',
    'tc:stack',
    'tc:type',
    'tcgetpgrp',
    'tcsetpgrp',
    'tenth',
    'third',
    'throw',
    'thunk?',
    'time-difference',
    'time-difference!',
    'time-monotonic->date',
    'time-monotonic->time-tai',
    'time-monotonic->time-tai!',
    'time-monotonic->time-utc',
    'time-monotonic->time-utc!',
    'time-nanosecond',
    'time-resolution',
    'time-second',
    'time-tai->date',
    'time-tai->julian-day',
    'time-tai->modified-julian-day',
    'time-tai->time-monotonic',
    'time-tai->time-monotonic!',
    'time-tai->time-utc',
    'time-tai->time-utc!',
    'time-type',
    'time-utc->date',
    'time-utc->julian-day',
    'time-utc->modified-julian-day',
    'time-utc->time-monotonic',
    'time-utc->time-monotonic!',
    'time-utc->time-tai',
    'time-utc->time-tai!',
    'time<=?',
    'time<?',
    'time=?',
    'time>=?',
    'time>?',
    'time?',
    'times',
    'tm:gmtoff',
    'tm:hour',
    'tm:isdst',
    'tm:mday',
    'tm:min',
    'tm:mon',
    'tm:sec',
    'tm:wday',
    'tm:yday',
    'tm:year',
    'tm:zone',
    'tmpnam',
    'tms:clock',
    'tms:cstime',
    'tms:cutime',
    'tms:stime',
    'tms:utime',
    'trace',
    'trace-at-exit',
    'trace-port',
    'trace-trap',
    'trace-until-exit',
    'trace/info',
    'trace/pid',
    'trace/real?',
    'trace/source',
    'trace/source-column',
    'trace/source-file-name',
    'trace/source-line',
    'trace/stack',
    'trace/stack-depth',
    'trace/stack-id',
    'trace/stack-real-depth',
    'trace/type',
    'transpose-array',
    'trap-disable',
    'trap-enable',
    'trap-set!',
    'traps',
    'truncate',
    'truncate-file',
    'try-arbiter',
    'try-mutex',
    'ttyname',
    'typed-array?',
    'tzset',
    'u16vector',
    'u16vector->list',
    'u16vector-length',
    'u16vector-ref',
    'u16vector-set!',
    'u16vector?',
    'u32vector',
    'u32vector->list',
    'u32vector-length',
    'u32vector-ref',
    'u32vector-set!',
    'u32vector?',
    'u64vector',
    'u64vector->list',
    'u64vector-length',
    'u64vector-ref',
    'u64vector-set!',
    'u64vector?',
    'u8vector',
    'u8vector->list',
    'u8vector-length',
    'u8vector-ref',
    'u8vector-set!',
    'u8vector?',
    'ucs-range->char-set',
    'ucs-range->char-set!',
    'umask',
    'unfold',
    'unfold-right',
    'uniform-array-read!',
    'uniform-array-write',
    'uniform-vector->list',
    'uniform-vector-length',
    'uniform-vector-read!',
    'uniform-vector-ref',
    'uniform-vector-set!',
    'uniform-vector-write',
    'uniform-vector?',
    'uninstall-trap',
    'unlink',
    'unlock-mutex',
    'unmemoize',
    'unquote',
    'unquote-splicing',
    'unread-char',
    'unread-string',
    'unsetenv',
    'untrace',
    'unzip1',
    'unzip2',
    'unzip3',
    'unzip4',
    'unzip5',
    'up',
    'use-modules',
    'use-syntax',
    'utime',
    'values',
    'variable-bound?',
    'variable-ref',
    'variable-set!',
    'variable?',
    'vector',
    'vector->list',
    'vector->stream',
    'vector-copy',
    'vector-fill!',
    'vector-length',
    'vector-move-left!',
    'vector-move-right!',
    'vector-ref',
    'vector-set!',
    'vector?',
    'version',
    'wait-condition-variable',
    'waitpid',
    'weak-key-hash-table?',
    'weak-value-hash-table?',
    'weak-vector',
    'weak-vector?',
    'while',
    'with-continuation-barrier',
    'with-dynamic-state',
    'with-error-to-file',
    'with-fluid*',
    'with-fluids',
    'with-fluids*',
    'with-input-from-file',
    'with-input-from-string',
    'with-mutex',
    'with-output-to-file',
    'with-output-to-string',
    'with-parameters*',
    'with-readline-completion-function',
    'with-throw-handler',
    'with-traps',
    'write',
    'write-char',
    'write-line',
    'write-string/partial',
    'xcons',
    'xsubstring',
    'zero?',
    'zip',
]
