"""
A collection of monsters from D&D 5e's SRD

This file was autogenerated by https://github.com/stravajiaxen/5e-srd-to-py
"""

from dungeonsheets.monsters.monsters import Monster
from dungeonsheets.stats import Ability


class YoungBlackDragon(Monster):
    """
    Amphibious.
      The dragon can breathe air and water.
    Multiattack.
      The dragon makes three attacks: one with its bite and two with its
      claws.
    Bite.
      Melee Weapon Attack: +7 to hit, reach 10 ft., one target. Hit: 15
      (2d10 + 4) piercing damage plus 4 (1d8) acid damage.
    Claw.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 11 (2d6
      + 4) slashing damage.
    Acid Breath.
      The dragon exhales acid in a 30-foot line that is 5 feet wide. Each
      creature in that line must make a DC 14 Dexterity saving throw, taking
      49 (11d8) acid damage on a failed save, or half as much damage on a
      successful one.
    """
    name = "Young Black Dragon"
    description = "Large dragon, chaotic evil"
    challenge_rating = 7
    armor_class = 18
    skills = "Perception +6, Stealth +5"
    senses = "Blindsight 30 ft., Darkvision 120 ft., Passive Perception 16"
    languages = "Common, Draconic"
    strength = Ability(19)
    dexterity = Ability(14)
    constitution = Ability(17)
    intelligence = Ability(12)
    wisdom = Ability(11)
    charisma = Ability(15)
    speed = 40
    swim_speed = 40
    fly_speed = 80
    climb_speed = 0
    hp_max = 127
    hit_dice = "15d10"
    spells = []


class YoungBlueDragon(Monster):
    """
    Multiattack.
      The dragon makes three attacks: one with its bite and two with its
      claws.
    Bite.
      Melee Weapon Attack: +9 to hit, reach 10 ft., one target. Hit: 16
      (2d10 + 5) piercing damage plus 5 (1d10) lightning damage.
    Claw.
      Melee Weapon Attack: +9 to hit, reach 5 ft., one target. Hit: 12 (2d6
      + 5) slashing damage.
    Lightning Breath.
      The dragon exhales lightning in an 60-foot line that is 5 feet wide.
      Each creature in that line must make a DC 16 Dexterity saving throw,
      taking 55 (10d10) lightning damage on a failed save, or half as much
      damage on a successful one.
    """
    name = "Young Blue Dragon"
    description = "Large dragon, lawful evil"
    challenge_rating = 9
    armor_class = 18
    skills = "Perception +9, Stealth +4"
    senses = "Blindsight 30 ft., Darkvision 120 ft., Passive Perception 19"
    languages = "Common, Draconic"
    strength = Ability(21)
    dexterity = Ability(10)
    constitution = Ability(19)
    intelligence = Ability(14)
    wisdom = Ability(13)
    charisma = Ability(17)
    speed = 40
    swim_speed = 0
    fly_speed = 80
    climb_speed = 0
    hp_max = 152
    hit_dice = "16d10"
    spells = []


class YoungBrassDragon(Monster):
    """
    Multiattack.
      The dragon makes three attacks: one with its bite and two with its
      claws.
    Bite.
      Melee Weapon Attack: +7 to hit, reach 10 ft., one target. Hit: 15
      (2d10 + 4) piercing damage.
    Claw.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 11 (2d6
      + 4) slashing damage.
    Breath Weapons.
      The dragon uses one of the following breath weapons.
      
      Fire Breath. The dragon exhales fire in a 40-foot line that is 5 feet
      wide. Each creature in that line must make a DC 14 Dexterity saving
      throw, taking 42 (12d6) fire damage on a failed save, or half as much
      damage on a successful one.
      
      Sleep Breath. The dragon exhales sleep gas in a 30-foot cone. Each
      creature in that area must succeed on a DC 14 Constitution saving
      throw or fall unconscious for 5 minutes. This effect ends for a
      creature if the creature takes damage or someone uses an action to
      wake it.
    """
    name = "Young Brass Dragon"
    description = "Large dragon, chaotic good"
    challenge_rating = 6
    armor_class = 17
    skills = "Perception +6, Persuasion +5, Stealth +3"
    senses = "Blindsight 30 ft., Darkvision 120 ft., Passive Perception 16"
    languages = "Common, Draconic"
    strength = Ability(19)
    dexterity = Ability(10)
    constitution = Ability(17)
    intelligence = Ability(12)
    wisdom = Ability(11)
    charisma = Ability(15)
    speed = 40
    swim_speed = 0
    fly_speed = 80
    climb_speed = 0
    hp_max = 110
    hit_dice = "13d10"
    spells = []


class YoungBronzeDragon(Monster):
    """
    Amphibious.
      The dragon can breathe air and water.
    Multiattack.
      The dragon makes three attacks: one with its bite and two with its
      claws.
    Bite.
      Melee Weapon Attack: +8 to hit, reach 10 ft., one target. Hit: 16
      (2d10 + 5) piercing damage.
    Claw.
      Melee Weapon Attack: +8 to hit, reach 5 ft., one target. Hit: 12 (2d6
      + 5) slashing damage.
    Breath Weapons.
      The dragon uses one of the following breath weapons.
      
      Lightning Breath. The dragon exhales lightning in a 60-foot line that
      is 5 feet wide. Each creature in that line must make a DC 15 Dexterity
      saving throw, taking 55 (10d10) lightning damage on a failed save, or
      half as much damage on a successful one.
      
      Repulsion Breath. The dragon exhales repulsion energy in a 30-foot
      cone. Each creature in that area must succeed on a DC 15 Strength
      saving throw. On a failed save, the creature is pushed 40 feet away
      from the dragon.
    """
    name = "Young Bronze Dragon"
    description = "Large dragon, lawful good"
    challenge_rating = 8
    armor_class = 18
    skills = "Insight +4, Perception +7, Stealth +3"
    senses = "Blindsight 30 ft., Darkvision 120 ft., Passive Perception 17"
    languages = "Common, Draconic"
    strength = Ability(21)
    dexterity = Ability(10)
    constitution = Ability(19)
    intelligence = Ability(14)
    wisdom = Ability(13)
    charisma = Ability(17)
    speed = 40
    swim_speed = 40
    fly_speed = 80
    climb_speed = 0
    hp_max = 142
    hit_dice = "15d10"
    spells = []


class YoungCopperDragon(Monster):
    """
    Multiattack.
      The dragon makes three attacks: one with its bite and two with its
      claws.
    Bite.
      Melee Weapon Attack: +7 to hit, reach 10 ft., one target. Hit: 15
      (2d10 + 4) piercing damage.
    Claw.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 11 (2d6
      + 4) slashing damage.
    Breath Weapons.
      The dragon uses one of the following breath weapons.
      
      Acid Breath. The dragon exhales acid in an 40-foot line that is 5 feet
      wide. Each creature in that line must make a DC 14 Dexterity saving
      throw, taking 40 (9d8) acid damage on a failed save, or half as much
      damage on a successful one.
      
      Slowing Breath. The dragon exhales gas in a 30-foot cone. Each
      creature in that area must succeed on a DC 14 Constitution saving
      throw. On a failed save, the creature can't use reactions, its speed
      is halved, and it can't make more than one attack on its turn. In
      addition, the creature can use either an action or a bonus action on
      its turn, but not both. These effects last for 1 minute. The creature
      can repeat the saving throw at the end of each of its turns, ending
      the effect on itself with a successful save.
    """
    name = "Young Copper Dragon"
    description = "Large dragon, chaotic good"
    challenge_rating = 7
    armor_class = 17
    skills = "Deception +5, Perception +7, Stealth +4"
    senses = "Blindsight 30 ft., Darkvision 120 ft., Passive Perception 17"
    languages = "Common, Draconic"
    strength = Ability(19)
    dexterity = Ability(12)
    constitution = Ability(17)
    intelligence = Ability(16)
    wisdom = Ability(13)
    charisma = Ability(15)
    speed = 40
    swim_speed = 0
    fly_speed = 80
    climb_speed = 40
    hp_max = 119
    hit_dice = "14d10"
    spells = []


class YoungGoldDragon(Monster):
    """
    Amphibious.
      The dragon can breathe air and water.
    Multiattack.
      The dragon makes three attacks: one with its bite and two with its
      claws.
    Bite.
      Melee Weapon Attack: +10 to hit, reach 10 ft., one target. Hit: 17
      (2d10 + 6) piercing damage.
    Claw.
      Melee Weapon Attack: +10 to hit, reach 5 ft., one target. Hit: 13 (2d6
      + 6) slashing damage.
    Breath Weapons.
      The dragon uses one of the following breath weapons.
      
      Fire Breath. The dragon exhales fire in a 30-foot cone. Each creature
      in that area must make a DC 17 Dexterity saving throw, taking 55
      (10d10) fire damage on a failed save, or half as much damage on a
      successful one.
      
      Weakening Breath. The dragon exhales gas in a 30-foot cone. Each
      creature in that area must succeed on a DC 17 Strength saving throw or
      have disadvantage on Strength-based attack rolls, Strength checks, and
      Strength saving throws for 1 minute. A creature can repeat the saving
      throw at the end of each of its turns, ending the effect on itself on
      a success.
    """
    name = "Young Gold Dragon"
    description = "Large dragon, lawful good"
    challenge_rating = 10
    armor_class = 18
    skills = "Insight +5, Perception +9, Persuasion +9, Stealth +6"
    senses = "Blindsight 30 ft., Darkvision 120 ft., Passive Perception 19"
    languages = "Common, Draconic"
    strength = Ability(23)
    dexterity = Ability(14)
    constitution = Ability(21)
    intelligence = Ability(16)
    wisdom = Ability(13)
    charisma = Ability(20)
    speed = 40
    swim_speed = 40
    fly_speed = 80
    climb_speed = 0
    hp_max = 178
    hit_dice = "17d10"
    spells = []


class YoungGreenDragon(Monster):
    """
    Amphibious.
      The dragon can breathe air and water.
    Multiattack.
      The dragon makes three attacks: one with its bite and two with its
      claws.
    Bite.
      Melee Weapon Attack: +7 to hit, reach 10 ft., one target. Hit: 15
      (2d10 + 4) piercing damage plus 7 (2d6) poison damage.
    Claw.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 11 (2d6
      + 4) slashing damage.
    Poison Breath.
      The dragon exhales poisonous gas in a 30-foot cone. Each creature in
      that area must make a DC 14 Constitution saving throw, taking 42
      (12d6) poison damage on a failed save, or half as much damage on a
      successful one.
    """
    name = "Young Green Dragon"
    description = "Large dragon, lawful evil"
    challenge_rating = 8
    armor_class = 18
    skills = "Deception +5, Perception +7, Stealth +4"
    senses = "Blindsight 30 ft., Darkvision 120 ft., Passive Perception 17"
    languages = "Common, Draconic"
    strength = Ability(19)
    dexterity = Ability(12)
    constitution = Ability(17)
    intelligence = Ability(16)
    wisdom = Ability(13)
    charisma = Ability(15)
    speed = 40
    swim_speed = 40
    fly_speed = 80
    climb_speed = 0
    hp_max = 136
    hit_dice = "16d10"
    spells = []


class YoungRedDragon(Monster):
    """
    Multiattack.
      The dragon makes three attacks: one with its bite and two with its
      claws.
    Bite.
      Melee Weapon Attack: +10 to hit, reach 10 ft., one target. Hit: 17
      (2d10 + 6) piercing damage plus 3 (1d6) fire damage.
    Claw.
      Melee Weapon Attack: +10 to hit, reach 5 ft., one target. Hit: 13 (2d6
      + 6) slashing damage.
    Fire Breath.
      The dragon exhales fire in a 30-foot cone. Each creature in that area
      must make a DC 17 Dexterity saving throw, taking 56 (16d6) fire damage
      on a failed save, or half as much damage on a successful one.
    """
    name = "Young Red Dragon"
    description = "Large dragon, chaotic evil"
    challenge_rating = 10
    armor_class = 18
    skills = "Perception +8, Stealth +4"
    senses = "Blindsight 30 ft., Darkvision 120 ft., Passive Perception 18"
    languages = "Common, Draconic"
    strength = Ability(23)
    dexterity = Ability(10)
    constitution = Ability(21)
    intelligence = Ability(14)
    wisdom = Ability(11)
    charisma = Ability(19)
    speed = 40
    swim_speed = 0
    fly_speed = 80
    climb_speed = 40
    hp_max = 178
    hit_dice = "17d10"
    spells = []


class YoungSilverDragon(Monster):
    """
    Multiattack.
      The dragon makes three attacks: one with its bite and two with its
      claws.
    Bite.
      Melee Weapon Attack: +10 to hit, reach 10 ft., one target. Hit: 17
      (2d10 + 6) piercing damage.
    Claw.
      Melee Weapon Attack: +10 to hit, reach 5 ft., one target. Hit: 13 (2d6
      + 6) slashing damage.
    Breath Weapons.
      The dragon uses one of the following breath weapons.
      
      Cold Breath. The dragon exhales an icy blast in a 30-foot cone. Each
      creature in that area must make a DC 17 Constitution saving throw,
      taking 54 (12d8) cold damage on a failed save, or half as much damage
      on a successful one.
      
      Paralyzing Breath. The dragon exhales paralyzing gas in a 30-foot
      cone. Each creature in that area must succeed on a DC 17 Constitution
      saving throw or be paralyzed for 1 minute. A creature can repeat the
      saving throw at the end of each of its turns, ending the effect on
      itself on a success.
    """
    name = "Young Silver Dragon"
    description = "Large dragon, lawful good"
    challenge_rating = 9
    armor_class = 18
    skills = "Arcana +6, History +6, Perception +8, Stealth +4"
    senses = "Blindsight 30 ft., Darkvision 120 ft., Passive Perception 18"
    languages = "Common, Draconic"
    strength = Ability(23)
    dexterity = Ability(10)
    constitution = Ability(21)
    intelligence = Ability(14)
    wisdom = Ability(11)
    charisma = Ability(19)
    speed = 40
    swim_speed = 0
    fly_speed = 80
    climb_speed = 0
    hp_max = 168
    hit_dice = "16d10"
    spells = []


class YoungWhiteDragon(Monster):
    """
    Ice Walk.
      The dragon can move across and climb icy surfaces without needing to
      make an ability check. Additionally, difficult terrain composed of ice
      or snow doesn't cost it extra moment.
    Multiattack.
      The dragon makes three attacks: one with its bite and two with its
      claws.
    Bite.
      Melee Weapon Attack: +7 to hit, reach 10 ft., one target. Hit: 15
      (2d10 + 4) piercing damage plus 4 (1d8) cold damage.
    Claw.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 11 (2d6
      + 4) slashing damage.
    Cold Breath.
      The dragon exhales an icy blast in a 30-foot cone. Each creature in
      that area must make a DC 15 Constitution saving throw, taking 45
      (10d8) cold damage on a failed save, or half as much damage on a
      successful one.
    """
    name = "Young White Dragon"
    description = "Large dragon, chaotic evil"
    challenge_rating = 6
    armor_class = 17
    skills = "Perception +6, Stealth +3"
    senses = "Blindsight 30 ft., Darkvision 120 ft., Passive Perception 16"
    languages = "Common, Draconic"
    strength = Ability(18)
    dexterity = Ability(10)
    constitution = Ability(18)
    intelligence = Ability(6)
    wisdom = Ability(11)
    charisma = Ability(12)
    speed = 40
    swim_speed = 40
    fly_speed = 80
    climb_speed = 0
    hp_max = 133
    hit_dice = "14d10"
    spells = []
