from typing import Dict


QUERY: Dict[str, str] = {
    "conv360IDToO2OIDQ": "query Conv360IDToO2OID($qid : String, $deviceId: String) {\n  conv360IDToO2OID(qid: $qid, deviceId: $deviceId) {\n    __typename\n    qid {\n      __typename\n      ori\n      o2oId\n    }\n    deviceId {\n      __typename\n      ori\n      o2oId\n    }\n  }\n}",
}
BLOG_Q: Dict[str, str] = {
    "linksQ": "query BlogLinks($linkId : String) {\n  blogLinks(linkId: $linkId) {\n    __typename\n    ...BlogLinkListFragment\n  }\n}\nfragment BlogLinkListFragment on BlogLinkList {\n  __typename\n  offset\n  limit\n  total\n  list {\n    __typename\n    ...BlogLinkFragment\n  }\n}\nfragment BlogLinkFragment on BlogLink {\n  __typename\n  id\n  campaign {\n    __typename\n    ...CampaignFragment\n  }\n  title {\n    __typename\n    ...MultiLangTextFragment\n  }\n  link\n  type\n  lgImage {\n    __typename\n    ...FileFragment\n  }\n  status\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n  update\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}",
}
CAMPAIGN_Q: Dict[str, str] = {
    "avatarsQ": "query Avatars($id: String) {\n  avatars(id: $id) {\n    __typename\n    id\n    name\n    file {\n      __typename\n      ...FileFragment\n    }\n    listOrder\n    create\n    update\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}",
    "campaignsQ": "query Campaigns($id : String, $categoryId : String) {\n  campaigns(id: $id, categoryId: $categoryId, status: ENABLE) {\n    __typename\n    ...CampaignFragment\n  }\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}",
    "isSubscribedQ": "query IsSubscribedCampaign($id: String!, $uid: String!) {\n  isSubscribedCampaign(uid: $uid, id: $id)\n}",
    "subscribedQ": "query SubscribedCampaign($uid: String!, $needDetail: Boolean!) {\n  subscribedCampaign(uid:$uid) {\n    __typename\n    campaign @include(if: $needDetail) {\n      __typename\n      ...CampaignFragment\n    }\n    user @include(if: $needDetail) {\n      __typename\n      ...UserFragment\n    }\n    avatar @include(if: $needDetail) {\n      __typename\n      ...FileFragment\n    }\n    profile @include(if: $needDetail) {\n      __typename\n      ...FileFragment\n    }\n    name\n    subscribedDate\n  }\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "ranksQ": "query Ranks($campaignId : String!) {\n  ranks(campaignId: $campaignId) {\n    __typename\n    campaign {\n      __typename\n      ...CampaignFragment\n    }\n    topRank {\n      __typename\n      ...SimpleRankRowFragment\n    }\n    userRank {\n      __typename\n      ...SimpleRankRowFragment\n    }\n  }\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}\nfragment SimpleRankRowFragment on SimpleRankRow {\n  __typename\n  id\n  userName\n  userId\n  score\n  rank\n  avatar {\n    __typename\n    ...FileFragment\n  }\n}",
    "followRequestWatchCountQ": "query FollowRequestWatchCount {\n  followRequestWatchCount\n}",
    "campaignUserProfilesQ": "query CampaignUserProfiles {\n  campaignUserProfiles {\n    __typename\n    ...CampaignUserProfilesFragment\n  }\n  followRequestWatchCount\n}\nfragment CampaignUserProfilesFragment on CampaignUserProfile {\n  __typename\n  id\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  avatar {\n    __typename\n    ...AvatarFragment\n  }\n  profile {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment AvatarFragment on Avatar {\n  __typename\n  id\n  name\n  file {\n    __typename\n    ...FileFragment\n  }\n}",
}
CARD_Q: Dict[str, str] = {
    "groupsQ": "query CardGroups($isCampaign : Boolean!) {\n  cardGroups(status: ENABLE, isCampaign: $isCampaign) {\n    __typename\n    id\n    name\n    type\n    kind\n    status\n    listOrder\n    extra\n    description\n    create\n    update\n  }\n}",
    "dynamicQ": 'query DynamicCards {\n  dynamicCards(groupId: "#groupId") {\n    __typename\n    id\n    type\n  }\n}',
    "staticQ": 'query StaticCard {\n  staticCards(groupId: "#groupId") {\n    __typename\n    id\n    title {\n      __typename\n      ...MultiLangTextFragment\n    }\n    type\n    lgBackground {\n      __typename\n      ...FileFragment\n    }\n    smBackground {\n      __typename\n      ...FileFragment\n    }\n    mov {\n      __typename\n      ...FileFragment\n    }\n    bgColor\n    fgColor\n    extra\n    description {\n      __typename\n      ...MultiLangTextFragment\n    }\n    status\n    width\n    height\n    create\n    update\n    campaign {\n      __typename\n      ...CampaignFragment\n    }\n    docLink {\n      __typename\n      ...DocLinkFragment\n    }\n    campaignRanks {\n      __typename\n      ...RankCardFragment\n    }\n    product {\n      __typename\n      ...UnpurchaseProductFragment\n    }\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}\nfragment DocLinkFragment on DocLink {\n  __typename\n  id\n  campaignId\n  title {\n    __typename\n    ...MultiLangTextFragment\n  }\n  link\n  type\n  lgImage {\n    __typename\n    ...FileFragment\n  }\n  status\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n  update\n}\nfragment RankCardFragment on RankCard {\n  __typename\n  campaign {\n    __typename\n    ...CampaignFragment\n  }\n  topRank {\n    __typename\n    ...RankRowFragment\n  }\n  userRank {\n    __typename\n    ...RankRowFragment\n  }\n}\nfragment RankRowFragment on RankRow {\n  __typename\n  user {\n    __typename\n    ...SimpleUserFragment\n  }\n  score\n  rank\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment UnpurchaseProductFragment on UnpurchaseProduct {\n  __typename\n  productId\n  productName\n}',
}
FAMILY_Q: Dict[str, str] = {
    "infoQ": "query FamilyInfo($uid: String!, $watchId: String!, $tz:String, $date:Int!) {\n  userSteps(uid: $uid, tz: $tz, date: $date) {\n    __typename\n    ...UserStepsFragment\n  }\n  subscribedCampaign(uid: $uid) {\n    __typename\n    ...SubscribedCampaignFragment\n  }\n  contacts(uid: $uid, watchId: $watchId) {\n    __typename\n    ...ContactListFragment\n  }\n  coinHistory(uid: $uid, tz: $tz) {\n    __typename\n    ...HistoryCoinListFragment\n  }\n}\nfragment UserStepsFragment on UserStep {\n  __typename\n  age\n  user {\n    __typename\n    ...UserFragment\n  }\n  day\n  monthSteps {\n    __typename\n    ...StepItemFragment\n  }\n  daySteps {\n    __typename\n    ...StepItemFragment\n  }\n  timeSteps {\n    __typename\n    ...StepItemFragment\n  }\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment StepItemFragment on StepItem {\n  __typename\n  key\n  step\n}\nfragment SubscribedCampaignFragment on CampaignSubscribed {\n  __typename\n  campaign {\n    __typename\n    id\n  }\n  user {\n    __typename\n    id\n  }\n  avatar {\n    __typename\n    ...FileFragment\n  }\n  profile {\n    __typename\n    ...FileFragment\n  }\n  name\n  subscribedDate\n}\nfragment ContactListFragment on XPContactList {\n  __typename\n  contacts {\n    __typename\n    ...ContactFragment\n  }\n  followRequest {\n    __typename\n    ...FollowRequestFragment\n  }\n}\nfragment ContactFragment on XPContact {\n  __typename\n  id\n  ownUser {\n    __typename\n    ...SimpleUserFragment\n  }\n  name\n  countryPhoneNumber\n  phoneNumber\n  contactUser {\n    __typename\n    ...SimpleUserFragment\n  }\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  approval\n  guardianType\n  create\n  update\n}\nfragment FollowRequestFragment on XPFollowRequest {\n  __typename\n  id\n  qid\n  deviceId\n  name\n  iconUrl\n  phoneNumber\n  countryCode\n  requestTime\n}\nfragment HistoryCoinListFragment on HistoryCoinList {\n  __typename\n  offset\n  limit\n  total\n  list {\n    __typename\n    ...HistoryCoinFragment\n  }\n}\nfragment HistoryCoinFragment on HistoryCoin {\n  __typename\n  id\n  user {\n    __typename\n    ...UserFragment\n  }\n  type\n  coin\n  totalCoin\n  step\n  campaign {\n    __typename\n    ...CampaignFragment\n  }\n  srcUser {\n    __typename\n    ...UserFragment\n  }\n  destUser {\n    __typename\n    ...UserFragment\n  }\n  create\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}",
}
MYINFO_Q: Dict[str, str] = {
    "getMyTotalInfoQ": "query GetMyTotalInfo($uid : String!, $tz : String, $date : Int!, $start : Int, $end: Int, $type: [CoinHistoryType], $offset: Int, $limit: Int) {\n  coinHistory(uid: $uid, tz: $tz, start: $start, end: $end, type: $type, offset: $offset, limit: $limit) {\n    __typename\n    ...HistoryCoinListFragment\n  }\n  userSteps(uid: $uid, tz: $tz, date: $date) {\n    __typename\n    ...UserStepsFragment\n  }\n  subscribedCampaign(uid: $uid) {\n    __typename\n    ...SubscribedCampaignFragment\n  }\n}\nfragment HistoryCoinListFragment on HistoryCoinList {\n  __typename\n  offset\n  limit\n  total\n  list {\n    __typename\n    ...HistoryCoinFragment\n  }\n}\nfragment HistoryCoinFragment on HistoryCoin {\n  __typename\n  id\n  user {\n    __typename\n    ...UserFragment\n  }\n  type\n  coin\n  totalCoin\n  step\n  campaign {\n    __typename\n    ...CampaignFragment\n  }\n  srcUser {\n    __typename\n    ...UserFragment\n  }\n  destUser {\n    __typename\n    ...UserFragment\n  }\n  create\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}\nfragment UserStepsFragment on UserStep {\n  __typename\n  age\n  user {\n    __typename\n    ...UserFragment\n  }\n  day\n  monthSteps {\n    __typename\n    ...StepItemFragment\n  }\n  daySteps {\n    __typename\n    ...StepItemFragment\n  }\n  timeSteps {\n    __typename\n    ...StepItemFragment\n  }\n}\nfragment StepItemFragment on StepItem {\n  __typename\n  key\n  step\n}\nfragment SubscribedCampaignFragment on CampaignSubscribed {\n  __typename\n  campaign {\n    __typename\n    id\n  }\n  user {\n    __typename\n    id\n  }\n  avatar {\n    __typename\n    ...FileFragment\n  }\n  profile {\n    __typename\n    ...FileFragment\n  }\n  name\n  subscribedDate\n}",
    "coinHistoryQ": "query MyInfoWithCoinHistory($uid: String!, $start: Int, $end: Int, $tz: String, $type: [CoinHistoryType], $offset: Int, $limit: Int) {\n  coinHistory(uid: $uid, start: $start, end: $end, tz: $tz, type: $type, offset: $offset, limit: $limit) {\n    __typename\n    ...HistoryCoinListFragment\n  }\n}\nfragment HistoryCoinListFragment on HistoryCoinList {\n  __typename\n  offset\n  limit\n  total\n  list {\n    __typename\n    ...HistoryCoinFragment\n  }\n}\nfragment HistoryCoinFragment on HistoryCoin {\n  __typename\n  id\n  user {\n    __typename\n    ...UserFragment\n  }\n  type\n  coin\n  totalCoin\n  step\n  campaign {\n    __typename\n    ...CampaignFragment\n  }\n  srcUser {\n    __typename\n    ...UserFragment\n  }\n  destUser {\n    __typename\n    ...UserFragment\n  }\n  create\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}",
    "readQ": "query ReadMyInfo {\n  readMyInfo {\n    __typename\n    ...UserFragment\n  }\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "readCampaignProfileQ": "query ReadMyInfoWithCampaignProfile {\n  campaignUserProfiles {\n    __typename\n    ...CampaignUserProfilesFragment\n  }\n  readMyInfo {\n    __typename\n    ...UserFragment\n  }\n  followRequestWatchCount\n}\nfragment CampaignUserProfilesFragment on CampaignUserProfile {\n  __typename\n  id\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  avatar {\n    __typename\n    ...AvatarFragment\n  }\n  profile {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment AvatarFragment on Avatar {\n  __typename\n  id\n  name\n  file {\n    __typename\n    ...FileFragment\n  }\n}",
}
REVIEW_Q: Dict[str, str] = {"getStatusQ": "query GetReviewStatus($uid: String!) {\n  getReviewStatus(uid: $uid)\n}"}
STEP_Q: Dict[str, str] = {
    "userQ": "query UserSteps($uid: String!, $tz: String, $date : Int!) {\n  userSteps(uid: $uid, tz : $tz, date: $date) {\n    __typename\n    ...UserStepsFragment\n  }\n}\nfragment UserStepsFragment on UserStep {\n  __typename\n  age\n  user {\n    __typename\n    ...UserFragment\n  }\n  day\n  monthSteps {\n    __typename\n    ...StepItemFragment\n  }\n  daySteps {\n    __typename\n    ...StepItemFragment\n  }\n  timeSteps {\n    __typename\n    ...StepItemFragment\n  }\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment StepItemFragment on StepItem {\n  __typename\n  key\n  step\n}",
}
UTILS_Q: Dict[str, str] = {
    "countriesQ": "query Countries {\n  countries(status: ENABLE) {\n    __typename\n    ...CountryFragment\n  }\n}\nfragment CountryFragment on Country {\n  __typename\n  id\n  code\n  name\n  status\n  listOrder\n  create\n}",
}
WATCH_Q: Dict[str, str] = {
    "alarmsQ": "query Alarms($uid: String!) {\n  alarms(uid: $uid) {\n    __typename\n    ...WatchAlarmFragment\n  }\n}\nfragment WatchAlarmFragment on WatchAlarm {\n  __typename\n  id\n  vendorName\n  vendorId\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  start\n  end\n  weekRepeat\n  occurMin\n  description\n  extra\n  start\n  create\n  update\n  status\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "askLocateQ": "query AskWatchLocate($uid: String!) {\n  askWatchLocate(uid: $uid)\n}",
    "chatsQ": "query Chats($uid : String!, $offset: Int, $limit: Int, $msgId: String) {\n  chatsNew(uid: $uid, offset: $offset, limit: $limit, msgId: $msgId) {\n    __typename\n    offset\n    limit\n    list {\n      __typename\n      ...SimpleChatFragment\n    }\n  }\n}\nfragment SimpleChatFragment on SimpleChat {\n  __typename\n  id\n  msgId\n  readFlag\n  type\n  sender {\n    __typename\n    ...SimpleUserFragment\n  }\n  receiver {\n    __typename\n    ...SimpleUserFragment\n  }\n  data\n  create\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "checkByQrCodeQ": "query CheckWatchByQrCode($qrCode: String) {\n  getSWInfo(qrCode: $qrCode) {\n    __typename\n    id\n    imei\n    deviceKey\n    vendorName\n    groupName\n    status\n    qrCode\n    qrT\n    qrC\n    bt\n    os\n    osName\n    osVersion\n    eid\n    serviceName\n    create\n    update\n  }\n}",
    "contactsQ": "query Contacts($uid: String) {\n  contacts(uid: $uid) {\n    __typename\n    ...ContactListFragment\n  }\n}\nfragment ContactListFragment on XPContactList {\n  __typename\n  contacts {\n    __typename\n    ...ContactFragment\n  }\n  followRequest {\n    __typename\n    ...FollowRequestFragment\n  }\n}\nfragment ContactFragment on XPContact {\n  __typename\n  id\n  ownUser {\n    __typename\n    ...SimpleUserFragment\n  }\n  name\n  countryPhoneNumber\n  phoneNumber\n  contactUser {\n    __typename\n    ...SimpleUserFragment\n  }\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  approval\n  guardianType\n  create\n  update\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment FollowRequestFragment on XPFollowRequest {\n  __typename\n  id\n  qid\n  deviceId\n  name\n  iconUrl\n  phoneNumber\n  countryCode\n  requestTime\n}",
    "fetchChatImageQ": "query FetchChatImage($uid: String!, $msgId: String!) {\n  fetchChatImage(uid: $uid, msgId: $msgId)\n}",
    "fetchChatMp3Q": "query FetchChatMp3($uid : String!, $msgId : String!) {\n  fetchChatMp3(uid: $uid, msgId: $msgId)\n}",
    "fetchChatShortVideoQ": "query FetchChatShortVideo($uid : String!, $msgId : String!) {\n  fetchChatShortVideo(uid: $uid, msgId: $msgId)\n}",
    "fetchChatVoiceQ": "query FetchChatVoice($uid : String!, $msgId : String!) {\n  fetchChatVoice(uid: $uid, msgId: $msgId)\n}",
    "getWifisQ": "query GetWifis($uid : String!) {\n  getWiFis(uid: $uid) {\n    __typename\n    ...WiFiFragment\n  }\n}\nfragment WiFiFragment on WiFi {\n  __typename\n  id\n  name\n  ssid\n  password\n  state\n  create\n  update\n  user {\n    __typename\n    ...UserFragment\n  }\n  watch {\n    __typename\n    ...WatchFragment\n  }\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}",
    "imeiQ": "query WatchImei($imei: String, $qrCode: String, $deviceKey: String) {\n  watchImei(imei: $imei, qrCode: $qrCode, deviceKey: $deviceKey) {\n    __typename\n    id\n    imei\n    deviceKey\n    vendorName\n    groupName\n    status\n    qrCode\n    qrT\n    qrC\n    bt\n    os\n    osName\n    osVersion\n    eid\n    create\n    update\n  }\n}",
    "locHistoryQ": "query LocHistory($uid : String!, $date: Int, $tz: String, $limit: Int!) {\n  locHistory(uid: $uid, date: $date, tz: $tz, limit: $limit) {\n    __typename\n    offset\n    limit\n    list {\n      __typename\n      ...SimepleLocation\n    }\n  }\n}\nfragment SimepleLocation on SimpleLocation {\n  __typename\n  type\n  tm\n  lat\n  lng\n  rad\n  country\n  countryAbbr\n  province\n  city\n  addr\n  poi\n  locateType\n}",
    "locateQ": "query WatchLastLocate($uid: String!) {\n  watchLastLocate(uid: $uid) {\n    __typename\n    ...WatchLastLocateFragment\n  }\n}\nfragment WatchLastLocateFragment on Location {\n  __typename\n  tm\n  lat\n  lng\n  rad\n  country\n  countryAbbr\n  province\n  city\n  addr\n  poi\n  battery\n  isCharging\n  isAdjusted\n  locateType\n  step\n  distance\n  isInSafeZone\n  safeZoneLabel\n}",
    "stateQ": "query WatchState($qrCode : String!, $qrt: String!, $qrc: String!) {\n  getWatchState(qrCode: $qrCode, qrt: $qrt, qrc: $qrc) {\n    __typename\n    ...WatchStateFragment\n  }\n}\nfragment WatchStateFragment on WatchState {\n  __typename\n  state\n  pn\n  countryCode\n  deviceType\n}",
    "safeZoneGroupsQ": "query SafeZoneGroups {\n  safeZoneGroups(status: ENABLE) {\n    __typename\n    ...SafeZoneGroupFragment\n  }\n}\nfragment SafeZoneGroupFragment on SafeZoneGroup {\n  __typename\n  id\n  name\n  status\n  description\n  create\n  update\n}",
    "safeZonesQ": "query SafeZones($uid: String!) {\n  safeZones(uid: $uid) {\n    __typename\n    ...SafeZoneFragment\n  }\n}\nfragment SafeZoneFragment on SafeZone {\n  __typename\n  id\n  vendorName\n  vendorId\n  groupName\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  group {\n    __typename\n    ...SafeZoneGroupFragment\n  }\n  name\n  lat\n  lng\n  rad\n  address\n  description\n  extra\n  create\n  update\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment SafeZoneGroupFragment on SafeZoneGroup {\n  __typename\n  id\n  name\n  status\n  description\n  create\n  update\n}",
    "silentTimesQ": "query SlientTimes($uid : String!) {\n  silentTimes(uid: $uid) {\n    __typename\n    ...SilentModeFragment\n  }\n}\nfragment SilentModeFragment on SilentMode {\n  __typename\n  id\n  vendorName\n  vendorId\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  start\n  end\n  weekRepeat\n  description\n  extra\n  status\n  create\n  update\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "trackQ": "query TrackWatch($uid: String!) {\n  trackWatch(uid: $uid)\n}",
    "unReadChatMsgCountQ": "query UnReadChatMsgCount($uid : String!) {\n  unReadChatMsgCount(uid: $uid)\n}",
    "watchesDynamicQ": 'query WatchesDynamic {\n  watches(uid: "#userId") {\n    __typename\n    ...WatchFragment\n  }\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}',
    "watchesQ": "query Watches($uid: String) {\n  watches(uid: $uid) {\n    __typename\n    ...WatchFragment\n  }\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "startTrackingWatchQ": "query StartTrackingWatch($uid: String!) {\n  startTrackingWatch(uid: $uid)\n}",
}
WATCHGROUP_Q: Dict[str, str] = {
    "watchGroupsQ": "query WatchGroups($id : String) {\n  watchGroups(id: $id) {\n    __typename\n    ...WatchGroupFragment\n  }\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}",
}
XCOIN_Q: Dict[str, str] = {
    "historyQ": "query CoinHistory($uid: String!, $start: Int, $end: Int, $type: [CoinHistoryType], $offset: Int, $limit: Int) {\n  coinHistory(uid: $uid, start: $start, end: $end, type: $type, offset: $offset, limit: $limit) {\n    __typename\n    ...HistoryCoinListFragment\n  }\n}\nfragment HistoryCoinListFragment on HistoryCoinList {\n  __typename\n  offset\n  limit\n  total\n  list {\n    __typename\n    ...HistoryCoinFragment\n  }\n}\nfragment HistoryCoinFragment on HistoryCoin {\n  __typename\n  id\n  user {\n    __typename\n    ...UserFragment\n  }\n  type\n  coin\n  totalCoin\n  step\n  campaign {\n    __typename\n    ...CampaignFragment\n  }\n  srcUser {\n    __typename\n    ...UserFragment\n  }\n  destUser {\n    __typename\n    ...UserFragment\n  }\n  create\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment CampaignFragment on Campaign {\n  __typename\n  id\n  category {\n    __typename\n    ...CampaignCategoryFragment\n  }\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  lgProfile {\n    __typename\n    ...FileFragment\n  }\n  cardProfile {\n    __typename\n    ...FileFragment\n  }\n  cardMov {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  description {\n    __typename\n    ...MultiLangTextFragment\n  }\n  content {\n    __typename\n    ...MultiLangTextFragment\n  }\n  rewardDescription {\n    __typename\n    ...MultiLangTextFragment\n  }\n  tags {\n    __typename\n    ...CampaignTagFragmet\n  }\n  extra\n  start\n  end\n  status\n  new\n  hot\n  create\n  update\n}\nfragment CampaignCategoryFragment on CampaignCategory {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  status\n  create\n  update\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment MultiLangTextFragment on MultiLangText {\n  __typename\n  id\n  key\n  langId\n  langKey\n  text\n  type\n  create\n}\nfragment CampaignTagFragmet on CampaignTag {\n  __typename\n  id\n  name {\n    __typename\n    ...MultiLangTextFragment\n  }\n  create\n}",
}
XMOVE_Q: Dict[str, str] = {
    "remindersQ": "query Reminders($uid: String!) {\n  reminders(uid: $uid) {\n    __typename\n    ...WatchReminderFragment\n  }\n}\nfragment WatchReminderFragment on WatchReminder {\n  __typename\n  id\n  vendorName\n  vendorId\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  start\n  end\n  weekRepeat\n  occurMin\n  extra\n  start\n  create\n  update\n  status\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
}
