"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionSecretStack = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("../../constructs");
class ActionSecretStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const sourceSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'secretToStoreInGitHub', 'cdk-github/test/structured');
        const githubTokenSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'ghSecret', 'GITHUB_TOKEN');
        new constructs_1.ActionSecret(this, 'GitHubActionSecret', {
            githubTokenSecret,
            repository: { name: 'cdk-github', owner: 'wtfjoke' },
            repositorySecretName: 'A_RANDOM_GITHUB_SECRET',
            sourceSecret,
            sourceSecretJsonField: 'key',
        });
    }
}
exports.ActionSecretStack = ActionSecretStack;
//# sourceMappingURL=data:application/json;base64,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