"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionEnvironmentSecretStack = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("../../constructs");
class ActionEnvironmentSecretStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const sourceSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'secretToStoreInGitHub', 'testcdkgithub');
        const githubTokenSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'ghSecret', 'GITHUB_TOKEN');
        new constructs_1.ActionEnvironmentSecret(this, 'GitHubActionEnvironmentSecret', {
            githubTokenSecret,
            environment: 'dev',
            repository: { name: 'cdk-github', owner: 'wtfjoke' },
            repositorySecretName: 'A_RANDOM_GITHUB_SECRET',
            sourceSecret,
        });
    }
}
exports.ActionEnvironmentSecretStack = ActionEnvironmentSecretStack;
//# sourceMappingURL=data:application/json;base64,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