"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const action_secrets_1 = require("../handler/secrets/action-secrets");
class ActionSecret extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { githubTokenSecret, repositorySecretName, repository, sourceSecret, sourceSecretJsonField } = props;
        const awsRegion = aws_cdk_lib_1.Stack.of(this).region;
        const shortId = aws_cdk_lib_1.Names.uniqueId(this).slice(-8);
        const handler = new action_secrets_1.ActionSecretHandlerFunction(this, 'CustomResourceHandler', {
            functionName: 'GitHubActionSecretCustomResourceHandler' + shortId,
            description: 'Handles the creation/deletion of a GitHub Action (repository) secret - created by cdk-github',
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        githubTokenSecret.grantRead(handler);
        sourceSecret.grantRead(handler);
        const provider = new custom_resources_1.Provider(this, 'SecretProvider', {
            onEventHandler: handler,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
        });
        const githubRepositorySecretEventProps = {
            githubTokenSecret: githubTokenSecret.secretArn,
            repositoryOwner: repository.owner,
            repositoryName: repository.name,
            sourceSecretArn: sourceSecret.secretArn,
            sourceSecretJsonField,
            repositorySecretName,
            awsRegion,
        };
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::GitHubActionSecret',
            properties: githubRepositorySecretEventProps,
        });
    }
}
exports.ActionSecret = ActionSecret;
_a = JSII_RTTI_SYMBOL_1;
ActionSecret[_a] = { fqn: "cdk-github.ActionSecret", version: "0.0.37" };
//# sourceMappingURL=data:application/json;base64,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