import setuptools
import os
import sys
import shutil
import distutils.cmd

from typing import List

VERSION = "0.0.1"

class PypiCommand(distutils.cmd.Command):
    
    description = "Build and upload for PyPi."
    user_options = []
    
    def initialize_options(self):
        pass
    
    
    def finalize_options(self):
        pass
    
    
    def run(self):
        shutil.rmtree("dist/")
        
        wheel_file = "PyCytoData-{}-py3-none-any.whl".format(VERSION)
        tar_file = "PyCytoData-{}.tar.gz".format(VERSION)
        
        os.system("{} setup.py sdist bdist_wheel".format(sys.executable))
        os.system("twine upload dist/{} dist/{}".format(wheel_file, tar_file))
    
    
class CondaCommand(distutils.cmd.Command):
    
    description = "Build and upload for conda."
    user_options = []
    
    
    @staticmethod
    def move_assets(origin: str, destination: str, exclude: List[str], new_destination_dir: bool) -> None:
        
        if origin[-1] != "\\" and origin[-1] != "/":
            origin += "/"
            
        if destination[-1] != "\\" and destination[-1] != "/":
            destination += "/"
        
        if new_destination_dir:    
            if os.path.isdir(destination):
                raise ValueError("Destination directory already exists.")
            else:
                os.mkdir(destination)
            
        all_files = os.listdir(origin)
        
        for files in all_files:
            if files in exclude:
                pass
            else:
                origin_path = origin + files
                destination_path = destination + files
                shutil.move(origin_path, destination_path)
        
    
    def initialize_options(self):
        pass
    
    
    def finalize_options(self):
        pass
    
    
    def run(self):
        self.move_assets("./PyCytoData/data/", "../temp_assets/", [], True)
        shutil.rmtree("./PyCytoData/data/")
        shutil.rmtree("dist_conda/")
        os.system("conda build . --output-folder dist_conda/")
        os.system("anaconda upload ./dist_conda/noarch/pycytodata-{}-py_0.tar.bz2".format(VERSION))
        
        self.move_assets("../temp_assets/", "./PyCytoData/data/", [], False)
        shutil.rmtree("../temp_assets/")


setuptools.setup(
    name = "PyCytoData",
    version = VERSION,
    description = "An Elegant Data Analysis Tool for CyTOF",
    long_description_content_type = "text/markdown",
    long_description = open("README.md").read(),
    packages=["PyCytoData"],
    python_requires=">=3.7",
    install_requires=["fcsparser", "pandas", "numpy"],
    test_requires=["pytest",
                   "pytest-cov",
                   "pytest-mock",
                   "coverage"],
    classifiers = [
        "Programming Language :: Python :: 3 :: Only",
        "Natural Language :: English"
    ],
    cmdclass = {"pypi": PypiCommand,
                "conda": CondaCommand
                }
)