import { Construct } from 'constructs';
import { Chain } from '..';
import { IChainable, INextable } from '../types';
import { State } from './state';
/**
 * Properties for defining a custom state definition.
 *
 * @stability stable
 */
export interface CustomStateProps {
    /**
     * Amazon States Language (JSON-based) definition of the state.
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html
     * @stability stable
     */
    readonly stateJson: {
        [key: string]: any;
    };
}
/**
 * State defined by supplying Amazon States Language (ASL) in the state machine.
 *
 * @stability stable
 */
export declare class CustomState extends State implements IChainable, INextable {
    /**
     * Continuable states of this Chainable.
     *
     * @stability stable
     */
    readonly endStates: INextable[];
    /**
     * Amazon States Language (JSON-based) definition of the state
     */
    private readonly stateJson;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CustomStateProps);
    /**
     * Continue normal execution with the given state.
     *
     * @stability stable
     */
    next(next: IChainable): Chain;
    /**
     * Returns the Amazon States Language object for this state.
     *
     * @stability stable
     */
    toStateJson(): object;
}
