# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
import pulumi_aws

__all__ = ['IamServiceAccountRoleArgs', 'IamServiceAccountRole']

@pulumi.input_type
class IamServiceAccountRoleArgs:
    def __init__(__self__, *,
                 namespace_name: pulumi.Input[str],
                 oidc_provider_arn: pulumi.Input[str],
                 oidc_provider_url: pulumi.Input[str],
                 service_account_name: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a IamServiceAccountRole resource.
        :param pulumi.Input[str] namespace_name: The namespace to create the service account in.
        :param pulumi.Input[str] oidc_provider_arn: The arn of the OIDC provider attached to your EKS cluster.
        :param pulumi.Input[str] oidc_provider_url: The URL of the OIDC provider attached to your EKS cluster.
        :param pulumi.Input[str] service_account_name: The name of the service account to bind to the role
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of tags to apply to the service account.
        """
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "oidc_provider_arn", oidc_provider_arn)
        pulumi.set(__self__, "oidc_provider_url", oidc_provider_url)
        pulumi.set(__self__, "service_account_name", service_account_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Input[str]:
        """
        The namespace to create the service account in.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter(name="oidcProviderArn")
    def oidc_provider_arn(self) -> pulumi.Input[str]:
        """
        The arn of the OIDC provider attached to your EKS cluster.
        """
        return pulumi.get(self, "oidc_provider_arn")

    @oidc_provider_arn.setter
    def oidc_provider_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "oidc_provider_arn", value)

    @property
    @pulumi.getter(name="oidcProviderUrl")
    def oidc_provider_url(self) -> pulumi.Input[str]:
        """
        The URL of the OIDC provider attached to your EKS cluster.
        """
        return pulumi.get(self, "oidc_provider_url")

    @oidc_provider_url.setter
    def oidc_provider_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "oidc_provider_url", value)

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> pulumi.Input[str]:
        """
        The name of the service account to bind to the role
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_account_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of tags to apply to the service account.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class IamServiceAccountRole(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 oidc_provider_arn: Optional[pulumi.Input[str]] = None,
                 oidc_provider_url: Optional[pulumi.Input[str]] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a IamServiceAccountRole resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] namespace_name: The namespace to create the service account in.
        :param pulumi.Input[str] oidc_provider_arn: The arn of the OIDC provider attached to your EKS cluster.
        :param pulumi.Input[str] oidc_provider_url: The URL of the OIDC provider attached to your EKS cluster.
        :param pulumi.Input[str] service_account_name: The name of the service account to bind to the role
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of tags to apply to the service account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamServiceAccountRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a IamServiceAccountRole resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param IamServiceAccountRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamServiceAccountRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 oidc_provider_arn: Optional[pulumi.Input[str]] = None,
                 oidc_provider_url: Optional[pulumi.Input[str]] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamServiceAccountRoleArgs.__new__(IamServiceAccountRoleArgs)

            if namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_name'")
            __props__.__dict__["namespace_name"] = namespace_name
            if oidc_provider_arn is None and not opts.urn:
                raise TypeError("Missing required property 'oidc_provider_arn'")
            __props__.__dict__["oidc_provider_arn"] = oidc_provider_arn
            if oidc_provider_url is None and not opts.urn:
                raise TypeError("Missing required property 'oidc_provider_url'")
            __props__.__dict__["oidc_provider_url"] = oidc_provider_url
            if service_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_name'")
            __props__.__dict__["service_account_name"] = service_account_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["role"] = None
        super(IamServiceAccountRole, __self__).__init__(
            'lbrlabs-eks:index:IamServiceAccountRole',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output['pulumi_aws.iam.Role']:
        return pulumi.get(self, "role")

