# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *
import pulumi_kubernetes

__all__ = ['AutoscaledNodeGroupArgs', 'AutoscaledNodeGroup']

@pulumi.input_type
class AutoscaledNodeGroupArgs:
    def __init__(__self__, *,
                 disk_size: Optional[pulumi.Input[str]] = None,
                 node_role: pulumi.Input[str],
                 requirements: pulumi.Input[Sequence[pulumi.Input['RequirementArgs']]],
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 ami_family: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disruption: Optional[pulumi.Input['DisruptionConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.TaintArgs']]]] = None):
        """
        The set of arguments for constructing a AutoscaledNodeGroup resource.
        :param pulumi.Input[str] disk_size: Disk size for the node group.
        :param pulumi.Input[str] node_role: Node role for the node group.
        :param pulumi.Input[Sequence[pulumi.Input['RequirementArgs']]] requirements: List of requirements for the node group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of security group selector terms for the node group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet selector terms for the node group.
        :param pulumi.Input[str] ami_family: AMI family for the node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations to apply to the node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.TaintArgs']]] taints: Optional node taints.
        """
        if disk_size is None:
            disk_size = '20Gi'
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "node_role", node_role)
        pulumi.set(__self__, "requirements", requirements)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if ami_family is not None:
            pulumi.set(__self__, "ami_family", ami_family)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if disruption is not None:
            pulumi.set(__self__, "disruption", disruption)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Input[str]:
        """
        Disk size for the node group.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> pulumi.Input[str]:
        """
        Node role for the node group.
        """
        return pulumi.get(self, "node_role")

    @node_role.setter
    def node_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_role", value)

    @property
    @pulumi.getter
    def requirements(self) -> pulumi.Input[Sequence[pulumi.Input['RequirementArgs']]]:
        """
        List of requirements for the node group.
        """
        return pulumi.get(self, "requirements")

    @requirements.setter
    def requirements(self, value: pulumi.Input[Sequence[pulumi.Input['RequirementArgs']]]):
        pulumi.set(self, "requirements", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of security group selector terms for the node group.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of subnet selector terms for the node group.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="amiFamily")
    def ami_family(self) -> Optional[pulumi.Input[str]]:
        """
        AMI family for the node group.
        """
        return pulumi.get(self, "ami_family")

    @ami_family.setter
    def ami_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_family", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations to apply to the node group.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def disruption(self) -> Optional[pulumi.Input['DisruptionConfigArgs']]:
        return pulumi.get(self, "disruption")

    @disruption.setter
    def disruption(self, value: Optional[pulumi.Input['DisruptionConfigArgs']]):
        pulumi.set(self, "disruption", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.TaintArgs']]]]:
        """
        Optional node taints.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_kubernetes.core.v1.TaintArgs']]]]):
        pulumi.set(self, "taints", value)


class AutoscaledNodeGroup(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_family: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disk_size: Optional[pulumi.Input[str]] = None,
                 disruption: Optional[pulumi.Input[pulumi.InputType['DisruptionConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_role: Optional[pulumi.Input[str]] = None,
                 requirements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RequirementArgs']]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.TaintArgs']]]]] = None,
                 __props__=None):
        """
        Create a AutoscaledNodeGroup resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ami_family: AMI family for the node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations to apply to the node group.
        :param pulumi.Input[str] disk_size: Disk size for the node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        :param pulumi.Input[str] node_role: Node role for the node group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RequirementArgs']]]] requirements: List of requirements for the node group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of security group selector terms for the node group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet selector terms for the node group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.TaintArgs']]]] taints: Optional node taints.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutoscaledNodeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AutoscaledNodeGroup resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AutoscaledNodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutoscaledNodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_family: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disk_size: Optional[pulumi.Input[str]] = None,
                 disruption: Optional[pulumi.Input[pulumi.InputType['DisruptionConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_role: Optional[pulumi.Input[str]] = None,
                 requirements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RequirementArgs']]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_kubernetes.core.v1.TaintArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutoscaledNodeGroupArgs.__new__(AutoscaledNodeGroupArgs)

            __props__.__dict__["ami_family"] = ami_family
            __props__.__dict__["annotations"] = annotations
            if disk_size is None:
                disk_size = '20Gi'
            if disk_size is None and not opts.urn:
                raise TypeError("Missing required property 'disk_size'")
            __props__.__dict__["disk_size"] = disk_size
            __props__.__dict__["disruption"] = disruption
            __props__.__dict__["labels"] = labels
            if node_role is None and not opts.urn:
                raise TypeError("Missing required property 'node_role'")
            __props__.__dict__["node_role"] = node_role
            if requirements is None and not opts.urn:
                raise TypeError("Missing required property 'requirements'")
            __props__.__dict__["requirements"] = requirements
            if security_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_ids'")
            __props__.__dict__["security_group_ids"] = security_group_ids
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["taints"] = taints
        super(AutoscaledNodeGroup, __self__).__init__(
            'lbrlabs-eks:index:AutoscaledNodeGroup',
            resource_name,
            __props__,
            opts,
            remote=True)

