# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'BudgetConfigArgs',
    'DisruptionConfigArgs',
    'IngressConfigArgs',
    'RequirementArgs',
]

@pulumi.input_type
class BudgetConfigArgs:
    def __init__(__self__, *,
                 duration: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None):
        """
        Configuration for Autoscaled Node budgets.
        :param pulumi.Input[str] duration: The duration during which disruptuon can happen.
        :param pulumi.Input[str] nodes: The maximum number of nodes that can be scaled down at any time.
        :param pulumi.Input[str] schedule: A cron schedule for when disruption can happen.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration during which disruptuon can happen.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum number of nodes that can be scaled down at any time.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        A cron schedule for when disruption can happen.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)


@pulumi.input_type
class DisruptionConfigArgs:
    def __init__(__self__, *,
                 budgets: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetConfigArgs']]]] = None,
                 consolidate_after: Optional[pulumi.Input[str]] = None,
                 consolidation_policy: Optional[pulumi.Input[str]] = None,
                 expire_after: Optional[pulumi.Input[str]] = None):
        """
        Configuration for Autoscaled nodes disruption.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetConfigArgs']]] budgets: Budgets control the speed Karpenter can scale down nodes.
        :param pulumi.Input[str] consolidate_after: The amount of time Karpenter should wait after discovering a consolidation decision. This value can currently only be set when the consolidationPolicy is 'WhenEmpty'. You can choose to disable consolidation entirely by setting the string value 'Never' here.
        :param pulumi.Input[str] consolidation_policy: Describes which types of Nodes Karpenter should consider for consolidation.
        :param pulumi.Input[str] expire_after: The amount of time a Node can live on the cluster before being removed.
        """
        if budgets is not None:
            pulumi.set(__self__, "budgets", budgets)
        if consolidate_after is not None:
            pulumi.set(__self__, "consolidate_after", consolidate_after)
        if consolidation_policy is None:
            consolidation_policy = 'WhenEmpty'
        if consolidation_policy is not None:
            pulumi.set(__self__, "consolidation_policy", consolidation_policy)
        if expire_after is not None:
            pulumi.set(__self__, "expire_after", expire_after)

    @property
    @pulumi.getter
    def budgets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetConfigArgs']]]]:
        """
        Budgets control the speed Karpenter can scale down nodes.
        """
        return pulumi.get(self, "budgets")

    @budgets.setter
    def budgets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetConfigArgs']]]]):
        pulumi.set(self, "budgets", value)

    @property
    @pulumi.getter(name="consolidateAfter")
    def consolidate_after(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time Karpenter should wait after discovering a consolidation decision. This value can currently only be set when the consolidationPolicy is 'WhenEmpty'. You can choose to disable consolidation entirely by setting the string value 'Never' here.
        """
        return pulumi.get(self, "consolidate_after")

    @consolidate_after.setter
    def consolidate_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consolidate_after", value)

    @property
    @pulumi.getter(name="consolidationPolicy")
    def consolidation_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Describes which types of Nodes Karpenter should consider for consolidation.
        """
        return pulumi.get(self, "consolidation_policy")

    @consolidation_policy.setter
    def consolidation_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consolidation_policy", value)

    @property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time a Node can live on the cluster before being removed.
        """
        return pulumi.get(self, "expire_after")

    @expire_after.setter
    def expire_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_after", value)


@pulumi.input_type
class IngressConfigArgs:
    def __init__(__self__, *,
                 additional_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 controller_replicas: Optional[pulumi.Input[float]] = None,
                 enable_metrics: Optional[pulumi.Input[bool]] = None,
                 enable_service_monitor: Optional[pulumi.Input[bool]] = None,
                 nlb_target_type: Optional[pulumi.Input[str]] = None,
                 service_monitor_namespace: Optional[pulumi.Input[str]] = None):
        """
        Configuration for the ingress controller.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_config: Additional configuration for the ingress controller.
        :param pulumi.Input[float] controller_replicas: The number of replicas of the ingress controller.
        :param pulumi.Input[bool] enable_metrics: Enable metrics for the ingress controller.
        :param pulumi.Input[bool] enable_service_monitor: Enable the service monitor for kube-prometheus-stackl.
        :param pulumi.Input[str] nlb_target_type: NLB target type for NLB loadbalancers.
        :param pulumi.Input[str] service_monitor_namespace: The namespace to deploy the service monitor to.
        """
        if additional_config is not None:
            pulumi.set(__self__, "additional_config", additional_config)
        if controller_replicas is None:
            controller_replicas = 1
        if controller_replicas is not None:
            pulumi.set(__self__, "controller_replicas", controller_replicas)
        if enable_metrics is None:
            enable_metrics = False
        if enable_metrics is not None:
            pulumi.set(__self__, "enable_metrics", enable_metrics)
        if enable_service_monitor is None:
            enable_service_monitor = False
        if enable_service_monitor is not None:
            pulumi.set(__self__, "enable_service_monitor", enable_service_monitor)
        if nlb_target_type is None:
            nlb_target_type = 'ip'
        if nlb_target_type is not None:
            pulumi.set(__self__, "nlb_target_type", nlb_target_type)
        if service_monitor_namespace is not None:
            pulumi.set(__self__, "service_monitor_namespace", service_monitor_namespace)

    @property
    @pulumi.getter(name="additionalConfig")
    def additional_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional configuration for the ingress controller.
        """
        return pulumi.get(self, "additional_config")

    @additional_config.setter
    def additional_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "additional_config", value)

    @property
    @pulumi.getter(name="controllerReplicas")
    def controller_replicas(self) -> Optional[pulumi.Input[float]]:
        """
        The number of replicas of the ingress controller.
        """
        return pulumi.get(self, "controller_replicas")

    @controller_replicas.setter
    def controller_replicas(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "controller_replicas", value)

    @property
    @pulumi.getter(name="enableMetrics")
    def enable_metrics(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable metrics for the ingress controller.
        """
        return pulumi.get(self, "enable_metrics")

    @enable_metrics.setter
    def enable_metrics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_metrics", value)

    @property
    @pulumi.getter(name="enableServiceMonitor")
    def enable_service_monitor(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the service monitor for kube-prometheus-stackl.
        """
        return pulumi.get(self, "enable_service_monitor")

    @enable_service_monitor.setter
    def enable_service_monitor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_service_monitor", value)

    @property
    @pulumi.getter(name="nlbTargetType")
    def nlb_target_type(self) -> Optional[pulumi.Input[str]]:
        """
        NLB target type for NLB loadbalancers.
        """
        return pulumi.get(self, "nlb_target_type")

    @nlb_target_type.setter
    def nlb_target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nlb_target_type", value)

    @property
    @pulumi.getter(name="serviceMonitorNamespace")
    def service_monitor_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to deploy the service monitor to.
        """
        return pulumi.get(self, "service_monitor_namespace")

    @service_monitor_namespace.setter
    def service_monitor_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_monitor_namespace", value)


@pulumi.input_type
class RequirementArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a single requirement with key, operator, and values.
        :param pulumi.Input[str] key: The key of the requirement.
        :param pulumi.Input[str] operator: The operator for the requirement (e.g., In, Gt).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The list of values for the requirement.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the requirement.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        """
        The operator for the requirement (e.g., In, Gt).
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of values for the requirement.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


