# T1548.001 - Privesc: Setuid and Setgid
Setuid and setgid are bits that can allow a process to run with the privileges of the owning user or group of a file. These set of tests enumerate various ways that these values can be set. It then verifies that the appropriate bits have been set on the file. 

These tests enumerate various ways to set the setuid and setgid bits on a given binary. They try to show different built in tools that are capable of doing this as well as doing it with the syscall directly. The list of tools is not exhaustive as there are likely many ways to set those bits. It does however try and show what common command line args will look like

## Showing the available tests
To show which tests are available for this specific technique you can run
```python
python -m poisxath linux -t T1548_001 --list
```

## Running the tests
To run all the tests
```python
python -m posixath linux -t T1548_001
```

To run just the tests that use the setuid bit
```python
python -m posixath linux -t T1548_001 -k "TestSetUid"
```

To run a specific test in a class
```python
python -m posixath linux -t T1548_001 -k "TestSetGid and install"
```

To run a specific variation of a test in a class
```python
python -m posixath linux -t T1548_001 -k "TestSetGid and chmod and 2755 and not rsync"
```

## Inputs
None

## Output
`activity_at_ts` - The time at which the event occured

`command_line` - The command line that was executed that generated the event

`cwd` - The current working directory

`gid` - The group id of the process that was run

`md5` - The MD5 sum of the executable that was run

`pid` - The pid of the process that was run
 
`ppid` - The parent pid of the process that was run

`process_path` - The path to the executable that was run

`result` - This value is a string that will be either "success" or "failed"

`return_code` - The return code from the process that was run

`stderr` - Any output written to stderr

`stdin` - Any data written to stdin

`stdout` - Any output written to stdout

`uid` - The user id of the process

## Example
```json
{
  "activity_at_ts": "2022-09-20T08:04:04.104Z",
  "command_line": "/usr/bin/chmod u+s /usr/bin/cat",
  "cwd": "/home/user",
  "gid": 0,
  "md5": "739483b900c045ae1374d6f53a86a279",
  "pid": 40137,
  "ppid": 40135,
  "process_path": "/usr/bin/chmod",
  "result": "success",
  "return_code": 0,
  "stderr": "",
  "stdin": null,
  "stdout": " ",
  "uid": 0
}
```