# T1018 - Remote System Discovery
This set of tests if fairly straight forward. They enumerate many of the common tools found on Linux distributions that are able to help identify external connections to the host machine. The goal of this test is to simulate events that would be associated with a handful of System Discovery commands. The list of system discovery tools is not exhaustive as that would be impractical. Instead it is a list of common commands that can be found on many distributions of linux. If you want to add additional commands it is trivial to update the `@pytest.mark.parametrize` section of `test_t1018.py`

## Running the tests
This will run all the tests for this technique id
```python
python -m posixath linux -t t1018
```

This will run the `ping` variation
```python
python -m posixath linux -t T1018 -k "ping"
```

This will run just the `ip neigh show` variation and now the `ip route` variation
```python
python -m posixath linux -t T1018 -k "ip and neigh"
```
## Inputs
None

## Output
`activity_at_ts` - The time at which the event occured

`command_line` - The command line that was executed that generated the event

`cwd` - The current working directory

`gid` - The group id of the process that was run

`md5` - The MD5 sum of the executable that was run

`pid` - The pid of the process that was run
 
`ppid` - The parent pid of the process that was run

`process_path` - The path to the executable that was run

`result` - This value is a string that will be either "success" or "failed"

`return_code` - The return code from the process that was run

`stderr` - Any output written to stderr

`stdin` - Any data written to stdin

`stdout` - Any output written to stdout

`uid` - The user id of the process

## Example
```
tests/linux/test_T1018.py::TestRemoteSystemDiscovery::test_remote_system_discovery[ping -c 1 127.0.0.1] 
{
  "activity_at_ts": "2022-09-19T18:03:09.725Z",
  "command_line": "/usr/bin/ping -c 1 127.0.0.1",
  "cwd": "/home/user",
  "gid": 1000,
  "md5": "011938c0b4f0d4a8cdc9bbe6fd2389a9",
  "pid": 27324,
  "ppid": 27282,
  "process_path": "/usr/bin/ping",
  "result": "success",
  "return_code": 0,
  "stderr": "",
  "stdin": null,
  "stdout": "PING 127.0.0.1 (127.0.0.1) 56(84) bytes of data.\n64 bytes from 127.0.0.1: icmp_seq=1 ttl=64 time=0.050 ms\n\n--- 127.0.0.1 ping statistics ---\n1 packets transmitted, 1 received, 0% packet loss, time 0ms\nrtt min/avg/max/mdev = 0.050/0.050/0.050/0.000 ms\n ",
  "uid": 1000
}
```