"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcIngressConnection = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The App Runner VPC Ingress Connection
 *
 * @resource AWS::AppRunner::VpcIngressConnection
 */
class VpcIngressConnection extends cdk.Resource {
    /**
     * Import from VPC Ingress Connection from attributes.
     */
    static fromVpcIngressConnectionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcIngressConnectionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVpcIngressConnectionAttributes);
            }
            throw error;
        }
        const vpcIngressConnectionArn = attrs.vpcIngressConnectionArn;
        const domainName = attrs.domainName;
        const status = attrs.status;
        const vpcIngressConnectionName = attrs.vpcIngressConnectionName;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcIngressConnectionArn = vpcIngressConnectionArn;
                this.domainName = domainName;
                this.status = status;
                this.vpcIngressConnectionName = vpcIngressConnectionName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports an App Runner VPC Ingress Connection from its ARN
     */
    static fromArn(scope, id, vpcIngressConnectionArn) {
        const resourceParts = cdk.Fn.split('/', vpcIngressConnectionArn);
        const vpcIngressConnectionName = cdk.Fn.select(0, resourceParts);
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcIngressConnectionName = vpcIngressConnectionName;
                this.vpcIngressConnectionArn = vpcIngressConnectionArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.vpcIngressConnectionName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcIngressConnectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcIngressConnection);
            }
            throw error;
        }
        if (props.vpcIngressConnectionName !== undefined && !cdk.Token.isUnresolved(props.vpcIngressConnectionName)) {
            if (props.vpcIngressConnectionName.length < 4 || props.vpcIngressConnectionName.length > 40) {
                throw new Error(`\`vpcIngressConnectionName\` must be between 4 and 40 characters, got: ${props.vpcIngressConnectionName.length} characters.`);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.vpcIngressConnectionName)) {
                throw new Error(`\`vpcIngressConnectionName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.vpcIngressConnectionName}.`);
            }
        }
        const resource = new aws_apprunner_1.CfnVpcIngressConnection(this, 'Resource', {
            ingressVpcConfiguration: {
                vpcEndpointId: props.interfaceVpcEndpoint.vpcEndpointId,
                vpcId: props.vpc.vpcId,
            },
            serviceArn: props.service.serviceArn,
            vpcIngressConnectionName: this.physicalName,
        });
        this.vpcIngressConnectionArn = resource.attrVpcIngressConnectionArn;
        this.vpcIngressConnectionName = resource.ref;
        this.domainName = resource.attrDomainName;
        this.status = resource.attrStatus;
    }
}
exports.VpcIngressConnection = VpcIngressConnection;
_a = JSII_RTTI_SYMBOL_1;
VpcIngressConnection[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.VpcIngressConnection", version: "2.177.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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