import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as cdk from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
import { IService } from './service';
/**
 * Properties of the AppRunner VPC Ingress Connection
 */
export interface VpcIngressConnectionProps {
    /**
     * The name for the VPC Ingress Connection.
     *
     * @default - a name generated by CloudFormation
     */
    readonly vpcIngressConnectionName?: string;
    /**
     * The service to connect.
     */
    readonly service: IService;
    /**
     * The VPC for the VPC Ingress Connection.
     */
    readonly vpc: ec2.IVpc;
    /**
     * The VPC Interface Endpoint for the VPC Ingress Connection.
     */
    readonly interfaceVpcEndpoint: ec2.IInterfaceVpcEndpoint;
}
/**
 * Attributes for the App Runner VPC Ingress Connection
 */
export interface VpcIngressConnectionAttributes {
    /**
     * The Amazon Resource Name (ARN) of the VPC Ingress Connection.
     */
    readonly vpcIngressConnectionArn: string;
    /**
     * The name of the VPC Ingress Connection.
     */
    readonly vpcIngressConnectionName: string;
    /**
     * The domain name associated with the VPC Ingress Connection resource.
     */
    readonly domainName: string;
    /**
     * The current status of the VPC Ingress Connection.
     */
    readonly status: string;
}
/**
 * Represents the App Runner VPC Ingress Connection.
 */
export interface IVpcIngressConnection extends cdk.IResource {
    /**
     * The Amazon Resource Name (ARN) of the VPC Ingress Connection.
     * @attribute
     */
    readonly vpcIngressConnectionArn: string;
    /**
      * The name of the VPC Ingress Connection.
      * @attribute
      */
    readonly vpcIngressConnectionName: string;
}
/**
 * The App Runner VPC Ingress Connection
 *
 * @resource AWS::AppRunner::VpcIngressConnection
 */
export declare class VpcIngressConnection extends cdk.Resource implements IVpcIngressConnection {
    /**
     * Import from VPC Ingress Connection from attributes.
     */
    static fromVpcIngressConnectionAttributes(scope: Construct, id: string, attrs: VpcIngressConnectionAttributes): IVpcIngressConnection;
    /**
     * Imports an App Runner VPC Ingress Connection from its ARN
     */
    static fromArn(scope: Construct, id: string, vpcIngressConnectionArn: string): IVpcIngressConnection;
    /**
     * The ARN of the VPC Ingress Connection.
     * @attribute
     */
    readonly vpcIngressConnectionArn: string;
    /**
     * The domain name associated with the VPC Ingress Connection resource.
     * @attribute
     */
    readonly domainName: string;
    /**
     * The current status of the VPC Ingress Connection.
     * @attribute
     */
    readonly status: string;
    /**
     * The name of the VPC Ingress Connection.
     * @attribute
     */
    readonly vpcIngressConnectionName: string;
    constructor(scope: Construct, id: string, props: VpcIngressConnectionProps);
}
