"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcConnector = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The App Runner VPC Connector
 *
 * @resource AWS::AppRunner::VpcConnector
 */
class VpcConnector extends cdk.Resource {
    /**
     * Import from VPC connector attributes.
     */
    static fromVpcConnectorAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcConnectorAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVpcConnectorAttributes);
            }
            throw error;
        }
        const vpcConnectorArn = attrs.vpcConnectorArn;
        const vpcConnectorName = attrs.vpcConnectorName;
        const vpcConnectorRevision = attrs.vpcConnectorRevision;
        const securityGroups = attrs.securityGroups;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcConnectorArn = vpcConnectorArn;
                this.vpcConnectorName = vpcConnectorName;
                this.vpcConnectorRevision = vpcConnectorRevision;
                this.connections = new aws_ec2_1.Connections({ securityGroups });
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.vpcConnectorName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcConnectorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcConnector);
            }
            throw error;
        }
        if (props.vpcConnectorName !== undefined && !cdk.Token.isUnresolved(props.vpcConnectorName)) {
            if (props.vpcConnectorName.length < 4 || props.vpcConnectorName.length > 40) {
                throw new Error(`\`vpcConnectorName\` must be between 4 and 40 characters, got: ${props.vpcConnectorName.length} characters.`);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.vpcConnectorName)) {
                throw new Error(`\`vpcConnectorName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.vpcConnectorName}.`);
            }
        }
        const securityGroups = props.securityGroups?.length ?
            props.securityGroups
            : [new ec2.SecurityGroup(this, 'SecurityGroup', { vpc: props.vpc })];
        const resource = new aws_apprunner_1.CfnVpcConnector(this, 'Resource', {
            subnets: props.vpc.selectSubnets(props.vpcSubnets).subnetIds,
            securityGroups: cdk.Lazy.list({ produce: () => this.connections.securityGroups.map(sg => sg.securityGroupId) }),
            vpcConnectorName: this.physicalName,
        });
        this.vpcConnectorArn = resource.attrVpcConnectorArn;
        this.vpcConnectorRevision = resource.attrVpcConnectorRevision;
        this.vpcConnectorName = resource.ref;
        this.connections = new aws_ec2_1.Connections({ securityGroups });
    }
}
exports.VpcConnector = VpcConnector;
_a = JSII_RTTI_SYMBOL_1;
VpcConnector[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.VpcConnector", version: "2.177.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidnBjLWNvbm5lY3Rvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInZwYy1jb25uZWN0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsMkNBQTJDO0FBQzNDLGlEQUFrRDtBQUNsRCx3Q0FBd0M7QUFFeEMsNkRBQTREO0FBaUY1RDs7OztHQUlHO0FBQ0gsTUFBYSxZQUFhLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUFDNUM7O09BRUc7SUFDSSxNQUFNLENBQUMsMEJBQTBCLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBNkI7Ozs7Ozs7Ozs7UUFDbEcsTUFBTSxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM5QyxNQUFNLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztRQUNoRCxNQUFNLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQztRQUN4RCxNQUFNLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBRTVDLE1BQU0sTUFBTyxTQUFRLEdBQUcsQ0FBQyxRQUFRO1lBQWpDOztnQkFDa0Isb0JBQWUsR0FBRyxlQUFlLENBQUM7Z0JBQ2xDLHFCQUFnQixHQUFHLGdCQUFnQixDQUFDO2dCQUNwQyx5QkFBb0IsR0FBRyxvQkFBb0IsQ0FBQztnQkFDNUMsZ0JBQVcsR0FBRyxJQUFJLHFCQUFXLENBQUMsRUFBRSxjQUFjLEVBQUUsQ0FBQyxDQUFDO1lBQ3BFLENBQUM7U0FBQTtRQUVELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0tBQzlCO0lBeUJELFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCO1FBQ3ZFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsWUFBWSxFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7U0FDckMsQ0FBQyxDQUFDOzs7Ozs7K0NBOUNNLFlBQVk7Ozs7UUFnRHJCLElBQUksS0FBSyxDQUFDLGdCQUFnQixLQUFLLFNBQVMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLENBQUM7WUFFNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxHQUFHLENBQUMsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxHQUFHLEVBQUUsRUFBRSxDQUFDO2dCQUM1RSxNQUFNLElBQUksS0FBSyxDQUNiLGtFQUFrRSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxjQUFjLENBQzlHLENBQUM7WUFDSixDQUFDO1lBRUQsSUFBSSxDQUFDLDhCQUE4QixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLENBQUMsRUFBRSxDQUFDO2dCQUNqRSxNQUFNLElBQUksS0FBSyxDQUNiLHFKQUFxSixLQUFLLENBQUMsZ0JBQWdCLEdBQUcsQ0FDL0ssQ0FBQztZQUNKLENBQUM7UUFDSCxDQUFDO1FBRUQsTUFBTSxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQztZQUNuRCxLQUFLLENBQUMsY0FBYztZQUNwQixDQUFDLENBQUMsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxhQUFhLENBQUMsSUFBSSxFQUFFLGVBQWUsRUFBRSxFQUFFLEdBQUcsRUFBRSxLQUFLLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBRXZFLE1BQU0sUUFBUSxHQUFHLElBQUksK0JBQWUsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3JELE9BQU8sRUFBRSxLQUFLLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsU0FBUztZQUM1RCxjQUFjLEVBQUUsR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxjQUFjLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxFQUFFLENBQUM7WUFDL0csZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLFlBQVk7U0FDcEMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGVBQWUsR0FBRyxRQUFRLENBQUMsbUJBQW1CLENBQUM7UUFDcEQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLFFBQVEsQ0FBQyx3QkFBd0IsQ0FBQztRQUM5RCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztRQUNyQyxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUkscUJBQVcsQ0FBQyxFQUFFLGNBQWMsRUFBRSxDQUFDLENBQUM7S0FDeEQ7O0FBN0VILG9DQThFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZWMyJztcbmltcG9ydCB7IENvbm5lY3Rpb25zIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWVjMic7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWIvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmblZwY0Nvbm5lY3RvciB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcHBydW5uZXInO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgb2YgdGhlIEFwcFJ1bm5lciBWUEMgQ29ubmVjdG9yXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVnBjQ29ubmVjdG9yUHJvcHMge1xuICAvKipcbiAgICogVGhlIFZQQyBmb3IgdGhlIFZQQyBDb25uZWN0b3IuXG4gICAqL1xuICByZWFkb25seSB2cGM6IGVjMi5JVnBjO1xuXG4gIC8qKlxuICAgKiBXaGVyZSB0byBwbGFjZSB0aGUgVlBDIENvbm5lY3RvciB3aXRoaW4gdGhlIFZQQy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBQcml2YXRlIHN1Ym5ldHMuXG4gICAqL1xuICByZWFkb25seSB2cGNTdWJuZXRzPzogZWMyLlN1Ym5ldFNlbGVjdGlvbjtcblxuICAvKipcbiAgICogQSBsaXN0IG9mIElEcyBvZiBzZWN1cml0eSBncm91cHMgdGhhdCBBcHAgUnVubmVyIHNob3VsZCB1c2UgZm9yIGFjY2VzcyB0byBBV1MgcmVzb3VyY2VzIHVuZGVyIHRoZSBzcGVjaWZpZWQgc3VibmV0cy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBhIG5ldyBzZWN1cml0eSBncm91cCB3aWxsIGJlIGNyZWF0ZWQgaW4gdGhlIHNwZWNpZmllZCBWUENcbiAgICovXG4gIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBzPzogZWMyLklTZWN1cml0eUdyb3VwW107XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIGZvciB0aGUgVnBjQ29ubmVjdG9yLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGEgbmFtZSBnZW5lcmF0ZWQgYnkgQ2xvdWRGb3JtYXRpb25cbiAgICovXG4gIHJlYWRvbmx5IHZwY0Nvbm5lY3Rvck5hbWU/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogQXR0cmlidXRlcyBmb3IgdGhlIEFwcCBSdW5uZXIgVlBDIENvbm5lY3RvclxuICovXG5leHBvcnQgaW50ZXJmYWNlIFZwY0Nvbm5lY3RvckF0dHJpYnV0ZXMge1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIFZQQyBjb25uZWN0b3IuXG4gICAqL1xuICByZWFkb25seSB2cGNDb25uZWN0b3JOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIFZQQyBjb25uZWN0b3IuXG4gICAqL1xuICByZWFkb25seSB2cGNDb25uZWN0b3JBcm46IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHJldmlzaW9uIG9mIHRoZSBWUEMgY29ubmVjdG9yLlxuICAgKi9cbiAgcmVhZG9ubHkgdnBjQ29ubmVjdG9yUmV2aXNpb246IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIHNlY3VyaXR5IGdyb3VwcyBhc3NvY2lhdGVkIHdpdGggdGhlIFZQQyBjb25uZWN0b3IuXG4gICAqL1xuICByZWFkb25seSBzZWN1cml0eUdyb3VwczogZWMyLklTZWN1cml0eUdyb3VwW107XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgQXBwIFJ1bm5lciBWUEMgQ29ubmVjdG9yLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElWcGNDb25uZWN0b3IgZXh0ZW5kcyBjZGsuSVJlc291cmNlLCBlYzIuSUNvbm5lY3RhYmxlIHtcbiAgLyoqXG4gICAqIFRoZSBOYW1lIG9mIHRoZSBWUEMgY29ubmVjdG9yLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSB2cGNDb25uZWN0b3JOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIFZQQyBjb25uZWN0b3IuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHZwY0Nvbm5lY3RvckFybjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcmV2aXNpb24gb2YgdGhlIFZQQyBjb25uZWN0b3IuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHZwY0Nvbm5lY3RvclJldmlzaW9uOiBudW1iZXI7XG59XG5cbi8qKlxuICogVGhlIEFwcCBSdW5uZXIgVlBDIENvbm5lY3RvclxuICpcbiAqIEByZXNvdXJjZSBBV1M6OkFwcFJ1bm5lcjo6VnBjQ29ubmVjdG9yXG4gKi9cbmV4cG9ydCBjbGFzcyBWcGNDb25uZWN0b3IgZXh0ZW5kcyBjZGsuUmVzb3VyY2UgaW1wbGVtZW50cyBJVnBjQ29ubmVjdG9yIHtcbiAgLyoqXG4gICAqIEltcG9ydCBmcm9tIFZQQyBjb25uZWN0b3IgYXR0cmlidXRlcy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVZwY0Nvbm5lY3RvckF0dHJpYnV0ZXMoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXR0cnM6IFZwY0Nvbm5lY3RvckF0dHJpYnV0ZXMpOiBJVnBjQ29ubmVjdG9yIHtcbiAgICBjb25zdCB2cGNDb25uZWN0b3JBcm4gPSBhdHRycy52cGNDb25uZWN0b3JBcm47XG4gICAgY29uc3QgdnBjQ29ubmVjdG9yTmFtZSA9IGF0dHJzLnZwY0Nvbm5lY3Rvck5hbWU7XG4gICAgY29uc3QgdnBjQ29ubmVjdG9yUmV2aXNpb24gPSBhdHRycy52cGNDb25uZWN0b3JSZXZpc2lvbjtcbiAgICBjb25zdCBzZWN1cml0eUdyb3VwcyA9IGF0dHJzLnNlY3VyaXR5R3JvdXBzO1xuXG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgY2RrLlJlc291cmNlIHtcbiAgICAgIHB1YmxpYyByZWFkb25seSB2cGNDb25uZWN0b3JBcm4gPSB2cGNDb25uZWN0b3JBcm47XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgdnBjQ29ubmVjdG9yTmFtZSA9IHZwY0Nvbm5lY3Rvck5hbWU7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgdnBjQ29ubmVjdG9yUmV2aXNpb24gPSB2cGNDb25uZWN0b3JSZXZpc2lvbjtcbiAgICAgIHB1YmxpYyByZWFkb25seSBjb25uZWN0aW9ucyA9IG5ldyBDb25uZWN0aW9ucyh7IHNlY3VyaXR5R3JvdXBzIH0pO1xuICAgIH1cblxuICAgIHJldHVybiBuZXcgSW1wb3J0KHNjb3BlLCBpZCk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgVlBDIGNvbm5lY3Rvci5cbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgdnBjQ29ubmVjdG9yQXJuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSByZXZpc2lvbiBvZiB0aGUgVlBDIGNvbm5lY3Rvci5cbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgdnBjQ29ubmVjdG9yUmV2aXNpb246IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIFZQQyBjb25uZWN0b3IuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHZwY0Nvbm5lY3Rvck5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogQWxsb3dzIHNwZWNpZnlpbmcgc2VjdXJpdHkgZ3JvdXAgY29ubmVjdGlvbnMgZm9yIHRoZSBWUEMgY29ubmVjdG9yLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGNvbm5lY3Rpb25zOiBDb25uZWN0aW9ucztcblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFZwY0Nvbm5lY3RvclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLnZwY0Nvbm5lY3Rvck5hbWUsXG4gICAgfSk7XG5cbiAgICBpZiAocHJvcHMudnBjQ29ubmVjdG9yTmFtZSAhPT0gdW5kZWZpbmVkICYmICFjZGsuVG9rZW4uaXNVbnJlc29sdmVkKHByb3BzLnZwY0Nvbm5lY3Rvck5hbWUpKSB7XG5cbiAgICAgIGlmIChwcm9wcy52cGNDb25uZWN0b3JOYW1lLmxlbmd0aCA8IDQgfHwgcHJvcHMudnBjQ29ubmVjdG9yTmFtZS5sZW5ndGggPiA0MCkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgICAgYFxcYHZwY0Nvbm5lY3Rvck5hbWVcXGAgbXVzdCBiZSBiZXR3ZWVuIDQgYW5kIDQwIGNoYXJhY3RlcnMsIGdvdDogJHtwcm9wcy52cGNDb25uZWN0b3JOYW1lLmxlbmd0aH0gY2hhcmFjdGVycy5gLFxuICAgICAgICApO1xuICAgICAgfVxuXG4gICAgICBpZiAoIS9eW0EtWmEtejAtOV1bQS1aYS16MC05XFwtX10qJC8udGVzdChwcm9wcy52cGNDb25uZWN0b3JOYW1lKSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgICAgYFxcYHZwY0Nvbm5lY3Rvck5hbWVcXGAgbXVzdCBzdGFydCB3aXRoIGFuIGFscGhhbnVtZXJpYyBjaGFyYWN0ZXIgYW5kIGNvbnRhaW4gb25seSBhbHBoYW51bWVyaWMgY2hhcmFjdGVycywgaHlwaGVucywgb3IgdW5kZXJzY29yZXMgYWZ0ZXIgdGhhdCwgZ290OiAke3Byb3BzLnZwY0Nvbm5lY3Rvck5hbWV9LmAsXG4gICAgICAgICk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgY29uc3Qgc2VjdXJpdHlHcm91cHMgPSBwcm9wcy5zZWN1cml0eUdyb3Vwcz8ubGVuZ3RoID9cbiAgICAgIHByb3BzLnNlY3VyaXR5R3JvdXBzXG4gICAgICA6IFtuZXcgZWMyLlNlY3VyaXR5R3JvdXAodGhpcywgJ1NlY3VyaXR5R3JvdXAnLCB7IHZwYzogcHJvcHMudnBjIH0pXTtcblxuICAgIGNvbnN0IHJlc291cmNlID0gbmV3IENmblZwY0Nvbm5lY3Rvcih0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBzdWJuZXRzOiBwcm9wcy52cGMuc2VsZWN0U3VibmV0cyhwcm9wcy52cGNTdWJuZXRzKS5zdWJuZXRJZHMsXG4gICAgICBzZWN1cml0eUdyb3VwczogY2RrLkxhenkubGlzdCh7IHByb2R1Y2U6ICgpID0+IHRoaXMuY29ubmVjdGlvbnMuc2VjdXJpdHlHcm91cHMubWFwKHNnID0+IHNnLnNlY3VyaXR5R3JvdXBJZCkgfSksXG4gICAgICB2cGNDb25uZWN0b3JOYW1lOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICB9KTtcblxuICAgIHRoaXMudnBjQ29ubmVjdG9yQXJuID0gcmVzb3VyY2UuYXR0clZwY0Nvbm5lY3RvckFybjtcbiAgICB0aGlzLnZwY0Nvbm5lY3RvclJldmlzaW9uID0gcmVzb3VyY2UuYXR0clZwY0Nvbm5lY3RvclJldmlzaW9uO1xuICAgIHRoaXMudnBjQ29ubmVjdG9yTmFtZSA9IHJlc291cmNlLnJlZjtcbiAgICB0aGlzLmNvbm5lY3Rpb25zID0gbmV3IENvbm5lY3Rpb25zKHsgc2VjdXJpdHlHcm91cHMgfSk7XG4gIH1cbn1cbiJdfQ==