"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.Secret = exports.IpAddressType = exports.HealthCheck = exports.HealthCheckProtocolType = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib/core");
const core_1 = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The image repository types
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    /**
     * Amazon ECR Public
     */
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    /**
     * Amazon ECR
     */
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType || (exports.ImageRepositoryType = ImageRepositoryType = {}));
/**
 * The number of CPU units reserved for each instance of your App Runner service.
 *
 */
class Cpu {
    /**
     * Custom CPU unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     *
     * @param unit custom CPU unit
     */
    static of(unit) {
        const numericPatterns = ['256', '512', '1024', '2048', '4096'];
        const unitPatterns = ['0.25 vCPU', '0.5 vCPU', '1 vCPU', '2 vCPU', '4 vCPU'];
        const allowedPatterns = numericPatterns.concat(unitPatterns);
        const isValidValue = allowedPatterns.some((pattern) => pattern === unit);
        if (!isValidValue) {
            throw new Error('CPU value is invalid');
        }
        ;
        return new Cpu(unit);
    }
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
}
exports.Cpu = Cpu;
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.Cpu", version: "2.177.0-alpha.0" };
/**
 * 0.25 vCPU
 */
Cpu.QUARTER_VCPU = Cpu.of('0.25 vCPU');
/**
 * 0.5 vCPU
 */
Cpu.HALF_VCPU = Cpu.of('0.5 vCPU');
/**
 * 1 vCPU
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * 2 vCPU
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
/**
 * 4 vCPU
 */
Cpu.FOUR_VCPU = Cpu.of('4 vCPU');
/**
 * The amount of memory reserved for each instance of your App Runner service.
 */
class Memory {
    /**
     * Custom Memory unit
     *
     * @param unit custom Memory unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     */
    static of(unit) {
        const numericPatterns = ['512', '1024', '2048', '3072', '4096', '6144', '8192', '10240', '12288'];
        const unitPatterns = ['0.5 GB', '1 GB', '2 GB', '3 GB', '4 GB', '6 GB', '8 GB', '10 GB', '12 GB'];
        const allowedPatterns = numericPatterns.concat(unitPatterns);
        const isValidValue = allowedPatterns.some((pattern) => pattern === unit);
        if (!isValidValue) {
            throw new Error('Memory value is invalid');
        }
        ;
        return new Memory(unit);
    }
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
}
exports.Memory = Memory;
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner-alpha.Memory", version: "2.177.0-alpha.0" };
/**
 * 0.5 GB(for 0.25 vCPU)
 */
Memory.HALF_GB = Memory.of('0.5 GB');
/**
 * 1 GB(for 0.25 or 0.5 vCPU)
 */
Memory.ONE_GB = Memory.of('1 GB');
/**
 * 2 GB(for 1 vCPU)
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * 3 GB(for 1 vCPU)
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * 4 GB(for 1 or 2 vCPU)
 */
Memory.FOUR_GB = Memory.of('4 GB');
/**
 * 6 GB(for 2 vCPU)
 */
Memory.SIX_GB = Memory.of('6 GB');
/**
 * 8 GB(for 4 vCPU)
 */
Memory.EIGHT_GB = Memory.of('8 GB');
/**
 * 10 GB(for 4 vCPU)
 */
Memory.TEN_GB = Memory.of('10 GB');
/**
 * 12 GB(for 4 vCPU)
 */
Memory.TWELVE_GB = Memory.of('12 GB');
/**
 * The code runtimes
 */
class Runtime {
    /**
     * Other runtimes
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     *
     * @param name runtime name
     *
     */
    static of(name) { return new Runtime(name); }
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
}
exports.Runtime = Runtime;
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner-alpha.Runtime", version: "2.177.0-alpha.0" };
/**
 * CORRETTO 8
 */
Runtime.CORRETTO_8 = Runtime.of('CORRETTO_8');
/**
 * CORRETTO 11
 */
Runtime.CORRETTO_11 = Runtime.of('CORRETTO_11');
/**
 * .NET 6
 */
Runtime.DOTNET_6 = Runtime.of('DOTNET_6');
/**
 * Go 1.18
 */
Runtime.GO_1 = Runtime.of('GO_1');
/**
 * NodeJS 12
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * NodeJS 14
 */
Runtime.NODEJS_14 = Runtime.of('NODEJS_14');
/**
 * NodeJS 16
 */
Runtime.NODEJS_16 = Runtime.of('NODEJS_16');
/**
 * NodeJS 18
 */
Runtime.NODEJS_18 = Runtime.of('NODEJS_18');
/**
 * PHP 8.1
 */
Runtime.PHP_81 = Runtime.of('PHP_81');
/**
 * Python 3
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * Python 3.11
 */
Runtime.PYTHON_311 = Runtime.of('PYTHON_311');
/**
 * Ruby 3.1
 */
Runtime.RUBY_31 = Runtime.of('RUBY_31');
/**
 * Represents the App Runner service source.
 */
class Source {
    /**
     * Source from the GitHub repository.
     */
    static fromGitHub(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return new GithubSource(props);
    }
    /**
     * Source from the ECR repository.
     */
    static fromEcr(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return new EcrSource(props);
    }
    /**
     * Source from the ECR Public repository.
     */
    static fromEcrPublic(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrPublic);
            }
            throw error;
        }
        return new EcrPublicSource(props);
    }
    /**
     * Source from local assets.
     */
    static fromAsset(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetSource(props);
    }
}
exports.Source = Source;
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner-alpha.Source", version: "2.177.0-alpha.0" };
/**
 * Represents the service source from a Github repository.
 */
class GithubSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GithubSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: this.props.branch ?? 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
exports.GithubSource = GithubSource;
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner-alpha.GithubSource", version: "2.177.0-alpha.0" };
/**
 * Represents the service source from ECR.
 */
class EcrSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTagOrDigest(this.props.tagOrDigest || this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
exports.EcrSource = EcrSource;
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrSource", version: "2.177.0-alpha.0" };
/**
 * Represents the service source from ECR Public.
 */
class EcrPublicSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrPublicSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
exports.EcrPublicSource = EcrPublicSource;
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrPublicSource", version: "2.177.0-alpha.0" };
/**
 * Represents the source from local assets.
 */
class AssetSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
exports.AssetSource = AssetSource;
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner-alpha.AssetSource", version: "2.177.0-alpha.0" };
/**
 * The source of the App Runner configuration.
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    /**
     * App Runner reads configuration values from `the apprunner.yaml` file in the source code repository
     * and ignores `configurationValues`.
     */
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    /**
     * App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml`
     * file in the source code repository.
     */
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType || (exports.ConfigurationSourceType = ConfigurationSourceType = {}));
/**
 * Represents the App Runner connection that enables the App Runner service to connect
 * to a source repository. It's required for GitHub code repositories.
 */
class GitHubConnection {
    /**
     * Using existing App Runner connection by specifying the connection ARN.
     * @param arn connection ARN
     * @returns Connection
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
    constructor(arn) {
        this.connectionArn = arn;
    }
}
exports.GitHubConnection = GitHubConnection;
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner-alpha.GitHubConnection", version: "2.177.0-alpha.0" };
/**
 * The health check protocol type
 */
var HealthCheckProtocolType;
(function (HealthCheckProtocolType) {
    /**
     * HTTP protocol
     */
    HealthCheckProtocolType["HTTP"] = "HTTP";
    /**
     * TCP protocol
     */
    HealthCheckProtocolType["TCP"] = "TCP";
})(HealthCheckProtocolType || (exports.HealthCheckProtocolType = HealthCheckProtocolType = {}));
/**
 * Contains static factory methods for creating health checks for different protocols
 */
class HealthCheck {
    /**
     * Construct a HTTP health check
     */
    static http(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_HttpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new HealthCheck(HealthCheckProtocolType.HTTP, options.healthyThreshold, options.interval, options.timeout, options.unhealthyThreshold, options.path);
    }
    /**
     * Construct a TCP health check
     */
    static tcp(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_TcpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.tcp);
            }
            throw error;
        }
        return new HealthCheck(HealthCheckProtocolType.TCP, options.healthyThreshold, options.interval, options.timeout, options.unhealthyThreshold);
    }
    constructor(healthCheckProtocolType, healthyThreshold = 1, interval = cdk.Duration.seconds(5), timeout = cdk.Duration.seconds(2), unhealthyThreshold = 5, path) {
        this.healthCheckProtocolType = healthCheckProtocolType;
        this.healthyThreshold = healthyThreshold;
        this.interval = interval;
        this.timeout = timeout;
        this.unhealthyThreshold = unhealthyThreshold;
        this.path = path;
        if (this.healthCheckProtocolType === HealthCheckProtocolType.HTTP) {
            if (this.path !== undefined && this.path.length === 0) {
                throw new Error('path length must be greater than 0');
            }
            if (this.path === undefined) {
                this.path = '/';
            }
        }
        if (this.healthyThreshold < 1 || this.healthyThreshold > 20) {
            throw new Error(`healthyThreshold must be between 1 and 20, got ${this.healthyThreshold}`);
        }
        if (this.unhealthyThreshold < 1 || this.unhealthyThreshold > 20) {
            throw new Error(`unhealthyThreshold must be between 1 and 20, got ${this.unhealthyThreshold}`);
        }
        if (this.interval.toSeconds() < 1 || this.interval.toSeconds() > 20) {
            throw new Error(`interval must be between 1 and 20 seconds, got ${this.interval.toSeconds()}`);
        }
        if (this.timeout.toSeconds() < 1 || this.timeout.toSeconds() > 20) {
            throw new Error(`timeout must be between 1 and 20 seconds, got ${this.timeout.toSeconds()}`);
        }
    }
    bind() {
        return {
            healthyThreshold: this.healthyThreshold,
            interval: this.interval?.toSeconds(),
            path: this.path,
            protocol: this.healthCheckProtocolType,
            timeout: this.timeout?.toSeconds(),
            unhealthyThreshold: this.unhealthyThreshold,
        };
    }
}
exports.HealthCheck = HealthCheck;
_k = JSII_RTTI_SYMBOL_1;
HealthCheck[_k] = { fqn: "@aws-cdk/aws-apprunner-alpha.HealthCheck", version: "2.177.0-alpha.0" };
/**
 * The IP address type for your incoming public network configuration.
 */
var IpAddressType;
(function (IpAddressType) {
    /**
     * IPV4
     */
    IpAddressType["IPV4"] = "IPV4";
    /**
     * DUAL_STACK
     */
    IpAddressType["DUAL_STACK"] = "DUAL_STACK";
})(IpAddressType || (exports.IpAddressType = IpAddressType = {}));
/**
 * A secret environment variable.
 */
class Secret {
    /**
     * Creates an environment variable value from a parameter stored in AWS
     * Systems Manager Parameter Store.
     */
    static fromSsmParameter(parameter) {
        return {
            arn: parameter.parameterArn,
            grantRead: grantee => parameter.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManager(secret, field) {
        return {
            arn: field ? `${secret.secretArn}:${field}::` : secret.secretArn,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param versionInfo the version information to reference the secret
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManagerVersion(secret, versionInfo, field) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_SecretVersionInfo(versionInfo);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSecretsManagerVersion);
            }
            throw error;
        }
        return {
            arn: `${secret.secretArn}:${field ?? ''}:${versionInfo.versionStage ?? ''}:${versionInfo.versionId ?? ''}`,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
}
exports.Secret = Secret;
_l = JSII_RTTI_SYMBOL_1;
Secret[_l] = { fqn: "@aws-cdk/aws-apprunner-alpha.Secret", version: "2.177.0-alpha.0" };
/**
 * The App Runner Service.
 */
class Service extends cdk.Resource {
    /**
     * Import from service name.
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Import from service attributes.
     */
    static fromServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromServiceAttributes);
            }
            throw error;
        }
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Environment variables for this service.
         *
         * @deprecated use environmentVariables.
         */
        this.environment = {};
        /**
         * Environment secrets for this service.
         */
        this.secrets = [];
        /**
         * Environment variables for this service.
         */
        this.variables = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Service);
            }
            throw error;
        }
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        this.instanceRole = this.props.instanceRole ?? this.createInstanceRole();
        this.grantPrincipal = this.instanceRole;
        const environmentVariables = this.getEnvironmentVariables();
        const environmentSecrets = this.getEnvironmentSecrets();
        for (const [key, value] of Object.entries(environmentVariables)) {
            this.addEnvironmentVariable(key, value);
        }
        for (const [key, value] of Object.entries(environmentSecrets)) {
            this.addSecret(key, value);
        }
        // generate an IAM role only when ImageRepositoryType is ECR and props.accessRole is undefined
        this.accessRole = (this.source.imageRepository?.imageRepositoryType == ImageRepositoryType.ECR) ?
            this.props.accessRole ?? this.generateDefaultRole() : undefined;
        if (this.source.codeRepository?.codeConfiguration.configurationSource == ConfigurationSourceType.REPOSITORY &&
            this.source.codeRepository?.codeConfiguration.configurationValues) {
            throw new Error('configurationValues cannot be provided if the ConfigurationSource is Repository');
        }
        if (props.serviceName !== undefined && !cdk.Token.isUnresolved(props.serviceName)) {
            if (props.serviceName.length < 4 || props.serviceName.length > 40) {
                throw new Error(`\`serviceName\` must be between 4 and 40 characters, got: ${props.serviceName.length} characters.`);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.serviceName)) {
                throw new Error(`\`serviceName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.serviceName}.`);
            }
        }
        const resource = new aws_apprunner_1.CfnService(this, 'Resource', {
            serviceName: this.props.serviceName,
            instanceConfiguration: {
                cpu: this.props.cpu?.unit,
                memory: this.props.memory?.unit,
                instanceRoleArn: core_1.Lazy.string({ produce: () => this.instanceRole?.roleArn }),
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                autoDeploymentsEnabled: this.props.autoDeploymentsEnabled,
                imageRepository: this.source.imageRepository ?
                    this.renderImageRepository(this.source.imageRepository) :
                    undefined,
                codeRepository: this.source.codeRepository ?
                    this.renderCodeConfiguration(this.source.codeRepository.codeConfiguration.configurationValues) :
                    undefined,
            },
            encryptionConfiguration: this.props.kmsKey ? {
                kmsKey: this.props.kmsKey.keyArn,
            } : undefined,
            autoScalingConfigurationArn: this.props.autoScalingConfiguration?.autoScalingConfigurationArn,
            networkConfiguration: {
                egressConfiguration: {
                    egressType: this.props.vpcConnector ? 'VPC' : 'DEFAULT',
                    vpcConnectorArn: this.props.vpcConnector?.vpcConnectorArn,
                },
                ingressConfiguration: props.isPubliclyAccessible !== undefined ? { isPubliclyAccessible: props.isPubliclyAccessible } : undefined,
                ipAddressType: this.props.ipAddressType,
            },
            healthCheckConfiguration: this.props.healthCheck ?
                this.props.healthCheck.bind() :
                undefined,
            observabilityConfiguration: props.observabilityConfiguration ? {
                observabilityEnabled: true,
                observabilityConfigurationArn: props.observabilityConfiguration.observabilityConfigurationArn,
            } : undefined,
        });
        // grant required privileges for the role to access an image in Amazon ECR
        // See https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles
        if (this.source.ecrRepository && this.accessRole) {
            this.source.ecrRepository.grantPull(this.accessRole);
            this.source.ecrRepository.grant(this.accessRole, 'ecr:DescribeImages');
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        /**
         * Cloudformaton does not return the serviceName attribute so we extract it from the serviceArn.
         * The ARN comes with this format:
         * arn:aws:apprunner:us-east-1:123456789012:service/SERVICE_NAME/SERVICE_ID
         */
        // First, get the last element by splitting with ':'
        const resourceFullName = cdk.Fn.select(5, cdk.Fn.split(':', this.serviceArn));
        // Now, split the resourceFullName with '/' to get the serviceName
        this.serviceName = cdk.Fn.select(1, cdk.Fn.split('/', resourceFullName));
    }
    /**
     * Adds a statement to the instance role.
     */
    addToRolePolicy(statement) {
        this.instanceRole.addToPrincipalPolicy(statement);
    }
    /**
     * This method adds an environment variable to the App Runner service.
     */
    addEnvironmentVariable(name, value) {
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new Error(`Environment variable key ${name} with a prefix of AWSAPPRUNNER is not allowed`);
        }
        this.variables.push({ name: name, value: value });
    }
    /**
     * This method adds a secret as environment variable to the App Runner service.
     */
    addSecret(name, secret) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_Secret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addSecret);
            }
            throw error;
        }
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new Error(`Environment secret key ${name} with a prefix of AWSAPPRUNNER is not allowed`);
        }
        secret.grantRead(this.instanceRole);
        this.secrets.push({ name: name, value: secret.arn });
    }
    /**
     * This method generates an Instance Role. Needed if using secrets and props.instanceRole is undefined
     * @returns iam.IRole
     */
    createInstanceRole() {
        return new iam.Role(this, 'InstanceRole', {
            assumedBy: new iam.ServicePrincipal('tasks.apprunner.amazonaws.com'),
            roleName: cdk.PhysicalName.GENERATE_IF_NEEDED,
        });
    }
    /**
     * This method generates an Access Role only when ImageRepositoryType is ECR and props.accessRole is undefined
     * @returns iam.IRole
     */
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
    getEnvironmentSecrets() {
        let secrets = this.source.codeRepository?.codeConfiguration.configurationValues?.environmentSecrets ??
            this.source.imageRepository?.imageConfiguration?.environmentSecrets;
        return secrets || {};
    }
    getEnvironmentVariables() {
        let codeEnv = [
            this.source.codeRepository?.codeConfiguration.configurationValues?.environmentVariables,
            this.source.codeRepository?.codeConfiguration.configurationValues?.environment,
        ];
        let imageEnv = [
            this.source.imageRepository?.imageConfiguration?.environmentVariables,
            this.source.imageRepository?.imageConfiguration?.environment,
        ];
        if (codeEnv.every(el => el !== undefined) || imageEnv.every(el => el !== undefined)) {
            throw new Error([
                'You cannot set both \'environmentVariables\' and \'environment\' properties.',
                'Please only use environmentVariables, as environment is deprecated.',
            ].join(' '));
        }
        return codeEnv.find(el => el !== undefined) || imageEnv.find(el => el !== undefined) || {};
    }
    renderAuthenticationConfiguration() {
        return {
            accessRoleArn: this.accessRole?.roleArn,
            connectionArn: this.source.codeRepository?.connection?.connectionArn,
        };
    }
    renderCodeConfiguration(props) {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(props) :
                    undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        return {
            port: props.port,
            buildCommand: props.buildCommand,
            runtime: props.runtime.name,
            runtimeEnvironmentVariables: core_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
            runtimeEnvironmentSecrets: core_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            startCommand: props.startCommand,
        };
    }
    renderEnvironmentVariables() {
        if (this.variables.length > 0) {
            return this.variables;
        }
        else {
            return undefined;
        }
    }
    renderEnvironmentSecrets() {
        if (this.secrets.length > 0 && this.instanceRole) {
            return this.secrets;
        }
        else {
            return undefined;
        }
    }
    renderImageRepository(repo) {
        return Object.assign(repo, {
            imageConfiguration: {
                port: repo.imageConfiguration?.port?.toString(),
                startCommand: repo.imageConfiguration?.startCommand,
                runtimeEnvironmentVariables: core_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
                runtimeEnvironmentSecrets: core_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            },
        });
    }
}
exports.Service = Service;
_m = JSII_RTTI_SYMBOL_1;
Service[_m] = { fqn: "@aws-cdk/aws-apprunner-alpha.Service", version: "2.177.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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