"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObservabilityConfiguration = exports.TraceConfigurationVendor = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The implementation provider chosen for tracing App Runner services
 *
 * @see https://docs.aws.amazon.com/apprunner/latest/dg/monitor.html
 */
var TraceConfigurationVendor;
(function (TraceConfigurationVendor) {
    /**
     * Tracing (X-Ray)
     */
    TraceConfigurationVendor["AWSXRAY"] = "AWSXRAY";
})(TraceConfigurationVendor || (exports.TraceConfigurationVendor = TraceConfigurationVendor = {}));
/**
 * The App Runner Observability configuration
 *
 * @resource AWS::AppRunner::ObservabilityConfiguration
 */
class ObservabilityConfiguration extends cdk.Resource {
    /**
     * Imports an App Runner Observability Configuration from attributes.
     */
    static fromObservabilityConfigurationAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ObservabilityConfigurationAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromObservabilityConfigurationAttributes);
            }
            throw error;
        }
        const observabilityConfigurationName = attrs.observabilityConfigurationName;
        const observabilityConfigurationRevision = attrs.observabilityConfigurationRevision;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.observabilityConfigurationName = observabilityConfigurationName;
                this.observabilityConfigurationRevision = observabilityConfigurationRevision;
                this.observabilityConfigurationArn = cdk.Stack.of(this).formatArn({
                    resource: 'observabilityconfiguration',
                    service: 'apprunner',
                    resourceName: `${attrs.observabilityConfigurationName}/${attrs.observabilityConfigurationRevision}`,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports an App Runner Observability Configuration from its ARN
     */
    static fromArn(scope, id, observabilityConfigurationArn) {
        const resourceParts = cdk.Fn.split('/', observabilityConfigurationArn);
        if (!resourceParts || resourceParts.length < 3) {
            throw new Error(`Unexpected ARN format: ${observabilityConfigurationArn}.`);
        }
        const observabilityConfigurationName = cdk.Fn.select(0, resourceParts);
        const observabilityConfigurationRevision = Number(cdk.Fn.select(1, resourceParts));
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.observabilityConfigurationName = observabilityConfigurationName;
                this.observabilityConfigurationRevision = observabilityConfigurationRevision;
                this.observabilityConfigurationArn = observabilityConfigurationArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.observabilityConfigurationName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ObservabilityConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ObservabilityConfiguration);
            }
            throw error;
        }
        if (props.observabilityConfigurationName !== undefined && !cdk.Token.isUnresolved(props.observabilityConfigurationName)) {
            if (props.observabilityConfigurationName.length < 4 || props.observabilityConfigurationName.length > 32) {
                throw new Error(`\`observabilityConfigurationName\` must be between 4 and 32 characters, got: ${props.observabilityConfigurationName.length} characters.`);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.observabilityConfigurationName)) {
                throw new Error(`\`observabilityConfigurationName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.observabilityConfigurationName}.`);
            }
        }
        const resource = new aws_apprunner_1.CfnObservabilityConfiguration(this, 'Resource', {
            observabilityConfigurationName: props.observabilityConfigurationName,
            traceConfiguration: {
                vendor: props.traceConfigurationVendor,
            },
        });
        this.observabilityConfigurationArn = resource.attrObservabilityConfigurationArn;
        this.observabilityConfigurationRevision = resource.attrObservabilityConfigurationRevision;
        this.observabilityConfigurationName = resource.ref;
    }
}
exports.ObservabilityConfiguration = ObservabilityConfiguration;
_a = JSII_RTTI_SYMBOL_1;
ObservabilityConfiguration[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.ObservabilityConfiguration", version: "2.177.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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