"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingConfiguration = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The App Runner Auto Scaling Configuration.
 *
 * @resource AWS::AppRunner::AutoScalingConfiguration
 */
class AutoScalingConfiguration extends cdk.Resource {
    /**
     * Imports an App Runner Auto Scaling Configuration from attributes
     */
    static fromAutoScalingConfigurationAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AutoScalingConfigurationAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAutoScalingConfigurationAttributes);
            }
            throw error;
        }
        const autoScalingConfigurationName = attrs.autoScalingConfigurationName;
        const autoScalingConfigurationRevision = attrs.autoScalingConfigurationRevision;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.autoScalingConfigurationName = autoScalingConfigurationName;
                this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
                this.autoScalingConfigurationArn = cdk.Stack.of(this).formatArn({
                    resource: 'autoscalingconfiguration',
                    service: 'apprunner',
                    resourceName: `${attrs.autoScalingConfigurationName}/${attrs.autoScalingConfigurationRevision}`,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports an App Runner Auto Scaling Configuration from its ARN
     */
    static fromArn(scope, id, autoScalingConfigurationArn) {
        const resourceParts = cdk.Fn.split('/', autoScalingConfigurationArn);
        if (!resourceParts || resourceParts.length < 3) {
            throw new Error(`Unexpected ARN format: ${autoScalingConfigurationArn}.`);
        }
        const autoScalingConfigurationName = cdk.Fn.select(0, resourceParts);
        const autoScalingConfigurationRevision = Number(cdk.Fn.select(1, resourceParts));
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.autoScalingConfigurationName = autoScalingConfigurationName;
                this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
                this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.autoScalingConfigurationName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AutoScalingConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AutoScalingConfiguration);
            }
            throw error;
        }
        this.validateAutoScalingConfiguration(props);
        const resource = new aws_apprunner_1.CfnAutoScalingConfiguration(this, 'Resource', {
            autoScalingConfigurationName: props.autoScalingConfigurationName,
            maxConcurrency: props.maxConcurrency,
            maxSize: props.maxSize,
            minSize: props.minSize,
        });
        this.autoScalingConfigurationArn = resource.attrAutoScalingConfigurationArn;
        this.autoScalingConfigurationRevision = resource.attrAutoScalingConfigurationRevision;
        this.autoScalingConfigurationName = resource.ref;
    }
    validateAutoScalingConfiguration(props) {
        if (props.autoScalingConfigurationName !== undefined && !cdk.Token.isUnresolved(props.autoScalingConfigurationName)) {
            if (props.autoScalingConfigurationName.length < 4 || props.autoScalingConfigurationName.length > 32) {
                throw new Error(`\`autoScalingConfigurationName\` must be between 4 and 32 characters, got: ${props.autoScalingConfigurationName.length} characters.`);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.autoScalingConfigurationName)) {
                throw new Error(`\`autoScalingConfigurationName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.autoScalingConfigurationName}.`);
            }
        }
        const isMinSizeDefined = typeof props.minSize === 'number';
        const isMaxSizeDefined = typeof props.maxSize === 'number';
        const isMaxConcurrencyDefined = typeof props.maxConcurrency === 'number';
        if (isMinSizeDefined && (props.minSize < 1 || props.minSize > 25)) {
            throw new Error(`minSize must be between 1 and 25, got ${props.minSize}.`);
        }
        if (isMaxSizeDefined && (props.maxSize < 1 || props.maxSize > 25)) {
            throw new Error(`maxSize must be between 1 and 25, got ${props.maxSize}.`);
        }
        if (isMinSizeDefined && isMaxSizeDefined && !(props.minSize < props.maxSize)) {
            throw new Error('maxSize must be greater than minSize.');
        }
        if (isMaxConcurrencyDefined && (props.maxConcurrency < 1 || props.maxConcurrency > 200)) {
            throw new Error(`maxConcurrency must be between 1 and 200, got ${props.maxConcurrency}.`);
        }
    }
}
exports.AutoScalingConfiguration = AutoScalingConfiguration;
_a = JSII_RTTI_SYMBOL_1;
AutoScalingConfiguration[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.AutoScalingConfiguration", version: "2.177.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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