# -*- coding: utf-8 -*-

import pytest
from pandas import DataFrame

from simmate.database.base_data_types import Dynamics, DynamicsIonicStep
from simmate.toolkit import Structure

# from pymatgen.io.vasp.outputs import Vasprun


@pytest.mark.django_db
def test_static_energy_table(structure):
    # test writing columns
    Dynamics.show_columns()
    DynamicsIonicStep.show_columns()

    # test writing to database
    structure_db = Dynamics.from_run_context(
        run_id="example-id-123",
        workflow_name="example.test.workflow",
        workflow_version="1.2.3",
        structure=structure,
    )
    structure_db.save()

    # try grabbing the calculation again and make sure it loaded from the
    # database rather than creating a new entry
    structure_db2 = Dynamics.from_run_context(
        run_id="example-id-123",
        workflow_name="example.test.workflow",
        workflow_version="1.2.3",
    )
    assert structure_db.id == structure_db.id

    # test converting back to toolkit and ensuring the structure is the
    # same as before
    structure_new = structure_db.to_toolkit()
    assert structure == structure_new

    # test converting search results to dataframe and to toolkit
    df = Dynamics.objects.to_dataframe()
    assert isinstance(df, DataFrame)
    structures = Dynamics.objects.to_toolkit()
    assert isinstance(structures, list)
    assert isinstance(structures[0], Structure)
