"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeletableBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const empty_bucket_1 = require("./empty-bucket");
class DeletableBucket extends aws_s3_1.Bucket {
    constructor(scope, id, props = {}) {
        const { forceDelete = false } = props;
        super(scope, id, {
            removalPolicy: forceDelete ? core_1.RemovalPolicy.DESTROY : undefined,
            ...props,
        });
        if (forceDelete) {
            new empty_bucket_1.EmptyBucket(this, 'EmptyBucket', {
                bucket: this,
            });
        }
    }
}
exports.DeletableBucket = DeletableBucket;
_a = JSII_RTTI_SYMBOL_1;
DeletableBucket[_a] = { fqn: "@cloudcomponents/cdk-deletable-bucket.DeletableBucket", version: "1.30.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVsZXRhYmxlLWJ1Y2tldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9kZWxldGFibGUtYnVja2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNENBQXNEO0FBQ3RELHdDQUF5RDtBQUV6RCxpREFBNkM7QUFXN0MsTUFBYSxlQUFnQixTQUFRLGVBQU07SUFDekMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUE4QixFQUFFO1FBQ3hFLE1BQU0sRUFBRSxXQUFXLEdBQUcsS0FBSyxFQUFFLEdBQUcsS0FBSyxDQUFDO1FBQ3RDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsYUFBYSxFQUFFLFdBQVcsQ0FBQyxDQUFDLENBQUMsb0JBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDOUQsR0FBRyxLQUFLO1NBQ1QsQ0FBQyxDQUFDO1FBRUgsSUFBSSxXQUFXLEVBQUU7WUFDZixJQUFJLDBCQUFXLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtnQkFDbkMsTUFBTSxFQUFFLElBQUk7YUFDYixDQUFDLENBQUM7U0FDSjtJQUNILENBQUM7O0FBYkgsMENBY0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBCdWNrZXQsIEJ1Y2tldFByb3BzIH0gZnJvbSAnQGF3cy1jZGsvYXdzLXMzJztcbmltcG9ydCB7IENvbnN0cnVjdCwgUmVtb3ZhbFBvbGljeSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG5pbXBvcnQgeyBFbXB0eUJ1Y2tldCB9IGZyb20gJy4vZW1wdHktYnVja2V0JztcblxuZXhwb3J0IGludGVyZmFjZSBEZWxldGFibGVCdWNrZXRQcm9wcyBleHRlbmRzIEJ1Y2tldFByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBmb3JjZURlbGV0ZT86IGJvb2xlYW47XG59XG5cbmV4cG9ydCBjbGFzcyBEZWxldGFibGVCdWNrZXQgZXh0ZW5kcyBCdWNrZXQge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRGVsZXRhYmxlQnVja2V0UHJvcHMgPSB7fSkge1xuICAgIGNvbnN0IHsgZm9yY2VEZWxldGUgPSBmYWxzZSB9ID0gcHJvcHM7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICByZW1vdmFsUG9saWN5OiBmb3JjZURlbGV0ZSA/IFJlbW92YWxQb2xpY3kuREVTVFJPWSA6IHVuZGVmaW5lZCxcbiAgICAgIC4uLnByb3BzLFxuICAgIH0pO1xuXG4gICAgaWYgKGZvcmNlRGVsZXRlKSB7XG4gICAgICBuZXcgRW1wdHlCdWNrZXQodGhpcywgJ0VtcHR5QnVja2V0Jywge1xuICAgICAgICBidWNrZXQ6IHRoaXMsXG4gICAgICB9KTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==