# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class VirusScanPolicyApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_mount_target_virus_scan_policy(self, body, mountTargetExtId, **kwargs):  # noqa: E501
        """Create a mount target virus scan policy
        Create virus scan policy for a mount target identified by mountTargetExtId.  A sample request body would look like this:  ``` {   \"scanOnRead\": true,   \"blockAccessFile\": true,   \"scanTimeoutIntervalInSecs\": 60,   \"mountTargetExtId\": \"f1be4f9f-70b5-4a04-8460-472f032ac9d8\",   \"fileSizeExclusionInBytes\": 0,   \"scanOnWrite\": true,   \"extId\": \"5a008cef-17e4-4658-9978-1bd38f3738bc\" } ``` 

        >>> response = api.create_mount_target_virus_scan_policy(body, mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_mount_target_virus_scan_policy(body, mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.VirusScanPolicyMountTarget body: virus scan policy Model (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool async_req:
        :return: files.v4.config.CreateMountTargetVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_mount_target_virus_scan_policy_with_http_info(body, mountTargetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.create_mount_target_virus_scan_policy_with_http_info(body, mountTargetExtId, **kwargs)  # noqa: E501
            return data

    def create_mount_target_virus_scan_policy_with_http_info(self, body, mountTargetExtId, **kwargs):  # noqa: E501
        """Create a mount target virus scan policy
        Create virus scan policy for a mount target identified by mountTargetExtId.  A sample request body would look like this:  ``` {   \"scanOnRead\": true,   \"blockAccessFile\": true,   \"scanTimeoutIntervalInSecs\": 60,   \"mountTargetExtId\": \"f1be4f9f-70b5-4a04-8460-472f032ac9d8\",   \"fileSizeExclusionInBytes\": 0,   \"scanOnWrite\": true,   \"extId\": \"5a008cef-17e4-4658-9978-1bd38f3738bc\" } ``` 

        >>> response = api.create_mount_target_virus_scan_policy(body, mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_mount_target_virus_scan_policy_with_http_info(body, mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.VirusScanPolicyMountTarget body: virus scan policy Model (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool async_req:
        :return: files.v4.config.CreateMountTargetVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'mountTargetExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_mount_target_virus_scan_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_mount_target_virus_scan_policy`")  # noqa: E501
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `create_mount_target_virus_scan_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/virus-scan-policy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateMountTargetVirusScanPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_virus_scan_policy(self, body, **kwargs):  # noqa: E501
        """Create a virus scan policy
        Creates a virus scan policy using the provided request body.  A sample request body would look like this:  ``` {   \"scanOnRead\": true,   \"blockAccessFile\": true,   \"scanTimeoutIntervalInSecs\": 120,   \"fileTypeExclusions\": [     \".txt\",     \".db\"   ],   \"fileSizeExclusionInBytes\": 0,   \"extId\": \"d96df616-c3e4-4ee3-8425-05d6182b27a1\",   \"enableAntiVirus\": false,   \"scanOnWrite\": false } ``` 

        >>> response = api.create_virus_scan_policy(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_virus_scan_policy(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.VirusScanPolicy body: virus scan policy Model (required)
        :param bool async_req:
        :return: files.v4.config.CreateVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_virus_scan_policy_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_virus_scan_policy_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_virus_scan_policy_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a virus scan policy
        Creates a virus scan policy using the provided request body.  A sample request body would look like this:  ``` {   \"scanOnRead\": true,   \"blockAccessFile\": true,   \"scanTimeoutIntervalInSecs\": 120,   \"fileTypeExclusions\": [     \".txt\",     \".db\"   ],   \"fileSizeExclusionInBytes\": 0,   \"extId\": \"d96df616-c3e4-4ee3-8425-05d6182b27a1\",   \"enableAntiVirus\": false,   \"scanOnWrite\": false } ``` 

        >>> response = api.create_virus_scan_policy(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_virus_scan_policy_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.VirusScanPolicy body: virus scan policy Model (required)
        :param bool async_req:
        :return: files.v4.config.CreateVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_virus_scan_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_virus_scan_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/virus-scan-policy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateVirusScanPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_mount_target_virus_scan_policy(self, mountTargetExtId, virusScanPolicyExtId, **kwargs):  # noqa: E501
        """Delete a mount target virus scan policy
        Delete virus scan policy request for a mount target identified by mountTargetExtId. 

        >>> response = api.delete_mount_target_virus_scan_policy(mountTargetExtId, virusScanPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mount_target_virus_scan_policy(mountTargetExtId, virusScanPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str virusScanPolicyExtId: The {extId} of the virus scan policy. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteMountTargetVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_mount_target_virus_scan_policy_with_http_info(mountTargetExtId, virusScanPolicyExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_mount_target_virus_scan_policy_with_http_info(mountTargetExtId, virusScanPolicyExtId, **kwargs)  # noqa: E501
            return data

    def delete_mount_target_virus_scan_policy_with_http_info(self, mountTargetExtId, virusScanPolicyExtId, **kwargs):  # noqa: E501
        """Delete a mount target virus scan policy
        Delete virus scan policy request for a mount target identified by mountTargetExtId. 

        >>> response = api.delete_mount_target_virus_scan_policy(mountTargetExtId, virusScanPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mount_target_virus_scan_policy_with_http_info(mountTargetExtId, virusScanPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str virusScanPolicyExtId: The {extId} of the virus scan policy. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteMountTargetVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', 'virusScanPolicyExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mount_target_virus_scan_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `delete_mount_target_virus_scan_policy`")  # noqa: E501
        # verify the required parameter 'virusScanPolicyExtId' is set
        if ('virusScanPolicyExtId' not in params or
                params['virusScanPolicyExtId'] is None):
            raise ValueError("Missing the required parameter `virusScanPolicyExtId` when calling `delete_mount_target_virus_scan_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501
        if 'virusScanPolicyExtId' in params:
            path_params['virusScanPolicyExtId'] = params['virusScanPolicyExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/virus-scan-policy/{virusScanPolicyExtId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DeleteMountTargetVirusScanPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mount_target_virus_scan_policy(self, mountTargetExtId, virusScanPolicyExtId, **kwargs):  # noqa: E501
        """Get a mount target virus scan policy
        Get virus scan policy with given external identifier for a mount target with provided mount target  external identifier.  The user has to specify - a valid external identifier `mountTargetExtId` of the mount target and `virusScanPolicyExtId` of virus scan policy which  needs to be fetched. 

        >>> response = api.get_mount_target_virus_scan_policy(mountTargetExtId, virusScanPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mount_target_virus_scan_policy(mountTargetExtId, virusScanPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str virusScanPolicyExtId: The {extId} of the virus scan policy. (required)
        :param bool async_req:
        :return: files.v4.config.MountTargetVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mount_target_virus_scan_policy_with_http_info(mountTargetExtId, virusScanPolicyExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mount_target_virus_scan_policy_with_http_info(mountTargetExtId, virusScanPolicyExtId, **kwargs)  # noqa: E501
            return data

    def get_mount_target_virus_scan_policy_with_http_info(self, mountTargetExtId, virusScanPolicyExtId, **kwargs):  # noqa: E501
        """Get a mount target virus scan policy
        Get virus scan policy with given external identifier for a mount target with provided mount target  external identifier.  The user has to specify - a valid external identifier `mountTargetExtId` of the mount target and `virusScanPolicyExtId` of virus scan policy which  needs to be fetched. 

        >>> response = api.get_mount_target_virus_scan_policy(mountTargetExtId, virusScanPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mount_target_virus_scan_policy_with_http_info(mountTargetExtId, virusScanPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str virusScanPolicyExtId: The {extId} of the virus scan policy. (required)
        :param bool async_req:
        :return: files.v4.config.MountTargetVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', 'virusScanPolicyExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mount_target_virus_scan_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `get_mount_target_virus_scan_policy`")  # noqa: E501
        # verify the required parameter 'virusScanPolicyExtId' is set
        if ('virusScanPolicyExtId' not in params or
                params['virusScanPolicyExtId'] is None):
            raise ValueError("Missing the required parameter `virusScanPolicyExtId` when calling `get_mount_target_virus_scan_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501
        if 'virusScanPolicyExtId' in params:
            path_params['virusScanPolicyExtId'] = params['virusScanPolicyExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/virus-scan-policy/{virusScanPolicyExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.MountTargetVirusScanPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_virus_scan_policy(self, virusScanPolicyExtId, **kwargs):  # noqa: E501
        """Get a virus scan policy
        Get a virus scan policy identified by {extId}. 

        >>> response = api.get_virus_scan_policy(virusScanPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_virus_scan_policy(virusScanPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param str virusScanPolicyExtId: The {extId} of the virus scan policy. (required)
        :param bool async_req:
        :return: files.v4.config.VirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_virus_scan_policy_with_http_info(virusScanPolicyExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_virus_scan_policy_with_http_info(virusScanPolicyExtId, **kwargs)  # noqa: E501
            return data

    def get_virus_scan_policy_with_http_info(self, virusScanPolicyExtId, **kwargs):  # noqa: E501
        """Get a virus scan policy
        Get a virus scan policy identified by {extId}. 

        >>> response = api.get_virus_scan_policy(virusScanPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_virus_scan_policy_with_http_info(virusScanPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param str virusScanPolicyExtId: The {extId} of the virus scan policy. (required)
        :param bool async_req:
        :return: files.v4.config.VirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['virusScanPolicyExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_virus_scan_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'virusScanPolicyExtId' is set
        if ('virusScanPolicyExtId' not in params or
                params['virusScanPolicyExtId'] is None):
            raise ValueError("Missing the required parameter `virusScanPolicyExtId` when calling `get_virus_scan_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'virusScanPolicyExtId' in params:
            path_params['virusScanPolicyExtId'] = params['virusScanPolicyExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/virus-scan-policy/{virusScanPolicyExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.VirusScanPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_mount_target_virus_scan_policy(self, mountTargetExtId, **kwargs):  # noqa: E501
        """List mount target virus scan policies
        List virus scan policy for a mount target with provided mountTargetExtId.  The user has to specify - a valid external identifier (`mountTargetExtId`) of the mount target for which the virus scan policy needs to be fetched.  A sample request URL would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/ff6cafea-a1dc-4d40-776a-cc2ce55be211/virus-scan-policy ``` 

        >>> response = api.list_mount_target_virus_scan_policy(mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_mount_target_virus_scan_policy(mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool async_req:
        :return: files.v4.config.ListMountTargetVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_mount_target_virus_scan_policy_with_http_info(mountTargetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.list_mount_target_virus_scan_policy_with_http_info(mountTargetExtId, **kwargs)  # noqa: E501
            return data

    def list_mount_target_virus_scan_policy_with_http_info(self, mountTargetExtId, **kwargs):  # noqa: E501
        """List mount target virus scan policies
        List virus scan policy for a mount target with provided mountTargetExtId.  The user has to specify - a valid external identifier (`mountTargetExtId`) of the mount target for which the virus scan policy needs to be fetched.  A sample request URL would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/ff6cafea-a1dc-4d40-776a-cc2ce55be211/virus-scan-policy ``` 

        >>> response = api.list_mount_target_virus_scan_policy(mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_mount_target_virus_scan_policy_with_http_info(mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool async_req:
        :return: files.v4.config.ListMountTargetVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_mount_target_virus_scan_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `list_mount_target_virus_scan_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/virus-scan-policy', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.ListMountTargetVirusScanPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_virus_scan_policy(self, **kwargs):  # noqa: E501
        """List virus scan policies
        List virus scan policy for a file server.  A sample request URL would look like this:  ``` /api/files/v4.0.a2/config/file-server/virus-scan-policy ``` 

        >>> response = api.list_virus_scan_policy()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_virus_scan_policy(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: files.v4.config.ListVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_virus_scan_policy_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_virus_scan_policy_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_virus_scan_policy_with_http_info(self, **kwargs):  # noqa: E501
        """List virus scan policies
        List virus scan policy for a file server.  A sample request URL would look like this:  ``` /api/files/v4.0.a2/config/file-server/virus-scan-policy ``` 

        >>> response = api.list_virus_scan_policy()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_virus_scan_policy_with_http_info(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: files.v4.config.ListVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_virus_scan_policy" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/virus-scan-policy', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.ListVirusScanPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_mount_target_virus_scan_policy(self, body, mountTargetExtId, virusScanPolicyExtId, **kwargs):  # noqa: E501
        """Update a mount target virus scan policy
        Update virus scan policy request for a mount target identified by mountTargetExtId.  A sample request body would look like this:  ``` {   \"scanOnRead\": true,   \"blockAccessFile\": true,   \"scanTimeoutIntervalInSecs\": 60,   \"fileTypeExclusions\": [     \".pdf\"   ],   \"mountTargetExtId\": \"4e624597-8a37-45aa-b4ac-0f992de0a903\",   \"scanOnWrite\": true,   \"extId\": \"dc9d2193-10db-45eb-8ff3-3bef0fe6fb07\" } ``` 

        >>> response = api.update_mount_target_virus_scan_policy(body, mountTargetExtId, virusScanPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_mount_target_virus_scan_policy(body, mountTargetExtId, virusScanPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.VirusScanPolicyMountTarget body: virus scan policy Model (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str virusScanPolicyExtId: The {extId} of the virus scan policy. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateMountTargetVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_mount_target_virus_scan_policy_with_http_info(body, mountTargetExtId, virusScanPolicyExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_mount_target_virus_scan_policy_with_http_info(body, mountTargetExtId, virusScanPolicyExtId, **kwargs)  # noqa: E501
            return data

    def update_mount_target_virus_scan_policy_with_http_info(self, body, mountTargetExtId, virusScanPolicyExtId, **kwargs):  # noqa: E501
        """Update a mount target virus scan policy
        Update virus scan policy request for a mount target identified by mountTargetExtId.  A sample request body would look like this:  ``` {   \"scanOnRead\": true,   \"blockAccessFile\": true,   \"scanTimeoutIntervalInSecs\": 60,   \"fileTypeExclusions\": [     \".pdf\"   ],   \"mountTargetExtId\": \"4e624597-8a37-45aa-b4ac-0f992de0a903\",   \"scanOnWrite\": true,   \"extId\": \"dc9d2193-10db-45eb-8ff3-3bef0fe6fb07\" } ``` 

        >>> response = api.update_mount_target_virus_scan_policy(body, mountTargetExtId, virusScanPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_mount_target_virus_scan_policy_with_http_info(body, mountTargetExtId, virusScanPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.VirusScanPolicyMountTarget body: virus scan policy Model (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str virusScanPolicyExtId: The {extId} of the virus scan policy. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateMountTargetVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'mountTargetExtId', 'virusScanPolicyExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_mount_target_virus_scan_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_mount_target_virus_scan_policy`")  # noqa: E501
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `update_mount_target_virus_scan_policy`")  # noqa: E501
        # verify the required parameter 'virusScanPolicyExtId' is set
        if ('virusScanPolicyExtId' not in params or
                params['virusScanPolicyExtId'] is None):
            raise ValueError("Missing the required parameter `virusScanPolicyExtId` when calling `update_mount_target_virus_scan_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501
        if 'virusScanPolicyExtId' in params:
            path_params['virusScanPolicyExtId'] = params['virusScanPolicyExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/virus-scan-policy/{virusScanPolicyExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateMountTargetVirusScanPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_virus_scan_policy(self, body, virusScanPolicyExtId, **kwargs):  # noqa: E501
        """Update a virus scan policy
        Update virus scan policy for file server identified for the provided extId.  A sample request body would look like this:  ``` {   \"scanOnRead\": true,   \"enableAntiVirus\": true,   \"scanTimeoutIntervalInSecs\": 120,   \"fileTypeExclusions\": [     \".txt\",     \".db\"   ],   \"scanOnWrite\": false,   \"fileSizeExclusionInBytes\": 0,   \"extId\": \"d96df616-c3e4-4ee3-8425-05d6182b27a1\" } ``` 

        >>> response = api.update_virus_scan_policy(body, virusScanPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_virus_scan_policy(body, virusScanPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.VirusScanPolicy body: virus scan policy Model (required)
        :param str virusScanPolicyExtId: The {extId} of the virus scan policy. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_virus_scan_policy_with_http_info(body, virusScanPolicyExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_virus_scan_policy_with_http_info(body, virusScanPolicyExtId, **kwargs)  # noqa: E501
            return data

    def update_virus_scan_policy_with_http_info(self, body, virusScanPolicyExtId, **kwargs):  # noqa: E501
        """Update a virus scan policy
        Update virus scan policy for file server identified for the provided extId.  A sample request body would look like this:  ``` {   \"scanOnRead\": true,   \"enableAntiVirus\": true,   \"scanTimeoutIntervalInSecs\": 120,   \"fileTypeExclusions\": [     \".txt\",     \".db\"   ],   \"scanOnWrite\": false,   \"fileSizeExclusionInBytes\": 0,   \"extId\": \"d96df616-c3e4-4ee3-8425-05d6182b27a1\" } ``` 

        >>> response = api.update_virus_scan_policy(body, virusScanPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_virus_scan_policy_with_http_info(body, virusScanPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.VirusScanPolicy body: virus scan policy Model (required)
        :param str virusScanPolicyExtId: The {extId} of the virus scan policy. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateVirusScanPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'virusScanPolicyExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_virus_scan_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_virus_scan_policy`")  # noqa: E501
        # verify the required parameter 'virusScanPolicyExtId' is set
        if ('virusScanPolicyExtId' not in params or
                params['virusScanPolicyExtId'] is None):
            raise ValueError("Missing the required parameter `virusScanPolicyExtId` when calling `update_virus_scan_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'virusScanPolicyExtId' in params:
            path_params['virusScanPolicyExtId'] = params['virusScanPolicyExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/virus-scan-policy/{virusScanPolicyExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateVirusScanPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
