# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class UserMappingApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_user_mapping(self, body, **kwargs):  # noqa: E501
        """Create a user mapping
        Create a user mapping using the provided request body.  User can specify fields like `explicitMapping`, `deniedAccessSmbUsers`, `ruleBasedMapping`.  A sample request body would look like this:  ``` {   \"explicitMapping\": {     \"deniedAccessSmbUsers\": [       {         \"actionType\": \"DENY_ACCESS\",         \"mappingType\": \"USER\",         \"name\": \"child4\\\\test1\"       },       {         \"actionType\": \"DENY_ACCESS\",         \"mappingType\": \"USER\",         \"name\": \"child4\\\\test2\"       }     ],     \"oneToOneMappings\": [       {         \"identityMappingType\": \"USER\",         \"nfsMapping\": {             \"name\": \"1001\"         },         \"smbMapping\": {             \"name\": \"child4\\\\administrator\"         }       }     ]   },   \"ruleBasedMapping\": {     \"nfsWithNoMappings\": [         {             \"actionType\": \"MAP_IDENTITIES\",             \"mappingType\": \"USER\",             \"name\": \"child4\\\\admin\"         },         {             \"actionType\": \"MAP_IDENTITIES\",             \"mappingType\": \"GROUP\",             \"name\": \"child4\\\\administrator\"         }     ],     \"smbWithNoMappings\": [         {           \"actionType\": \"MAP_IDENTITIES\",           \"mappingType\": \"USER\",           \"name\": \"1001\",           \"userId\": 1001         },         {           \"actionType\": \"MAP_IDENTITIES\",           \"groupId\": 1002,           \"mappingType\": \"GROUP\",           \"name\": \"1002\"         }     ],     \"templateMapping\": \"NO_TEMPLATE_MAPPING\"     }   } ``` 

        >>> response = api.create_user_mapping(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_mapping(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.UserMapping body: User mapping model. (required)
        :param bool async_req:
        :return: files.v4.config.CreateUserMappingApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_user_mapping_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_user_mapping_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_user_mapping_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a user mapping
        Create a user mapping using the provided request body.  User can specify fields like `explicitMapping`, `deniedAccessSmbUsers`, `ruleBasedMapping`.  A sample request body would look like this:  ``` {   \"explicitMapping\": {     \"deniedAccessSmbUsers\": [       {         \"actionType\": \"DENY_ACCESS\",         \"mappingType\": \"USER\",         \"name\": \"child4\\\\test1\"       },       {         \"actionType\": \"DENY_ACCESS\",         \"mappingType\": \"USER\",         \"name\": \"child4\\\\test2\"       }     ],     \"oneToOneMappings\": [       {         \"identityMappingType\": \"USER\",         \"nfsMapping\": {             \"name\": \"1001\"         },         \"smbMapping\": {             \"name\": \"child4\\\\administrator\"         }       }     ]   },   \"ruleBasedMapping\": {     \"nfsWithNoMappings\": [         {             \"actionType\": \"MAP_IDENTITIES\",             \"mappingType\": \"USER\",             \"name\": \"child4\\\\admin\"         },         {             \"actionType\": \"MAP_IDENTITIES\",             \"mappingType\": \"GROUP\",             \"name\": \"child4\\\\administrator\"         }     ],     \"smbWithNoMappings\": [         {           \"actionType\": \"MAP_IDENTITIES\",           \"mappingType\": \"USER\",           \"name\": \"1001\",           \"userId\": 1001         },         {           \"actionType\": \"MAP_IDENTITIES\",           \"groupId\": 1002,           \"mappingType\": \"GROUP\",           \"name\": \"1002\"         }     ],     \"templateMapping\": \"NO_TEMPLATE_MAPPING\"     }   } ``` 

        >>> response = api.create_user_mapping(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_mapping_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.UserMapping body: User mapping model. (required)
        :param bool async_req:
        :return: files.v4.config.CreateUserMappingApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_user_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/user-mapping', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateUserMappingApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_mapping(self, **kwargs):  # noqa: E501
        """Get a user mapping
        Get a list of user mappings.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_user_mapping()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_mapping(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: files.v4.config.UserMappingListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_mapping_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_mapping_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_mapping_with_http_info(self, **kwargs):  # noqa: E501
        """Get a user mapping
        Get a list of user mappings.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_user_mapping()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_mapping_with_http_info(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: files.v4.config.UserMappingListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_mapping" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/user-mapping', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UserMappingListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_user_mapping(self, body, **kwargs):  # noqa: E501
        """Search a user mapping
        Search a user mapping using the provided request body.  A sample request body would look like this:  ``` {   \"mappingType\": \"USER\",   \"nameIds\": [     \"4321\"   ],   \"actionType\": \"MAP_IDENTITIES\",   \"searchMappingType\": \"NFS_TO_SMB\" } ``` 

        >>> response = api.search_user_mapping(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_user_mapping(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.SearchUserMappingRequestSpec body: Search a user mapping request model. (required)
        :param bool async_req:
        :return: files.v4.config.SearchUserMappingPOSTResponses

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_user_mapping_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.search_user_mapping_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def search_user_mapping_with_http_info(self, body, **kwargs):  # noqa: E501
        """Search a user mapping
        Search a user mapping using the provided request body.  A sample request body would look like this:  ``` {   \"mappingType\": \"USER\",   \"nameIds\": [     \"4321\"   ],   \"actionType\": \"MAP_IDENTITIES\",   \"searchMappingType\": \"NFS_TO_SMB\" } ``` 

        >>> response = api.search_user_mapping(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_user_mapping_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.SearchUserMappingRequestSpec body: Search a user mapping request model. (required)
        :param bool async_req:
        :return: files.v4.config.SearchUserMappingPOSTResponses

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_user_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `search_user_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/$actions/search-user-mapping', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.SearchUserMappingPOSTResponses',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user_mapping(self, body, **kwargs):  # noqa: E501
        """Update a user mapping
        Update a user mapping using the provided request body.  The user needs to provide a request body for performing the update. They can specify fields like `explicitMapping`, `deniedAccessSmbUsers`, `ruleBasedMapping`.  A sample request body would look like this:  ``` {   \"explicitMapping\": {     \"deniedAccessSmbUsers\": [       {         \"actionType\": \"DENY_ACCESS\",         \"mappingType\": \"USER\",         \"name\": \"child4\\\\test1\"       },       {         \"actionType\": \"DENY_ACCESS\",         \"mappingType\": \"USER\",         \"name\": \"child4\\\\test2\"       }     ],     \"oneToOneMappings\": [       {         \"identityMappingType\": \"USER\",         \"nfsMapping\": {             \"name\": \"1001\"         },         \"smbMapping\": {             \"name\": \"child4\\\\administrator\"         }       }     ]   },   \"ruleBasedMapping\": {     \"nfsWithNoMappings\": [         {             \"actionType\": \"MAP_IDENTITIES\",             \"mappingType\": \"USER\",             \"name\": \"child4\\\\admin\"         },         {             \"actionType\": \"MAP_IDENTITIES\",             \"mappingType\": \"GROUP\",             \"name\": \"child4\\\\administrator\"         }     ],     \"smbWithNoMappings\": [         {           \"actionType\": \"MAP_IDENTITIES\",           \"mappingType\": \"USER\",           \"name\": \"1001\",           \"userId\": 1001         },         {           \"actionType\": \"MAP_IDENTITIES\",           \"groupId\": 1002,           \"mappingType\": \"GROUP\",           \"name\": \"1002\"         }     ],     \"templateMapping\": \"NO_TEMPLATE_MAPPING\"     }   } ```  User mapping update operation should be performed on a complete GET response body. A GET on a resource is required before doing an UPDATE operation. Sending a partial or incomplete GET response body as update request-body might result in the existing configuration being removed.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/user-mapping ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/user-mapping ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_user_mapping(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_mapping(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.UserMapping body: User mapping model. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateUserMappingApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_user_mapping_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_user_mapping_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def update_user_mapping_with_http_info(self, body, **kwargs):  # noqa: E501
        """Update a user mapping
        Update a user mapping using the provided request body.  The user needs to provide a request body for performing the update. They can specify fields like `explicitMapping`, `deniedAccessSmbUsers`, `ruleBasedMapping`.  A sample request body would look like this:  ``` {   \"explicitMapping\": {     \"deniedAccessSmbUsers\": [       {         \"actionType\": \"DENY_ACCESS\",         \"mappingType\": \"USER\",         \"name\": \"child4\\\\test1\"       },       {         \"actionType\": \"DENY_ACCESS\",         \"mappingType\": \"USER\",         \"name\": \"child4\\\\test2\"       }     ],     \"oneToOneMappings\": [       {         \"identityMappingType\": \"USER\",         \"nfsMapping\": {             \"name\": \"1001\"         },         \"smbMapping\": {             \"name\": \"child4\\\\administrator\"         }       }     ]   },   \"ruleBasedMapping\": {     \"nfsWithNoMappings\": [         {             \"actionType\": \"MAP_IDENTITIES\",             \"mappingType\": \"USER\",             \"name\": \"child4\\\\admin\"         },         {             \"actionType\": \"MAP_IDENTITIES\",             \"mappingType\": \"GROUP\",             \"name\": \"child4\\\\administrator\"         }     ],     \"smbWithNoMappings\": [         {           \"actionType\": \"MAP_IDENTITIES\",           \"mappingType\": \"USER\",           \"name\": \"1001\",           \"userId\": 1001         },         {           \"actionType\": \"MAP_IDENTITIES\",           \"groupId\": 1002,           \"mappingType\": \"GROUP\",           \"name\": \"1002\"         }     ],     \"templateMapping\": \"NO_TEMPLATE_MAPPING\"     }   } ```  User mapping update operation should be performed on a complete GET response body. A GET on a resource is required before doing an UPDATE operation. Sending a partial or incomplete GET response body as update request-body might result in the existing configuration being removed.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/user-mapping ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/user-mapping ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_user_mapping(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_mapping_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.UserMapping body: User mapping model. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateUserMappingApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_user_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/user-mapping', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateUserMappingApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
