# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class TierApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_tiering_config(self, body, **kwargs):  # noqa: E501
        """Create the tiering configuration.
        Create the tiering configuration using the provided request body.  The user needs to specify `capacityThreshold` in percentage. Tiering will only happen if the memory has exceeded the capacity threshold. Users can specify `schedule` for each day of the week, auto tiering can happen at that specified time.  A sample request body would look like this: ``` {   \"capacityThreshold\": 50,   \"schedule\": [     {         \"dayOfWeek\": 1,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },     {         \"dayOfWeek\": 2,         \"schedules\" :[             {                 \"startTimeHours\": 11,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 120             }         ]     },     {         \"dayOfWeek\": 3,         \"schedules\" :[             {                 \"startTimeHours\": 23,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },     {         \"dayOfWeek\": 4,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 5,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 6,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 7,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     }   ] } ``` 

        >>> response = api.create_tiering_config(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_tiering_config(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TieringConfig body: Tiering configuration model (required)
        :param bool async_req:
        :return: files.v4.config.CreateTieringConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tiering_config_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tiering_config_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_tiering_config_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create the tiering configuration.
        Create the tiering configuration using the provided request body.  The user needs to specify `capacityThreshold` in percentage. Tiering will only happen if the memory has exceeded the capacity threshold. Users can specify `schedule` for each day of the week, auto tiering can happen at that specified time.  A sample request body would look like this: ``` {   \"capacityThreshold\": 50,   \"schedule\": [     {         \"dayOfWeek\": 1,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },     {         \"dayOfWeek\": 2,         \"schedules\" :[             {                 \"startTimeHours\": 11,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 120             }         ]     },     {         \"dayOfWeek\": 3,         \"schedules\" :[             {                 \"startTimeHours\": 23,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },     {         \"dayOfWeek\": 4,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 5,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 6,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 7,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     }   ] } ``` 

        >>> response = api.create_tiering_config(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_tiering_config_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TieringConfig body: Tiering configuration model (required)
        :param bool async_req:
        :return: files.v4.config.CreateTieringConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tiering_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_tiering_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/tier-config', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateTieringConfigApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_tiering_policy(self, body, **kwargs):  # noqa: E501
        """Create a tiering policy.
        Create the tiering policy using the provided request body.  User can specify list of shares, cool-off periods, minimum file size. This will decide the list of files which will be identified for tiering.  A sample request body would look like this:  ``` {   \"isIncludeFutureShares\": true,   \"extId\": \"234ee9c2-8f08-4276-9b4c-a084cd592111\",   \"mountTargetExtIds\": [     \"d89ee9c2-8f08-4276-9b4c-a084cd59271b\",     \"2e9fe9c1-9d08-6251-4b4c-9271ba084cd5\"   ],   \"cooloffPeriodInSeconds\": 86400,   \"minimumFileSizeInBytes\": 70000 } ``` 

        >>> response = api.create_tiering_policy(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_tiering_policy(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TieringPolicy body: Tiering policy model (required)
        :param bool async_req:
        :return: files.v4.config.CreateTieringPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tiering_policy_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tiering_policy_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_tiering_policy_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a tiering policy.
        Create the tiering policy using the provided request body.  User can specify list of shares, cool-off periods, minimum file size. This will decide the list of files which will be identified for tiering.  A sample request body would look like this:  ``` {   \"isIncludeFutureShares\": true,   \"extId\": \"234ee9c2-8f08-4276-9b4c-a084cd592111\",   \"mountTargetExtIds\": [     \"d89ee9c2-8f08-4276-9b4c-a084cd59271b\",     \"2e9fe9c1-9d08-6251-4b4c-9271ba084cd5\"   ],   \"cooloffPeriodInSeconds\": 86400,   \"minimumFileSizeInBytes\": 70000 } ``` 

        >>> response = api.create_tiering_policy(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_tiering_policy_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TieringPolicy body: Tiering policy model (required)
        :param bool async_req:
        :return: files.v4.config.CreateTieringPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tiering_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_tiering_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/tier-policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateTieringPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tiering_config(self, extId, **kwargs):  # noqa: E501
        """Delete the tiering configuration.
        Delete the tiering configuration with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the configuration to be deleted. After deletion auto tiering will be disabled.  How to use Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/tier-config/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ````  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/tier-config/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status 

        >>> response = api.delete_tiering_config(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tiering_config(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Tiering config extId. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteTieringConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tiering_config_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tiering_config_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def delete_tiering_config_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Delete the tiering configuration.
        Delete the tiering configuration with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the configuration to be deleted. After deletion auto tiering will be disabled.  How to use Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/tier-config/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ````  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/tier-config/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status 

        >>> response = api.delete_tiering_config(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tiering_config_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Tiering config extId. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteTieringConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tiering_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_tiering_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/tier-config/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DeleteTieringConfigApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tiering_policy(self, extId, **kwargs):  # noqa: E501
        """Delete a tiering policy
        Delete the tiering policy identified with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the policy to be deleted.  How to use Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/tier-policies/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ````  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/tier-policies/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.delete_tiering_policy(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tiering_policy(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Tiering policy extId. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteTieringPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tiering_policy_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tiering_policy_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def delete_tiering_policy_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Delete a tiering policy
        Delete the tiering policy identified with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the policy to be deleted.  How to use Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/tier-policies/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ````  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/tier-policies/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.delete_tiering_policy(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tiering_policy_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Tiering policy extId. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteTieringPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tiering_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_tiering_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/tier-policies/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DeleteTieringPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_object_store_profile(self, profileExtId, **kwargs):  # noqa: E501
        """Get object store profile
        Get a single object store profile for the provided external identifier.  The user has to specify - a valid external identifier  (`profileExtId`) of the object store profile to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_object_store_profile(profileExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_object_store_profile(profileExtId, async_req=True)
        >>> result = thread.get()

        :param str profileExtId: UUID of the tiering object store (required)
        :param bool async_req:
        :return: files.v4.config.GetObjectStoreApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_object_store_profile_with_http_info(profileExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_object_store_profile_with_http_info(profileExtId, **kwargs)  # noqa: E501
            return data

    def get_object_store_profile_with_http_info(self, profileExtId, **kwargs):  # noqa: E501
        """Get object store profile
        Get a single object store profile for the provided external identifier.  The user has to specify - a valid external identifier  (`profileExtId`) of the object store profile to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_object_store_profile(profileExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_object_store_profile_with_http_info(profileExtId, async_req=True)
        >>> result = thread.get()

        :param str profileExtId: UUID of the tiering object store (required)
        :param bool async_req:
        :return: files.v4.config.GetObjectStoreApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['profileExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_object_store_profile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'profileExtId' is set
        if ('profileExtId' not in params or
                params['profileExtId'] is None):
            raise ValueError("Missing the required parameter `profileExtId` when calling `get_object_store_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'profileExtId' in params:
            path_params['profileExtId'] = params['profileExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/object-store/profiles/{profileExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.GetObjectStoreApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tiering_config(self, extId, **kwargs):  # noqa: E501
        """Get the tiering configuration.
        Get tiering configuration with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the configuration to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_tiering_config(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tiering_config(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Tiering config extId. (required)
        :param bool async_req:
        :return: files.v4.config.GetTieringConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tiering_config_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tiering_config_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_tiering_config_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get the tiering configuration.
        Get tiering configuration with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the configuration to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_tiering_config(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tiering_config_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Tiering config extId. (required)
        :param bool async_req:
        :return: files.v4.config.GetTieringConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tiering_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_tiering_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/tier-config/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.GetTieringConfigApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tiering_config_list(self, **kwargs):  # noqa: E501
        """Get list of the tiering configuration.
        Get list of the tiering configuration.

        >>> response = api.get_tiering_config_list((optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tiering_config_list(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param bool async_req:
        :return: files.v4.config.GetTieringConfigListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tiering_config_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tiering_config_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tiering_config_list_with_http_info(self, **kwargs):  # noqa: E501
        """Get list of the tiering configuration.
        Get list of the tiering configuration.

        >>> response = api.get_tiering_config_list((optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tiering_config_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param bool async_req:
        :return: files.v4.config.GetTieringConfigListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tiering_config_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/tier-config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.GetTieringConfigListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tiering_policies(self, **kwargs):  # noqa: E501
        """List tiering policies
        Get a paginated list of the tiering policies.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported: - cooloffPeriodInSeconds - minimumFileSizeInBytes - isIncludeFutureShares  Example of supported query parameters for the tiering policy list API: ```   - ?$page=0&$limit=1   - ?$select=cooloffPeriodInSeconds, minimumFileSizeInBytes   - ?$limit=5&$select=cooloffPeriodInSeconds, minimumFileSizeInBytes   - ?$filter=cooloffPeriodInSeconds gt 50000   - ?$orderby=minimumFileSizeInBytes ``` The `$orderby` query parameter allows specifying attributes on which to sort the returned list of the tiering policies  The following parameters support sorting in the object store profile list: - cooloffPeriodInSeconds - minimumFileSizeInBytes - isIncludeFutureShares  A sample call would look like this: ``` /api/files/v4.0.a2/config/file-server/tier-policies?$orderby=cooloffPeriodInSeconds desc ```  The `$select` query parameter allows specifying attributes which the user wants to fetch in the returned list of the tiering policies, other attributes will be returned as a null value.  the following attributes can be selected: - cooloffPeriodInSeconds - minimumFileSizeInBytes - isIncludeFutureShares  Some more examples are given below: 1. Filter by cooloffPeriodInSeconds: ``` /api/files/v4.0.a2/config/file-server/tier-policies?$filter=cooloffPeriodInSeconds gt 50 ```  2. Order by cooloffPeriodInSeconds in ascending order ``` /api/files/v4.0.a2/config/file-server/tier-policies?$orderby=cooloffPeriodInSeconds asc ```  3. Order by cooloffPeriodInSeconds in descending order ``` /api/files/v4.0.a2/config/file-server/tier-policies?$orderby=cooloffPeriodInSeconds desc ```  4. Select by cooloffPeriodInSeconds ``` /api/files/v4.0.a2/config/file-server/tier-policies?$select=cooloffPeriodInSeconds ```  5. Paginate the returned tiering policy list ``` /api/files/v4.0.a2/config/file-server/tier-policies?$page=0&$limit=1 ```  6. Combination of queries ``` /api/files/v4.0.a2/config/file-server/tier-policies?$limit=5&$select=cooloffPeriodInSeconds &$orderby=cooloffPeriodInSeconds desc ```  If the user doesn't specify any search query parameters, a list of all tiering policies will be returned. 

        >>> response = api.get_tiering_policies((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tiering_policies(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - cooloffPeriodInSeconds
        - isIncludeFutureShares
        - minimumFileSizeInBytes
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - cooloffPeriodInSeconds
        - isIncludeFutureShares
        - minimumFileSizeInBytes
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- cooloffPeriodInSeconds
- extId
- isIncludeFutureShares
- links
- minimumFileSizeInBytes
- mountTargetExtIds
- tenantId

        :param bool async_req:
        :return: files.v4.config.GetTieringPolicyListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tiering_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tiering_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tiering_policies_with_http_info(self, **kwargs):  # noqa: E501
        """List tiering policies
        Get a paginated list of the tiering policies.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported: - cooloffPeriodInSeconds - minimumFileSizeInBytes - isIncludeFutureShares  Example of supported query parameters for the tiering policy list API: ```   - ?$page=0&$limit=1   - ?$select=cooloffPeriodInSeconds, minimumFileSizeInBytes   - ?$limit=5&$select=cooloffPeriodInSeconds, minimumFileSizeInBytes   - ?$filter=cooloffPeriodInSeconds gt 50000   - ?$orderby=minimumFileSizeInBytes ``` The `$orderby` query parameter allows specifying attributes on which to sort the returned list of the tiering policies  The following parameters support sorting in the object store profile list: - cooloffPeriodInSeconds - minimumFileSizeInBytes - isIncludeFutureShares  A sample call would look like this: ``` /api/files/v4.0.a2/config/file-server/tier-policies?$orderby=cooloffPeriodInSeconds desc ```  The `$select` query parameter allows specifying attributes which the user wants to fetch in the returned list of the tiering policies, other attributes will be returned as a null value.  the following attributes can be selected: - cooloffPeriodInSeconds - minimumFileSizeInBytes - isIncludeFutureShares  Some more examples are given below: 1. Filter by cooloffPeriodInSeconds: ``` /api/files/v4.0.a2/config/file-server/tier-policies?$filter=cooloffPeriodInSeconds gt 50 ```  2. Order by cooloffPeriodInSeconds in ascending order ``` /api/files/v4.0.a2/config/file-server/tier-policies?$orderby=cooloffPeriodInSeconds asc ```  3. Order by cooloffPeriodInSeconds in descending order ``` /api/files/v4.0.a2/config/file-server/tier-policies?$orderby=cooloffPeriodInSeconds desc ```  4. Select by cooloffPeriodInSeconds ``` /api/files/v4.0.a2/config/file-server/tier-policies?$select=cooloffPeriodInSeconds ```  5. Paginate the returned tiering policy list ``` /api/files/v4.0.a2/config/file-server/tier-policies?$page=0&$limit=1 ```  6. Combination of queries ``` /api/files/v4.0.a2/config/file-server/tier-policies?$limit=5&$select=cooloffPeriodInSeconds &$orderby=cooloffPeriodInSeconds desc ```  If the user doesn't specify any search query parameters, a list of all tiering policies will be returned. 

        >>> response = api.get_tiering_policies((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tiering_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - cooloffPeriodInSeconds
        - isIncludeFutureShares
        - minimumFileSizeInBytes
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - cooloffPeriodInSeconds
        - isIncludeFutureShares
        - minimumFileSizeInBytes
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- cooloffPeriodInSeconds
- extId
- isIncludeFutureShares
- links
- minimumFileSizeInBytes
- mountTargetExtIds
- tenantId

        :param bool async_req:
        :return: files.v4.config.GetTieringPolicyListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tiering_policies" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/tier-policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.GetTieringPolicyListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tiering_policy_by_id(self, extId, **kwargs):  # noqa: E501
        """Get a tiering policy by extId
        Get the tiering policy identified with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the policy to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_tiering_policy_by_id(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tiering_policy_by_id(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Tiering policy extId. (required)
        :param bool async_req:
        :return: files.v4.config.GetTieringPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tiering_policy_by_id_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tiering_policy_by_id_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_tiering_policy_by_id_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get a tiering policy by extId
        Get the tiering policy identified with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the policy to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_tiering_policy_by_id(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tiering_policy_by_id_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Tiering policy extId. (required)
        :param bool async_req:
        :return: files.v4.config.GetTieringPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tiering_policy_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_tiering_policy_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/tier-policies/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.GetTieringPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tier_data(self, body, **kwargs):  # noqa: E501
        """Initiate tiering data.
        Initiate the process of tiering data.  The user needs to provide duration in seconds. Tiering will start immediately and will run for the specified duration. If the duration is not provided the tiering will run until file server storage usage has reached the threshold capacity value.  A sample request body would look like this:  ``` {   \"durationInSeconds\": 86400 } ``` 

        >>> response = api.tier_data(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.tier_data(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TierData body: Model for tier data. (required)
        :param bool async_req:
        :return: files.v4.config.TierDataApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tier_data_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.tier_data_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def tier_data_with_http_info(self, body, **kwargs):  # noqa: E501
        """Initiate tiering data.
        Initiate the process of tiering data.  The user needs to provide duration in seconds. Tiering will start immediately and will run for the specified duration. If the duration is not provided the tiering will run until file server storage usage has reached the threshold capacity value.  A sample request body would look like this:  ``` {   \"durationInSeconds\": 86400 } ``` 

        >>> response = api.tier_data(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.tier_data_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TierData body: Model for tier data. (required)
        :param bool async_req:
        :return: files.v4.config.TierDataApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tier_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `tier_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/$actions/tier-data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.TierDataApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_object_store_profile(self, body, profileExtId, **kwargs):  # noqa: E501
        """Update object store profile
        Update attributes of the object store profile with the given external identifier using the provided request body.  The user has to specify - a valid external identifier (`profileExtId`) of the policy to be updated. They also need to provide a request body for performing the update.  A sample request body would look like this:  ``` {   \"secretKey\": \"NaabhdrtaPDndqmvfdoaVqTPyotqz\",   \"fileServerExtId\": \"cc118c4e-bfe7-4cfd-a363-c2717983fb75\",   \"accessKey\": \"5--abgdrVrjL6zCKnAXfBNCUIPk_iEGpT\",   \"extId\": \"546b1234-af77-48a3-a1fb-f5cba068f037\",   \"tenantId\": \"aa123c4a-bfe7-4cfd-a363-c2717983f111\" } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/object-store/profiles/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/object-store/profiles/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_object_store_profile(body, profileExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_object_store_profile(body, profileExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TieringObjectStoreProfile body: Object store profile specification. (required)
        :param str profileExtId: UUID of the tiering object store (required)
        :param bool async_req:
        :return: files.v4.config.UpdateObjectStoreApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_object_store_profile_with_http_info(body, profileExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_object_store_profile_with_http_info(body, profileExtId, **kwargs)  # noqa: E501
            return data

    def update_object_store_profile_with_http_info(self, body, profileExtId, **kwargs):  # noqa: E501
        """Update object store profile
        Update attributes of the object store profile with the given external identifier using the provided request body.  The user has to specify - a valid external identifier (`profileExtId`) of the policy to be updated. They also need to provide a request body for performing the update.  A sample request body would look like this:  ``` {   \"secretKey\": \"NaabhdrtaPDndqmvfdoaVqTPyotqz\",   \"fileServerExtId\": \"cc118c4e-bfe7-4cfd-a363-c2717983fb75\",   \"accessKey\": \"5--abgdrVrjL6zCKnAXfBNCUIPk_iEGpT\",   \"extId\": \"546b1234-af77-48a3-a1fb-f5cba068f037\",   \"tenantId\": \"aa123c4a-bfe7-4cfd-a363-c2717983f111\" } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/object-store/profiles/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/object-store/profiles/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_object_store_profile(body, profileExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_object_store_profile_with_http_info(body, profileExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TieringObjectStoreProfile body: Object store profile specification. (required)
        :param str profileExtId: UUID of the tiering object store (required)
        :param bool async_req:
        :return: files.v4.config.UpdateObjectStoreApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'profileExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_object_store_profile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_object_store_profile`")  # noqa: E501
        # verify the required parameter 'profileExtId' is set
        if ('profileExtId' not in params or
                params['profileExtId'] is None):
            raise ValueError("Missing the required parameter `profileExtId` when calling `update_object_store_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'profileExtId' in params:
            path_params['profileExtId'] = params['profileExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/object-store/profiles/{profileExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateObjectStoreApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tiering_config(self, body, extId, **kwargs):  # noqa: E501
        """Update the tiering configuration.
        Update the tiering configuration with the given external identifier using the provided request body.  The user has to specify - a valid external identifier (`extId`) of the configuration to be updated. They also need to provide a request body for performing the update.  A sample request body would look like this:  ``` {   \"capacityThreshold\": 50,   \"schedule\": [     {         \"dayOfWeek\": 1,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },     {         \"dayOfWeek\": 2,         \"schedules\" :[             {                 \"startTimeHours\": 11,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 120             }         ]     },     {         \"dayOfWeek\": 3,         \"schedules\" :[             {                 \"startTimeHours\": 23,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },     {         \"dayOfWeek\": 4,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 5,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 6,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 7,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     }   ] } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/tier-config/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/tier-config/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_tiering_config(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_tiering_config(body, extId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TieringConfig body: Tiering configuration model (required)
        :param str extId: Tiering config extId. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateTieringConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tiering_config_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tiering_config_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def update_tiering_config_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Update the tiering configuration.
        Update the tiering configuration with the given external identifier using the provided request body.  The user has to specify - a valid external identifier (`extId`) of the configuration to be updated. They also need to provide a request body for performing the update.  A sample request body would look like this:  ``` {   \"capacityThreshold\": 50,   \"schedule\": [     {         \"dayOfWeek\": 1,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },     {         \"dayOfWeek\": 2,         \"schedules\" :[             {                 \"startTimeHours\": 11,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 120             }         ]     },     {         \"dayOfWeek\": 3,         \"schedules\" :[             {                 \"startTimeHours\": 23,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },     {         \"dayOfWeek\": 4,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 5,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 6,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     },      {         \"dayOfWeek\": 7,         \"schedules\" :[             {                 \"startTimeHours\": 10,                 \"startTimeMinutes\": 10,                 \"durationMinutes\": 100             }         ]     }   ] } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/tier-config/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/tier-config/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_tiering_config(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_tiering_config_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TieringConfig body: Tiering configuration model (required)
        :param str extId: Tiering config extId. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateTieringConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tiering_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_tiering_config`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_tiering_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/tier-config/{extId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateTieringConfigApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tiering_policy(self, body, extId, **kwargs):  # noqa: E501
        """Update a tiering policy
        Update the tiering policy with the given external identifier using the provided request body.  The user has to specify - a valid external identifier (`extId`) of the policy to be updated. They also need to provide a request body for performing the update.  A sample request body would look like this:  ``` {   \"isIncludeFutureShares\": true,   \"mountTargetExtIds\": [     \"d89ee9c2-8f08-4276-9b4c-a084cd59271b\",     \"2e9fe9c1-9d08-6251-4b4c-9271ba084cd5\"   ],   \"cooloffPeriodInSeconds\": 86400,   \"minimumFileSizeInBytes\": 70000 } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/tier-policies/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/tier-policies/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_tiering_policy(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_tiering_policy(body, extId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TieringPolicy body: Tiering policy model (required)
        :param str extId: Tiering policy extId. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateTieringPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tiering_policy_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tiering_policy_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def update_tiering_policy_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Update a tiering policy
        Update the tiering policy with the given external identifier using the provided request body.  The user has to specify - a valid external identifier (`extId`) of the policy to be updated. They also need to provide a request body for performing the update.  A sample request body would look like this:  ``` {   \"isIncludeFutureShares\": true,   \"mountTargetExtIds\": [     \"d89ee9c2-8f08-4276-9b4c-a084cd59271b\",     \"2e9fe9c1-9d08-6251-4b4c-9271ba084cd5\"   ],   \"cooloffPeriodInSeconds\": 86400,   \"minimumFileSizeInBytes\": 70000 } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/tier-policies/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/tier-policies/bb118c5e-bfe7-4cfd-a363-c3717983fb75 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_tiering_policy(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_tiering_policy_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.TieringPolicy body: Tiering policy model (required)
        :param str extId: Tiering policy extId. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateTieringPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tiering_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_tiering_policy`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_tiering_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/tier-policies/{extId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateTieringPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
