# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class SsrSnapshotScheduleApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_ssr_snapshot_schedule(self, body, **kwargs):  # noqa: E501
        """Create a SSR snapshot schedule
        Creates a new SSR snapshot schedule using the provided request body.  The user needs to specify the `localMaxSnapshots` and `snapshotScheduleType` of the schedule to be created. User can also provide `daysOfWeek`, `daysOfMonth`, `snapshotScheduleFrequency`.  A sample request body would look like this:  ``` {   \"snapshotScheduleType\": \"HOURLY\",   \"localMaxSnapshots\": 24,   \"snapshotScheduleFrequency\": 4 } ``` 

        >>> response = api.create_ssr_snapshot_schedule(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ssr_snapshot_schedule(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.SsrSnapshotSchedule body: SSR snapshot schedule model (required)
        :param bool async_req:
        :return: files.v4.config.CreateSsrSnapshotScheduleApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ssr_snapshot_schedule_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ssr_snapshot_schedule_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_ssr_snapshot_schedule_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a SSR snapshot schedule
        Creates a new SSR snapshot schedule using the provided request body.  The user needs to specify the `localMaxSnapshots` and `snapshotScheduleType` of the schedule to be created. User can also provide `daysOfWeek`, `daysOfMonth`, `snapshotScheduleFrequency`.  A sample request body would look like this:  ``` {   \"snapshotScheduleType\": \"HOURLY\",   \"localMaxSnapshots\": 24,   \"snapshotScheduleFrequency\": 4 } ``` 

        >>> response = api.create_ssr_snapshot_schedule(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ssr_snapshot_schedule_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.SsrSnapshotSchedule body: SSR snapshot schedule model (required)
        :param bool async_req:
        :return: files.v4.config.CreateSsrSnapshotScheduleApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ssr_snapshot_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_ssr_snapshot_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateSsrSnapshotScheduleApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ssr_snapshot_schedule(self, ssrSnapshotScheduleExtId, **kwargs):  # noqa: E501
        """Delete SSR snapshot schedule
        Delete a SSR snapshot schedule with the given external identifier.  The user has to specify - a valid external identifier  (`extId`) of the schedule to be deleted.  How to pass Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/48f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/48f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.delete_ssr_snapshot_schedule(ssrSnapshotScheduleExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ssr_snapshot_schedule(ssrSnapshotScheduleExtId, async_req=True)
        >>> result = thread.get()

        :param str ssrSnapshotScheduleExtId: SSR snapshot schedule extId. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.DeleteSsrSnapshotScheduleApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ssr_snapshot_schedule_with_http_info(ssrSnapshotScheduleExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ssr_snapshot_schedule_with_http_info(ssrSnapshotScheduleExtId, **kwargs)  # noqa: E501
            return data

    def delete_ssr_snapshot_schedule_with_http_info(self, ssrSnapshotScheduleExtId, **kwargs):  # noqa: E501
        """Delete SSR snapshot schedule
        Delete a SSR snapshot schedule with the given external identifier.  The user has to specify - a valid external identifier  (`extId`) of the schedule to be deleted.  How to pass Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/48f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/48f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.delete_ssr_snapshot_schedule(ssrSnapshotScheduleExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ssr_snapshot_schedule_with_http_info(ssrSnapshotScheduleExtId, async_req=True)
        >>> result = thread.get()

        :param str ssrSnapshotScheduleExtId: SSR snapshot schedule extId. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.DeleteSsrSnapshotScheduleApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ssrSnapshotScheduleExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ssr_snapshot_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ssrSnapshotScheduleExtId' is set
        if ('ssrSnapshotScheduleExtId' not in params or
                params['ssrSnapshotScheduleExtId'] is None):
            raise ValueError("Missing the required parameter `ssrSnapshotScheduleExtId` when calling `delete_ssr_snapshot_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ssrSnapshotScheduleExtId' in params:
            path_params['ssrSnapshotScheduleExtId'] = params['ssrSnapshotScheduleExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/{ssrSnapshotScheduleExtId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DeleteSsrSnapshotScheduleApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ssr_snapshot_schedule_by_ext_id(self, ssrSnapshotScheduleExtId, **kwargs):  # noqa: E501
        """Get SSR snapshot schedule by extId
        Get a SSR snapshot schedule with the given external identifier.  The user has to specify - a valid external identifier  (`extId`) of the schedule to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_ssr_snapshot_schedule_by_ext_id(ssrSnapshotScheduleExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ssr_snapshot_schedule_by_ext_id(ssrSnapshotScheduleExtId, async_req=True)
        >>> result = thread.get()

        :param str ssrSnapshotScheduleExtId: SSR snapshot schedule extId. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.SsrSnapshotScheduleApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ssr_snapshot_schedule_by_ext_id_with_http_info(ssrSnapshotScheduleExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ssr_snapshot_schedule_by_ext_id_with_http_info(ssrSnapshotScheduleExtId, **kwargs)  # noqa: E501
            return data

    def get_ssr_snapshot_schedule_by_ext_id_with_http_info(self, ssrSnapshotScheduleExtId, **kwargs):  # noqa: E501
        """Get SSR snapshot schedule by extId
        Get a SSR snapshot schedule with the given external identifier.  The user has to specify - a valid external identifier  (`extId`) of the schedule to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_ssr_snapshot_schedule_by_ext_id(ssrSnapshotScheduleExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ssr_snapshot_schedule_by_ext_id_with_http_info(ssrSnapshotScheduleExtId, async_req=True)
        >>> result = thread.get()

        :param str ssrSnapshotScheduleExtId: SSR snapshot schedule extId. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.SsrSnapshotScheduleApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ssrSnapshotScheduleExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ssr_snapshot_schedule_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ssrSnapshotScheduleExtId' is set
        if ('ssrSnapshotScheduleExtId' not in params or
                params['ssrSnapshotScheduleExtId'] is None):
            raise ValueError("Missing the required parameter `ssrSnapshotScheduleExtId` when calling `get_ssr_snapshot_schedule_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ssrSnapshotScheduleExtId' in params:
            path_params['ssrSnapshotScheduleExtId'] = params['ssrSnapshotScheduleExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/{ssrSnapshotScheduleExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.SsrSnapshotScheduleApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ssr_snapshot_schedules(self, **kwargs):  # noqa: E501
        """List SSR snapshot schedules
        Get a paginated list of SSR snapshot schedules.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported: - localMaxSnapshots - snapshotScheduleType  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$filter=snapshotScheduleType eq Schema.Enums.SnapshotScheduleType'WEEKLY' ```  Example of supported query parameters for SSR snapshot schedules LIST API: ```   - ?$page=0&$limit=1   - ?$select=snapshotScheduleType, localMaxSnapshots   - ?$orderby=localMaxSnapshots desc   - ?$filter=snapshotScheduleType eq Schema.Enums.SnapshotScheduleType'WEEKLY'   - ?$filter=localMaxSnapshots eq 4   - ?$filter=localMaxSnapshots ne 4   - ?$select=snapshotScheduleType, localMaxSnapshots&$filter=localMaxSnapshots ne 4   - ?$limit=5&$select=snapshotScheduleType, localMaxSnapshots&$orderby=snapshotScheduleType desc ```  The `$orderby` query parameter allows specifying attributes on which to sort the returned list of SSR snapshot schedules.  The following parameters support sorting in SSR snapshot schedule list API: - localMaxSnapshots - snapshotScheduleType  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$orderby=name desc ```  The $select query parameter allows specifying attributes which the user wants to fetch in the returned list of SSR snapshot schedules, other attributes will be returned as  a null value.  The following attributes can be selected: ```   - localMaxSnapshots   - snapshotScheduleType ```  Some more examples are given below:  1. Order by name in ascending order  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$orderby=localMaxSnapshots asc ```  2. Select by snapshotScheduleType  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$select=snapshotScheduleType ```  3. Paginate the returned list  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$page=0&$limit=1 ```  4. Combination of queries  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$limit=5&$select=snapshotScheduleType, localMaxSnapshots&$orderby=localMaxSnapshots desc ``` 

        >>> response = api.get_ssr_snapshot_schedules((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ssr_snapshot_schedules(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - localMaxSnapshots
        - snapshotScheduleType
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - localMaxSnapshots
        - snapshotScheduleType
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- daysOfMonth
- daysOfWeek
- extId
- links
- localMaxSnapshots
- snapshotScheduleFrequency
- snapshotScheduleType
- tenantId

        :param bool async_req:
        :return: files.v4.config.SsrSnapshotScheduleListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ssr_snapshot_schedules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ssr_snapshot_schedules_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ssr_snapshot_schedules_with_http_info(self, **kwargs):  # noqa: E501
        """List SSR snapshot schedules
        Get a paginated list of SSR snapshot schedules.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported: - localMaxSnapshots - snapshotScheduleType  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$filter=snapshotScheduleType eq Schema.Enums.SnapshotScheduleType'WEEKLY' ```  Example of supported query parameters for SSR snapshot schedules LIST API: ```   - ?$page=0&$limit=1   - ?$select=snapshotScheduleType, localMaxSnapshots   - ?$orderby=localMaxSnapshots desc   - ?$filter=snapshotScheduleType eq Schema.Enums.SnapshotScheduleType'WEEKLY'   - ?$filter=localMaxSnapshots eq 4   - ?$filter=localMaxSnapshots ne 4   - ?$select=snapshotScheduleType, localMaxSnapshots&$filter=localMaxSnapshots ne 4   - ?$limit=5&$select=snapshotScheduleType, localMaxSnapshots&$orderby=snapshotScheduleType desc ```  The `$orderby` query parameter allows specifying attributes on which to sort the returned list of SSR snapshot schedules.  The following parameters support sorting in SSR snapshot schedule list API: - localMaxSnapshots - snapshotScheduleType  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$orderby=name desc ```  The $select query parameter allows specifying attributes which the user wants to fetch in the returned list of SSR snapshot schedules, other attributes will be returned as  a null value.  The following attributes can be selected: ```   - localMaxSnapshots   - snapshotScheduleType ```  Some more examples are given below:  1. Order by name in ascending order  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$orderby=localMaxSnapshots asc ```  2. Select by snapshotScheduleType  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$select=snapshotScheduleType ```  3. Paginate the returned list  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$page=0&$limit=1 ```  4. Combination of queries  ``` /files/v4.0.a2/config/file-server/ssr-snapshot-schedules?$limit=5&$select=snapshotScheduleType, localMaxSnapshots&$orderby=localMaxSnapshots desc ``` 

        >>> response = api.get_ssr_snapshot_schedules((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ssr_snapshot_schedules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - localMaxSnapshots
        - snapshotScheduleType
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - localMaxSnapshots
        - snapshotScheduleType
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- daysOfMonth
- daysOfWeek
- extId
- links
- localMaxSnapshots
- snapshotScheduleFrequency
- snapshotScheduleType
- tenantId

        :param bool async_req:
        :return: files.v4.config.SsrSnapshotScheduleListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ssr_snapshot_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.SsrSnapshotScheduleListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ssr_snapshot_schedule(self, body, ssrSnapshotScheduleExtId, **kwargs):  # noqa: E501
        """Update SSR snapshot schedule
        Update a SSR snapshot schedule with the given external identifier using the provided request body.  The user has to specify - a valid external identifier  (`extId`) of the schedule to be updated. They also need to provide a request body for   performing the update. They can provide an updated value of   `snapshotScheduleFrequency`, `snapshotScheduleType` and `localMaxSnapshots`.  A sample request body would look like this:  ``` {   \"snapshotScheduleType\": \"HOURLY\",   \"localMaxSnapshots\": 24,   \"snapshotScheduleFrequency\": 6 } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/48f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/48f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_ssr_snapshot_schedule(body, ssrSnapshotScheduleExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_ssr_snapshot_schedule(body, ssrSnapshotScheduleExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.SsrSnapshotSchedule body: SSR snapshot schedule model (required)
        :param str ssrSnapshotScheduleExtId: SSR snapshot schedule extId. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.UpdateSsrSnapshotScheduleApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ssr_snapshot_schedule_with_http_info(body, ssrSnapshotScheduleExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ssr_snapshot_schedule_with_http_info(body, ssrSnapshotScheduleExtId, **kwargs)  # noqa: E501
            return data

    def update_ssr_snapshot_schedule_with_http_info(self, body, ssrSnapshotScheduleExtId, **kwargs):  # noqa: E501
        """Update SSR snapshot schedule
        Update a SSR snapshot schedule with the given external identifier using the provided request body.  The user has to specify - a valid external identifier  (`extId`) of the schedule to be updated. They also need to provide a request body for   performing the update. They can provide an updated value of   `snapshotScheduleFrequency`, `snapshotScheduleType` and `localMaxSnapshots`.  A sample request body would look like this:  ``` {   \"snapshotScheduleType\": \"HOURLY\",   \"localMaxSnapshots\": 24,   \"snapshotScheduleFrequency\": 6 } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/48f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/48f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_ssr_snapshot_schedule(body, ssrSnapshotScheduleExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_ssr_snapshot_schedule_with_http_info(body, ssrSnapshotScheduleExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.SsrSnapshotSchedule body: SSR snapshot schedule model (required)
        :param str ssrSnapshotScheduleExtId: SSR snapshot schedule extId. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.UpdateSsrSnapshotScheduleApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'ssrSnapshotScheduleExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ssr_snapshot_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_ssr_snapshot_schedule`")  # noqa: E501
        # verify the required parameter 'ssrSnapshotScheduleExtId' is set
        if ('ssrSnapshotScheduleExtId' not in params or
                params['ssrSnapshotScheduleExtId'] is None):
            raise ValueError("Missing the required parameter `ssrSnapshotScheduleExtId` when calling `update_ssr_snapshot_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ssrSnapshotScheduleExtId' in params:
            path_params['ssrSnapshotScheduleExtId'] = params['ssrSnapshotScheduleExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/ssr-snapshot-schedules/{ssrSnapshotScheduleExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateSsrSnapshotScheduleApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
