# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class SnapshotsApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_mount_target_snapshot(self, mountTargetExtId, snapshotExtId, **kwargs):  # noqa: E501
        """Delete mount target snapshot
        Delete a mount target snapshot with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the mount target to which the snapshot belongs to and a valid external identifier (`extId`) of the snapshot to be deleted. 

        >>> response = api.delete_mount_target_snapshot(mountTargetExtId, snapshotExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mount_target_snapshot(mountTargetExtId, snapshotExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str snapshotExtId: The extId of the snapshot. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.DeleteMountTargetSnapshotApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_mount_target_snapshot_with_http_info(mountTargetExtId, snapshotExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_mount_target_snapshot_with_http_info(mountTargetExtId, snapshotExtId, **kwargs)  # noqa: E501
            return data

    def delete_mount_target_snapshot_with_http_info(self, mountTargetExtId, snapshotExtId, **kwargs):  # noqa: E501
        """Delete mount target snapshot
        Delete a mount target snapshot with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the mount target to which the snapshot belongs to and a valid external identifier (`extId`) of the snapshot to be deleted. 

        >>> response = api.delete_mount_target_snapshot(mountTargetExtId, snapshotExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mount_target_snapshot_with_http_info(mountTargetExtId, snapshotExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str snapshotExtId: The extId of the snapshot. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.DeleteMountTargetSnapshotApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', 'snapshotExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mount_target_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `delete_mount_target_snapshot`")  # noqa: E501
        # verify the required parameter 'snapshotExtId' is set
        if ('snapshotExtId' not in params or
                params['snapshotExtId'] is None):
            raise ValueError("Missing the required parameter `snapshotExtId` when calling `delete_mount_target_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501
        if 'snapshotExtId' in params:
            path_params['snapshotExtId'] = params['snapshotExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/snapshots/{snapshotExtId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DeleteMountTargetSnapshotApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mount_target_snapshot_by_ext_id(self, mountTargetExtId, snapshotExtId, **kwargs):  # noqa: E501
        """Get mount target snapshot for the provided extId
        Get mount target snapshot with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the mount target to which the snapshot belongs to and a valid external identifier (`extId`) of the snapshot to be fetched. 

        >>> response = api.get_mount_target_snapshot_by_ext_id(mountTargetExtId, snapshotExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mount_target_snapshot_by_ext_id(mountTargetExtId, snapshotExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str snapshotExtId: The extId of the snapshot. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.MountTargetSnapshotApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mount_target_snapshot_by_ext_id_with_http_info(mountTargetExtId, snapshotExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mount_target_snapshot_by_ext_id_with_http_info(mountTargetExtId, snapshotExtId, **kwargs)  # noqa: E501
            return data

    def get_mount_target_snapshot_by_ext_id_with_http_info(self, mountTargetExtId, snapshotExtId, **kwargs):  # noqa: E501
        """Get mount target snapshot for the provided extId
        Get mount target snapshot with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the mount target to which the snapshot belongs to and a valid external identifier (`extId`) of the snapshot to be fetched. 

        >>> response = api.get_mount_target_snapshot_by_ext_id(mountTargetExtId, snapshotExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mount_target_snapshot_by_ext_id_with_http_info(mountTargetExtId, snapshotExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str snapshotExtId: The extId of the snapshot. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.MountTargetSnapshotApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', 'snapshotExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mount_target_snapshot_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `get_mount_target_snapshot_by_ext_id`")  # noqa: E501
        # verify the required parameter 'snapshotExtId' is set
        if ('snapshotExtId' not in params or
                params['snapshotExtId'] is None):
            raise ValueError("Missing the required parameter `snapshotExtId` when calling `get_mount_target_snapshot_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501
        if 'snapshotExtId' in params:
            path_params['snapshotExtId'] = params['snapshotExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/snapshots/{snapshotExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.MountTargetSnapshotApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mount_target_snapshots(self, mountTargetExtId, **kwargs):  # noqa: E501
        """List mount target snapshots
        Get a paginated list of mount target snapshots.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported:   - name   - creator  A sample request URL would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$filter=name eq 'test' ```  Example of supported query parameters for mount target snapshots LIST API: ```   - ?$page=0&$limit=1   - ?$select=name, createTime, totalSpaceBytes   - ?$orderby=totalSpaceBytes asc   - ?$filter=creator eq Schema.Enums.SnapshotCreator'SSR_SNAPSHOT'   - ?$filter=startswith(name,'test')   - ?$filter=endswith(name,'test')   - ?$filter=contains(name,'test')   - ?$select=name, creator, totalSpaceBytes&$filter=startswith(name,'test')   - ?$limit=5&$select=name, totalSpaceBytes&$orderby=totalSpaceBytes asc&$filter=contains(name,'test')\\n ```  The `$orderby` query parameter allows specifying attributes on which to sort the returned list of snapshots.  The following parameters support sorting in snapshots API   - createTime   - name   - reclaimableSpaceBytes   - totalSpaceBytes   - creator  A sample call would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$orderby=totalSpaceBytes asc ```  The `$select` query parameter allows specifying attributes which the user wants to fetch in the returned list of snapshots, other attributes will be returned as a null value.  The following attributes can be selected: ```   - mountTargetExtId   - fileServerExtId   - name   - createTime   - totalSpaceBytes   - reclaimableSpaceBytes   - creator ```  Some more examples are given below:  1. Filter by name:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$filter=contains(name,'test') ```  2. Order by totalSpaceBytes in ascending order  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$orderby=totalSpaceBytes asc ```  3. Order by totalSpaceBytes in descending order  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$orderby=totalSpaceBytes desc ```  4. Select by name  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$select=name ```  5. Paginate the results  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$page=0&$limit=1 ```  6. Combination of queries  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots$limit=5&$select=name, totalSpaceBytes&$orderby=totalSpaceBytes asc&$filter=contains(name,'test') ``` 

        >>> response = api.get_mount_target_snapshots(mountTargetExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mount_target_snapshots(mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - creator
        - name
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - createTime
        - creator
        - name
        - reclaimableSpaceBytes
        - totalSpaceBytes
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- createTime
- creator
- extId
- fileServerExtId
- links
- mountTargetExtId
- name
- reclaimableSpaceBytes
- tenantId
- totalSpaceBytes

        :param bool async_req:
        :return: files.v4.config.MountTargetSnapshotListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mount_target_snapshots_with_http_info(mountTargetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mount_target_snapshots_with_http_info(mountTargetExtId, **kwargs)  # noqa: E501
            return data

    def get_mount_target_snapshots_with_http_info(self, mountTargetExtId, **kwargs):  # noqa: E501
        """List mount target snapshots
        Get a paginated list of mount target snapshots.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported:   - name   - creator  A sample request URL would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$filter=name eq 'test' ```  Example of supported query parameters for mount target snapshots LIST API: ```   - ?$page=0&$limit=1   - ?$select=name, createTime, totalSpaceBytes   - ?$orderby=totalSpaceBytes asc   - ?$filter=creator eq Schema.Enums.SnapshotCreator'SSR_SNAPSHOT'   - ?$filter=startswith(name,'test')   - ?$filter=endswith(name,'test')   - ?$filter=contains(name,'test')   - ?$select=name, creator, totalSpaceBytes&$filter=startswith(name,'test')   - ?$limit=5&$select=name, totalSpaceBytes&$orderby=totalSpaceBytes asc&$filter=contains(name,'test')\\n ```  The `$orderby` query parameter allows specifying attributes on which to sort the returned list of snapshots.  The following parameters support sorting in snapshots API   - createTime   - name   - reclaimableSpaceBytes   - totalSpaceBytes   - creator  A sample call would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$orderby=totalSpaceBytes asc ```  The `$select` query parameter allows specifying attributes which the user wants to fetch in the returned list of snapshots, other attributes will be returned as a null value.  The following attributes can be selected: ```   - mountTargetExtId   - fileServerExtId   - name   - createTime   - totalSpaceBytes   - reclaimableSpaceBytes   - creator ```  Some more examples are given below:  1. Filter by name:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$filter=contains(name,'test') ```  2. Order by totalSpaceBytes in ascending order  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$orderby=totalSpaceBytes asc ```  3. Order by totalSpaceBytes in descending order  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$orderby=totalSpaceBytes desc ```  4. Select by name  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$select=name ```  5. Paginate the results  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots?$page=0&$limit=1 ```  6. Combination of queries  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/snapshots$limit=5&$select=name, totalSpaceBytes&$orderby=totalSpaceBytes asc&$filter=contains(name,'test') ``` 

        >>> response = api.get_mount_target_snapshots(mountTargetExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mount_target_snapshots_with_http_info(mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - creator
        - name
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - createTime
        - creator
        - name
        - reclaimableSpaceBytes
        - totalSpaceBytes
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- createTime
- creator
- extId
- fileServerExtId
- links
- mountTargetExtId
- name
- reclaimableSpaceBytes
- tenantId
- totalSpaceBytes

        :param bool async_req:
        :return: files.v4.config.MountTargetSnapshotListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', '_page', '_limit', '_filter', '_orderby', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mount_target_snapshots" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `get_mount_target_snapshots`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/snapshots', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.MountTargetSnapshotListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
