# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class QuotaPoliciesApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_quota_policy(self, body, mountTargetExtId, **kwargs):  # noqa: E501
        """Create a quota policy
        Create a quota policy using the provided request body.  The user has to specify - a valid external identifier (extId) of the mount target for which quota policy needs to be created. They can specify `enforcementType`, `principalValue`, `principalType`, `enforcementType` as part of request body.  A sample request body would look like this: ``` {   \"enableNotifications\": true,   \"sizeInBytes\": 1073741800,   \"enforcementType\": \"SOFT\",   \"principalValue\": \"administrator\",   \"mountTargetExtId\": \"9c1e537d-6777-4c22-5d41-ddd0c3337aa9\",   \"principalType\": \"USER\",   \"notificationRecipients\": [     \"tempemail@test.com\"   ] } ``` 

        >>> response = api.create_quota_policy(body, mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_quota_policy(body, mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.QuotaPolicy body: Quota policy model. (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool async_req:
        :return: files.v4.config.CreateQuotaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_quota_policy_with_http_info(body, mountTargetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.create_quota_policy_with_http_info(body, mountTargetExtId, **kwargs)  # noqa: E501
            return data

    def create_quota_policy_with_http_info(self, body, mountTargetExtId, **kwargs):  # noqa: E501
        """Create a quota policy
        Create a quota policy using the provided request body.  The user has to specify - a valid external identifier (extId) of the mount target for which quota policy needs to be created. They can specify `enforcementType`, `principalValue`, `principalType`, `enforcementType` as part of request body.  A sample request body would look like this: ``` {   \"enableNotifications\": true,   \"sizeInBytes\": 1073741800,   \"enforcementType\": \"SOFT\",   \"principalValue\": \"administrator\",   \"mountTargetExtId\": \"9c1e537d-6777-4c22-5d41-ddd0c3337aa9\",   \"principalType\": \"USER\",   \"notificationRecipients\": [     \"tempemail@test.com\"   ] } ``` 

        >>> response = api.create_quota_policy(body, mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_quota_policy_with_http_info(body, mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.QuotaPolicy body: Quota policy model. (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool async_req:
        :return: files.v4.config.CreateQuotaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'mountTargetExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_quota_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_quota_policy`")  # noqa: E501
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `create_quota_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/quota-policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateQuotaPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_quota_policy(self, mountTargetExtId, quotaPolicyExtId, **kwargs):  # noqa: E501
        """Delete a quota policy
        Delete a quota policy with the provided extId.  The user has to specify - a valid external identifier (`extId`) of the of the mount target to which quota policy belongs to and a valid external identifier (`extId`) of the quota policy to be deleted.  How to pass Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies/48f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies/48f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.delete_quota_policy(mountTargetExtId, quotaPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_quota_policy(mountTargetExtId, quotaPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str quotaPolicyExtId: Quota policy UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteQuotaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_quota_policy_with_http_info(mountTargetExtId, quotaPolicyExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_quota_policy_with_http_info(mountTargetExtId, quotaPolicyExtId, **kwargs)  # noqa: E501
            return data

    def delete_quota_policy_with_http_info(self, mountTargetExtId, quotaPolicyExtId, **kwargs):  # noqa: E501
        """Delete a quota policy
        Delete a quota policy with the provided extId.  The user has to specify - a valid external identifier (`extId`) of the of the mount target to which quota policy belongs to and a valid external identifier (`extId`) of the quota policy to be deleted.  How to pass Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies/48f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies/48f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.delete_quota_policy(mountTargetExtId, quotaPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_quota_policy_with_http_info(mountTargetExtId, quotaPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str quotaPolicyExtId: Quota policy UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteQuotaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', 'quotaPolicyExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quota_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `delete_quota_policy`")  # noqa: E501
        # verify the required parameter 'quotaPolicyExtId' is set
        if ('quotaPolicyExtId' not in params or
                params['quotaPolicyExtId'] is None):
            raise ValueError("Missing the required parameter `quotaPolicyExtId` when calling `delete_quota_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501
        if 'quotaPolicyExtId' in params:
            path_params['quotaPolicyExtId'] = params['quotaPolicyExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/quota-policies/{quotaPolicyExtId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DeleteQuotaPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_quota_email_config(self, **kwargs):  # noqa: E501
        """Get the quota policy email configuration
        Get the quota policy email configuration. 

        >>> response = api.get_quota_email_config()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quota_email_config(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: files.v4.config.GetQuotaEmailConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_quota_email_config_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_quota_email_config_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_quota_email_config_with_http_info(self, **kwargs):  # noqa: E501
        """Get the quota policy email configuration
        Get the quota policy email configuration. 

        >>> response = api.get_quota_email_config()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quota_email_config_with_http_info(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: files.v4.config.GetQuotaEmailConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quota_email_config" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/quota-email-config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.GetQuotaEmailConfigApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_quota_policies(self, mountTargetExtId, **kwargs):  # noqa: E501
        """List all quota policies
        Get a paginated list of quota policies.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported: - enforcementType - principalValue - sizeInBytes  A sample call would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$filter=enforcementType eq Schema.Enums.EnforcementType'SOFT' ```  Example of supported query parameters for nested Quota policy LIST API: ```  - ?$page=0&$limit=1  - ?$select=principalType, principalValue, sizeInBytes  - ?$orderby=enforcementType desc  - ?$filter=enforcementType eq Schema.Enums.EnforcementType'SOFT'  - ?$limit=1&$select=principalType, sizeInBytes&$orderby=enforcementType desc&$filter=enforcementType eq Schema.Enums.EnforcementType'SOFT' ``` The following attributes can be selected: ``` - mountTargetExtId - principalValue - sizeInBytes - enableNotifications - isEnableNotifications ```  Some more examples are given below: 1. Order by enforcementType in ascending order  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$orderby=enforcementType asc ```  2. Order by enforcementType in descending order  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$orderby=enforcementType desc ```  3. Select by principalType  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$select=principalType ```  4. Select by principalValue  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$select=principalValue ```  5. Paginate the returned policies list  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$page=0&$limit=1 ```  6. Combination of queries  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$limit=1&$select=principalType, sizeInBytes&$orderby=enforcementType desc&$filter=enforcementType eq Schema.Enums.EnforcementType'SOFT' ``` 

        >>> response = api.get_quota_policies(mountTargetExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quota_policies(mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - enforcementType
        - principalValue
        - sizeInBytes
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - enforcementType
        - principalValue
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- enableNotifications
- enforcementType
- extId
- isEnableNotifications
- links
- mountTargetExtId
- notificationRecipients
- principalType
- principalValue
- sizeInBytes
- tenantId

        :param bool async_req:
        :return: files.v4.config.QuotaPolicyListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_quota_policies_with_http_info(mountTargetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_quota_policies_with_http_info(mountTargetExtId, **kwargs)  # noqa: E501
            return data

    def get_quota_policies_with_http_info(self, mountTargetExtId, **kwargs):  # noqa: E501
        """List all quota policies
        Get a paginated list of quota policies.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported: - enforcementType - principalValue - sizeInBytes  A sample call would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$filter=enforcementType eq Schema.Enums.EnforcementType'SOFT' ```  Example of supported query parameters for nested Quota policy LIST API: ```  - ?$page=0&$limit=1  - ?$select=principalType, principalValue, sizeInBytes  - ?$orderby=enforcementType desc  - ?$filter=enforcementType eq Schema.Enums.EnforcementType'SOFT'  - ?$limit=1&$select=principalType, sizeInBytes&$orderby=enforcementType desc&$filter=enforcementType eq Schema.Enums.EnforcementType'SOFT' ``` The following attributes can be selected: ``` - mountTargetExtId - principalValue - sizeInBytes - enableNotifications - isEnableNotifications ```  Some more examples are given below: 1. Order by enforcementType in ascending order  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$orderby=enforcementType asc ```  2. Order by enforcementType in descending order  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$orderby=enforcementType desc ```  3. Select by principalType  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$select=principalType ```  4. Select by principalValue  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$select=principalValue ```  5. Paginate the returned policies list  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$page=0&$limit=1 ```  6. Combination of queries  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies?$limit=1&$select=principalType, sizeInBytes&$orderby=enforcementType desc&$filter=enforcementType eq Schema.Enums.EnforcementType'SOFT' ``` 

        >>> response = api.get_quota_policies(mountTargetExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quota_policies_with_http_info(mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - enforcementType
        - principalValue
        - sizeInBytes
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - enforcementType
        - principalValue
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- enableNotifications
- enforcementType
- extId
- isEnableNotifications
- links
- mountTargetExtId
- notificationRecipients
- principalType
- principalValue
- sizeInBytes
- tenantId

        :param bool async_req:
        :return: files.v4.config.QuotaPolicyListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', '_page', '_limit', '_filter', '_orderby', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quota_policies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `get_quota_policies`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/quota-policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.QuotaPolicyListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_quota_policy_by_ext_id(self, mountTargetExtId, quotaPolicyExtId, **kwargs):  # noqa: E501
        """Get a quota policy by extId
        Get a quota policy with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the of the mount target to which quota policy belongs to and a valid external identifier (`extId`) of the quota policy to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_quota_policy_by_ext_id(mountTargetExtId, quotaPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quota_policy_by_ext_id(mountTargetExtId, quotaPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str quotaPolicyExtId: Quota policy UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.QuotaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_quota_policy_by_ext_id_with_http_info(mountTargetExtId, quotaPolicyExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_quota_policy_by_ext_id_with_http_info(mountTargetExtId, quotaPolicyExtId, **kwargs)  # noqa: E501
            return data

    def get_quota_policy_by_ext_id_with_http_info(self, mountTargetExtId, quotaPolicyExtId, **kwargs):  # noqa: E501
        """Get a quota policy by extId
        Get a quota policy with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the of the mount target to which quota policy belongs to and a valid external identifier (`extId`) of the quota policy to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_quota_policy_by_ext_id(mountTargetExtId, quotaPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quota_policy_by_ext_id_with_http_info(mountTargetExtId, quotaPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str quotaPolicyExtId: Quota policy UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.QuotaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', 'quotaPolicyExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quota_policy_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `get_quota_policy_by_ext_id`")  # noqa: E501
        # verify the required parameter 'quotaPolicyExtId' is set
        if ('quotaPolicyExtId' not in params or
                params['quotaPolicyExtId'] is None):
            raise ValueError("Missing the required parameter `quotaPolicyExtId` when calling `get_quota_policy_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501
        if 'quotaPolicyExtId' in params:
            path_params['quotaPolicyExtId'] = params['quotaPolicyExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/quota-policies/{quotaPolicyExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.QuotaPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_quota_email_config(self, body, **kwargs):  # noqa: E501
        """Update the quota policy email configuration
        Update the quota policy email configuration.  The user has to specify (`content`) and (`subject`) to update the quota policy email configuration.  A sample request body would look like this: ``` {   \"content\": \"Updated email content\",   \"subject\": \"Updated email subject\" } ``` 

        >>> response = api.update_quota_email_config(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_quota_email_config(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.QuotaEmailConfig body: Quota policy email configuration model (required)
        :param bool async_req:
        :return: files.v4.config.UpdateQuotaEmailConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_quota_email_config_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_quota_email_config_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def update_quota_email_config_with_http_info(self, body, **kwargs):  # noqa: E501
        """Update the quota policy email configuration
        Update the quota policy email configuration.  The user has to specify (`content`) and (`subject`) to update the quota policy email configuration.  A sample request body would look like this: ``` {   \"content\": \"Updated email content\",   \"subject\": \"Updated email subject\" } ``` 

        >>> response = api.update_quota_email_config(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_quota_email_config_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.QuotaEmailConfig body: Quota policy email configuration model (required)
        :param bool async_req:
        :return: files.v4.config.UpdateQuotaEmailConfigApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_quota_email_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_quota_email_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/quota-email-config', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateQuotaEmailConfigApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_quota_policy(self, body, mountTargetExtId, quotaPolicyExtId, **kwargs):  # noqa: E501
        """Update a quota policy.
        Update quota policy.  The user has to specify - a valid external identifier (`extId`) of the of the mount target to which quota policy belongs to and a valid external identifier (`extId`) of the quota policy to be updated. They also need to provide a request body for performing the update. They can provide parameters like `enableNotifications`, `sizeInBytes`, `enforcementType`.  A sample request body would look like this: ``` {   \"enableNotifications\": false,   \"sizeInBytes\": 1073741800,   \"enforcementType\": \"SOFT\",   \"principalValue\": \"administrator\",   \"mountTargetExtId\": \"9c1e537d-6777-4c22-5d41-ddd0c3337aa9\",   \"principalType\": \"USER\" } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies/48f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies/48f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_quota_policy(body, mountTargetExtId, quotaPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_quota_policy(body, mountTargetExtId, quotaPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.QuotaPolicy body: Quota policy model. (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str quotaPolicyExtId: Quota policy UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateQuotaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_quota_policy_with_http_info(body, mountTargetExtId, quotaPolicyExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_quota_policy_with_http_info(body, mountTargetExtId, quotaPolicyExtId, **kwargs)  # noqa: E501
            return data

    def update_quota_policy_with_http_info(self, body, mountTargetExtId, quotaPolicyExtId, **kwargs):  # noqa: E501
        """Update a quota policy.
        Update quota policy.  The user has to specify - a valid external identifier (`extId`) of the of the mount target to which quota policy belongs to and a valid external identifier (`extId`) of the quota policy to be updated. They also need to provide a request body for performing the update. They can provide parameters like `enableNotifications`, `sizeInBytes`, `enforcementType`.  A sample request body would look like this: ``` {   \"enableNotifications\": false,   \"sizeInBytes\": 1073741800,   \"enforcementType\": \"SOFT\",   \"principalValue\": \"administrator\",   \"mountTargetExtId\": \"9c1e537d-6777-4c22-5d41-ddd0c3337aa9\",   \"principalType\": \"USER\" } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies/48f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9/quota-policies/48f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_quota_policy(body, mountTargetExtId, quotaPolicyExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_quota_policy_with_http_info(body, mountTargetExtId, quotaPolicyExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.QuotaPolicy body: Quota policy model. (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param str quotaPolicyExtId: Quota policy UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateQuotaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'mountTargetExtId', 'quotaPolicyExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_quota_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_quota_policy`")  # noqa: E501
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `update_quota_policy`")  # noqa: E501
        # verify the required parameter 'quotaPolicyExtId' is set
        if ('quotaPolicyExtId' not in params or
                params['quotaPolicyExtId'] is None):
            raise ValueError("Missing the required parameter `quotaPolicyExtId` when calling `update_quota_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501
        if 'quotaPolicyExtId' in params:
            path_params['quotaPolicyExtId'] = params['quotaPolicyExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/quota-policies/{quotaPolicyExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateQuotaPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
