# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class NetworksApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_network(self, body, **kwargs):  # noqa: E501
        """Create a network
        Creates a new network using the provided request body.  The users need to specify only the `networkExtId` of the nvm network, for the managed network. For the unmanaged networks user can provide `defaultGateway`, `ipAddresses`, `virtualIpAddress`, `subnetMask`, `vlanId`.  A sample request body would look like this: ``` {   \"defaultGateway\": {     \"ipv4\": {       \"value\": \"10.53.80.1\"     }   },   \"ipAddresses\": {     \"ipv4\": {       \"value\": \"10.53.73.42\"     }   },   \"virtualIpAddress\": {     \"ipv4\": {       \"value\": \"\"     }   },   \"subnetMask\": {     \"ipv4\": {       \"value\": \"255.255.240.0\"     }   },   \"networkExtId\": \"8064cae7-13c6-4cc9-be63-021dec2448ac\",   \"vlanId\": 0,   \"extId\": \"bb64cae7-13c6-4cc9-be63-021dec2448bb\" } ``` 

        >>> response = api.create_network(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_network(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.Network body: A model that represents the file server network resources. (required)
        :param bool async_req:
        :return: files.v4.config.CreateNetworkApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_network_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_network_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_network_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a network
        Creates a new network using the provided request body.  The users need to specify only the `networkExtId` of the nvm network, for the managed network. For the unmanaged networks user can provide `defaultGateway`, `ipAddresses`, `virtualIpAddress`, `subnetMask`, `vlanId`.  A sample request body would look like this: ``` {   \"defaultGateway\": {     \"ipv4\": {       \"value\": \"10.53.80.1\"     }   },   \"ipAddresses\": {     \"ipv4\": {       \"value\": \"10.53.73.42\"     }   },   \"virtualIpAddress\": {     \"ipv4\": {       \"value\": \"\"     }   },   \"subnetMask\": {     \"ipv4\": {       \"value\": \"255.255.240.0\"     }   },   \"networkExtId\": \"8064cae7-13c6-4cc9-be63-021dec2448ac\",   \"vlanId\": 0,   \"extId\": \"bb64cae7-13c6-4cc9-be63-021dec2448bb\" } ``` 

        >>> response = api.create_network(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_network_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.Network body: A model that represents the file server network resources. (required)
        :param bool async_req:
        :return: files.v4.config.CreateNetworkApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_network" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_network`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/networks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateNetworkApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_network(self, extId, **kwargs):  # noqa: E501
        """Delete a network
        Delete the file server network with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the network to be deleted. 

        >>> response = api.delete_network(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_network(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The extId of the file server network. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteNetworkApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_network_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_network_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def delete_network_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Delete a network
        Delete the file server network with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the network to be deleted. 

        >>> response = api.delete_network(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_network_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The extId of the file server network. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteNetworkApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_network" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_network`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/networks/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DeleteNetworkApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_by_ext_id(self, extId, **kwargs):  # noqa: E501
        """Get network by extId
        Get the file server network with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the network to be fetched. 

        >>> response = api.get_network_by_ext_id(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_network_by_ext_id(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The extId of the file server network. (required)
        :param bool async_req:
        :return: files.v4.config.NetworkGetByExtIdApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_by_ext_id_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_network_by_ext_id_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_network_by_ext_id_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get network by extId
        Get the file server network with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the network to be fetched. 

        >>> response = api.get_network_by_ext_id(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_network_by_ext_id_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The extId of the file server network. (required)
        :param bool async_req:
        :return: files.v4.config.NetworkGetByExtIdApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_network_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/networks/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.NetworkGetByExtIdApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_networks(self, **kwargs):  # noqa: E501
        """Get networks
        Get a paginated list of file server external networks.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported: - networkExtId - vlanId - virtualIpAddress - virtualNetworkName - subnetMask - defaultGateway - ipv6PrefixLength - isManaged  A sample call would look like this: ``` /api/files/v4.0.a2/config/file-server/networks?$filter=vlanId gt 10 ``` Example of supported query parameters for the file server network list API: ```  - ?$page=0&$limit=1  - ?$select=vlanId  - ?$filter=vlanId gt 10  - ?$orderby=virtualNetworkName desc  - ?$limit=5&$select=vlanId  - ?$limit=5&$select=virtualNetworkName &$orderby=virtualNetworkName desc ``` The `$orderby` query parameter allows specifying attributes on which to sort the returned list of networks  The following parameters support sorting in the file server network list:   - virtualNetworkName   - isManaged   - vlanId  A sample call would look like this: ``` /api/files/v4.0.a2/config/file-server/network?$orderby=virtualNetworkName desc ```  The `$select` query parameter allows specifying attributes which the user wants to fetch in the returned list of networks, other attributes will be returned as a null value.  The following attributes can be selected: - virtualNetworkName - isManaged - vlanId  Some more examples are given below: 1. Filter by virtualNetworkName: ``` /api/files/v4.0.a2/config/file-server/network?$filter=contains(virtualNetworkName, 'something')   OR /api/files/v4.0.a2/config/file-server/network?$filter=virtualNetworkName eq 'something' ```  2. Order by virtualNetworkName in ascending order ``` /api/files/v4.0.a2/config/file-server/network?$orderby=virtualNetworkName asc ```  3. Order by virtualNetworkName in descending order ``` /api/files/v4.0.a2/config/file-server/network?$orderby=virtualNetworkName desc ``` 4. Select by virtualNetworkName ``` /api/files/v4.0.a2/config/file-server/network?$select=virtualNetworkName ``` 5. Paginate the returned network list ``` /api/files/v4.0.a2/config/file-server/network?$page=0&$limit=1 ``` 7. Combination of queries ```   /api/files/v4.0.a2/config/file-server/network?$limit=5&$select=virtualNetworkName, vlanId &$orderby=virtualNetworkName desc ```  If the user doesn't specify any search query parameters, a list of all external networks will be returned. 

        >>> response = api.get_networks((optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_networks(async_req=True)
        >>> result = thread.get()

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - isManaged
        - virtualNetworkName
        - vlanId
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - isManaged
        - virtualNetworkName
        - vlanId
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- defaultGateway/ipv4/prefixLength
- defaultGateway/ipv4/value
- defaultGateway/ipv6/prefixLength
- defaultGateway/ipv6/value
- extId
- ipAddresses
- ipv6PrefixLength
- isManaged
- links
- networkExtId
- subnetMask/ipv4/prefixLength
- subnetMask/ipv4/value
- subnetMask/ipv6/prefixLength
- subnetMask/ipv6/value
- tenantId
- virtualIpAddress/ipv4/prefixLength
- virtualIpAddress/ipv4/value
- virtualIpAddress/ipv6/prefixLength
- virtualIpAddress/ipv6/value
- virtualNetworkName
- vlanId

        :param bool async_req:
        :return: files.v4.config.NetworkListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_networks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_networks_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_networks_with_http_info(self, **kwargs):  # noqa: E501
        """Get networks
        Get a paginated list of file server external networks.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported: - networkExtId - vlanId - virtualIpAddress - virtualNetworkName - subnetMask - defaultGateway - ipv6PrefixLength - isManaged  A sample call would look like this: ``` /api/files/v4.0.a2/config/file-server/networks?$filter=vlanId gt 10 ``` Example of supported query parameters for the file server network list API: ```  - ?$page=0&$limit=1  - ?$select=vlanId  - ?$filter=vlanId gt 10  - ?$orderby=virtualNetworkName desc  - ?$limit=5&$select=vlanId  - ?$limit=5&$select=virtualNetworkName &$orderby=virtualNetworkName desc ``` The `$orderby` query parameter allows specifying attributes on which to sort the returned list of networks  The following parameters support sorting in the file server network list:   - virtualNetworkName   - isManaged   - vlanId  A sample call would look like this: ``` /api/files/v4.0.a2/config/file-server/network?$orderby=virtualNetworkName desc ```  The `$select` query parameter allows specifying attributes which the user wants to fetch in the returned list of networks, other attributes will be returned as a null value.  The following attributes can be selected: - virtualNetworkName - isManaged - vlanId  Some more examples are given below: 1. Filter by virtualNetworkName: ``` /api/files/v4.0.a2/config/file-server/network?$filter=contains(virtualNetworkName, 'something')   OR /api/files/v4.0.a2/config/file-server/network?$filter=virtualNetworkName eq 'something' ```  2. Order by virtualNetworkName in ascending order ``` /api/files/v4.0.a2/config/file-server/network?$orderby=virtualNetworkName asc ```  3. Order by virtualNetworkName in descending order ``` /api/files/v4.0.a2/config/file-server/network?$orderby=virtualNetworkName desc ``` 4. Select by virtualNetworkName ``` /api/files/v4.0.a2/config/file-server/network?$select=virtualNetworkName ``` 5. Paginate the returned network list ``` /api/files/v4.0.a2/config/file-server/network?$page=0&$limit=1 ``` 7. Combination of queries ```   /api/files/v4.0.a2/config/file-server/network?$limit=5&$select=virtualNetworkName, vlanId &$orderby=virtualNetworkName desc ```  If the user doesn't specify any search query parameters, a list of all external networks will be returned. 

        >>> response = api.get_networks((optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_networks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - isManaged
        - virtualNetworkName
        - vlanId
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - isManaged
        - virtualNetworkName
        - vlanId
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- defaultGateway/ipv4/prefixLength
- defaultGateway/ipv4/value
- defaultGateway/ipv6/prefixLength
- defaultGateway/ipv6/value
- extId
- ipAddresses
- ipv6PrefixLength
- isManaged
- links
- networkExtId
- subnetMask/ipv4/prefixLength
- subnetMask/ipv4/value
- subnetMask/ipv6/prefixLength
- subnetMask/ipv6/value
- tenantId
- virtualIpAddress/ipv4/prefixLength
- virtualIpAddress/ipv4/value
- virtualIpAddress/ipv6/prefixLength
- virtualIpAddress/ipv6/value
- virtualNetworkName
- vlanId

        :param bool async_req:
        :return: files.v4.config.NetworkListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_filter', '_orderby', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_networks" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/networks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.NetworkListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
