# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class MountTargetsApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_mount_targets(self, body, **kwargs):  # noqa: E501
        """Create a mount target
        Create a mount target using the provided request body.  The user has to specify `name` and  `type` of the mount target which needs to be created. User can also specify `maxSizeGib`, `path`, `secondaryProtocol`, `state` etc of the mount target.  A sample request body would look like this: ``` {   \"protocol\": \"NFS\",   \"name\": \"sharetest\",   \"maxSizeGib\": 1,   \"extId\": \"2f2193f0-0c9e-4be4-571a-949694761ff3\",   \"enableCompression\": true,   \"secondaryProtocol\": [     \"NONE\"   ],   \"nfsProperties\": {     \"authenticationType\": \"SYSTEM\",     \"clientAccessType\": {       \"defaultAccessType\": \"READ_WRITE\"     }   },   \"type\": \"GENERAL\",   \"description\": \"share\" } ``` 

        >>> response = api.create_mount_targets(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_mount_targets(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.MountTarget body: Mount target model (required)
        :param bool async_req:
        :return: files.v4.config.CreateMountTargetApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_mount_targets_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_mount_targets_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_mount_targets_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a mount target
        Create a mount target using the provided request body.  The user has to specify `name` and  `type` of the mount target which needs to be created. User can also specify `maxSizeGib`, `path`, `secondaryProtocol`, `state` etc of the mount target.  A sample request body would look like this: ``` {   \"protocol\": \"NFS\",   \"name\": \"sharetest\",   \"maxSizeGib\": 1,   \"extId\": \"2f2193f0-0c9e-4be4-571a-949694761ff3\",   \"enableCompression\": true,   \"secondaryProtocol\": [     \"NONE\"   ],   \"nfsProperties\": {     \"authenticationType\": \"SYSTEM\",     \"clientAccessType\": {       \"defaultAccessType\": \"READ_WRITE\"     }   },   \"type\": \"GENERAL\",   \"description\": \"share\" } ``` 

        >>> response = api.create_mount_targets(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_mount_targets_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.MountTarget body: Mount target model (required)
        :param bool async_req:
        :return: files.v4.config.CreateMountTargetApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_mount_targets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_mount_targets`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateMountTargetApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_mount_target_by_id(self, mountTargetExtId, **kwargs):  # noqa: E501
        """Delete a mount target
        Delete a mount target with the given external identifier.  The user has to specify - a valid external identifier (`mountTargetExtId`) of the mount target to be deleted. User can also specify `force` flag to delete mount target forcefully.  How to use Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9 ````  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.delete_mount_target_by_id(mountTargetExtId, (optional) force)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mount_target_by_id(mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool force: Force flag to delete the mount target. If set to true, mount target will be deleted even if there are users accessing data from it right now.
        :param bool async_req:
        :return: files.v4.config.DeleteMountTargetApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_mount_target_by_id_with_http_info(mountTargetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_mount_target_by_id_with_http_info(mountTargetExtId, **kwargs)  # noqa: E501
            return data

    def delete_mount_target_by_id_with_http_info(self, mountTargetExtId, **kwargs):  # noqa: E501
        """Delete a mount target
        Delete a mount target with the given external identifier.  The user has to specify - a valid external identifier (`mountTargetExtId`) of the mount target to be deleted. User can also specify `force` flag to delete mount target forcefully.  How to use Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9 ````  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.delete_mount_target_by_id(mountTargetExtId, (optional) force)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_mount_target_by_id_with_http_info(mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool force: Force flag to delete the mount target. If set to true, mount target will be deleted even if there are users accessing data from it right now.
        :param bool async_req:
        :return: files.v4.config.DeleteMountTargetApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mount_target_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `delete_mount_target_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DeleteMountTargetApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_mount_targets(self, **kwargs):  # noqa: E501
        """List all mount targets
        Get a paginated list of mount targets.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported:   - name   - type  A sample request URL would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$filter=type eq Schema.Enums.MountTargetType'DISTRIBUTED' ```  Example of supported query parameters for mount targets LIST API: ```   - ?$page=0&$limit=1   - ?$select=name, description   - ?$orderby=name desc   - ?$filter=type eq Schema.Enums.MountTargetType'DISTRIBUTED'   - ?$filter=startswith(name,'test')   - ?$filter=endswith(name,'test')   - ?$filter=contains(name,'nested')   - ?$select=name, description, path&$filter=startswith(name,'test')   - ?$limit=5&$select=name, description, path&$orderby=name desc ```  The `$orderby` query parameter allows specifying attributes on which to sort the returned list of mount targets.  The following parameters support sorting in mount target list API:   - enableCompression   - isEnableCompression   - name   - path   - protocol   - type  A sample request URL would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$orderby=name desc ```  The $select query parameter allows specifying attributes which the user wants to fetch in the returned list of mount targets, other attributes will be returned as  a null value.  The following attributes can be selected: ```   - name   - description   - fileServerExtId   - maxSizeGib   - path   - parentMountTargetExtId   - enableCompression   - isEnableCompression   - enablePreviousVersion   - isEnablePreviousVersion   - longnameEnabled   - isLongnameEnabled ```  Some more examples are given below:  1. Order by name in ascending order  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$orderby=name asc ```  2. Select by name  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$select=name ```  3. Paginate the returned list  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$page=0&$limit=1 ```  4. Combination of queries  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$limit=5&$select=name, description, path&$orderby=name desc ``` 

        >>> response = api.get_all_mount_targets((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_mount_targets(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - name
        - type
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - enableCompression
        - isEnableCompression
        - name
        - path
        - protocol
        - type
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- blockedClients
- description
- enableCompression
- enablePreviousVersion
- extId
- fileBlockingExtensions
- fileServerExtId
- isEnableCompression
- isEnablePreviousVersion
- isLongnameEnabled
- links
- longnameEnabled
- maxSizeGib
- multiProtocolProperties
- name
- nfsProperties
- parentMountTargetExtId
- path
- protocol
- secondaryProtocol
- smbProperties/enableAccessBasedEnumeration
- smbProperties/enableCa
- smbProperties/enableSmb3Encryption
- smbProperties/isEnableAccessBasedEnumeration
- smbProperties/isEnableCa
- smbProperties/isEnableSmb3Encryption
- state
- statusType
- tenantId
- type
- workloadType
- wormSpec

        :param bool async_req:
        :return: files.v4.config.MountTargetListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_mount_targets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_mount_targets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_mount_targets_with_http_info(self, **kwargs):  # noqa: E501
        """List all mount targets
        Get a paginated list of mount targets.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported:   - name   - type  A sample request URL would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$filter=type eq Schema.Enums.MountTargetType'DISTRIBUTED' ```  Example of supported query parameters for mount targets LIST API: ```   - ?$page=0&$limit=1   - ?$select=name, description   - ?$orderby=name desc   - ?$filter=type eq Schema.Enums.MountTargetType'DISTRIBUTED'   - ?$filter=startswith(name,'test')   - ?$filter=endswith(name,'test')   - ?$filter=contains(name,'nested')   - ?$select=name, description, path&$filter=startswith(name,'test')   - ?$limit=5&$select=name, description, path&$orderby=name desc ```  The `$orderby` query parameter allows specifying attributes on which to sort the returned list of mount targets.  The following parameters support sorting in mount target list API:   - enableCompression   - isEnableCompression   - name   - path   - protocol   - type  A sample request URL would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$orderby=name desc ```  The $select query parameter allows specifying attributes which the user wants to fetch in the returned list of mount targets, other attributes will be returned as  a null value.  The following attributes can be selected: ```   - name   - description   - fileServerExtId   - maxSizeGib   - path   - parentMountTargetExtId   - enableCompression   - isEnableCompression   - enablePreviousVersion   - isEnablePreviousVersion   - longnameEnabled   - isLongnameEnabled ```  Some more examples are given below:  1. Order by name in ascending order  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$orderby=name asc ```  2. Select by name  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$select=name ```  3. Paginate the returned list  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$page=0&$limit=1 ```  4. Combination of queries  ``` /api/files/v4.0.a2/config/file-server/mount-targets?$limit=5&$select=name, description, path&$orderby=name desc ``` 

        >>> response = api.get_all_mount_targets((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_mount_targets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - name
        - type
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - enableCompression
        - isEnableCompression
        - name
        - path
        - protocol
        - type
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- blockedClients
- description
- enableCompression
- enablePreviousVersion
- extId
- fileBlockingExtensions
- fileServerExtId
- isEnableCompression
- isEnablePreviousVersion
- isLongnameEnabled
- links
- longnameEnabled
- maxSizeGib
- multiProtocolProperties
- name
- nfsProperties
- parentMountTargetExtId
- path
- protocol
- secondaryProtocol
- smbProperties/enableAccessBasedEnumeration
- smbProperties/enableCa
- smbProperties/enableSmb3Encryption
- smbProperties/isEnableAccessBasedEnumeration
- smbProperties/isEnableCa
- smbProperties/isEnableSmb3Encryption
- state
- statusType
- tenantId
- type
- workloadType
- wormSpec

        :param bool async_req:
        :return: files.v4.config.MountTargetListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_mount_targets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.MountTargetListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_by_inode_gen_id(self, mountTargetExtId, inodeGenIdList, **kwargs):  # noqa: E501
        """Get the mimetype of files for the given inode genId pair.
        Query the mimetypes of files of mount target with given external identifier, Inode and genId.  The user has to specify - a valid external identifier (`mountTargetExtId`) of mount target for which mimetypes of files need to be fetched and a list of Inode and genId pairs (`inodeGenIdList`) in the path parameter. 

        >>> response = api.get_file_by_inode_gen_id(mountTargetExtId, inodeGenIdList)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_by_inode_gen_id(mountTargetExtId, inodeGenIdList, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param list[str] inodeGenIdList: List of Inode and genId pairs in the format inode:genId. (required)
        :param bool async_req:
        :return: files.v4.config.MimeTypeResponseApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_by_inode_gen_id_with_http_info(mountTargetExtId, inodeGenIdList, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_by_inode_gen_id_with_http_info(mountTargetExtId, inodeGenIdList, **kwargs)  # noqa: E501
            return data

    def get_file_by_inode_gen_id_with_http_info(self, mountTargetExtId, inodeGenIdList, **kwargs):  # noqa: E501
        """Get the mimetype of files for the given inode genId pair.
        Query the mimetypes of files of mount target with given external identifier, Inode and genId.  The user has to specify - a valid external identifier (`mountTargetExtId`) of mount target for which mimetypes of files need to be fetched and a list of Inode and genId pairs (`inodeGenIdList`) in the path parameter. 

        >>> response = api.get_file_by_inode_gen_id(mountTargetExtId, inodeGenIdList)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_by_inode_gen_id_with_http_info(mountTargetExtId, inodeGenIdList, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param list[str] inodeGenIdList: List of Inode and genId pairs in the format inode:genId. (required)
        :param bool async_req:
        :return: files.v4.config.MimeTypeResponseApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', 'inodeGenIdList']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_by_inode_gen_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `get_file_by_inode_gen_id`")  # noqa: E501
        # verify the required parameter 'inodeGenIdList' is set
        if ('inodeGenIdList' not in params or
                params['inodeGenIdList'] is None):
            raise ValueError("Missing the required parameter `inodeGenIdList` when calling `get_file_by_inode_gen_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501

        query_params = []
        if 'inodeGenIdList' in params:
            query_params.append(('inodeGenIdList', params['inodeGenIdList']))  # noqa: E501
            collection_formats['inodeGenIdList'] = 'csv'  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.MimeTypeResponseApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mount_target_by_uuid(self, mountTargetExtId, **kwargs):  # noqa: E501
        """Get a mount target by extId
        Get the mount target with the given external identifier.  The user has to specify - a valid external identifier (`mountTargetExtId`) of the mount target to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_mount_target_by_uuid(mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mount_target_by_uuid(mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool async_req:
        :return: files.v4.config.MountTargetApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mount_target_by_uuid_with_http_info(mountTargetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mount_target_by_uuid_with_http_info(mountTargetExtId, **kwargs)  # noqa: E501
            return data

    def get_mount_target_by_uuid_with_http_info(self, mountTargetExtId, **kwargs):  # noqa: E501
        """Get a mount target by extId
        Get the mount target with the given external identifier.  The user has to specify - a valid external identifier (`mountTargetExtId`) of the mount target to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_mount_target_by_uuid(mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_mount_target_by_uuid_with_http_info(mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool async_req:
        :return: files.v4.config.MountTargetApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mount_target_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `get_mount_target_by_uuid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.MountTargetApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_mount_targets(self, body, mountTargetExtId, **kwargs):  # noqa: E501
        """Update a mount target
        Update a mount target with the given external identifier using the provided request body.  The user has to specify - a valid external identifier (`mountTargetExtId`) of the mount target to be updated. They also need to provide a request body for performing the update.  A sample request body would look like this:  ``` {   \"protocol\": \"NFS\",   \"name\": \"sharetest\",   \"maxSizeGib\": 1,   \"extId\": \"9c1e537d-6777-4c22-5d41-ddd0c3337aa9\",   \"enableCompression\": true,   \"secondaryProtocol\": [     \"NONE\"   ],   \"nfsProperties\": {     \"authenticationType\": \"SYSTEM\",     \"clientAccessType\": {       \"defaultAccessType\": \"READ_WRITE\"     }   },   \"type\": \"GENERAL\",   \"description\": \"share\" } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to use Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9 ````  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_mount_targets(body, mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_mount_targets(body, mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.MountTarget body: Mount target model (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateMountTargetApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_mount_targets_with_http_info(body, mountTargetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_mount_targets_with_http_info(body, mountTargetExtId, **kwargs)  # noqa: E501
            return data

    def update_mount_targets_with_http_info(self, body, mountTargetExtId, **kwargs):  # noqa: E501
        """Update a mount target
        Update a mount target with the given external identifier using the provided request body.  The user has to specify - a valid external identifier (`mountTargetExtId`) of the mount target to be updated. They also need to provide a request body for performing the update.  A sample request body would look like this:  ``` {   \"protocol\": \"NFS\",   \"name\": \"sharetest\",   \"maxSizeGib\": 1,   \"extId\": \"9c1e537d-6777-4c22-5d41-ddd0c3337aa9\",   \"enableCompression\": true,   \"secondaryProtocol\": [     \"NONE\"   ],   \"nfsProperties\": {     \"authenticationType\": \"SYSTEM\",     \"clientAccessType\": {       \"defaultAccessType\": \"READ_WRITE\"     }   },   \"type\": \"GENERAL\",   \"description\": \"share\" } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to use Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9 ````  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/mount-targets/9c1e537d-6777-4c22-5d41-ddd0c3337aa9 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_mount_targets(body, mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_mount_targets_with_http_info(body, mountTargetExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.MountTarget body: Mount target model (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateMountTargetApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'mountTargetExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_mount_targets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_mount_targets`")  # noqa: E501
        # verify the required parameter 'mountTargetExtId' is set
        if ('mountTargetExtId' not in params or
                params['mountTargetExtId'] is None):
            raise ValueError("Missing the required parameter `mountTargetExtId` when calling `update_mount_targets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mountTargetExtId' in params:
            path_params['mountTargetExtId'] = params['mountTargetExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/mount-targets/{mountTargetExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateMountTargetApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
