# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class InfectedFilesApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_infected_file_by_ext_id(self, infectedFileExtId, **kwargs):  # noqa: E501
        """Get infected file by extId
        Get infected files with the given external identifier.  The user has to specify - a valid external identifier (`infectedFileExtId`) of the infected file to be fetched. The user can also specify inside a path parameter - a valid external identifier(`mountTargetExtId`) to which the file belongs. 

        >>> response = api.get_infected_file_by_ext_id(infectedFileExtId, (optional) mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_infected_file_by_ext_id(infectedFileExtId, async_req=True)
        >>> result = thread.get()

        :param str infectedFileExtId: The extId of the infected file. (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9.
        :param bool async_req:
        :return: files.v4.config.InfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_infected_file_by_ext_id_with_http_info(infectedFileExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_infected_file_by_ext_id_with_http_info(infectedFileExtId, **kwargs)  # noqa: E501
            return data

    def get_infected_file_by_ext_id_with_http_info(self, infectedFileExtId, **kwargs):  # noqa: E501
        """Get infected file by extId
        Get infected files with the given external identifier.  The user has to specify - a valid external identifier (`infectedFileExtId`) of the infected file to be fetched. The user can also specify inside a path parameter - a valid external identifier(`mountTargetExtId`) to which the file belongs. 

        >>> response = api.get_infected_file_by_ext_id(infectedFileExtId, (optional) mountTargetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_infected_file_by_ext_id_with_http_info(infectedFileExtId, async_req=True)
        >>> result = thread.get()

        :param str infectedFileExtId: The extId of the infected file. (required)
        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9.
        :param bool async_req:
        :return: files.v4.config.InfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infectedFileExtId', 'mountTargetExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_infected_file_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infectedFileExtId' is set
        if ('infectedFileExtId' not in params or
                params['infectedFileExtId'] is None):
            raise ValueError("Missing the required parameter `infectedFileExtId` when calling `get_infected_file_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infectedFileExtId' in params:
            path_params['infectedFileExtId'] = params['infectedFileExtId']  # noqa: E501

        query_params = []
        if 'mountTargetExtId' in params:
            query_params.append(('mountTargetExtId', params['mountTargetExtId']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/infected-files/{infectedFileExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.InfectedFilesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_infected_files(self, **kwargs):  # noqa: E501
        """List of infected files
        Get a paginated list of infected files.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter).   Example of supported query parameters for infected files LIST API: ```  - ?$page=0&$limit=1  - ?$select=shareName, filePath, threatDescription  - ?$limit=5&$select=shareName, filePath ``` The following attributes can be selected: ```   - mountTargetExtId   - shareName   - filePath   - threatDescription   - scanTimestampUsecs   - quarantined   - icapServer ``` \" 

        >>> response = api.list_infected_files((optional) mountTargetExtId, (optional) _page, (optional) _limit, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_infected_files(async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9.
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- extId
- filePath
- fileServerExtId
- icapServer
- links
- mountTargetExtId
- quarantined
- scanTimestampUsecs
- shareName
- tenantId
- threatDescription

        :param bool async_req:
        :return: files.v4.config.InfectedFilesListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_infected_files_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_infected_files_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_infected_files_with_http_info(self, **kwargs):  # noqa: E501
        """List of infected files
        Get a paginated list of infected files.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter).   Example of supported query parameters for infected files LIST API: ```  - ?$page=0&$limit=1  - ?$select=shareName, filePath, threatDescription  - ?$limit=5&$select=shareName, filePath ``` The following attributes can be selected: ```   - mountTargetExtId   - shareName   - filePath   - threatDescription   - scanTimestampUsecs   - quarantined   - icapServer ``` \" 

        >>> response = api.list_infected_files((optional) mountTargetExtId, (optional) _page, (optional) _limit, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_infected_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :param str mountTargetExtId: The {extId} of the mount target. Example:9c1e537d-6777-4c22-5d41-ddd0c3337aa9.
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- extId
- filePath
- fileServerExtId
- icapServer
- links
- mountTargetExtId
- quarantined
- scanTimestampUsecs
- shareName
- tenantId
- threatDescription

        :param bool async_req:
        :return: files.v4.config.InfectedFilesListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mountTargetExtId', '_page', '_limit', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_infected_files" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'mountTargetExtId' in params:
            query_params.append(('mountTargetExtId', params['mountTargetExtId']))  # noqa: E501
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/infected-files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.InfectedFilesListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def quarantine_infected_files(self, body, **kwargs):  # noqa: E501
        """Quarantine infected files
        Quarantine infected files with the given infected files UUIDs in the request body.  A sample request body would look like this: ``` {   \"infectedFileUuids\": [     \"392e08f3-5d27-4655-8936-2a558fd29ef2\"   ] } ``` 

        >>> response = api.quarantine_infected_files(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.quarantine_infected_files(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.InfectedFileSpec body: Quarantine infected files request. (required)
        :param bool async_req:
        :return: files.v4.config.QuarantineInfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.quarantine_infected_files_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.quarantine_infected_files_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def quarantine_infected_files_with_http_info(self, body, **kwargs):  # noqa: E501
        """Quarantine infected files
        Quarantine infected files with the given infected files UUIDs in the request body.  A sample request body would look like this: ``` {   \"infectedFileUuids\": [     \"392e08f3-5d27-4655-8936-2a558fd29ef2\"   ] } ``` 

        >>> response = api.quarantine_infected_files(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.quarantine_infected_files_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.InfectedFileSpec body: Quarantine infected files request. (required)
        :param bool async_req:
        :return: files.v4.config.QuarantineInfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method quarantine_infected_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `quarantine_infected_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/$actions/quarantine-infected-files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.QuarantineInfectedFilesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_infected_files(self, body, **kwargs):  # noqa: E501
        """Remove infected files
        Remove infected files with the given infected files UUID in request body.  A sample request body would look like this: ``` {   \"infectedFileUuids\": [     \"392e08f3-5d27-4655-8936-2a558fd29ef2\"   ] } ``` 

        >>> response = api.remove_infected_files(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_infected_files(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.InfectedFileSpec body: Remove infected files request. (required)
        :param bool async_req:
        :return: files.v4.config.RemoveInfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_infected_files_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_infected_files_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def remove_infected_files_with_http_info(self, body, **kwargs):  # noqa: E501
        """Remove infected files
        Remove infected files with the given infected files UUID in request body.  A sample request body would look like this: ``` {   \"infectedFileUuids\": [     \"392e08f3-5d27-4655-8936-2a558fd29ef2\"   ] } ``` 

        >>> response = api.remove_infected_files(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_infected_files_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.InfectedFileSpec body: Remove infected files request. (required)
        :param bool async_req:
        :return: files.v4.config.RemoveInfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_infected_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_infected_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/$actions/remove-infected-files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.RemoveInfectedFilesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rescan_infected_files(self, body, **kwargs):  # noqa: E501
        """Rescan infected files
        Rescan infected files with the given infected files UUID in request body. A sample request body would look like this: ``` {   \"infectedFileUuids\": [     \"392e08f3-5d27-4655-8936-2a558fd29ef2\"   ] } ``` 

        >>> response = api.rescan_infected_files(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rescan_infected_files(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.InfectedFileSpec body: Rescan infected files request (required)
        :param bool async_req:
        :return: files.v4.config.RescanInfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rescan_infected_files_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.rescan_infected_files_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def rescan_infected_files_with_http_info(self, body, **kwargs):  # noqa: E501
        """Rescan infected files
        Rescan infected files with the given infected files UUID in request body. A sample request body would look like this: ``` {   \"infectedFileUuids\": [     \"392e08f3-5d27-4655-8936-2a558fd29ef2\"   ] } ``` 

        >>> response = api.rescan_infected_files(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rescan_infected_files_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.InfectedFileSpec body: Rescan infected files request (required)
        :param bool async_req:
        :return: files.v4.config.RescanInfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rescan_infected_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `rescan_infected_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/$actions/rescan-infected-files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.RescanInfectedFilesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_infected_files(self, body, **kwargs):  # noqa: E501
        """Reset infected files
        Reset infected files with the given infected files UUID in request body.  A sample request body would look like this: ``` {   \"infectedFileUuids\": [     \"392e08f3-5d27-4655-8936-2a558fd29ef2\"   ] } ``` 

        >>> response = api.reset_infected_files(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reset_infected_files(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.InfectedFileSpec body: Reset infected files request. (required)
        :param bool async_req:
        :return: files.v4.config.ResetInfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_infected_files_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.reset_infected_files_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def reset_infected_files_with_http_info(self, body, **kwargs):  # noqa: E501
        """Reset infected files
        Reset infected files with the given infected files UUID in request body.  A sample request body would look like this: ``` {   \"infectedFileUuids\": [     \"392e08f3-5d27-4655-8936-2a558fd29ef2\"   ] } ``` 

        >>> response = api.reset_infected_files(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reset_infected_files_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.InfectedFileSpec body: Reset infected files request. (required)
        :param bool async_req:
        :return: files.v4.config.ResetInfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_infected_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `reset_infected_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/$actions/reset-infected-files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.ResetInfectedFilesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def un_quarantine_infected_files(self, body, **kwargs):  # noqa: E501
        """Unquarantine infected files request.
        Unquarantine infected files using the provided request body.  The user has to specify list of `infectedFileUuids` of files which needs to be unquarantined inside the request body.  A sample request body would look like this: ``` {   \"infectedFileUuids\": [     \"392e08f3-5d27-4655-8936-2a558fd29ef2\"   ] } ``` 

        >>> response = api.un_quarantine_infected_files(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.un_quarantine_infected_files(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.InfectedFileSpec body: Unquarantine infected files request. (required)
        :param bool async_req:
        :return: files.v4.config.UnQuarantineInfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.un_quarantine_infected_files_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.un_quarantine_infected_files_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def un_quarantine_infected_files_with_http_info(self, body, **kwargs):  # noqa: E501
        """Unquarantine infected files request.
        Unquarantine infected files using the provided request body.  The user has to specify list of `infectedFileUuids` of files which needs to be unquarantined inside the request body.  A sample request body would look like this: ``` {   \"infectedFileUuids\": [     \"392e08f3-5d27-4655-8936-2a558fd29ef2\"   ] } ``` 

        >>> response = api.un_quarantine_infected_files(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.un_quarantine_infected_files_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.InfectedFileSpec body: Unquarantine infected files request. (required)
        :param bool async_req:
        :return: files.v4.config.UnQuarantineInfectedFilesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method un_quarantine_infected_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `un_quarantine_infected_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/$actions/unquarantine-infected-files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UnQuarantineInfectedFilesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
