# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class FileServerUsersApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_file_server_user(self, body, **kwargs):  # noqa: E501
        """Create a file server user
        Create a file server user using the provided request body.  The user has to specify the request body for creating an user. They need to specify `name`, `password`, `roles` inside request body.  A sample request body would look like this: ``` {   \"password\": \"testuser\",   \"name\": \"testuser\",   \"roles\": [     \"ROLE_CLUSTER_ADMIN\",     \"ROLE_CLUSTER_VIEWER\"   ] } ``` 

        >>> response = api.create_file_server_user(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_server_user(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.FileServerUser body: File server user model. (required)
        :param bool async_req:
        :return: files.v4.config.CreateFileServerUserApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_file_server_user_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_file_server_user_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_file_server_user_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a file server user
        Create a file server user using the provided request body.  The user has to specify the request body for creating an user. They need to specify `name`, `password`, `roles` inside request body.  A sample request body would look like this: ``` {   \"password\": \"testuser\",   \"name\": \"testuser\",   \"roles\": [     \"ROLE_CLUSTER_ADMIN\",     \"ROLE_CLUSTER_VIEWER\"   ] } ``` 

        >>> response = api.create_file_server_user(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_server_user_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.FileServerUser body: File server user model. (required)
        :param bool async_req:
        :return: files.v4.config.CreateFileServerUserApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_server_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_file_server_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateFileServerUserApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file_server_user(self, fileServerUserExtId, **kwargs):  # noqa: E501
        """Delete file server user
        Delete file server user with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the file server user to be deleted. 

        >>> response = api.delete_file_server_user(fileServerUserExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file_server_user(fileServerUserExtId, async_req=True)
        >>> result = thread.get()

        :param str fileServerUserExtId: File server user UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.DeleteFileServerUserApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_file_server_user_with_http_info(fileServerUserExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_file_server_user_with_http_info(fileServerUserExtId, **kwargs)  # noqa: E501
            return data

    def delete_file_server_user_with_http_info(self, fileServerUserExtId, **kwargs):  # noqa: E501
        """Delete file server user
        Delete file server user with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the file server user to be deleted. 

        >>> response = api.delete_file_server_user(fileServerUserExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file_server_user_with_http_info(fileServerUserExtId, async_req=True)
        >>> result = thread.get()

        :param str fileServerUserExtId: File server user UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.DeleteFileServerUserApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fileServerUserExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_server_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'fileServerUserExtId' is set
        if ('fileServerUserExtId' not in params or
                params['fileServerUserExtId'] is None):
            raise ValueError("Missing the required parameter `fileServerUserExtId` when calling `delete_file_server_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'fileServerUserExtId' in params:
            path_params['fileServerUserExtId'] = params['fileServerUserExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/users/{fileServerUserExtId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DeleteFileServerUserApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_server_user_by_ext_id(self, fileServerUserExtId, **kwargs):  # noqa: E501
        """Get file server user by extId
        Get a file server user with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the file server user to be fetched. 

        >>> response = api.get_file_server_user_by_ext_id(fileServerUserExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_server_user_by_ext_id(fileServerUserExtId, async_req=True)
        >>> result = thread.get()

        :param str fileServerUserExtId: File server user UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.FileServerUserApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_server_user_by_ext_id_with_http_info(fileServerUserExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_server_user_by_ext_id_with_http_info(fileServerUserExtId, **kwargs)  # noqa: E501
            return data

    def get_file_server_user_by_ext_id_with_http_info(self, fileServerUserExtId, **kwargs):  # noqa: E501
        """Get file server user by extId
        Get a file server user with the given external identifier.  The user has to specify - a valid external identifier (`extId`) of the file server user to be fetched. 

        >>> response = api.get_file_server_user_by_ext_id(fileServerUserExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_server_user_by_ext_id_with_http_info(fileServerUserExtId, async_req=True)
        >>> result = thread.get()

        :param str fileServerUserExtId: File server user UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.FileServerUserApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fileServerUserExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_server_user_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'fileServerUserExtId' is set
        if ('fileServerUserExtId' not in params or
                params['fileServerUserExtId'] is None):
            raise ValueError("Missing the required parameter `fileServerUserExtId` when calling `get_file_server_user_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'fileServerUserExtId' in params:
            path_params['fileServerUserExtId'] = params['fileServerUserExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/users/{fileServerUserExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.FileServerUserApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_server_users(self, **kwargs):  # noqa: E501
        """List all the file server users
        Get a list of file server users.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter).  A sample request URL with limit would look like this:  ``` /api/files/v4.0.a2/config/file-server/users?$limit=1 ``` 

        >>> response = api.get_file_server_users()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_server_users(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: files.v4.config.FileServerUserListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_server_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_file_server_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_file_server_users_with_http_info(self, **kwargs):  # noqa: E501
        """List all the file server users
        Get a list of file server users.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter).  A sample request URL with limit would look like this:  ``` /api/files/v4.0.a2/config/file-server/users?$limit=1 ``` 

        >>> response = api.get_file_server_users()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_server_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: files.v4.config.FileServerUserListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_server_users" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.FileServerUserListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_file_server_user(self, body, fileServerUserExtId, **kwargs):  # noqa: E501
        """Update file server user
        Update a file server user with the given external identifier using the provided request body.  The user has to specify - a valid external identifier (`extId`) of the file server user to be updated. They also need to provide a request body for performing the update. They need to specify the `name` and `password` of the file server user. They can also specify `roles` in the request body.  A sample request body would look like this:  ``` {   \"password\": \"password\",   \"name\": \"testuser\",   \"roles\": [     \"ROLE_CLUSTER_ADMIN\"   ] } ``` 

        >>> response = api.update_file_server_user(body, fileServerUserExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_server_user(body, fileServerUserExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.FileServerUser body: File server user model. (required)
        :param str fileServerUserExtId: File server user UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.UpdateFileServerUserApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_file_server_user_with_http_info(body, fileServerUserExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_file_server_user_with_http_info(body, fileServerUserExtId, **kwargs)  # noqa: E501
            return data

    def update_file_server_user_with_http_info(self, body, fileServerUserExtId, **kwargs):  # noqa: E501
        """Update file server user
        Update a file server user with the given external identifier using the provided request body.  The user has to specify - a valid external identifier (`extId`) of the file server user to be updated. They also need to provide a request body for performing the update. They need to specify the `name` and `password` of the file server user. They can also specify `roles` in the request body.  A sample request body would look like this:  ``` {   \"password\": \"password\",   \"name\": \"testuser\",   \"roles\": [     \"ROLE_CLUSTER_ADMIN\"   ] } ``` 

        >>> response = api.update_file_server_user(body, fileServerUserExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_server_user_with_http_info(body, fileServerUserExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.FileServerUser body: File server user model. (required)
        :param str fileServerUserExtId: File server user UUID. Example:48f78959-14a6-4c47-b5db-920460c4b668 (required)
        :param bool async_req:
        :return: files.v4.config.UpdateFileServerUserApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fileServerUserExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file_server_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_file_server_user`")  # noqa: E501
        # verify the required parameter 'fileServerUserExtId' is set
        if ('fileServerUserExtId' not in params or
                params['fileServerUserExtId'] is None):
            raise ValueError("Missing the required parameter `fileServerUserExtId` when calling `update_file_server_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'fileServerUserExtId' in params:
            path_params['fileServerUserExtId'] = params['fileServerUserExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/users/{fileServerUserExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateFileServerUserApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
