# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class FileServerApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_file_servers(self, **kwargs):  # noqa: E501
        """Get file server
        Get file server details.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_file_servers()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_servers(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: files.v4.config.FileServerGetApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_file_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_file_servers_with_http_info(self, **kwargs):  # noqa: E501
        """Get file server
        Get file server details.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_file_servers()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: files.v4.config.FileServerGetApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_servers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.FileServerGetApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_file_server(self, body, **kwargs):  # noqa: E501
        """Update a file server
        Update details of a file server with the given external identifier.  The user has to specify a request body for performing the update. User can specify updated values for fields like `nvmsCount`, `sizeInGib`, `ntpServers`, `vms` etc. Network updates are not allowed as part of update file-server.  A sample request body would look like this:  ``` {   \"containerExtId\": \"18f78959-14a6-4c47-b5db-920460c4b668\",   \"nvmsCount\": 1,   \"sizeInGib\": 1024,   \"ntpServers\": [     {       \"ipv4\": {         \"value\": \"10.1.61.96\"       }     },     {       \"ipv4\": {         \"value\": \"10.40.64.15\"       }     },     {       \"ipv4\": {         \"value\": \"10.40.64.16\"       }     }   ],   \"memoryGib\": 12,   \"vms\": [     {       \"externalNetworks\": [         {           \"ipAddresses\": [             {               \"ipv4\": {                 \"value\": \"10.53.89.31\"               }             }           ]         }       ],       \"vcpus\": 4,       \"memoryGib\": 12,       \"name\": \"NTNX-mar10-fs-1\",       \"extId\": \"1a6d0f9b-be7a-409d-9c05-79974efb5c4a\"     }   ],   \"externalPrimaryNetworkExtId\": \"8064cae7-13c6-4cc9-be63-021dec2448ac\",   \"fileBlockingExtensions\": [     \".doc\"   ],   \"cvmIpAddresses\": [{     \"value\": \"10.51.48.119\"   }],   \"name\": \"mar10-fs\",   \"rebalanceNeeded\": false,   \"vcpus\": 4,   \"version\": \"4.0.0\",   \"dnsDomainName\": \"child4.afs.minerva.com\",   \"dnsServers\": [     {       \"value\": \"10.40.64.16\"     },     {       \"value\": \"10.40.64.16\"     },     {       \"value\": \"10.40.64.16\"     }   ],   \"compressionEnabled\": true } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_file_server(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_server(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.FileServer body: A model that represents file server resources. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateFileServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_file_server_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_file_server_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def update_file_server_with_http_info(self, body, **kwargs):  # noqa: E501
        """Update a file server
        Update details of a file server with the given external identifier.  The user has to specify a request body for performing the update. User can specify updated values for fields like `nvmsCount`, `sizeInGib`, `ntpServers`, `vms` etc. Network updates are not allowed as part of update file-server.  A sample request body would look like this:  ``` {   \"containerExtId\": \"18f78959-14a6-4c47-b5db-920460c4b668\",   \"nvmsCount\": 1,   \"sizeInGib\": 1024,   \"ntpServers\": [     {       \"ipv4\": {         \"value\": \"10.1.61.96\"       }     },     {       \"ipv4\": {         \"value\": \"10.40.64.15\"       }     },     {       \"ipv4\": {         \"value\": \"10.40.64.16\"       }     }   ],   \"memoryGib\": 12,   \"vms\": [     {       \"externalNetworks\": [         {           \"ipAddresses\": [             {               \"ipv4\": {                 \"value\": \"10.53.89.31\"               }             }           ]         }       ],       \"vcpus\": 4,       \"memoryGib\": 12,       \"name\": \"NTNX-mar10-fs-1\",       \"extId\": \"1a6d0f9b-be7a-409d-9c05-79974efb5c4a\"     }   ],   \"externalPrimaryNetworkExtId\": \"8064cae7-13c6-4cc9-be63-021dec2448ac\",   \"fileBlockingExtensions\": [     \".doc\"   ],   \"cvmIpAddresses\": [{     \"value\": \"10.51.48.119\"   }],   \"name\": \"mar10-fs\",   \"rebalanceNeeded\": false,   \"vcpus\": 4,   \"version\": \"4.0.0\",   \"dnsDomainName\": \"child4.afs.minerva.com\",   \"dnsServers\": [     {       \"value\": \"10.40.64.16\"     },     {       \"value\": \"10.40.64.16\"     },     {       \"value\": \"10.40.64.16\"     }   ],   \"compressionEnabled\": true } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_file_server(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_file_server_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.FileServer body: A model that represents file server resources. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateFileServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_file_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateFileServerApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
