# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class DnsEntriesApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_dns_server(self, body, **kwargs):  # noqa: E501
        """Add DNS server
        Add a new DNS server using the provided request body.  A sample request body would look like this:  ``` {   \"username\": \"administrator\",   \"preferredNameServer\": \"child4.afs.minerva.com\",   \"password\": \"3a1d1d124e000b0f401d\",   \"operationType\": \"MS_DNS\" } ``` 

        >>> response = api.add_dns_server(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_dns_server(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.Dns body: Add DNS server entry. (required)
        :param bool async_req:
        :return: files.v4.config.AddDnsEntriesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_dns_server_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_dns_server_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_dns_server_with_http_info(self, body, **kwargs):  # noqa: E501
        """Add DNS server
        Add a new DNS server using the provided request body.  A sample request body would look like this:  ``` {   \"username\": \"administrator\",   \"preferredNameServer\": \"child4.afs.minerva.com\",   \"password\": \"3a1d1d124e000b0f401d\",   \"operationType\": \"MS_DNS\" } ``` 

        >>> response = api.add_dns_server(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_dns_server_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.Dns body: Add DNS server entry. (required)
        :param bool async_req:
        :return: files.v4.config.AddDnsEntriesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_dns_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_dns_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/$actions/add-dns-entries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.AddDnsEntriesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dns_servers(self, **kwargs):  # noqa: E501
        """List DNS entries
        Get a paginated list of DNS servers.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported:   - hostName  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/dns-entries?$filter=hostName eq 'fs-jun1-pe.child4.afs.minerva.com' ```  Example of supported query parameters for DNS servers LIST API: ```   - ?$page=0&$limit=1   - ?$select=extId, hostName   - ?$orderby=hostName desc   - ?$filter=hostName eq 'fs-jun1-pe.child4.afs.minerva.com'   - ?$filter=startswith(hostName,'test')   - ?$filter=endswith(hostName,'test')   - ?$filter=contains(hostName,'admin')   - ?$select=name, hostName&$filter=startswith(hostName,'test')   - ?$limit=5&$select=extId, hostName&$orderby=hostName desc ```  The `$orderby` query parameter allows specifying attributes on which to sort the returned list of DNS servers.  The following parameters support sorting in DNS server list API:   - name   - role  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/dns-entries?$orderby=hostName desc ```  The $select query parameter allows specifying attributes which the user wants to fetch in the returned list of DNS servers, other attributes will be returned as  a null value.  The following attributes can be selected: ```   - extId   - preferredNameServer   - ipAddress   - hostName   - isVerified ```  Some more examples are given below:  1. Order by name in ascending order  ``` /files/v4.0.a2/config/file-server/dns-entries?$orderby=hostName asc ```  2. Select by preferredNameServer  ``` /files/v4.0.a2/config/file-server/dns-entries?$select=preferredNameServer ```  3. Paginate the returned list  ``` /files/v4.0.a2/config/file-server/dns-entries?$page=0&$limit=1 ```  4. Combination of queries  ``` /files/v4.0.a2/config/file-server/dns-entries?$limit=5&$select=extId, hostName&$orderby=hostName desc ``` 

        >>> response = api.get_dns_servers((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_dns_servers(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - hostName
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - hostName
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- extId
- hostName
- ipAddress
- isVerified
- links
- tenantId

        :param bool async_req:
        :return: files.v4.config.DnsEntriesListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dns_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_dns_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_dns_servers_with_http_info(self, **kwargs):  # noqa: E501
        """List DNS entries
        Get a paginated list of DNS servers.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported:   - hostName  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/dns-entries?$filter=hostName eq 'fs-jun1-pe.child4.afs.minerva.com' ```  Example of supported query parameters for DNS servers LIST API: ```   - ?$page=0&$limit=1   - ?$select=extId, hostName   - ?$orderby=hostName desc   - ?$filter=hostName eq 'fs-jun1-pe.child4.afs.minerva.com'   - ?$filter=startswith(hostName,'test')   - ?$filter=endswith(hostName,'test')   - ?$filter=contains(hostName,'admin')   - ?$select=name, hostName&$filter=startswith(hostName,'test')   - ?$limit=5&$select=extId, hostName&$orderby=hostName desc ```  The `$orderby` query parameter allows specifying attributes on which to sort the returned list of DNS servers.  The following parameters support sorting in DNS server list API:   - name   - role  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/dns-entries?$orderby=hostName desc ```  The $select query parameter allows specifying attributes which the user wants to fetch in the returned list of DNS servers, other attributes will be returned as  a null value.  The following attributes can be selected: ```   - extId   - preferredNameServer   - ipAddress   - hostName   - isVerified ```  Some more examples are given below:  1. Order by name in ascending order  ``` /files/v4.0.a2/config/file-server/dns-entries?$orderby=hostName asc ```  2. Select by preferredNameServer  ``` /files/v4.0.a2/config/file-server/dns-entries?$select=preferredNameServer ```  3. Paginate the returned list  ``` /files/v4.0.a2/config/file-server/dns-entries?$page=0&$limit=1 ```  4. Combination of queries  ``` /files/v4.0.a2/config/file-server/dns-entries?$limit=5&$select=extId, hostName&$orderby=hostName desc ``` 

        >>> response = api.get_dns_servers((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_dns_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - hostName
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - hostName
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- extId
- hostName
- ipAddress
- isVerified
- links
- tenantId

        :param bool async_req:
        :return: files.v4.config.DnsEntriesListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dns_servers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/dns-entries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DnsEntriesListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_dns_server(self, body, **kwargs):  # noqa: E501
        """Remove DNS entries
        Remove DNS server entry using the provided request body.  A sample request body would look like this: ``` {   \"username\": \"administrator\",   \"preferredNameServer\": \"child4.afs.minerva.com\",   \"password\": \"3a1d1d124e000b0f401d\",   \"operationType\": \"MS_DNS\" } ``` 

        >>> response = api.remove_dns_server(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_dns_server(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.Dns body: Delete DNS server entry. (required)
        :param bool async_req:
        :return: files.v4.config.RemoveDnsEntriesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_dns_server_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_dns_server_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def remove_dns_server_with_http_info(self, body, **kwargs):  # noqa: E501
        """Remove DNS entries
        Remove DNS server entry using the provided request body.  A sample request body would look like this: ``` {   \"username\": \"administrator\",   \"preferredNameServer\": \"child4.afs.minerva.com\",   \"password\": \"3a1d1d124e000b0f401d\",   \"operationType\": \"MS_DNS\" } ``` 

        >>> response = api.remove_dns_server(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_dns_server_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.Dns body: Delete DNS server entry. (required)
        :param bool async_req:
        :return: files.v4.config.RemoveDnsEntriesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_dns_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_dns_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/$actions/remove-dns-entries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.RemoveDnsEntriesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def verify_dns_server(self, **kwargs):  # noqa: E501
        """Verify DNS entries
        Validate DNS entries using the provided request body.  A sample request body would look like this:  ``` {   \"username\": \"administrator\",   \"preferredNameServer\": \"child4.afs.minerva.com\",   \"password\": \"3a1d1d124e000b0f401d\",   \"operationType\": \"MS_DNS\" } ``` 

        >>> response = api.verify_dns_server((optional) body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verify_dns_server(async_req=True)
        >>> result = thread.get()

        :param files.v4.config.Dns body: Verify DNS server entry.
        :param bool async_req:
        :return: files.v4.config.VerifyDnsEntriesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.verify_dns_server_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.verify_dns_server_with_http_info(**kwargs)  # noqa: E501
            return data

    def verify_dns_server_with_http_info(self, **kwargs):  # noqa: E501
        """Verify DNS entries
        Validate DNS entries using the provided request body.  A sample request body would look like this:  ``` {   \"username\": \"administrator\",   \"preferredNameServer\": \"child4.afs.minerva.com\",   \"password\": \"3a1d1d124e000b0f401d\",   \"operationType\": \"MS_DNS\" } ``` 

        >>> response = api.verify_dns_server((optional) body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verify_dns_server_with_http_info(async_req=True)
        >>> result = thread.get()

        :param files.v4.config.Dns body: Verify DNS server entry.
        :param bool async_req:
        :return: files.v4.config.VerifyDnsEntriesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_dns_server" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/$actions/verify-dns-entries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.VerifyDnsEntriesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
