# coding: utf-8


"""
IGNORE:
    Nutanix Files Versioned APIs

    Manage virtual file servers, create and configure shares for client access, protect them using DR and sync policies, provision storage space and administer security controls.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_files_py_client.api_client import ApiClient


class AntivirusServersApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_antivirus_server(self, body, **kwargs):  # noqa: E501
        """Create antivirus server
        Create antivirus server using the provided request body.  A sample request body would look like this: ``` {   \"port\": 1222,   \"description\": \"server-1 description\",   \"name\": \"server-1\",   \"icapServiceName\": \"avscan\",   \"address\": {     \"ipv4\": {       \"value\": \"10.23.12.21\"     }   } } ``` 

        >>> response = api.create_antivirus_server(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_antivirus_server(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.AntivirusServer body: Antivirus server model. Create request model contains description, address and port. (required)
        :param bool async_req:
        :return: files.v4.config.CreateAntivirusServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_antivirus_server_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_antivirus_server_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_antivirus_server_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create antivirus server
        Create antivirus server using the provided request body.  A sample request body would look like this: ``` {   \"port\": 1222,   \"description\": \"server-1 description\",   \"name\": \"server-1\",   \"icapServiceName\": \"avscan\",   \"address\": {     \"ipv4\": {       \"value\": \"10.23.12.21\"     }   } } ``` 

        >>> response = api.create_antivirus_server(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_antivirus_server_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.AntivirusServer body: Antivirus server model. Create request model contains description, address and port. (required)
        :param bool async_req:
        :return: files.v4.config.CreateAntivirusServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_antivirus_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_antivirus_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/anti-virus-servers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.CreateAntivirusServerApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_antivirus_server(self, antivirusServerExtId, **kwargs):  # noqa: E501
        """Delete antivirus server
        Delete the antivirus server with the given external identifier.  The user has to specify - a valid external identifier (`antivirusServerExtId`) of the antivirus server to be deleted.  How to pass Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/anti-virus-servers/18f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/anti-virus-servers/18f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.delete_antivirus_server(antivirusServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_antivirus_server(antivirusServerExtId, async_req=True)
        >>> result = thread.get()

        :param str antivirusServerExtId: Antivirus server UUID. Example:18f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteAntivirusServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_antivirus_server_with_http_info(antivirusServerExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_antivirus_server_with_http_info(antivirusServerExtId, **kwargs)  # noqa: E501
            return data

    def delete_antivirus_server_with_http_info(self, antivirusServerExtId, **kwargs):  # noqa: E501
        """Delete antivirus server
        Delete the antivirus server with the given external identifier.  The user has to specify - a valid external identifier (`antivirusServerExtId`) of the antivirus server to be deleted.  How to pass Etag  For performing delete, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/anti-virus-servers/18f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the DELETE request to the below URL  ``` /api/files/v4.0.a2/config/file-server/anti-virus-servers/18f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.delete_antivirus_server(antivirusServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_antivirus_server_with_http_info(antivirusServerExtId, async_req=True)
        >>> result = thread.get()

        :param str antivirusServerExtId: Antivirus server UUID. Example:18f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.DeleteAntivirusServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirusServerExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_antivirus_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirusServerExtId' is set
        if ('antivirusServerExtId' not in params or
                params['antivirusServerExtId'] is None):
            raise ValueError("Missing the required parameter `antivirusServerExtId` when calling `delete_antivirus_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirusServerExtId' in params:
            path_params['antivirusServerExtId'] = params['antivirusServerExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/anti-virus-servers/{antivirusServerExtId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.DeleteAntivirusServerApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_antivirus_server_by_ext_id(self, antivirusServerExtId, **kwargs):  # noqa: E501
        """Get antivirus server by extId
        Get antivirus server for the provided extId with the given external identifier.  The user has to specify - a valid external identifier (`antivirusServerExtId`) of the antivirus server to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_antivirus_server_by_ext_id(antivirusServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_antivirus_server_by_ext_id(antivirusServerExtId, async_req=True)
        >>> result = thread.get()

        :param str antivirusServerExtId: Antivirus server UUID. Example:18f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.AntivirusServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_antivirus_server_by_ext_id_with_http_info(antivirusServerExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_antivirus_server_by_ext_id_with_http_info(antivirusServerExtId, **kwargs)  # noqa: E501
            return data

    def get_antivirus_server_by_ext_id_with_http_info(self, antivirusServerExtId, **kwargs):  # noqa: E501
        """Get antivirus server by extId
        Get antivirus server for the provided extId with the given external identifier.  The user has to specify - a valid external identifier (`antivirusServerExtId`) of the antivirus server to be fetched.  Etag  Etag is used to cache unchanged resources. When making a GET call to the above resource, `If-None-Match` header can be passed as shown in the example below.  ``` If-None-Match:        9 Content-Type:         application/json ```  The server compares the above Etag (sent with If-None-Match) with the Etag for its current version of the resource, and if both values match (that is, the resource has not changed), the server sends back a 304 Not Modified status, without a body. This tells the user that the cached version of the response is still good to use (fresh). If it doesn't match, it will send the response body of the latest resource with the updated value of Etag in the response headers as below:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  If this header is not passed, the server will send the full payload with the latest etag value in response headers. 

        >>> response = api.get_antivirus_server_by_ext_id(antivirusServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_antivirus_server_by_ext_id_with_http_info(antivirusServerExtId, async_req=True)
        >>> result = thread.get()

        :param str antivirusServerExtId: Antivirus server UUID. Example:18f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.AntivirusServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirusServerExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_antivirus_server_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirusServerExtId' is set
        if ('antivirusServerExtId' not in params or
                params['antivirusServerExtId'] is None):
            raise ValueError("Missing the required parameter `antivirusServerExtId` when calling `get_antivirus_server_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirusServerExtId' in params:
            path_params['antivirusServerExtId'] = params['antivirusServerExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/anti-virus-servers/{antivirusServerExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.AntivirusServerApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_antivirus_servers(self, **kwargs):  # noqa: E501
        """List antivirus servers
        Get a paginated list of antivirus servers.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported:   - port  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$filter=port eq 1344 ```  Example of supported query parameters for antivirus servers LIST API: ```   - ?$page=0&$limit=1   - ?$select=port, description   - ?$orderby=port desc   - ?$filter=port eq 1344   - ?$filter=port ne 1344   - ?$select=port&$filter=port eq 1344   - ?$limit=5&$select=port, description&$orderby=port desc ```  The `$orderby` query parameter allows specifying attributes on which to sort the returned list of antivirus servers.  The following parameters support sorting in antivirus server list API:   - port  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$orderby=port desc ```  The `$select` query parameter allows specifying attributes which the user wants to fetch in the returned list of servers, other attributes will be returned as a null value.   The following attributes can be selected: ```   - description   - port   - enable   - partner   - icapServiceName ```  Some more examples are given below:  1. Order by description in ascending order  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$orderby=description asc ```  2. Select by description  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$select=description ```  3. Paginate the returned list  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$page=0&$limit=1 ```  4. Combination of queries  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$limit=5&$select=description, port&$orderby=port desc ``` 

        >>> response = api.get_antivirus_servers((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_antivirus_servers(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - port
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - port
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- address
- connectionStatus
- description
- enable
- extId
- icapServiceName
- isEnable
- links
- partner
- port
- tenantId

        :param bool async_req:
        :return: files.v4.config.AntivirusServerListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_antivirus_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_antivirus_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_antivirus_servers_with_http_info(self, **kwargs):  # noqa: E501
        """List antivirus servers
        Get a paginated list of antivirus servers.  You can use filtering options to manage the results of your query. The `$filter` query parameter provides a flexible way to subset the resources from collections by combining comparison and other functions. There are several kinds of basic predicates and built-in functions for $filter, including logical operators and arithmetic operators. For more detailed information, refer to the  [OData V4 URL Conventions Document](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html). For more information, see [5.1.2 System Query Option $filter](https://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part2-url-conventions.html#sec_SystemQueryOptionfilter). Following OData filters are supported:   - port  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$filter=port eq 1344 ```  Example of supported query parameters for antivirus servers LIST API: ```   - ?$page=0&$limit=1   - ?$select=port, description   - ?$orderby=port desc   - ?$filter=port eq 1344   - ?$filter=port ne 1344   - ?$select=port&$filter=port eq 1344   - ?$limit=5&$select=port, description&$orderby=port desc ```  The `$orderby` query parameter allows specifying attributes on which to sort the returned list of antivirus servers.  The following parameters support sorting in antivirus server list API:   - port  A sample request URL would look like this:  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$orderby=port desc ```  The `$select` query parameter allows specifying attributes which the user wants to fetch in the returned list of servers, other attributes will be returned as a null value.   The following attributes can be selected: ```   - description   - port   - enable   - partner   - icapServiceName ```  Some more examples are given below:  1. Order by description in ascending order  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$orderby=description asc ```  2. Select by description  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$select=description ```  3. Paginate the returned list  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$page=0&$limit=1 ```  4. Combination of queries  ``` /files/v4.0.a2/config/file-server/anti-virus-servers?$limit=5&$select=description, port&$orderby=port desc ``` 

        >>> response = api.get_antivirus_servers((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_antivirus_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - port
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - port
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- address
- connectionStatus
- description
- enable
- extId
- icapServiceName
- isEnable
- links
- partner
- port
- tenantId

        :param bool async_req:
        :return: files.v4.config.AntivirusServerListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_antivirus_servers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/anti-virus-servers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.AntivirusServerListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def test_connection_antivirus_server(self, antivirusServerExtId, **kwargs):  # noqa: E501
        """Test antivirus server connection
        Test antivirus server connection with the given external identifier.  The user has to specify - a valid external identifier (`antivirusServerExtId`) of the antivirus sever for which the connection needs to be tested. 

        >>> response = api.test_connection_antivirus_server(antivirusServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.test_connection_antivirus_server(antivirusServerExtId, async_req=True)
        >>> result = thread.get()

        :param str antivirusServerExtId: Antivirus server UUID. Example:18f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.TestConnectionAntivirusServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.test_connection_antivirus_server_with_http_info(antivirusServerExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.test_connection_antivirus_server_with_http_info(antivirusServerExtId, **kwargs)  # noqa: E501
            return data

    def test_connection_antivirus_server_with_http_info(self, antivirusServerExtId, **kwargs):  # noqa: E501
        """Test antivirus server connection
        Test antivirus server connection with the given external identifier.  The user has to specify - a valid external identifier (`antivirusServerExtId`) of the antivirus sever for which the connection needs to be tested. 

        >>> response = api.test_connection_antivirus_server(antivirusServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.test_connection_antivirus_server_with_http_info(antivirusServerExtId, async_req=True)
        >>> result = thread.get()

        :param str antivirusServerExtId: Antivirus server UUID. Example:18f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.TestConnectionAntivirusServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['antivirusServerExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_connection_antivirus_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'antivirusServerExtId' is set
        if ('antivirusServerExtId' not in params or
                params['antivirusServerExtId'] is None):
            raise ValueError("Missing the required parameter `antivirusServerExtId` when calling `test_connection_antivirus_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirusServerExtId' in params:
            path_params['antivirusServerExtId'] = params['antivirusServerExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/anti-virus-servers/{antivirusServerExtId}/$actions/test-connection', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.TestConnectionAntivirusServerApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_antivirus_server(self, body, antivirusServerExtId, **kwargs):  # noqa: E501
        """Update antivirus server
        Update antivirus server using the provided request body.  The user has to specify - a valid external identifier (`antivirusServerExtId`) of the antivirus server to be updated. They also need to provide a request body for performing the update.   A sample request body would look like this:  ``` {   \"description\": \"server-1 updated description\",   \"address\": {     \"ipv4\": {}     },   \"port\": 1222,   \"icapServiceName\": \"avscan\",   \"extId\": \"18f78959-14a6-4c47-b5db-920460c4b668\" } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/anti-virus-servers/18f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/anti-virus-servers/18f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_antivirus_server(body, antivirusServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_antivirus_server(body, antivirusServerExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.AntivirusServer body: Antivirus server update model. Update request model contains description, address and port. The user cannot modify port and address fields. (required)
        :param str antivirusServerExtId: Antivirus server UUID. Example:18f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateAntivirusServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_antivirus_server_with_http_info(body, antivirusServerExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_antivirus_server_with_http_info(body, antivirusServerExtId, **kwargs)  # noqa: E501
            return data

    def update_antivirus_server_with_http_info(self, body, antivirusServerExtId, **kwargs):  # noqa: E501
        """Update antivirus server
        Update antivirus server using the provided request body.  The user has to specify - a valid external identifier (`antivirusServerExtId`) of the antivirus server to be updated. They also need to provide a request body for performing the update.   A sample request body would look like this:  ``` {   \"description\": \"server-1 updated description\",   \"address\": {     \"ipv4\": {}     },   \"port\": 1222,   \"icapServiceName\": \"avscan\",   \"extId\": \"18f78959-14a6-4c47-b5db-920460c4b668\" } ```  It is always recommended to do a GET on a resource before doing an UPDATE.  How to pass Etag  For performing an update, the user needs an Etag value which is returned as a part of the response headers for the get operation.  A sample GET request url to get etag value would look like this:  ``` /api/files/v4.0.a2/config/file-server/anti-virus-servers/18f78959-14a6-4c47-b5db-920460c4b668 ```  Response headers for the above call would look like this:  ``` Etag:              10 Ntnx-Request-Id:   fc6f929a-3ece-41d3-5a49-dd35f2610530 Content-Type:      application/json ```  The user needs to pass the above value of Etag to `If-Match` header in the PUT request to the below URL  ``` /api/files/v4.0.a2/config/file-server/anti-virus-servers/18f78959-14a6-4c47-b5db-920460c4b668 ```  Request headers for the above call would look like this:  ``` If-Match:        10 Content-Type:    application/json ```  Etag is required for v4.0.a2 APIs. If this header is not passed or an incorrect value is passed, the request will fail with 412 precondition failed status. 

        >>> response = api.update_antivirus_server(body, antivirusServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_antivirus_server_with_http_info(body, antivirusServerExtId, async_req=True)
        >>> result = thread.get()

        :param files.v4.config.AntivirusServer body: Antivirus server update model. Update request model contains description, address and port. The user cannot modify port and address fields. (required)
        :param str antivirusServerExtId: Antivirus server UUID. Example:18f78959-14a6-4c47-b5db-920460c4b668. (required)
        :param bool async_req:
        :return: files.v4.config.UpdateAntivirusServerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'antivirusServerExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_antivirus_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_antivirus_server`")  # noqa: E501
        # verify the required parameter 'antivirusServerExtId' is set
        if ('antivirusServerExtId' not in params or
                params['antivirusServerExtId'] is None):
            raise ValueError("Missing the required parameter `antivirusServerExtId` when calling `update_antivirus_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'antivirusServerExtId' in params:
            path_params['antivirusServerExtId'] = params['antivirusServerExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/files/v4.0.a2/config/file-server/anti-virus-servers/{antivirusServerExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='files.v4.config.UpdateAntivirusServerApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
